////////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//------------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//------------------------------------------------------------------------------
// $Revision: $
// $Date: $
// -----------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of ahb_2_core module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// -----------------------------------------------------------------------------
//
// $HeadURL: $
//
////////////////////////////////////////////////////////////////////////////////
`default_nettype none
module ahb_2_core #(
   parameter ADDR_WIDTH = 32                     // Address bus width
) ( 
   //$port_g Clock and reset
   input  wire                    clk,           // root Clock
   input  wire                    rst_n,         // Asynchronous reset (active low)

   //$port_g AHB Slave interface
   input  wire                    s_hready_in,
   input  wire                    s_hsel,
   input  wire   [ADDR_WIDTH-1:0] s_haddr,
   input  wire              [1:0] s_htrans,
   input  wire                    s_hwrite,
   input  wire              [2:0] s_hsize,
   input  wire             [31:0] s_hwdata,
   output reg              [31:0] s_hrdata,
   output wire              [1:0] s_hresp,
   output reg                     s_hready,

   //$port_g CORE Master interface
   output reg                     m_req,
   input  wire                    m_gnt,
   input  wire                    m_rvalid,
   output reg                     m_we,
   output reg               [3:0] m_be,
   output reg    [ADDR_WIDTH-1:0] m_addr,
   output wire             [31:0] m_wdata,
   input  wire             [31:0] m_rdata,
   input  wire                    m_err
);


////////////////////////////////////////////////////////////////////////////////
// Internal Signals
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------
// AHB Control
//------------------------------------------------------------------------------
always @(posedge clk or negedge rst_n)
begin
   if (~rst_n)
      s_hready <= 1'b1;
   else
   begin
      if (s_hsel & s_htrans[1] & s_hready_in)
         s_hready <= 1'b0;
      else if (m_rvalid)
         s_hready <= 1'b1;
   end
end

always @(posedge clk or negedge rst_n)
begin
   if (~rst_n)
      s_hrdata <= 32'h0;
   else
   begin
      if (m_rvalid)
         s_hrdata <= m_rdata;
      else
         s_hrdata <= 32'h0;
   end
end

assign s_hresp  = 2'b00;


//------------------------------------------------------------------------------
// CORE Control
//------------------------------------------------------------------------------
always @(posedge clk or negedge rst_n)
begin
   if (~rst_n)
   begin
      m_req  <= 1'b0;
      m_addr <= {ADDR_WIDTH{1'b0}};
      m_we   <= 1'b0;
      m_be   <= 4'h0;
   end
   else
   begin
      if (s_hsel & s_htrans[1] & s_hready_in)
      begin
         m_req  <= 1'b1;
         m_addr <= s_haddr;
         m_we   <= s_hwrite;
         case ({s_hsize, s_haddr[1:0]}) 
         // 8 bits Access
         5'b000_00: m_be <= 4'b0001;       
         5'b000_01: m_be <= 4'b0010;       
         5'b000_10: m_be <= 4'b0100;       
         5'b000_11: m_be <= 4'b1000;
         // 16 bits Access
         5'b001_00: m_be <= 4'b0011;
         5'b001_10: m_be <= 4'b1100;
         // 32 bits Access
         5'b010_00: m_be <= 4'b1111;
         // Invalid Access
         default  : m_be <= 4'b0000;
         endcase
      end
      else if (m_gnt)
      begin
         m_req  <= 1'b0;
         m_addr <= {ADDR_WIDTH{1'b0}};
         m_we   <= 1'b0;
         m_be   <= 4'h0;
      end
   end
end

assign m_wdata = s_hwdata;


endmodule
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////
