////////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//------------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//------------------------------------------------------------------------------
// $Revision: $
// $Date: $
// -----------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of core_2_sram module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// -----------------------------------------------------------------------------
//
// $HeadURL: $
//
////////////////////////////////////////////////////////////////////////////////
`default_nettype none

module core_2_sram #( 
   parameter ADDR_WIDTH = 32                     // CORE Address bus width
) (
   //$port_g Clock and reset
   input  wire                    clk,           // root Clock
   input  wire                    rst_n,         // Asynchronous reset (active low)

   //$port_g CORE Slave interface
   input  wire                    s_req,
   output wire                    s_gnt,
   output reg                     s_rvalid,
   input  wire   [ADDR_WIDTH-1:0] s_addr,
   output wire             [31:0] s_rdata,

   //$port_g SRAM Master interface
   output wire                    ram_cs,
   output wire   [ADDR_WIDTH-3:0] ram_a,
   input  wire             [31:0] ram_q
);


////////////////////////////////////////////////////////////////////////////////
// Internal Signals
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------
// Core control
//------------------------------------------------------------------------------
assign s_gnt    = s_req;
assign s_rdata  = ram_q;

always @(posedge clk or negedge rst_n)
begin
   if (~rst_n)
   begin
      s_rvalid <= 1'b0;
   end
   else
   begin
      s_rvalid <= s_gnt;
   end
end


//------------------------------------------------------------------------------
// Ram Control
//------------------------------------------------------------------------------
assign ram_cs = s_req;
assign ram_a  = s_addr[ADDR_WIDTH-1:2];


endmodule
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////
