////////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//------------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//------------------------------------------------------------------------------
// $Revision: $
// $Date: $
// -----------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of core_instr_bridge module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// -----------------------------------------------------------------------------
//
// $HeadURL: $
//
////////////////////////////////////////////////////////////////////////////////
`default_nettype none

module core_instr_bridge #( 
   parameter ADDR_WIDTH = 32                     // CORE Address bus width
) (
   //$port_g Clock and reset
   input  wire                    clk,           // root Clock
   input  wire                    rst_n,         // Asynchronous reset (active low)

   //$port_g CORE Slave interface
   input  wire                    s_req,
   output wire                    s_gnt,
   output wire                    s_rvalid,
   input  wire   [ADDR_WIDTH-1:0] s_addr,
   output wire             [31:0] s_rdata,

   //$port_g CORE Master interface
   output wire                    m_req,
   input  wire                    m_gnt,
   input  wire                    m_rvalid,
   output reg    [ADDR_WIDTH-1:0] m_addr,
   input  wire             [31:0] m_rdata
);


////////////////////////////////////////////////////////////////////////////////
// Internal Signals
////////////////////////////////////////////////////////////////////////////////
wire hit;
wire miss;


////////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
assign hit  = s_req & s_addr==m_addr;
assign miss = s_req & s_addr!=m_addr;


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
assign s_gnt    = m_gnt & hit;
assign s_rdata  = m_rdata;
assign s_rvalid = m_rvalid;


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
always @(posedge clk or negedge rst_n)
begin
   if (~rst_n)
      m_addr <= {ADDR_WIDTH{1'b0}};
   else
   begin
      if (miss)
         m_addr <= s_addr;
      else if (m_req & m_gnt)
         m_addr <= m_addr+4;
   end
end

assign m_req = s_req & hit;


endmodule
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////
