////////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//------------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//------------------------------------------------------------------------------
// $Revision: $
// $Date: $
// -----------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of core_mpa module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// -----------------------------------------------------------------------------
//
// $HeadURL: $
//
////////////////////////////////////////////////////////////////////////////////
`default_nettype none

module core_mpa #( 
   parameter ADDR_WIDTH = 32                     // CORE Address bus width
) (
   //$port_g Clock and reset
   input  wire                    clk,           // root Clock
   input  wire                    rst_n,         // Asynchronous reset (active low)

   //$port_g CORE Slave0 interface
   input  wire                    s0_req,
   output wire                    s0_gnt,
   output reg                     s0_rvalid,
   input  wire                    s0_we,
   input  wire              [3:0] s0_be,
   input  wire   [ADDR_WIDTH-1:0] s0_addr,
   input  wire             [31:0] s0_wdata,
   output wire             [31:0] s0_rdata,
   output wire                    s0_err,

   //$port_g CORE Slave1 interface
   input  wire                    s1_req,
   output wire                    s1_gnt,
   output reg                     s1_rvalid,
   input  wire                    s1_we,
   input  wire              [3:0] s1_be,
   input  wire   [ADDR_WIDTH-1:0] s1_addr,
   input  wire             [31:0] s1_wdata,
   output wire             [31:0] s1_rdata,
   output wire                    s1_err,

   //$port_g SRAM Master interface
   output wire                    ram_cs,
   output wire              [3:0] ram_we,
   output wire   [ADDR_WIDTH-3:0] ram_a,
   output wire             [31:0] ram_d,
   input  wire             [31:0] ram_q
);


////////////////////////////////////////////////////////////////////////////////
// Internal Signals
////////////////////////////////////////////////////////////////////////////////
reg [1:0] owner;


////////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------
// Owner generation
//------------------------------------------------------------------------------
always @(posedge clk or negedge rst_n)
begin
   if (~rst_n)
      owner <= 2'b01;
   else
   begin
      if (~s0_req & ~s1_req)          owner <= 2'b01;
      else if (owner==2'b10 & s0_req) owner <= 2'b01;
      else if (owner==2'b01 & s1_req) owner <= 2'b10;
   end
end


//------------------------------------------------------------------------------
// Core control
//------------------------------------------------------------------------------
assign s0_gnt    = owner[0] & s0_req;
assign s0_rdata  = ram_q;
assign s0_err    = 1'b0;

assign s1_gnt    = owner[1] & s1_req;
assign s1_rdata  = ram_q;
assign s1_err    = 1'b0;

always @(posedge clk or negedge rst_n)
begin
   if (~rst_n)
   begin
      s0_rvalid <= 1'b0;
      s1_rvalid <= 1'b0;
   end
   else
   begin
      s0_rvalid <= s0_gnt;
      s1_rvalid <= s1_gnt;
   end
end


//------------------------------------------------------------------------------
// Ram Control
//------------------------------------------------------------------------------
assign ram_cs = owner[1] ? s1_req                      : s0_req;
assign ram_we = owner[1] ? s1_be & {4{s1_we & s1_req}} : s0_be & {4{s0_we & s0_req}};
assign ram_a  = owner[1] ? s1_addr[ADDR_WIDTH-1:2]     : s0_addr[ADDR_WIDTH-1:2];
assign ram_d  = owner[1] ? s1_wdata                    : s0_wdata;


endmodule
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////
