//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of RISC-V module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////

module riscv_top( 
   //$port_g Clock and reset
   input  wire               clk,                     // Root clock
   input  wire               rst_n,                   // Core reset
                                                      
   //$port_g Instruction memory interface             
   output wire               instr_req_o,             // Request
   input  wire               instr_gnt_i,             // Grant
   input  wire               instr_rvalid_i,          // Read Valid
   output wire        [31:0] instr_addr_o,            // Address
   input  wire        [31:0] instr_rdata_i,           // Read Data
                                                      
   //$port_g Data memory interface                    
   output wire               data_req_o,              // Request
   input  wire               data_gnt_i,              // Grant
   input  wire               data_rvalid_i,           // Read Valid
   output wire               data_we_o,               // Write Enable
   output wire         [3:0] data_be_o,               // Byte Enable
   output wire        [31:0] data_addr_o,             // Address
   output wire        [31:0] data_wdata_o,            // Write Data
   input  wire        [31:0] data_rdata_i,            // Read Data
   input  wire               data_err_i,              // Error
                                                      
   //$port_g Interrupt Interface                      
   input  wire        [31:0] irq_i,                   // Level sensitive IR lines

   //$port_g Debug Interface
   input  wire               debug_req_i,
   output wire               debug_gnt_o,
   output wire               debug_rvalid_o,
   input  wire        [14:0] debug_addr_i,
   input  wire               debug_we_i,
   input  wire        [31:0] debug_wdata_i,
   output wire        [31:0] debug_rdata_o,
   output wire               debug_halted_o,
   input  wire               debug_halt_i,
   input  wire               debug_resume_i,
   
   //$port_g CPU Control Signals
   input  wire               fetch_enable_i,
   output wire               core_busy_o
);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//******************************************************************************
// RISC-V
//******************************************************************************

`define ZERORISCY
`ifdef  ZERORISCY
reg [4:0] irq_id_i;
always @*
begin
   casez (irq_i[2:0])
   3'b??1: irq_id_i = 5'd0;
   3'b?10: irq_id_i = 5'd1;
   3'b100: irq_id_i = 5'd2;
   default:irq_id_i = 5'd0;
   endcase
end
assign core_busy_o = 1'b0;

zeroriscy_core #(
   .RV32E              (0),
   .RV32M              (1)
) u_zeroriscy_core (
`else //ZERORISCY
riscv_core u_riscv_core (
`endif//ZERORISCY
   //Clock and Reset
   .clk_i               (clk            ),
   .rst_ni              (rst_n          ),
   .clock_en_i          (1'b1           ),
   .test_en_i           (1'b0           ),
   //Core ID, Cluster ID and boot address are considered more or less static
   .boot_addr_i         (32'h0          ),
   .core_id_i           (4'h0           ),
   .cluster_id_i        (6'h0           ),
   //Instruction memory interface
   .instr_req_o         (instr_req_o    ),
   .instr_gnt_i         (instr_gnt_i    ),
   .instr_rvalid_i      (instr_rvalid_i ),
   .instr_addr_o        (instr_addr_o   ),
   .instr_rdata_i       (instr_rdata_i  ),
   //Data memory interface
   .data_req_o          (data_req_o     ),
   .data_gnt_i          (data_gnt_i     ),
   .data_rvalid_i       (data_rvalid_i  ),
   .data_we_o           (data_we_o      ),
   .data_be_o           (data_be_o      ),
   .data_addr_o         (data_addr_o    ),
   .data_wdata_o        (data_wdata_o   ),
   .data_rdata_i        (data_rdata_i   ),
   .data_err_i          (data_err_i     ),
   // Interrupt inputs
`ifdef  ZERORISCY
   .irq_i               (|irq_i[2:0]    ),
   .irq_id_i            (irq_id_i       ),
   .irq_ack_o           (/*Open*/       ),
   .irq_id_o            (/*Open*/       ),
`else //ZERORISCY
   .irq_i               (irq_i          ),
`endif//ZERORISCY
   // Debug Interface
   .debug_req_i         (debug_req_i    ),
   .debug_gnt_o         (debug_gnt_o    ),
   .debug_rvalid_o      (debug_rvalid_o ),
   .debug_addr_i        (debug_addr_i   ),
   .debug_we_i          (debug_we_i     ),
   .debug_wdata_i       (debug_wdata_i  ),
   .debug_rdata_o       (debug_rdata_o  ),
   .debug_halted_o      (debug_halted_o ),
   .debug_halt_i        (debug_halt_i   ),
   .debug_resume_i      (debug_resume_i ),
   // CPU Control Signals
   .fetch_enable_i      (fetch_enable_i ),
`ifndef ZERORISCY
   .core_busy_o         (core_busy_o    ),
`endif//ZERORISCY
   .ext_perf_counters_i (2'b0           )
);


endmodule
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
