/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none

// Buffer Pointer resynchronization
// srcbufptr will not change faster than every ~100' of ns.
// The following scheme assumes srcbufptr stays stable, after each change, for at least
// the propagation time to bufptr_comp + 3 dstclk cycles.
// srcbufptr is resampled to dstbufptr when a value change between the two pointers has been
// detected and resynchronized.
// srcbufptr_attr contains attributes of the srcbufptr. They are resampled to dstbufptr_attr
// at the same time as srcbufptr is resampled to dstbufptr.  
module ClkSyncBufPtr # (
  parameter PTRSIZE = 2
)(
  /* system */
  input  wire                srcclk,
  input  wire                srcresetn,
  
  input  wire                dstclk,
  input  wire                dstresetn,

  input  wire                dstenable,

  /* Buffer pointers with specific resynchronization scheme */
  input  wire [PTRSIZE-1:0]  srcbufptr,
  output wire [PTRSIZE-1:0]  dstbufptr
);

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
  // detect value change as src pointers
  wire srcbufptr_comp_rise;
  wire dstbufptr_comp_rise;

  reg  [PTRSIZE-1:0]  srcbufptr_1t;

  // internal signals with _resync suffix for STA
  reg  [PTRSIZE-1:0]  dstbufptr_resync;
  
//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  always @(posedge srcclk, negedge srcresetn)
    if(!srcresetn)
      srcbufptr_1t <= {PTRSIZE{1'b0}};
    else
      srcbufptr_1t <= srcbufptr;

  assign dstbufptr      = dstbufptr_resync;

  assign srcbufptr_comp_rise = (srcbufptr_1t!=srcbufptr);

  // Resync comparison rise to destination clock domain
  ClkSyncPulse2Pulse u_ClkSync_bufptr_comp_rise( 
    .srcclk(     srcclk),
    .srcresetn(  srcresetn),
    .dstclk(     dstclk),
    .dstresetn(  dstresetn),

    .srcdata(    srcbufptr_comp_rise),
    .dstdata(    dstbufptr_comp_rise)
    );


  // Sample pointer value in destination domain when comparison signal has been resynchronized
  always @(posedge dstclk, negedge dstresetn)
    if(!dstresetn)
      dstbufptr_resync <= {PTRSIZE{1'b0}};
    else if (!dstenable)
      dstbufptr_resync <= {PTRSIZE{1'b0}};
    else if (dstbufptr_comp_rise)
      dstbufptr_resync <= srcbufptr;

endmodule
`default_nettype wire
