//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 26840 $
// $Date: 2016-06-08 16:51:13 +0200 (Wed, 08 Jun 2016) $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : 
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module ClkSyncFallingEdgeDetector( 
         input  wire      dstclk,
         input  wire      dstresetn,
         input  wire      srcdata,
         //  
         output wire      dstdata
         );


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
wire dst_ff1;
reg  dst_ff2;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

assign dstdata = (dst_ff2 == 1'b1 && dst_ff1 == 1'b0) ? 1'b1 : 1'b0;

// resynchronize data
ClkSyncSimple u_ClkSyncSimple
(
  .dstclk(     dstclk),
  .dstresetn(  dstresetn),
  .srcdata(    srcdata),
  .dstdata(    dst_ff1)
 );

always @ (posedge dstclk or negedge dstresetn) 
begin
  if ( dstresetn == 1'b0)  // Asynchronous Reset
    dst_ff2 <= 1'b0;
  else
    dst_ff2 <= dst_ff1;
end

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
