/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      :   
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module ClkSyncParam # (
  parameter PARAMSIZE = 2
)(
  input  wire                    dstclk,
  input  wire                    dstresetn,

  input  wire                    srcupdate,
  input  wire [PARAMSIZE-1:0]    srcdata,

  output reg                     dstupdate,
  output wire [PARAMSIZE-1:0]    dstdata

);
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  wire                  dstupdate_resync; 
  reg  [PARAMSIZE-1:0]  dstdata_resync;
  reg                   dstupdate_m1t;
  
  /*****************************************************************************
  * OFDM RX VECTOR 
  *****************************************************************************/
  assign dstdata      = dstdata_resync;
  
  ClkSyncSimple u_ClkSyncUpdate
  (
    .dstclk(     dstclk),
    .dstresetn(  dstresetn),
    .srcdata(    srcupdate),
    .dstdata(    dstupdate_resync)
   );

  always @(posedge dstclk,negedge dstresetn)
    if(!dstresetn)
    begin
      dstupdate_m1t   <= 1'b0; 
      dstupdate       <= 1'b0; 
      dstdata_resync  <= {PARAMSIZE{1'b0}};
    end
    else
    begin
      dstupdate_m1t    <= dstupdate_resync; 
      dstupdate        <= dstupdate_m1t; 
      if (dstupdate_resync && !dstupdate_m1t)
        dstdata_resync <= srcdata;     
    end

endmodule
`default_nettype wire
  
