//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 26840 $
// $Date: 2016-06-08 16:51:13 +0200 (Wed, 08 Jun 2016) $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : 
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module ClkSyncPulse2Pulse( 
         input  wire      srcclk,
         input  wire      srcresetn,
         input  wire      dstclk,
         input  wire      dstresetn,
         input  wire      srcdata,
         
         output wire      dstdata
         );

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
reg         srcdataCapt;
wire        dstdata_ff1;      
reg         dstdata_ff2;      
wire        srcdataCaptReset;    // reset the srcdataCapt


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

assign dstdata = ((dstdata_ff1 == 1'b1) && (dstdata_ff2 == 1'b0)) ? 1'b1 : 1'b0;

// Capture the input
always @ (posedge srcclk or negedge srcresetn) 
begin
  if (srcresetn == 1'b0)  // Asynchronous Reset
    srcdataCapt <= 1'b0;
  else if (srcdata == 1'b1)
    srcdataCapt <= 1'b1;
  else if (srcdataCaptReset == 1'b1)
    srcdataCapt <= 1'b0;
end

// resynchronize dst data
ClkSyncSimple u_ClkSyncSimple_src
(
  .dstclk(     srcclk),
  .dstresetn(  srcresetn),
  .srcdata(    dstdata_ff1),
  .dstdata(    srcdataCaptReset)
 );

// resynchronize captured data
ClkSyncSimple u_ClkSyncSimple_dst
(
  .dstclk(     dstclk),
  .dstresetn(  dstresetn),
  .srcdata(    srcdataCapt),
  .dstdata(    dstdata_ff1)
 );

always @ (posedge dstclk or negedge dstresetn) 
begin
  if (dstresetn == 1'b0)  // Asynchronous Reset
    dstdata_ff2 <= 1'b0;
  else
    dstdata_ff2 <= dstdata_ff1;
end

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
