//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 26840 $
// $Date: 2016-06-08 16:51:13 +0200 (Wed, 08 Jun 2016) $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : 
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module ClkSyncPulseSrcDomain( 
         input  wire     srcclk,
         input  wire     srcresetn,
         //
         input  wire     srcdata,
         input  wire     dstdata_sampled,
         
         //
         output reg      srcdataCapt
         );

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
wire srcdataCaptReset;    // reset the srcdataCapt

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Capt the input
always @ (posedge srcclk or negedge srcresetn) 
begin
  if ( srcresetn == 1'b0)  // Asynchronous Reset
    srcdataCapt <= 1'b0;
  else
    if ( srcdata == 1'b1 )
      srcdataCapt <= 1'b1;
    else if (srcdataCaptReset == 1'b1)
      srcdataCapt <= 1'b0;
end

// resynchronize dst data
ClkSyncSimple u_ClkSyncSimple
(
  .dstclk(     srcclk),
  .dstresetn(  srcresetn),
  .srcdata(    dstdata_sampled),
  .dstdata(    srcdataCaptReset)
 );

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
