//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : 
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module Data2RAM # (
  parameter RAM_DWIDTH  =  128,
  parameter RAM_AWIDTH  =  10,
  parameter RAM_WEWIDTH =  4
)( 
  /* system */
  input  wire                    nRst,
  input  wire                    Clk,

  /* control */
  input  wire                    Enable,
  input  wire                    Start,
  input  wire [RAM_AWIDTH-1:0]   StartAddress,
  input  wire [RAM_AWIDTH-1:0]   WrapAddress, // Address at which write address wraps to 0

  /* Data interface */
  input  wire [RAM_DWIDTH-1:0]   DataIn,
  input  wire                    DataInValid,
  input  wire [RAM_WEWIDTH-1:0]  DataInLen, // indicates which part of DataIn must be written, in slices of RAM_DWIDTH/RAM_WEWIDTH

  /* Memory interface */
  output reg  [RAM_AWIDTH-1:0]   RAMWrAddr,
  output reg  [RAM_WEWIDTH-1:0]  RAMWrEn,
  output reg  [RAM_DWIDTH-1:0]   RAMWrData
  
  );

  /******************************************************************************
  * declarations
  ******************************************************************************/
  localparam   [RAM_AWIDTH-1:0] SIG_ONE_DSP_AWIDTH_PARAM = 'b1;
  reg StartStore;

  /******************************************************************************
  * Output
  ******************************************************************************/

  always @(posedge Clk, negedge nRst)
    if(!nRst)
    begin
      RAMWrAddr     <= {RAM_AWIDTH{1'd0}};
      RAMWrEn       <= {RAM_WEWIDTH{1'd0}};
      RAMWrData     <= {RAM_DWIDTH{1'd0}};
      StartStore    <= 1'b0;

    end else if (!Enable) begin
      RAMWrAddr     <= {RAM_AWIDTH{1'd0}};
      RAMWrEn       <= {RAM_WEWIDTH{1'd0}};
      RAMWrData     <= {RAM_DWIDTH{1'd0}};
      StartStore    <= 1'b0;

    end else begin
      // Store Start until first data valid
      if (Start)
        StartStore    <= 1'b1;
    
      // Store incoming valid data in RAM
      if(DataInValid) begin
        if (Start || StartStore) begin
          RAMWrAddr     <= StartAddress;
          StartStore    <= 1'b0;
        end else begin
          if (RAMWrAddr == WrapAddress) 
            RAMWrAddr  <= {RAM_AWIDTH{1'b0}};
          else 
            RAMWrAddr  <= RAMWrAddr + SIG_ONE_DSP_AWIDTH_PARAM;
        end
        RAMWrEn       <= DataInLen;
        RAMWrData     <= DataIn;
      // No valid data, reset WrEn
      end else begin
        RAMWrEn       <= {RAM_WEWIDTH{1'd0}};
      end
      
    end


endmodule
                 
`default_nettype wire
