////////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//------------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//------------------------------------------------------------------------------
// $Revision: $
// $Date: $
// -----------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of aes module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// -----------------------------------------------------------------------------
//
//
////////////////////////////////////////////////////////////////////////////////
`default_nettype none

module aes( 
   //$port_g Clocks and Resets
   input  wire           pClk,           // baseband clock signal
   input  wire           nPRst,          // reset signal from hardware
   input  wire           nSRst,          // reset signal from software

   //$port_g Control
   input  wire           abort_p,        // Abort Request
   input  wire           aesInValid,     // Cipher Input Qualifier
   input  wire    [1:0]  aesKeyLen,      // Cipher Key Length
   input  wire  [255:0]  aesKey,         // Cipher Key
   input  wire  [127:0]  aesInData,      // Plain Text
   output wire  [127:0]  aesOutData,     // Cipher Text
   output wire           aesOutValid_p   // Cipher Text qualifier
);


////////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
////////////////////////////////////////////////////////////////////////////////

//******************************************************************************
// AES Core
//******************************************************************************
aesCore u_aesCore( 
   //Clocks and Resets
   .pClk          (pClk          ),
   .nPRst         (nPRst         ),
   .nSRst         (nSRst         ),
   //Control
   .abort_p       (abort_p       ),
   .aesInValid    (aesInValid    ),
   .aesKeyLen     (aesKeyLen     ),
   .aesKey        (aesKey        ),
   .aesInData     (aesInData     ),
   .aesOutData    (aesOutData    ),
   .aesOutValid_p (aesOutValid_p )
);

////////////////////////////////////////////////////////////////////////////////
// Additional Code to ease verification
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Display FSM State in string for RTL simulation waveform
////////////////////////////////////////////////////////////////////////////////
`ifdef RW_SIMU_ON
`endif // RW_SIMU_ON

////////////////////////////////////////////////////////////////////////////////
// System Verilog Assertions
////////////////////////////////////////////////////////////////////////////////
`ifdef RW_ASSERT_ON
`endif // RW_ASSERT_ON

endmodule
                 
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////
