/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module async_fifo2
#(
  parameter integer    g_width     = 'd8,
  parameter integer    g_log_depth = 'd3
)
(  
  /*****************************************************************************
  * Domain W (w_clk)
  *****************************************************************************/
  input  wire                w_rst_n,
  input  wire                w_clk,
  
  input  wire                w_enable,
  
  output wire                w_ready,
  input  wire [g_width-1:0]  w_data,
  input  wire                w_valid,

  /*****************************************************************************
  * Domain R (r_clk)
  *****************************************************************************/
  input  wire                r_rst_n,
  input  wire                r_clk,
  
  input  wire                r_enable,
  
  input  wire                r_ready,
  output reg  [g_width-1:0]  r_data,
  output reg                 r_valid
);
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* W */
  wire [g_log_depth:0] n_w_wrptr_dec;
  wire [g_log_depth:0] w_rdptr_dec;
  wire                 fifo_full;
  reg  [g_width-1:0]   fifo[(2**g_log_depth)-1:0];
  reg  [g_log_depth:0] w_wrptr_dec;
  reg  [g_log_depth:0] w_wrptr_gray;
  wire [g_log_depth:0] w_rdptr_gray_2t;
 
  /* R */
  wire [g_log_depth:0] n_r_rdptr_dec;
  wire [g_log_depth:0] r_wrptr_dec;
  wire                 fifo_empty;
  wire [g_log_depth:0] r_wrptr_gray_2t;
  reg  [g_log_depth:0] r_rdptr_dec;
  reg  [g_log_depth:0] r_rdptr_gray;
  
  genvar i;
  
  /* gray/decimal convertions */
  function [g_log_depth:0] gray2dec;
    input   [g_log_depth:0]   i;
    integer k;
  begin
    gray2dec[g_log_depth] = i[g_log_depth];
    for(k=1 ; k<=g_log_depth ; k=k+1)
      gray2dec[g_log_depth-k] = gray2dec[g_log_depth-k+1] ^ i[g_log_depth-k];
  end
  endfunction
 
  function [g_log_depth:0] dec2gray;
    input [g_log_depth:0] i;
    dec2gray = {1'b0,i[g_log_depth:1]} ^ i;
  endfunction
  
  
  /*****************************************************************************
  * W domain
  *****************************************************************************/
  generate
    for(i=0;i<(g_log_depth+1);i=i+1)
    begin:g_wclk_rdptr_resync
      ClkSyncSimple u_wclk_rdptr_resync
      ( 
        .dstclk(          w_clk),
        .dstresetn(       w_rst_n),
        .srcdata(         r_rdptr_gray[i]),
        .dstdata(         w_rdptr_gray_2t[i])
      );
    end
  endgenerate
  
  /*  write pointers */
  assign n_w_wrptr_dec  = w_wrptr_dec + {{g_log_depth{1'b0}},1'b1};
  assign w_rdptr_dec    = gray2dec(w_rdptr_gray_2t);
  assign fifo_full      = w_wrptr_dec=={~w_rdptr_dec[g_log_depth],w_rdptr_dec[g_log_depth-1:0]};
  assign w_ready        = ~fifo_full && w_enable;
  
  /* fifo */
  always @(posedge w_clk, negedge w_rst_n)
  begin:b_fifo
    integer i;
    if(!w_rst_n)
    begin
      for(i=0;i<(2**g_log_depth);i=i+'d1)
        fifo[i] <= {g_width{1'b0}};
      w_wrptr_dec            <= {g_log_depth+1{1'b0}};
      w_wrptr_gray           <= {g_log_depth+1{1'b0}};
    end
    else
    begin
      if(w_enable)
      begin
        /* fifo write */                                                      
        if(!fifo_full && w_valid)                                             
        begin                                                                 
          fifo[w_wrptr_dec[g_log_depth-1:0]] <= w_data;                       
          w_wrptr_dec                        <= n_w_wrptr_dec;                
          w_wrptr_gray                       <= dec2gray(n_w_wrptr_dec);      
        end 
      end
      else
      begin
        /* reset */
        for(i=0;i<(2**g_log_depth);i=i+'d1)
          fifo[i] <= {g_width{1'b0}};
        w_wrptr_dec            <= {g_log_depth+1{1'b0}};
        w_wrptr_gray           <= {g_log_depth+1{1'b0}};
      end                                                                  
    end
  end
 
  /*****************************************************************************
  * R domain
  *****************************************************************************/
  generate
    for(i=0;i<(g_log_depth+1);i=i+1)
    begin:g_rclk_wrptr_resync
      ClkSyncSimple u_rclk_wrptr_resync
      ( 
        .dstclk(    r_clk),
        .dstresetn( r_rst_n),
        .srcdata(   w_wrptr_gray[i]),
        .dstdata(   r_wrptr_gray_2t[i])
      );
    end
  endgenerate

  /* pointers */
  assign n_r_rdptr_dec = r_rdptr_dec + {{g_log_depth{1'b0}},1'b1};
  assign r_wrptr_dec   = gray2dec(r_wrptr_gray_2t);
  assign fifo_empty    = r_rdptr_dec==r_wrptr_dec;

  always @(posedge r_clk, negedge r_rst_n)                       
  begin                                                          
    if(!r_rst_n)                                                 
    begin                                                        
      r_data       <= {g_width{1'b0}};                 
      r_valid      <= 1'b0;                            
      r_rdptr_dec  <= {g_log_depth+1{1'b0}};           
      r_rdptr_gray <= {g_log_depth+1{1'b0}};           
    end                                                          
    else                                                         
    begin                                                        
      /* read port */                                            
      if(r_enable)
      begin
        /* data consumed */                                      
        if(r_ready)                                              
          r_valid <= 1'b0;                                       
                                                                   
        /* fifo read */                                          
        if(!fifo_empty && (r_ready || !r_valid))                 
        begin                                                    
           r_data       <= fifo[r_rdptr_dec[g_log_depth-1:0]]; 
           r_valid      <= 1'b1;                               
           r_rdptr_dec  <= n_r_rdptr_dec;                      
           r_rdptr_gray <= dec2gray(n_r_rdptr_dec);            
        end   
      end
      else
      begin
        r_data       <= {g_width{1'b0}};                 
        r_valid      <= 1'b0;                            
        r_rdptr_dec  <= {g_log_depth+1{1'b0}};           
        r_rdptr_gray <= {g_log_depth+1{1'b0}};           
      end                                                   
    end                                                          
  end                                                            

endmodule
`default_nettype wire
