///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) by RivieraWaves.
// This module is a confidential and proprietary property of RivieraWaves
// and a possession or use of this module requires written permission
// from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 16379 $
// $Date: 2014-10-06 18:59:58 +0200 (Mon, 06 Oct 2014) $
//---------------------------------------------------------------------------
// Description : This module is responsible for generating clock for the platform
//               
//
// Terms & concepts : 
// Bugs :  
// Open issues and future enhancements : 
// Tasks and functions:  
// interfaces : 
// Revision History : 
///////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////// 
module mac_crm ( 
       /* $port_g system reset input */
       input wire      sys_rst_n,                     // System reset input

       /* $port_g test input */
       input wire      test,                          // test input

       /* $port_g rw_nx_platform resets outputs */
       output wire     plf_rst_n,                     // Active low hard reset signal synchronized to the plf_clk.
       output wire     mac_core_rst_n,                // Active low hard reset signal synchronized to the mac_core_clk.
       output wire     mac_wt_rst_n,                  // Active low hard reset signal synchronized to the mac_wt_lk.
       output wire     mpif_rst_n,                    // Active low hard reset signal synchronized to the mpif_clk.
       
       /* $port_g rw_nx_platform source clocks*/ 
       input wire      plf_root_clk,                  // Platform root clock
       input wire      mac_lp_root_clk,               // Low-Power root clock
       input wire      mac_wt_root_clk,               // WEP/TKIP root clock
       input wire      mac_core_root_clk,             // MAC Core root clock
       input wire      mpif_root_clk,                 // MPIF root clock
  
       /* $port_g  Clock enable inputs */
       input wire      mac_pi_clken,                  // Clock Enable for macPriClk Clocks
       input wire      mac_pi_tx_clken,               // Clock Enable for macPITxClk Clock
       input wire      mac_pi_rx_clken,               // Clock Enable for macPIRxClk Clock
       input wire      mac_core_clken,                // Clock Enable for macCoreClk Clock
       input wire      mac_core_tx_clken,             // Clock Enable for macCoreTxClk Clock
       input wire      mac_core_rx_clken,             // Clock Enable for macCoreRxClk Clock
       input wire      mac_crypt_clken,               // Clock Enable for macCryptClk Clock
       input wire      mac_wt_clken,                  // Clock Enable for macWTClk Clock
       input wire      mpif_clken,                    // Clock Enable for mpIFClk Clock
       input wire      mac_lp_clkswitch,              // Switch MAC Lower Clock.
`ifdef RW_MUMIMO_SEC_USER1_EN
       input wire      sec_u1_mac_pi_tx_clken,        // Clock Enable for sec_u1_mac_pi_tx_clk Clock
       input wire      sec_u1_mac_core_tx_clken,      // Clock Enable for sec_u1_mac_core_tx_clk Clock
       input wire      sec_u1_mac_crypt_clken,        // Clock Enable for sec_u1_macCryptClk Clock
       input wire      sec_u1_mpif_clken,             // Clock Enable for sec_u1_mpif_clk Clock
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
       input wire      sec_u2_mac_pi_tx_clken,        // Clock Enable for sec_u2_mac_pi_tx_clk Clock
       input wire      sec_u2_mac_core_tx_clken,      // Clock Enable for sec_u2_mac_core_tx_clk Clock
       input wire      sec_u2_mac_crypt_clken,        // Clock Enable for sec_u2_mac_crypt_clk Clock
       input wire      sec_u2_mpif_clken,             // Clock Enable for sec_u2_mpif_clk Clock
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
       input wire      sec_u3_mac_pi_tx_clken,        // Clock Enable for sec_u3_mac_pi_tx_clk Clock
       input wire      sec_u3_mac_core_tx_clken,      // Clock Enable for sec_u3_mac_core_tx_clk Clock
       input wire      sec_u3_mac_crypt_clken,        // Clock Enable for sec_u3_mac_crypt_clk Clock
       input wire      sec_u3_mpif_clken,             // Clock Enable for sec_u3_mpif_clk Clock
`endif // RW_MUMIMO_SEC_USER3_EN
       
         /* $port_g rw_nx_platform clocks outputs */
       output wire     mac_pi_clk,                    // Primary MAC Platform Interface Clock
       output wire     mac_pi_tx_clk,                 // Secondary MAC Platform Interface Clock for TX
       output wire     mac_pi_rx_clk,                 // Secondary MAC Platform Interface Clock for RX
       output wire     mac_core_clk,                  // Primary MAC Core Clock
       output wire     mac_core_tx_clk,               // Secondary MAC Core Clock for TX
       output wire     mac_core_rx_clk,               // Secondary MAC Core Clock for RX
       output wire     mac_crypt_clk,                 // Secondary MAC Crypt Clock for CryptoEngine
       output wire     mac_lp_clk,                    // MAC Low Power clock.
       output wire     mac_wt_clk,                    // Clock for WEP/TKIP blocks.
       output wire     mpif_clk,                      // Clock for Mpif.
`ifdef RW_MUMIMO_SEC_USER1_EN
       output wire     sec_u1_mac_pi_tx_clk,          // mac_pi_tx_clk Clock of secondary user 1
       output wire     sec_u1_mac_core_tx_clk,        // mac_core_tx_clk Clock of secondary user 1
       output wire     sec_u1_mac_crypt_clk,          // mac_crypt_clk Clock of secondary user 1
       output wire     sec_u1_mpif_clk,               // mpif_clk Clock of secondary user 1
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
       output wire     sec_u2_mac_pi_tx_clk,          // mac_pi_tx_clk Clock of secondary user 2
       output wire     sec_u2_mac_core_tx_clk,        // mac_core_tx_clk Clock of secondary user 2
       output wire     sec_u2_mac_crypt_clk,          // mac_crypt_clk Clock for Secondary User 2
       output wire     sec_u2_mpif_clk,               // mpif_clk Clock of secondary user 2
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
       output wire     sec_u3_mac_pi_tx_clk,          // mac_pi_tx_clk Clock of secondary user 3
       output wire     sec_u3_mac_core_tx_clk,        // mac_core_tx_clk Clock of secondary user 3
       output wire     sec_u3_mac_crypt_clk,          // mac_crypt_clk Clock for Secondary User 3
       output wire     sec_u3_mpif_clk,               // mpif_clk Clock of secondary user 3
`endif // RW_MUMIMO_SEC_USER3_EN
       output wire     plf_clk                        // Platform Clock
                 
       );
  
  
  
//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  
  
  // Resets
  //assign plf_rst_n       = sys_rst_n;
  // Instanciation of rw_crm_reset_cleaner
  // Name of the instance : u_reset_cleaner_plf_rst_n
  // Name of the file containing this module : rw_crm_reset_cleaner.v
  rw_crm_reset_cleaner u_reset_cleaner_plf_rst_n (
	  	.clk          (plf_root_clk),
		  .nrst_in      (sys_rst_n),
  		.nrst_out     (plf_rst_n)
	);


  //assign mac_core_rst_n  = sys_rst_n;
  // Instanciation of rw_crm_reset_cleaner
  // Name of the instance : u_reset_cleaner_mac_core_rst_n
  // Name of the file containing this module : rw_crm_reset_cleaner.v
  rw_crm_reset_cleaner u_reset_cleaner_mac_core_rst_n(
	  	.clk          (mac_core_root_clk),
		  .nrst_in      (sys_rst_n),
  		.nrst_out     (mac_core_rst_n)
	);
  
  //assign mac_wt_rst_n    = sys_rst_n;
  // Instanciation of rw_crm_reset_cleaner
  // Name of the instance : u_reset_cleaner_mac_wt_rst_n
  // Name of the file containing this module : rw_crm_reset_cleaner.v
  rw_crm_reset_cleaner u_reset_cleaner_mac_wt_rst_n (
	  	.clk          (mac_wt_root_clk),
		  .nrst_in      (sys_rst_n),
  		.nrst_out     (mac_wt_rst_n)
	);
  
  //assign mpif_rst_n      = sys_rst_n;
  // Instanciation of rw_crm_reset_cleaner
  // Name of the instance : u_reset_cleaner_mpif_rst_n
  // Name of the file containing this module : rw_crm_reset_cleaner.v
  rw_crm_reset_cleaner u_reset_cleaner_mpif_rst_n (
	  	.clk          (mpif_root_clk),
		  .nrst_in      (sys_rst_n),
  		.nrst_out     (mpif_rst_n)
	);
  
  // Instanciation of rw_crm_clock_mux
  // Name of the instance : u_rw_clock_mux
  // Name of the file containing this module : rw_crm_clock_mux.v
  rw_crm_clock_mux u_rw_clock_mux (
  		.clk0                   (mac_core_root_clk),
  		.clk1                   (mac_lp_root_clk),
  		.clk_sel                (mac_lp_clkswitch),
  		.resetn                 (mac_core_rst_n),
  		.test                   (test),
  		.switchedclk            (mac_lp_clk)
);


  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_mac_pi_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_mac_pi_clk (
  		.clk          (plf_root_clk),
  		.resetn       (plf_rst_n),
  		.enable       (mac_pi_clken),
  		.test         (test),
  		.gclk         (mac_pi_clk)
  		);


  //assign mac_pi_tx_clk   = plf_root_clk & mac_pi_tx_clken;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_mac_pi_tx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_mac_pi_tx_clk (
  		.clk          (plf_root_clk),
  		.resetn       (plf_rst_n),
  		.enable       (mac_pi_tx_clken),
  		.test         (test),
  		.gclk         (mac_pi_tx_clk)
  		);
  
`ifdef RW_MUMIMO_SEC_USER1_EN
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u1_mac_pi_tx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u1_mac_pi_tx_clk (
  		.clk          (plf_root_clk),
  		.resetn       (plf_rst_n),
  		.enable       (sec_u1_mac_pi_tx_clken),
  		.test         (test),
  		.gclk         (sec_u1_mac_pi_tx_clk)
  		);
`endif // RW_MUMIMO_SEC_USER1_EN
  
`ifdef RW_MUMIMO_SEC_USER2_EN
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u2_mac_pi_tx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u2_mac_pi_tx_clk (
  		.clk          (plf_root_clk),
  		.resetn       (plf_rst_n),
  		.enable       (sec_u2_mac_pi_tx_clken),
  		.test         (test),
  		.gclk         (sec_u2_mac_pi_tx_clk)
  		);
`endif // RW_MUMIMO_SEC_USER2_EN
  
`ifdef RW_MUMIMO_SEC_USER3_EN
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u3_mac_pi_tx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u3_mac_pi_tx_clk (
  		.clk          (plf_root_clk),
  		.resetn       (plf_rst_n),
  		.enable       (sec_u3_mac_pi_tx_clken),
  		.test         (test),
  		.gclk         (sec_u3_mac_pi_tx_clk)
  		);
`endif // RW_MUMIMO_SEC_USER3_EN
  
  //assign mac_pi_rx_clk   = plf_root_clk & mac_pi_rx_clken;  
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_mac_pi_rx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_mac_pi_rx_clk (
  		.clk          (plf_root_clk),
  		.resetn       (plf_rst_n),
  		.enable       (mac_pi_rx_clken),
  		.test         (test),
  		.gclk         (mac_pi_rx_clk)
  		);
  
  assign plf_clk         = plf_root_clk;      //macPISlaveClk
  
  // macCore clock domain (20-255 Mhz)
  
  //assign mac_core_clk    = mac_core_root_clk & mac_core_clken;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_mac_core_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_mac_core_clk (
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (mac_core_clken),
  		.test         (test),
  		.gclk         (mac_core_clk)
  		);

  //assign mac_core_tx_clk = mac_core_root_clk & mac_core_tx_clken;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_mac_core_tx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_mac_core_tx_clk (
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (mac_core_tx_clken),
  		.test         (test),
  		.gclk         (mac_core_tx_clk)
  		);

`ifdef RW_MUMIMO_SEC_USER1_EN
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u1_mac_core_tx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u1_mac_core_tx_clk (
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (sec_u1_mac_core_tx_clken),
  		.test         (test),
  		.gclk         (sec_u1_mac_core_tx_clk)
  		);
`endif // RW_MUMIMO_SEC_USER1_EN

`ifdef RW_MUMIMO_SEC_USER2_EN
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u2_mac_core_tx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u2_mac_core_tx_clk (
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (sec_u2_mac_core_tx_clken),
  		.test         (test),
  		.gclk         (sec_u2_mac_core_tx_clk)
  		);
`endif // RW_MUMIMO_SEC_USER2_EN

`ifdef RW_MUMIMO_SEC_USER3_EN
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u3_mac_core_tx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u3_mac_core_tx_clk (
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (sec_u3_mac_core_tx_clken),
  		.test         (test),
  		.gclk         (sec_u3_mac_core_tx_clk)
  		);
`endif // RW_MUMIMO_SEC_USER3_EN

  //assign mac_core_rx_clk = mac_core_root_clk & mac_core_rx_clken;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_mac_core_rx_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_mac_core_rx_clk(
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (mac_core_rx_clken),
  		.test         (test),
  		.gclk         (mac_core_rx_clk)
  		);
  
  //assign mac_crypt_clk   = mac_core_root_clk & mac_crypt_clken  ;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_mac_crypt_clk 
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_mac_crypt_clk (
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (mac_crypt_clken),
  		.test         (test),
  		.gclk         (mac_crypt_clk)
  		);

`ifdef RW_MUMIMO_SEC_USER1_EN
  //assign sec_u1_mac_crypt_clk   = mac_core_root_clk & sec_u1_mac_crypt_clken  ;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u1_mac_crypt_clk 
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u1_mac_crypt_clk (
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (sec_u1_mac_crypt_clken),
  		.test         (test),
  		.gclk         (sec_u1_mac_crypt_clk)
  		);
`endif // RW_MUMIMO_SEC_USER1_EN

`ifdef RW_MUMIMO_SEC_USER2_EN
  //assign sec_u2_mac_crypt_clk   = mac_core_root_clk & sec_u2_mac_crypt_clken  ;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u2_mac_crypt_clk 
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u2_mac_crypt_clk (
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (sec_u2_mac_crypt_clken),
  		.test         (test),
  		.gclk         (sec_u2_mac_crypt_clk)
  		);
`endif // RW_MUMIMO_SEC_USER2_EN

`ifdef RW_MUMIMO_SEC_USER3_EN
  //assign sec_u3mac_crypt_clk   = mac_core_root_clk & sec_u3mac_crypt_clken  ;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u3mac_crypt_clk 
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u3_mac_crypt_clk (
  		.clk          (mac_core_root_clk),
  		.resetn       (mac_core_rst_n),
  		.enable       (sec_u3_mac_crypt_clken),
  		.test         (test),
  		.gclk         (sec_u3_mac_crypt_clk)
  		);
`endif // RW_MUMIMO_SEC_USER3_EN

  // WEP/TKIP clock (x1/x2/x3 macCoreClk)
  //assign mac_wt_clk      = mac_wt_root_clk & mac_wt_clken;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_mac_wt_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_mac_wt_clk (
  		.clk          (mac_wt_root_clk),
  		.resetn       (mac_wt_rst_n),
  		.enable       (mac_wt_clken),
  		.test         (test),
  		.gclk         (mac_wt_clk)
  		);

  // MPIF clock (30-180 MHz)
  //assign mpif_clk        = mpif_root_clk & mpif_clken;
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_mpif_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_mpif_clk (
  		.clk          (mpif_root_clk),
  		.resetn       (mpif_rst_n),
  		.enable       (mpif_clken),
  		.test         (test),
  		.gclk         (mpif_clk)
  		);

`ifdef RW_MUMIMO_SEC_USER1_EN
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u1_mpif_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u1_mpif_clk (
  		.clk          (mpif_root_clk),
  		.resetn       (mpif_rst_n),
  		.enable       (sec_u1_mpif_clken),
  		.test         (test),
  		.gclk         (sec_u1_mpif_clk)
  		);
`endif // RW_MUMIMO_SEC_USER1_EN
  
`ifdef RW_MUMIMO_SEC_USER2_EN
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u2_mpif_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u2_mpif_clk (
  		.clk          (mpif_root_clk),
  		.resetn       (mpif_rst_n),
  		.enable       (sec_u2_mpif_clken),
  		.test         (test),
  		.gclk         (sec_u2_mpif_clk)
  		);
`endif // RW_MUMIMO_SEC_USER2_EN
  
`ifdef RW_MUMIMO_SEC_USER3_EN
  // Instanciation of rw_crm_clock_gater
  // Name of the instance : u_rw_crm_clock_gater_sec_u3_mpif_clk
  // Name of the file containing this module : rw_crm_clock_gater.v
  rw_crm_clock_gater u_rw_crm_clock_gater_sec_u3_mpif_clk (
  		.clk          (mpif_root_clk),
  		.resetn       (mpif_rst_n),
  		.enable       (sec_u3_mpif_clken),
  		.test         (test),
  		.gclk         (sec_u3_mpif_clk)
  		);
`endif // RW_MUMIMO_SEC_USER3_EN
  
endmodule // mac_crm

/////////////////////////////////////////////////////////////////////////////// 
