/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module sram_dual_port_model
#(
  parameter  g_addr_width = 10,
  parameter  g_data_width = 8,
  parameter  g_depth      = 0 // 0 defaults to depth = 2**g_addr_width
)
( 
  /* port 1 */
  input  wire                    clk1,
  input  wire                    en1,
  input  wire [g_addr_width-1:0] addr1,
  input  wire [g_data_width-1:0] wen1,
  input  wire [g_data_width-1:0] wdata1,
  output reg  [g_data_width-1:0] rdata1,
  
  /* port 2 */
  input  wire                    clk2,
  input  wire                    en2,
  input  wire [g_addr_width-1:0] addr2,
  input  wire [g_data_width-1:0] wen2,
  input  wire [g_data_width-1:0] wdata2,
  output reg  [g_data_width-1:0] rdata2
);

  localparam g_mem_depth = (g_depth==0) ? 2**g_addr_width : g_depth;
  reg [g_data_width-1:0] mem [0:g_mem_depth-1] /* synthesis syn_ramstyle="no_rw_check" */;

  reg [g_addr_width-1:0] reg_addr1;
  reg [g_addr_width-1:0] reg_addr2;


  integer i,j;
  
  `ifdef RW_SIMU_ON
  initial
  begin
    if (g_depth > (2**g_addr_width))
    begin
      $write("MEMORY MODEL ERROR. Wrong configuration of %m. g_depth (%0d) cannot be bigger than 2**g_addr_width (%0d)\n",g_depth,2**g_addr_width);
      $stop;
    end  
  end

  /* port 1 */
  always @(posedge clk1)
  begin 
    rdata1 <= {g_data_width{1'bx}};
    if(en1===1'b1)
    begin
      if(addr1<g_mem_depth)
      begin
        if(|wen1)
        begin
          if(!(|wen2) || addr1!=addr2)
          begin
            for (i = 0; i <g_data_width;i=i+1)
            begin
              if (wen1[i])
              begin
                mem[addr1][i] <= wdata1[i];
              end  
            end  
          end
          else
          begin
            $write("%m: both ports writing at the same address (addr1=%0d) !\n",g_depth,addr1);
            $stop();
          end
        end
        else
        begin
          rdata1 <= mem[addr1];
        end
      end
      else
      begin
        $write("%m: addr1 out of the specified range (g_depth=%0d,addr1=%0d) !\n",g_depth,addr1);
        $stop();
      end
    end
  end

  /* port 2 */
  always @(posedge clk2)
  begin 
    rdata2 <= {g_data_width{1'bx}};
    if(en2===1'b1)
    begin
      if(addr2<g_mem_depth)
      begin
        if(|wen2)
        begin
          if(!(|wen1) || addr1!=addr2)
          begin
            for (j = 0; j <g_data_width;j=j+1)
            begin
              if (wen2[j])
              begin
                mem[addr2][j] <= wdata2[j];
              end  
            end  
          end
          else
          begin
            $write("%m: both ports writing at the same address (addr2=%0d) !\n",g_depth,addr2);
            $stop();
          end
        end
        else
        begin
          rdata2 <= mem[addr2];
        end
      end
      else
      begin
        $write("%m: addr2 out of the specified range (g_depth=%0d,addr2=%0d) !\n",g_depth,addr2);
        $stop();
      end
    end
  end


  `else // RW_SIMU_ON

  always @*
  begin
    rdata1 = mem[reg_addr1];
  end  

  always @*
  begin
    rdata2 = mem[reg_addr2];
  end  

  always @(posedge clk1)
  begin
    reg_addr1 <= addr1;
    if (|wen1)
    begin
      for (i = 0; i <g_data_width;i=i+1)
      begin
        if (wen1[i])
        begin
          mem[addr1][i] <= wdata1[i];
        end  
      end
    end    
  end

  always @(posedge clk2)
  begin
    reg_addr2 <= addr2;
    if (|wen2)
    begin
      for (j = 0; j <g_data_width;j=j+1)
      begin
        if (wen2[j])
        begin
          mem[addr2][j] <= wdata2[j];
        end  
      end
    end    
  end


  `endif // RW_SIMU_ON
      
endmodule
`default_nettype wire
