/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module sram_single_port_model
#(
  parameter  g_addr_width       = 10,
  parameter  g_data_width       = 8,
  parameter  g_load_mem         = "none",
  parameter  g_depth            = 0 // 0 defaults to depth = 2**g_addr_width
)
( 
  input  wire                    clk,
  input  wire                    en,
  input  wire [g_data_width-1:0] wen,
  input  wire [g_addr_width-1:0] addr,
  input  wire [g_data_width-1:0] wdata,
  output reg  [g_data_width-1:0] rdata
);

  localparam g_mem_depth = (g_depth==0) ? 2**g_addr_width : g_depth;

  reg [g_data_width-1:0] mem [0:g_mem_depth-1];
  integer i;  

  `ifdef RW_SIMU_ON
  initial
  begin

    if (g_depth > (2**g_addr_width))
    begin
      $write("MEMORY MODEL ERROR. Wrong configuration of %m. g_depth (%0d) cannot be bigger than 2**g_addr_width (%0d)\n",g_depth,2**g_addr_width);
      $stop;
    end  
  end
  
  generate
    if (g_load_mem != "none")
    begin
      initial
      begin
       $readmemb(g_load_mem,mem);
      end
    end
  endgenerate
  `endif // RW_SIMU_ON
  
  
  always @(posedge clk)
  begin 
    rdata <= {g_data_width{1'bx}};
    if(en===1'b1)
    begin
      if(addr<g_mem_depth)
      begin
        if(|wen)
        begin
          for (i = 0; i <g_data_width;i=i+1)
          begin
            if (wen[i])
            begin
              mem[addr][i] <= wdata[i];
            end  
          end  
        end
        else
        begin
          rdata <= mem[addr];
        end
      end
      else
      begin
        $write("%m: addr out of the specified range (g_depth=%0d,addr=%0d) !\n",g_depth,addr);
        $stop();
      end
    end
  end
      
endmodule
`default_nettype wire
