/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module sram_two_port_model
#(
  parameter g_addr_width =8,
  parameter g_data_width =32,
  parameter g_depth      =0 // 0 defaults to depth = 2**g_addr_width
)
( 
  /* write port */
  input  wire                    wclk,
  input  wire [g_data_width-1:0] wen,
  input  wire [g_addr_width-1:0] waddr,
  input  wire [g_data_width-1:0] wdata,
  
  /* read port */
  input  wire                    rclk,
  input  wire                    ren,
  input  wire [g_addr_width-1:0] raddr,                
  output reg  [g_data_width-1:0] rdata
);

  localparam g_mem_depth = (g_depth==0) ? 2**g_addr_width : g_depth;
  reg [g_data_width-1:0] mem [0:g_mem_depth-1];

  integer i;
  
  
  initial
  begin
    if (g_depth > (2**g_addr_width))
    begin
      $write("MEMORY MODEL ERROR. Wrong configuration of %m. g_depth (%0d) cannot be bigger than 2**g_addr_width (%0d)\n",g_depth,2**g_addr_width);
      $stop;
    end  
  end

  /* write port */
  always @(posedge wclk) 
  begin
    if(|wen) 
    begin
      if(waddr<g_mem_depth)
      begin
        for (i = 0; i <g_data_width;i=i+1)
        begin
          if (wen[i])
          begin
            mem[waddr][i] <= wdata[i];
          end  
        end  
      end
      else
      begin
        $write("%m: waddr out of specified range (g_depth=%0d,waddr=%0d) !\n",g_depth,waddr);
        $stop();
      end
    end
  end

  /* read port */
  always @(posedge rclk)
  begin
    rdata <= {g_data_width{1'hx}};
    if(ren)
    begin
      if(raddr<g_mem_depth)
      begin
        rdata <= mem[raddr];
      end
      else
      begin
        $write("%m: raddr out of the specified range (g_depth=%0d,raddr=%0d) !\n",g_depth,raddr);
        $stop();
      end
    end
  end
      
endmodule
`default_nettype wire
