///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) by RivieraWaves.
// This module is a confidential and proprietary property of RivieraWaves
// and a possession or use of this module requires written permission
// from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthournout $
// Company : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 16379 $
// $Date: 2018-02-14 14:17:55 +0100 (Wed, 14 Feb 2018) $
//---------------------------------------------------------------------------
// Description : This module is responsible for generating clock gating
//               
//
// Terms & concepts : 
// Bugs :  
// Open issues and future enhancements : 
// Tasks and functions:  
// interfaces : 
// Revision History : 
///////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////// 
module rw_crm_clock_gater ( // Inputs
                       input wire clk,
                       input wire resetn,
                       input wire enable, 
                       input wire test,
                       // Outputs
                       output wire gclk 
                       );
  


reg enableff1; 
reg enableff2; 
reg clken;     

/*************************************************** END OF DECLARATIONS ******************************************************/
always @(posedge clk or negedge resetn) 
begin
   if(resetn == 1'b0) 
     enableff1 <= 1'd1;
   else 
     enableff1 <= enable;
end

always @(posedge clk or negedge resetn) 
begin
   if(resetn == 1'b0) 
     enableff2 <= 1'd1;
   else 
     enableff2 <= enableff1;
end

always @(negedge clk or negedge resetn) 
begin
   if(resetn == 1'b0) 
     clken <= 1'd1;
   else 
     clken <= enableff2 | test;
end

assign gclk = clken & clk;

endmodule


