///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) by RivieraWaves.
// This module is a confidential and proprietary property of RivieraWaves
// and a possession or use of this module requires written permission
// from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthournout $
// Company : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 16379 $
// $Date: 2018-01-26 17:13:17 +0100 (Fri, 26 Jan 2018) $
//---------------------------------------------------------------------------
// Description : This module is responsible for generating clock switch
//               
//
// Terms & concepts : 
// Bugs :  
// Open issues and future enhancements : 
// Tasks and functions:  
// interfaces : 
// Revision History : 
///////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////// 
module rw_crm_clock_mux ( // Inputs
                       input wire clk0,
                       input wire clk1,
                       input wire clk_sel, // 0 : clk0, 1 : clk1
                       input wire resetn,
                       input wire test,
                       // Outputs
                       output wire switchedclk
                       );
  


reg clk0en;
reg clk0en_ff1;

reg clk1en;
reg clk1en_ff1;

reg gclk0en;     
reg gclk1en;     

wire gclk0;
wire gclk1;

/*************************************************** END OF DECLARATIONS ******************************************************/
`define REAL_CLOCK_MUX
`ifdef REAL_CLOCK_MUX

always @(posedge clk0 or negedge resetn) 
begin
   if(resetn == 1'b0) 
     clk0en     <= 1'd0;
   else 
     clk0en     <= !(clk1en_ff1 | clk_sel);
end

always @(posedge clk0 or negedge resetn) 
//always @(negedge clk0 or negedge resetn) 
begin
   if(resetn == 1'b0) 
     clk0en_ff1 <= 1'd0;
   else 
     clk0en_ff1 <= clk0en;
end

always @(posedge clk1 or negedge resetn) 
begin
   if(resetn == 1'b0) 
     clk1en     <= 1'd0;
   else 
     clk1en     <= !(clk0en_ff1 | !clk_sel);
end

always @(posedge clk1 or negedge resetn) 
//always @(negedge clk1 or negedge resetn) 
begin
   if(resetn == 1'b0) 
     clk1en_ff1 <= 1'd0;
   else 
     clk1en_ff1 <= clk1en;
end

always @(clk0)
begin
   if (clk0 == 1'b0)
     gclk0en    <= clk0en;
end
assign gclk0 = clk0 & gclk0en;
//assign gclk0 = clk0 & clk0en_ff1;

always @(clk1)
begin
   if (clk1 == 1'b0)
     gclk1en    <= clk1en;
end
assign gclk1 = clk1 & gclk1en;
//assign gclk1 = clk1 & clk1en_ff1;


assign switchedclk = gclk0 | gclk1;

`else // REAL_CLOCK_MUX

assign switchedclk = (clk_sel) ? clk1 : clk0;

`endif // REAL_CLOCK_MUX
endmodule


