//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission 
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 918 $
// $Date: 
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Diagnostic port used for debug.
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////

module rw_nx_diag (
            ///////////////////////////////////////////////
            //$port_g Registers
            ///////////////////////////////////////////////
            // DIAGCNTL register
            input  wire [4:0] diag0_sel,    // Diagnostic port 0 selection
            input  wire [4:0] diag1_sel,    // Diagnostic port 1 selection
            input  wire [4:0] diag2_sel,    // Diagnostic port 2 selection
            input  wire [4:0] diag3_sel,    // Diagnostic port 3 selection
            input  wire [4:0] diag4_sel,    // Diagnostic port 4 selection

            ///////////////////////////////////////////////
            //$port_g Diagnostic ports from IPs blocks
            ///////////////////////////////////////////////
            input  wire [31:0] diag_in0,     // Diagnostic input port 0
            input  wire [31:0] diag_in1,     // Diagnostic input port 1
            input  wire [31:0] diag_in2,     // Diagnostic input port 2
            input  wire [31:0] diag_in3,     // Diagnostic input port 3
            input  wire [31:0] diag_in4,     // Diagnostic input port 4
            input  wire [31:0] diag_in5,     // Diagnostic input port 5
            input  wire [31:0] diag_in6,     // Diagnostic input port 6
            input  wire [31:0] diag_in7,     // Diagnostic input port 7
            input  wire [31:0] diag_in8,     // Diagnostic input port 8
            input  wire [31:0] diag_in9,     // Diagnostic input port 9
            input  wire [31:0] diag_in10,    // Diagnostic input port 10
            input  wire [31:0] diag_in11,    // Diagnostic input port 11
            input  wire [31:0] diag_in12,    // Diagnostic input port 12
            input  wire [31:0] diag_in13,    // Diagnostic input port 13
            input  wire [31:0] diag_in14,    // Diagnostic input port 14
            input  wire [31:0] diag_in15,    // Diagnostic input port 15
            input  wire [31:0] diag_in16,    // Diagnostic input port 16
            input  wire [31:0] diag_in17,    // Diagnostic input port 17
            input  wire [31:0] diag_in18,    // Diagnostic input port 18
            input  wire [31:0] diag_in19,    // Diagnostic input port 19
            input  wire [31:0] diag_in20,    // Diagnostic input port 20
            input  wire [31:0] diag_in21,    // Diagnostic input port 21
            input  wire [31:0] diag_in22,    // Diagnostic input port 22
            input  wire [31:0] diag_in23,    // Diagnostic input port 23
            input  wire [31:0] diag_in24,    // Diagnostic input port 24
            input  wire [31:0] diag_in25,    // Diagnostic input port 25
            input  wire [31:0] diag_in26,    // Diagnostic input port 26
            input  wire [31:0] diag_in27,    // Diagnostic input port 27
            input  wire [31:0] diag_in28,    // Diagnostic input port 28
            input  wire [31:0] diag_in29,    // Diagnostic input port 29
            input  wire [31:0] diag_in30,    // Diagnostic input port 30
            input  wire [31:0] diag_in31,    // Diagnostic input port 31

            
            ///////////////////////////////////////////////
            //$port_g debug output ports
            ///////////////////////////////////////////////
            output wire [31:0] dbg0,         // debug port 0
            output wire [31:0] dbg1,         // debug port 1
            output wire [31:0] dbg2,         // debug port 2
            output wire [31:0] dbg3,         // debug port 3
            output wire [31:0] dbg4          // debug port 4
            );



//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////
// DIAGSTAT 
reg  [31:0] diag0stat;    // Diagnostic output port 0
reg  [31:0] diag1stat;    // Diagnostic output port 1
reg  [31:0] diag2stat;    // Diagnostic output port 2
reg  [31:0] diag3stat;    // Diagnostic output port 3
reg  [31:0] diag4stat;    // Diagnostic output port 4

// IP debug output ports
//////////////////////////////////////////////////////////////////////////////
assign dbg0 = diag0stat;
assign dbg1 = diag1stat;
assign dbg2 = diag2stat;
assign dbg3 = diag3stat;
assign dbg4 = diag4stat;

// Debug port 0
//////////////////////////////////////////////////////////////////////////////
always @*
begin
  case(diag0_sel)
    5'd0  : diag0stat = diag_in0;
    5'd1  : diag0stat = diag_in1;
    5'd2  : diag0stat = diag_in2;
    5'd3  : diag0stat = diag_in3;
    5'd4  : diag0stat = diag_in4;
    5'd5  : diag0stat = diag_in5;
    5'd6  : diag0stat = diag_in6;
    5'd7  : diag0stat = diag_in7;
    5'd8  : diag0stat = diag_in8;
    5'd9  : diag0stat = diag_in9;
    5'd10 : diag0stat = diag_in10;
    5'd11 : diag0stat = diag_in11;
    5'd12 : diag0stat = diag_in12;
    5'd13 : diag0stat = diag_in13;
    5'd14 : diag0stat = diag_in14;
    5'd15 : diag0stat = diag_in15;
    5'd16 : diag0stat = diag_in16;
    5'd17 : diag0stat = diag_in17;
    5'd18 : diag0stat = diag_in18;
    5'd19 : diag0stat = diag_in19;
    5'd20 : diag0stat = diag_in20;
    5'd21 : diag0stat = diag_in21;
    5'd22 : diag0stat = diag_in22;
    5'd23 : diag0stat = diag_in23;
    5'd24 : diag0stat = diag_in24;
    5'd25 : diag0stat = diag_in25;
    5'd26 : diag0stat = diag_in26;
    5'd27 : diag0stat = diag_in27;
    5'd28 : diag0stat = diag_in28;
    5'd29 : diag0stat = diag_in29;
    5'd30 : diag0stat = diag_in30;
    5'd31 : diag0stat = diag_in31;

  endcase
end

// Debug port 1
//////////////////////////////////////////////////////////////////////////////
always @*
begin
  case(diag1_sel)
    5'd0  : diag1stat = diag_in0;
    5'd1  : diag1stat = diag_in1;
    5'd2  : diag1stat = diag_in2;
    5'd3  : diag1stat = diag_in3;
    5'd4  : diag1stat = diag_in4;
    5'd5  : diag1stat = diag_in5;
    5'd6  : diag1stat = diag_in6;
    5'd7  : diag1stat = diag_in7;
    5'd8  : diag1stat = diag_in8;
    5'd9  : diag1stat = diag_in9;
    5'd10 : diag1stat = diag_in10;
    5'd11 : diag1stat = diag_in11;
    5'd12 : diag1stat = diag_in12;
    5'd13 : diag1stat = diag_in13;
    5'd14 : diag1stat = diag_in14;
    5'd15 : diag1stat = diag_in15;
    5'd16 : diag1stat = diag_in16;
    5'd17 : diag1stat = diag_in17;
    5'd18 : diag1stat = diag_in18;
    5'd19 : diag1stat = diag_in19;
    5'd20 : diag1stat = diag_in20;
    5'd21 : diag1stat = diag_in21;
    5'd22 : diag1stat = diag_in22;
    5'd23 : diag1stat = diag_in23;
    5'd24 : diag1stat = diag_in24;
    5'd25 : diag1stat = diag_in25;
    5'd26 : diag1stat = diag_in26;
    5'd27 : diag1stat = diag_in27;
    5'd28 : diag1stat = diag_in28;
    5'd29 : diag1stat = diag_in29;
    5'd30 : diag1stat = diag_in30;
    5'd31 : diag1stat = diag_in31;

  endcase
end

// Debug port 2
//////////////////////////////////////////////////////////////////////////////
always @*
begin
  case(diag2_sel)
    5'd0  : diag2stat = diag_in0;
    5'd1  : diag2stat = diag_in1;
    5'd2  : diag2stat = diag_in2;
    5'd3  : diag2stat = diag_in3;
    5'd4  : diag2stat = diag_in4;
    5'd5  : diag2stat = diag_in5;
    5'd6  : diag2stat = diag_in6;
    5'd7  : diag2stat = diag_in7;
    5'd8  : diag2stat = diag_in8;
    5'd9  : diag2stat = diag_in9;
    5'd10 : diag2stat = diag_in10;
    5'd11 : diag2stat = diag_in11;
    5'd12 : diag2stat = diag_in12;
    5'd13 : diag2stat = diag_in13;
    5'd14 : diag2stat = diag_in14;
    5'd15 : diag2stat = diag_in15;
    5'd16 : diag2stat = diag_in16;
    5'd17 : diag2stat = diag_in17;
    5'd18 : diag2stat = diag_in18;
    5'd19 : diag2stat = diag_in19;
    5'd20 : diag2stat = diag_in20;
    5'd21 : diag2stat = diag_in21;
    5'd22 : diag2stat = diag_in22;
    5'd23 : diag2stat = diag_in23;
    5'd24 : diag2stat = diag_in24;
    5'd25 : diag2stat = diag_in25;
    5'd26 : diag2stat = diag_in26;
    5'd27 : diag2stat = diag_in27;
    5'd28 : diag2stat = diag_in28;
    5'd29 : diag2stat = diag_in29;
    5'd30 : diag2stat = diag_in30;
    5'd31 : diag2stat = diag_in31;

  endcase
end

// Debug port 3
//////////////////////////////////////////////////////////////////////////////

always @*
begin
  case(diag3_sel)
    5'd0  : diag3stat = diag_in0;
    5'd1  : diag3stat = diag_in1;
    5'd2  : diag3stat = diag_in2;
    5'd3  : diag3stat = diag_in3;
    5'd4  : diag3stat = diag_in4;
    5'd5  : diag3stat = diag_in5;
    5'd6  : diag3stat = diag_in6;
    5'd7  : diag3stat = diag_in7;
    5'd8  : diag3stat = diag_in8;
    5'd9  : diag3stat = diag_in9;
    5'd10 : diag3stat = diag_in10;
    5'd11 : diag3stat = diag_in11;
    5'd12 : diag3stat = diag_in12;
    5'd13 : diag3stat = diag_in13;
    5'd14 : diag3stat = diag_in14;
    5'd15 : diag3stat = diag_in15;
    5'd16 : diag3stat = diag_in16;
    5'd17 : diag3stat = diag_in17;
    5'd18 : diag3stat = diag_in18;
    5'd19 : diag3stat = diag_in19;
    5'd20 : diag3stat = diag_in20;
    5'd21 : diag3stat = diag_in21;
    5'd22 : diag3stat = diag_in22;
    5'd23 : diag3stat = diag_in23;
    5'd24 : diag3stat = diag_in24;
    5'd25 : diag3stat = diag_in25;
    5'd26 : diag3stat = diag_in26;
    5'd27 : diag3stat = diag_in27;
    5'd28 : diag3stat = diag_in28;
    5'd29 : diag3stat = diag_in29;
    5'd30 : diag3stat = diag_in30;
    5'd31 : diag3stat = diag_in31;

  endcase
end

// Debug port 4
//////////////////////////////////////////////////////////////////////////////

always @*
begin
  case(diag4_sel)
    5'd0  : diag4stat = diag_in0;
    5'd1  : diag4stat = diag_in1;
    5'd2  : diag4stat = diag_in2;
    5'd3  : diag4stat = diag_in3;
    5'd4  : diag4stat = diag_in4;
    5'd5  : diag4stat = diag_in5;
    5'd6  : diag4stat = diag_in6;
    5'd7  : diag4stat = diag_in7;
    5'd8  : diag4stat = diag_in8;
    5'd9  : diag4stat = diag_in9;
    5'd10 : diag4stat = diag_in10;
    5'd11 : diag4stat = diag_in11;
    5'd12 : diag4stat = diag_in12;
    5'd13 : diag4stat = diag_in13;
    5'd14 : diag4stat = diag_in14;
    5'd15 : diag4stat = diag_in15;
    5'd16 : diag4stat = diag_in16;
    5'd17 : diag4stat = diag_in17;
    5'd18 : diag4stat = diag_in18;
    5'd19 : diag4stat = diag_in19;
    5'd20 : diag4stat = diag_in20;
    5'd21 : diag4stat = diag_in21;
    5'd22 : diag4stat = diag_in22;
    5'd23 : diag4stat = diag_in23;
    5'd24 : diag4stat = diag_in24;
    5'd25 : diag4stat = diag_in25;
    5'd26 : diag4stat = diag_in26;
    5'd27 : diag4stat = diag_in27;
    5'd28 : diag4stat = diag_in28;
    5'd29 : diag4stat = diag_in29;
    5'd30 : diag4stat = diag_in30;
    5'd31 : diag4stat = diag_in31;

  endcase
end

endmodule

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------

