//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission 
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 918 $
// $Date: 
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Diagnostic port used for debug (4 inputs of 16bits).
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////

module rw_nx_diag_4x16 (
   ///////////////////////////////////////////////
   //$port_g Registers
   ///////////////////////////////////////////////
   // DIAGCNTL register
   input  wire  [1:0] diag_sel,     // Diagnostic port selection

   ///////////////////////////////////////////////
   //$port_g Diagnostic input ports
   ///////////////////////////////////////////////
   input  wire [15:0] diag_in0,     // Diagnostic input port 0
   input  wire [15:0] diag_in1,     // Diagnostic input port 1
   input  wire [15:0] diag_in2,     // Diagnostic input port 2
   input  wire [15:0] diag_in3,     // Diagnostic input port 3

   ///////////////////////////////////////////////
   //$port_g Diagnostic output ports
   ///////////////////////////////////////////////
   output reg  [15:0] diag_out      // Diagnostic output port
);



//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Debug port mux
always @*
begin
   case(diag_sel)
   2'd0  : diag_out = diag_in0;
   2'd1  : diag_out = diag_in1;
   2'd2  : diag_out = diag_in2;
   2'd3  : diag_out = diag_in3;
   endcase
end

endmodule
//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
