//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission 
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 918 $
// $Date: 
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Diagnostic port used for debug (64 inputs of 16bits).
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////

module rw_nx_diag_64x16 (
   ///////////////////////////////////////////////
   //$port_g Registers
   ///////////////////////////////////////////////
   // DIAGCNTL register
   input  wire  [5:0] diag_sel,     // Diagnostic port selection

   ///////////////////////////////////////////////
   //$port_g Diagnostic input ports
   ///////////////////////////////////////////////
   input  wire [15:0] diag_in0,     // Diagnostic input port 0
   input  wire [15:0] diag_in1,     // Diagnostic input port 1
   input  wire [15:0] diag_in2,     // Diagnostic input port 2
   input  wire [15:0] diag_in3,     // Diagnostic input port 3
   input  wire [15:0] diag_in4,     // Diagnostic input port 4
   input  wire [15:0] diag_in5,     // Diagnostic input port 5
   input  wire [15:0] diag_in6,     // Diagnostic input port 6
   input  wire [15:0] diag_in7,     // Diagnostic input port 7
   input  wire [15:0] diag_in8,     // Diagnostic input port 8
   input  wire [15:0] diag_in9,     // Diagnostic input port 9
   input  wire [15:0] diag_in10,    // Diagnostic input port 10
   input  wire [15:0] diag_in11,    // Diagnostic input port 11
   input  wire [15:0] diag_in12,    // Diagnostic input port 12
   input  wire [15:0] diag_in13,    // Diagnostic input port 13
   input  wire [15:0] diag_in14,    // Diagnostic input port 14
   input  wire [15:0] diag_in15,    // Diagnostic input port 15
   input  wire [15:0] diag_in16,    // Diagnostic input port 16
   input  wire [15:0] diag_in17,    // Diagnostic input port 17
   input  wire [15:0] diag_in18,    // Diagnostic input port 18
   input  wire [15:0] diag_in19,    // Diagnostic input port 19
   input  wire [15:0] diag_in20,    // Diagnostic input port 20
   input  wire [15:0] diag_in21,    // Diagnostic input port 21
   input  wire [15:0] diag_in22,    // Diagnostic input port 22
   input  wire [15:0] diag_in23,    // Diagnostic input port 23
   input  wire [15:0] diag_in24,    // Diagnostic input port 24
   input  wire [15:0] diag_in25,    // Diagnostic input port 25
   input  wire [15:0] diag_in26,    // Diagnostic input port 26
   input  wire [15:0] diag_in27,    // Diagnostic input port 27
   input  wire [15:0] diag_in28,    // Diagnostic input port 28
   input  wire [15:0] diag_in29,    // Diagnostic input port 29
   input  wire [15:0] diag_in30,    // Diagnostic input port 30
   input  wire [15:0] diag_in31,    // Diagnostic input port 31
   input  wire [15:0] diag_in32,    // Diagnostic input port 32
   input  wire [15:0] diag_in33,    // Diagnostic input port 33
   input  wire [15:0] diag_in34,    // Diagnostic input port 34
   input  wire [15:0] diag_in35,    // Diagnostic input port 35
   input  wire [15:0] diag_in36,    // Diagnostic input port 36
   input  wire [15:0] diag_in37,    // Diagnostic input port 37
   input  wire [15:0] diag_in38,    // Diagnostic input port 38
   input  wire [15:0] diag_in39,    // Diagnostic input port 39
   input  wire [15:0] diag_in40,    // Diagnostic input port 40
   input  wire [15:0] diag_in41,    // Diagnostic input port 41
   input  wire [15:0] diag_in42,    // Diagnostic input port 42
   input  wire [15:0] diag_in43,    // Diagnostic input port 43
   input  wire [15:0] diag_in44,    // Diagnostic input port 44
   input  wire [15:0] diag_in45,    // Diagnostic input port 45
   input  wire [15:0] diag_in46,    // Diagnostic input port 46
   input  wire [15:0] diag_in47,    // Diagnostic input port 47
   input  wire [15:0] diag_in48,    // Diagnostic input port 48
   input  wire [15:0] diag_in49,    // Diagnostic input port 49
   input  wire [15:0] diag_in50,    // Diagnostic input port 50
   input  wire [15:0] diag_in51,    // Diagnostic input port 51
   input  wire [15:0] diag_in52,    // Diagnostic input port 52
   input  wire [15:0] diag_in53,    // Diagnostic input port 53
   input  wire [15:0] diag_in54,    // Diagnostic input port 54
   input  wire [15:0] diag_in55,    // Diagnostic input port 55
   input  wire [15:0] diag_in56,    // Diagnostic input port 56
   input  wire [15:0] diag_in57,    // Diagnostic input port 57
   input  wire [15:0] diag_in58,    // Diagnostic input port 58
   input  wire [15:0] diag_in59,    // Diagnostic input port 59
   input  wire [15:0] diag_in60,    // Diagnostic input port 60
   input  wire [15:0] diag_in61,    // Diagnostic input port 61
   input  wire [15:0] diag_in62,    // Diagnostic input port 62
   input  wire [15:0] diag_in63,    // Diagnostic input port 63

   ///////////////////////////////////////////////
   //$port_g Diagnostic output ports
   ///////////////////////////////////////////////
   output reg  [15:0] diag_out      // Diagnostic output port
);



//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Debug port mux
always @*
begin
   case(diag_sel)
   6'd0  : diag_out = diag_in0;
   6'd1  : diag_out = diag_in1;
   6'd2  : diag_out = diag_in2;
   6'd3  : diag_out = diag_in3;
   6'd4  : diag_out = diag_in4;
   6'd5  : diag_out = diag_in5;
   6'd6  : diag_out = diag_in6;
   6'd7  : diag_out = diag_in7;
   6'd8  : diag_out = diag_in8;
   6'd9  : diag_out = diag_in9;
   6'd10 : diag_out = diag_in10;
   6'd11 : diag_out = diag_in11;
   6'd12 : diag_out = diag_in12;
   6'd13 : diag_out = diag_in13;
   6'd14 : diag_out = diag_in14;
   6'd15 : diag_out = diag_in15;
   6'd16 : diag_out = diag_in16;
   6'd17 : diag_out = diag_in17;
   6'd18 : diag_out = diag_in18;
   6'd19 : diag_out = diag_in19;
   6'd20 : diag_out = diag_in20;
   6'd21 : diag_out = diag_in21;
   6'd22 : diag_out = diag_in22;
   6'd23 : diag_out = diag_in23;
   6'd24 : diag_out = diag_in24;
   6'd25 : diag_out = diag_in25;
   6'd26 : diag_out = diag_in26;
   6'd27 : diag_out = diag_in27;
   6'd28 : diag_out = diag_in28;
   6'd29 : diag_out = diag_in29;
   6'd30 : diag_out = diag_in30;
   6'd31 : diag_out = diag_in31;
   6'd32 : diag_out = diag_in32;
   6'd33 : diag_out = diag_in33;
   6'd34 : diag_out = diag_in34;
   6'd35 : diag_out = diag_in35;
   6'd36 : diag_out = diag_in36;
   6'd37 : diag_out = diag_in37;
   6'd38 : diag_out = diag_in38;
   6'd39 : diag_out = diag_in39;
   6'd40 : diag_out = diag_in40;
   6'd41 : diag_out = diag_in41;
   6'd42 : diag_out = diag_in42;
   6'd43 : diag_out = diag_in43;
   6'd44 : diag_out = diag_in44;
   6'd45 : diag_out = diag_in45;
   6'd46 : diag_out = diag_in46;
   6'd47 : diag_out = diag_in47;
   6'd48 : diag_out = diag_in48;
   6'd49 : diag_out = diag_in49;
   6'd50 : diag_out = diag_in50;
   6'd51 : diag_out = diag_in51;
   6'd52 : diag_out = diag_in52;
   6'd53 : diag_out = diag_in53;
   6'd54 : diag_out = diag_in54;
   6'd55 : diag_out = diag_in55;
   6'd56 : diag_out = diag_in56;
   6'd57 : diag_out = diag_in57;
   6'd58 : diag_out = diag_in58;
   6'd59 : diag_out = diag_in59;
   6'd60 : diag_out = diag_in60;
   6'd61 : diag_out = diag_in61;
   6'd62 : diag_out = diag_in62;
   6'd63 : diag_out = diag_in63;
   endcase
end

endmodule
//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
