/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author:$
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :             
* Description      : rw_nx_macbypass
* Simulation Notes :             
* Synthesis Notes  :              
* Application Note :              
* Simulator        :             
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*           
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module rw_nx_macbypass
( 
  /*****************************************************************************
  * System
  *****************************************************************************/
  input  wire         mpif_rst_n, 
  input  wire         ahb_rst_n,  
  
  input  wire         mpif_clk,   
  input  wire         ahb_clk,    

  /*****************************************************************************
  * Clock enable
  *****************************************************************************/
  output wire         mpif_clken,
 
  /*****************************************************************************
  * AHB
  *****************************************************************************/
  input  wire         hready_in, 
  input  wire         hsel,      
  input  wire [ 9:0]  haddr,     
  input  wire [ 1:0]  htrans,    
  input  wire         hwrite,    
  input  wire [31:0]  hwdata,    
  output wire [31:0]  hrdata,    
  output wire [1:0]   hresp,     
  output wire         hready,    
  
  /*****************************************************************************
  * MAC/PHY   MAC side
  *****************************************************************************/
  input  wire         mpifi_txreq,
  input  wire [7:0]   mpifi_txdata,                         
  output reg          mpifi_phyrdy,                         
  input  wire         mpifi_macdatavalid,                   
  input  wire         mpifi_mimocmdvalid,                   
  output reg          mpifi_txend,                        
  input  wire         mpifi_rxreq,
  output reg  [7:0]   mpifi_rxdata,                         
  output reg          mpifi_cca_pri20,                      
  output reg          mpifi_cca_sec20,                      
  output reg          mpifi_cca_sec40,                      
  output reg          mpifi_rxendfortiming,               
  output reg          mpifi_rxerr,                        
  output reg          mpifi_rxend,                        
  input  wire         mpifi_keeprfon,                       
  output reg          mpifi_phyerr,                       
  output reg          mpifi_rifsrxdetected,                 
  
  /*****************************************************************************
  * MAC/PHY   PHY side
  *****************************************************************************/
  output reg          mpifo_txreq, 
  output reg  [7:0]   mpifo_txdata,
  output reg          mpifo_macdatavalid,                    
  output reg          mpifo_mimocmdvalid,                    
  input  wire         mpifo_phyrdy,
  input  wire         mpifo_txend,                         
  output reg          mpifo_rxreq, 
  input  wire [7:0]   mpifo_rxdata,
  input  wire         mpifo_cca_pri20,                       
  input  wire         mpifo_cca_sec20,                       
  input  wire         mpifo_cca_sec40,                       
  input  wire         mpifo_rxendfortiming,                
  input  wire         mpifo_rxerr,                         
  input  wire         mpifo_rxend,                         
  output reg          mpifo_keeprfon,                        
  input  wire         mpifo_phyerr,                        
  input  wire         mpifo_rifsrxdetected,                  
  
  /*****************************************************************************
  * interrupt/trigger
  *****************************************************************************/
  output wire         interrupt, /* ahb synchronous  */
  output wire  [1:0]  trigger    /* mpif synchronous */
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* ahbif */
  wire        ahbif_req;           
  wire        ahbif_req_resync;    
  wire        ahbif_wr;            
  wire [ 9:0] ahbif_addr;          
  wire [31:0] ahbif_wdata;         
  wire [31:0] ahbif_rdata;         
  wire        ahbif_ack;           
  wire        ahbif_ack_resync;      
  
  /* fsm */
  wire        fsm_rxreq;
  wire        fsm_txreq;
  wire        event_tx_phyerr;
  wire        event_tx_eof;
  wire        event_rx_eof_abort;
  wire        event_rx_eof_normal;
  wire        event_rx_rxerr;
  wire        event_rx_rxend;
  wire        event_rxv_unsupported;
  wire        event_rxv_supported;
  wire        event_rx_fcs_update;
  wire        event_rx_fcs_ok;
  wire        event_rx_fcs_bad;
  wire        event_rx_delimiter_lost;
  wire        event_rxvl_locked;
  wire [ 1:0] event_trigger;
  
  /* stat */
  wire [31:0] stat_frame_ok;
  wire [31:0] stat_frame_bad;
  wire [31:0] stat_rxend;
  wire [31:0] stat_rxerr;
  wire [31:0] stat_phyerr;
//  wire [ 7:0] stat_rssi;
//  wire [ 7:0] stat_evm;
 
  /* int */
  wire        int0_raw,int1_raw,int2_raw,int3_raw;
  
  /* rxv */
  wire        rxvu1_last;                     
  wire        rxvu2_last;                     
  wire        rxvu1_captured;                     
  wire        rxvu2_captured;                     
  wire        rxvl_locked;                        
  wire [ 7:0] rxvl_0,  rxvl_1,  rxvl_2,  rxvl_3;  
  wire [ 7:0] rxvl_4,  rxvl_5,  rxvl_6,  rxvl_7;  
  wire [ 7:0] rxvl_8,  rxvl_9,  rxvl_10, rxvl_11; 
  wire [ 7:0] rxvl_12, rxvl_13, rxvl_14, rxvl_15; 

  wire [11:0] rxvu_l_length;                      
  wire [19:0] rxvu_length;                        
  wire [ 3:0] rxvu_format;                        
  wire [ 6:0] rxvu_mcs;                           
  wire [ 1:0] rxvu_gi_type;                       
  wire        rxvu_fec;                           
  wire        rxvu_stbc;                          
  wire [ 2:0] rxvu_chbw;                          
  wire [ 2:0] rxvu_nss;                           
  wire        rxvu_sounding;                      
  wire [ 8:0] rxvu_paid;                          
  wire [ 5:0] rxvu_gid;                           
  wire        rxvu_smoothing;                     
  wire        rxvu_beamformed;                    
  wire        rxvu_aggregation;                   
  wire        rxvu_ndp;                   

  /* pldtrck */
  wire        pldtrck_enable;
  wire        pldtrck_last;
  
  /* txv */
  wire        txv_done;
  wire [ 3:0] txv_format;
  wire [19:0] txv_length;
  wire        txv_aggregation;
  wire [ 7:0] txv0,  txv1,  txv2,  txv3;
  wire [ 7:0] txv4,  txv5,  txv6,  txv7;
  wire [ 7:0] txv8,  txv9,  txv10, txv11;
  wire [ 7:0] txv12, txv13, txv14, txv15;
  wire [ 7:0] txv16, txv17, txv18, txv19;
  wire [ 7:0] txv20, txv21, txv22, txv23;
  wire [ 7:0] txv24, txv25;
  wire [ 7:0] txv_data;
  wire        txv_last;
  wire        txv_valid;
  
  /* pldgen */
  wire        pldgen_enable;
  wire        pldgen_done;
  wire [7:0]  pldgen_data;
  wire        pldgen_valid;
  
  /* registres */
  wire        regb_bypass;
  wire        regb_defkeeprfon;
  wire        regb_defrxreq;
  wire        regb_mode_is_rxlisten;
  wire        regb_mode_is_txsingle;
  wire        regb_mode_is_txburst;
  wire        regb_stat_clear;
  wire [ 3:0] regb_pld_type_rx;
  wire [ 3:0] regb_pld_type_tx;
  wire [15:0] regb_frameperburst;
  wire [19:0] regb_interframe_delay;
  wire        regb_intrxvlock_en;
  wire        regb_int3_en;
  wire        regb_int2_en;
  wire        regb_int1_en;
  wire        regb_int0_en;
  wire [ 7:0] regb_int3_gen;
  wire [ 7:0] regb_int2_gen;
  wire [ 7:0] regb_int1_gen;
  wire [ 7:0] regb_int0_gen;
  wire        regb_intrxvlock_ack;
  wire        regb_int0_ack;
  wire        regb_int1_ack;
  wire        regb_int2_ack;
  wire        regb_int3_ack;
  wire        regb_trig_format_en;
  wire [ 3:0] regb_trig_format;
  wire        regb_trig_mcs_en;
  wire [ 6:0] regb_trig_mcs;
  wire        regb_trig_gitype_en;
  wire [ 1:0] regb_trig_gitype;
  wire        regb_trig_fec_en;
  wire        regb_trig_fec;
  wire        regb_trig_stbc_en;
  wire        regb_trig_stbc;
  wire        regb_trig_chbw_en;
  wire [ 2:0] regb_trig_chbw;
  wire        regb_trig_nss_en;
  wire [ 2:0] regb_trig_nss;
  wire        regb_trig_sounding_en;
  wire        regb_trig_sounding;
  wire        regb_trig_paid_en;
  wire [ 8:0] regb_trig_paid;
  wire        regb_trig_gid_en;
  wire [ 5:0] regb_trig_gid;
  wire        regb_trig_smoothing_en;
  wire        regb_trig_smoothing;
  wire [ 3:0] regb_trigger0;
  wire [ 3:0] regb_trigger1;
  
  /*****************************************************************************
  * mux
  *****************************************************************************/
  /* bypass multiplexer */
  always @(*)
  begin
    if(!regb_bypass)
    begin
      mpifo_txreq             = mpifi_txreq;
      mpifo_txdata            = mpifi_txdata;
      mpifo_macdatavalid      = mpifi_macdatavalid;
      mpifo_mimocmdvalid      = mpifi_mimocmdvalid;
      mpifo_rxreq             = mpifi_rxreq;
      mpifo_keeprfon          = mpifi_keeprfon;
      
      mpifi_phyrdy            = mpifo_phyrdy;
      mpifi_txend             = mpifo_txend; 
      mpifi_rxdata            = mpifo_rxdata;
      mpifi_cca_pri20         = mpifo_cca_pri20; 
      mpifi_cca_sec20         = mpifo_cca_sec20; 
      mpifi_cca_sec40         = mpifo_cca_sec40; 
      mpifi_rxendfortiming    = mpifo_rxendfortiming;
      mpifi_rxerr             = mpifo_rxerr; 
      mpifi_rxend             = mpifo_rxend; 
      mpifi_phyerr            = mpifo_phyerr;
      mpifi_rifsrxdetected    = mpifo_rifsrxdetected; 
    end      
    else     
    begin    
      mpifo_txreq             = fsm_txreq;
      mpifo_rxreq             = fsm_rxreq;
      if(!txv_done)
      begin
        mpifo_macdatavalid = txv_valid;
        mpifo_txdata       = txv_data;
      end
      else
      begin
        mpifo_macdatavalid = pldgen_valid;
        mpifo_txdata       = pldgen_data;
      end
      mpifo_mimocmdvalid      = 1'b0;
      mpifo_keeprfon          = regb_defkeeprfon;
      mpifi_phyrdy            = 1'b0;
      mpifi_txend             = 1'b0; 
      mpifi_rxdata            = 8'b0;
      mpifi_cca_pri20         = 1'b0; 
      mpifi_cca_sec20         = 1'b0; 
      mpifi_cca_sec40         = 1'b0; 
      mpifi_rxendfortiming    = 1'b0;
      mpifi_rxerr             = 1'b0; 
      mpifi_rxend             = 1'b0; 
      mpifi_phyerr            = 1'b0;
      mpifi_rifsrxdetected    = 1'b0; 
    end
  end
  
  /*****************************************************************************
  * ahb slave
  *****************************************************************************/
  ClkSyncSimple u_ack_resync
  ( 
    .dstclk(                     ahb_clk),
    .dstresetn(                  ahb_rst_n),
    .srcdata(                    ahbif_ack),   
    .dstdata(                    ahbif_ack_resync)  
  );
  
  rw_nx_macbypass_ahbif u_ahbif
  (
    /* system */
    .clk(                        ahb_clk),
    .rst_n(                      ahb_rst_n),
    
    .mpif_clken(                 mpif_clken),
    
    /* ahb */
    .hready_in(                  hready_in), 
    .hsel(                       hsel),      
    .haddr(                      haddr),     
    .htrans(                     htrans),    
    .hwrite(                     hwrite),    
    .hwdata(                     hwdata),    
    .hrdata(                     hrdata),    
    .hresp(                      hresp),     
    .hready(                     hready),
    
    /* regb */
    .regb_req(                   ahbif_req),
    .regb_wr(                    ahbif_wr),
    .regb_addr(                  ahbif_addr),
    .regb_wdata(                 ahbif_wdata),
    .regb_rdata(                 ahbif_rdata),
    .regb_ack(                   ahbif_ack_resync)  
  );
 
  /*****************************************************************************
  * register bank
  *****************************************************************************/
  ClkSyncSimple u_req_resync
  ( 
    .dstclk(                     mpif_clk),
    .dstresetn(                  mpif_rst_n),
    .srcdata(                    ahbif_req),   
    .dstdata(                    ahbif_req_resync)   
  );
 
  rw_nx_macbypass_regbank u_regbank
  (
    /* system */
    .rst_n(                      mpif_rst_n),  
    .clk(                        mpif_clk),  

    /* async bus */
    .ahbif_req(                  ahbif_req_resync),
    .ahbif_wr(                   ahbif_wr),
    .ahbif_addr(                 ahbif_addr),
    .ahbif_wdata(                ahbif_wdata),
    .ahbif_rdata(                ahbif_rdata),
    .ahbif_ack(                  ahbif_ack),
  
    /* stat */
    .stat_frame_ok(              stat_frame_ok),
    .stat_frame_bad(             stat_frame_bad),
    .stat_rxend(                 stat_rxend),
    .stat_rxerr(                 stat_rxerr),
    .stat_phyerr(                stat_phyerr),
    .stat_rssi(                  8'd0),
    .stat_evm(                   8'd0),
 
    /* event */
    .event_tx_eof(               event_tx_eof),
   
    /* rxv */
    .rxv_locked(                 rxvl_locked),
    .rxv0(                       rxvl_0),
    .rxv1(                       rxvl_1),
    .rxv2(                       rxvl_2),
    .rxv3(                       rxvl_3),
    .rxv4(                       rxvl_4),
    .rxv5(                       rxvl_5),
    .rxv6(                       rxvl_6),
    .rxv7(                       rxvl_7),
    .rxv8(                       rxvl_8),
    .rxv9(                       rxvl_9),
    .rxv10(                      rxvl_10),
    .rxv11(                      rxvl_11),
    .rxv12(                      rxvl_12),
    .rxv13(                      rxvl_13),
    .rxv14(                      rxvl_14),
    .rxv15(                      rxvl_15),
  
    /* int */
    .int0_raw(                   int0_raw),
    .int1_raw(                   int1_raw),
    .int2_raw(                   int2_raw),
    .int3_raw(                   int3_raw),  
    
    /* registres */
    /* CTRL */
    .regb_bypass(                regb_bypass),
    .regb_defkeeprfon(           regb_defkeeprfon),
    .regb_defrxreq(              regb_defrxreq),
    .regb_mode_is_rxlisten(      regb_mode_is_rxlisten),   
    .regb_mode_is_txsingle(      regb_mode_is_txsingle),   
    .regb_mode_is_txburst(       regb_mode_is_txburst),    
    .regb_stat_clear(            regb_stat_clear),         
    /* PAYLOAD */
    .regb_pld_type_rx(           regb_pld_type_rx),        
    .regb_pld_type_tx(           regb_pld_type_tx),        
    /* FRAMEPERBURST */
    .regb_frameperburst(         regb_frameperburst),      
    /* INTERFRAME_DELAY */
    .regb_interframe_delay(      regb_interframe_delay),   
    /* INT_CTRL */
    .regb_intrxvlock_en(         regb_intrxvlock_en),    
    .regb_int3_en(               regb_int3_en),            
    .regb_int2_en(               regb_int2_en),            
    .regb_int1_en(               regb_int1_en),            
    .regb_int0_en(               regb_int0_en),            
    /* INT_GEN */
    .regb_int3_gen(              regb_int3_gen),           
    .regb_int2_gen(              regb_int2_gen),           
    .regb_int1_gen(              regb_int1_gen),           
    .regb_int0_gen(              regb_int0_gen),           
    /* INT_ACK */
    .regb_intrxvlock_ack(        regb_intrxvlock_ack),   
    .regb_int0_ack(              regb_int0_ack),        
    .regb_int1_ack(              regb_int1_ack),        
    .regb_int2_ack(              regb_int2_ack),        
    .regb_int3_ack(              regb_int3_ack),        
    /* TRIGGER */
    .regb_trig_format_en(        regb_trig_format_en),     
    .regb_trig_format(           regb_trig_format),        
    .regb_trig_mcs_en(           regb_trig_mcs_en),        
    .regb_trig_mcs(              regb_trig_mcs),           
    .regb_trig_gitype_en(        regb_trig_gitype_en),        
    .regb_trig_gitype(           regb_trig_gitype),           
    .regb_trig_fec_en(           regb_trig_fec_en),        
    .regb_trig_fec(              regb_trig_fec),           
    .regb_trig_stbc_en(          regb_trig_stbc_en),       
    .regb_trig_stbc(             regb_trig_stbc),          
    .regb_trig_chbw_en(          regb_trig_chbw_en),       
    .regb_trig_chbw(             regb_trig_chbw),          
    .regb_trig_nss_en(           regb_trig_nss_en),       
    .regb_trig_nss(              regb_trig_nss),          
    .regb_trig_sounding_en(      regb_trig_sounding_en),   
    .regb_trig_sounding(         regb_trig_sounding),      
    .regb_trig_paid_en(          regb_trig_paid_en),
    .regb_trig_paid(             regb_trig_paid),
    .regb_trig_gid_en(           regb_trig_gid_en),
    .regb_trig_gid(              regb_trig_gid),
    .regb_trig_smoothing_en(     regb_trig_smoothing_en),
    .regb_trig_smoothing(        regb_trig_smoothing),
    /* trigger */
    .regb_trigger0(              regb_trigger0),
    .regb_trigger1(              regb_trigger1),
    /* TXV */
    .regb_txv0(                  txv0),
    .regb_txv1(                  txv1),
    .regb_txv2(                  txv2),
    .regb_txv3(                  txv3),
    .regb_txv4(                  txv4),
    .regb_txv5(                  txv5),
    .regb_txv6(                  txv6),
    .regb_txv7(                  txv7),
    .regb_txv8(                  txv8),
    .regb_txv9(                  txv9),
    .regb_txv10(                 txv10),
    .regb_txv11(                 txv11),
    .regb_txv12(                 txv12),
    .regb_txv13(                 txv13),
    .regb_txv14(                 txv14),
    .regb_txv15(                 txv15),
    .regb_txv16(                 txv16),
    .regb_txv17(                 txv17),
    .regb_txv18(                 txv18),
    .regb_txv19(                 txv19),
    .regb_txv20(                 txv20),
    .regb_txv21(                 txv21),
    .regb_txv22(                 txv22),
    .regb_txv23(                 txv23),
    .regb_txv24(                 txv24),
    .regb_txv25(                 txv25)
  );

  /*****************************************************************************
  * status
  *****************************************************************************/
  rw_nx_macbypass_stat u_stat
  (
    /* system */
    .clk(                        mpif_clk),
    .rst_n(                      mpif_rst_n),
    
    /* control */
    .clear(                      regb_stat_clear),
    .incr_frame_ok(              event_rx_fcs_ok),
    .incr_frame_bad(             event_rx_fcs_bad),
    .incr_rxerr(                 event_rx_rxerr),
    .incr_rxend(                 event_rx_rxend),
    .incr_phyerr(                event_tx_phyerr),

    /* counters */
    .stat_frame_ok(              stat_frame_ok),
    .stat_frame_bad(             stat_frame_bad),
    .stat_rxerr(                 stat_rxerr),
    .stat_rxend(                 stat_rxend),
    .stat_phyerr(                stat_phyerr)
  );
  
  /*****************************************************************************
  * rxv
  *****************************************************************************/
  rw_nx_macbypass_rxv u_rxv
  (
    /* system */
    .clk(                        mpif_clk),
    .rst_n(                      mpif_rst_n),
  
    /* control */ 
    .rxreq(                      mpifo_rxreq),
    .rxend(                      mpifo_rxend),

    /* input data */ 
    .data(                       mpifo_rxdata),
    .last(                       pldtrck_last),
    .valid(                      mpifo_phyrdy),
    
    /* registres */
    .regb_intrxvlock_en(         regb_intrxvlock_en),
  
    /* decoded rxvector */
    .rxvu1_last(                 rxvu1_last),
    .rxvu2_last(                 rxvu2_last),
    .rxvu1_captured(             rxvu1_captured),
    .rxvu2_captured(             rxvu2_captured),
    .rxvu_format(                rxvu_format),
    .rxvu_length(                rxvu_length),
    .rxvu_l_length(              rxvu_l_length),
    .rxvu_mcs(                   rxvu_mcs),
    .rxvu_gi_type(               rxvu_gi_type),
    .rxvu_fec(                   rxvu_fec),
    .rxvu_stbc(                  rxvu_stbc),
    .rxvu_chbw(                  rxvu_chbw),
    .rxvu_nss(                   rxvu_nss),
    .rxvu_sounding(              rxvu_sounding),
    .rxvu_paid(                  rxvu_paid),
    .rxvu_gid(                   rxvu_gid),
    .rxvu_smoothing(             rxvu_smoothing),
    .rxvu_beamformed(            rxvu_beamformed),
    .rxvu_aggregation(           rxvu_aggregation),
    .rxvu_ndp(                   rxvu_ndp),
   
    /* undecoded rxvector */
    .rxvl_clear(                 regb_intrxvlock_ack),
    .rxvl_locked(                rxvl_locked),
    .rxvl_0(                     rxvl_0),
    .rxvl_1(                     rxvl_1),
    .rxvl_2(                     rxvl_2),
    .rxvl_3(                     rxvl_3),
    .rxvl_4(                     rxvl_4),
    .rxvl_5(                     rxvl_5),
    .rxvl_6(                     rxvl_6),
    .rxvl_7(                     rxvl_7),
    .rxvl_8(                     rxvl_8),
    .rxvl_9(                     rxvl_9),
    .rxvl_10(                    rxvl_10),
    .rxvl_11(                    rxvl_11),
    .rxvl_12(                    rxvl_12),
    .rxvl_13(                    rxvl_13),
    .rxvl_14(                    rxvl_14),
    .rxvl_15(                    rxvl_15),
    
    /* event */
    .event_rxvl_locked(          event_rxvl_locked)
  );
  
  /*****************************************************************************
  * txv
  *****************************************************************************/
  rw_nx_macbypass_txv u_txv
  (
    /* system */
    .clk(                        mpif_clk),
    .rst_n(                      mpif_rst_n),
    
    /* control */
    .txreq(                      mpifo_txreq),
    .done(                       txv_done),
    
    /* input txv */
    .txv0(                       txv0),
    .txv1(                       txv1),
    .txv2(                       txv2),
    .txv3(                       txv3),
    .txv4(                       txv4),
    .txv5(                       txv5),
    .txv6(                       txv6),
    .txv7(                       txv7),
    .txv8(                       txv8),
    .txv9(                       txv9),
    .txv10(                      txv10),
    .txv11(                      txv11),
    .txv12(                      txv12),
    .txv13(                      txv13),
    .txv14(                      txv14),
    .txv15(                      txv15),
    .txv16(                      txv16),
    .txv17(                      txv17),
    .txv18(                      txv18),
    .txv19(                      txv19),
    .txv20(                      txv20),
    .txv21(                      txv21),
    .txv22(                      txv22),
    .txv23(                      txv23),
    .txv24(                      txv24),
    .txv25(                      txv25),
    
    /* output txv decoded */
    .txv_format(                 txv_format),
    .txv_length(                 txv_length),
    .txv_aggregation(            txv_aggregation),
    
    /* output data */
    .data(                       txv_data),
    .last(                       txv_last),
    .valid(                      txv_valid)
  );
 
  /*****************************************************************************
  * payload tracking
  *****************************************************************************/
  rw_nx_macbypass_payload_tracking u_payload_tracking
  (
    .clk(                        mpif_clk),
    .rst_n(                      mpif_rst_n),
    .enable(                     pldtrck_enable),
    .format(                     rxvu_format),
    .aggregation(                rxvu_aggregation),
    .length(                     rxvu_length),
    .data(                       mpifo_rxdata),
    .valid(                      mpifo_phyrdy),
    .last(                       pldtrck_last),
    .event_fcs_update(           event_rx_fcs_update),
    .event_fcs_ok(               event_rx_fcs_ok),
    .event_fcs_bad(              event_rx_fcs_bad),
    .event_delimiter_lost(       event_rx_delimiter_lost)
  );

  /*****************************************************************************
  * payload generation
  *****************************************************************************/
  rw_nx_macbypass_payload_generator u_payload_generator
  (
    .clk(                        mpif_clk),
    .rst_n(                      mpif_rst_n),
    .enable(                     pldgen_enable),
    .pldtype(                    regb_pld_type_tx),
    .format(                     txv_format),
    .aggregation(                txv_aggregation),
    .length(                     txv_length),
    .done(                       pldgen_done),
    .ready(                      mpifo_phyrdy),
    .data(                       pldgen_data),
    .valid(                      pldgen_valid)
  );
  
  /*****************************************************************************
  * fsm
  *****************************************************************************/
  rw_nx_macbypass_fsm u_fsm
  ( 
    /* system */
    .rst_n(                      mpif_rst_n), 
    .clk(                        mpif_clk),  

    /* mac mpif */
    .mpifi_rxreq(                mpifi_rxreq),
  
    /* phy mpif */
    .rxreq(                      fsm_rxreq),
    .txreq(                      fsm_txreq),
    
    .mpifo_phyrdy(               mpifo_phyrdy),   
    .mpifo_rxendfortiming(       mpifo_rxendfortiming),
    .mpifo_rxend(                mpifo_rxend),
    .mpifo_rxerr(                mpifo_rxerr),
    .mpifo_phyerr(               mpifo_phyerr),
    .mpifo_txend(                mpifo_txend),
  
    /* regb */
    .regb_bypass(                regb_bypass),
    .regb_mode_is_rxlisten(      regb_mode_is_rxlisten),
    .regb_mode_is_txsingle(      regb_mode_is_txsingle),
    .regb_mode_is_txburst(       regb_mode_is_txburst),
    .regb_defrxreq(              regb_defrxreq),
    .regb_defkeeprfon(           regb_defkeeprfon),
    .regb_interframe_delay(      regb_interframe_delay),
    .regb_frameperburst(         regb_frameperburst),
  
    /* rxv */
    .rxvu_ndp(                   rxvu_ndp),
    .rxvu1_last(                 rxvu1_last),
    .rxvu2_last(                 rxvu2_last),
  
    /* payload tracking */
    .pldtrck_enable(             pldtrck_enable),
    .pldtrck_last(               pldtrck_last),
  
    /* txv */
    .txv_last(                   txv_last),
  
    /* payload generator */
    .pldgen_enable(              pldgen_enable),
    .pldgen_done(                pldgen_done),
  
    /* event signaling */
    .event_tx_phyerr(            event_tx_phyerr),
    .event_tx_eof(               event_tx_eof),
    .event_rx_eof_abort(         event_rx_eof_abort),
    .event_rx_eof_normal(        event_rx_eof_normal),
    .event_rx_rxerr(             event_rx_rxerr),
    .event_rx_rxend(             event_rx_rxend),
    .event_rxv_unsupported(      event_rxv_unsupported),
    .event_rxv_supported(        event_rxv_supported)
  );

  /*****************************************************************************
  * stat
  *****************************************************************************/
 
  /*****************************************************************************
  * int
  *****************************************************************************/
  wire interrupt_presync;
  ClkSyncSimple u_interrupt_resync
  ( 
    .dstclk(                     ahb_clk),
    .dstresetn(                  ahb_rst_n),
    .srcdata(                    interrupt_presync),   
    .dstdata(                    interrupt)  
  );
  
  rw_nx_macbypass_interrupt u_interrupt
  (
    /* system */
    .rst_n(                      mpif_rst_n),  
    .clk(                        mpif_clk),  

    /* interrupt */
    .interrupt(                  interrupt_presync),
  
    /* registers */
    .regb_int0_en(               regb_int0_en),
    .regb_int1_en(               regb_int1_en),
    .regb_int2_en(               regb_int2_en),
    .regb_int3_en(               regb_int3_en),
    .regb_int0_ack(              regb_int0_ack),
    .regb_int1_ack(              regb_int1_ack),
    .regb_int2_ack(              regb_int2_ack),
    .regb_int3_ack(              regb_int3_ack),
    .regb_int0_gen(              regb_int0_gen),
    .regb_int1_gen(              regb_int1_gen),
    .regb_int2_gen(              regb_int2_gen),
    .regb_int3_gen(              regb_int3_gen),
  
    .int0_raw(                   int0_raw),
    .int1_raw(                   int1_raw),
    .int2_raw(                   int2_raw),
    .int3_raw(                   int3_raw),

    /* event */
    .event_tx_phyerr(            event_tx_phyerr),
    .event_tx_eof(               event_tx_eof),
    .event_rx_eof_abort(         event_rx_eof_abort),
    .event_rx_eof_normal(        event_rx_eof_normal),
    .event_rx_rxerr(             event_rx_rxerr),
    .event_rx_rxend(             event_rx_rxend),
    .event_rxv_unsupported(      event_rxv_unsupported),
    .event_rxv_supported(        event_rxv_supported),
    .event_rxv_locked(           event_rxvl_locked),
    .event_trigger(              event_trigger),
    /* rxv */
    .rxv_captured(               rxvu1_captured),
    .rxv_format(                 rxvu_format),
    .rxv_mcs(                    rxvu_mcs),
    /* cca */
    .cca_pri20(                  mpifo_cca_pri20),
    .cca_sec20(                  mpifo_cca_sec20),
    .cca_sec40(                  mpifo_cca_sec40)
  );
 
  /*****************************************************************************
  * trigger
  *****************************************************************************/
  rw_nx_macbypass_trigger u_trigger
  (
    /* system */
    .rst_n(                      mpif_rst_n),  
    .clk(                        mpif_clk), 

    /* registres */
    .regb_trig_format_en(        regb_trig_format_en),     
    .regb_trig_format(           regb_trig_format),        
    .regb_trig_mcs_en(           regb_trig_mcs_en),        
    .regb_trig_mcs(              regb_trig_mcs),           
    .regb_trig_gitype_en(        regb_trig_gitype_en),        
    .regb_trig_gitype(           regb_trig_gitype),           
    .regb_trig_fec_en(           regb_trig_fec_en),        
    .regb_trig_fec(              regb_trig_fec),           
    .regb_trig_stbc_en(          regb_trig_stbc_en),       
    .regb_trig_stbc(             regb_trig_stbc),          
    .regb_trig_chbw_en(          regb_trig_chbw_en),       
    .regb_trig_chbw(             regb_trig_chbw),          
    .regb_trig_nss_en(           regb_trig_nss_en),       
    .regb_trig_nss(              regb_trig_nss),          
    .regb_trig_sounding_en(      regb_trig_sounding_en),   
    .regb_trig_sounding(         regb_trig_sounding),      
    .regb_trig_paid_en(          regb_trig_paid_en),
    .regb_trig_paid(             regb_trig_paid),
    .regb_trig_gid_en(           regb_trig_gid_en),
    .regb_trig_gid(              regb_trig_gid),
    .regb_trig_smoothing_en(     regb_trig_smoothing_en),
    .regb_trig_smoothing(        regb_trig_smoothing),
    .regb_trigger0(              regb_trigger0),
    .regb_trigger1(              regb_trigger1),
    
    /* sources */
    .rxv_captured(               rxvu1_captured),
    .rxv_format(                 rxvu_format),
    .rxv_mcs(                    rxvu_mcs),
    .rxv_gitype(                 rxvu_gi_type),
    .rxv_fec(                    rxvu_fec),
    .rxv_stbc(                   rxvu_stbc),
    .rxv_chbw(                   rxvu_chbw),
    .rxv_nss(                    rxvu_nss),
    .rxv_sounding(               rxvu_sounding),
    .rxv_paid(                   rxvu_paid),
    .rxv_gid(                    rxvu_gid),
    .rxv_smoothing(              rxvu_smoothing),
    .interrupt(                  interrupt_presync),
    .event_rx_fcs_update(        event_rx_fcs_update),
    .event_rx_fcs_ok(            event_rx_fcs_ok),
    .event_rx_fcs_bad(           event_rx_fcs_bad),
    .event_rx_delimiter_lost(    event_rx_delimiter_lost),
    .event_rx_rxerr(             event_rx_rxerr),
    .event_rx_rxend(             event_rx_rxend),
    
    /* trigger */
    .event_trigger(              event_trigger),
    .trigger(                    trigger)
  );
  
 endmodule
`default_nettype wire
