/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author:$
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :             
* Description      : rw_nx_he_macbypass
* Simulation Notes :             
* Synthesis Notes  :              
* Application Note :              
* Simulator        :             
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*           
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module rw_nx_macbypass_ahbif
( 
  /* system */
  input  wire         rst_n, 
  input  wire         clk,  
  

  /*****************************************************************************
  * clock enable
  *****************************************************************************/
  output reg          mpif_clken,
 
  /*****************************************************************************
  * AHB
  *****************************************************************************/
  input  wire         hready_in, 
  input  wire         hsel,      
  input  wire [ 9:0]  haddr,     
  input  wire [ 1:0]  htrans,    
  input  wire         hwrite,    
  input  wire [31:0]  hwdata,    
  output reg  [31:0]  hrdata,    
  output wire [1:0]   hresp,     
  output reg          hready,    
  
  /*****************************************************************************
  * REGB
  *****************************************************************************/
  output reg          regb_req,       
  output reg          regb_wr,
  output reg  [ 9:0]  regb_addr,    
  output reg  [31:0]  regb_wdata,   
  input  wire [31:0]  regb_rdata,
  input  wire         regb_ack
);
  reg [ 9:0] timeout;
  reg [ 9:0] pending_addr;
  reg        pending_write;
  reg        regb_done;

  assign hresp = 2'b0;

  always @(posedge clk ,negedge rst_n)
  begin
    if(!rst_n)
    begin
      mpif_clken    <= 1'b0;
      
      timeout       <= 10'd0;
      hrdata        <= 32'd0;
      hready        <= 1'b1;
      
      pending_addr  <= 10'd0;
      pending_write <= 1'b0;
      
      regb_done     <= 1'b0;
      regb_req      <= 1'b0;   
      regb_wr       <= 1'b0; 
      regb_addr     <= 10'b0;    
      regb_wdata    <= 32'b0;        
    end
    else
    begin
      if(hready)
      begin
        regb_req  <= 1'b0;
        regb_done <= 1'b0;
        timeout   <= 10'd0;
        if(hready_in && hsel && htrans[1])
        begin
          hready        <= 1'b0;
          pending_addr  <= haddr;
          pending_write <= hwrite;
        end
      end
      else
      begin
        if(!regb_done)
        begin
          if(!regb_req)
          begin
            if(!regb_ack)
            begin
              case(pending_addr)
                10'h00c: /* REG_CLKEN */
                begin
                  hready <= 1'b1;
                  if(pending_write)
                    mpif_clken <= hwdata[0];
                  else
                    hrdata     <= {31'b0,mpif_clken};
                end
                10'h3fc: /* REG_VERSION */
                begin
                  hready <= 1'b1;
                  hrdata <= 32'h00010003;
                end
                default: /* OTHERS (MPIF CLK DOMAIN) */
                begin
                  regb_req  <= 1'b1;
                  regb_wr   <= pending_write;
                  regb_addr <= pending_addr; 
                  regb_wdata<= 32'h0;
                  if(pending_write)
                    regb_wdata <= hwdata;
                end
              endcase
            end
          end
          else
          begin
            if(regb_ack)
            begin
              regb_done <= 1'b1;
              regb_req  <= 1'b0;
            end
          end
        end
        else
        begin
          if(!regb_ack)
          begin
            regb_done <= 1'b0;
            hready    <= 1'b1;
            hrdata    <= 32'h0;
            if(!pending_write)
              hrdata <= regb_rdata;
          end
        end
        /* timeout protection */
        timeout <= timeout + 10'd1;
        if(timeout==10'h3ff)
        begin
          hready    <= 1'b1;
          hrdata    <= 32'hdead0f0f;
          regb_req  <= 1'b0;
          regb_done <= 1'b0;
        end
      end
    end
  end

endmodule
`default_nettype wire    

