/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : mpif_payload_generator
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module rw_nx_macbypass_fcs32
(
  input  wire         clk,
  input  wire         rst_n,
  
  input  wire         enable,
  output wire         done,
  output wire  [31:0] fcs,

  input  wire  [ 7:0] data,
  input  wire         last,
  input  wire         valid
);
  /*****************************************************************************
  * declaration
  *****************************************************************************/
  localparam INIT = 2'd0,
             DATA = 2'd1,
             PAD  = 2'd2,
             DONE = 2'd3;
  
  reg  [31:0]  fcs32;
  reg  [31:0]  n_fcs32;
  reg  [ 1:0]  state;
  reg  [ 1:0]  count;
  wire [ 1:0]  n_count;
  wire [ 7:0]  natad;
  
  assign natad = ~{data[0],data[1],data[2],data[3],data[4],data[5],data[6],data[7]};
  
  always @(*)
  begin:b_fcs32_calc
    integer   i;
    reg [7:0] t;
 
    /* FCS p498 8.2.4.8 */
    n_fcs32 = fcs32;
    t       = (state==DATA)?data:8'b0;
    for(i=0;i<8;i=i+1)
      n_fcs32 = {n_fcs32[30:0],t[i]}^(n_fcs32[31]?32'h04c11db7:32'd0);
    
  end
  
  assign fcs = 
    ~{fcs32[24],fcs32[25],fcs32[26],fcs32[27],fcs32[28],fcs32[29],fcs32[30],fcs32[31],
      fcs32[16],fcs32[17],fcs32[18],fcs32[19],fcs32[20],fcs32[21],fcs32[22],fcs32[23],
      fcs32[ 8],fcs32[ 9],fcs32[10],fcs32[11],fcs32[12],fcs32[13],fcs32[14],fcs32[15],
      fcs32[ 0],fcs32[ 1],fcs32[ 2],fcs32[ 3],fcs32[ 4],fcs32[ 5],fcs32[ 6],fcs32[ 7]};
 
  assign done    = state==DONE;
  assign n_count = count + 2'd1;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      fcs32 <= 32'd0;
      count <= 2'd0;
      state <= INIT;
    end
    else if(!enable)
    begin
      fcs32 <= 32'd0;
      count <= 2'd0;
      state <= INIT;
    end
    else
    begin
      case(state)
        INIT:
        begin
          if(valid)
          begin
            fcs32    <= {fcs32[23:0],natad};
            count    <= n_count;
            if(count==2'd3)
              state <= DATA;
          end
        end
        DATA:
        begin
          if(valid)
          begin
            fcs32 <= n_fcs32;
            if(last)
              state <= PAD;
          end
        end
        PAD:
        begin
          fcs32 <= n_fcs32;
          count <= n_count;
          if(count==2'd3)
          begin
            state <= DONE;
          end
        end
        DONE: ;
      endcase
    end
  end
  
 
`ifdef RW_SIMU_ON
  reg [16*8-1:0] str_state;
  always @(*)
    case(state)
      INIT:    str_state = "INIT";
      DATA:    str_state = "DATA";
      PAD:     str_state = "PAD";
      DONE:    str_state = "DONE";
      default: str_state = "XXXXXX";
    endcase
`endif
  
  
endmodule
`default_nettype wire 

