/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author:$
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :             
* Description      : rw_nx_he_macbypass
* Simulation Notes :             
* Synthesis Notes  :              
* Application Note :              
* Simulator        :             
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*           
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module rw_nx_macbypass_interrupt
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire          rst_n,  
  input  wire          clk,  

  /*****************************************************************************
  * interrupt
  *****************************************************************************/
  output reg           interrupt,
  
  /*****************************************************************************
  * registers
  *****************************************************************************/
  input  wire          regb_int0_en,
  input  wire          regb_int1_en,
  input  wire          regb_int2_en,
  input  wire          regb_int3_en,
  input  wire          regb_int0_ack,
  input  wire          regb_int1_ack,
  input  wire          regb_int2_ack,
  input  wire          regb_int3_ack,
  input  wire  [ 7:0]  regb_int0_gen,
  input  wire  [ 7:0]  regb_int1_gen,
  input  wire  [ 7:0]  regb_int2_gen,
  input  wire  [ 7:0]  regb_int3_gen,
  
  output reg           int0_raw,
  output reg           int1_raw,
  output reg           int2_raw,
  output reg           int3_raw,

  /*****************************************************************************
  * sources
  *****************************************************************************/
  /* event */
  input  wire          event_tx_phyerr,
  input  wire          event_tx_eof,
  input  wire          event_rx_eof_abort,
  input  wire          event_rx_eof_normal,
  input  wire          event_rx_rxerr,
  input  wire          event_rx_rxend,
  input  wire          event_rxv_unsupported,
  input  wire          event_rxv_supported,
  input  wire          event_rxv_locked,
  input  wire   [ 1:0] event_trigger,
  /* rxv */
  input  wire          rxv_captured,
  input  wire   [ 3:0] rxv_format,
  input  wire   [ 6:0] rxv_mcs,
  /* cca */
  input  wire          cca_pri20,
  input  wire          cca_sec20,
  input  wire          cca_sec40
);
 
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  localparam NON_HT     = 4'd0,
             NON_HT_DUP = 4'd1,
             HT_MM      = 4'd2,
             HT_GF      = 4'd3,
             VHT        = 4'd4,
             HE_SU      = 4'd5,
             HE_MU      = 4'd6,
             HE_ER_SU   = 4'd7,
             HE_TB      = 4'd8;
 
  reg   cca_pri20_1t,cca_pri20_2t;
  reg   cca_sec20_1t,cca_sec20_2t;
  reg   cca_sec40_1t,cca_sec40_2t;
  
  wire  int0,     int1,     int2,     int3;
  wire  int0_set, int1_set, int2_set, int3_set;
  
  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      /* edge detector */
      cca_pri20_1t      <= 1'b0;
      cca_pri20_2t <= 1'b0;
      cca_sec20_1t <= 1'b0;
      cca_sec20_2t <= 1'b0;
      cca_sec40_1t <= 1'b0;
      cca_sec40_2t <= 1'b0;
      /* interrupt */
      interrupt    <= 1'b0;
      int0_raw     <= 1'b0;
      int1_raw     <= 1'b0;
      int2_raw     <= 1'b0;
      int3_raw     <= 1'b0;
    end
    else
    begin
      /* edge detector */
      cca_pri20_1t <= cca_pri20;
      cca_pri20_2t <= cca_pri20_1t;
      cca_sec20_1t <= cca_sec20;
      cca_sec20_2t <= cca_sec20_1t;
      cca_sec40_1t <= cca_sec40;
      cca_sec40_2t <= cca_sec40_1t;
      /* interrupt */
      interrupt    <= int0|int1|int2|int3;
      int0_raw     <= ~regb_int0_ack & (int0_raw | int0_set);
      int1_raw     <= ~regb_int1_ack & (int1_raw | int1_set);
      int2_raw     <= ~regb_int2_ack & (int2_raw | int2_set);
      int3_raw     <= ~regb_int3_ack & (int3_raw | int3_set);
    end
  end

  /* enable interrupt source */
  assign int0 = int0_raw & regb_int0_en;
  assign int1 = int1_raw & regb_int1_en;
  assign int2 = int2_raw & regb_int2_en;
  assign int3 = int3_raw & regb_int3_en;
  
  assign int0_set =
    regb_int0_gen[ 7: 6]==2'd2 & regb_int0_gen[    5] & event_rxv_unsupported |   
    regb_int0_gen[ 7: 6]==2'd2 & regb_int0_gen[    4] & event_rxv_supported   |       
    regb_int0_gen[ 7: 6]==2'd2 & regb_int0_gen[    3] & rxv_captured & rxv_format==VHT  |       
    regb_int0_gen[ 7: 6]==2'd2 & regb_int0_gen[    2] & rxv_captured & (rxv_format==HT_MM  | rxv_format[2:0]==HT_GF) |
    regb_int0_gen[ 7: 6]==2'd2 & regb_int0_gen[    1] & rxv_captured & (rxv_format==NON_HT | rxv_format[2:0]==NON_HT_DUP) &  rxv_mcs[3] |  
    regb_int0_gen[ 7: 6]==2'd2 & regb_int0_gen[    0] & rxv_captured & (rxv_format==NON_HT | rxv_format[2:0]==NON_HT_DUP) & ~rxv_mcs[3] |   
    regb_int0_gen[ 7: 6]==2'd3 & regb_int0_gen[ 2: 0]==3'd0 & regb_int0_gen[ 4] & ~cca_pri20_1t &  cca_pri20_2t |
    regb_int0_gen[ 7: 6]==2'd3 & regb_int0_gen[ 2: 0]==3'd0 & regb_int0_gen[ 5] &  cca_pri20_1t & ~cca_pri20_2t | 
    regb_int0_gen[ 7: 6]==2'd3 & regb_int0_gen[ 2: 0]==3'd1 & regb_int0_gen[ 4] & ~cca_sec20_1t &  cca_sec20_2t |
    regb_int0_gen[ 7: 6]==2'd3 & regb_int0_gen[ 2: 0]==3'd1 & regb_int0_gen[ 5] &  cca_sec20_1t & ~cca_sec20_2t | 
    regb_int0_gen[ 7: 6]==2'd3 & regb_int0_gen[ 2: 0]==3'd2 & regb_int0_gen[ 4] & ~cca_sec40_1t &  cca_sec40_2t |
    regb_int0_gen[ 7: 6]==2'd3 & regb_int0_gen[ 2: 0]==3'd2 & regb_int0_gen[ 5] &  cca_sec40_1t & ~cca_sec40_2t |
    regb_int0_gen[    7]==1'b0 & regb_int0_gen[ 6: 0]==7'd1 & event_trigger[0] |
    regb_int0_gen[    7]==1'b0 & regb_int0_gen[ 6: 0]==7'd2 & event_trigger[1] |
    regb_int0_gen[    7]==1'b0 & regb_int0_gen[ 6: 0]==7'd3 & event_rx_eof_normal |
    regb_int0_gen[    7]==1'b0 & regb_int0_gen[ 6: 0]==7'd4 & event_rx_eof_abort  |
    regb_int0_gen[    7]==1'b0 & regb_int0_gen[ 6: 0]==7'd5 & event_tx_eof        |
    regb_int0_gen[    7]==1'b0 & regb_int0_gen[ 6: 0]==7'd6 & event_tx_phyerr     |
    regb_int0_gen[    7]==1'b0 & regb_int0_gen[ 6: 0]==7'd7 & event_rxv_unsupported |
    regb_int0_gen[    7]==1'b0 & regb_int0_gen[ 6: 0]==7'd8 & event_rxv_supported   | 
    regb_int0_gen[    7]==1'b0 & regb_int0_gen[ 6: 0]==7'd9 & event_rxv_locked;
 
  assign int1_set =
    regb_int1_gen[ 7: 6]==2'd2 & regb_int1_gen[    5] & event_rxv_unsupported |   
    regb_int1_gen[ 7: 6]==2'd2 & regb_int1_gen[    4] & event_rxv_supported   |   
    regb_int1_gen[ 7: 6]==2'd2 & regb_int1_gen[    3] & rxv_captured & rxv_format==VHT  |       
    regb_int1_gen[ 7: 6]==2'd2 & regb_int1_gen[    2] & rxv_captured & (rxv_format==HT_MM  | rxv_format[2:0]==HT_GF) |
    regb_int1_gen[ 7: 6]==2'd2 & regb_int1_gen[    1] & rxv_captured & (rxv_format==NON_HT | rxv_format[2:0]==NON_HT_DUP) &  rxv_mcs[3] |
    regb_int1_gen[ 7: 6]==2'd2 & regb_int1_gen[    0] & rxv_captured & (rxv_format==NON_HT | rxv_format[2:0]==NON_HT_DUP) & ~rxv_mcs[3] |
    regb_int1_gen[ 7: 6]==2'd3 & regb_int1_gen[ 2: 0]==3'd0 & regb_int1_gen[ 4] & ~cca_pri20_1t &  cca_pri20_2t |
    regb_int1_gen[ 7: 6]==2'd3 & regb_int1_gen[ 2: 0]==3'd0 & regb_int1_gen[ 5] &  cca_pri20_1t & ~cca_pri20_2t |
    regb_int1_gen[ 7: 6]==2'd3 & regb_int1_gen[ 2: 0]==3'd1 & regb_int1_gen[ 4] & ~cca_sec20_1t &  cca_sec20_2t |
    regb_int1_gen[ 7: 6]==2'd3 & regb_int1_gen[ 2: 0]==3'd1 & regb_int1_gen[ 5] &  cca_sec20_1t & ~cca_sec20_2t |
    regb_int1_gen[ 7: 6]==2'd3 & regb_int1_gen[ 2: 0]==3'd2 & regb_int1_gen[ 4] & ~cca_sec40_1t &  cca_sec40_2t |
    regb_int1_gen[ 7: 6]==2'd3 & regb_int1_gen[ 2: 0]==3'd2 & regb_int1_gen[ 5] &  cca_sec40_1t & ~cca_sec40_2t |
    regb_int1_gen[    7]==1'b0 & regb_int1_gen[ 6: 0]==7'd1 & event_trigger[0] |
    regb_int1_gen[    7]==1'b0 & regb_int1_gen[ 6: 0]==7'd2 & event_trigger[1] |
    regb_int1_gen[    7]==1'b0 & regb_int1_gen[ 6: 0]==7'd3 & event_rx_eof_normal |
    regb_int1_gen[    7]==1'b0 & regb_int1_gen[ 6: 0]==7'd4 & event_rx_eof_abort  |
    regb_int1_gen[    7]==1'b0 & regb_int1_gen[ 6: 0]==7'd5 & event_tx_eof        |
    regb_int1_gen[    7]==1'b0 & regb_int1_gen[ 6: 0]==7'd6 & event_tx_phyerr     |
    regb_int1_gen[    7]==1'b0 & regb_int1_gen[ 6: 0]==7'd7 & event_rxv_unsupported |
    regb_int1_gen[    7]==1'b0 & regb_int1_gen[ 6: 0]==7'd8 & event_rxv_supported   | 
    regb_int1_gen[    7]==1'b0 & regb_int1_gen[ 6: 0]==7'd9 & event_rxv_locked;

  assign int2_set =
    regb_int2_gen[ 7: 6]==2'd2 & regb_int2_gen[    5] & event_rxv_unsupported |   
    regb_int2_gen[ 7: 6]==2'd2 & regb_int2_gen[    4] & event_rxv_supported   |                        
    regb_int2_gen[ 7: 6]==2'd2 & regb_int2_gen[    3] & rxv_captured & rxv_format==VHT  |       
    regb_int2_gen[ 7: 6]==2'd2 & regb_int2_gen[    2] & rxv_captured & (rxv_format==HT_MM  | rxv_format[2:0]==HT_GF) |
    regb_int2_gen[ 7: 6]==2'd2 & regb_int2_gen[    1] & rxv_captured & (rxv_format==NON_HT | rxv_format[2:0]==NON_HT_DUP) &  rxv_mcs[3] |
    regb_int2_gen[ 7: 6]==2'd2 & regb_int2_gen[    0] & rxv_captured & (rxv_format==NON_HT | rxv_format[2:0]==NON_HT_DUP) & ~rxv_mcs[3] |
    regb_int2_gen[ 7: 6]==2'd3 & regb_int2_gen[ 2: 0]==3'd0 & regb_int2_gen[ 4] & ~cca_pri20_1t &  cca_pri20_2t |
    regb_int2_gen[ 7: 6]==2'd3 & regb_int2_gen[ 2: 0]==3'd0 & regb_int2_gen[ 5] &  cca_pri20_1t & ~cca_pri20_2t |
    regb_int2_gen[ 7: 6]==2'd3 & regb_int2_gen[ 2: 0]==3'd1 & regb_int2_gen[ 4] & ~cca_sec20_1t &  cca_sec20_2t |
    regb_int2_gen[ 7: 6]==2'd3 & regb_int2_gen[ 2: 0]==3'd1 & regb_int2_gen[ 5] &  cca_sec20_1t & ~cca_sec20_2t |
    regb_int2_gen[ 7: 6]==2'd3 & regb_int2_gen[ 2: 0]==3'd2 & regb_int2_gen[ 4] & ~cca_sec40_1t &  cca_sec40_2t |
    regb_int2_gen[ 7: 6]==2'd3 & regb_int2_gen[ 2: 0]==3'd2 & regb_int2_gen[ 5] &  cca_sec40_1t & ~cca_sec40_2t |
    regb_int2_gen[    7]==1'b0 & regb_int2_gen[ 6: 0]==7'd1 & event_trigger[0] |
    regb_int2_gen[    7]==1'b0 & regb_int2_gen[ 6: 0]==7'd2 & event_trigger[1] |
    regb_int2_gen[    7]==1'b0 & regb_int2_gen[ 6: 0]==7'd3 & event_rx_eof_normal |
    regb_int2_gen[    7]==1'b0 & regb_int2_gen[ 6: 0]==7'd4 & event_rx_eof_abort  |
    regb_int2_gen[    7]==1'b0 & regb_int2_gen[ 6: 0]==7'd5 & event_tx_eof        |
    regb_int2_gen[    7]==1'b0 & regb_int2_gen[ 6: 0]==7'd6 & event_tx_phyerr     |
    regb_int2_gen[    7]==1'b0 & regb_int2_gen[ 6: 0]==7'd7 & event_rxv_unsupported |
    regb_int2_gen[    7]==1'b0 & regb_int2_gen[ 6: 0]==7'd8 & event_rxv_supported   | 
    regb_int2_gen[    7]==1'b0 & regb_int2_gen[ 6: 0]==7'd9 & event_rxv_locked;

  assign int3_set =
    regb_int3_gen[ 7: 6]==2'd2 & regb_int3_gen[    5] & event_rxv_unsupported |   
    regb_int3_gen[ 7: 6]==2'd2 & regb_int3_gen[    4] & event_rxv_supported   |                         
    regb_int3_gen[ 7: 6]==2'd2 & regb_int3_gen[    3] & rxv_captured & rxv_format==VHT  |       
    regb_int3_gen[ 7: 6]==2'd2 & regb_int3_gen[    2] & rxv_captured & (rxv_format==HT_MM  | rxv_format[2:0]==HT_GF) |
    regb_int3_gen[ 7: 6]==2'd2 & regb_int3_gen[    1] & rxv_captured & (rxv_format==NON_HT | rxv_format[2:0]==NON_HT_DUP) &  rxv_mcs[3] |
    regb_int3_gen[ 7: 6]==2'd2 & regb_int3_gen[    0] & rxv_captured & (rxv_format==NON_HT | rxv_format[2:0]==NON_HT_DUP) & ~rxv_mcs[3] | 
    regb_int3_gen[ 7: 6]==2'd3 & regb_int3_gen[ 2: 0]==3'd0 & regb_int3_gen[ 4] & ~cca_pri20_1t &  cca_pri20_2t |
    regb_int3_gen[ 7: 6]==2'd3 & regb_int3_gen[ 2: 0]==3'd0 & regb_int3_gen[ 5] &  cca_pri20_1t & ~cca_pri20_2t |
    regb_int3_gen[ 7: 6]==2'd3 & regb_int3_gen[ 2: 0]==3'd1 & regb_int3_gen[ 4] & ~cca_sec20_1t &  cca_sec20_2t |
    regb_int3_gen[ 7: 6]==2'd3 & regb_int3_gen[ 2: 0]==3'd1 & regb_int3_gen[ 5] &  cca_sec20_1t & ~cca_sec20_2t |
    regb_int3_gen[ 7: 6]==2'd3 & regb_int3_gen[ 2: 0]==3'd2 & regb_int3_gen[ 4] & ~cca_sec40_1t &  cca_sec40_2t |
    regb_int3_gen[ 7: 6]==2'd3 & regb_int3_gen[ 2: 0]==3'd2 & regb_int3_gen[ 5] &  cca_sec40_1t & ~cca_sec40_2t |
    regb_int3_gen[    7]==1'b0 & regb_int3_gen[ 6: 0]==7'd1 & event_trigger[0] |
    regb_int3_gen[    7]==1'b0 & regb_int3_gen[ 6: 0]==7'd2 & event_trigger[1] |
    regb_int3_gen[    7]==1'b0 & regb_int3_gen[ 6: 0]==7'd3 & event_rx_eof_normal |
    regb_int3_gen[    7]==1'b0 & regb_int3_gen[ 6: 0]==7'd4 & event_rx_eof_abort  |
    regb_int3_gen[    7]==1'b0 & regb_int3_gen[ 6: 0]==7'd5 & event_tx_eof        |
    regb_int3_gen[    7]==1'b0 & regb_int3_gen[ 6: 0]==7'd6 & event_tx_phyerr     |
    regb_int3_gen[    7]==1'b0 & regb_int3_gen[ 6: 0]==7'd7 & event_rxv_unsupported |
    regb_int3_gen[    7]==1'b0 & regb_int3_gen[ 6: 0]==7'd8 & event_rxv_supported   | 
    regb_int3_gen[    7]==1'b0 & regb_int3_gen[ 6: 0]==7'd9 & event_rxv_locked;


endmodule
`default_nettype wire
