/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author:$
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :             
* Description      : rw_nx_he_macbypass
* Simulation Notes :             
* Synthesis Notes  :              
* Application Note :              
* Simulator        :             
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*           
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module rw_nx_macbypass_regbank
( 
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire          rst_n,  
  input  wire          clk,  

  /*****************************************************************************
  * async bus
  *****************************************************************************/
  input  wire          ahbif_req,
  input  wire          ahbif_wr,
  input  wire [  9:0]  ahbif_addr,
  input  wire [ 31:0]  ahbif_wdata,
  output reg  [ 31:0]  ahbif_rdata,
  output reg           ahbif_ack,
  
  /*****************************************************************************
  * stat
  *****************************************************************************/
  input  wire  [31:0]  stat_frame_ok,
  input  wire  [31:0]  stat_frame_bad,
  input  wire  [31:0]  stat_rxend,
  input  wire  [31:0]  stat_rxerr,
  input  wire  [31:0]  stat_phyerr,
  input  wire  [ 7:0]  stat_rssi,
  input  wire  [ 7:0]  stat_evm,
 
  /*****************************************************************************
  * event
  *****************************************************************************/
  input wire           event_tx_eof,

  /*****************************************************************************
  * rxv
  *****************************************************************************/
  input  wire          rxv_locked,
  input  wire  [ 7:0]  rxv0,
  input  wire  [ 7:0]  rxv1,
  input  wire  [ 7:0]  rxv2,
  input  wire  [ 7:0]  rxv3,
  input  wire  [ 7:0]  rxv4,
  input  wire  [ 7:0]  rxv5,
  input  wire  [ 7:0]  rxv6,
  input  wire  [ 7:0]  rxv7,
  input  wire  [ 7:0]  rxv8,
  input  wire  [ 7:0]  rxv9,
  input  wire  [ 7:0]  rxv10,
  input  wire  [ 7:0]  rxv11,
  input  wire  [ 7:0]  rxv12,
  input  wire  [ 7:0]  rxv13,
  input  wire  [ 7:0]  rxv14,
  input  wire  [ 7:0]  rxv15,

  /*****************************************************************************
  * interrupt
  *****************************************************************************/
  input  wire          int0_raw,
  input  wire          int1_raw,
  input  wire          int2_raw,
  input  wire          int3_raw,
  
  /*****************************************************************************
  * registres
  *****************************************************************************/
  /* CTRL */
  output reg           regb_bypass,
  output reg           regb_defkeeprfon,
  output reg           regb_defrxreq,
  output reg           regb_mode_is_rxlisten,
  output reg           regb_mode_is_txsingle,
  output reg           regb_mode_is_txburst,
  output reg           regb_stat_clear,
  /* PAYLOAD */
  output reg  [  3:0]  regb_pld_type_rx,
  output reg  [  3:0]  regb_pld_type_tx,
  /* FRAMEPERBURST */
  output reg  [ 15:0]  regb_frameperburst,
  /* INTERFRAME_DELAY */
  output reg  [ 19:0]  regb_interframe_delay,
  /* INT_CTRL */
  output reg           regb_intrxvlock_en,
  output reg           regb_int3_en,
  output reg           regb_int2_en,
  output reg           regb_int1_en,
  output reg           regb_int0_en,
  /* INT_GEN */
  output reg  [  7:0]  regb_int3_gen,
  output reg  [  7:0]  regb_int2_gen,
  output reg  [  7:0]  regb_int1_gen,
  output reg  [  7:0]  regb_int0_gen,
  /* INT_ACK */
  output reg           regb_intrxvlock_ack,
  output reg           regb_int0_ack,
  output reg           regb_int1_ack,
  output reg           regb_int2_ack,
  output reg           regb_int3_ack,
  /* TRIGGER */
  output reg           regb_trig_format_en,
  output reg  [  3:0]  regb_trig_format,
  output reg           regb_trig_mcs_en,
  output reg  [  6:0]  regb_trig_mcs,
  output reg           regb_trig_gitype_en,
  output reg  [  1:0]  regb_trig_gitype,
  output reg           regb_trig_fec_en,
  output reg           regb_trig_fec,
  output reg           regb_trig_stbc_en,
  output reg           regb_trig_stbc,
  output reg           regb_trig_chbw_en,
  output reg  [  2:0]  regb_trig_chbw,
  output reg           regb_trig_nss_en,
  output reg  [  2:0]  regb_trig_nss,
  output reg           regb_trig_sounding_en,
  output reg           regb_trig_sounding,
  output reg           regb_trig_paid_en,
  output reg  [  8:0]  regb_trig_paid,
  output reg           regb_trig_gid_en,
  output reg  [  5:0]  regb_trig_gid,
  output reg           regb_trig_smoothing_en,
  output reg           regb_trig_smoothing,
  /* trigger */
  output reg  [  3:0]  regb_trigger0,
  output reg  [  3:0]  regb_trigger1,
  /* TXV */
  output reg  [  7:0]  regb_txv0,
  output reg  [  7:0]  regb_txv1,
  output reg  [  7:0]  regb_txv2,
  output reg  [  7:0]  regb_txv3,
  output reg  [  7:0]  regb_txv4,
  output reg  [  7:0]  regb_txv5,
  output reg  [  7:0]  regb_txv6,
  output reg  [  7:0]  regb_txv7,
  output reg  [  7:0]  regb_txv8,
  output reg  [  7:0]  regb_txv9,
  output reg  [  7:0]  regb_txv10,
  output reg  [  7:0]  regb_txv11,
  output reg  [  7:0]  regb_txv12,
  output reg  [  7:0]  regb_txv13,
  output reg  [  7:0]  regb_txv14,
  output reg  [  7:0]  regb_txv15,
  output reg  [  7:0]  regb_txv16,
  output reg  [  7:0]  regb_txv17,
  output reg  [  7:0]  regb_txv18,
  output reg  [  7:0]  regb_txv19,
  output reg  [  7:0]  regb_txv20,
  output reg  [  7:0]  regb_txv21,
  output reg  [  7:0]  regb_txv22,
  output reg  [  7:0]  regb_txv23,
  output reg  [  7:0]  regb_txv24,
  output reg  [  7:0]  regb_txv25
);

  /*****************************************************************************
  * AHB
  *
  ******************************************************************************
  * CONTROL
  ******************************************************************************
  * 0x000 CTRL
  *      [   0] RW bypass 
  *                  0=off
  *                  1=on   
  *      [   1] RW RXREQ default state in bypass mode
  *      [   2] RW KEEPRFON default state in bypass mode
  *      [   4] RW clear stat registers (automatically cleared)
  *      [15:8] RW mode
  *                  0=idle
  *                  1=rx
  *                  2=tx single
  *                  3=tx continuous/burst
  *      [  31] R  txdone (end of single or burst sequence)
  *
  * 0x004 PAYLOAD
  *      [ 3:0] RW  RX payload
  *                  no longer implemented, fcs check always enabled
  *
  *     [19:16] RW  TX payload
  *                  0=zeros  + FCS
  *                  1=ramp   + FCS
  *                  2=PRBS23 + FCS
  *
  * 0x008 TRIGGER 
  *      [7:4] RW    event number selection for trigger1
  *      [3:0] RW    event number selection for trigger0
  *
  *          event number :
  * 
  *             0  none
  *             1  fcs update
  *             2  fcs ok
  *             3  fcs bad
  *             4  payload mismatch
  *             5  AMPDU delimiter lost
  *             6  rxerr
  *             7  rxend
  *             8  rxvector fields matching against TRIG_XXXX registers
  *             9  interrupt
  *         15-10  reserved
  *
  * 0x00C CLKEN (macbypass mpif clock enable) 
  *      [0]    RW  clken
  *
  * 0x010 FRAMEPERBURST 
  *      [15:0] RW  number of frame for a TX burst (0=continuous)
  *****************************************************************************
  * DELAYS
  ******************************************************************************
  * 0x048 INTERFRAME
  *        [19:0] RW   inter frame delay in mpif clock cycles
  *
  ******************************************************************************
  * RX STATUS
  ******************************************************************************
  * 0x080 STAT_FRAME_OK   [31:0]  R  number of received frames with FCS OK
  * 0x084 STAT_FRAME_BAD  [31:0]  R  number of received frames with wrong FCS
  * 0x088 STAT_RXEND      [31:0]  R  number of rxend events
  * 0x08c STAT_RXERROR    [31:0]  R  number of rxerr events
  * 0x090 STAT_EVM        EVM of the last frame
  *       [31:24]  R  STS3
  *       [23:16]  R  STS2
  *       [15: 8]  R  STS1
  *       [ 7: 0]  R  STS0
  * 0x094 STAT_RSSI       RSSI of the last frame
  *       [15: 8]  R  RSSI    
  *       [ 7: 0]  R  LEG RSSI
  * 0x098 STAT_PHYERR   [31:0]  R  number of phyerr events
  *   
  ******************************************************************************
  * INTERRUPTS
  ******************************************************************************
  * 0xA0 INT_CTRL
  *      [16]     RW  1=RXV captured and locked until released by SW 
  *                   0=RXV updated at each receive 
  *      [3]      RW  interrupt source #3 enable 
  *      [2]      RW  interrupt source #2 enable 
  *      [1]      RW  interrupt source #1 enable 
  *      [0]      RW  interrupt source #0 enable 
  *    
  * 0xA4 INT_GENERATION
  *      [31:24]  RW  generation of interrupt source #3
  *      [23:16]  RW  generation of interrupt source #2
  *      [15: 8]  RW  generation of interrupt source #1
  *      [ 7: 0]  RW  generation of interrupt source #0
  *
  *
  *      BYTE ENCODING
  *     
  *      [7:6]= 2'b10 (FORMAT SELECTION)
  *        [5] unsupported
  *        [4] supported
  *        [3] vht
  *        [2] ht
  *        [1] nonht ofdm
  *        [0] nonht dsss
  * 
  *      [7:6]= 2'b11 (CCA SELECTION)
  *        [5]   rising edge
  *        [4]   falling edge
  *        [3]   reserved
  *        [2:0] 0 CCA PRI20
  *              1 CCA SEC20
  *              2 CCA SEC40
  * 
  *      [7]= 1'b0 (MISC)
  *        [6:0]  0     always inactive
  *               1     trigger0 source
  *               2     trigger1 source
  *               3     end of receive (normal)
  *               4     end of receive (abort)
  *               5     end of transmit
  *               6     phy error
  *               7     rxv_unsupported
  *               8     rxv_supported  
  *               9     rxv_locked 
  *               10-127 always active (interrupt line test)
  *
  * 0xA8 INT_RAW
  *      [3]      R   state of interrupt source #3
  *      [2]      R   state of interrupt source #2
  *      [1]      R   state of interrupt source #1
  *      [0]      R   state of interrupt source #0
  *
  * 0xAC INT_ACK (writting 0 has no effect / writing 1 clears the correspondig bit)
  *      [16]     R   RXV locked                  | W  clear and unlock captured RXV
  *      [3]      R   interrupt source #3 pending | W  acknowledge of interrupt source #3
  *      [2]      R   interrupt source #2 pending | W  acknowledge of interrupt source #2
  *      [1]      R   interrupt source #1 pending | W  acknowledge of interrupt source #1
  *      [0]      R   interrupt source #0 pending | W  acknowledge of interrupt source #0
  *
  * 0xB0 INT_RXV0
  *      [31:24]  R   RXV3
  *      [23:16]  R   RXV2
  *      [15: 8]  R   RXV1
  *      [ 7: 0]  R   RXV0
  *
  * 0xB4 INT_RXV4
  *      [31:24]  R   RXV7
  *      [23:16]  R   RXV6
  *      [15: 8]  R   RXV5
  *      [ 7: 0]  R   RXV4
  *
  * 0xB8 INT_RXV8
  *      [31:24]  R   RXV11
  *      [23:16]  R   RXV10
  *      [15: 8]  R   RXV9
  *      [ 7: 0]  R   RXV8
  *
  * 0xBC INT_RXV12
  *      [31:24]  R   RXV15
  *      [23:16]  R   RXV14
  *      [15: 8]  R   RXV13
  *      [ 7: 0]  R   RXV12
  * 
  ******************************************************************************
  * TRIGGERS
  ******************************************************************************
  * 0x100 TRIG_FORMAT
  *       [31]  RW  enable
  *      [3:0]  RW  format 0=NON_HT 1=NON_HT_DUP 2=HT_MM 3=HT_GF  4=VHT 5=HE_SU 6=HE_MU 7=HE_ER_SU 8=HE_TB
  *
  * 0x104 TRIG_MCS
  *       [31]  RW  enable
  *      [6:0]  RW  MCS for HT,VHT,HE or LEGRATE for NON_HT,NON_HT_DUP  
  *       
  * 0x108 TRIG_GITYPE     
  *       [31]  RW  enable
  *      [1:0]  RW  guard interval
  *       
  * 0x10C TRIG_FEC       
  *       [31]  RW  enable
  *        [0]  RW  forward encoding 0=BCC,  1=LDPC
  *       
  * 0x110 TRIG_STBC      
  *       [31]  RW  enable
  *        [0]  RW  STBC
  *       
  * 0x114 TRIG_CHBW      
  *       [31]  RW  enable
  *      [2:0]  RW  frame bandwidth 0=20M, 1=40M, 2=80M, 3=160/80+80MHz,
  *                                 4=HE-CBW-PUNC80-PRI, 5=HE-CBW-PUNC80-SEC,
  *                                 6=HE-CBW-PUNC160-PRI20, 7=HE-CBW-PUNC160-SEC40
  *       
  * 0x118 TRIG_NSS      
  *       [31]  RW  enable
  *      [2:0]  RW  NSS
  *       
  * 0x11C TRIG_SOUNDING  
  *       [31]  RW  enable
  *        [0]  RW  sounding
  *       
  * 0x120 TRIG_PAID      
  *       [31]  RW  enable
  *      [8:0]  RW  partial id
  *       
  * 0x124 TRIG_GID       
  *       [31]  RW  enable
  *      [5:0]  RW  group id
  *       
  * 0x128 TRIG_SMOOTHING
  *       [31]  RW  enable
  *        [0]  RW  smoothing
  *       
  ******************************************************************************
  * TXVECTOR
  ******************************************************************************
  * 0x200 TXVECTOR0   as defined in MPIF FS
  * 0x204 TXVECTOR1
  * 0x208 TXVECTOR2
  * 0x20c TXVECTOR3
  * 0x210 TXVECTOR4
  * 0x214 TXVECTOR5
  * 0x218 TXVECTOR6
  * 0x21c TXVECTOR7
  * 0x220 TXVECTOR8
  * 0x224 TXVECTOR9
  * 0x228 TXVECTOR10
  * 0x22c TXVECTOR11
  * 0x230 TXVECTOR12
  * 0x234 TXVECTOR13
  * 0x238 TXVECTOR14
  * 0x23c TXVECTOR15
  * 0x240 TXVECTOR16
  * 0x244 TXVECTOR17
  * 0x248 TXVECTOR18
  * 0x24c TXVECTOR19
  * 0x250 TXVECTOR20
  * 0x254 TXVECTOR21
  * 0x258 TXVECTOR22
  * 0x25c TXVECTOR23
  * 0x260 TXVECTOR24
  * 0x264 TXVECTOR25
  ******************************************************************************
  * MISC
  ******************************************************************************
  * 0x3fc VERSION  
  *       [31:16]   0x0001
  *       [15: 0]   0x0001
  *****************************************************************************/
  localparam   REG_CTRL           = 10'h000,
               REG_PAYLOAD        = 10'h004,
               REG_TRIGGER        = 10'h008,
               REG_CLKEN          = 10'h00c,
               REG_FRAMEPERBURST  = 10'h010,
               
               REG_INTERFRAME_DELAY = 10'h048,
               
               REG_STAT_FRAME_OK  = 10'h080,
               REG_STAT_FRAME_BAD = 10'h084,
               REG_STAT_RXEND     = 10'h088,
               REG_STAT_RXERROR   = 10'h08c,
               REG_STAT_EVM       = 10'h090,
               REG_STAT_RSSI      = 10'h094,
               REG_STAT_PHYERR    = 10'h098,
               
               REG_INT_CTRL       = 10'h0a0,
               REG_INT_GEN        = 10'h0a4, 
               REG_INT_RAW        = 10'h0a8,
               REG_INT_ACK        = 10'h0ac,
               REG_INT_RXV0       = 10'h0b0,
               REG_INT_RXV4       = 10'h0b4,
               REG_INT_RXV8       = 10'h0b8,
               REG_INT_RXV12      = 10'h0bc,
               
               REG_TRIG_FORMAT    = 10'h100,
               REG_TRIG_MCS       = 10'h104,
               REG_TRIG_GITYPE    = 10'h108,
               REG_TRIG_FEC       = 10'h10c,
               REG_TRIG_STBC      = 10'h110,
               REG_TRIG_CHBW      = 10'h114,
               REG_TRIG_NSS       = 10'h118,
               REG_TRIG_SOUNDING  = 10'h11c,
               REG_TRIG_PAID      = 10'h120,
               REG_TRIG_GID       = 10'h124,
               REG_TRIG_SMOOTHING = 10'h128,
               
               REG_TXV0           = 10'h200,
               REG_TXV1           = 10'h204,
               REG_TXV2           = 10'h208,
               REG_TXV3           = 10'h20c,
               REG_TXV4           = 10'h210,
               REG_TXV5           = 10'h214,
               REG_TXV6           = 10'h218,
               REG_TXV7           = 10'h21c,
               REG_TXV8           = 10'h220,
               REG_TXV9           = 10'h224,
               REG_TXV10          = 10'h228,
               REG_TXV11          = 10'h22c,
               REG_TXV12          = 10'h230,
               REG_TXV13          = 10'h234,
               REG_TXV14          = 10'h238,
               REG_TXV15          = 10'h23c,
               REG_TXV16          = 10'h240,
               REG_TXV17          = 10'h244,
               REG_TXV18          = 10'h248,
               REG_TXV19          = 10'h24c,
               REG_TXV20          = 10'h250,
               REG_TXV21          = 10'h254,
               REG_TXV22          = 10'h258,
               REG_TXV23          = 10'h25c,
               REG_TXV24          = 10'h260,
               REG_TXV25          = 10'h264,
               REG_VERSION        = 10'h3fc;

  reg     regb_txdone;
  
  /* bus fsm */
  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      ahbif_rdata           <= 32'd0;
      ahbif_ack             <= 1'b0;
      regb_bypass           <= 4'b0; 
      regb_defkeeprfon      <= 1'b0;
      regb_defrxreq         <= 1'b0;
      regb_mode_is_rxlisten <= 1'b0;
      regb_mode_is_txsingle <= 1'b0;
      regb_mode_is_txburst  <= 1'b0;
      regb_stat_clear       <= 1'b0;
      regb_pld_type_tx      <= 4'b0;
      regb_pld_type_rx      <= 4'b0;
      regb_frameperburst    <= 16'b0;
      regb_interframe_delay <= 20'b0;
      regb_intrxvlock_en    <= 1'b0;
      regb_int3_en          <= 1'b0;
      regb_int2_en          <= 1'b0;
      regb_int1_en          <= 1'b0;
      regb_int0_en          <= 1'b0;
      regb_intrxvlock_ack   <= 1'b0; 
      regb_int3_gen         <= 8'b0;
      regb_int2_gen         <= 8'b0;
      regb_int1_gen         <= 8'b0;
      regb_int0_gen         <= 8'b0;
      regb_int3_ack         <= 1'b0; 
      regb_int2_ack         <= 1'b0; 
      regb_int1_ack         <= 1'b0; 
      regb_int0_ack         <= 1'b0;         
      regb_trig_format_en   <= 1'b0;
      regb_trig_format      <= 4'd0;
      regb_trig_mcs_en      <= 1'd0;
      regb_trig_mcs         <= 7'd0;
      regb_trig_gitype_en   <= 1'd0;
      regb_trig_gitype      <= 2'd0;
      regb_trig_fec_en      <= 1'd0;
      regb_trig_fec         <= 1'd0;
      regb_trig_stbc_en     <= 1'd0;
      regb_trig_stbc        <= 1'd0;
      regb_trig_chbw_en     <= 1'd0;
      regb_trig_chbw        <= 3'd0;
      regb_trig_nss_en      <= 1'd0;
      regb_trig_nss         <= 3'd0;
      regb_trig_sounding_en <= 1'd0;
      regb_trig_sounding    <= 1'd0;
      regb_trig_paid_en     <= 1'd0;
      regb_trig_paid        <= 9'd0;
      regb_trig_gid_en      <= 1'd0;
      regb_trig_gid         <= 6'd0;
      regb_trig_smoothing_en<= 1'd0;
      regb_trig_smoothing   <= 1'd0;
      regb_txv0             <= 8'b0;
      regb_txv1             <= 8'b0;
      regb_txv2             <= 8'b0;
      regb_txv3             <= 8'b0;
      regb_txv4             <= 8'b0;
      regb_txv5             <= 8'b0;
      regb_txv6             <= 8'b0;
      regb_txv7             <= 8'b0;
      regb_txv8             <= 8'b0;
      regb_txv9             <= 8'b0;
      regb_txv10            <= 8'b0;
      regb_txv11            <= 8'b0;
      regb_txv12            <= 8'b0;
      regb_txv13            <= 8'b0;
      regb_txv14            <= 8'b0;
      regb_txv15            <= 8'b0;
      regb_txv16            <= 8'b0;
      regb_txv17            <= 8'b0;
      regb_txv18            <= 8'b0;
      regb_txv19            <= 8'b0;
      regb_txv20            <= 8'b0;
      regb_txv21            <= 8'b0;
      regb_txv22            <= 8'b0;
      regb_txv23            <= 8'b0;
      regb_txv24            <= 8'b0;
      regb_txv25            <= 8'b0;
      regb_trigger0         <= 4'b0;
      regb_trigger1         <= 4'b0;
      regb_txdone           <= 1'b0;
    end
    else
    begin
      /* rtz */
      regb_stat_clear         <= 1'b0; 
      regb_intrxvlock_ack     <= 1'b0; 
      regb_int3_ack           <= 1'b0; 
      regb_int2_ack           <= 1'b0; 
      regb_int1_ack           <= 1'b0; 
      regb_int0_ack           <= 1'b0;      
      /* set */
      regb_txdone             <= regb_txdone | event_tx_eof;
      
      /* access */
      if(ahbif_req && !ahbif_ack)
      begin
        ahbif_ack   <= 1'b1;
        ahbif_rdata <= 32'd0;
        if(ahbif_wr)
        begin
          /* register write */
          case(ahbif_addr)                         
            REG_CTRL:   
            begin       
              regb_txdone            <= regb_txdone & ahbif_wdata[31];
              regb_mode_is_rxlisten  <= 1'b0;
              regb_mode_is_txsingle  <= 1'b0;
              regb_mode_is_txburst   <= 1'b0;
              case(ahbif_wdata[15:8])
                8'd1:    regb_mode_is_rxlisten  <= 1'b1;
                8'd2:    regb_mode_is_txsingle  <= 1'b1;
                8'd3:    regb_mode_is_txburst   <= 1'b1;
                default: ;
              endcase
              regb_stat_clear        <= ahbif_wdata[4];
              regb_defkeeprfon       <= ahbif_wdata[2];
              regb_defrxreq          <= ahbif_wdata[1]; 
              regb_bypass            <= ahbif_wdata[0]; 
            end         
            REG_PAYLOAD:
            begin  
              regb_pld_type_rx       <= ahbif_wdata[ 3: 0]; 
              regb_pld_type_tx       <= ahbif_wdata[19:16]; 
            end  
            REG_TRIGGER:
            begin       
              regb_trigger0          <= ahbif_wdata[3:0];
              regb_trigger1          <= ahbif_wdata[7:4];
            end          
            REG_FRAMEPERBURST:
            begin   
              regb_frameperburst     <= ahbif_wdata[15:0];
            end
            /* delays */
            REG_INTERFRAME_DELAY:
            begin
              regb_interframe_delay  <= ahbif_wdata[19:0];
            end
            /* txvector */                        
            REG_TXV0:  regb_txv0     <= ahbif_wdata[ 7:0]; 
            REG_TXV1:  regb_txv1     <= ahbif_wdata[ 7:0];
            REG_TXV2:  regb_txv2     <= ahbif_wdata[ 7:0]; 
            REG_TXV3:  regb_txv3     <= ahbif_wdata[ 7:0];
            REG_TXV4:  regb_txv4     <= ahbif_wdata[ 7:0];
            REG_TXV5:  regb_txv5     <= ahbif_wdata[ 7:0];
            REG_TXV6:  regb_txv6     <= ahbif_wdata[ 7:0]; 
            REG_TXV7:  regb_txv7     <= ahbif_wdata[ 7:0]; 
            REG_TXV8:  regb_txv8     <= ahbif_wdata[ 7:0]; 
            REG_TXV9:  regb_txv9     <= ahbif_wdata[ 7:0]; 
            REG_TXV10: regb_txv10    <= ahbif_wdata[ 7:0];
            REG_TXV11: regb_txv11    <= ahbif_wdata[ 7:0];
            REG_TXV12: regb_txv12    <= ahbif_wdata[ 7:0];
            REG_TXV13: regb_txv13    <= ahbif_wdata[ 7:0]; 
            REG_TXV14: regb_txv14    <= ahbif_wdata[ 7:0]; 
            REG_TXV15: regb_txv15    <= ahbif_wdata[ 7:0]; 
            REG_TXV16: regb_txv16    <= ahbif_wdata[ 7:0]; 
            REG_TXV17: regb_txv17    <= ahbif_wdata[ 7:0]; 
            REG_TXV18: regb_txv18    <= ahbif_wdata[ 7:0]; 
            REG_TXV19: regb_txv19    <= ahbif_wdata[ 7:0]; 
            REG_TXV20: regb_txv20    <= ahbif_wdata[ 7:0];
            REG_TXV21: regb_txv21    <= ahbif_wdata[ 7:0];
            REG_TXV22: regb_txv22    <= ahbif_wdata[ 7:0];
            REG_TXV23: regb_txv23    <= ahbif_wdata[ 7:0]; 
            REG_TXV24: regb_txv24    <= ahbif_wdata[ 7:0]; 
            REG_TXV25: regb_txv25    <= ahbif_wdata[ 7:0]; 
            /* interrupt */                       
            REG_INT_CTRL:                         
            begin       
              regb_intrxvlock_en     <= ahbif_wdata[16];
              regb_int3_en           <= ahbif_wdata[ 3];
              regb_int2_en           <= ahbif_wdata[ 2];
              regb_int1_en           <= ahbif_wdata[ 1];
              regb_int0_en           <= ahbif_wdata[ 0];
            end         
            REG_INT_GEN:                        
            begin       
              regb_int3_gen          <= ahbif_wdata[31:24]; 
              regb_int2_gen          <= ahbif_wdata[23:16]; 
              regb_int1_gen          <= ahbif_wdata[15: 8]; 
              regb_int0_gen          <= ahbif_wdata[ 7 :0]; 
            end
            REG_INT_ACK:                        
            begin       
              regb_intrxvlock_ack    <= ahbif_wdata[16];
              regb_int3_ack          <= ahbif_wdata[ 3];
              regb_int2_ack          <= ahbif_wdata[ 2];
              regb_int1_ack          <= ahbif_wdata[ 1];
              regb_int0_ack          <= ahbif_wdata[ 0];
            end
            /* triggers */                        
            REG_TRIG_FORMAT:
            begin
              regb_trig_format_en    <= ahbif_wdata[31];
              regb_trig_format       <= ahbif_wdata[3:0]; 
            end
            REG_TRIG_MCS:
            begin
              regb_trig_mcs_en       <= ahbif_wdata[31];
              regb_trig_mcs          <= ahbif_wdata[6:0];
            end
            REG_TRIG_GITYPE:
            begin
              regb_trig_gitype_en    <= ahbif_wdata[31];                         
              regb_trig_gitype       <= ahbif_wdata[1:0];                        
            end
            REG_TRIG_FEC:       
            begin
              regb_trig_fec_en       <= ahbif_wdata[31];                         
              regb_trig_fec          <= ahbif_wdata[0];                          
            end
            REG_TRIG_STBC:      
            begin
              regb_trig_stbc_en      <= ahbif_wdata[31];                         
              regb_trig_stbc         <= ahbif_wdata[0];                          
            end
            REG_TRIG_CHBW:      
            begin
              regb_trig_chbw_en      <= ahbif_wdata[31];                         
              regb_trig_chbw         <= ahbif_wdata[2:0];                        
            end
            REG_TRIG_NSS:      
            begin
              regb_trig_nss_en       <= ahbif_wdata[31];                         
              regb_trig_nss          <= ahbif_wdata[2:0];                        
            end
            REG_TRIG_SOUNDING:   
            begin
              regb_trig_sounding_en  <= ahbif_wdata[31];                         
              regb_trig_sounding     <= ahbif_wdata[0];                          
            end
            REG_TRIG_PAID:      
            begin
              regb_trig_paid_en      <= ahbif_wdata[31];                         
              regb_trig_paid         <= ahbif_wdata[8:0];                        
            end
            REG_TRIG_GID:       
            begin
              regb_trig_gid_en       <= ahbif_wdata[31];                         
              regb_trig_gid          <= ahbif_wdata[5:0];  
            end
            REG_TRIG_SMOOTHING:  
            begin
              regb_trig_smoothing_en <= ahbif_wdata[31];
              regb_trig_smoothing    <= ahbif_wdata[0];
            end
            default: ;
          endcase
        end
        else
        begin
          /* register read */
          case(ahbif_addr)                         
            REG_CTRL:  
            begin                                
              ahbif_rdata[31]     <= regb_txdone;
              if(regb_mode_is_rxlisten)
                ahbif_rdata[11:8] <= 8'd1;
              else if(regb_mode_is_txsingle)
                ahbif_rdata[11:8] <= 8'd2;
              else if(regb_mode_is_txburst)
                ahbif_rdata[11:8] <= 8'd3;
              else
                ahbif_rdata[11:8] <= 8'd0; 

              ahbif_rdata[2]      <= regb_defkeeprfon;
              ahbif_rdata[1]      <= regb_defrxreq;
              ahbif_rdata[0]      <= regb_bypass; 
            end        
            REG_PAYLOAD:                         
            begin      
              ahbif_rdata[ 3: 0]  <= regb_pld_type_rx; 
              ahbif_rdata[19:16]  <= regb_pld_type_tx; 
            end        
            REG_TRIGGER:                         
            begin      
              ahbif_rdata[3:0]    <= regb_trigger0; 
              ahbif_rdata[7:4]    <= regb_trigger1; 
            end   
            REG_FRAMEPERBURST:                  
            begin      
              ahbif_rdata[15:0]   <= regb_frameperburst;
            end        
            REG_INTERFRAME_DELAY:                   
            begin      
              ahbif_rdata[19:0]   <= regb_interframe_delay;
            end        
            REG_STAT_FRAME_OK:  ahbif_rdata[31:0] <= stat_frame_ok;
            REG_STAT_FRAME_BAD: ahbif_rdata[31:0] <= stat_frame_bad;
            REG_STAT_RXEND:     ahbif_rdata[31:0] <= stat_rxend;
            REG_STAT_RXERROR:   ahbif_rdata[31:0] <= stat_rxerr;
            REG_STAT_EVM:       ahbif_rdata[ 7:0] <= stat_evm;
            REG_STAT_RSSI:      ahbif_rdata[ 7:0] <= stat_rssi;
            REG_STAT_PHYERR:    ahbif_rdata[31:0] <= stat_phyerr;
            REG_TXV0:           ahbif_rdata[ 7:0] <= regb_txv0;
            REG_TXV1:           ahbif_rdata[ 7:0] <= regb_txv1;
            REG_TXV2:           ahbif_rdata[ 7:0] <= regb_txv2;
            REG_TXV3:           ahbif_rdata[ 7:0] <= regb_txv3;
            REG_TXV4:           ahbif_rdata[ 7:0] <= regb_txv4;
            REG_TXV5:           ahbif_rdata[ 7:0] <= regb_txv5;
            REG_TXV6:           ahbif_rdata[ 7:0] <= regb_txv6;
            REG_TXV7:           ahbif_rdata[ 7:0] <= regb_txv7;
            REG_TXV8:           ahbif_rdata[ 7:0] <= regb_txv8;
            REG_TXV9:           ahbif_rdata[ 7:0] <= regb_txv9;
            REG_TXV10:          ahbif_rdata[ 7:0] <= regb_txv10;
            REG_TXV11:          ahbif_rdata[ 7:0] <= regb_txv11;
            REG_TXV12:          ahbif_rdata[ 7:0] <= regb_txv12;
            REG_TXV13:          ahbif_rdata[ 7:0] <= regb_txv13;
            REG_TXV14:          ahbif_rdata[ 7:0] <= regb_txv14;
            REG_TXV15:          ahbif_rdata[ 7:0] <= regb_txv15;
            REG_TXV16:          ahbif_rdata[ 7:0] <= regb_txv16;
            REG_TXV17:          ahbif_rdata[ 7:0] <= regb_txv17;
            REG_TXV18:          ahbif_rdata[ 7:0] <= regb_txv18;
            REG_TXV19:          ahbif_rdata[ 7:0] <= regb_txv19;
            REG_TXV20:          ahbif_rdata[ 7:0] <= regb_txv20;
            REG_TXV21:          ahbif_rdata[ 7:0] <= regb_txv21;
            REG_TXV22:          ahbif_rdata[ 7:0] <= regb_txv22;
            REG_TXV23:          ahbif_rdata[ 7:0] <= regb_txv23;
            REG_TXV24:          ahbif_rdata[ 7:0] <= regb_txv24;
            REG_TXV25:          ahbif_rdata[ 7:0] <= regb_txv25;
            /* interrupts */                     
            REG_INT_CTRL:                        
            begin      
              ahbif_rdata[16]     <= regb_intrxvlock_en; 
              ahbif_rdata[ 3]     <= regb_int3_en; 
              ahbif_rdata[ 2]     <= regb_int2_en; 
              ahbif_rdata[ 1]     <= regb_int1_en; 
              ahbif_rdata[ 0]     <= regb_int0_en; 
            end        
            REG_INT_GEN:                    
            begin                            
              ahbif_rdata[31:24]  <= regb_int3_gen;
              ahbif_rdata[23:16]  <= regb_int2_gen;
              ahbif_rdata[15: 8]  <= regb_int1_gen;
              ahbif_rdata[ 7 :0]  <= regb_int0_gen;
            end        
            REG_INT_RAW,
            REG_INT_ACK:
            begin
              ahbif_rdata[16]     <= rxv_locked; 
              ahbif_rdata[ 3]     <= int3_raw; 
              ahbif_rdata[ 2]     <= int2_raw; 
              ahbif_rdata[ 1]     <= int1_raw; 
              ahbif_rdata[ 0]     <= int0_raw; 
            end
            /* rxv */
            REG_INT_RXV0:  ahbif_rdata <= { rxv3, rxv2, rxv1, rxv0};
            REG_INT_RXV4:  ahbif_rdata <= { rxv7, rxv6, rxv5, rxv4};
            REG_INT_RXV8:  ahbif_rdata <= {rxv11,rxv10, rxv9, rxv8};
            REG_INT_RXV12: ahbif_rdata <= {rxv15,rxv14,rxv13,rxv12};
            /* triggers */                       
            REG_TRIG_FORMAT:
            begin
              ahbif_rdata[31]   <= regb_trig_format_en;
              ahbif_rdata[3:0]  <= regb_trig_format;
            end
            REG_TRIG_MCS:       
            begin
              ahbif_rdata[31]   <= regb_trig_mcs_en;
              ahbif_rdata[6:0]  <= regb_trig_mcs;
            end
            REG_TRIG_GITYPE:       
            begin
              ahbif_rdata[31]   <= regb_trig_gitype_en;
              ahbif_rdata[1:0]  <= regb_trig_gitype;
            end
            REG_TRIG_FEC:       
            begin
              ahbif_rdata[31]   <= regb_trig_fec_en;
              ahbif_rdata[  0]  <= regb_trig_fec;
            end
            REG_TRIG_STBC:      
            begin
              ahbif_rdata[31]   <= regb_trig_stbc_en;
              ahbif_rdata[  0]  <= regb_trig_stbc;
            end
            REG_TRIG_CHBW:      
            begin
              ahbif_rdata[31]   <= regb_trig_chbw_en;
              ahbif_rdata[2:0]  <= regb_trig_chbw;
            end
            REG_TRIG_NSS:      
            begin
              ahbif_rdata[31]   <= regb_trig_nss_en;
              ahbif_rdata[2:0]  <= regb_trig_nss;
            end
            REG_TRIG_SOUNDING:  
            begin
              ahbif_rdata[31]   <= regb_trig_sounding_en;
              ahbif_rdata[0]    <= regb_trig_sounding;
            end
            REG_TRIG_PAID:      
            begin
              ahbif_rdata[31]   <= regb_trig_paid_en;
              ahbif_rdata[8:0]  <= regb_trig_paid;
            end
            REG_TRIG_GID:       
            begin
              ahbif_rdata[31]   <= regb_trig_gid_en;
              ahbif_rdata[5:0]  <= regb_trig_gid;
            end
            REG_TRIG_SMOOTHING: 
            begin
              ahbif_rdata[31]   <= regb_trig_smoothing_en;
              ahbif_rdata[ 0]   <= regb_trig_smoothing;
            end
            /* illegal */
            default:
            begin
              ahbif_rdata       <= 32'hdead0e0e; 
            end
          endcase
        end
      end
      else if(!ahbif_req && ahbif_ack)
      begin
        ahbif_ack <= 1'b0;
      end
    end
  end
  
endmodule
`default_nettype wire
