/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : mpif_payload_tracking
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module rw_nx_macbypass_rxv
(
  /* system */
  input  wire         clk,
  input  wire         rst_n,
  
  /* control */
  input  wire         rxreq,
  input  wire         rxend,

  /* input data */
  input  wire  [7:0]  data,
  input  wire         valid,
  input  wire         last,
  
  /* registres */
  input  wire         regb_intrxvlock_en,
  
  /* decoded unlocked rxvector */
  output wire         rxvu1_last,
  output wire         rxvu2_last,
  output reg          rxvu1_captured,
  output reg          rxvu2_captured,
  
  output reg   [ 3:0] rxvu_format,
  output reg   [11:0] rxvu_l_length,
  output reg   [19:0] rxvu_length,
  output reg   [ 6:0] rxvu_mcs,
  output reg   [ 1:0] rxvu_gi_type,
  output reg          rxvu_fec,
  output reg          rxvu_stbc,
  output reg   [ 2:0] rxvu_chbw,
  output reg   [ 2:0] rxvu_nss,
  output reg          rxvu_sounding,
  output reg   [ 8:0] rxvu_paid,
  output reg   [ 5:0] rxvu_gid,
  output reg          rxvu_smoothing,
  output reg          rxvu_beamformed,
  output reg          rxvu_aggregation,
  output wire         rxvu_ndp,

  /* undecoded locked rxvector */
  input  wire         rxvl_clear,
  output reg          rxvl_locked,
  output reg   [ 7:0] rxvl_0,
  output reg   [ 7:0] rxvl_1,
  output reg   [ 7:0] rxvl_2,
  output reg   [ 7:0] rxvl_3,
  output reg   [ 7:0] rxvl_4,
  output reg   [ 7:0] rxvl_5,
  output reg   [ 7:0] rxvl_6,
  output reg   [ 7:0] rxvl_7,
  output reg   [ 7:0] rxvl_8,
  output reg   [ 7:0] rxvl_9,
  output reg   [ 7:0] rxvl_10,
  output reg   [ 7:0] rxvl_11,
  output reg   [ 7:0] rxvl_12,
  output reg   [ 7:0] rxvl_13,
  output reg   [ 7:0] rxvl_14,
  output reg   [ 7:0] rxvl_15,
  
  /* event */
  output reg          event_rxvl_locked
  
);

  localparam NON_HT     = 4'd0,
             NON_HT_DUP = 4'd1,
             HT_MM      = 4'd2,
             HT_GF      = 4'd3,
             VHT        = 4'd4,
             HE_SU      = 4'd5,
             HE_MU      = 4'd6,
             HE_ER_SU   = 4'd7,
             HE_TB      = 4'd8;

  wire [ 4:0] n_count;
  reg  [ 4:0] count;
  reg         payload_done;
  
  assign rxvu_ndp   = rxvu1_captured && rxvu_format!=NON_HT && rxvu_format!=NON_HT_DUP && rxvu_format!=HE_TB && rxvu_length==20'd0;
  
  assign n_count    = count + 5'd1;
  assign rxvu1_last = !rxvu1_captured && (rxvu_format==NON_HT     && count==5'd6  ||
                                          rxvu_format==NON_HT_DUP && count==5'd6  ||
                                          rxvu_format==HT_MM      && count==5'd9  ||
                                          rxvu_format==HT_GF      && count==5'd9  ||
                                          rxvu_format==VHT        && count==5'd12 ||
                                          rxvu_format==HE_SU      && count==5'd15 ||
                                          rxvu_format==HE_MU      && count==5'd15 ||
                                          rxvu_format==HE_ER_SU   && count==5'd15 ||
                                          rxvu_format==HE_TB      && count==5'd11);
                          
  assign rxvu2_last = rxvu1_captured && (rxvu_ndp || payload_done) && count==5'd7;
  
  /* rxv capture */ 
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      count             <= 5'd0;
      payload_done      <= 1'b0;
      rxvu1_captured    <= 1'b0;
      rxvu2_captured    <= 1'b0;
      rxvu_format       <= 4'b0; 
      rxvu_l_length     <= 12'b0;
      rxvu_length       <= 20'b0;
      rxvu_mcs          <= 7'b0;
      rxvu_gi_type      <= 2'b0;
      rxvu_fec          <= 1'b0;
      rxvu_stbc         <= 1'b0;
      rxvu_chbw         <= 3'b0;
      rxvu_nss          <= 3'b0;
      rxvu_sounding     <= 1'b0;
      rxvu_paid         <= 9'b0;
      rxvu_gid          <= 6'b0;
      rxvu_smoothing    <= 1'b0;
      rxvu_beamformed   <= 1'b0;
      rxvu_aggregation  <= 1'b0;
      rxvl_locked       <= 1'b0;
      rxvl_0            <= 8'b0;
      rxvl_1            <= 8'b0;
      rxvl_2            <= 8'b0;
      rxvl_3            <= 8'b0;
      rxvl_4            <= 8'b0;
      rxvl_5            <= 8'b0;
      rxvl_6            <= 8'b0;
      rxvl_7            <= 8'b0;
      rxvl_8            <= 8'b0;
      rxvl_9            <= 8'b0;
      rxvl_10           <= 8'b0;
      rxvl_11           <= 8'b0;
      rxvl_12           <= 8'b0;
      rxvl_13           <= 8'b0;
      rxvl_14           <= 8'b0;
      rxvl_15           <= 8'b0;
      event_rxvl_locked <= 1'b0;
    end
    else 
    begin
      /* rtz */
      event_rxvl_locked <= 1'b0;
     
      /* clear locked vector */
      if(rxvl_clear)
      begin
        rxvl_locked <= 1'b0;
        rxvl_0      <= 8'd0;  
        rxvl_1      <= 8'd0;  
        rxvl_2      <= 8'd0;  
        rxvl_3      <= 8'd0;  
        rxvl_4      <= 8'd0;  
        rxvl_5      <= 8'd0;  
        rxvl_6      <= 8'd0;  
        rxvl_7      <= 8'd0;  
        rxvl_8      <= 8'd0;  
        rxvl_9      <= 8'd0;  
        rxvl_10     <= 8'd0;  
        rxvl_11     <= 8'd0;  
        rxvl_12     <= 8'd0;  
        rxvl_13     <= 8'd0;  
        rxvl_14     <= 8'd0;  
        rxvl_15     <= 8'd0;  
      end

      if(!rxreq || rxend)
      begin
        count             <= 5'd0;
        payload_done      <= 1'b0;
        rxvu1_captured    <= 1'b0;
        rxvu2_captured    <= 1'b0;
        rxvu_format       <= 4'b0; 
        rxvu_length       <= 20'b0;
        rxvu_mcs          <= 7'b0;
        rxvu_gi_type      <= 2'b0;
        rxvu_fec          <= 1'b0;
        rxvu_stbc         <= 1'b0;
        rxvu_chbw         <= 3'b0;
        rxvu_nss          <= 3'b0;
        rxvu_sounding     <= 1'b0;
        rxvu_paid         <= 9'b0;
        rxvu_gid          <= 6'b0;
        rxvu_smoothing    <= 1'b0;
        rxvu_beamformed   <= 1'b0;
        rxvu_aggregation  <= 1'b0;
      end
      else
      begin
        if(valid)
        begin
          count <= n_count;
          /* rxv1 captured */
          if(!rxvu1_captured)
          begin
            /* locked   */               
            if(!rxvl_locked)             
            begin                        
              case(count)                
                5'd0:  rxvl_0  <= data;  
                5'd1:  rxvl_1  <= data;  
                5'd2:  rxvl_2  <= data;  
                5'd3:  rxvl_3  <= data;  
                5'd4:  rxvl_4  <= data;  
                5'd5:  rxvl_5  <= data;  
                5'd6:  rxvl_6  <= data;  
                5'd7:  rxvl_7  <= data;  
                5'd8:  rxvl_8  <= data;  
                5'd9:  rxvl_9  <= data;  
                5'd10: rxvl_10 <= data;  
                5'd11: rxvl_11 <= data;  
                5'd12: rxvl_12 <= data;  
                5'd13: rxvl_13 <= data;  
                5'd14: rxvl_14 <= data;  
                5'd15: rxvl_15 <= data;  
                default: ;               
              endcase
            end                    
            /* unlocked */
            if(count==5'd0)
            begin
              rxvu_format      <= data[3:0];
              rxvu_chbw        <= data[6:4];
              rxvu_l_length    <= 12'b0;
              rxvu_length      <= 20'b0;
              rxvu_mcs         <= 7'b0;
              rxvu_gi_type     <= 2'b0;
              rxvu_fec         <= 1'b0;
              rxvu_stbc        <= 1'b0;
              rxvu_chbw        <= 3'b0;
              rxvu_nss         <= 3'b0;
              rxvu_sounding    <= 1'b0;
              rxvu_paid        <= 9'b0;
              rxvu_gid         <= 6'b0;
              rxvu_smoothing   <= 1'b0;
              rxvu_beamformed  <= 1'b0;
              rxvu_aggregation <= 1'b0;
            end
            else
            begin
              case(rxvu_format)
                NON_HT,NON_HT_DUP:
                begin
                  case(count)
                    5'd3: 
                    begin
                      rxvu_length[7:0]    <= data;
                      rxvu_l_length[7:0]  <= data;
                    end
                    5'd4: 
                    begin
                      rxvu_length[11: 8]  <= data[3:0];
                      rxvu_length[19:12]  <= 8'b0;
                      rxvu_l_length[11:8] <= data[3:0];
                      rxvu_mcs            <= { 3'b0, data[7:4]};
                    end
                    default: ;
                  endcase
                end  
                HT_MM,HT_GF:
                begin
                  case(count)
                    5'd3: 
                    begin
                      rxvu_l_length[7:0]  <= data;
                    end
                    5'd4: 
                    begin
                      rxvu_l_length[11:8] <= data[3:0];
                    end
                    5'd6:
                    begin
                     rxvu_sounding        <= data[0];        
                     rxvu_smoothing       <= data[1];        
                     rxvu_gi_type         <= {1'b0,data[2]}; 
                     rxvu_aggregation     <= data[3];        
                     rxvu_stbc            <= data[4];        
                    end
                    5'd7:
                    begin
                      rxvu_mcs            <= data[6:0];      
                      rxvu_fec            <= data[7];        
                    end
                    5'd8:
                    begin
                      rxvu_length[7:0]    <= data;
                    end
                    5'd9:
                    begin
                      rxvu_length[19:8]   <= {4'b0,data};
                    end
                    default: ;
                  endcase
                end
                VHT:
                begin
                  case(count)
                    5'd3: 
                    begin
                      rxvu_l_length[7:0]  <= data;
                    end
                    5'd4: 
                    begin
                      rxvu_l_length[11:8] <= data[3:0];
                    end
                    5'd6:
                    begin
                      rxvu_beamformed     <= data[1];
                      rxvu_gi_type        <= {1'b0,data[2]};
                      rxvu_aggregation    <= 1'b1;
                      rxvu_stbc           <= data[4];
                    end  
                    5'd7:
                    begin
                      rxvu_paid[7:0]      <= data;
                    end
                    5'd8:
                    begin
                      rxvu_paid[8]        <= data[0];
                      rxvu_gid            <= data[6:1];
                    end
                    5'd9:
                    begin
                      rxvu_mcs            <= {3'b0,data[3:0]};
                      rxvu_nss            <= data[6:4];
                      rxvu_fec            <= data[7];
                    end
                    5'd10:
                    begin
                      rxvu_length[7:0]    <= data;
                    end
                    5'd11:
                    begin
                      rxvu_length[15:8]   <= data;
                    end
                    5'd12:
                    begin
                      rxvu_length[19:16]  <= data[3:0];
                    end
                    default: ;
                  endcase
                end
                HE_SU,HE_ER_SU:
                begin
                  case(count)
                    5'd3: 
                    begin
                      rxvu_l_length[7:0]  <= data;
                    end
                    5'd4: 
                    begin
                      rxvu_l_length[11:8] <= data[3:0];
                    end
                    5'd6:
                    begin
                      rxvu_beamformed     <= data[1];
                      rxvu_gi_type        <= data[3:2];
                      rxvu_aggregation    <= 1'b1;
                      rxvu_stbc           <= data[4];
                    end
                    5'd12:
                    begin
                      rxvu_mcs            <= {3'b0,data[3:0]};
                      rxvu_nss            <= data[6:4];
                      rxvu_fec            <= data[7];
                    end
                    5'd13:
                    begin
                      rxvu_length[7:0]    <= data;
                    end
                    5'd14:
                    begin
                      rxvu_length[15:8]   <= data;
                    end
                    5'd15:
                    begin
                      rxvu_length[19:16]  <= data[3:0];
                    end
                    default: ;
                  endcase
                end
                HE_MU:
                begin
                  case(count)
                    5'd3: 
                    begin
                      rxvu_l_length[7:0]  <= data;
                    end
                    5'd4: 
                    begin
                      rxvu_l_length[11:8] <= data[3:0];
                    end
                    5'd6:
                    begin
                      rxvu_beamformed     <= data[1];
                      rxvu_gi_type        <= data[3:2];
                      rxvu_aggregation    <= 1'b1;
                      rxvu_stbc           <= data[4];
                    end
                    5'd12:
                    begin
                      rxvu_mcs            <= {3'b0,data[3:0]};
                      rxvu_nss            <= data[6:4];
                      rxvu_fec            <= data[7];
                    end
                    5'd13:
                    begin
                      rxvu_length[7:0]    <= data;
                    end
                    5'd14:
                    begin
                      rxvu_length[15:8]   <= data;
                    end
                    5'd15:
                    begin
                      rxvu_length[19:16]  <= data[3:0];
                    end
                    default: ;
                  endcase
                end
                default: /* HE_TB */
                begin
                  case(count)
                    5'd3: 
                    begin
                      rxvu_l_length[7:0]  <= data;
                    end
                    5'd4: 
                    begin
                      rxvu_l_length[11:8] <= data[3:0];
                    end
                    default: ;
                  endcase
                end
              endcase
            end
            
            if(rxvu1_last)
            begin
              rxvu1_captured    <= 1'b1;
              rxvl_locked       <= regb_intrxvlock_en;
              event_rxvl_locked <= regb_intrxvlock_en;
              count             <= 5'd0;
            end
            else
            begin
              count <= n_count;
            end
          end
          else if(!payload_done && !rxvu_ndp)
          begin
            if(valid && last)
            begin
              count        <= 5'd0;
              payload_done <= 1'b1;
            end
          end
          else if(!rxvu2_captured)
          begin
            if(rxvu2_last)
            begin
              rxvu2_captured <= 1'b1;
              count          <= 5'd0;
            end
            else
            begin
              count <= n_count;
            end
          end
        end
      end
    end
  end

endmodule
`default_nettype wire
