/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author:$
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :             
* Description      : rw_nx_he_macbypass
* Simulation Notes :             
* Synthesis Notes  :              
* Application Note :              
* Simulator        :             
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*           
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module rw_nx_macbypass_stat
(
  /* system */
  input  wire         clk,
  input  wire         rst_n,
  
  /* control */
  input  wire         clear,
  input  wire         incr_frame_ok,
  input  wire         incr_frame_bad,
  input  wire         incr_rxerr,
  input  wire         incr_rxend,
  input  wire         incr_phyerr,

  /* counters */
  output reg   [31:0] stat_frame_ok,
  output reg   [31:0] stat_frame_bad,
  output reg   [31:0] stat_rxerr,
  output reg   [31:0] stat_rxend,
  output reg   [31:0] stat_phyerr
);

  wire  [31:0]  n_stat_frame_ok;
  wire  [31:0]  n_stat_frame_bad;
  wire  [31:0]  n_stat_rxend;
  wire  [31:0]  n_stat_rxerr;
  wire  [31:0]  n_stat_phyerr;

  assign n_stat_frame_ok[15: 0]  = stat_frame_ok[15: 0]  + {15'd0, incr_frame_ok};
  assign n_stat_frame_ok[31:16]  = stat_frame_ok[31:16]  + {15'b0,&stat_frame_ok[15: 0]};
  assign n_stat_frame_bad[15: 0] = stat_frame_bad[15: 0] + {15'd0, incr_frame_bad};
  assign n_stat_frame_bad[31:16] = stat_frame_bad[31:16] + {15'b0,&stat_frame_bad[15: 0]};
  assign n_stat_rxend[15: 0]     = stat_rxend[15: 0]     + {15'd0, incr_rxend};
  assign n_stat_rxend[31:16]     = stat_rxend[31:16]     + {15'b0,&stat_rxend[15: 0]};
  assign n_stat_rxerr[15: 0]     = stat_rxerr[15: 0]     + {15'd0, incr_rxerr};
  assign n_stat_rxerr[31:16]     = stat_rxerr[31:16]     + {15'b0,&stat_rxerr[15: 0]};
  assign n_stat_phyerr[15: 0]    = stat_phyerr[15: 0]    + {15'd0, incr_phyerr};
  assign n_stat_phyerr[31:16]    = stat_phyerr[31:16]    + {15'b0,&stat_phyerr[15: 0]};

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      stat_frame_ok   <= 32'd0;
      stat_frame_bad  <= 32'd0;
      stat_rxerr      <= 32'd0;
      stat_rxend      <= 32'd0;
      stat_phyerr     <= 32'd0;   
    end
    else if(clear)
    begin
      stat_frame_ok   <= 32'd0;
      stat_frame_bad  <= 32'd0;
      stat_rxerr      <= 32'd0;
      stat_rxend      <= 32'd0;
      stat_phyerr     <= 32'd0;   
    end
    else
    begin
      stat_frame_ok   <= n_stat_frame_ok;
      stat_frame_bad  <= n_stat_frame_bad;
      stat_rxerr      <= n_stat_rxerr;
      stat_rxend      <= n_stat_rxend;
      stat_phyerr     <= n_stat_phyerr;
    end
  end

endmodule
`default_nettype wire
