/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author:$
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :             
* Description      : rw_nx_he_macbypass
* Simulation Notes :             
* Synthesis Notes  :              
* Application Note :              
* Simulator        :             
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*           
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module rw_nx_macbypass_trigger
( 
  /* system */
  input  wire        rst_n,                   
  input  wire        clk,                     

  /* registres */
  input  wire [ 3:0] regb_trigger0,
  input  wire [ 3:0] regb_trigger1,
  input  wire        regb_trig_format_en,     
  input  wire [ 3:0] regb_trig_format,        
  input  wire        regb_trig_mcs_en,        
  input  wire [ 6:0] regb_trig_mcs,           
  input  wire        regb_trig_gitype_en,        
  input  wire [ 1:0] regb_trig_gitype,           
  input  wire        regb_trig_fec_en,        
  input  wire        regb_trig_fec,           
  input  wire        regb_trig_stbc_en,       
  input  wire        regb_trig_stbc,          
  input  wire        regb_trig_chbw_en,       
  input  wire [ 2:0] regb_trig_chbw,          
  input  wire        regb_trig_nss_en,       
  input  wire [ 2:0] regb_trig_nss,          
  input  wire        regb_trig_sounding_en,   
  input  wire        regb_trig_sounding,      
  input  wire        regb_trig_paid_en,       
  input  wire [ 8:0] regb_trig_paid,          
  input  wire        regb_trig_gid_en,        
  input  wire [ 5:0] regb_trig_gid,           
  input  wire        regb_trig_smoothing_en,  
  input  wire        regb_trig_smoothing,     
    
  /* sources */
  input  wire        rxv_captured,
  input  wire [ 3:0] rxv_format,
  input  wire [ 6:0] rxv_mcs,
  input  wire [ 1:0] rxv_gitype,
  input  wire        rxv_fec,
  input  wire        rxv_stbc,
  input  wire [ 2:0] rxv_chbw,
  input  wire [ 2:0] rxv_nss,
  input  wire        rxv_sounding,
  input  wire [ 8:0] rxv_paid,
  input  wire [ 5:0] rxv_gid,
  input  wire        rxv_smoothing,
  input  wire        interrupt,
  input  wire        event_rx_fcs_update,
  input  wire        event_rx_fcs_ok,
  input  wire        event_rx_fcs_bad,
  input  wire        event_rx_delimiter_lost,
  input  wire        event_rx_rxerr,
  input  wire        event_rx_rxend,
    
  /* trigger */
  output reg   [ 1:0] event_trigger,
  output wire  [ 1:0] trigger
);

  reg [3:0] trigger0_sr;
  reg [3:0] trigger1_sr;

  wire  rxv_trigger;

  assign rxv_trigger = 
      (~regb_trig_format_en     | regb_trig_format    == rxv_format)   &  
      (~regb_trig_mcs_en        | regb_trig_mcs       == rxv_mcs)      &    
      (~regb_trig_gitype_en     | regb_trig_gitype    == rxv_gitype)   &   
      (~regb_trig_fec_en        | regb_trig_fec       == rxv_fec)      &   
      (~regb_trig_stbc_en       | regb_trig_stbc      == rxv_stbc)     &   
      (~regb_trig_chbw_en       | regb_trig_chbw      == rxv_chbw)     &   
      (~regb_trig_nss_en        | regb_trig_nss       == rxv_nss)      &   
      (~regb_trig_sounding_en   | regb_trig_sounding  == rxv_sounding) &      
      (~regb_trig_paid_en       | regb_trig_paid      == rxv_paid)     &      
      (~regb_trig_gid_en        | regb_trig_gid       == rxv_gid)      &      
      (~regb_trig_smoothing_en  | regb_trig_smoothing == rxv_smoothing);

  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      event_trigger <= 2'b0;
      trigger0_sr   <= 4'b0;
      trigger1_sr   <= 4'b0;
    end
    else
    begin
      /* event */
      case(regb_trigger0)
           4'd1: event_trigger[0] <= event_rx_fcs_update;
           4'd2: event_trigger[0] <= event_rx_fcs_update & event_rx_fcs_ok;
           4'd3: event_trigger[0] <= event_rx_fcs_update & event_rx_fcs_bad;
           4'd4: event_trigger[0] <= 1'b0;
           4'd5: event_trigger[0] <= event_rx_delimiter_lost;
           4'd6: event_trigger[0] <= event_rx_rxerr;
           4'd7: event_trigger[0] <= event_rx_rxend;
           4'd8: event_trigger[0] <= rxv_trigger;
           4'd9: event_trigger[0] <= interrupt;
        default: event_trigger[0] <= 1'b0;
      endcase
  
      case(regb_trigger1)
           4'd1: event_trigger[1] <= event_rx_fcs_update;
           4'd2: event_trigger[1] <= event_rx_fcs_update & event_rx_fcs_ok;
           4'd3: event_trigger[1] <= event_rx_fcs_update & event_rx_fcs_bad;
           4'd4: event_trigger[1] <= 1'b0;
           4'd5: event_trigger[1] <= event_rx_delimiter_lost;
           4'd6: event_trigger[1] <= event_rx_rxerr;
           4'd7: event_trigger[1] <= event_rx_rxend;
           4'd8: event_trigger[1] <= rxv_trigger;
           4'd9: event_trigger[1] <= interrupt;
        default: event_trigger[1] <= 1'b0;
      endcase
     
      /* enlarge trigger pulse for external la */
      trigger0_sr <= {1'b0,trigger0_sr[3:1]} | {4{event_trigger[0]}};
      trigger1_sr <= {1'b0,trigger1_sr[3:1]} | {4{event_trigger[1]}};
    end
  end

  assign trigger = {trigger1_sr[0],trigger0_sr[0]};

endmodule
`default_nettype wire
