/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : mpif_payload_tracking
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module rw_nx_macbypass_txv
(
  /* system */
  input  wire         clk,
  input  wire         rst_n,
  
  /* control */
  input  wire         txreq,
  output reg          done,
  
  /* input txv */
  input  wire [ 7:0]  txv0,
  input  wire [ 7:0]  txv1,
  input  wire [ 7:0]  txv2,
  input  wire [ 7:0]  txv3,
  input  wire [ 7:0]  txv4,
  input  wire [ 7:0]  txv5,
  input  wire [ 7:0]  txv6,
  input  wire [ 7:0]  txv7,
  input  wire [ 7:0]  txv8,
  input  wire [ 7:0]  txv9,
  input  wire [ 7:0]  txv10,
  input  wire [ 7:0]  txv11,
  input  wire [ 7:0]  txv12,
  input  wire [ 7:0]  txv13,
  input  wire [ 7:0]  txv14,
  input  wire [ 7:0]  txv15,
  input  wire [ 7:0]  txv16,
  input  wire [ 7:0]  txv17,
  input  wire [ 7:0]  txv18,
  input  wire [ 7:0]  txv19,
  input  wire [ 7:0]  txv20,
  input  wire [ 7:0]  txv21,
  input  wire [ 7:0]  txv22,
  input  wire [ 7:0]  txv23,
  input  wire [ 7:0]  txv24,
  input  wire [ 7:0]  txv25,
  
  /* output txv decoded */
  output reg  [ 3:0]  txv_format,
  output reg  [19:0]  txv_length,
  output reg          txv_aggregation,
  
  /* output data */
  output reg   [7:0]  data,
  output wire         last,
  output wire         valid
);

  localparam NON_HT     = 4'd0,
             NON_HT_DUP = 4'd1,
             HT_MM      = 4'd2,
             HT_GF      = 4'd3,
             VHT        = 4'd4,
             HE_SU      = 4'd5,
             HE_MU      = 4'd6,
             HE_ER_SU   = 4'd7,
             HE_TB      = 4'd8;
  
  reg  [ 4:0]   count;
  wire [ 4:0]   n_count;
  
  assign last = txv0==NON_HT     && count==5'd9  ||
                txv0==NON_HT_DUP && count==5'd9  ||
                txv0==HT_MM      && count==5'd12 ||
                txv0==HT_GF      && count==5'd12 ||
                txv0==VHT        && count==5'd16 ||
                txv0==HE_SU      && count==5'd17 ||
                txv0==HE_MU      && count==5'd25 ||
                txv0==HE_ER_SU   && count==5'd17 ||
                txv0==HE_TB      && count==5'd23;

  assign valid   = txreq & !done;
  assign n_count = count + 5'd1;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      count    <= 5'd0;
      done     <= 1'b0;
      data     <= 8'd0;
    end
    else
    begin
    
      case(n_count)                
        5'd0:    data <= txv0;   
        5'd1:    data <= txv1;   
        5'd2:    data <= txv2;   
        5'd3:    data <= txv3;   
        5'd4:    data <= txv4;   
        5'd5:    data <= txv5;   
        5'd6:    data <= txv6;   
        5'd7:    data <= txv7;   
        5'd8:    data <= txv8;   
        5'd9:    data <= txv9;   
        5'd10:   data <= txv10;  
        5'd11:   data <= txv11;  
        5'd12:   data <= txv12;  
        5'd13:   data <= txv13;  
        5'd14:   data <= txv14;  
        5'd15:   data <= txv15;  
        5'd16:   data <= txv16;  
        5'd17:   data <= txv17;  
        5'd18:   data <= txv18;  
        5'd19:   data <= txv19;  
        5'd20:   data <= txv20;  
        5'd21:   data <= txv21;  
        5'd22:   data <= txv22;  
        5'd23:   data <= txv23;  
        5'd24:   data <= txv24;  
        default: data <= txv25;  
      endcase                    
    
      if(!txreq)
      begin
        count <= 5'd0;
        data  <= txv0;
        done  <= 1'b0;
      end
      else if(!done)
      begin
        case(n_count)                
          5'd1:    data <= txv1;   
          5'd2:    data <= txv2;   
          5'd3:    data <= txv3;   
          5'd4:    data <= txv4;   
          5'd5:    data <= txv5;   
          5'd6:    data <= txv6;   
          5'd7:    data <= txv7;   
          5'd8:    data <= txv8;   
          5'd9:    data <= txv9;   
          5'd10:   data <= txv10;  
          5'd11:   data <= txv11;  
          5'd12:   data <= txv12;  
          5'd13:   data <= txv13;  
          5'd14:   data <= txv14;  
          5'd15:   data <= txv15;  
          5'd16:   data <= txv16;  
          5'd17:   data <= txv17;  
          5'd18:   data <= txv18;  
          5'd19:   data <= txv19;  
          5'd20:   data <= txv20;  
          5'd21:   data <= txv21;  
          5'd22:   data <= txv22;  
          5'd23:   data <= txv23;  
          5'd24:   data <= txv24;  
          default: data <= txv25;  
        endcase                    
        count <= n_count;
        if(last)
          done <= 1'b1;
      end
    end    
  end
  
  always @(*)
  begin
    txv_format      = txv0[3:0];
    txv_length      = 20'd0;
    txv_aggregation = 1'b0;
    
    case(txv_format)
      NON_HT,NON_HT_DUP:
      begin
        txv_length      = {8'b0,txv5[3:0],txv4};
      end
      HT_MM,HT_GF:
      begin
        txv_length      = {4'b0,txv12,txv11};
        txv_aggregation = txv8[3];
      end
      VHT:
      begin
        txv_length      = {txv16[3:0],txv15,txv14};
        txv_aggregation = 1'b1;
      end
      HE_SU,HE_ER_SU:
      begin
        txv_length      = {txv17[3:0],txv16,txv15};
        txv_aggregation = 1'b1;
      end
      HE_MU:
      begin
        txv_length      = {txv23[3:0],txv22,txv21};
        txv_aggregation = 1'b1;
      end
      default: /* HE_TB */
      begin
        txv_length      = {txv22[3:0],txv21,txv20};
        txv_aggregation = 1'b1;
      end
    endcase
  end
  
endmodule
`default_nettype wire
