//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : synchronize a one hot encoded bus with dstclk clock.
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module onehotSynchro #(parameter SYNC_WIDTH = 1)(
         input  wire                  dstclk,
         input  wire                  dstresetn,
         input  wire [SYNC_WIDTH-1:0] srcdata,

         output wire [SYNC_WIDTH-1:0] dstdata
);

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

 // Instanciation of the reference One Hot Synchronization cell

 ClkSyncSimpleTop #(.SIZE (SYNC_WIDTH)) u_ClkSyncSimpleTop
 (
   .dstclk(     dstclk),
   .dstresetn(  dstresetn),
   .srcdata(    srcdata),
   .dstdata(    dstdata)
  );


endmodule
                 
