//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : 
//   This module calculates a running CRC-32 on input data, and accumulates it in
//   internal registers. When icvSDrain_p is asserted, it places the accumulated
//   data byte by byte on output lines.
//                    
// Simulation Notes : 
// Synthesis Notes  :
//   If the DW_CRC_32 `define is enabled, the Design-ware component will be used 
//   for CRC-32 generation and checking. The Designware CRC-32 can be synthesized 
//   by synopsys syntheis tool only.  In case a synthesis tool other than synopsys
//   is being used, either crcGenChk has to be used or a netlist targetting the 
//   same library for FCS in EDIF format can be generated by synopsys tool, and 
//   the same can be included at the time Place and Route.           
// 
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module icv (

           //$port_g Inputs
           bbClk,                 // baseband clock signal
           hardRstBbClk_n,        // reset signal from hardware
           dataToICV,             // input to the FCS Block
           icvStart_p,            // indication to start taking in the data
           icvSDrain_p,           // indication to start draining tha data
           icvEnable_p,           // enable input to FCS

           //$port_g Outputs
           dataFromICV,           // output of the FCS block
           icvCRCOk               // CRC OK 

                );

//--------------------- inputs declared ------------------

  input                               bbClk;
  input                               hardRstBbClk_n;
  input  [7:0]                        dataToICV;
  input                               icvStart_p;
  input                               icvSDrain_p;
  input                               icvEnable_p;

//--------------------- outputs declared ------------------

  output [7:0]                        dataFromICV;
  output                              icvCRCOk;

//--------------------- wires ------------------

  wire                                bbClk;
  wire                                hardRstBbClk_n;
  wire   [7:0]                        dataToICV;
  wire                                icvStart_p;
  wire                                icvSDrain_p;
  wire                                icvEnable_p;
  wire   [7:0]                        dataOut;
  wire                                icvCRCOk;
  wire                                crcGenChkEnable;

//--------------------- wires ------------------

  reg [7:0] dataFromICV;

//------------Instantiation of Design ware component ----------------

  assign crcGenChkEnable = (icvEnable_p || icvStart_p);

  crcGenChk U_crcGenChk (
      .clk (bbClk),
      .reset_N (hardRstBbClk_n),
      .start (icvStart_p),
      .enable (crcGenChkEnable),
      .drain (icvSDrain_p),
      .d_in (dataToICV),

      .d_out (dataOut),
      .crc_ok (icvCRCOk)
        );


  always @ (posedge bbClk or negedge hardRstBbClk_n)
  begin
    if (!hardRstBbClk_n)
      dataFromICV <= 8'h0;
    else if (icvEnable_p)
      dataFromICV <= dataOut;
  end

endmodule

//------------------- END OF FILE ----------------//
