//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : wrapper to matching the registers interface
//                                     
// Simulation Notes : 
// Synthesis Notes  : 
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////

module dmaEngineWrapper (
   //input wires
   //Clocks
   //Secondary clock for TX DMA modules. 
   //Synchronized to macPIClk domain. 
   input wire        macPITxClk,

   //Secondary clock for RX DMA modules. 
   //Synchronized to macPIClk domain.
   input wire        macPIRxClk,

   //source clock signals not resynchronized
   input  wire       macCoreClk,              // mac core clock             

   //source clock signals not resynchronized
   input  wire       macCoreRxClk,              // mac core Rx clock             

   //Primary clock for the common modules
   input wire        macPIClk,

   //Resets
   //Hard Reset synchronized to macPITxClk domain
   input wire        macPITxClkHardRst_n,

   //Hard Reset synchronized to macPIRxClk domain
   input wire        macPIRxClkHardRst_n,

   //Hard Reset synchronized to macPIClk domain
   input wire        macPIClkHardRst_n,

   //Hard Reset synchronized to macCoreClk domain
   input  wire       macCoreClkHardRst_n,       // mac core Tx clock reset       

   //Soft Reset synchronized to macPITxClk domain
   input wire        macPITxClkSoftRst_n,

   //Soft Reset synchronized to macPIRxClk domain
   input wire        macPIRxClkSoftRst_n,

   //Soft Reset synchronized to macPIClk domain
   input wire        macPIClkSoftRst_n,

   //dmaHIF Master Interface
   //Data read from the SRAM during a dmaHIF read transfer
   input wire [31:0] dmaHIFReadDataOut,

   //Data in dmaHIFReadData is valid when this signal is 
   //asserted HIGH 
   input wire        dmaHIFReadDataValid,

   //Driven high to indicate that either the single or 
   //burst transfer is complete
   input wire        dmaHIFTransComplete,

   //Driven high when the next data needs to pushed on the interface
   input wire        dmaHIFReady,
   
   //Driven high when the error response is received from 
   //the external addressed dmaHIF slave for the transfer 
   //initiated
   input wire        dmaHIFError,

   //MAC Controller
   //Trigger from the MAC Controller to indicate DMA to 
   //start fetching frames associated with AC0
   input wire        trigTxAC0,

   //Trigger from the MAC Controller to indicate DMA to 
   //start fetching frames associated with AC1
   input wire        trigTxAC1,

   //Trigger from the MAC Controller to indicate DMA to 
   //start fetching frames associated with AC2
   input wire        trigTxAC2,

   //Trigger from the MAC Controller to indicate DMA to 
   //start fetching frames associated with AC3
   input wire        trigTxAC3,

   //Trigger from the MAC Controller to indicate DMA to 
   //start fetching frames associated with Beacon
   input wire        trigTxBcn,

   //Trigger from the MAC Controller to indicate DMA to 
   //start fetching frames associated with Trigger Based
   input wire        trigTxTB,

   // trigTxAC0 Resynchronized on macPITxClk clock domain
   input wire        trigTxAC0PI,

   // trigTxAC1 Resynchronized on macPITxClk clock domain
   input wire        trigTxAC1PI,

   // trigTxAC2 Resynchronized on macPITxClk clock domain
   input wire        trigTxAC2PI,

   // trigTxAC3 Resynchronized on macPITxClk clock domain
   input wire        trigTxAC3PI,

   // trigTxBcn Resynchronized on macPITxClk clock domain
   input wire        trigTxBcnPI,

   // trigTxTB Resynchronized on macPITxClk clock domain
   input wire        trigTxTBPI,

   //MAC Controller indicates a frame is successfully 
   //received
   input wire        frameRxed_p,
   output wire       rxListProcCsIsIdle,  // rxListProc FSM is in IDLE state
   output wire       txListProcCsIsIdle,  // txListProc FSM is in IDLE state

   //TSF Timer value
   input wire [31:0] tsfTimerValue,

   // trigs the DMA Status update.
   input wire        updateDMAStatus_p,

   //Asserted high if the current transmitted packet is a
   //RTS frame prepared by SW
   input wire        swRTS_p,

   //Asserted high after every transmission of MPDU in an 
   //AMPDU frame
   input wire        txMpduDone_p,

   //Asserted high if the transmitted packet was an AMPDU 
   //frame
   input wire        ampduFrm_p,

   //If the transmitted frame has to be retried then this 
   //signal is asserted.
   input wire        retryFrame_p,

   //If the transmitted frame was successful. Not asserted
   //for RTS frames
   input wire        mpduSuccess_p,

   //If the transmitted frame was not successful. Not asserted
   //if the RTS frame failed
   input wire        mpduFailed_p,

   //If the transmitted frame was a RTS frame and did not 
   //receive a CTS frame within the CTS timeout
   input wire        rtsFailed_p,

   //If the transmitted frame was a RTS frame and successfully
   //received a CTS in reponse.
   input wire        rtsSuccess_p,

   //If the transmitted frame was not successful and has reached
   //the retry limit.Is asserted for both RTS and other MPDU's
   input wire        retryLimitReached_p,

   //Indicates whether the frame was transmitted with 20MHz, 40Mhz, 80MHz or 160Mhz BW
   input wire [1:0]  transmissionBW,

   //Indicates the number of retries for this MPDU. Valid when 
   //rtsFailed_p rtsSuccess_p mpduSuccess_p mpduFailed_p or 
   //retryLimitReached 
   input wire [7:0]  numMPDURetries,

   //indicates the the number of times the RTS has been sent.
   //Valid when rtsFailed_p rtsSuccess_p mpduSuccess_p 
   //mpduFailed_p or retryLimitReached 
   input wire [7:0]  numRTSRetries,
   
   // Updated value of medium time used for this MPDU or A-MPDU.
   input wire [31:0] mediumTimeUsed,

   //rxController interface Discard the current rx frame : no more descriptor and rxFlowCntrlEn == 1
   output wire        rxFrmDiscard,
   // Indicate to rxController that Current frame has a all necessaries descripstor
   output wire        rxDescAvailable,

   input  wire [30:0] rxBuf1StartPtr,                // Receive buffer 1 start pointer
   input  wire [30:0] rxBuf1EndPtr,                  // Receive buffer 1 end   pointer
   input  wire [31:0] rxBuf1RdPtr,                   // Receive buffer 1 read  pointer
   input  wire [31:0] rxBuf1WrPtr,                   // Receive buffer 1 write pointer
   output wire [31:0] rxBuf1WrPtrIn,                 // Receive buffer 1 write pointer
   output wire        rxBuf1WrPtrInValid,            // Receive buffer 1 write pointer update
   input  wire [30:0] rxBuf2StartPtr,                // Receive buffer 2 start pointer
   input  wire [30:0] rxBuf2EndPtr,                  // Receive buffer 2 end   pointer
   input  wire [31:0] rxBuf2RdPtr,                   // Receive buffer 2 read  pointer
   input  wire [31:0] rxBuf2WrPtr,                   // Receive buffer 2 write pointer
   output wire [31:0] rxBuf2WrPtrIn,                 // Receive buffer 1 write pointer
   output wire        rxBuf2WrPtrInValid,            // Receive buffer 1 write pointer update
   input  wire  [7:0] rxBufRHDHeader,                // Receive buffer RHD header size
   input  wire  [7:0] rxBufRHDFooter,                // Receive buffer RHD footer size
   input  wire  [7:0] rxBufRPDHeader,                // Receive buffer RHD header size
   input  wire  [7:0] rxBufRPDFooter,                // Receive buffer RHD footer size
   input  wire  [7:0] partialUnwrapSize,             // Partial Unwrap Size
   

   //registers interface rx Flow Control Enable
   input  wire        rxFlowCntrlEn,

   input  wire [ 3:0] whichDescriptorSW,             // Indicates the value of the partAMorMSDU field Controller

   //Frame Length mismatch detected by the MAC Controller
   input wire         macPHYIFUnderRun,


   // TXTBHEADPTRREG register.
   input wire [31 : 0] txTBHeadPtr    , //Transmit Trigger Based List Head Pointer

   // TXBCNHEADPTRREG register.
   input wire [31 : 0] txBcnHeadPtr   , //Transmit Beacon List Head Pointer

    // TXAC0HEADPTRREG register.
   input wire [31 : 0] txAC0HeadPtr   , //Transmit AC0 List Head Pointer

    // TXAC1HEADPTRREG register.
   input wire [31 : 0] txAC1HeadPtr   , //Transmit AC1 List Head Pointer

    // TXAC2HEADPTRREG register.
   input wire [31 : 0] txAC2HeadPtr   , //Transmit AC2 List Head Pointer

    // TXAC3HEADPTRREG register.
   input wire [31 : 0] txAC3HeadPtr   , //Transmit AC3 List Head Pointer 

   //TX Control Registers
   //Indicates there are 2 sets of parameters 
   //already in the tx Parameter Cache module
   //and not to fetch more
   input wire        txCtrlRegBusy,

   //TX FIFO
   //FIFO Full indication
   input wire        txFifoAlmostFull,
   input wire        txFifoFull,

   //FIFO Empty indication
   input wire        txFifoEmpty,
   output wire       txFIFOFlushDone_p,
                   
   //RX FIFO
   //FIFO empty indication
   input wire        rxFifoEmpty,
   //FIFO almost empty indication
   input wire        rxFIFOAlmEmpty,

   //Data read from RX FIFO
   input wire [31:0] rxFifoRdData,


   //RX TAG FIFO
   //Data from TAG FIFO
   input wire  [3:0] rxTagFifoRdData,


   //output wires
   //dmaHIF Master Interface      
   //Active High pulse indicating that a read transfer
   //has to be initiated on the dmaHIF
   output wire        dmaHIFRead,

   //Active High pulse indicating that a write transfer
   //has to be initiated on the dmaHIF
   output wire        dmaHIFWrite,

   //Indicates teh type of burst to be performed on teh dmaHIF
   output wire  [2:0] dmaHIFSize,

   //Address put out by the read write controller to the 
   //dmaHIF master interface. Starting address for the transfer
   //is provided by this bus
   output wire [31:0] dmaHIFAddressIn,

   //Data to be written to the SRAM is passed by the read write
   //controller to the dmaHIF master interface
   output wire [31:0] dmaHIFWriteDataIn,

   //TX parameter Cache module signals
   //Write signal to the Tx Parameter Cache
   output wire        txCtrlRegWr,

   //Indicates currently Policy table information is
   //being passed
   output wire        txCtrlRegPT,

   //Indicates currently Header descriptor information
   //is being passed
   output wire        txCtrlRegHD,

   //Signal to TX Parameter Cache module. 
   //Indicates to discard the recently 
   //fetch Header Descriptor
   output wire        discardPrevHD_p,

   //DMA state for AC0 channel. Registers will be updated with
   //this information
   output wire  [1:0] txAC0State,

   //DMA state for AC1 channel. Registers will be updated with
   //this information
   output wire  [1:0] txAC1State,

   //DMA state for AC2 channel. Registers will be updated with
   //this information
   output wire  [1:0] txAC2State,

   //DMA state for AC3 channel. Registers will be updated with
   //this information
   output wire  [1:0] txAC3State,

   //DMA state for Beacon channel. Registers will be updated with
   //this information
   output wire  [1:0] txBcnState,

   //DMA state for Trigger Based channel. Registers will be updated with
   //this information
   output wire  [1:0] txTBState,

   //DMA state for AC0 channel. Registers will be updated with
   //this information
   output reg   [3:0] txAC0StateMC,

   //DMA state for AC1 channel. Registers will be updated with
   //this information
   output reg   [3:0] txAC1StateMC,

   //DMA state for AC2 channel. Registers will be updated with
   //this information
   output reg   [3:0] txAC2StateMC,

   //DMA state for AC3 channel. Registers will be updated with
   //this information
   output reg   [3:0] txAC3StateMC,

   //DMA state for Beacon channel. Registers will be updated with
   //this information
   output reg   [3:0] txBcnStateMC,

   //DMA state for Trigger Based channel. Registers will be updated with
   //this information
   output reg   [3:0] txTBStateMC,

   // Transmit Length Mismatch
   output wire        txLenMismatch, 
   // Transmit Unique Pattern Error
   output wire        txUPatternErr,     
   // Transmit Next Pointer Error
   output wire        txNextPointerErr,  
   // Transmit Policy Table Address Error
   output wire        txPTAddressErr,       
   // Transmit Bus Error
   output wire        txBusErr,          
   // Transmit New Head Error
   output wire        txNewHeadErr,      
   // Receive Header Bus Error
   output wire        rxHdrBusErr,         
   // Receive Payload Bus Error
   output wire        rxPayBusErr,         
   // Transmit PolicyTable Error
   output wire        ptError,
   // Transmit Beacon Startup      
   output wire        txBcnStartup,       
   // Transmit AC0 New Head Error
   output wire        txAC0Startup,       
   // Transmit AC1 New Head Error
   output wire        txAC1Startup,       
   // Transmit AC2 New Head Error
   output wire        txAC2Startup,       
   // Transmit AC3 New Head Error
   output wire        txAC3Startup,       
   // Transmit Beacon End of Queue
   output wire        txBcnEndQ,          
   // Transmit AC0 End of Queue
   output wire        txAC0EndQ,          
   // Transmit AC1 End of Queue
   output wire        txAC1EndQ,          
   // Transmit AC2 End of Queue
   output wire        txAC2EndQ,          
   // Transmit AC3 End of Queue
   output wire        txAC3EndQ,          
   // Transmit TB Halt After TXOP
   output wire        txTBHaltAfterTXOP, 
   // Transmit Beacon Halt After TXOP
   output wire        txBcnHaltAfterTXOP, 
   // Transmit AC0 Halt After TXOP
   output wire        txAC0HaltAfterTXOP, 
   // Transmit AC1 Halt After TXOP
   output wire        txAC1HaltAfterTXOP, 
   // Transmit AC2 Halt After TXOP
   output wire        txAC2HaltAfterTXOP, 
   // Transmit AC3 Halt After TXOP
   output wire        txAC3HaltAfterTXOP, 

   output wire [15:0] debugPortDMA1,
   output wire [15:0] debugPortDMA2,
   output wire [15:0] debugPortDMA3,
   output wire [15:0] debugPortDMA4,
   output wire [15:0] debugPortDMA5,
   output wire [15:0] debugPortDMA6,
   output wire [15:0] debugPortDMAStatus,
   output wire [15:0] debugPortDMATxStatus,
   output wire [15:0] debugPortTxRxListA,
   output wire [15:0] debugPortDmaRdWrCtlr,

   output wire        dmaInternalError,// Generate a pulse when an internal error occured

   // Indication from the DMA that status have been updated.
   output wire        statusUpdated_p,

   //TX FIFO
   //Read signal to TX FIFO
   output wire        txFifoWr,

   //Read signal to TX FIFO
   output wire [31:0] txFIFOWrData,

   //Flush signal to TX FIFo
   output wire        flushTxFifo,

   //RX FIFO
   //Write signal to RX FIFO
   output wire        rxFifoRd,

   //TX TAG FIFO
   //Data to write to TX TAG FIFO
   output wire  [5:0] txTagFifoWrData,

   //Interrupt Controller
   //Transmit Channel error
   output wire        tbTxDMADead,    // tbTxDMADead output mask interruption
   output wire        bcnTxDMADead,   // bcnTxDMADead output mask interruption
   output wire        ac3TxDMADead,   // ac3TxDMADead output mask interruption
   output wire        ac2TxDMADead,   // ac2TxDMADead output mask interruption
   output wire        ac1TxDMADead,   // ac1TxDMADead output mask interruption
   output wire        ac0TxDMADead,   // ac0TxDMADead output mask interruption

   //Receive Channel error
   output wire        rxPayloadDMADead,   // rxPayloadDMADead output mask interruption
   output wire        rxHeaderDMADead,    // rxHeaderDMADead output mask interruption

   output wire        ac0TxTrigger,       //trigger for transmission interrupt for AC0,
   output wire        ac1TxTrigger,       //trigger for transmission interrupt for AC1,
   output wire        ac2TxTrigger,       //trigger for transmission interrupt for AC2,
   output wire        ac3TxTrigger,       //trigger for transmission interrupt for AC3,
   output wire        bcnTxTrigger,       //trigger for transmission interrupt for Beacon,
   output wire        tbTxTrigger,        //trigger for transmission interrupt for TB,

   output wire        ac0TxBufTrigger,    //trigger for Payload Buffer transmission interrupt for AC0,
   output wire        ac1TxBufTrigger,    //trigger for Payload Buffer transmission interrupt for AC1,
   output wire        ac2TxBufTrigger,    //trigger for Payload Buffer transmission interrupt for AC2,
   output wire        ac3TxBufTrigger,    //trigger for Payload Buffer transmission interrupt for AC3,
   output wire        bcnTxBufTrigger,    //trigger for Payload Buffer transmission interrupt for Beacon,
   output wire        tbTxBufTrigger,     //trigger for Payload Buffer transmission interrupt for TB,

   //$port_g Trigger for receive interrupt
   output wire        rxBuffer1Trigger,           // Trigger for receive Buffer 1 interrupt
   output wire        rxBuffer2Trigger,           // Trigger for receive Buffer 2 interrupt
   output wire        rxTrig_p,                   // Indicate that the RX Descriptor Done has been written
   output wire        tbProtTrigger,              // Indicate that a trigger frame has been 
                                                  // received and stored

   // Tx Status pointers
   output wire [31:0] ac0StatusPointer,           // Status ptr of AC0 channel
   output wire [31:0] ac1StatusPointer,           // status ptr of AC1 channel
   output wire [31:0] ac2StatusPointer,           // status ptr of AC2 channel
   output wire [31:0] ac3StatusPointer,           // Status ptr of AC3 channel
   output wire [31:0] bcnStatusPointer,           // status ptr of beacon channel
   output wire [31:0] tbStatusPointer,            // status ptr of Trigger Based channel
   output wire [31:0] txCurrentPointer,           // status of the current pointer
   
   
   //Rx Status Pointers
   output wire [29:0] rxHeaderTFPtr,              // Receive Header Trigger Frame Pointer

   //
   output wire statussettxAC0NewTail            , //Status signal of txAC0NewTail bit in
                                                  //the DMA Control register
   output wire statussettxAC1NewTail            , //Status signal of txAC1NewTail bit in
                                                  //the DMA Control register
   output wire statussettxAC2NewTail            , //Status signal of txAC2NewTail bit in
                                                  //the DMA Control register
   output wire statussettxAC3NewTail            , //Status signal of txAC3NewTail bit in
                                                  //the DMA Control register
   output wire statussettxBcnNewTail            , //Status signal of txBcnNewTail bit in
                                                  //the DMA Control register
   output wire statussettxAC0NewHead            , //Status signal of txAC0NewHead bit in
                                                  //the DMA Control register
   output wire statussettxAC1NewHead            , //Status signal of txAC1NewHead bit in
                                                  //the DMA Control register
   output wire statussettxAC2NewHead            , //Status signal of txAC2NewHead bit in
                                                  //the DMA Control register
   output wire statussettxAC3NewHead            , //Status signal of txAC3NewHead bit in
                                                  //the DMA Control register
   output wire statussettxBcnNewHead            , //Status signal of txBcnNewHead bit in
                                                  //the DMA Control register
   output wire statussettxTBNewHead             , //Status signal of txTBNewHead bit in
                                                  //the DMA Control register

   output wire statussethaltTBAfterTXOP         ,

   output wire statussethaltBcnAfterTXOP        ,
   
   output wire statussethaltAC3AfterTXOP        ,
   
   output wire statussethaltAC2AfterTXOP        ,
   
   output wire statussethaltAC1AfterTXOP        ,
   
   output wire statussethaltAC0AfterTXOP        ,
   



   input wire  settxAC0NewTail                  ,   //Set signal to Set the txAC0NewTail bit in
                                                    //the DMA Control register
   input wire  settxAC1NewTail                  ,   //Set signal to Set the txAC1NewTail bit in
                                                    //the DMA Control register
   input wire  settxAC2NewTail                  ,   //Set signal to Set the txAC2NewTail bit in
                                                    //the DMA Control register
   input wire  settxAC3NewTail                  ,   //Set signal to Set the txAC3NewTail bit in
                                                    //the DMA Control register
   input wire  settxBcnNewTail                  ,   //Set signal to Set the txBcnNewTail bit in
                                                    //the DMA Control register
   input wire  settxAC0NewHead                  ,   //Set signal to Set the txAC0NewHead bit in
                                                    //the DMA Control register
   input wire  settxAC1NewHead                  ,   //Set signal to Set the txAC1NewHead bit in
                                                    //the DMA Control register
   input wire  settxAC2NewHead                  ,   //Set signal to Set the txAC2NewHead bit in
                                                    //the DMA Control register
   input wire  settxAC3NewHead                  ,   //Set signal to Set the txAC3NewHead bit in
                                                    //the DMA Control register
   input wire  settxBcnNewHead                  ,   //Set signal to Set the txBcnNewHead bit in
                                                    //the DMA Control register
   input wire  settxTBNewHead                   ,   //Set signal to Set the txTBNewHead bit in
                                                    //the DMA Control register
   input wire  sethaltTBAfterTXOP               ,
   
   input wire  sethaltBcnAfterTXOP              ,
   
   input wire  sethaltAC3AfterTXOP              ,
   
   input wire  sethaltAC2AfterTXOP              ,
   
   input wire  sethaltAC1AfterTXOP              ,
   
   input wire  sethaltAC0AfterTXOP              ,
   

   input wire  cleartxAC0NewTail                ,   //Clear signal to Clear the txAC0NewTail bit in
                                                    //the DMA Control register
   input wire  cleartxAC1NewTail                ,   //Clear signal to Clear the txAC1NewTail bit in
                                                    //the DMA Control register
   input wire  cleartxAC2NewTail                ,   //Clear signal to Clear the txAC2NewTail bit in
                                                    //the DMA Control register
   input wire  cleartxAC3NewTail                ,   //Clear signal to Clear the txAC3NewTail bit in
                                                    //the DMA Control register
   input wire  cleartxBcnNewTail                ,   //Clear signal to Clear the txBcnNewTail bit in
                                                    //the DMA Control register
   input wire  cleartxAC0NewHead                ,   //Clear signal to Clear the txAC0NewHead bit in
                                                    //the DMA Control register
   input wire  cleartxAC1NewHead                ,   //Clear signal to Clear the txAC1NewHead bit in
                                                    //the DMA Control register
   input wire  cleartxAC2NewHead                ,   //Clear signal to Clear the txAC2NewHead bit in
                                                    //the DMA Control register
   input wire  cleartxAC3NewHead                ,   //Clear signal to Clear the txAC3NewHead bit in
                                                    //the DMA Control register
   input wire  cleartxBcnNewHead                ,   //Clear signal to Clear the txBcnNewHead bit in
                                                    //the DMA Control register
   input wire  cleartxTBNewHead                 ,   //Clear signal to Clear the txTBNewHead bit in
                                                    //the DMA Control register
   input wire  clearhaltTBAfterTXOP             ,
   
   input wire  clearhaltBcnAfterTXOP            ,
   
   input wire  clearhaltAC3AfterTXOP            ,
   
   input wire  clearhaltAC2AfterTXOP            ,
   
   input wire  clearhaltAC1AfterTXOP            ,
   
   input wire  clearhaltAC0AfterTXOP            
   
   
   
      );


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////

reg        haltAC0AfterTXOP;
reg        haltAC1AfterTXOP;
reg        haltAC2AfterTXOP;
reg        haltAC3AfterTXOP;
reg        haltBcnAfterTXOP;
reg        haltTBAfterTXOP;

wire       bufferInterruptTx;     //

reg        txNewTailAC0;
reg        txNewTailAC1;
reg        txNewTailAC2;
reg        txNewTailAC3;
reg        txNewTailBcn;
reg        txNewHeadAC0;
reg        txNewHeadAC1;
reg        txNewHeadAC2;
reg        txNewHeadAC3;
reg        txNewHeadBcn;
reg        txNewHeadTB;
reg        txNewHeadAC0_waitIdle;
reg        txNewHeadAC1_waitIdle;
reg        txNewHeadAC2_waitIdle;
reg        txNewHeadAC3_waitIdle;
reg        txNewHeadBcn_waitIdle;
reg        txNewHeadTB_waitIdle;

wire       rstAC0NewTail;
wire       rstAC1NewTail;
wire       rstAC2NewTail;
wire       rstAC3NewTail;
wire       rstBcnNewTail;
wire       rstAC0NewHead;
wire       rstAC1NewHead;
wire       rstAC2NewHead;
wire       rstAC3NewHead;
wire       rstBcnNewHead;
wire       rstTBNewHead;


// resynchronized signals
//wire        trigTxAC0sync;
//wire        trigTxAC1sync;
//wire        trigTxAC2sync;
//wire        trigTxAC3sync;
//wire        trigTxBcnsync;
wire        underRunDetected_p;

// resynchronized signals
wire        dmaframeRxed_p;                // frameRxed_p resynchronized with macPIClk      
wire        dmarxListProcCsIsIdle;         // rxListProcCsIsIdle from DMAEngine before resynchronization to macCoreClock domain
wire        dmatxListProcCsIsIdle;         // txListProcCsIsIdle from DMAEngine before resynchronization to macCoreClock domain
reg         swRTSResync_p;                 // swRTS_p resynchronized with macPIClk        
wire        txMpduDoneResync_p;            // txMpduDone_p resynchronized with macPIClk   
reg         txMpduDoneResyncDly_p;         // txMpduDoneResyncDly_p is txMpduDoneResync_p delayed of 1cc
reg         ampduFrmResync_p;              // ampduFrm_p resynchronized with macPIClk     
reg         retryFrameResync_p;            // retryFrame_p resynchronized with macPIClk   
reg         mpduSuccessResync_p;           // mpduSuccess_p resynchronized with macPIClk  
reg         mpduFailedResync_p;            // mpduFailed_p resynchronized with macPIClk   
reg         rtsFailedResync_p;             // rtsFailed_p resynchronized with macPIClk    
reg         rtsSuccessResync_p;            // rtsSuccess_p resynchronized with macPIClk   
reg         retryLimitReachedResync_p;     // retryLimitReached_p resynchronized with macPIClk 

reg  [1:0]  transmissionBWResync;          // transmissionBW resynchronized with macPIClk
reg  [7:0]  numMPDURetriesResync;          // numMPDURetries resynchronized with macPIClk
reg  [7:0]  numRTSRetriesResync;           // numRTSRetries resynchronized with macPIClk
reg  [31:0] mediumTimeUsedResync;          // mediumTimeUsed resynchronized with macPIClk


reg  [3:0]  whichDescriptorSWResync;       // whichDescriptorSW resynchronized with macPIClk
wire        updateDMAStatusResync_p;       // updateDMAStatus_p resynchronized with macPIClk
reg         updateDMAStatusResyncDly_p;    // updateDMAStatusResyncDly_p is updateDMAStatusResync_p delayed of 1cc
reg         updateDMAStatusResyncDly2_p;    // updateDMAStatusResyncDly_p is updateDMAStatusResync_p delayed of 1cc

wire        rxFlowCntrlEnResync;           // Resync from macCore register domain
// signals for debug
wire        oredNewHead;                // indicate a newhead trigger
wire        oredNewTail;                // indicate a newTail trigger
wire        txInterrupt;                // 
wire        rxInterrupt;                // 

// Internal DMA States signals for resynchronization and 
// One Hot to Binary conversion
wire  [3:0] txAC0StateInt;              // DMA state for AC0 channel on macPIClk
wire  [3:0] txAC1StateInt;              // DMA state for AC1 channel on macPIClk
wire  [3:0] txAC2StateInt;              // DMA state for AC2 channel on macPIClk
wire  [3:0] txAC3StateInt;              // DMA state for AC3 channel on macPIClk
wire  [3:0] txBcnStateInt;              // DMA state for Beacon channel on macPIClk
wire  [3:0] txTBStateInt;               // DMA state for Trigger Based channel on macPIClk
wire  [3:0] txAC0StateMCInt;            // DMA state for AC0 channel on macCoreClk
wire  [3:0] txAC1StateMCInt;            // DMA state for AC1 channel on macCoreClk
wire  [3:0] txAC2StateMCInt;            // DMA state for AC2 channel on macCoreClk
wire  [3:0] txAC3StateMCInt;            // DMA state for AC3 channel on macCoreClk
wire  [3:0] txBcnStateMCInt;            // DMA state for Beacon channel on macCoreClk
wire  [3:0] txTBStateMCInt;             // DMA state for Trigger Based channel on macCoreClk

wire        statusUpdatedInt_p;         // statusUpdated_p before resynchronizationon macCoreClk

wire  [4:0] txListProcCs;               // Current State counter
wire  [4:0] rxListProcCs;               // Current State counter
wire        interruptEnTx;              // Interrupt Enable information in THD
wire        statusUpdaterFull;          // Indicate the status updater is full

wire        tbTxDMADead_int;
wire        bcnTxDMADead_int;
wire        ac3TxDMADead_int;
wire        ac2TxDMADead_int;
wire        ac1TxDMADead_int;
wire        ac0TxDMADead_int;
wire        dmaInternalError_int;// Generate a pulse when an internal error occured

wire        rxTrigInt_p;               // Indicate that the RX Descriptor Done has been written in macPIClk

wire        rxFrmDiscardResync;
wire        rxDescAvailableResync;
wire        rxFrmDiscardRet;

reg         txStateActiveMC;
wire        txStateActive;
wire        txStateActiveMC_resync;
  
wire        dmaTxFIFOFlushDone_p;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////
// Conversion function between One Hot encoding to binay.
//////////////////////////////////////////////////////////////////
function [1:0] convOneHotToBin ;
input   [3:0] onehot ;
begin
  case (onehot)
    4'b0001 : convOneHotToBin = 2'd0;
    4'b0010 : convOneHotToBin = 2'd1;
    4'b0100 : convOneHotToBin = 2'd2;
    4'b1000 : convOneHotToBin = 2'd3;
    default : convOneHotToBin = 2'd0;
  endcase
end
endfunction


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewTailAC0 <= 1'b0;
  end
  else if(macPIClkSoftRst_n == 1'b0)
  begin
    txNewTailAC0 <= 1'b0;
  end
  else 
  begin
    if ( (rstAC0NewTail == 1'b1) || (cleartxAC0NewTail)) begin
      txNewTailAC0 <= 1'b0;
    end
    else if (settxAC0NewTail == 1'b1) begin
      txNewTailAC0 <= 1'b1;
    end
  end
end

assign statussettxAC0NewTail  = txNewTailAC0;


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewTailAC1 <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewTailAC1 <= 1'b0;
  end
  else 
  begin
    if ( (rstAC1NewTail == 1'b1) || (cleartxAC1NewTail)) begin
      txNewTailAC1 <= 1'b0;
    end
    else if (settxAC1NewTail == 1'b1) begin
      txNewTailAC1 <= 1'b1;
    end
  end
end

assign statussettxAC1NewTail  = txNewTailAC1;


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewTailAC2 <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewTailAC2 <= 1'b0;
  end 
  else 
  begin
    if ( (rstAC2NewTail == 1'b1) || (cleartxAC2NewTail)) begin
      txNewTailAC2 <= 1'b0;
    end
    else if (settxAC2NewTail == 1'b1) begin
      txNewTailAC2 <= 1'b1;
    end
  end
end

assign statussettxAC2NewTail  = txNewTailAC2;


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewTailAC3 <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewTailAC3 <= 1'b0;
  end
  else 
  begin
    if ( (rstAC3NewTail == 1'b1) || (cleartxAC3NewTail)) begin
      txNewTailAC3 <= 1'b0;
    end
    else if (settxAC3NewTail == 1'b1) begin
      txNewTailAC3 <= 1'b1;
    end
  end
end

assign statussettxAC3NewTail  = txNewTailAC3;


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewTailBcn <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewTailBcn <= 1'b0;
  end
  else 
  begin
    if ( (rstBcnNewTail == 1'b1) || (cleartxBcnNewTail)) begin
      txNewTailBcn <= 1'b0;
    end
    else if (settxBcnNewTail == 1'b1) begin
      txNewTailBcn <= 1'b1;
    end
  end
end

assign statussettxBcnNewTail  = txNewTailBcn;


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewHeadAC0          <= 1'b0;
    txNewHeadAC0_waitIdle <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewHeadAC0          <= 1'b0;
    txNewHeadAC0_waitIdle <= 1'b0;
  end
  else 
  begin
    if ((rstAC0NewHead == 1'b1) || (cleartxAC0NewHead))
    begin
      txNewHeadAC0          <= 1'b0;
      txNewHeadAC0_waitIdle <= 1'b0;
    end
    else if ((txAC0StateInt[3:0] == 4'h1) || (txAC0StateInt[3:0] == 4'h2))
    begin
      if ((settxAC0NewHead == 1'b1) || (txNewHeadAC0_waitIdle == 1'b1))
      begin
        txNewHeadAC0          <= 1'b1;
        txNewHeadAC0_waitIdle <= 1'b0;
      end
    end
    else if ((settxAC0NewHead == 1'b1) && (txAC0StateInt[3:0] == 4'h4))
    begin
      txNewHeadAC0_waitIdle <= 1'b1;
    end
  end
end

assign statussettxAC0NewHead  = txNewHeadAC0;


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewHeadAC1          <= 1'b0;
    txNewHeadAC1_waitIdle <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewHeadAC1          <= 1'b0;
    txNewHeadAC1_waitIdle <= 1'b0;
  end
  else 
  begin
    if ((rstAC1NewHead == 1'b1) || (cleartxAC1NewHead))
    begin
      txNewHeadAC1          <= 1'b0;
      txNewHeadAC1_waitIdle <= 1'b0;
    end
    else if ((txAC1StateInt[3:0] == 4'h1) || (txAC1StateInt[3:0] == 4'h2))
    begin
      if ((settxAC1NewHead == 1'b1) || (txNewHeadAC1_waitIdle == 1'b1))
      begin
        txNewHeadAC1          <= 1'b1;
        txNewHeadAC1_waitIdle <= 1'b0;
      end
    end
    else if ((settxAC1NewHead == 1'b1)  && (txAC1StateInt[3:0] == 4'h4))
    begin
        txNewHeadAC1_waitIdle <= 1'b1;
    end
  end
end

assign statussettxAC1NewHead  = txNewHeadAC1;

/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewHeadAC2          <= 1'b0;
    txNewHeadAC2_waitIdle <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewHeadAC2          <= 1'b0;
    txNewHeadAC2_waitIdle <= 1'b0;
  end
  else 
  begin
    if ((rstAC2NewHead == 1'b1) || (cleartxAC2NewHead))
    begin
      txNewHeadAC2          <= 1'b0;
      txNewHeadAC2_waitIdle <= 1'b0;
    end
    else if ((txAC2StateInt[3:0] == 4'h1) || (txAC2StateInt[3:0] == 4'h2))
    begin
      if ((settxAC2NewHead == 1'b1) || (txNewHeadAC2_waitIdle == 1'b1))
      begin
        txNewHeadAC2          <= 1'b1;
        txNewHeadAC2_waitIdle <= 1'b0;
      end
    end
    else if ((settxAC2NewHead == 1'b1)  && (txAC2StateInt[3:0] == 4'h4))
    begin
        txNewHeadAC2_waitIdle <= 1'b1;
    end
  end
end

assign statussettxAC2NewHead  = txNewHeadAC2;

/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewHeadAC3          <= 1'b0;
    txNewHeadAC3_waitIdle <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewHeadAC3          <= 1'b0;
    txNewHeadAC3_waitIdle <= 1'b0;
  end
  else 
  begin
    if ((rstAC3NewHead == 1'b1) || (cleartxAC3NewHead)) 
    begin
      txNewHeadAC3          <= 1'b0;
      txNewHeadAC3_waitIdle <= 1'b0;
    end
    else if ((txAC3StateInt[3:0] == 4'h1) || (txAC3StateInt[3:0] == 4'h2))
    begin
      if ((settxAC3NewHead == 1'b1) || (txNewHeadAC3_waitIdle == 1'b1))
      begin
        txNewHeadAC3          <= 1'b1;
        txNewHeadAC3_waitIdle <= 1'b0;
      end
    end
    else if ((settxAC3NewHead == 1'b1) && (txAC3StateInt[3:0] == 4'h4))
    begin
        txNewHeadAC3_waitIdle <= 1'b1;
    end
  end
end

assign statussettxAC3NewHead  = txNewHeadAC3;


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewHeadBcn          <= 1'b0;
    txNewHeadBcn_waitIdle <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewHeadBcn          <= 1'b0;
    txNewHeadBcn_waitIdle <= 1'b0;
  end
  else 
  begin
    if ((rstBcnNewHead == 1'b1) || (cleartxBcnNewHead))
    begin
      txNewHeadBcn          <= 1'b0;
      txNewHeadBcn_waitIdle <= 1'b0;
    end
    else if ((txBcnStateInt[3:0] == 4'h1) || (txBcnStateInt[3:0] == 4'h2))
    begin
      if ((settxBcnNewHead == 1'b1) || (txNewHeadBcn_waitIdle == 1'b1))
      begin
        txNewHeadBcn          <= 1'b1;
        txNewHeadBcn_waitIdle <= 1'b0;
      end
    end
    else if ((settxBcnNewHead == 1'b1)  && (txBcnStateInt[3:0] == 4'h4))
    begin
        txNewHeadBcn_waitIdle <= 1'b1;
    end
  end
end

// assign statussettxBcnNewHead  = txNewHeadBcn;
assign statussettxBcnNewHead  = txNewHeadBcn || txNewHeadBcn_waitIdle;


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    txNewHeadTB          <= 1'b0;
    txNewHeadTB_waitIdle <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    txNewHeadTB          <= 1'b0;
    txNewHeadTB_waitIdle <= 1'b0;
  end
  else 
  begin
    if ((rstTBNewHead == 1'b1) || (cleartxTBNewHead))
    begin
      txNewHeadTB          <= 1'b0;
      txNewHeadTB_waitIdle <= 1'b0;
    end
    else if ((txTBStateInt[3:0] == 4'h1) || (txTBStateInt[3:0] == 4'h2))
    begin
      if ((settxTBNewHead == 1'b1) || (txNewHeadTB_waitIdle == 1'b1))
      begin
        txNewHeadTB          <= 1'b1;
        txNewHeadTB_waitIdle <= 1'b0;
      end
    end
    else if ((settxTBNewHead == 1'b1)  && (txTBStateInt[3:0] == 4'h4))
    begin
        txNewHeadTB_waitIdle <= 1'b1;
    end
  end
end

// assign statussettxTBNewHead  = txNewHeadTB;
assign statussettxTBNewHead  = txNewHeadTB || txNewHeadTB_waitIdle;


/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    haltAC0AfterTXOP <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    haltAC0AfterTXOP <= 1'b0;
  end
  else 
  begin
    if (clearhaltAC0AfterTXOP) begin
      haltAC0AfterTXOP <= 1'b0;
    end
    else if (sethaltAC0AfterTXOP == 1'b1) begin
      haltAC0AfterTXOP <= 1'b1;
    end
  end
end

assign statussethaltAC0AfterTXOP  = haltAC0AfterTXOP;

/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    haltAC1AfterTXOP <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    haltAC1AfterTXOP <= 1'b0;
  end
  else 
  begin
    if (clearhaltAC1AfterTXOP) begin
      haltAC1AfterTXOP <= 1'b0;
    end
    else if (sethaltAC1AfterTXOP == 1'b1) begin
      haltAC1AfterTXOP <= 1'b1;
    end
  end
end

assign statussethaltAC1AfterTXOP  = haltAC1AfterTXOP;

/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    haltAC2AfterTXOP <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    haltAC2AfterTXOP <= 1'b0;
  end
  else 
  begin
    if (clearhaltAC2AfterTXOP) begin
      haltAC2AfterTXOP <= 1'b0;
    end
    else if (sethaltAC2AfterTXOP == 1'b1) begin
      haltAC2AfterTXOP <= 1'b1;
    end
  end
end

assign statussethaltAC2AfterTXOP  = haltAC2AfterTXOP;

/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    haltAC3AfterTXOP <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    haltAC3AfterTXOP <= 1'b0;
  end
  else 
  begin
    if (clearhaltAC3AfterTXOP) begin
      haltAC3AfterTXOP <= 1'b0;
    end
    else if (sethaltAC3AfterTXOP == 1'b1) begin
      haltAC3AfterTXOP <= 1'b1;
    end
  end
end

assign statussethaltAC3AfterTXOP  = haltAC3AfterTXOP;

/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    haltBcnAfterTXOP <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    haltBcnAfterTXOP <= 1'b0;
  end
  else 
  begin
    if (clearhaltBcnAfterTXOP) begin
      haltBcnAfterTXOP <= 1'b0;
    end
    else if (sethaltBcnAfterTXOP == 1'b1) begin
      haltBcnAfterTXOP <= 1'b1;
    end
  end
end

assign statussethaltBcnAfterTXOP  = haltBcnAfterTXOP;

/////////////////////////////////////////////////////////////////
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    haltTBAfterTXOP <= 1'b0;
  end
  else if (macPIClkSoftRst_n == 1'b0)
  begin
    haltTBAfterTXOP <= 1'b0;
  end
  else 
  begin
    if (clearhaltTBAfterTXOP) begin
      haltTBAfterTXOP <= 1'b0;
    end
    else if (sethaltTBAfterTXOP == 1'b1) begin
      haltTBAfterTXOP <= 1'b1;
    end
  end
end

assign statussethaltTBAfterTXOP  = haltTBAfterTXOP;


/////////////////////////////////////////////////////////////////
// clock domain reynchronization
/////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////
/// rxController Flow Control
////////////////////////////////////////////////////

// Instanciation of simpleSynchro
// Name of the instance : U_rxFrmDiscard_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_rxFrmDiscard_synchro (
                .dstclk             (macCoreRxClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (rxFrmDiscardResync),
                .dstdata            (rxFrmDiscard)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_rxDescAvailable_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_rxDescAvailable_synchro (
                .dstclk             (macCoreRxClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (rxDescAvailableResync),
                .dstdata            (rxDescAvailable)
                );

// Loop Back Here to avoid port map goes and return
// Instanciation of simpleSynchro
// Name of the instance : U_rxFrmDiscardRet_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_rxFrmDiscardRet_synchro (
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (rxFrmDiscard),
                .dstdata            (rxFrmDiscardRet)
                );

// Resync rxFlowCntrlEn from macCore register domain
// Instanciation of simpleSynchro
// Name of the instance : U_rxFlowCntrlEn_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_rxFlowCntrlEn_synchro (
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (rxFlowCntrlEn),
                .dstdata            (rxFlowCntrlEnResync)
                );

// Instanciation of pulse2PulseSynchro
// Name of the instance : U_txFIFOFlushDone_p_synchro
// Name of the file containing this module : pulse2PulseSynchro.v
pulse2PulseSynchro U_txFIFOFlushDone_p_synchro (
                .srcclk             (macPIClk),
                .srcresetn          (macPIClkHardRst_n),
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (dmaTxFIFOFlushDone_p),
                .dstdata            (txFIFOFlushDone_p)
                );


////////////////////////////////////////////////////
/// BackOff/AC Selection Interface
////////////////////////////////////////////////////


//// Instanciation of simpleSynchro
//// Name of the instance : U_trigTxAC0_synchro
//// Name of the file containing this module : simpleSynchro.v
//simpleSynchro U_trigTxAC0_synchro (
//                .dstclk             (macPITxClk),
//                .dstresetn          (macPITxClkHardRst_n),
//                .srcdata            (trigTxAC0),
//                .dstdata            (trigTxAC0sync)
//                );
//
//// Instanciation of simpleSynchro
//// Name of the instance : U_trigTxAC1_synchro
//// Name of the file containing this module : simpleSynchro.v
//simpleSynchro U_trigTxAC1_synchro (
//                .dstclk             (macPITxClk),
//                .dstresetn          (macPITxClkHardRst_n),
//                .srcdata            (trigTxAC1),
//                .dstdata            (trigTxAC1sync)
//                );
//
//// Instanciation of simpleSynchro
//// Name of the instance : U_trigTxAC2_synchro
//// Name of the file containing this module : simpleSynchro.v
//simpleSynchro U_trigTxAC2_synchro (
//                .dstclk             (macPITxClk),
//                .dstresetn          (macPITxClkHardRst_n),
//                .srcdata            (trigTxAC2),
//                .dstdata            (trigTxAC2sync)
//                );
//
//// Instanciation of simpleSynchro
//// Name of the instance : U_trigTxAC3_synchro
//// Name of the file containing this module : simpleSynchro.v
//simpleSynchro U_trigTxAC3_synchro (
//                .dstclk             (macPITxClk),
//                .dstresetn          (macPITxClkHardRst_n),
//                .srcdata            (trigTxAC3),
//                .dstdata            (trigTxAC3sync)
//                );
//
//// Instanciation of simpleSynchro
//// Name of the instance : U_trigTxACBcn_synchro
//// Name of the file containing this module : simpleSynchro.v
//generate if(SECONDARY==0)
//begin: gen_trigTxACBcn_synchro
//  simpleSynchro U_trigTxACBcn_synchro (
//                .dstclk             (macPITxClk),
//                .dstresetn          (macPITxClkHardRst_n),
//                .srcdata            (trigTxBcn),
//                .dstdata            (trigTxBcnsync)
//                );
//end
//else
//begin: gen_trigTxACBcn_synchro_tied
//  assign trigTxBcnsync = 1'b0;
//end
//endgenerate

// Instanciation of pulse2PulseSynchro
// Name of the instance : U_rxUnderRun_synchro
// Name of the file containing this module : pulse2PulseSynchro.v
pulse2PulseSynchro U_txUnderRun_synchro (
                .srcclk             (macCoreClk),
                .srcresetn          (macCoreClkHardRst_n),
                .dstclk             (macPITxClk),
                .dstresetn          (macPITxClkHardRst_n),
                .srcdata            (macPHYIFUnderRun),
                .dstdata            (underRunDetected_p)
                );


// Avoid glitches resync matters
// Resynchronization of txAC0State on macCoreClock domain
// As txAC0State is one hot coded, the resyncrhonization can be done using onehotSynchro
onehotSynchro #(.SYNC_WIDTH (4)) u_txAC0StateOneHotSynchro(
       .dstclk (macCoreClk),
       .dstresetn (macCoreClkHardRst_n),
       .srcdata(txAC0StateInt),

       .dstdata(txAC0StateMCInt)
);

// Update txAC0StateMC only when the OneHot resynchronization gives valid state
always @(posedge macCoreClk, negedge macCoreClkHardRst_n)
begin
  if(macCoreClkHardRst_n == 1'b0)
    txAC0StateMC <= 4'b0;
  else if (txAC0StateMCInt == 4'b0001 || txAC0StateMCInt == 4'b0010 || txAC0StateMCInt == 4'b0100 || txAC0StateMCInt == 4'b1000)
    txAC0StateMC <= txAC0StateMCInt;
end  

// Resynchronization of txAC0State on macCoreClock domain
// As txAC1State is one hot coded, the resyncrhonization can be done using onehotSynchro
onehotSynchro #(.SYNC_WIDTH (4)) u_txAC1StateOneHotSynchro(
       .dstclk (macCoreClk),
       .dstresetn (macCoreClkHardRst_n),
       .srcdata(txAC1StateInt),

       .dstdata(txAC1StateMCInt)
);

// Update txAC3StateMC only when the OneHot resynchronization gives valid state
always @(posedge macCoreClk, negedge macCoreClkHardRst_n)
begin
  if(macCoreClkHardRst_n == 1'b0)
    txAC1StateMC <= 4'b0;
  else if (txAC1StateMCInt == 4'b0001 || txAC1StateMCInt == 4'b0010 || txAC1StateMCInt == 4'b0100 || txAC1StateMCInt == 4'b1000)
    txAC1StateMC <= txAC1StateMCInt;
end  


// Resynchronization of txAC0State on macCoreClock domain
// As txAC2State is one hot coded, the resyncrhonization can be done using onehotSynchro
onehotSynchro #(.SYNC_WIDTH (4)) u_txAC2StateOneHotSynchro(
       .dstclk (macCoreClk),
       .dstresetn (macCoreClkHardRst_n),
       .srcdata(txAC2StateInt),

       .dstdata(txAC2StateMCInt)
);

// Update txAC2StateMC only when the OneHot resynchronization gives valid state
always @(posedge macCoreClk, negedge macCoreClkHardRst_n)
begin
  if(macCoreClkHardRst_n == 1'b0)
    txAC2StateMC <= 4'b0;
  else if (txAC2StateMCInt == 4'b0001 || txAC2StateMCInt == 4'b0010 || txAC2StateMCInt == 4'b0100 || txAC2StateMCInt == 4'b1000)
    txAC2StateMC <= txAC2StateMCInt;
end  

// Resynchronization of txAC0State on macCoreClock domain
// As txAC3State is one hot coded, the resyncrhonization can be done using onehotSynchro
onehotSynchro #(.SYNC_WIDTH (4)) u_txAC3StateOneHotSynchro(
       .dstclk (macCoreClk),
       .dstresetn (macCoreClkHardRst_n),
       .srcdata(txAC3StateInt),

       .dstdata(txAC3StateMCInt)
);

// Update txAC3StateMC only when the OneHot resynchronization gives valid state
always @(posedge macCoreClk, negedge macCoreClkHardRst_n)
begin
  if(macCoreClkHardRst_n == 1'b0)
    txAC3StateMC <= 4'b0;
  else if (txAC3StateMCInt == 4'b0001 || txAC3StateMCInt == 4'b0010 || txAC3StateMCInt == 4'b0100 || txAC3StateMCInt == 4'b1000)
    txAC3StateMC <= txAC3StateMCInt;
end  

// Resynchronization of txAC0State on macCoreClock domain
// As txBcnState is one hot coded, the resyncrhonization can be done using onehotSynchro
onehotSynchro  #(.SYNC_WIDTH (4))u_txBcnStateOneHotSynchro(
       .dstclk (macCoreClk),
       .dstresetn (macCoreClkHardRst_n),
       .srcdata(txBcnStateInt),
       .dstdata(txBcnStateMCInt)
);

// Update txBcnStateMC only when the OneHot resynchronization gives valid state
always @(posedge macCoreClk, negedge macCoreClkHardRst_n)
begin
  if(macCoreClkHardRst_n == 1'b0)
    txBcnStateMC <= 4'b0;
  else if (txBcnStateMCInt == 4'b0001 || txBcnStateMCInt == 4'b0010 || txBcnStateMCInt == 4'b0100 || txBcnStateMCInt == 4'b1000)
    txBcnStateMC <= txBcnStateMCInt;
end  

// Resynchronization of txTBState on macCoreClock domain
// As txTBState is one hot coded, the resyncrhonization can be done using onehotSynchro
onehotSynchro  #(.SYNC_WIDTH (4))u_txTBStateOneHotSynchro(
       .dstclk (macCoreClk),
       .dstresetn (macCoreClkHardRst_n),
       .srcdata(txTBStateInt),
       .dstdata(txTBStateMCInt)
);

// Update txTBStateMC only when the OneHot resynchronization gives valid state
always @(posedge macCoreClk, negedge macCoreClkHardRst_n)
begin
  if(macCoreClkHardRst_n == 1'b0)
    txTBStateMC <= 4'b0;
  else if (txTBStateMCInt == 4'b0001 || txTBStateMCInt == 4'b0010 || txTBStateMCInt == 4'b0100 || txTBStateMCInt == 4'b1000)
    txTBStateMC <= txTBStateMCInt;
end  


assign txStateActive   = ((trigTxAC0PI == 1'b1) && (txAC0StateInt == 4'h4)) ||
                         ((trigTxAC1PI == 1'b1) && (txAC1StateInt == 4'h4)) ||
                         ((trigTxAC2PI == 1'b1) && (txAC2StateInt == 4'h4)) ||
                         ((trigTxAC3PI == 1'b1) && (txAC3StateInt == 4'h4)) ||
                         ((trigTxBcnPI == 1'b1) && (txBcnStateInt == 4'h4)) ||
                         ((trigTxTBPI  == 1'b1) && (txTBStateInt  == 4'h4));

always @(posedge macCoreClk, negedge macCoreClkHardRst_n)
begin
  if(macCoreClkHardRst_n == 1'b0)
    txStateActiveMC <= 1'b0;
  else  
    txStateActiveMC <= ((trigTxAC0 == 1'b1) && (txAC0StateMC == 4'h4)) ||
                       ((trigTxAC1 == 1'b1) && (txAC1StateMC == 4'h4)) ||
                       ((trigTxAC2 == 1'b1) && (txAC2StateMC == 4'h4)) ||
                       ((trigTxAC3 == 1'b1) && (txAC3StateMC == 4'h4)) ||
                       ((trigTxBcn == 1'b1) && (txBcnStateMC == 4'h4)) ||
                       ((trigTxTB  == 1'b1) && (txTBStateMC  == 4'h4));
end  

simpleSynchro U_txStateActiveMC_synchro (
              .dstclk             (macPITxClk),
              .dstresetn          (macPITxClkHardRst_n),
              .srcdata            (txStateActiveMC),
              .dstdata            (txStateActiveMC_resync)
              );

////////////////////////////////////////////////////
/// MAC Controller Interface
////////////////////////////////////////////////////

// Instanciation of pulse2PulseSynchro
// Name of the instance : U_frameRxed_p_synchro
// Name of the file containing this module : pulse2PulseSynchro.v
pulse2PulseSynchro U_frameRxed_p_synchro (
                .srcclk             (macCoreClk),
                .srcresetn          (macCoreClkHardRst_n),
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (frameRxed_p),
                .dstdata            (dmaframeRxed_p)
                );

simpleSynchro U_rxListProcCsIsIdle_synchro (
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (dmarxListProcCsIsIdle),
                .dstdata            (rxListProcCsIsIdle)
                );

simpleSynchro U_txListProcCsIsIdle_synchro (
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (dmatxListProcCsIsIdle),
                .dstdata            (txListProcCsIsIdle)
                );


// Instanciation of pulse2PulseSynchro
// Name of the instance : U_updateDMAStatus_p_synchro
// Name of the file containing this module : pulse2PulseSynchro.v
pulse2PulseSynchro U_updateDMAStatus_p_synchro (
                .srcclk             (macCoreClk),
                .srcresetn          (macCoreClkHardRst_n),
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (updateDMAStatus_p),
                .dstdata            (updateDMAStatusResync_p)
                );


// Instanciation of pulse2PulseSynchro
// Name of the instance : U_statusUpdated_p_synchro
// Name of the file containing this module : pulse2PulseSynchro.v
pulse2PulseSynchro U_statusUpdated_p_synchro (
                .srcclk             (macPIClk),
                .srcresetn          (macPIClkHardRst_n),
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (statusUpdatedInt_p),
                .dstdata            (statusUpdated_p)
                );

// Instanciation of pulse2PulseSynchro
// Name of the instance : U_rxTrig_p_synchro
// Name of the file containing this module : pulse2PulseSynchro.v
pulse2PulseSynchro U_rxTrig_p_synchro (
                .srcclk             (macPIClk),
                .srcresetn          (macPIClkHardRst_n),
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (rxTrigInt_p),
                .dstdata            (rxTrig_p)
                );


always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
  begin
    retryLimitReachedResync_p <= 1'b0;
    rtsSuccessResync_p  <= 1'b0;
    rtsFailedResync_p   <= 1'b0;
    mpduFailedResync_p  <= 1'b0;
    mpduSuccessResync_p <= 1'b0;
    retryFrameResync_p  <= 1'b0;
    ampduFrmResync_p    <= 1'b0;
    swRTSResync_p       <= 1'b0;
    numMPDURetriesResync<= 8'b0;
    numRTSRetriesResync <= 8'b0;
    mediumTimeUsedResync<= 32'b0;
    updateDMAStatusResyncDly_p<= 1'b0;
    updateDMAStatusResyncDly2_p<= 1'b0;
  end
  else if ((macPIClkSoftRst_n == 1'b0) || statusUpdatedInt_p)
  begin
    retryLimitReachedResync_p <= 1'b0;
    rtsSuccessResync_p  <= 1'b0;
    rtsFailedResync_p   <= 1'b0;
    mpduFailedResync_p  <= 1'b0;
    mpduSuccessResync_p <= 1'b0;
    retryFrameResync_p  <= 1'b0;
    ampduFrmResync_p    <= 1'b0;
    swRTSResync_p       <= 1'b0;
    numMPDURetriesResync<= 8'b0;
    numRTSRetriesResync <= 8'b0;
    mediumTimeUsedResync<= 32'b0;
    updateDMAStatusResyncDly_p<= 1'b0;
    updateDMAStatusResyncDly2_p<= 1'b0;
    
  end
  else if (updateDMAStatusResync_p)
  begin
    updateDMAStatusResyncDly_p<= 1'b1;
    retryLimitReachedResync_p <= retryLimitReached_p;
    rtsSuccessResync_p <= rtsSuccess_p;
    rtsFailedResync_p <= rtsFailed_p;
    mpduFailedResync_p <= mpduFailed_p;
    mpduSuccessResync_p <= mpduSuccess_p;
    retryFrameResync_p <= retryFrame_p;
    ampduFrmResync_p <= ampduFrm_p;
    swRTSResync_p <= swRTS_p;
    numMPDURetriesResync <= numMPDURetries;
    numRTSRetriesResync <= numRTSRetries;
    mediumTimeUsedResync<= mediumTimeUsed;
  end
  else
  begin
    updateDMAStatusResyncDly_p<= 1'b0;
    updateDMAStatusResyncDly2_p<= updateDMAStatusResyncDly_p;
  end  
end   

// Instanciation of pulse2PulseSynchro
// Name of the instance : U_txMpduDone_p_synchro
// Name of the file containing this module : pulse2PulseSynchro.v
pulse2PulseSynchro U_txMpduDone_p_synchro (
                .srcclk             (macCoreClk),
                .srcresetn          (macCoreClkHardRst_n),
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (txMpduDone_p),
                .dstdata            (txMpduDoneResync_p)
                );


always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
    txMpduDoneResyncDly_p<= 1'b0;
  else 
    txMpduDoneResyncDly_p<= txMpduDoneResync_p;
end   

always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
    whichDescriptorSWResync <= 4'b0;
  else if (macPIClkSoftRst_n == 1'b0)
    whichDescriptorSWResync <= 4'b0;
  else if (txMpduDoneResync_p || updateDMAStatusResync_p)
    whichDescriptorSWResync <= whichDescriptorSW;
end   

always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
    transmissionBWResync <= 2'b0;
  else if (macPIClkSoftRst_n == 1'b0)
    transmissionBWResync <= 2'b0;
  else if (txMpduDoneResync_p || updateDMAStatusResync_p)
    transmissionBWResync <= transmissionBW;
end   



// Instanciation of dmaEngine
// Name of the instance : U_dmaEngine
// Name of the file containing this module : dmaEngine.v
dmaEngine U_dmaEngine (
  .macPITxClk                       (macPITxClk),
  .macPIRxClk                       (macPIRxClk),
  .macPIClk                         (macPIClk),
  .macPITxClkHardRst_n              (macPITxClkHardRst_n),
  .macPIRxClkHardRst_n              (macPIRxClkHardRst_n),
  .macPIClkHardRst_n                (macPIClkHardRst_n),
  .macPITxClkSoftRst_n              (macPITxClkSoftRst_n),
  .macPIRxClkSoftRst_n              (macPIRxClkSoftRst_n),
  .macPIClkSoftRst_n                (macPIClkSoftRst_n),
  .dmaHIFReadDataOut                (dmaHIFReadDataOut),
  .dmaHIFReadDataValid              (dmaHIFReadDataValid),
  .dmaHIFReady                      (dmaHIFReady),
  .dmaHIFTransComplete              (dmaHIFTransComplete),
  .dmaHIFError                      (dmaHIFError),
  .trigTxAC0                        (trigTxAC0PI),
  .trigTxAC1                        (trigTxAC1PI),
  .trigTxAC2                        (trigTxAC2PI),
  .trigTxAC3                        (trigTxAC3PI),
  .trigTxBcn                        (trigTxBcnPI),
  .trigTxTB                         (trigTxTBPI),
  .frameRxed_p                      (dmaframeRxed_p),
  .rxListProcCsIsIdle               (dmarxListProcCsIsIdle),
  .txListProcCsIsIdle               (dmatxListProcCsIsIdle),
  .tsfTimerValue                    (tsfTimerValue),
  .updateDMAStatus_p                (updateDMAStatusResyncDly2_p),
  .swRTS_p                          (swRTSResync_p),
  .txMpduDone_p                     (txMpduDoneResyncDly_p),
  .ampduFrm_p                       (ampduFrmResync_p),
  .retryFrame_p                     (retryFrameResync_p),
  .mpduSuccess_p                    (mpduSuccessResync_p),
  .mpduFailed_p                     (mpduFailedResync_p),
  .rtsFailed_p                      (rtsFailedResync_p),
  .rtsSuccess_p                     (rtsSuccessResync_p),
  .retryLimitReached_p              (retryLimitReachedResync_p),
  .transmissionBW                   (transmissionBWResync),
  .numMPDURetries                   (numMPDURetriesResync),
  .numRTSRetries                    (numRTSRetriesResync),
  .mediumTimeUsed                   (mediumTimeUsedResync),
  .whichDescriptorSW                (whichDescriptorSWResync),
  .rxFrmDiscard                     (rxFrmDiscardResync),
  .rxDescAvailable                  (rxDescAvailableResync),
  .rxFrmDiscardRet                  (rxFrmDiscardRet),
  .rxBuf1StartPtr                   (rxBuf1StartPtr),
  .rxBuf1EndPtr                     (rxBuf1EndPtr),
  .rxBuf1RdPtr                      (rxBuf1RdPtr),
  .rxBuf1WrPtr                      (rxBuf1WrPtr),
  .rxBuf1WrPtrIn                    (rxBuf1WrPtrIn),
  .rxBuf1WrPtrInValid               (rxBuf1WrPtrInValid),
  .rxBuf2StartPtr                   (rxBuf2StartPtr),
  .rxBuf2EndPtr                     (rxBuf2EndPtr),
  .rxBuf2RdPtr                      (rxBuf2RdPtr),
  .rxBuf2WrPtr                      (rxBuf2WrPtr),
  .rxBuf2WrPtrIn                    (rxBuf2WrPtrIn),
  .rxBuf2WrPtrInValid               (rxBuf2WrPtrInValid),
  .rxBufRHDHeader                   (rxBufRHDHeader),
  .rxBufRHDFooter                   (rxBufRHDFooter),
  .rxBufRPDHeader                   (rxBufRPDHeader),
  .rxBufRPDFooter                   (rxBufRPDFooter),
  .partialUnwrapSize                (partialUnwrapSize),
  .rxFlowCntrlEn                    (rxFlowCntrlEnResync),
  .underRunDetected_p               (underRunDetected_p),
  .txNewTailAC0                     (txNewTailAC0),
  .txNewTailAC1                     (txNewTailAC1),
  .txNewTailAC2                     (txNewTailAC2),
  .txNewTailAC3                     (txNewTailAC3),
  .txNewTailBcn                     (txNewTailBcn),
  .txNewTailTB                      (1'b0),
  .txNewHeadAC0                     (txNewHeadAC0),
  .txNewHeadAC1                     (txNewHeadAC1),
  .txNewHeadAC2                     (txNewHeadAC2),
  .txNewHeadAC3                     (txNewHeadAC3),
  .txNewHeadBcn                     (txNewHeadBcn),
  .txNewHeadTB                      (txNewHeadTB),
  .haltAC0AfterTXOP                 (haltAC0AfterTXOP),
  .haltAC1AfterTXOP                 (haltAC1AfterTXOP),
  .haltAC2AfterTXOP                 (haltAC2AfterTXOP),
  .haltAC3AfterTXOP                 (haltAC3AfterTXOP),
  .haltBcnAfterTXOP                 (haltBcnAfterTXOP),
  .haltTBAfterTXOP                  (haltTBAfterTXOP),
  .txAC0HeadPtr                     (txAC0HeadPtr),
  .txAC1HeadPtr                     (txAC1HeadPtr),
  .txAC2HeadPtr                     (txAC2HeadPtr),
  .txAC3HeadPtr                     (txAC3HeadPtr),
  .txBcnHeadPtr                     (txBcnHeadPtr),
  .txTBHeadPtr                      (txTBHeadPtr),
  .txCtrlRegBusy                    (txCtrlRegBusy),
  .txStateActiveMC                  (txStateActiveMC_resync && txStateActive),
  .txFifoAlmostFull                 (txFifoAlmostFull),
  .txFifoFull                       (txFifoFull),
  .txFifoEmpty                      (txFifoEmpty),
  .rxFifoEmpty                      (rxFifoEmpty),
  .rxFifoAlmEmpty                   (rxFIFOAlmEmpty),
  .rxFifoRdData                     (rxFifoRdData),
  .rxTagFifoRdData                  (rxTagFifoRdData),
  .dmaHIFRead                       (dmaHIFRead),
  .dmaHIFWrite                      (dmaHIFWrite),
  .dmaHIFSize                       (dmaHIFSize),
  .dmaHIFAddressIn                  (dmaHIFAddressIn),
  .dmaHIFWriteDataIn                (dmaHIFWriteDataIn),
  .txCtrlRegWr                      (txCtrlRegWr),
  .txCtrlRegPT                      (txCtrlRegPT),
  .txCtrlRegHD                      (txCtrlRegHD),
  .discardPrevHD_p                  (discardPrevHD_p),
  .rstAC0NewTail                    (rstAC0NewTail),
  .rstAC1NewTail                    (rstAC1NewTail),
  .rstAC2NewTail                    (rstAC2NewTail),
  .rstAC3NewTail                    (rstAC3NewTail),
  .rstBcnNewTail                    (rstBcnNewTail),
  .rstTBNewTail                     (/*Open*/),
  .rstAC0NewHead                    (rstAC0NewHead),
  .rstAC1NewHead                    (rstAC1NewHead),
  .rstAC2NewHead                    (rstAC2NewHead),
  .rstAC3NewHead                    (rstAC3NewHead),
  .rstBcnNewHead                    (rstBcnNewHead),
  .rstTBNewHead                     (rstTBNewHead),
  .txAC0State                       (txAC0StateInt),
  .txAC1State                       (txAC1StateInt),
  .txAC2State                       (txAC2StateInt),
  .txAC3State                       (txAC3StateInt),
  .txBcnState                       (txBcnStateInt),
  .txTBState                        (txTBStateInt),
  .txLenMismatch                    (txLenMismatch), 
  .txUPatternErr                    (txUPatternErr),    
  .txNextPointerErr                 (txNextPointerErr), 
  .txPTAddressErr                   (txPTAddressErr),   
  .txBusErr                         (txBusErr),         
  .txNewHeadErr                     (txNewHeadErr),     
  .rxHdrBusErr                      (rxHdrBusErr),        
  .rxPayBusErr                      (rxPayBusErr),        
  .ptError                          (ptError),
  .txTBStartup                      (/*Open*/),       
  .txBcnStartup                     (txBcnStartup),       
  .txAC0Startup                     (txAC0Startup),       
  .txAC1Startup                     (txAC1Startup),       
  .txAC2Startup                     (txAC2Startup),       
  .txAC3Startup                     (txAC3Startup),       
  .txTBEndQ                         (/*Open*/),          
  .txBcnEndQ                        (txBcnEndQ),          
  .txAC0EndQ                        (txAC0EndQ),          
  .txAC1EndQ                        (txAC1EndQ),          
  .txAC2EndQ                        (txAC2EndQ),          
  .txAC3EndQ                        (txAC3EndQ),          
  .txTBHaltAfterTXOP                (txTBHaltAfterTXOP),   
  .txBcnHaltAfterTXOP               (txBcnHaltAfterTXOP),   
  .txAC0HaltAfterTXOP               (txAC0HaltAfterTXOP), 
  .txAC1HaltAfterTXOP               (txAC1HaltAfterTXOP), 
  .txAC2HaltAfterTXOP               (txAC2HaltAfterTXOP), 
  .txAC3HaltAfterTXOP               (txAC3HaltAfterTXOP),   
  .statusUpdated_p                  (statusUpdatedInt_p),
  .txFifoWr                         (txFifoWr),
  .txFifoWrData                     (txFIFOWrData),
  .flushTxFifo                      (flushTxFifo),
  .txFIFOFlushDone_p                (dmaTxFIFOFlushDone_p),
  .rxFifoRd                         (rxFifoRd),
  .txTagFifoWrData                  (txTagFifoWrData),
  .txListProcCs                     (txListProcCs),
  .rxListProcCs                     (rxListProcCs),
  .interruptEnTx                    (interruptEnTx),
  .bufferInterruptTx                (bufferInterruptTx),
  .statusUpdaterFull                (statusUpdaterFull),
  .tbTxDMADead                      (tbTxDMADead_int),
  .bcnTxDMADead                     (bcnTxDMADead_int),
  .ac3TxDMADead                     (ac3TxDMADead_int),
  .ac2TxDMADead                     (ac2TxDMADead_int),
  .ac1TxDMADead                     (ac1TxDMADead_int),
  .ac0TxDMADead                     (ac0TxDMADead_int),
  .rxPayloadDMADead                 (rxPayloadDMADead),
  .rxHeaderDMADead                  (rxHeaderDMADead),
  .tx0Trigger                       (ac0TxTrigger),
  .tx1Trigger                       (ac1TxTrigger),
  .tx2Trigger                       (ac2TxTrigger),
  .tx3Trigger                       (ac3TxTrigger),
  .bcnTrigger                       (bcnTxTrigger),
  .tbTrigger                        (tbTxTrigger),
  .rxBuffer1Trigger                 (rxBuffer1Trigger),
  .rxBuffer2Trigger                 (rxBuffer2Trigger),
  .rxTrig_p                         (rxTrigInt_p),
  .tbProtTrigger                    (tbProtTrigger),
  .ac0StatusPointer                 (ac0StatusPointer),
  .ac1StatusPointer                 (ac1StatusPointer),
  .ac2StatusPointer                 (ac2StatusPointer),
  .ac3StatusPointer                 (ac3StatusPointer),
  .bcnStatusPointer                 (bcnStatusPointer),
  .tbStatusPointer                  (tbStatusPointer),
  .currentPtr                       (txCurrentPointer),
  .rxHeaderTFPtr                    (rxHeaderTFPtr),
  .debugPortDMA3                    (debugPortDMA3),
  .debugPortDMA5                    (debugPortDMA5),
  .debugPortDMA6                    (debugPortDMA6),
  .debugPortDMAStatus               (debugPortDMAStatus),
  .debugPortDMATxStatus             (debugPortDMATxStatus),
  .debugPortTxRxListA               (debugPortTxRxListA),
  .debugPortDmaRdWrCtlr             (debugPortDmaRdWrCtlr),
  .dmaInternalError                 (dmaInternalError_int)
);




assign ac0TxBufTrigger = bufferInterruptTx & trigTxAC0PI;
assign ac1TxBufTrigger = bufferInterruptTx & trigTxAC1PI;
assign ac2TxBufTrigger = bufferInterruptTx & trigTxAC2PI;
assign ac3TxBufTrigger = bufferInterruptTx & trigTxAC3PI;
assign bcnTxBufTrigger = bufferInterruptTx & trigTxBcnPI;
assign tbTxBufTrigger  = bufferInterruptTx & trigTxTBPI;


// Conversion between One Hot encoding of the FSM state and the binay encoding of the CSReg.
//DMA state for AC0 channel.
assign txAC0State     = convOneHotToBin(txAC0StateInt);
//DMA state for AC1 channel.
assign txAC1State     = convOneHotToBin(txAC1StateInt);
//DMA state for AC2 channel.
assign txAC2State     = convOneHotToBin(txAC2StateInt);
//DMA state for AC3 channel.
assign txAC3State     = convOneHotToBin(txAC3StateInt);
//DMA state for Beacon channel.
assign txBcnState     = convOneHotToBin(txBcnStateInt);
//DMA state for Trigger Based channel.
assign txTBState      = convOneHotToBin(txTBStateInt);

//Oring NewHead 
assign oredNewHead    = txNewHeadAC0 | txNewHeadAC1 | txNewHeadAC2 | txNewHeadAC3 |
                        txNewHeadBcn | txNewHeadTB;
//Oring NewTail 
assign oredNewTail    = txNewTailAC0 | txNewTailAC1 | txNewTailAC2 | txNewTailAC3 |
                        txNewTailBcn ;

assign txInterrupt    = ac0TxTrigger | ac1TxTrigger | ac2TxTrigger | ac3TxTrigger |
                        bcnTxTrigger | tbTxTrigger  ;

assign rxInterrupt    =  rxBuffer1Trigger | rxBuffer2Trigger;

assign tbTxDMADead    =  tbTxDMADead_int  | (trigTxTBPI  & underRunDetected_p);
assign bcnTxDMADead   =  bcnTxDMADead_int | (trigTxBcnPI & underRunDetected_p);
assign ac3TxDMADead   =  ac3TxDMADead_int | (trigTxAC3PI & underRunDetected_p);
assign ac2TxDMADead   =  ac2TxDMADead_int | (trigTxAC2PI & underRunDetected_p);
assign ac1TxDMADead   =  ac1TxDMADead_int | (trigTxAC1PI & underRunDetected_p);
assign ac0TxDMADead   =  ac0TxDMADead_int | (trigTxAC0PI & underRunDetected_p);

assign debugPortDMA1 = {oredNewHead,oredNewTail,2'b00,2'b00,txBcnState,txAC3State,txAC2State,txAC1State,txAC0State};
assign debugPortDMA2 = {statusUpdaterFull,rxListProcCs,interruptEnTx,rxInterrupt,txInterrupt,oredNewTail,oredNewHead,txListProcCs};
assign debugPortDMA4 = {dmaHIFRead,
                        txCtrlRegHD || txCtrlRegPT,
                        txCtrlRegBusy,
                        txCtrlRegWr,
                        discardPrevHD_p,
                        txFifoAlmostFull,
                        txFifoFull,
                        txFifoEmpty,
                        txFifoWr,
                        flushTxFifo,
                        txTagFifoWrData}; // 6bits

// Instanciation of pulse2PulseSynchro
// Name of the instance : U_dmaInternalError_synchro
// Name of the file containing this module : pulse2PulseSynchro.v
pulse2PulseSynchro U_dmaInternalError_synchro (
                .srcclk             (macPIClk),
                .srcresetn          (macPIClkHardRst_n),
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (dmaInternalError_int),
                .dstdata            (dmaInternalError)
                );
   
endmodule
