////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//------------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//------------------------------------------------------------------------------
// $Revision: $
// $Date: $
// -----------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : This block is a data wtBuffer with ready/valid flow control.
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -----------------------------------------------------------------------------
//                                                                          
// 
// 
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

module wepTkipBuffer #(
   parameter SIZE=8
) (
   //$port_g Clock and reset
   input  wire            clk,                   // Clock
   input  wire            hardRst_n,             // Hardware Reset
   input  wire            softRst_n,             // Software Reset
                                                                  
   //$port_g Data interface
   input  wire [SIZE-1:0] dataIn,                // Data Input
   input  wire            dataInValid,           // Data Input valid
   output wire            dataInReady,           // Data Input ready
   output wire [SIZE-1:0] dataOut,               // Data Output
   output wire            dataOutValid,          // Data Output valid
   input  wire            dataOutReady           // Data Output ready
);


////////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
////////////////////////////////////////////////////////////////////////////////
reg [SIZE-1:0] wtBuffer;
reg            full;


////////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
////////////////////////////////////////////////////////////////////////////////

//******************************************************************************
// wtBuffer
//******************************************************************************
always @(posedge clk or negedge hardRst_n)
begin
   if (!hardRst_n)
   begin
      wtBuffer <= {SIZE{1'b0}};
      full   <= 1'b0;
   end
   else if (!softRst_n)
   begin
      wtBuffer <= {SIZE{1'b0}};
      full   <= 1'b0;
   end
   else if (dataInValid  && !full)
   begin
      wtBuffer <= dataIn;
      full   <= 1'b1;
   end
   else if (dataOutReady &&  full)
   begin
      wtBuffer <= {SIZE{1'b0}};
      full   <= 1'b0;
   end
end

assign dataOut      =  wtBuffer;
assign dataOutValid =  full;
assign dataInReady  = !full;


endmodule
////////////////////////////////////////////////////////////////////////////////
// END OF FILE
////////////////////////////////////////////////////////////////////////////////
