//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 15063 $
// $Date: 2014-05-24 10:01:22 +0200 (Sat, 24 May 2014) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : AHB Master IF file. 
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// 
// 
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module ahbMasterDelay (

  //$port_g clock and reset
  input wire                 macPIClk         ,// AHB Clock (12MHz to 100 MHz)   
  input wire                 macPIClkHardRst_n,// AHB Reset signal. Power on reset.  

  //$port_g  AHB Input interface
  input wire   [31:0]        hMAddr            ,// Address for the transaction for external AHB slave
  input wire   [ 1:0]        hMTrans           ,// Transfer Type, for external AHB slave
  input wire   [ 2:0]        hMSize            ,// dmaHIFSize of each transfer, for external AHB slave
  input wire                 hMWrite           ,// Control signal, 1-dmaHIFWrite transfer 0 -dmaHIFRead transfer for external AHB slave
  input wire   [ 2:0]        hMBurst           ,// Type of burst for external AHB slave.
  input wire   [31:0]        hMWData           ,// The data for the dmaHIFWrite transfer, for external AHB slave

  output wire                hMReady           ,// dmaHIFReady signal. 1- transfer can complete, 0- the data phase to be extended. From the addressed slave.
  output wire    [ 1:0]      hMResp            ,// Transfer response for the initited transfer. From the adddressed slave.
  output reg     [31:0]      hMRData,           // Data dmaHIFRead from the addressed location. It is valid when hMReady is 1 from the addressed slave

  //$port_g  AHB Delay interface
  output wire   [31:0]       hMAddr_Del        ,// Address for the transaction for external AHB slave
  output wire   [ 1:0]       hMTrans_Del       ,// Transfer Type, for external AHB slave
  output wire   [ 2:0]       hMSize_Del        ,// dmaHIFSize of each transfer, for external AHB slave
  output wire                hMWrite_Del       ,// Control signal, 1-dmaHIFWrite transfer 0 -dmaHIFRead transfer for external AHB slave
  output wire   [ 2:0]       hMBurst_Del       ,// Type of burst for external AHB slave.
  output wire   [31:0]       hMWData_Del       ,// The data for the dmaHIFWrite transfer, for external AHB slave

  input wire                 hMReady_Del       ,// dmaHIFReady signal. 1- transfer can complete, 0- the data phase to be extended. From the addressed slave.
  input wire    [ 1:0]       hMResp_Del        ,// Transfer response for the initited transfer. From the adddressed slave.
  input wire    [31:0]       hMRData_Del        // Data dmaHIFRead from the addressed location. It is valid when hMReady is 1 from the addressed slave


);


reg [31:0]          hMRData_d;
reg [1:0]           hMResp_d;
reg                 hMReady_d;
reg [1:0]           hMTrans_d;

reg [31:0]          hMAddr_d;	

wire                FirstBurstCycle;

	
always @ (posedge macPIClk or negedge macPIClkHardRst_n) 
  if (macPIClkHardRst_n == 1'b0)  // Asynchronous Reset
    hMTrans_d     <= 2'b0; 
  else 
    hMTrans_d     <= hMTrans;

assign FirstBurstCycle = (hMTrans == 2'b10) && (hMTrans_d == 2'b00);
	
	
always @ (posedge macPIClk or negedge macPIClkHardRst_n) 
  if (macPIClkHardRst_n == 1'b0)  // Asynchronous Reset
    hMRData     <= 32'b0; 
  else if (hMReady_Del)
    hMRData     <= hMRData_Del;
  

always @ (posedge macPIClk or negedge macPIClkHardRst_n) 
  if (macPIClkHardRst_n == 1'b0)  // Asynchronous Reset
    hMResp_d     <= 2'b0; 
  else if (~hMWrite)
    hMResp_d     <= hMResp_Del;
  
assign hMResp  = FirstBurstCycle | hMWrite ? hMResp_Del  : hMResp_d;

always @ (posedge macPIClk or negedge macPIClkHardRst_n) 
  if (macPIClkHardRst_n == 1'b0)  // Asynchronous Reset
    hMReady_d     <= 1'b0; 
  else if (FirstBurstCycle) 
    hMReady_d     <= 1'b0;
  else if (~hMWrite)
    hMReady_d     <= hMReady_Del;
  
assign hMReady = FirstBurstCycle | hMWrite ? hMReady_Del : hMReady_d;


	
always @ (posedge macPIClk or negedge macPIClkHardRst_n) 
  if (macPIClkHardRst_n == 1'b0)  // Asynchronous Reset
    hMAddr_d     <= 32'b0; 
  else if (FirstBurstCycle && hMTrans[1])
    hMAddr_d     <= hMAddr + 4'h4;
  else if (hMReady_Del && hMTrans[1])
    hMAddr_d     <= hMAddr_d + 4'h4;
	
assign hMAddr_Del  = FirstBurstCycle | hMWrite ? hMAddr : hMAddr_d;

assign hMTrans_Del = hMTrans;
assign hMSize_Del  = hMSize;
assign hMWrite_Del = hMWrite;
assign hMBurst_Del = hMBurst;
assign hMWData_Del = hMWData;
	
endmodule

