//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                    
// Description      : Top level of intCtrl module
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module intCtrl( 

      //$port_g clocks and reset
      input wire                         macPIClk                      ,// Platform clock                     
      input wire                         macPIClkHardRst_n             ,// Platfrom Reset
                                         
      //$port_g  REGISTERS INTERFACE
      //$port_g general interrupts enable
      input wire                         masterGenIntEn                ,//General Interrupt master Enable
      
      //$port_g general set interrupts
      input wire                         setphyRxStart                 ,// set phyRxStart interruption      
      input wire                         setphyErr                     ,// set phyErr interruption                 
      input wire                         setmacPHYIFUnderRun           ,// set macPHYIFUnderRun interruption       
      input wire                         sethwErr                      ,// set hwErr interruption                  
      input wire                         setimpSecDTIM                 ,// set impSecDTIM interruption             
      input wire                         setimpPriDTIM                 ,// set impPriDTIM interruption             
      input wire                         settbTxDMADead                ,// set tbTxDMADead interruption           
      input wire                         setbcnTxDMADead               ,// set bcnTxDMADead interruption           
      input wire                         setac3TxDMADead               ,// set ac3TxDMADead interruption           
      input wire                         setac2TxDMADead               ,// set ac2TxDMADead interruption           
      input wire                         setac1TxDMADead               ,// set ac1TxDMADead interruption           
      input wire                         setac0TxDMADead               ,// set ac0TxDMADead interruption           
      input wire                         setptError                    ,// set ptError interruption                
      input wire                         settimSet                     ,// set timSet interruption                 
      input wire                         setolbcDSSS                   ,// set olbcDSSS interruption               
      input wire                         setolbcOFDM                   ,// set olbcOFDM interruption               
      input wire                         setrxFIFOOverFlow             ,// set rxFIFOOverFlow interruption         
      input wire                         setmacPHYIFOverflow           ,// set macPHYIFOverflow interruption             
      input wire                         setrxPayloadDMADead           ,// set rxPayloadDMADead interruption             
      input wire                         setrxHeaderDMADead            ,// set rxHeaderDMADead interruption             
      input wire                         absGenTimers                  ,// set absTimer interruption              
      input wire [9:0]                   setabsTimers                  ,// set absTimer interruption              
      input wire                         setidleInterrupt              ,// set idleInterrupt interruption          
      input wire                         setimpSecTBTT                 ,// set impSecTBTT interruption             
      input wire                         setimpPriTBTT                 ,// set impPriTBTT interruption             
      
      //$port_g general interrupts clear
      input wire                         clearphyRxStart               ,// clear phyRxStart interruption      
      input wire                         clearphyErr                   ,// clear phyErr interruption              
      input wire                         clearmacPHYIFUnderRun         ,// clear macPHYIFUnderRun interruption    
      input wire                         clearhwErr                    ,// clear hwErr interruption               
      input wire                         clearimpSecDTIM               ,// clear impSecDTIM interruption          
      input wire                         clearimpPriDTIM               ,// clear impPriDTIM interruption          
      input wire                         cleartbTxDMADead              ,// clear tbTxDMADead interruption        
      input wire                         clearbcnTxDMADead             ,// clear bcnTxDMADead interruption        
      input wire                         clearac3TxDMADead             ,// clear ac3TxDMADead interruption        
      input wire                         clearac2TxDMADead             ,// clear ac2TxDMADead interruption        
      input wire                         clearac1TxDMADead             ,// clear ac1TxDMADead interruption        
      input wire                         clearac0TxDMADead             ,// clear ac0TxDMADead interruption        
      input wire                         clearptError                  ,// clear ptError interruption             
      input wire                         cleartimSet                   ,// clear timSet interruption              
      input wire                         clearolbcDSSS                 ,// clear olbcDSSS interruption            
      input wire                         clearolbcOFDM                 ,// clear olbcOFDM interruption            
      input wire                         clearrxFIFOOverFlow           ,// clear rxFIFOOverFlow interruption      
      input wire                         clearmacPHYIFOverflow         ,// clear macPHYIFOverflow interruption          
      input wire                         clearrxPayloadDMADead         ,// clear rxPayloadDMADead interruption          
      input wire                         clearrxHeaderDMADead          ,// clear rxHeaderDMADead interruption          
      input wire [9:0]                   clearabsTimers                ,// clear absTimer interruption           
      input wire                         clearidleInterrupt            ,// clear idleInterrupt interruption       
      input wire                         clearimpSecTBTT               ,// clear impSecTBTT interruption          
      input wire                         clearimpPriTBTT               ,// clear impPriTBTT interruption          
      
      //$port_g general interrupts mask
      input wire                         maskphyRxStart                ,// phyRxStart mask interruption
      input wire                         maskphyErr                    ,// phyErr mask interruption
      input wire                         maskmacPHYIFUnderRun          ,// macPHYIFUnderRun mask interruption
      input wire                         maskhwErr                     ,// hwErr mask interruption
      input wire                         maskimpSecDTIM                ,// impSecDTIM mask interruption
      input wire                         maskimpPriDTIM                ,// impPriDTIM mask interruption
      input wire                         masktbTxDMADead               ,// tbTxDMADead mask interruption
      input wire                         maskbcnTxDMADead              ,// bcnTxDMADead mask interruption
      input wire                         maskac3TxDMADead              ,// ac3TxDMADead mask interruption
      input wire                         maskac2TxDMADead              ,// ac2TxDMADead mask interruption
      input wire                         maskac1TxDMADead              ,// ac1TxDMADead mask interruption
      input wire                         maskac0TxDMADead              ,// ac0TxDMADead mask interruption
      input wire                         maskptError                   ,// ptError mask interruption
      input wire                         masktimSet                    ,// timSet mask interruption
      input wire                         maskolbcDSSS                  ,// olbcDSSS mask interruption
      input wire                         maskolbcOFDM                  ,// olbcOFDM mask interruption
      input wire                         maskrxFIFOOverFlow            ,// rxFIFOOverFlow mask interruption
      input wire                         maskmacPHYIFOverflow          ,// macPHYIFOverflow mask interruption
      input wire                         maskrxPayloadDMADead          ,// rxPayloadDMADead mask interruption
      input wire                         maskrxHeaderDMADead           ,// rxHeaderDMADead mask interruption
      input wire                         maskabsGenTimers              ,// absTimer mask interruption    
      input wire [9:0]                   maskabsTimers                 ,// absTimer mask interruption    
      input wire                         maskidleInterrupt             ,// idleInterrupt mask interruption
      input wire                         maskimpSecTBTT                ,// impSecTBTT mask interruption
      input wire                         maskimpPriTBTT                ,// impPriTBTT interruption       
      
      //$port_g general interrupts statusset
      output wire                        statussetphyRxStart           ,//  phyRxStart interruption status
      output wire                        statussetphyErr               ,//  phyErr interruption status
      output wire                        statussetmacPHYIFUnderRun     ,//  macPHYIFUnderRun interruption status
      output wire                        statussethwErr                ,//  hwErr interruption status
      output wire                        statussetimpSecDTIM           ,//  impSecDTIM interruption status
      output wire                        statussetimpPriDTIM           ,//  impPriDTIM interruption status
      output wire                        statussettbTxDMADead          ,//  tbTxDMADead interruption status
      output wire                        statussetbcnTxDMADead         ,//  bcnTxDMADead interruption status
      output wire                        statussetac3TxDMADead         ,//  ac3TxDMADead interruption status
      output wire                        statussetac2TxDMADead         ,//  ac2TxDMADead interruption status
      output wire                        statussetac1TxDMADead         ,//  ac1TxDMADead interruption status
      output wire                        statussetac0TxDMADead         ,//  ac0TxDMADead interruption status
      output wire                        statussetptError              ,//  ptError interruption status
      output wire                        statussettimSet               ,//  timSet interruption status
      output wire                        statussetolbcDSSS             ,//  olbcDSSS interruption status
      output wire                        statussetolbcOFDM             ,//  olbcOFDM interruption status
      output wire                        statussetrxFIFOOverFlow       ,//  rxFIFOOverFlow interruption status
      output wire                        statussetmacPHYIFOverflow     ,//  macPHYIFOverflow interruption status
      output wire                        statussetrxPayloadDMADead     ,//  rxPayloadDMADead interruption status
      output wire                        statussetrxHeaderDMADead      ,//  rxHeaderDMADead interruption status
      output wire                        statusabsGenTimers            ,//  All absTimer interruption status
      output wire [9:0]                  statussetabsTimers            ,//  absTimer interruption status
      output wire                        statussetidleInterrupt        ,//  idleInterrupt interruption status
      output wire                        statussetimpSecTBTT           ,//  impSecTBTT interruption status
      output wire                        statussetimpPriTBTT           ,//  impPriTBTT interruption status

      //$port_g general interrupts enable
      input wire                         masterTxRxIntEn               ,// TxRx Interruption master enable
      //$port_g Rx/Tx set interrupts
      input wire                         settimerRxTrigger             ,//  set timerRxTrigger  
      input wire                         setrxBuffer1Trigger           ,//  set rxBuffer1Trigger
      input wire                         setrxBuffer2Trigger           ,//  set rxBuffer2Trigger       
      input wire                         setac3TxBufTrigger            ,//  set ac3TxBufTrigger    
      input wire                         setac2TxBufTrigger            ,//  set ac2TxBufTrigger    
      input wire                         setac1TxBufTrigger            ,//  set ac1TxBufTrigger    
      input wire                         setac0TxBufTrigger            ,//  set ac0TxBufTrigger    
      input wire                         setbcnTxBufTrigger            ,//  set bcnTxBufTrigger    
      input wire                         settbTxBufTrigger             ,//  set tbTxBufTrigger    
      input wire                         settimerTxTrigger             ,//  set timerTxTrigger  
      input wire                         settxopComplete               ,//  set txopComplete    
      input wire                         setac3TxTrigger               ,//  set ac3TxTrigger    
      input wire                         setac2TxTrigger               ,//  set ac2TxTrigger    
      input wire                         setac1TxTrigger               ,//  set ac1TxTrigger    
      input wire                         setac0TxTrigger               ,//  set ac0TxTrigger    
      input wire                         setbcnTxTrigger               ,//  set bcnTxTrigger    
      input wire                         settbTxTrigger                ,//  set tbTxTrigger    
      input wire                         settbTxCancelled              ,//  set tbTxCancelled  
      input wire                         settbProtTrigger              ,//  set tbProtTrigger  
      input wire                         setac3ProtTrigger             ,//  set ac3ProtTrigger  
      input wire                         setac2ProtTrigger             ,//  set ac2ProtTrigger  
      input wire                         setac1ProtTrigger             ,//  set ac1ProtTrigger  
      input wire                         setac0ProtTrigger             ,//  set ac0ProtTrigger  
      input wire                         setac3BWDropTrigger           ,//  set ac3BWDropTrigger  
      input wire                         setac2BWDropTrigger           ,//  set ac2BWDropTrigger  
      input wire                         setac1BWDropTrigger           ,//  set ac1BWDropTrigger  
      input wire                         setac0BWDropTrigger           ,//  set ac0BWDropTrigger  
     
      //$port_g Rx/Tx clear interrupts
      input wire                         cleartimerRxTrigger           ,//  clear timerRxTrigger  
      input wire                         clearrxBuffer1Trigger         ,//  clear rxBuffer1Trigger       
      input wire                         clearrxBuffer2Trigger         ,//  clear rxBuffer2Trigger       
      input wire                         clearac3TxBufTrigger          ,//  clear ac3TxBufTrigger    
      input wire                         clearac2TxBufTrigger          ,//  clear ac2TxBufTrigger    
      input wire                         clearac1TxBufTrigger          ,//  clear ac1TxBufTrigger    
      input wire                         clearac0TxBufTrigger          ,//  clear ac0TxBufTrigger    
      input wire                         clearbcnTxBufTrigger          ,//  clear bcnTxBufTrigger    
      input wire                         cleartbTxBufTrigger           ,//  clear tbTxBufTrigger    
      input wire                         cleartimerTxTrigger           ,//  clear timerTxTrigger  
      input wire                         cleartxopComplete             ,//  clear txopComplete    
      input wire                         clearac3TxTrigger             ,//  clear ac3TxTrigger    
      input wire                         clearac2TxTrigger             ,//  clear ac2TxTrigger    
      input wire                         clearac1TxTrigger             ,//  clear ac1TxTrigger    
      input wire                         clearac0TxTrigger             ,//  clear ac0TxTrigger    
      input wire                         clearbcnTxTrigger             ,//  clear bcnTxTrigger    
      input wire                         cleartbTxTrigger              ,//  clear tbTxTrigger    
      input wire                         cleartbTxCancelled            ,//  clear tbTxCancelled
      input wire                         cleartbProtTrigger            ,//  clear tbProtTrigger  
      input wire                         clearac3ProtTrigger           ,//  clear ac3ProtTrigger  
      input wire                         clearac2ProtTrigger           ,//  clear ac2ProtTrigger  
      input wire                         clearac1ProtTrigger           ,//  clear ac1ProtTrigger  
      input wire                         clearac0ProtTrigger           ,//  clear ac0BWDropTrigger  
      input wire                         clearac3BWDropTrigger         ,//  clear ac3BWDropTrigger  
      input wire                         clearac2BWDropTrigger         ,//  clear ac2BWDropTrigger  
      input wire                         clearac1BWDropTrigger         ,//  clear ac1BWDropTrigger  
      input wire                         clearac0BWDropTrigger         ,//  clear ac0BWDropTrigger  
      //$port_g Rx/Tx mask interrupts
      input wire                         masktimerRxTrigger            ,// timerRxTrigger output interruption mask 
      input wire                         maskrxBuffer1Trigger          ,// rxBuffer1Trigger output interruption mask 
      input wire                         maskrxBuffer2Trigger          ,// rxBuffer2Trigger output interruption mask 
      input wire                         maskac3TxBufTrigger           ,// ac3TxBufTrigger output interruption mask 
      input wire                         maskac2TxBufTrigger           ,// ac2TxBufTrigger output interruption mask 
      input wire                         maskac1TxBufTrigger           ,// ac1TxBufTrigger output interruption mask 
      input wire                         maskac0TxBufTrigger           ,// ac0TxBufTrigger output interruption mask 
      input wire                         maskbcnTxBufTrigger           ,// bcnTxBufTrigger output interruption mask 
      input wire                         masktbTxBufTrigger            ,// tbTxBufTrigger output interruption mask 
      input wire                         masktimerTxTrigger            ,// timerTxTrigger output interruption mask 
      input wire                         masktxopComplete              ,// txopComplete output interruption mask 
      input wire                         maskac3TxTrigger              ,// ac3TxTrigger output interruption mask 
      input wire                         maskac2TxTrigger              ,// ac2TxTrigger output interruption mask 
      input wire                         maskac1TxTrigger              ,// ac1TxTrigger output interruption mask 
      input wire                         maskac0TxTrigger              ,// ac0TxTrigger output interruption mask 
      input wire                         maskbcnTxTrigger              ,// bcnTxTrigger output interruption mask 
      input wire                         masktbTxTrigger               ,// tbTxTrigger output interruption mask 
      input wire                         masktbTxCancelled             ,// tbTxCancelled output interruption mask 
      input wire                         masktbProtTrigger             ,// tbProtTrigger output interruption mask 
      input wire                         maskac3ProtTrigger            ,// ac3ProtTrigger output interruption mask 
      input wire                         maskac2ProtTrigger            ,// ac2ProtTrigger output interruption mask 
      input wire                         maskac1ProtTrigger            ,// ac1ProtTrigger output interruption mask 
      input wire                         maskac0ProtTrigger            ,// ac0BWDropTrigger output interruption mask 
      input wire                         maskac3BWDropTrigger          ,// ac3BWDropTrigger output interruption mask 
      input wire                         maskac2BWDropTrigger          ,// ac2BWDropTrigger output interruption mask 
      input wire                         maskac1BWDropTrigger          ,// ac1BWDropTrigger output interruption mask 
      input wire                         maskac0BWDropTrigger          ,// ac0BWDropTrigger output interruption mask 

      //$port_g Rx/Tx interrupts statusset
      output wire                        statussettimerRxTrigger       ,//  timerRxTrigger interruption status
      output wire                        statussetrxBuffer1Trigger     ,//  rxBuffer1Trigger interruption status
      output wire                        statussetrxBuffer2Trigger     ,//  rxBuffer2Trigger interruption status
      output wire                        statussetac3TxBufTrigger      ,//  ac3TxBufTrigger interruption status
      output wire                        statussetac2TxBufTrigger      ,//  ac2TxBufTrigger interruption status
      output wire                        statussetac1TxBufTrigger      ,//  ac1TxBufTrigger interruption status
      output wire                        statussetac0TxBufTrigger      ,//  ac0TxBufTrigger interruption status
      output wire                        statussetbcnTxBufTrigger      ,//  bcnTxBufTrigger interruption status
      output wire                        statussettbTxBufTrigger       ,//  tbTxBufTrigger interruption status
      output wire                        statussettimerTxTrigger       ,//  timerTxTrigger interruption status
      output wire                        statussettxopComplete         ,//  txopComplete interruption status
      output wire                        statussetac3TxTrigger         ,//  ac3TxTrigger interruption status
      output wire                        statussetac2TxTrigger         ,//  ac2TxTrigger interruption status
      output wire                        statussetac1TxTrigger         ,//  ac1TxTrigger interruption status
      output wire                        statussetac0TxTrigger         ,//  ac0TxTrigger interruption status
      output wire                        statussetbcnTxTrigger         ,//  bcnTxTrigger interruption status
      output wire                        statussettbTxTrigger          ,//  tbTxTrigger interruption status
      output wire                        statussettbTxCancelled        ,//  tbTxCancelled interruption status
      output wire                        statussettbProtTrigger        ,//  tbProtTrigger interruption status
      output wire                        statussetac3ProtTrigger       ,//  ac3ProtTrigger interruption status
      output wire                        statussetac2ProtTrigger       ,//  ac2ProtTrigger interruption status
      output wire                        statussetac1ProtTrigger       ,//  ac1ProtTrigger interruption status
      output wire                        statussetac0ProtTrigger       ,//  ac0ProtTrigger interruption status
      output wire                        statussetac3BWDropTrigger     ,//  ac3BWDropTrigger interruption status
      output wire                        statussetac2BWDropTrigger     ,//  ac2BWDropTrigger interruption status
      output wire                        statussetac1BWDropTrigger     ,//  ac1BWDropTrigger interruption status
      output wire                        statussetac0BWDropTrigger     ,//  ac0BWDropTrigger interruption status

      //$port_g internal interruptions interruption
      input wire                         phyRxStart                    ,// phyRxStart internal interruption
      input wire                         phyErr                        ,// phyErr internal interruption
      input wire                         macPHYIFUnderRun              ,// macPHYIFUnderRun internal interruption
      input wire                         hwErr                         ,// hwErr internal interruption
      input wire                         impSecDTIM                    ,// impSecDTIM internal interruption
      input wire                         impPriDTIM                    ,// impPriDTIM internal interruption
      input wire                         tbTxDMADead                   ,// bcnTxDMADead internal interruption
      input wire                         bcnTxDMADead                  ,// bcnTxDMADead internal interruption
      input wire                         ac3TxDMADead                  ,// ac3TxDMADead internal interruption
      input wire                         ac2TxDMADead                  ,// ac2TxDMADead internal interruption
      input wire                         ac1TxDMADead                  ,// ac1TxDMADead internal interruption
      input wire                         ac0TxDMADead                  ,// ac0TxDMADead internal interruption
      input wire                         ptError                       ,// ptError internal interruption
      input wire                         timSet                        ,// timSet internal interruption
      input wire                         olbcDSSS                      ,// olbcDSSS internal interruption
      input wire                         olbcOFDM                      ,// olbcOFDM internal interruption
      input wire                         rxFIFOOverFlow                ,// rxFIFOOverFlow internal interruption
      input wire                         macPHYIFOverflow              ,// macPHYIFOverflow internal interruption
      input wire                         rxPayloadDMADead              ,// rxPayloadDMADead internal interruption
      input wire                         rxHeaderDMADead               ,// rxHeaderDMADead internal interruption
      input wire [9:0]                   absTimers                     ,// absTimer internal interruption
      input wire                         idleInterrupt                 ,// idleInterrupt internal interruption
      input wire                         impSecTBTT                    ,// impSecTBTT internal interruption
      input wire                         impPriTBTT                    ,// impPriTBTT internal interruption
      input wire                         timerRxTrigger                ,// timerRxTrigger internal interruption
      input wire                         rxBuffer1Trigger              ,// rxBuffer1Trigger internal interruption
      input wire                         rxBuffer2Trigger              ,// rxBuffer2Trigger internal interruption
      input wire                         ac3TxBufTrigger               ,// ac3TxBufTrigger internal interruption
      input wire                         ac2TxBufTrigger               ,// ac2TxBufTrigger internal interruption
      input wire                         ac1TxBufTrigger               ,// ac1TxBufTrigger internal interruption
      input wire                         ac0TxBufTrigger               ,// ac0TxBufTrigger internal interruption
      input wire                         bcnTxBufTrigger               ,// bcnTxBufTrigger internal interruption
      input wire                         tbTxBufTrigger                ,// tbTxBufTrigger internal interruption
      input wire                         timerTxTrigger                ,// timerTxTrigger internal interruption
      input wire                         txopComplete                  ,// txopComplete internal interruption
      input wire                         ac3TxTrigger                  ,// ac3TxTrigger internal interruption
      input wire                         ac2TxTrigger                  ,// ac2TxTrigger internal interruption
      input wire                         ac1TxTrigger                  ,// ac1TxTrigger internal interruption
      input wire                         ac0TxTrigger                  ,// ac0TxTrigger internal interruption
      input wire                         bcnTxTrigger                  ,// bcnTxTrigger internal interruption
      input wire                         tbTxTrigger                   ,// tbTxTrigger internal interruption
      input wire                         tbTxCancelled                 ,// tbTxCancelled internal interruption
      input wire                         tbProtTrigger                 ,// tbProtTrigger internal interruption
      input wire                         ac3ProtTrigger                ,// ac3ProtTrigger internal interruption
      input wire                         ac2ProtTrigger                ,// ac2ProtTrigger internal interruption
      input wire                         ac1ProtTrigger                ,// ac1ProtTrigger internal interruption
      input wire                         ac0ProtTrigger                ,// ac0ProtTrigger internal interruption
      input wire                         ac3BWDropTrigger              ,// ac3BWDropTrigger internal interruption
      input wire                         ac2BWDropTrigger              ,// ac2BWDropTrigger internal interruption
      input wire                         ac1BWDropTrigger              ,// ac1BWDropTrigger internal interruption
      input wire                         ac0BWDropTrigger              ,// ac0BWDropTrigger internal interruption
      
  `ifdef RW_WLAN_COEX_EN
      input wire                         setcoexEvent,                  // set setcoexEvent interruption          
      input wire                         clearcoexEvent,                // set setcoexEvent interruption          
      input wire                         maskcoexEvent,                 // set setcoexEvent interruption
      input wire                         coexEvent,                     // coexEvent internal interruption
      output wire                        statussetcoexEvent,            //  coexEvent interruption status
  `endif // RW_WLAN_COEX_EN


      //$port_g Output interruptions
      output wire                        intGen_n                      ,// Active low general interrupt signal.
      output wire                        intProtTrigger_n              ,// Active low protocol event interrupt signal
      output wire                        intTxTrigger_n                ,// Active low TX event interrupt signal
      output wire                        intRxTrigger_n                ,// Active low Rx event interrupt signal
      output wire                        intTxRxMisc_n                 ,// Active low Misc Tx/Rx event interrupt signal
      output wire                        intTxRxTimer_n                 // Active low Timer Rx event interrupt signal


                 );


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
wire oredInterruptGen;                                      // ored general interrupt line
wire oredIntProtTrigger;                                    // ored protocol event interrupt line
wire oredIntTxTrigger;                                      // ored TX event interrupt line
wire oredIntRxTrigger;                                      // ored Rx event interrupt line
wire oredIntTxRxMisc;                                       // ored Misc Tx/Rx event interrupt line
wire oredIntTxRxTimer;                                      // ored Timer Tx/Rx event interrupt line


//resynched interruptions
                             
wire                         intphyRxStart                 ;// phyRxStart internal register
wire                         intphyErr                     ;// phyErr internal register
wire                         intmacPHYIFUnderRun           ;// macPHYIFUnderRun internal register
wire                         intmacPHYIFOverflow           ;// macPHYIFOverflow internal register
wire                         inthwErr                      ;// hwErr internal register
wire                         intimpSecDTIM                 ;// impSecDTIM internal register
wire                         intimpPriDTIM                 ;// impPriDTIM internal register
wire                         inttimSet                     ;// timSet internal register
wire                         intolbcDSSS                   ;// olbcDSSS internal register
wire                         intolbcOFDM                   ;// olbcOFDM internal register
wire                         intrxFIFOOverFlow             ;// rxFIFOOverFlow internal register
wire [9:0]                   intabsTimers                  ;// absTimer internal register
wire                         intidleInterrupt              ;// idleInterrupt internal register
`ifdef RW_WLAN_COEX_EN
wire                         intcoexEvent                  ;// coexEvent internal register
`endif // RW_WLAN_COEX_EN
wire                         intimpSecTBTT                 ;// impSecTBTT internal register
wire                         intimpPriTBTT                 ;// impPriTBTT internal register
wire                         inttimerRxTrigger             ;// timerRxTrigger internal register
wire                         inttimerTxTrigger             ;// timerTxTrigger internal register
wire                         inttxopComplete               ;// txopComplete internal register
wire                         intac3ProtTrigger             ;// ac3ProtTrigger internal register
wire                         intac2ProtTrigger             ;// ac2ProtTrigger internal register
wire                         intac1ProtTrigger             ;// ac1ProtTrigger internal register
wire                         intac0ProtTrigger             ;// ac0ProtTrigger internal register
wire                         intac3BWDropTrigger           ;// ac3BWDropTrigger internal register
wire                         intac2BWDropTrigger           ;// ac2BWDropTrigger internal register
wire                         intac1BWDropTrigger           ;// ac1BWDropTrigger internal register
wire                         intac0BWDropTrigger           ;// ac0BWDropTrigger internal register

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////


// output interruptions
assign intGen_n  = (! (oredInterruptGen  && masterGenIntEn ));
assign intProtTrigger_n = (! (oredIntProtTrigger && masterTxRxIntEn));
assign intTxTrigger_n = (! (oredIntTxTrigger && masterTxRxIntEn));
assign intRxTrigger_n = (! (oredIntRxTrigger && masterTxRxIntEn));
assign intTxRxMisc_n = (! (oredIntTxRxMisc && masterTxRxIntEn));
assign intTxRxTimer_n = (! (oredIntTxRxTimer && masterTxRxIntEn));


// ORing interruptions

assign oredInterruptGen     =  statussetphyRxStart       ||
                               statussetphyErr           ||
                               statussetmacPHYIFUnderRun ||
                               statussethwErr            ||
                               statussetimpSecDTIM       ||
                               statussetimpPriDTIM       ||
                               statussettbTxDMADead      ||
                               statussetbcnTxDMADead     ||
                               statussetac3TxDMADead     ||
                               statussetac2TxDMADead     ||
                               statussetac1TxDMADead     ||
                               statussetac0TxDMADead     ||
                               statussetptError          ||
                               statussettimSet           ||
                               statussetolbcDSSS         ||
                               statussetolbcOFDM         ||
                               statussetrxFIFOOverFlow   ||
                               statussetmacPHYIFOverflow ||
                               statussetrxPayloadDMADead ||
                               statussetrxHeaderDMADead  ||
                               statusabsGenTimers        ||
                            `ifdef RW_WLAN_COEX_EN
                               statussetcoexEvent        ||
                            `endif // RW_WLAN_COEX_EN
                               statussetidleInterrupt    ||
                               statussetimpSecTBTT       ||
                               statussetimpPriTBTT;      


assign oredIntProtTrigger    = statussettbProtTrigger    ||
                               statussetac3ProtTrigger   ||
                               statussetac2ProtTrigger   ||
                               statussetac1ProtTrigger   ||
                               statussetac0ProtTrigger   ||
                               statussetac3BWDropTrigger ||
                               statussetac2BWDropTrigger ||
                               statussetac1BWDropTrigger ||
                               statussetac0BWDropTrigger;

assign oredIntTxTrigger      = statussetac3TxBufTrigger  ||
                               statussetac2TxBufTrigger  ||
                               statussetac1TxBufTrigger  ||
                               statussetac0TxBufTrigger  ||
                               statussetbcnTxBufTrigger  ||
                               statussettbTxBufTrigger   ||
                               statussetac3TxTrigger     ||
                               statussetac2TxTrigger     ||
                               statussetac1TxTrigger     ||
                               statussetac0TxTrigger     ||
                               statussetbcnTxTrigger     ||
                               statussettbTxTrigger      ||
                               statussettbTxCancelled;

assign oredIntRxTrigger      = statussetrxBuffer1Trigger ||
                               statussetrxBuffer2Trigger;

assign oredIntTxRxMisc       = statussettxopComplete;

assign oredIntTxRxTimer      = statussettimerTxTrigger   ||
                               statussettimerRxTrigger;

assign statusabsGenTimers    = (statussetabsTimers != 10'b0) ? maskabsGenTimers : 1'b0;

// Instanciation of intCtrlRegisters
// Name of the instance : U_intCtrlRegisters
// Name of the file containing this module : intCtrlRegisters.v
intCtrlRegisters U_intCtrlRegisters (
   .macPIClk                         (macPIClk),
   .macPIClkHardRst_n                (macPIClkHardRst_n),
   .setphyRxStart                    (setphyRxStart),
   .setphyErr                        (setphyErr),
   .setmacPHYIFUnderRun              (setmacPHYIFUnderRun),
   .sethwErr                         (sethwErr),
   .setimpSecDTIM                    (setimpSecDTIM),
   .setimpPriDTIM                    (setimpPriDTIM),
   .settbTxDMADead                   (settbTxDMADead),
   .setbcnTxDMADead                  (setbcnTxDMADead),
   .setac3TxDMADead                  (setac3TxDMADead),
   .setac2TxDMADead                  (setac2TxDMADead),
   .setac1TxDMADead                  (setac1TxDMADead),
   .setac0TxDMADead                  (setac0TxDMADead),
   .setptError                       (setptError),
   .settimSet                        (settimSet),
   .setolbcDSSS                      (setolbcDSSS),
   .setolbcOFDM                      (setolbcOFDM),
   .setrxFIFOOverFlow                (setrxFIFOOverFlow),
   .setmacPHYIFOverflow              (setmacPHYIFOverflow),
   .setrxPayloadDMADead              (setrxPayloadDMADead),
   .setrxHeaderDMADead               (setrxHeaderDMADead),
   .setabsTimers                     (setabsTimers),
   .setidleInterrupt                 (setidleInterrupt),
   .setimpSecTBTT                    (setimpSecTBTT),
   .setimpPriTBTT                    (setimpPriTBTT),
   .clearphyRxStart                  (clearphyRxStart),
   .clearphyErr                      (clearphyErr),
   .clearmacPHYIFUnderRun            (clearmacPHYIFUnderRun),
   .clearhwErr                       (clearhwErr),
   .clearimpSecDTIM                  (clearimpSecDTIM),
   .clearimpPriDTIM                  (clearimpPriDTIM),
   .cleartbTxDMADead                 (cleartbTxDMADead),
   .clearbcnTxDMADead                (clearbcnTxDMADead),
   .clearac3TxDMADead                (clearac3TxDMADead),
   .clearac2TxDMADead                (clearac2TxDMADead),
   .clearac1TxDMADead                (clearac1TxDMADead),
   .clearac0TxDMADead                (clearac0TxDMADead),
   .clearptError                     (clearptError),
   .cleartimSet                      (cleartimSet),
   .clearolbcDSSS                    (clearolbcDSSS),
   .clearolbcOFDM                    (clearolbcOFDM),
   .clearrxFIFOOverFlow              (clearrxFIFOOverFlow),
   .clearmacPHYIFOverflow            (clearmacPHYIFOverflow),
   .clearrxPayloadDMADead            (clearrxPayloadDMADead),
   .clearrxHeaderDMADead             (clearrxHeaderDMADead),
   .clearabsTimers                   (clearabsTimers),
   .clearidleInterrupt               (clearidleInterrupt),
   .clearimpSecTBTT                  (clearimpSecTBTT),
   .clearimpPriTBTT                  (clearimpPriTBTT),
   .maskphyRxStart                   (maskphyRxStart),
   .maskphyErr                       (maskphyErr),
   .maskmacPHYIFUnderRun             (maskmacPHYIFUnderRun),
   .maskhwErr                        (maskhwErr),
   .maskimpSecDTIM                   (maskimpSecDTIM),
   .maskimpPriDTIM                   (maskimpPriDTIM),
   .masktbTxDMADead                  (masktbTxDMADead),
   .maskbcnTxDMADead                 (maskbcnTxDMADead),
   .maskac3TxDMADead                 (maskac3TxDMADead),
   .maskac2TxDMADead                 (maskac2TxDMADead),
   .maskac1TxDMADead                 (maskac1TxDMADead),
   .maskac0TxDMADead                 (maskac0TxDMADead),
   .maskptError                      (maskptError),
   .masktimSet                       (masktimSet),
   .maskolbcDSSS                     (maskolbcDSSS),
   .maskolbcOFDM                     (maskolbcOFDM),
   .maskrxFIFOOverFlow               (maskrxFIFOOverFlow),
   .maskmacPHYIFOverflow             (maskmacPHYIFOverflow),
   .maskrxPayloadDMADead             (maskrxPayloadDMADead),
   .maskrxHeaderDMADead              (maskrxHeaderDMADead),
   .maskabsTimers                    (maskabsTimers),
   .maskidleInterrupt                (maskidleInterrupt),
   .maskimpSecTBTT                   (maskimpSecTBTT),
   .maskimpPriTBTT                   (maskimpPriTBTT),
   .statussetphyRxStart              (statussetphyRxStart),
   .statussetphyErr                  (statussetphyErr),
   .statussetmacPHYIFUnderRun        (statussetmacPHYIFUnderRun),
   .statussethwErr                   (statussethwErr),
   .statussetimpSecDTIM              (statussetimpSecDTIM),
   .statussetimpPriDTIM              (statussetimpPriDTIM),
   .statussettbTxDMADead             (statussettbTxDMADead),
   .statussetbcnTxDMADead            (statussetbcnTxDMADead),
   .statussetac3TxDMADead            (statussetac3TxDMADead),
   .statussetac2TxDMADead            (statussetac2TxDMADead),
   .statussetac1TxDMADead            (statussetac1TxDMADead),
   .statussetac0TxDMADead            (statussetac0TxDMADead),
   .statussetptError                 (statussetptError),
   .statussettimSet                  (statussettimSet),
   .statussetolbcDSSS                (statussetolbcDSSS),
   .statussetolbcOFDM                (statussetolbcOFDM),
   .statussetrxFIFOOverFlow          (statussetrxFIFOOverFlow),
   .statussetmacPHYIFOverflow        (statussetmacPHYIFOverflow),
   .statussetrxPayloadDMADead        (statussetrxPayloadDMADead),
   .statussetrxHeaderDMADead         (statussetrxHeaderDMADead),
   .statussetabsTimers               (statussetabsTimers),
   .statussetidleInterrupt           (statussetidleInterrupt),
   .statussetimpSecTBTT              (statussetimpSecTBTT),
   .statussetimpPriTBTT              (statussetimpPriTBTT),
   .settimerRxTrigger                (settimerRxTrigger),
   .setrxBuffer1Trigger              (setrxBuffer1Trigger),
   .setrxBuffer2Trigger              (setrxBuffer2Trigger),
   .setac3TxBufTrigger               (setac3TxBufTrigger),
   .setac2TxBufTrigger               (setac2TxBufTrigger),
   .setac1TxBufTrigger               (setac1TxBufTrigger),
   .setac0TxBufTrigger               (setac0TxBufTrigger),
   .setbcnTxBufTrigger               (setbcnTxBufTrigger),
   .settbTxBufTrigger                (settbTxBufTrigger),
   .settimerTxTrigger                (settimerTxTrigger),
   .settxopComplete                  (settxopComplete),
   .setac3TxTrigger                  (setac3TxTrigger),
   .setac2TxTrigger                  (setac2TxTrigger),
   .setac1TxTrigger                  (setac1TxTrigger),
   .setac0TxTrigger                  (setac0TxTrigger),
   .setbcnTxTrigger                  (setbcnTxTrigger),
   .settbTxTrigger                   (settbTxTrigger),
   .settbTxCancelled                 (settbTxCancelled),
   .settbProtTrigger                 (settbProtTrigger),
   .setac3ProtTrigger                (setac3ProtTrigger),
   .setac2ProtTrigger                (setac2ProtTrigger),
   .setac1ProtTrigger                (setac1ProtTrigger),
   .setac0ProtTrigger                (setac0ProtTrigger),
   .setac3BWDropTrigger              (setac3BWDropTrigger),
   .setac2BWDropTrigger              (setac2BWDropTrigger),
   .setac1BWDropTrigger              (setac1BWDropTrigger),
   .setac0BWDropTrigger              (setac0BWDropTrigger),
   .cleartimerRxTrigger              (cleartimerRxTrigger),
   .clearrxBuffer1Trigger            (clearrxBuffer1Trigger),
   .clearrxBuffer2Trigger            (clearrxBuffer2Trigger),
   .clearac3TxBufTrigger             (clearac3TxBufTrigger),
   .clearac2TxBufTrigger             (clearac2TxBufTrigger),
   .clearac1TxBufTrigger             (clearac1TxBufTrigger),
   .clearac0TxBufTrigger             (clearac0TxBufTrigger),
   .clearbcnTxBufTrigger             (clearbcnTxBufTrigger),
   .cleartbTxBufTrigger              (cleartbTxBufTrigger),
   .cleartimerTxTrigger              (cleartimerTxTrigger),
   .cleartxopComplete                (cleartxopComplete),
   .clearac3TxTrigger                (clearac3TxTrigger),
   .clearac2TxTrigger                (clearac2TxTrigger),
   .clearac1TxTrigger                (clearac1TxTrigger),
   .clearac0TxTrigger                (clearac0TxTrigger),
   .clearbcnTxTrigger                (clearbcnTxTrigger),
   .cleartbTxTrigger                 (cleartbTxTrigger),
   .cleartbTxCancelled               (cleartbTxCancelled),
   .cleartbProtTrigger               (cleartbProtTrigger),
   .clearac3ProtTrigger              (clearac3ProtTrigger),
   .clearac2ProtTrigger              (clearac2ProtTrigger),
   .clearac1ProtTrigger              (clearac1ProtTrigger),
   .clearac0ProtTrigger              (clearac0ProtTrigger),
   .clearac3BWDropTrigger            (clearac3BWDropTrigger),
   .clearac2BWDropTrigger            (clearac2BWDropTrigger),
   .clearac1BWDropTrigger            (clearac1BWDropTrigger),
   .clearac0BWDropTrigger            (clearac0BWDropTrigger),
   .masktimerRxTrigger               (masktimerRxTrigger),
   .maskrxBuffer1Trigger             (maskrxBuffer1Trigger),
   .maskrxBuffer2Trigger             (maskrxBuffer2Trigger),
   .maskac3TxBufTrigger              (maskac3TxBufTrigger),
   .maskac2TxBufTrigger              (maskac2TxBufTrigger),
   .maskac1TxBufTrigger              (maskac1TxBufTrigger),
   .maskac0TxBufTrigger              (maskac0TxBufTrigger),
   .maskbcnTxBufTrigger              (maskbcnTxBufTrigger),
   .masktbTxBufTrigger               (masktbTxBufTrigger),
   .masktimerTxTrigger               (masktimerTxTrigger),
   .masktxopComplete                 (masktxopComplete),
   .maskac3TxTrigger                 (maskac3TxTrigger),
   .maskac2TxTrigger                 (maskac2TxTrigger),
   .maskac1TxTrigger                 (maskac1TxTrigger),
   .maskac0TxTrigger                 (maskac0TxTrigger),
   .maskbcnTxTrigger                 (maskbcnTxTrigger),
   .masktbTxTrigger                  (masktbTxTrigger),
   .masktbTxCancelled                (masktbTxCancelled),
   .masktbProtTrigger                (masktbProtTrigger),
   .maskac3ProtTrigger               (maskac3ProtTrigger),
   .maskac2ProtTrigger               (maskac2ProtTrigger),
   .maskac1ProtTrigger               (maskac1ProtTrigger),
   .maskac0ProtTrigger               (maskac0ProtTrigger),
   .maskac3BWDropTrigger             (maskac3BWDropTrigger),
   .maskac2BWDropTrigger             (maskac2BWDropTrigger),
   .maskac1BWDropTrigger             (maskac1BWDropTrigger),
   .maskac0BWDropTrigger             (maskac0BWDropTrigger),
   .statussettimerRxTrigger          (statussettimerRxTrigger),
   .statussetrxBuffer1Trigger        (statussetrxBuffer1Trigger),
   .statussetrxBuffer2Trigger        (statussetrxBuffer2Trigger),
   .statussetac3TxBufTrigger         (statussetac3TxBufTrigger),
   .statussetac2TxBufTrigger         (statussetac2TxBufTrigger),
   .statussetac1TxBufTrigger         (statussetac1TxBufTrigger),
   .statussetac0TxBufTrigger         (statussetac0TxBufTrigger),
   .statussetbcnTxBufTrigger         (statussetbcnTxBufTrigger),
   .statussettbTxBufTrigger          (statussettbTxBufTrigger),
   .statussettimerTxTrigger          (statussettimerTxTrigger),
   .statussettxopComplete            (statussettxopComplete),
   .statussetac3TxTrigger            (statussetac3TxTrigger),
   .statussetac2TxTrigger            (statussetac2TxTrigger),
   .statussetac1TxTrigger            (statussetac1TxTrigger),
   .statussetac0TxTrigger            (statussetac0TxTrigger),
   .statussetbcnTxTrigger            (statussetbcnTxTrigger),
   .statussettbTxTrigger             (statussettbTxTrigger),
   .statussettbTxCancelled           (statussettbTxCancelled),
   .statussettbProtTrigger           (statussettbProtTrigger),
   .statussetac3ProtTrigger          (statussetac3ProtTrigger),
   .statussetac2ProtTrigger          (statussetac2ProtTrigger),
   .statussetac1ProtTrigger          (statussetac1ProtTrigger),
   .statussetac0ProtTrigger          (statussetac0ProtTrigger),
   .statussetac3BWDropTrigger        (statussetac3BWDropTrigger),
   .statussetac2BWDropTrigger        (statussetac2BWDropTrigger),
   .statussetac1BWDropTrigger        (statussetac1BWDropTrigger),
   .statussetac0BWDropTrigger        (statussetac0BWDropTrigger),
`ifdef RW_WLAN_COEX_EN
   .setcoexEvent                     (setcoexEvent),
   .clearcoexEvent                   (clearcoexEvent),
   .maskcoexEvent                    (maskcoexEvent),
   .statussetcoexEvent               (statussetcoexEvent),
   .intcoexEvent                     (intcoexEvent),
`endif // RW_WLAN_COEX_EN
   .intphyRxStart                    (intphyRxStart),
   .intphyErr                        (intphyErr),
   .intmacPHYIFUnderRun              (intmacPHYIFUnderRun),
   .inthwErr                         (inthwErr),
   .intimpSecDTIM                    (intimpSecDTIM),
   .intimpPriDTIM                    (intimpPriDTIM),
   .inttbTxDMADead                   (tbTxDMADead),
   .intbcnTxDMADead                  (bcnTxDMADead),
   .intac3TxDMADead                  (ac3TxDMADead),
   .intac2TxDMADead                  (ac2TxDMADead),
   .intac1TxDMADead                  (ac1TxDMADead),
   .intac0TxDMADead                  (ac0TxDMADead),
   .intptError                       (ptError),
   .inttimSet                        (inttimSet),
   .intolbcDSSS                      (intolbcDSSS),
   .intolbcOFDM                      (intolbcOFDM),
   .intrxFIFOOverFlow                (intrxFIFOOverFlow),
   .intmacPHYIFOverflow              (intmacPHYIFOverflow),
   .intrxPayloadDMADead              (rxPayloadDMADead),
   .intrxHeaderDMADead               (rxHeaderDMADead),
   .intabsTimers                     (intabsTimers),
   .intidleInterrupt                 (intidleInterrupt),
   .intimpSecTBTT                    (intimpSecTBTT),
   .intimpPriTBTT                    (intimpPriTBTT),
   .inttimerRxTrigger                (inttimerRxTrigger),
   .intrxBuffer1Trigger              (rxBuffer1Trigger),
   .intrxBuffer2Trigger              (rxBuffer2Trigger),
   .intac3TxBufTrigger               (ac3TxBufTrigger),
   .intac2TxBufTrigger               (ac2TxBufTrigger),
   .intac1TxBufTrigger               (ac1TxBufTrigger),
   .intac0TxBufTrigger               (ac0TxBufTrigger),
   .intbcnTxBufTrigger               (bcnTxBufTrigger),
   .inttbTxBufTrigger                (tbTxBufTrigger),
   .inttimerTxTrigger                (inttimerTxTrigger),
   .inttxopComplete                  (inttxopComplete),
   .intac3TxTrigger                  (ac3TxTrigger),
   .intac2TxTrigger                  (ac2TxTrigger),
   .intac1TxTrigger                  (ac1TxTrigger),
   .intac0TxTrigger                  (ac0TxTrigger),
   .intbcnTxTrigger                  (bcnTxTrigger),
   .inttbTxTrigger                   (tbTxTrigger),
   .inttbTxCancelled                 (tbTxCancelled),
   .inttbProtTrigger                 (tbProtTrigger),
   .intac3ProtTrigger                (intac3ProtTrigger),
   .intac2ProtTrigger                (intac2ProtTrigger),
   .intac1ProtTrigger                (intac1ProtTrigger),
   .intac0ProtTrigger                (intac0ProtTrigger),
   .intac3BWDropTrigger              (intac3BWDropTrigger),
   .intac2BWDropTrigger              (intac2BWDropTrigger),
   .intac1BWDropTrigger              (intac1BWDropTrigger),
   .intac0BWDropTrigger              (intac0BWDropTrigger)//,
);


// Instanciation of intCtrlResync
// Name of the instance : U_intCtrlResync
// Name of the file containing this module : intCtrlResync.v
intCtrlResync U_intCtrlResync (
   .macPIClk                         (macPIClk),
   .macPIClkHardRst_n                (macPIClkHardRst_n),
   .phyRxStart                       (phyRxStart),
   .phyErr                           (phyErr),
   .macPHYIFUnderRun                 (macPHYIFUnderRun),
   .macPHYIFOverflow                 (macPHYIFOverflow),
   .hwErr                            (hwErr),
   .impSecDTIM                       (impSecDTIM),
   .impPriDTIM                       (impPriDTIM),
   .timSet                           (timSet),
   .olbcDSSS                         (olbcDSSS),
   .olbcOFDM                         (olbcOFDM),
   .rxFIFOOverFlow                   (rxFIFOOverFlow),
   .absTimers                        (absTimers),
   .idleInterrupt                    (idleInterrupt),
   .impSecTBTT                       (impSecTBTT),
   .impPriTBTT                       (impPriTBTT),
   .timerRxTrigger                   (timerRxTrigger),
   .timerTxTrigger                   (timerTxTrigger),
   .txopComplete                     (txopComplete),
   .ac3ProtTrigger                   (ac3ProtTrigger),
   .ac2ProtTrigger                   (ac2ProtTrigger),
   .ac1ProtTrigger                   (ac1ProtTrigger),
   .ac0ProtTrigger                   (ac0ProtTrigger),
   .ac3BWDropTrigger                 (ac3BWDropTrigger),
   .ac2BWDropTrigger                 (ac2BWDropTrigger),
   .ac1BWDropTrigger                 (ac1BWDropTrigger),
   .ac0BWDropTrigger                 (ac0BWDropTrigger),
`ifdef RW_WLAN_COEX_EN
   .coexEvent                        (coexEvent),
   .intcoexEvent                     (intcoexEvent),
`endif // RW_WLAN_COEX_EN
   .intphyRxStart                    (intphyRxStart),
   .intphyErr                        (intphyErr),
   .intmacPHYIFUnderRun              (intmacPHYIFUnderRun),
   .intmacPHYIFOverflow              (intmacPHYIFOverflow),
   .inthwErr                         (inthwErr),
   .intimpSecDTIM                    (intimpSecDTIM),
   .intimpPriDTIM                    (intimpPriDTIM),
   .inttimSet                        (inttimSet),
   .intolbcDSSS                      (intolbcDSSS),
   .intolbcOFDM                      (intolbcOFDM),
   .intrxFIFOOverFlow                (intrxFIFOOverFlow),
   .intabsTimers                     (intabsTimers),
   .intidleInterrupt                 (intidleInterrupt),
   .intimpSecTBTT                    (intimpSecTBTT),
   .intimpPriTBTT                    (intimpPriTBTT),
   .inttimerRxTrigger                (inttimerRxTrigger),
   .inttimerTxTrigger                (inttimerTxTrigger),
   .inttxopComplete                  (inttxopComplete),
   .intac3ProtTrigger                (intac3ProtTrigger),
   .intac2ProtTrigger                (intac2ProtTrigger),
   .intac1ProtTrigger                (intac1ProtTrigger),
   .intac0ProtTrigger                (intac0ProtTrigger),
   .intac3BWDropTrigger              (intac3BWDropTrigger),
   .intac2BWDropTrigger              (intac2BWDropTrigger),
   .intac1BWDropTrigger              (intac1BWDropTrigger),
   .intac0BWDropTrigger              (intac0BWDropTrigger)
);

endmodule
                 
