//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : Top level of macCSReg module
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module macCSReg( 

    ////////////////////////////////////////////
    //$port_g Clocks and Reset
    ////////////////////////////////////////////
    input  wire          macPIClk,              // Platform clock
    input  wire          macPIClkHardRst_n,     // Platfrom Reset
    input  wire          macPIClkSoftRst_n,     // Platfrom Reset
    input  wire          macCoreClk,            // Core clock
    input  wire          macCoreClkHardRst_n,   // Core Reset
    input  wire          macCoreClkSoftRst_n,   // Core Reset

    ////////////////////////////////////////////
    //$port_g Registers
    ////////////////////////////////////////////
    //$port_g nextTBTTReg register.
    input wire [15 : 0] nextTBTT                       , // Next TBTT
    //$port_g genIntEventSetReg register.
    input wire          statussettbTxDMADead           , // TB Transmit DMA Dead
    input wire          statussetrxPayloadDMADead      , // Receive Payload DMA Dead
    input wire          statussetrxHeaderDMADead       , // Receive Payload DMA Dead
    input wire          statussetphyRxStart            , // PHY Receive Start indication
    input wire          statussetphyErr                , // PHY Error
    input wire          statussetmacPHYIFUnderRun      , // MAC PHY InterFace Under Run
    input wire          statussethwErr                 , // Hardware Error
    input wire          statussetimpSecDTIM            , // Impending Secondary DTIM
    input wire          statussetimpPriDTIM            , // Impending Primary DTIM
    input wire          statussetbcnTxDMADead          , // Beacon Transmit DMA Dead
    input wire          statussetac3TxDMADead          , // AC3 Transmit DMA Dead
    input wire          statussetac2TxDMADead          , // AC2 Transmit DMA Dead
    input wire          statussetac1TxDMADead          , // AC1 Transmit DMA Dead
    input wire          statussetac0TxDMADead          , // AC0 Transmit DMA Dead
    input wire          statussetptError               , // Policy Table Error
    input wire          statussettimSet                , // TIM Set
    input wire          statussetolbcDSSS              , // DSSS OLBC
    input wire          statussetolbcOFDM              , // OFDM OLBC
    input wire          statussetrxFIFOOverFlow        , // Receive FIFO Over Flow
    input wire          statussetmacPHYIFOverflow      , // MAC PHY InterFace Over Flow
    input wire          statussetcoexEvent             , // Coex Interface Event
    input wire          statusabsGenTimers             , // Absolute General Timer Interrupt
    input wire          statussetidleInterrupt         , // Idle Interrupt
    input wire          statussetimpSecTBTT            , // Impending Secondary Target Beacon Transmission Time
    input wire          statussetimpPriTBTT            , // Impending Primary Target Beacon Transmission Time
    //$port_g txRxIntEventSetReg register.
    input wire          statussettbTxBufTrigger        , // TB Transmission Buffer Trigger
    input wire          statussetbcnTxBufTrigger       , // Beacon Transmission Buffer Trigger
    input wire          statussetac3TxBufTrigger       , // AC3 Transmission Buffer Trigger
    input wire          statussetac2TxBufTrigger       , // AC2 Transmission Buffer Trigger
    input wire          statussetac1TxBufTrigger       , // AC1 Transmission Buffer Trigger
    input wire          statussetac0TxBufTrigger       , // AC0 Transmission Buffer Trigger
    input wire          statussetac3BWDropTrigger      , // AC3 Bandwith Drop Trigger
    input wire          statussetac2BWDropTrigger      , // AC2 Bandwith Drop Trigger
    input wire          statussetac1BWDropTrigger      , // AC1 Bandwith Drop Trigger
    input wire          statussetac0BWDropTrigger      , // AC0 Bandwith Drop Trigger
    input wire          statussetrxBuffer2Trigger      , // Receive Buffer 2 Trigger
    input wire          statussettimerRxTrigger        , // Timer Receive Trigger
    input wire          statussetrxBuffer1Trigger      , // Receive Buffer 1 Trigger
    input wire          statussetsecUserTxTrigger      , // Secondary User Transmission Trigger
    input wire          statussettimerTxTrigger        , // Timer Transmission Trigger
    input wire          statussettxopComplete          , // TXOP Complete
    input wire          statussettbTxCancelled         , // TB Transmission Cancelled
    input wire          statussettbTxTrigger           , // TB Transmission Trigger
    input wire          statussetbcnTxTrigger          , // Beacon Transmission Trigger
    input wire          statussetac3TxTrigger          , // AC3 Transmission Trigger
    input wire          statussetac2TxTrigger          , // AC2 Transmission Trigger
    input wire          statussetac1TxTrigger          , // AC1 Transmission Trigger
    input wire          statussetac0TxTrigger          , // AC0 Transmission Trigger
    input wire          statussettbProtTrigger         , // TB Protocol Trigger
    input wire          statussetac3ProtTrigger        , // AC3 Protocol Trigger
    input wire          statussetac2ProtTrigger        , // AC2 Protocol Trigger
    input wire          statussetac1ProtTrigger        , // AC1 Protocol Trigger
    input wire          statussetac0ProtTrigger        , // AC0 Protocol Trigger
    //$port_g timersIntEventSetReg register.
    input wire          statussetabsTimers9            , // Absolute Timers 9
    input wire          statussetabsTimers8            , // Absolute Timers 8
    input wire          statussetabsTimers7            , // Absolute Timers 7
    input wire          statussetabsTimers6            , // Absolute Timers 6
    input wire          statussetabsTimers5            , // Absolute Timers 5
    input wire          statussetabsTimers4            , // Absolute Timers 4
    input wire          statussetabsTimers3            , // Absolute Timers 3
    input wire          statussetabsTimers2            , // Absolute Timers 2
    input wire          statussetabsTimers1            , // Absolute Timers 1
    input wire          statussetabsTimers0            , // Absolute Timers 0
    input wire [31 : 0] tsfTimerLowIn                  , // TSF Timer In
    input wire          tsfTimerLowInValid             , // TSF Timer In Valid
    input wire [31 : 0] tsfTimerHighIn                 , // TSF Timer In
    input wire          tsfTimerHighInValid            , // TSF Timer In Valid
    input wire          computeDurationIn              , // Compute Duration In
    input wire          computeDurationInValid         , // Compute Duration In Valid
    //$port_g timeOnAirValueReg register.
    input wire          timeOnAirValid                 , // Time On Air Valid
    input wire [15 : 0] timeOnAir                      , // Time On Air
    //$port_g dmaCntrlSetReg register.
    input wire          statussethaltTBAfterTXOP       , // Halt TB After TXOP
    input wire          statussethaltAC3AfterTXOP      , // Halt AC3 After TXOP
    input wire          statussethaltAC2AfterTXOP      , // Halt AC2 After TXOP
    input wire          statussethaltAC1AfterTXOP      , // Halt AC1 After TXOP
    input wire          statussethaltAC0AfterTXOP      , // Halt AC0 After TXOP
    input wire          statussethaltBcnAfterTXOP      , // Halt BCN queue
    input wire          statussettxTBNewHead           , // Transmit TB DMA New Head
    input wire          statussettxAC3NewHead          , // Transmit AC 3 DMA New Head
    input wire          statussettxAC2NewHead          , // Transmit AC 2 DMA New Head
    input wire          statussettxAC1NewHead          , // Transmit AC 1 DMA New Head
    input wire          statussettxAC0NewHead          , // Transmit AC 0 DMA New Head
    input wire          statussettxBcnNewHead          , // Transmit Beacon DMA New Head
    input wire          statussettxAC3NewTail          , // Transmit AC 3 DMA New Tail
    input wire          statussettxAC2NewTail          , // Transmit AC 2 DMA New Tail
    input wire          statussettxAC1NewTail          , // Transmit AC 1 DMA New Tail
    input wire          statussettxAC0NewTail          , // Transmit AC 0 DMA New Tail
    input wire          statussettxBcnNewTail          , // Transmit Beacon DMA New Tail
    //$port_g dmaStatus1Reg register.
    input wire [ 1 : 0] txTBState                      , // Transmit TB State
    input wire [ 1 : 0] txAC3State                     , // Transmit AC3 State
    input wire [ 1 : 0] txAC2State                     , // Transmit AC2 State
    input wire [ 1 : 0] txAC1State                     , // Transmit AC1 State
    input wire [ 1 : 0] txAC0State                     , // Transmit AC0 State
    input wire [ 1 : 0] txBcnState                     , // Transmit Beacon State
    //$port_g dmaStatus2Reg register.
    input wire          txNewHeadErr                   , // Transmit New Head Error
    input wire          txBusErr                       , // Transmit Bus Error
    input wire          txPTAddressErr                 , // Transmit Policy Table Address Error
    input wire          txNextPointerErr               , // Transmit Next Pointer Error
    input wire          txUPatternErr                  , // Transmit Unique Pattern Error
    input wire          txLenMismatch                  , // Transmit Length Mismatch
    //$port_g dmaStatus3Reg register.
    input wire          rxPayBusErr                    , // Receive Payload Bus Error
    input wire          rxHdrBusErr                    , // Receive Header Bus Error
    //$port_g dmaStatus4Reg register.
    input wire          txTBHaltAfterTXOP              , // Transmit TB Halt After TXOP
    input wire          txAC3HaltAfterTXOP             , // Transmit AC3 Halt After TXOP
    input wire          txAC2HaltAfterTXOP             , // Transmit AC2 Halt After TXOP
    input wire          txAC1HaltAfterTXOP             , // Transmit AC1 Halt After TXOP
    input wire          txAC0HaltAfterTXOP             , // Transmit AC0 Halt After TXOP
    input wire          txBcnHaltAfterTXOP             , // Transmit BCN Halt After TXOP
    input wire          txAC3EndQ                      , // Transmit AC3 End of Queue
    input wire          txAC2EndQ                      , // Transmit AC2 End of Queue
    input wire          txAC1EndQ                      , // Transmit AC1 End of Queue
    input wire          txAC0EndQ                      , // Transmit AC0 End of Queue
    input wire          txBcnEndQ                      , // Transmit Beacon End of Queue
    input wire          txAC3Startup                   , // Transmit AC3 Startup
    input wire          txAC2Startup                   , // Transmit AC2 Startup
    input wire          txAC1Startup                   , // Transmit AC1 Startup
    input wire          txAC0Startup                   , // Transmit AC0 Startup
    input wire          txBcnStartup                   , // Transmit Beacon Startup
    //$port_g rxHeaderTFPtrReg register.
    input wire [29 : 0] rxHeaderTFPtr                  , // Receive Header Trigger Frame Pointer
    input wire [31 : 0] rxBuf1WrPtrIn                  , // DMA Receive buffer 1 write Pointer In
    input wire          rxBuf1WrPtrInValid             , // DMA Receive buffer 1 write Pointer In Valid
    input wire [31 : 0] rxBuf2WrPtrIn                  , // DMA Receive buffer 2 write Pointer In
    input wire          rxBuf2WrPtrInValid             , // DMA Receive buffer 2 write Pointer In Valid
    //$port_g mot1Reg register.
    input wire [15 : 0] ac1MOT                         , // AC1 Medium Occupancy Timer
    input wire [15 : 0] ac0MOT                         , // AC0 Medium Occupancy Timer
    //$port_g mot2Reg register.
    input wire [15 : 0] ac3MOT                         , // AC3 Medium Occupancy Timer
    input wire [15 : 0] ac2MOT                         , // AC2 Medium Occupancy Timer
    //$port_g txBWDropInfoReg register.
    input wire [ 1 : 0] txBWAfterDrop                  , // Transmit Bandwidth After Drop
    input wire [ 2 : 0] eOCWIn                         , // Exposent of OFDMA Contention Window In
    input wire          eOCWInValid                    , // Exposent of OFDMA Contention Window In Valid
    //$port_g txHETBInfoReg register.
    input wire [ 5 : 0] txHETBRemDur                   , // HE TB Preparation Remaining Duration
    //$port_g rxHETrigCommonInfoReg register.
    input wire          ulDoppler                      , // UpLink Doppler
    input wire          ulPEDisambiguity               , // UpLink PE Disambiguity
    input wire [ 1 : 0] ulPreFecPadding                , // UpLink Pre-FEC Padding Factor
    input wire          ulLDPCExtrSymb                 , // UpLink LDPC Extra Symbol Segment
    input wire          ulSTBC                         , // UpLink STBC
    input wire [ 2 : 0] ulNLTFAndMidamble              , // UpLink Number Of HE-LTF Symbols And Midamble Periodicity
    input wire          ulMULTFMode                    , // UpLink MU-MIMO LTF Mode
    input wire [ 1 : 0] ulGILTFType                    , // UpLink GI And LTF Type
    input wire [ 1 : 0] ulBW                           , // UpLink Bandwidth
    input wire [11 : 0] ulLength                       , // UpLink Length
    input wire [ 3 : 0] ulTriggerType                  , // UpLink Trigger Type
    //$port_g rxHETrigUserInfoReg register.
    input wire [ 7 : 0] tdUserInfoSubfield             , // Trigger Dependent User Info subfield
    input wire          ulRUType                       , // UpLink RU Type
    input wire [ 2 : 0] ulNSS                          , // UpLink NSS
    input wire          ulDCM                          , // UpLink DCM
    input wire [ 3 : 0] ulMCS                          , // UpLink MCS
    input wire          ulFECCoding                    , // UpLink Fec Coding
    input wire [ 2 : 0] ulRUSize                       , // UpLink RU Size
    //$port_g rxHETrigPSDULenReg register.
    input wire          ulPSDULenValid                 , // UpLink PSDU Length Valid
    input wire [19 : 0] ulPSDULen                      , // UpLink PSDU Length
    //$port_g rxHETrigPwrInfoReg register.
    input wire [ 7 : 0] heTBUPHControl                 , // HE-TB Uplink power headroom
    input wire [ 6 : 0] ulTargetRSSI                   , // Uplink Target RSSI 
    input wire [ 5 : 0] apTXPower                      , // AP TX power
`ifdef RW_MUMIMO_TX_EN                      
    //$port_g secUsersTxIntEventSetReg register.
    input wire          statussetsecU3ac3TxBufTrigger  , // Secondary User 3 AC3 Transmission Buffer Trigger
    input wire          statussetsecU3ac2TxBufTrigger  , // Secondary User 3 AC2 Transmission Buffer Trigger
    input wire          statussetsecU3ac1TxBufTrigger  , // Secondary User 3 AC1 Transmission Buffer Trigger
    input wire          statussetsecU3ac0TxBufTrigger  , // Secondary User 3 AC0 Transmission Buffer Trigger
    input wire          statussetsecU3ac3TxTrigger     , // Secondary User 3 AC3 Transmission Trigger
    input wire          statussetsecU3ac2TxTrigger     , // Secondary User 3 AC2 Transmission Trigger
    input wire          statussetsecU3ac1TxTrigger     , // Secondary User 3 AC1 Transmission Trigger
    input wire          statussetsecU3ac0TxTrigger     , // Secondary User 3 AC0 Transmission Trigger
    input wire          statussetsecU2ac3TxBufTrigger  , // Secondary User 2 AC3 Transmission Buffer Trigger
    input wire          statussetsecU2ac2TxBufTrigger  , // Secondary User 2 AC2 Transmission Buffer Trigger
    input wire          statussetsecU2ac1TxBufTrigger  , // Secondary User 2 AC1 Transmission Buffer Trigger
    input wire          statussetsecU2ac0TxBufTrigger  , // Secondary User 2 AC0 Transmission Buffer Trigger
    input wire          statussetsecU2ac3TxTrigger     , // Secondary User 2 AC3 Transmission Trigger
    input wire          statussetsecU2ac2TxTrigger     , // Secondary User 2 AC2 Transmission Trigger
    input wire          statussetsecU2ac1TxTrigger     , // Secondary User 2 AC1 Transmission Trigger
    input wire          statussetsecU2ac0TxTrigger     , // Secondary User 2 AC0 Transmission Trigger
    input wire          statussetsecU1ac3TxBufTrigger  , // Secondary User 1 AC3 Transmission Buffer Trigger
    input wire          statussetsecU1ac2TxBufTrigger  , // Secondary User 1 AC2 Transmission Buffer Trigger
    input wire          statussetsecU1ac1TxBufTrigger  , // Secondary User 1 AC1 Transmission Buffer Trigger
    input wire          statussetsecU1ac0TxBufTrigger  , // Secondary User 1 AC0 Transmission Buffer Trigger
    input wire          statussetsecU1ac3TxTrigger     , // Secondary User 1 AC3 Transmission Trigger
    input wire          statussetsecU1ac2TxTrigger     , // Secondary User 1 AC2 Transmission Trigger
    input wire          statussetsecU1ac1TxTrigger     , // Secondary User 1 AC1 Transmission Trigger
    input wire          statussetsecU1ac0TxTrigger     , // Secondary User 1 AC0 Transmission Trigger
`endif // RW_MUMIMO_TX_EN                      
    //$port_g debugBcnSPtrReg register.
    input wire [31 : 0] bcnStatusPointer               , // Beacon Status Pointer
    //$port_g debugAC0SPtrReg register.
    input wire [31 : 0] ac0StatusPointer               , // AC0 Status Pointer
    //$port_g debugAC1SPtrReg register.
    input wire [31 : 0] ac1StatusPointer               , // AC1 Status Pointer
    //$port_g debugAC2SPtrReg register.
    input wire [31 : 0] ac2StatusPointer               , // AC2 Status Pointer
    //$port_g debugAC3SPtrReg register.
    input wire [31 : 0] ac3StatusPointer               , // AC3 Status Pointer
    //$port_g debugTBSPtrReg register.
    input wire [31 : 0] tbStatusPointer                , // TB Status Pointer
    //$port_g debugTxCPtrReg register.
    input wire [31 : 0] txCurrentPointer               , // Transmit Current Pointer
    input wire          swProf31In                     , // Software Profiling value In
    input wire          swProf31InValid                , // Software Profiling value In Valid
    input wire          swProf30In                     , // Software Profiling value In
    input wire          swProf30InValid                , // Software Profiling value In Valid
    input wire          swProf29In                     , // Software Profiling value In
    input wire          swProf29InValid                , // Software Profiling value In Valid
    input wire          swProf28In                     , // Software Profiling value In
    input wire          swProf28InValid                , // Software Profiling value In Valid
    input wire          swProf27In                     , // Software Profiling value In
    input wire          swProf27InValid                , // Software Profiling value In Valid
    input wire          swProf26In                     , // Software Profiling value In
    input wire          swProf26InValid                , // Software Profiling value In Valid
    input wire          swProf25In                     , // Software Profiling value In
    input wire          swProf25InValid                , // Software Profiling value In Valid
    input wire          swProf24In                     , // Software Profiling value In
    input wire          swProf24InValid                , // Software Profiling value In Valid
    input wire          swProf23In                     , // Software Profiling value In
    input wire          swProf23InValid                , // Software Profiling value In Valid
    input wire          swProf22In                     , // Software Profiling value In
    input wire          swProf22InValid                , // Software Profiling value In Valid
    input wire          swProf21In                     , // Software Profiling value In
    input wire          swProf21InValid                , // Software Profiling value In Valid
    input wire          swProf20In                     , // Software Profiling value In
    input wire          swProf20InValid                , // Software Profiling value In Valid
    input wire          swProf19In                     , // Software Profiling value In
    input wire          swProf19InValid                , // Software Profiling value In Valid
    input wire          swProf18In                     , // Software Profiling value In
    input wire          swProf18InValid                , // Software Profiling value In Valid
    input wire          swProf17In                     , // Software Profiling value In
    input wire          swProf17InValid                , // Software Profiling value In Valid
    input wire          swProf16In                     , // Software Profiling value In
    input wire          swProf16InValid                , // Software Profiling value In Valid
    input wire          swProf15In                     , // Software Profiling value In
    input wire          swProf15InValid                , // Software Profiling value In Valid
    input wire          swProf14In                     , // Software Profiling value In
    input wire          swProf14InValid                , // Software Profiling value In Valid
    input wire          swProf13In                     , // Software Profiling value In
    input wire          swProf13InValid                , // Software Profiling value In Valid
    input wire          swProf12In                     , // Software Profiling value In
    input wire          swProf12InValid                , // Software Profiling value In Valid
    input wire          swProf11In                     , // Software Profiling value In
    input wire          swProf11InValid                , // Software Profiling value In Valid
    input wire          swProf10In                     , // Software Profiling value In
    input wire          swProf10InValid                , // Software Profiling value In Valid
    input wire          swProf9In                      , // Software Profiling value In
    input wire          swProf9InValid                 , // Software Profiling value In Valid
    input wire          swProf8In                      , // Software Profiling value In
    input wire          swProf8InValid                 , // Software Profiling value In Valid
    input wire          swProf7In                      , // Software Profiling value In
    input wire          swProf7InValid                 , // Software Profiling value In Valid
    input wire          swProf6In                      , // Software Profiling value In
    input wire          swProf6InValid                 , // Software Profiling value In Valid
    input wire          swProf5In                      , // Software Profiling value In
    input wire          swProf5InValid                 , // Software Profiling value In Valid
    input wire          swProf4In                      , // Software Profiling value In
    input wire          swProf4InValid                 , // Software Profiling value In Valid
    input wire          swProf3In                      , // Software Profiling value In
    input wire          swProf3InValid                 , // Software Profiling value In Valid
    input wire          swProf2In                      , // Software Profiling value In
    input wire          swProf2InValid                 , // Software Profiling value In Valid
    input wire          swProf1In                      , // Software Profiling value In
    input wire          swProf1InValid                 , // Software Profiling value In Valid
    input wire          swProf0In                      , // Software Profiling value In
    input wire          swProf0InValid                 , // Software Profiling value In Valid
    //$port_g swSetProfilingReg register.
    input wire          statusswSetProf31              , // Software Profiling Set Bit
    input wire          statusswSetProf30              , // Software Profiling Set Bit
    input wire          statusswSetProf29              , // Software Profiling Set Bit
    input wire          statusswSetProf28              , // Software Profiling Set Bit
    input wire          statusswSetProf27              , // Software Profiling Set Bit
    input wire          statusswSetProf26              , // Software Profiling Set Bit
    input wire          statusswSetProf25              , // Software Profiling Set Bit
    input wire          statusswSetProf24              , // Software Profiling Set Bit
    input wire          statusswSetProf23              , // Software Profiling Set Bit
    input wire          statusswSetProf22              , // Software Profiling Set Bit
    input wire          statusswSetProf21              , // Software Profiling Set Bit
    input wire          statusswSetProf20              , // Software Profiling Set Bit
    input wire          statusswSetProf19              , // Software Profiling Set Bit
    input wire          statusswSetProf18              , // Software Profiling Set Bit
    input wire          statusswSetProf17              , // Software Profiling Set Bit
    input wire          statusswSetProf16              , // Software Profiling Set Bit
    input wire          statusswSetProf15              , // Software Profiling Set Bit
    input wire          statusswSetProf14              , // Software Profiling Set Bit
    input wire          statusswSetProf13              , // Software Profiling Set Bit
    input wire          statusswSetProf12              , // Software Profiling Set Bit
    input wire          statusswSetProf11              , // Software Profiling Set Bit
    input wire          statusswSetProf10              , // Software Profiling Set Bit
    input wire          statusswSetProf9               , // Software Profiling Set Bit
    input wire          statusswSetProf8               , // Software Profiling Set Bit
    input wire          statusswSetProf7               , // Software Profiling Set Bit
    input wire          statusswSetProf6               , // Software Profiling Set Bit
    input wire          statusswSetProf5               , // Software Profiling Set Bit
    input wire          statusswSetProf4               , // Software Profiling Set Bit
    input wire          statusswSetProf3               , // Software Profiling Set Bit
    input wire          statusswSetProf2               , // Software Profiling Set Bit
    input wire          statusswSetProf1               , // Software Profiling Set Bit
    input wire          statusswSetProf0               , // Software Profiling Set Bit
    input wire          swProf63In                     , // Software Profiling value In
    input wire          swProf63InValid                , // Software Profiling value In Valid
    input wire          swProf62In                     , // Software Profiling value In
    input wire          swProf62InValid                , // Software Profiling value In Valid
    input wire          swProf61In                     , // Software Profiling value In
    input wire          swProf61InValid                , // Software Profiling value In Valid
    input wire          swProf60In                     , // Software Profiling value In
    input wire          swProf60InValid                , // Software Profiling value In Valid
    input wire          swProf59In                     , // Software Profiling value In
    input wire          swProf59InValid                , // Software Profiling value In Valid
    input wire          swProf58In                     , // Software Profiling value In
    input wire          swProf58InValid                , // Software Profiling value In Valid
    input wire          swProf57In                     , // Software Profiling value In
    input wire          swProf57InValid                , // Software Profiling value In Valid
    input wire          swProf56In                     , // Software Profiling value In
    input wire          swProf56InValid                , // Software Profiling value In Valid
    input wire          swProf55In                     , // Software Profiling value In
    input wire          swProf55InValid                , // Software Profiling value In Valid
    input wire          swProf54In                     , // Software Profiling value In
    input wire          swProf54InValid                , // Software Profiling value In Valid
    input wire          swProf53In                     , // Software Profiling value In
    input wire          swProf53InValid                , // Software Profiling value In Valid
    input wire          swProf52In                     , // Software Profiling value In
    input wire          swProf52InValid                , // Software Profiling value In Valid
    input wire          swProf51In                     , // Software Profiling value In
    input wire          swProf51InValid                , // Software Profiling value In Valid
    input wire          swProf50In                     , // Software Profiling value In
    input wire          swProf50InValid                , // Software Profiling value In Valid
    input wire          swProf49In                     , // Software Profiling value In
    input wire          swProf49InValid                , // Software Profiling value In Valid
    input wire          swProf48In                     , // Software Profiling value In
    input wire          swProf48InValid                , // Software Profiling value In Valid
    input wire          swProf47In                     , // Software Profiling value In
    input wire          swProf47InValid                , // Software Profiling value In Valid
    input wire          swProf46In                     , // Software Profiling value In
    input wire          swProf46InValid                , // Software Profiling value In Valid
    input wire          swProf45In                     , // Software Profiling value In
    input wire          swProf45InValid                , // Software Profiling value In Valid
    input wire          swProf44In                     , // Software Profiling value In
    input wire          swProf44InValid                , // Software Profiling value In Valid
    input wire          swProf43In                     , // Software Profiling value In
    input wire          swProf43InValid                , // Software Profiling value In Valid
    input wire          swProf42In                     , // Software Profiling value In
    input wire          swProf42InValid                , // Software Profiling value In Valid
    input wire          swProf41In                     , // Software Profiling value In
    input wire          swProf41InValid                , // Software Profiling value In Valid
    input wire          swProf40In                     , // Software Profiling value In
    input wire          swProf40InValid                , // Software Profiling value In Valid
    input wire          swProf39In                     , // Software Profiling value In
    input wire          swProf39InValid                , // Software Profiling value In Valid
    input wire          swProf38In                     , // Software Profiling value In
    input wire          swProf38InValid                , // Software Profiling value In Valid
    input wire          swProf37In                     , // Software Profiling value In
    input wire          swProf37InValid                , // Software Profiling value In Valid
    input wire          swProf36In                     , // Software Profiling value In
    input wire          swProf36InValid                , // Software Profiling value In Valid
    input wire          swProf35In                     , // Software Profiling value In
    input wire          swProf35InValid                , // Software Profiling value In Valid
    input wire          swProf34In                     , // Software Profiling value In
    input wire          swProf34InValid                , // Software Profiling value In Valid
    input wire          swProf33In                     , // Software Profiling value In
    input wire          swProf33InValid                , // Software Profiling value In Valid
    input wire          swProf32In                     , // Software Profiling value In
    input wire          swProf32InValid                , // Software Profiling value In Valid
    //$port_g swSetProfilingReg2 register.
    input wire          statusswSetProf63              , // Software Profiling Set Bit
    input wire          statusswSetProf62              , // Software Profiling Set Bit
    input wire          statusswSetProf61              , // Software Profiling Set Bit
    input wire          statusswSetProf60              , // Software Profiling Set Bit
    input wire          statusswSetProf59              , // Software Profiling Set Bit
    input wire          statusswSetProf58              , // Software Profiling Set Bit
    input wire          statusswSetProf57              , // Software Profiling Set Bit
    input wire          statusswSetProf56              , // Software Profiling Set Bit
    input wire          statusswSetProf55              , // Software Profiling Set Bit
    input wire          statusswSetProf54              , // Software Profiling Set Bit
    input wire          statusswSetProf53              , // Software Profiling Set Bit
    input wire          statusswSetProf52              , // Software Profiling Set Bit
    input wire          statusswSetProf51              , // Software Profiling Set Bit
    input wire          statusswSetProf50              , // Software Profiling Set Bit
    input wire          statusswSetProf49              , // Software Profiling Set Bit
    input wire          statusswSetProf48              , // Software Profiling Set Bit
    input wire          statusswSetProf47              , // Software Profiling Set Bit
    input wire          statusswSetProf46              , // Software Profiling Set Bit
    input wire          statusswSetProf45              , // Software Profiling Set Bit
    input wire          statusswSetProf44              , // Software Profiling Set Bit
    input wire          statusswSetProf43              , // Software Profiling Set Bit
    input wire          statusswSetProf42              , // Software Profiling Set Bit
    input wire          statusswSetProf41              , // Software Profiling Set Bit
    input wire          statusswSetProf40              , // Software Profiling Set Bit
    input wire          statusswSetProf39              , // Software Profiling Set Bit
    input wire          statusswSetProf38              , // Software Profiling Set Bit
    input wire          statusswSetProf37              , // Software Profiling Set Bit
    input wire          statusswSetProf36              , // Software Profiling Set Bit
    input wire          statusswSetProf35              , // Software Profiling Set Bit
    input wire          statusswSetProf34              , // Software Profiling Set Bit
    input wire          statusswSetProf33              , // Software Profiling Set Bit
    input wire          statusswSetProf32              , // Software Profiling Set Bit
`ifdef RW_MUMIMO_SEC_USER1_EN               
    //$port_g debugSecU1TxCPtrReg register.
    input wire [31 : 0] secU1TxCurrentPointer          , // Secondary User1 Transmit Current Pointer
`endif // RW_MUMIMO_SEC_USER1_EN               
`ifdef RW_MUMIMO_SEC_USER2_EN               
    //$port_g debugSecU2TxCPtrReg register.
    input wire [31 : 0] secU2TxCurrentPointer          , // Secondary User2 Transmit Current Pointer
`endif // RW_MUMIMO_SEC_USER2_EN               
`ifdef RW_MUMIMO_SEC_USER3_EN               
    //$port_g debugSecU3TxCPtrReg register.
    input wire [31 : 0] secU3TxCurrentPointer          , // Secondary User3 Transmit Current Pointer
`endif // RW_MUMIMO_SEC_USER3_EN               
    //$port_g signatureReg register.
    input wire [31 : 0] signature                      , // The SIGNATURE register is a read only register containing a specific ID. 
    //$port_g version1Reg register.
    input wire          muMIMOTx                       , // This bit indicates if the core supports the MU-MIMO transmission as an AP
    input wire          bfmer                          , // This bit indicates if the core supports the beamforming as a beamformer
    input wire          bfmee                          , // This bit indicates if the core supports the beamforming as a beamformee
    input wire          he                             , // High Efficiency
    input wire          coex                           , // Coexistence
    input wire          wapi                           , // WAPI
    input wire          tpc                            , // Transmit Power Control
    input wire          vht                            , // Very High Throughput
    input wire          ht                             , // High Throughput
    input wire          gcmp                           , // GCMP
    input wire          rce                            , // Regulatory Classes Extensions
    input wire          ccmp                           , // CCMP
    input wire          tkip                           , // TKIP
    input wire          wep                            , // WEP
    input wire          security                       , // Security
    input wire          sme                            , // Spectrum Management Extension
    input wire          edca                           , // Enhanced Distributed Channel Access
    input wire          qos                            , // Quality of Service
    //$port_g version2Reg register.
    input wire [ 2 : 0] phaseNumber                    , // These bits are used to define the phase number of the release (same as the minor version field of the tag in SVN).
    input wire [ 5 : 0] releaseNumber                  , // These bits are used to define the release number under this phase (same as the intermediate release field of the tag in SVN).
    input wire          ieRelease                      , // This bit is set if it is an external (client) release, and is reset if it is an internal (test team) release
    input wire [ 6 : 0] umVersion                      , // These bits are used to define the FS compliancy of the current hardware as xx.yyyyy.
    //$port_g bitmapCntReg register.
    input wire [15 : 0] bitmapCnt                      , // Bitmap Count
    input wire [ 3 : 0] nextStateIn                    , // Next State In
    input wire          nextStateInValid               , // Next State In Valid
    //$port_g stateCntrlReg register.
    input wire [ 3 : 0] currentState                   , // Current State
    input wire          tsfUpdatedBySWIn               , // TSF Updated By SW In
    input wire          tsfUpdatedBySWInValid          , // TSF Updated By SW In Valid
    input wire          keyStoRAMResetIn               , // Key Storage RAM Reset In
    input wire          keyStoRAMResetInValid          , // Key Storage RAM Reset In Valid
    input wire          mibTableResetIn                , // MIB Table reset In
    input wire          mibTableResetInValid           , // MIB Table reset In Valid
    input wire          baPSBitmapResetIn              , // Block ACK Partial Bitmap Reset In
    input wire          baPSBitmapResetInValid         , // Block ACK Partial Bitmap Reset In Valid
    input wire          macPHYIFFIFOResetIn            , // MAC-PHY InterFace FIFO Reset In
    input wire          macPHYIFFIFOResetInValid       , // MAC-PHY InterFace FIFO Reset In Valid
    input wire          txFIFOResetIn                  , // Transmit FIFO Reset In
    input wire          txFIFOResetInValid             , // Transmit FIFO Reset In Valid
    input wire          rxFIFOResetIn                  , // Receive FIFO Reset In
    input wire          rxFIFOResetInValid             , // Receive FIFO Reset In Valid
    input wire          hwFSMResetIn                   , // Hardware Finite State Machine Reset In
    input wire          hwFSMResetInValid              , // Hardware Finite State Machine Reset In Valid
    //$port_g macErrRecCntrlReg register.
    input wire          useErrRec                      , // Use Error Recovery
    //$port_g macErrSetStatusReg register.
    input wire          statuserrInHWLevel3            , // Error in HW - Level 3
    input wire          statuserrInTxRxLevel2          , // Error in Transmit/Receive - Level 2
    input wire          statuserrInRxLevel1            , // Error In Receive - Level 1
    input wire          statuserrInTxLevel1            , // Error In Transmit - Level 1
    //$port_g rxCntrlReg register.
    input wire          enDuplicateDetection           , // Enable Duplicate Detection
    input wire          dtimUpdatedBySWIn              , // DTIM Updated by SW In
    input wire          dtimUpdatedBySWInValid         , // DTIM Updated by SW In Valid
    input wire [ 7 : 0] dtimPeriodIn                   , // DTIM Period In
    input wire          dtimPeriodInValid              , // DTIM Period In Valid
    input wire [31 : 0] encrKeyRAMWord0In              , // Encryption Key for RAM In
    input wire          encrKeyRAMWord0InValid         , // Encryption Key for RAM In Valid
    input wire [31 : 0] encrKeyRAMWord1In              , // Encryption Key for RAM In
    input wire          encrKeyRAMWord1InValid         , // Encryption Key for RAM In Valid
    input wire [31 : 0] encrKeyRAMWord2In              , // It contains bits 95 to 64 of the 104-bit WEP key or the TKIP/CCMP/WAPI key to be programmed in the Key Storage RAM. In
    input wire          encrKeyRAMWord2InValid         , // It contains bits 95 to 64 of the 104-bit WEP key or the TKIP/CCMP/WAPI key to be programmed in the Key Storage RAM. In Valid
    input wire [31 : 0] encrKeyRAMWord3In              , // Encryption Key for RAM In
    input wire          encrKeyRAMWord3InValid         , // Encryption Key for RAM In Valid
    input wire [31 : 0] macAddrRAMLowIn                , // MAC Address for RAM In
    input wire          macAddrRAMLowInValid           , // MAC Address for RAM In Valid
    input wire [15 : 0] macAddrRAMHighIn               , // MAC Address for RAM In
    input wire          macAddrRAMHighInValid          , // MAC Address for RAM In Valid
    input wire          newReadIn                      , // New Read In
    input wire          newReadInValid                 , // New Read In Valid
    input wire          newWriteIn                     , // New Write In
    input wire          newWriteInValid                , // New Write In Valid
    input wire          newSearchIn                    , // New Search In
    input wire          newSearchInValid               , // New Search In Valid
    input wire          searchErrorIn                  , // Search Error In
    input wire          searchErrorInValid             , // Search Error In Valid
    input wire [ 9 : 0] keyIndexRAMIn                  , // Key Index RAM In
    input wire          keyIndexRAMInValid             , // Key Index RAM In Valid
    input wire [ 1 : 0] cLenRAMIn                      , // Cipher Length for RAM In
    input wire          cLenRAMInValid                 , // Cipher Length for RAM In Valid
    input wire [ 2 : 0] cTypeRAMIn                     , // Cipher Type for RAM In
    input wire          cTypeRAMInValid                , // Cipher Type for RAM In Valid
    input wire [ 3 : 0] vlanIDRAMIn                    , // Virtual LAN ID for RAM In
    input wire          vlanIDRAMInValid               , // Virtual LAN ID for RAM In Valid
    input wire [ 1 : 0] sppRAMIn                       , // SPP for RAM In
    input wire          sppRAMInValid                  , // SPP for RAM In Valid
    input wire          useDefKeyRAMIn                 , // Use Default Key for RAM In
    input wire          useDefKeyRAMInValid            , // Use Default Key for RAM In Valid
`ifdef RW_KEY_EXTENDED                      
    input wire [31 : 0] encrIntKeyRAMWord0In           , // Encryption WPI integrity Key for RAM In
    input wire          encrIntKeyRAMWord0InValid      , // Encryption WPI integrity Key for RAM In Valid
    input wire [31 : 0] encrIntKeyRAMWord1In           , // Encryption WPI integrity Key for RAM In
    input wire          encrIntKeyRAMWord1InValid      , // Encryption WPI integrity Key for RAM In Valid
    input wire [31 : 0] encrIntKeyRAMWord2In           , // Encryption WPI integrity Key for RAM In
    input wire          encrIntKeyRAMWord2InValid      , // Encryption WPI integrity Key for RAM In Valid
    input wire [31 : 0] encrIntKeyRAMWord3In           , // Encryption WPI integrity Key for RAM In
    input wire          encrIntKeyRAMWord3InValid      , // Encryption WPI integrity Key for RAM In Valid
`endif // RW_KEY_EXTENDED                      
    //$port_g encrRAMConfigReg register.
    input wire [ 7 : 0] staKeyMaxIndex                 , // STA Key Max Index
    input wire          mibWriteIn                     , // MIB Write In
    input wire          mibWriteInValid                , // MIB Write In Valid
    //$port_g monotonicCounter1Reg register.
    input wire [31 : 0] monotonicCounter1              , // Monotonic Counter 1
    input wire [31 : 0] monotonicCounterLow2In         , // Monotonic Counter 2 In
    input wire          monotonicCounterLow2InValid    , // Monotonic Counter 2 In Valid
    input wire [15 : 0] monotonicCounterHigh2In        , // Monotonic Counter 2 In
    input wire          monotonicCounterHigh2InValid   , // Monotonic Counter 2 In Valid
    input wire [31 : 0] ccaBusyDurIn                   , // CCA Busy Duration In
    input wire          ccaBusyDurInValid              , // CCA Busy Duration In Valid
    input wire          sendCFEndNowIn                 , // Send CF-End Now In
    input wire          sendCFEndNowInValid            , // Send CF-End Now In Valid
    input wire [15 : 0] quietDuration1In               , // Quiet Duration 1 In
    input wire          quietDuration1InValid          , // Quiet Duration 1 In Valid
    input wire [ 7 : 0] quietPeriod1In                 , // Quiet Period 1 In
    input wire          quietPeriod1InValid            , // Quiet Period 1 In Valid
    input wire [ 7 : 0] quietCount1In                  , // Quiet Count 1 In
    input wire          quietCount1InValid             , // Quiet Count 1 In Valid
    input wire [15 : 0] quietOffset1In                 , // Quiet Offset 1 In
    input wire          quietOffset1InValid            , // Quiet Offset 1 In Valid
    input wire [31 : 0] ccaBusyDurSec20In              , // CCA Busy Duration on secondary 20MHz In
    input wire          ccaBusyDurSec20InValid         , // CCA Busy Duration on secondary 20MHz In Valid
    input wire [31 : 0] ccaBusyDurSec40In              , // CCA Busy Duration on secondary 40MHz In
    input wire          ccaBusyDurSec40InValid         , // CCA Busy Duration on secondary 40MHz In Valid
    input wire [31 : 0] ccaBusyDurSec80In              , // CCA Busy Duration on secondary 80MHz In
    input wire          ccaBusyDurSec80InValid         , // CCA Busy Duration on secondary 80MHz In Valid
`ifdef RW_BFMEE_EN                          
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      
    //$port_g CoexStatReg register.
    input wire [ 3 : 0] coexWlanPTIState               , // Coex Wlan PTI State
    input wire          coexWlanPTIToggleState         , // Coex Wlan PTI Toggle State
    input wire          coexWlanChanBwState            , // Coex Wlan Channel Bandwidth State
    input wire          coexWlanRxState                , // Coex Wlan Rx State
    input wire          coexWlanTxState                , // Coex Wlan Tx State
    input wire          coexWlanRxAbortState           , // Coex Wlan Rx Abort State
    input wire          coexWlanTxAbortState           , // Coex Wlan Tx Abort State
`endif // RW_WLAN_COEX_EN                      
    //$port_g debugHWSM1Reg register.
    input wire [ 7 : 0] macControlLs                   , // MAC Controller Latched State
    input wire [ 8 : 0] txControlLs                    , // Transmit Controller Latched State
    input wire [ 5 : 0] rxControlLs                    , // Receive Controller Latched State 
    //$port_g debugHWSM2Reg register.
    input wire [ 7 : 0] macControlCs                   , // MAC Controller Current State
    input wire [ 8 : 0] txControlCs                    , // Transmit Controller Current State
    input wire [ 5 : 0] rxControlCs                    , // Receive Controller Current State 
    //$port_g debugPortValueReg register.
    input wire [31 : 0] debugPortRead                  , // This register reflects the value of the debugPort [31:0] signals, the 32 top level debug signals.
    input wire [25 : 0] basicNAVCounterIn              , // Basic Network Allocation Vector Counter. In
    input wire          basicNAVCounterInValid         , // Basic Network Allocation Vector Counter. In Valid
    //$port_g debugCWReg register.
    input wire [ 2 : 0] activeAC                       , // Current Access Category
    input wire [ 3 : 0] currentCW3                     , // Current Contention Window for AC3
    input wire [ 3 : 0] currentCW2                     , // Current Contention Window for AC2
    input wire [ 3 : 0] currentCW1                     , // Current Contention Window for AC1
    input wire [ 3 : 0] currentCW0                     , // Current Contention Window for AC0
    //$port_g debugQSRCReg register.
    input wire [ 7 : 0] ac3QSRC                        , // AC 3 QoS station Short Retry Count
    input wire [ 7 : 0] ac2QSRC                        , // AC 2 QoS station Short Retry Count
    input wire [ 7 : 0] ac1QSRC                        , // AC 1 QoS station Short Retry Count
    input wire [ 7 : 0] ac0QSRC                        , // AC 0 QoS station Short Retry Count
    //$port_g debugQLRCReg register.
    input wire [ 7 : 0] ac3QLRC                        , // AC 3 QoS station Long Retry Count
    input wire [ 7 : 0] ac2QLRC                        , // AC 2 QoS station Long Retry Count
    input wire [ 7 : 0] ac1QLRC                        , // AC 1 QoS station Long Retry Count
    input wire [ 7 : 0] ac0QLRC                        , // AC 0 QoS station Long Retry Count
    input wire [ 6 : 0] ocwLFSRIn                      , // OFDMA Contention Window LFSR In
    input wire          ocwLFSRInValid                 , // OFDMA Contention Window LFSR In Valid
    input wire [15 : 0] intraNAVCounterIn              , // Intra BSS Network Allocation Vector Counter. In
    input wire          intraNAVCounterInValid         , // Intra BSS Network Allocation Vector Counter. In Valid
    //
    //$port_g dozeCntrl2Reg register.
    output wire          wakeUpFromDoze                , // Wake Up from Doze.
    output wire          wakeUpSW                      , // Wake Up SW
    //$port_g macCntrl2Reg register.
    output wire          softReset                     , // Soft Reset
    //$port_g genIntEventSetReg register.
    output wire          settbTxDMADead                , // TB Transmit DMA Dead
    output wire          setrxPayloadDMADead           , // Receive Payload DMA Dead
    output wire          setrxHeaderDMADead            , // Receive Payload DMA Dead
    output wire          setphyRxStart                 , // PHY Receive Start indication
    output wire          setphyErr                     , // PHY Error
    output wire          setmacPHYIFUnderRun           , // MAC PHY InterFace Under Run
    output wire          sethwErr                      , // Hardware Error
    output wire          setimpSecDTIM                 , // Impending Secondary DTIM
    output wire          setimpPriDTIM                 , // Impending Primary DTIM
    output wire          setbcnTxDMADead               , // Beacon Transmit DMA Dead
    output wire          setac3TxDMADead               , // AC3 Transmit DMA Dead
    output wire          setac2TxDMADead               , // AC2 Transmit DMA Dead
    output wire          setac1TxDMADead               , // AC1 Transmit DMA Dead
    output wire          setac0TxDMADead               , // AC0 Transmit DMA Dead
    output wire          setptError                    , // Policy Table Error
    output wire          settimSet                     , // TIM Set
    output wire          setolbcDSSS                   , // DSSS OLBC
    output wire          setolbcOFDM                   , // OFDM OLBC
    output wire          setrxFIFOOverFlow             , // Receive FIFO Over Flow
    output wire          setmacPHYIFOverflow           , // MAC PHY InterFace Over Flow
    output wire          setcoexEvent                  , // Coex Interface Event
    output wire          absGenTimers                  , // Absolute General Timer Interrupt
    output wire          setidleInterrupt              , // Idle Interrupt
    output wire          setimpSecTBTT                 , // Impending Secondary Target Beacon Transmission Time
    output wire          setimpPriTBTT                 , // Impending Primary Target Beacon Transmission Time
    //$port_g genIntEventClearReg register.
    output wire          cleartbTxDMADead              , // TB Transmit DMA Dead
    output wire          clearrxPayloadDMADead         , // Receive Payload DMA Dead
    output wire          clearrxHeaderDMADead          , // Receive Payload DMA Dead
    output wire          clearphyRxStart               , // PHY Receive Start indication
    output wire          clearphyErr                   , // PHY Error
    output wire          clearmacPHYIFUnderRun         , // MAC PHY InterFace Under Run
    output wire          clearhwErr                    , // Hardware Error
    output wire          clearimpSecDTIM               , // Impending Secondary DTIM
    output wire          clearimpPriDTIM               , // Impending Primary DTIM
    output wire          clearbcnTxDMADead             , // Beacon Transmit DMA Dead
    output wire          clearac3TxDMADead             , // AC3 Transmit DMA Dead
    output wire          clearac2TxDMADead             , // AC2 Transmit DMA Dead
    output wire          clearac1TxDMADead             , // AC1 Transmit DMA Dead
    output wire          clearac0TxDMADead             , // AC0 Transmit DMA Dead
    output wire          clearptError                  , // Policy Table Error
    output wire          cleartimSet                   , // TIM Set
    output wire          clearolbcDSSS                 , // DSSS OLBC
    output wire          clearolbcOFDM                 , // OFDM OLBC
    output wire          clearrxFIFOOverFlow           , // Receive FIFO Over Flow
    output wire          clearmacPHYIFOverflow         , // MAC PHY InterFace Over Flow
    output wire          clearcoexEvent                , // Coex Interface Event
    output wire          clearidleInterrupt            , // Idle Interrupt
    output wire          clearimpSecTBTT               , // Impending Secondary Target Beacon Transmission Time
    output wire          clearimpPriTBTT               , // Impending Primary Target Beacon Transmission Time
    //$port_g genIntUnMaskReg register.
    output wire          masterGenIntEn                , // If set, external interrupts will be generated in accordance with the rest of the genIntUnMaskReg register bits.
    output wire          masktbTxDMADead               , // TB Transmit DMA Dead
    output wire          maskrxPayloadDMADead          , // Receive Payload DMA Dead
    output wire          maskrxHeaderDMADead           , // Receive Payload DMA Dead
    output wire          maskphyRxStart                , // PHY Receive Start indication
    output wire          maskphyErr                    , // PHY Error
    output wire          maskmacPHYIFUnderRun          , // MAC PHY InterFace Under Run
    output wire          maskhwErr                     , // Hardware Error
    output wire          maskimpSecDTIM                , // Impending Secondary DTIM
    output wire          maskimpPriDTIM                , // Impending Primary DTIM
    output wire          maskbcnTxDMADead              , // Beacon Transmit DMA Dead
    output wire          maskac3TxDMADead              , // AC3 Transmit DMA Dead
    output wire          maskac2TxDMADead              , // AC2 Transmit DMA Dead
    output wire          maskac1TxDMADead              , // AC1 Transmit DMA Dead
    output wire          maskac0TxDMADead              , // AC0 Transmit DMA Dead
    output wire          maskptError                   , // Policy Table Error
    output wire          masktimSet                    , // TIM Set
    output wire          maskolbcDSSS                  , // DSSS OLBC
    output wire          maskolbcOFDM                  , // OFDM OLBC
    output wire          maskrxFIFOOverFlow            , // Receive FIFO Over Flow
    output wire          maskmacPHYIFOverflow          , // MAC PHY InterFace Over Flow
    output wire          maskcoexEvent                 , // Coex Interface Event
    output wire          maskabsGenTimers              , // Absolute General Timer Interrupt
    output wire          maskidleInterrupt             , // Idle Interrupt
    output wire          maskimpSecTBTT                , // Impending Secondary Target Beacon Transmission Time
    output wire          maskimpPriTBTT                , // Impending Primary Target Beacon Transmission Time
    //$port_g txRxIntEventSetReg register.
    output wire          settbTxBufTrigger             , // TB Transmission Buffer Trigger
    output wire          setbcnTxBufTrigger            , // Beacon Transmission Buffer Trigger
    output wire          setac3TxBufTrigger            , // AC3 Transmission Buffer Trigger
    output wire          setac2TxBufTrigger            , // AC2 Transmission Buffer Trigger
    output wire          setac1TxBufTrigger            , // AC1 Transmission Buffer Trigger
    output wire          setac0TxBufTrigger            , // AC0 Transmission Buffer Trigger
    output wire          setac3BWDropTrigger           , // AC3 Bandwith Drop Trigger
    output wire          setac2BWDropTrigger           , // AC2 Bandwith Drop Trigger
    output wire          setac1BWDropTrigger           , // AC1 Bandwith Drop Trigger
    output wire          setac0BWDropTrigger           , // AC0 Bandwith Drop Trigger
    output wire          setrxBuffer2Trigger           , // Receive Buffer 2 Trigger
    output wire          settimerRxTrigger             , // Timer Receive Trigger
    output wire          setrxBuffer1Trigger           , // Receive Buffer 1 Trigger
    output wire          setsecUserTxTrigger           , // Secondary User Transmission Trigger
    output wire          settimerTxTrigger             , // Timer Transmission Trigger
    output wire          settxopComplete               , // TXOP Complete
    output wire          settbTxCancelled              , // TB Transmission Cancelled
    output wire          settbTxTrigger                , // TB Transmission Trigger
    output wire          setbcnTxTrigger               , // Beacon Transmission Trigger
    output wire          setac3TxTrigger               , // AC3 Transmission Trigger
    output wire          setac2TxTrigger               , // AC2 Transmission Trigger
    output wire          setac1TxTrigger               , // AC1 Transmission Trigger
    output wire          setac0TxTrigger               , // AC0 Transmission Trigger
    output wire          settbProtTrigger              , // TB Protocol Trigger
    output wire          setac3ProtTrigger             , // AC3 Protocol Trigger
    output wire          setac2ProtTrigger             , // AC2 Protocol Trigger
    output wire          setac1ProtTrigger             , // AC1 Protocol Trigger
    output wire          setac0ProtTrigger             , // AC0 Protocol Trigger
    //$port_g txRxIntEventClearReg register.
    output wire          cleartbTxBufTrigger           , // Trigger Based Transmission Buffer Trigger
    output wire          clearbcnTxBufTrigger          , // Beacon Transmission Buffer Trigger
    output wire          clearac3TxBufTrigger          , // AC3 Transmission Buffer Trigger
    output wire          clearac2TxBufTrigger          , // AC2 Transmission Buffer Trigger
    output wire          clearac1TxBufTrigger          , // AC1 Transmission Buffer Trigger
    output wire          clearac0TxBufTrigger          , // AC0 Transmission Buffer Trigger
    output wire          clearac3BWDropTrigger         , // AC3 Bandwith Drop Trigger
    output wire          clearac2BWDropTrigger         , // AC2 Bandwith Drop Trigger
    output wire          clearac1BWDropTrigger         , // AC1 Bandwith Drop Trigger
    output wire          clearac0BWDropTrigger         , // AC0 Bandwith Drop Trigger
    output wire          clearrxBuffer2Trigger         , // Receive Buffer 2 Trigger
    output wire          cleartimerRxTrigger           , // Timer Receive Trigger
    output wire          clearrxBuffer1Trigger         , // Receive Buffer 1 Trigger
    output wire          cleartimerTxTrigger           , // Timer Transmission Trigger
    output wire          cleartxopComplete             , // TXOP Complete
    output wire          cleartbTxCancelled            , // TB Transmission Cancelled
    output wire          cleartbTxTrigger              , // TB Transmission Trigger
    output wire          clearbcnTxTrigger             , // Beacon Transmission Trigger
    output wire          clearac3TxTrigger             , // AC3 Transmission Trigger
    output wire          clearac2TxTrigger             , // AC2 Transmission Trigger
    output wire          clearac1TxTrigger             , // AC1 Transmission Trigger
    output wire          clearac0TxTrigger             , // AC0 Transmission Trigger
    output wire          cleartbProtTrigger            , // TB Protocol Trigger
    output wire          clearac3ProtTrigger           , // AC3 Protocol Trigger
    output wire          clearac2ProtTrigger           , // AC2 Protocol Trigger
    output wire          clearac1ProtTrigger           , // AC1 Protocol Trigger
    output wire          clearac0ProtTrigger           , // AC0 Protocol Trigger
    //$port_g txRxIntUnMaskReg register.
    output wire          masterTxRxIntEn               , // If set, external interrupts will be generated in accordance with the rest of the txRxIntUnMaskReg register bits.
    output wire          masktbTxBufTrigger            , // Trigger Based Transmission Buffer Trigger
    output wire          maskbcnTxBufTrigger           , // Beacon Transmission Buffer Trigger
    output wire          maskac3TxBufTrigger           , // AC3 Transmission Buffer Trigger
    output wire          maskac2TxBufTrigger           , // AC2 Transmission Buffer Trigger
    output wire          maskac1TxBufTrigger           , // AC1 Transmission Buffer Trigger
    output wire          maskac0TxBufTrigger           , // AC0 Transmission Buffer Trigger
    output wire          maskac3BWDropTrigger          , // AC3 Bandwith Drop Trigger
    output wire          maskac2BWDropTrigger          , // AC2 Bandwith Drop Trigger
    output wire          maskac1BWDropTrigger          , // AC1 Bandwith Drop Trigger
    output wire          maskac0BWDropTrigger          , // AC0 Bandwith Drop Trigger
    output wire          maskrxBuffer2Trigger          , // Receive Buffer 2 Trigger
    output wire          masktimerRxTrigger            , // Timer Receive Trigger
    output wire          maskrxBuffer1Trigger          , // Receive Buffer 1 Trigger
    output wire          masksecUserTxTrigger          , // Secondary User Transmission Trigger
    output wire          masktimerTxTrigger            , // Timer Transmission Trigger
    output wire          masktxopComplete              , // TXOP Complete
    output wire          masktbTxCancelled             , // TB Transmission Cancelled
    output wire          masktbTxTrigger               , // TB Transmission Trigger
    output wire          maskbcnTxTrigger              , // Beacon Transmission Trigger
    output wire          maskac3TxTrigger              , // AC3 Transmission Trigger
    output wire          maskac2TxTrigger              , // AC2 Transmission Trigger
    output wire          maskac1TxTrigger              , // AC1 Transmission Trigger
    output wire          maskac0TxTrigger              , // AC0 Transmission Trigger
    output wire          masktbProtTrigger             , // TB Protocol Trigger
    output wire          maskac3ProtTrigger            , // AC3 Protocol Trigger
    output wire          maskac2ProtTrigger            , // AC2 Protocol Trigger
    output wire          maskac1ProtTrigger            , // AC1 Protocol Trigger
    output wire          maskac0ProtTrigger            , // AC0 Protocol Trigger
    //$port_g timersIntEventSetReg register.
    output wire          setabsTimers9                 , // Absolute Timers 9
    output wire          setabsTimers8                 , // Absolute Timers 8
    output wire          setabsTimers7                 , // Absolute Timers 7
    output wire          setabsTimers6                 , // Absolute Timers 6
    output wire          setabsTimers5                 , // Absolute Timers 5
    output wire          setabsTimers4                 , // Absolute Timers 4
    output wire          setabsTimers3                 , // Absolute Timers 3
    output wire          setabsTimers2                 , // Absolute Timers 2
    output wire          setabsTimers1                 , // Absolute Timers 1
    output wire          setabsTimers0                 , // Absolute Timers 0
    //$port_g timersIntEventClearReg register.
    output wire          clearabsTimers9               , // Absolute Timers 9
    output wire          clearabsTimers8               , // Absolute Timers 8
    output wire          clearabsTimers7               , // Absolute Timers 7
    output wire          clearabsTimers6               , // Absolute Timers 6
    output wire          clearabsTimers5               , // Absolute Timers 5
    output wire          clearabsTimers4               , // Absolute Timers 4
    output wire          clearabsTimers3               , // Absolute Timers 3
    output wire          clearabsTimers2               , // Absolute Timers 2
    output wire          clearabsTimers1               , // Absolute Timers 1
    output wire          clearabsTimers0               , // Absolute Timers 0
    //$port_g timersIntUnMaskReg register.
    output wire          maskabsTimers9                , // Absolute Timers 9
    output wire          maskabsTimers8                , // Absolute Timers 8
    output wire          maskabsTimers7                , // Absolute Timers 7
    output wire          maskabsTimers6                , // Absolute Timers 6
    output wire          maskabsTimers5                , // Absolute Timers 5
    output wire          maskabsTimers4                , // Absolute Timers 4
    output wire          maskabsTimers3                , // Absolute Timers 3
    output wire          maskabsTimers2                , // Absolute Timers 2
    output wire          maskabsTimers1                , // Absolute Timers 1
    output wire          maskabsTimers0                , // Absolute Timers 0
    //$port_g tsfLoReg register.
    output wire [31 : 0] tsfTimerLow                   , // TSF Timer
    //$port_g tsfHiReg register.
    output wire [31 : 0] tsfTimerHigh                  , // TSF Timer
    //$port_g timeOnAirParam1Reg register.
    output wire [ 1 : 0] ppduSTBC                      , // PPDU Space Time Block Coding
    output wire [ 1 : 0] ppduNumExtnSS                 , // PPDU Number of Extension Spatial Streams
    output wire [ 1 : 0] ppduBW                        , // PPDU BW
    output wire [ 1 : 0] ppduGI                        , // PPDU Guard Interval
    output wire [ 3 : 0] ppduPreType                   , // PPDU Preamble Type
    output wire [19 : 0] ppduLength                    , // PPDU Length
    //$port_g timeOnAirParam2Reg register.
    output wire [ 2 : 0] ppduNumHeLtf                  , // PPDU Number of HE LTF
    output wire [ 6 : 0] ppduNUser                     , // PPDU Dual Carrier Modulation on SIG B
    output wire [ 2 : 0] ppduPE                        , // PPDU Packet Extension
    output wire [ 2 : 0] ppduMCSSigB                   , // PPDU MCS of SIG B
    output wire          ppduDCMSigB                   , // PPDU Dual Carrier Modulation on SIG B
    output wire          ppduSigBCompMode              , // PPDU SIG B Compression Mode
    output wire [ 1 : 0] ppduHELTFType                 , // PPDU HE-LTF Type
    output wire          ppduDCM                       , // PPDU Dual Carrier Modulation
    output wire [ 6 : 0] ppduMCSIndex                  , // PPDU MCS Index
    //$port_g timeOnAirParam3Reg register.
    output wire [ 2 : 0] ppduRuType                    , // PPDU Ru Type
    output wire          ppduMma                       , // PPDU Midamble
    output wire          ppduDoppler                   , // PPDU Doppler
    //$port_g timeOnAirValueReg register.
    output wire          computeDuration               , // Compute Duration
    //$port_g dmaCntrlSetReg register.
    output wire          sethaltTBAfterTXOP            , // Halt TB After TXOP
    output wire          sethaltAC3AfterTXOP           , // Halt AC3 After TXOP
    output wire          sethaltAC2AfterTXOP           , // Halt AC2 After TXOP
    output wire          sethaltAC1AfterTXOP           , // Halt AC1 After TXOP
    output wire          sethaltAC0AfterTXOP           , // Halt AC0 After TXOP
    output wire          sethaltBcnAfterTXOP           , // Halt BCN queue
    output wire          settxTBNewHead                , // Transmit TB DMA New Head
    output wire          settxAC3NewHead               , // Transmit AC 3 DMA New Head
    output wire          settxAC2NewHead               , // Transmit AC 2 DMA New Head
    output wire          settxAC1NewHead               , // Transmit AC 1 DMA New Head
    output wire          settxAC0NewHead               , // Transmit AC 0 DMA New Head
    output wire          settxBcnNewHead               , // Transmit Beacon DMA New Head
    output wire          settxAC3NewTail               , // Transmit AC 3 DMA New Tail
    output wire          settxAC2NewTail               , // Transmit AC 2 DMA New Tail
    output wire          settxAC1NewTail               , // Transmit AC 1 DMA New Tail
    output wire          settxAC0NewTail               , // Transmit AC 0 DMA New Tail
    output wire          settxBcnNewTail               , // Transmit Beacon DMA New Tail
    //$port_g dmaCntrlClearReg register.
    output wire          clearhaltTBAfterTXOP          , // Halt TB After TXOP
    output wire          clearhaltAC3AfterTXOP         , // Halt AC3 After TXOP
    output wire          clearhaltAC2AfterTXOP         , // Halt AC2 After TXOP
    output wire          clearhaltAC1AfterTXOP         , // Halt AC1 After TXOP
    output wire          clearhaltAC0AfterTXOP         , // Halt AC0 After TXOP
    output wire          clearhaltBcnAfterTXOP         , // Halt BCN queue
    output wire          cleartxTBNewHead              , // Transmit TB DMA New Head
    output wire          cleartxAC3NewHead             , // Transmit AC 3 DMA New Head
    output wire          cleartxAC2NewHead             , // Transmit AC 2 DMA New Head
    output wire          cleartxAC1NewHead             , // Transmit AC 1 DMA New Head
    output wire          cleartxAC0NewHead             , // Transmit AC 0 DMA New Head
    output wire          cleartxBcnNewHead             , // Transmit Beacon DMA New Head
    output wire          cleartxAC3NewTail             , // Transmit AC 3 DMA New Tail
    output wire          cleartxAC2NewTail             , // Transmit AC 2 DMA New Tail
    output wire          cleartxAC1NewTail             , // Transmit AC 1 DMA New Tail
    output wire          cleartxAC0NewTail             , // Transmit AC 0 DMA New Tail
    output wire          cleartxBcnNewTail             , // Transmit Beacon DMA New Tail
    //$port_g txBcnHeadPtrReg register.
    output wire [31 : 0] txBcnHeadPtr                  , // Transmit Beacon list Head Pointer
    //$port_g txAC0HeadPtrReg register.
    output wire [31 : 0] txAC0HeadPtr                  , // Transmit AC 0 list Head Pointer
    //$port_g txAC1HeadPtrReg register.
    output wire [31 : 0] txAC1HeadPtr                  , // Transmit AC 1 list Head Pointer
    //$port_g txAC2HeadPtrReg register.
    output wire [31 : 0] txAC2HeadPtr                  , // Transmit AC 2 list Head Pointer
    //$port_g txAC3HeadPtrReg register.
    output wire [31 : 0] txAC3HeadPtr                  , // Transmit AC 3 list Head Pointer
    //$port_g txTBHeadPtrReg register.
    output wire [31 : 0] txTBHeadPtr                   , // Transmit TB Head Pointer
    //$port_g txStructSizesReg register.
    output wire [ 5 : 0] dmaRBDSize                    , // DMA Receive Buffer Descriptor Size
    output wire [ 5 : 0] dmaRHDSize                    , // DMA Receive Header Descriptor Size
    output wire [ 5 : 0] dmaTBDSize                    , // DMA Transmit Buffer Descriptor Size
    output wire [ 5 : 0] dmaTHDSize                    , // DMA Transmit Header Descriptor Size
    output wire [ 5 : 0] ptEntrySize                   , // Policy Table Entry Size
    //$port_g dmaThresholdReg register.
    output wire [ 7 : 0] rxFIFOThreshold               , // Receive FIFO Threshold
    output wire [ 7 : 0] txFIFOThreshold               , // Transmit FIFO Threshold
    //$port_g rxHeaderTFPtrReg register.
    //$port_g rxBuf1StartPtrReg register.
    output wire [30 : 0] rxBuf1StartPtr                , // DMA Receive buffer 1 start address Pointer
    //$port_g rxBuf1EndPtrReg register.
    output wire [30 : 0] rxBuf1EndPtr                  , // DMA Receive buffer 1 end address Pointer
    //$port_g rxBuf1RdPtrReg register.
    output wire [31 : 0] rxBuf1RdPtr                   , // DMA Receive buffer 1 read Pointer
    //$port_g rxBuf1WrPtrReg register.
    output wire [31 : 0] rxBuf1WrPtr                   , // DMA Receive buffer 1 write Pointer
    //$port_g rxBuf2StartPtrReg register.
    output wire [30 : 0] rxBuf2StartPtr                , // DMA Receive buffer 2 start address Pointer
    //$port_g rxBuf2EndPtrReg register.
    output wire [30 : 0] rxBuf2EndPtr                  , // DMA Receive buffer 2 end address Pointer
    //$port_g rxBuf2RdPtrReg register.
    output wire [31 : 0] rxBuf2RdPtr                   , // DMA Receive buffer 2 read Pointer
    //$port_g rxBuf2WrPtrReg register.
    output wire [31 : 0] rxBuf2WrPtr                   , // DMA Receive buffer 2 write Pointer
    //$port_g rxBufConfigReg register.
    output wire [ 7 : 0] rxBufRPDFooter                , // DMA RX buffer Receive Payload Descriptor blank space Footer
    output wire [ 7 : 0] rxBufRPDHeader                , // DMA RX buffer Receive Payload Descriptor blank space Header
    output wire [ 7 : 0] rxBufRHDFooter                , // DMA RX buffer Receive Header Descriptor blank space Footer
    output wire [ 7 : 0] rxBufRHDHeader                , // DMA RX buffer Receive Header Descriptor blank space Header
    //$port_g txHETBInfoReg register.
    output wire [ 3 : 0] maxMCSInHETB                  , // Max MCS in HE TB
    output wire [ 2 : 0] eOCW                          , // Exposent of OFDMA Contention Window
    output wire [ 2 : 0] eOCWMin                       , // Exposent of OFDMA Contention Window Minimum
    output wire          raRUType                      , // Random Access RU Type
    output wire          raRUEnable                    , // Random Access RU Enable
    output wire [ 5 : 0] txHETBMaxDur                  , // HE TB Preparation Max Duration
`ifdef RW_MUMIMO_TX_EN                      
    //$port_g secUsersTxIntEventSetReg register.
    output wire          setsecU3ac3TxBufTrigger       , // Secondary User 3 AC3 Transmission Buffer Trigger
    output wire          setsecU3ac2TxBufTrigger       , // Secondary User 3 AC2 Transmission Buffer Trigger
    output wire          setsecU3ac1TxBufTrigger       , // Secondary User 3 AC1 Transmission Buffer Trigger
    output wire          setsecU3ac0TxBufTrigger       , // Secondary User 3 AC0 Transmission Buffer Trigger
    output wire          setsecU3ac3TxTrigger          , // Secondary User 3 AC3 Transmission Trigger
    output wire          setsecU3ac2TxTrigger          , // Secondary User 3 AC2 Transmission Trigger
    output wire          setsecU3ac1TxTrigger          , // Secondary User 3 AC1 Transmission Trigger
    output wire          setsecU3ac0TxTrigger          , // Secondary User 3 AC0 Transmission Trigger
    output wire          setsecU2ac3TxBufTrigger       , // Secondary User 2 AC3 Transmission Buffer Trigger
    output wire          setsecU2ac2TxBufTrigger       , // Secondary User 2 AC2 Transmission Buffer Trigger
    output wire          setsecU2ac1TxBufTrigger       , // Secondary User 2 AC1 Transmission Buffer Trigger
    output wire          setsecU2ac0TxBufTrigger       , // Secondary User 2 AC0 Transmission Buffer Trigger
    output wire          setsecU2ac3TxTrigger          , // Secondary User 2 AC3 Transmission Trigger
    output wire          setsecU2ac2TxTrigger          , // Secondary User 2 AC2 Transmission Trigger
    output wire          setsecU2ac1TxTrigger          , // Secondary User 2 AC1 Transmission Trigger
    output wire          setsecU2ac0TxTrigger          , // Secondary User 2 AC0 Transmission Trigger
    output wire          setsecU1ac3TxBufTrigger       , // Secondary User 1 AC3 Transmission Buffer Trigger
    output wire          setsecU1ac2TxBufTrigger       , // Secondary User 1 AC2 Transmission Buffer Trigger
    output wire          setsecU1ac1TxBufTrigger       , // Secondary User 1 AC1 Transmission Buffer Trigger
    output wire          setsecU1ac0TxBufTrigger       , // Secondary User 1 AC0 Transmission Buffer Trigger
    output wire          setsecU1ac3TxTrigger          , // Secondary User 1 AC3 Transmission Trigger
    output wire          setsecU1ac2TxTrigger          , // Secondary User 1 AC2 Transmission Trigger
    output wire          setsecU1ac1TxTrigger          , // Secondary User 1 AC1 Transmission Trigger
    output wire          setsecU1ac0TxTrigger          , // Secondary User 1 AC0 Transmission Trigger
    //$port_g secUsersTxIntEventClearReg register.
    output wire          clearsecU3ac3TxBufTrigger     , // Secondary User 3 AC3 Transmission Buffer Trigger
    output wire          clearsecU3ac2TxBufTrigger     , // Secondary User 3 AC2 Transmission Buffer Trigger
    output wire          clearsecU3ac1TxBufTrigger     , // Secondary User 3 AC1 Transmission Buffer Trigger
    output wire          clearsecU3ac0TxBufTrigger     , // Secondary User 3 AC0 Transmission Buffer Trigger
    output wire          clearsecU3ac3TxTrigger        , // Secondary User 3 AC3 Transmission Trigger
    output wire          clearsecU3ac2TxTrigger        , // Secondary User 3 AC2 Transmission Trigger
    output wire          clearsecU3ac1TxTrigger        , // Secondary User 3 AC1 Transmission Trigger
    output wire          clearsecU3ac0TxTrigger        , // Secondary User 3 AC0 Transmission Trigger
    output wire          clearsecU2ac3TxBufTrigger     , // Secondary User 2 AC3 Transmission Buffer Trigger
    output wire          clearsecU2ac2TxBufTrigger     , // Secondary User 2 AC2 Transmission Buffer Trigger
    output wire          clearsecU2ac1TxBufTrigger     , // Secondary User 2 AC1 Transmission Buffer Trigger
    output wire          clearsecU2ac0TxBufTrigger     , // Secondary User 2 AC0 Transmission Buffer Trigger
    output wire          clearsecU2ac3TxTrigger        , // Secondary User 2 AC3 Transmission Trigger
    output wire          clearsecU2ac2TxTrigger        , // Secondary User 2 AC2 Transmission Trigger
    output wire          clearsecU2ac1TxTrigger        , // Secondary User 2 AC1 Transmission Trigger
    output wire          clearsecU2ac0TxTrigger        , // Secondary User 2 AC0 Transmission Trigger
    output wire          clearsecU1ac3TxBufTrigger     , // Secondary User 1 AC3 Transmission Buffer Trigger
    output wire          clearsecU1ac2TxBufTrigger     , // Secondary User 1 AC2 Transmission Buffer Trigger
    output wire          clearsecU1ac1TxBufTrigger     , // Secondary User 1 AC1 Transmission Buffer Trigger
    output wire          clearsecU1ac0TxBufTrigger     , // Secondary User 1 AC0 Transmission Buffer Trigger
    output wire          clearsecU1ac3TxTrigger        , // Secondary User 1 AC3 Transmission Trigger
    output wire          clearsecU1ac2TxTrigger        , // Secondary User 1 AC2 Transmission Trigger
    output wire          clearsecU1ac1TxTrigger        , // Secondary User 1 AC1 Transmission Trigger
    output wire          clearsecU1ac0TxTrigger        , // Secondary User 1 AC0 Transmission Trigger
    //$port_g secUsersTxIntEventUnMaskReg register.
    output wire          masterSecUsersTxIntEn         , // Master Secondary Users Tx Interrupt Enable
    output wire          masksecU3ac3TxBufTrigger      , // Secondary User 3 AC3 Transmission Buffer Trigger
    output wire          masksecU3ac2TxBufTrigger      , // Secondary User 3 AC2 Transmission Buffer Trigger
    output wire          masksecU3ac1TxBufTrigger      , // Secondary User 3 AC1 Transmission Buffer Trigger
    output wire          masksecU3ac0TxBufTrigger      , // Secondary User 3 AC0 Transmission Buffer Trigger
    output wire          masksecU3ac3TxTrigger         , // Secondary User 3 AC3 Transmission Trigger
    output wire          masksecU3ac2TxTrigger         , // Secondary User 3 AC2 Transmission Trigger
    output wire          masksecU3ac1TxTrigger         , // Secondary User 3 AC1 Transmission Trigger
    output wire          masksecU3ac0TxTrigger         , // Secondary User 3 AC0 Transmission Trigger
    output wire          masksecU2ac3TxBufTrigger      , // Secondary User 2 AC3 Transmission Buffer Trigger
    output wire          masksecU2ac2TxBufTrigger      , // Secondary User 2 AC2 Transmission Buffer Trigger
    output wire          masksecU2ac1TxBufTrigger      , // Secondary User 2 AC1 Transmission Buffer Trigger
    output wire          masksecU2ac0TxBufTrigger      , // Secondary User 2 AC0 Transmission Buffer Trigger
    output wire          masksecU2ac3TxTrigger         , // Secondary User 2 AC3 Transmission Trigger
    output wire          masksecU2ac2TxTrigger         , // Secondary User 2 AC2 Transmission Trigger
    output wire          masksecU2ac1TxTrigger         , // Secondary User 2 AC1 Transmission Trigger
    output wire          masksecU2ac0TxTrigger         , // Secondary User 2 AC0 Transmission Trigger
    output wire          masksecU1ac3TxBufTrigger      , // Secondary User 1 AC3 Transmission Buffer Trigger
    output wire          masksecU1ac2TxBufTrigger      , // Secondary User 1 AC2 Transmission Buffer Trigger
    output wire          masksecU1ac1TxBufTrigger      , // Secondary User 1 AC1 Transmission Buffer Trigger
    output wire          masksecU1ac0TxBufTrigger      , // Secondary User 1 AC0 Transmission Buffer Trigger
    output wire          masksecU1ac3TxTrigger         , // Secondary User 1 AC3 Transmission Trigger
    output wire          masksecU1ac2TxTrigger         , // Secondary User 1 AC2 Transmission Trigger
    output wire          masksecU1ac1TxTrigger         , // Secondary User 1 AC1 Transmission Trigger
    output wire          masksecU1ac0TxTrigger         , // Secondary User 1 AC0 Transmission Trigger
`endif // RW_MUMIMO_TX_EN                      
    //$port_g debugTBSPtrReg register.
    //$port_g swProfilingReg register.
    output wire          swProf31                      , // Software Profiling value
    output wire          swProf30                      , // Software Profiling value
    output wire          swProf29                      , // Software Profiling value
    output wire          swProf28                      , // Software Profiling value
    output wire          swProf27                      , // Software Profiling value
    output wire          swProf26                      , // Software Profiling value
    output wire          swProf25                      , // Software Profiling value
    output wire          swProf24                      , // Software Profiling value
    output wire          swProf23                      , // Software Profiling value
    output wire          swProf22                      , // Software Profiling value
    output wire          swProf21                      , // Software Profiling value
    output wire          swProf20                      , // Software Profiling value
    output wire          swProf19                      , // Software Profiling value
    output wire          swProf18                      , // Software Profiling value
    output wire          swProf17                      , // Software Profiling value
    output wire          swProf16                      , // Software Profiling value
    output wire          swProf15                      , // Software Profiling value
    output wire          swProf14                      , // Software Profiling value
    output wire          swProf13                      , // Software Profiling value
    output wire          swProf12                      , // Software Profiling value
    output wire          swProf11                      , // Software Profiling value
    output wire          swProf10                      , // Software Profiling value
    output wire          swProf9                       , // Software Profiling value
    output wire          swProf8                       , // Software Profiling value
    output wire          swProf7                       , // Software Profiling value
    output wire          swProf6                       , // Software Profiling value
    output wire          swProf5                       , // Software Profiling value
    output wire          swProf4                       , // Software Profiling value
    output wire          swProf3                       , // Software Profiling value
    output wire          swProf2                       , // Software Profiling value
    output wire          swProf1                       , // Software Profiling value
    output wire          swProf0                       , // Software Profiling value
    //$port_g swSetProfilingReg register.
    output wire          swSetProf31                   , // Software Profiling Set Bit
    output wire          swSetProf30                   , // Software Profiling Set Bit
    output wire          swSetProf29                   , // Software Profiling Set Bit
    output wire          swSetProf28                   , // Software Profiling Set Bit
    output wire          swSetProf27                   , // Software Profiling Set Bit
    output wire          swSetProf26                   , // Software Profiling Set Bit
    output wire          swSetProf25                   , // Software Profiling Set Bit
    output wire          swSetProf24                   , // Software Profiling Set Bit
    output wire          swSetProf23                   , // Software Profiling Set Bit
    output wire          swSetProf22                   , // Software Profiling Set Bit
    output wire          swSetProf21                   , // Software Profiling Set Bit
    output wire          swSetProf20                   , // Software Profiling Set Bit
    output wire          swSetProf19                   , // Software Profiling Set Bit
    output wire          swSetProf18                   , // Software Profiling Set Bit
    output wire          swSetProf17                   , // Software Profiling Set Bit
    output wire          swSetProf16                   , // Software Profiling Set Bit
    output wire          swSetProf15                   , // Software Profiling Set Bit
    output wire          swSetProf14                   , // Software Profiling Set Bit
    output wire          swSetProf13                   , // Software Profiling Set Bit
    output wire          swSetProf12                   , // Software Profiling Set Bit
    output wire          swSetProf11                   , // Software Profiling Set Bit
    output wire          swSetProf10                   , // Software Profiling Set Bit
    output wire          swSetProf9                    , // Software Profiling Set Bit
    output wire          swSetProf8                    , // Software Profiling Set Bit
    output wire          swSetProf7                    , // Software Profiling Set Bit
    output wire          swSetProf6                    , // Software Profiling Set Bit
    output wire          swSetProf5                    , // Software Profiling Set Bit
    output wire          swSetProf4                    , // Software Profiling Set Bit
    output wire          swSetProf3                    , // Software Profiling Set Bit
    output wire          swSetProf2                    , // Software Profiling Set Bit
    output wire          swSetProf1                    , // Software Profiling Set Bit
    output wire          swSetProf0                    , // Software Profiling Set Bit
    //$port_g swClearProfilingReg register.
    output wire          swClearProf31                 , // Software Profiling Clear Bit
    output wire          swClearProf30                 , // Software Profiling Clear Bit
    output wire          swClearProf29                 , // Software Profiling Clear Bit
    output wire          swClearProf28                 , // Software Profiling Clear Bit
    output wire          swClearProf27                 , // Software Profiling Clear Bit
    output wire          swClearProf26                 , // Software Profiling Clear Bit
    output wire          swClearProf25                 , // Software Profiling Clear Bit
    output wire          swClearProf24                 , // Software Profiling Clear Bit
    output wire          swClearProf23                 , // Software Profiling Clear Bit
    output wire          swClearProf22                 , // Software Profiling Clear Bit
    output wire          swClearProf21                 , // Software Profiling Clear Bit
    output wire          swClearProf20                 , // Software Profiling Clear Bit
    output wire          swClearProf19                 , // Software Profiling Clear Bit
    output wire          swClearProf18                 , // Software Profiling Clear Bit
    output wire          swClearProf17                 , // Software Profiling Clear Bit
    output wire          swClearProf16                 , // Software Profiling Clear Bit
    output wire          swClearProf15                 , // Software Profiling Clear Bit
    output wire          swClearProf14                 , // Software Profiling Clear Bit
    output wire          swClearProf13                 , // Software Profiling Clear Bit
    output wire          swClearProf12                 , // Software Profiling Clear Bit
    output wire          swClearProf11                 , // Software Profiling Clear Bit
    output wire          swClearProf10                 , // Software Profiling Clear Bit
    output wire          swClearProf9                  , // Software Profiling Clear Bit
    output wire          swClearProf8                  , // Software Profiling Clear Bit
    output wire          swClearProf7                  , // Software Profiling Clear Bit
    output wire          swClearProf6                  , // Software Profiling Clear Bit
    output wire          swClearProf5                  , // Software Profiling Clear Bit
    output wire          swClearProf4                  , // Software Profiling Clear Bit
    output wire          swClearProf3                  , // Software Profiling Clear Bit
    output wire          swClearProf2                  , // Software Profiling Clear Bit
    output wire          swClearProf1                  , // Software Profiling Clear Bit
    output wire          swClearProf0                  , // Software Profiling Clear Bit
    //$port_g swProfilingReg2 register.
    output wire          swProf63                      , // Software Profiling value
    output wire          swProf62                      , // Software Profiling value
    output wire          swProf61                      , // Software Profiling value
    output wire          swProf60                      , // Software Profiling value
    output wire          swProf59                      , // Software Profiling value
    output wire          swProf58                      , // Software Profiling value
    output wire          swProf57                      , // Software Profiling value
    output wire          swProf56                      , // Software Profiling value
    output wire          swProf55                      , // Software Profiling value
    output wire          swProf54                      , // Software Profiling value
    output wire          swProf53                      , // Software Profiling value
    output wire          swProf52                      , // Software Profiling value
    output wire          swProf51                      , // Software Profiling value
    output wire          swProf50                      , // Software Profiling value
    output wire          swProf49                      , // Software Profiling value
    output wire          swProf48                      , // Software Profiling value
    output wire          swProf47                      , // Software Profiling value
    output wire          swProf46                      , // Software Profiling value
    output wire          swProf45                      , // Software Profiling value
    output wire          swProf44                      , // Software Profiling value
    output wire          swProf43                      , // Software Profiling value
    output wire          swProf42                      , // Software Profiling value
    output wire          swProf41                      , // Software Profiling value
    output wire          swProf40                      , // Software Profiling value
    output wire          swProf39                      , // Software Profiling value
    output wire          swProf38                      , // Software Profiling value
    output wire          swProf37                      , // Software Profiling value
    output wire          swProf36                      , // Software Profiling value
    output wire          swProf35                      , // Software Profiling value
    output wire          swProf34                      , // Software Profiling value
    output wire          swProf33                      , // Software Profiling value
    output wire          swProf32                      , // Software Profiling value
    //$port_g swSetProfilingReg2 register.
    output wire          swSetProf63                   , // Software Profiling Set Bit
    output wire          swSetProf62                   , // Software Profiling Set Bit
    output wire          swSetProf61                   , // Software Profiling Set Bit
    output wire          swSetProf60                   , // Software Profiling Set Bit
    output wire          swSetProf59                   , // Software Profiling Set Bit
    output wire          swSetProf58                   , // Software Profiling Set Bit
    output wire          swSetProf57                   , // Software Profiling Set Bit
    output wire          swSetProf56                   , // Software Profiling Set Bit
    output wire          swSetProf55                   , // Software Profiling Set Bit
    output wire          swSetProf54                   , // Software Profiling Set Bit
    output wire          swSetProf53                   , // Software Profiling Set Bit
    output wire          swSetProf52                   , // Software Profiling Set Bit
    output wire          swSetProf51                   , // Software Profiling Set Bit
    output wire          swSetProf50                   , // Software Profiling Set Bit
    output wire          swSetProf49                   , // Software Profiling Set Bit
    output wire          swSetProf48                   , // Software Profiling Set Bit
    output wire          swSetProf47                   , // Software Profiling Set Bit
    output wire          swSetProf46                   , // Software Profiling Set Bit
    output wire          swSetProf45                   , // Software Profiling Set Bit
    output wire          swSetProf44                   , // Software Profiling Set Bit
    output wire          swSetProf43                   , // Software Profiling Set Bit
    output wire          swSetProf42                   , // Software Profiling Set Bit
    output wire          swSetProf41                   , // Software Profiling Set Bit
    output wire          swSetProf40                   , // Software Profiling Set Bit
    output wire          swSetProf39                   , // Software Profiling Set Bit
    output wire          swSetProf38                   , // Software Profiling Set Bit
    output wire          swSetProf37                   , // Software Profiling Set Bit
    output wire          swSetProf36                   , // Software Profiling Set Bit
    output wire          swSetProf35                   , // Software Profiling Set Bit
    output wire          swSetProf34                   , // Software Profiling Set Bit
    output wire          swSetProf33                   , // Software Profiling Set Bit
    output wire          swSetProf32                   , // Software Profiling Set Bit
    //$port_g swClearProfilingReg2 register.
    output wire          swClearProf63                 , // Software Profiling Clear Bit
    output wire          swClearProf62                 , // Software Profiling Clear Bit
    output wire          swClearProf61                 , // Software Profiling Clear Bit
    output wire          swClearProf60                 , // Software Profiling Clear Bit
    output wire          swClearProf59                 , // Software Profiling Clear Bit
    output wire          swClearProf58                 , // Software Profiling Clear Bit
    output wire          swClearProf57                 , // Software Profiling Clear Bit
    output wire          swClearProf56                 , // Software Profiling Clear Bit
    output wire          swClearProf55                 , // Software Profiling Clear Bit
    output wire          swClearProf54                 , // Software Profiling Clear Bit
    output wire          swClearProf53                 , // Software Profiling Clear Bit
    output wire          swClearProf52                 , // Software Profiling Clear Bit
    output wire          swClearProf51                 , // Software Profiling Clear Bit
    output wire          swClearProf50                 , // Software Profiling Clear Bit
    output wire          swClearProf49                 , // Software Profiling Clear Bit
    output wire          swClearProf48                 , // Software Profiling Clear Bit
    output wire          swClearProf47                 , // Software Profiling Clear Bit
    output wire          swClearProf46                 , // Software Profiling Clear Bit
    output wire          swClearProf45                 , // Software Profiling Clear Bit
    output wire          swClearProf44                 , // Software Profiling Clear Bit
    output wire          swClearProf43                 , // Software Profiling Clear Bit
    output wire          swClearProf42                 , // Software Profiling Clear Bit
    output wire          swClearProf41                 , // Software Profiling Clear Bit
    output wire          swClearProf40                 , // Software Profiling Clear Bit
    output wire          swClearProf39                 , // Software Profiling Clear Bit
    output wire          swClearProf38                 , // Software Profiling Clear Bit
    output wire          swClearProf37                 , // Software Profiling Clear Bit
    output wire          swClearProf36                 , // Software Profiling Clear Bit
    output wire          swClearProf35                 , // Software Profiling Clear Bit
    output wire          swClearProf34                 , // Software Profiling Clear Bit
    output wire          swClearProf33                 , // Software Profiling Clear Bit
    output wire          swClearProf32                 , // Software Profiling Clear Bit
`ifdef RW_MUMIMO_SEC_USER1_EN               
`endif // RW_MUMIMO_SEC_USER1_EN               
`ifdef RW_MUMIMO_SEC_USER2_EN               
`endif // RW_MUMIMO_SEC_USER2_EN               
`ifdef RW_MUMIMO_SEC_USER3_EN               
`endif // RW_MUMIMO_SEC_USER3_EN               
    //$port_g macAddrLowReg register.
    output wire [31 : 0] macAddrLow                    , // MAC Address
    //$port_g macAddrHiReg register.
    output wire [15 : 0] macAddrHigh                   , // MAC Address
    //$port_g macAddrLowMaskReg register.
    output wire [31 : 0] macAddrLowMask                , // MAC Address Mask
    //$port_g macAddrHiMaskReg register.
    output wire [15 : 0] macAddrHighMask               , // MAC Address Mask
    //$port_g bssIDLowReg register.
    output wire [31 : 0] bssIDLow                      , // BSSID
    //$port_g bssIDHiReg register.
    output wire [15 : 0] bssIDHigh                     , // BSSID
    //$port_g bssIDLowMaskReg register.
    output wire [31 : 0] bssIDLowMask                  , // BSSID Mask
    //$port_g bssIDHiMaskReg register.
    output wire [15 : 0] bssIDHighMask                 , // BSSID Mask
    //$port_g bssColorReg register.
    output wire          partialBSSColorEn             , // Partial BSS Color Enable
    output wire          bssColorEn                    , // BSS Color Enable
    output wire [ 5 : 0] bssColor                      , // BSS Color
    //$port_g stateCntrlReg register.
    output wire [ 3 : 0] nextState                     , // Next State
    //$port_g scanCntrlReg register.
    output wire [ 2 : 0] primaryChPosition             , // Primary Channel Position
    output wire [15 : 0] probeDelay                    , // Probe Delay
    //$port_g dozeCntrl1Reg register.
    output wire          wakeupDTIM                    , // Wakeup DTIM interval
    output wire [15 : 0] listenInterval                , // Listen Interval
    //$port_g macCntrl1Reg register.
    output wire          rxRIFSEn                      , // Rx RIFS Enable
    output wire          tsfMgtDisable                 , // TSF Management Disable
    output wire          tsfUpdatedBySW                , // TSF Updated By SW
    output wire          disableSVDRxPause             , // Disable reception pause during SVD Processing.
    output wire          disableBQRResp                , // Disable BQR Response
    output wire [ 2 : 0] abgnMode                      , // 802.11a/b/g/n/ac Mode
    output wire          keyStoRAMReset                , // Key Storage RAM Reset
    output wire          mibTableReset                 , // MIB Table reset
    output wire          rateControllerMPIF            , // Rate Controlled MAC-PHY InterFace
    output wire          disableBAResp                 , // Disable BA Response
    output wire          disableCTSResp                , // Disable CTS Response
    output wire          disableACKResp                , // Disable ACK Response
    output wire          activeClkGating               , // Active Clock Gating
    output wire          enableLPClkSwitch             , // Enable the switch to Low Power clock
    output wire          lpClk32786Hz                  , // LowPower Clock 32768Hz
    output wire          pwrMgt                        , // Power Management
    output wire          ap                            , // Access Point
    output wire          bssType                       , // BSS Type
    //$port_g macErrRecCntrlReg register.
    output wire          rxFlowCntrlEn                 , // RX Flow Control Enable
    output wire          baPSBitmapReset               , // Block ACK Partial Bitmap Reset
    output wire          macPHYIFFIFOReset             , // MAC-PHY InterFace FIFO Reset
    output wire          txFIFOReset                   , // Transmit FIFO Reset
    output wire          rxFIFOReset                   , // Receive FIFO Reset
    output wire          hwFSMReset                    , // Hardware Finite State Machine Reset
    output wire          useErrDet                     , // Use Error Detection
    //$port_g macErrSetStatusReg register.
    output wire          errInHWLevel3                 , // Error in HW - Level 3
    output wire          errInTxRxLevel2               , // Error in Transmit/Receive - Level 2
    output wire          errInRxLevel1                 , // Error In Receive - Level 1
    output wire          errInTxLevel1                 , // Error In Transmit - Level 1
    //$port_g macErrClearStatusReg register.
    output wire          clearErrInHWLevel3            , // Error in HW - Level 3
    output wire          clearErrInTxRxLevel2          , // Error in Transmit/Receive - Level 2
    output wire          clearErrInRxLevel1            , // Error In Receive - Level 1
    output wire          clearErrInTxLevel1            , // Error In Transmit - Level 1
    //$port_g rxCntrlReg register.
    output wire          acceptUnknown                 , // Accept Unknown Type field
    output wire          acceptOtherDataFrames         , // Accept Other Data Frames
    output wire          acceptQoSNull                 , // Accept QoS Null
    output wire          acceptQCFWOData               , // Accept QoS CF WithOut Data
    output wire          acceptQData                   , // Accept QoS Data
    output wire          acceptCFWOData                , // Accept CF WithOut Data
    output wire          acceptData                    , // Accept Data
    output wire          acceptOtherCntrlFrames        , // Accept Other Control Frames
    output wire          acceptCFEnd                   , // Accept CF-End
    output wire          acceptACK                     , // Accept ACK
    output wire          acceptCTS                     , // Accept CTS
    output wire          acceptRTS                     , // Accept RTS
    output wire          acceptPSPoll                  , // Accept PS-Poll
    output wire          acceptBA                      , // Accept Block Ack
    output wire          acceptBAR                     , // Accept Block Ack Request
    output wire          acceptOtherMgmtFrames         , // Accept Other Management Frames
    output wire          acceptBfmeeFrames             , // Accept All Beamformee Frames
    output wire          acceptAllBeacon               , // Accept All Beacon
    output wire          acceptNotExpectedBA           , // Accept Not Expected BA
    output wire          acceptDecryptErrorFrames      , // Accept Decryption Error Frames
    output wire          acceptBeacon                  , // Accept Beacon
    output wire          acceptProbeResp               , // Accept Probe Response
    output wire          acceptProbeReq                , // Accept Probe Request
    output wire          acceptMyUnicast               , // Accept My Unicast
    output wire          acceptUnicast                 , // Accept Unicast
    output wire          acceptErrorFrames             , // Accept Error Frames
    output wire          acceptOtherBSSID              , // Accept Other BSSID
    output wire          acceptBroadcast               , // Accept Broadcast 
    output wire          acceptMulticast               , // Accept Multicast 
    output wire          dontDecrypt                   , // Don't Decrypt
    output wire          excUnencrypted                , // Exclude Unencrypted Receive fragments
    //$port_g bcnCntrl1Reg register.
    output wire [ 7 : 0] noBcnTxTime                   , // No Beacon Transmit Time
    output wire          impTBTTIn128Us                , // Impending TBTT Interrupt Period in 128us
    output wire [ 6 : 0] impTBTTPeriod                 , // Impending TBTT Period
    output wire [15 : 0] beaconInt                     , // Beacon Interval 
    //$port_g bcnCntrl2Reg register.
    output wire [15 : 0] aid                           , // Association ID
    output wire [ 7 : 0] timOffset                     , // TIM Offset
    output wire [ 7 : 0] bcnUpdateOffset               , // Beacon Update Offset
    //$port_g dtim1Reg register.
    output wire          dtimUpdatedBySW               , // DTIM Updated by SW
    output wire [ 7 : 0] dtimPeriod                    , // DTIM Period
    //$port_g retryLimitsReg register.
    output wire [ 7 : 0] dot11LongRetryLimit           , // Dot11 Long Retry Limit
    output wire [ 7 : 0] dot11ShortRetryLimit          , // Dot11 Short Retry Limit
    //$port_g bbServiceReg register.
    output wire [ 2 : 0] maxPHYNtx                     , // Maximum number of PHY Transmit Chains
    output wire [ 7 : 0] bbServiceB                    , // This field contains the service field that is to be sent to the baseband. The 8 bits from this field are transmitted to the BB in the lower 8 bits of the Service field of the Tx Vector when the modulation is DSSS/CCK.
    output wire [15 : 0] bbServiceA                    , // This field contains the service field that is to be sent to the baseband. The 16 bits from this field are transmitted to the BB in the 16 bits of the Service field of the Tx-Vector when the modulation is OFDM.
    //$port_g maxPowerLevelReg register.
    output wire [ 7 : 0] ofdmMinPwrLevel               , // OFDM Minimum Power Level
    output wire [ 7 : 0] dsssMaxPwrLevel               , // DSSS Maximum Power Level
    output wire [ 7 : 0] ofdmMaxPwrLevel               , // OFDM Maximum Power Level
    //$port_g encrKey0Reg register.
    output wire [31 : 0] encrKeyRAMWord0               , // Encryption Key for RAM
    //$port_g encrKey1Reg register.
    output wire [31 : 0] encrKeyRAMWord1               , // Encryption Key for RAM
    //$port_g encrKey2Reg register.
    output wire [31 : 0] encrKeyRAMWord2               , // It contains bits 95 to 64 of the 104-bit WEP key or the TKIP/CCMP/WAPI key to be programmed in the Key Storage RAM.
    //$port_g encrKey3Reg register.
    output wire [31 : 0] encrKeyRAMWord3               , // Encryption Key for RAM
    //$port_g encrMACAddrLowReg register.
    output wire [31 : 0] macAddrRAMLow                 , // MAC Address for RAM
    //$port_g encrMACAddrHighReg register.
    output wire [15 : 0] macAddrRAMHigh                , // MAC Address for RAM
    //$port_g encrCntrlReg register.
    output wire          newRead                       , // New Read
    output wire          newWrite                      , // New Write
    output wire          newSearch                     , // New Search
    output wire          searchError                   , // Search Error
    output wire [ 9 : 0] keyIndexRAM                   , // Key Index RAM
    output wire [ 1 : 0] cLenRAM                       , // Cipher Length for RAM
    output wire [ 2 : 0] cTypeRAM                      , // Cipher Type for RAM
    output wire [ 3 : 0] vlanIDRAM                     , // Virtual LAN ID for RAM
    output wire [ 1 : 0] sppRAM                        , // SPP for RAM
    output wire          useDefKeyRAM                  , // Use Default Key for RAM
`ifdef RW_KEY_EXTENDED                      
    //$port_g encrWPIIntKey0Reg register.
    output wire [31 : 0] encrIntKeyRAMWord0            , // Encryption WPI integrity Key for RAM
    //$port_g encrWPIIntKey1Reg register.
    output wire [31 : 0] encrIntKeyRAMWord1            , // Encryption WPI integrity Key for RAM
    //$port_g encrWPIIntKey2Reg register.
    output wire [31 : 0] encrIntKeyRAMWord2            , // Encryption WPI integrity Key for RAM
    //$port_g encrWPIIntKey3Reg register.
    output wire [31 : 0] encrIntKeyRAMWord3            , // Encryption WPI integrity Key for RAM
`endif // RW_KEY_EXTENDED                      
    //$port_g encrRAMConfigReg register.
    output wire [ 3 : 0] nVAP                          , // Number of VAP
    output wire [ 7 : 0] staKeyEndIndex                , // STA Key End Index
    output wire [ 7 : 0] staKeyStartIndex              , // STA Key Start Index
    //$port_g ratesReg register.
    output wire [11 : 0] bssBasicRateSet               , // BSS Basic Rate Set
    //$port_g olbcReg register.
    output wire [ 7 : 0] dsssCount                     , // DSSS/CCK Count
    output wire [ 7 : 0] ofdmCount                     , // OFDM Count
    output wire [15 : 0] olbcTimer                     , // OLBC Timer
    //$port_g timings1Reg register.
    output wire [ 9 : 0] txChainDelayInMACClk          , // Transmit Chain Delay in MAC Clocks
    output wire [ 9 : 0] txRFDelayInMACClk             , // Transmit RF Delay in MAC Clocks
    output wire [ 7 : 0] macCoreClkFreq                , // MAC Core Clock Frequency
    //$port_g timings2Reg register.
    output wire [15 : 0] slotTimeInMACClk              , // This register should be programmed with the value of macCoreClkFreq * slotTime.
    output wire [ 7 : 0] slotTime                      , // This field is programmed with the aSlotTime parameter. 
    //$port_g timings3Reg register.
    output wire [ 9 : 0] rxRFDelayInMACClk             , // Receive RF Delay in MAC Clock
    output wire [ 9 : 0] macProcDelayInMACClk          , // MAC Processing Delay in MAC clocks
    //$port_g timings4Reg register.
    output wire [ 9 : 0] radioWakeUpTime               , // Radio Wakeup Time
    output wire [ 9 : 0] radioChirpTime                , // Radio Chirp Time
    output wire [ 1 : 0] wt2CryptClkRatio              , // Define the clock ratio between wtClk and macCryptClk
    //$port_g timings5Reg register.
    output wire [15 : 0] sifsBInMACClk                 , // This register should be programmed with the value of macCoreClkFreq * sifsB.
    output wire [ 7 : 0] sifsB                         , // SIFS Duration for 2.4GHz band
    //$port_g timings6Reg register.
    output wire [15 : 0] sifsAInMACClk                 , // This register should be programmed with the value of macCoreClkFreq * sifsA.
    output wire [ 7 : 0] sifsA                         , // SIFS Duration for 5GHz band
    //$port_g timings7Reg register.
    output wire [ 3 : 0] rxCCADelay                    , // Receive Chain CCA Delay
    //$port_g timings8Reg register.
    output wire [ 7 : 0] rxStartDelayMIMO              , // Receive Start Delay for MIMO
    output wire [ 7 : 0] rxStartDelayShort             , // Receive Start Delay with Short preamble
    output wire [ 7 : 0] rxStartDelayLong              , // Receive Start Delay with Long preamble
    output wire [ 7 : 0] rxStartDelayOFDM              , // Receive Start Delay for OFDM
    //$port_g timings9Reg register.
    output wire [ 9 : 0] rifsTOInMACClk                , // This register should be programmed with the value of RIFS TimeOut in terms of macCoreClk clock cycles.
    output wire [ 9 : 0] txDMAProcDlyInMACClk          , // Transmit DMA Processing Delay in MAC Clocks
    //$port_g rxCntrl2 register.
    output wire          disableRxBuffer2              , // Disable Rx Buffer 2
    output wire          dataMHStoredwithPld           , // Data Frame Mac Header Stored With Payload
    output wire          mgtMHStoredwithPld            , // Management Frame Mac Header Stored With Payload
    output wire          ctrlMHStoredwithPld           , // Control Frame Mac Header Stored With Payload
    output wire [ 7 : 0] partialUnwrapSize             , // Partial Unwrap Size
    output wire [ 1 : 0] dataFrmWrapMode               , // Data Frame Wrap Mode
    output wire [ 1 : 0] mgtFrmWrapMode                , // Management Frame Wrap Mode
    output wire [ 1 : 0] ctrlFrmWrapMode               , // Control Frame Wrap Mode
    //$port_g txTriggerTimerReg register.
    output wire [ 7 : 0] txPacketTimeout               , // Transmission Packet Timeout
    output wire [ 7 : 0] txAbsoluteTimeout             , // Transmission Absolute Timeout
    //$port_g rxTriggerTimerReg register.
    output wire [ 7 : 0] rxPacketTimeout               , // Reception Packet Timeout
    output wire [ 7 : 0] rxAbsoluteTimeout             , // Reception Absolute Timeout
    //$port_g mibTableWriteReg register.
    output wire [15 : 0] mibValue                      , // MIB Value
    output wire          mibWrite                      , // MIB Write
    output wire          mibIncrementMode              , // MIB Increment Mode
    output wire [ 9 : 0] mibTableIndex                 , // MIB Table Index
    //$port_g monotonicCounter2LoReg register.
    output wire [31 : 0] monotonicCounterLow2          , // Monotonic Counter 2
    //$port_g monotonicCounter2HiReg register.
    output wire          monotonicCounter2SWUpdate     , // Monotonic Counter 2 SW Update
    output wire [15 : 0] monotonicCounterHigh2         , // Monotonic Counter 2
    //$port_g absTimerReg0 register.
    output wire [31 : 0] absTimerValue0                , // Absolute Timer Value
    //$port_g absTimerReg1 register.
    output wire [31 : 0] absTimerValue1                , // Absolute Timer Value
    //$port_g absTimerReg2 register.
    output wire [31 : 0] absTimerValue2                , // Absolute Timer Value
    //$port_g absTimerReg3 register.
    output wire [31 : 0] absTimerValue3                , // Absolute Timer Value
    //$port_g absTimerReg4 register.
    output wire [31 : 0] absTimerValue4                , // Absolute Timer Value
    //$port_g absTimerReg5 register.
    output wire [31 : 0] absTimerValue5                , // Absolute Timer Value
    //$port_g absTimerReg6 register.
    output wire [31 : 0] absTimerValue6                , // Absolute Timer Value
    //$port_g absTimerReg7 register.
    output wire [31 : 0] absTimerValue7                , // Absolute Timer Value
    //$port_g absTimerReg8 register.
    output wire [31 : 0] absTimerValue8                , // Absolute Timer Value
    //$port_g absTimerReg9 register.
    output wire [31 : 0] absTimerValue9                , // Absolute Timer Value
    //$port_g maxRxLengthReg register.
    output wire [19 : 0] maxAllowedLength              , // Max Rx Length 
    //$port_g edcaAC0Reg register.
    output wire [15 : 0] txOpLimit0                    , // Transmit Opportunity Limit for AC 0
    output wire [ 3 : 0] cwMax0                        , // Maximum CW for AC 0
    output wire [ 3 : 0] cwMin0                        , // Minimum CW for AC 0
    output wire [ 3 : 0] aifsn0                        , // AIFSN for AC 0
    //$port_g edcaAC1Reg register.
    output wire [15 : 0] txOpLimit1                    , // Transmit Opportunity Limit for AC 1
    output wire [ 3 : 0] cwMax1                        , // Maximum CW for AC 1
    output wire [ 3 : 0] cwMin1                        , // Minimum CW for AC 1
    output wire [ 3 : 0] aifsn1                        , // AIFSN for AC 1
    //$port_g edcaAC2Reg register.
    output wire [15 : 0] txOpLimit2                    , // Transmit Opportunity Limit for AC 2
    output wire [ 3 : 0] cwMax2                        , // Maximum CW for AC 2
    output wire [ 3 : 0] cwMin2                        , // Minimum CW for AC 2
    output wire [ 3 : 0] aifsn2                        , // AIFSN for AC 2
    //$port_g edcaAC3Reg register.
    output wire [15 : 0] txOpLimit3                    , // Transmit Opportunity Limit for AC 3
    output wire [ 3 : 0] cwMax3                        , // Maximum CW for AC 3
    output wire [ 3 : 0] cwMin3                        , // Minimum CW for AC 3
    output wire [ 3 : 0] aifsn3                        , // AIFSN for AC 3
    //$port_g edcaCCABusyReg register.
    output wire [31 : 0] ccaBusyDur                    , // CCA Busy Duration
    //$port_g edcaCntrlReg register.
    output wire          keepTXOPOpen                  , // Keep TXOP Open
    output wire          remTXOPInDurField             , // Remaining TXOP Indicated in Duration Field
    output wire          sendCFEnd                     , // Send CF-End
    output wire          sendCFEndNow                  , // Send CF-End Now
    //$port_g quietElement1aReg register.
    output wire [15 : 0] quietDuration1                , // Quiet Duration 1
    output wire [ 7 : 0] quietPeriod1                  , // Quiet Period 1
    output wire [ 7 : 0] quietCount1                   , // Quiet Count 1
    //$port_g quietElement1bReg register.
    output wire [15 : 0] quietOffset1                  , // Quiet Offset 1
    //$port_g addCCABusySec20Reg register.
    output wire [31 : 0] ccaBusyDurSec20               , // CCA Busy Duration on secondary 20MHz
    //$port_g addCCABusySec40Reg register.
    output wire [31 : 0] ccaBusyDurSec40               , // CCA Busy Duration on secondary 40MHz
    //$port_g addCCABusySec80Reg register.
    output wire [31 : 0] ccaBusyDurSec80               , // CCA Busy Duration on secondary 80MHz
    //$port_g stbcCntrlReg register.
    output wire [ 6 : 0] basicSTBCMCS                  , // Basic STBC MCS
    output wire          dualCTSProt                   , // Dual-CTS Protection
    output wire [ 7 : 0] ctsSTBCDur                    , // CTS STBC Duration
    output wire [15 : 0] cfEndSTBCDur                  , // CF-End STBC Duration
    //$port_g txBWCntrlReg register.
    output wire [ 1 : 0] maxSupportedBW                , // Max Supported Bandwidth
    output wire [ 7 : 0] aPPDUMaxTime                  , // aPPDU Maximum Time
    output wire          dynBWEn                       , // Dynamic Bandwidth Enable
    output wire [ 2 : 0] numTryBWAcquisition           , // Number of Tries for Requested Bandwidth Acquisition
    output wire          dropToLowerBW                 , // Drop To Lower Bandwidth PPDU
    output wire [ 1 : 0] defaultBWTXOP                 , // Default Bandwidth TXOP
    output wire          defaultBWTXOPV                , // Default BW TXOP Valid
    //$port_g HTMCSReg register.
    output wire [ 5 : 0] bssBasicHTMCSSetUM            , // BSS Basic MCS Set for Equal Modulation
    output wire [15 : 0] bssBasicHTMCSSetEM            , // BSS Basic MCS Set for Unequal Modulation
    //$port_g VHTMCSReg register.
    output wire [15 : 0] bssBasicVHTMCSSet             , // BSS Basic VHT MCS Set
    //$port_g LSTPReg register.
    output wire          supportLSTP                   , // Support of L-SIG TXOP
    //$port_g HEConfigReg register.
    output wire          dcmSupport                    , // DCM Support
    output wire          dopplerSupport                , // Doppler Support
    output wire          enableOBSSPD                  , // Enable OBSS PD Spatial Reuse
    output wire          enableSRP                     , // Enable SRP Spatial Reuse
    output wire          acceptAllTriggerFrames        , // Accept All Trigger Frame
    output wire          acceptTriggerSWFrames         , // Accept Trigger Frame handled by SW 
    output wire          acceptTriggerHWFrames         , // Accept Trigger Frame handled by HW 
    output wire          disableTBUPH                  , // Disable UPH Control field in HE TB Response
    output wire          disableTBRU26Resp             , // Disable 26-tones RU on Trigger Based Response
    output wire          disableTBCS                   , // Disable Carrier Sense on Trigger Based Response
    output wire          disableTBResp                 , // Disable Trigger Based Response
    output wire [ 2 : 0] defaultPEDur                  , // Provide the PE default duration used for trigger based transmission in TRS
    //$port_g SPConfig1Reg register.
    output wire [ 7 : 0] srgOBSSPDMaxOffset            , // SRG OBSS PD Max Offset
    output wire [ 7 : 0] srgOBSSPDMinOffset            , // SRG OBSS PD Min Offset
    output wire [ 7 : 0] nonSRGOBSSPDMaxOffset         , // Non-SRG OBSS PD Max Offset
    output wire          srgInformationPresent         , // SRG Information Present
    output wire          nonSRGOffsetPresent           , // Non-SRG Offset Present 
    output wire          nonSRGOBSSPDSRDisallowed      , // Non-SRG OBSS PD SR Disallowed
    output wire          SRPDisallowed                 , // SRP Disallowed
    //$port_g SRGBSSColorBitmapLowReg register.
    output wire [31 : 0] SRGBSSColorBitmapLow          , // SRG BSS Color Bitmap
    //$port_g SRGBSSColorBitmapHighReg register.
    output wire [31 : 0] SRGBSSColorBitmapHigh         , // SRG BSS Color Bitmap
    //$port_g SRGPartialBSSIDBitmapLowReg register.
    output wire [31 : 0] SRGPartialBSSIDBitmapLow      , // Partial BSSID Bitmap
    //$port_g SRGPartialBSSIDBitmapHighReg register.
    output wire [31 : 0] SRGPartialBSSIDBitmapHigh     , // Partial BSSID Bitmap
`ifdef RW_BFMEE_EN                          
    //$port_g bfmeeControlReg register.
    output wire [ 1 : 0] bfrHELTFType                  , // Beamforming Report giType (HE Only)
    output wire [ 1 : 0] bfrGIType                     , // Beamforming Report HE-LTF-TYPE(HE Only)
    output wire [ 2 : 0] bfrFormatMod                  , // Beamforming Report Format Modulation
    output wire          bfrShortGI                    , // Beamforming Report Short GI
    output wire [ 7 : 0] bfrMCS                        , // Beamforming Report MCS
    output wire [ 2 : 0] bfmeeNc                       , // Beamformee Number of columns
    output wire [ 2 : 0] bfmeeNr                       , // Beamformee Number of rows
    output wire [ 1 : 0] bfmeeGrouping                 , // Beamformee Grouping
    output wire          bfmeeCodebook                 , // Beamformee Codebook
    output wire          bfmeeMUSupport                , // Beamformee MU Support
    output wire          bfmeeEnable                   , // Beamformee Enable
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      
    //$port_g CoexControlReg register.
    output wire [ 3 : 0] coexForceWlanPTI              , // Coex Force Wlan PTI output
    output wire          coexForceWlanPTIToggle        , // Coex Force Wlan PTI toggle output
    output wire          coexForceWlanChanBw           , // Coex Force Wlan Channel Bandwidth  output
    output wire          coexForceWlanRx               , // Coex Force Wlan Rx output
    output wire          coexForceWlanTx               , // Coex Force Wlan Tx output
    output wire [ 6 : 0] coexWlanChanFreq              , // Coex Wlan Channel Frequency 
    output wire          coexWlanChanOffset            , // Coex Wlan Channel offset
    output wire [ 1 : 0] coexAutoPTIAdjIncr            , // Coex Automatic PTI Adjustmnent Increment
    output wire          coexAutoPTIAdjEnable          , // Coex Automatic  PTI Adjustment Enable
    output wire          coexForceEnable               , // Coex Force Enable
    output wire          coexPostponeTxEnable          , // Coex Postpone Tx Enable
    output wire          coexPHYRxAbortEnable          , // Coex Phy Rx Abort Enable.
    output wire          coexPHYTxAbortEnable          , // Coex Phy Tx Abort Enable.
    output wire          coexEnable                    , // Coex Enable
    //$port_g CoexPTIReg register.
    output wire [ 3 : 0] coexPTIBcnData                , // Coex Packet traffic information for Data frames sent on the Beacon Channel
    output wire [ 3 : 0] coexPTIBKData                 , // Coex Packet traffic information for Data frames sent on the AC BK Channel
    output wire [ 3 : 0] coexPTIBEData                 , // Coex Packet traffic information for Data frames sent on the AC BE Channel
    output wire [ 3 : 0] coexPTIVIData                 , // Coex Packet traffic information for Data frames sent on the AC VI Channel
    output wire [ 3 : 0] coexPTIVOData                 , // Coex Packet traffic information for Data frames sent on the AC VO Channel
    output wire [ 3 : 0] coexPTIMgt                    , // Coex Packet traffic information for Management frames
    output wire [ 3 : 0] coexPTICntl                   , // Coex Packet traffic information for Control frames
    output wire [ 3 : 0] coexPTIAck                    , // Coex Packet traffic information for Ack/BA frames
    //$port_g CoexIntReg register.
    output wire          coexWlanRxAbortFallEn         , // Coex Wlan Rx Abort Falling Edge Enable
    output wire          coexWlanRxAbortRiseEn         , // Coex Wlan Rx Abort Rising Edge Enable
    output wire          coexWlanTxAbortFallEn         , // Coex Wlan Tx Abort Falling Edge Enable
    output wire          coexWlanTxAbortRiseEn         , // Coex Wlan Tx Abort Rising Edge Enable
`endif // RW_WLAN_COEX_EN                      
    //$port_g debugPortSelReg register.
    output wire [ 7 : 0] debugPortSel2                 , // Debug Port Selection 2
    output wire [ 7 : 0] debugPortSel1                 , // Debug Port Selection 1
    //$port_g debugBasicNAVReg register.
    output wire [25 : 0] basicNAVCounter               , // Basic Network Allocation Vector Counter.
    //$port_g debugCWReg register.
    output wire [ 1 : 0] backoffOffset                 , // Backoff Offset
    //$port_g debugUORAReg register.
    output wire [ 6 : 0] ocwLFSR                       , // OFDMA Contention Window LFSR
    //$port_g debugPHYReg register.
    output wire          rxEndForTimingErrRec          , // rxReq Force Deassertion
    output wire          rxReqForceDeassertion         , // rxEndForTiming Error Recovery
    //$port_g debugIntraNAVReg register.
    output wire [15 : 0] intraNAVCounter               , // Intra BSS Network Allocation Vector Counter.
            
    
    output wire          latchNextState_p  , // Next state latch
    ////////////////////////////////////////////
    //$port_g host slave IF
    ////////////////////////////////////////////
    input  wire                                 regWrite,              // Write enable
    input  wire                                 regRead,               // Read enable
    input  wire   [(`RW_REG_ADDR_WIDTH-1) : 0]  regAddr,               // Register address
    input  wire   [(`RW_REG_DATA_WIDTH-1) : 0]  regWriteData,          // Data to be written to the registers

    output wire                                 regReadyIn,            // read data valid or write completed 
    output wire   [(`RW_REG_DATA_WIDTH-1) : 0]  regReadData            // Data read from registers
    
            
);



  //////////////////////////////////////////////////////////////////////////////
  //host slave IF
  //////////////////////////////////////////////////////////////////////////////

  wire                                      plRegSel;
  reg                                       plRegSelDly;
  wire                                      coreRegSel;
  wire          [(`RW_REG_DATA_WIDTH-1):0]  plReadData;
  reg           [(`RW_REG_DATA_WIDTH-1):0]  plReadDataCapt;
  wire          [(`RW_REG_DATA_WIDTH-1):0]  coreReadData;
  wire                                      coreReadyIn;

  wire                                      postWriteWrite;
  wire                                      postWriteRead;
  wire          [(`RW_REG_DATA_WIDTH-1):0]  postWritewriteData;
  wire          [(`RW_REG_DATA_WIDTH-1):0]  postWritereadData;
  wire          [(`RW_REG_ADDR_WIDTH-2):0]  postWriteregAddr;

  wire                                      postWriteSel;
  
  //////////////////////////////////////////////////////////////////////////////
  //Registers
  //////////////////////////////////////////////////////////////////////////////
 
  //////////////////////////////////////////////////////////////////////////////
  // Ouput linkage
  //////////////////////////////////////////////////////////////////////////////
  assign plRegSel    = (regAddr[(`RW_REG_ADDR_WIDTH-1)]);
  assign coreRegSel  = ( !regAddr[(`RW_REG_ADDR_WIDTH-1)]);
  assign regReadData = plRegSelDly ? plReadDataCapt : coreReadData;
  assign regReadyIn  = coreReadyIn & !regRead;

  // sample data read from registers on macPIClk
  always @(posedge macPIClk or negedge macPIClkHardRst_n)
  begin
    if (macPIClkHardRst_n == 1'b0)
    begin
      plReadDataCapt <= `RW_REG_DATA_WIDTH'b0;
      plRegSelDly    <= 1'b0;       
    end
    else 
    begin
      plRegSelDly    <= plRegSel;       
      if (plRegSel && regRead)
        plReadDataCapt <= plReadData;
    end
  end




`ifdef ASSERT_ON

//$rw_sva Checks no write is fired while read is active
property no_write_while_read_prop; 
@(posedge macPIClk)
  disable iff(macPIClkHardRst_n==0)
  regRead |-> !regWrite;
endproperty
no_write_while_read: assert property (no_write_while_read_prop); 

//$rw_sva Checks no read is fired while write is active
property no_read_while_write_prop; 
@(posedge macPIClk)
  disable iff(macPIClkHardRst_n==0)
  regWrite |-> !regRead;
endproperty
no_read_while_write: assert property (no_write_while_read_prop); 

`endif // ASSERT_ON

// Instanciation of macPlReg
// Name of the instance : u_macPlReg
// Name of the file containing this module : macPlReg.v
macPlReg u_macPlReg (
    .hardRstClk_n                     (macPIClkHardRst_n),
    .softRstClk_n                     (macPIClkSoftRst_n),
    .Clk                              (macPIClk),
    .nextTBTT                         (nextTBTT),
    .statussettbTxDMADead             (statussettbTxDMADead),
    .statussetrxPayloadDMADead        (statussetrxPayloadDMADead),
    .statussetrxHeaderDMADead         (statussetrxHeaderDMADead),
    .statussetphyRxStart              (statussetphyRxStart),
    .statussetphyErr                  (statussetphyErr),
    .statussetmacPHYIFUnderRun        (statussetmacPHYIFUnderRun),
    .statussethwErr                   (statussethwErr),
    .statussetimpSecDTIM              (statussetimpSecDTIM),
    .statussetimpPriDTIM              (statussetimpPriDTIM),
    .statussetbcnTxDMADead            (statussetbcnTxDMADead),
    .statussetac3TxDMADead            (statussetac3TxDMADead),
    .statussetac2TxDMADead            (statussetac2TxDMADead),
    .statussetac1TxDMADead            (statussetac1TxDMADead),
    .statussetac0TxDMADead            (statussetac0TxDMADead),
    .statussetptError                 (statussetptError),
    .statussettimSet                  (statussettimSet),
    .statussetolbcDSSS                (statussetolbcDSSS),
    .statussetolbcOFDM                (statussetolbcOFDM),
    .statussetrxFIFOOverFlow          (statussetrxFIFOOverFlow),
    .statussetmacPHYIFOverflow        (statussetmacPHYIFOverflow),
    .statussetcoexEvent               (statussetcoexEvent),
    .statusabsGenTimers               (statusabsGenTimers),
    .statussetidleInterrupt           (statussetidleInterrupt),
    .statussetimpSecTBTT              (statussetimpSecTBTT),
    .statussetimpPriTBTT              (statussetimpPriTBTT),
    .statussettbTxBufTrigger          (statussettbTxBufTrigger),
    .statussetbcnTxBufTrigger         (statussetbcnTxBufTrigger),
    .statussetac3TxBufTrigger         (statussetac3TxBufTrigger),
    .statussetac2TxBufTrigger         (statussetac2TxBufTrigger),
    .statussetac1TxBufTrigger         (statussetac1TxBufTrigger),
    .statussetac0TxBufTrigger         (statussetac0TxBufTrigger),
    .statussetac3BWDropTrigger        (statussetac3BWDropTrigger),
    .statussetac2BWDropTrigger        (statussetac2BWDropTrigger),
    .statussetac1BWDropTrigger        (statussetac1BWDropTrigger),
    .statussetac0BWDropTrigger        (statussetac0BWDropTrigger),
    .statussetrxBuffer2Trigger        (statussetrxBuffer2Trigger),
    .statussettimerRxTrigger          (statussettimerRxTrigger),
    .statussetrxBuffer1Trigger        (statussetrxBuffer1Trigger),
    .statussetsecUserTxTrigger        (statussetsecUserTxTrigger),
    .statussettimerTxTrigger          (statussettimerTxTrigger),
    .statussettxopComplete            (statussettxopComplete),
    .statussettbTxCancelled           (statussettbTxCancelled),
    .statussettbTxTrigger             (statussettbTxTrigger),
    .statussetbcnTxTrigger            (statussetbcnTxTrigger),
    .statussetac3TxTrigger            (statussetac3TxTrigger),
    .statussetac2TxTrigger            (statussetac2TxTrigger),
    .statussetac1TxTrigger            (statussetac1TxTrigger),
    .statussetac0TxTrigger            (statussetac0TxTrigger),
    .statussettbProtTrigger           (statussettbProtTrigger),
    .statussetac3ProtTrigger          (statussetac3ProtTrigger),
    .statussetac2ProtTrigger          (statussetac2ProtTrigger),
    .statussetac1ProtTrigger          (statussetac1ProtTrigger),
    .statussetac0ProtTrigger          (statussetac0ProtTrigger),
    .statussetabsTimers9              (statussetabsTimers9),
    .statussetabsTimers8              (statussetabsTimers8),
    .statussetabsTimers7              (statussetabsTimers7),
    .statussetabsTimers6              (statussetabsTimers6),
    .statussetabsTimers5              (statussetabsTimers5),
    .statussetabsTimers4              (statussetabsTimers4),
    .statussetabsTimers3              (statussetabsTimers3),
    .statussetabsTimers2              (statussetabsTimers2),
    .statussetabsTimers1              (statussetabsTimers1),
    .statussetabsTimers0              (statussetabsTimers0),
    .tsfTimerLowIn                    (tsfTimerLowIn),
    .tsfTimerLowInValid               (tsfTimerLowInValid),
    .tsfTimerHighIn                   (tsfTimerHighIn),
    .tsfTimerHighInValid              (tsfTimerHighInValid),
    .computeDurationIn                (computeDurationIn),
    .computeDurationInValid           (computeDurationInValid),
    .timeOnAirValid                   (timeOnAirValid),
    .timeOnAir                        (timeOnAir),
    .statussethaltTBAfterTXOP         (statussethaltTBAfterTXOP),
    .statussethaltAC3AfterTXOP        (statussethaltAC3AfterTXOP),
    .statussethaltAC2AfterTXOP        (statussethaltAC2AfterTXOP),
    .statussethaltAC1AfterTXOP        (statussethaltAC1AfterTXOP),
    .statussethaltAC0AfterTXOP        (statussethaltAC0AfterTXOP),
    .statussethaltBcnAfterTXOP        (statussethaltBcnAfterTXOP),
    .statussettxTBNewHead             (statussettxTBNewHead),
    .statussettxAC3NewHead            (statussettxAC3NewHead),
    .statussettxAC2NewHead            (statussettxAC2NewHead),
    .statussettxAC1NewHead            (statussettxAC1NewHead),
    .statussettxAC0NewHead            (statussettxAC0NewHead),
    .statussettxBcnNewHead            (statussettxBcnNewHead),
    .statussettxAC3NewTail            (statussettxAC3NewTail),
    .statussettxAC2NewTail            (statussettxAC2NewTail),
    .statussettxAC1NewTail            (statussettxAC1NewTail),
    .statussettxAC0NewTail            (statussettxAC0NewTail),
    .statussettxBcnNewTail            (statussettxBcnNewTail),
    .txTBState                        (txTBState),
    .txAC3State                       (txAC3State),
    .txAC2State                       (txAC2State),
    .txAC1State                       (txAC1State),
    .txAC0State                       (txAC0State),
    .txBcnState                       (txBcnState),
    .txNewHeadErr                     (txNewHeadErr),
    .txBusErr                         (txBusErr),
    .txPTAddressErr                   (txPTAddressErr),
    .txNextPointerErr                 (txNextPointerErr),
    .txUPatternErr                    (txUPatternErr),
    .txLenMismatch                    (txLenMismatch),
    .rxPayBusErr                      (rxPayBusErr),
    .rxHdrBusErr                      (rxHdrBusErr),
    .txTBHaltAfterTXOP                (txTBHaltAfterTXOP),
    .txAC3HaltAfterTXOP               (txAC3HaltAfterTXOP),
    .txAC2HaltAfterTXOP               (txAC2HaltAfterTXOP),
    .txAC1HaltAfterTXOP               (txAC1HaltAfterTXOP),
    .txAC0HaltAfterTXOP               (txAC0HaltAfterTXOP),
    .txBcnHaltAfterTXOP               (txBcnHaltAfterTXOP),
    .txAC3EndQ                        (txAC3EndQ),
    .txAC2EndQ                        (txAC2EndQ),
    .txAC1EndQ                        (txAC1EndQ),
    .txAC0EndQ                        (txAC0EndQ),
    .txBcnEndQ                        (txBcnEndQ),
    .txAC3Startup                     (txAC3Startup),
    .txAC2Startup                     (txAC2Startup),
    .txAC1Startup                     (txAC1Startup),
    .txAC0Startup                     (txAC0Startup),
    .txBcnStartup                     (txBcnStartup),
    .rxHeaderTFPtr                    (rxHeaderTFPtr),
    .rxBuf1WrPtrIn                    (rxBuf1WrPtrIn),
    .rxBuf1WrPtrInValid               (rxBuf1WrPtrInValid),
    .rxBuf2WrPtrIn                    (rxBuf2WrPtrIn),
    .rxBuf2WrPtrInValid               (rxBuf2WrPtrInValid),
    .ac1MOT                           (ac1MOT),
    .ac0MOT                           (ac0MOT),
    .ac3MOT                           (ac3MOT),
    .ac2MOT                           (ac2MOT),
    .txBWAfterDrop                    (txBWAfterDrop),
    .eOCWIn                           (eOCWIn),
    .eOCWInValid                      (eOCWInValid),
    .txHETBRemDur                     (txHETBRemDur),
    .ulDoppler                        (ulDoppler),
    .ulPEDisambiguity                 (ulPEDisambiguity),
    .ulPreFecPadding                  (ulPreFecPadding),
    .ulLDPCExtrSymb                   (ulLDPCExtrSymb),
    .ulSTBC                           (ulSTBC),
    .ulNLTFAndMidamble                (ulNLTFAndMidamble),
    .ulMULTFMode                      (ulMULTFMode),
    .ulGILTFType                      (ulGILTFType),
    .ulBW                             (ulBW),
    .ulLength                         (ulLength),
    .ulTriggerType                    (ulTriggerType),
    .tdUserInfoSubfield               (tdUserInfoSubfield),
    .ulRUType                         (ulRUType),
    .ulNSS                            (ulNSS),
    .ulDCM                            (ulDCM),
    .ulMCS                            (ulMCS),
    .ulFECCoding                      (ulFECCoding),
    .ulRUSize                         (ulRUSize),
    .ulPSDULenValid                   (ulPSDULenValid),
    .ulPSDULen                        (ulPSDULen),
    .heTBUPHControl                   (heTBUPHControl),
    .ulTargetRSSI                     (ulTargetRSSI),
    .apTXPower                        (apTXPower),
  `ifdef RW_MUMIMO_TX_EN                     
    .statussetsecU3ac3TxBufTrigger    (statussetsecU3ac3TxBufTrigger),
    .statussetsecU3ac2TxBufTrigger    (statussetsecU3ac2TxBufTrigger),
    .statussetsecU3ac1TxBufTrigger    (statussetsecU3ac1TxBufTrigger),
    .statussetsecU3ac0TxBufTrigger    (statussetsecU3ac0TxBufTrigger),
    .statussetsecU3ac3TxTrigger       (statussetsecU3ac3TxTrigger),
    .statussetsecU3ac2TxTrigger       (statussetsecU3ac2TxTrigger),
    .statussetsecU3ac1TxTrigger       (statussetsecU3ac1TxTrigger),
    .statussetsecU3ac0TxTrigger       (statussetsecU3ac0TxTrigger),
    .statussetsecU2ac3TxBufTrigger    (statussetsecU2ac3TxBufTrigger),
    .statussetsecU2ac2TxBufTrigger    (statussetsecU2ac2TxBufTrigger),
    .statussetsecU2ac1TxBufTrigger    (statussetsecU2ac1TxBufTrigger),
    .statussetsecU2ac0TxBufTrigger    (statussetsecU2ac0TxBufTrigger),
    .statussetsecU2ac3TxTrigger       (statussetsecU2ac3TxTrigger),
    .statussetsecU2ac2TxTrigger       (statussetsecU2ac2TxTrigger),
    .statussetsecU2ac1TxTrigger       (statussetsecU2ac1TxTrigger),
    .statussetsecU2ac0TxTrigger       (statussetsecU2ac0TxTrigger),
    .statussetsecU1ac3TxBufTrigger    (statussetsecU1ac3TxBufTrigger),
    .statussetsecU1ac2TxBufTrigger    (statussetsecU1ac2TxBufTrigger),
    .statussetsecU1ac1TxBufTrigger    (statussetsecU1ac1TxBufTrigger),
    .statussetsecU1ac0TxBufTrigger    (statussetsecU1ac0TxBufTrigger),
    .statussetsecU1ac3TxTrigger       (statussetsecU1ac3TxTrigger),
    .statussetsecU1ac2TxTrigger       (statussetsecU1ac2TxTrigger),
    .statussetsecU1ac1TxTrigger       (statussetsecU1ac1TxTrigger),
    .statussetsecU1ac0TxTrigger       (statussetsecU1ac0TxTrigger),
  `endif // RW_MUMIMO_TX_EN                     
    .bcnStatusPointer                 (bcnStatusPointer),
    .ac0StatusPointer                 (ac0StatusPointer),
    .ac1StatusPointer                 (ac1StatusPointer),
    .ac2StatusPointer                 (ac2StatusPointer),
    .ac3StatusPointer                 (ac3StatusPointer),
    .tbStatusPointer                  (tbStatusPointer),
    .txCurrentPointer                 (txCurrentPointer),
    .swProf31In                       (swProf31In),
    .swProf31InValid                  (swProf31InValid),
    .swProf30In                       (swProf30In),
    .swProf30InValid                  (swProf30InValid),
    .swProf29In                       (swProf29In),
    .swProf29InValid                  (swProf29InValid),
    .swProf28In                       (swProf28In),
    .swProf28InValid                  (swProf28InValid),
    .swProf27In                       (swProf27In),
    .swProf27InValid                  (swProf27InValid),
    .swProf26In                       (swProf26In),
    .swProf26InValid                  (swProf26InValid),
    .swProf25In                       (swProf25In),
    .swProf25InValid                  (swProf25InValid),
    .swProf24In                       (swProf24In),
    .swProf24InValid                  (swProf24InValid),
    .swProf23In                       (swProf23In),
    .swProf23InValid                  (swProf23InValid),
    .swProf22In                       (swProf22In),
    .swProf22InValid                  (swProf22InValid),
    .swProf21In                       (swProf21In),
    .swProf21InValid                  (swProf21InValid),
    .swProf20In                       (swProf20In),
    .swProf20InValid                  (swProf20InValid),
    .swProf19In                       (swProf19In),
    .swProf19InValid                  (swProf19InValid),
    .swProf18In                       (swProf18In),
    .swProf18InValid                  (swProf18InValid),
    .swProf17In                       (swProf17In),
    .swProf17InValid                  (swProf17InValid),
    .swProf16In                       (swProf16In),
    .swProf16InValid                  (swProf16InValid),
    .swProf15In                       (swProf15In),
    .swProf15InValid                  (swProf15InValid),
    .swProf14In                       (swProf14In),
    .swProf14InValid                  (swProf14InValid),
    .swProf13In                       (swProf13In),
    .swProf13InValid                  (swProf13InValid),
    .swProf12In                       (swProf12In),
    .swProf12InValid                  (swProf12InValid),
    .swProf11In                       (swProf11In),
    .swProf11InValid                  (swProf11InValid),
    .swProf10In                       (swProf10In),
    .swProf10InValid                  (swProf10InValid),
    .swProf9In                        (swProf9In),
    .swProf9InValid                   (swProf9InValid),
    .swProf8In                        (swProf8In),
    .swProf8InValid                   (swProf8InValid),
    .swProf7In                        (swProf7In),
    .swProf7InValid                   (swProf7InValid),
    .swProf6In                        (swProf6In),
    .swProf6InValid                   (swProf6InValid),
    .swProf5In                        (swProf5In),
    .swProf5InValid                   (swProf5InValid),
    .swProf4In                        (swProf4In),
    .swProf4InValid                   (swProf4InValid),
    .swProf3In                        (swProf3In),
    .swProf3InValid                   (swProf3InValid),
    .swProf2In                        (swProf2In),
    .swProf2InValid                   (swProf2InValid),
    .swProf1In                        (swProf1In),
    .swProf1InValid                   (swProf1InValid),
    .swProf0In                        (swProf0In),
    .swProf0InValid                   (swProf0InValid),
    .statusswSetProf31                (statusswSetProf31),
    .statusswSetProf30                (statusswSetProf30),
    .statusswSetProf29                (statusswSetProf29),
    .statusswSetProf28                (statusswSetProf28),
    .statusswSetProf27                (statusswSetProf27),
    .statusswSetProf26                (statusswSetProf26),
    .statusswSetProf25                (statusswSetProf25),
    .statusswSetProf24                (statusswSetProf24),
    .statusswSetProf23                (statusswSetProf23),
    .statusswSetProf22                (statusswSetProf22),
    .statusswSetProf21                (statusswSetProf21),
    .statusswSetProf20                (statusswSetProf20),
    .statusswSetProf19                (statusswSetProf19),
    .statusswSetProf18                (statusswSetProf18),
    .statusswSetProf17                (statusswSetProf17),
    .statusswSetProf16                (statusswSetProf16),
    .statusswSetProf15                (statusswSetProf15),
    .statusswSetProf14                (statusswSetProf14),
    .statusswSetProf13                (statusswSetProf13),
    .statusswSetProf12                (statusswSetProf12),
    .statusswSetProf11                (statusswSetProf11),
    .statusswSetProf10                (statusswSetProf10),
    .statusswSetProf9                 (statusswSetProf9),
    .statusswSetProf8                 (statusswSetProf8),
    .statusswSetProf7                 (statusswSetProf7),
    .statusswSetProf6                 (statusswSetProf6),
    .statusswSetProf5                 (statusswSetProf5),
    .statusswSetProf4                 (statusswSetProf4),
    .statusswSetProf3                 (statusswSetProf3),
    .statusswSetProf2                 (statusswSetProf2),
    .statusswSetProf1                 (statusswSetProf1),
    .statusswSetProf0                 (statusswSetProf0),
    .swProf63In                       (swProf63In),
    .swProf63InValid                  (swProf63InValid),
    .swProf62In                       (swProf62In),
    .swProf62InValid                  (swProf62InValid),
    .swProf61In                       (swProf61In),
    .swProf61InValid                  (swProf61InValid),
    .swProf60In                       (swProf60In),
    .swProf60InValid                  (swProf60InValid),
    .swProf59In                       (swProf59In),
    .swProf59InValid                  (swProf59InValid),
    .swProf58In                       (swProf58In),
    .swProf58InValid                  (swProf58InValid),
    .swProf57In                       (swProf57In),
    .swProf57InValid                  (swProf57InValid),
    .swProf56In                       (swProf56In),
    .swProf56InValid                  (swProf56InValid),
    .swProf55In                       (swProf55In),
    .swProf55InValid                  (swProf55InValid),
    .swProf54In                       (swProf54In),
    .swProf54InValid                  (swProf54InValid),
    .swProf53In                       (swProf53In),
    .swProf53InValid                  (swProf53InValid),
    .swProf52In                       (swProf52In),
    .swProf52InValid                  (swProf52InValid),
    .swProf51In                       (swProf51In),
    .swProf51InValid                  (swProf51InValid),
    .swProf50In                       (swProf50In),
    .swProf50InValid                  (swProf50InValid),
    .swProf49In                       (swProf49In),
    .swProf49InValid                  (swProf49InValid),
    .swProf48In                       (swProf48In),
    .swProf48InValid                  (swProf48InValid),
    .swProf47In                       (swProf47In),
    .swProf47InValid                  (swProf47InValid),
    .swProf46In                       (swProf46In),
    .swProf46InValid                  (swProf46InValid),
    .swProf45In                       (swProf45In),
    .swProf45InValid                  (swProf45InValid),
    .swProf44In                       (swProf44In),
    .swProf44InValid                  (swProf44InValid),
    .swProf43In                       (swProf43In),
    .swProf43InValid                  (swProf43InValid),
    .swProf42In                       (swProf42In),
    .swProf42InValid                  (swProf42InValid),
    .swProf41In                       (swProf41In),
    .swProf41InValid                  (swProf41InValid),
    .swProf40In                       (swProf40In),
    .swProf40InValid                  (swProf40InValid),
    .swProf39In                       (swProf39In),
    .swProf39InValid                  (swProf39InValid),
    .swProf38In                       (swProf38In),
    .swProf38InValid                  (swProf38InValid),
    .swProf37In                       (swProf37In),
    .swProf37InValid                  (swProf37InValid),
    .swProf36In                       (swProf36In),
    .swProf36InValid                  (swProf36InValid),
    .swProf35In                       (swProf35In),
    .swProf35InValid                  (swProf35InValid),
    .swProf34In                       (swProf34In),
    .swProf34InValid                  (swProf34InValid),
    .swProf33In                       (swProf33In),
    .swProf33InValid                  (swProf33InValid),
    .swProf32In                       (swProf32In),
    .swProf32InValid                  (swProf32InValid),
    .statusswSetProf63                (statusswSetProf63),
    .statusswSetProf62                (statusswSetProf62),
    .statusswSetProf61                (statusswSetProf61),
    .statusswSetProf60                (statusswSetProf60),
    .statusswSetProf59                (statusswSetProf59),
    .statusswSetProf58                (statusswSetProf58),
    .statusswSetProf57                (statusswSetProf57),
    .statusswSetProf56                (statusswSetProf56),
    .statusswSetProf55                (statusswSetProf55),
    .statusswSetProf54                (statusswSetProf54),
    .statusswSetProf53                (statusswSetProf53),
    .statusswSetProf52                (statusswSetProf52),
    .statusswSetProf51                (statusswSetProf51),
    .statusswSetProf50                (statusswSetProf50),
    .statusswSetProf49                (statusswSetProf49),
    .statusswSetProf48                (statusswSetProf48),
    .statusswSetProf47                (statusswSetProf47),
    .statusswSetProf46                (statusswSetProf46),
    .statusswSetProf45                (statusswSetProf45),
    .statusswSetProf44                (statusswSetProf44),
    .statusswSetProf43                (statusswSetProf43),
    .statusswSetProf42                (statusswSetProf42),
    .statusswSetProf41                (statusswSetProf41),
    .statusswSetProf40                (statusswSetProf40),
    .statusswSetProf39                (statusswSetProf39),
    .statusswSetProf38                (statusswSetProf38),
    .statusswSetProf37                (statusswSetProf37),
    .statusswSetProf36                (statusswSetProf36),
    .statusswSetProf35                (statusswSetProf35),
    .statusswSetProf34                (statusswSetProf34),
    .statusswSetProf33                (statusswSetProf33),
    .statusswSetProf32                (statusswSetProf32),
  `ifdef RW_MUMIMO_SEC_USER1_EN              
    .secU1TxCurrentPointer            (secU1TxCurrentPointer),
  `endif // RW_MUMIMO_SEC_USER1_EN              
  `ifdef RW_MUMIMO_SEC_USER2_EN              
    .secU2TxCurrentPointer            (secU2TxCurrentPointer),
  `endif // RW_MUMIMO_SEC_USER2_EN              
  `ifdef RW_MUMIMO_SEC_USER3_EN              
    .secU3TxCurrentPointer            (secU3TxCurrentPointer),
  `endif // RW_MUMIMO_SEC_USER3_EN              
    .wakeUpFromDoze                   (wakeUpFromDoze),
    .wakeUpSW                         (wakeUpSW),
    .softReset                        (softReset),
    .settbTxDMADead                   (settbTxDMADead),
    .setrxPayloadDMADead              (setrxPayloadDMADead),
    .setrxHeaderDMADead               (setrxHeaderDMADead),
    .setphyRxStart                    (setphyRxStart),
    .setphyErr                        (setphyErr),
    .setmacPHYIFUnderRun              (setmacPHYIFUnderRun),
    .sethwErr                         (sethwErr),
    .setimpSecDTIM                    (setimpSecDTIM),
    .setimpPriDTIM                    (setimpPriDTIM),
    .setbcnTxDMADead                  (setbcnTxDMADead),
    .setac3TxDMADead                  (setac3TxDMADead),
    .setac2TxDMADead                  (setac2TxDMADead),
    .setac1TxDMADead                  (setac1TxDMADead),
    .setac0TxDMADead                  (setac0TxDMADead),
    .setptError                       (setptError),
    .settimSet                        (settimSet),
    .setolbcDSSS                      (setolbcDSSS),
    .setolbcOFDM                      (setolbcOFDM),
    .setrxFIFOOverFlow                (setrxFIFOOverFlow),
    .setmacPHYIFOverflow              (setmacPHYIFOverflow),
    .setcoexEvent                     (setcoexEvent),
    .absGenTimers                     (absGenTimers),
    .setidleInterrupt                 (setidleInterrupt),
    .setimpSecTBTT                    (setimpSecTBTT),
    .setimpPriTBTT                    (setimpPriTBTT),
    .cleartbTxDMADead                 (cleartbTxDMADead),
    .clearrxPayloadDMADead            (clearrxPayloadDMADead),
    .clearrxHeaderDMADead             (clearrxHeaderDMADead),
    .clearphyRxStart                  (clearphyRxStart),
    .clearphyErr                      (clearphyErr),
    .clearmacPHYIFUnderRun            (clearmacPHYIFUnderRun),
    .clearhwErr                       (clearhwErr),
    .clearimpSecDTIM                  (clearimpSecDTIM),
    .clearimpPriDTIM                  (clearimpPriDTIM),
    .clearbcnTxDMADead                (clearbcnTxDMADead),
    .clearac3TxDMADead                (clearac3TxDMADead),
    .clearac2TxDMADead                (clearac2TxDMADead),
    .clearac1TxDMADead                (clearac1TxDMADead),
    .clearac0TxDMADead                (clearac0TxDMADead),
    .clearptError                     (clearptError),
    .cleartimSet                      (cleartimSet),
    .clearolbcDSSS                    (clearolbcDSSS),
    .clearolbcOFDM                    (clearolbcOFDM),
    .clearrxFIFOOverFlow              (clearrxFIFOOverFlow),
    .clearmacPHYIFOverflow            (clearmacPHYIFOverflow),
    .clearcoexEvent                   (clearcoexEvent),
    .clearidleInterrupt               (clearidleInterrupt),
    .clearimpSecTBTT                  (clearimpSecTBTT),
    .clearimpPriTBTT                  (clearimpPriTBTT),
    .masterGenIntEn                   (masterGenIntEn),
    .masktbTxDMADead                  (masktbTxDMADead),
    .maskrxPayloadDMADead             (maskrxPayloadDMADead),
    .maskrxHeaderDMADead              (maskrxHeaderDMADead),
    .maskphyRxStart                   (maskphyRxStart),
    .maskphyErr                       (maskphyErr),
    .maskmacPHYIFUnderRun             (maskmacPHYIFUnderRun),
    .maskhwErr                        (maskhwErr),
    .maskimpSecDTIM                   (maskimpSecDTIM),
    .maskimpPriDTIM                   (maskimpPriDTIM),
    .maskbcnTxDMADead                 (maskbcnTxDMADead),
    .maskac3TxDMADead                 (maskac3TxDMADead),
    .maskac2TxDMADead                 (maskac2TxDMADead),
    .maskac1TxDMADead                 (maskac1TxDMADead),
    .maskac0TxDMADead                 (maskac0TxDMADead),
    .maskptError                      (maskptError),
    .masktimSet                       (masktimSet),
    .maskolbcDSSS                     (maskolbcDSSS),
    .maskolbcOFDM                     (maskolbcOFDM),
    .maskrxFIFOOverFlow               (maskrxFIFOOverFlow),
    .maskmacPHYIFOverflow             (maskmacPHYIFOverflow),
    .maskcoexEvent                    (maskcoexEvent),
    .maskabsGenTimers                 (maskabsGenTimers),
    .maskidleInterrupt                (maskidleInterrupt),
    .maskimpSecTBTT                   (maskimpSecTBTT),
    .maskimpPriTBTT                   (maskimpPriTBTT),
    .settbTxBufTrigger                (settbTxBufTrigger),
    .setbcnTxBufTrigger               (setbcnTxBufTrigger),
    .setac3TxBufTrigger               (setac3TxBufTrigger),
    .setac2TxBufTrigger               (setac2TxBufTrigger),
    .setac1TxBufTrigger               (setac1TxBufTrigger),
    .setac0TxBufTrigger               (setac0TxBufTrigger),
    .setac3BWDropTrigger              (setac3BWDropTrigger),
    .setac2BWDropTrigger              (setac2BWDropTrigger),
    .setac1BWDropTrigger              (setac1BWDropTrigger),
    .setac0BWDropTrigger              (setac0BWDropTrigger),
    .setrxBuffer2Trigger              (setrxBuffer2Trigger),
    .settimerRxTrigger                (settimerRxTrigger),
    .setrxBuffer1Trigger              (setrxBuffer1Trigger),
    .setsecUserTxTrigger              (setsecUserTxTrigger),
    .settimerTxTrigger                (settimerTxTrigger),
    .settxopComplete                  (settxopComplete),
    .settbTxCancelled                 (settbTxCancelled),
    .settbTxTrigger                   (settbTxTrigger),
    .setbcnTxTrigger                  (setbcnTxTrigger),
    .setac3TxTrigger                  (setac3TxTrigger),
    .setac2TxTrigger                  (setac2TxTrigger),
    .setac1TxTrigger                  (setac1TxTrigger),
    .setac0TxTrigger                  (setac0TxTrigger),
    .settbProtTrigger                 (settbProtTrigger),
    .setac3ProtTrigger                (setac3ProtTrigger),
    .setac2ProtTrigger                (setac2ProtTrigger),
    .setac1ProtTrigger                (setac1ProtTrigger),
    .setac0ProtTrigger                (setac0ProtTrigger),
    .cleartbTxBufTrigger              (cleartbTxBufTrigger),
    .clearbcnTxBufTrigger             (clearbcnTxBufTrigger),
    .clearac3TxBufTrigger             (clearac3TxBufTrigger),
    .clearac2TxBufTrigger             (clearac2TxBufTrigger),
    .clearac1TxBufTrigger             (clearac1TxBufTrigger),
    .clearac0TxBufTrigger             (clearac0TxBufTrigger),
    .clearac3BWDropTrigger            (clearac3BWDropTrigger),
    .clearac2BWDropTrigger            (clearac2BWDropTrigger),
    .clearac1BWDropTrigger            (clearac1BWDropTrigger),
    .clearac0BWDropTrigger            (clearac0BWDropTrigger),
    .clearrxBuffer2Trigger            (clearrxBuffer2Trigger),
    .cleartimerRxTrigger              (cleartimerRxTrigger),
    .clearrxBuffer1Trigger            (clearrxBuffer1Trigger),
    .cleartimerTxTrigger              (cleartimerTxTrigger),
    .cleartxopComplete                (cleartxopComplete),
    .cleartbTxCancelled               (cleartbTxCancelled),
    .cleartbTxTrigger                 (cleartbTxTrigger),
    .clearbcnTxTrigger                (clearbcnTxTrigger),
    .clearac3TxTrigger                (clearac3TxTrigger),
    .clearac2TxTrigger                (clearac2TxTrigger),
    .clearac1TxTrigger                (clearac1TxTrigger),
    .clearac0TxTrigger                (clearac0TxTrigger),
    .cleartbProtTrigger               (cleartbProtTrigger),
    .clearac3ProtTrigger              (clearac3ProtTrigger),
    .clearac2ProtTrigger              (clearac2ProtTrigger),
    .clearac1ProtTrigger              (clearac1ProtTrigger),
    .clearac0ProtTrigger              (clearac0ProtTrigger),
    .masterTxRxIntEn                  (masterTxRxIntEn),
    .masktbTxBufTrigger               (masktbTxBufTrigger),
    .maskbcnTxBufTrigger              (maskbcnTxBufTrigger),
    .maskac3TxBufTrigger              (maskac3TxBufTrigger),
    .maskac2TxBufTrigger              (maskac2TxBufTrigger),
    .maskac1TxBufTrigger              (maskac1TxBufTrigger),
    .maskac0TxBufTrigger              (maskac0TxBufTrigger),
    .maskac3BWDropTrigger             (maskac3BWDropTrigger),
    .maskac2BWDropTrigger             (maskac2BWDropTrigger),
    .maskac1BWDropTrigger             (maskac1BWDropTrigger),
    .maskac0BWDropTrigger             (maskac0BWDropTrigger),
    .maskrxBuffer2Trigger             (maskrxBuffer2Trigger),
    .masktimerRxTrigger               (masktimerRxTrigger),
    .maskrxBuffer1Trigger             (maskrxBuffer1Trigger),
    .masksecUserTxTrigger             (masksecUserTxTrigger),
    .masktimerTxTrigger               (masktimerTxTrigger),
    .masktxopComplete                 (masktxopComplete),
    .masktbTxCancelled                (masktbTxCancelled),
    .masktbTxTrigger                  (masktbTxTrigger),
    .maskbcnTxTrigger                 (maskbcnTxTrigger),
    .maskac3TxTrigger                 (maskac3TxTrigger),
    .maskac2TxTrigger                 (maskac2TxTrigger),
    .maskac1TxTrigger                 (maskac1TxTrigger),
    .maskac0TxTrigger                 (maskac0TxTrigger),
    .masktbProtTrigger                (masktbProtTrigger),
    .maskac3ProtTrigger               (maskac3ProtTrigger),
    .maskac2ProtTrigger               (maskac2ProtTrigger),
    .maskac1ProtTrigger               (maskac1ProtTrigger),
    .maskac0ProtTrigger               (maskac0ProtTrigger),
    .setabsTimers9                    (setabsTimers9),
    .setabsTimers8                    (setabsTimers8),
    .setabsTimers7                    (setabsTimers7),
    .setabsTimers6                    (setabsTimers6),
    .setabsTimers5                    (setabsTimers5),
    .setabsTimers4                    (setabsTimers4),
    .setabsTimers3                    (setabsTimers3),
    .setabsTimers2                    (setabsTimers2),
    .setabsTimers1                    (setabsTimers1),
    .setabsTimers0                    (setabsTimers0),
    .clearabsTimers9                  (clearabsTimers9),
    .clearabsTimers8                  (clearabsTimers8),
    .clearabsTimers7                  (clearabsTimers7),
    .clearabsTimers6                  (clearabsTimers6),
    .clearabsTimers5                  (clearabsTimers5),
    .clearabsTimers4                  (clearabsTimers4),
    .clearabsTimers3                  (clearabsTimers3),
    .clearabsTimers2                  (clearabsTimers2),
    .clearabsTimers1                  (clearabsTimers1),
    .clearabsTimers0                  (clearabsTimers0),
    .maskabsTimers9                   (maskabsTimers9),
    .maskabsTimers8                   (maskabsTimers8),
    .maskabsTimers7                   (maskabsTimers7),
    .maskabsTimers6                   (maskabsTimers6),
    .maskabsTimers5                   (maskabsTimers5),
    .maskabsTimers4                   (maskabsTimers4),
    .maskabsTimers3                   (maskabsTimers3),
    .maskabsTimers2                   (maskabsTimers2),
    .maskabsTimers1                   (maskabsTimers1),
    .maskabsTimers0                   (maskabsTimers0),
    .tsfTimerLow                      (tsfTimerLow),
    .tsfTimerHigh                     (tsfTimerHigh),
    .ppduSTBC                         (ppduSTBC),
    .ppduNumExtnSS                    (ppduNumExtnSS),
    .ppduBW                           (ppduBW),
    .ppduGI                           (ppduGI),
    .ppduPreType                      (ppduPreType),
    .ppduLength                       (ppduLength),
    .ppduNumHeLtf                     (ppduNumHeLtf),
    .ppduNUser                        (ppduNUser),
    .ppduPE                           (ppduPE),
    .ppduMCSSigB                      (ppduMCSSigB),
    .ppduDCMSigB                      (ppduDCMSigB),
    .ppduSigBCompMode                 (ppduSigBCompMode),
    .ppduHELTFType                    (ppduHELTFType),
    .ppduDCM                          (ppduDCM),
    .ppduMCSIndex                     (ppduMCSIndex),
    .ppduRuType                       (ppduRuType),
    .ppduMma                          (ppduMma),
    .ppduDoppler                      (ppduDoppler),
    .computeDuration                  (computeDuration),
    .sethaltTBAfterTXOP               (sethaltTBAfterTXOP),
    .sethaltAC3AfterTXOP              (sethaltAC3AfterTXOP),
    .sethaltAC2AfterTXOP              (sethaltAC2AfterTXOP),
    .sethaltAC1AfterTXOP              (sethaltAC1AfterTXOP),
    .sethaltAC0AfterTXOP              (sethaltAC0AfterTXOP),
    .sethaltBcnAfterTXOP              (sethaltBcnAfterTXOP),
    .settxTBNewHead                   (settxTBNewHead),
    .settxAC3NewHead                  (settxAC3NewHead),
    .settxAC2NewHead                  (settxAC2NewHead),
    .settxAC1NewHead                  (settxAC1NewHead),
    .settxAC0NewHead                  (settxAC0NewHead),
    .settxBcnNewHead                  (settxBcnNewHead),
    .settxAC3NewTail                  (settxAC3NewTail),
    .settxAC2NewTail                  (settxAC2NewTail),
    .settxAC1NewTail                  (settxAC1NewTail),
    .settxAC0NewTail                  (settxAC0NewTail),
    .settxBcnNewTail                  (settxBcnNewTail),
    .clearhaltTBAfterTXOP             (clearhaltTBAfterTXOP),
    .clearhaltAC3AfterTXOP            (clearhaltAC3AfterTXOP),
    .clearhaltAC2AfterTXOP            (clearhaltAC2AfterTXOP),
    .clearhaltAC1AfterTXOP            (clearhaltAC1AfterTXOP),
    .clearhaltAC0AfterTXOP            (clearhaltAC0AfterTXOP),
    .clearhaltBcnAfterTXOP            (clearhaltBcnAfterTXOP),
    .cleartxTBNewHead                 (cleartxTBNewHead),
    .cleartxAC3NewHead                (cleartxAC3NewHead),
    .cleartxAC2NewHead                (cleartxAC2NewHead),
    .cleartxAC1NewHead                (cleartxAC1NewHead),
    .cleartxAC0NewHead                (cleartxAC0NewHead),
    .cleartxBcnNewHead                (cleartxBcnNewHead),
    .cleartxAC3NewTail                (cleartxAC3NewTail),
    .cleartxAC2NewTail                (cleartxAC2NewTail),
    .cleartxAC1NewTail                (cleartxAC1NewTail),
    .cleartxAC0NewTail                (cleartxAC0NewTail),
    .cleartxBcnNewTail                (cleartxBcnNewTail),
    .txBcnHeadPtr                     (txBcnHeadPtr),
    .txAC0HeadPtr                     (txAC0HeadPtr),
    .txAC1HeadPtr                     (txAC1HeadPtr),
    .txAC2HeadPtr                     (txAC2HeadPtr),
    .txAC3HeadPtr                     (txAC3HeadPtr),
    .txTBHeadPtr                      (txTBHeadPtr),
    .dmaRBDSize                       (dmaRBDSize),
    .dmaRHDSize                       (dmaRHDSize),
    .dmaTBDSize                       (dmaTBDSize),
    .dmaTHDSize                       (dmaTHDSize),
    .ptEntrySize                      (ptEntrySize),
    .rxFIFOThreshold                  (rxFIFOThreshold),
    .txFIFOThreshold                  (txFIFOThreshold),
    .rxBuf1StartPtr                   (rxBuf1StartPtr),
    .rxBuf1EndPtr                     (rxBuf1EndPtr),
    .rxBuf1RdPtr                      (rxBuf1RdPtr),
    .rxBuf1WrPtr                      (rxBuf1WrPtr),
    .rxBuf2StartPtr                   (rxBuf2StartPtr),
    .rxBuf2EndPtr                     (rxBuf2EndPtr),
    .rxBuf2RdPtr                      (rxBuf2RdPtr),
    .rxBuf2WrPtr                      (rxBuf2WrPtr),
    .rxBufRPDFooter                   (rxBufRPDFooter),
    .rxBufRPDHeader                   (rxBufRPDHeader),
    .rxBufRHDFooter                   (rxBufRHDFooter),
    .rxBufRHDHeader                   (rxBufRHDHeader),
    .maxMCSInHETB                     (maxMCSInHETB),
    .eOCW                             (eOCW),
    .eOCWMin                          (eOCWMin),
    .raRUType                         (raRUType),
    .raRUEnable                       (raRUEnable),
    .txHETBMaxDur                     (txHETBMaxDur),
  `ifdef RW_MUMIMO_TX_EN                     
    .setsecU3ac3TxBufTrigger          (setsecU3ac3TxBufTrigger),
    .setsecU3ac2TxBufTrigger          (setsecU3ac2TxBufTrigger),
    .setsecU3ac1TxBufTrigger          (setsecU3ac1TxBufTrigger),
    .setsecU3ac0TxBufTrigger          (setsecU3ac0TxBufTrigger),
    .setsecU3ac3TxTrigger             (setsecU3ac3TxTrigger),
    .setsecU3ac2TxTrigger             (setsecU3ac2TxTrigger),
    .setsecU3ac1TxTrigger             (setsecU3ac1TxTrigger),
    .setsecU3ac0TxTrigger             (setsecU3ac0TxTrigger),
    .setsecU2ac3TxBufTrigger          (setsecU2ac3TxBufTrigger),
    .setsecU2ac2TxBufTrigger          (setsecU2ac2TxBufTrigger),
    .setsecU2ac1TxBufTrigger          (setsecU2ac1TxBufTrigger),
    .setsecU2ac0TxBufTrigger          (setsecU2ac0TxBufTrigger),
    .setsecU2ac3TxTrigger             (setsecU2ac3TxTrigger),
    .setsecU2ac2TxTrigger             (setsecU2ac2TxTrigger),
    .setsecU2ac1TxTrigger             (setsecU2ac1TxTrigger),
    .setsecU2ac0TxTrigger             (setsecU2ac0TxTrigger),
    .setsecU1ac3TxBufTrigger          (setsecU1ac3TxBufTrigger),
    .setsecU1ac2TxBufTrigger          (setsecU1ac2TxBufTrigger),
    .setsecU1ac1TxBufTrigger          (setsecU1ac1TxBufTrigger),
    .setsecU1ac0TxBufTrigger          (setsecU1ac0TxBufTrigger),
    .setsecU1ac3TxTrigger             (setsecU1ac3TxTrigger),
    .setsecU1ac2TxTrigger             (setsecU1ac2TxTrigger),
    .setsecU1ac1TxTrigger             (setsecU1ac1TxTrigger),
    .setsecU1ac0TxTrigger             (setsecU1ac0TxTrigger),
    .clearsecU3ac3TxBufTrigger        (clearsecU3ac3TxBufTrigger),
    .clearsecU3ac2TxBufTrigger        (clearsecU3ac2TxBufTrigger),
    .clearsecU3ac1TxBufTrigger        (clearsecU3ac1TxBufTrigger),
    .clearsecU3ac0TxBufTrigger        (clearsecU3ac0TxBufTrigger),
    .clearsecU3ac3TxTrigger           (clearsecU3ac3TxTrigger),
    .clearsecU3ac2TxTrigger           (clearsecU3ac2TxTrigger),
    .clearsecU3ac1TxTrigger           (clearsecU3ac1TxTrigger),
    .clearsecU3ac0TxTrigger           (clearsecU3ac0TxTrigger),
    .clearsecU2ac3TxBufTrigger        (clearsecU2ac3TxBufTrigger),
    .clearsecU2ac2TxBufTrigger        (clearsecU2ac2TxBufTrigger),
    .clearsecU2ac1TxBufTrigger        (clearsecU2ac1TxBufTrigger),
    .clearsecU2ac0TxBufTrigger        (clearsecU2ac0TxBufTrigger),
    .clearsecU2ac3TxTrigger           (clearsecU2ac3TxTrigger),
    .clearsecU2ac2TxTrigger           (clearsecU2ac2TxTrigger),
    .clearsecU2ac1TxTrigger           (clearsecU2ac1TxTrigger),
    .clearsecU2ac0TxTrigger           (clearsecU2ac0TxTrigger),
    .clearsecU1ac3TxBufTrigger        (clearsecU1ac3TxBufTrigger),
    .clearsecU1ac2TxBufTrigger        (clearsecU1ac2TxBufTrigger),
    .clearsecU1ac1TxBufTrigger        (clearsecU1ac1TxBufTrigger),
    .clearsecU1ac0TxBufTrigger        (clearsecU1ac0TxBufTrigger),
    .clearsecU1ac3TxTrigger           (clearsecU1ac3TxTrigger),
    .clearsecU1ac2TxTrigger           (clearsecU1ac2TxTrigger),
    .clearsecU1ac1TxTrigger           (clearsecU1ac1TxTrigger),
    .clearsecU1ac0TxTrigger           (clearsecU1ac0TxTrigger),
    .masterSecUsersTxIntEn            (masterSecUsersTxIntEn),
    .masksecU3ac3TxBufTrigger         (masksecU3ac3TxBufTrigger),
    .masksecU3ac2TxBufTrigger         (masksecU3ac2TxBufTrigger),
    .masksecU3ac1TxBufTrigger         (masksecU3ac1TxBufTrigger),
    .masksecU3ac0TxBufTrigger         (masksecU3ac0TxBufTrigger),
    .masksecU3ac3TxTrigger            (masksecU3ac3TxTrigger),
    .masksecU3ac2TxTrigger            (masksecU3ac2TxTrigger),
    .masksecU3ac1TxTrigger            (masksecU3ac1TxTrigger),
    .masksecU3ac0TxTrigger            (masksecU3ac0TxTrigger),
    .masksecU2ac3TxBufTrigger         (masksecU2ac3TxBufTrigger),
    .masksecU2ac2TxBufTrigger         (masksecU2ac2TxBufTrigger),
    .masksecU2ac1TxBufTrigger         (masksecU2ac1TxBufTrigger),
    .masksecU2ac0TxBufTrigger         (masksecU2ac0TxBufTrigger),
    .masksecU2ac3TxTrigger            (masksecU2ac3TxTrigger),
    .masksecU2ac2TxTrigger            (masksecU2ac2TxTrigger),
    .masksecU2ac1TxTrigger            (masksecU2ac1TxTrigger),
    .masksecU2ac0TxTrigger            (masksecU2ac0TxTrigger),
    .masksecU1ac3TxBufTrigger         (masksecU1ac3TxBufTrigger),
    .masksecU1ac2TxBufTrigger         (masksecU1ac2TxBufTrigger),
    .masksecU1ac1TxBufTrigger         (masksecU1ac1TxBufTrigger),
    .masksecU1ac0TxBufTrigger         (masksecU1ac0TxBufTrigger),
    .masksecU1ac3TxTrigger            (masksecU1ac3TxTrigger),
    .masksecU1ac2TxTrigger            (masksecU1ac2TxTrigger),
    .masksecU1ac1TxTrigger            (masksecU1ac1TxTrigger),
    .masksecU1ac0TxTrigger            (masksecU1ac0TxTrigger),
  `endif // RW_MUMIMO_TX_EN                     
    .swProf31                         (swProf31),
    .swProf30                         (swProf30),
    .swProf29                         (swProf29),
    .swProf28                         (swProf28),
    .swProf27                         (swProf27),
    .swProf26                         (swProf26),
    .swProf25                         (swProf25),
    .swProf24                         (swProf24),
    .swProf23                         (swProf23),
    .swProf22                         (swProf22),
    .swProf21                         (swProf21),
    .swProf20                         (swProf20),
    .swProf19                         (swProf19),
    .swProf18                         (swProf18),
    .swProf17                         (swProf17),
    .swProf16                         (swProf16),
    .swProf15                         (swProf15),
    .swProf14                         (swProf14),
    .swProf13                         (swProf13),
    .swProf12                         (swProf12),
    .swProf11                         (swProf11),
    .swProf10                         (swProf10),
    .swProf9                          (swProf9),
    .swProf8                          (swProf8),
    .swProf7                          (swProf7),
    .swProf6                          (swProf6),
    .swProf5                          (swProf5),
    .swProf4                          (swProf4),
    .swProf3                          (swProf3),
    .swProf2                          (swProf2),
    .swProf1                          (swProf1),
    .swProf0                          (swProf0),
    .swSetProf31                      (swSetProf31),
    .swSetProf30                      (swSetProf30),
    .swSetProf29                      (swSetProf29),
    .swSetProf28                      (swSetProf28),
    .swSetProf27                      (swSetProf27),
    .swSetProf26                      (swSetProf26),
    .swSetProf25                      (swSetProf25),
    .swSetProf24                      (swSetProf24),
    .swSetProf23                      (swSetProf23),
    .swSetProf22                      (swSetProf22),
    .swSetProf21                      (swSetProf21),
    .swSetProf20                      (swSetProf20),
    .swSetProf19                      (swSetProf19),
    .swSetProf18                      (swSetProf18),
    .swSetProf17                      (swSetProf17),
    .swSetProf16                      (swSetProf16),
    .swSetProf15                      (swSetProf15),
    .swSetProf14                      (swSetProf14),
    .swSetProf13                      (swSetProf13),
    .swSetProf12                      (swSetProf12),
    .swSetProf11                      (swSetProf11),
    .swSetProf10                      (swSetProf10),
    .swSetProf9                       (swSetProf9),
    .swSetProf8                       (swSetProf8),
    .swSetProf7                       (swSetProf7),
    .swSetProf6                       (swSetProf6),
    .swSetProf5                       (swSetProf5),
    .swSetProf4                       (swSetProf4),
    .swSetProf3                       (swSetProf3),
    .swSetProf2                       (swSetProf2),
    .swSetProf1                       (swSetProf1),
    .swSetProf0                       (swSetProf0),
    .swClearProf31                    (swClearProf31),
    .swClearProf30                    (swClearProf30),
    .swClearProf29                    (swClearProf29),
    .swClearProf28                    (swClearProf28),
    .swClearProf27                    (swClearProf27),
    .swClearProf26                    (swClearProf26),
    .swClearProf25                    (swClearProf25),
    .swClearProf24                    (swClearProf24),
    .swClearProf23                    (swClearProf23),
    .swClearProf22                    (swClearProf22),
    .swClearProf21                    (swClearProf21),
    .swClearProf20                    (swClearProf20),
    .swClearProf19                    (swClearProf19),
    .swClearProf18                    (swClearProf18),
    .swClearProf17                    (swClearProf17),
    .swClearProf16                    (swClearProf16),
    .swClearProf15                    (swClearProf15),
    .swClearProf14                    (swClearProf14),
    .swClearProf13                    (swClearProf13),
    .swClearProf12                    (swClearProf12),
    .swClearProf11                    (swClearProf11),
    .swClearProf10                    (swClearProf10),
    .swClearProf9                     (swClearProf9),
    .swClearProf8                     (swClearProf8),
    .swClearProf7                     (swClearProf7),
    .swClearProf6                     (swClearProf6),
    .swClearProf5                     (swClearProf5),
    .swClearProf4                     (swClearProf4),
    .swClearProf3                     (swClearProf3),
    .swClearProf2                     (swClearProf2),
    .swClearProf1                     (swClearProf1),
    .swClearProf0                     (swClearProf0),
    .swProf63                         (swProf63),
    .swProf62                         (swProf62),
    .swProf61                         (swProf61),
    .swProf60                         (swProf60),
    .swProf59                         (swProf59),
    .swProf58                         (swProf58),
    .swProf57                         (swProf57),
    .swProf56                         (swProf56),
    .swProf55                         (swProf55),
    .swProf54                         (swProf54),
    .swProf53                         (swProf53),
    .swProf52                         (swProf52),
    .swProf51                         (swProf51),
    .swProf50                         (swProf50),
    .swProf49                         (swProf49),
    .swProf48                         (swProf48),
    .swProf47                         (swProf47),
    .swProf46                         (swProf46),
    .swProf45                         (swProf45),
    .swProf44                         (swProf44),
    .swProf43                         (swProf43),
    .swProf42                         (swProf42),
    .swProf41                         (swProf41),
    .swProf40                         (swProf40),
    .swProf39                         (swProf39),
    .swProf38                         (swProf38),
    .swProf37                         (swProf37),
    .swProf36                         (swProf36),
    .swProf35                         (swProf35),
    .swProf34                         (swProf34),
    .swProf33                         (swProf33),
    .swProf32                         (swProf32),
    .swSetProf63                      (swSetProf63),
    .swSetProf62                      (swSetProf62),
    .swSetProf61                      (swSetProf61),
    .swSetProf60                      (swSetProf60),
    .swSetProf59                      (swSetProf59),
    .swSetProf58                      (swSetProf58),
    .swSetProf57                      (swSetProf57),
    .swSetProf56                      (swSetProf56),
    .swSetProf55                      (swSetProf55),
    .swSetProf54                      (swSetProf54),
    .swSetProf53                      (swSetProf53),
    .swSetProf52                      (swSetProf52),
    .swSetProf51                      (swSetProf51),
    .swSetProf50                      (swSetProf50),
    .swSetProf49                      (swSetProf49),
    .swSetProf48                      (swSetProf48),
    .swSetProf47                      (swSetProf47),
    .swSetProf46                      (swSetProf46),
    .swSetProf45                      (swSetProf45),
    .swSetProf44                      (swSetProf44),
    .swSetProf43                      (swSetProf43),
    .swSetProf42                      (swSetProf42),
    .swSetProf41                      (swSetProf41),
    .swSetProf40                      (swSetProf40),
    .swSetProf39                      (swSetProf39),
    .swSetProf38                      (swSetProf38),
    .swSetProf37                      (swSetProf37),
    .swSetProf36                      (swSetProf36),
    .swSetProf35                      (swSetProf35),
    .swSetProf34                      (swSetProf34),
    .swSetProf33                      (swSetProf33),
    .swSetProf32                      (swSetProf32),
    .swClearProf63                    (swClearProf63),
    .swClearProf62                    (swClearProf62),
    .swClearProf61                    (swClearProf61),
    .swClearProf60                    (swClearProf60),
    .swClearProf59                    (swClearProf59),
    .swClearProf58                    (swClearProf58),
    .swClearProf57                    (swClearProf57),
    .swClearProf56                    (swClearProf56),
    .swClearProf55                    (swClearProf55),
    .swClearProf54                    (swClearProf54),
    .swClearProf53                    (swClearProf53),
    .swClearProf52                    (swClearProf52),
    .swClearProf51                    (swClearProf51),
    .swClearProf50                    (swClearProf50),
    .swClearProf49                    (swClearProf49),
    .swClearProf48                    (swClearProf48),
    .swClearProf47                    (swClearProf47),
    .swClearProf46                    (swClearProf46),
    .swClearProf45                    (swClearProf45),
    .swClearProf44                    (swClearProf44),
    .swClearProf43                    (swClearProf43),
    .swClearProf42                    (swClearProf42),
    .swClearProf41                    (swClearProf41),
    .swClearProf40                    (swClearProf40),
    .swClearProf39                    (swClearProf39),
    .swClearProf38                    (swClearProf38),
    .swClearProf37                    (swClearProf37),
    .swClearProf36                    (swClearProf36),
    .swClearProf35                    (swClearProf35),
    .swClearProf34                    (swClearProf34),
    .swClearProf33                    (swClearProf33),
    .swClearProf32                    (swClearProf32),
  `ifdef RW_MUMIMO_SEC_USER1_EN              
  `endif // RW_MUMIMO_SEC_USER1_EN              
  `ifdef RW_MUMIMO_SEC_USER2_EN              
  `endif // RW_MUMIMO_SEC_USER2_EN              
  `ifdef RW_MUMIMO_SEC_USER3_EN              
  `endif // RW_MUMIMO_SEC_USER3_EN              
    .regSel                           (plRegSel),
    .regWrite                         (regWrite),
    .regRead                          (regRead),
    .latchNextState_p                 (latchNextState_p),
    .regAddr                          (regAddr[(`RW_REG_ADDR_WIDTH-2):0]),
    .regWriteData                     (regWriteData),
    .regReadData                      (plReadData)
    );

// Instanciation of macCoreReg
// Name of the instance : u_macCoreReg
// Name of the file containing this module : macCoreReg.v
macCoreReg u_macCoreReg (
    .hardRstClk_n                     (macCoreClkHardRst_n),
    .softRstClk_n                     (macCoreClkSoftRst_n),
    .Clk                              (macCoreClk),
    .signature                        (signature),
    .muMIMOTx                         (muMIMOTx),
    .bfmer                            (bfmer),
    .bfmee                            (bfmee),
    .he                               (he),
    .coex                             (coex),
    .wapi                             (wapi),
    .tpc                              (tpc),
    .vht                              (vht),
    .ht                               (ht),
    .gcmp                             (gcmp),
    .rce                              (rce),
    .ccmp                             (ccmp),
    .tkip                             (tkip),
    .wep                              (wep),
    .security                         (security),
    .sme                              (sme),
    .edca                             (edca),
    .qos                              (qos),
    .phaseNumber                      (phaseNumber),
    .releaseNumber                    (releaseNumber),
    .ieRelease                        (ieRelease),
    .umVersion                        (umVersion),
    .bitmapCnt                        (bitmapCnt),
    .nextStateIn                      (nextStateIn),
    .nextStateInValid                 (nextStateInValid),
    .currentState                     (currentState),
    .tsfUpdatedBySWIn                 (tsfUpdatedBySWIn),
    .tsfUpdatedBySWInValid            (tsfUpdatedBySWInValid),
    .keyStoRAMResetIn                 (keyStoRAMResetIn),
    .keyStoRAMResetInValid            (keyStoRAMResetInValid),
    .mibTableResetIn                  (mibTableResetIn),
    .mibTableResetInValid             (mibTableResetInValid),
    .baPSBitmapResetIn                (baPSBitmapResetIn),
    .baPSBitmapResetInValid           (baPSBitmapResetInValid),
    .macPHYIFFIFOResetIn              (macPHYIFFIFOResetIn),
    .macPHYIFFIFOResetInValid         (macPHYIFFIFOResetInValid),
    .txFIFOResetIn                    (txFIFOResetIn),
    .txFIFOResetInValid               (txFIFOResetInValid),
    .rxFIFOResetIn                    (rxFIFOResetIn),
    .rxFIFOResetInValid               (rxFIFOResetInValid),
    .hwFSMResetIn                     (hwFSMResetIn),
    .hwFSMResetInValid                (hwFSMResetInValid),
    .useErrRec                        (useErrRec),
    .statuserrInHWLevel3              (statuserrInHWLevel3),
    .statuserrInTxRxLevel2            (statuserrInTxRxLevel2),
    .statuserrInRxLevel1              (statuserrInRxLevel1),
    .statuserrInTxLevel1              (statuserrInTxLevel1),
    .enDuplicateDetection             (enDuplicateDetection),
    .dtimUpdatedBySWIn                (dtimUpdatedBySWIn),
    .dtimUpdatedBySWInValid           (dtimUpdatedBySWInValid),
    .dtimPeriodIn                     (dtimPeriodIn),
    .dtimPeriodInValid                (dtimPeriodInValid),
    .encrKeyRAMWord0In                (encrKeyRAMWord0In),
    .encrKeyRAMWord0InValid           (encrKeyRAMWord0InValid),
    .encrKeyRAMWord1In                (encrKeyRAMWord1In),
    .encrKeyRAMWord1InValid           (encrKeyRAMWord1InValid),
    .encrKeyRAMWord2In                (encrKeyRAMWord2In),
    .encrKeyRAMWord2InValid           (encrKeyRAMWord2InValid),
    .encrKeyRAMWord3In                (encrKeyRAMWord3In),
    .encrKeyRAMWord3InValid           (encrKeyRAMWord3InValid),
    .macAddrRAMLowIn                  (macAddrRAMLowIn),
    .macAddrRAMLowInValid             (macAddrRAMLowInValid),
    .macAddrRAMHighIn                 (macAddrRAMHighIn),
    .macAddrRAMHighInValid            (macAddrRAMHighInValid),
    .newReadIn                        (newReadIn),
    .newReadInValid                   (newReadInValid),
    .newWriteIn                       (newWriteIn),
    .newWriteInValid                  (newWriteInValid),
    .newSearchIn                      (newSearchIn),
    .newSearchInValid                 (newSearchInValid),
    .searchErrorIn                    (searchErrorIn),
    .searchErrorInValid               (searchErrorInValid),
    .keyIndexRAMIn                    (keyIndexRAMIn),
    .keyIndexRAMInValid               (keyIndexRAMInValid),
    .cLenRAMIn                        (cLenRAMIn),
    .cLenRAMInValid                   (cLenRAMInValid),
    .cTypeRAMIn                       (cTypeRAMIn),
    .cTypeRAMInValid                  (cTypeRAMInValid),
    .vlanIDRAMIn                      (vlanIDRAMIn),
    .vlanIDRAMInValid                 (vlanIDRAMInValid),
    .sppRAMIn                         (sppRAMIn),
    .sppRAMInValid                    (sppRAMInValid),
    .useDefKeyRAMIn                   (useDefKeyRAMIn),
    .useDefKeyRAMInValid              (useDefKeyRAMInValid),
  `ifdef RW_KEY_EXTENDED                      
    .encrIntKeyRAMWord0In             (encrIntKeyRAMWord0In),
    .encrIntKeyRAMWord0InValid        (encrIntKeyRAMWord0InValid),
    .encrIntKeyRAMWord1In             (encrIntKeyRAMWord1In),
    .encrIntKeyRAMWord1InValid        (encrIntKeyRAMWord1InValid),
    .encrIntKeyRAMWord2In             (encrIntKeyRAMWord2In),
    .encrIntKeyRAMWord2InValid        (encrIntKeyRAMWord2InValid),
    .encrIntKeyRAMWord3In             (encrIntKeyRAMWord3In),
    .encrIntKeyRAMWord3InValid        (encrIntKeyRAMWord3InValid),
  `endif // RW_KEY_EXTENDED                      
    .staKeyMaxIndex                   (staKeyMaxIndex),
    .mibWriteIn                       (mibWriteIn),
    .mibWriteInValid                  (mibWriteInValid),
    .monotonicCounter1                (monotonicCounter1),
    .monotonicCounterLow2In           (monotonicCounterLow2In),
    .monotonicCounterLow2InValid      (monotonicCounterLow2InValid),
    .monotonicCounterHigh2In          (monotonicCounterHigh2In),
    .monotonicCounterHigh2InValid     (monotonicCounterHigh2InValid),
    .ccaBusyDurIn                     (ccaBusyDurIn),
    .ccaBusyDurInValid                (ccaBusyDurInValid),
    .sendCFEndNowIn                   (sendCFEndNowIn),
    .sendCFEndNowInValid              (sendCFEndNowInValid),
    .quietDuration1In                 (quietDuration1In),
    .quietDuration1InValid            (quietDuration1InValid),
    .quietPeriod1In                   (quietPeriod1In),
    .quietPeriod1InValid              (quietPeriod1InValid),
    .quietCount1In                    (quietCount1In),
    .quietCount1InValid               (quietCount1InValid),
    .quietOffset1In                   (quietOffset1In),
    .quietOffset1InValid              (quietOffset1InValid),
    .ccaBusyDurSec20In                (ccaBusyDurSec20In),
    .ccaBusyDurSec20InValid           (ccaBusyDurSec20InValid),
    .ccaBusyDurSec40In                (ccaBusyDurSec40In),
    .ccaBusyDurSec40InValid           (ccaBusyDurSec40InValid),
    .ccaBusyDurSec80In                (ccaBusyDurSec80In),
    .ccaBusyDurSec80InValid           (ccaBusyDurSec80InValid),
  `ifdef RW_BFMEE_EN                          
  `endif // RW_BFMEE_EN                          
  `ifdef RW_WLAN_COEX_EN                      
    .coexWlanPTIState                 (coexWlanPTIState),
    .coexWlanPTIToggleState           (coexWlanPTIToggleState),
    .coexWlanChanBwState              (coexWlanChanBwState),
    .coexWlanRxState                  (coexWlanRxState),
    .coexWlanTxState                  (coexWlanTxState),
    .coexWlanRxAbortState             (coexWlanRxAbortState),
    .coexWlanTxAbortState             (coexWlanTxAbortState),
  `endif // RW_WLAN_COEX_EN                      
    .macControlLs                     (macControlLs),
    .txControlLs                      (txControlLs),
    .rxControlLs                      (rxControlLs),
    .macControlCs                     (macControlCs),
    .txControlCs                      (txControlCs),
    .rxControlCs                      (rxControlCs),
    .debugPortRead                    (debugPortRead),
    .basicNAVCounterIn                (basicNAVCounterIn),
    .basicNAVCounterInValid           (basicNAVCounterInValid),
    .activeAC                         (activeAC),
    .currentCW3                       (currentCW3),
    .currentCW2                       (currentCW2),
    .currentCW1                       (currentCW1),
    .currentCW0                       (currentCW0),
    .ac3QSRC                          (ac3QSRC),
    .ac2QSRC                          (ac2QSRC),
    .ac1QSRC                          (ac1QSRC),
    .ac0QSRC                          (ac0QSRC),
    .ac3QLRC                          (ac3QLRC),
    .ac2QLRC                          (ac2QLRC),
    .ac1QLRC                          (ac1QLRC),
    .ac0QLRC                          (ac0QLRC),
    .ocwLFSRIn                        (ocwLFSRIn),
    .ocwLFSRInValid                   (ocwLFSRInValid),
    .intraNAVCounterIn                (intraNAVCounterIn),
    .intraNAVCounterInValid           (intraNAVCounterInValid),
    .macAddrLow                       (macAddrLow),
    .macAddrHigh                      (macAddrHigh),
    .macAddrLowMask                   (macAddrLowMask),
    .macAddrHighMask                  (macAddrHighMask),
    .bssIDLow                         (bssIDLow),
    .bssIDHigh                        (bssIDHigh),
    .bssIDLowMask                     (bssIDLowMask),
    .bssIDHighMask                    (bssIDHighMask),
    .partialBSSColorEn                (partialBSSColorEn),
    .bssColorEn                       (bssColorEn),
    .bssColor                         (bssColor),
    .nextState                        (nextState),
    .primaryChPosition                (primaryChPosition),
    .probeDelay                       (probeDelay),
    .wakeupDTIM                       (wakeupDTIM),
    .listenInterval                   (listenInterval),
    .rxRIFSEn                         (rxRIFSEn),
    .tsfMgtDisable                    (tsfMgtDisable),
    .tsfUpdatedBySW                   (tsfUpdatedBySW),
    .disableSVDRxPause                (disableSVDRxPause),
    .disableBQRResp                   (disableBQRResp),
    .abgnMode                         (abgnMode),
    .keyStoRAMReset                   (keyStoRAMReset),
    .mibTableReset                    (mibTableReset),
    .rateControllerMPIF               (rateControllerMPIF),
    .disableBAResp                    (disableBAResp),
    .disableCTSResp                   (disableCTSResp),
    .disableACKResp                   (disableACKResp),
    .activeClkGating                  (activeClkGating),
    .enableLPClkSwitch                (enableLPClkSwitch),
    .lpClk32786Hz                     (lpClk32786Hz),
    .pwrMgt                           (pwrMgt),
    .ap                               (ap),
    .bssType                          (bssType),
    .rxFlowCntrlEn                    (rxFlowCntrlEn),
    .baPSBitmapReset                  (baPSBitmapReset),
    .macPHYIFFIFOReset                (macPHYIFFIFOReset),
    .txFIFOReset                      (txFIFOReset),
    .rxFIFOReset                      (rxFIFOReset),
    .hwFSMReset                       (hwFSMReset),
    .useErrDet                        (useErrDet),
    .errInHWLevel3                    (errInHWLevel3),
    .errInTxRxLevel2                  (errInTxRxLevel2),
    .errInRxLevel1                    (errInRxLevel1),
    .errInTxLevel1                    (errInTxLevel1),
    .clearErrInHWLevel3               (clearErrInHWLevel3),
    .clearErrInTxRxLevel2             (clearErrInTxRxLevel2),
    .clearErrInRxLevel1               (clearErrInRxLevel1),
    .clearErrInTxLevel1               (clearErrInTxLevel1),
    .acceptUnknown                    (acceptUnknown),
    .acceptOtherDataFrames            (acceptOtherDataFrames),
    .acceptQoSNull                    (acceptQoSNull),
    .acceptQCFWOData                  (acceptQCFWOData),
    .acceptQData                      (acceptQData),
    .acceptCFWOData                   (acceptCFWOData),
    .acceptData                       (acceptData),
    .acceptOtherCntrlFrames           (acceptOtherCntrlFrames),
    .acceptCFEnd                      (acceptCFEnd),
    .acceptACK                        (acceptACK),
    .acceptCTS                        (acceptCTS),
    .acceptRTS                        (acceptRTS),
    .acceptPSPoll                     (acceptPSPoll),
    .acceptBA                         (acceptBA),
    .acceptBAR                        (acceptBAR),
    .acceptOtherMgmtFrames            (acceptOtherMgmtFrames),
    .acceptBfmeeFrames                (acceptBfmeeFrames),
    .acceptAllBeacon                  (acceptAllBeacon),
    .acceptNotExpectedBA              (acceptNotExpectedBA),
    .acceptDecryptErrorFrames         (acceptDecryptErrorFrames),
    .acceptBeacon                     (acceptBeacon),
    .acceptProbeResp                  (acceptProbeResp),
    .acceptProbeReq                   (acceptProbeReq),
    .acceptMyUnicast                  (acceptMyUnicast),
    .acceptUnicast                    (acceptUnicast),
    .acceptErrorFrames                (acceptErrorFrames),
    .acceptOtherBSSID                 (acceptOtherBSSID),
    .acceptBroadcast                  (acceptBroadcast),
    .acceptMulticast                  (acceptMulticast),
    .dontDecrypt                      (dontDecrypt),
    .excUnencrypted                   (excUnencrypted),
    .noBcnTxTime                      (noBcnTxTime),
    .impTBTTIn128Us                   (impTBTTIn128Us),
    .impTBTTPeriod                    (impTBTTPeriod),
    .beaconInt                        (beaconInt),
    .aid                              (aid),
    .timOffset                        (timOffset),
    .bcnUpdateOffset                  (bcnUpdateOffset),
    .dtimUpdatedBySW                  (dtimUpdatedBySW),
    .dtimPeriod                       (dtimPeriod),
    .dot11LongRetryLimit              (dot11LongRetryLimit),
    .dot11ShortRetryLimit             (dot11ShortRetryLimit),
    .maxPHYNtx                        (maxPHYNtx),
    .bbServiceB                       (bbServiceB),
    .bbServiceA                       (bbServiceA),
    .ofdmMinPwrLevel                  (ofdmMinPwrLevel),
    .dsssMaxPwrLevel                  (dsssMaxPwrLevel),
    .ofdmMaxPwrLevel                  (ofdmMaxPwrLevel),
    .encrKeyRAMWord0                  (encrKeyRAMWord0),
    .encrKeyRAMWord1                  (encrKeyRAMWord1),
    .encrKeyRAMWord2                  (encrKeyRAMWord2),
    .encrKeyRAMWord3                  (encrKeyRAMWord3),
    .macAddrRAMLow                    (macAddrRAMLow),
    .macAddrRAMHigh                   (macAddrRAMHigh),
    .newRead                          (newRead),
    .newWrite                         (newWrite),
    .newSearch                        (newSearch),
    .searchError                      (searchError),
    .keyIndexRAM                      (keyIndexRAM),
    .cLenRAM                          (cLenRAM),
    .cTypeRAM                         (cTypeRAM),
    .vlanIDRAM                        (vlanIDRAM),
    .sppRAM                           (sppRAM),
    .useDefKeyRAM                     (useDefKeyRAM),
  `ifdef RW_KEY_EXTENDED                      
    .encrIntKeyRAMWord0               (encrIntKeyRAMWord0),
    .encrIntKeyRAMWord1               (encrIntKeyRAMWord1),
    .encrIntKeyRAMWord2               (encrIntKeyRAMWord2),
    .encrIntKeyRAMWord3               (encrIntKeyRAMWord3),
  `endif // RW_KEY_EXTENDED                      
    .nVAP                             (nVAP),
    .staKeyEndIndex                   (staKeyEndIndex),
    .staKeyStartIndex                 (staKeyStartIndex),
    .bssBasicRateSet                  (bssBasicRateSet),
    .dsssCount                        (dsssCount),
    .ofdmCount                        (ofdmCount),
    .olbcTimer                        (olbcTimer),
    .txChainDelayInMACClk             (txChainDelayInMACClk),
    .txRFDelayInMACClk                (txRFDelayInMACClk),
    .macCoreClkFreq                   (macCoreClkFreq),
    .slotTimeInMACClk                 (slotTimeInMACClk),
    .slotTime                         (slotTime),
    .rxRFDelayInMACClk                (rxRFDelayInMACClk),
    .macProcDelayInMACClk             (macProcDelayInMACClk),
    .radioWakeUpTime                  (radioWakeUpTime),
    .radioChirpTime                   (radioChirpTime),
    .wt2CryptClkRatio                 (wt2CryptClkRatio),
    .sifsBInMACClk                    (sifsBInMACClk),
    .sifsB                            (sifsB),
    .sifsAInMACClk                    (sifsAInMACClk),
    .sifsA                            (sifsA),
    .rxCCADelay                       (rxCCADelay),
    .rxStartDelayMIMO                 (rxStartDelayMIMO),
    .rxStartDelayShort                (rxStartDelayShort),
    .rxStartDelayLong                 (rxStartDelayLong),
    .rxStartDelayOFDM                 (rxStartDelayOFDM),
    .rifsTOInMACClk                   (rifsTOInMACClk),
    .txDMAProcDlyInMACClk             (txDMAProcDlyInMACClk),
    .disableRxBuffer2                 (disableRxBuffer2),
    .dataMHStoredwithPld              (dataMHStoredwithPld),
    .mgtMHStoredwithPld               (mgtMHStoredwithPld),
    .ctrlMHStoredwithPld              (ctrlMHStoredwithPld),
    .partialUnwrapSize                (partialUnwrapSize),
    .dataFrmWrapMode                  (dataFrmWrapMode),
    .mgtFrmWrapMode                   (mgtFrmWrapMode),
    .ctrlFrmWrapMode                  (ctrlFrmWrapMode),
    .txPacketTimeout                  (txPacketTimeout),
    .txAbsoluteTimeout                (txAbsoluteTimeout),
    .rxPacketTimeout                  (rxPacketTimeout),
    .rxAbsoluteTimeout                (rxAbsoluteTimeout),
    .mibValue                         (mibValue),
    .mibWrite                         (mibWrite),
    .mibIncrementMode                 (mibIncrementMode),
    .mibTableIndex                    (mibTableIndex),
    .monotonicCounterLow2             (monotonicCounterLow2),
    .monotonicCounter2SWUpdate        (monotonicCounter2SWUpdate),
    .monotonicCounterHigh2            (monotonicCounterHigh2),
    .absTimerValue0                   (absTimerValue0),
    .absTimerValue1                   (absTimerValue1),
    .absTimerValue2                   (absTimerValue2),
    .absTimerValue3                   (absTimerValue3),
    .absTimerValue4                   (absTimerValue4),
    .absTimerValue5                   (absTimerValue5),
    .absTimerValue6                   (absTimerValue6),
    .absTimerValue7                   (absTimerValue7),
    .absTimerValue8                   (absTimerValue8),
    .absTimerValue9                   (absTimerValue9),
    .maxAllowedLength                 (maxAllowedLength),
    .txOpLimit0                       (txOpLimit0),
    .cwMax0                           (cwMax0),
    .cwMin0                           (cwMin0),
    .aifsn0                           (aifsn0),
    .txOpLimit1                       (txOpLimit1),
    .cwMax1                           (cwMax1),
    .cwMin1                           (cwMin1),
    .aifsn1                           (aifsn1),
    .txOpLimit2                       (txOpLimit2),
    .cwMax2                           (cwMax2),
    .cwMin2                           (cwMin2),
    .aifsn2                           (aifsn2),
    .txOpLimit3                       (txOpLimit3),
    .cwMax3                           (cwMax3),
    .cwMin3                           (cwMin3),
    .aifsn3                           (aifsn3),
    .ccaBusyDur                       (ccaBusyDur),
    .keepTXOPOpen                     (keepTXOPOpen),
    .remTXOPInDurField                (remTXOPInDurField),
    .sendCFEnd                        (sendCFEnd),
    .sendCFEndNow                     (sendCFEndNow),
    .quietDuration1                   (quietDuration1),
    .quietPeriod1                     (quietPeriod1),
    .quietCount1                      (quietCount1),
    .quietOffset1                     (quietOffset1),
    .ccaBusyDurSec20                  (ccaBusyDurSec20),
    .ccaBusyDurSec40                  (ccaBusyDurSec40),
    .ccaBusyDurSec80                  (ccaBusyDurSec80),
    .basicSTBCMCS                     (basicSTBCMCS),
    .dualCTSProt                      (dualCTSProt),
    .ctsSTBCDur                       (ctsSTBCDur),
    .cfEndSTBCDur                     (cfEndSTBCDur),
    .maxSupportedBW                   (maxSupportedBW),
    .aPPDUMaxTime                     (aPPDUMaxTime),
    .dynBWEn                          (dynBWEn),
    .numTryBWAcquisition              (numTryBWAcquisition),
    .dropToLowerBW                    (dropToLowerBW),
    .defaultBWTXOP                    (defaultBWTXOP),
    .defaultBWTXOPV                   (defaultBWTXOPV),
    .bssBasicHTMCSSetUM               (bssBasicHTMCSSetUM),
    .bssBasicHTMCSSetEM               (bssBasicHTMCSSetEM),
    .bssBasicVHTMCSSet                (bssBasicVHTMCSSet),
    .supportLSTP                      (supportLSTP),
    .dcmSupport                       (dcmSupport),
    .dopplerSupport                   (dopplerSupport),
    .enableOBSSPD                     (enableOBSSPD),
    .enableSRP                        (enableSRP),
    .acceptAllTriggerFrames           (acceptAllTriggerFrames),
    .acceptTriggerSWFrames            (acceptTriggerSWFrames),
    .acceptTriggerHWFrames            (acceptTriggerHWFrames),
    .disableTBUPH                     (disableTBUPH),
    .disableTBRU26Resp                (disableTBRU26Resp),
    .disableTBCS                      (disableTBCS),
    .disableTBResp                    (disableTBResp),
    .defaultPEDur                     (defaultPEDur),
    .srgOBSSPDMaxOffset               (srgOBSSPDMaxOffset),
    .srgOBSSPDMinOffset               (srgOBSSPDMinOffset),
    .nonSRGOBSSPDMaxOffset            (nonSRGOBSSPDMaxOffset),
    .srgInformationPresent            (srgInformationPresent),
    .nonSRGOffsetPresent              (nonSRGOffsetPresent),
    .nonSRGOBSSPDSRDisallowed         (nonSRGOBSSPDSRDisallowed),
    .SRPDisallowed                    (SRPDisallowed),
    .SRGBSSColorBitmapLow             (SRGBSSColorBitmapLow),
    .SRGBSSColorBitmapHigh            (SRGBSSColorBitmapHigh),
    .SRGPartialBSSIDBitmapLow         (SRGPartialBSSIDBitmapLow),
    .SRGPartialBSSIDBitmapHigh        (SRGPartialBSSIDBitmapHigh),
  `ifdef RW_BFMEE_EN                          
    .bfrHELTFType                     (bfrHELTFType),
    .bfrGIType                        (bfrGIType),
    .bfrFormatMod                     (bfrFormatMod),
    .bfrShortGI                       (bfrShortGI),
    .bfrMCS                           (bfrMCS),
    .bfmeeNc                          (bfmeeNc),
    .bfmeeNr                          (bfmeeNr),
    .bfmeeGrouping                    (bfmeeGrouping),
    .bfmeeCodebook                    (bfmeeCodebook),
    .bfmeeMUSupport                   (bfmeeMUSupport),
    .bfmeeEnable                      (bfmeeEnable),
  `endif // RW_BFMEE_EN                          
  `ifdef RW_WLAN_COEX_EN                      
    .coexForceWlanPTI                 (coexForceWlanPTI),
    .coexForceWlanPTIToggle           (coexForceWlanPTIToggle),
    .coexForceWlanChanBw              (coexForceWlanChanBw),
    .coexForceWlanRx                  (coexForceWlanRx),
    .coexForceWlanTx                  (coexForceWlanTx),
    .coexWlanChanFreq                 (coexWlanChanFreq),
    .coexWlanChanOffset               (coexWlanChanOffset),
    .coexAutoPTIAdjIncr               (coexAutoPTIAdjIncr),
    .coexAutoPTIAdjEnable             (coexAutoPTIAdjEnable),
    .coexForceEnable                  (coexForceEnable),
    .coexPostponeTxEnable             (coexPostponeTxEnable),
    .coexPHYRxAbortEnable             (coexPHYRxAbortEnable),
    .coexPHYTxAbortEnable             (coexPHYTxAbortEnable),
    .coexEnable                       (coexEnable),
    .coexPTIBcnData                   (coexPTIBcnData),
    .coexPTIBKData                    (coexPTIBKData),
    .coexPTIBEData                    (coexPTIBEData),
    .coexPTIVIData                    (coexPTIVIData),
    .coexPTIVOData                    (coexPTIVOData),
    .coexPTIMgt                       (coexPTIMgt),
    .coexPTICntl                      (coexPTICntl),
    .coexPTIAck                       (coexPTIAck),
    .coexWlanRxAbortFallEn            (coexWlanRxAbortFallEn),
    .coexWlanRxAbortRiseEn            (coexWlanRxAbortRiseEn),
    .coexWlanTxAbortFallEn            (coexWlanTxAbortFallEn),
    .coexWlanTxAbortRiseEn            (coexWlanTxAbortRiseEn),
  `endif // RW_WLAN_COEX_EN                      
    .debugPortSel2                    (debugPortSel2),
    .debugPortSel1                    (debugPortSel1),
    .basicNAVCounter                  (basicNAVCounter),
    .backoffOffset                    (backoffOffset),
    .ocwLFSR                          (ocwLFSR),
    .rxEndForTimingErrRec             (rxEndForTimingErrRec),
    .rxReqForceDeassertion            (rxReqForceDeassertion),
    .intraNAVCounter                  (intraNAVCounter),
    .regSel                           (postWriteSel),
    .regWrite                         (postWriteWrite),
    .regRead                          (postWriteRead),
    .regAddr                          (postWriteregAddr),
    .regWriteData                     (postWritewriteData),
    .regReadData                      (postWritereadData)
    );

// Instanciation of postWrite
// Name of the instance : u_postWrite
// Name of the file containing this module : postWrite.v
postWrite u_postWrite (
    .macPIClk               (macPIClk),
    .macPIClkHardRst_n      (macPIClkHardRst_n),
    .macCoreClk             (macCoreClk),
    .macCoreClkHardRst_n    (macCoreClkHardRst_n),
    .regSel                 (coreRegSel),
    .regWrite               (regWrite),
    .regRead                (regRead),
    .regAddr                (regAddr[(`RW_REG_ADDR_WIDTH-2):0]),
    .regWriteData           (regWriteData),
    .regReadyIn             (coreReadyIn),
    .regReadData            (coreReadData),
    .postWriteWrite         (postWriteWrite),
    .postWriteRead          (postWriteRead),
    .postWriteSel           (postWriteSel),
    .postWriteregAddr       (postWriteregAddr),
    .postWritewriteData     (postWritewriteData),
    .postWritereadData      (postWritereadData)
    );

endmodule
