//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : Core register
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module macCoreReg (
    ////////////////////////////////////////////
    //$port_g clock and reset
    ////////////////////////////////////////////
    input wire          hardRstClk_n     , // Hard Reset.
    input wire          softRstClk_n     , // Soft Reset.
    input wire          Clk              , // clock clock.

    ////////////////////////////////////////////
    //$port_g Registers
    ////////////////////////////////////////////

    //$port_g SIGNATUREREG register.
    input wire [31 : 0] signature                      , // The SIGNATURE register is a read only register containing a specific ID. 

    //$port_g VERSION1REG register.
    input wire          muMIMOTx                       , // This bit indicates if the core supports the MU-MIMO transmission as an AP
    input wire          bfmer                          , // This bit indicates if the core supports the beamforming as a beamformer
    input wire          bfmee                          , // This bit indicates if the core supports the beamforming as a beamformee
    input wire          he                             , // High Efficiency
    input wire          coex                           , // Coexistence
    input wire          wapi                           , // WAPI
    input wire          tpc                            , // Transmit Power Control
    input wire          vht                            , // Very High Throughput
    input wire          ht                             , // High Throughput
    input wire          gcmp                           , // GCMP
    input wire          rce                            , // Regulatory Classes Extensions
    input wire          ccmp                           , // CCMP
    input wire          tkip                           , // TKIP
    input wire          wep                            , // WEP
    input wire          security                       , // Security
    input wire          sme                            , // Spectrum Management Extension
    input wire          edca                           , // Enhanced Distributed Channel Access
    input wire          qos                            , // Quality of Service

    //$port_g VERSION2REG register.
    input wire [ 2 : 0] phaseNumber                    , // These bits are used to define the phase number of the release (same as the minor version field of the tag in SVN).
    input wire [ 5 : 0] releaseNumber                  , // These bits are used to define the release number under this phase (same as the intermediate release field of the tag in SVN).
    input wire          ieRelease                      , // This bit is set if it is an external (client) release, and is reset if it is an internal (test team) release
    input wire [ 6 : 0] umVersion                      , // These bits are used to define the FS compliancy of the current hardware as xx.yyyyy.

    //$port_g BITMAPCNTREG register.
    input wire [15 : 0] bitmapCnt                      , // Bitmap Count

    //$port_g STATECNTRLREG register.
    input wire [ 3 : 0] nextStateIn                    , // Next State In
    input wire          nextStateInValid               , // Next State In Valid
    input wire [ 3 : 0] currentState                   , // Current State

    //$port_g MACCNTRL1REG register.
    input wire          tsfUpdatedBySWIn               , // TSF Updated By SW In
    input wire          tsfUpdatedBySWInValid          , // TSF Updated By SW In Valid
    input wire          keyStoRAMResetIn               , // Key Storage RAM Reset In
    input wire          keyStoRAMResetInValid          , // Key Storage RAM Reset In Valid
    input wire          mibTableResetIn                , // MIB Table reset In
    input wire          mibTableResetInValid           , // MIB Table reset In Valid

    //$port_g MACERRRECCNTRLREG register.
    input wire          baPSBitmapResetIn              , // Block ACK Partial Bitmap Reset In
    input wire          baPSBitmapResetInValid         , // Block ACK Partial Bitmap Reset In Valid
    input wire          macPHYIFFIFOResetIn            , // MAC-PHY InterFace FIFO Reset In
    input wire          macPHYIFFIFOResetInValid       , // MAC-PHY InterFace FIFO Reset In Valid
    input wire          txFIFOResetIn                  , // Transmit FIFO Reset In
    input wire          txFIFOResetInValid             , // Transmit FIFO Reset In Valid
    input wire          rxFIFOResetIn                  , // Receive FIFO Reset In
    input wire          rxFIFOResetInValid             , // Receive FIFO Reset In Valid
    input wire          hwFSMResetIn                   , // Hardware Finite State Machine Reset In
    input wire          hwFSMResetInValid              , // Hardware Finite State Machine Reset In Valid
    input wire          useErrRec                      , // Use Error Recovery

    //$port_g MACERRSETSTATUSREG register.

    //$port_g MACERRSETSTATUSREG register.
    input wire          statuserrInHWLevel3            , // Error in HW - Level 3
    input wire          statuserrInTxRxLevel2          , // Error in Transmit/Receive - Level 2
    input wire          statuserrInRxLevel1            , // Error In Receive - Level 1
    input wire          statuserrInTxLevel1            , // Error In Transmit - Level 1

    //$port_g MACERRCLEARSTATUSREG register.

    //$port_g RXCNTRLREG register.
    input wire          enDuplicateDetection           , // Enable Duplicate Detection

    //$port_g DTIM1REG register.
    input wire          dtimUpdatedBySWIn              , // DTIM Updated by SW In
    input wire          dtimUpdatedBySWInValid         , // DTIM Updated by SW In Valid
    input wire [ 7 : 0] dtimPeriodIn                   , // DTIM Period In
    input wire          dtimPeriodInValid              , // DTIM Period In Valid

    //$port_g ENCRKEY0REG register.
    input wire [31 : 0] encrKeyRAMWord0In              , // Encryption Key for RAM In
    input wire          encrKeyRAMWord0InValid         , // Encryption Key for RAM In Valid

    //$port_g ENCRKEY1REG register.
    input wire [31 : 0] encrKeyRAMWord1In              , // Encryption Key for RAM In
    input wire          encrKeyRAMWord1InValid         , // Encryption Key for RAM In Valid

    //$port_g ENCRKEY2REG register.
    input wire [31 : 0] encrKeyRAMWord2In              , // It contains bits 95 to 64 of the 104-bit WEP key or the TKIP/CCMP/WAPI key to be programmed in the Key Storage RAM. In
    input wire          encrKeyRAMWord2InValid         , // It contains bits 95 to 64 of the 104-bit WEP key or the TKIP/CCMP/WAPI key to be programmed in the Key Storage RAM. In Valid

    //$port_g ENCRKEY3REG register.
    input wire [31 : 0] encrKeyRAMWord3In              , // Encryption Key for RAM In
    input wire          encrKeyRAMWord3InValid         , // Encryption Key for RAM In Valid

    //$port_g ENCRMACADDRLOWREG register.
    input wire [31 : 0] macAddrRAMLowIn                , // MAC Address for RAM In
    input wire          macAddrRAMLowInValid           , // MAC Address for RAM In Valid

    //$port_g ENCRMACADDRHIGHREG register.
    input wire [15 : 0] macAddrRAMHighIn               , // MAC Address for RAM In
    input wire          macAddrRAMHighInValid          , // MAC Address for RAM In Valid

    //$port_g ENCRCNTRLREG register.
    input wire          newReadIn                      , // New Read In
    input wire          newReadInValid                 , // New Read In Valid
    input wire          newWriteIn                     , // New Write In
    input wire          newWriteInValid                , // New Write In Valid
    input wire          newSearchIn                    , // New Search In
    input wire          newSearchInValid               , // New Search In Valid
    input wire          searchErrorIn                  , // Search Error In
    input wire          searchErrorInValid             , // Search Error In Valid
    input wire [ 9 : 0] keyIndexRAMIn                  , // Key Index RAM In
    input wire          keyIndexRAMInValid             , // Key Index RAM In Valid
    input wire [ 1 : 0] cLenRAMIn                      , // Cipher Length for RAM In
    input wire          cLenRAMInValid                 , // Cipher Length for RAM In Valid
    input wire [ 2 : 0] cTypeRAMIn                     , // Cipher Type for RAM In
    input wire          cTypeRAMInValid                , // Cipher Type for RAM In Valid
    input wire [ 3 : 0] vlanIDRAMIn                    , // Virtual LAN ID for RAM In
    input wire          vlanIDRAMInValid               , // Virtual LAN ID for RAM In Valid
    input wire [ 1 : 0] sppRAMIn                       , // SPP for RAM In
    input wire          sppRAMInValid                  , // SPP for RAM In Valid
    input wire          useDefKeyRAMIn                 , // Use Default Key for RAM In
    input wire          useDefKeyRAMInValid            , // Use Default Key for RAM In Valid
`ifdef RW_KEY_EXTENDED                      

    //$port_g ENCRWPIINTKEY0REG register.
    input wire [31 : 0] encrIntKeyRAMWord0In           , // Encryption WPI integrity Key for RAM In
    input wire          encrIntKeyRAMWord0InValid      , // Encryption WPI integrity Key for RAM In Valid

    //$port_g ENCRWPIINTKEY1REG register.
    input wire [31 : 0] encrIntKeyRAMWord1In           , // Encryption WPI integrity Key for RAM In
    input wire          encrIntKeyRAMWord1InValid      , // Encryption WPI integrity Key for RAM In Valid

    //$port_g ENCRWPIINTKEY2REG register.
    input wire [31 : 0] encrIntKeyRAMWord2In           , // Encryption WPI integrity Key for RAM In
    input wire          encrIntKeyRAMWord2InValid      , // Encryption WPI integrity Key for RAM In Valid

    //$port_g ENCRWPIINTKEY3REG register.
    input wire [31 : 0] encrIntKeyRAMWord3In           , // Encryption WPI integrity Key for RAM In
    input wire          encrIntKeyRAMWord3InValid      , // Encryption WPI integrity Key for RAM In Valid
`endif // RW_KEY_EXTENDED                      

    //$port_g ENCRRAMCONFIGREG register.
    input wire [ 7 : 0] staKeyMaxIndex                 , // STA Key Max Index

    //$port_g MIBTABLEWRITEREG register.
    input wire          mibWriteIn                     , // MIB Write In
    input wire          mibWriteInValid                , // MIB Write In Valid

    //$port_g MONOTONICCOUNTER1REG register.
    input wire [31 : 0] monotonicCounter1              , // Monotonic Counter 1

    //$port_g MONOTONICCOUNTER2LOREG register.
    input wire [31 : 0] monotonicCounterLow2In         , // Monotonic Counter 2 In
    input wire          monotonicCounterLow2InValid    , // Monotonic Counter 2 In Valid

    //$port_g MONOTONICCOUNTER2HIREG register.
    input wire [15 : 0] monotonicCounterHigh2In        , // Monotonic Counter 2 In
    input wire          monotonicCounterHigh2InValid   , // Monotonic Counter 2 In Valid

    //$port_g EDCACCABUSYREG register.
    input wire [31 : 0] ccaBusyDurIn                   , // CCA Busy Duration In
    input wire          ccaBusyDurInValid              , // CCA Busy Duration In Valid

    //$port_g EDCACNTRLREG register.
    input wire          sendCFEndNowIn                 , // Send CF-End Now In
    input wire          sendCFEndNowInValid            , // Send CF-End Now In Valid

    //$port_g QUIETELEMENT1AREG register.
    input wire [15 : 0] quietDuration1In               , // Quiet Duration 1 In
    input wire          quietDuration1InValid          , // Quiet Duration 1 In Valid
    input wire [ 7 : 0] quietPeriod1In                 , // Quiet Period 1 In
    input wire          quietPeriod1InValid            , // Quiet Period 1 In Valid
    input wire [ 7 : 0] quietCount1In                  , // Quiet Count 1 In
    input wire          quietCount1InValid             , // Quiet Count 1 In Valid

    //$port_g QUIETELEMENT1BREG register.
    input wire [15 : 0] quietOffset1In                 , // Quiet Offset 1 In
    input wire          quietOffset1InValid            , // Quiet Offset 1 In Valid

    //$port_g ADDCCABUSYSEC20REG register.
    input wire [31 : 0] ccaBusyDurSec20In              , // CCA Busy Duration on secondary 20MHz In
    input wire          ccaBusyDurSec20InValid         , // CCA Busy Duration on secondary 20MHz In Valid

    //$port_g ADDCCABUSYSEC40REG register.
    input wire [31 : 0] ccaBusyDurSec40In              , // CCA Busy Duration on secondary 40MHz In
    input wire          ccaBusyDurSec40InValid         , // CCA Busy Duration on secondary 40MHz In Valid

    //$port_g ADDCCABUSYSEC80REG register.
    input wire [31 : 0] ccaBusyDurSec80In              , // CCA Busy Duration on secondary 80MHz In
    input wire          ccaBusyDurSec80InValid         , // CCA Busy Duration on secondary 80MHz In Valid
`ifdef RW_BFMEE_EN                          
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      

    //$port_g COEXSTATREG register.
    input wire [ 3 : 0] coexWlanPTIState               , // Coex Wlan PTI State
    input wire          coexWlanPTIToggleState         , // Coex Wlan PTI Toggle State
    input wire          coexWlanChanBwState            , // Coex Wlan Channel Bandwidth State
    input wire          coexWlanRxState                , // Coex Wlan Rx State
    input wire          coexWlanTxState                , // Coex Wlan Tx State
    input wire          coexWlanRxAbortState           , // Coex Wlan Rx Abort State
    input wire          coexWlanTxAbortState           , // Coex Wlan Tx Abort State
`endif // RW_WLAN_COEX_EN                      

    //$port_g DEBUGHWSM1REG register.
    input wire [ 7 : 0] macControlLs                   , // MAC Controller Latched State
    input wire [ 8 : 0] txControlLs                    , // Transmit Controller Latched State
    input wire [ 5 : 0] rxControlLs                    , // Receive Controller Latched State 

    //$port_g DEBUGHWSM2REG register.
    input wire [ 7 : 0] macControlCs                   , // MAC Controller Current State
    input wire [ 8 : 0] txControlCs                    , // Transmit Controller Current State
    input wire [ 5 : 0] rxControlCs                    , // Receive Controller Current State 

    //$port_g DEBUGPORTVALUEREG register.
    input wire [31 : 0] debugPortRead                  , // This register reflects the value of the debugPort [31:0] signals, the 32 top level debug signals.

    //$port_g DEBUGBASICNAVREG register.
    input wire [25 : 0] basicNAVCounterIn              , // Basic Network Allocation Vector Counter. In
    input wire          basicNAVCounterInValid         , // Basic Network Allocation Vector Counter. In Valid

    //$port_g DEBUGCWREG register.
    input wire [ 2 : 0] activeAC                       , // Current Access Category
    input wire [ 3 : 0] currentCW3                     , // Current Contention Window for AC3
    input wire [ 3 : 0] currentCW2                     , // Current Contention Window for AC2
    input wire [ 3 : 0] currentCW1                     , // Current Contention Window for AC1
    input wire [ 3 : 0] currentCW0                     , // Current Contention Window for AC0

    //$port_g DEBUGQSRCREG register.
    input wire [ 7 : 0] ac3QSRC                        , // AC 3 QoS station Short Retry Count
    input wire [ 7 : 0] ac2QSRC                        , // AC 2 QoS station Short Retry Count
    input wire [ 7 : 0] ac1QSRC                        , // AC 1 QoS station Short Retry Count
    input wire [ 7 : 0] ac0QSRC                        , // AC 0 QoS station Short Retry Count

    //$port_g DEBUGQLRCREG register.
    input wire [ 7 : 0] ac3QLRC                        , // AC 3 QoS station Long Retry Count
    input wire [ 7 : 0] ac2QLRC                        , // AC 2 QoS station Long Retry Count
    input wire [ 7 : 0] ac1QLRC                        , // AC 1 QoS station Long Retry Count
    input wire [ 7 : 0] ac0QLRC                        , // AC 0 QoS station Long Retry Count

    //$port_g DEBUGUORAREG register.
    input wire [ 6 : 0] ocwLFSRIn                      , // OFDMA Contention Window LFSR In
    input wire          ocwLFSRInValid                 , // OFDMA Contention Window LFSR In Valid

    //$port_g DEBUGINTRANAVREG register.
    input wire [15 : 0] intraNAVCounterIn              , // Intra BSS Network Allocation Vector Counter. In
    input wire          intraNAVCounterInValid         , // Intra BSS Network Allocation Vector Counter. In Valid
    //

    //$port_g MACADDRLOWREG register.
    output wire [31 : 0] macAddrLow                    , // MAC Address

    //$port_g MACADDRHIREG register.
    output wire [15 : 0] macAddrHigh                   , // MAC Address

    //$port_g MACADDRLOWMASKREG register.
    output wire [31 : 0] macAddrLowMask                , // MAC Address Mask

    //$port_g MACADDRHIMASKREG register.
    output wire [15 : 0] macAddrHighMask               , // MAC Address Mask

    //$port_g BSSIDLOWREG register.
    output wire [31 : 0] bssIDLow                      , // BSSID

    //$port_g BSSIDHIREG register.
    output wire [15 : 0] bssIDHigh                     , // BSSID

    //$port_g BSSIDLOWMASKREG register.
    output wire [31 : 0] bssIDLowMask                  , // BSSID Mask

    //$port_g BSSIDHIMASKREG register.
    output wire [15 : 0] bssIDHighMask                 , // BSSID Mask

    //$port_g BSSCOLORREG register.
    output wire          partialBSSColorEn             , // Partial BSS Color Enable
    output wire          bssColorEn                    , // BSS Color Enable
    output wire [ 5 : 0] bssColor                      , // BSS Color

    //$port_g STATECNTRLREG register.
    output wire [ 3 : 0] nextState                     , // Next State

    //$port_g SCANCNTRLREG register.
    output wire [ 2 : 0] primaryChPosition             , // Primary Channel Position
    output wire [15 : 0] probeDelay                    , // Probe Delay

    //$port_g DOZECNTRL1REG register.
    output wire          wakeupDTIM                    , // Wakeup DTIM interval
    output wire [15 : 0] listenInterval                , // Listen Interval

    //$port_g MACCNTRL1REG register.
    output wire          rxRIFSEn                      , // Rx RIFS Enable
    output wire          tsfMgtDisable                 , // TSF Management Disable
    output wire          tsfUpdatedBySW                , // TSF Updated By SW
    output wire          disableSVDRxPause             , // Disable reception pause during SVD Processing.
    output wire          disableBQRResp                , // Disable BQR Response
    output wire [ 2 : 0] abgnMode                      , // 802.11a/b/g/n/ac Mode
    output wire          keyStoRAMReset                , // Key Storage RAM Reset
    output wire          mibTableReset                 , // MIB Table reset
    output wire          rateControllerMPIF            , // Rate Controlled MAC-PHY InterFace
    output wire          disableBAResp                 , // Disable BA Response
    output wire          disableCTSResp                , // Disable CTS Response
    output wire          disableACKResp                , // Disable ACK Response
    output wire          activeClkGating               , // Active Clock Gating
    output wire          enableLPClkSwitch             , // Enable the switch to Low Power clock
    output wire          lpClk32786Hz                  , // LowPower Clock 32768Hz
    output wire          pwrMgt                        , // Power Management
    output wire          ap                            , // Access Point
    output wire          bssType                       , // BSS Type

    //$port_g MACERRRECCNTRLREG register.
    output wire          rxFlowCntrlEn                 , // RX Flow Control Enable
    output wire          baPSBitmapReset               , // Block ACK Partial Bitmap Reset
    output wire          macPHYIFFIFOReset             , // MAC-PHY InterFace FIFO Reset
    output wire          txFIFOReset                   , // Transmit FIFO Reset
    output wire          rxFIFOReset                   , // Receive FIFO Reset
    output wire          hwFSMReset                    , // Hardware Finite State Machine Reset
    output wire          useErrDet                     , // Use Error Detection

    //$port_g MACERRSETSTATUSREG register.
    output wire          errInHWLevel3                 , // Error in HW - Level 3
    output wire          errInTxRxLevel2               , // Error in Transmit/Receive - Level 2
    output wire          errInRxLevel1                 , // Error In Receive - Level 1
    output wire          errInTxLevel1                 , // Error In Transmit - Level 1

    //$port_g MACERRCLEARSTATUSREG register.
    output wire          clearErrInHWLevel3            , // Error in HW - Level 3
    output wire          clearErrInTxRxLevel2          , // Error in Transmit/Receive - Level 2
    output wire          clearErrInRxLevel1            , // Error In Receive - Level 1
    output wire          clearErrInTxLevel1            , // Error In Transmit - Level 1

    //$port_g RXCNTRLREG register.
    output wire          acceptUnknown                 , // Accept Unknown Type field
    output wire          acceptOtherDataFrames         , // Accept Other Data Frames
    output wire          acceptQoSNull                 , // Accept QoS Null
    output wire          acceptQCFWOData               , // Accept QoS CF WithOut Data
    output wire          acceptQData                   , // Accept QoS Data
    output wire          acceptCFWOData                , // Accept CF WithOut Data
    output wire          acceptData                    , // Accept Data
    output wire          acceptOtherCntrlFrames        , // Accept Other Control Frames
    output wire          acceptCFEnd                   , // Accept CF-End
    output wire          acceptACK                     , // Accept ACK
    output wire          acceptCTS                     , // Accept CTS
    output wire          acceptRTS                     , // Accept RTS
    output wire          acceptPSPoll                  , // Accept PS-Poll
    output wire          acceptBA                      , // Accept Block Ack
    output wire          acceptBAR                     , // Accept Block Ack Request
    output wire          acceptOtherMgmtFrames         , // Accept Other Management Frames
    output wire          acceptBfmeeFrames             , // Accept All Beamformee Frames
    output wire          acceptAllBeacon               , // Accept All Beacon
    output wire          acceptNotExpectedBA           , // Accept Not Expected BA
    output wire          acceptDecryptErrorFrames      , // Accept Decryption Error Frames
    output wire          acceptBeacon                  , // Accept Beacon
    output wire          acceptProbeResp               , // Accept Probe Response
    output wire          acceptProbeReq                , // Accept Probe Request
    output wire          acceptMyUnicast               , // Accept My Unicast
    output wire          acceptUnicast                 , // Accept Unicast
    output wire          acceptErrorFrames             , // Accept Error Frames
    output wire          acceptOtherBSSID              , // Accept Other BSSID
    output wire          acceptBroadcast               , // Accept Broadcast 
    output wire          acceptMulticast               , // Accept Multicast 
    output wire          dontDecrypt                   , // Don't Decrypt
    output wire          excUnencrypted                , // Exclude Unencrypted Receive fragments

    //$port_g BCNCNTRL1REG register.
    output wire [ 7 : 0] noBcnTxTime                   , // No Beacon Transmit Time
    output wire          impTBTTIn128Us                , // Impending TBTT Interrupt Period in 128us
    output wire [ 6 : 0] impTBTTPeriod                 , // Impending TBTT Period
    output wire [15 : 0] beaconInt                     , // Beacon Interval 

    //$port_g BCNCNTRL2REG register.
    output wire [15 : 0] aid                           , // Association ID
    output wire [ 7 : 0] timOffset                     , // TIM Offset
    output wire [ 7 : 0] bcnUpdateOffset               , // Beacon Update Offset

    //$port_g DTIM1REG register.
    output wire          dtimUpdatedBySW               , // DTIM Updated by SW
    output wire [ 7 : 0] dtimPeriod                    , // DTIM Period

    //$port_g RETRYLIMITSREG register.
    output wire [ 7 : 0] dot11LongRetryLimit           , // Dot11 Long Retry Limit
    output wire [ 7 : 0] dot11ShortRetryLimit          , // Dot11 Short Retry Limit

    //$port_g BBSERVICEREG register.
    output wire [ 2 : 0] maxPHYNtx                     , // Maximum number of PHY Transmit Chains
    output wire [ 7 : 0] bbServiceB                    , // This field contains the service field that is to be sent to the baseband. The 8 bits from this field are transmitted to the BB in the lower 8 bits of the Service field of the Tx Vector when the modulation is DSSS/CCK.
    output wire [15 : 0] bbServiceA                    , // This field contains the service field that is to be sent to the baseband. The 16 bits from this field are transmitted to the BB in the 16 bits of the Service field of the Tx-Vector when the modulation is OFDM.

    //$port_g MAXPOWERLEVELREG register.
    output wire [ 7 : 0] ofdmMinPwrLevel               , // OFDM Minimum Power Level
    output wire [ 7 : 0] dsssMaxPwrLevel               , // DSSS Maximum Power Level
    output wire [ 7 : 0] ofdmMaxPwrLevel               , // OFDM Maximum Power Level

    //$port_g ENCRKEY0REG register.
    output wire [31 : 0] encrKeyRAMWord0               , // Encryption Key for RAM

    //$port_g ENCRKEY1REG register.
    output wire [31 : 0] encrKeyRAMWord1               , // Encryption Key for RAM

    //$port_g ENCRKEY2REG register.
    output wire [31 : 0] encrKeyRAMWord2               , // It contains bits 95 to 64 of the 104-bit WEP key or the TKIP/CCMP/WAPI key to be programmed in the Key Storage RAM.

    //$port_g ENCRKEY3REG register.
    output wire [31 : 0] encrKeyRAMWord3               , // Encryption Key for RAM

    //$port_g ENCRMACADDRLOWREG register.
    output wire [31 : 0] macAddrRAMLow                 , // MAC Address for RAM

    //$port_g ENCRMACADDRHIGHREG register.
    output wire [15 : 0] macAddrRAMHigh                , // MAC Address for RAM

    //$port_g ENCRCNTRLREG register.
    output wire          newRead                       , // New Read
    output wire          newWrite                      , // New Write
    output wire          newSearch                     , // New Search
    output wire          searchError                   , // Search Error
    output wire [ 9 : 0] keyIndexRAM                   , // Key Index RAM
    output wire [ 1 : 0] cLenRAM                       , // Cipher Length for RAM
    output wire [ 2 : 0] cTypeRAM                      , // Cipher Type for RAM
    output wire [ 3 : 0] vlanIDRAM                     , // Virtual LAN ID for RAM
    output wire [ 1 : 0] sppRAM                        , // SPP for RAM
    output wire          useDefKeyRAM                  , // Use Default Key for RAM
`ifdef RW_KEY_EXTENDED                      

    //$port_g ENCRWPIINTKEY0REG register.
    output wire [31 : 0] encrIntKeyRAMWord0            , // Encryption WPI integrity Key for RAM

    //$port_g ENCRWPIINTKEY1REG register.
    output wire [31 : 0] encrIntKeyRAMWord1            , // Encryption WPI integrity Key for RAM

    //$port_g ENCRWPIINTKEY2REG register.
    output wire [31 : 0] encrIntKeyRAMWord2            , // Encryption WPI integrity Key for RAM

    //$port_g ENCRWPIINTKEY3REG register.
    output wire [31 : 0] encrIntKeyRAMWord3            , // Encryption WPI integrity Key for RAM
`endif // RW_KEY_EXTENDED                      

    //$port_g ENCRRAMCONFIGREG register.
    output wire [ 3 : 0] nVAP                          , // Number of VAP
    output wire [ 7 : 0] staKeyEndIndex                , // STA Key End Index
    output wire [ 7 : 0] staKeyStartIndex              , // STA Key Start Index

    //$port_g RATESREG register.
    output wire [11 : 0] bssBasicRateSet               , // BSS Basic Rate Set

    //$port_g OLBCREG register.
    output wire [ 7 : 0] dsssCount                     , // DSSS/CCK Count
    output wire [ 7 : 0] ofdmCount                     , // OFDM Count
    output wire [15 : 0] olbcTimer                     , // OLBC Timer

    //$port_g TIMINGS1REG register.
    output wire [ 9 : 0] txChainDelayInMACClk          , // Transmit Chain Delay in MAC Clocks
    output wire [ 9 : 0] txRFDelayInMACClk             , // Transmit RF Delay in MAC Clocks
    output wire [ 7 : 0] macCoreClkFreq                , // MAC Core Clock Frequency

    //$port_g TIMINGS2REG register.
    output wire [15 : 0] slotTimeInMACClk              , // This register should be programmed with the value of macCoreClkFreq * slotTime.
    output wire [ 7 : 0] slotTime                      , // This field is programmed with the aSlotTime parameter. 

    //$port_g TIMINGS3REG register.
    output wire [ 9 : 0] rxRFDelayInMACClk             , // Receive RF Delay in MAC Clock
    output wire [ 9 : 0] macProcDelayInMACClk          , // MAC Processing Delay in MAC clocks

    //$port_g TIMINGS4REG register.
    output wire [ 9 : 0] radioWakeUpTime               , // Radio Wakeup Time
    output wire [ 9 : 0] radioChirpTime                , // Radio Chirp Time
    output wire [ 1 : 0] wt2CryptClkRatio              , // Define the clock ratio between wtClk and macCryptClk

    //$port_g TIMINGS5REG register.
    output wire [15 : 0] sifsBInMACClk                 , // This register should be programmed with the value of macCoreClkFreq * sifsB.
    output wire [ 7 : 0] sifsB                         , // SIFS Duration for 2.4GHz band

    //$port_g TIMINGS6REG register.
    output wire [15 : 0] sifsAInMACClk                 , // This register should be programmed with the value of macCoreClkFreq * sifsA.
    output wire [ 7 : 0] sifsA                         , // SIFS Duration for 5GHz band

    //$port_g TIMINGS7REG register.
    output wire [ 3 : 0] rxCCADelay                    , // Receive Chain CCA Delay

    //$port_g TIMINGS8REG register.
    output wire [ 7 : 0] rxStartDelayMIMO              , // Receive Start Delay for MIMO
    output wire [ 7 : 0] rxStartDelayShort             , // Receive Start Delay with Short preamble
    output wire [ 7 : 0] rxStartDelayLong              , // Receive Start Delay with Long preamble
    output wire [ 7 : 0] rxStartDelayOFDM              , // Receive Start Delay for OFDM

    //$port_g TIMINGS9REG register.
    output wire [ 9 : 0] rifsTOInMACClk                , // This register should be programmed with the value of RIFS TimeOut in terms of macCoreClk clock cycles.
    output wire [ 9 : 0] txDMAProcDlyInMACClk          , // Transmit DMA Processing Delay in MAC Clocks

    //$port_g RXCNTRL2 register.
    output wire          disableRxBuffer2              , // Disable Rx Buffer 2
    output wire          dataMHStoredwithPld           , // Data Frame Mac Header Stored With Payload
    output wire          mgtMHStoredwithPld            , // Management Frame Mac Header Stored With Payload
    output wire          ctrlMHStoredwithPld           , // Control Frame Mac Header Stored With Payload
    output wire [ 7 : 0] partialUnwrapSize             , // Partial Unwrap Size
    output wire [ 1 : 0] dataFrmWrapMode               , // Data Frame Wrap Mode
    output wire [ 1 : 0] mgtFrmWrapMode                , // Management Frame Wrap Mode
    output wire [ 1 : 0] ctrlFrmWrapMode               , // Control Frame Wrap Mode

    //$port_g TXTRIGGERTIMERREG register.
    output wire [ 7 : 0] txPacketTimeout               , // Transmission Packet Timeout
    output wire [ 7 : 0] txAbsoluteTimeout             , // Transmission Absolute Timeout

    //$port_g RXTRIGGERTIMERREG register.
    output wire [ 7 : 0] rxPacketTimeout               , // Reception Packet Timeout
    output wire [ 7 : 0] rxAbsoluteTimeout             , // Reception Absolute Timeout

    //$port_g MIBTABLEWRITEREG register.
    output wire [15 : 0] mibValue                      , // MIB Value
    output wire          mibWrite                      , // MIB Write
    output wire          mibIncrementMode              , // MIB Increment Mode
    output wire [ 9 : 0] mibTableIndex                 , // MIB Table Index

    //$port_g MONOTONICCOUNTER2LOREG register.
    output wire [31 : 0] monotonicCounterLow2          , // Monotonic Counter 2

    //$port_g MONOTONICCOUNTER2HIREG register.
    output wire          monotonicCounter2SWUpdate     , // Monotonic Counter 2 SW Update
    output wire [15 : 0] monotonicCounterHigh2         , // Monotonic Counter 2

    //$port_g ABSTIMERREG0 register.
    output wire [31 : 0] absTimerValue0                , // Absolute Timer Value

    //$port_g ABSTIMERREG1 register.
    output wire [31 : 0] absTimerValue1                , // Absolute Timer Value

    //$port_g ABSTIMERREG2 register.
    output wire [31 : 0] absTimerValue2                , // Absolute Timer Value

    //$port_g ABSTIMERREG3 register.
    output wire [31 : 0] absTimerValue3                , // Absolute Timer Value

    //$port_g ABSTIMERREG4 register.
    output wire [31 : 0] absTimerValue4                , // Absolute Timer Value

    //$port_g ABSTIMERREG5 register.
    output wire [31 : 0] absTimerValue5                , // Absolute Timer Value

    //$port_g ABSTIMERREG6 register.
    output wire [31 : 0] absTimerValue6                , // Absolute Timer Value

    //$port_g ABSTIMERREG7 register.
    output wire [31 : 0] absTimerValue7                , // Absolute Timer Value

    //$port_g ABSTIMERREG8 register.
    output wire [31 : 0] absTimerValue8                , // Absolute Timer Value

    //$port_g ABSTIMERREG9 register.
    output wire [31 : 0] absTimerValue9                , // Absolute Timer Value

    //$port_g MAXRXLENGTHREG register.
    output wire [19 : 0] maxAllowedLength              , // Max Rx Length 

    //$port_g EDCAAC0REG register.
    output wire [15 : 0] txOpLimit0                    , // Transmit Opportunity Limit for AC 0
    output wire [ 3 : 0] cwMax0                        , // Maximum CW for AC 0
    output wire [ 3 : 0] cwMin0                        , // Minimum CW for AC 0
    output wire [ 3 : 0] aifsn0                        , // AIFSN for AC 0

    //$port_g EDCAAC1REG register.
    output wire [15 : 0] txOpLimit1                    , // Transmit Opportunity Limit for AC 1
    output wire [ 3 : 0] cwMax1                        , // Maximum CW for AC 1
    output wire [ 3 : 0] cwMin1                        , // Minimum CW for AC 1
    output wire [ 3 : 0] aifsn1                        , // AIFSN for AC 1

    //$port_g EDCAAC2REG register.
    output wire [15 : 0] txOpLimit2                    , // Transmit Opportunity Limit for AC 2
    output wire [ 3 : 0] cwMax2                        , // Maximum CW for AC 2
    output wire [ 3 : 0] cwMin2                        , // Minimum CW for AC 2
    output wire [ 3 : 0] aifsn2                        , // AIFSN for AC 2

    //$port_g EDCAAC3REG register.
    output wire [15 : 0] txOpLimit3                    , // Transmit Opportunity Limit for AC 3
    output wire [ 3 : 0] cwMax3                        , // Maximum CW for AC 3
    output wire [ 3 : 0] cwMin3                        , // Minimum CW for AC 3
    output wire [ 3 : 0] aifsn3                        , // AIFSN for AC 3

    //$port_g EDCACCABUSYREG register.
    output wire [31 : 0] ccaBusyDur                    , // CCA Busy Duration

    //$port_g EDCACNTRLREG register.
    output wire          keepTXOPOpen                  , // Keep TXOP Open
    output wire          remTXOPInDurField             , // Remaining TXOP Indicated in Duration Field
    output wire          sendCFEnd                     , // Send CF-End
    output wire          sendCFEndNow                  , // Send CF-End Now

    //$port_g QUIETELEMENT1AREG register.
    output wire [15 : 0] quietDuration1                , // Quiet Duration 1
    output wire [ 7 : 0] quietPeriod1                  , // Quiet Period 1
    output wire [ 7 : 0] quietCount1                   , // Quiet Count 1

    //$port_g QUIETELEMENT1BREG register.
    output wire [15 : 0] quietOffset1                  , // Quiet Offset 1

    //$port_g ADDCCABUSYSEC20REG register.
    output wire [31 : 0] ccaBusyDurSec20               , // CCA Busy Duration on secondary 20MHz

    //$port_g ADDCCABUSYSEC40REG register.
    output wire [31 : 0] ccaBusyDurSec40               , // CCA Busy Duration on secondary 40MHz

    //$port_g ADDCCABUSYSEC80REG register.
    output wire [31 : 0] ccaBusyDurSec80               , // CCA Busy Duration on secondary 80MHz

    //$port_g STBCCNTRLREG register.
    output wire [ 6 : 0] basicSTBCMCS                  , // Basic STBC MCS
    output wire          dualCTSProt                   , // Dual-CTS Protection
    output wire [ 7 : 0] ctsSTBCDur                    , // CTS STBC Duration
    output wire [15 : 0] cfEndSTBCDur                  , // CF-End STBC Duration

    //$port_g TXBWCNTRLREG register.
    output wire [ 1 : 0] maxSupportedBW                , // Max Supported Bandwidth
    output wire [ 7 : 0] aPPDUMaxTime                  , // aPPDU Maximum Time
    output wire          dynBWEn                       , // Dynamic Bandwidth Enable
    output wire [ 2 : 0] numTryBWAcquisition           , // Number of Tries for Requested Bandwidth Acquisition
    output wire          dropToLowerBW                 , // Drop To Lower Bandwidth PPDU
    output wire [ 1 : 0] defaultBWTXOP                 , // Default Bandwidth TXOP
    output wire          defaultBWTXOPV                , // Default BW TXOP Valid

    //$port_g HTMCSREG register.
    output wire [ 5 : 0] bssBasicHTMCSSetUM            , // BSS Basic MCS Set for Equal Modulation
    output wire [15 : 0] bssBasicHTMCSSetEM            , // BSS Basic MCS Set for Unequal Modulation

    //$port_g VHTMCSREG register.
    output wire [15 : 0] bssBasicVHTMCSSet             , // BSS Basic VHT MCS Set

    //$port_g LSTPREG register.
    output wire          supportLSTP                   , // Support of L-SIG TXOP

    //$port_g HECONFIGREG register.
    output wire          dcmSupport                    , // DCM Support
    output wire          dopplerSupport                , // Doppler Support
    output wire          enableOBSSPD                  , // Enable OBSS PD Spatial Reuse
    output wire          enableSRP                     , // Enable SRP Spatial Reuse
    output wire          acceptAllTriggerFrames        , // Accept All Trigger Frame
    output wire          acceptTriggerSWFrames         , // Accept Trigger Frame handled by SW 
    output wire          acceptTriggerHWFrames         , // Accept Trigger Frame handled by HW 
    output wire          disableTBUPH                  , // Disable UPH Control field in HE TB Response
    output wire          disableTBRU26Resp             , // Disable 26-tones RU on Trigger Based Response
    output wire          disableTBCS                   , // Disable Carrier Sense on Trigger Based Response
    output wire          disableTBResp                 , // Disable Trigger Based Response
    output wire [ 2 : 0] defaultPEDur                  , // Provide the PE default duration used for trigger based transmission in TRS

    //$port_g SPCONFIG1REG register.
    output wire [ 7 : 0] srgOBSSPDMaxOffset            , // SRG OBSS PD Max Offset
    output wire [ 7 : 0] srgOBSSPDMinOffset            , // SRG OBSS PD Min Offset
    output wire [ 7 : 0] nonSRGOBSSPDMaxOffset         , // Non-SRG OBSS PD Max Offset
    output wire          srgInformationPresent         , // SRG Information Present
    output wire          nonSRGOffsetPresent           , // Non-SRG Offset Present 
    output wire          nonSRGOBSSPDSRDisallowed      , // Non-SRG OBSS PD SR Disallowed
    output wire          SRPDisallowed                 , // SRP Disallowed

    //$port_g SRGBSSCOLORBITMAPLOWREG register.
    output wire [31 : 0] SRGBSSColorBitmapLow          , // SRG BSS Color Bitmap

    //$port_g SRGBSSCOLORBITMAPHIGHREG register.
    output wire [31 : 0] SRGBSSColorBitmapHigh         , // SRG BSS Color Bitmap

    //$port_g SRGPARTIALBSSIDBITMAPLOWREG register.
    output wire [31 : 0] SRGPartialBSSIDBitmapLow      , // Partial BSSID Bitmap

    //$port_g SRGPARTIALBSSIDBITMAPHIGHREG register.
    output wire [31 : 0] SRGPartialBSSIDBitmapHigh     , // Partial BSSID Bitmap
`ifdef RW_BFMEE_EN                          

    //$port_g BFMEECONTROLREG register.
    output wire [ 1 : 0] bfrHELTFType                  , // Beamforming Report giType (HE Only)
    output wire [ 1 : 0] bfrGIType                     , // Beamforming Report HE-LTF-TYPE(HE Only)
    output wire [ 2 : 0] bfrFormatMod                  , // Beamforming Report Format Modulation
    output wire          bfrShortGI                    , // Beamforming Report Short GI
    output wire [ 7 : 0] bfrMCS                        , // Beamforming Report MCS
    output wire [ 2 : 0] bfmeeNc                       , // Beamformee Number of columns
    output wire [ 2 : 0] bfmeeNr                       , // Beamformee Number of rows
    output wire [ 1 : 0] bfmeeGrouping                 , // Beamformee Grouping
    output wire          bfmeeCodebook                 , // Beamformee Codebook
    output wire          bfmeeMUSupport                , // Beamformee MU Support
    output wire          bfmeeEnable                   , // Beamformee Enable
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      

    //$port_g COEXCONTROLREG register.
    output wire [ 3 : 0] coexForceWlanPTI              , // Coex Force Wlan PTI output
    output wire          coexForceWlanPTIToggle        , // Coex Force Wlan PTI toggle output
    output wire          coexForceWlanChanBw           , // Coex Force Wlan Channel Bandwidth  output
    output wire          coexForceWlanRx               , // Coex Force Wlan Rx output
    output wire          coexForceWlanTx               , // Coex Force Wlan Tx output
    output wire [ 6 : 0] coexWlanChanFreq              , // Coex Wlan Channel Frequency 
    output wire          coexWlanChanOffset            , // Coex Wlan Channel offset
    output wire [ 1 : 0] coexAutoPTIAdjIncr            , // Coex Automatic PTI Adjustmnent Increment
    output wire          coexAutoPTIAdjEnable          , // Coex Automatic  PTI Adjustment Enable
    output wire          coexForceEnable               , // Coex Force Enable
    output wire          coexPostponeTxEnable          , // Coex Postpone Tx Enable
    output wire          coexPHYRxAbortEnable          , // Coex Phy Rx Abort Enable.
    output wire          coexPHYTxAbortEnable          , // Coex Phy Tx Abort Enable.
    output wire          coexEnable                    , // Coex Enable

    //$port_g COEXPTIREG register.
    output wire [ 3 : 0] coexPTIBcnData                , // Coex Packet traffic information for Data frames sent on the Beacon Channel
    output wire [ 3 : 0] coexPTIBKData                 , // Coex Packet traffic information for Data frames sent on the AC BK Channel
    output wire [ 3 : 0] coexPTIBEData                 , // Coex Packet traffic information for Data frames sent on the AC BE Channel
    output wire [ 3 : 0] coexPTIVIData                 , // Coex Packet traffic information for Data frames sent on the AC VI Channel
    output wire [ 3 : 0] coexPTIVOData                 , // Coex Packet traffic information for Data frames sent on the AC VO Channel
    output wire [ 3 : 0] coexPTIMgt                    , // Coex Packet traffic information for Management frames
    output wire [ 3 : 0] coexPTICntl                   , // Coex Packet traffic information for Control frames
    output wire [ 3 : 0] coexPTIAck                    , // Coex Packet traffic information for Ack/BA frames

    //$port_g COEXINTREG register.
    output wire          coexWlanRxAbortFallEn         , // Coex Wlan Rx Abort Falling Edge Enable
    output wire          coexWlanRxAbortRiseEn         , // Coex Wlan Rx Abort Rising Edge Enable
    output wire          coexWlanTxAbortFallEn         , // Coex Wlan Tx Abort Falling Edge Enable
    output wire          coexWlanTxAbortRiseEn         , // Coex Wlan Tx Abort Rising Edge Enable
`endif // RW_WLAN_COEX_EN                      

    //$port_g DEBUGPORTSELREG register.
    output wire [ 7 : 0] debugPortSel2                 , // Debug Port Selection 2
    output wire [ 7 : 0] debugPortSel1                 , // Debug Port Selection 1

    //$port_g DEBUGBASICNAVREG register.
    output wire [25 : 0] basicNAVCounter               , // Basic Network Allocation Vector Counter.

    //$port_g DEBUGCWREG register.
    output wire [ 1 : 0] backoffOffset                 , // Backoff Offset

    //$port_g DEBUGUORAREG register.
    output wire [ 6 : 0] ocwLFSR                       , // OFDMA Contention Window LFSR

    //$port_g DEBUGPHYREG register.
    output wire          rxEndForTimingErrRec          , // rxReq Force Deassertion
    output wire          rxReqForceDeassertion         , // rxEndForTiming Error Recovery

    //$port_g DEBUGINTRANAVREG register.
    output wire [15 : 0] intraNAVCounter               , // Intra BSS Network Allocation Vector Counter.

    ////////////////////////////////////////////
    //$port_g APB slave
    ////////////////////////////////////////////
    input wire           regSel            , // Device select.
    input wire           regWrite          , // Defines the enable cycle.
    input wire           regRead           , // Write signal.
    input wire [12 : 0]  regAddr           , // Address.
    input wire [31 : 0]  regWriteData      , // Write data.
    // 
    output reg [31 : 0]  regReadData         // Read data.

    
  );
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////
 
//////////////////////////////////////////////////////////////////////////////
// Constants for registers addresses
//////////////////////////////////////////////////////////////////////////////

  // Constants for register addresses.
localparam SIGNATUREREG_ADDR_CT                  = 13'b000000000000;
localparam VERSION1REG_ADDR_CT                   = 13'b000000000001;
localparam VERSION2REG_ADDR_CT                   = 13'b000000000010;
localparam BITMAPCNTREG_ADDR_CT                  = 13'b000000000011;
localparam MACADDRLOWREG_ADDR_CT                 = 13'b000000000100;
localparam MACADDRHIREG_ADDR_CT                  = 13'b000000000101;
localparam MACADDRLOWMASKREG_ADDR_CT             = 13'b000000000110;
localparam MACADDRHIMASKREG_ADDR_CT              = 13'b000000000111;
localparam BSSIDLOWREG_ADDR_CT                   = 13'b000000001000;
localparam BSSIDHIREG_ADDR_CT                    = 13'b000000001001;
localparam BSSIDLOWMASKREG_ADDR_CT               = 13'b000000001010;
localparam BSSIDHIMASKREG_ADDR_CT                = 13'b000000001011;
localparam BSSCOLORREG_ADDR_CT                   = 13'b000000001101;
localparam STATECNTRLREG_ADDR_CT                 = 13'b000000001110;
localparam SCANCNTRLREG_ADDR_CT                  = 13'b000000001111;
localparam DOZECNTRL1REG_ADDR_CT                 = 13'b000000010001;
localparam MACCNTRL1REG_ADDR_CT                  = 13'b000000010011;
localparam MACERRRECCNTRLREG_ADDR_CT             = 13'b000000010101;
localparam MACERRSETSTATUSREG_ADDR_CT            = 13'b000000010110;
localparam MACERRCLEARSTATUSREG_ADDR_CT          = 13'b000000010111;
localparam RXCNTRLREG_ADDR_CT                    = 13'b000000011000;
localparam BCNCNTRL1REG_ADDR_CT                  = 13'b000000011001;
localparam BCNCNTRL2REG_ADDR_CT                  = 13'b000000011010;
localparam DTIM1REG_ADDR_CT                      = 13'b000000100100;
localparam RETRYLIMITSREG_ADDR_CT                = 13'b000000100110;
localparam BBSERVICEREG_ADDR_CT                  = 13'b000000100111;
localparam MAXPOWERLEVELREG_ADDR_CT              = 13'b000000101000;
localparam ENCRKEY0REG_ADDR_CT                   = 13'b000000101011;
localparam ENCRKEY1REG_ADDR_CT                   = 13'b000000101100;
localparam ENCRKEY2REG_ADDR_CT                   = 13'b000000101101;
localparam ENCRKEY3REG_ADDR_CT                   = 13'b000000101110;
localparam ENCRMACADDRLOWREG_ADDR_CT             = 13'b000000101111;
localparam ENCRMACADDRHIGHREG_ADDR_CT            = 13'b000000110000;
localparam ENCRCNTRLREG_ADDR_CT                  = 13'b000000110001;
`ifdef RW_KEY_EXTENDED                      
localparam ENCRWPIINTKEY0REG_ADDR_CT             = 13'b000000110010;
localparam ENCRWPIINTKEY1REG_ADDR_CT             = 13'b000000110011;
localparam ENCRWPIINTKEY2REG_ADDR_CT             = 13'b000000110100;
localparam ENCRWPIINTKEY3REG_ADDR_CT             = 13'b000000110101;
`endif // RW_KEY_EXTENDED                      
localparam ENCRRAMCONFIGREG_ADDR_CT              = 13'b000000110110;
localparam RATESREG_ADDR_CT                      = 13'b000000110111;
localparam OLBCREG_ADDR_CT                       = 13'b000000111000;
localparam TIMINGS1REG_ADDR_CT                   = 13'b000000111001;
localparam TIMINGS2REG_ADDR_CT                   = 13'b000000111010;
localparam TIMINGS3REG_ADDR_CT                   = 13'b000000111011;
localparam TIMINGS4REG_ADDR_CT                   = 13'b000000111100;
localparam TIMINGS5REG_ADDR_CT                   = 13'b000000111101;
localparam TIMINGS6REG_ADDR_CT                   = 13'b000000111110;
localparam TIMINGS7REG_ADDR_CT                   = 13'b000000111111;
localparam TIMINGS8REG_ADDR_CT                   = 13'b000001000000;
localparam TIMINGS9REG_ADDR_CT                   = 13'b000001000001;
localparam RXCNTRL2_ADDR_CT                      = 13'b000001000011;
localparam TXTRIGGERTIMERREG_ADDR_CT             = 13'b000001000100;
localparam RXTRIGGERTIMERREG_ADDR_CT             = 13'b000001000101;
localparam MIBTABLEWRITEREG_ADDR_CT              = 13'b000001000110;
localparam MONOTONICCOUNTER1REG_ADDR_CT          = 13'b000001000111;
localparam MONOTONICCOUNTER2LOREG_ADDR_CT        = 13'b000001001000;
localparam MONOTONICCOUNTER2HIREG_ADDR_CT        = 13'b000001001001;
localparam ABSTIMERREG0_ADDR_CT                  = 13'b000001001010;
localparam ABSTIMERREG1_ADDR_CT                  = 13'b000001001011;
localparam ABSTIMERREG2_ADDR_CT                  = 13'b000001001100;
localparam ABSTIMERREG3_ADDR_CT                  = 13'b000001001101;
localparam ABSTIMERREG4_ADDR_CT                  = 13'b000001001110;
localparam ABSTIMERREG5_ADDR_CT                  = 13'b000001001111;
localparam ABSTIMERREG6_ADDR_CT                  = 13'b000001010000;
localparam ABSTIMERREG7_ADDR_CT                  = 13'b000001010001;
localparam ABSTIMERREG8_ADDR_CT                  = 13'b000001010010;
localparam ABSTIMERREG9_ADDR_CT                  = 13'b000001010011;
localparam MAXRXLENGTHREG_ADDR_CT                = 13'b000001010100;
localparam EDCAAC0REG_ADDR_CT                    = 13'b000010000000;
localparam EDCAAC1REG_ADDR_CT                    = 13'b000010000001;
localparam EDCAAC2REG_ADDR_CT                    = 13'b000010000010;
localparam EDCAAC3REG_ADDR_CT                    = 13'b000010000011;
localparam EDCACCABUSYREG_ADDR_CT                = 13'b000010001000;
localparam EDCACNTRLREG_ADDR_CT                  = 13'b000010001001;
localparam QUIETELEMENT1AREG_ADDR_CT             = 13'b000010100000;
localparam QUIETELEMENT1BREG_ADDR_CT             = 13'b000010100001;
localparam ADDCCABUSYSEC20REG_ADDR_CT            = 13'b000010100100;
localparam ADDCCABUSYSEC40REG_ADDR_CT            = 13'b000010100101;
localparam ADDCCABUSYSEC80REG_ADDR_CT            = 13'b000010100110;
localparam STBCCNTRLREG_ADDR_CT                  = 13'b000011000000;
localparam TXBWCNTRLREG_ADDR_CT                  = 13'b000011000100;
localparam HTMCSREG_ADDR_CT                      = 13'b000011000101;
localparam VHTMCSREG_ADDR_CT                     = 13'b000011000111;
localparam LSTPREG_ADDR_CT                       = 13'b000011001000;
localparam HECONFIGREG_ADDR_CT                   = 13'b000011001001;
localparam SPCONFIG1REG_ADDR_CT                  = 13'b000011001010;
localparam SRGBSSCOLORBITMAPLOWREG_ADDR_CT       = 13'b000011001011;
localparam SRGBSSCOLORBITMAPHIGHREG_ADDR_CT      = 13'b000011001100;
localparam SRGPARTIALBSSIDBITMAPLOWREG_ADDR_CT   = 13'b000011001101;
localparam SRGPARTIALBSSIDBITMAPHIGHREG_ADDR_CT  = 13'b000011001110;
`ifdef RW_BFMEE_EN                          
localparam BFMEECONTROLREG_ADDR_CT               = 13'b000011010100;
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      
localparam COEXCONTROLREG_ADDR_CT                = 13'b000100000000;
localparam COEXPTIREG_ADDR_CT                    = 13'b000100000001;
localparam COEXSTATREG_ADDR_CT                   = 13'b000100000010;
localparam COEXINTREG_ADDR_CT                    = 13'b000100000011;
`endif // RW_WLAN_COEX_EN                      
localparam DEBUGHWSM1REG_ADDR_CT                 = 13'b000101000000;
localparam DEBUGHWSM2REG_ADDR_CT                 = 13'b000101000001;
localparam DEBUGPORTVALUEREG_ADDR_CT             = 13'b000101000011;
localparam DEBUGPORTSELREG_ADDR_CT               = 13'b000101000100;
localparam DEBUGBASICNAVREG_ADDR_CT              = 13'b000101000101;
localparam DEBUGCWREG_ADDR_CT                    = 13'b000101000110;
localparam DEBUGQSRCREG_ADDR_CT                  = 13'b000101000111;
localparam DEBUGQLRCREG_ADDR_CT                  = 13'b000101001000;
localparam DEBUGUORAREG_ADDR_CT                  = 13'b000101010110;
localparam DEBUGPHYREG_ADDR_CT                   = 13'b000101010111;
localparam DEBUGINTRANAVREG_ADDR_CT              = 13'b000101011000;

//////////////////////////////////////////////////////////////////////////////
// Signals
//////////////////////////////////////////////////////////////////////////////
  // macAddrLowReg register.
  reg [31 : 0] int_macAddrLow                ;
  // macAddrHiReg register.
  reg [15 : 0] int_macAddrHigh               ;
  // macAddrLowMaskReg register.
  reg [31 : 0] int_macAddrLowMask            ;
  // macAddrHiMaskReg register.
  reg [15 : 0] int_macAddrHighMask           ;
  // bssIDLowReg register.
  reg [31 : 0] int_bssIDLow                  ;
  // bssIDHiReg register.
  reg [15 : 0] int_bssIDHigh                 ;
  // bssIDLowMaskReg register.
  reg [31 : 0] int_bssIDLowMask              ;
  // bssIDHiMaskReg register.
  reg [15 : 0] int_bssIDHighMask             ;
  // bssColorReg register.
  reg          int_partialBSSColorEn         ;
  reg          int_bssColorEn                ;
  reg [ 5 : 0] int_bssColor                  ;
  // stateCntrlReg register.
  reg [ 3 : 0] int_nextState                 ;
  // scanCntrlReg register.
  reg [ 2 : 0] int_primaryChPosition         ;
  reg [15 : 0] int_probeDelay                ;
  // dozeCntrl1Reg register.
  reg          int_wakeupDTIM                ;
  reg [15 : 0] int_listenInterval            ;
  // macCntrl1Reg register.
  reg          int_rxRIFSEn                  ;
  reg          int_tsfMgtDisable             ;
  reg          int_tsfUpdatedBySW            ;
  reg          int_disableSVDRxPause         ;
  reg          int_disableBQRResp            ;
  reg [ 2 : 0] int_abgnMode                  ;
  reg          int_keyStoRAMReset            ;
  reg          int_mibTableReset             ;
  reg          int_rateControllerMPIF        ;
  reg          int_disableBAResp             ;
  reg          int_disableCTSResp            ;
  reg          int_disableACKResp            ;
  reg          int_activeClkGating           ;
  reg          int_enableLPClkSwitch         ;
  reg          int_lpClk32786Hz              ;
  reg          int_pwrMgt                    ;
  reg          int_ap                        ;
  reg          int_bssType                   ;
  // macErrRecCntrlReg register.
  reg          int_rxFlowCntrlEn             ;
  reg          int_baPSBitmapReset           ;
  reg          int_macPHYIFFIFOReset         ;
  reg          int_txFIFOReset               ;
  reg          int_rxFIFOReset               ;
  reg          int_hwFSMReset                ;
  reg          int_useErrDet                 ;
  reg          int_errInHWLevel3             ;
  reg          int_errInTxRxLevel2           ;
  reg          int_errInRxLevel1             ;
  reg          int_errInTxLevel1             ;
  reg          int_clearErrInHWLevel3        ;
  reg          int_clearErrInTxRxLevel2      ;
  reg          int_clearErrInRxLevel1        ;
  reg          int_clearErrInTxLevel1        ;
  // rxCntrlReg register.
  reg          int_acceptUnknown             ;
  reg          int_acceptOtherDataFrames     ;
  reg          int_acceptQoSNull             ;
  reg          int_acceptQCFWOData           ;
  reg          int_acceptQData               ;
  reg          int_acceptCFWOData            ;
  reg          int_acceptData                ;
  reg          int_acceptOtherCntrlFrames    ;
  reg          int_acceptCFEnd               ;
  reg          int_acceptACK                 ;
  reg          int_acceptCTS                 ;
  reg          int_acceptRTS                 ;
  reg          int_acceptPSPoll              ;
  reg          int_acceptBA                  ;
  reg          int_acceptBAR                 ;
  reg          int_acceptOtherMgmtFrames     ;
  reg          int_acceptBfmeeFrames         ;
  reg          int_acceptAllBeacon           ;
  reg          int_acceptNotExpectedBA       ;
  reg          int_acceptDecryptErrorFrames  ;
  reg          int_acceptBeacon              ;
  reg          int_acceptProbeResp           ;
  reg          int_acceptProbeReq            ;
  reg          int_acceptMyUnicast           ;
  reg          int_acceptUnicast             ;
  reg          int_acceptErrorFrames         ;
  reg          int_acceptOtherBSSID          ;
  reg          int_acceptBroadcast           ;
  reg          int_acceptMulticast           ;
  reg          int_dontDecrypt               ;
  reg          int_excUnencrypted            ;
  // bcnCntrl1Reg register.
  reg [ 7 : 0] int_noBcnTxTime               ;
  reg          int_impTBTTIn128Us            ;
  reg [ 6 : 0] int_impTBTTPeriod             ;
  reg [15 : 0] int_beaconInt                 ;
  // bcnCntrl2Reg register.
  reg [15 : 0] int_aid                       ;
  reg [ 7 : 0] int_timOffset                 ;
  reg [ 7 : 0] int_bcnUpdateOffset           ;
  // dtim1Reg register.
  reg          int_dtimUpdatedBySW           ;
  reg [ 7 : 0] int_dtimPeriod                ;
  // retryLimitsReg register.
  reg [ 7 : 0] int_dot11LongRetryLimit       ;
  reg [ 7 : 0] int_dot11ShortRetryLimit      ;
  // bbServiceReg register.
  reg [ 2 : 0] int_maxPHYNtx                 ;
  reg [ 7 : 0] int_bbServiceB                ;
  reg [15 : 0] int_bbServiceA                ;
  // maxPowerLevelReg register.
  reg [ 7 : 0] int_ofdmMinPwrLevel           ;
  reg [ 7 : 0] int_dsssMaxPwrLevel           ;
  reg [ 7 : 0] int_ofdmMaxPwrLevel           ;
  // encrKey0Reg register.
  reg [31 : 0] int_encrKeyRAMWord0           ;
  // encrKey1Reg register.
  reg [31 : 0] int_encrKeyRAMWord1           ;
  // encrKey2Reg register.
  reg [31 : 0] int_encrKeyRAMWord2           ;
  // encrKey3Reg register.
  reg [31 : 0] int_encrKeyRAMWord3           ;
  // encrMACAddrLowReg register.
  reg [31 : 0] int_macAddrRAMLow             ;
  // encrMACAddrHighReg register.
  reg [15 : 0] int_macAddrRAMHigh            ;
  // encrCntrlReg register.
  reg          int_newRead                   ;
  reg          int_newWrite                  ;
  reg          int_newSearch                 ;
  reg          int_searchError               ;
  reg [ 9 : 0] int_keyIndexRAM               ;
  reg [ 1 : 0] int_cLenRAM                   ;
  reg [ 2 : 0] int_cTypeRAM                  ;
  reg [ 3 : 0] int_vlanIDRAM                 ;
  reg [ 1 : 0] int_sppRAM                    ;
  reg          int_useDefKeyRAM              ;
`ifdef RW_KEY_EXTENDED                      
  // encrWPIIntKey0Reg register.
  reg [31 : 0] int_encrIntKeyRAMWord0        ;
  // encrWPIIntKey1Reg register.
  reg [31 : 0] int_encrIntKeyRAMWord1        ;
  // encrWPIIntKey2Reg register.
  reg [31 : 0] int_encrIntKeyRAMWord2        ;
  // encrWPIIntKey3Reg register.
  reg [31 : 0] int_encrIntKeyRAMWord3        ;
`endif // RW_KEY_EXTENDED                      
  // encrRAMConfigReg register.
  reg [ 3 : 0] int_nVAP                      ;
  reg [ 7 : 0] int_staKeyEndIndex            ;
  reg [ 7 : 0] int_staKeyStartIndex          ;
  // ratesReg register.
  reg [11 : 0] int_bssBasicRateSet           ;
  // olbcReg register.
  reg [ 7 : 0] int_dsssCount                 ;
  reg [ 7 : 0] int_ofdmCount                 ;
  reg [15 : 0] int_olbcTimer                 ;
  // timings1Reg register.
  reg [ 9 : 0] int_txChainDelayInMACClk      ;
  reg [ 9 : 0] int_txRFDelayInMACClk         ;
  reg [ 7 : 0] int_macCoreClkFreq            ;
  // timings2Reg register.
  reg [15 : 0] int_slotTimeInMACClk          ;
  reg [ 7 : 0] int_slotTime                  ;
  // timings3Reg register.
  reg [ 9 : 0] int_rxRFDelayInMACClk         ;
  reg [ 9 : 0] int_macProcDelayInMACClk      ;
  // timings4Reg register.
  reg [ 9 : 0] int_radioWakeUpTime           ;
  reg [ 9 : 0] int_radioChirpTime            ;
  reg [ 1 : 0] int_wt2CryptClkRatio          ;
  // timings5Reg register.
  reg [15 : 0] int_sifsBInMACClk             ;
  reg [ 7 : 0] int_sifsB                     ;
  // timings6Reg register.
  reg [15 : 0] int_sifsAInMACClk             ;
  reg [ 7 : 0] int_sifsA                     ;
  // timings7Reg register.
  reg [ 3 : 0] int_rxCCADelay                ;
  // timings8Reg register.
  reg [ 7 : 0] int_rxStartDelayMIMO          ;
  reg [ 7 : 0] int_rxStartDelayShort         ;
  reg [ 7 : 0] int_rxStartDelayLong          ;
  reg [ 7 : 0] int_rxStartDelayOFDM          ;
  // timings9Reg register.
  reg [ 9 : 0] int_rifsTOInMACClk            ;
  reg [ 9 : 0] int_txDMAProcDlyInMACClk      ;
  // rxCntrl2 register.
  reg          int_disableRxBuffer2          ;
  reg          int_dataMHStoredwithPld       ;
  reg          int_mgtMHStoredwithPld        ;
  reg          int_ctrlMHStoredwithPld       ;
  reg [ 7 : 0] int_partialUnwrapSize         ;
  reg [ 1 : 0] int_dataFrmWrapMode           ;
  reg [ 1 : 0] int_mgtFrmWrapMode            ;
  reg [ 1 : 0] int_ctrlFrmWrapMode           ;
  // txTriggerTimerReg register.
  reg [ 7 : 0] int_txPacketTimeout           ;
  reg [ 7 : 0] int_txAbsoluteTimeout         ;
  // rxTriggerTimerReg register.
  reg [ 7 : 0] int_rxPacketTimeout           ;
  reg [ 7 : 0] int_rxAbsoluteTimeout         ;
  // mibTableWriteReg register.
  reg [15 : 0] int_mibValue                  ;
  reg          int_mibWrite                  ;
  reg          int_mibIncrementMode          ;
  reg [ 9 : 0] int_mibTableIndex             ;
  // monotonicCounter2LoReg register.
  reg [31 : 0] int_monotonicCounterLow2      ;
  // monotonicCounter2HiReg register.
  reg          int_monotonicCounter2SWUpdate ;
  reg [15 : 0] int_monotonicCounterHigh2     ;
  // absTimerReg0 register.
  reg [31 : 0] int_absTimerValue0            ;
  // absTimerReg1 register.
  reg [31 : 0] int_absTimerValue1            ;
  // absTimerReg2 register.
  reg [31 : 0] int_absTimerValue2            ;
  // absTimerReg3 register.
  reg [31 : 0] int_absTimerValue3            ;
  // absTimerReg4 register.
  reg [31 : 0] int_absTimerValue4            ;
  // absTimerReg5 register.
  reg [31 : 0] int_absTimerValue5            ;
  // absTimerReg6 register.
  reg [31 : 0] int_absTimerValue6            ;
  // absTimerReg7 register.
  reg [31 : 0] int_absTimerValue7            ;
  // absTimerReg8 register.
  reg [31 : 0] int_absTimerValue8            ;
  // absTimerReg9 register.
  reg [31 : 0] int_absTimerValue9            ;
  // maxRxLengthReg register.
  reg [19 : 0] int_maxAllowedLength          ;
  // edcaAC0Reg register.
  reg [15 : 0] int_txOpLimit0                ;
  reg [ 3 : 0] int_cwMax0                    ;
  reg [ 3 : 0] int_cwMin0                    ;
  reg [ 3 : 0] int_aifsn0                    ;
  // edcaAC1Reg register.
  reg [15 : 0] int_txOpLimit1                ;
  reg [ 3 : 0] int_cwMax1                    ;
  reg [ 3 : 0] int_cwMin1                    ;
  reg [ 3 : 0] int_aifsn1                    ;
  // edcaAC2Reg register.
  reg [15 : 0] int_txOpLimit2                ;
  reg [ 3 : 0] int_cwMax2                    ;
  reg [ 3 : 0] int_cwMin2                    ;
  reg [ 3 : 0] int_aifsn2                    ;
  // edcaAC3Reg register.
  reg [15 : 0] int_txOpLimit3                ;
  reg [ 3 : 0] int_cwMax3                    ;
  reg [ 3 : 0] int_cwMin3                    ;
  reg [ 3 : 0] int_aifsn3                    ;
  // edcaCCABusyReg register.
  reg [31 : 0] int_ccaBusyDur                ;
  // edcaCntrlReg register.
  reg          int_keepTXOPOpen              ;
  reg          int_remTXOPInDurField         ;
  reg          int_sendCFEnd                 ;
  reg          int_sendCFEndNow              ;
  // quietElement1aReg register.
  reg [15 : 0] int_quietDuration1            ;
  reg [ 7 : 0] int_quietPeriod1              ;
  reg [ 7 : 0] int_quietCount1               ;
  // quietElement1bReg register.
  reg [15 : 0] int_quietOffset1              ;
  // addCCABusySec20Reg register.
  reg [31 : 0] int_ccaBusyDurSec20           ;
  // addCCABusySec40Reg register.
  reg [31 : 0] int_ccaBusyDurSec40           ;
  // addCCABusySec80Reg register.
  reg [31 : 0] int_ccaBusyDurSec80           ;
  // stbcCntrlReg register.
  reg [ 6 : 0] int_basicSTBCMCS              ;
  reg          int_dualCTSProt               ;
  reg [ 7 : 0] int_ctsSTBCDur                ;
  reg [15 : 0] int_cfEndSTBCDur              ;
  // txBWCntrlReg register.
  reg [ 1 : 0] int_maxSupportedBW            ;
  reg [ 7 : 0] int_aPPDUMaxTime              ;
  reg          int_dynBWEn                   ;
  reg [ 2 : 0] int_numTryBWAcquisition       ;
  reg          int_dropToLowerBW             ;
  reg [ 1 : 0] int_defaultBWTXOP             ;
  reg          int_defaultBWTXOPV            ;
  // HTMCSReg register.
  reg [ 5 : 0] int_bssBasicHTMCSSetUM        ;
  reg [15 : 0] int_bssBasicHTMCSSetEM        ;
  // VHTMCSReg register.
  reg [15 : 0] int_bssBasicVHTMCSSet         ;
  // LSTPReg register.
  reg          int_supportLSTP               ;
  // HEConfigReg register.
  reg          int_dcmSupport                ;
  reg          int_dopplerSupport            ;
  reg          int_enableOBSSPD              ;
  reg          int_enableSRP                 ;
  reg          int_acceptAllTriggerFrames    ;
  reg          int_acceptTriggerSWFrames     ;
  reg          int_acceptTriggerHWFrames     ;
  reg          int_disableTBUPH              ;
  reg          int_disableTBRU26Resp         ;
  reg          int_disableTBCS               ;
  reg          int_disableTBResp             ;
  reg [ 2 : 0] int_defaultPEDur              ;
  // SPConfig1Reg register.
  reg [ 7 : 0] int_srgOBSSPDMaxOffset        ;
  reg [ 7 : 0] int_srgOBSSPDMinOffset        ;
  reg [ 7 : 0] int_nonSRGOBSSPDMaxOffset     ;
  reg          int_srgInformationPresent     ;
  reg          int_nonSRGOffsetPresent       ;
  reg          int_nonSRGOBSSPDSRDisallowed  ;
  reg          int_SRPDisallowed             ;
  // SRGBSSColorBitmapLowReg register.
  reg [31 : 0] int_SRGBSSColorBitmapLow      ;
  // SRGBSSColorBitmapHighReg register.
  reg [31 : 0] int_SRGBSSColorBitmapHigh     ;
  // SRGPartialBSSIDBitmapLowReg register.
  reg [31 : 0] int_SRGPartialBSSIDBitmapLow  ;
  // SRGPartialBSSIDBitmapHighReg register.
  reg [31 : 0] int_SRGPartialBSSIDBitmapHigh ;
`ifdef RW_BFMEE_EN                          
  // bfmeeControlReg register.
  reg [ 1 : 0] int_bfrHELTFType              ;
  reg [ 1 : 0] int_bfrGIType                 ;
  reg [ 2 : 0] int_bfrFormatMod              ;
  reg          int_bfrShortGI                ;
  reg [ 7 : 0] int_bfrMCS                    ;
  reg [ 2 : 0] int_bfmeeNc                   ;
  reg [ 2 : 0] int_bfmeeNr                   ;
  reg [ 1 : 0] int_bfmeeGrouping             ;
  reg          int_bfmeeCodebook             ;
  reg          int_bfmeeMUSupport            ;
  reg          int_bfmeeEnable               ;
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      
  // CoexControlReg register.
  reg [ 3 : 0] int_coexForceWlanPTI          ;
  reg          int_coexForceWlanPTIToggle    ;
  reg          int_coexForceWlanChanBw       ;
  reg          int_coexForceWlanRx           ;
  reg          int_coexForceWlanTx           ;
  reg [ 6 : 0] int_coexWlanChanFreq          ;
  reg          int_coexWlanChanOffset        ;
  reg [ 1 : 0] int_coexAutoPTIAdjIncr        ;
  reg          int_coexAutoPTIAdjEnable      ;
  reg          int_coexForceEnable           ;
  reg          int_coexPostponeTxEnable      ;
  reg          int_coexPHYRxAbortEnable      ;
  reg          int_coexPHYTxAbortEnable      ;
  reg          int_coexEnable                ;
  // CoexPTIReg register.
  reg [ 3 : 0] int_coexPTIBcnData            ;
  reg [ 3 : 0] int_coexPTIBKData             ;
  reg [ 3 : 0] int_coexPTIBEData             ;
  reg [ 3 : 0] int_coexPTIVIData             ;
  reg [ 3 : 0] int_coexPTIVOData             ;
  reg [ 3 : 0] int_coexPTIMgt                ;
  reg [ 3 : 0] int_coexPTICntl               ;
  reg [ 3 : 0] int_coexPTIAck                ;
  // CoexIntReg register.
  reg          int_coexWlanRxAbortFallEn     ;
  reg          int_coexWlanRxAbortRiseEn     ;
  reg          int_coexWlanTxAbortFallEn     ;
  reg          int_coexWlanTxAbortRiseEn     ;
`endif // RW_WLAN_COEX_EN                      
  // debugPortSelReg register.
  reg [ 7 : 0] int_debugPortSel2             ;
  reg [ 7 : 0] int_debugPortSel1             ;
  // debugBasicNAVReg register.
  reg [25 : 0] int_basicNAVCounter           ;
  // debugCWReg register.
  reg [ 1 : 0] int_backoffOffset             ;
  // debugUORAReg register.
  reg [ 6 : 0] int_ocwLFSR                   ;
  // debugPHYReg register.
  reg          int_rxEndForTimingErrRec      ;
  reg          int_rxReqForceDeassertion     ;
  // debugIntraNAVReg register.
  reg [15 : 0] int_intraNAVCounter           ;


//////////////////////////////////////////////////////////////////////////////
// Ouput linkage
//////////////////////////////////////////////////////////////////////////////
   assign macAddrLow                = int_macAddrLow                ;
   assign macAddrHigh               = int_macAddrHigh               ;
   assign macAddrLowMask            = int_macAddrLowMask            ;
   assign macAddrHighMask           = int_macAddrHighMask           ;
   assign bssIDLow                  = int_bssIDLow                  ;
   assign bssIDHigh                 = int_bssIDHigh                 ;
   assign bssIDLowMask              = int_bssIDLowMask              ;
   assign bssIDHighMask             = int_bssIDHighMask             ;
   assign partialBSSColorEn         = int_partialBSSColorEn         ;
   assign bssColorEn                = int_bssColorEn                ;
   assign bssColor                  = int_bssColor                  ;
   assign nextState                 = int_nextState                 ;
   assign primaryChPosition         = int_primaryChPosition         ;
   assign probeDelay                = int_probeDelay                ;
   assign wakeupDTIM                = int_wakeupDTIM                ;
   assign listenInterval            = int_listenInterval            ;
   assign rxRIFSEn                  = int_rxRIFSEn                  ;
   assign tsfMgtDisable             = int_tsfMgtDisable             ;
   assign tsfUpdatedBySW            = int_tsfUpdatedBySW            ;
   assign disableSVDRxPause         = int_disableSVDRxPause         ;
   assign disableBQRResp            = int_disableBQRResp            ;
   assign abgnMode                  = int_abgnMode                  ;
   assign keyStoRAMReset            = int_keyStoRAMReset            ;
   assign mibTableReset             = int_mibTableReset             ;
   assign rateControllerMPIF        = int_rateControllerMPIF        ;
   assign disableBAResp             = int_disableBAResp             ;
   assign disableCTSResp            = int_disableCTSResp            ;
   assign disableACKResp            = int_disableACKResp            ;
   assign activeClkGating           = int_activeClkGating           ;
   assign enableLPClkSwitch         = int_enableLPClkSwitch         ;
   assign lpClk32786Hz              = int_lpClk32786Hz              ;
   assign pwrMgt                    = int_pwrMgt                    ;
   assign ap                        = int_ap                        ;
   assign bssType                   = int_bssType                   ;
   assign rxFlowCntrlEn             = int_rxFlowCntrlEn             ;
   assign baPSBitmapReset           = int_baPSBitmapReset           ;
   assign macPHYIFFIFOReset         = int_macPHYIFFIFOReset         ;
   assign txFIFOReset               = int_txFIFOReset               ;
   assign rxFIFOReset               = int_rxFIFOReset               ;
   assign hwFSMReset                = int_hwFSMReset                ;
   assign useErrDet                 = int_useErrDet                 ;
   assign errInHWLevel3             = int_errInHWLevel3             ;
   assign errInTxRxLevel2           = int_errInTxRxLevel2           ;
   assign errInRxLevel1             = int_errInRxLevel1             ;
   assign errInTxLevel1             = int_errInTxLevel1             ;
   assign clearErrInHWLevel3        = int_clearErrInHWLevel3        ;
   assign clearErrInTxRxLevel2      = int_clearErrInTxRxLevel2      ;
   assign clearErrInRxLevel1        = int_clearErrInRxLevel1        ;
   assign clearErrInTxLevel1        = int_clearErrInTxLevel1        ;
   assign acceptUnknown             = int_acceptUnknown             ;
   assign acceptOtherDataFrames     = int_acceptOtherDataFrames     ;
   assign acceptQoSNull             = int_acceptQoSNull             ;
   assign acceptQCFWOData           = int_acceptQCFWOData           ;
   assign acceptQData               = int_acceptQData               ;
   assign acceptCFWOData            = int_acceptCFWOData            ;
   assign acceptData                = int_acceptData                ;
   assign acceptOtherCntrlFrames    = int_acceptOtherCntrlFrames    ;
   assign acceptCFEnd               = int_acceptCFEnd               ;
   assign acceptACK                 = int_acceptACK                 ;
   assign acceptCTS                 = int_acceptCTS                 ;
   assign acceptRTS                 = int_acceptRTS                 ;
   assign acceptPSPoll              = int_acceptPSPoll              ;
   assign acceptBA                  = int_acceptBA                  ;
   assign acceptBAR                 = int_acceptBAR                 ;
   assign acceptOtherMgmtFrames     = int_acceptOtherMgmtFrames     ;
   assign acceptBfmeeFrames         = int_acceptBfmeeFrames         ;
   assign acceptAllBeacon           = int_acceptAllBeacon           ;
   assign acceptNotExpectedBA       = int_acceptNotExpectedBA       ;
   assign acceptDecryptErrorFrames  = int_acceptDecryptErrorFrames  ;
   assign acceptBeacon              = int_acceptBeacon              ;
   assign acceptProbeResp           = int_acceptProbeResp           ;
   assign acceptProbeReq            = int_acceptProbeReq            ;
   assign acceptMyUnicast           = int_acceptMyUnicast           ;
   assign acceptUnicast             = int_acceptUnicast             ;
   assign acceptErrorFrames         = int_acceptErrorFrames         ;
   assign acceptOtherBSSID          = int_acceptOtherBSSID          ;
   assign acceptBroadcast           = int_acceptBroadcast           ;
   assign acceptMulticast           = int_acceptMulticast           ;
   assign dontDecrypt               = int_dontDecrypt               ;
   assign excUnencrypted            = int_excUnencrypted            ;
   assign noBcnTxTime               = int_noBcnTxTime               ;
   assign impTBTTIn128Us            = int_impTBTTIn128Us            ;
   assign impTBTTPeriod             = int_impTBTTPeriod             ;
   assign beaconInt                 = int_beaconInt                 ;
   assign aid                       = int_aid                       ;
   assign timOffset                 = int_timOffset                 ;
   assign bcnUpdateOffset           = int_bcnUpdateOffset           ;
   assign dtimUpdatedBySW           = int_dtimUpdatedBySW           ;
   assign dtimPeriod                = int_dtimPeriod                ;
   assign dot11LongRetryLimit       = int_dot11LongRetryLimit       ;
   assign dot11ShortRetryLimit      = int_dot11ShortRetryLimit      ;
   assign maxPHYNtx                 = int_maxPHYNtx                 ;
   assign bbServiceB                = int_bbServiceB                ;
   assign bbServiceA                = int_bbServiceA                ;
   assign ofdmMinPwrLevel           = int_ofdmMinPwrLevel           ;
   assign dsssMaxPwrLevel           = int_dsssMaxPwrLevel           ;
   assign ofdmMaxPwrLevel           = int_ofdmMaxPwrLevel           ;
   assign encrKeyRAMWord0           = int_encrKeyRAMWord0           ;
   assign encrKeyRAMWord1           = int_encrKeyRAMWord1           ;
   assign encrKeyRAMWord2           = int_encrKeyRAMWord2           ;
   assign encrKeyRAMWord3           = int_encrKeyRAMWord3           ;
   assign macAddrRAMLow             = int_macAddrRAMLow             ;
   assign macAddrRAMHigh            = int_macAddrRAMHigh            ;
   assign newRead                   = int_newRead                   ;
   assign newWrite                  = int_newWrite                  ;
   assign newSearch                 = int_newSearch                 ;
   assign searchError               = int_searchError               ;
   assign keyIndexRAM               = int_keyIndexRAM               ;
   assign cLenRAM                   = int_cLenRAM                   ;
   assign cTypeRAM                  = int_cTypeRAM                  ;
   assign vlanIDRAM                 = int_vlanIDRAM                 ;
   assign sppRAM                    = int_sppRAM                    ;
   assign useDefKeyRAM              = int_useDefKeyRAM              ;
`ifdef RW_KEY_EXTENDED                      
   assign encrIntKeyRAMWord0        = int_encrIntKeyRAMWord0        ;
   assign encrIntKeyRAMWord1        = int_encrIntKeyRAMWord1        ;
   assign encrIntKeyRAMWord2        = int_encrIntKeyRAMWord2        ;
   assign encrIntKeyRAMWord3        = int_encrIntKeyRAMWord3        ;
`endif // RW_KEY_EXTENDED                      
   assign nVAP                      = int_nVAP                      ;
   assign staKeyEndIndex            = int_staKeyEndIndex            ;
   assign staKeyStartIndex          = int_staKeyStartIndex          ;
   assign bssBasicRateSet           = int_bssBasicRateSet           ;
   assign dsssCount                 = int_dsssCount                 ;
   assign ofdmCount                 = int_ofdmCount                 ;
   assign olbcTimer                 = int_olbcTimer                 ;
   assign txChainDelayInMACClk      = int_txChainDelayInMACClk      ;
   assign txRFDelayInMACClk         = int_txRFDelayInMACClk         ;
   assign macCoreClkFreq            = int_macCoreClkFreq            ;
   assign slotTimeInMACClk          = int_slotTimeInMACClk          ;
   assign slotTime                  = int_slotTime                  ;
   assign rxRFDelayInMACClk         = int_rxRFDelayInMACClk         ;
   assign macProcDelayInMACClk      = int_macProcDelayInMACClk      ;
   assign radioWakeUpTime           = int_radioWakeUpTime           ;
   assign radioChirpTime            = int_radioChirpTime            ;
   assign wt2CryptClkRatio          = int_wt2CryptClkRatio          ;
   assign sifsBInMACClk             = int_sifsBInMACClk             ;
   assign sifsB                     = int_sifsB                     ;
   assign sifsAInMACClk             = int_sifsAInMACClk             ;
   assign sifsA                     = int_sifsA                     ;
   assign rxCCADelay                = int_rxCCADelay                ;
   assign rxStartDelayMIMO          = int_rxStartDelayMIMO          ;
   assign rxStartDelayShort         = int_rxStartDelayShort         ;
   assign rxStartDelayLong          = int_rxStartDelayLong          ;
   assign rxStartDelayOFDM          = int_rxStartDelayOFDM          ;
   assign rifsTOInMACClk            = int_rifsTOInMACClk            ;
   assign txDMAProcDlyInMACClk      = int_txDMAProcDlyInMACClk      ;
   assign disableRxBuffer2          = int_disableRxBuffer2          ;
   assign dataMHStoredwithPld       = int_dataMHStoredwithPld       ;
   assign mgtMHStoredwithPld        = int_mgtMHStoredwithPld        ;
   assign ctrlMHStoredwithPld       = int_ctrlMHStoredwithPld       ;
   assign partialUnwrapSize         = int_partialUnwrapSize         ;
   assign dataFrmWrapMode           = int_dataFrmWrapMode           ;
   assign mgtFrmWrapMode            = int_mgtFrmWrapMode            ;
   assign ctrlFrmWrapMode           = int_ctrlFrmWrapMode           ;
   assign txPacketTimeout           = int_txPacketTimeout           ;
   assign txAbsoluteTimeout         = int_txAbsoluteTimeout         ;
   assign rxPacketTimeout           = int_rxPacketTimeout           ;
   assign rxAbsoluteTimeout         = int_rxAbsoluteTimeout         ;
   assign mibValue                  = int_mibValue                  ;
   assign mibWrite                  = int_mibWrite                  ;
   assign mibIncrementMode          = int_mibIncrementMode          ;
   assign mibTableIndex             = int_mibTableIndex             ;
   assign monotonicCounterLow2      = int_monotonicCounterLow2      ;
   assign monotonicCounter2SWUpdate = int_monotonicCounter2SWUpdate ;
   assign monotonicCounterHigh2     = int_monotonicCounterHigh2     ;
   assign absTimerValue0            = int_absTimerValue0            ;
   assign absTimerValue1            = int_absTimerValue1            ;
   assign absTimerValue2            = int_absTimerValue2            ;
   assign absTimerValue3            = int_absTimerValue3            ;
   assign absTimerValue4            = int_absTimerValue4            ;
   assign absTimerValue5            = int_absTimerValue5            ;
   assign absTimerValue6            = int_absTimerValue6            ;
   assign absTimerValue7            = int_absTimerValue7            ;
   assign absTimerValue8            = int_absTimerValue8            ;
   assign absTimerValue9            = int_absTimerValue9            ;
   assign maxAllowedLength          = int_maxAllowedLength          ;
   assign txOpLimit0                = int_txOpLimit0                ;
   assign cwMax0                    = int_cwMax0                    ;
   assign cwMin0                    = int_cwMin0                    ;
   assign aifsn0                    = int_aifsn0                    ;
   assign txOpLimit1                = int_txOpLimit1                ;
   assign cwMax1                    = int_cwMax1                    ;
   assign cwMin1                    = int_cwMin1                    ;
   assign aifsn1                    = int_aifsn1                    ;
   assign txOpLimit2                = int_txOpLimit2                ;
   assign cwMax2                    = int_cwMax2                    ;
   assign cwMin2                    = int_cwMin2                    ;
   assign aifsn2                    = int_aifsn2                    ;
   assign txOpLimit3                = int_txOpLimit3                ;
   assign cwMax3                    = int_cwMax3                    ;
   assign cwMin3                    = int_cwMin3                    ;
   assign aifsn3                    = int_aifsn3                    ;
   assign ccaBusyDur                = int_ccaBusyDur                ;
   assign keepTXOPOpen              = int_keepTXOPOpen              ;
   assign remTXOPInDurField         = int_remTXOPInDurField         ;
   assign sendCFEnd                 = int_sendCFEnd                 ;
   assign sendCFEndNow              = int_sendCFEndNow              ;
   assign quietDuration1            = int_quietDuration1            ;
   assign quietPeriod1              = int_quietPeriod1              ;
   assign quietCount1               = int_quietCount1               ;
   assign quietOffset1              = int_quietOffset1              ;
   assign ccaBusyDurSec20           = int_ccaBusyDurSec20           ;
   assign ccaBusyDurSec40           = int_ccaBusyDurSec40           ;
   assign ccaBusyDurSec80           = int_ccaBusyDurSec80           ;
   assign basicSTBCMCS              = int_basicSTBCMCS              ;
   assign dualCTSProt               = int_dualCTSProt               ;
   assign ctsSTBCDur                = int_ctsSTBCDur                ;
   assign cfEndSTBCDur              = int_cfEndSTBCDur              ;
   assign maxSupportedBW            = int_maxSupportedBW            ;
   assign aPPDUMaxTime              = int_aPPDUMaxTime              ;
   assign dynBWEn                   = int_dynBWEn                   ;
   assign numTryBWAcquisition       = int_numTryBWAcquisition       ;
   assign dropToLowerBW             = int_dropToLowerBW             ;
   assign defaultBWTXOP             = int_defaultBWTXOP             ;
   assign defaultBWTXOPV            = int_defaultBWTXOPV            ;
   assign bssBasicHTMCSSetUM        = int_bssBasicHTMCSSetUM        ;
   assign bssBasicHTMCSSetEM        = int_bssBasicHTMCSSetEM        ;
   assign bssBasicVHTMCSSet         = int_bssBasicVHTMCSSet         ;
   assign supportLSTP               = int_supportLSTP               ;
   assign dcmSupport                = int_dcmSupport                ;
   assign dopplerSupport            = int_dopplerSupport            ;
   assign enableOBSSPD              = int_enableOBSSPD              ;
   assign enableSRP                 = int_enableSRP                 ;
   assign acceptAllTriggerFrames    = int_acceptAllTriggerFrames    ;
   assign acceptTriggerSWFrames     = int_acceptTriggerSWFrames     ;
   assign acceptTriggerHWFrames     = int_acceptTriggerHWFrames     ;
   assign disableTBUPH              = int_disableTBUPH              ;
   assign disableTBRU26Resp         = int_disableTBRU26Resp         ;
   assign disableTBCS               = int_disableTBCS               ;
   assign disableTBResp             = int_disableTBResp             ;
   assign defaultPEDur              = int_defaultPEDur              ;
   assign srgOBSSPDMaxOffset        = int_srgOBSSPDMaxOffset        ;
   assign srgOBSSPDMinOffset        = int_srgOBSSPDMinOffset        ;
   assign nonSRGOBSSPDMaxOffset     = int_nonSRGOBSSPDMaxOffset     ;
   assign srgInformationPresent     = int_srgInformationPresent     ;
   assign nonSRGOffsetPresent       = int_nonSRGOffsetPresent       ;
   assign nonSRGOBSSPDSRDisallowed  = int_nonSRGOBSSPDSRDisallowed  ;
   assign SRPDisallowed             = int_SRPDisallowed             ;
   assign SRGBSSColorBitmapLow      = int_SRGBSSColorBitmapLow      ;
   assign SRGBSSColorBitmapHigh     = int_SRGBSSColorBitmapHigh     ;
   assign SRGPartialBSSIDBitmapLow  = int_SRGPartialBSSIDBitmapLow  ;
   assign SRGPartialBSSIDBitmapHigh = int_SRGPartialBSSIDBitmapHigh ;
`ifdef RW_BFMEE_EN                          
   assign bfrHELTFType              = int_bfrHELTFType              ;
   assign bfrGIType                 = int_bfrGIType                 ;
   assign bfrFormatMod              = int_bfrFormatMod              ;
   assign bfrShortGI                = int_bfrShortGI                ;
   assign bfrMCS                    = int_bfrMCS                    ;
   assign bfmeeNc                   = int_bfmeeNc                   ;
   assign bfmeeNr                   = int_bfmeeNr                   ;
   assign bfmeeGrouping             = int_bfmeeGrouping             ;
   assign bfmeeCodebook             = int_bfmeeCodebook             ;
   assign bfmeeMUSupport            = int_bfmeeMUSupport            ;
   assign bfmeeEnable               = int_bfmeeEnable               ;
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      
   assign coexForceWlanPTI          = int_coexForceWlanPTI          ;
   assign coexForceWlanPTIToggle    = int_coexForceWlanPTIToggle    ;
   assign coexForceWlanChanBw       = int_coexForceWlanChanBw       ;
   assign coexForceWlanRx           = int_coexForceWlanRx           ;
   assign coexForceWlanTx           = int_coexForceWlanTx           ;
   assign coexWlanChanFreq          = int_coexWlanChanFreq          ;
   assign coexWlanChanOffset        = int_coexWlanChanOffset        ;
   assign coexAutoPTIAdjIncr        = int_coexAutoPTIAdjIncr        ;
   assign coexAutoPTIAdjEnable      = int_coexAutoPTIAdjEnable      ;
   assign coexForceEnable           = int_coexForceEnable           ;
   assign coexPostponeTxEnable      = int_coexPostponeTxEnable      ;
   assign coexPHYRxAbortEnable      = int_coexPHYRxAbortEnable      ;
   assign coexPHYTxAbortEnable      = int_coexPHYTxAbortEnable      ;
   assign coexEnable                = int_coexEnable                ;
   assign coexPTIBcnData            = int_coexPTIBcnData            ;
   assign coexPTIBKData             = int_coexPTIBKData             ;
   assign coexPTIBEData             = int_coexPTIBEData             ;
   assign coexPTIVIData             = int_coexPTIVIData             ;
   assign coexPTIVOData             = int_coexPTIVOData             ;
   assign coexPTIMgt                = int_coexPTIMgt                ;
   assign coexPTICntl               = int_coexPTICntl               ;
   assign coexPTIAck                = int_coexPTIAck                ;
   assign coexWlanRxAbortFallEn     = int_coexWlanRxAbortFallEn     ;
   assign coexWlanRxAbortRiseEn     = int_coexWlanRxAbortRiseEn     ;
   assign coexWlanTxAbortFallEn     = int_coexWlanTxAbortFallEn     ;
   assign coexWlanTxAbortRiseEn     = int_coexWlanTxAbortRiseEn     ;
`endif // RW_WLAN_COEX_EN                      
   assign debugPortSel2             = int_debugPortSel2             ;
   assign debugPortSel1             = int_debugPortSel1             ;
   assign basicNAVCounter           = int_basicNAVCounter           ;
   assign backoffOffset             = int_backoffOffset             ;
   assign ocwLFSR                   = int_ocwLFSR                   ;
   assign rxEndForTimingErrRec      = int_rxEndForTimingErrRec      ;
   assign rxReqForceDeassertion     = int_rxReqForceDeassertion     ;
   assign intraNAVCounter           = int_intraNAVCounter           ;


  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  // apb_write_p:


  always @(posedge Clk or negedge hardRstClk_n)
  begin
    if (!hardRstClk_n) 
    begin
	
      // MACADDRLOWREG register.
      int_macAddrLow                 <= 32'b0000000000000000000000000000000;
      // MACADDRHIREG register.
      int_macAddrHigh                <= 16'b000000000000000;
      // MACADDRLOWMASKREG register.
      int_macAddrLowMask             <= 32'b0000000000000000000000000000000;
      // MACADDRHIMASKREG register.
      int_macAddrHighMask            <= 16'b000000000000000;
      // BSSIDLOWREG register.
      int_bssIDLow                   <= 32'b0000000000000000000000000000000;
      // BSSIDHIREG register.
      int_bssIDHigh                  <= 16'b000000000000000;
      // BSSIDLOWMASKREG register.
      int_bssIDLowMask               <= 32'b0000000000000000000000000000000;
      // BSSIDHIMASKREG register.
      int_bssIDHighMask              <= 16'b000000000000000;
      // BSSCOLORREG register.
      int_partialBSSColorEn          <= 1'b0;
      int_bssColorEn                 <= 1'b0;
      int_bssColor                   <= 6'b00000;
      // STATECNTRLREG register.
      int_nextState                  <= 4'b000;
      // SCANCNTRLREG register.
      int_primaryChPosition          <= 3'b00;
      int_probeDelay                 <= 16'b000000000000000;
      // DOZECNTRL1REG register.
      int_wakeupDTIM                 <= 1'b0;
      int_listenInterval             <= 16'b000000000000000;
      // MACCNTRL1REG register.
      int_rxRIFSEn                   <= 1'b0;
      int_tsfMgtDisable              <= 1'b0;
      int_tsfUpdatedBySW             <= 1'b0;
      int_disableSVDRxPause          <= 1'b0;
      int_disableBQRResp             <= 1'b0;
      int_abgnMode                   <= 3'b11;
      int_keyStoRAMReset             <= 1'b0;
      int_mibTableReset              <= 1'b0;
      int_rateControllerMPIF         <= 1'b1;
      int_disableBAResp              <= 1'b0;
      int_disableCTSResp             <= 1'b0;
      int_disableACKResp             <= 1'b0;
      int_activeClkGating            <= 1'b1;
      int_enableLPClkSwitch          <= 1'b0;
      int_lpClk32786Hz               <= 1'b0;
      int_pwrMgt                     <= 1'b0;
      int_ap                         <= 1'b0;
      int_bssType                    <= 1'b1;
      // MACERRRECCNTRLREG register.
      int_rxFlowCntrlEn              <= 1'b0;
      int_baPSBitmapReset            <= 1'b0;
      int_macPHYIFFIFOReset          <= 1'b0;
      int_txFIFOReset                <= 1'b0;
      int_rxFIFOReset                <= 1'b0;
      int_hwFSMReset                 <= 1'b0;
      int_useErrDet                  <= 1'b0;
      // MACERRSETSTATUSREG register.
      int_errInHWLevel3              <= 1'b0;
      int_errInTxRxLevel2            <= 1'b0;
      int_errInRxLevel1              <= 1'b0;
      int_errInTxLevel1              <= 1'b0;
      // MACERRCLEARSTATUSREG register.
      int_clearErrInHWLevel3         <= 1'b0;
      int_clearErrInTxRxLevel2       <= 1'b0;
      int_clearErrInRxLevel1         <= 1'b0;
      int_clearErrInTxLevel1         <= 1'b0;
      // RXCNTRLREG register.
      int_acceptUnknown              <= 1'b0;
      int_acceptOtherDataFrames      <= 1'b0;
      int_acceptQoSNull              <= 1'b1;
      int_acceptQCFWOData            <= 1'b0;
      int_acceptQData                <= 1'b1;
      int_acceptCFWOData             <= 1'b0;
      int_acceptData                 <= 1'b1;
      int_acceptOtherCntrlFrames     <= 1'b0;
      int_acceptCFEnd                <= 1'b0;
      int_acceptACK                  <= 1'b0;
      int_acceptCTS                  <= 1'b0;
      int_acceptRTS                  <= 1'b0;
      int_acceptPSPoll               <= 1'b1;
      int_acceptBA                   <= 1'b1;
      int_acceptBAR                  <= 1'b1;
      int_acceptOtherMgmtFrames      <= 1'b1;
      int_acceptBfmeeFrames          <= 1'b0;
      int_acceptAllBeacon            <= 1'b0;
      int_acceptNotExpectedBA        <= 1'b0;
      int_acceptDecryptErrorFrames   <= 1'b0;
      int_acceptBeacon               <= 1'b1;
      int_acceptProbeResp            <= 1'b1;
      int_acceptProbeReq             <= 1'b1;
      int_acceptMyUnicast            <= 1'b1;
      int_acceptUnicast              <= 1'b0;
      int_acceptErrorFrames          <= 1'b0;
      int_acceptOtherBSSID           <= 1'b0;
      int_acceptBroadcast            <= 1'b1;
      int_acceptMulticast            <= 1'b0;
      int_dontDecrypt                <= 1'b0;
      int_excUnencrypted             <= 1'b0;
      // BCNCNTRL1REG register.
      int_noBcnTxTime                <= 8'd`NO_BCN_TX_TIME;
      int_impTBTTIn128Us             <= 1'b0;
      int_impTBTTPeriod              <= 7'd`IMP_TBTT_TIME;
      int_beaconInt                  <= 16'b000000000000000;
      // BCNCNTRL2REG register.
      int_aid                        <= 16'b000000000000000;
      int_timOffset                  <= 8'b0000000;
      int_bcnUpdateOffset            <= 8'b0000000;
      // DTIM1REG register.
      int_dtimUpdatedBySW            <= 1'b0;
      int_dtimPeriod                 <= 8'b0000000;
      // RETRYLIMITSREG register.
      int_dot11LongRetryLimit        <= 8'b0000100;
      int_dot11ShortRetryLimit       <= 8'b0000111;
      // BBSERVICEREG register.
      int_maxPHYNtx                  <= 3'b01;
      int_bbServiceB                 <= 8'b0000000;
      int_bbServiceA                 <= 16'b000000000000000;
      // MAXPOWERLEVELREG register.
      int_ofdmMinPwrLevel            <= 8'b0000000;
      int_dsssMaxPwrLevel            <= 8'b0001111;
      int_ofdmMaxPwrLevel            <= 8'b0001111;
      // ENCRKEY0REG register.
      int_encrKeyRAMWord0            <= 32'b0000000000000000000000000000000;
      // ENCRKEY1REG register.
      int_encrKeyRAMWord1            <= 32'b0000000000000000000000000000000;
      // ENCRKEY2REG register.
      int_encrKeyRAMWord2            <= 32'b0000000000000000000000000000000;
      // ENCRKEY3REG register.
      int_encrKeyRAMWord3            <= 32'b0000000000000000000000000000000;
      // ENCRMACADDRLOWREG register.
      int_macAddrRAMLow              <= 32'b11111111111111111111111111111111;
      // ENCRMACADDRHIGHREG register.
      int_macAddrRAMHigh             <= 16'b1111111111111111;
      // ENCRCNTRLREG register.
      int_newRead                    <= 1'b0;
      int_newWrite                   <= 1'b0;
      int_newSearch                  <= 1'b0;
      int_searchError                <= 1'b0;
      int_keyIndexRAM                <= 10'b000000000;
      int_cLenRAM                    <= 2'b0;
      int_cTypeRAM                   <= 3'b00;
      int_vlanIDRAM                  <= 4'b000;
      int_sppRAM                     <= 2'b0;
      int_useDefKeyRAM               <= 1'b0;
`ifdef RW_KEY_EXTENDED                      
      // ENCRWPIINTKEY0REG register.
      int_encrIntKeyRAMWord0         <= 32'b0000000000000000000000000000000;
      // ENCRWPIINTKEY1REG register.
      int_encrIntKeyRAMWord1         <= 32'b0000000000000000000000000000000;
      // ENCRWPIINTKEY2REG register.
      int_encrIntKeyRAMWord2         <= 32'b0000000000000000000000000000000;
      // ENCRWPIINTKEY3REG register.
      int_encrIntKeyRAMWord3         <= 32'b0000000000000000000000000000000;
`endif // RW_KEY_EXTENDED                      
      // ENCRRAMCONFIGREG register.
      int_nVAP                       <= 4'd`RW_KEY_NVAP;
      int_staKeyEndIndex             <= 8'd`RW_KEY_INDEX_MAX;
      int_staKeyStartIndex           <= 8'd`RW_KEY_NVAP*4;
      // RATESREG register.
      int_bssBasicRateSet            <= 12'b00101010000;
      // OLBCREG register.
      int_dsssCount                  <= 8'b0000000;
      int_ofdmCount                  <= 8'b0000000;
      int_olbcTimer                  <= 16'b000000000000000;
      // TIMINGS1REG register.
      int_txChainDelayInMACClk       <= 10'd`TX_CHAIN_DLY * 10'd`MAC_FREQ;
      int_txRFDelayInMACClk          <= 10'd`TX_RF_DLY * 10'd`MAC_FREQ;
      int_macCoreClkFreq             <= 8'd`MAC_FREQ;
      // TIMINGS2REG register.
      int_slotTimeInMACClk           <= 16'd`SHORT_SLOT * 16'd`MAC_FREQ;
      int_slotTime                   <= 8'd`SHORT_SLOT;
      // TIMINGS3REG register.
      int_rxRFDelayInMACClk          <= 10'd`RX_RF_DLY * 10'd`MAC_FREQ;
      int_macProcDelayInMACClk       <= 10'd`MAC_PROC_DELAY * 10'd`MAC_FREQ;
      // TIMINGS4REG register.
      int_radioWakeUpTime            <= 10'd`RADIOWAKEUP_TIME;
      int_radioChirpTime             <= 10'd`RADIO_CHIRP_TIME;
      int_wt2CryptClkRatio           <= 2'd`WEP_2_BB_CLK_RATIO;
      // TIMINGS5REG register.
      int_sifsBInMACClk              <= 16'd`SIFS_B * 16'd`MAC_FREQ;
      int_sifsB                      <= 8'd`SIFS_B;
      // TIMINGS6REG register.
      int_sifsAInMACClk              <= 16'd`SIFS_A* 16'd`MAC_FREQ;
      int_sifsA                      <= 8'd`SIFS_A;
      // TIMINGS7REG register.
      int_rxCCADelay                 <= 4'd`RX_CCA_DLY;
      // TIMINGS8REG register.
      int_rxStartDelayMIMO           <= 8'b0100001;
      int_rxStartDelayShort          <= 8'b1100110;
      int_rxStartDelayLong           <= 8'b11000110;
      int_rxStartDelayOFDM           <= 8'b0100001;
      // TIMINGS9REG register.
      int_rifsTOInMACClk             <= 10'd`RIFSTO * 10'd`MAC_FREQ;
      int_txDMAProcDlyInMACClk       <= 10'd`TX_DMA_PROC_DLY * 10'd`MAC_FREQ;
      // RXCNTRL2 register.
      int_disableRxBuffer2           <= 1'b0;
      int_dataMHStoredwithPld        <= 1'b0;
      int_mgtMHStoredwithPld         <= 1'b1;
      int_ctrlMHStoredwithPld        <= 1'b1;
      int_partialUnwrapSize          <= 8'b0110010;
      int_dataFrmWrapMode            <= 2'b10;
      int_mgtFrmWrapMode             <= 2'b1;
      int_ctrlFrmWrapMode            <= 2'b1;
      // TXTRIGGERTIMERREG register.
      int_txPacketTimeout            <= 8'b0001111;
      int_txAbsoluteTimeout          <= 8'b10011100;
      // RXTRIGGERTIMERREG register.
      int_rxPacketTimeout            <= 8'b0001111;
      int_rxAbsoluteTimeout          <= 8'b10011100;
      // MIBTABLEWRITEREG register.
      int_mibValue                   <= 16'b000000000000000;
      int_mibWrite                   <= 1'b0;
      int_mibIncrementMode           <= 1'b1;
      int_mibTableIndex              <= 10'b000000000;
      // MONOTONICCOUNTER2LOREG register.
      int_monotonicCounterLow2       <= 32'b0000000000000000000000000000000;
      // MONOTONICCOUNTER2HIREG register.
      int_monotonicCounter2SWUpdate  <= 1'b0;
      int_monotonicCounterHigh2      <= 16'b000000000000000;
      // ABSTIMERREG0 register.
      int_absTimerValue0             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG1 register.
      int_absTimerValue1             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG2 register.
      int_absTimerValue2             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG3 register.
      int_absTimerValue3             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG4 register.
      int_absTimerValue4             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG5 register.
      int_absTimerValue5             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG6 register.
      int_absTimerValue6             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG7 register.
      int_absTimerValue7             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG8 register.
      int_absTimerValue8             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG9 register.
      int_absTimerValue9             <= 32'b0000000000000000000000000000000;
      // MAXRXLENGTHREG register.
      int_maxAllowedLength           <= 20'b0001111111111111111;
      // EDCAAC0REG register.
      int_txOpLimit0                 <= 16'b000000000000000;
      int_cwMax0                     <= 4'b1010;
      int_cwMin0                     <= 4'b100;
      int_aifsn0                     <= 4'b111;
      // EDCAAC1REG register.
      int_txOpLimit1                 <= 16'b000000000000000;
      int_cwMax1                     <= 4'b1010;
      int_cwMin1                     <= 4'b100;
      int_aifsn1                     <= 4'b011;
      // EDCAAC2REG register.
      int_txOpLimit2                 <= 16'b000000001011110;
      int_cwMax2                     <= 4'b100;
      int_cwMin2                     <= 4'b011;
      int_aifsn2                     <= 4'b010;
      // EDCAAC3REG register.
      int_txOpLimit3                 <= 16'b000000000101111;
      int_cwMax3                     <= 4'b011;
      int_cwMin3                     <= 4'b010;
      int_aifsn3                     <= 4'b010;
      // EDCACCABUSYREG register.
      int_ccaBusyDur                 <= 32'b0000000000000000000000000000000;
      // EDCACNTRLREG register.
      int_keepTXOPOpen               <= 1'b0;
      int_remTXOPInDurField          <= 1'b0;
      int_sendCFEnd                  <= 1'b0;
      int_sendCFEndNow               <= 1'b0;
      // QUIETELEMENT1AREG register.
      int_quietDuration1             <= 16'b000000000000000;
      int_quietPeriod1               <= 8'b0000000;
      int_quietCount1                <= 8'b0000000;
      // QUIETELEMENT1BREG register.
      int_quietOffset1               <= 16'b000000000000000;
      // ADDCCABUSYSEC20REG register.
      int_ccaBusyDurSec20            <= 32'b0000000000000000000000000000000;
      // ADDCCABUSYSEC40REG register.
      int_ccaBusyDurSec40            <= 32'b0000000000000000000000000000000;
      // ADDCCABUSYSEC80REG register.
      int_ccaBusyDurSec80            <= 32'b0000000000000000000000000000000;
      // STBCCNTRLREG register.
      int_basicSTBCMCS               <= 7'b000000;
      int_dualCTSProt                <= 1'b0;
      int_ctsSTBCDur                 <= 8'b0000000;
      int_cfEndSTBCDur               <= 16'b000000000000000;
      // TXBWCNTRLREG register.
      int_maxSupportedBW             <= 2'b0;
      int_aPPDUMaxTime               <= 8'b0001010;
      int_dynBWEn                    <= 1'b0;
      int_numTryBWAcquisition        <= 3'b01;
      int_dropToLowerBW              <= 1'b1;
      int_defaultBWTXOP              <= 2'b0;
      int_defaultBWTXOPV             <= 1'b0;
      // HTMCSREG register.
      int_bssBasicHTMCSSetUM         <= 6'b00000;
      int_bssBasicHTMCSSetEM         <= 16'b1111111111111111;
      // VHTMCSREG register.
      int_bssBasicVHTMCSSet          <= 16'b1111111111111111;
      // LSTPREG register.
      int_supportLSTP                <= 1'b0;
      // HECONFIGREG register.
      int_dcmSupport                 <= 1'b0;
      int_dopplerSupport             <= 1'b0;
      int_enableOBSSPD               <= 1'b0;
      int_enableSRP                  <= 1'b0;
      int_acceptAllTriggerFrames     <= 1'b0;
      int_acceptTriggerSWFrames      <= 1'b0;
      int_acceptTriggerHWFrames      <= 1'b0;
      int_disableTBUPH               <= 1'b0;
      int_disableTBRU26Resp          <= 1'b0;
      int_disableTBCS                <= 1'b0;
      int_disableTBResp              <= 1'b0;
      int_defaultPEDur               <= 3'b00;
      // SPCONFIG1REG register.
      int_srgOBSSPDMaxOffset         <= 8'b0000000;
      int_srgOBSSPDMinOffset         <= 8'b0000000;
      int_nonSRGOBSSPDMaxOffset      <= 8'b0000000;
      int_srgInformationPresent      <= 1'b0;
      int_nonSRGOffsetPresent        <= 1'b0;
      int_nonSRGOBSSPDSRDisallowed   <= 1'b0;
      int_SRPDisallowed              <= 1'b0;
      // SRGBSSCOLORBITMAPLOWREG register.
      int_SRGBSSColorBitmapLow       <= 32'b0000000000000000000000000000000;
      // SRGBSSCOLORBITMAPHIGHREG register.
      int_SRGBSSColorBitmapHigh      <= 32'b0000000000000000000000000000000;
      // SRGPARTIALBSSIDBITMAPLOWREG register.
      int_SRGPartialBSSIDBitmapLow   <= 32'b0000000000000000000000000000000;
      // SRGPARTIALBSSIDBITMAPHIGHREG register.
      int_SRGPartialBSSIDBitmapHigh  <= 32'b0000000000000000000000000000000;
`ifdef RW_BFMEE_EN                          
      // BFMEECONTROLREG register.
      int_bfrHELTFType               <= 2'b0;
      int_bfrGIType                  <= 2'b0;
      int_bfrFormatMod               <= 3'b100;
      int_bfrShortGI                 <= 1'b0;
      int_bfrMCS                     <= 8'b10000100;
      int_bfmeeNc                    <= 3'b01;
      int_bfmeeNr                    <= 3'b01;
      int_bfmeeGrouping              <= 2'b0;
      int_bfmeeCodebook              <= 1'b1;
      int_bfmeeMUSupport             <= 1'b0;
      int_bfmeeEnable                <= 1'b0;
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      
      // COEXCONTROLREG register.
      int_coexForceWlanPTI           <= 4'b000;
      int_coexForceWlanPTIToggle     <= 1'b0;
      int_coexForceWlanChanBw        <= 1'b0;
      int_coexForceWlanRx            <= 1'b0;
      int_coexForceWlanTx            <= 1'b0;
      int_coexWlanChanFreq           <= 7'b000000;
      int_coexWlanChanOffset         <= 1'b0;
      int_coexAutoPTIAdjIncr         <= 2'b1;
      int_coexAutoPTIAdjEnable       <= 1'b1;
      int_coexForceEnable            <= 1'b0;
      int_coexPostponeTxEnable       <= 1'b1;
      int_coexPHYRxAbortEnable       <= 1'b0;
      int_coexPHYTxAbortEnable       <= 1'b0;
      int_coexEnable                 <= 1'b0;
      // COEXPTIREG register.
      int_coexPTIBcnData             <= 4'b000;
      int_coexPTIBKData              <= 4'b000;
      int_coexPTIBEData              <= 4'b010;
      int_coexPTIVIData              <= 4'b100;
      int_coexPTIVOData              <= 4'b110;
      int_coexPTIMgt                 <= 4'b110;
      int_coexPTICntl                <= 4'b011;
      int_coexPTIAck                 <= 4'b111;
      // COEXINTREG register.
      int_coexWlanRxAbortFallEn      <= 1'b0;
      int_coexWlanRxAbortRiseEn      <= 1'b0;
      int_coexWlanTxAbortFallEn      <= 1'b0;
      int_coexWlanTxAbortRiseEn      <= 1'b0;
`endif // RW_WLAN_COEX_EN                      
      // DEBUGPORTSELREG register.
      int_debugPortSel2              <= 8'b0000000;
      int_debugPortSel1              <= 8'b0000000;
      // DEBUGBASICNAVREG register.
      int_basicNAVCounter            <= 26'b0000000000000000000000000;
      // DEBUGCWREG register.
      int_backoffOffset              <= 2'b0;
      // DEBUGUORAREG register.
      int_ocwLFSR                    <= 7'b000001;
      // DEBUGPHYREG register.
      int_rxEndForTimingErrRec       <= 1'b0;
      int_rxReqForceDeassertion      <= 1'b0;
      // DEBUGINTRANAVREG register.
      int_intraNAVCounter            <= 16'b000000000000000;
    end
    else if (!softRstClk_n) 
    begin
	
      // MACADDRLOWREG register.
      int_macAddrLow                 <= 32'b0000000000000000000000000000000;
      // MACADDRHIREG register.
      int_macAddrHigh                <= 16'b000000000000000;
      // MACADDRLOWMASKREG register.
      int_macAddrLowMask             <= 32'b0000000000000000000000000000000;
      // MACADDRHIMASKREG register.
      int_macAddrHighMask            <= 16'b000000000000000;
      // BSSIDLOWREG register.
      int_bssIDLow                   <= 32'b0000000000000000000000000000000;
      // BSSIDHIREG register.
      int_bssIDHigh                  <= 16'b000000000000000;
      // BSSIDLOWMASKREG register.
      int_bssIDLowMask               <= 32'b0000000000000000000000000000000;
      // BSSIDHIMASKREG register.
      int_bssIDHighMask              <= 16'b000000000000000;
      // BSSCOLORREG register.
      int_partialBSSColorEn          <= 1'b0;
      int_bssColorEn                 <= 1'b0;
      int_bssColor                   <= 6'b00000;
      // STATECNTRLREG register.
      int_nextState                  <= 4'b000;
      // SCANCNTRLREG register.
      int_primaryChPosition          <= 3'b00;
      int_probeDelay                 <= 16'b000000000000000;
      // DOZECNTRL1REG register.
      int_wakeupDTIM                 <= 1'b0;
      int_listenInterval             <= 16'b000000000000000;
      // MACCNTRL1REG register.
      int_rxRIFSEn                   <= 1'b0;
      int_tsfMgtDisable              <= 1'b0;
      int_tsfUpdatedBySW             <= 1'b0;
      int_disableSVDRxPause          <= 1'b0;
      int_disableBQRResp             <= 1'b0;
      int_abgnMode                   <= 3'b11;
      int_keyStoRAMReset             <= 1'b0;
      int_mibTableReset              <= 1'b0;
      int_rateControllerMPIF         <= 1'b1;
      int_disableBAResp              <= 1'b0;
      int_disableCTSResp             <= 1'b0;
      int_disableACKResp             <= 1'b0;
      int_activeClkGating            <= 1'b1;
      int_enableLPClkSwitch          <= 1'b0;
      int_lpClk32786Hz               <= 1'b0;
      int_pwrMgt                     <= 1'b0;
      int_ap                         <= 1'b0;
      int_bssType                    <= 1'b1;
      // MACERRRECCNTRLREG register.
      int_rxFlowCntrlEn              <= 1'b0;
      int_baPSBitmapReset            <= 1'b0;
      int_macPHYIFFIFOReset          <= 1'b0;
      int_txFIFOReset                <= 1'b0;
      int_rxFIFOReset                <= 1'b0;
      int_hwFSMReset                 <= 1'b0;
      int_useErrDet                  <= 1'b0;
      // MACERRSETSTATUSREG register.
      int_errInHWLevel3              <= 1'b0;
      int_errInTxRxLevel2            <= 1'b0;
      int_errInRxLevel1              <= 1'b0;
      int_errInTxLevel1              <= 1'b0;
      // MACERRCLEARSTATUSREG register.
      int_clearErrInHWLevel3         <= 1'b0;
      int_clearErrInTxRxLevel2       <= 1'b0;
      int_clearErrInRxLevel1         <= 1'b0;
      int_clearErrInTxLevel1         <= 1'b0;
      // RXCNTRLREG register.
      int_acceptUnknown              <= 1'b0;
      int_acceptOtherDataFrames      <= 1'b0;
      int_acceptQoSNull              <= 1'b1;
      int_acceptQCFWOData            <= 1'b0;
      int_acceptQData                <= 1'b1;
      int_acceptCFWOData             <= 1'b0;
      int_acceptData                 <= 1'b1;
      int_acceptOtherCntrlFrames     <= 1'b0;
      int_acceptCFEnd                <= 1'b0;
      int_acceptACK                  <= 1'b0;
      int_acceptCTS                  <= 1'b0;
      int_acceptRTS                  <= 1'b0;
      int_acceptPSPoll               <= 1'b1;
      int_acceptBA                   <= 1'b1;
      int_acceptBAR                  <= 1'b1;
      int_acceptOtherMgmtFrames      <= 1'b1;
      int_acceptBfmeeFrames          <= 1'b0;
      int_acceptAllBeacon            <= 1'b0;
      int_acceptNotExpectedBA        <= 1'b0;
      int_acceptDecryptErrorFrames   <= 1'b0;
      int_acceptBeacon               <= 1'b1;
      int_acceptProbeResp            <= 1'b1;
      int_acceptProbeReq             <= 1'b1;
      int_acceptMyUnicast            <= 1'b1;
      int_acceptUnicast              <= 1'b0;
      int_acceptErrorFrames          <= 1'b0;
      int_acceptOtherBSSID           <= 1'b0;
      int_acceptBroadcast            <= 1'b1;
      int_acceptMulticast            <= 1'b0;
      int_dontDecrypt                <= 1'b0;
      int_excUnencrypted             <= 1'b0;
      // BCNCNTRL1REG register.
      int_noBcnTxTime                <= 8'd`NO_BCN_TX_TIME;
      int_impTBTTIn128Us             <= 1'b0;
      int_impTBTTPeriod              <= 7'd`IMP_TBTT_TIME;
      int_beaconInt                  <= 16'b000000000000000;
      // BCNCNTRL2REG register.
      int_aid                        <= 16'b000000000000000;
      int_timOffset                  <= 8'b0000000;
      int_bcnUpdateOffset            <= 8'b0000000;
      // DTIM1REG register.
      int_dtimUpdatedBySW            <= 1'b0;
      int_dtimPeriod                 <= 8'b0000000;
      // RETRYLIMITSREG register.
      int_dot11LongRetryLimit        <= 8'b0000100;
      int_dot11ShortRetryLimit       <= 8'b0000111;
      // BBSERVICEREG register.
      int_maxPHYNtx                  <= 3'b01;
      int_bbServiceB                 <= 8'b0000000;
      int_bbServiceA                 <= 16'b000000000000000;
      // MAXPOWERLEVELREG register.
      int_ofdmMinPwrLevel            <= 8'b0000000;
      int_dsssMaxPwrLevel            <= 8'b0001111;
      int_ofdmMaxPwrLevel            <= 8'b0001111;
      // ENCRKEY0REG register.
      int_encrKeyRAMWord0            <= 32'b0000000000000000000000000000000;
      // ENCRKEY1REG register.
      int_encrKeyRAMWord1            <= 32'b0000000000000000000000000000000;
      // ENCRKEY2REG register.
      int_encrKeyRAMWord2            <= 32'b0000000000000000000000000000000;
      // ENCRKEY3REG register.
      int_encrKeyRAMWord3            <= 32'b0000000000000000000000000000000;
      // ENCRMACADDRLOWREG register.
      int_macAddrRAMLow              <= 32'b11111111111111111111111111111111;
      // ENCRMACADDRHIGHREG register.
      int_macAddrRAMHigh             <= 16'b1111111111111111;
      // ENCRCNTRLREG register.
      int_newRead                    <= 1'b0;
      int_newWrite                   <= 1'b0;
      int_newSearch                  <= 1'b0;
      int_searchError                <= 1'b0;
      int_keyIndexRAM                <= 10'b000000000;
      int_cLenRAM                    <= 2'b0;
      int_cTypeRAM                   <= 3'b00;
      int_vlanIDRAM                  <= 4'b000;
      int_sppRAM                     <= 2'b0;
      int_useDefKeyRAM               <= 1'b0;
`ifdef RW_KEY_EXTENDED                      
      // ENCRWPIINTKEY0REG register.
      int_encrIntKeyRAMWord0         <= 32'b0000000000000000000000000000000;
      // ENCRWPIINTKEY1REG register.
      int_encrIntKeyRAMWord1         <= 32'b0000000000000000000000000000000;
      // ENCRWPIINTKEY2REG register.
      int_encrIntKeyRAMWord2         <= 32'b0000000000000000000000000000000;
      // ENCRWPIINTKEY3REG register.
      int_encrIntKeyRAMWord3         <= 32'b0000000000000000000000000000000;
`endif // RW_KEY_EXTENDED                      
      // ENCRRAMCONFIGREG register.
      int_nVAP                       <= 4'd`RW_KEY_NVAP;
      int_staKeyEndIndex             <= 8'd`RW_KEY_INDEX_MAX;
      int_staKeyStartIndex           <= 8'd`RW_KEY_NVAP*4;
      // RATESREG register.
      int_bssBasicRateSet            <= 12'b00101010000;
      // OLBCREG register.
      int_dsssCount                  <= 8'b0000000;
      int_ofdmCount                  <= 8'b0000000;
      int_olbcTimer                  <= 16'b000000000000000;
      // TIMINGS1REG register.
      int_txChainDelayInMACClk       <= 10'd`TX_CHAIN_DLY * 10'd`MAC_FREQ;
      int_txRFDelayInMACClk          <= 10'd`TX_RF_DLY * 10'd`MAC_FREQ;
      int_macCoreClkFreq             <= 8'd`MAC_FREQ;
      // TIMINGS2REG register.
      int_slotTimeInMACClk           <= 16'd`SHORT_SLOT * 16'd`MAC_FREQ;
      int_slotTime                   <= 8'd`SHORT_SLOT;
      // TIMINGS3REG register.
      int_rxRFDelayInMACClk          <= 10'd`RX_RF_DLY * 10'd`MAC_FREQ;
      int_macProcDelayInMACClk       <= 10'd`MAC_PROC_DELAY * 10'd`MAC_FREQ;
      // TIMINGS4REG register.
      int_radioWakeUpTime            <= 10'd`RADIOWAKEUP_TIME;
      int_radioChirpTime             <= 10'd`RADIO_CHIRP_TIME;
      int_wt2CryptClkRatio           <= 2'd`WEP_2_BB_CLK_RATIO;
      // TIMINGS5REG register.
      int_sifsBInMACClk              <= 16'd`SIFS_B * 16'd`MAC_FREQ;
      int_sifsB                      <= 8'd`SIFS_B;
      // TIMINGS6REG register.
      int_sifsAInMACClk              <= 16'd`SIFS_A* 16'd`MAC_FREQ;
      int_sifsA                      <= 8'd`SIFS_A;
      // TIMINGS7REG register.
      int_rxCCADelay                 <= 4'd`RX_CCA_DLY;
      // TIMINGS8REG register.
      int_rxStartDelayMIMO           <= 8'b0100001;
      int_rxStartDelayShort          <= 8'b1100110;
      int_rxStartDelayLong           <= 8'b11000110;
      int_rxStartDelayOFDM           <= 8'b0100001;
      // TIMINGS9REG register.
      int_rifsTOInMACClk             <= 10'd`RIFSTO * 10'd`MAC_FREQ;
      int_txDMAProcDlyInMACClk       <= 10'd`TX_DMA_PROC_DLY * 10'd`MAC_FREQ;
      // RXCNTRL2 register.
      int_disableRxBuffer2           <= 1'b0;
      int_dataMHStoredwithPld        <= 1'b0;
      int_mgtMHStoredwithPld         <= 1'b1;
      int_ctrlMHStoredwithPld        <= 1'b1;
      int_partialUnwrapSize          <= 8'b0110010;
      int_dataFrmWrapMode            <= 2'b10;
      int_mgtFrmWrapMode             <= 2'b1;
      int_ctrlFrmWrapMode            <= 2'b1;
      // TXTRIGGERTIMERREG register.
      int_txPacketTimeout            <= 8'b0001111;
      int_txAbsoluteTimeout          <= 8'b10011100;
      // RXTRIGGERTIMERREG register.
      int_rxPacketTimeout            <= 8'b0001111;
      int_rxAbsoluteTimeout          <= 8'b10011100;
      // MIBTABLEWRITEREG register.
      int_mibValue                   <= 16'b000000000000000;
      int_mibWrite                   <= 1'b0;
      int_mibIncrementMode           <= 1'b1;
      int_mibTableIndex              <= 10'b000000000;
      // MONOTONICCOUNTER2LOREG register.
      int_monotonicCounterLow2       <= 32'b0000000000000000000000000000000;
      // MONOTONICCOUNTER2HIREG register.
      int_monotonicCounter2SWUpdate  <= 1'b0;
      int_monotonicCounterHigh2      <= 16'b000000000000000;
      // ABSTIMERREG0 register.
      int_absTimerValue0             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG1 register.
      int_absTimerValue1             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG2 register.
      int_absTimerValue2             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG3 register.
      int_absTimerValue3             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG4 register.
      int_absTimerValue4             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG5 register.
      int_absTimerValue5             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG6 register.
      int_absTimerValue6             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG7 register.
      int_absTimerValue7             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG8 register.
      int_absTimerValue8             <= 32'b0000000000000000000000000000000;
      // ABSTIMERREG9 register.
      int_absTimerValue9             <= 32'b0000000000000000000000000000000;
      // MAXRXLENGTHREG register.
      int_maxAllowedLength           <= 20'b0001111111111111111;
      // EDCAAC0REG register.
      int_txOpLimit0                 <= 16'b000000000000000;
      int_cwMax0                     <= 4'b1010;
      int_cwMin0                     <= 4'b100;
      int_aifsn0                     <= 4'b111;
      // EDCAAC1REG register.
      int_txOpLimit1                 <= 16'b000000000000000;
      int_cwMax1                     <= 4'b1010;
      int_cwMin1                     <= 4'b100;
      int_aifsn1                     <= 4'b011;
      // EDCAAC2REG register.
      int_txOpLimit2                 <= 16'b000000001011110;
      int_cwMax2                     <= 4'b100;
      int_cwMin2                     <= 4'b011;
      int_aifsn2                     <= 4'b010;
      // EDCAAC3REG register.
      int_txOpLimit3                 <= 16'b000000000101111;
      int_cwMax3                     <= 4'b011;
      int_cwMin3                     <= 4'b010;
      int_aifsn3                     <= 4'b010;
      // EDCACCABUSYREG register.
      int_ccaBusyDur                 <= 32'b0000000000000000000000000000000;
      // EDCACNTRLREG register.
      int_keepTXOPOpen               <= 1'b0;
      int_remTXOPInDurField          <= 1'b0;
      int_sendCFEnd                  <= 1'b0;
      int_sendCFEndNow               <= 1'b0;
      // QUIETELEMENT1AREG register.
      int_quietDuration1             <= 16'b000000000000000;
      int_quietPeriod1               <= 8'b0000000;
      int_quietCount1                <= 8'b0000000;
      // QUIETELEMENT1BREG register.
      int_quietOffset1               <= 16'b000000000000000;
      // ADDCCABUSYSEC20REG register.
      int_ccaBusyDurSec20            <= 32'b0000000000000000000000000000000;
      // ADDCCABUSYSEC40REG register.
      int_ccaBusyDurSec40            <= 32'b0000000000000000000000000000000;
      // ADDCCABUSYSEC80REG register.
      int_ccaBusyDurSec80            <= 32'b0000000000000000000000000000000;
      // STBCCNTRLREG register.
      int_basicSTBCMCS               <= 7'b000000;
      int_dualCTSProt                <= 1'b0;
      int_ctsSTBCDur                 <= 8'b0000000;
      int_cfEndSTBCDur               <= 16'b000000000000000;
      // TXBWCNTRLREG register.
      int_maxSupportedBW             <= 2'b0;
      int_aPPDUMaxTime               <= 8'b0001010;
      int_dynBWEn                    <= 1'b0;
      int_numTryBWAcquisition        <= 3'b01;
      int_dropToLowerBW              <= 1'b1;
      int_defaultBWTXOP              <= 2'b0;
      int_defaultBWTXOPV             <= 1'b0;
      // HTMCSREG register.
      int_bssBasicHTMCSSetUM         <= 6'b00000;
      int_bssBasicHTMCSSetEM         <= 16'b1111111111111111;
      // VHTMCSREG register.
      int_bssBasicVHTMCSSet          <= 16'b1111111111111111;
      // LSTPREG register.
      int_supportLSTP                <= 1'b0;
      // HECONFIGREG register.
      int_dcmSupport                 <= 1'b0;
      int_dopplerSupport             <= 1'b0;
      int_enableOBSSPD               <= 1'b0;
      int_enableSRP                  <= 1'b0;
      int_acceptAllTriggerFrames     <= 1'b0;
      int_acceptTriggerSWFrames      <= 1'b0;
      int_acceptTriggerHWFrames      <= 1'b0;
      int_disableTBUPH               <= 1'b0;
      int_disableTBRU26Resp          <= 1'b0;
      int_disableTBCS                <= 1'b0;
      int_disableTBResp              <= 1'b0;
      int_defaultPEDur               <= 3'b00;
      // SPCONFIG1REG register.
      int_srgOBSSPDMaxOffset         <= 8'b0000000;
      int_srgOBSSPDMinOffset         <= 8'b0000000;
      int_nonSRGOBSSPDMaxOffset      <= 8'b0000000;
      int_srgInformationPresent      <= 1'b0;
      int_nonSRGOffsetPresent        <= 1'b0;
      int_nonSRGOBSSPDSRDisallowed   <= 1'b0;
      int_SRPDisallowed              <= 1'b0;
      // SRGBSSCOLORBITMAPLOWREG register.
      int_SRGBSSColorBitmapLow       <= 32'b0000000000000000000000000000000;
      // SRGBSSCOLORBITMAPHIGHREG register.
      int_SRGBSSColorBitmapHigh      <= 32'b0000000000000000000000000000000;
      // SRGPARTIALBSSIDBITMAPLOWREG register.
      int_SRGPartialBSSIDBitmapLow   <= 32'b0000000000000000000000000000000;
      // SRGPARTIALBSSIDBITMAPHIGHREG register.
      int_SRGPartialBSSIDBitmapHigh  <= 32'b0000000000000000000000000000000;
`ifdef RW_BFMEE_EN                          
      // BFMEECONTROLREG register.
      int_bfrHELTFType               <= 2'b0;
      int_bfrGIType                  <= 2'b0;
      int_bfrFormatMod               <= 3'b100;
      int_bfrShortGI                 <= 1'b0;
      int_bfrMCS                     <= 8'b10000100;
      int_bfmeeNc                    <= 3'b01;
      int_bfmeeNr                    <= 3'b01;
      int_bfmeeGrouping              <= 2'b0;
      int_bfmeeCodebook              <= 1'b1;
      int_bfmeeMUSupport             <= 1'b0;
      int_bfmeeEnable                <= 1'b0;
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      
      // COEXCONTROLREG register.
      int_coexForceWlanPTI           <= 4'b000;
      int_coexForceWlanPTIToggle     <= 1'b0;
      int_coexForceWlanChanBw        <= 1'b0;
      int_coexForceWlanRx            <= 1'b0;
      int_coexForceWlanTx            <= 1'b0;
      int_coexWlanChanFreq           <= 7'b000000;
      int_coexWlanChanOffset         <= 1'b0;
      int_coexAutoPTIAdjIncr         <= 2'b1;
      int_coexAutoPTIAdjEnable       <= 1'b1;
      int_coexForceEnable            <= 1'b0;
      int_coexPostponeTxEnable       <= 1'b1;
      int_coexPHYRxAbortEnable       <= 1'b0;
      int_coexPHYTxAbortEnable       <= 1'b0;
      int_coexEnable                 <= 1'b0;
      // COEXPTIREG register.
      int_coexPTIBcnData             <= 4'b000;
      int_coexPTIBKData              <= 4'b000;
      int_coexPTIBEData              <= 4'b010;
      int_coexPTIVIData              <= 4'b100;
      int_coexPTIVOData              <= 4'b110;
      int_coexPTIMgt                 <= 4'b110;
      int_coexPTICntl                <= 4'b011;
      int_coexPTIAck                 <= 4'b111;
      // COEXINTREG register.
      int_coexWlanRxAbortFallEn      <= 1'b0;
      int_coexWlanRxAbortRiseEn      <= 1'b0;
      int_coexWlanTxAbortFallEn      <= 1'b0;
      int_coexWlanTxAbortRiseEn      <= 1'b0;
`endif // RW_WLAN_COEX_EN                      
      // DEBUGPORTSELREG register.
      int_debugPortSel2              <= 8'b0000000;
      int_debugPortSel1              <= 8'b0000000;
      // DEBUGBASICNAVREG register.
      int_basicNAVCounter            <= 26'b0000000000000000000000000;
      // DEBUGCWREG register.
      int_backoffOffset              <= 2'b0;
      // DEBUGUORAREG register.
      int_ocwLFSR                    <= 7'b000001;
      // DEBUGPHYREG register.
      int_rxEndForTimingErrRec       <= 1'b0;
      int_rxReqForceDeassertion      <= 1'b0;
      // DEBUGINTRANAVREG register.
      int_intraNAVCounter            <= 16'b000000000000000;
    end

    else
    begin
      if (nextStateInValid)
        int_nextState                  <= nextStateIn;
      if (tsfUpdatedBySWInValid)
        int_tsfUpdatedBySW             <= tsfUpdatedBySWIn;
      if (keyStoRAMResetInValid)
        int_keyStoRAMReset             <= keyStoRAMResetIn;
      if (mibTableResetInValid)
        int_mibTableReset              <= mibTableResetIn;
      if (baPSBitmapResetInValid)
        int_baPSBitmapReset            <= baPSBitmapResetIn;
      if (macPHYIFFIFOResetInValid)
        int_macPHYIFFIFOReset          <= macPHYIFFIFOResetIn;
      if (txFIFOResetInValid)
        int_txFIFOReset                <= txFIFOResetIn;
      if (rxFIFOResetInValid)
        int_rxFIFOReset                <= rxFIFOResetIn;
      if (hwFSMResetInValid)
        int_hwFSMReset                 <= hwFSMResetIn;
      if (dtimUpdatedBySWInValid)
        int_dtimUpdatedBySW            <= dtimUpdatedBySWIn;
      if (dtimPeriodInValid)
        int_dtimPeriod                 <= dtimPeriodIn;
      if (encrKeyRAMWord0InValid)
        int_encrKeyRAMWord0            <= encrKeyRAMWord0In;
      if (encrKeyRAMWord1InValid)
        int_encrKeyRAMWord1            <= encrKeyRAMWord1In;
      if (encrKeyRAMWord2InValid)
        int_encrKeyRAMWord2            <= encrKeyRAMWord2In;
      if (encrKeyRAMWord3InValid)
        int_encrKeyRAMWord3            <= encrKeyRAMWord3In;
      if (macAddrRAMLowInValid)
        int_macAddrRAMLow              <= macAddrRAMLowIn;
      if (macAddrRAMHighInValid)
        int_macAddrRAMHigh             <= macAddrRAMHighIn;
      if (newReadInValid)
        int_newRead                    <= newReadIn;
      if (newWriteInValid)
        int_newWrite                   <= newWriteIn;
      if (newSearchInValid)
        int_newSearch                  <= newSearchIn;
      if (searchErrorInValid)
        int_searchError                <= searchErrorIn;
      if (keyIndexRAMInValid)
        int_keyIndexRAM                <= keyIndexRAMIn;
      if (cLenRAMInValid)
        int_cLenRAM                    <= cLenRAMIn;
      if (cTypeRAMInValid)
        int_cTypeRAM                   <= cTypeRAMIn;
      if (vlanIDRAMInValid)
        int_vlanIDRAM                  <= vlanIDRAMIn;
      if (sppRAMInValid)
        int_sppRAM                     <= sppRAMIn;
      if (useDefKeyRAMInValid)
        int_useDefKeyRAM               <= useDefKeyRAMIn;
`ifdef RW_KEY_EXTENDED                      
      if (encrIntKeyRAMWord0InValid)
        int_encrIntKeyRAMWord0         <= encrIntKeyRAMWord0In;
      if (encrIntKeyRAMWord1InValid)
        int_encrIntKeyRAMWord1         <= encrIntKeyRAMWord1In;
      if (encrIntKeyRAMWord2InValid)
        int_encrIntKeyRAMWord2         <= encrIntKeyRAMWord2In;
      if (encrIntKeyRAMWord3InValid)
        int_encrIntKeyRAMWord3         <= encrIntKeyRAMWord3In;
`endif // RW_KEY_EXTENDED                      
      if (mibWriteInValid)
        int_mibWrite                   <= mibWriteIn;
      if (monotonicCounterLow2InValid)
        int_monotonicCounterLow2       <= monotonicCounterLow2In;
      if (monotonicCounterHigh2InValid)
        int_monotonicCounterHigh2      <= monotonicCounterHigh2In;
      if (ccaBusyDurInValid)
        int_ccaBusyDur                 <= ccaBusyDurIn;
      if (sendCFEndNowInValid)
        int_sendCFEndNow               <= sendCFEndNowIn;
      if (quietDuration1InValid)
        int_quietDuration1             <= quietDuration1In;
      if (quietPeriod1InValid)
        int_quietPeriod1               <= quietPeriod1In;
      if (quietCount1InValid)
        int_quietCount1                <= quietCount1In;
      if (quietOffset1InValid)
        int_quietOffset1               <= quietOffset1In;
      if (ccaBusyDurSec20InValid)
        int_ccaBusyDurSec20            <= ccaBusyDurSec20In;
      if (ccaBusyDurSec40InValid)
        int_ccaBusyDurSec40            <= ccaBusyDurSec40In;
      if (ccaBusyDurSec80InValid)
        int_ccaBusyDurSec80            <= ccaBusyDurSec80In;
`ifdef RW_BFMEE_EN                          
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      
`endif // RW_WLAN_COEX_EN                      
      if (basicNAVCounterInValid)
        int_basicNAVCounter            <= basicNAVCounterIn;
      if (ocwLFSRInValid)
        int_ocwLFSR                    <= ocwLFSRIn;
      if (intraNAVCounterInValid)
        int_intraNAVCounter            <= intraNAVCounterIn;
      if(regSel && regWrite)
      begin
        case(regAddr)

          // Write MACADDRLOWREG register.
          MACADDRLOWREG_ADDR_CT : begin
            int_macAddrLow                 <= regWriteData[31 : 0];
          end

          // Write MACADDRHIREG register.
          MACADDRHIREG_ADDR_CT : begin
            int_macAddrHigh                <= regWriteData[15 : 0];
          end

          // Write MACADDRLOWMASKREG register.
          MACADDRLOWMASKREG_ADDR_CT : begin
            int_macAddrLowMask             <= regWriteData[31 : 0];
          end

          // Write MACADDRHIMASKREG register.
          MACADDRHIMASKREG_ADDR_CT : begin
            int_macAddrHighMask            <= regWriteData[15 : 0];
          end

          // Write BSSIDLOWREG register.
          BSSIDLOWREG_ADDR_CT : begin
            int_bssIDLow                   <= regWriteData[31 : 0];
          end

          // Write BSSIDHIREG register.
          BSSIDHIREG_ADDR_CT : begin
            int_bssIDHigh                  <= regWriteData[15 : 0];
          end

          // Write BSSIDLOWMASKREG register.
          BSSIDLOWMASKREG_ADDR_CT : begin
            int_bssIDLowMask               <= regWriteData[31 : 0];
          end

          // Write BSSIDHIMASKREG register.
          BSSIDHIMASKREG_ADDR_CT : begin
            int_bssIDHighMask              <= regWriteData[15 : 0];
          end

          // Write BSSCOLORREG register.
          BSSCOLORREG_ADDR_CT : begin
            int_partialBSSColorEn          <= regWriteData[9];
            int_bssColorEn                 <= regWriteData[8];
            int_bssColor                   <= regWriteData[5 : 0];
          end

          // Write STATECNTRLREG register.
          STATECNTRLREG_ADDR_CT : begin
            int_nextState                  <= regWriteData[7 : 4];
          end

          // Write SCANCNTRLREG register.
          SCANCNTRLREG_ADDR_CT : begin
            int_primaryChPosition          <= regWriteData[22 : 20];
            int_probeDelay                 <= regWriteData[15 : 0];
          end

          // Write DOZECNTRL1REG register.
          DOZECNTRL1REG_ADDR_CT : begin
            int_wakeupDTIM                 <= regWriteData[16];
            int_listenInterval             <= regWriteData[15 : 0];
          end

          // Write MACCNTRL1REG register.
          MACCNTRL1REG_ADDR_CT : begin
            int_rxRIFSEn                   <= regWriteData[26];
            int_tsfMgtDisable              <= regWriteData[25];
            int_tsfUpdatedBySW             <= regWriteData[24];
            int_disableSVDRxPause          <= regWriteData[19];
            int_disableBQRResp             <= regWriteData[18];
            int_abgnMode                   <= regWriteData[16 : 14];
            int_keyStoRAMReset             <= regWriteData[13];
            int_mibTableReset              <= regWriteData[12];
            int_rateControllerMPIF         <= regWriteData[11];
            int_disableBAResp              <= regWriteData[10];
            int_disableCTSResp             <= regWriteData[9];
            int_disableACKResp             <= regWriteData[8];
            int_activeClkGating            <= regWriteData[7];
            int_enableLPClkSwitch          <= regWriteData[6];
            int_lpClk32786Hz               <= regWriteData[5];
            int_pwrMgt                     <= regWriteData[2];
            int_ap                         <= regWriteData[1];
            int_bssType                    <= regWriteData[0];
          end

          // Write MACERRRECCNTRLREG register.
          MACERRRECCNTRLREG_ADDR_CT : begin
            int_rxFlowCntrlEn              <= regWriteData[16];
            int_baPSBitmapReset            <= regWriteData[7];
            int_macPHYIFFIFOReset          <= regWriteData[5];
            int_txFIFOReset                <= regWriteData[4];
            int_rxFIFOReset                <= regWriteData[3];
            int_hwFSMReset                 <= regWriteData[2];
            int_useErrDet                  <= regWriteData[1];
          end

          // Write MACERRSETSTATUSREG register.
          MACERRSETSTATUSREG_ADDR_CT : begin
            int_errInHWLevel3              <= regWriteData[3];
            int_errInTxRxLevel2            <= regWriteData[2];
            int_errInRxLevel1              <= regWriteData[1];
            int_errInTxLevel1              <= regWriteData[0];
          end

          // Write MACERRCLEARSTATUSREG register.
          MACERRCLEARSTATUSREG_ADDR_CT : begin
            int_clearErrInHWLevel3         <= regWriteData[3];
            int_clearErrInTxRxLevel2       <= regWriteData[2];
            int_clearErrInRxLevel1         <= regWriteData[1];
            int_clearErrInTxLevel1         <= regWriteData[0];
          end

          // Write RXCNTRLREG register.
          RXCNTRLREG_ADDR_CT : begin
            int_acceptUnknown              <= regWriteData[30];
            int_acceptOtherDataFrames      <= regWriteData[29];
            int_acceptQoSNull              <= regWriteData[28];
            int_acceptQCFWOData            <= regWriteData[27];
            int_acceptQData                <= regWriteData[26];
            int_acceptCFWOData             <= regWriteData[25];
            int_acceptData                 <= regWriteData[24];
            int_acceptOtherCntrlFrames     <= regWriteData[23];
            int_acceptCFEnd                <= regWriteData[22];
            int_acceptACK                  <= regWriteData[21];
            int_acceptCTS                  <= regWriteData[20];
            int_acceptRTS                  <= regWriteData[19];
            int_acceptPSPoll               <= regWriteData[18];
            int_acceptBA                   <= regWriteData[17];
            int_acceptBAR                  <= regWriteData[16];
            int_acceptOtherMgmtFrames      <= regWriteData[15];
            int_acceptBfmeeFrames          <= regWriteData[14];
            int_acceptAllBeacon            <= regWriteData[13];
            int_acceptNotExpectedBA        <= regWriteData[12];
            int_acceptDecryptErrorFrames   <= regWriteData[11];
            int_acceptBeacon               <= regWriteData[10];
            int_acceptProbeResp            <= regWriteData[9];
            int_acceptProbeReq             <= regWriteData[8];
            int_acceptMyUnicast            <= regWriteData[7];
            int_acceptUnicast              <= regWriteData[6];
            int_acceptErrorFrames          <= regWriteData[5];
            int_acceptOtherBSSID           <= regWriteData[4];
            int_acceptBroadcast            <= regWriteData[3];
            int_acceptMulticast            <= regWriteData[2];
            int_dontDecrypt                <= regWriteData[1];
            int_excUnencrypted             <= regWriteData[0];
          end

          // Write BCNCNTRL1REG register.
          BCNCNTRL1REG_ADDR_CT : begin
            int_noBcnTxTime                <= regWriteData[31 : 24];
            int_impTBTTIn128Us             <= regWriteData[23];
            int_impTBTTPeriod              <= regWriteData[22 : 16];
            int_beaconInt                  <= regWriteData[15 : 0];
          end

          // Write BCNCNTRL2REG register.
          BCNCNTRL2REG_ADDR_CT : begin
            int_aid                        <= regWriteData[31 : 16];
            int_timOffset                  <= regWriteData[15 : 8];
            int_bcnUpdateOffset            <= regWriteData[7 : 0];
          end

          // Write DTIM1REG register.
          DTIM1REG_ADDR_CT : begin
            int_dtimUpdatedBySW            <= regWriteData[31];
            int_dtimPeriod                 <= regWriteData[7 : 0];
          end

          // Write RETRYLIMITSREG register.
          RETRYLIMITSREG_ADDR_CT : begin
            int_dot11LongRetryLimit        <= regWriteData[15 : 8];
            int_dot11ShortRetryLimit       <= regWriteData[7 : 0];
          end

          // Write BBSERVICEREG register.
          BBSERVICEREG_ADDR_CT : begin
            int_maxPHYNtx                  <= regWriteData[28 : 26];
            int_bbServiceB                 <= regWriteData[23 : 16];
            int_bbServiceA                 <= regWriteData[15 : 0];
          end

          // Write MAXPOWERLEVELREG register.
          MAXPOWERLEVELREG_ADDR_CT : begin
            int_ofdmMinPwrLevel            <= regWriteData[23 : 16];
            int_dsssMaxPwrLevel            <= regWriteData[15 : 8];
            int_ofdmMaxPwrLevel            <= regWriteData[7 : 0];
          end

          // Write ENCRKEY0REG register.
          ENCRKEY0REG_ADDR_CT : begin
            int_encrKeyRAMWord0            <= regWriteData[31 : 0];
          end

          // Write ENCRKEY1REG register.
          ENCRKEY1REG_ADDR_CT : begin
            int_encrKeyRAMWord1            <= regWriteData[31 : 0];
          end

          // Write ENCRKEY2REG register.
          ENCRKEY2REG_ADDR_CT : begin
            int_encrKeyRAMWord2            <= regWriteData[31 : 0];
          end

          // Write ENCRKEY3REG register.
          ENCRKEY3REG_ADDR_CT : begin
            int_encrKeyRAMWord3            <= regWriteData[31 : 0];
          end

          // Write ENCRMACADDRLOWREG register.
          ENCRMACADDRLOWREG_ADDR_CT : begin
            int_macAddrRAMLow              <= regWriteData[31 : 0];
          end

          // Write ENCRMACADDRHIGHREG register.
          ENCRMACADDRHIGHREG_ADDR_CT : begin
            int_macAddrRAMHigh             <= regWriteData[15 : 0];
          end

          // Write ENCRCNTRLREG register.
          ENCRCNTRLREG_ADDR_CT : begin
            int_newRead                    <= regWriteData[31];
            int_newWrite                   <= regWriteData[30];
            int_newSearch                  <= regWriteData[29];
            int_searchError                <= regWriteData[28];
            int_keyIndexRAM                <= regWriteData[25 : 16];
            int_cLenRAM                    <= regWriteData[13 : 12];
            int_cTypeRAM                   <= regWriteData[10 : 8];
            int_vlanIDRAM                  <= regWriteData[7 : 4];
            int_sppRAM                     <= regWriteData[3 : 2];
            int_useDefKeyRAM               <= regWriteData[1];
          end
`ifdef RW_KEY_EXTENDED                      

          // Write ENCRWPIINTKEY0REG register.
          ENCRWPIINTKEY0REG_ADDR_CT : begin
            int_encrIntKeyRAMWord0         <= regWriteData[31 : 0];
          end

          // Write ENCRWPIINTKEY1REG register.
          ENCRWPIINTKEY1REG_ADDR_CT : begin
            int_encrIntKeyRAMWord1         <= regWriteData[31 : 0];
          end

          // Write ENCRWPIINTKEY2REG register.
          ENCRWPIINTKEY2REG_ADDR_CT : begin
            int_encrIntKeyRAMWord2         <= regWriteData[31 : 0];
          end

          // Write ENCRWPIINTKEY3REG register.
          ENCRWPIINTKEY3REG_ADDR_CT : begin
            int_encrIntKeyRAMWord3         <= regWriteData[31 : 0];
          end
`endif // RW_KEY_EXTENDED                      

          // Write ENCRRAMCONFIGREG register.
          ENCRRAMCONFIGREG_ADDR_CT : begin
            int_nVAP                       <= regWriteData[19 : 16];
            int_staKeyEndIndex             <= regWriteData[15 : 8];
            int_staKeyStartIndex           <= regWriteData[7 : 0];
          end

          // Write RATESREG register.
          RATESREG_ADDR_CT : begin
            int_bssBasicRateSet            <= regWriteData[11 : 0];
          end

          // Write OLBCREG register.
          OLBCREG_ADDR_CT : begin
            int_dsssCount                  <= regWriteData[31 : 24];
            int_ofdmCount                  <= regWriteData[23 : 16];
            int_olbcTimer                  <= regWriteData[15 : 0];
          end

          // Write TIMINGS1REG register.
          TIMINGS1REG_ADDR_CT : begin
            int_txChainDelayInMACClk       <= regWriteData[27 : 18];
            int_txRFDelayInMACClk          <= regWriteData[17 : 8];
            int_macCoreClkFreq             <= regWriteData[7 : 0];
          end

          // Write TIMINGS2REG register.
          TIMINGS2REG_ADDR_CT : begin
            int_slotTimeInMACClk           <= regWriteData[23 : 8];
            int_slotTime                   <= regWriteData[7 : 0];
          end

          // Write TIMINGS3REG register.
          TIMINGS3REG_ADDR_CT : begin
            int_rxRFDelayInMACClk          <= regWriteData[29 : 20];
            int_macProcDelayInMACClk       <= regWriteData[9 : 0];
          end

          // Write TIMINGS4REG register.
          TIMINGS4REG_ADDR_CT : begin
            int_radioWakeUpTime            <= regWriteData[31 : 22];
            int_radioChirpTime             <= regWriteData[21 : 12];
            int_wt2CryptClkRatio           <= regWriteData[1 : 0];
          end

          // Write TIMINGS5REG register.
          TIMINGS5REG_ADDR_CT : begin
            int_sifsBInMACClk              <= regWriteData[23 : 8];
            int_sifsB                      <= regWriteData[7 : 0];
          end

          // Write TIMINGS6REG register.
          TIMINGS6REG_ADDR_CT : begin
            int_sifsAInMACClk              <= regWriteData[23 : 8];
            int_sifsA                      <= regWriteData[7 : 0];
          end

          // Write TIMINGS7REG register.
          TIMINGS7REG_ADDR_CT : begin
            int_rxCCADelay                 <= regWriteData[11 : 8];
          end

          // Write TIMINGS8REG register.
          TIMINGS8REG_ADDR_CT : begin
            int_rxStartDelayMIMO           <= regWriteData[31 : 24];
            int_rxStartDelayShort          <= regWriteData[23 : 16];
            int_rxStartDelayLong           <= regWriteData[15 : 8];
            int_rxStartDelayOFDM           <= regWriteData[7 : 0];
          end

          // Write TIMINGS9REG register.
          TIMINGS9REG_ADDR_CT : begin
            int_rifsTOInMACClk             <= regWriteData[29 : 20];
            int_txDMAProcDlyInMACClk       <= regWriteData[9 : 0];
          end

          // Write RXCNTRL2 register.
          RXCNTRL2_ADDR_CT : begin
            int_disableRxBuffer2           <= regWriteData[19];
            int_dataMHStoredwithPld        <= regWriteData[18];
            int_mgtMHStoredwithPld         <= regWriteData[17];
            int_ctrlMHStoredwithPld        <= regWriteData[16];
            int_partialUnwrapSize          <= regWriteData[15 : 8];
            int_dataFrmWrapMode            <= regWriteData[5 : 4];
            int_mgtFrmWrapMode             <= regWriteData[3 : 2];
            int_ctrlFrmWrapMode            <= regWriteData[1 : 0];
          end

          // Write TXTRIGGERTIMERREG register.
          TXTRIGGERTIMERREG_ADDR_CT : begin
            int_txPacketTimeout            <= regWriteData[15 : 8];
            int_txAbsoluteTimeout          <= regWriteData[7 : 0];
          end

          // Write RXTRIGGERTIMERREG register.
          RXTRIGGERTIMERREG_ADDR_CT : begin
            int_rxPacketTimeout            <= regWriteData[15 : 8];
            int_rxAbsoluteTimeout          <= regWriteData[7 : 0];
          end

          // Write MIBTABLEWRITEREG register.
          MIBTABLEWRITEREG_ADDR_CT : begin
            int_mibValue                   <= regWriteData[31 : 16];
            int_mibWrite                   <= regWriteData[15];
            int_mibIncrementMode           <= regWriteData[14];
            int_mibTableIndex              <= regWriteData[9 : 0];
          end

          // Write MONOTONICCOUNTER2LOREG register.
          MONOTONICCOUNTER2LOREG_ADDR_CT : begin
            int_monotonicCounterLow2       <= regWriteData[31 : 0];
          end

          // Write MONOTONICCOUNTER2HIREG register.
          MONOTONICCOUNTER2HIREG_ADDR_CT : begin
            int_monotonicCounter2SWUpdate  <= regWriteData[31];
            int_monotonicCounterHigh2      <= regWriteData[15 : 0];
          end

          // Write ABSTIMERREG0 register.
          ABSTIMERREG0_ADDR_CT : begin
            int_absTimerValue0             <= regWriteData[31 : 0];
          end

          // Write ABSTIMERREG1 register.
          ABSTIMERREG1_ADDR_CT : begin
            int_absTimerValue1             <= regWriteData[31 : 0];
          end

          // Write ABSTIMERREG2 register.
          ABSTIMERREG2_ADDR_CT : begin
            int_absTimerValue2             <= regWriteData[31 : 0];
          end

          // Write ABSTIMERREG3 register.
          ABSTIMERREG3_ADDR_CT : begin
            int_absTimerValue3             <= regWriteData[31 : 0];
          end

          // Write ABSTIMERREG4 register.
          ABSTIMERREG4_ADDR_CT : begin
            int_absTimerValue4             <= regWriteData[31 : 0];
          end

          // Write ABSTIMERREG5 register.
          ABSTIMERREG5_ADDR_CT : begin
            int_absTimerValue5             <= regWriteData[31 : 0];
          end

          // Write ABSTIMERREG6 register.
          ABSTIMERREG6_ADDR_CT : begin
            int_absTimerValue6             <= regWriteData[31 : 0];
          end

          // Write ABSTIMERREG7 register.
          ABSTIMERREG7_ADDR_CT : begin
            int_absTimerValue7             <= regWriteData[31 : 0];
          end

          // Write ABSTIMERREG8 register.
          ABSTIMERREG8_ADDR_CT : begin
            int_absTimerValue8             <= regWriteData[31 : 0];
          end

          // Write ABSTIMERREG9 register.
          ABSTIMERREG9_ADDR_CT : begin
            int_absTimerValue9             <= regWriteData[31 : 0];
          end

          // Write MAXRXLENGTHREG register.
          MAXRXLENGTHREG_ADDR_CT : begin
            int_maxAllowedLength           <= regWriteData[19 : 0];
          end

          // Write EDCAAC0REG register.
          EDCAAC0REG_ADDR_CT : begin
            int_txOpLimit0                 <= regWriteData[27 : 12];
            int_cwMax0                     <= regWriteData[11 : 8];
            int_cwMin0                     <= regWriteData[7 : 4];
            int_aifsn0                     <= regWriteData[3 : 0];
          end

          // Write EDCAAC1REG register.
          EDCAAC1REG_ADDR_CT : begin
            int_txOpLimit1                 <= regWriteData[27 : 12];
            int_cwMax1                     <= regWriteData[11 : 8];
            int_cwMin1                     <= regWriteData[7 : 4];
            int_aifsn1                     <= regWriteData[3 : 0];
          end

          // Write EDCAAC2REG register.
          EDCAAC2REG_ADDR_CT : begin
            int_txOpLimit2                 <= regWriteData[27 : 12];
            int_cwMax2                     <= regWriteData[11 : 8];
            int_cwMin2                     <= regWriteData[7 : 4];
            int_aifsn2                     <= regWriteData[3 : 0];
          end

          // Write EDCAAC3REG register.
          EDCAAC3REG_ADDR_CT : begin
            int_txOpLimit3                 <= regWriteData[27 : 12];
            int_cwMax3                     <= regWriteData[11 : 8];
            int_cwMin3                     <= regWriteData[7 : 4];
            int_aifsn3                     <= regWriteData[3 : 0];
          end

          // Write EDCACCABUSYREG register.
          EDCACCABUSYREG_ADDR_CT : begin
            int_ccaBusyDur                 <= regWriteData[31 : 0];
          end

          // Write EDCACNTRLREG register.
          EDCACNTRLREG_ADDR_CT : begin
            int_keepTXOPOpen               <= regWriteData[5];
            int_remTXOPInDurField          <= regWriteData[4];
            int_sendCFEnd                  <= regWriteData[1];
            int_sendCFEndNow               <= regWriteData[0];
          end

          // Write QUIETELEMENT1AREG register.
          QUIETELEMENT1AREG_ADDR_CT : begin
            int_quietDuration1             <= regWriteData[31 : 16];
            int_quietPeriod1               <= regWriteData[15 : 8];
            int_quietCount1                <= regWriteData[7 : 0];
          end

          // Write QUIETELEMENT1BREG register.
          QUIETELEMENT1BREG_ADDR_CT : begin
            int_quietOffset1               <= regWriteData[15 : 0];
          end

          // Write ADDCCABUSYSEC20REG register.
          ADDCCABUSYSEC20REG_ADDR_CT : begin
            int_ccaBusyDurSec20            <= regWriteData[31 : 0];
          end

          // Write ADDCCABUSYSEC40REG register.
          ADDCCABUSYSEC40REG_ADDR_CT : begin
            int_ccaBusyDurSec40            <= regWriteData[31 : 0];
          end

          // Write ADDCCABUSYSEC80REG register.
          ADDCCABUSYSEC80REG_ADDR_CT : begin
            int_ccaBusyDurSec80            <= regWriteData[31 : 0];
          end

          // Write STBCCNTRLREG register.
          STBCCNTRLREG_ADDR_CT : begin
            int_basicSTBCMCS               <= regWriteData[31 : 25];
            int_dualCTSProt                <= regWriteData[24];
            int_ctsSTBCDur                 <= regWriteData[23 : 16];
            int_cfEndSTBCDur               <= regWriteData[15 : 0];
          end

          // Write TXBWCNTRLREG register.
          TXBWCNTRLREG_ADDR_CT : begin
            int_maxSupportedBW             <= regWriteData[17 : 16];
            int_aPPDUMaxTime               <= regWriteData[15 : 8];
            int_dynBWEn                    <= regWriteData[7];
            int_numTryBWAcquisition        <= regWriteData[6 : 4];
            int_dropToLowerBW              <= regWriteData[3];
            int_defaultBWTXOP              <= regWriteData[2 : 1];
            int_defaultBWTXOPV             <= regWriteData[0];
          end

          // Write HTMCSREG register.
          HTMCSREG_ADDR_CT : begin
            int_bssBasicHTMCSSetUM         <= regWriteData[21 : 16];
            int_bssBasicHTMCSSetEM         <= regWriteData[15 : 0];
          end

          // Write VHTMCSREG register.
          VHTMCSREG_ADDR_CT : begin
            int_bssBasicVHTMCSSet          <= regWriteData[15 : 0];
          end

          // Write LSTPREG register.
          LSTPREG_ADDR_CT : begin
            int_supportLSTP                <= regWriteData[0];
          end

          // Write HECONFIGREG register.
          HECONFIGREG_ADDR_CT : begin
            int_dcmSupport                 <= regWriteData[21];
            int_dopplerSupport             <= regWriteData[20];
            int_enableOBSSPD               <= regWriteData[17];
            int_enableSRP                  <= regWriteData[16];
            int_acceptAllTriggerFrames     <= regWriteData[10];
            int_acceptTriggerSWFrames      <= regWriteData[9];
            int_acceptTriggerHWFrames      <= regWriteData[8];
            int_disableTBUPH               <= regWriteData[7];
            int_disableTBRU26Resp          <= regWriteData[6];
            int_disableTBCS                <= regWriteData[5];
            int_disableTBResp              <= regWriteData[4];
            int_defaultPEDur               <= regWriteData[2 : 0];
          end

          // Write SPCONFIG1REG register.
          SPCONFIG1REG_ADDR_CT : begin
            int_srgOBSSPDMaxOffset         <= regWriteData[31 : 24];
            int_srgOBSSPDMinOffset         <= regWriteData[23 : 16];
            int_nonSRGOBSSPDMaxOffset      <= regWriteData[15 : 8];
            int_srgInformationPresent      <= regWriteData[3];
            int_nonSRGOffsetPresent        <= regWriteData[2];
            int_nonSRGOBSSPDSRDisallowed   <= regWriteData[1];
            int_SRPDisallowed              <= regWriteData[0];
          end

          // Write SRGBSSCOLORBITMAPLOWREG register.
          SRGBSSCOLORBITMAPLOWREG_ADDR_CT : begin
            int_SRGBSSColorBitmapLow       <= regWriteData[31 : 0];
          end

          // Write SRGBSSCOLORBITMAPHIGHREG register.
          SRGBSSCOLORBITMAPHIGHREG_ADDR_CT : begin
            int_SRGBSSColorBitmapHigh      <= regWriteData[31 : 0];
          end

          // Write SRGPARTIALBSSIDBITMAPLOWREG register.
          SRGPARTIALBSSIDBITMAPLOWREG_ADDR_CT : begin
            int_SRGPartialBSSIDBitmapLow   <= regWriteData[31 : 0];
          end

          // Write SRGPARTIALBSSIDBITMAPHIGHREG register.
          SRGPARTIALBSSIDBITMAPHIGHREG_ADDR_CT : begin
            int_SRGPartialBSSIDBitmapHigh  <= regWriteData[31 : 0];
          end
`ifdef RW_BFMEE_EN                          

          // Write BFMEECONTROLREG register.
          BFMEECONTROLREG_ADDR_CT : begin
            int_bfrHELTFType               <= regWriteData[31 : 30];
            int_bfrGIType                  <= regWriteData[29 : 28];
            int_bfrFormatMod               <= regWriteData[27 : 25];
            int_bfrShortGI                 <= regWriteData[24];
            int_bfrMCS                     <= regWriteData[23 : 16];
            int_bfmeeNc                    <= regWriteData[10 : 8];
            int_bfmeeNr                    <= regWriteData[7 : 5];
            int_bfmeeGrouping              <= regWriteData[4 : 3];
            int_bfmeeCodebook              <= regWriteData[2];
            int_bfmeeMUSupport             <= regWriteData[1];
            int_bfmeeEnable                <= regWriteData[0];
          end
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      

          // Write COEXCONTROLREG register.
          COEXCONTROLREG_ADDR_CT : begin
            int_coexForceWlanPTI           <= regWriteData[31 : 28];
            int_coexForceWlanPTIToggle     <= regWriteData[27];
            int_coexForceWlanChanBw        <= regWriteData[26];
            int_coexForceWlanRx            <= regWriteData[25];
            int_coexForceWlanTx            <= regWriteData[24];
            int_coexWlanChanFreq           <= regWriteData[22 : 16];
            int_coexWlanChanOffset         <= regWriteData[12];
            int_coexAutoPTIAdjIncr         <= regWriteData[7 : 6];
            int_coexAutoPTIAdjEnable       <= regWriteData[5];
            int_coexForceEnable            <= regWriteData[4];
            int_coexPostponeTxEnable       <= regWriteData[3];
            int_coexPHYRxAbortEnable       <= regWriteData[2];
            int_coexPHYTxAbortEnable       <= regWriteData[1];
            int_coexEnable                 <= regWriteData[0];
          end

          // Write COEXPTIREG register.
          COEXPTIREG_ADDR_CT : begin
            int_coexPTIBcnData             <= regWriteData[31 : 28];
            int_coexPTIBKData              <= regWriteData[27 : 24];
            int_coexPTIBEData              <= regWriteData[23 : 20];
            int_coexPTIVIData              <= regWriteData[19 : 16];
            int_coexPTIVOData              <= regWriteData[15 : 12];
            int_coexPTIMgt                 <= regWriteData[11 : 8];
            int_coexPTICntl                <= regWriteData[7 : 4];
            int_coexPTIAck                 <= regWriteData[3 : 0];
          end

          // Write COEXINTREG register.
          COEXINTREG_ADDR_CT : begin
            int_coexWlanRxAbortFallEn      <= regWriteData[3];
            int_coexWlanRxAbortRiseEn      <= regWriteData[2];
            int_coexWlanTxAbortFallEn      <= regWriteData[1];
            int_coexWlanTxAbortRiseEn      <= regWriteData[0];
          end
`endif // RW_WLAN_COEX_EN                      

          // Write DEBUGPORTSELREG register.
          DEBUGPORTSELREG_ADDR_CT : begin
            int_debugPortSel2              <= regWriteData[15 : 8];
            int_debugPortSel1              <= regWriteData[7 : 0];
          end

          // Write DEBUGBASICNAVREG register.
          DEBUGBASICNAVREG_ADDR_CT : begin
            int_basicNAVCounter            <= regWriteData[25 : 0];
          end

          // Write DEBUGCWREG register.
          DEBUGCWREG_ADDR_CT : begin
            int_backoffOffset              <= regWriteData[25 : 24];
          end

          // Write DEBUGUORAREG register.
          DEBUGUORAREG_ADDR_CT : begin
            int_ocwLFSR                    <= regWriteData[6 : 0];
          end

          // Write DEBUGPHYREG register.
          DEBUGPHYREG_ADDR_CT : begin
            int_rxEndForTimingErrRec       <= regWriteData[1];
            int_rxReqForceDeassertion      <= regWriteData[0];
          end

          // Write DEBUGINTRANAVREG register.
          DEBUGINTRANAVREG_ADDR_CT : begin
            int_intraNAVCounter            <= regWriteData[15 : 0];
          end

          
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : begin
          end
          // pragma coverage block = on 

        endcase
      end
      else begin
        int_errInHWLevel3              <= 1'b0;
        int_errInTxRxLevel2            <= 1'b0;
        int_errInRxLevel1              <= 1'b0;
        int_errInTxLevel1              <= 1'b0;
        int_clearErrInHWLevel3         <= 1'b0;
        int_clearErrInTxRxLevel2       <= 1'b0;
        int_clearErrInRxLevel1         <= 1'b0;
        int_clearErrInTxLevel1         <= 1'b0;
`ifdef RW_KEY_EXTENDED                      
`endif // RW_KEY_EXTENDED                      
`ifdef RW_BFMEE_EN                          
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      
`endif // RW_WLAN_COEX_EN                      
      end
    end
  end
        
  //////////////////////////////////////////////////////////////////////////////
  // Registers read
  //////////////////////////////////////////////////////////////////////////////
  //Read_p: 
  
  always @*
  begin

    regReadData = `RW_REG_DATA_WIDTH'b0;
    // Test only psel to detect first cycle of the two-cycles APB read access.
    if (regSel && regRead)
    begin

      case (regAddr)

        // Read SIGNATUREREG register.
        SIGNATUREREG_ADDR_CT : begin
          regReadData[31 : 0]        = signature;
        end

        // Read VERSION1REG register.
        VERSION1REG_ADDR_CT : begin
          regReadData[19]            = muMIMOTx;
          regReadData[18]            = bfmer;
          regReadData[17]            = bfmee;
          regReadData[15]            = he;
          regReadData[14]            = coex;
          regReadData[13]            = wapi;
          regReadData[12]            = tpc;
          regReadData[11]            = vht;
          regReadData[10]            = ht;
          regReadData[9]             = gcmp;
          regReadData[8]             = rce;
          regReadData[7]             = ccmp;
          regReadData[6]             = tkip;
          regReadData[5]             = wep;
          regReadData[4]             = security;
          regReadData[3]             = sme;
          regReadData[1]             = edca;
          regReadData[0]             = qos;
        end

        // Read VERSION2REG register.
        VERSION2REG_ADDR_CT : begin
          regReadData[16 : 14]       = phaseNumber;
          regReadData[13 : 8]        = releaseNumber;
          regReadData[7]             = ieRelease;
          regReadData[6 : 0]         = umVersion;
        end

        // Read BITMAPCNTREG register.
        BITMAPCNTREG_ADDR_CT : begin
          regReadData[15 : 0]        = bitmapCnt;
        end

        // Read MACADDRLOWREG register.
        MACADDRLOWREG_ADDR_CT : begin
          regReadData[31 : 0]        = macAddrLow;
        end

        // Read MACADDRHIREG register.
        MACADDRHIREG_ADDR_CT : begin
          regReadData[15 : 0]        = macAddrHigh;
        end

        // Read MACADDRLOWMASKREG register.
        MACADDRLOWMASKREG_ADDR_CT : begin
          regReadData[31 : 0]        = macAddrLowMask;
        end

        // Read MACADDRHIMASKREG register.
        MACADDRHIMASKREG_ADDR_CT : begin
          regReadData[15 : 0]        = macAddrHighMask;
        end

        // Read BSSIDLOWREG register.
        BSSIDLOWREG_ADDR_CT : begin
          regReadData[31 : 0]        = bssIDLow;
        end

        // Read BSSIDHIREG register.
        BSSIDHIREG_ADDR_CT : begin
          regReadData[15 : 0]        = bssIDHigh;
        end

        // Read BSSIDLOWMASKREG register.
        BSSIDLOWMASKREG_ADDR_CT : begin
          regReadData[31 : 0]        = bssIDLowMask;
        end

        // Read BSSIDHIMASKREG register.
        BSSIDHIMASKREG_ADDR_CT : begin
          regReadData[15 : 0]        = bssIDHighMask;
        end

        // Read BSSCOLORREG register.
        BSSCOLORREG_ADDR_CT : begin
          regReadData[9]             = partialBSSColorEn;
          regReadData[8]             = bssColorEn;
          regReadData[5 : 0]         = bssColor;
        end

        // Read STATECNTRLREG register.
        STATECNTRLREG_ADDR_CT : begin
          regReadData[7 : 4]         = nextState;
          regReadData[3 : 0]         = currentState;
        end

        // Read SCANCNTRLREG register.
        SCANCNTRLREG_ADDR_CT : begin
          regReadData[22 : 20]       = primaryChPosition;
          regReadData[15 : 0]        = probeDelay;
        end

        // Read DOZECNTRL1REG register.
        DOZECNTRL1REG_ADDR_CT : begin
          regReadData[16]            = wakeupDTIM;
          regReadData[15 : 0]        = listenInterval;
        end

        // Read MACCNTRL1REG register.
        MACCNTRL1REG_ADDR_CT : begin
          regReadData[26]            = rxRIFSEn;
          regReadData[25]            = tsfMgtDisable;
          regReadData[24]            = tsfUpdatedBySW;
          regReadData[19]            = disableSVDRxPause;
          regReadData[18]            = disableBQRResp;
          regReadData[16 : 14]       = abgnMode;
          regReadData[13]            = keyStoRAMReset;
          regReadData[12]            = mibTableReset;
          regReadData[11]            = rateControllerMPIF;
          regReadData[10]            = disableBAResp;
          regReadData[9]             = disableCTSResp;
          regReadData[8]             = disableACKResp;
          regReadData[7]             = activeClkGating;
          regReadData[6]             = enableLPClkSwitch;
          regReadData[5]             = lpClk32786Hz;
          regReadData[2]             = pwrMgt;
          regReadData[1]             = ap;
          regReadData[0]             = bssType;
        end

        // Read MACERRRECCNTRLREG register.
        MACERRRECCNTRLREG_ADDR_CT : begin
          regReadData[16]            = rxFlowCntrlEn;
          regReadData[7]             = baPSBitmapReset;
          regReadData[5]             = macPHYIFFIFOReset;
          regReadData[4]             = txFIFOReset;
          regReadData[3]             = rxFIFOReset;
          regReadData[2]             = hwFSMReset;
          regReadData[1]             = useErrDet;
          regReadData[0]             = useErrRec;
        end

        // Read MACERRSETSTATUSREG register.
        MACERRSETSTATUSREG_ADDR_CT : begin
          regReadData[3]             = statuserrInHWLevel3;
          regReadData[2]             = statuserrInTxRxLevel2;
          regReadData[1]             = statuserrInRxLevel1;
          regReadData[0]             = statuserrInTxLevel1;
        end

        // Read MACERRCLEARSTATUSREG register.
        MACERRCLEARSTATUSREG_ADDR_CT : begin
          regReadData[3]             = clearErrInHWLevel3;
          regReadData[2]             = clearErrInTxRxLevel2;
          regReadData[1]             = clearErrInRxLevel1;
          regReadData[0]             = clearErrInTxLevel1;
        end

        // Read RXCNTRLREG register.
        RXCNTRLREG_ADDR_CT : begin
          regReadData[31]            = enDuplicateDetection;
          regReadData[30]            = acceptUnknown;
          regReadData[29]            = acceptOtherDataFrames;
          regReadData[28]            = acceptQoSNull;
          regReadData[27]            = acceptQCFWOData;
          regReadData[26]            = acceptQData;
          regReadData[25]            = acceptCFWOData;
          regReadData[24]            = acceptData;
          regReadData[23]            = acceptOtherCntrlFrames;
          regReadData[22]            = acceptCFEnd;
          regReadData[21]            = acceptACK;
          regReadData[20]            = acceptCTS;
          regReadData[19]            = acceptRTS;
          regReadData[18]            = acceptPSPoll;
          regReadData[17]            = acceptBA;
          regReadData[16]            = acceptBAR;
          regReadData[15]            = acceptOtherMgmtFrames;
          regReadData[14]            = acceptBfmeeFrames;
          regReadData[13]            = acceptAllBeacon;
          regReadData[12]            = acceptNotExpectedBA;
          regReadData[11]            = acceptDecryptErrorFrames;
          regReadData[10]            = acceptBeacon;
          regReadData[9]             = acceptProbeResp;
          regReadData[8]             = acceptProbeReq;
          regReadData[7]             = acceptMyUnicast;
          regReadData[6]             = acceptUnicast;
          regReadData[5]             = acceptErrorFrames;
          regReadData[4]             = acceptOtherBSSID;
          regReadData[3]             = acceptBroadcast;
          regReadData[2]             = acceptMulticast;
          regReadData[1]             = dontDecrypt;
          regReadData[0]             = excUnencrypted;
        end

        // Read BCNCNTRL1REG register.
        BCNCNTRL1REG_ADDR_CT : begin
          regReadData[31 : 24]       = noBcnTxTime;
          regReadData[23]            = impTBTTIn128Us;
          regReadData[22 : 16]       = impTBTTPeriod;
          regReadData[15 : 0]        = beaconInt;
        end

        // Read BCNCNTRL2REG register.
        BCNCNTRL2REG_ADDR_CT : begin
          regReadData[31 : 16]       = aid;
          regReadData[15 : 8]        = timOffset;
          regReadData[7 : 0]         = bcnUpdateOffset;
        end

        // Read DTIM1REG register.
        DTIM1REG_ADDR_CT : begin
          regReadData[31]            = dtimUpdatedBySW;
          regReadData[7 : 0]         = dtimPeriod;
        end

        // Read RETRYLIMITSREG register.
        RETRYLIMITSREG_ADDR_CT : begin
          regReadData[15 : 8]        = dot11LongRetryLimit;
          regReadData[7 : 0]         = dot11ShortRetryLimit;
        end

        // Read BBSERVICEREG register.
        BBSERVICEREG_ADDR_CT : begin
          regReadData[28 : 26]       = maxPHYNtx;
          regReadData[23 : 16]       = bbServiceB;
          regReadData[15 : 0]        = bbServiceA;
        end

        // Read MAXPOWERLEVELREG register.
        MAXPOWERLEVELREG_ADDR_CT : begin
          regReadData[23 : 16]       = ofdmMinPwrLevel;
          regReadData[15 : 8]        = dsssMaxPwrLevel;
          regReadData[7 : 0]         = ofdmMaxPwrLevel;
        end

        // Read ENCRKEY0REG register.
        ENCRKEY0REG_ADDR_CT : begin
          regReadData[31 : 0]        = encrKeyRAMWord0;
        end

        // Read ENCRKEY1REG register.
        ENCRKEY1REG_ADDR_CT : begin
          regReadData[31 : 0]        = encrKeyRAMWord1;
        end

        // Read ENCRKEY2REG register.
        ENCRKEY2REG_ADDR_CT : begin
          regReadData[31 : 0]        = encrKeyRAMWord2;
        end

        // Read ENCRKEY3REG register.
        ENCRKEY3REG_ADDR_CT : begin
          regReadData[31 : 0]        = encrKeyRAMWord3;
        end

        // Read ENCRMACADDRLOWREG register.
        ENCRMACADDRLOWREG_ADDR_CT : begin
          regReadData[31 : 0]        = macAddrRAMLow;
        end

        // Read ENCRMACADDRHIGHREG register.
        ENCRMACADDRHIGHREG_ADDR_CT : begin
          regReadData[15 : 0]        = macAddrRAMHigh;
        end

        // Read ENCRCNTRLREG register.
        ENCRCNTRLREG_ADDR_CT : begin
          regReadData[31]            = newRead;
          regReadData[30]            = newWrite;
          regReadData[29]            = newSearch;
          regReadData[28]            = searchError;
          regReadData[25 : 16]       = keyIndexRAM;
          regReadData[13 : 12]       = cLenRAM;
          regReadData[10 : 8]        = cTypeRAM;
          regReadData[7 : 4]         = vlanIDRAM;
          regReadData[3 : 2]         = sppRAM;
          regReadData[1]             = useDefKeyRAM;
        end
`ifdef RW_KEY_EXTENDED                      

        // Read ENCRWPIINTKEY0REG register.
        ENCRWPIINTKEY0REG_ADDR_CT : begin
          regReadData[31 : 0]        = encrIntKeyRAMWord0;
        end

        // Read ENCRWPIINTKEY1REG register.
        ENCRWPIINTKEY1REG_ADDR_CT : begin
          regReadData[31 : 0]        = encrIntKeyRAMWord1;
        end

        // Read ENCRWPIINTKEY2REG register.
        ENCRWPIINTKEY2REG_ADDR_CT : begin
          regReadData[31 : 0]        = encrIntKeyRAMWord2;
        end

        // Read ENCRWPIINTKEY3REG register.
        ENCRWPIINTKEY3REG_ADDR_CT : begin
          regReadData[31 : 0]        = encrIntKeyRAMWord3;
        end
`endif // RW_KEY_EXTENDED                      

        // Read ENCRRAMCONFIGREG register.
        ENCRRAMCONFIGREG_ADDR_CT : begin
          regReadData[31 : 24]       = staKeyMaxIndex;
          regReadData[19 : 16]       = nVAP;
          regReadData[15 : 8]        = staKeyEndIndex;
          regReadData[7 : 0]         = staKeyStartIndex;
        end

        // Read RATESREG register.
        RATESREG_ADDR_CT : begin
          regReadData[11 : 0]        = bssBasicRateSet;
        end

        // Read OLBCREG register.
        OLBCREG_ADDR_CT : begin
          regReadData[31 : 24]       = dsssCount;
          regReadData[23 : 16]       = ofdmCount;
          regReadData[15 : 0]        = olbcTimer;
        end

        // Read TIMINGS1REG register.
        TIMINGS1REG_ADDR_CT : begin
          regReadData[27 : 18]       = txChainDelayInMACClk;
          regReadData[17 : 8]        = txRFDelayInMACClk;
          regReadData[7 : 0]         = macCoreClkFreq;
        end

        // Read TIMINGS2REG register.
        TIMINGS2REG_ADDR_CT : begin
          regReadData[23 : 8]        = slotTimeInMACClk;
          regReadData[7 : 0]         = slotTime;
        end

        // Read TIMINGS3REG register.
        TIMINGS3REG_ADDR_CT : begin
          regReadData[29 : 20]       = rxRFDelayInMACClk;
          regReadData[9 : 0]         = macProcDelayInMACClk;
        end

        // Read TIMINGS4REG register.
        TIMINGS4REG_ADDR_CT : begin
          regReadData[31 : 22]       = radioWakeUpTime;
          regReadData[21 : 12]       = radioChirpTime;
          regReadData[1 : 0]         = wt2CryptClkRatio;
        end

        // Read TIMINGS5REG register.
        TIMINGS5REG_ADDR_CT : begin
          regReadData[23 : 8]        = sifsBInMACClk;
          regReadData[7 : 0]         = sifsB;
        end

        // Read TIMINGS6REG register.
        TIMINGS6REG_ADDR_CT : begin
          regReadData[23 : 8]        = sifsAInMACClk;
          regReadData[7 : 0]         = sifsA;
        end

        // Read TIMINGS7REG register.
        TIMINGS7REG_ADDR_CT : begin
          regReadData[11 : 8]        = rxCCADelay;
        end

        // Read TIMINGS8REG register.
        TIMINGS8REG_ADDR_CT : begin
          regReadData[31 : 24]       = rxStartDelayMIMO;
          regReadData[23 : 16]       = rxStartDelayShort;
          regReadData[15 : 8]        = rxStartDelayLong;
          regReadData[7 : 0]         = rxStartDelayOFDM;
        end

        // Read TIMINGS9REG register.
        TIMINGS9REG_ADDR_CT : begin
          regReadData[29 : 20]       = rifsTOInMACClk;
          regReadData[9 : 0]         = txDMAProcDlyInMACClk;
        end

        // Read RXCNTRL2 register.
        RXCNTRL2_ADDR_CT : begin
          regReadData[19]            = disableRxBuffer2;
          regReadData[18]            = dataMHStoredwithPld;
          regReadData[17]            = mgtMHStoredwithPld;
          regReadData[16]            = ctrlMHStoredwithPld;
          regReadData[15 : 8]        = partialUnwrapSize;
          regReadData[5 : 4]         = dataFrmWrapMode;
          regReadData[3 : 2]         = mgtFrmWrapMode;
          regReadData[1 : 0]         = ctrlFrmWrapMode;
        end

        // Read TXTRIGGERTIMERREG register.
        TXTRIGGERTIMERREG_ADDR_CT : begin
          regReadData[15 : 8]        = txPacketTimeout;
          regReadData[7 : 0]         = txAbsoluteTimeout;
        end

        // Read RXTRIGGERTIMERREG register.
        RXTRIGGERTIMERREG_ADDR_CT : begin
          regReadData[15 : 8]        = rxPacketTimeout;
          regReadData[7 : 0]         = rxAbsoluteTimeout;
        end

        // Read MIBTABLEWRITEREG register.
        MIBTABLEWRITEREG_ADDR_CT : begin
          regReadData[31 : 16]       = mibValue;
          regReadData[15]            = mibWrite;
          regReadData[14]            = mibIncrementMode;
          regReadData[9 : 0]         = mibTableIndex;
        end

        // Read MONOTONICCOUNTER1REG register.
        MONOTONICCOUNTER1REG_ADDR_CT : begin
          regReadData[31 : 0]        = monotonicCounter1;
        end

        // Read MONOTONICCOUNTER2LOREG register.
        MONOTONICCOUNTER2LOREG_ADDR_CT : begin
          regReadData[31 : 0]        = monotonicCounterLow2;
        end

        // Read MONOTONICCOUNTER2HIREG register.
        MONOTONICCOUNTER2HIREG_ADDR_CT : begin
          regReadData[31]            = monotonicCounter2SWUpdate;
          regReadData[15 : 0]        = monotonicCounterHigh2;
        end

        // Read ABSTIMERREG0 register.
        ABSTIMERREG0_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue0;
        end

        // Read ABSTIMERREG1 register.
        ABSTIMERREG1_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue1;
        end

        // Read ABSTIMERREG2 register.
        ABSTIMERREG2_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue2;
        end

        // Read ABSTIMERREG3 register.
        ABSTIMERREG3_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue3;
        end

        // Read ABSTIMERREG4 register.
        ABSTIMERREG4_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue4;
        end

        // Read ABSTIMERREG5 register.
        ABSTIMERREG5_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue5;
        end

        // Read ABSTIMERREG6 register.
        ABSTIMERREG6_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue6;
        end

        // Read ABSTIMERREG7 register.
        ABSTIMERREG7_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue7;
        end

        // Read ABSTIMERREG8 register.
        ABSTIMERREG8_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue8;
        end

        // Read ABSTIMERREG9 register.
        ABSTIMERREG9_ADDR_CT : begin
          regReadData[31 : 0]        = absTimerValue9;
        end

        // Read MAXRXLENGTHREG register.
        MAXRXLENGTHREG_ADDR_CT : begin
          regReadData[19 : 0]        = maxAllowedLength;
        end

        // Read EDCAAC0REG register.
        EDCAAC0REG_ADDR_CT : begin
          regReadData[27 : 12]       = txOpLimit0;
          regReadData[11 : 8]        = cwMax0;
          regReadData[7 : 4]         = cwMin0;
          regReadData[3 : 0]         = aifsn0;
        end

        // Read EDCAAC1REG register.
        EDCAAC1REG_ADDR_CT : begin
          regReadData[27 : 12]       = txOpLimit1;
          regReadData[11 : 8]        = cwMax1;
          regReadData[7 : 4]         = cwMin1;
          regReadData[3 : 0]         = aifsn1;
        end

        // Read EDCAAC2REG register.
        EDCAAC2REG_ADDR_CT : begin
          regReadData[27 : 12]       = txOpLimit2;
          regReadData[11 : 8]        = cwMax2;
          regReadData[7 : 4]         = cwMin2;
          regReadData[3 : 0]         = aifsn2;
        end

        // Read EDCAAC3REG register.
        EDCAAC3REG_ADDR_CT : begin
          regReadData[27 : 12]       = txOpLimit3;
          regReadData[11 : 8]        = cwMax3;
          regReadData[7 : 4]         = cwMin3;
          regReadData[3 : 0]         = aifsn3;
        end

        // Read EDCACCABUSYREG register.
        EDCACCABUSYREG_ADDR_CT : begin
          regReadData[31 : 0]        = ccaBusyDur;
        end

        // Read EDCACNTRLREG register.
        EDCACNTRLREG_ADDR_CT : begin
          regReadData[5]             = keepTXOPOpen;
          regReadData[4]             = remTXOPInDurField;
          regReadData[1]             = sendCFEnd;
          regReadData[0]             = sendCFEndNow;
        end

        // Read QUIETELEMENT1AREG register.
        QUIETELEMENT1AREG_ADDR_CT : begin
          regReadData[31 : 16]       = quietDuration1;
          regReadData[15 : 8]        = quietPeriod1;
          regReadData[7 : 0]         = quietCount1;
        end

        // Read QUIETELEMENT1BREG register.
        QUIETELEMENT1BREG_ADDR_CT : begin
          regReadData[15 : 0]        = quietOffset1;
        end

        // Read ADDCCABUSYSEC20REG register.
        ADDCCABUSYSEC20REG_ADDR_CT : begin
          regReadData[31 : 0]        = ccaBusyDurSec20;
        end

        // Read ADDCCABUSYSEC40REG register.
        ADDCCABUSYSEC40REG_ADDR_CT : begin
          regReadData[31 : 0]        = ccaBusyDurSec40;
        end

        // Read ADDCCABUSYSEC80REG register.
        ADDCCABUSYSEC80REG_ADDR_CT : begin
          regReadData[31 : 0]        = ccaBusyDurSec80;
        end

        // Read STBCCNTRLREG register.
        STBCCNTRLREG_ADDR_CT : begin
          regReadData[31 : 25]       = basicSTBCMCS;
          regReadData[24]            = dualCTSProt;
          regReadData[23 : 16]       = ctsSTBCDur;
          regReadData[15 : 0]        = cfEndSTBCDur;
        end

        // Read TXBWCNTRLREG register.
        TXBWCNTRLREG_ADDR_CT : begin
          regReadData[17 : 16]       = maxSupportedBW;
          regReadData[15 : 8]        = aPPDUMaxTime;
          regReadData[7]             = dynBWEn;
          regReadData[6 : 4]         = numTryBWAcquisition;
          regReadData[3]             = dropToLowerBW;
          regReadData[2 : 1]         = defaultBWTXOP;
          regReadData[0]             = defaultBWTXOPV;
        end

        // Read HTMCSREG register.
        HTMCSREG_ADDR_CT : begin
          regReadData[21 : 16]       = bssBasicHTMCSSetUM;
          regReadData[15 : 0]        = bssBasicHTMCSSetEM;
        end

        // Read VHTMCSREG register.
        VHTMCSREG_ADDR_CT : begin
          regReadData[15 : 0]        = bssBasicVHTMCSSet;
        end

        // Read LSTPREG register.
        LSTPREG_ADDR_CT : begin
          regReadData[0]             = supportLSTP;
        end

        // Read HECONFIGREG register.
        HECONFIGREG_ADDR_CT : begin
          regReadData[21]            = dcmSupport;
          regReadData[20]            = dopplerSupport;
          regReadData[17]            = enableOBSSPD;
          regReadData[16]            = enableSRP;
          regReadData[10]            = acceptAllTriggerFrames;
          regReadData[9]             = acceptTriggerSWFrames;
          regReadData[8]             = acceptTriggerHWFrames;
          regReadData[7]             = disableTBUPH;
          regReadData[6]             = disableTBRU26Resp;
          regReadData[5]             = disableTBCS;
          regReadData[4]             = disableTBResp;
          regReadData[2 : 0]         = defaultPEDur;
        end

        // Read SPCONFIG1REG register.
        SPCONFIG1REG_ADDR_CT : begin
          regReadData[31 : 24]       = srgOBSSPDMaxOffset;
          regReadData[23 : 16]       = srgOBSSPDMinOffset;
          regReadData[15 : 8]        = nonSRGOBSSPDMaxOffset;
          regReadData[3]             = srgInformationPresent;
          regReadData[2]             = nonSRGOffsetPresent;
          regReadData[1]             = nonSRGOBSSPDSRDisallowed;
          regReadData[0]             = SRPDisallowed;
        end

        // Read SRGBSSCOLORBITMAPLOWREG register.
        SRGBSSCOLORBITMAPLOWREG_ADDR_CT : begin
          regReadData[31 : 0]        = SRGBSSColorBitmapLow;
        end

        // Read SRGBSSCOLORBITMAPHIGHREG register.
        SRGBSSCOLORBITMAPHIGHREG_ADDR_CT : begin
          regReadData[31 : 0]        = SRGBSSColorBitmapHigh;
        end

        // Read SRGPARTIALBSSIDBITMAPLOWREG register.
        SRGPARTIALBSSIDBITMAPLOWREG_ADDR_CT : begin
          regReadData[31 : 0]        = SRGPartialBSSIDBitmapLow;
        end

        // Read SRGPARTIALBSSIDBITMAPHIGHREG register.
        SRGPARTIALBSSIDBITMAPHIGHREG_ADDR_CT : begin
          regReadData[31 : 0]        = SRGPartialBSSIDBitmapHigh;
        end
`ifdef RW_BFMEE_EN                          

        // Read BFMEECONTROLREG register.
        BFMEECONTROLREG_ADDR_CT : begin
          regReadData[31 : 30]       = bfrHELTFType;
          regReadData[29 : 28]       = bfrGIType;
          regReadData[27 : 25]       = bfrFormatMod;
          regReadData[24]            = bfrShortGI;
          regReadData[23 : 16]       = bfrMCS;
          regReadData[10 : 8]        = bfmeeNc;
          regReadData[7 : 5]         = bfmeeNr;
          regReadData[4 : 3]         = bfmeeGrouping;
          regReadData[2]             = bfmeeCodebook;
          regReadData[1]             = bfmeeMUSupport;
          regReadData[0]             = bfmeeEnable;
        end
`endif // RW_BFMEE_EN                          
`ifdef RW_WLAN_COEX_EN                      

        // Read COEXCONTROLREG register.
        COEXCONTROLREG_ADDR_CT : begin
          regReadData[31 : 28]       = coexForceWlanPTI;
          regReadData[27]            = coexForceWlanPTIToggle;
          regReadData[26]            = coexForceWlanChanBw;
          regReadData[25]            = coexForceWlanRx;
          regReadData[24]            = coexForceWlanTx;
          regReadData[22 : 16]       = coexWlanChanFreq;
          regReadData[12]            = coexWlanChanOffset;
          regReadData[7 : 6]         = coexAutoPTIAdjIncr;
          regReadData[5]             = coexAutoPTIAdjEnable;
          regReadData[4]             = coexForceEnable;
          regReadData[3]             = coexPostponeTxEnable;
          regReadData[2]             = coexPHYRxAbortEnable;
          regReadData[1]             = coexPHYTxAbortEnable;
          regReadData[0]             = coexEnable;
        end

        // Read COEXPTIREG register.
        COEXPTIREG_ADDR_CT : begin
          regReadData[31 : 28]       = coexPTIBcnData;
          regReadData[27 : 24]       = coexPTIBKData;
          regReadData[23 : 20]       = coexPTIBEData;
          regReadData[19 : 16]       = coexPTIVIData;
          regReadData[15 : 12]       = coexPTIVOData;
          regReadData[11 : 8]        = coexPTIMgt;
          regReadData[7 : 4]         = coexPTICntl;
          regReadData[3 : 0]         = coexPTIAck;
        end

        // Read COEXSTATREG register.
        COEXSTATREG_ADDR_CT : begin
          regReadData[11 : 8]        = coexWlanPTIState;
          regReadData[5]             = coexWlanPTIToggleState;
          regReadData[4]             = coexWlanChanBwState;
          regReadData[3]             = coexWlanRxState;
          regReadData[2]             = coexWlanTxState;
          regReadData[1]             = coexWlanRxAbortState;
          regReadData[0]             = coexWlanTxAbortState;
        end

        // Read COEXINTREG register.
        COEXINTREG_ADDR_CT : begin
          regReadData[3]             = coexWlanRxAbortFallEn;
          regReadData[2]             = coexWlanRxAbortRiseEn;
          regReadData[1]             = coexWlanTxAbortFallEn;
          regReadData[0]             = coexWlanTxAbortRiseEn;
        end
`endif // RW_WLAN_COEX_EN                      

        // Read DEBUGHWSM1REG register.
        DEBUGHWSM1REG_ADDR_CT : begin
          regReadData[31 : 24]       = macControlLs;
          regReadData[16 : 8]        = txControlLs;
          regReadData[5 : 0]         = rxControlLs;
        end

        // Read DEBUGHWSM2REG register.
        DEBUGHWSM2REG_ADDR_CT : begin
          regReadData[31 : 24]       = macControlCs;
          regReadData[16 : 8]        = txControlCs;
          regReadData[5 : 0]         = rxControlCs;
        end

        // Read DEBUGPORTVALUEREG register.
        DEBUGPORTVALUEREG_ADDR_CT : begin
          regReadData[31 : 0]        = debugPortRead;
        end

        // Read DEBUGPORTSELREG register.
        DEBUGPORTSELREG_ADDR_CT : begin
          regReadData[15 : 8]        = debugPortSel2;
          regReadData[7 : 0]         = debugPortSel1;
        end

        // Read DEBUGBASICNAVREG register.
        DEBUGBASICNAVREG_ADDR_CT : begin
          regReadData[25 : 0]        = basicNAVCounter;
        end

        // Read DEBUGCWREG register.
        DEBUGCWREG_ADDR_CT : begin
          regReadData[25 : 24]       = backoffOffset;
          regReadData[18 : 16]       = activeAC;
          regReadData[15 : 12]       = currentCW3;
          regReadData[11 : 8]        = currentCW2;
          regReadData[7 : 4]         = currentCW1;
          regReadData[3 : 0]         = currentCW0;
        end

        // Read DEBUGQSRCREG register.
        DEBUGQSRCREG_ADDR_CT : begin
          regReadData[31 : 24]       = ac3QSRC;
          regReadData[23 : 16]       = ac2QSRC;
          regReadData[15 : 8]        = ac1QSRC;
          regReadData[7 : 0]         = ac0QSRC;
        end

        // Read DEBUGQLRCREG register.
        DEBUGQLRCREG_ADDR_CT : begin
          regReadData[31 : 24]       = ac3QLRC;
          regReadData[23 : 16]       = ac2QLRC;
          regReadData[15 : 8]        = ac1QLRC;
          regReadData[7 : 0]         = ac0QLRC;
        end

        // Read DEBUGUORAREG register.
        DEBUGUORAREG_ADDR_CT : begin
          regReadData[6 : 0]         = ocwLFSR;
        end

        // Read DEBUGPHYREG register.
        DEBUGPHYREG_ADDR_CT : begin
          regReadData[1]             = rxEndForTimingErrRec;
          regReadData[0]             = rxReqForceDeassertion;
        end

        // Read DEBUGINTRANAVREG register.
        DEBUGINTRANAVREG_ADDR_CT : begin
          regReadData[15 : 0]        = intraNAVCounter;
        end

        // Disable coverage on the default state because it cannot be reached.
        // pragma coverage block = off 
        default : regReadData = `RW_REG_DATA_WIDTH'b0;
        // pragma coverage block = on 

      endcase
    
    end
    else
      regReadData = `RW_REG_DATA_WIDTH'b0;
    
  end 
  
  
endmodule

////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

