//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthournout $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 33818 $
// $Date: 2018-04-19 15:05:29 +0200 (Thu, 19 Apr 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : Platform register
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module macPlReg (
    ////////////////////////////////////////////
    //$port_g clock and reset
    ////////////////////////////////////////////
    input wire          hardRstClk_n     , // Hard Reset.
    input wire          softRstClk_n     , // Soft Reset.
    input wire          Clk              , // clock clock.

    ////////////////////////////////////////////
    //$port_g Registers
    ////////////////////////////////////////////

    //$port_g NEXTTBTTREG register.
    input wire [15 : 0] nextTBTT                       , // Next TBTT

    //$port_g GENINTEVENTSETREG register.

    //$port_g GENINTEVENTSETREG register.
    input wire          statussettbTxDMADead           , // TB Transmit DMA Dead
    input wire          statussetrxPayloadDMADead      , // Receive Payload DMA Dead
    input wire          statussetrxHeaderDMADead       , // Receive Payload DMA Dead
    input wire          statussetphyRxStart            , // PHY Receive Start indication
    input wire          statussetphyErr                , // PHY Error
    input wire          statussetmacPHYIFUnderRun      , // MAC PHY InterFace Under Run
    input wire          statussethwErr                 , // Hardware Error
    input wire          statussetimpSecDTIM            , // Impending Secondary DTIM
    input wire          statussetimpPriDTIM            , // Impending Primary DTIM
    input wire          statussetbcnTxDMADead          , // Beacon Transmit DMA Dead
    input wire          statussetac3TxDMADead          , // AC3 Transmit DMA Dead
    input wire          statussetac2TxDMADead          , // AC2 Transmit DMA Dead
    input wire          statussetac1TxDMADead          , // AC1 Transmit DMA Dead
    input wire          statussetac0TxDMADead          , // AC0 Transmit DMA Dead
    input wire          statussetptError               , // Policy Table Error
    input wire          statussettimSet                , // TIM Set
    input wire          statussetolbcDSSS              , // DSSS OLBC
    input wire          statussetolbcOFDM              , // OFDM OLBC
    input wire          statussetrxFIFOOverFlow        , // Receive FIFO Over Flow
    input wire          statussetmacPHYIFOverflow      , // MAC PHY InterFace Over Flow
    input wire          statussetcoexEvent             , // Coex Interface Event
    input wire          statusabsGenTimers             , // Absolute General Timer Interrupt
    input wire          statussetidleInterrupt         , // Idle Interrupt
    input wire          statussetimpSecTBTT            , // Impending Secondary Target Beacon Transmission Time
    input wire          statussetimpPriTBTT            , // Impending Primary Target Beacon Transmission Time

    //$port_g TXRXINTEVENTSETREG register.

    //$port_g TXRXINTEVENTSETREG register.
    input wire          statussettbTxBufTrigger        , // TB Transmission Buffer Trigger
    input wire          statussetbcnTxBufTrigger       , // Beacon Transmission Buffer Trigger
    input wire          statussetac3TxBufTrigger       , // AC3 Transmission Buffer Trigger
    input wire          statussetac2TxBufTrigger       , // AC2 Transmission Buffer Trigger
    input wire          statussetac1TxBufTrigger       , // AC1 Transmission Buffer Trigger
    input wire          statussetac0TxBufTrigger       , // AC0 Transmission Buffer Trigger
    input wire          statussetac3BWDropTrigger      , // AC3 Bandwith Drop Trigger
    input wire          statussetac2BWDropTrigger      , // AC2 Bandwith Drop Trigger
    input wire          statussetac1BWDropTrigger      , // AC1 Bandwith Drop Trigger
    input wire          statussetac0BWDropTrigger      , // AC0 Bandwith Drop Trigger
    input wire          statussetrxBuffer2Trigger      , // Receive Buffer 2 Trigger
    input wire          statussettimerRxTrigger        , // Timer Receive Trigger
    input wire          statussetrxBuffer1Trigger      , // Receive Buffer 1 Trigger
    input wire          statussetsecUserTxTrigger      , // Secondary User Transmission Trigger
    input wire          statussettimerTxTrigger        , // Timer Transmission Trigger
    input wire          statussettxopComplete          , // TXOP Complete
    input wire          statussettbTxCancelled         , // TB Transmission Cancelled
    input wire          statussettbTxTrigger           , // TB Transmission Trigger
    input wire          statussetbcnTxTrigger          , // Beacon Transmission Trigger
    input wire          statussetac3TxTrigger          , // AC3 Transmission Trigger
    input wire          statussetac2TxTrigger          , // AC2 Transmission Trigger
    input wire          statussetac1TxTrigger          , // AC1 Transmission Trigger
    input wire          statussetac0TxTrigger          , // AC0 Transmission Trigger
    input wire          statussettbProtTrigger         , // TB Protocol Trigger
    input wire          statussetac3ProtTrigger        , // AC3 Protocol Trigger
    input wire          statussetac2ProtTrigger        , // AC2 Protocol Trigger
    input wire          statussetac1ProtTrigger        , // AC1 Protocol Trigger
    input wire          statussetac0ProtTrigger        , // AC0 Protocol Trigger

    //$port_g TIMERSINTEVENTSETREG register.
    input wire          statussetabsTimers9            , // Absolute Timers 9
    input wire          statussetabsTimers8            , // Absolute Timers 8
    input wire          statussetabsTimers7            , // Absolute Timers 7
    input wire          statussetabsTimers6            , // Absolute Timers 6
    input wire          statussetabsTimers5            , // Absolute Timers 5
    input wire          statussetabsTimers4            , // Absolute Timers 4
    input wire          statussetabsTimers3            , // Absolute Timers 3
    input wire          statussetabsTimers2            , // Absolute Timers 2
    input wire          statussetabsTimers1            , // Absolute Timers 1
    input wire          statussetabsTimers0            , // Absolute Timers 0

    //$port_g TSFLOREG register.
    input wire [31 : 0] tsfTimerLowIn                  , // TSF Timer In
    input wire          tsfTimerLowInValid             , // TSF Timer In Valid

    //$port_g TSFHIREG register.
    input wire [31 : 0] tsfTimerHighIn                 , // TSF Timer In
    input wire          tsfTimerHighInValid            , // TSF Timer In Valid

    //$port_g TIMEONAIRVALUEREG register.
    input wire          computeDurationIn              , // Compute Duration In
    input wire          computeDurationInValid         , // Compute Duration In Valid
    input wire          timeOnAirValid                 , // Time On Air Valid
    input wire [15 : 0] timeOnAir                      , // Time On Air

    //$port_g DMACNTRLSETREG register.
    input wire          statussethaltTBAfterTXOP       , // Halt TB After TXOP
    input wire          statussethaltAC3AfterTXOP      , // Halt AC3 After TXOP
    input wire          statussethaltAC2AfterTXOP      , // Halt AC2 After TXOP
    input wire          statussethaltAC1AfterTXOP      , // Halt AC1 After TXOP
    input wire          statussethaltAC0AfterTXOP      , // Halt AC0 After TXOP
    input wire          statussethaltBcnAfterTXOP      , // Halt BCN queue
    input wire          statussettxTBNewHead           , // Transmit TB DMA New Head
    input wire          statussettxAC3NewHead          , // Transmit AC 3 DMA New Head
    input wire          statussettxAC2NewHead          , // Transmit AC 2 DMA New Head
    input wire          statussettxAC1NewHead          , // Transmit AC 1 DMA New Head
    input wire          statussettxAC0NewHead          , // Transmit AC 0 DMA New Head
    input wire          statussettxBcnNewHead          , // Transmit Beacon DMA New Head
    input wire          statussettxAC3NewTail          , // Transmit AC 3 DMA New Tail
    input wire          statussettxAC2NewTail          , // Transmit AC 2 DMA New Tail
    input wire          statussettxAC1NewTail          , // Transmit AC 1 DMA New Tail
    input wire          statussettxAC0NewTail          , // Transmit AC 0 DMA New Tail
    input wire          statussettxBcnNewTail          , // Transmit Beacon DMA New Tail

    //$port_g DMASTATUS1REG register.
    input wire [ 1 : 0] txTBState                      , // Transmit TB State
    input wire [ 1 : 0] txAC3State                     , // Transmit AC3 State
    input wire [ 1 : 0] txAC2State                     , // Transmit AC2 State
    input wire [ 1 : 0] txAC1State                     , // Transmit AC1 State
    input wire [ 1 : 0] txAC0State                     , // Transmit AC0 State
    input wire [ 1 : 0] txBcnState                     , // Transmit Beacon State

    //$port_g DMASTATUS2REG register.
    input wire          txNewHeadErr                   , // Transmit New Head Error
    input wire          txBusErr                       , // Transmit Bus Error
    input wire          txPTAddressErr                 , // Transmit Policy Table Address Error
    input wire          txNextPointerErr               , // Transmit Next Pointer Error
    input wire          txUPatternErr                  , // Transmit Unique Pattern Error
    input wire          txLenMismatch                  , // Transmit Length Mismatch

    //$port_g DMASTATUS3REG register.
    input wire          rxPayBusErr                    , // Receive Payload Bus Error
    input wire          rxHdrBusErr                    , // Receive Header Bus Error

    //$port_g DMASTATUS4REG register.
    input wire          txTBHaltAfterTXOP              , // Transmit TB Halt After TXOP
    input wire          txAC3HaltAfterTXOP             , // Transmit AC3 Halt After TXOP
    input wire          txAC2HaltAfterTXOP             , // Transmit AC2 Halt After TXOP
    input wire          txAC1HaltAfterTXOP             , // Transmit AC1 Halt After TXOP
    input wire          txAC0HaltAfterTXOP             , // Transmit AC0 Halt After TXOP
    input wire          txBcnHaltAfterTXOP             , // Transmit BCN Halt After TXOP
    input wire          txAC3EndQ                      , // Transmit AC3 End of Queue
    input wire          txAC2EndQ                      , // Transmit AC2 End of Queue
    input wire          txAC1EndQ                      , // Transmit AC1 End of Queue
    input wire          txAC0EndQ                      , // Transmit AC0 End of Queue
    input wire          txBcnEndQ                      , // Transmit Beacon End of Queue
    input wire          txAC3Startup                   , // Transmit AC3 Startup
    input wire          txAC2Startup                   , // Transmit AC2 Startup
    input wire          txAC1Startup                   , // Transmit AC1 Startup
    input wire          txAC0Startup                   , // Transmit AC0 Startup
    input wire          txBcnStartup                   , // Transmit Beacon Startup

    //$port_g RXHEADERTFPTRREG register.
    input wire [29 : 0] rxHeaderTFPtr                  , // Receive Header Trigger Frame Pointer

    //$port_g RXBUF1WRPTRREG register.
    input wire [31 : 0] rxBuf1WrPtrIn                  , // DMA Receive buffer 1 write Pointer In
    input wire          rxBuf1WrPtrInValid             , // DMA Receive buffer 1 write Pointer In Valid

    //$port_g RXBUF2WRPTRREG register.
    input wire [31 : 0] rxBuf2WrPtrIn                  , // DMA Receive buffer 2 write Pointer In
    input wire          rxBuf2WrPtrInValid             , // DMA Receive buffer 2 write Pointer In Valid

    //$port_g MOT1REG register.
    input wire [15 : 0] ac1MOT                         , // AC1 Medium Occupancy Timer
    input wire [15 : 0] ac0MOT                         , // AC0 Medium Occupancy Timer

    //$port_g MOT2REG register.
    input wire [15 : 0] ac3MOT                         , // AC3 Medium Occupancy Timer
    input wire [15 : 0] ac2MOT                         , // AC2 Medium Occupancy Timer

    //$port_g TXBWDROPINFOREG register.
    input wire [ 1 : 0] txBWAfterDrop                  , // Transmit Bandwidth After Drop

    //$port_g TXHETBINFOREG register.
    input wire [ 2 : 0] eOCWIn                         , // Exposent of OFDMA Contention Window In
    input wire          eOCWInValid                    , // Exposent of OFDMA Contention Window In Valid
    input wire [ 5 : 0] txHETBRemDur                   , // HE TB Preparation Remaining Duration

    //$port_g RXHETRIGCOMMONINFOREG register.
    input wire          ulDoppler                      , // UpLink Doppler
    input wire          ulPEDisambiguity               , // UpLink PE Disambiguity
    input wire [ 1 : 0] ulPreFecPadding                , // UpLink Pre-FEC Padding Factor
    input wire          ulLDPCExtrSymb                 , // UpLink LDPC Extra Symbol Segment
    input wire          ulSTBC                         , // UpLink STBC
    input wire [ 2 : 0] ulNLTFAndMidamble              , // UpLink Number Of HE-LTF Symbols And Midamble Periodicity
    input wire          ulMULTFMode                    , // UpLink MU-MIMO LTF Mode
    input wire [ 1 : 0] ulGILTFType                    , // UpLink GI And LTF Type
    input wire [ 1 : 0] ulBW                           , // UpLink Bandwidth
    input wire [11 : 0] ulLength                       , // UpLink Length
    input wire [ 3 : 0] ulTriggerType                  , // UpLink Trigger Type

    //$port_g RXHETRIGUSERINFOREG register.
    input wire [ 7 : 0] tdUserInfoSubfield             , // Trigger Dependent User Info subfield
    input wire          ulRUType                       , // UpLink RU Type
    input wire [ 2 : 0] ulNSS                          , // UpLink NSS
    input wire          ulDCM                          , // UpLink DCM
    input wire [ 3 : 0] ulMCS                          , // UpLink MCS
    input wire          ulFECCoding                    , // UpLink Fec Coding
    input wire [ 2 : 0] ulRUSize                       , // UpLink RU Size

    //$port_g RXHETRIGPSDULENREG register.
    input wire          ulPSDULenValid                 , // UpLink PSDU Length Valid
    input wire [19 : 0] ulPSDULen                      , // UpLink PSDU Length

    //$port_g RXHETRIGPWRINFOREG register.
    input wire [ 7 : 0] heTBUPHControl                 , // HE-TB Uplink power headroom
    input wire [ 6 : 0] ulTargetRSSI                   , // Uplink Target RSSI 
    input wire [ 5 : 0] apTXPower                      , // AP TX power
`ifdef RW_MUMIMO_TX_EN                     

    //$port_g SECUSERSTXINTEVENTSETREG register.

    //$port_g SECUSERSTXINTEVENTSETREG register.
    input wire          statussetsecU3ac3TxBufTrigger  , // Secondary User 3 AC3 Transmission Buffer Trigger
    input wire          statussetsecU3ac2TxBufTrigger  , // Secondary User 3 AC2 Transmission Buffer Trigger
    input wire          statussetsecU3ac1TxBufTrigger  , // Secondary User 3 AC1 Transmission Buffer Trigger
    input wire          statussetsecU3ac0TxBufTrigger  , // Secondary User 3 AC0 Transmission Buffer Trigger
    input wire          statussetsecU3ac3TxTrigger     , // Secondary User 3 AC3 Transmission Trigger
    input wire          statussetsecU3ac2TxTrigger     , // Secondary User 3 AC2 Transmission Trigger
    input wire          statussetsecU3ac1TxTrigger     , // Secondary User 3 AC1 Transmission Trigger
    input wire          statussetsecU3ac0TxTrigger     , // Secondary User 3 AC0 Transmission Trigger
    input wire          statussetsecU2ac3TxBufTrigger  , // Secondary User 2 AC3 Transmission Buffer Trigger
    input wire          statussetsecU2ac2TxBufTrigger  , // Secondary User 2 AC2 Transmission Buffer Trigger
    input wire          statussetsecU2ac1TxBufTrigger  , // Secondary User 2 AC1 Transmission Buffer Trigger
    input wire          statussetsecU2ac0TxBufTrigger  , // Secondary User 2 AC0 Transmission Buffer Trigger
    input wire          statussetsecU2ac3TxTrigger     , // Secondary User 2 AC3 Transmission Trigger
    input wire          statussetsecU2ac2TxTrigger     , // Secondary User 2 AC2 Transmission Trigger
    input wire          statussetsecU2ac1TxTrigger     , // Secondary User 2 AC1 Transmission Trigger
    input wire          statussetsecU2ac0TxTrigger     , // Secondary User 2 AC0 Transmission Trigger
    input wire          statussetsecU1ac3TxBufTrigger  , // Secondary User 1 AC3 Transmission Buffer Trigger
    input wire          statussetsecU1ac2TxBufTrigger  , // Secondary User 1 AC2 Transmission Buffer Trigger
    input wire          statussetsecU1ac1TxBufTrigger  , // Secondary User 1 AC1 Transmission Buffer Trigger
    input wire          statussetsecU1ac0TxBufTrigger  , // Secondary User 1 AC0 Transmission Buffer Trigger
    input wire          statussetsecU1ac3TxTrigger     , // Secondary User 1 AC3 Transmission Trigger
    input wire          statussetsecU1ac2TxTrigger     , // Secondary User 1 AC2 Transmission Trigger
    input wire          statussetsecU1ac1TxTrigger     , // Secondary User 1 AC1 Transmission Trigger
    input wire          statussetsecU1ac0TxTrigger     , // Secondary User 1 AC0 Transmission Trigger
`endif // RW_MUMIMO_TX_EN                     

    //$port_g DEBUGBCNSPTRREG register.
    input wire [31 : 0] bcnStatusPointer               , // Beacon Status Pointer

    //$port_g DEBUGAC0SPTRREG register.
    input wire [31 : 0] ac0StatusPointer               , // AC0 Status Pointer

    //$port_g DEBUGAC1SPTRREG register.
    input wire [31 : 0] ac1StatusPointer               , // AC1 Status Pointer

    //$port_g DEBUGAC2SPTRREG register.
    input wire [31 : 0] ac2StatusPointer               , // AC2 Status Pointer

    //$port_g DEBUGAC3SPTRREG register.
    input wire [31 : 0] ac3StatusPointer               , // AC3 Status Pointer
    //$port_g DEBUGTBSPTRREG register.
    input wire [31 : 0] tbStatusPointer                , // TB Status Pointer

    //$port_g DEBUGTXCPTRREG register.
    input wire [31 : 0] txCurrentPointer               , // Transmit Current Pointer

    //$port_g SWPROFILINGREG register.
    input wire          swProf31In                     , // Software Profiling value In
    input wire          swProf31InValid                , // Software Profiling value In Valid
    input wire          swProf30In                     , // Software Profiling value In
    input wire          swProf30InValid                , // Software Profiling value In Valid
    input wire          swProf29In                     , // Software Profiling value In
    input wire          swProf29InValid                , // Software Profiling value In Valid
    input wire          swProf28In                     , // Software Profiling value In
    input wire          swProf28InValid                , // Software Profiling value In Valid
    input wire          swProf27In                     , // Software Profiling value In
    input wire          swProf27InValid                , // Software Profiling value In Valid
    input wire          swProf26In                     , // Software Profiling value In
    input wire          swProf26InValid                , // Software Profiling value In Valid
    input wire          swProf25In                     , // Software Profiling value In
    input wire          swProf25InValid                , // Software Profiling value In Valid
    input wire          swProf24In                     , // Software Profiling value In
    input wire          swProf24InValid                , // Software Profiling value In Valid
    input wire          swProf23In                     , // Software Profiling value In
    input wire          swProf23InValid                , // Software Profiling value In Valid
    input wire          swProf22In                     , // Software Profiling value In
    input wire          swProf22InValid                , // Software Profiling value In Valid
    input wire          swProf21In                     , // Software Profiling value In
    input wire          swProf21InValid                , // Software Profiling value In Valid
    input wire          swProf20In                     , // Software Profiling value In
    input wire          swProf20InValid                , // Software Profiling value In Valid
    input wire          swProf19In                     , // Software Profiling value In
    input wire          swProf19InValid                , // Software Profiling value In Valid
    input wire          swProf18In                     , // Software Profiling value In
    input wire          swProf18InValid                , // Software Profiling value In Valid
    input wire          swProf17In                     , // Software Profiling value In
    input wire          swProf17InValid                , // Software Profiling value In Valid
    input wire          swProf16In                     , // Software Profiling value In
    input wire          swProf16InValid                , // Software Profiling value In Valid
    input wire          swProf15In                     , // Software Profiling value In
    input wire          swProf15InValid                , // Software Profiling value In Valid
    input wire          swProf14In                     , // Software Profiling value In
    input wire          swProf14InValid                , // Software Profiling value In Valid
    input wire          swProf13In                     , // Software Profiling value In
    input wire          swProf13InValid                , // Software Profiling value In Valid
    input wire          swProf12In                     , // Software Profiling value In
    input wire          swProf12InValid                , // Software Profiling value In Valid
    input wire          swProf11In                     , // Software Profiling value In
    input wire          swProf11InValid                , // Software Profiling value In Valid
    input wire          swProf10In                     , // Software Profiling value In
    input wire          swProf10InValid                , // Software Profiling value In Valid
    input wire          swProf9In                      , // Software Profiling value In
    input wire          swProf9InValid                 , // Software Profiling value In Valid
    input wire          swProf8In                      , // Software Profiling value In
    input wire          swProf8InValid                 , // Software Profiling value In Valid
    input wire          swProf7In                      , // Software Profiling value In
    input wire          swProf7InValid                 , // Software Profiling value In Valid
    input wire          swProf6In                      , // Software Profiling value In
    input wire          swProf6InValid                 , // Software Profiling value In Valid
    input wire          swProf5In                      , // Software Profiling value In
    input wire          swProf5InValid                 , // Software Profiling value In Valid
    input wire          swProf4In                      , // Software Profiling value In
    input wire          swProf4InValid                 , // Software Profiling value In Valid
    input wire          swProf3In                      , // Software Profiling value In
    input wire          swProf3InValid                 , // Software Profiling value In Valid
    input wire          swProf2In                      , // Software Profiling value In
    input wire          swProf2InValid                 , // Software Profiling value In Valid
    input wire          swProf1In                      , // Software Profiling value In
    input wire          swProf1InValid                 , // Software Profiling value In Valid
    input wire          swProf0In                      , // Software Profiling value In
    input wire          swProf0InValid                 , // Software Profiling value In Valid

    //$port_g SWSETPROFILINGREG register.
    input wire          statusswSetProf31              , // Software Profiling Set Bit
    input wire          statusswSetProf30              , // Software Profiling Set Bit
    input wire          statusswSetProf29              , // Software Profiling Set Bit
    input wire          statusswSetProf28              , // Software Profiling Set Bit
    input wire          statusswSetProf27              , // Software Profiling Set Bit
    input wire          statusswSetProf26              , // Software Profiling Set Bit
    input wire          statusswSetProf25              , // Software Profiling Set Bit
    input wire          statusswSetProf24              , // Software Profiling Set Bit
    input wire          statusswSetProf23              , // Software Profiling Set Bit
    input wire          statusswSetProf22              , // Software Profiling Set Bit
    input wire          statusswSetProf21              , // Software Profiling Set Bit
    input wire          statusswSetProf20              , // Software Profiling Set Bit
    input wire          statusswSetProf19              , // Software Profiling Set Bit
    input wire          statusswSetProf18              , // Software Profiling Set Bit
    input wire          statusswSetProf17              , // Software Profiling Set Bit
    input wire          statusswSetProf16              , // Software Profiling Set Bit
    input wire          statusswSetProf15              , // Software Profiling Set Bit
    input wire          statusswSetProf14              , // Software Profiling Set Bit
    input wire          statusswSetProf13              , // Software Profiling Set Bit
    input wire          statusswSetProf12              , // Software Profiling Set Bit
    input wire          statusswSetProf11              , // Software Profiling Set Bit
    input wire          statusswSetProf10              , // Software Profiling Set Bit
    input wire          statusswSetProf9               , // Software Profiling Set Bit
    input wire          statusswSetProf8               , // Software Profiling Set Bit
    input wire          statusswSetProf7               , // Software Profiling Set Bit
    input wire          statusswSetProf6               , // Software Profiling Set Bit
    input wire          statusswSetProf5               , // Software Profiling Set Bit
    input wire          statusswSetProf4               , // Software Profiling Set Bit
    input wire          statusswSetProf3               , // Software Profiling Set Bit
    input wire          statusswSetProf2               , // Software Profiling Set Bit
    input wire          statusswSetProf1               , // Software Profiling Set Bit
    input wire          statusswSetProf0               , // Software Profiling Set Bit

    //$port_g SWPROFILINGREG2 register.
    input wire          swProf63In                     , // Software Profiling value In
    input wire          swProf63InValid                , // Software Profiling value In Valid
    input wire          swProf62In                     , // Software Profiling value In
    input wire          swProf62InValid                , // Software Profiling value In Valid
    input wire          swProf61In                     , // Software Profiling value In
    input wire          swProf61InValid                , // Software Profiling value In Valid
    input wire          swProf60In                     , // Software Profiling value In
    input wire          swProf60InValid                , // Software Profiling value In Valid
    input wire          swProf59In                     , // Software Profiling value In
    input wire          swProf59InValid                , // Software Profiling value In Valid
    input wire          swProf58In                     , // Software Profiling value In
    input wire          swProf58InValid                , // Software Profiling value In Valid
    input wire          swProf57In                     , // Software Profiling value In
    input wire          swProf57InValid                , // Software Profiling value In Valid
    input wire          swProf56In                     , // Software Profiling value In
    input wire          swProf56InValid                , // Software Profiling value In Valid
    input wire          swProf55In                     , // Software Profiling value In
    input wire          swProf55InValid                , // Software Profiling value In Valid
    input wire          swProf54In                     , // Software Profiling value In
    input wire          swProf54InValid                , // Software Profiling value In Valid
    input wire          swProf53In                     , // Software Profiling value In
    input wire          swProf53InValid                , // Software Profiling value In Valid
    input wire          swProf52In                     , // Software Profiling value In
    input wire          swProf52InValid                , // Software Profiling value In Valid
    input wire          swProf51In                     , // Software Profiling value In
    input wire          swProf51InValid                , // Software Profiling value In Valid
    input wire          swProf50In                     , // Software Profiling value In
    input wire          swProf50InValid                , // Software Profiling value In Valid
    input wire          swProf49In                     , // Software Profiling value In
    input wire          swProf49InValid                , // Software Profiling value In Valid
    input wire          swProf48In                     , // Software Profiling value In
    input wire          swProf48InValid                , // Software Profiling value In Valid
    input wire          swProf47In                     , // Software Profiling value In
    input wire          swProf47InValid                , // Software Profiling value In Valid
    input wire          swProf46In                     , // Software Profiling value In
    input wire          swProf46InValid                , // Software Profiling value In Valid
    input wire          swProf45In                     , // Software Profiling value In
    input wire          swProf45InValid                , // Software Profiling value In Valid
    input wire          swProf44In                     , // Software Profiling value In
    input wire          swProf44InValid                , // Software Profiling value In Valid
    input wire          swProf43In                     , // Software Profiling value In
    input wire          swProf43InValid                , // Software Profiling value In Valid
    input wire          swProf42In                     , // Software Profiling value In
    input wire          swProf42InValid                , // Software Profiling value In Valid
    input wire          swProf41In                     , // Software Profiling value In
    input wire          swProf41InValid                , // Software Profiling value In Valid
    input wire          swProf40In                     , // Software Profiling value In
    input wire          swProf40InValid                , // Software Profiling value In Valid
    input wire          swProf39In                     , // Software Profiling value In
    input wire          swProf39InValid                , // Software Profiling value In Valid
    input wire          swProf38In                     , // Software Profiling value In
    input wire          swProf38InValid                , // Software Profiling value In Valid
    input wire          swProf37In                     , // Software Profiling value In
    input wire          swProf37InValid                , // Software Profiling value In Valid
    input wire          swProf36In                     , // Software Profiling value In
    input wire          swProf36InValid                , // Software Profiling value In Valid
    input wire          swProf35In                     , // Software Profiling value In
    input wire          swProf35InValid                , // Software Profiling value In Valid
    input wire          swProf34In                     , // Software Profiling value In
    input wire          swProf34InValid                , // Software Profiling value In Valid
    input wire          swProf33In                     , // Software Profiling value In
    input wire          swProf33InValid                , // Software Profiling value In Valid
    input wire          swProf32In                     , // Software Profiling value In
    input wire          swProf32InValid                , // Software Profiling value In Valid

    //$port_g SWSETPROFILINGREG2 register.
    input wire          statusswSetProf63              , // Software Profiling Set Bit
    input wire          statusswSetProf62              , // Software Profiling Set Bit
    input wire          statusswSetProf61              , // Software Profiling Set Bit
    input wire          statusswSetProf60              , // Software Profiling Set Bit
    input wire          statusswSetProf59              , // Software Profiling Set Bit
    input wire          statusswSetProf58              , // Software Profiling Set Bit
    input wire          statusswSetProf57              , // Software Profiling Set Bit
    input wire          statusswSetProf56              , // Software Profiling Set Bit
    input wire          statusswSetProf55              , // Software Profiling Set Bit
    input wire          statusswSetProf54              , // Software Profiling Set Bit
    input wire          statusswSetProf53              , // Software Profiling Set Bit
    input wire          statusswSetProf52              , // Software Profiling Set Bit
    input wire          statusswSetProf51              , // Software Profiling Set Bit
    input wire          statusswSetProf50              , // Software Profiling Set Bit
    input wire          statusswSetProf49              , // Software Profiling Set Bit
    input wire          statusswSetProf48              , // Software Profiling Set Bit
    input wire          statusswSetProf47              , // Software Profiling Set Bit
    input wire          statusswSetProf46              , // Software Profiling Set Bit
    input wire          statusswSetProf45              , // Software Profiling Set Bit
    input wire          statusswSetProf44              , // Software Profiling Set Bit
    input wire          statusswSetProf43              , // Software Profiling Set Bit
    input wire          statusswSetProf42              , // Software Profiling Set Bit
    input wire          statusswSetProf41              , // Software Profiling Set Bit
    input wire          statusswSetProf40              , // Software Profiling Set Bit
    input wire          statusswSetProf39              , // Software Profiling Set Bit
    input wire          statusswSetProf38              , // Software Profiling Set Bit
    input wire          statusswSetProf37              , // Software Profiling Set Bit
    input wire          statusswSetProf36              , // Software Profiling Set Bit
    input wire          statusswSetProf35              , // Software Profiling Set Bit
    input wire          statusswSetProf34              , // Software Profiling Set Bit
    input wire          statusswSetProf33              , // Software Profiling Set Bit
    input wire          statusswSetProf32              , // Software Profiling Set Bit
`ifdef RW_MUMIMO_SEC_USER1_EN              

    //$port_g DEBUGSECU1TXCPTRREG register.
    input wire [31 : 0] secU1TxCurrentPointer          , // Secondary User1 Transmit Current Pointer
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              

    //$port_g DEBUGSECU2TXCPTRREG register.
    input wire [31 : 0] secU2TxCurrentPointer          , // Secondary User2 Transmit Current Pointer
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              

    //$port_g DEBUGSECU3TXCPTRREG register.
    input wire [31 : 0] secU3TxCurrentPointer          , // Secondary User3 Transmit Current Pointer
`endif // RW_MUMIMO_SEC_USER3_EN              
    //

    //$port_g DOZECNTRL2REG register.
    output wire          wakeUpFromDoze                , // Wake Up from Doze.
    output wire          wakeUpSW                      , // Wake Up SW

    //$port_g MACCNTRL2REG register.
    output wire          softReset                     , // Soft Reset

    //$port_g GENINTEVENTSETREG register.
    output wire          settbTxDMADead                , // TB Transmit DMA Dead
    output wire          setrxPayloadDMADead           , // Receive Payload DMA Dead
    output wire          setrxHeaderDMADead            , // Receive Payload DMA Dead
    output wire          setphyRxStart                 , // PHY Receive Start indication
    output wire          setphyErr                     , // PHY Error
    output wire          setmacPHYIFUnderRun           , // MAC PHY InterFace Under Run
    output wire          sethwErr                      , // Hardware Error
    output wire          setimpSecDTIM                 , // Impending Secondary DTIM
    output wire          setimpPriDTIM                 , // Impending Primary DTIM
    output wire          setbcnTxDMADead               , // Beacon Transmit DMA Dead
    output wire          setac3TxDMADead               , // AC3 Transmit DMA Dead
    output wire          setac2TxDMADead               , // AC2 Transmit DMA Dead
    output wire          setac1TxDMADead               , // AC1 Transmit DMA Dead
    output wire          setac0TxDMADead               , // AC0 Transmit DMA Dead
    output wire          setptError                    , // Policy Table Error
    output wire          settimSet                     , // TIM Set
    output wire          setolbcDSSS                   , // DSSS OLBC
    output wire          setolbcOFDM                   , // OFDM OLBC
    output wire          setrxFIFOOverFlow             , // Receive FIFO Over Flow
    output wire          setmacPHYIFOverflow           , // MAC PHY InterFace Over Flow
    output wire          setcoexEvent                  , // Coex Interface Event
    output wire          absGenTimers                  , // Absolute General Timer Interrupt
    output wire          setidleInterrupt              , // Idle Interrupt
    output wire          setimpSecTBTT                 , // Impending Secondary Target Beacon Transmission Time
    output wire          setimpPriTBTT                 , // Impending Primary Target Beacon Transmission Time

    //$port_g GENINTEVENTCLEARREG register.
    output wire          cleartbTxDMADead              , // TB Transmit DMA Dead
    output wire          clearrxPayloadDMADead         , // Receive Payload DMA Dead
    output wire          clearrxHeaderDMADead          , // Receive Payload DMA Dead
    output wire          clearphyRxStart               , // PHY Receive Start indication
    output wire          clearphyErr                   , // PHY Error
    output wire          clearmacPHYIFUnderRun         , // MAC PHY InterFace Under Run
    output wire          clearhwErr                    , // Hardware Error
    output wire          clearimpSecDTIM               , // Impending Secondary DTIM
    output wire          clearimpPriDTIM               , // Impending Primary DTIM
    output wire          clearbcnTxDMADead             , // Beacon Transmit DMA Dead
    output wire          clearac3TxDMADead             , // AC3 Transmit DMA Dead
    output wire          clearac2TxDMADead             , // AC2 Transmit DMA Dead
    output wire          clearac1TxDMADead             , // AC1 Transmit DMA Dead
    output wire          clearac0TxDMADead             , // AC0 Transmit DMA Dead
    output wire          clearptError                  , // Policy Table Error
    output wire          cleartimSet                   , // TIM Set
    output wire          clearolbcDSSS                 , // DSSS OLBC
    output wire          clearolbcOFDM                 , // OFDM OLBC
    output wire          clearrxFIFOOverFlow           , // Receive FIFO Over Flow
    output wire          clearmacPHYIFOverflow         , // MAC PHY InterFace Over Flow
    output wire          clearcoexEvent                , // Coex Interface Event
    output wire          clearidleInterrupt            , // Idle Interrupt
    output wire          clearimpSecTBTT               , // Impending Secondary Target Beacon Transmission Time
    output wire          clearimpPriTBTT               , // Impending Primary Target Beacon Transmission Time

    //$port_g GENINTUNMASKREG register.
    output wire          masterGenIntEn                , // If set, external interrupts will be generated in accordance with the rest of the genIntUnMaskReg register bits.
    output wire          masktbTxDMADead               , // TB Transmit DMA Dead
    output wire          maskrxPayloadDMADead          , // Receive Payload DMA Dead
    output wire          maskrxHeaderDMADead           , // Receive Payload DMA Dead
    output wire          maskphyRxStart                , // PHY Receive Start indication
    output wire          maskphyErr                    , // PHY Error
    output wire          maskmacPHYIFUnderRun          , // MAC PHY InterFace Under Run
    output wire          maskhwErr                     , // Hardware Error
    output wire          maskimpSecDTIM                , // Impending Secondary DTIM
    output wire          maskimpPriDTIM                , // Impending Primary DTIM
    output wire          maskbcnTxDMADead              , // Beacon Transmit DMA Dead
    output wire          maskac3TxDMADead              , // AC3 Transmit DMA Dead
    output wire          maskac2TxDMADead              , // AC2 Transmit DMA Dead
    output wire          maskac1TxDMADead              , // AC1 Transmit DMA Dead
    output wire          maskac0TxDMADead              , // AC0 Transmit DMA Dead
    output wire          maskptError                   , // Policy Table Error
    output wire          masktimSet                    , // TIM Set
    output wire          maskolbcDSSS                  , // DSSS OLBC
    output wire          maskolbcOFDM                  , // OFDM OLBC
    output wire          maskrxFIFOOverFlow            , // Receive FIFO Over Flow
    output wire          maskmacPHYIFOverflow          , // MAC PHY InterFace Over Flow
    output wire          maskcoexEvent                 , // Coex Interface Event
    output wire          maskabsGenTimers              , // Absolute General Timer Interrupt
    output wire          maskidleInterrupt             , // Idle Interrupt
    output wire          maskimpSecTBTT                , // Impending Secondary Target Beacon Transmission Time
    output wire          maskimpPriTBTT                , // Impending Primary Target Beacon Transmission Time

    //$port_g TXRXINTEVENTSETREG register.
    output wire          settbTxBufTrigger             , // TB Transmission Buffer Trigger
    output wire          setbcnTxBufTrigger            , // Beacon Transmission Buffer Trigger
    output wire          setac3TxBufTrigger            , // AC3 Transmission Buffer Trigger
    output wire          setac2TxBufTrigger            , // AC2 Transmission Buffer Trigger
    output wire          setac1TxBufTrigger            , // AC1 Transmission Buffer Trigger
    output wire          setac0TxBufTrigger            , // AC0 Transmission Buffer Trigger
    output wire          setac3BWDropTrigger           , // AC3 Bandwith Drop Trigger
    output wire          setac2BWDropTrigger           , // AC2 Bandwith Drop Trigger
    output wire          setac1BWDropTrigger           , // AC1 Bandwith Drop Trigger
    output wire          setac0BWDropTrigger           , // AC0 Bandwith Drop Trigger
    output wire          setrxBuffer2Trigger           , // Receive Buffer 2 Trigger
    output wire          settimerRxTrigger             , // Timer Receive Trigger
    output wire          setrxBuffer1Trigger           , // Receive Buffer 1 Trigger
    output wire          setsecUserTxTrigger           , // Secondary User Transmission Trigger
    output wire          settimerTxTrigger             , // Timer Transmission Trigger
    output wire          settxopComplete               , // TXOP Complete
    output wire          settbTxCancelled              , // TB Transmission Cancelled
    output wire          settbTxTrigger                , // TB Transmission Trigger
    output wire          setbcnTxTrigger               , // Beacon Transmission Trigger
    output wire          setac3TxTrigger               , // AC3 Transmission Trigger
    output wire          setac2TxTrigger               , // AC2 Transmission Trigger
    output wire          setac1TxTrigger               , // AC1 Transmission Trigger
    output wire          setac0TxTrigger               , // AC0 Transmission Trigger
    output wire          settbProtTrigger              , // TB Protocol Trigger
    output wire          setac3ProtTrigger             , // AC3 Protocol Trigger
    output wire          setac2ProtTrigger             , // AC2 Protocol Trigger
    output wire          setac1ProtTrigger             , // AC1 Protocol Trigger
    output wire          setac0ProtTrigger             , // AC0 Protocol Trigger

    //$port_g TXRXINTEVENTCLEARREG register.
    output wire          cleartbTxBufTrigger           , // Trigger Based Transmission Buffer Trigger
    output wire          clearbcnTxBufTrigger          , // Beacon Transmission Buffer Trigger
    output wire          clearac3TxBufTrigger          , // AC3 Transmission Buffer Trigger
    output wire          clearac2TxBufTrigger          , // AC2 Transmission Buffer Trigger
    output wire          clearac1TxBufTrigger          , // AC1 Transmission Buffer Trigger
    output wire          clearac0TxBufTrigger          , // AC0 Transmission Buffer Trigger
    output wire          clearac3BWDropTrigger         , // AC3 Bandwith Drop Trigger
    output wire          clearac2BWDropTrigger         , // AC2 Bandwith Drop Trigger
    output wire          clearac1BWDropTrigger         , // AC1 Bandwith Drop Trigger
    output wire          clearac0BWDropTrigger         , // AC0 Bandwith Drop Trigger
    output wire          clearrxBuffer2Trigger         , // Receive Buffer 2 Trigger
    output wire          cleartimerRxTrigger           , // Timer Receive Trigger
    output wire          clearrxBuffer1Trigger         , // Receive Buffer 1 Trigger
    output wire          cleartimerTxTrigger           , // Timer Transmission Trigger
    output wire          cleartxopComplete             , // TXOP Complete
    output wire          cleartbTxCancelled            , // TB Transmission Cancelled
    output wire          cleartbTxTrigger              , // TB Transmission Trigger
    output wire          clearbcnTxTrigger             , // Beacon Transmission Trigger
    output wire          clearac3TxTrigger             , // AC3 Transmission Trigger
    output wire          clearac2TxTrigger             , // AC2 Transmission Trigger
    output wire          clearac1TxTrigger             , // AC1 Transmission Trigger
    output wire          clearac0TxTrigger             , // AC0 Transmission Trigger
    output wire          cleartbProtTrigger            , // TB Protocol Trigger
    output wire          clearac3ProtTrigger           , // AC3 Protocol Trigger
    output wire          clearac2ProtTrigger           , // AC2 Protocol Trigger
    output wire          clearac1ProtTrigger           , // AC1 Protocol Trigger
    output wire          clearac0ProtTrigger           , // AC0 Protocol Trigger

    //$port_g TXRXINTUNMASKREG register.
    output wire          masterTxRxIntEn               , // If set, external interrupts will be generated in accordance with the rest of the txRxIntUnMaskReg register bits.
    output wire          masktbTxBufTrigger            , // Trigger Based Transmission Buffer Trigger
    output wire          maskbcnTxBufTrigger           , // Beacon Transmission Buffer Trigger
    output wire          maskac3TxBufTrigger           , // AC3 Transmission Buffer Trigger
    output wire          maskac2TxBufTrigger           , // AC2 Transmission Buffer Trigger
    output wire          maskac1TxBufTrigger           , // AC1 Transmission Buffer Trigger
    output wire          maskac0TxBufTrigger           , // AC0 Transmission Buffer Trigger
    output wire          maskac3BWDropTrigger          , // AC3 Bandwith Drop Trigger
    output wire          maskac2BWDropTrigger          , // AC2 Bandwith Drop Trigger
    output wire          maskac1BWDropTrigger          , // AC1 Bandwith Drop Trigger
    output wire          maskac0BWDropTrigger          , // AC0 Bandwith Drop Trigger
    output wire          maskrxBuffer2Trigger          , // Receive Buffer 2 Trigger
    output wire          masktimerRxTrigger            , // Timer Receive Trigger
    output wire          maskrxBuffer1Trigger          , // Receive Buffer 1 Trigger
    output wire          masksecUserTxTrigger          , // Secondary User Transmission Trigger
    output wire          masktimerTxTrigger            , // Timer Transmission Trigger
    output wire          masktxopComplete              , // TXOP Complete
    output wire          masktbTxCancelled             , // TB Transmission Cancelled
    output wire          masktbTxTrigger               , // TB Transmission Trigger
    output wire          maskbcnTxTrigger              , // Beacon Transmission Trigger
    output wire          maskac3TxTrigger              , // AC3 Transmission Trigger
    output wire          maskac2TxTrigger              , // AC2 Transmission Trigger
    output wire          maskac1TxTrigger              , // AC1 Transmission Trigger
    output wire          maskac0TxTrigger              , // AC0 Transmission Trigger
    output wire          masktbProtTrigger             , // TB Protocol Trigger
    output wire          maskac3ProtTrigger            , // AC3 Protocol Trigger
    output wire          maskac2ProtTrigger            , // AC2 Protocol Trigger
    output wire          maskac1ProtTrigger            , // AC1 Protocol Trigger
    output wire          maskac0ProtTrigger            , // AC0 Protocol Trigger

    //$port_g TIMERSINTEVENTSETREG register.
    output wire          setabsTimers9                 , // Absolute Timers 9
    output wire          setabsTimers8                 , // Absolute Timers 8
    output wire          setabsTimers7                 , // Absolute Timers 7
    output wire          setabsTimers6                 , // Absolute Timers 6
    output wire          setabsTimers5                 , // Absolute Timers 5
    output wire          setabsTimers4                 , // Absolute Timers 4
    output wire          setabsTimers3                 , // Absolute Timers 3
    output wire          setabsTimers2                 , // Absolute Timers 2
    output wire          setabsTimers1                 , // Absolute Timers 1
    output wire          setabsTimers0                 , // Absolute Timers 0

    //$port_g TIMERSINTEVENTCLEARREG register.
    output wire          clearabsTimers9               , // Absolute Timers 9
    output wire          clearabsTimers8               , // Absolute Timers 8
    output wire          clearabsTimers7               , // Absolute Timers 7
    output wire          clearabsTimers6               , // Absolute Timers 6
    output wire          clearabsTimers5               , // Absolute Timers 5
    output wire          clearabsTimers4               , // Absolute Timers 4
    output wire          clearabsTimers3               , // Absolute Timers 3
    output wire          clearabsTimers2               , // Absolute Timers 2
    output wire          clearabsTimers1               , // Absolute Timers 1
    output wire          clearabsTimers0               , // Absolute Timers 0

    //$port_g TIMERSINTUNMASKREG register.
    output wire          maskabsTimers9                , // Absolute Timers 9
    output wire          maskabsTimers8                , // Absolute Timers 8
    output wire          maskabsTimers7                , // Absolute Timers 7
    output wire          maskabsTimers6                , // Absolute Timers 6
    output wire          maskabsTimers5                , // Absolute Timers 5
    output wire          maskabsTimers4                , // Absolute Timers 4
    output wire          maskabsTimers3                , // Absolute Timers 3
    output wire          maskabsTimers2                , // Absolute Timers 2
    output wire          maskabsTimers1                , // Absolute Timers 1
    output wire          maskabsTimers0                , // Absolute Timers 0

    //$port_g TSFLOREG register.
    output wire [31 : 0] tsfTimerLow                   , // TSF Timer

    //$port_g TSFHIREG register.
    output wire [31 : 0] tsfTimerHigh                  , // TSF Timer

    //$port_g TIMEONAIRPARAM1REG register.
    output wire [ 1 : 0] ppduSTBC                      , // PPDU Space Time Block Coding
    output wire [ 1 : 0] ppduNumExtnSS                 , // PPDU Number of Extension Spatial Streams
    output wire [ 1 : 0] ppduBW                        , // PPDU BW
    output wire [ 1 : 0] ppduGI                        , // PPDU Guard Interval
    output wire [ 3 : 0] ppduPreType                   , // PPDU Preamble Type
    output wire [19 : 0] ppduLength                    , // PPDU Length

    //$port_g TIMEONAIRPARAM2REG register.
    output wire [ 2 : 0] ppduNumHeLtf                  , // PPDU Number of HE LTF
    output wire [ 6 : 0] ppduNUser                     , // PPDU Dual Carrier Modulation on SIG B
    output wire [ 2 : 0] ppduPE                        , // PPDU Packet Extension
    output wire [ 2 : 0] ppduMCSSigB                   , // PPDU MCS of SIG B
    output wire          ppduDCMSigB                   , // PPDU Dual Carrier Modulation on SIG B
    output wire          ppduSigBCompMode              , // PPDU SIG B Compression Mode
    output wire [ 1 : 0] ppduHELTFType                 , // PPDU HE-LTF Type
    output wire          ppduDCM                       , // PPDU Dual Carrier Modulation
    output wire [ 6 : 0] ppduMCSIndex                  , // PPDU MCS Index

    //$port_g TIMEONAIRPARAM3REG register.
    output wire [ 2 : 0] ppduRuType                    , // PPDU Ru Type
    output wire          ppduMma                       , // PPDU Midamble
    output wire          ppduDoppler                   , // PPDU Doppler

    //$port_g TIMEONAIRVALUEREG register.
    output wire          computeDuration               , // Compute Duration

    //$port_g DMACNTRLSETREG register.
    output wire          sethaltTBAfterTXOP            , // Halt TB After TXOP
    output wire          sethaltAC3AfterTXOP           , // Halt AC3 After TXOP
    output wire          sethaltAC2AfterTXOP           , // Halt AC2 After TXOP
    output wire          sethaltAC1AfterTXOP           , // Halt AC1 After TXOP
    output wire          sethaltAC0AfterTXOP           , // Halt AC0 After TXOP
    output wire          sethaltBcnAfterTXOP           , // Halt BCN queue
    output wire          settxTBNewHead                , // Transmit TB DMA New Head
    output wire          settxAC3NewHead               , // Transmit AC 3 DMA New Head
    output wire          settxAC2NewHead               , // Transmit AC 2 DMA New Head
    output wire          settxAC1NewHead               , // Transmit AC 1 DMA New Head
    output wire          settxAC0NewHead               , // Transmit AC 0 DMA New Head
    output wire          settxBcnNewHead               , // Transmit Beacon DMA New Head
    output wire          settxAC3NewTail               , // Transmit AC 3 DMA New Tail
    output wire          settxAC2NewTail               , // Transmit AC 2 DMA New Tail
    output wire          settxAC1NewTail               , // Transmit AC 1 DMA New Tail
    output wire          settxAC0NewTail               , // Transmit AC 0 DMA New Tail
    output wire          settxBcnNewTail               , // Transmit Beacon DMA New Tail

    //$port_g DMACNTRLCLEARREG register.
    output wire          clearhaltTBAfterTXOP          , // Halt TB After TXOP
    output wire          clearhaltAC3AfterTXOP         , // Halt AC3 After TXOP
    output wire          clearhaltAC2AfterTXOP         , // Halt AC2 After TXOP
    output wire          clearhaltAC1AfterTXOP         , // Halt AC1 After TXOP
    output wire          clearhaltAC0AfterTXOP         , // Halt AC0 After TXOP
    output wire          clearhaltBcnAfterTXOP         , // Halt BCN queue
    output wire          cleartxTBNewHead              , // Transmit TB DMA New Head
    output wire          cleartxAC3NewHead             , // Transmit AC 3 DMA New Head
    output wire          cleartxAC2NewHead             , // Transmit AC 2 DMA New Head
    output wire          cleartxAC1NewHead             , // Transmit AC 1 DMA New Head
    output wire          cleartxAC0NewHead             , // Transmit AC 0 DMA New Head
    output wire          cleartxBcnNewHead             , // Transmit Beacon DMA New Head
    output wire          cleartxAC3NewTail             , // Transmit AC 3 DMA New Tail
    output wire          cleartxAC2NewTail             , // Transmit AC 2 DMA New Tail
    output wire          cleartxAC1NewTail             , // Transmit AC 1 DMA New Tail
    output wire          cleartxAC0NewTail             , // Transmit AC 0 DMA New Tail
    output wire          cleartxBcnNewTail             , // Transmit Beacon DMA New Tail

    //$port_g TXBCNHEADPTRREG register.
    output wire [31 : 0] txBcnHeadPtr                  , // Transmit Beacon list Head Pointer

    //$port_g TXAC0HEADPTRREG register.
    output wire [31 : 0] txAC0HeadPtr                  , // Transmit AC 0 list Head Pointer

    //$port_g TXAC1HEADPTRREG register.
    output wire [31 : 0] txAC1HeadPtr                  , // Transmit AC 1 list Head Pointer

    //$port_g TXAC2HEADPTRREG register.
    output wire [31 : 0] txAC2HeadPtr                  , // Transmit AC 2 list Head Pointer

    //$port_g TXAC3HEADPTRREG register.
    output wire [31 : 0] txAC3HeadPtr                  , // Transmit AC 3 list Head Pointer

    //$port_g TXTBHEADPTRREG register.
    output wire [31 : 0] txTBHeadPtr                   , // Transmit TB Head Pointer

    //$port_g TXSTRUCTSIZESREG register.
    output wire [ 5 : 0] dmaRBDSize                    , // DMA Receive Buffer Descriptor Size
    output wire [ 5 : 0] dmaRHDSize                    , // DMA Receive Header Descriptor Size
    output wire [ 5 : 0] dmaTBDSize                    , // DMA Transmit Buffer Descriptor Size
    output wire [ 5 : 0] dmaTHDSize                    , // DMA Transmit Header Descriptor Size
    output wire [ 5 : 0] ptEntrySize                   , // Policy Table Entry Size

    //$port_g DMATHRESHOLDREG register.
    output wire [ 7 : 0] rxFIFOThreshold               , // Receive FIFO Threshold
    output wire [ 7 : 0] txFIFOThreshold               , // Transmit FIFO Threshold

    //$port_g RXHEADERTFPTRREG register.

    //$port_g RXBUF1STARTPTRREG register.
    output wire [30 : 0] rxBuf1StartPtr                , // DMA Receive buffer 1 start address Pointer

    //$port_g RXBUF1ENDPTRREG register.
    output wire [30 : 0] rxBuf1EndPtr                  , // DMA Receive buffer 1 end address Pointer

    //$port_g RXBUF1RDPTRREG register.
    output wire [31 : 0] rxBuf1RdPtr                   , // DMA Receive buffer 1 read Pointer

    //$port_g RXBUF1WRPTRREG register.
    output wire [31 : 0] rxBuf1WrPtr                   , // DMA Receive buffer 1 write Pointer

    //$port_g RXBUF2STARTPTRREG register.
    output wire [30 : 0] rxBuf2StartPtr                , // DMA Receive buffer 2 start address Pointer

    //$port_g RXBUF2ENDPTRREG register.
    output wire [30 : 0] rxBuf2EndPtr                  , // DMA Receive buffer 2 end address Pointer

    //$port_g RXBUF2RDPTRREG register.
    output wire [31 : 0] rxBuf2RdPtr                   , // DMA Receive buffer 2 read Pointer

    //$port_g RXBUF2WRPTRREG register.
    output wire [31 : 0] rxBuf2WrPtr                   , // DMA Receive buffer 2 write Pointer

    //$port_g RXBUFCONFIGREG register.
    output wire [ 7 : 0] rxBufRPDFooter                , // DMA RX buffer Receive Payload Descriptor blank space Footer
    output wire [ 7 : 0] rxBufRPDHeader                , // DMA RX buffer Receive Payload Descriptor blank space Header
    output wire [ 7 : 0] rxBufRHDFooter                , // DMA RX buffer Receive Header Descriptor blank space Footer
    output wire [ 7 : 0] rxBufRHDHeader                , // DMA RX buffer Receive Header Descriptor blank space Header

    //$port_g TXHETBINFOREG register.
    output wire [ 3 : 0] maxMCSInHETB                  , // Max MCS in HE TB
    output wire [ 2 : 0] eOCW                          , // Exposent of OFDMA Contention Window
    output wire [ 2 : 0] eOCWMin                       , // Exposent of OFDMA Contention Window Minimum
    output wire          raRUType                      , // Random Access RU Type
    output wire          raRUEnable                    , // Random Access RU Enable
    output wire [ 5 : 0] txHETBMaxDur                  , // HE TB Preparation Max Duration
`ifdef RW_MUMIMO_TX_EN                     

    //$port_g SECUSERSTXINTEVENTSETREG register.
    output wire          setsecU3ac3TxBufTrigger       , // Secondary User 3 AC3 Transmission Buffer Trigger
    output wire          setsecU3ac2TxBufTrigger       , // Secondary User 3 AC2 Transmission Buffer Trigger
    output wire          setsecU3ac1TxBufTrigger       , // Secondary User 3 AC1 Transmission Buffer Trigger
    output wire          setsecU3ac0TxBufTrigger       , // Secondary User 3 AC0 Transmission Buffer Trigger
    output wire          setsecU3ac3TxTrigger          , // Secondary User 3 AC3 Transmission Trigger
    output wire          setsecU3ac2TxTrigger          , // Secondary User 3 AC2 Transmission Trigger
    output wire          setsecU3ac1TxTrigger          , // Secondary User 3 AC1 Transmission Trigger
    output wire          setsecU3ac0TxTrigger          , // Secondary User 3 AC0 Transmission Trigger
    output wire          setsecU2ac3TxBufTrigger       , // Secondary User 2 AC3 Transmission Buffer Trigger
    output wire          setsecU2ac2TxBufTrigger       , // Secondary User 2 AC2 Transmission Buffer Trigger
    output wire          setsecU2ac1TxBufTrigger       , // Secondary User 2 AC1 Transmission Buffer Trigger
    output wire          setsecU2ac0TxBufTrigger       , // Secondary User 2 AC0 Transmission Buffer Trigger
    output wire          setsecU2ac3TxTrigger          , // Secondary User 2 AC3 Transmission Trigger
    output wire          setsecU2ac2TxTrigger          , // Secondary User 2 AC2 Transmission Trigger
    output wire          setsecU2ac1TxTrigger          , // Secondary User 2 AC1 Transmission Trigger
    output wire          setsecU2ac0TxTrigger          , // Secondary User 2 AC0 Transmission Trigger
    output wire          setsecU1ac3TxBufTrigger       , // Secondary User 1 AC3 Transmission Buffer Trigger
    output wire          setsecU1ac2TxBufTrigger       , // Secondary User 1 AC2 Transmission Buffer Trigger
    output wire          setsecU1ac1TxBufTrigger       , // Secondary User 1 AC1 Transmission Buffer Trigger
    output wire          setsecU1ac0TxBufTrigger       , // Secondary User 1 AC0 Transmission Buffer Trigger
    output wire          setsecU1ac3TxTrigger          , // Secondary User 1 AC3 Transmission Trigger
    output wire          setsecU1ac2TxTrigger          , // Secondary User 1 AC2 Transmission Trigger
    output wire          setsecU1ac1TxTrigger          , // Secondary User 1 AC1 Transmission Trigger
    output wire          setsecU1ac0TxTrigger          , // Secondary User 1 AC0 Transmission Trigger

    //$port_g SECUSERSTXINTEVENTCLEARREG register.
    output wire          clearsecU3ac3TxBufTrigger     , // Secondary User 3 AC3 Transmission Buffer Trigger
    output wire          clearsecU3ac2TxBufTrigger     , // Secondary User 3 AC2 Transmission Buffer Trigger
    output wire          clearsecU3ac1TxBufTrigger     , // Secondary User 3 AC1 Transmission Buffer Trigger
    output wire          clearsecU3ac0TxBufTrigger     , // Secondary User 3 AC0 Transmission Buffer Trigger
    output wire          clearsecU3ac3TxTrigger        , // Secondary User 3 AC3 Transmission Trigger
    output wire          clearsecU3ac2TxTrigger        , // Secondary User 3 AC2 Transmission Trigger
    output wire          clearsecU3ac1TxTrigger        , // Secondary User 3 AC1 Transmission Trigger
    output wire          clearsecU3ac0TxTrigger        , // Secondary User 3 AC0 Transmission Trigger
    output wire          clearsecU2ac3TxBufTrigger     , // Secondary User 2 AC3 Transmission Buffer Trigger
    output wire          clearsecU2ac2TxBufTrigger     , // Secondary User 2 AC2 Transmission Buffer Trigger
    output wire          clearsecU2ac1TxBufTrigger     , // Secondary User 2 AC1 Transmission Buffer Trigger
    output wire          clearsecU2ac0TxBufTrigger     , // Secondary User 2 AC0 Transmission Buffer Trigger
    output wire          clearsecU2ac3TxTrigger        , // Secondary User 2 AC3 Transmission Trigger
    output wire          clearsecU2ac2TxTrigger        , // Secondary User 2 AC2 Transmission Trigger
    output wire          clearsecU2ac1TxTrigger        , // Secondary User 2 AC1 Transmission Trigger
    output wire          clearsecU2ac0TxTrigger        , // Secondary User 2 AC0 Transmission Trigger
    output wire          clearsecU1ac3TxBufTrigger     , // Secondary User 1 AC3 Transmission Buffer Trigger
    output wire          clearsecU1ac2TxBufTrigger     , // Secondary User 1 AC2 Transmission Buffer Trigger
    output wire          clearsecU1ac1TxBufTrigger     , // Secondary User 1 AC1 Transmission Buffer Trigger
    output wire          clearsecU1ac0TxBufTrigger     , // Secondary User 1 AC0 Transmission Buffer Trigger
    output wire          clearsecU1ac3TxTrigger        , // Secondary User 1 AC3 Transmission Trigger
    output wire          clearsecU1ac2TxTrigger        , // Secondary User 1 AC2 Transmission Trigger
    output wire          clearsecU1ac1TxTrigger        , // Secondary User 1 AC1 Transmission Trigger
    output wire          clearsecU1ac0TxTrigger        , // Secondary User 1 AC0 Transmission Trigger

    //$port_g SECUSERSTXINTEVENTUNMASKREG register.
    output wire          masterSecUsersTxIntEn         , // Master Secondary Users Tx Interrupt Enable
    output wire          masksecU3ac3TxBufTrigger      , // Secondary User 3 AC3 Transmission Buffer Trigger
    output wire          masksecU3ac2TxBufTrigger      , // Secondary User 3 AC2 Transmission Buffer Trigger
    output wire          masksecU3ac1TxBufTrigger      , // Secondary User 3 AC1 Transmission Buffer Trigger
    output wire          masksecU3ac0TxBufTrigger      , // Secondary User 3 AC0 Transmission Buffer Trigger
    output wire          masksecU3ac3TxTrigger         , // Secondary User 3 AC3 Transmission Trigger
    output wire          masksecU3ac2TxTrigger         , // Secondary User 3 AC2 Transmission Trigger
    output wire          masksecU3ac1TxTrigger         , // Secondary User 3 AC1 Transmission Trigger
    output wire          masksecU3ac0TxTrigger         , // Secondary User 3 AC0 Transmission Trigger
    output wire          masksecU2ac3TxBufTrigger      , // Secondary User 2 AC3 Transmission Buffer Trigger
    output wire          masksecU2ac2TxBufTrigger      , // Secondary User 2 AC2 Transmission Buffer Trigger
    output wire          masksecU2ac1TxBufTrigger      , // Secondary User 2 AC1 Transmission Buffer Trigger
    output wire          masksecU2ac0TxBufTrigger      , // Secondary User 2 AC0 Transmission Buffer Trigger
    output wire          masksecU2ac3TxTrigger         , // Secondary User 2 AC3 Transmission Trigger
    output wire          masksecU2ac2TxTrigger         , // Secondary User 2 AC2 Transmission Trigger
    output wire          masksecU2ac1TxTrigger         , // Secondary User 2 AC1 Transmission Trigger
    output wire          masksecU2ac0TxTrigger         , // Secondary User 2 AC0 Transmission Trigger
    output wire          masksecU1ac3TxBufTrigger      , // Secondary User 1 AC3 Transmission Buffer Trigger
    output wire          masksecU1ac2TxBufTrigger      , // Secondary User 1 AC2 Transmission Buffer Trigger
    output wire          masksecU1ac1TxBufTrigger      , // Secondary User 1 AC1 Transmission Buffer Trigger
    output wire          masksecU1ac0TxBufTrigger      , // Secondary User 1 AC0 Transmission Buffer Trigger
    output wire          masksecU1ac3TxTrigger         , // Secondary User 1 AC3 Transmission Trigger
    output wire          masksecU1ac2TxTrigger         , // Secondary User 1 AC2 Transmission Trigger
    output wire          masksecU1ac1TxTrigger         , // Secondary User 1 AC1 Transmission Trigger
    output wire          masksecU1ac0TxTrigger         , // Secondary User 1 AC0 Transmission Trigger
`endif // RW_MUMIMO_TX_EN                     

    //$port_g DEBUGTBSPTRREG register.

    //$port_g SWPROFILINGREG register.
    output wire          swProf31                      , // Software Profiling value
    output wire          swProf30                      , // Software Profiling value
    output wire          swProf29                      , // Software Profiling value
    output wire          swProf28                      , // Software Profiling value
    output wire          swProf27                      , // Software Profiling value
    output wire          swProf26                      , // Software Profiling value
    output wire          swProf25                      , // Software Profiling value
    output wire          swProf24                      , // Software Profiling value
    output wire          swProf23                      , // Software Profiling value
    output wire          swProf22                      , // Software Profiling value
    output wire          swProf21                      , // Software Profiling value
    output wire          swProf20                      , // Software Profiling value
    output wire          swProf19                      , // Software Profiling value
    output wire          swProf18                      , // Software Profiling value
    output wire          swProf17                      , // Software Profiling value
    output wire          swProf16                      , // Software Profiling value
    output wire          swProf15                      , // Software Profiling value
    output wire          swProf14                      , // Software Profiling value
    output wire          swProf13                      , // Software Profiling value
    output wire          swProf12                      , // Software Profiling value
    output wire          swProf11                      , // Software Profiling value
    output wire          swProf10                      , // Software Profiling value
    output wire          swProf9                       , // Software Profiling value
    output wire          swProf8                       , // Software Profiling value
    output wire          swProf7                       , // Software Profiling value
    output wire          swProf6                       , // Software Profiling value
    output wire          swProf5                       , // Software Profiling value
    output wire          swProf4                       , // Software Profiling value
    output wire          swProf3                       , // Software Profiling value
    output wire          swProf2                       , // Software Profiling value
    output wire          swProf1                       , // Software Profiling value
    output wire          swProf0                       , // Software Profiling value

    //$port_g SWSETPROFILINGREG register.
    output wire          swSetProf31                   , // Software Profiling Set Bit
    output wire          swSetProf30                   , // Software Profiling Set Bit
    output wire          swSetProf29                   , // Software Profiling Set Bit
    output wire          swSetProf28                   , // Software Profiling Set Bit
    output wire          swSetProf27                   , // Software Profiling Set Bit
    output wire          swSetProf26                   , // Software Profiling Set Bit
    output wire          swSetProf25                   , // Software Profiling Set Bit
    output wire          swSetProf24                   , // Software Profiling Set Bit
    output wire          swSetProf23                   , // Software Profiling Set Bit
    output wire          swSetProf22                   , // Software Profiling Set Bit
    output wire          swSetProf21                   , // Software Profiling Set Bit
    output wire          swSetProf20                   , // Software Profiling Set Bit
    output wire          swSetProf19                   , // Software Profiling Set Bit
    output wire          swSetProf18                   , // Software Profiling Set Bit
    output wire          swSetProf17                   , // Software Profiling Set Bit
    output wire          swSetProf16                   , // Software Profiling Set Bit
    output wire          swSetProf15                   , // Software Profiling Set Bit
    output wire          swSetProf14                   , // Software Profiling Set Bit
    output wire          swSetProf13                   , // Software Profiling Set Bit
    output wire          swSetProf12                   , // Software Profiling Set Bit
    output wire          swSetProf11                   , // Software Profiling Set Bit
    output wire          swSetProf10                   , // Software Profiling Set Bit
    output wire          swSetProf9                    , // Software Profiling Set Bit
    output wire          swSetProf8                    , // Software Profiling Set Bit
    output wire          swSetProf7                    , // Software Profiling Set Bit
    output wire          swSetProf6                    , // Software Profiling Set Bit
    output wire          swSetProf5                    , // Software Profiling Set Bit
    output wire          swSetProf4                    , // Software Profiling Set Bit
    output wire          swSetProf3                    , // Software Profiling Set Bit
    output wire          swSetProf2                    , // Software Profiling Set Bit
    output wire          swSetProf1                    , // Software Profiling Set Bit
    output wire          swSetProf0                    , // Software Profiling Set Bit

    //$port_g SWCLEARPROFILINGREG register.
    output wire          swClearProf31                 , // Software Profiling Clear Bit
    output wire          swClearProf30                 , // Software Profiling Clear Bit
    output wire          swClearProf29                 , // Software Profiling Clear Bit
    output wire          swClearProf28                 , // Software Profiling Clear Bit
    output wire          swClearProf27                 , // Software Profiling Clear Bit
    output wire          swClearProf26                 , // Software Profiling Clear Bit
    output wire          swClearProf25                 , // Software Profiling Clear Bit
    output wire          swClearProf24                 , // Software Profiling Clear Bit
    output wire          swClearProf23                 , // Software Profiling Clear Bit
    output wire          swClearProf22                 , // Software Profiling Clear Bit
    output wire          swClearProf21                 , // Software Profiling Clear Bit
    output wire          swClearProf20                 , // Software Profiling Clear Bit
    output wire          swClearProf19                 , // Software Profiling Clear Bit
    output wire          swClearProf18                 , // Software Profiling Clear Bit
    output wire          swClearProf17                 , // Software Profiling Clear Bit
    output wire          swClearProf16                 , // Software Profiling Clear Bit
    output wire          swClearProf15                 , // Software Profiling Clear Bit
    output wire          swClearProf14                 , // Software Profiling Clear Bit
    output wire          swClearProf13                 , // Software Profiling Clear Bit
    output wire          swClearProf12                 , // Software Profiling Clear Bit
    output wire          swClearProf11                 , // Software Profiling Clear Bit
    output wire          swClearProf10                 , // Software Profiling Clear Bit
    output wire          swClearProf9                  , // Software Profiling Clear Bit
    output wire          swClearProf8                  , // Software Profiling Clear Bit
    output wire          swClearProf7                  , // Software Profiling Clear Bit
    output wire          swClearProf6                  , // Software Profiling Clear Bit
    output wire          swClearProf5                  , // Software Profiling Clear Bit
    output wire          swClearProf4                  , // Software Profiling Clear Bit
    output wire          swClearProf3                  , // Software Profiling Clear Bit
    output wire          swClearProf2                  , // Software Profiling Clear Bit
    output wire          swClearProf1                  , // Software Profiling Clear Bit
    output wire          swClearProf0                  , // Software Profiling Clear Bit

    //$port_g SWPROFILINGREG2 register.
    output wire          swProf63                      , // Software Profiling value
    output wire          swProf62                      , // Software Profiling value
    output wire          swProf61                      , // Software Profiling value
    output wire          swProf60                      , // Software Profiling value
    output wire          swProf59                      , // Software Profiling value
    output wire          swProf58                      , // Software Profiling value
    output wire          swProf57                      , // Software Profiling value
    output wire          swProf56                      , // Software Profiling value
    output wire          swProf55                      , // Software Profiling value
    output wire          swProf54                      , // Software Profiling value
    output wire          swProf53                      , // Software Profiling value
    output wire          swProf52                      , // Software Profiling value
    output wire          swProf51                      , // Software Profiling value
    output wire          swProf50                      , // Software Profiling value
    output wire          swProf49                      , // Software Profiling value
    output wire          swProf48                      , // Software Profiling value
    output wire          swProf47                      , // Software Profiling value
    output wire          swProf46                      , // Software Profiling value
    output wire          swProf45                      , // Software Profiling value
    output wire          swProf44                      , // Software Profiling value
    output wire          swProf43                      , // Software Profiling value
    output wire          swProf42                      , // Software Profiling value
    output wire          swProf41                      , // Software Profiling value
    output wire          swProf40                      , // Software Profiling value
    output wire          swProf39                      , // Software Profiling value
    output wire          swProf38                      , // Software Profiling value
    output wire          swProf37                      , // Software Profiling value
    output wire          swProf36                      , // Software Profiling value
    output wire          swProf35                      , // Software Profiling value
    output wire          swProf34                      , // Software Profiling value
    output wire          swProf33                      , // Software Profiling value
    output wire          swProf32                      , // Software Profiling value

    //$port_g SWSETPROFILINGREG2 register.
    output wire          swSetProf63                   , // Software Profiling Set Bit
    output wire          swSetProf62                   , // Software Profiling Set Bit
    output wire          swSetProf61                   , // Software Profiling Set Bit
    output wire          swSetProf60                   , // Software Profiling Set Bit
    output wire          swSetProf59                   , // Software Profiling Set Bit
    output wire          swSetProf58                   , // Software Profiling Set Bit
    output wire          swSetProf57                   , // Software Profiling Set Bit
    output wire          swSetProf56                   , // Software Profiling Set Bit
    output wire          swSetProf55                   , // Software Profiling Set Bit
    output wire          swSetProf54                   , // Software Profiling Set Bit
    output wire          swSetProf53                   , // Software Profiling Set Bit
    output wire          swSetProf52                   , // Software Profiling Set Bit
    output wire          swSetProf51                   , // Software Profiling Set Bit
    output wire          swSetProf50                   , // Software Profiling Set Bit
    output wire          swSetProf49                   , // Software Profiling Set Bit
    output wire          swSetProf48                   , // Software Profiling Set Bit
    output wire          swSetProf47                   , // Software Profiling Set Bit
    output wire          swSetProf46                   , // Software Profiling Set Bit
    output wire          swSetProf45                   , // Software Profiling Set Bit
    output wire          swSetProf44                   , // Software Profiling Set Bit
    output wire          swSetProf43                   , // Software Profiling Set Bit
    output wire          swSetProf42                   , // Software Profiling Set Bit
    output wire          swSetProf41                   , // Software Profiling Set Bit
    output wire          swSetProf40                   , // Software Profiling Set Bit
    output wire          swSetProf39                   , // Software Profiling Set Bit
    output wire          swSetProf38                   , // Software Profiling Set Bit
    output wire          swSetProf37                   , // Software Profiling Set Bit
    output wire          swSetProf36                   , // Software Profiling Set Bit
    output wire          swSetProf35                   , // Software Profiling Set Bit
    output wire          swSetProf34                   , // Software Profiling Set Bit
    output wire          swSetProf33                   , // Software Profiling Set Bit
    output wire          swSetProf32                   , // Software Profiling Set Bit

    //$port_g SWCLEARPROFILINGREG2 register.
    output wire          swClearProf63                 , // Software Profiling Clear Bit
    output wire          swClearProf62                 , // Software Profiling Clear Bit
    output wire          swClearProf61                 , // Software Profiling Clear Bit
    output wire          swClearProf60                 , // Software Profiling Clear Bit
    output wire          swClearProf59                 , // Software Profiling Clear Bit
    output wire          swClearProf58                 , // Software Profiling Clear Bit
    output wire          swClearProf57                 , // Software Profiling Clear Bit
    output wire          swClearProf56                 , // Software Profiling Clear Bit
    output wire          swClearProf55                 , // Software Profiling Clear Bit
    output wire          swClearProf54                 , // Software Profiling Clear Bit
    output wire          swClearProf53                 , // Software Profiling Clear Bit
    output wire          swClearProf52                 , // Software Profiling Clear Bit
    output wire          swClearProf51                 , // Software Profiling Clear Bit
    output wire          swClearProf50                 , // Software Profiling Clear Bit
    output wire          swClearProf49                 , // Software Profiling Clear Bit
    output wire          swClearProf48                 , // Software Profiling Clear Bit
    output wire          swClearProf47                 , // Software Profiling Clear Bit
    output wire          swClearProf46                 , // Software Profiling Clear Bit
    output wire          swClearProf45                 , // Software Profiling Clear Bit
    output wire          swClearProf44                 , // Software Profiling Clear Bit
    output wire          swClearProf43                 , // Software Profiling Clear Bit
    output wire          swClearProf42                 , // Software Profiling Clear Bit
    output wire          swClearProf41                 , // Software Profiling Clear Bit
    output wire          swClearProf40                 , // Software Profiling Clear Bit
    output wire          swClearProf39                 , // Software Profiling Clear Bit
    output wire          swClearProf38                 , // Software Profiling Clear Bit
    output wire          swClearProf37                 , // Software Profiling Clear Bit
    output wire          swClearProf36                 , // Software Profiling Clear Bit
    output wire          swClearProf35                 , // Software Profiling Clear Bit
    output wire          swClearProf34                 , // Software Profiling Clear Bit
    output wire          swClearProf33                 , // Software Profiling Clear Bit
    output wire          swClearProf32                 , // Software Profiling Clear Bit
`ifdef RW_MUMIMO_SEC_USER1_EN              
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              
`endif // RW_MUMIMO_SEC_USER3_EN              

    ////////////////////////////////////////////
    //$port_g APB slave
    ////////////////////////////////////////////
    input wire           regSel            , // Device select.
    input wire           regWrite          , // Defines the enable cycle.
    input wire           regRead           , // Write signal.
    output wire          latchNextState_p  , // Next state latch
    input wire [12 : 0]  regAddr           , // Address.
    input wire [31 : 0]  regWriteData      , // Write data.
    // 
    output reg [31 : 0]  regReadData         // Read data.

    
  );
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////
 
//////////////////////////////////////////////////////////////////////////////
// Constants for registers addresses
//////////////////////////////////////////////////////////////////////////////

  // Constants for register addresses.
localparam NEXTTBTTREG_ADDR_CT                  = 13'b000000010000;
localparam DOZECNTRL2REG_ADDR_CT                = 13'b000000010010;
localparam MACCNTRL2REG_ADDR_CT                 = 13'b000000010100;
localparam GENINTEVENTSETREG_ADDR_CT            = 13'b000000011011;
localparam GENINTEVENTCLEARREG_ADDR_CT          = 13'b000000011100;
localparam GENINTUNMASKREG_ADDR_CT              = 13'b000000011101;
localparam TXRXINTEVENTSETREG_ADDR_CT           = 13'b000000011110;
localparam TXRXINTEVENTCLEARREG_ADDR_CT         = 13'b000000011111;
localparam TXRXINTUNMASKREG_ADDR_CT             = 13'b000000100000;
localparam TIMERSINTEVENTSETREG_ADDR_CT         = 13'b000000100001;
localparam TIMERSINTEVENTCLEARREG_ADDR_CT       = 13'b000000100010;
localparam TIMERSINTUNMASKREG_ADDR_CT           = 13'b000000100011;
localparam TSFLOREG_ADDR_CT                     = 13'b000000101001;
localparam TSFHIREG_ADDR_CT                     = 13'b000000101010;
localparam TIMEONAIRPARAM1REG_ADDR_CT           = 13'b000001011000;
localparam TIMEONAIRPARAM2REG_ADDR_CT           = 13'b000001011001;
localparam TIMEONAIRPARAM3REG_ADDR_CT           = 13'b000001011010;
localparam TIMEONAIRVALUEREG_ADDR_CT            = 13'b000001011011;
localparam DMACNTRLSETREG_ADDR_CT               = 13'b000001100000;
localparam DMACNTRLCLEARREG_ADDR_CT             = 13'b000001100001;
localparam DMASTATUS1REG_ADDR_CT                = 13'b000001100010;
localparam DMASTATUS2REG_ADDR_CT                = 13'b000001100011;
localparam DMASTATUS3REG_ADDR_CT                = 13'b000001100100;
localparam DMASTATUS4REG_ADDR_CT                = 13'b000001100101;
localparam TXBCNHEADPTRREG_ADDR_CT              = 13'b000001100110;
localparam TXAC0HEADPTRREG_ADDR_CT              = 13'b000001100111;
localparam TXAC1HEADPTRREG_ADDR_CT              = 13'b000001101000;
localparam TXAC2HEADPTRREG_ADDR_CT              = 13'b000001101001;
localparam TXAC3HEADPTRREG_ADDR_CT              = 13'b000001101010;
localparam TXTBHEADPTRREG_ADDR_CT               = 13'b000001101011;
localparam TXSTRUCTSIZESREG_ADDR_CT             = 13'b000001101100;
localparam DMATHRESHOLDREG_ADDR_CT              = 13'b000001110000;
localparam RXHEADERTFPTRREG_ADDR_CT             = 13'b000001110001;
localparam RXBUF1STARTPTRREG_ADDR_CT            = 13'b000001110010;
localparam RXBUF1ENDPTRREG_ADDR_CT              = 13'b000001110011;
localparam RXBUF1RDPTRREG_ADDR_CT               = 13'b000001110100;
localparam RXBUF1WRPTRREG_ADDR_CT               = 13'b000001110101;
localparam RXBUF2STARTPTRREG_ADDR_CT            = 13'b000001110110;
localparam RXBUF2ENDPTRREG_ADDR_CT              = 13'b000001110111;
localparam RXBUF2RDPTRREG_ADDR_CT               = 13'b000001111000;
localparam RXBUF2WRPTRREG_ADDR_CT               = 13'b000001111001;
localparam RXBUFCONFIGREG_ADDR_CT               = 13'b000001111010;
localparam MOT1REG_ADDR_CT                      = 13'b000010001010;
localparam MOT2REG_ADDR_CT                      = 13'b000010001011;
localparam TXBWDROPINFOREG_ADDR_CT              = 13'b000011001100;
localparam TXHETBINFOREG_ADDR_CT                = 13'b000011010101;
localparam RXHETRIGCOMMONINFOREG_ADDR_CT        = 13'b000011010110;
localparam RXHETRIGUSERINFOREG_ADDR_CT          = 13'b000011010111;
localparam RXHETRIGPSDULENREG_ADDR_CT           = 13'b000011011000;
localparam RXHETRIGPWRINFOREG_ADDR_CT           = 13'b000011011001;
`ifdef RW_MUMIMO_TX_EN                     
localparam SECUSERSTXINTEVENTSETREG_ADDR_CT     = 13'b000011011010;
localparam SECUSERSTXINTEVENTCLEARREG_ADDR_CT   = 13'b000011011011;
localparam SECUSERSTXINTEVENTUNMASKREG_ADDR_CT  = 13'b000011011100;
`endif // RW_MUMIMO_TX_EN                     
localparam DEBUGBCNSPTRREG_ADDR_CT              = 13'b000101001001;
localparam DEBUGAC0SPTRREG_ADDR_CT              = 13'b000101001010;
localparam DEBUGAC1SPTRREG_ADDR_CT              = 13'b000101001011;
localparam DEBUGAC2SPTRREG_ADDR_CT              = 13'b000101001100;
localparam DEBUGAC3SPTRREG_ADDR_CT              = 13'b000101001101;
localparam DEBUGTBSPTRREG_ADDR_CT               = 13'b000101001110;
localparam DEBUGTXCPTRREG_ADDR_CT               = 13'b000101010000;
localparam SWPROFILINGREG_ADDR_CT               = 13'b000101011000;
localparam SWSETPROFILINGREG_ADDR_CT            = 13'b000101011001;
localparam SWCLEARPROFILINGREG_ADDR_CT          = 13'b000101011010;
localparam SWPROFILINGREG2_ADDR_CT              = 13'b000101011011;
localparam SWSETPROFILINGREG2_ADDR_CT           = 13'b000101011100;
localparam SWCLEARPROFILINGREG2_ADDR_CT         = 13'b000101011101;
`ifdef RW_MUMIMO_SEC_USER1_EN              
localparam DEBUGSECU1TXCPTRREG_ADDR_CT          = 13'b000101100100;
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              
localparam DEBUGSECU2TXCPTRREG_ADDR_CT          = 13'b000101100101;
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              
localparam DEBUGSECU3TXCPTRREG_ADDR_CT          = 13'b000101100110;
`endif // RW_MUMIMO_SEC_USER3_EN              

//////////////////////////////////////////////////////////////////////////////
// Signals
//////////////////////////////////////////////////////////////////////////////
  // dozeCntrl2Reg register.
  reg          int_wakeUpFromDoze            ;
  reg          int_wakeUpSW                  ;
  // macCntrl2Reg register.
  reg          int_softReset                 ;
  reg          int_settbTxDMADead            ;
  reg          int_setrxPayloadDMADead       ;
  reg          int_setrxHeaderDMADead        ;
  reg          int_setphyRxStart             ;
  reg          int_setphyErr                 ;
  reg          int_setmacPHYIFUnderRun       ;
  reg          int_sethwErr                  ;
  reg          int_setimpSecDTIM             ;
  reg          int_setimpPriDTIM             ;
  reg          int_setbcnTxDMADead           ;
  reg          int_setac3TxDMADead           ;
  reg          int_setac2TxDMADead           ;
  reg          int_setac1TxDMADead           ;
  reg          int_setac0TxDMADead           ;
  reg          int_setptError                ;
  reg          int_settimSet                 ;
  reg          int_setolbcDSSS               ;
  reg          int_setolbcOFDM               ;
  reg          int_setrxFIFOOverFlow         ;
  reg          int_setmacPHYIFOverflow       ;
  reg          int_setcoexEvent              ;
  reg          int_absGenTimers              ;
  reg          int_setidleInterrupt          ;
  reg          int_setimpSecTBTT             ;
  reg          int_setimpPriTBTT             ;
  reg          int_cleartbTxDMADead          ;
  reg          int_clearrxPayloadDMADead     ;
  reg          int_clearrxHeaderDMADead      ;
  reg          int_clearphyRxStart           ;
  reg          int_clearphyErr               ;
  reg          int_clearmacPHYIFUnderRun     ;
  reg          int_clearhwErr                ;
  reg          int_clearimpSecDTIM           ;
  reg          int_clearimpPriDTIM           ;
  reg          int_clearbcnTxDMADead         ;
  reg          int_clearac3TxDMADead         ;
  reg          int_clearac2TxDMADead         ;
  reg          int_clearac1TxDMADead         ;
  reg          int_clearac0TxDMADead         ;
  reg          int_clearptError              ;
  reg          int_cleartimSet               ;
  reg          int_clearolbcDSSS             ;
  reg          int_clearolbcOFDM             ;
  reg          int_clearrxFIFOOverFlow       ;
  reg          int_clearmacPHYIFOverflow     ;
  reg          int_clearcoexEvent            ;
  reg          int_clearidleInterrupt        ;
  reg          int_clearimpSecTBTT           ;
  reg          int_clearimpPriTBTT           ;
  // genIntUnMaskReg register.
  reg          int_masterGenIntEn            ;
  reg          int_masktbTxDMADead           ;
  reg          int_maskrxPayloadDMADead      ;
  reg          int_maskrxHeaderDMADead       ;
  reg          int_maskphyRxStart            ;
  reg          int_maskphyErr                ;
  reg          int_maskmacPHYIFUnderRun      ;
  reg          int_maskhwErr                 ;
  reg          int_maskimpSecDTIM            ;
  reg          int_maskimpPriDTIM            ;
  reg          int_maskbcnTxDMADead          ;
  reg          int_maskac3TxDMADead          ;
  reg          int_maskac2TxDMADead          ;
  reg          int_maskac1TxDMADead          ;
  reg          int_maskac0TxDMADead          ;
  reg          int_maskptError               ;
  reg          int_masktimSet                ;
  reg          int_maskolbcDSSS              ;
  reg          int_maskolbcOFDM              ;
  reg          int_maskrxFIFOOverFlow        ;
  reg          int_maskmacPHYIFOverflow      ;
  reg          int_maskcoexEvent             ;
  reg          int_maskabsGenTimers          ;
  reg          int_maskidleInterrupt         ;
  reg          int_maskimpSecTBTT            ;
  reg          int_maskimpPriTBTT            ;
  reg          int_settbTxBufTrigger         ;
  reg          int_setbcnTxBufTrigger        ;
  reg          int_setac3TxBufTrigger        ;
  reg          int_setac2TxBufTrigger        ;
  reg          int_setac1TxBufTrigger        ;
  reg          int_setac0TxBufTrigger        ;
  reg          int_setac3BWDropTrigger       ;
  reg          int_setac2BWDropTrigger       ;
  reg          int_setac1BWDropTrigger       ;
  reg          int_setac0BWDropTrigger       ;
  reg          int_setrxBuffer2Trigger       ;
  reg          int_settimerRxTrigger         ;
  reg          int_setrxBuffer1Trigger       ;
  reg          int_setsecUserTxTrigger       ;
  reg          int_settimerTxTrigger         ;
  reg          int_settxopComplete           ;
  reg          int_settbTxCancelled          ;
  reg          int_settbTxTrigger            ;
  reg          int_setbcnTxTrigger           ;
  reg          int_setac3TxTrigger           ;
  reg          int_setac2TxTrigger           ;
  reg          int_setac1TxTrigger           ;
  reg          int_setac0TxTrigger           ;
  reg          int_settbProtTrigger          ;
  reg          int_setac3ProtTrigger         ;
  reg          int_setac2ProtTrigger         ;
  reg          int_setac1ProtTrigger         ;
  reg          int_setac0ProtTrigger         ;
  reg          int_cleartbTxBufTrigger       ;
  reg          int_clearbcnTxBufTrigger      ;
  reg          int_clearac3TxBufTrigger      ;
  reg          int_clearac2TxBufTrigger      ;
  reg          int_clearac1TxBufTrigger      ;
  reg          int_clearac0TxBufTrigger      ;
  reg          int_clearac3BWDropTrigger     ;
  reg          int_clearac2BWDropTrigger     ;
  reg          int_clearac1BWDropTrigger     ;
  reg          int_clearac0BWDropTrigger     ;
  reg          int_clearrxBuffer2Trigger     ;
  reg          int_cleartimerRxTrigger       ;
  reg          int_clearrxBuffer1Trigger     ;
  reg          int_cleartimerTxTrigger       ;
  reg          int_cleartxopComplete         ;
  reg          int_cleartbTxCancelled        ;
  reg          int_cleartbTxTrigger          ;
  reg          int_clearbcnTxTrigger         ;
  reg          int_clearac3TxTrigger         ;
  reg          int_clearac2TxTrigger         ;
  reg          int_clearac1TxTrigger         ;
  reg          int_clearac0TxTrigger         ;
  reg          int_cleartbProtTrigger        ;
  reg          int_clearac3ProtTrigger       ;
  reg          int_clearac2ProtTrigger       ;
  reg          int_clearac1ProtTrigger       ;
  reg          int_clearac0ProtTrigger       ;
  // txRxIntUnMaskReg register.
  reg          int_masterTxRxIntEn           ;
  reg          int_masktbTxBufTrigger        ;
  reg          int_maskbcnTxBufTrigger       ;
  reg          int_maskac3TxBufTrigger       ;
  reg          int_maskac2TxBufTrigger       ;
  reg          int_maskac1TxBufTrigger       ;
  reg          int_maskac0TxBufTrigger       ;
  reg          int_maskac3BWDropTrigger      ;
  reg          int_maskac2BWDropTrigger      ;
  reg          int_maskac1BWDropTrigger      ;
  reg          int_maskac0BWDropTrigger      ;
  reg          int_maskrxBuffer2Trigger      ;
  reg          int_masktimerRxTrigger        ;
  reg          int_maskrxBuffer1Trigger      ;
  reg          int_masksecUserTxTrigger      ;
  reg          int_masktimerTxTrigger        ;
  reg          int_masktxopComplete          ;
  reg          int_masktbTxCancelled         ;
  reg          int_masktbTxTrigger           ;
  reg          int_maskbcnTxTrigger          ;
  reg          int_maskac3TxTrigger          ;
  reg          int_maskac2TxTrigger          ;
  reg          int_maskac1TxTrigger          ;
  reg          int_maskac0TxTrigger          ;
  reg          int_masktbProtTrigger         ;
  reg          int_maskac3ProtTrigger        ;
  reg          int_maskac2ProtTrigger        ;
  reg          int_maskac1ProtTrigger        ;
  reg          int_maskac0ProtTrigger        ;
  reg          int_setabsTimers9             ;
  reg          int_setabsTimers8             ;
  reg          int_setabsTimers7             ;
  reg          int_setabsTimers6             ;
  reg          int_setabsTimers5             ;
  reg          int_setabsTimers4             ;
  reg          int_setabsTimers3             ;
  reg          int_setabsTimers2             ;
  reg          int_setabsTimers1             ;
  reg          int_setabsTimers0             ;
  reg          int_clearabsTimers9           ;
  reg          int_clearabsTimers8           ;
  reg          int_clearabsTimers7           ;
  reg          int_clearabsTimers6           ;
  reg          int_clearabsTimers5           ;
  reg          int_clearabsTimers4           ;
  reg          int_clearabsTimers3           ;
  reg          int_clearabsTimers2           ;
  reg          int_clearabsTimers1           ;
  reg          int_clearabsTimers0           ;
  // timersIntUnMaskReg register.
  reg          int_maskabsTimers9            ;
  reg          int_maskabsTimers8            ;
  reg          int_maskabsTimers7            ;
  reg          int_maskabsTimers6            ;
  reg          int_maskabsTimers5            ;
  reg          int_maskabsTimers4            ;
  reg          int_maskabsTimers3            ;
  reg          int_maskabsTimers2            ;
  reg          int_maskabsTimers1            ;
  reg          int_maskabsTimers0            ;
  // tsfLoReg register.
  reg [31 : 0] int_tsfTimerLow               ;
  // tsfHiReg register.
  reg [31 : 0] int_tsfTimerHigh              ;
  // timeOnAirParam1Reg register.
  reg [ 1 : 0] int_ppduSTBC                  ;
  reg [ 1 : 0] int_ppduNumExtnSS             ;
  reg [ 1 : 0] int_ppduBW                    ;
  reg [ 1 : 0] int_ppduGI                    ;
  reg [ 3 : 0] int_ppduPreType               ;
  reg [19 : 0] int_ppduLength                ;
  // timeOnAirParam2Reg register.
  reg [ 2 : 0] int_ppduNumHeLtf              ;
  reg [ 6 : 0] int_ppduNUser                 ;
  reg [ 2 : 0] int_ppduPE                    ;
  reg [ 2 : 0] int_ppduMCSSigB               ;
  reg          int_ppduDCMSigB               ;
  reg          int_ppduSigBCompMode          ;
  reg [ 1 : 0] int_ppduHELTFType             ;
  reg          int_ppduDCM                   ;
  reg [ 6 : 0] int_ppduMCSIndex              ;
  // timeOnAirParam3Reg register.
  reg [ 2 : 0] int_ppduRuType                ;
  reg          int_ppduMma                   ;
  reg          int_ppduDoppler               ;
  // timeOnAirValueReg register.
  reg          int_computeDuration           ;
  reg          int_sethaltTBAfterTXOP        ;
  reg          int_sethaltAC3AfterTXOP       ;
  reg          int_sethaltAC2AfterTXOP       ;
  reg          int_sethaltAC1AfterTXOP       ;
  reg          int_sethaltAC0AfterTXOP       ;
  reg          int_sethaltBcnAfterTXOP       ;
  reg          int_settxTBNewHead            ;
  reg          int_settxAC3NewHead           ;
  reg          int_settxAC2NewHead           ;
  reg          int_settxAC1NewHead           ;
  reg          int_settxAC0NewHead           ;
  reg          int_settxBcnNewHead           ;
  reg          int_settxAC3NewTail           ;
  reg          int_settxAC2NewTail           ;
  reg          int_settxAC1NewTail           ;
  reg          int_settxAC0NewTail           ;
  reg          int_settxBcnNewTail           ;
  reg          int_clearhaltTBAfterTXOP      ;
  reg          int_clearhaltAC3AfterTXOP     ;
  reg          int_clearhaltAC2AfterTXOP     ;
  reg          int_clearhaltAC1AfterTXOP     ;
  reg          int_clearhaltAC0AfterTXOP     ;
  reg          int_clearhaltBcnAfterTXOP     ;
  reg          int_cleartxTBNewHead          ;
  reg          int_cleartxAC3NewHead         ;
  reg          int_cleartxAC2NewHead         ;
  reg          int_cleartxAC1NewHead         ;
  reg          int_cleartxAC0NewHead         ;
  reg          int_cleartxBcnNewHead         ;
  reg          int_cleartxAC3NewTail         ;
  reg          int_cleartxAC2NewTail         ;
  reg          int_cleartxAC1NewTail         ;
  reg          int_cleartxAC0NewTail         ;
  reg          int_cleartxBcnNewTail         ;
  // txBcnHeadPtrReg register.
  reg [31 : 0] int_txBcnHeadPtr              ;
  // txAC0HeadPtrReg register.
  reg [31 : 0] int_txAC0HeadPtr              ;
  // txAC1HeadPtrReg register.
  reg [31 : 0] int_txAC1HeadPtr              ;
  // txAC2HeadPtrReg register.
  reg [31 : 0] int_txAC2HeadPtr              ;
  // txAC3HeadPtrReg register.
  reg [31 : 0] int_txAC3HeadPtr              ;
  // txTBHeadPtrReg register.
  reg [31 : 0] int_txTBHeadPtr               ;
  // txStructSizesReg register.
  reg [ 5 : 0] int_dmaRBDSize                ;
  reg [ 5 : 0] int_dmaRHDSize                ;
  reg [ 5 : 0] int_dmaTBDSize                ;
  reg [ 5 : 0] int_dmaTHDSize                ;
  reg [ 5 : 0] int_ptEntrySize               ;
  // dmaThresholdReg register.
  reg [ 7 : 0] int_rxFIFOThreshold           ;
  reg [ 7 : 0] int_txFIFOThreshold           ;
  // rxBuf1StartPtrReg register.
  reg [30 : 0] int_rxBuf1StartPtr            ;
  // rxBuf1EndPtrReg register.
  reg [30 : 0] int_rxBuf1EndPtr              ;
  // rxBuf1RdPtrReg register.
  reg [31 : 0] int_rxBuf1RdPtr               ;
  // rxBuf1WrPtrReg register.
  reg [31 : 0] int_rxBuf1WrPtr               ;
  // rxBuf2StartPtrReg register.
  reg [30 : 0] int_rxBuf2StartPtr            ;
  // rxBuf2EndPtrReg register.
  reg [30 : 0] int_rxBuf2EndPtr              ;
  // rxBuf2RdPtrReg register.
  reg [31 : 0] int_rxBuf2RdPtr               ;
  // rxBuf2WrPtrReg register.
  reg [31 : 0] int_rxBuf2WrPtr               ;
  // rxBufConfigReg register.
  reg [ 7 : 0] int_rxBufRPDFooter            ;
  reg [ 7 : 0] int_rxBufRPDHeader            ;
  reg [ 7 : 0] int_rxBufRHDFooter            ;
  reg [ 7 : 0] int_rxBufRHDHeader            ;
  // txHETBInfoReg register.
  reg [ 3 : 0] int_maxMCSInHETB              ;
  reg [ 2 : 0] int_eOCW                      ;
  reg [ 2 : 0] int_eOCWMin                   ;
  reg          int_raRUType                  ;
  reg          int_raRUEnable                ;
  reg [ 5 : 0] int_txHETBMaxDur              ;
`ifdef RW_MUMIMO_TX_EN                     
  reg          int_setsecU3ac3TxBufTrigger   ;
  reg          int_setsecU3ac2TxBufTrigger   ;
  reg          int_setsecU3ac1TxBufTrigger   ;
  reg          int_setsecU3ac0TxBufTrigger   ;
  reg          int_setsecU3ac3TxTrigger      ;
  reg          int_setsecU3ac2TxTrigger      ;
  reg          int_setsecU3ac1TxTrigger      ;
  reg          int_setsecU3ac0TxTrigger      ;
  reg          int_setsecU2ac3TxBufTrigger   ;
  reg          int_setsecU2ac2TxBufTrigger   ;
  reg          int_setsecU2ac1TxBufTrigger   ;
  reg          int_setsecU2ac0TxBufTrigger   ;
  reg          int_setsecU2ac3TxTrigger      ;
  reg          int_setsecU2ac2TxTrigger      ;
  reg          int_setsecU2ac1TxTrigger      ;
  reg          int_setsecU2ac0TxTrigger      ;
  reg          int_setsecU1ac3TxBufTrigger   ;
  reg          int_setsecU1ac2TxBufTrigger   ;
  reg          int_setsecU1ac1TxBufTrigger   ;
  reg          int_setsecU1ac0TxBufTrigger   ;
  reg          int_setsecU1ac3TxTrigger      ;
  reg          int_setsecU1ac2TxTrigger      ;
  reg          int_setsecU1ac1TxTrigger      ;
  reg          int_setsecU1ac0TxTrigger      ;
  reg          int_clearsecU3ac3TxBufTrigger ;
  reg          int_clearsecU3ac2TxBufTrigger ;
  reg          int_clearsecU3ac1TxBufTrigger ;
  reg          int_clearsecU3ac0TxBufTrigger ;
  reg          int_clearsecU3ac3TxTrigger    ;
  reg          int_clearsecU3ac2TxTrigger    ;
  reg          int_clearsecU3ac1TxTrigger    ;
  reg          int_clearsecU3ac0TxTrigger    ;
  reg          int_clearsecU2ac3TxBufTrigger ;
  reg          int_clearsecU2ac2TxBufTrigger ;
  reg          int_clearsecU2ac1TxBufTrigger ;
  reg          int_clearsecU2ac0TxBufTrigger ;
  reg          int_clearsecU2ac3TxTrigger    ;
  reg          int_clearsecU2ac2TxTrigger    ;
  reg          int_clearsecU2ac1TxTrigger    ;
  reg          int_clearsecU2ac0TxTrigger    ;
  reg          int_clearsecU1ac3TxBufTrigger ;
  reg          int_clearsecU1ac2TxBufTrigger ;
  reg          int_clearsecU1ac1TxBufTrigger ;
  reg          int_clearsecU1ac0TxBufTrigger ;
  reg          int_clearsecU1ac3TxTrigger    ;
  reg          int_clearsecU1ac2TxTrigger    ;
  reg          int_clearsecU1ac1TxTrigger    ;
  reg          int_clearsecU1ac0TxTrigger    ;
  // secUsersTxIntEventUnMaskReg register.
  reg          int_masterSecUsersTxIntEn     ;
  reg          int_masksecU3ac3TxBufTrigger  ;
  reg          int_masksecU3ac2TxBufTrigger  ;
  reg          int_masksecU3ac1TxBufTrigger  ;
  reg          int_masksecU3ac0TxBufTrigger  ;
  reg          int_masksecU3ac3TxTrigger     ;
  reg          int_masksecU3ac2TxTrigger     ;
  reg          int_masksecU3ac1TxTrigger     ;
  reg          int_masksecU3ac0TxTrigger     ;
  reg          int_masksecU2ac3TxBufTrigger  ;
  reg          int_masksecU2ac2TxBufTrigger  ;
  reg          int_masksecU2ac1TxBufTrigger  ;
  reg          int_masksecU2ac0TxBufTrigger  ;
  reg          int_masksecU2ac3TxTrigger     ;
  reg          int_masksecU2ac2TxTrigger     ;
  reg          int_masksecU2ac1TxTrigger     ;
  reg          int_masksecU2ac0TxTrigger     ;
  reg          int_masksecU1ac3TxBufTrigger  ;
  reg          int_masksecU1ac2TxBufTrigger  ;
  reg          int_masksecU1ac1TxBufTrigger  ;
  reg          int_masksecU1ac0TxBufTrigger  ;
  reg          int_masksecU1ac3TxTrigger     ;
  reg          int_masksecU1ac2TxTrigger     ;
  reg          int_masksecU1ac1TxTrigger     ;
  reg          int_masksecU1ac0TxTrigger     ;
`endif // RW_MUMIMO_TX_EN                     
  // debugTBSPtrReg register.
  // swProfilingReg register.
  reg          int_swProf31                  ;
  reg          int_swProf30                  ;
  reg          int_swProf29                  ;
  reg          int_swProf28                  ;
  reg          int_swProf27                  ;
  reg          int_swProf26                  ;
  reg          int_swProf25                  ;
  reg          int_swProf24                  ;
  reg          int_swProf23                  ;
  reg          int_swProf22                  ;
  reg          int_swProf21                  ;
  reg          int_swProf20                  ;
  reg          int_swProf19                  ;
  reg          int_swProf18                  ;
  reg          int_swProf17                  ;
  reg          int_swProf16                  ;
  reg          int_swProf15                  ;
  reg          int_swProf14                  ;
  reg          int_swProf13                  ;
  reg          int_swProf12                  ;
  reg          int_swProf11                  ;
  reg          int_swProf10                  ;
  reg          int_swProf9                   ;
  reg          int_swProf8                   ;
  reg          int_swProf7                   ;
  reg          int_swProf6                   ;
  reg          int_swProf5                   ;
  reg          int_swProf4                   ;
  reg          int_swProf3                   ;
  reg          int_swProf2                   ;
  reg          int_swProf1                   ;
  reg          int_swProf0                   ;
  reg          int_swSetProf31               ;
  reg          int_swSetProf30               ;
  reg          int_swSetProf29               ;
  reg          int_swSetProf28               ;
  reg          int_swSetProf27               ;
  reg          int_swSetProf26               ;
  reg          int_swSetProf25               ;
  reg          int_swSetProf24               ;
  reg          int_swSetProf23               ;
  reg          int_swSetProf22               ;
  reg          int_swSetProf21               ;
  reg          int_swSetProf20               ;
  reg          int_swSetProf19               ;
  reg          int_swSetProf18               ;
  reg          int_swSetProf17               ;
  reg          int_swSetProf16               ;
  reg          int_swSetProf15               ;
  reg          int_swSetProf14               ;
  reg          int_swSetProf13               ;
  reg          int_swSetProf12               ;
  reg          int_swSetProf11               ;
  reg          int_swSetProf10               ;
  reg          int_swSetProf9                ;
  reg          int_swSetProf8                ;
  reg          int_swSetProf7                ;
  reg          int_swSetProf6                ;
  reg          int_swSetProf5                ;
  reg          int_swSetProf4                ;
  reg          int_swSetProf3                ;
  reg          int_swSetProf2                ;
  reg          int_swSetProf1                ;
  reg          int_swSetProf0                ;
  reg          int_swClearProf31             ;
  reg          int_swClearProf30             ;
  reg          int_swClearProf29             ;
  reg          int_swClearProf28             ;
  reg          int_swClearProf27             ;
  reg          int_swClearProf26             ;
  reg          int_swClearProf25             ;
  reg          int_swClearProf24             ;
  reg          int_swClearProf23             ;
  reg          int_swClearProf22             ;
  reg          int_swClearProf21             ;
  reg          int_swClearProf20             ;
  reg          int_swClearProf19             ;
  reg          int_swClearProf18             ;
  reg          int_swClearProf17             ;
  reg          int_swClearProf16             ;
  reg          int_swClearProf15             ;
  reg          int_swClearProf14             ;
  reg          int_swClearProf13             ;
  reg          int_swClearProf12             ;
  reg          int_swClearProf11             ;
  reg          int_swClearProf10             ;
  reg          int_swClearProf9              ;
  reg          int_swClearProf8              ;
  reg          int_swClearProf7              ;
  reg          int_swClearProf6              ;
  reg          int_swClearProf5              ;
  reg          int_swClearProf4              ;
  reg          int_swClearProf3              ;
  reg          int_swClearProf2              ;
  reg          int_swClearProf1              ;
  reg          int_swClearProf0              ;
  // swProfilingReg2 register.
  reg          int_swProf63                  ;
  reg          int_swProf62                  ;
  reg          int_swProf61                  ;
  reg          int_swProf60                  ;
  reg          int_swProf59                  ;
  reg          int_swProf58                  ;
  reg          int_swProf57                  ;
  reg          int_swProf56                  ;
  reg          int_swProf55                  ;
  reg          int_swProf54                  ;
  reg          int_swProf53                  ;
  reg          int_swProf52                  ;
  reg          int_swProf51                  ;
  reg          int_swProf50                  ;
  reg          int_swProf49                  ;
  reg          int_swProf48                  ;
  reg          int_swProf47                  ;
  reg          int_swProf46                  ;
  reg          int_swProf45                  ;
  reg          int_swProf44                  ;
  reg          int_swProf43                  ;
  reg          int_swProf42                  ;
  reg          int_swProf41                  ;
  reg          int_swProf40                  ;
  reg          int_swProf39                  ;
  reg          int_swProf38                  ;
  reg          int_swProf37                  ;
  reg          int_swProf36                  ;
  reg          int_swProf35                  ;
  reg          int_swProf34                  ;
  reg          int_swProf33                  ;
  reg          int_swProf32                  ;
  reg          int_swSetProf63               ;
  reg          int_swSetProf62               ;
  reg          int_swSetProf61               ;
  reg          int_swSetProf60               ;
  reg          int_swSetProf59               ;
  reg          int_swSetProf58               ;
  reg          int_swSetProf57               ;
  reg          int_swSetProf56               ;
  reg          int_swSetProf55               ;
  reg          int_swSetProf54               ;
  reg          int_swSetProf53               ;
  reg          int_swSetProf52               ;
  reg          int_swSetProf51               ;
  reg          int_swSetProf50               ;
  reg          int_swSetProf49               ;
  reg          int_swSetProf48               ;
  reg          int_swSetProf47               ;
  reg          int_swSetProf46               ;
  reg          int_swSetProf45               ;
  reg          int_swSetProf44               ;
  reg          int_swSetProf43               ;
  reg          int_swSetProf42               ;
  reg          int_swSetProf41               ;
  reg          int_swSetProf40               ;
  reg          int_swSetProf39               ;
  reg          int_swSetProf38               ;
  reg          int_swSetProf37               ;
  reg          int_swSetProf36               ;
  reg          int_swSetProf35               ;
  reg          int_swSetProf34               ;
  reg          int_swSetProf33               ;
  reg          int_swSetProf32               ;
  reg          int_swClearProf63             ;
  reg          int_swClearProf62             ;
  reg          int_swClearProf61             ;
  reg          int_swClearProf60             ;
  reg          int_swClearProf59             ;
  reg          int_swClearProf58             ;
  reg          int_swClearProf57             ;
  reg          int_swClearProf56             ;
  reg          int_swClearProf55             ;
  reg          int_swClearProf54             ;
  reg          int_swClearProf53             ;
  reg          int_swClearProf52             ;
  reg          int_swClearProf51             ;
  reg          int_swClearProf50             ;
  reg          int_swClearProf49             ;
  reg          int_swClearProf48             ;
  reg          int_swClearProf47             ;
  reg          int_swClearProf46             ;
  reg          int_swClearProf45             ;
  reg          int_swClearProf44             ;
  reg          int_swClearProf43             ;
  reg          int_swClearProf42             ;
  reg          int_swClearProf41             ;
  reg          int_swClearProf40             ;
  reg          int_swClearProf39             ;
  reg          int_swClearProf38             ;
  reg          int_swClearProf37             ;
  reg          int_swClearProf36             ;
  reg          int_swClearProf35             ;
  reg          int_swClearProf34             ;
  reg          int_swClearProf33             ;
  reg          int_swClearProf32             ;
`ifdef RW_MUMIMO_SEC_USER1_EN              
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              
`endif // RW_MUMIMO_SEC_USER3_EN              


//////////////////////////////////////////////////////////////////////////////
// Ouput linkage
//////////////////////////////////////////////////////////////////////////////
   assign wakeUpFromDoze            = int_wakeUpFromDoze            ;
   assign wakeUpSW                  = int_wakeUpSW                  ;
   assign softReset                 = int_softReset                 ;
   assign settbTxDMADead            = int_settbTxDMADead            ;
   assign setrxPayloadDMADead       = int_setrxPayloadDMADead       ;
   assign setrxHeaderDMADead        = int_setrxHeaderDMADead        ;
   assign setphyRxStart             = int_setphyRxStart             ;
   assign setphyErr                 = int_setphyErr                 ;
   assign setmacPHYIFUnderRun       = int_setmacPHYIFUnderRun       ;
   assign sethwErr                  = int_sethwErr                  ;
   assign setimpSecDTIM             = int_setimpSecDTIM             ;
   assign setimpPriDTIM             = int_setimpPriDTIM             ;
   assign setbcnTxDMADead           = int_setbcnTxDMADead           ;
   assign setac3TxDMADead           = int_setac3TxDMADead           ;
   assign setac2TxDMADead           = int_setac2TxDMADead           ;
   assign setac1TxDMADead           = int_setac1TxDMADead           ;
   assign setac0TxDMADead           = int_setac0TxDMADead           ;
   assign setptError                = int_setptError                ;
   assign settimSet                 = int_settimSet                 ;
   assign setolbcDSSS               = int_setolbcDSSS               ;
   assign setolbcOFDM               = int_setolbcOFDM               ;
   assign setrxFIFOOverFlow         = int_setrxFIFOOverFlow         ;
   assign setmacPHYIFOverflow       = int_setmacPHYIFOverflow       ;
   assign setcoexEvent              = int_setcoexEvent              ;
   assign absGenTimers              = int_absGenTimers              ;
   assign setidleInterrupt          = int_setidleInterrupt          ;
   assign setimpSecTBTT             = int_setimpSecTBTT             ;
   assign setimpPriTBTT             = int_setimpPriTBTT             ;
   assign cleartbTxDMADead          = int_cleartbTxDMADead          ;
   assign clearrxPayloadDMADead     = int_clearrxPayloadDMADead     ;
   assign clearrxHeaderDMADead      = int_clearrxHeaderDMADead      ;
   assign clearphyRxStart           = int_clearphyRxStart           ;
   assign clearphyErr               = int_clearphyErr               ;
   assign clearmacPHYIFUnderRun     = int_clearmacPHYIFUnderRun     ;
   assign clearhwErr                = int_clearhwErr                ;
   assign clearimpSecDTIM           = int_clearimpSecDTIM           ;
   assign clearimpPriDTIM           = int_clearimpPriDTIM           ;
   assign clearbcnTxDMADead         = int_clearbcnTxDMADead         ;
   assign clearac3TxDMADead         = int_clearac3TxDMADead         ;
   assign clearac2TxDMADead         = int_clearac2TxDMADead         ;
   assign clearac1TxDMADead         = int_clearac1TxDMADead         ;
   assign clearac0TxDMADead         = int_clearac0TxDMADead         ;
   assign clearptError              = int_clearptError              ;
   assign cleartimSet               = int_cleartimSet               ;
   assign clearolbcDSSS             = int_clearolbcDSSS             ;
   assign clearolbcOFDM             = int_clearolbcOFDM             ;
   assign clearrxFIFOOverFlow       = int_clearrxFIFOOverFlow       ;
   assign clearmacPHYIFOverflow     = int_clearmacPHYIFOverflow     ;
   assign clearcoexEvent            = int_clearcoexEvent            ;
   assign clearidleInterrupt        = int_clearidleInterrupt        ;
   assign clearimpSecTBTT           = int_clearimpSecTBTT           ;
   assign clearimpPriTBTT           = int_clearimpPriTBTT           ;
   assign masterGenIntEn            = int_masterGenIntEn            ;
   assign masktbTxDMADead           = int_masktbTxDMADead           ;
   assign maskrxPayloadDMADead      = int_maskrxPayloadDMADead      ;
   assign maskrxHeaderDMADead       = int_maskrxHeaderDMADead       ;
   assign maskphyRxStart            = int_maskphyRxStart            ;
   assign maskphyErr                = int_maskphyErr                ;
   assign maskmacPHYIFUnderRun      = int_maskmacPHYIFUnderRun      ;
   assign maskhwErr                 = int_maskhwErr                 ;
   assign maskimpSecDTIM            = int_maskimpSecDTIM            ;
   assign maskimpPriDTIM            = int_maskimpPriDTIM            ;
   assign maskbcnTxDMADead          = int_maskbcnTxDMADead          ;
   assign maskac3TxDMADead          = int_maskac3TxDMADead          ;
   assign maskac2TxDMADead          = int_maskac2TxDMADead          ;
   assign maskac1TxDMADead          = int_maskac1TxDMADead          ;
   assign maskac0TxDMADead          = int_maskac0TxDMADead          ;
   assign maskptError               = int_maskptError               ;
   assign masktimSet                = int_masktimSet                ;
   assign maskolbcDSSS              = int_maskolbcDSSS              ;
   assign maskolbcOFDM              = int_maskolbcOFDM              ;
   assign maskrxFIFOOverFlow        = int_maskrxFIFOOverFlow        ;
   assign maskmacPHYIFOverflow      = int_maskmacPHYIFOverflow      ;
   assign maskcoexEvent             = int_maskcoexEvent             ;
   assign maskabsGenTimers          = int_maskabsGenTimers          ;
   assign maskidleInterrupt         = int_maskidleInterrupt         ;
   assign maskimpSecTBTT            = int_maskimpSecTBTT            ;
   assign maskimpPriTBTT            = int_maskimpPriTBTT            ;
   assign settbTxBufTrigger         = int_settbTxBufTrigger         ;
   assign setbcnTxBufTrigger        = int_setbcnTxBufTrigger        ;
   assign setac3TxBufTrigger        = int_setac3TxBufTrigger        ;
   assign setac2TxBufTrigger        = int_setac2TxBufTrigger        ;
   assign setac1TxBufTrigger        = int_setac1TxBufTrigger        ;
   assign setac0TxBufTrigger        = int_setac0TxBufTrigger        ;
   assign setac3BWDropTrigger       = int_setac3BWDropTrigger       ;
   assign setac2BWDropTrigger       = int_setac2BWDropTrigger       ;
   assign setac1BWDropTrigger       = int_setac1BWDropTrigger       ;
   assign setac0BWDropTrigger       = int_setac0BWDropTrigger       ;
   assign setrxBuffer2Trigger       = int_setrxBuffer2Trigger       ;
   assign settimerRxTrigger         = int_settimerRxTrigger         ;
   assign setrxBuffer1Trigger       = int_setrxBuffer1Trigger       ;
   assign setsecUserTxTrigger       = int_setsecUserTxTrigger       ;
   assign settimerTxTrigger         = int_settimerTxTrigger         ;
   assign settxopComplete           = int_settxopComplete           ;
   assign settbTxCancelled          = int_settbTxCancelled          ;
   assign settbTxTrigger            = int_settbTxTrigger            ;
   assign setbcnTxTrigger           = int_setbcnTxTrigger           ;
   assign setac3TxTrigger           = int_setac3TxTrigger           ;
   assign setac2TxTrigger           = int_setac2TxTrigger           ;
   assign setac1TxTrigger           = int_setac1TxTrigger           ;
   assign setac0TxTrigger           = int_setac0TxTrigger           ;
   assign settbProtTrigger          = int_settbProtTrigger          ;
   assign setac3ProtTrigger         = int_setac3ProtTrigger         ;
   assign setac2ProtTrigger         = int_setac2ProtTrigger         ;
   assign setac1ProtTrigger         = int_setac1ProtTrigger         ;
   assign setac0ProtTrigger         = int_setac0ProtTrigger         ;
   assign cleartbTxBufTrigger       = int_cleartbTxBufTrigger       ;
   assign clearbcnTxBufTrigger      = int_clearbcnTxBufTrigger      ;
   assign clearac3TxBufTrigger      = int_clearac3TxBufTrigger      ;
   assign clearac2TxBufTrigger      = int_clearac2TxBufTrigger      ;
   assign clearac1TxBufTrigger      = int_clearac1TxBufTrigger      ;
   assign clearac0TxBufTrigger      = int_clearac0TxBufTrigger      ;
   assign clearac3BWDropTrigger     = int_clearac3BWDropTrigger     ;
   assign clearac2BWDropTrigger     = int_clearac2BWDropTrigger     ;
   assign clearac1BWDropTrigger     = int_clearac1BWDropTrigger     ;
   assign clearac0BWDropTrigger     = int_clearac0BWDropTrigger     ;
   assign clearrxBuffer2Trigger     = int_clearrxBuffer2Trigger     ;
   assign cleartimerRxTrigger       = int_cleartimerRxTrigger       ;
   assign clearrxBuffer1Trigger     = int_clearrxBuffer1Trigger     ;
   assign cleartimerTxTrigger       = int_cleartimerTxTrigger       ;
   assign cleartxopComplete         = int_cleartxopComplete         ;
   assign cleartbTxCancelled        = int_cleartbTxCancelled        ;
   assign cleartbTxTrigger          = int_cleartbTxTrigger          ;
   assign clearbcnTxTrigger         = int_clearbcnTxTrigger         ;
   assign clearac3TxTrigger         = int_clearac3TxTrigger         ;
   assign clearac2TxTrigger         = int_clearac2TxTrigger         ;
   assign clearac1TxTrigger         = int_clearac1TxTrigger         ;
   assign clearac0TxTrigger         = int_clearac0TxTrigger         ;
   assign cleartbProtTrigger        = int_cleartbProtTrigger        ;
   assign clearac3ProtTrigger       = int_clearac3ProtTrigger       ;
   assign clearac2ProtTrigger       = int_clearac2ProtTrigger       ;
   assign clearac1ProtTrigger       = int_clearac1ProtTrigger       ;
   assign clearac0ProtTrigger       = int_clearac0ProtTrigger       ;
   assign masterTxRxIntEn           = int_masterTxRxIntEn           ;
   assign masktbTxBufTrigger        = int_masktbTxBufTrigger        ;
   assign maskbcnTxBufTrigger       = int_maskbcnTxBufTrigger       ;
   assign maskac3TxBufTrigger       = int_maskac3TxBufTrigger       ;
   assign maskac2TxBufTrigger       = int_maskac2TxBufTrigger       ;
   assign maskac1TxBufTrigger       = int_maskac1TxBufTrigger       ;
   assign maskac0TxBufTrigger       = int_maskac0TxBufTrigger       ;
   assign maskac3BWDropTrigger      = int_maskac3BWDropTrigger      ;
   assign maskac2BWDropTrigger      = int_maskac2BWDropTrigger      ;
   assign maskac1BWDropTrigger      = int_maskac1BWDropTrigger      ;
   assign maskac0BWDropTrigger      = int_maskac0BWDropTrigger      ;
   assign maskrxBuffer2Trigger      = int_maskrxBuffer2Trigger      ;
   assign masktimerRxTrigger        = int_masktimerRxTrigger        ;
   assign maskrxBuffer1Trigger      = int_maskrxBuffer1Trigger      ;
   assign masksecUserTxTrigger      = int_masksecUserTxTrigger      ;
   assign masktimerTxTrigger        = int_masktimerTxTrigger        ;
   assign masktxopComplete          = int_masktxopComplete          ;
   assign masktbTxCancelled         = int_masktbTxCancelled         ;
   assign masktbTxTrigger           = int_masktbTxTrigger           ;
   assign maskbcnTxTrigger          = int_maskbcnTxTrigger          ;
   assign maskac3TxTrigger          = int_maskac3TxTrigger          ;
   assign maskac2TxTrigger          = int_maskac2TxTrigger          ;
   assign maskac1TxTrigger          = int_maskac1TxTrigger          ;
   assign maskac0TxTrigger          = int_maskac0TxTrigger          ;
   assign masktbProtTrigger         = int_masktbProtTrigger         ;
   assign maskac3ProtTrigger        = int_maskac3ProtTrigger        ;
   assign maskac2ProtTrigger        = int_maskac2ProtTrigger        ;
   assign maskac1ProtTrigger        = int_maskac1ProtTrigger        ;
   assign maskac0ProtTrigger        = int_maskac0ProtTrigger        ;
   assign setabsTimers9             = int_setabsTimers9             ;
   assign setabsTimers8             = int_setabsTimers8             ;
   assign setabsTimers7             = int_setabsTimers7             ;
   assign setabsTimers6             = int_setabsTimers6             ;
   assign setabsTimers5             = int_setabsTimers5             ;
   assign setabsTimers4             = int_setabsTimers4             ;
   assign setabsTimers3             = int_setabsTimers3             ;
   assign setabsTimers2             = int_setabsTimers2             ;
   assign setabsTimers1             = int_setabsTimers1             ;
   assign setabsTimers0             = int_setabsTimers0             ;
   assign clearabsTimers9           = int_clearabsTimers9           ;
   assign clearabsTimers8           = int_clearabsTimers8           ;
   assign clearabsTimers7           = int_clearabsTimers7           ;
   assign clearabsTimers6           = int_clearabsTimers6           ;
   assign clearabsTimers5           = int_clearabsTimers5           ;
   assign clearabsTimers4           = int_clearabsTimers4           ;
   assign clearabsTimers3           = int_clearabsTimers3           ;
   assign clearabsTimers2           = int_clearabsTimers2           ;
   assign clearabsTimers1           = int_clearabsTimers1           ;
   assign clearabsTimers0           = int_clearabsTimers0           ;
   assign maskabsTimers9            = int_maskabsTimers9            ;
   assign maskabsTimers8            = int_maskabsTimers8            ;
   assign maskabsTimers7            = int_maskabsTimers7            ;
   assign maskabsTimers6            = int_maskabsTimers6            ;
   assign maskabsTimers5            = int_maskabsTimers5            ;
   assign maskabsTimers4            = int_maskabsTimers4            ;
   assign maskabsTimers3            = int_maskabsTimers3            ;
   assign maskabsTimers2            = int_maskabsTimers2            ;
   assign maskabsTimers1            = int_maskabsTimers1            ;
   assign maskabsTimers0            = int_maskabsTimers0            ;
   assign tsfTimerLow               = int_tsfTimerLow               ;
   assign tsfTimerHigh              = int_tsfTimerHigh              ;
   assign ppduSTBC                  = int_ppduSTBC                  ;
   assign ppduNumExtnSS             = int_ppduNumExtnSS             ;
   assign ppduBW                    = int_ppduBW                    ;
   assign ppduGI                    = int_ppduGI                    ;
   assign ppduPreType               = int_ppduPreType               ;
   assign ppduLength                = int_ppduLength                ;
   assign ppduNumHeLtf              = int_ppduNumHeLtf              ;
   assign ppduNUser                 = int_ppduNUser                 ;
   assign ppduPE                    = int_ppduPE                    ;
   assign ppduMCSSigB               = int_ppduMCSSigB               ;
   assign ppduDCMSigB               = int_ppduDCMSigB               ;
   assign ppduSigBCompMode          = int_ppduSigBCompMode          ;
   assign ppduHELTFType             = int_ppduHELTFType             ;
   assign ppduDCM                   = int_ppduDCM                   ;
   assign ppduMCSIndex              = int_ppduMCSIndex              ;
   assign ppduRuType                = int_ppduRuType                ;
   assign ppduMma                   = int_ppduMma                   ;
   assign ppduDoppler               = int_ppduDoppler               ;
   assign computeDuration           = int_computeDuration           ;
   assign sethaltTBAfterTXOP        = int_sethaltTBAfterTXOP        ;
   assign sethaltAC3AfterTXOP       = int_sethaltAC3AfterTXOP       ;
   assign sethaltAC2AfterTXOP       = int_sethaltAC2AfterTXOP       ;
   assign sethaltAC1AfterTXOP       = int_sethaltAC1AfterTXOP       ;
   assign sethaltAC0AfterTXOP       = int_sethaltAC0AfterTXOP       ;
   assign sethaltBcnAfterTXOP       = int_sethaltBcnAfterTXOP       ;
   assign settxTBNewHead            = int_settxTBNewHead            ;
   assign settxAC3NewHead           = int_settxAC3NewHead           ;
   assign settxAC2NewHead           = int_settxAC2NewHead           ;
   assign settxAC1NewHead           = int_settxAC1NewHead           ;
   assign settxAC0NewHead           = int_settxAC0NewHead           ;
   assign settxBcnNewHead           = int_settxBcnNewHead           ;
   assign settxAC3NewTail           = int_settxAC3NewTail           ;
   assign settxAC2NewTail           = int_settxAC2NewTail           ;
   assign settxAC1NewTail           = int_settxAC1NewTail           ;
   assign settxAC0NewTail           = int_settxAC0NewTail           ;
   assign settxBcnNewTail           = int_settxBcnNewTail           ;
   assign clearhaltTBAfterTXOP      = int_clearhaltTBAfterTXOP      ;
   assign clearhaltAC3AfterTXOP     = int_clearhaltAC3AfterTXOP     ;
   assign clearhaltAC2AfterTXOP     = int_clearhaltAC2AfterTXOP     ;
   assign clearhaltAC1AfterTXOP     = int_clearhaltAC1AfterTXOP     ;
   assign clearhaltAC0AfterTXOP     = int_clearhaltAC0AfterTXOP     ;
   assign clearhaltBcnAfterTXOP     = int_clearhaltBcnAfterTXOP     ;
   assign cleartxTBNewHead          = int_cleartxTBNewHead          ;
   assign cleartxAC3NewHead         = int_cleartxAC3NewHead         ;
   assign cleartxAC2NewHead         = int_cleartxAC2NewHead         ;
   assign cleartxAC1NewHead         = int_cleartxAC1NewHead         ;
   assign cleartxAC0NewHead         = int_cleartxAC0NewHead         ;
   assign cleartxBcnNewHead         = int_cleartxBcnNewHead         ;
   assign cleartxAC3NewTail         = int_cleartxAC3NewTail         ;
   assign cleartxAC2NewTail         = int_cleartxAC2NewTail         ;
   assign cleartxAC1NewTail         = int_cleartxAC1NewTail         ;
   assign cleartxAC0NewTail         = int_cleartxAC0NewTail         ;
   assign cleartxBcnNewTail         = int_cleartxBcnNewTail         ;
   assign txBcnHeadPtr              = int_txBcnHeadPtr              ;
   assign txAC0HeadPtr              = int_txAC0HeadPtr              ;
   assign txAC1HeadPtr              = int_txAC1HeadPtr              ;
   assign txAC2HeadPtr              = int_txAC2HeadPtr              ;
   assign txAC3HeadPtr              = int_txAC3HeadPtr              ;
   assign txTBHeadPtr               = int_txTBHeadPtr               ;
   assign dmaRBDSize                = int_dmaRBDSize                ;
   assign dmaRHDSize                = int_dmaRHDSize                ;
   assign dmaTBDSize                = int_dmaTBDSize                ;
   assign dmaTHDSize                = int_dmaTHDSize                ;
   assign ptEntrySize               = int_ptEntrySize               ;
   assign rxFIFOThreshold           = int_rxFIFOThreshold           ;
   assign txFIFOThreshold           = int_txFIFOThreshold           ;
   assign rxBuf1StartPtr            = int_rxBuf1StartPtr            ;
   assign rxBuf1EndPtr              = int_rxBuf1EndPtr              ;
   assign rxBuf1RdPtr               = int_rxBuf1RdPtr               ;
   assign rxBuf1WrPtr               = int_rxBuf1WrPtr               ;
   assign rxBuf2StartPtr            = int_rxBuf2StartPtr            ;
   assign rxBuf2EndPtr              = int_rxBuf2EndPtr              ;
   assign rxBuf2RdPtr               = int_rxBuf2RdPtr               ;
   assign rxBuf2WrPtr               = int_rxBuf2WrPtr               ;
   assign rxBufRPDFooter            = int_rxBufRPDFooter            ;
   assign rxBufRPDHeader            = int_rxBufRPDHeader            ;
   assign rxBufRHDFooter            = int_rxBufRHDFooter            ;
   assign rxBufRHDHeader            = int_rxBufRHDHeader            ;
   assign maxMCSInHETB              = int_maxMCSInHETB              ;
   assign eOCW                      = int_eOCW                      ;
   assign eOCWMin                   = int_eOCWMin                   ;
   assign raRUType                  = int_raRUType                  ;
   assign raRUEnable                = int_raRUEnable                ;
   assign txHETBMaxDur              = int_txHETBMaxDur              ;
`ifdef RW_MUMIMO_TX_EN                     
   assign setsecU3ac3TxBufTrigger   = int_setsecU3ac3TxBufTrigger   ;
   assign setsecU3ac2TxBufTrigger   = int_setsecU3ac2TxBufTrigger   ;
   assign setsecU3ac1TxBufTrigger   = int_setsecU3ac1TxBufTrigger   ;
   assign setsecU3ac0TxBufTrigger   = int_setsecU3ac0TxBufTrigger   ;
   assign setsecU3ac3TxTrigger      = int_setsecU3ac3TxTrigger      ;
   assign setsecU3ac2TxTrigger      = int_setsecU3ac2TxTrigger      ;
   assign setsecU3ac1TxTrigger      = int_setsecU3ac1TxTrigger      ;
   assign setsecU3ac0TxTrigger      = int_setsecU3ac0TxTrigger      ;
   assign setsecU2ac3TxBufTrigger   = int_setsecU2ac3TxBufTrigger   ;
   assign setsecU2ac2TxBufTrigger   = int_setsecU2ac2TxBufTrigger   ;
   assign setsecU2ac1TxBufTrigger   = int_setsecU2ac1TxBufTrigger   ;
   assign setsecU2ac0TxBufTrigger   = int_setsecU2ac0TxBufTrigger   ;
   assign setsecU2ac3TxTrigger      = int_setsecU2ac3TxTrigger      ;
   assign setsecU2ac2TxTrigger      = int_setsecU2ac2TxTrigger      ;
   assign setsecU2ac1TxTrigger      = int_setsecU2ac1TxTrigger      ;
   assign setsecU2ac0TxTrigger      = int_setsecU2ac0TxTrigger      ;
   assign setsecU1ac3TxBufTrigger   = int_setsecU1ac3TxBufTrigger   ;
   assign setsecU1ac2TxBufTrigger   = int_setsecU1ac2TxBufTrigger   ;
   assign setsecU1ac1TxBufTrigger   = int_setsecU1ac1TxBufTrigger   ;
   assign setsecU1ac0TxBufTrigger   = int_setsecU1ac0TxBufTrigger   ;
   assign setsecU1ac3TxTrigger      = int_setsecU1ac3TxTrigger      ;
   assign setsecU1ac2TxTrigger      = int_setsecU1ac2TxTrigger      ;
   assign setsecU1ac1TxTrigger      = int_setsecU1ac1TxTrigger      ;
   assign setsecU1ac0TxTrigger      = int_setsecU1ac0TxTrigger      ;
   assign clearsecU3ac3TxBufTrigger = int_clearsecU3ac3TxBufTrigger ;
   assign clearsecU3ac2TxBufTrigger = int_clearsecU3ac2TxBufTrigger ;
   assign clearsecU3ac1TxBufTrigger = int_clearsecU3ac1TxBufTrigger ;
   assign clearsecU3ac0TxBufTrigger = int_clearsecU3ac0TxBufTrigger ;
   assign clearsecU3ac3TxTrigger    = int_clearsecU3ac3TxTrigger    ;
   assign clearsecU3ac2TxTrigger    = int_clearsecU3ac2TxTrigger    ;
   assign clearsecU3ac1TxTrigger    = int_clearsecU3ac1TxTrigger    ;
   assign clearsecU3ac0TxTrigger    = int_clearsecU3ac0TxTrigger    ;
   assign clearsecU2ac3TxBufTrigger = int_clearsecU2ac3TxBufTrigger ;
   assign clearsecU2ac2TxBufTrigger = int_clearsecU2ac2TxBufTrigger ;
   assign clearsecU2ac1TxBufTrigger = int_clearsecU2ac1TxBufTrigger ;
   assign clearsecU2ac0TxBufTrigger = int_clearsecU2ac0TxBufTrigger ;
   assign clearsecU2ac3TxTrigger    = int_clearsecU2ac3TxTrigger    ;
   assign clearsecU2ac2TxTrigger    = int_clearsecU2ac2TxTrigger    ;
   assign clearsecU2ac1TxTrigger    = int_clearsecU2ac1TxTrigger    ;
   assign clearsecU2ac0TxTrigger    = int_clearsecU2ac0TxTrigger    ;
   assign clearsecU1ac3TxBufTrigger = int_clearsecU1ac3TxBufTrigger ;
   assign clearsecU1ac2TxBufTrigger = int_clearsecU1ac2TxBufTrigger ;
   assign clearsecU1ac1TxBufTrigger = int_clearsecU1ac1TxBufTrigger ;
   assign clearsecU1ac0TxBufTrigger = int_clearsecU1ac0TxBufTrigger ;
   assign clearsecU1ac3TxTrigger    = int_clearsecU1ac3TxTrigger    ;
   assign clearsecU1ac2TxTrigger    = int_clearsecU1ac2TxTrigger    ;
   assign clearsecU1ac1TxTrigger    = int_clearsecU1ac1TxTrigger    ;
   assign clearsecU1ac0TxTrigger    = int_clearsecU1ac0TxTrigger    ;
   assign masterSecUsersTxIntEn     = int_masterSecUsersTxIntEn     ;
   assign masksecU3ac3TxBufTrigger  = int_masksecU3ac3TxBufTrigger  ;
   assign masksecU3ac2TxBufTrigger  = int_masksecU3ac2TxBufTrigger  ;
   assign masksecU3ac1TxBufTrigger  = int_masksecU3ac1TxBufTrigger  ;
   assign masksecU3ac0TxBufTrigger  = int_masksecU3ac0TxBufTrigger  ;
   assign masksecU3ac3TxTrigger     = int_masksecU3ac3TxTrigger     ;
   assign masksecU3ac2TxTrigger     = int_masksecU3ac2TxTrigger     ;
   assign masksecU3ac1TxTrigger     = int_masksecU3ac1TxTrigger     ;
   assign masksecU3ac0TxTrigger     = int_masksecU3ac0TxTrigger     ;
   assign masksecU2ac3TxBufTrigger  = int_masksecU2ac3TxBufTrigger  ;
   assign masksecU2ac2TxBufTrigger  = int_masksecU2ac2TxBufTrigger  ;
   assign masksecU2ac1TxBufTrigger  = int_masksecU2ac1TxBufTrigger  ;
   assign masksecU2ac0TxBufTrigger  = int_masksecU2ac0TxBufTrigger  ;
   assign masksecU2ac3TxTrigger     = int_masksecU2ac3TxTrigger     ;
   assign masksecU2ac2TxTrigger     = int_masksecU2ac2TxTrigger     ;
   assign masksecU2ac1TxTrigger     = int_masksecU2ac1TxTrigger     ;
   assign masksecU2ac0TxTrigger     = int_masksecU2ac0TxTrigger     ;
   assign masksecU1ac3TxBufTrigger  = int_masksecU1ac3TxBufTrigger  ;
   assign masksecU1ac2TxBufTrigger  = int_masksecU1ac2TxBufTrigger  ;
   assign masksecU1ac1TxBufTrigger  = int_masksecU1ac1TxBufTrigger  ;
   assign masksecU1ac0TxBufTrigger  = int_masksecU1ac0TxBufTrigger  ;
   assign masksecU1ac3TxTrigger     = int_masksecU1ac3TxTrigger     ;
   assign masksecU1ac2TxTrigger     = int_masksecU1ac2TxTrigger     ;
   assign masksecU1ac1TxTrigger     = int_masksecU1ac1TxTrigger     ;
   assign masksecU1ac0TxTrigger     = int_masksecU1ac0TxTrigger     ;
`endif // RW_MUMIMO_TX_EN                     
   assign swProf31                  = int_swProf31                  ;
   assign swProf30                  = int_swProf30                  ;
   assign swProf29                  = int_swProf29                  ;
   assign swProf28                  = int_swProf28                  ;
   assign swProf27                  = int_swProf27                  ;
   assign swProf26                  = int_swProf26                  ;
   assign swProf25                  = int_swProf25                  ;
   assign swProf24                  = int_swProf24                  ;
   assign swProf23                  = int_swProf23                  ;
   assign swProf22                  = int_swProf22                  ;
   assign swProf21                  = int_swProf21                  ;
   assign swProf20                  = int_swProf20                  ;
   assign swProf19                  = int_swProf19                  ;
   assign swProf18                  = int_swProf18                  ;
   assign swProf17                  = int_swProf17                  ;
   assign swProf16                  = int_swProf16                  ;
   assign swProf15                  = int_swProf15                  ;
   assign swProf14                  = int_swProf14                  ;
   assign swProf13                  = int_swProf13                  ;
   assign swProf12                  = int_swProf12                  ;
   assign swProf11                  = int_swProf11                  ;
   assign swProf10                  = int_swProf10                  ;
   assign swProf9                   = int_swProf9                   ;
   assign swProf8                   = int_swProf8                   ;
   assign swProf7                   = int_swProf7                   ;
   assign swProf6                   = int_swProf6                   ;
   assign swProf5                   = int_swProf5                   ;
   assign swProf4                   = int_swProf4                   ;
   assign swProf3                   = int_swProf3                   ;
   assign swProf2                   = int_swProf2                   ;
   assign swProf1                   = int_swProf1                   ;
   assign swProf0                   = int_swProf0                   ;
   assign swSetProf31               = int_swSetProf31               ;
   assign swSetProf30               = int_swSetProf30               ;
   assign swSetProf29               = int_swSetProf29               ;
   assign swSetProf28               = int_swSetProf28               ;
   assign swSetProf27               = int_swSetProf27               ;
   assign swSetProf26               = int_swSetProf26               ;
   assign swSetProf25               = int_swSetProf25               ;
   assign swSetProf24               = int_swSetProf24               ;
   assign swSetProf23               = int_swSetProf23               ;
   assign swSetProf22               = int_swSetProf22               ;
   assign swSetProf21               = int_swSetProf21               ;
   assign swSetProf20               = int_swSetProf20               ;
   assign swSetProf19               = int_swSetProf19               ;
   assign swSetProf18               = int_swSetProf18               ;
   assign swSetProf17               = int_swSetProf17               ;
   assign swSetProf16               = int_swSetProf16               ;
   assign swSetProf15               = int_swSetProf15               ;
   assign swSetProf14               = int_swSetProf14               ;
   assign swSetProf13               = int_swSetProf13               ;
   assign swSetProf12               = int_swSetProf12               ;
   assign swSetProf11               = int_swSetProf11               ;
   assign swSetProf10               = int_swSetProf10               ;
   assign swSetProf9                = int_swSetProf9                ;
   assign swSetProf8                = int_swSetProf8                ;
   assign swSetProf7                = int_swSetProf7                ;
   assign swSetProf6                = int_swSetProf6                ;
   assign swSetProf5                = int_swSetProf5                ;
   assign swSetProf4                = int_swSetProf4                ;
   assign swSetProf3                = int_swSetProf3                ;
   assign swSetProf2                = int_swSetProf2                ;
   assign swSetProf1                = int_swSetProf1                ;
   assign swSetProf0                = int_swSetProf0                ;
   assign swClearProf31             = int_swClearProf31             ;
   assign swClearProf30             = int_swClearProf30             ;
   assign swClearProf29             = int_swClearProf29             ;
   assign swClearProf28             = int_swClearProf28             ;
   assign swClearProf27             = int_swClearProf27             ;
   assign swClearProf26             = int_swClearProf26             ;
   assign swClearProf25             = int_swClearProf25             ;
   assign swClearProf24             = int_swClearProf24             ;
   assign swClearProf23             = int_swClearProf23             ;
   assign swClearProf22             = int_swClearProf22             ;
   assign swClearProf21             = int_swClearProf21             ;
   assign swClearProf20             = int_swClearProf20             ;
   assign swClearProf19             = int_swClearProf19             ;
   assign swClearProf18             = int_swClearProf18             ;
   assign swClearProf17             = int_swClearProf17             ;
   assign swClearProf16             = int_swClearProf16             ;
   assign swClearProf15             = int_swClearProf15             ;
   assign swClearProf14             = int_swClearProf14             ;
   assign swClearProf13             = int_swClearProf13             ;
   assign swClearProf12             = int_swClearProf12             ;
   assign swClearProf11             = int_swClearProf11             ;
   assign swClearProf10             = int_swClearProf10             ;
   assign swClearProf9              = int_swClearProf9              ;
   assign swClearProf8              = int_swClearProf8              ;
   assign swClearProf7              = int_swClearProf7              ;
   assign swClearProf6              = int_swClearProf6              ;
   assign swClearProf5              = int_swClearProf5              ;
   assign swClearProf4              = int_swClearProf4              ;
   assign swClearProf3              = int_swClearProf3              ;
   assign swClearProf2              = int_swClearProf2              ;
   assign swClearProf1              = int_swClearProf1              ;
   assign swClearProf0              = int_swClearProf0              ;
   assign swProf63                  = int_swProf63                  ;
   assign swProf62                  = int_swProf62                  ;
   assign swProf61                  = int_swProf61                  ;
   assign swProf60                  = int_swProf60                  ;
   assign swProf59                  = int_swProf59                  ;
   assign swProf58                  = int_swProf58                  ;
   assign swProf57                  = int_swProf57                  ;
   assign swProf56                  = int_swProf56                  ;
   assign swProf55                  = int_swProf55                  ;
   assign swProf54                  = int_swProf54                  ;
   assign swProf53                  = int_swProf53                  ;
   assign swProf52                  = int_swProf52                  ;
   assign swProf51                  = int_swProf51                  ;
   assign swProf50                  = int_swProf50                  ;
   assign swProf49                  = int_swProf49                  ;
   assign swProf48                  = int_swProf48                  ;
   assign swProf47                  = int_swProf47                  ;
   assign swProf46                  = int_swProf46                  ;
   assign swProf45                  = int_swProf45                  ;
   assign swProf44                  = int_swProf44                  ;
   assign swProf43                  = int_swProf43                  ;
   assign swProf42                  = int_swProf42                  ;
   assign swProf41                  = int_swProf41                  ;
   assign swProf40                  = int_swProf40                  ;
   assign swProf39                  = int_swProf39                  ;
   assign swProf38                  = int_swProf38                  ;
   assign swProf37                  = int_swProf37                  ;
   assign swProf36                  = int_swProf36                  ;
   assign swProf35                  = int_swProf35                  ;
   assign swProf34                  = int_swProf34                  ;
   assign swProf33                  = int_swProf33                  ;
   assign swProf32                  = int_swProf32                  ;
   assign swSetProf63               = int_swSetProf63               ;
   assign swSetProf62               = int_swSetProf62               ;
   assign swSetProf61               = int_swSetProf61               ;
   assign swSetProf60               = int_swSetProf60               ;
   assign swSetProf59               = int_swSetProf59               ;
   assign swSetProf58               = int_swSetProf58               ;
   assign swSetProf57               = int_swSetProf57               ;
   assign swSetProf56               = int_swSetProf56               ;
   assign swSetProf55               = int_swSetProf55               ;
   assign swSetProf54               = int_swSetProf54               ;
   assign swSetProf53               = int_swSetProf53               ;
   assign swSetProf52               = int_swSetProf52               ;
   assign swSetProf51               = int_swSetProf51               ;
   assign swSetProf50               = int_swSetProf50               ;
   assign swSetProf49               = int_swSetProf49               ;
   assign swSetProf48               = int_swSetProf48               ;
   assign swSetProf47               = int_swSetProf47               ;
   assign swSetProf46               = int_swSetProf46               ;
   assign swSetProf45               = int_swSetProf45               ;
   assign swSetProf44               = int_swSetProf44               ;
   assign swSetProf43               = int_swSetProf43               ;
   assign swSetProf42               = int_swSetProf42               ;
   assign swSetProf41               = int_swSetProf41               ;
   assign swSetProf40               = int_swSetProf40               ;
   assign swSetProf39               = int_swSetProf39               ;
   assign swSetProf38               = int_swSetProf38               ;
   assign swSetProf37               = int_swSetProf37               ;
   assign swSetProf36               = int_swSetProf36               ;
   assign swSetProf35               = int_swSetProf35               ;
   assign swSetProf34               = int_swSetProf34               ;
   assign swSetProf33               = int_swSetProf33               ;
   assign swSetProf32               = int_swSetProf32               ;
   assign swClearProf63             = int_swClearProf63             ;
   assign swClearProf62             = int_swClearProf62             ;
   assign swClearProf61             = int_swClearProf61             ;
   assign swClearProf60             = int_swClearProf60             ;
   assign swClearProf59             = int_swClearProf59             ;
   assign swClearProf58             = int_swClearProf58             ;
   assign swClearProf57             = int_swClearProf57             ;
   assign swClearProf56             = int_swClearProf56             ;
   assign swClearProf55             = int_swClearProf55             ;
   assign swClearProf54             = int_swClearProf54             ;
   assign swClearProf53             = int_swClearProf53             ;
   assign swClearProf52             = int_swClearProf52             ;
   assign swClearProf51             = int_swClearProf51             ;
   assign swClearProf50             = int_swClearProf50             ;
   assign swClearProf49             = int_swClearProf49             ;
   assign swClearProf48             = int_swClearProf48             ;
   assign swClearProf47             = int_swClearProf47             ;
   assign swClearProf46             = int_swClearProf46             ;
   assign swClearProf45             = int_swClearProf45             ;
   assign swClearProf44             = int_swClearProf44             ;
   assign swClearProf43             = int_swClearProf43             ;
   assign swClearProf42             = int_swClearProf42             ;
   assign swClearProf41             = int_swClearProf41             ;
   assign swClearProf40             = int_swClearProf40             ;
   assign swClearProf39             = int_swClearProf39             ;
   assign swClearProf38             = int_swClearProf38             ;
   assign swClearProf37             = int_swClearProf37             ;
   assign swClearProf36             = int_swClearProf36             ;
   assign swClearProf35             = int_swClearProf35             ;
   assign swClearProf34             = int_swClearProf34             ;
   assign swClearProf33             = int_swClearProf33             ;
   assign swClearProf32             = int_swClearProf32             ;
`ifdef RW_MUMIMO_SEC_USER1_EN              
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              
`endif // RW_MUMIMO_SEC_USER3_EN              


  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  assign latchNextState_p = 1'b0;


  // apb_write_p:
  always @(posedge Clk or negedge hardRstClk_n)
  begin
    if (!hardRstClk_n) 
    begin
	
      // DOZECNTRL2REG register.
      int_wakeUpFromDoze             <= 1'b0;
      int_wakeUpSW                   <= 1'b1;
      // MACCNTRL2REG register.
      int_softReset                  <= 1'b0;
      // GENINTEVENTSETREG register.
      int_settbTxDMADead             <= 1'b0;
      int_setrxPayloadDMADead        <= 1'b0;
      int_setrxHeaderDMADead         <= 1'b0;
      int_setphyRxStart              <= 1'b0;
      int_setphyErr                  <= 1'b0;
      int_setmacPHYIFUnderRun        <= 1'b0;
      int_sethwErr                   <= 1'b0;
      int_setimpSecDTIM              <= 1'b0;
      int_setimpPriDTIM              <= 1'b0;
      int_setbcnTxDMADead            <= 1'b0;
      int_setac3TxDMADead            <= 1'b0;
      int_setac2TxDMADead            <= 1'b0;
      int_setac1TxDMADead            <= 1'b0;
      int_setac0TxDMADead            <= 1'b0;
      int_setptError                 <= 1'b0;
      int_settimSet                  <= 1'b0;
      int_setolbcDSSS                <= 1'b0;
      int_setolbcOFDM                <= 1'b0;
      int_setrxFIFOOverFlow          <= 1'b0;
      int_setmacPHYIFOverflow        <= 1'b0;
      int_setcoexEvent               <= 1'b0;
      int_absGenTimers               <= 1'b0;
      int_setidleInterrupt           <= 1'b0;
      int_setimpSecTBTT              <= 1'b0;
      int_setimpPriTBTT              <= 1'b0;
      // GENINTEVENTCLEARREG register.
      int_cleartbTxDMADead           <= 1'b0;
      int_clearrxPayloadDMADead      <= 1'b0;
      int_clearrxHeaderDMADead       <= 1'b0;
      int_clearphyRxStart            <= 1'b0;
      int_clearphyErr                <= 1'b0;
      int_clearmacPHYIFUnderRun      <= 1'b0;
      int_clearhwErr                 <= 1'b0;
      int_clearimpSecDTIM            <= 1'b0;
      int_clearimpPriDTIM            <= 1'b0;
      int_clearbcnTxDMADead          <= 1'b0;
      int_clearac3TxDMADead          <= 1'b0;
      int_clearac2TxDMADead          <= 1'b0;
      int_clearac1TxDMADead          <= 1'b0;
      int_clearac0TxDMADead          <= 1'b0;
      int_clearptError               <= 1'b0;
      int_cleartimSet                <= 1'b0;
      int_clearolbcDSSS              <= 1'b0;
      int_clearolbcOFDM              <= 1'b0;
      int_clearrxFIFOOverFlow        <= 1'b0;
      int_clearmacPHYIFOverflow      <= 1'b0;
      int_clearcoexEvent             <= 1'b0;
      int_clearidleInterrupt         <= 1'b0;
      int_clearimpSecTBTT            <= 1'b0;
      int_clearimpPriTBTT            <= 1'b0;
      // GENINTUNMASKREG register.
      int_masterGenIntEn             <= 1'b0;
      int_masktbTxDMADead            <= 1'b0;
      int_maskrxPayloadDMADead       <= 1'b0;
      int_maskrxHeaderDMADead        <= 1'b0;
      int_maskphyRxStart             <= 1'b0;
      int_maskphyErr                 <= 1'b0;
      int_maskmacPHYIFUnderRun       <= 1'b0;
      int_maskhwErr                  <= 1'b0;
      int_maskimpSecDTIM             <= 1'b0;
      int_maskimpPriDTIM             <= 1'b0;
      int_maskbcnTxDMADead           <= 1'b0;
      int_maskac3TxDMADead           <= 1'b0;
      int_maskac2TxDMADead           <= 1'b0;
      int_maskac1TxDMADead           <= 1'b0;
      int_maskac0TxDMADead           <= 1'b0;
      int_maskptError                <= 1'b0;
      int_masktimSet                 <= 1'b0;
      int_maskolbcDSSS               <= 1'b0;
      int_maskolbcOFDM               <= 1'b0;
      int_maskrxFIFOOverFlow         <= 1'b0;
      int_maskmacPHYIFOverflow       <= 1'b0;
      int_maskcoexEvent              <= 1'b0;
      int_maskabsGenTimers           <= 1'b0;
      int_maskidleInterrupt          <= 1'b0;
      int_maskimpSecTBTT             <= 1'b0;
      int_maskimpPriTBTT             <= 1'b0;
      // TXRXINTEVENTSETREG register.
      int_settbTxBufTrigger          <= 1'b0;
      int_setbcnTxBufTrigger         <= 1'b0;
      int_setac3TxBufTrigger         <= 1'b0;
      int_setac2TxBufTrigger         <= 1'b0;
      int_setac1TxBufTrigger         <= 1'b0;
      int_setac0TxBufTrigger         <= 1'b0;
      int_setac3BWDropTrigger        <= 1'b0;
      int_setac2BWDropTrigger        <= 1'b0;
      int_setac1BWDropTrigger        <= 1'b0;
      int_setac0BWDropTrigger        <= 1'b0;
      int_setrxBuffer2Trigger        <= 1'b0;
      int_settimerRxTrigger          <= 1'b0;
      int_setrxBuffer1Trigger        <= 1'b0;
      int_setsecUserTxTrigger        <= 1'b0;
      int_settimerTxTrigger          <= 1'b0;
      int_settxopComplete            <= 1'b0;
      int_settbTxCancelled           <= 1'b0;
      int_settbTxTrigger             <= 1'b0;
      int_setbcnTxTrigger            <= 1'b0;
      int_setac3TxTrigger            <= 1'b0;
      int_setac2TxTrigger            <= 1'b0;
      int_setac1TxTrigger            <= 1'b0;
      int_setac0TxTrigger            <= 1'b0;
      int_settbProtTrigger           <= 1'b0;
      int_setac3ProtTrigger          <= 1'b0;
      int_setac2ProtTrigger          <= 1'b0;
      int_setac1ProtTrigger          <= 1'b0;
      int_setac0ProtTrigger          <= 1'b0;
      // TXRXINTEVENTCLEARREG register.
      int_cleartbTxBufTrigger        <= 1'b0;
      int_clearbcnTxBufTrigger       <= 1'b0;
      int_clearac3TxBufTrigger       <= 1'b0;
      int_clearac2TxBufTrigger       <= 1'b0;
      int_clearac1TxBufTrigger       <= 1'b0;
      int_clearac0TxBufTrigger       <= 1'b0;
      int_clearac3BWDropTrigger      <= 1'b0;
      int_clearac2BWDropTrigger      <= 1'b0;
      int_clearac1BWDropTrigger      <= 1'b0;
      int_clearac0BWDropTrigger      <= 1'b0;
      int_clearrxBuffer2Trigger      <= 1'b0;
      int_cleartimerRxTrigger        <= 1'b0;
      int_clearrxBuffer1Trigger      <= 1'b0;
      int_cleartimerTxTrigger        <= 1'b0;
      int_cleartxopComplete          <= 1'b0;
      int_cleartbTxCancelled         <= 1'b0;
      int_cleartbTxTrigger           <= 1'b0;
      int_clearbcnTxTrigger          <= 1'b0;
      int_clearac3TxTrigger          <= 1'b0;
      int_clearac2TxTrigger          <= 1'b0;
      int_clearac1TxTrigger          <= 1'b0;
      int_clearac0TxTrigger          <= 1'b0;
      int_cleartbProtTrigger         <= 1'b0;
      int_clearac3ProtTrigger        <= 1'b0;
      int_clearac2ProtTrigger        <= 1'b0;
      int_clearac1ProtTrigger        <= 1'b0;
      int_clearac0ProtTrigger        <= 1'b0;
      // TXRXINTUNMASKREG register.
      int_masterTxRxIntEn            <= 1'b0;
      int_masktbTxBufTrigger         <= 1'b0;
      int_maskbcnTxBufTrigger        <= 1'b0;
      int_maskac3TxBufTrigger        <= 1'b0;
      int_maskac2TxBufTrigger        <= 1'b0;
      int_maskac1TxBufTrigger        <= 1'b0;
      int_maskac0TxBufTrigger        <= 1'b0;
      int_maskac3BWDropTrigger       <= 1'b0;
      int_maskac2BWDropTrigger       <= 1'b0;
      int_maskac1BWDropTrigger       <= 1'b0;
      int_maskac0BWDropTrigger       <= 1'b0;
      int_maskrxBuffer2Trigger       <= 1'b0;
      int_masktimerRxTrigger         <= 1'b0;
      int_maskrxBuffer1Trigger       <= 1'b0;
      int_masksecUserTxTrigger       <= 1'b0;
      int_masktimerTxTrigger         <= 1'b0;
      int_masktxopComplete           <= 1'b0;
      int_masktbTxCancelled          <= 1'b0;
      int_masktbTxTrigger            <= 1'b0;
      int_maskbcnTxTrigger           <= 1'b0;
      int_maskac3TxTrigger           <= 1'b0;
      int_maskac2TxTrigger           <= 1'b0;
      int_maskac1TxTrigger           <= 1'b0;
      int_maskac0TxTrigger           <= 1'b0;
      int_masktbProtTrigger          <= 1'b0;
      int_maskac3ProtTrigger         <= 1'b0;
      int_maskac2ProtTrigger         <= 1'b0;
      int_maskac1ProtTrigger         <= 1'b0;
      int_maskac0ProtTrigger         <= 1'b0;
      // TIMERSINTEVENTSETREG register.
      int_setabsTimers9              <= 1'b0;
      int_setabsTimers8              <= 1'b0;
      int_setabsTimers7              <= 1'b0;
      int_setabsTimers6              <= 1'b0;
      int_setabsTimers5              <= 1'b0;
      int_setabsTimers4              <= 1'b0;
      int_setabsTimers3              <= 1'b0;
      int_setabsTimers2              <= 1'b0;
      int_setabsTimers1              <= 1'b0;
      int_setabsTimers0              <= 1'b0;
      // TIMERSINTEVENTCLEARREG register.
      int_clearabsTimers9            <= 1'b0;
      int_clearabsTimers8            <= 1'b0;
      int_clearabsTimers7            <= 1'b0;
      int_clearabsTimers6            <= 1'b0;
      int_clearabsTimers5            <= 1'b0;
      int_clearabsTimers4            <= 1'b0;
      int_clearabsTimers3            <= 1'b0;
      int_clearabsTimers2            <= 1'b0;
      int_clearabsTimers1            <= 1'b0;
      int_clearabsTimers0            <= 1'b0;
      // TIMERSINTUNMASKREG register.
      int_maskabsTimers9             <= 1'b0;
      int_maskabsTimers8             <= 1'b0;
      int_maskabsTimers7             <= 1'b0;
      int_maskabsTimers6             <= 1'b0;
      int_maskabsTimers5             <= 1'b0;
      int_maskabsTimers4             <= 1'b0;
      int_maskabsTimers3             <= 1'b0;
      int_maskabsTimers2             <= 1'b0;
      int_maskabsTimers1             <= 1'b0;
      int_maskabsTimers0             <= 1'b0;
      // TSFLOREG register.
      int_tsfTimerLow                <= 32'b0000000000000000000000000000000;
      // TSFHIREG register.
      int_tsfTimerHigh               <= 32'b0000000000000000000000000000000;
      // TIMEONAIRPARAM1REG register.
      int_ppduSTBC                   <= 2'b0;
      int_ppduNumExtnSS              <= 2'b0;
      int_ppduBW                     <= 2'b0;
      int_ppduGI                     <= 2'b0;
      int_ppduPreType                <= 4'b000;
      int_ppduLength                 <= 20'b0000000000000000000;
      // TIMEONAIRPARAM2REG register.
      int_ppduNumHeLtf               <= 3'b00;
      int_ppduNUser                  <= 7'b000000;
      int_ppduPE                     <= 3'b00;
      int_ppduMCSSigB                <= 3'b00;
      int_ppduDCMSigB                <= 1'b0;
      int_ppduSigBCompMode           <= 1'b0;
      int_ppduHELTFType              <= 2'b0;
      int_ppduDCM                    <= 1'b0;
      int_ppduMCSIndex               <= 7'b000000;
      // TIMEONAIRPARAM3REG register.
      int_ppduRuType                 <= 3'b00;
      int_ppduMma                    <= 1'b0;
      int_ppduDoppler                <= 1'b0;
      // TIMEONAIRVALUEREG register.
      int_computeDuration            <= 1'b0;
      // DMACNTRLSETREG register.
      int_sethaltTBAfterTXOP         <= 1'b0;
      int_sethaltAC3AfterTXOP        <= 1'b0;
      int_sethaltAC2AfterTXOP        <= 1'b0;
      int_sethaltAC1AfterTXOP        <= 1'b0;
      int_sethaltAC0AfterTXOP        <= 1'b0;
      int_sethaltBcnAfterTXOP        <= 1'b0;
      int_settxTBNewHead             <= 1'b0;
      int_settxAC3NewHead            <= 1'b0;
      int_settxAC2NewHead            <= 1'b0;
      int_settxAC1NewHead            <= 1'b0;
      int_settxAC0NewHead            <= 1'b0;
      int_settxBcnNewHead            <= 1'b0;
      int_settxAC3NewTail            <= 1'b0;
      int_settxAC2NewTail            <= 1'b0;
      int_settxAC1NewTail            <= 1'b0;
      int_settxAC0NewTail            <= 1'b0;
      int_settxBcnNewTail            <= 1'b0;
      // DMACNTRLCLEARREG register.
      int_clearhaltTBAfterTXOP       <= 1'b0;
      int_clearhaltAC3AfterTXOP      <= 1'b0;
      int_clearhaltAC2AfterTXOP      <= 1'b0;
      int_clearhaltAC1AfterTXOP      <= 1'b0;
      int_clearhaltAC0AfterTXOP      <= 1'b0;
      int_clearhaltBcnAfterTXOP      <= 1'b0;
      int_cleartxTBNewHead           <= 1'b0;
      int_cleartxAC3NewHead          <= 1'b0;
      int_cleartxAC2NewHead          <= 1'b0;
      int_cleartxAC1NewHead          <= 1'b0;
      int_cleartxAC0NewHead          <= 1'b0;
      int_cleartxBcnNewHead          <= 1'b0;
      int_cleartxAC3NewTail          <= 1'b0;
      int_cleartxAC2NewTail          <= 1'b0;
      int_cleartxAC1NewTail          <= 1'b0;
      int_cleartxAC0NewTail          <= 1'b0;
      int_cleartxBcnNewTail          <= 1'b0;
      // TXBCNHEADPTRREG register.
      int_txBcnHeadPtr               <= 32'b0000000000000000000000000000000;
      // TXAC0HEADPTRREG register.
      int_txAC0HeadPtr               <= 32'b0000000000000000000000000000000;
      // TXAC1HEADPTRREG register.
      int_txAC1HeadPtr               <= 32'b0000000000000000000000000000000;
      // TXAC2HEADPTRREG register.
      int_txAC2HeadPtr               <= 32'b0000000000000000000000000000000;
      // TXAC3HEADPTRREG register.
      int_txAC3HeadPtr               <= 32'b0000000000000000000000000000000;
      // TXTBHEADPTRREG register.
      int_txTBHeadPtr                <= 32'b0000000000000000000000000000000;
      // TXSTRUCTSIZESREG register.
      int_dmaRBDSize                 <= 6'd`RBD_SIZE;
      int_dmaRHDSize                 <= 6'd`RHD_SIZE;
      int_dmaTBDSize                 <= 6'd`TBD_SIZE;
      int_dmaTHDSize                 <= 6'd`THD_SIZE;
      int_ptEntrySize                <= 6'd`PT_SIZE;
      // DMATHRESHOLDREG register.
      int_rxFIFOThreshold            <= 8'b0010000;
      int_txFIFOThreshold            <= 8'b0010000;
      // RXBUF1STARTPTRREG register.
      int_rxBuf1StartPtr             <= 31'b000000000000000000000000000000;
      // RXBUF1ENDPTRREG register.
      int_rxBuf1EndPtr               <= 31'b000000000000000000000000000000;
      // RXBUF1RDPTRREG register.
      int_rxBuf1RdPtr                <= 32'b0000000000000000000000000000000;
      // RXBUF1WRPTRREG register.
      int_rxBuf1WrPtr                <= 32'b0000000000000000000000000000000;
      // RXBUF2STARTPTRREG register.
      int_rxBuf2StartPtr             <= 31'b000000000000000000000000000000;
      // RXBUF2ENDPTRREG register.
      int_rxBuf2EndPtr               <= 31'b000000000000000000000000000000;
      // RXBUF2RDPTRREG register.
      int_rxBuf2RdPtr                <= 32'b0000000000000000000000000000000;
      // RXBUF2WRPTRREG register.
      int_rxBuf2WrPtr                <= 32'b0000000000000000000000000000000;
      // RXBUFCONFIGREG register.
      int_rxBufRPDFooter             <= 8'b0000000;
      int_rxBufRPDHeader             <= 8'b0000000;
      int_rxBufRHDFooter             <= 8'b0000000;
      int_rxBufRHDHeader             <= 8'b0000000;
      // TXHETBINFOREG register.
      int_maxMCSInHETB               <= 4'b111;
      int_eOCW                       <= 3'b11;
      int_eOCWMin                    <= 3'b11;
      int_raRUType                   <= 1'b0;
      int_raRUEnable                 <= 1'b0;
      int_txHETBMaxDur               <= 6'b11100;
`ifdef RW_MUMIMO_TX_EN                     
      // SECUSERSTXINTEVENTSETREG register.
      int_setsecU3ac3TxBufTrigger    <= 1'b0;
      int_setsecU3ac2TxBufTrigger    <= 1'b0;
      int_setsecU3ac1TxBufTrigger    <= 1'b0;
      int_setsecU3ac0TxBufTrigger    <= 1'b0;
      int_setsecU3ac3TxTrigger       <= 1'b0;
      int_setsecU3ac2TxTrigger       <= 1'b0;
      int_setsecU3ac1TxTrigger       <= 1'b0;
      int_setsecU3ac0TxTrigger       <= 1'b0;
      int_setsecU2ac3TxBufTrigger    <= 1'b0;
      int_setsecU2ac2TxBufTrigger    <= 1'b0;
      int_setsecU2ac1TxBufTrigger    <= 1'b0;
      int_setsecU2ac0TxBufTrigger    <= 1'b0;
      int_setsecU2ac3TxTrigger       <= 1'b0;
      int_setsecU2ac2TxTrigger       <= 1'b0;
      int_setsecU2ac1TxTrigger       <= 1'b0;
      int_setsecU2ac0TxTrigger       <= 1'b0;
      int_setsecU1ac3TxBufTrigger    <= 1'b0;
      int_setsecU1ac2TxBufTrigger    <= 1'b0;
      int_setsecU1ac1TxBufTrigger    <= 1'b0;
      int_setsecU1ac0TxBufTrigger    <= 1'b0;
      int_setsecU1ac3TxTrigger       <= 1'b0;
      int_setsecU1ac2TxTrigger       <= 1'b0;
      int_setsecU1ac1TxTrigger       <= 1'b0;
      int_setsecU1ac0TxTrigger       <= 1'b0;
      // SECUSERSTXINTEVENTCLEARREG register.
      int_clearsecU3ac3TxBufTrigger  <= 1'b0;
      int_clearsecU3ac2TxBufTrigger  <= 1'b0;
      int_clearsecU3ac1TxBufTrigger  <= 1'b0;
      int_clearsecU3ac0TxBufTrigger  <= 1'b0;
      int_clearsecU3ac3TxTrigger     <= 1'b0;
      int_clearsecU3ac2TxTrigger     <= 1'b0;
      int_clearsecU3ac1TxTrigger     <= 1'b0;
      int_clearsecU3ac0TxTrigger     <= 1'b0;
      int_clearsecU2ac3TxBufTrigger  <= 1'b0;
      int_clearsecU2ac2TxBufTrigger  <= 1'b0;
      int_clearsecU2ac1TxBufTrigger  <= 1'b0;
      int_clearsecU2ac0TxBufTrigger  <= 1'b0;
      int_clearsecU2ac3TxTrigger     <= 1'b0;
      int_clearsecU2ac2TxTrigger     <= 1'b0;
      int_clearsecU2ac1TxTrigger     <= 1'b0;
      int_clearsecU2ac0TxTrigger     <= 1'b0;
      int_clearsecU1ac3TxBufTrigger  <= 1'b0;
      int_clearsecU1ac2TxBufTrigger  <= 1'b0;
      int_clearsecU1ac1TxBufTrigger  <= 1'b0;
      int_clearsecU1ac0TxBufTrigger  <= 1'b0;
      int_clearsecU1ac3TxTrigger     <= 1'b0;
      int_clearsecU1ac2TxTrigger     <= 1'b0;
      int_clearsecU1ac1TxTrigger     <= 1'b0;
      int_clearsecU1ac0TxTrigger     <= 1'b0;
      // SECUSERSTXINTEVENTUNMASKREG register.
      int_masterSecUsersTxIntEn      <= 1'b0;
      int_masksecU3ac3TxBufTrigger   <= 1'b0;
      int_masksecU3ac2TxBufTrigger   <= 1'b0;
      int_masksecU3ac1TxBufTrigger   <= 1'b0;
      int_masksecU3ac0TxBufTrigger   <= 1'b0;
      int_masksecU3ac3TxTrigger      <= 1'b0;
      int_masksecU3ac2TxTrigger      <= 1'b0;
      int_masksecU3ac1TxTrigger      <= 1'b0;
      int_masksecU3ac0TxTrigger      <= 1'b0;
      int_masksecU2ac3TxBufTrigger   <= 1'b0;
      int_masksecU2ac2TxBufTrigger   <= 1'b0;
      int_masksecU2ac1TxBufTrigger   <= 1'b0;
      int_masksecU2ac0TxBufTrigger   <= 1'b0;
      int_masksecU2ac3TxTrigger      <= 1'b0;
      int_masksecU2ac2TxTrigger      <= 1'b0;
      int_masksecU2ac1TxTrigger      <= 1'b0;
      int_masksecU2ac0TxTrigger      <= 1'b0;
      int_masksecU1ac3TxBufTrigger   <= 1'b0;
      int_masksecU1ac2TxBufTrigger   <= 1'b0;
      int_masksecU1ac1TxBufTrigger   <= 1'b0;
      int_masksecU1ac0TxBufTrigger   <= 1'b0;
      int_masksecU1ac3TxTrigger      <= 1'b0;
      int_masksecU1ac2TxTrigger      <= 1'b0;
      int_masksecU1ac1TxTrigger      <= 1'b0;
      int_masksecU1ac0TxTrigger      <= 1'b0;
`endif // RW_MUMIMO_TX_EN                     
      // DEBUGTBSPTRREG register.
      // SWPROFILINGREG register.
      int_swProf31                   <= 1'b0;
      int_swProf30                   <= 1'b0;
      int_swProf29                   <= 1'b0;
      int_swProf28                   <= 1'b0;
      int_swProf27                   <= 1'b0;
      int_swProf26                   <= 1'b0;
      int_swProf25                   <= 1'b0;
      int_swProf24                   <= 1'b0;
      int_swProf23                   <= 1'b0;
      int_swProf22                   <= 1'b0;
      int_swProf21                   <= 1'b0;
      int_swProf20                   <= 1'b0;
      int_swProf19                   <= 1'b0;
      int_swProf18                   <= 1'b0;
      int_swProf17                   <= 1'b0;
      int_swProf16                   <= 1'b0;
      int_swProf15                   <= 1'b0;
      int_swProf14                   <= 1'b0;
      int_swProf13                   <= 1'b0;
      int_swProf12                   <= 1'b0;
      int_swProf11                   <= 1'b0;
      int_swProf10                   <= 1'b0;
      int_swProf9                    <= 1'b0;
      int_swProf8                    <= 1'b0;
      int_swProf7                    <= 1'b0;
      int_swProf6                    <= 1'b0;
      int_swProf5                    <= 1'b0;
      int_swProf4                    <= 1'b0;
      int_swProf3                    <= 1'b0;
      int_swProf2                    <= 1'b0;
      int_swProf1                    <= 1'b0;
      int_swProf0                    <= 1'b0;
      // SWSETPROFILINGREG register.
      int_swSetProf31                <= 1'b0;
      int_swSetProf30                <= 1'b0;
      int_swSetProf29                <= 1'b0;
      int_swSetProf28                <= 1'b0;
      int_swSetProf27                <= 1'b0;
      int_swSetProf26                <= 1'b0;
      int_swSetProf25                <= 1'b0;
      int_swSetProf24                <= 1'b0;
      int_swSetProf23                <= 1'b0;
      int_swSetProf22                <= 1'b0;
      int_swSetProf21                <= 1'b0;
      int_swSetProf20                <= 1'b0;
      int_swSetProf19                <= 1'b0;
      int_swSetProf18                <= 1'b0;
      int_swSetProf17                <= 1'b0;
      int_swSetProf16                <= 1'b0;
      int_swSetProf15                <= 1'b0;
      int_swSetProf14                <= 1'b0;
      int_swSetProf13                <= 1'b0;
      int_swSetProf12                <= 1'b0;
      int_swSetProf11                <= 1'b0;
      int_swSetProf10                <= 1'b0;
      int_swSetProf9                 <= 1'b0;
      int_swSetProf8                 <= 1'b0;
      int_swSetProf7                 <= 1'b0;
      int_swSetProf6                 <= 1'b0;
      int_swSetProf5                 <= 1'b0;
      int_swSetProf4                 <= 1'b0;
      int_swSetProf3                 <= 1'b0;
      int_swSetProf2                 <= 1'b0;
      int_swSetProf1                 <= 1'b0;
      int_swSetProf0                 <= 1'b0;
      // SWCLEARPROFILINGREG register.
      int_swClearProf31              <= 1'b0;
      int_swClearProf30              <= 1'b0;
      int_swClearProf29              <= 1'b0;
      int_swClearProf28              <= 1'b0;
      int_swClearProf27              <= 1'b0;
      int_swClearProf26              <= 1'b0;
      int_swClearProf25              <= 1'b0;
      int_swClearProf24              <= 1'b0;
      int_swClearProf23              <= 1'b0;
      int_swClearProf22              <= 1'b0;
      int_swClearProf21              <= 1'b0;
      int_swClearProf20              <= 1'b0;
      int_swClearProf19              <= 1'b0;
      int_swClearProf18              <= 1'b0;
      int_swClearProf17              <= 1'b0;
      int_swClearProf16              <= 1'b0;
      int_swClearProf15              <= 1'b0;
      int_swClearProf14              <= 1'b0;
      int_swClearProf13              <= 1'b0;
      int_swClearProf12              <= 1'b0;
      int_swClearProf11              <= 1'b0;
      int_swClearProf10              <= 1'b0;
      int_swClearProf9               <= 1'b0;
      int_swClearProf8               <= 1'b0;
      int_swClearProf7               <= 1'b0;
      int_swClearProf6               <= 1'b0;
      int_swClearProf5               <= 1'b0;
      int_swClearProf4               <= 1'b0;
      int_swClearProf3               <= 1'b0;
      int_swClearProf2               <= 1'b0;
      int_swClearProf1               <= 1'b0;
      int_swClearProf0               <= 1'b0;
      // SWPROFILINGREG2 register.
      int_swProf63                   <= 1'b0;
      int_swProf62                   <= 1'b0;
      int_swProf61                   <= 1'b0;
      int_swProf60                   <= 1'b0;
      int_swProf59                   <= 1'b0;
      int_swProf58                   <= 1'b0;
      int_swProf57                   <= 1'b0;
      int_swProf56                   <= 1'b0;
      int_swProf55                   <= 1'b0;
      int_swProf54                   <= 1'b0;
      int_swProf53                   <= 1'b0;
      int_swProf52                   <= 1'b0;
      int_swProf51                   <= 1'b0;
      int_swProf50                   <= 1'b0;
      int_swProf49                   <= 1'b0;
      int_swProf48                   <= 1'b0;
      int_swProf47                   <= 1'b0;
      int_swProf46                   <= 1'b0;
      int_swProf45                   <= 1'b0;
      int_swProf44                   <= 1'b0;
      int_swProf43                   <= 1'b0;
      int_swProf42                   <= 1'b0;
      int_swProf41                   <= 1'b0;
      int_swProf40                   <= 1'b0;
      int_swProf39                   <= 1'b0;
      int_swProf38                   <= 1'b0;
      int_swProf37                   <= 1'b0;
      int_swProf36                   <= 1'b0;
      int_swProf35                   <= 1'b0;
      int_swProf34                   <= 1'b0;
      int_swProf33                   <= 1'b0;
      int_swProf32                   <= 1'b0;
      // SWSETPROFILINGREG2 register.
      int_swSetProf63                <= 1'b0;
      int_swSetProf62                <= 1'b0;
      int_swSetProf61                <= 1'b0;
      int_swSetProf60                <= 1'b0;
      int_swSetProf59                <= 1'b0;
      int_swSetProf58                <= 1'b0;
      int_swSetProf57                <= 1'b0;
      int_swSetProf56                <= 1'b0;
      int_swSetProf55                <= 1'b0;
      int_swSetProf54                <= 1'b0;
      int_swSetProf53                <= 1'b0;
      int_swSetProf52                <= 1'b0;
      int_swSetProf51                <= 1'b0;
      int_swSetProf50                <= 1'b0;
      int_swSetProf49                <= 1'b0;
      int_swSetProf48                <= 1'b0;
      int_swSetProf47                <= 1'b0;
      int_swSetProf46                <= 1'b0;
      int_swSetProf45                <= 1'b0;
      int_swSetProf44                <= 1'b0;
      int_swSetProf43                <= 1'b0;
      int_swSetProf42                <= 1'b0;
      int_swSetProf41                <= 1'b0;
      int_swSetProf40                <= 1'b0;
      int_swSetProf39                <= 1'b0;
      int_swSetProf38                <= 1'b0;
      int_swSetProf37                <= 1'b0;
      int_swSetProf36                <= 1'b0;
      int_swSetProf35                <= 1'b0;
      int_swSetProf34                <= 1'b0;
      int_swSetProf33                <= 1'b0;
      int_swSetProf32                <= 1'b0;
      // SWCLEARPROFILINGREG2 register.
      int_swClearProf63              <= 1'b0;
      int_swClearProf62              <= 1'b0;
      int_swClearProf61              <= 1'b0;
      int_swClearProf60              <= 1'b0;
      int_swClearProf59              <= 1'b0;
      int_swClearProf58              <= 1'b0;
      int_swClearProf57              <= 1'b0;
      int_swClearProf56              <= 1'b0;
      int_swClearProf55              <= 1'b0;
      int_swClearProf54              <= 1'b0;
      int_swClearProf53              <= 1'b0;
      int_swClearProf52              <= 1'b0;
      int_swClearProf51              <= 1'b0;
      int_swClearProf50              <= 1'b0;
      int_swClearProf49              <= 1'b0;
      int_swClearProf48              <= 1'b0;
      int_swClearProf47              <= 1'b0;
      int_swClearProf46              <= 1'b0;
      int_swClearProf45              <= 1'b0;
      int_swClearProf44              <= 1'b0;
      int_swClearProf43              <= 1'b0;
      int_swClearProf42              <= 1'b0;
      int_swClearProf41              <= 1'b0;
      int_swClearProf40              <= 1'b0;
      int_swClearProf39              <= 1'b0;
      int_swClearProf38              <= 1'b0;
      int_swClearProf37              <= 1'b0;
      int_swClearProf36              <= 1'b0;
      int_swClearProf35              <= 1'b0;
      int_swClearProf34              <= 1'b0;
      int_swClearProf33              <= 1'b0;
      int_swClearProf32              <= 1'b0;
`ifdef RW_MUMIMO_SEC_USER1_EN              
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              
`endif // RW_MUMIMO_SEC_USER3_EN              
    end
    else if (!softRstClk_n) 
    begin
	
      // DOZECNTRL2REG register.
      int_wakeUpFromDoze             <= 1'b0;
      int_wakeUpSW                   <= 1'b1;
      // MACCNTRL2REG register.
      int_softReset                  <= 1'b0;
      // GENINTEVENTSETREG register.
      int_settbTxDMADead             <= 1'b0;
      int_setrxPayloadDMADead        <= 1'b0;
      int_setrxHeaderDMADead         <= 1'b0;
      int_setphyRxStart              <= 1'b0;
      int_setphyErr                  <= 1'b0;
      int_setmacPHYIFUnderRun        <= 1'b0;
      int_sethwErr                   <= 1'b0;
      int_setimpSecDTIM              <= 1'b0;
      int_setimpPriDTIM              <= 1'b0;
      int_setbcnTxDMADead            <= 1'b0;
      int_setac3TxDMADead            <= 1'b0;
      int_setac2TxDMADead            <= 1'b0;
      int_setac1TxDMADead            <= 1'b0;
      int_setac0TxDMADead            <= 1'b0;
      int_setptError                 <= 1'b0;
      int_settimSet                  <= 1'b0;
      int_setolbcDSSS                <= 1'b0;
      int_setolbcOFDM                <= 1'b0;
      int_setrxFIFOOverFlow          <= 1'b0;
      int_setmacPHYIFOverflow        <= 1'b0;
      int_setcoexEvent               <= 1'b0;
      int_absGenTimers               <= 1'b0;
      int_setidleInterrupt           <= 1'b0;
      int_setimpSecTBTT              <= 1'b0;
      int_setimpPriTBTT              <= 1'b0;
      // GENINTEVENTCLEARREG register.
      int_cleartbTxDMADead           <= 1'b0;
      int_clearrxPayloadDMADead      <= 1'b0;
      int_clearrxHeaderDMADead       <= 1'b0;
      int_clearphyRxStart            <= 1'b0;
      int_clearphyErr                <= 1'b0;
      int_clearmacPHYIFUnderRun      <= 1'b0;
      int_clearhwErr                 <= 1'b0;
      int_clearimpSecDTIM            <= 1'b0;
      int_clearimpPriDTIM            <= 1'b0;
      int_clearbcnTxDMADead          <= 1'b0;
      int_clearac3TxDMADead          <= 1'b0;
      int_clearac2TxDMADead          <= 1'b0;
      int_clearac1TxDMADead          <= 1'b0;
      int_clearac0TxDMADead          <= 1'b0;
      int_clearptError               <= 1'b0;
      int_cleartimSet                <= 1'b0;
      int_clearolbcDSSS              <= 1'b0;
      int_clearolbcOFDM              <= 1'b0;
      int_clearrxFIFOOverFlow        <= 1'b0;
      int_clearmacPHYIFOverflow      <= 1'b0;
      int_clearcoexEvent             <= 1'b0;
      int_clearidleInterrupt         <= 1'b0;
      int_clearimpSecTBTT            <= 1'b0;
      int_clearimpPriTBTT            <= 1'b0;
      // GENINTUNMASKREG register.
      int_masterGenIntEn             <= 1'b0;
      int_masktbTxDMADead            <= 1'b0;
      int_maskrxPayloadDMADead       <= 1'b0;
      int_maskrxHeaderDMADead        <= 1'b0;
      int_maskphyRxStart             <= 1'b0;
      int_maskphyErr                 <= 1'b0;
      int_maskmacPHYIFUnderRun       <= 1'b0;
      int_maskhwErr                  <= 1'b0;
      int_maskimpSecDTIM             <= 1'b0;
      int_maskimpPriDTIM             <= 1'b0;
      int_maskbcnTxDMADead           <= 1'b0;
      int_maskac3TxDMADead           <= 1'b0;
      int_maskac2TxDMADead           <= 1'b0;
      int_maskac1TxDMADead           <= 1'b0;
      int_maskac0TxDMADead           <= 1'b0;
      int_maskptError                <= 1'b0;
      int_masktimSet                 <= 1'b0;
      int_maskolbcDSSS               <= 1'b0;
      int_maskolbcOFDM               <= 1'b0;
      int_maskrxFIFOOverFlow         <= 1'b0;
      int_maskmacPHYIFOverflow       <= 1'b0;
      int_maskcoexEvent              <= 1'b0;
      int_maskabsGenTimers           <= 1'b0;
      int_maskidleInterrupt          <= 1'b0;
      int_maskimpSecTBTT             <= 1'b0;
      int_maskimpPriTBTT             <= 1'b0;
      // TXRXINTEVENTSETREG register.
      int_settbTxBufTrigger          <= 1'b0;
      int_setbcnTxBufTrigger         <= 1'b0;
      int_setac3TxBufTrigger         <= 1'b0;
      int_setac2TxBufTrigger         <= 1'b0;
      int_setac1TxBufTrigger         <= 1'b0;
      int_setac0TxBufTrigger         <= 1'b0;
      int_setac3BWDropTrigger        <= 1'b0;
      int_setac2BWDropTrigger        <= 1'b0;
      int_setac1BWDropTrigger        <= 1'b0;
      int_setac0BWDropTrigger        <= 1'b0;
      int_setrxBuffer2Trigger        <= 1'b0;
      int_settimerRxTrigger          <= 1'b0;
      int_setrxBuffer1Trigger        <= 1'b0;
      int_setsecUserTxTrigger        <= 1'b0;
      int_settimerTxTrigger          <= 1'b0;
      int_settxopComplete            <= 1'b0;
      int_settbTxCancelled           <= 1'b0;
      int_settbTxTrigger             <= 1'b0;
      int_setbcnTxTrigger            <= 1'b0;
      int_setac3TxTrigger            <= 1'b0;
      int_setac2TxTrigger            <= 1'b0;
      int_setac1TxTrigger            <= 1'b0;
      int_setac0TxTrigger            <= 1'b0;
      int_settbProtTrigger           <= 1'b0;
      int_setac3ProtTrigger          <= 1'b0;
      int_setac2ProtTrigger          <= 1'b0;
      int_setac1ProtTrigger          <= 1'b0;
      int_setac0ProtTrigger          <= 1'b0;
      // TXRXINTEVENTCLEARREG register.
      int_cleartbTxBufTrigger        <= 1'b0;
      int_clearbcnTxBufTrigger       <= 1'b0;
      int_clearac3TxBufTrigger       <= 1'b0;
      int_clearac2TxBufTrigger       <= 1'b0;
      int_clearac1TxBufTrigger       <= 1'b0;
      int_clearac0TxBufTrigger       <= 1'b0;
      int_clearac3BWDropTrigger      <= 1'b0;
      int_clearac2BWDropTrigger      <= 1'b0;
      int_clearac1BWDropTrigger      <= 1'b0;
      int_clearac0BWDropTrigger      <= 1'b0;
      int_clearrxBuffer2Trigger      <= 1'b0;
      int_cleartimerRxTrigger        <= 1'b0;
      int_clearrxBuffer1Trigger      <= 1'b0;
      int_cleartimerTxTrigger        <= 1'b0;
      int_cleartxopComplete          <= 1'b0;
      int_cleartbTxCancelled         <= 1'b0;
      int_cleartbTxTrigger           <= 1'b0;
      int_clearbcnTxTrigger          <= 1'b0;
      int_clearac3TxTrigger          <= 1'b0;
      int_clearac2TxTrigger          <= 1'b0;
      int_clearac1TxTrigger          <= 1'b0;
      int_clearac0TxTrigger          <= 1'b0;
      int_cleartbProtTrigger         <= 1'b0;
      int_clearac3ProtTrigger        <= 1'b0;
      int_clearac2ProtTrigger        <= 1'b0;
      int_clearac1ProtTrigger        <= 1'b0;
      int_clearac0ProtTrigger        <= 1'b0;
      // TXRXINTUNMASKREG register.
      int_masterTxRxIntEn            <= 1'b0;
      int_masktbTxBufTrigger         <= 1'b0;
      int_maskbcnTxBufTrigger        <= 1'b0;
      int_maskac3TxBufTrigger        <= 1'b0;
      int_maskac2TxBufTrigger        <= 1'b0;
      int_maskac1TxBufTrigger        <= 1'b0;
      int_maskac0TxBufTrigger        <= 1'b0;
      int_maskac3BWDropTrigger       <= 1'b0;
      int_maskac2BWDropTrigger       <= 1'b0;
      int_maskac1BWDropTrigger       <= 1'b0;
      int_maskac0BWDropTrigger       <= 1'b0;
      int_maskrxBuffer2Trigger       <= 1'b0;
      int_masktimerRxTrigger         <= 1'b0;
      int_maskrxBuffer1Trigger       <= 1'b0;
      int_masksecUserTxTrigger       <= 1'b0;
      int_masktimerTxTrigger         <= 1'b0;
      int_masktxopComplete           <= 1'b0;
      int_masktbTxCancelled          <= 1'b0;
      int_masktbTxTrigger            <= 1'b0;
      int_maskbcnTxTrigger           <= 1'b0;
      int_maskac3TxTrigger           <= 1'b0;
      int_maskac2TxTrigger           <= 1'b0;
      int_maskac1TxTrigger           <= 1'b0;
      int_maskac0TxTrigger           <= 1'b0;
      int_masktbProtTrigger          <= 1'b0;
      int_maskac3ProtTrigger         <= 1'b0;
      int_maskac2ProtTrigger         <= 1'b0;
      int_maskac1ProtTrigger         <= 1'b0;
      int_maskac0ProtTrigger         <= 1'b0;
      // TIMERSINTEVENTSETREG register.
      int_setabsTimers9              <= 1'b0;
      int_setabsTimers8              <= 1'b0;
      int_setabsTimers7              <= 1'b0;
      int_setabsTimers6              <= 1'b0;
      int_setabsTimers5              <= 1'b0;
      int_setabsTimers4              <= 1'b0;
      int_setabsTimers3              <= 1'b0;
      int_setabsTimers2              <= 1'b0;
      int_setabsTimers1              <= 1'b0;
      int_setabsTimers0              <= 1'b0;
      // TIMERSINTEVENTCLEARREG register.
      int_clearabsTimers9            <= 1'b0;
      int_clearabsTimers8            <= 1'b0;
      int_clearabsTimers7            <= 1'b0;
      int_clearabsTimers6            <= 1'b0;
      int_clearabsTimers5            <= 1'b0;
      int_clearabsTimers4            <= 1'b0;
      int_clearabsTimers3            <= 1'b0;
      int_clearabsTimers2            <= 1'b0;
      int_clearabsTimers1            <= 1'b0;
      int_clearabsTimers0            <= 1'b0;
      // TIMERSINTUNMASKREG register.
      int_maskabsTimers9             <= 1'b0;
      int_maskabsTimers8             <= 1'b0;
      int_maskabsTimers7             <= 1'b0;
      int_maskabsTimers6             <= 1'b0;
      int_maskabsTimers5             <= 1'b0;
      int_maskabsTimers4             <= 1'b0;
      int_maskabsTimers3             <= 1'b0;
      int_maskabsTimers2             <= 1'b0;
      int_maskabsTimers1             <= 1'b0;
      int_maskabsTimers0             <= 1'b0;
      // TSFLOREG register.
      int_tsfTimerLow                <= 32'b0000000000000000000000000000000;
      // TSFHIREG register.
      int_tsfTimerHigh               <= 32'b0000000000000000000000000000000;
      // TIMEONAIRPARAM1REG register.
      int_ppduSTBC                   <= 2'b0;
      int_ppduNumExtnSS              <= 2'b0;
      int_ppduBW                     <= 2'b0;
      int_ppduGI                     <= 2'b0;
      int_ppduPreType                <= 4'b000;
      int_ppduLength                 <= 20'b0000000000000000000;
      // TIMEONAIRPARAM2REG register.
      int_ppduNumHeLtf               <= 3'b00;
      int_ppduNUser                  <= 7'b000000;
      int_ppduPE                     <= 3'b00;
      int_ppduMCSSigB                <= 3'b00;
      int_ppduDCMSigB                <= 1'b0;
      int_ppduSigBCompMode           <= 1'b0;
      int_ppduHELTFType              <= 2'b0;
      int_ppduDCM                    <= 1'b0;
      int_ppduMCSIndex               <= 7'b000000;
      // TIMEONAIRPARAM3REG register.
      int_ppduRuType                 <= 3'b00;
      int_ppduMma                    <= 1'b0;
      int_ppduDoppler                <= 1'b0;
      // TIMEONAIRVALUEREG register.
      int_computeDuration            <= 1'b0;
      // DMACNTRLSETREG register.
      int_sethaltTBAfterTXOP         <= 1'b0;
      int_sethaltAC3AfterTXOP        <= 1'b0;
      int_sethaltAC2AfterTXOP        <= 1'b0;
      int_sethaltAC1AfterTXOP        <= 1'b0;
      int_sethaltAC0AfterTXOP        <= 1'b0;
      int_sethaltBcnAfterTXOP        <= 1'b0;
      int_settxTBNewHead             <= 1'b0;
      int_settxAC3NewHead            <= 1'b0;
      int_settxAC2NewHead            <= 1'b0;
      int_settxAC1NewHead            <= 1'b0;
      int_settxAC0NewHead            <= 1'b0;
      int_settxBcnNewHead            <= 1'b0;
      int_settxAC3NewTail            <= 1'b0;
      int_settxAC2NewTail            <= 1'b0;
      int_settxAC1NewTail            <= 1'b0;
      int_settxAC0NewTail            <= 1'b0;
      int_settxBcnNewTail            <= 1'b0;
      // DMACNTRLCLEARREG register.
      int_clearhaltTBAfterTXOP       <= 1'b0;
      int_clearhaltAC3AfterTXOP      <= 1'b0;
      int_clearhaltAC2AfterTXOP      <= 1'b0;
      int_clearhaltAC1AfterTXOP      <= 1'b0;
      int_clearhaltAC0AfterTXOP      <= 1'b0;
      int_clearhaltBcnAfterTXOP      <= 1'b0;
      int_cleartxTBNewHead           <= 1'b0;
      int_cleartxAC3NewHead          <= 1'b0;
      int_cleartxAC2NewHead          <= 1'b0;
      int_cleartxAC1NewHead          <= 1'b0;
      int_cleartxAC0NewHead          <= 1'b0;
      int_cleartxBcnNewHead          <= 1'b0;
      int_cleartxAC3NewTail          <= 1'b0;
      int_cleartxAC2NewTail          <= 1'b0;
      int_cleartxAC1NewTail          <= 1'b0;
      int_cleartxAC0NewTail          <= 1'b0;
      int_cleartxBcnNewTail          <= 1'b0;
      // TXBCNHEADPTRREG register.
      int_txBcnHeadPtr               <= 32'b0000000000000000000000000000000;
      // TXAC0HEADPTRREG register.
      int_txAC0HeadPtr               <= 32'b0000000000000000000000000000000;
      // TXAC1HEADPTRREG register.
      int_txAC1HeadPtr               <= 32'b0000000000000000000000000000000;
      // TXAC2HEADPTRREG register.
      int_txAC2HeadPtr               <= 32'b0000000000000000000000000000000;
      // TXAC3HEADPTRREG register.
      int_txAC3HeadPtr               <= 32'b0000000000000000000000000000000;
      // TXTBHEADPTRREG register.
      int_txTBHeadPtr                <= 32'b0000000000000000000000000000000;
      // TXSTRUCTSIZESREG register.
      int_dmaRBDSize                 <= 6'd`RBD_SIZE;
      int_dmaRHDSize                 <= 6'd`RHD_SIZE;
      int_dmaTBDSize                 <= 6'd`TBD_SIZE;
      int_dmaTHDSize                 <= 6'd`THD_SIZE;
      int_ptEntrySize                <= 6'd`PT_SIZE;
      // DMATHRESHOLDREG register.
      int_rxFIFOThreshold            <= 8'b0010000;
      int_txFIFOThreshold            <= 8'b0010000;
      // RXBUF1STARTPTRREG register.
      int_rxBuf1StartPtr             <= 31'b000000000000000000000000000000;
      // RXBUF1ENDPTRREG register.
      int_rxBuf1EndPtr               <= 31'b000000000000000000000000000000;
      // RXBUF1RDPTRREG register.
      int_rxBuf1RdPtr                <= 32'b0000000000000000000000000000000;
      // RXBUF1WRPTRREG register.
      int_rxBuf1WrPtr                <= 32'b0000000000000000000000000000000;
      // RXBUF2STARTPTRREG register.
      int_rxBuf2StartPtr             <= 31'b000000000000000000000000000000;
      // RXBUF2ENDPTRREG register.
      int_rxBuf2EndPtr               <= 31'b000000000000000000000000000000;
      // RXBUF2RDPTRREG register.
      int_rxBuf2RdPtr                <= 32'b0000000000000000000000000000000;
      // RXBUF2WRPTRREG register.
      int_rxBuf2WrPtr                <= 32'b0000000000000000000000000000000;
      // RXBUFCONFIGREG register.
      int_rxBufRPDFooter             <= 8'b0000000;
      int_rxBufRPDHeader             <= 8'b0000000;
      int_rxBufRHDFooter             <= 8'b0000000;
      int_rxBufRHDHeader             <= 8'b0000000;
      // TXHETBINFOREG register.
      int_maxMCSInHETB               <= 4'b111;
      int_eOCW                       <= 3'b11;
      int_eOCWMin                    <= 3'b11;
      int_raRUType                   <= 1'b0;
      int_raRUEnable                 <= 1'b0;
      int_txHETBMaxDur               <= 6'b11100;
`ifdef RW_MUMIMO_TX_EN                     
      // SECUSERSTXINTEVENTSETREG register.
      int_setsecU3ac3TxBufTrigger    <= 1'b0;
      int_setsecU3ac2TxBufTrigger    <= 1'b0;
      int_setsecU3ac1TxBufTrigger    <= 1'b0;
      int_setsecU3ac0TxBufTrigger    <= 1'b0;
      int_setsecU3ac3TxTrigger       <= 1'b0;
      int_setsecU3ac2TxTrigger       <= 1'b0;
      int_setsecU3ac1TxTrigger       <= 1'b0;
      int_setsecU3ac0TxTrigger       <= 1'b0;
      int_setsecU2ac3TxBufTrigger    <= 1'b0;
      int_setsecU2ac2TxBufTrigger    <= 1'b0;
      int_setsecU2ac1TxBufTrigger    <= 1'b0;
      int_setsecU2ac0TxBufTrigger    <= 1'b0;
      int_setsecU2ac3TxTrigger       <= 1'b0;
      int_setsecU2ac2TxTrigger       <= 1'b0;
      int_setsecU2ac1TxTrigger       <= 1'b0;
      int_setsecU2ac0TxTrigger       <= 1'b0;
      int_setsecU1ac3TxBufTrigger    <= 1'b0;
      int_setsecU1ac2TxBufTrigger    <= 1'b0;
      int_setsecU1ac1TxBufTrigger    <= 1'b0;
      int_setsecU1ac0TxBufTrigger    <= 1'b0;
      int_setsecU1ac3TxTrigger       <= 1'b0;
      int_setsecU1ac2TxTrigger       <= 1'b0;
      int_setsecU1ac1TxTrigger       <= 1'b0;
      int_setsecU1ac0TxTrigger       <= 1'b0;
      // SECUSERSTXINTEVENTCLEARREG register.
      int_clearsecU3ac3TxBufTrigger  <= 1'b0;
      int_clearsecU3ac2TxBufTrigger  <= 1'b0;
      int_clearsecU3ac1TxBufTrigger  <= 1'b0;
      int_clearsecU3ac0TxBufTrigger  <= 1'b0;
      int_clearsecU3ac3TxTrigger     <= 1'b0;
      int_clearsecU3ac2TxTrigger     <= 1'b0;
      int_clearsecU3ac1TxTrigger     <= 1'b0;
      int_clearsecU3ac0TxTrigger     <= 1'b0;
      int_clearsecU2ac3TxBufTrigger  <= 1'b0;
      int_clearsecU2ac2TxBufTrigger  <= 1'b0;
      int_clearsecU2ac1TxBufTrigger  <= 1'b0;
      int_clearsecU2ac0TxBufTrigger  <= 1'b0;
      int_clearsecU2ac3TxTrigger     <= 1'b0;
      int_clearsecU2ac2TxTrigger     <= 1'b0;
      int_clearsecU2ac1TxTrigger     <= 1'b0;
      int_clearsecU2ac0TxTrigger     <= 1'b0;
      int_clearsecU1ac3TxBufTrigger  <= 1'b0;
      int_clearsecU1ac2TxBufTrigger  <= 1'b0;
      int_clearsecU1ac1TxBufTrigger  <= 1'b0;
      int_clearsecU1ac0TxBufTrigger  <= 1'b0;
      int_clearsecU1ac3TxTrigger     <= 1'b0;
      int_clearsecU1ac2TxTrigger     <= 1'b0;
      int_clearsecU1ac1TxTrigger     <= 1'b0;
      int_clearsecU1ac0TxTrigger     <= 1'b0;
      // SECUSERSTXINTEVENTUNMASKREG register.
      int_masterSecUsersTxIntEn      <= 1'b0;
      int_masksecU3ac3TxBufTrigger   <= 1'b0;
      int_masksecU3ac2TxBufTrigger   <= 1'b0;
      int_masksecU3ac1TxBufTrigger   <= 1'b0;
      int_masksecU3ac0TxBufTrigger   <= 1'b0;
      int_masksecU3ac3TxTrigger      <= 1'b0;
      int_masksecU3ac2TxTrigger      <= 1'b0;
      int_masksecU3ac1TxTrigger      <= 1'b0;
      int_masksecU3ac0TxTrigger      <= 1'b0;
      int_masksecU2ac3TxBufTrigger   <= 1'b0;
      int_masksecU2ac2TxBufTrigger   <= 1'b0;
      int_masksecU2ac1TxBufTrigger   <= 1'b0;
      int_masksecU2ac0TxBufTrigger   <= 1'b0;
      int_masksecU2ac3TxTrigger      <= 1'b0;
      int_masksecU2ac2TxTrigger      <= 1'b0;
      int_masksecU2ac1TxTrigger      <= 1'b0;
      int_masksecU2ac0TxTrigger      <= 1'b0;
      int_masksecU1ac3TxBufTrigger   <= 1'b0;
      int_masksecU1ac2TxBufTrigger   <= 1'b0;
      int_masksecU1ac1TxBufTrigger   <= 1'b0;
      int_masksecU1ac0TxBufTrigger   <= 1'b0;
      int_masksecU1ac3TxTrigger      <= 1'b0;
      int_masksecU1ac2TxTrigger      <= 1'b0;
      int_masksecU1ac1TxTrigger      <= 1'b0;
      int_masksecU1ac0TxTrigger      <= 1'b0;
`endif // RW_MUMIMO_TX_EN                     
      // DEBUGTBSPTRREG register.
      // SWPROFILINGREG register.
      int_swProf31                   <= 1'b0;
      int_swProf30                   <= 1'b0;
      int_swProf29                   <= 1'b0;
      int_swProf28                   <= 1'b0;
      int_swProf27                   <= 1'b0;
      int_swProf26                   <= 1'b0;
      int_swProf25                   <= 1'b0;
      int_swProf24                   <= 1'b0;
      int_swProf23                   <= 1'b0;
      int_swProf22                   <= 1'b0;
      int_swProf21                   <= 1'b0;
      int_swProf20                   <= 1'b0;
      int_swProf19                   <= 1'b0;
      int_swProf18                   <= 1'b0;
      int_swProf17                   <= 1'b0;
      int_swProf16                   <= 1'b0;
      int_swProf15                   <= 1'b0;
      int_swProf14                   <= 1'b0;
      int_swProf13                   <= 1'b0;
      int_swProf12                   <= 1'b0;
      int_swProf11                   <= 1'b0;
      int_swProf10                   <= 1'b0;
      int_swProf9                    <= 1'b0;
      int_swProf8                    <= 1'b0;
      int_swProf7                    <= 1'b0;
      int_swProf6                    <= 1'b0;
      int_swProf5                    <= 1'b0;
      int_swProf4                    <= 1'b0;
      int_swProf3                    <= 1'b0;
      int_swProf2                    <= 1'b0;
      int_swProf1                    <= 1'b0;
      int_swProf0                    <= 1'b0;
      // SWSETPROFILINGREG register.
      int_swSetProf31                <= 1'b0;
      int_swSetProf30                <= 1'b0;
      int_swSetProf29                <= 1'b0;
      int_swSetProf28                <= 1'b0;
      int_swSetProf27                <= 1'b0;
      int_swSetProf26                <= 1'b0;
      int_swSetProf25                <= 1'b0;
      int_swSetProf24                <= 1'b0;
      int_swSetProf23                <= 1'b0;
      int_swSetProf22                <= 1'b0;
      int_swSetProf21                <= 1'b0;
      int_swSetProf20                <= 1'b0;
      int_swSetProf19                <= 1'b0;
      int_swSetProf18                <= 1'b0;
      int_swSetProf17                <= 1'b0;
      int_swSetProf16                <= 1'b0;
      int_swSetProf15                <= 1'b0;
      int_swSetProf14                <= 1'b0;
      int_swSetProf13                <= 1'b0;
      int_swSetProf12                <= 1'b0;
      int_swSetProf11                <= 1'b0;
      int_swSetProf10                <= 1'b0;
      int_swSetProf9                 <= 1'b0;
      int_swSetProf8                 <= 1'b0;
      int_swSetProf7                 <= 1'b0;
      int_swSetProf6                 <= 1'b0;
      int_swSetProf5                 <= 1'b0;
      int_swSetProf4                 <= 1'b0;
      int_swSetProf3                 <= 1'b0;
      int_swSetProf2                 <= 1'b0;
      int_swSetProf1                 <= 1'b0;
      int_swSetProf0                 <= 1'b0;
      // SWCLEARPROFILINGREG register.
      int_swClearProf31              <= 1'b0;
      int_swClearProf30              <= 1'b0;
      int_swClearProf29              <= 1'b0;
      int_swClearProf28              <= 1'b0;
      int_swClearProf27              <= 1'b0;
      int_swClearProf26              <= 1'b0;
      int_swClearProf25              <= 1'b0;
      int_swClearProf24              <= 1'b0;
      int_swClearProf23              <= 1'b0;
      int_swClearProf22              <= 1'b0;
      int_swClearProf21              <= 1'b0;
      int_swClearProf20              <= 1'b0;
      int_swClearProf19              <= 1'b0;
      int_swClearProf18              <= 1'b0;
      int_swClearProf17              <= 1'b0;
      int_swClearProf16              <= 1'b0;
      int_swClearProf15              <= 1'b0;
      int_swClearProf14              <= 1'b0;
      int_swClearProf13              <= 1'b0;
      int_swClearProf12              <= 1'b0;
      int_swClearProf11              <= 1'b0;
      int_swClearProf10              <= 1'b0;
      int_swClearProf9               <= 1'b0;
      int_swClearProf8               <= 1'b0;
      int_swClearProf7               <= 1'b0;
      int_swClearProf6               <= 1'b0;
      int_swClearProf5               <= 1'b0;
      int_swClearProf4               <= 1'b0;
      int_swClearProf3               <= 1'b0;
      int_swClearProf2               <= 1'b0;
      int_swClearProf1               <= 1'b0;
      int_swClearProf0               <= 1'b0;
      // SWPROFILINGREG2 register.
      int_swProf63                   <= 1'b0;
      int_swProf62                   <= 1'b0;
      int_swProf61                   <= 1'b0;
      int_swProf60                   <= 1'b0;
      int_swProf59                   <= 1'b0;
      int_swProf58                   <= 1'b0;
      int_swProf57                   <= 1'b0;
      int_swProf56                   <= 1'b0;
      int_swProf55                   <= 1'b0;
      int_swProf54                   <= 1'b0;
      int_swProf53                   <= 1'b0;
      int_swProf52                   <= 1'b0;
      int_swProf51                   <= 1'b0;
      int_swProf50                   <= 1'b0;
      int_swProf49                   <= 1'b0;
      int_swProf48                   <= 1'b0;
      int_swProf47                   <= 1'b0;
      int_swProf46                   <= 1'b0;
      int_swProf45                   <= 1'b0;
      int_swProf44                   <= 1'b0;
      int_swProf43                   <= 1'b0;
      int_swProf42                   <= 1'b0;
      int_swProf41                   <= 1'b0;
      int_swProf40                   <= 1'b0;
      int_swProf39                   <= 1'b0;
      int_swProf38                   <= 1'b0;
      int_swProf37                   <= 1'b0;
      int_swProf36                   <= 1'b0;
      int_swProf35                   <= 1'b0;
      int_swProf34                   <= 1'b0;
      int_swProf33                   <= 1'b0;
      int_swProf32                   <= 1'b0;
      // SWSETPROFILINGREG2 register.
      int_swSetProf63                <= 1'b0;
      int_swSetProf62                <= 1'b0;
      int_swSetProf61                <= 1'b0;
      int_swSetProf60                <= 1'b0;
      int_swSetProf59                <= 1'b0;
      int_swSetProf58                <= 1'b0;
      int_swSetProf57                <= 1'b0;
      int_swSetProf56                <= 1'b0;
      int_swSetProf55                <= 1'b0;
      int_swSetProf54                <= 1'b0;
      int_swSetProf53                <= 1'b0;
      int_swSetProf52                <= 1'b0;
      int_swSetProf51                <= 1'b0;
      int_swSetProf50                <= 1'b0;
      int_swSetProf49                <= 1'b0;
      int_swSetProf48                <= 1'b0;
      int_swSetProf47                <= 1'b0;
      int_swSetProf46                <= 1'b0;
      int_swSetProf45                <= 1'b0;
      int_swSetProf44                <= 1'b0;
      int_swSetProf43                <= 1'b0;
      int_swSetProf42                <= 1'b0;
      int_swSetProf41                <= 1'b0;
      int_swSetProf40                <= 1'b0;
      int_swSetProf39                <= 1'b0;
      int_swSetProf38                <= 1'b0;
      int_swSetProf37                <= 1'b0;
      int_swSetProf36                <= 1'b0;
      int_swSetProf35                <= 1'b0;
      int_swSetProf34                <= 1'b0;
      int_swSetProf33                <= 1'b0;
      int_swSetProf32                <= 1'b0;
      // SWCLEARPROFILINGREG2 register.
      int_swClearProf63              <= 1'b0;
      int_swClearProf62              <= 1'b0;
      int_swClearProf61              <= 1'b0;
      int_swClearProf60              <= 1'b0;
      int_swClearProf59              <= 1'b0;
      int_swClearProf58              <= 1'b0;
      int_swClearProf57              <= 1'b0;
      int_swClearProf56              <= 1'b0;
      int_swClearProf55              <= 1'b0;
      int_swClearProf54              <= 1'b0;
      int_swClearProf53              <= 1'b0;
      int_swClearProf52              <= 1'b0;
      int_swClearProf51              <= 1'b0;
      int_swClearProf50              <= 1'b0;
      int_swClearProf49              <= 1'b0;
      int_swClearProf48              <= 1'b0;
      int_swClearProf47              <= 1'b0;
      int_swClearProf46              <= 1'b0;
      int_swClearProf45              <= 1'b0;
      int_swClearProf44              <= 1'b0;
      int_swClearProf43              <= 1'b0;
      int_swClearProf42              <= 1'b0;
      int_swClearProf41              <= 1'b0;
      int_swClearProf40              <= 1'b0;
      int_swClearProf39              <= 1'b0;
      int_swClearProf38              <= 1'b0;
      int_swClearProf37              <= 1'b0;
      int_swClearProf36              <= 1'b0;
      int_swClearProf35              <= 1'b0;
      int_swClearProf34              <= 1'b0;
      int_swClearProf33              <= 1'b0;
      int_swClearProf32              <= 1'b0;
`ifdef RW_MUMIMO_SEC_USER1_EN              
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              
`endif // RW_MUMIMO_SEC_USER3_EN              
    end

    else
    begin
      if (tsfTimerLowInValid)
        int_tsfTimerLow                <= tsfTimerLowIn;
      if (tsfTimerHighInValid)
        int_tsfTimerHigh               <= tsfTimerHighIn;
      if (computeDurationInValid)
        int_computeDuration            <= computeDurationIn;
      if (rxBuf1WrPtrInValid)
        int_rxBuf1WrPtr                <= rxBuf1WrPtrIn;
      if (rxBuf2WrPtrInValid)
        int_rxBuf2WrPtr                <= rxBuf2WrPtrIn;
      if (eOCWInValid)
        int_eOCW                       <= eOCWIn;
`ifdef RW_MUMIMO_TX_EN                     
`endif // RW_MUMIMO_TX_EN                     
      if (swProf31InValid)
        int_swProf31                   <= swProf31In;
      if (swProf30InValid)
        int_swProf30                   <= swProf30In;
      if (swProf29InValid)
        int_swProf29                   <= swProf29In;
      if (swProf28InValid)
        int_swProf28                   <= swProf28In;
      if (swProf27InValid)
        int_swProf27                   <= swProf27In;
      if (swProf26InValid)
        int_swProf26                   <= swProf26In;
      if (swProf25InValid)
        int_swProf25                   <= swProf25In;
      if (swProf24InValid)
        int_swProf24                   <= swProf24In;
      if (swProf23InValid)
        int_swProf23                   <= swProf23In;
      if (swProf22InValid)
        int_swProf22                   <= swProf22In;
      if (swProf21InValid)
        int_swProf21                   <= swProf21In;
      if (swProf20InValid)
        int_swProf20                   <= swProf20In;
      if (swProf19InValid)
        int_swProf19                   <= swProf19In;
      if (swProf18InValid)
        int_swProf18                   <= swProf18In;
      if (swProf17InValid)
        int_swProf17                   <= swProf17In;
      if (swProf16InValid)
        int_swProf16                   <= swProf16In;
      if (swProf15InValid)
        int_swProf15                   <= swProf15In;
      if (swProf14InValid)
        int_swProf14                   <= swProf14In;
      if (swProf13InValid)
        int_swProf13                   <= swProf13In;
      if (swProf12InValid)
        int_swProf12                   <= swProf12In;
      if (swProf11InValid)
        int_swProf11                   <= swProf11In;
      if (swProf10InValid)
        int_swProf10                   <= swProf10In;
      if (swProf9InValid)
        int_swProf9                    <= swProf9In;
      if (swProf8InValid)
        int_swProf8                    <= swProf8In;
      if (swProf7InValid)
        int_swProf7                    <= swProf7In;
      if (swProf6InValid)
        int_swProf6                    <= swProf6In;
      if (swProf5InValid)
        int_swProf5                    <= swProf5In;
      if (swProf4InValid)
        int_swProf4                    <= swProf4In;
      if (swProf3InValid)
        int_swProf3                    <= swProf3In;
      if (swProf2InValid)
        int_swProf2                    <= swProf2In;
      if (swProf1InValid)
        int_swProf1                    <= swProf1In;
      if (swProf0InValid)
        int_swProf0                    <= swProf0In;
      if (swProf63InValid)
        int_swProf63                   <= swProf63In;
      if (swProf62InValid)
        int_swProf62                   <= swProf62In;
      if (swProf61InValid)
        int_swProf61                   <= swProf61In;
      if (swProf60InValid)
        int_swProf60                   <= swProf60In;
      if (swProf59InValid)
        int_swProf59                   <= swProf59In;
      if (swProf58InValid)
        int_swProf58                   <= swProf58In;
      if (swProf57InValid)
        int_swProf57                   <= swProf57In;
      if (swProf56InValid)
        int_swProf56                   <= swProf56In;
      if (swProf55InValid)
        int_swProf55                   <= swProf55In;
      if (swProf54InValid)
        int_swProf54                   <= swProf54In;
      if (swProf53InValid)
        int_swProf53                   <= swProf53In;
      if (swProf52InValid)
        int_swProf52                   <= swProf52In;
      if (swProf51InValid)
        int_swProf51                   <= swProf51In;
      if (swProf50InValid)
        int_swProf50                   <= swProf50In;
      if (swProf49InValid)
        int_swProf49                   <= swProf49In;
      if (swProf48InValid)
        int_swProf48                   <= swProf48In;
      if (swProf47InValid)
        int_swProf47                   <= swProf47In;
      if (swProf46InValid)
        int_swProf46                   <= swProf46In;
      if (swProf45InValid)
        int_swProf45                   <= swProf45In;
      if (swProf44InValid)
        int_swProf44                   <= swProf44In;
      if (swProf43InValid)
        int_swProf43                   <= swProf43In;
      if (swProf42InValid)
        int_swProf42                   <= swProf42In;
      if (swProf41InValid)
        int_swProf41                   <= swProf41In;
      if (swProf40InValid)
        int_swProf40                   <= swProf40In;
      if (swProf39InValid)
        int_swProf39                   <= swProf39In;
      if (swProf38InValid)
        int_swProf38                   <= swProf38In;
      if (swProf37InValid)
        int_swProf37                   <= swProf37In;
      if (swProf36InValid)
        int_swProf36                   <= swProf36In;
      if (swProf35InValid)
        int_swProf35                   <= swProf35In;
      if (swProf34InValid)
        int_swProf34                   <= swProf34In;
      if (swProf33InValid)
        int_swProf33                   <= swProf33In;
      if (swProf32InValid)
        int_swProf32                   <= swProf32In;
`ifdef RW_MUMIMO_SEC_USER1_EN              
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              
`endif // RW_MUMIMO_SEC_USER3_EN              
      if(regSel && regWrite)
      begin
        case(regAddr)

          // Write DOZECNTRL2REG register.
          DOZECNTRL2REG_ADDR_CT : begin
            int_wakeUpFromDoze             <= regWriteData[31];
            int_wakeUpSW                   <= regWriteData[0];
          end

          // Write MACCNTRL2REG register.
          MACCNTRL2REG_ADDR_CT : begin
            int_softReset                  <= regWriteData[0];
          end

          // Write GENINTEVENTSETREG register.
          GENINTEVENTSETREG_ADDR_CT : begin
            int_settbTxDMADead             <= regWriteData[26];
            int_setrxPayloadDMADead        <= regWriteData[25];
            int_setrxHeaderDMADead         <= regWriteData[24];
            int_setphyRxStart              <= regWriteData[23];
            int_setphyErr                  <= regWriteData[22];
            int_setmacPHYIFUnderRun        <= regWriteData[21];
            int_sethwErr                   <= regWriteData[20];
            int_setimpSecDTIM              <= regWriteData[19];
            int_setimpPriDTIM              <= regWriteData[18];
            int_setbcnTxDMADead            <= regWriteData[17];
            int_setac3TxDMADead            <= regWriteData[16];
            int_setac2TxDMADead            <= regWriteData[15];
            int_setac1TxDMADead            <= regWriteData[14];
            int_setac0TxDMADead            <= regWriteData[13];
            int_setptError                 <= regWriteData[12];
            int_settimSet                  <= regWriteData[11];
            int_setolbcDSSS                <= regWriteData[10];
            int_setolbcOFDM                <= regWriteData[9];
            int_setrxFIFOOverFlow          <= regWriteData[8];
            int_setmacPHYIFOverflow        <= regWriteData[6];
            int_setcoexEvent               <= regWriteData[5];
            int_absGenTimers               <= regWriteData[3];
            int_setidleInterrupt           <= regWriteData[2];
            int_setimpSecTBTT              <= regWriteData[1];
            int_setimpPriTBTT              <= regWriteData[0];
          end

          // Write GENINTEVENTCLEARREG register.
          GENINTEVENTCLEARREG_ADDR_CT : begin
            int_cleartbTxDMADead           <= regWriteData[26];
            int_clearrxPayloadDMADead      <= regWriteData[25];
            int_clearrxHeaderDMADead       <= regWriteData[24];
            int_clearphyRxStart            <= regWriteData[23];
            int_clearphyErr                <= regWriteData[22];
            int_clearmacPHYIFUnderRun      <= regWriteData[21];
            int_clearhwErr                 <= regWriteData[20];
            int_clearimpSecDTIM            <= regWriteData[19];
            int_clearimpPriDTIM            <= regWriteData[18];
            int_clearbcnTxDMADead          <= regWriteData[17];
            int_clearac3TxDMADead          <= regWriteData[16];
            int_clearac2TxDMADead          <= regWriteData[15];
            int_clearac1TxDMADead          <= regWriteData[14];
            int_clearac0TxDMADead          <= regWriteData[13];
            int_clearptError               <= regWriteData[12];
            int_cleartimSet                <= regWriteData[11];
            int_clearolbcDSSS              <= regWriteData[10];
            int_clearolbcOFDM              <= regWriteData[9];
            int_clearrxFIFOOverFlow        <= regWriteData[8];
            int_clearmacPHYIFOverflow      <= regWriteData[6];
            int_clearcoexEvent             <= regWriteData[5];
            int_clearidleInterrupt         <= regWriteData[2];
            int_clearimpSecTBTT            <= regWriteData[1];
            int_clearimpPriTBTT            <= regWriteData[0];
          end

          // Write GENINTUNMASKREG register.
          GENINTUNMASKREG_ADDR_CT : begin
            int_masterGenIntEn             <= regWriteData[31];
            int_masktbTxDMADead            <= regWriteData[26];
            int_maskrxPayloadDMADead       <= regWriteData[25];
            int_maskrxHeaderDMADead        <= regWriteData[24];
            int_maskphyRxStart             <= regWriteData[23];
            int_maskphyErr                 <= regWriteData[22];
            int_maskmacPHYIFUnderRun       <= regWriteData[21];
            int_maskhwErr                  <= regWriteData[20];
            int_maskimpSecDTIM             <= regWriteData[19];
            int_maskimpPriDTIM             <= regWriteData[18];
            int_maskbcnTxDMADead           <= regWriteData[17];
            int_maskac3TxDMADead           <= regWriteData[16];
            int_maskac2TxDMADead           <= regWriteData[15];
            int_maskac1TxDMADead           <= regWriteData[14];
            int_maskac0TxDMADead           <= regWriteData[13];
            int_maskptError                <= regWriteData[12];
            int_masktimSet                 <= regWriteData[11];
            int_maskolbcDSSS               <= regWriteData[10];
            int_maskolbcOFDM               <= regWriteData[9];
            int_maskrxFIFOOverFlow         <= regWriteData[8];
            int_maskmacPHYIFOverflow       <= regWriteData[6];
            int_maskcoexEvent              <= regWriteData[5];
            int_maskabsGenTimers           <= regWriteData[3];
            int_maskidleInterrupt          <= regWriteData[2];
            int_maskimpSecTBTT             <= regWriteData[1];
            int_maskimpPriTBTT             <= regWriteData[0];
          end

          // Write TXRXINTEVENTSETREG register.
          TXRXINTEVENTSETREG_ADDR_CT : begin
            int_settbTxBufTrigger          <= regWriteData[29];
            int_setbcnTxBufTrigger         <= regWriteData[28];
            int_setac3TxBufTrigger         <= regWriteData[27];
            int_setac2TxBufTrigger         <= regWriteData[26];
            int_setac1TxBufTrigger         <= regWriteData[25];
            int_setac0TxBufTrigger         <= regWriteData[24];
            int_setac3BWDropTrigger        <= regWriteData[23];
            int_setac2BWDropTrigger        <= regWriteData[22];
            int_setac1BWDropTrigger        <= regWriteData[21];
            int_setac0BWDropTrigger        <= regWriteData[20];
            int_setrxBuffer2Trigger        <= regWriteData[18];
            int_settimerRxTrigger          <= regWriteData[17];
            int_setrxBuffer1Trigger        <= regWriteData[16];
            int_setsecUserTxTrigger        <= regWriteData[15];
            int_settimerTxTrigger          <= regWriteData[14];
            int_settxopComplete            <= regWriteData[13];
            int_settbTxCancelled           <= regWriteData[12];
            int_settbTxTrigger             <= regWriteData[11];
            int_setbcnTxTrigger            <= regWriteData[10];
            int_setac3TxTrigger            <= regWriteData[9];
            int_setac2TxTrigger            <= regWriteData[8];
            int_setac1TxTrigger            <= regWriteData[7];
            int_setac0TxTrigger            <= regWriteData[6];
            int_settbProtTrigger           <= regWriteData[4];
            int_setac3ProtTrigger          <= regWriteData[3];
            int_setac2ProtTrigger          <= regWriteData[2];
            int_setac1ProtTrigger          <= regWriteData[1];
            int_setac0ProtTrigger          <= regWriteData[0];
          end

          // Write TXRXINTEVENTCLEARREG register.
          TXRXINTEVENTCLEARREG_ADDR_CT : begin
            int_cleartbTxBufTrigger        <= regWriteData[29];
            int_clearbcnTxBufTrigger       <= regWriteData[28];
            int_clearac3TxBufTrigger       <= regWriteData[27];
            int_clearac2TxBufTrigger       <= regWriteData[26];
            int_clearac1TxBufTrigger       <= regWriteData[25];
            int_clearac0TxBufTrigger       <= regWriteData[24];
            int_clearac3BWDropTrigger      <= regWriteData[23];
            int_clearac2BWDropTrigger      <= regWriteData[22];
            int_clearac1BWDropTrigger      <= regWriteData[21];
            int_clearac0BWDropTrigger      <= regWriteData[20];
            int_clearrxBuffer2Trigger      <= regWriteData[18];
            int_cleartimerRxTrigger        <= regWriteData[17];
            int_clearrxBuffer1Trigger      <= regWriteData[16];
            int_cleartimerTxTrigger        <= regWriteData[14];
            int_cleartxopComplete          <= regWriteData[13];
            int_cleartbTxCancelled         <= regWriteData[12];
            int_cleartbTxTrigger           <= regWriteData[11];
            int_clearbcnTxTrigger          <= regWriteData[10];
            int_clearac3TxTrigger          <= regWriteData[9];
            int_clearac2TxTrigger          <= regWriteData[8];
            int_clearac1TxTrigger          <= regWriteData[7];
            int_clearac0TxTrigger          <= regWriteData[6];
            int_cleartbProtTrigger         <= regWriteData[4];
            int_clearac3ProtTrigger        <= regWriteData[3];
            int_clearac2ProtTrigger        <= regWriteData[2];
            int_clearac1ProtTrigger        <= regWriteData[1];
            int_clearac0ProtTrigger        <= regWriteData[0];
          end

          // Write TXRXINTUNMASKREG register.
          TXRXINTUNMASKREG_ADDR_CT : begin
            int_masterTxRxIntEn            <= regWriteData[31];
            int_masktbTxBufTrigger         <= regWriteData[29];
            int_maskbcnTxBufTrigger        <= regWriteData[28];
            int_maskac3TxBufTrigger        <= regWriteData[27];
            int_maskac2TxBufTrigger        <= regWriteData[26];
            int_maskac1TxBufTrigger        <= regWriteData[25];
            int_maskac0TxBufTrigger        <= regWriteData[24];
            int_maskac3BWDropTrigger       <= regWriteData[23];
            int_maskac2BWDropTrigger       <= regWriteData[22];
            int_maskac1BWDropTrigger       <= regWriteData[21];
            int_maskac0BWDropTrigger       <= regWriteData[20];
            int_maskrxBuffer2Trigger       <= regWriteData[18];
            int_masktimerRxTrigger         <= regWriteData[17];
            int_maskrxBuffer1Trigger       <= regWriteData[16];
            int_masksecUserTxTrigger       <= regWriteData[15];
            int_masktimerTxTrigger         <= regWriteData[14];
            int_masktxopComplete           <= regWriteData[13];
            int_masktbTxCancelled          <= regWriteData[12];
            int_masktbTxTrigger            <= regWriteData[11];
            int_maskbcnTxTrigger           <= regWriteData[10];
            int_maskac3TxTrigger           <= regWriteData[9];
            int_maskac2TxTrigger           <= regWriteData[8];
            int_maskac1TxTrigger           <= regWriteData[7];
            int_maskac0TxTrigger           <= regWriteData[6];
            int_masktbProtTrigger          <= regWriteData[4];
            int_maskac3ProtTrigger         <= regWriteData[3];
            int_maskac2ProtTrigger         <= regWriteData[2];
            int_maskac1ProtTrigger         <= regWriteData[1];
            int_maskac0ProtTrigger         <= regWriteData[0];
          end

          // Write TIMERSINTEVENTSETREG register.
          TIMERSINTEVENTSETREG_ADDR_CT : begin
            int_setabsTimers9              <= regWriteData[9];
            int_setabsTimers8              <= regWriteData[8];
            int_setabsTimers7              <= regWriteData[7];
            int_setabsTimers6              <= regWriteData[6];
            int_setabsTimers5              <= regWriteData[5];
            int_setabsTimers4              <= regWriteData[4];
            int_setabsTimers3              <= regWriteData[3];
            int_setabsTimers2              <= regWriteData[2];
            int_setabsTimers1              <= regWriteData[1];
            int_setabsTimers0              <= regWriteData[0];
          end

          // Write TIMERSINTEVENTCLEARREG register.
          TIMERSINTEVENTCLEARREG_ADDR_CT : begin
            int_clearabsTimers9            <= regWriteData[9];
            int_clearabsTimers8            <= regWriteData[8];
            int_clearabsTimers7            <= regWriteData[7];
            int_clearabsTimers6            <= regWriteData[6];
            int_clearabsTimers5            <= regWriteData[5];
            int_clearabsTimers4            <= regWriteData[4];
            int_clearabsTimers3            <= regWriteData[3];
            int_clearabsTimers2            <= regWriteData[2];
            int_clearabsTimers1            <= regWriteData[1];
            int_clearabsTimers0            <= regWriteData[0];
          end

          // Write TIMERSINTUNMASKREG register.
          TIMERSINTUNMASKREG_ADDR_CT : begin
            int_maskabsTimers9             <= regWriteData[9];
            int_maskabsTimers8             <= regWriteData[8];
            int_maskabsTimers7             <= regWriteData[7];
            int_maskabsTimers6             <= regWriteData[6];
            int_maskabsTimers5             <= regWriteData[5];
            int_maskabsTimers4             <= regWriteData[4];
            int_maskabsTimers3             <= regWriteData[3];
            int_maskabsTimers2             <= regWriteData[2];
            int_maskabsTimers1             <= regWriteData[1];
            int_maskabsTimers0             <= regWriteData[0];
          end

          // Write TSFLOREG register.
          TSFLOREG_ADDR_CT : begin
            int_tsfTimerLow                <= regWriteData[31 : 0];
          end

          // Write TSFHIREG register.
          TSFHIREG_ADDR_CT : begin
            int_tsfTimerHigh               <= regWriteData[31 : 0];
          end

          // Write TIMEONAIRPARAM1REG register.
          TIMEONAIRPARAM1REG_ADDR_CT : begin
            int_ppduSTBC                   <= regWriteData[31 : 30];
            int_ppduNumExtnSS              <= regWriteData[29 : 28];
            int_ppduBW                     <= regWriteData[27 : 26];
            int_ppduGI                     <= regWriteData[25 : 24];
            int_ppduPreType                <= regWriteData[23 : 20];
            int_ppduLength                 <= regWriteData[19 : 0];
          end

          // Write TIMEONAIRPARAM2REG register.
          TIMEONAIRPARAM2REG_ADDR_CT : begin
            int_ppduNumHeLtf               <= regWriteData[30 : 28];
            int_ppduNUser                  <= regWriteData[26 : 20];
            int_ppduPE                     <= regWriteData[18 : 16];
            int_ppduMCSSigB                <= regWriteData[15 : 13];
            int_ppduDCMSigB                <= regWriteData[12];
            int_ppduSigBCompMode           <= regWriteData[11];
            int_ppduHELTFType              <= regWriteData[10 : 9];
            int_ppduDCM                    <= regWriteData[8];
            int_ppduMCSIndex               <= regWriteData[6 : 0];
          end

          // Write TIMEONAIRPARAM3REG register.
          TIMEONAIRPARAM3REG_ADDR_CT : begin
            int_ppduRuType                 <= regWriteData[6 : 4];
            int_ppduMma                    <= regWriteData[1];
            int_ppduDoppler                <= regWriteData[0];
          end

          // Write TIMEONAIRVALUEREG register.
          TIMEONAIRVALUEREG_ADDR_CT : begin
            int_computeDuration            <= regWriteData[31];
          end

          // Write DMACNTRLSETREG register.
          DMACNTRLSETREG_ADDR_CT : begin
            int_sethaltTBAfterTXOP         <= regWriteData[20];
            int_sethaltAC3AfterTXOP        <= regWriteData[19];
            int_sethaltAC2AfterTXOP        <= regWriteData[18];
            int_sethaltAC1AfterTXOP        <= regWriteData[17];
            int_sethaltAC0AfterTXOP        <= regWriteData[16];
            int_sethaltBcnAfterTXOP        <= regWriteData[15];
            int_settxTBNewHead             <= regWriteData[13];
            int_settxAC3NewHead            <= regWriteData[12];
            int_settxAC2NewHead            <= regWriteData[11];
            int_settxAC1NewHead            <= regWriteData[10];
            int_settxAC0NewHead            <= regWriteData[9];
            int_settxBcnNewHead            <= regWriteData[8];
            int_settxAC3NewTail            <= regWriteData[4];
            int_settxAC2NewTail            <= regWriteData[3];
            int_settxAC1NewTail            <= regWriteData[2];
            int_settxAC0NewTail            <= regWriteData[1];
            int_settxBcnNewTail            <= regWriteData[0];
          end

          // Write DMACNTRLCLEARREG register.
          DMACNTRLCLEARREG_ADDR_CT : begin
            int_clearhaltTBAfterTXOP       <= regWriteData[20];
            int_clearhaltAC3AfterTXOP      <= regWriteData[19];
            int_clearhaltAC2AfterTXOP      <= regWriteData[18];
            int_clearhaltAC1AfterTXOP      <= regWriteData[17];
            int_clearhaltAC0AfterTXOP      <= regWriteData[16];
            int_clearhaltBcnAfterTXOP      <= regWriteData[15];
            int_cleartxTBNewHead           <= regWriteData[13];
            int_cleartxAC3NewHead          <= regWriteData[12];
            int_cleartxAC2NewHead          <= regWriteData[11];
            int_cleartxAC1NewHead          <= regWriteData[10];
            int_cleartxAC0NewHead          <= regWriteData[9];
            int_cleartxBcnNewHead          <= regWriteData[8];
            int_cleartxAC3NewTail          <= regWriteData[4];
            int_cleartxAC2NewTail          <= regWriteData[3];
            int_cleartxAC1NewTail          <= regWriteData[2];
            int_cleartxAC0NewTail          <= regWriteData[1];
            int_cleartxBcnNewTail          <= regWriteData[0];
          end

          // Write TXBCNHEADPTRREG register.
          TXBCNHEADPTRREG_ADDR_CT : begin
            int_txBcnHeadPtr               <= regWriteData[31 : 0];
          end

          // Write TXAC0HEADPTRREG register.
          TXAC0HEADPTRREG_ADDR_CT : begin
            int_txAC0HeadPtr               <= regWriteData[31 : 0];
          end

          // Write TXAC1HEADPTRREG register.
          TXAC1HEADPTRREG_ADDR_CT : begin
            int_txAC1HeadPtr               <= regWriteData[31 : 0];
          end

          // Write TXAC2HEADPTRREG register.
          TXAC2HEADPTRREG_ADDR_CT : begin
            int_txAC2HeadPtr               <= regWriteData[31 : 0];
          end

          // Write TXAC3HEADPTRREG register.
          TXAC3HEADPTRREG_ADDR_CT : begin
            int_txAC3HeadPtr               <= regWriteData[31 : 0];
          end

          // Write TXTBHEADPTRREG register.
          TXTBHEADPTRREG_ADDR_CT : begin
            int_txTBHeadPtr                <= regWriteData[31 : 0];
          end

          // Write TXSTRUCTSIZESREG register.
          TXSTRUCTSIZESREG_ADDR_CT : begin
            int_dmaRBDSize                 <= regWriteData[29 : 24];
            int_dmaRHDSize                 <= regWriteData[23 : 18];
            int_dmaTBDSize                 <= regWriteData[17 : 12];
            int_dmaTHDSize                 <= regWriteData[11 : 6];
            int_ptEntrySize                <= regWriteData[5 : 0];
          end

          // Write DMATHRESHOLDREG register.
          DMATHRESHOLDREG_ADDR_CT : begin
            int_rxFIFOThreshold            <= regWriteData[23 : 16];
            int_txFIFOThreshold            <= regWriteData[7 : 0];
          end

          // Write RXBUF1STARTPTRREG register.
          RXBUF1STARTPTRREG_ADDR_CT : begin
            int_rxBuf1StartPtr             <= regWriteData[30 : 0];
          end

          // Write RXBUF1ENDPTRREG register.
          RXBUF1ENDPTRREG_ADDR_CT : begin
            int_rxBuf1EndPtr               <= regWriteData[30 : 0];
          end

          // Write RXBUF1RDPTRREG register.
          RXBUF1RDPTRREG_ADDR_CT : begin
            int_rxBuf1RdPtr                <= regWriteData[31 : 0];
          end

          // Write RXBUF1WRPTRREG register.
          RXBUF1WRPTRREG_ADDR_CT : begin
            int_rxBuf1WrPtr                <= regWriteData[31 : 0];
          end

          // Write RXBUF2STARTPTRREG register.
          RXBUF2STARTPTRREG_ADDR_CT : begin
            int_rxBuf2StartPtr             <= regWriteData[30 : 0];
          end

          // Write RXBUF2ENDPTRREG register.
          RXBUF2ENDPTRREG_ADDR_CT : begin
            int_rxBuf2EndPtr               <= regWriteData[30 : 0];
          end

          // Write RXBUF2RDPTRREG register.
          RXBUF2RDPTRREG_ADDR_CT : begin
            int_rxBuf2RdPtr                <= regWriteData[31 : 0];
          end

          // Write RXBUF2WRPTRREG register.
          RXBUF2WRPTRREG_ADDR_CT : begin
            int_rxBuf2WrPtr                <= regWriteData[31 : 0];
          end

          // Write RXBUFCONFIGREG register.
          RXBUFCONFIGREG_ADDR_CT : begin
            int_rxBufRPDFooter             <= regWriteData[31 : 24];
            int_rxBufRPDHeader             <= regWriteData[23 : 16];
            int_rxBufRHDFooter             <= regWriteData[15 : 8];
            int_rxBufRHDHeader             <= regWriteData[7 : 0];
          end

          // Write TXHETBINFOREG register.
          TXHETBINFOREG_ADDR_CT : begin
            int_maxMCSInHETB               <= regWriteData[31 : 28];
            int_eOCW                       <= regWriteData[26 : 24];
            int_eOCWMin                    <= regWriteData[22 : 20];
            int_raRUType                   <= regWriteData[17];
            int_raRUEnable                 <= regWriteData[16];
            int_txHETBMaxDur               <= regWriteData[13 : 8];
          end
`ifdef RW_MUMIMO_TX_EN                     

          // Write SECUSERSTXINTEVENTSETREG register.
          SECUSERSTXINTEVENTSETREG_ADDR_CT : begin
            int_setsecU3ac3TxBufTrigger    <= regWriteData[23];
            int_setsecU3ac2TxBufTrigger    <= regWriteData[22];
            int_setsecU3ac1TxBufTrigger    <= regWriteData[21];
            int_setsecU3ac0TxBufTrigger    <= regWriteData[20];
            int_setsecU3ac3TxTrigger       <= regWriteData[19];
            int_setsecU3ac2TxTrigger       <= regWriteData[18];
            int_setsecU3ac1TxTrigger       <= regWriteData[17];
            int_setsecU3ac0TxTrigger       <= regWriteData[16];
            int_setsecU2ac3TxBufTrigger    <= regWriteData[15];
            int_setsecU2ac2TxBufTrigger    <= regWriteData[14];
            int_setsecU2ac1TxBufTrigger    <= regWriteData[13];
            int_setsecU2ac0TxBufTrigger    <= regWriteData[12];
            int_setsecU2ac3TxTrigger       <= regWriteData[11];
            int_setsecU2ac2TxTrigger       <= regWriteData[10];
            int_setsecU2ac1TxTrigger       <= regWriteData[9];
            int_setsecU2ac0TxTrigger       <= regWriteData[8];
            int_setsecU1ac3TxBufTrigger    <= regWriteData[7];
            int_setsecU1ac2TxBufTrigger    <= regWriteData[6];
            int_setsecU1ac1TxBufTrigger    <= regWriteData[5];
            int_setsecU1ac0TxBufTrigger    <= regWriteData[4];
            int_setsecU1ac3TxTrigger       <= regWriteData[3];
            int_setsecU1ac2TxTrigger       <= regWriteData[2];
            int_setsecU1ac1TxTrigger       <= regWriteData[1];
            int_setsecU1ac0TxTrigger       <= regWriteData[0];
          end

          // Write SECUSERSTXINTEVENTCLEARREG register.
          SECUSERSTXINTEVENTCLEARREG_ADDR_CT : begin
            int_clearsecU3ac3TxBufTrigger  <= regWriteData[23];
            int_clearsecU3ac2TxBufTrigger  <= regWriteData[22];
            int_clearsecU3ac1TxBufTrigger  <= regWriteData[21];
            int_clearsecU3ac0TxBufTrigger  <= regWriteData[20];
            int_clearsecU3ac3TxTrigger     <= regWriteData[19];
            int_clearsecU3ac2TxTrigger     <= regWriteData[18];
            int_clearsecU3ac1TxTrigger     <= regWriteData[17];
            int_clearsecU3ac0TxTrigger     <= regWriteData[16];
            int_clearsecU2ac3TxBufTrigger  <= regWriteData[15];
            int_clearsecU2ac2TxBufTrigger  <= regWriteData[14];
            int_clearsecU2ac1TxBufTrigger  <= regWriteData[13];
            int_clearsecU2ac0TxBufTrigger  <= regWriteData[12];
            int_clearsecU2ac3TxTrigger     <= regWriteData[11];
            int_clearsecU2ac2TxTrigger     <= regWriteData[10];
            int_clearsecU2ac1TxTrigger     <= regWriteData[9];
            int_clearsecU2ac0TxTrigger     <= regWriteData[8];
            int_clearsecU1ac3TxBufTrigger  <= regWriteData[7];
            int_clearsecU1ac2TxBufTrigger  <= regWriteData[6];
            int_clearsecU1ac1TxBufTrigger  <= regWriteData[5];
            int_clearsecU1ac0TxBufTrigger  <= regWriteData[4];
            int_clearsecU1ac3TxTrigger     <= regWriteData[3];
            int_clearsecU1ac2TxTrigger     <= regWriteData[2];
            int_clearsecU1ac1TxTrigger     <= regWriteData[1];
            int_clearsecU1ac0TxTrigger     <= regWriteData[0];
          end

          // Write SECUSERSTXINTEVENTUNMASKREG register.
          SECUSERSTXINTEVENTUNMASKREG_ADDR_CT : begin
            int_masterSecUsersTxIntEn      <= regWriteData[31];
            int_masksecU3ac3TxBufTrigger   <= regWriteData[23];
            int_masksecU3ac2TxBufTrigger   <= regWriteData[22];
            int_masksecU3ac1TxBufTrigger   <= regWriteData[21];
            int_masksecU3ac0TxBufTrigger   <= regWriteData[20];
            int_masksecU3ac3TxTrigger      <= regWriteData[19];
            int_masksecU3ac2TxTrigger      <= regWriteData[18];
            int_masksecU3ac1TxTrigger      <= regWriteData[17];
            int_masksecU3ac0TxTrigger      <= regWriteData[16];
            int_masksecU2ac3TxBufTrigger   <= regWriteData[15];
            int_masksecU2ac2TxBufTrigger   <= regWriteData[14];
            int_masksecU2ac1TxBufTrigger   <= regWriteData[13];
            int_masksecU2ac0TxBufTrigger   <= regWriteData[12];
            int_masksecU2ac3TxTrigger      <= regWriteData[11];
            int_masksecU2ac2TxTrigger      <= regWriteData[10];
            int_masksecU2ac1TxTrigger      <= regWriteData[9];
            int_masksecU2ac0TxTrigger      <= regWriteData[8];
            int_masksecU1ac3TxBufTrigger   <= regWriteData[7];
            int_masksecU1ac2TxBufTrigger   <= regWriteData[6];
            int_masksecU1ac1TxBufTrigger   <= regWriteData[5];
            int_masksecU1ac0TxBufTrigger   <= regWriteData[4];
            int_masksecU1ac3TxTrigger      <= regWriteData[3];
            int_masksecU1ac2TxTrigger      <= regWriteData[2];
            int_masksecU1ac1TxTrigger      <= regWriteData[1];
            int_masksecU1ac0TxTrigger      <= regWriteData[0];
          end
`endif // RW_MUMIMO_TX_EN                     

          // Write DEBUGTBSPTRREG register.
          DEBUGTBSPTRREG_ADDR_CT : begin
          end

          // Write SWPROFILINGREG register.
          SWPROFILINGREG_ADDR_CT : begin
            int_swProf31                   <= regWriteData[31];
            int_swProf30                   <= regWriteData[30];
            int_swProf29                   <= regWriteData[29];
            int_swProf28                   <= regWriteData[28];
            int_swProf27                   <= regWriteData[27];
            int_swProf26                   <= regWriteData[26];
            int_swProf25                   <= regWriteData[25];
            int_swProf24                   <= regWriteData[24];
            int_swProf23                   <= regWriteData[23];
            int_swProf22                   <= regWriteData[22];
            int_swProf21                   <= regWriteData[21];
            int_swProf20                   <= regWriteData[20];
            int_swProf19                   <= regWriteData[19];
            int_swProf18                   <= regWriteData[18];
            int_swProf17                   <= regWriteData[17];
            int_swProf16                   <= regWriteData[16];
            int_swProf15                   <= regWriteData[15];
            int_swProf14                   <= regWriteData[14];
            int_swProf13                   <= regWriteData[13];
            int_swProf12                   <= regWriteData[12];
            int_swProf11                   <= regWriteData[11];
            int_swProf10                   <= regWriteData[10];
            int_swProf9                    <= regWriteData[9];
            int_swProf8                    <= regWriteData[8];
            int_swProf7                    <= regWriteData[7];
            int_swProf6                    <= regWriteData[6];
            int_swProf5                    <= regWriteData[5];
            int_swProf4                    <= regWriteData[4];
            int_swProf3                    <= regWriteData[3];
            int_swProf2                    <= regWriteData[2];
            int_swProf1                    <= regWriteData[1];
            int_swProf0                    <= regWriteData[0];
          end

          // Write SWSETPROFILINGREG register.
          SWSETPROFILINGREG_ADDR_CT : begin
            int_swSetProf31                <= regWriteData[31];
            int_swSetProf30                <= regWriteData[30];
            int_swSetProf29                <= regWriteData[29];
            int_swSetProf28                <= regWriteData[28];
            int_swSetProf27                <= regWriteData[27];
            int_swSetProf26                <= regWriteData[26];
            int_swSetProf25                <= regWriteData[25];
            int_swSetProf24                <= regWriteData[24];
            int_swSetProf23                <= regWriteData[23];
            int_swSetProf22                <= regWriteData[22];
            int_swSetProf21                <= regWriteData[21];
            int_swSetProf20                <= regWriteData[20];
            int_swSetProf19                <= regWriteData[19];
            int_swSetProf18                <= regWriteData[18];
            int_swSetProf17                <= regWriteData[17];
            int_swSetProf16                <= regWriteData[16];
            int_swSetProf15                <= regWriteData[15];
            int_swSetProf14                <= regWriteData[14];
            int_swSetProf13                <= regWriteData[13];
            int_swSetProf12                <= regWriteData[12];
            int_swSetProf11                <= regWriteData[11];
            int_swSetProf10                <= regWriteData[10];
            int_swSetProf9                 <= regWriteData[9];
            int_swSetProf8                 <= regWriteData[8];
            int_swSetProf7                 <= regWriteData[7];
            int_swSetProf6                 <= regWriteData[6];
            int_swSetProf5                 <= regWriteData[5];
            int_swSetProf4                 <= regWriteData[4];
            int_swSetProf3                 <= regWriteData[3];
            int_swSetProf2                 <= regWriteData[2];
            int_swSetProf1                 <= regWriteData[1];
            int_swSetProf0                 <= regWriteData[0];
          end

          // Write SWCLEARPROFILINGREG register.
          SWCLEARPROFILINGREG_ADDR_CT : begin
            int_swClearProf31              <= regWriteData[31];
            int_swClearProf30              <= regWriteData[30];
            int_swClearProf29              <= regWriteData[29];
            int_swClearProf28              <= regWriteData[28];
            int_swClearProf27              <= regWriteData[27];
            int_swClearProf26              <= regWriteData[26];
            int_swClearProf25              <= regWriteData[25];
            int_swClearProf24              <= regWriteData[24];
            int_swClearProf23              <= regWriteData[23];
            int_swClearProf22              <= regWriteData[22];
            int_swClearProf21              <= regWriteData[21];
            int_swClearProf20              <= regWriteData[20];
            int_swClearProf19              <= regWriteData[19];
            int_swClearProf18              <= regWriteData[18];
            int_swClearProf17              <= regWriteData[17];
            int_swClearProf16              <= regWriteData[16];
            int_swClearProf15              <= regWriteData[15];
            int_swClearProf14              <= regWriteData[14];
            int_swClearProf13              <= regWriteData[13];
            int_swClearProf12              <= regWriteData[12];
            int_swClearProf11              <= regWriteData[11];
            int_swClearProf10              <= regWriteData[10];
            int_swClearProf9               <= regWriteData[9];
            int_swClearProf8               <= regWriteData[8];
            int_swClearProf7               <= regWriteData[7];
            int_swClearProf6               <= regWriteData[6];
            int_swClearProf5               <= regWriteData[5];
            int_swClearProf4               <= regWriteData[4];
            int_swClearProf3               <= regWriteData[3];
            int_swClearProf2               <= regWriteData[2];
            int_swClearProf1               <= regWriteData[1];
            int_swClearProf0               <= regWriteData[0];
          end

          // Write SWPROFILINGREG2 register.
          SWPROFILINGREG2_ADDR_CT : begin
            int_swProf63                   <= regWriteData[31];
            int_swProf62                   <= regWriteData[30];
            int_swProf61                   <= regWriteData[29];
            int_swProf60                   <= regWriteData[28];
            int_swProf59                   <= regWriteData[27];
            int_swProf58                   <= regWriteData[26];
            int_swProf57                   <= regWriteData[25];
            int_swProf56                   <= regWriteData[24];
            int_swProf55                   <= regWriteData[23];
            int_swProf54                   <= regWriteData[22];
            int_swProf53                   <= regWriteData[21];
            int_swProf52                   <= regWriteData[20];
            int_swProf51                   <= regWriteData[19];
            int_swProf50                   <= regWriteData[18];
            int_swProf49                   <= regWriteData[17];
            int_swProf48                   <= regWriteData[16];
            int_swProf47                   <= regWriteData[15];
            int_swProf46                   <= regWriteData[14];
            int_swProf45                   <= regWriteData[13];
            int_swProf44                   <= regWriteData[12];
            int_swProf43                   <= regWriteData[11];
            int_swProf42                   <= regWriteData[10];
            int_swProf41                   <= regWriteData[9];
            int_swProf40                   <= regWriteData[8];
            int_swProf39                   <= regWriteData[7];
            int_swProf38                   <= regWriteData[6];
            int_swProf37                   <= regWriteData[5];
            int_swProf36                   <= regWriteData[4];
            int_swProf35                   <= regWriteData[3];
            int_swProf34                   <= regWriteData[2];
            int_swProf33                   <= regWriteData[1];
            int_swProf32                   <= regWriteData[0];
          end

          // Write SWSETPROFILINGREG2 register.
          SWSETPROFILINGREG2_ADDR_CT : begin
            int_swSetProf63                <= regWriteData[31];
            int_swSetProf62                <= regWriteData[30];
            int_swSetProf61                <= regWriteData[29];
            int_swSetProf60                <= regWriteData[28];
            int_swSetProf59                <= regWriteData[27];
            int_swSetProf58                <= regWriteData[26];
            int_swSetProf57                <= regWriteData[25];
            int_swSetProf56                <= regWriteData[24];
            int_swSetProf55                <= regWriteData[23];
            int_swSetProf54                <= regWriteData[22];
            int_swSetProf53                <= regWriteData[21];
            int_swSetProf52                <= regWriteData[20];
            int_swSetProf51                <= regWriteData[19];
            int_swSetProf50                <= regWriteData[18];
            int_swSetProf49                <= regWriteData[17];
            int_swSetProf48                <= regWriteData[16];
            int_swSetProf47                <= regWriteData[15];
            int_swSetProf46                <= regWriteData[14];
            int_swSetProf45                <= regWriteData[13];
            int_swSetProf44                <= regWriteData[12];
            int_swSetProf43                <= regWriteData[11];
            int_swSetProf42                <= regWriteData[10];
            int_swSetProf41                <= regWriteData[9];
            int_swSetProf40                <= regWriteData[8];
            int_swSetProf39                <= regWriteData[7];
            int_swSetProf38                <= regWriteData[6];
            int_swSetProf37                <= regWriteData[5];
            int_swSetProf36                <= regWriteData[4];
            int_swSetProf35                <= regWriteData[3];
            int_swSetProf34                <= regWriteData[2];
            int_swSetProf33                <= regWriteData[1];
            int_swSetProf32                <= regWriteData[0];
          end

          // Write SWCLEARPROFILINGREG2 register.
          SWCLEARPROFILINGREG2_ADDR_CT : begin
            int_swClearProf63              <= regWriteData[31];
            int_swClearProf62              <= regWriteData[30];
            int_swClearProf61              <= regWriteData[29];
            int_swClearProf60              <= regWriteData[28];
            int_swClearProf59              <= regWriteData[27];
            int_swClearProf58              <= regWriteData[26];
            int_swClearProf57              <= regWriteData[25];
            int_swClearProf56              <= regWriteData[24];
            int_swClearProf55              <= regWriteData[23];
            int_swClearProf54              <= regWriteData[22];
            int_swClearProf53              <= regWriteData[21];
            int_swClearProf52              <= regWriteData[20];
            int_swClearProf51              <= regWriteData[19];
            int_swClearProf50              <= regWriteData[18];
            int_swClearProf49              <= regWriteData[17];
            int_swClearProf48              <= regWriteData[16];
            int_swClearProf47              <= regWriteData[15];
            int_swClearProf46              <= regWriteData[14];
            int_swClearProf45              <= regWriteData[13];
            int_swClearProf44              <= regWriteData[12];
            int_swClearProf43              <= regWriteData[11];
            int_swClearProf42              <= regWriteData[10];
            int_swClearProf41              <= regWriteData[9];
            int_swClearProf40              <= regWriteData[8];
            int_swClearProf39              <= regWriteData[7];
            int_swClearProf38              <= regWriteData[6];
            int_swClearProf37              <= regWriteData[5];
            int_swClearProf36              <= regWriteData[4];
            int_swClearProf35              <= regWriteData[3];
            int_swClearProf34              <= regWriteData[2];
            int_swClearProf33              <= regWriteData[1];
            int_swClearProf32              <= regWriteData[0];
          end
`ifdef RW_MUMIMO_SEC_USER1_EN              
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              
`endif // RW_MUMIMO_SEC_USER3_EN              

          
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : begin
          end
          // pragma coverage block = on 

        endcase
      end
      else begin
        int_settbTxDMADead             <= 1'b0;
        int_setrxPayloadDMADead        <= 1'b0;
        int_setrxHeaderDMADead         <= 1'b0;
        int_setphyRxStart              <= 1'b0;
        int_setphyErr                  <= 1'b0;
        int_setmacPHYIFUnderRun        <= 1'b0;
        int_sethwErr                   <= 1'b0;
        int_setimpSecDTIM              <= 1'b0;
        int_setimpPriDTIM              <= 1'b0;
        int_setbcnTxDMADead            <= 1'b0;
        int_setac3TxDMADead            <= 1'b0;
        int_setac2TxDMADead            <= 1'b0;
        int_setac1TxDMADead            <= 1'b0;
        int_setac0TxDMADead            <= 1'b0;
        int_setptError                 <= 1'b0;
        int_settimSet                  <= 1'b0;
        int_setolbcDSSS                <= 1'b0;
        int_setolbcOFDM                <= 1'b0;
        int_setrxFIFOOverFlow          <= 1'b0;
        int_setmacPHYIFOverflow        <= 1'b0;
        int_setcoexEvent               <= 1'b0;
        int_absGenTimers               <= 1'b0;
        int_setidleInterrupt           <= 1'b0;
        int_setimpSecTBTT              <= 1'b0;
        int_setimpPriTBTT              <= 1'b0;
        int_cleartbTxDMADead           <= 1'b0;
        int_clearrxPayloadDMADead      <= 1'b0;
        int_clearrxHeaderDMADead       <= 1'b0;
        int_clearphyRxStart            <= 1'b0;
        int_clearphyErr                <= 1'b0;
        int_clearmacPHYIFUnderRun      <= 1'b0;
        int_clearhwErr                 <= 1'b0;
        int_clearimpSecDTIM            <= 1'b0;
        int_clearimpPriDTIM            <= 1'b0;
        int_clearbcnTxDMADead          <= 1'b0;
        int_clearac3TxDMADead          <= 1'b0;
        int_clearac2TxDMADead          <= 1'b0;
        int_clearac1TxDMADead          <= 1'b0;
        int_clearac0TxDMADead          <= 1'b0;
        int_clearptError               <= 1'b0;
        int_cleartimSet                <= 1'b0;
        int_clearolbcDSSS              <= 1'b0;
        int_clearolbcOFDM              <= 1'b0;
        int_clearrxFIFOOverFlow        <= 1'b0;
        int_clearmacPHYIFOverflow      <= 1'b0;
        int_clearcoexEvent             <= 1'b0;
        int_clearidleInterrupt         <= 1'b0;
        int_clearimpSecTBTT            <= 1'b0;
        int_clearimpPriTBTT            <= 1'b0;
        int_settbTxBufTrigger          <= 1'b0;
        int_setbcnTxBufTrigger         <= 1'b0;
        int_setac3TxBufTrigger         <= 1'b0;
        int_setac2TxBufTrigger         <= 1'b0;
        int_setac1TxBufTrigger         <= 1'b0;
        int_setac0TxBufTrigger         <= 1'b0;
        int_setac3BWDropTrigger        <= 1'b0;
        int_setac2BWDropTrigger        <= 1'b0;
        int_setac1BWDropTrigger        <= 1'b0;
        int_setac0BWDropTrigger        <= 1'b0;
        int_setrxBuffer2Trigger        <= 1'b0;
        int_settimerRxTrigger          <= 1'b0;
        int_setrxBuffer1Trigger        <= 1'b0;
        int_setsecUserTxTrigger        <= 1'b0;
        int_settimerTxTrigger          <= 1'b0;
        int_settxopComplete            <= 1'b0;
        int_settbTxCancelled           <= 1'b0;
        int_settbTxTrigger             <= 1'b0;
        int_setbcnTxTrigger            <= 1'b0;
        int_setac3TxTrigger            <= 1'b0;
        int_setac2TxTrigger            <= 1'b0;
        int_setac1TxTrigger            <= 1'b0;
        int_setac0TxTrigger            <= 1'b0;
        int_settbProtTrigger           <= 1'b0;
        int_setac3ProtTrigger          <= 1'b0;
        int_setac2ProtTrigger          <= 1'b0;
        int_setac1ProtTrigger          <= 1'b0;
        int_setac0ProtTrigger          <= 1'b0;
        int_cleartbTxBufTrigger        <= 1'b0;
        int_clearbcnTxBufTrigger       <= 1'b0;
        int_clearac3TxBufTrigger       <= 1'b0;
        int_clearac2TxBufTrigger       <= 1'b0;
        int_clearac1TxBufTrigger       <= 1'b0;
        int_clearac0TxBufTrigger       <= 1'b0;
        int_clearac3BWDropTrigger      <= 1'b0;
        int_clearac2BWDropTrigger      <= 1'b0;
        int_clearac1BWDropTrigger      <= 1'b0;
        int_clearac0BWDropTrigger      <= 1'b0;
        int_clearrxBuffer2Trigger      <= 1'b0;
        int_cleartimerRxTrigger        <= 1'b0;
        int_clearrxBuffer1Trigger      <= 1'b0;
        int_cleartimerTxTrigger        <= 1'b0;
        int_cleartxopComplete          <= 1'b0;
        int_cleartbTxCancelled         <= 1'b0;
        int_cleartbTxTrigger           <= 1'b0;
        int_clearbcnTxTrigger          <= 1'b0;
        int_clearac3TxTrigger          <= 1'b0;
        int_clearac2TxTrigger          <= 1'b0;
        int_clearac1TxTrigger          <= 1'b0;
        int_clearac0TxTrigger          <= 1'b0;
        int_cleartbProtTrigger         <= 1'b0;
        int_clearac3ProtTrigger        <= 1'b0;
        int_clearac2ProtTrigger        <= 1'b0;
        int_clearac1ProtTrigger        <= 1'b0;
        int_clearac0ProtTrigger        <= 1'b0;
        int_setabsTimers9              <= 1'b0;
        int_setabsTimers8              <= 1'b0;
        int_setabsTimers7              <= 1'b0;
        int_setabsTimers6              <= 1'b0;
        int_setabsTimers5              <= 1'b0;
        int_setabsTimers4              <= 1'b0;
        int_setabsTimers3              <= 1'b0;
        int_setabsTimers2              <= 1'b0;
        int_setabsTimers1              <= 1'b0;
        int_setabsTimers0              <= 1'b0;
        int_clearabsTimers9            <= 1'b0;
        int_clearabsTimers8            <= 1'b0;
        int_clearabsTimers7            <= 1'b0;
        int_clearabsTimers6            <= 1'b0;
        int_clearabsTimers5            <= 1'b0;
        int_clearabsTimers4            <= 1'b0;
        int_clearabsTimers3            <= 1'b0;
        int_clearabsTimers2            <= 1'b0;
        int_clearabsTimers1            <= 1'b0;
        int_clearabsTimers0            <= 1'b0;
        int_sethaltTBAfterTXOP         <= 1'b0;
        int_sethaltAC3AfterTXOP        <= 1'b0;
        int_sethaltAC2AfterTXOP        <= 1'b0;
        int_sethaltAC1AfterTXOP        <= 1'b0;
        int_sethaltAC0AfterTXOP        <= 1'b0;
        int_sethaltBcnAfterTXOP        <= 1'b0;
        int_settxTBNewHead             <= 1'b0;
        int_settxAC3NewHead            <= 1'b0;
        int_settxAC2NewHead            <= 1'b0;
        int_settxAC1NewHead            <= 1'b0;
        int_settxAC0NewHead            <= 1'b0;
        int_settxBcnNewHead            <= 1'b0;
        int_settxAC3NewTail            <= 1'b0;
        int_settxAC2NewTail            <= 1'b0;
        int_settxAC1NewTail            <= 1'b0;
        int_settxAC0NewTail            <= 1'b0;
        int_settxBcnNewTail            <= 1'b0;
        int_clearhaltTBAfterTXOP       <= 1'b0;
        int_clearhaltAC3AfterTXOP      <= 1'b0;
        int_clearhaltAC2AfterTXOP      <= 1'b0;
        int_clearhaltAC1AfterTXOP      <= 1'b0;
        int_clearhaltAC0AfterTXOP      <= 1'b0;
        int_clearhaltBcnAfterTXOP      <= 1'b0;
        int_cleartxTBNewHead           <= 1'b0;
        int_cleartxAC3NewHead          <= 1'b0;
        int_cleartxAC2NewHead          <= 1'b0;
        int_cleartxAC1NewHead          <= 1'b0;
        int_cleartxAC0NewHead          <= 1'b0;
        int_cleartxBcnNewHead          <= 1'b0;
        int_cleartxAC3NewTail          <= 1'b0;
        int_cleartxAC2NewTail          <= 1'b0;
        int_cleartxAC1NewTail          <= 1'b0;
        int_cleartxAC0NewTail          <= 1'b0;
        int_cleartxBcnNewTail          <= 1'b0;
`ifdef RW_MUMIMO_TX_EN                     
        int_setsecU3ac3TxBufTrigger    <= 1'b0;
        int_setsecU3ac2TxBufTrigger    <= 1'b0;
        int_setsecU3ac1TxBufTrigger    <= 1'b0;
        int_setsecU3ac0TxBufTrigger    <= 1'b0;
        int_setsecU3ac3TxTrigger       <= 1'b0;
        int_setsecU3ac2TxTrigger       <= 1'b0;
        int_setsecU3ac1TxTrigger       <= 1'b0;
        int_setsecU3ac0TxTrigger       <= 1'b0;
        int_setsecU2ac3TxBufTrigger    <= 1'b0;
        int_setsecU2ac2TxBufTrigger    <= 1'b0;
        int_setsecU2ac1TxBufTrigger    <= 1'b0;
        int_setsecU2ac0TxBufTrigger    <= 1'b0;
        int_setsecU2ac3TxTrigger       <= 1'b0;
        int_setsecU2ac2TxTrigger       <= 1'b0;
        int_setsecU2ac1TxTrigger       <= 1'b0;
        int_setsecU2ac0TxTrigger       <= 1'b0;
        int_setsecU1ac3TxBufTrigger    <= 1'b0;
        int_setsecU1ac2TxBufTrigger    <= 1'b0;
        int_setsecU1ac1TxBufTrigger    <= 1'b0;
        int_setsecU1ac0TxBufTrigger    <= 1'b0;
        int_setsecU1ac3TxTrigger       <= 1'b0;
        int_setsecU1ac2TxTrigger       <= 1'b0;
        int_setsecU1ac1TxTrigger       <= 1'b0;
        int_setsecU1ac0TxTrigger       <= 1'b0;
        int_clearsecU3ac3TxBufTrigger  <= 1'b0;
        int_clearsecU3ac2TxBufTrigger  <= 1'b0;
        int_clearsecU3ac1TxBufTrigger  <= 1'b0;
        int_clearsecU3ac0TxBufTrigger  <= 1'b0;
        int_clearsecU3ac3TxTrigger     <= 1'b0;
        int_clearsecU3ac2TxTrigger     <= 1'b0;
        int_clearsecU3ac1TxTrigger     <= 1'b0;
        int_clearsecU3ac0TxTrigger     <= 1'b0;
        int_clearsecU2ac3TxBufTrigger  <= 1'b0;
        int_clearsecU2ac2TxBufTrigger  <= 1'b0;
        int_clearsecU2ac1TxBufTrigger  <= 1'b0;
        int_clearsecU2ac0TxBufTrigger  <= 1'b0;
        int_clearsecU2ac3TxTrigger     <= 1'b0;
        int_clearsecU2ac2TxTrigger     <= 1'b0;
        int_clearsecU2ac1TxTrigger     <= 1'b0;
        int_clearsecU2ac0TxTrigger     <= 1'b0;
        int_clearsecU1ac3TxBufTrigger  <= 1'b0;
        int_clearsecU1ac2TxBufTrigger  <= 1'b0;
        int_clearsecU1ac1TxBufTrigger  <= 1'b0;
        int_clearsecU1ac0TxBufTrigger  <= 1'b0;
        int_clearsecU1ac3TxTrigger     <= 1'b0;
        int_clearsecU1ac2TxTrigger     <= 1'b0;
        int_clearsecU1ac1TxTrigger     <= 1'b0;
        int_clearsecU1ac0TxTrigger     <= 1'b0;
`endif // RW_MUMIMO_TX_EN                     
        int_swSetProf31                <= 1'b0;
        int_swSetProf30                <= 1'b0;
        int_swSetProf29                <= 1'b0;
        int_swSetProf28                <= 1'b0;
        int_swSetProf27                <= 1'b0;
        int_swSetProf26                <= 1'b0;
        int_swSetProf25                <= 1'b0;
        int_swSetProf24                <= 1'b0;
        int_swSetProf23                <= 1'b0;
        int_swSetProf22                <= 1'b0;
        int_swSetProf21                <= 1'b0;
        int_swSetProf20                <= 1'b0;
        int_swSetProf19                <= 1'b0;
        int_swSetProf18                <= 1'b0;
        int_swSetProf17                <= 1'b0;
        int_swSetProf16                <= 1'b0;
        int_swSetProf15                <= 1'b0;
        int_swSetProf14                <= 1'b0;
        int_swSetProf13                <= 1'b0;
        int_swSetProf12                <= 1'b0;
        int_swSetProf11                <= 1'b0;
        int_swSetProf10                <= 1'b0;
        int_swSetProf9                 <= 1'b0;
        int_swSetProf8                 <= 1'b0;
        int_swSetProf7                 <= 1'b0;
        int_swSetProf6                 <= 1'b0;
        int_swSetProf5                 <= 1'b0;
        int_swSetProf4                 <= 1'b0;
        int_swSetProf3                 <= 1'b0;
        int_swSetProf2                 <= 1'b0;
        int_swSetProf1                 <= 1'b0;
        int_swSetProf0                 <= 1'b0;
        int_swClearProf31              <= 1'b0;
        int_swClearProf30              <= 1'b0;
        int_swClearProf29              <= 1'b0;
        int_swClearProf28              <= 1'b0;
        int_swClearProf27              <= 1'b0;
        int_swClearProf26              <= 1'b0;
        int_swClearProf25              <= 1'b0;
        int_swClearProf24              <= 1'b0;
        int_swClearProf23              <= 1'b0;
        int_swClearProf22              <= 1'b0;
        int_swClearProf21              <= 1'b0;
        int_swClearProf20              <= 1'b0;
        int_swClearProf19              <= 1'b0;
        int_swClearProf18              <= 1'b0;
        int_swClearProf17              <= 1'b0;
        int_swClearProf16              <= 1'b0;
        int_swClearProf15              <= 1'b0;
        int_swClearProf14              <= 1'b0;
        int_swClearProf13              <= 1'b0;
        int_swClearProf12              <= 1'b0;
        int_swClearProf11              <= 1'b0;
        int_swClearProf10              <= 1'b0;
        int_swClearProf9               <= 1'b0;
        int_swClearProf8               <= 1'b0;
        int_swClearProf7               <= 1'b0;
        int_swClearProf6               <= 1'b0;
        int_swClearProf5               <= 1'b0;
        int_swClearProf4               <= 1'b0;
        int_swClearProf3               <= 1'b0;
        int_swClearProf2               <= 1'b0;
        int_swClearProf1               <= 1'b0;
        int_swClearProf0               <= 1'b0;
        int_swSetProf63                <= 1'b0;
        int_swSetProf62                <= 1'b0;
        int_swSetProf61                <= 1'b0;
        int_swSetProf60                <= 1'b0;
        int_swSetProf59                <= 1'b0;
        int_swSetProf58                <= 1'b0;
        int_swSetProf57                <= 1'b0;
        int_swSetProf56                <= 1'b0;
        int_swSetProf55                <= 1'b0;
        int_swSetProf54                <= 1'b0;
        int_swSetProf53                <= 1'b0;
        int_swSetProf52                <= 1'b0;
        int_swSetProf51                <= 1'b0;
        int_swSetProf50                <= 1'b0;
        int_swSetProf49                <= 1'b0;
        int_swSetProf48                <= 1'b0;
        int_swSetProf47                <= 1'b0;
        int_swSetProf46                <= 1'b0;
        int_swSetProf45                <= 1'b0;
        int_swSetProf44                <= 1'b0;
        int_swSetProf43                <= 1'b0;
        int_swSetProf42                <= 1'b0;
        int_swSetProf41                <= 1'b0;
        int_swSetProf40                <= 1'b0;
        int_swSetProf39                <= 1'b0;
        int_swSetProf38                <= 1'b0;
        int_swSetProf37                <= 1'b0;
        int_swSetProf36                <= 1'b0;
        int_swSetProf35                <= 1'b0;
        int_swSetProf34                <= 1'b0;
        int_swSetProf33                <= 1'b0;
        int_swSetProf32                <= 1'b0;
        int_swClearProf63              <= 1'b0;
        int_swClearProf62              <= 1'b0;
        int_swClearProf61              <= 1'b0;
        int_swClearProf60              <= 1'b0;
        int_swClearProf59              <= 1'b0;
        int_swClearProf58              <= 1'b0;
        int_swClearProf57              <= 1'b0;
        int_swClearProf56              <= 1'b0;
        int_swClearProf55              <= 1'b0;
        int_swClearProf54              <= 1'b0;
        int_swClearProf53              <= 1'b0;
        int_swClearProf52              <= 1'b0;
        int_swClearProf51              <= 1'b0;
        int_swClearProf50              <= 1'b0;
        int_swClearProf49              <= 1'b0;
        int_swClearProf48              <= 1'b0;
        int_swClearProf47              <= 1'b0;
        int_swClearProf46              <= 1'b0;
        int_swClearProf45              <= 1'b0;
        int_swClearProf44              <= 1'b0;
        int_swClearProf43              <= 1'b0;
        int_swClearProf42              <= 1'b0;
        int_swClearProf41              <= 1'b0;
        int_swClearProf40              <= 1'b0;
        int_swClearProf39              <= 1'b0;
        int_swClearProf38              <= 1'b0;
        int_swClearProf37              <= 1'b0;
        int_swClearProf36              <= 1'b0;
        int_swClearProf35              <= 1'b0;
        int_swClearProf34              <= 1'b0;
        int_swClearProf33              <= 1'b0;
        int_swClearProf32              <= 1'b0;
`ifdef RW_MUMIMO_SEC_USER1_EN              
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              
`endif // RW_MUMIMO_SEC_USER3_EN              
      end
    end
  end
        
  //////////////////////////////////////////////////////////////////////////////
  // Registers read
  //////////////////////////////////////////////////////////////////////////////
  //Read_p: 
  
  always @*
  begin

    regReadData = `RW_REG_DATA_WIDTH'b0;
    // Test only psel to detect first cycle of the two-cycles APB read access.
    if (regSel && regRead)
    begin

      case (regAddr)

        // Read NEXTTBTTREG register.
        NEXTTBTTREG_ADDR_CT : begin
          regReadData[15 : 0]        = nextTBTT;
        end

        // Read DOZECNTRL2REG register.
        DOZECNTRL2REG_ADDR_CT : begin
          regReadData[31]            = wakeUpFromDoze;
          regReadData[0]             = wakeUpSW;
        end

        // Read MACCNTRL2REG register.
        MACCNTRL2REG_ADDR_CT : begin
          regReadData[0]             = softReset;
        end

        // Read GENINTEVENTSETREG register.
        GENINTEVENTSETREG_ADDR_CT : begin
          regReadData[26]            = statussettbTxDMADead;
          regReadData[25]            = statussetrxPayloadDMADead;
          regReadData[24]            = statussetrxHeaderDMADead;
          regReadData[23]            = statussetphyRxStart;
          regReadData[22]            = statussetphyErr;
          regReadData[21]            = statussetmacPHYIFUnderRun;
          regReadData[20]            = statussethwErr;
          regReadData[19]            = statussetimpSecDTIM;
          regReadData[18]            = statussetimpPriDTIM;
          regReadData[17]            = statussetbcnTxDMADead;
          regReadData[16]            = statussetac3TxDMADead;
          regReadData[15]            = statussetac2TxDMADead;
          regReadData[14]            = statussetac1TxDMADead;
          regReadData[13]            = statussetac0TxDMADead;
          regReadData[12]            = statussetptError;
          regReadData[11]            = statussettimSet;
          regReadData[10]            = statussetolbcDSSS;
          regReadData[9]             = statussetolbcOFDM;
          regReadData[8]             = statussetrxFIFOOverFlow;
          regReadData[6]             = statussetmacPHYIFOverflow;
          regReadData[5]             = statussetcoexEvent;
          regReadData[3]             = statusabsGenTimers;
          regReadData[2]             = statussetidleInterrupt;
          regReadData[1]             = statussetimpSecTBTT;
          regReadData[0]             = statussetimpPriTBTT;
        end

        // Read GENINTEVENTCLEARREG register.
        GENINTEVENTCLEARREG_ADDR_CT : begin
          regReadData[26]            = cleartbTxDMADead;
          regReadData[25]            = clearrxPayloadDMADead;
          regReadData[24]            = clearrxHeaderDMADead;
          regReadData[23]            = clearphyRxStart;
          regReadData[22]            = clearphyErr;
          regReadData[21]            = clearmacPHYIFUnderRun;
          regReadData[20]            = clearhwErr;
          regReadData[19]            = clearimpSecDTIM;
          regReadData[18]            = clearimpPriDTIM;
          regReadData[17]            = clearbcnTxDMADead;
          regReadData[16]            = clearac3TxDMADead;
          regReadData[15]            = clearac2TxDMADead;
          regReadData[14]            = clearac1TxDMADead;
          regReadData[13]            = clearac0TxDMADead;
          regReadData[12]            = clearptError;
          regReadData[11]            = cleartimSet;
          regReadData[10]            = clearolbcDSSS;
          regReadData[9]             = clearolbcOFDM;
          regReadData[8]             = clearrxFIFOOverFlow;
          regReadData[6]             = clearmacPHYIFOverflow;
          regReadData[5]             = clearcoexEvent;
          regReadData[2]             = clearidleInterrupt;
          regReadData[1]             = clearimpSecTBTT;
          regReadData[0]             = clearimpPriTBTT;
        end

        // Read GENINTUNMASKREG register.
        GENINTUNMASKREG_ADDR_CT : begin
          regReadData[31]            = masterGenIntEn;
          regReadData[26]            = masktbTxDMADead;
          regReadData[25]            = maskrxPayloadDMADead;
          regReadData[24]            = maskrxHeaderDMADead;
          regReadData[23]            = maskphyRxStart;
          regReadData[22]            = maskphyErr;
          regReadData[21]            = maskmacPHYIFUnderRun;
          regReadData[20]            = maskhwErr;
          regReadData[19]            = maskimpSecDTIM;
          regReadData[18]            = maskimpPriDTIM;
          regReadData[17]            = maskbcnTxDMADead;
          regReadData[16]            = maskac3TxDMADead;
          regReadData[15]            = maskac2TxDMADead;
          regReadData[14]            = maskac1TxDMADead;
          regReadData[13]            = maskac0TxDMADead;
          regReadData[12]            = maskptError;
          regReadData[11]            = masktimSet;
          regReadData[10]            = maskolbcDSSS;
          regReadData[9]             = maskolbcOFDM;
          regReadData[8]             = maskrxFIFOOverFlow;
          regReadData[6]             = maskmacPHYIFOverflow;
          regReadData[5]             = maskcoexEvent;
          regReadData[3]             = maskabsGenTimers;
          regReadData[2]             = maskidleInterrupt;
          regReadData[1]             = maskimpSecTBTT;
          regReadData[0]             = maskimpPriTBTT;
        end

        // Read TXRXINTEVENTSETREG register.
        TXRXINTEVENTSETREG_ADDR_CT : begin
          regReadData[29]            = statussettbTxBufTrigger;
          regReadData[28]            = statussetbcnTxBufTrigger;
          regReadData[27]            = statussetac3TxBufTrigger;
          regReadData[26]            = statussetac2TxBufTrigger;
          regReadData[25]            = statussetac1TxBufTrigger;
          regReadData[24]            = statussetac0TxBufTrigger;
          regReadData[23]            = statussetac3BWDropTrigger;
          regReadData[22]            = statussetac2BWDropTrigger;
          regReadData[21]            = statussetac1BWDropTrigger;
          regReadData[20]            = statussetac0BWDropTrigger;
          regReadData[18]            = statussetrxBuffer2Trigger;
          regReadData[17]            = statussettimerRxTrigger;
          regReadData[16]            = statussetrxBuffer1Trigger;
          regReadData[15]            = statussetsecUserTxTrigger;
          regReadData[14]            = statussettimerTxTrigger;
          regReadData[13]            = statussettxopComplete;
          regReadData[12]            = statussettbTxCancelled;
          regReadData[11]            = statussettbTxTrigger;
          regReadData[10]            = statussetbcnTxTrigger;
          regReadData[9]             = statussetac3TxTrigger;
          regReadData[8]             = statussetac2TxTrigger;
          regReadData[7]             = statussetac1TxTrigger;
          regReadData[6]             = statussetac0TxTrigger;
          regReadData[4]             = statussettbProtTrigger;
          regReadData[3]             = statussetac3ProtTrigger;
          regReadData[2]             = statussetac2ProtTrigger;
          regReadData[1]             = statussetac1ProtTrigger;
          regReadData[0]             = statussetac0ProtTrigger;
        end

        // Read TXRXINTEVENTCLEARREG register.
        TXRXINTEVENTCLEARREG_ADDR_CT : begin
          regReadData[29]            = cleartbTxBufTrigger;
          regReadData[28]            = clearbcnTxBufTrigger;
          regReadData[27]            = clearac3TxBufTrigger;
          regReadData[26]            = clearac2TxBufTrigger;
          regReadData[25]            = clearac1TxBufTrigger;
          regReadData[24]            = clearac0TxBufTrigger;
          regReadData[23]            = clearac3BWDropTrigger;
          regReadData[22]            = clearac2BWDropTrigger;
          regReadData[21]            = clearac1BWDropTrigger;
          regReadData[20]            = clearac0BWDropTrigger;
          regReadData[18]            = clearrxBuffer2Trigger;
          regReadData[17]            = cleartimerRxTrigger;
          regReadData[16]            = clearrxBuffer1Trigger;
          regReadData[14]            = cleartimerTxTrigger;
          regReadData[13]            = cleartxopComplete;
          regReadData[12]            = cleartbTxCancelled;
          regReadData[11]            = cleartbTxTrigger;
          regReadData[10]            = clearbcnTxTrigger;
          regReadData[9]             = clearac3TxTrigger;
          regReadData[8]             = clearac2TxTrigger;
          regReadData[7]             = clearac1TxTrigger;
          regReadData[6]             = clearac0TxTrigger;
          regReadData[4]             = cleartbProtTrigger;
          regReadData[3]             = clearac3ProtTrigger;
          regReadData[2]             = clearac2ProtTrigger;
          regReadData[1]             = clearac1ProtTrigger;
          regReadData[0]             = clearac0ProtTrigger;
        end

        // Read TXRXINTUNMASKREG register.
        TXRXINTUNMASKREG_ADDR_CT : begin
          regReadData[31]            = masterTxRxIntEn;
          regReadData[29]            = masktbTxBufTrigger;
          regReadData[28]            = maskbcnTxBufTrigger;
          regReadData[27]            = maskac3TxBufTrigger;
          regReadData[26]            = maskac2TxBufTrigger;
          regReadData[25]            = maskac1TxBufTrigger;
          regReadData[24]            = maskac0TxBufTrigger;
          regReadData[23]            = maskac3BWDropTrigger;
          regReadData[22]            = maskac2BWDropTrigger;
          regReadData[21]            = maskac1BWDropTrigger;
          regReadData[20]            = maskac0BWDropTrigger;
          regReadData[18]            = maskrxBuffer2Trigger;
          regReadData[17]            = masktimerRxTrigger;
          regReadData[16]            = maskrxBuffer1Trigger;
          regReadData[15]            = masksecUserTxTrigger;
          regReadData[14]            = masktimerTxTrigger;
          regReadData[13]            = masktxopComplete;
          regReadData[12]            = masktbTxCancelled;
          regReadData[11]            = masktbTxTrigger;
          regReadData[10]            = maskbcnTxTrigger;
          regReadData[9]             = maskac3TxTrigger;
          regReadData[8]             = maskac2TxTrigger;
          regReadData[7]             = maskac1TxTrigger;
          regReadData[6]             = maskac0TxTrigger;
          regReadData[4]             = masktbProtTrigger;
          regReadData[3]             = maskac3ProtTrigger;
          regReadData[2]             = maskac2ProtTrigger;
          regReadData[1]             = maskac1ProtTrigger;
          regReadData[0]             = maskac0ProtTrigger;
        end

        // Read TIMERSINTEVENTSETREG register.
        TIMERSINTEVENTSETREG_ADDR_CT : begin
          regReadData[9]             = statussetabsTimers9;
          regReadData[8]             = statussetabsTimers8;
          regReadData[7]             = statussetabsTimers7;
          regReadData[6]             = statussetabsTimers6;
          regReadData[5]             = statussetabsTimers5;
          regReadData[4]             = statussetabsTimers4;
          regReadData[3]             = statussetabsTimers3;
          regReadData[2]             = statussetabsTimers2;
          regReadData[1]             = statussetabsTimers1;
          regReadData[0]             = statussetabsTimers0;
        end

        // Read TIMERSINTEVENTCLEARREG register.
        TIMERSINTEVENTCLEARREG_ADDR_CT : begin
          regReadData[9]             = clearabsTimers9;
          regReadData[8]             = clearabsTimers8;
          regReadData[7]             = clearabsTimers7;
          regReadData[6]             = clearabsTimers6;
          regReadData[5]             = clearabsTimers5;
          regReadData[4]             = clearabsTimers4;
          regReadData[3]             = clearabsTimers3;
          regReadData[2]             = clearabsTimers2;
          regReadData[1]             = clearabsTimers1;
          regReadData[0]             = clearabsTimers0;
        end

        // Read TIMERSINTUNMASKREG register.
        TIMERSINTUNMASKREG_ADDR_CT : begin
          regReadData[9]             = maskabsTimers9;
          regReadData[8]             = maskabsTimers8;
          regReadData[7]             = maskabsTimers7;
          regReadData[6]             = maskabsTimers6;
          regReadData[5]             = maskabsTimers5;
          regReadData[4]             = maskabsTimers4;
          regReadData[3]             = maskabsTimers3;
          regReadData[2]             = maskabsTimers2;
          regReadData[1]             = maskabsTimers1;
          regReadData[0]             = maskabsTimers0;
        end

        // Read TSFLOREG register.
        TSFLOREG_ADDR_CT : begin
          regReadData[31 : 0]        = tsfTimerLow;
        end

        // Read TSFHIREG register.
        TSFHIREG_ADDR_CT : begin
          regReadData[31 : 0]        = tsfTimerHigh;
        end

        // Read TIMEONAIRPARAM1REG register.
        TIMEONAIRPARAM1REG_ADDR_CT : begin
          regReadData[31 : 30]       = ppduSTBC;
          regReadData[29 : 28]       = ppduNumExtnSS;
          regReadData[27 : 26]       = ppduBW;
          regReadData[25 : 24]       = ppduGI;
          regReadData[23 : 20]       = ppduPreType;
          regReadData[19 : 0]        = ppduLength;
        end

        // Read TIMEONAIRPARAM2REG register.
        TIMEONAIRPARAM2REG_ADDR_CT : begin
          regReadData[30 : 28]       = ppduNumHeLtf;
          regReadData[26 : 20]       = ppduNUser;
          regReadData[18 : 16]       = ppduPE;
          regReadData[15 : 13]       = ppduMCSSigB;
          regReadData[12]            = ppduDCMSigB;
          regReadData[11]            = ppduSigBCompMode;
          regReadData[10 : 9]        = ppduHELTFType;
          regReadData[8]             = ppduDCM;
          regReadData[6 : 0]         = ppduMCSIndex;
        end

        // Read TIMEONAIRPARAM3REG register.
        TIMEONAIRPARAM3REG_ADDR_CT : begin
          regReadData[6 : 4]         = ppduRuType;
          regReadData[1]             = ppduMma;
          regReadData[0]             = ppduDoppler;
        end

        // Read TIMEONAIRVALUEREG register.
        TIMEONAIRVALUEREG_ADDR_CT : begin
          regReadData[31]            = computeDuration;
          regReadData[30]            = timeOnAirValid;
          regReadData[15 : 0]        = timeOnAir;
        end

        // Read DMACNTRLSETREG register.
        DMACNTRLSETREG_ADDR_CT : begin
          regReadData[20]            = statussethaltTBAfterTXOP;
          regReadData[19]            = statussethaltAC3AfterTXOP;
          regReadData[18]            = statussethaltAC2AfterTXOP;
          regReadData[17]            = statussethaltAC1AfterTXOP;
          regReadData[16]            = statussethaltAC0AfterTXOP;
          regReadData[15]            = statussethaltBcnAfterTXOP;
          regReadData[13]            = statussettxTBNewHead;
          regReadData[12]            = statussettxAC3NewHead;
          regReadData[11]            = statussettxAC2NewHead;
          regReadData[10]            = statussettxAC1NewHead;
          regReadData[9]             = statussettxAC0NewHead;
          regReadData[8]             = statussettxBcnNewHead;
          regReadData[4]             = statussettxAC3NewTail;
          regReadData[3]             = statussettxAC2NewTail;
          regReadData[2]             = statussettxAC1NewTail;
          regReadData[1]             = statussettxAC0NewTail;
          regReadData[0]             = statussettxBcnNewTail;
        end

        // Read DMACNTRLCLEARREG register.
        DMACNTRLCLEARREG_ADDR_CT : begin
          regReadData[20]            = clearhaltTBAfterTXOP;
          regReadData[19]            = clearhaltAC3AfterTXOP;
          regReadData[18]            = clearhaltAC2AfterTXOP;
          regReadData[17]            = clearhaltAC1AfterTXOP;
          regReadData[16]            = clearhaltAC0AfterTXOP;
          regReadData[15]            = clearhaltBcnAfterTXOP;
          regReadData[13]            = cleartxTBNewHead;
          regReadData[12]            = cleartxAC3NewHead;
          regReadData[11]            = cleartxAC2NewHead;
          regReadData[10]            = cleartxAC1NewHead;
          regReadData[9]             = cleartxAC0NewHead;
          regReadData[8]             = cleartxBcnNewHead;
          regReadData[4]             = cleartxAC3NewTail;
          regReadData[3]             = cleartxAC2NewTail;
          regReadData[2]             = cleartxAC1NewTail;
          regReadData[1]             = cleartxAC0NewTail;
          regReadData[0]             = cleartxBcnNewTail;
        end

        // Read DMASTATUS1REG register.
        DMASTATUS1REG_ADDR_CT : begin
          regReadData[21 : 20]       = txTBState;
          regReadData[17 : 16]       = txAC3State;
          regReadData[13 : 12]       = txAC2State;
          regReadData[9 : 8]         = txAC1State;
          regReadData[5 : 4]         = txAC0State;
          regReadData[1 : 0]         = txBcnState;
        end

        // Read DMASTATUS2REG register.
        DMASTATUS2REG_ADDR_CT : begin
          regReadData[5]             = txNewHeadErr;
          regReadData[4]             = txBusErr;
          regReadData[3]             = txPTAddressErr;
          regReadData[2]             = txNextPointerErr;
          regReadData[1]             = txUPatternErr;
          regReadData[0]             = txLenMismatch;
        end

        // Read DMASTATUS3REG register.
        DMASTATUS3REG_ADDR_CT : begin
          regReadData[5]             = rxPayBusErr;
          regReadData[4]             = rxHdrBusErr;
        end

        // Read DMASTATUS4REG register.
        DMASTATUS4REG_ADDR_CT : begin
          regReadData[15]            = txTBHaltAfterTXOP;
          regReadData[14]            = txAC3HaltAfterTXOP;
          regReadData[13]            = txAC2HaltAfterTXOP;
          regReadData[12]            = txAC1HaltAfterTXOP;
          regReadData[11]            = txAC0HaltAfterTXOP;
          regReadData[10]            = txBcnHaltAfterTXOP;
          regReadData[9]             = txAC3EndQ;
          regReadData[8]             = txAC2EndQ;
          regReadData[7]             = txAC1EndQ;
          regReadData[6]             = txAC0EndQ;
          regReadData[5]             = txBcnEndQ;
          regReadData[4]             = txAC3Startup;
          regReadData[3]             = txAC2Startup;
          regReadData[2]             = txAC1Startup;
          regReadData[1]             = txAC0Startup;
          regReadData[0]             = txBcnStartup;
        end

        // Read TXBCNHEADPTRREG register.
        TXBCNHEADPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = txBcnHeadPtr;
        end

        // Read TXAC0HEADPTRREG register.
        TXAC0HEADPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = txAC0HeadPtr;
        end

        // Read TXAC1HEADPTRREG register.
        TXAC1HEADPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = txAC1HeadPtr;
        end

        // Read TXAC2HEADPTRREG register.
        TXAC2HEADPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = txAC2HeadPtr;
        end

        // Read TXAC3HEADPTRREG register.
        TXAC3HEADPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = txAC3HeadPtr;
        end

        // Read TXTBHEADPTRREG register.
        TXTBHEADPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = txTBHeadPtr;
        end

        // Read TXSTRUCTSIZESREG register.
        TXSTRUCTSIZESREG_ADDR_CT : begin
          regReadData[29 : 24]       = dmaRBDSize;
          regReadData[23 : 18]       = dmaRHDSize;
          regReadData[17 : 12]       = dmaTBDSize;
          regReadData[11 : 6]        = dmaTHDSize;
          regReadData[5 : 0]         = ptEntrySize;
        end

        // Read DMATHRESHOLDREG register.
        DMATHRESHOLDREG_ADDR_CT : begin
          regReadData[23 : 16]       = rxFIFOThreshold;
          regReadData[7 : 0]         = txFIFOThreshold;
        end

        // Read RXHEADERTFPTRREG register.
        RXHEADERTFPTRREG_ADDR_CT : begin
          regReadData[31 : 2]        = rxHeaderTFPtr;
        end

        // Read RXBUF1STARTPTRREG register.
        RXBUF1STARTPTRREG_ADDR_CT : begin
          regReadData[30 : 0]        = rxBuf1StartPtr;
        end

        // Read RXBUF1ENDPTRREG register.
        RXBUF1ENDPTRREG_ADDR_CT : begin
          regReadData[30 : 0]        = rxBuf1EndPtr;
        end

        // Read RXBUF1RDPTRREG register.
        RXBUF1RDPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = rxBuf1RdPtr;
        end

        // Read RXBUF1WRPTRREG register.
        RXBUF1WRPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = rxBuf1WrPtr;
        end

        // Read RXBUF2STARTPTRREG register.
        RXBUF2STARTPTRREG_ADDR_CT : begin
          regReadData[30 : 0]        = rxBuf2StartPtr;
        end

        // Read RXBUF2ENDPTRREG register.
        RXBUF2ENDPTRREG_ADDR_CT : begin
          regReadData[30 : 0]        = rxBuf2EndPtr;
        end

        // Read RXBUF2RDPTRREG register.
        RXBUF2RDPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = rxBuf2RdPtr;
        end

        // Read RXBUF2WRPTRREG register.
        RXBUF2WRPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = rxBuf2WrPtr;
        end

        // Read RXBUFCONFIGREG register.
        RXBUFCONFIGREG_ADDR_CT : begin
          regReadData[31 : 24]       = rxBufRPDFooter;
          regReadData[23 : 16]       = rxBufRPDHeader;
          regReadData[15 : 8]        = rxBufRHDFooter;
          regReadData[7 : 0]         = rxBufRHDHeader;
        end

        // Read MOT1REG register.
        MOT1REG_ADDR_CT : begin
          regReadData[31 : 16]       = ac1MOT;
          regReadData[15 : 0]        = ac0MOT;
        end

        // Read MOT2REG register.
        MOT2REG_ADDR_CT : begin
          regReadData[31 : 16]       = ac3MOT;
          regReadData[15 : 0]        = ac2MOT;
        end

        // Read TXBWDROPINFOREG register.
        TXBWDROPINFOREG_ADDR_CT : begin
          regReadData[1 : 0]         = txBWAfterDrop;
        end

        // Read TXHETBINFOREG register.
        TXHETBINFOREG_ADDR_CT : begin
          regReadData[31 : 28]       = maxMCSInHETB;
          regReadData[26 : 24]       = eOCW;
          regReadData[22 : 20]       = eOCWMin;
          regReadData[17]            = raRUType;
          regReadData[16]            = raRUEnable;
          regReadData[13 : 8]        = txHETBMaxDur;
          regReadData[5 : 0]         = txHETBRemDur;
        end

        // Read RXHETRIGCOMMONINFOREG register.
        RXHETRIGCOMMONINFOREG_ADDR_CT : begin
          regReadData[29]            = ulDoppler;
          regReadData[28]            = ulPEDisambiguity;
          regReadData[27 : 26]       = ulPreFecPadding;
          regReadData[25]            = ulLDPCExtrSymb;
          regReadData[24]            = ulSTBC;
          regReadData[23 : 21]       = ulNLTFAndMidamble;
          regReadData[20]            = ulMULTFMode;
          regReadData[19 : 18]       = ulGILTFType;
          regReadData[17 : 16]       = ulBW;
          regReadData[15 : 4]        = ulLength;
          regReadData[3 : 0]         = ulTriggerType;
        end

        // Read RXHETRIGUSERINFOREG register.
        RXHETRIGUSERINFOREG_ADDR_CT : begin
          regReadData[31 : 24]       = tdUserInfoSubfield;
          regReadData[12]            = ulRUType;
          regReadData[11 : 9]        = ulNSS;
          regReadData[8]             = ulDCM;
          regReadData[7 : 4]         = ulMCS;
          regReadData[3]             = ulFECCoding;
          regReadData[2 : 0]         = ulRUSize;
        end

        // Read RXHETRIGPSDULENREG register.
        RXHETRIGPSDULENREG_ADDR_CT : begin
          regReadData[31]            = ulPSDULenValid;
          regReadData[19 : 0]        = ulPSDULen;
        end

        // Read RXHETRIGPWRINFOREG register.
        RXHETRIGPWRINFOREG_ADDR_CT : begin
          regReadData[31 : 24]       = heTBUPHControl;
          regReadData[14 : 8]        = ulTargetRSSI;
          regReadData[5 : 0]         = apTXPower;
        end
`ifdef RW_MUMIMO_TX_EN                     

        // Read SECUSERSTXINTEVENTSETREG register.
        SECUSERSTXINTEVENTSETREG_ADDR_CT : begin
          regReadData[23]            = statussetsecU3ac3TxBufTrigger;
          regReadData[22]            = statussetsecU3ac2TxBufTrigger;
          regReadData[21]            = statussetsecU3ac1TxBufTrigger;
          regReadData[20]            = statussetsecU3ac0TxBufTrigger;
          regReadData[19]            = statussetsecU3ac3TxTrigger;
          regReadData[18]            = statussetsecU3ac2TxTrigger;
          regReadData[17]            = statussetsecU3ac1TxTrigger;
          regReadData[16]            = statussetsecU3ac0TxTrigger;
          regReadData[15]            = statussetsecU2ac3TxBufTrigger;
          regReadData[14]            = statussetsecU2ac2TxBufTrigger;
          regReadData[13]            = statussetsecU2ac1TxBufTrigger;
          regReadData[12]            = statussetsecU2ac0TxBufTrigger;
          regReadData[11]            = statussetsecU2ac3TxTrigger;
          regReadData[10]            = statussetsecU2ac2TxTrigger;
          regReadData[9]             = statussetsecU2ac1TxTrigger;
          regReadData[8]             = statussetsecU2ac0TxTrigger;
          regReadData[7]             = statussetsecU1ac3TxBufTrigger;
          regReadData[6]             = statussetsecU1ac2TxBufTrigger;
          regReadData[5]             = statussetsecU1ac1TxBufTrigger;
          regReadData[4]             = statussetsecU1ac0TxBufTrigger;
          regReadData[3]             = statussetsecU1ac3TxTrigger;
          regReadData[2]             = statussetsecU1ac2TxTrigger;
          regReadData[1]             = statussetsecU1ac1TxTrigger;
          regReadData[0]             = statussetsecU1ac0TxTrigger;
        end

        // Read SECUSERSTXINTEVENTCLEARREG register.
        SECUSERSTXINTEVENTCLEARREG_ADDR_CT : begin
          regReadData[23]            = clearsecU3ac3TxBufTrigger;
          regReadData[22]            = clearsecU3ac2TxBufTrigger;
          regReadData[21]            = clearsecU3ac1TxBufTrigger;
          regReadData[20]            = clearsecU3ac0TxBufTrigger;
          regReadData[19]            = clearsecU3ac3TxTrigger;
          regReadData[18]            = clearsecU3ac2TxTrigger;
          regReadData[17]            = clearsecU3ac1TxTrigger;
          regReadData[16]            = clearsecU3ac0TxTrigger;
          regReadData[15]            = clearsecU2ac3TxBufTrigger;
          regReadData[14]            = clearsecU2ac2TxBufTrigger;
          regReadData[13]            = clearsecU2ac1TxBufTrigger;
          regReadData[12]            = clearsecU2ac0TxBufTrigger;
          regReadData[11]            = clearsecU2ac3TxTrigger;
          regReadData[10]            = clearsecU2ac2TxTrigger;
          regReadData[9]             = clearsecU2ac1TxTrigger;
          regReadData[8]             = clearsecU2ac0TxTrigger;
          regReadData[7]             = clearsecU1ac3TxBufTrigger;
          regReadData[6]             = clearsecU1ac2TxBufTrigger;
          regReadData[5]             = clearsecU1ac1TxBufTrigger;
          regReadData[4]             = clearsecU1ac0TxBufTrigger;
          regReadData[3]             = clearsecU1ac3TxTrigger;
          regReadData[2]             = clearsecU1ac2TxTrigger;
          regReadData[1]             = clearsecU1ac1TxTrigger;
          regReadData[0]             = clearsecU1ac0TxTrigger;
        end

        // Read SECUSERSTXINTEVENTUNMASKREG register.
        SECUSERSTXINTEVENTUNMASKREG_ADDR_CT : begin
          regReadData[31]            = masterSecUsersTxIntEn;
          regReadData[23]            = masksecU3ac3TxBufTrigger;
          regReadData[22]            = masksecU3ac2TxBufTrigger;
          regReadData[21]            = masksecU3ac1TxBufTrigger;
          regReadData[20]            = masksecU3ac0TxBufTrigger;
          regReadData[19]            = masksecU3ac3TxTrigger;
          regReadData[18]            = masksecU3ac2TxTrigger;
          regReadData[17]            = masksecU3ac1TxTrigger;
          regReadData[16]            = masksecU3ac0TxTrigger;
          regReadData[15]            = masksecU2ac3TxBufTrigger;
          regReadData[14]            = masksecU2ac2TxBufTrigger;
          regReadData[13]            = masksecU2ac1TxBufTrigger;
          regReadData[12]            = masksecU2ac0TxBufTrigger;
          regReadData[11]            = masksecU2ac3TxTrigger;
          regReadData[10]            = masksecU2ac2TxTrigger;
          regReadData[9]             = masksecU2ac1TxTrigger;
          regReadData[8]             = masksecU2ac0TxTrigger;
          regReadData[7]             = masksecU1ac3TxBufTrigger;
          regReadData[6]             = masksecU1ac2TxBufTrigger;
          regReadData[5]             = masksecU1ac1TxBufTrigger;
          regReadData[4]             = masksecU1ac0TxBufTrigger;
          regReadData[3]             = masksecU1ac3TxTrigger;
          regReadData[2]             = masksecU1ac2TxTrigger;
          regReadData[1]             = masksecU1ac1TxTrigger;
          regReadData[0]             = masksecU1ac0TxTrigger;
        end
`endif // RW_MUMIMO_TX_EN                     

        // Read DEBUGBCNSPTRREG register.
        DEBUGBCNSPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = bcnStatusPointer;
        end

        // Read DEBUGAC0SPTRREG register.
        DEBUGAC0SPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = ac0StatusPointer;
        end

        // Read DEBUGAC1SPTRREG register.
        DEBUGAC1SPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = ac1StatusPointer;
        end

        // Read DEBUGAC2SPTRREG register.
        DEBUGAC2SPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = ac2StatusPointer;
        end

        // Read DEBUGAC3SPTRREG register.
        DEBUGAC3SPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = ac3StatusPointer;
        end

        // Read DEBUGTBSPTRREG register.
        DEBUGTBSPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = tbStatusPointer;
        end

        // Read DEBUGTXCPTRREG register.
        DEBUGTXCPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = txCurrentPointer;
        end

        // Read SWPROFILINGREG register.
        SWPROFILINGREG_ADDR_CT : begin
          regReadData[31]            = swProf31;
          regReadData[30]            = swProf30;
          regReadData[29]            = swProf29;
          regReadData[28]            = swProf28;
          regReadData[27]            = swProf27;
          regReadData[26]            = swProf26;
          regReadData[25]            = swProf25;
          regReadData[24]            = swProf24;
          regReadData[23]            = swProf23;
          regReadData[22]            = swProf22;
          regReadData[21]            = swProf21;
          regReadData[20]            = swProf20;
          regReadData[19]            = swProf19;
          regReadData[18]            = swProf18;
          regReadData[17]            = swProf17;
          regReadData[16]            = swProf16;
          regReadData[15]            = swProf15;
          regReadData[14]            = swProf14;
          regReadData[13]            = swProf13;
          regReadData[12]            = swProf12;
          regReadData[11]            = swProf11;
          regReadData[10]            = swProf10;
          regReadData[9]             = swProf9;
          regReadData[8]             = swProf8;
          regReadData[7]             = swProf7;
          regReadData[6]             = swProf6;
          regReadData[5]             = swProf5;
          regReadData[4]             = swProf4;
          regReadData[3]             = swProf3;
          regReadData[2]             = swProf2;
          regReadData[1]             = swProf1;
          regReadData[0]             = swProf0;
        end

        // Read SWSETPROFILINGREG register.
        SWSETPROFILINGREG_ADDR_CT : begin
          regReadData[31]            = statusswSetProf31;
          regReadData[30]            = statusswSetProf30;
          regReadData[29]            = statusswSetProf29;
          regReadData[28]            = statusswSetProf28;
          regReadData[27]            = statusswSetProf27;
          regReadData[26]            = statusswSetProf26;
          regReadData[25]            = statusswSetProf25;
          regReadData[24]            = statusswSetProf24;
          regReadData[23]            = statusswSetProf23;
          regReadData[22]            = statusswSetProf22;
          regReadData[21]            = statusswSetProf21;
          regReadData[20]            = statusswSetProf20;
          regReadData[19]            = statusswSetProf19;
          regReadData[18]            = statusswSetProf18;
          regReadData[17]            = statusswSetProf17;
          regReadData[16]            = statusswSetProf16;
          regReadData[15]            = statusswSetProf15;
          regReadData[14]            = statusswSetProf14;
          regReadData[13]            = statusswSetProf13;
          regReadData[12]            = statusswSetProf12;
          regReadData[11]            = statusswSetProf11;
          regReadData[10]            = statusswSetProf10;
          regReadData[9]             = statusswSetProf9;
          regReadData[8]             = statusswSetProf8;
          regReadData[7]             = statusswSetProf7;
          regReadData[6]             = statusswSetProf6;
          regReadData[5]             = statusswSetProf5;
          regReadData[4]             = statusswSetProf4;
          regReadData[3]             = statusswSetProf3;
          regReadData[2]             = statusswSetProf2;
          regReadData[1]             = statusswSetProf1;
          regReadData[0]             = statusswSetProf0;
        end

        // Read SWCLEARPROFILINGREG register.
        SWCLEARPROFILINGREG_ADDR_CT : begin
          regReadData[31]            = swClearProf31;
          regReadData[30]            = swClearProf30;
          regReadData[29]            = swClearProf29;
          regReadData[28]            = swClearProf28;
          regReadData[27]            = swClearProf27;
          regReadData[26]            = swClearProf26;
          regReadData[25]            = swClearProf25;
          regReadData[24]            = swClearProf24;
          regReadData[23]            = swClearProf23;
          regReadData[22]            = swClearProf22;
          regReadData[21]            = swClearProf21;
          regReadData[20]            = swClearProf20;
          regReadData[19]            = swClearProf19;
          regReadData[18]            = swClearProf18;
          regReadData[17]            = swClearProf17;
          regReadData[16]            = swClearProf16;
          regReadData[15]            = swClearProf15;
          regReadData[14]            = swClearProf14;
          regReadData[13]            = swClearProf13;
          regReadData[12]            = swClearProf12;
          regReadData[11]            = swClearProf11;
          regReadData[10]            = swClearProf10;
          regReadData[9]             = swClearProf9;
          regReadData[8]             = swClearProf8;
          regReadData[7]             = swClearProf7;
          regReadData[6]             = swClearProf6;
          regReadData[5]             = swClearProf5;
          regReadData[4]             = swClearProf4;
          regReadData[3]             = swClearProf3;
          regReadData[2]             = swClearProf2;
          regReadData[1]             = swClearProf1;
          regReadData[0]             = swClearProf0;
        end

        // Read SWPROFILINGREG2 register.
        SWPROFILINGREG2_ADDR_CT : begin
          regReadData[31]            = swProf63;
          regReadData[30]            = swProf62;
          regReadData[29]            = swProf61;
          regReadData[28]            = swProf60;
          regReadData[27]            = swProf59;
          regReadData[26]            = swProf58;
          regReadData[25]            = swProf57;
          regReadData[24]            = swProf56;
          regReadData[23]            = swProf55;
          regReadData[22]            = swProf54;
          regReadData[21]            = swProf53;
          regReadData[20]            = swProf52;
          regReadData[19]            = swProf51;
          regReadData[18]            = swProf50;
          regReadData[17]            = swProf49;
          regReadData[16]            = swProf48;
          regReadData[15]            = swProf47;
          regReadData[14]            = swProf46;
          regReadData[13]            = swProf45;
          regReadData[12]            = swProf44;
          regReadData[11]            = swProf43;
          regReadData[10]            = swProf42;
          regReadData[9]             = swProf41;
          regReadData[8]             = swProf40;
          regReadData[7]             = swProf39;
          regReadData[6]             = swProf38;
          regReadData[5]             = swProf37;
          regReadData[4]             = swProf36;
          regReadData[3]             = swProf35;
          regReadData[2]             = swProf34;
          regReadData[1]             = swProf33;
          regReadData[0]             = swProf32;
        end

        // Read SWSETPROFILINGREG2 register.
        SWSETPROFILINGREG2_ADDR_CT : begin
          regReadData[31]            = statusswSetProf63;
          regReadData[30]            = statusswSetProf62;
          regReadData[29]            = statusswSetProf61;
          regReadData[28]            = statusswSetProf60;
          regReadData[27]            = statusswSetProf59;
          regReadData[26]            = statusswSetProf58;
          regReadData[25]            = statusswSetProf57;
          regReadData[24]            = statusswSetProf56;
          regReadData[23]            = statusswSetProf55;
          regReadData[22]            = statusswSetProf54;
          regReadData[21]            = statusswSetProf53;
          regReadData[20]            = statusswSetProf52;
          regReadData[19]            = statusswSetProf51;
          regReadData[18]            = statusswSetProf50;
          regReadData[17]            = statusswSetProf49;
          regReadData[16]            = statusswSetProf48;
          regReadData[15]            = statusswSetProf47;
          regReadData[14]            = statusswSetProf46;
          regReadData[13]            = statusswSetProf45;
          regReadData[12]            = statusswSetProf44;
          regReadData[11]            = statusswSetProf43;
          regReadData[10]            = statusswSetProf42;
          regReadData[9]             = statusswSetProf41;
          regReadData[8]             = statusswSetProf40;
          regReadData[7]             = statusswSetProf39;
          regReadData[6]             = statusswSetProf38;
          regReadData[5]             = statusswSetProf37;
          regReadData[4]             = statusswSetProf36;
          regReadData[3]             = statusswSetProf35;
          regReadData[2]             = statusswSetProf34;
          regReadData[1]             = statusswSetProf33;
          regReadData[0]             = statusswSetProf32;
        end

        // Read SWCLEARPROFILINGREG2 register.
        SWCLEARPROFILINGREG2_ADDR_CT : begin
          regReadData[31]            = swClearProf63;
          regReadData[30]            = swClearProf62;
          regReadData[29]            = swClearProf61;
          regReadData[28]            = swClearProf60;
          regReadData[27]            = swClearProf59;
          regReadData[26]            = swClearProf58;
          regReadData[25]            = swClearProf57;
          regReadData[24]            = swClearProf56;
          regReadData[23]            = swClearProf55;
          regReadData[22]            = swClearProf54;
          regReadData[21]            = swClearProf53;
          regReadData[20]            = swClearProf52;
          regReadData[19]            = swClearProf51;
          regReadData[18]            = swClearProf50;
          regReadData[17]            = swClearProf49;
          regReadData[16]            = swClearProf48;
          regReadData[15]            = swClearProf47;
          regReadData[14]            = swClearProf46;
          regReadData[13]            = swClearProf45;
          regReadData[12]            = swClearProf44;
          regReadData[11]            = swClearProf43;
          regReadData[10]            = swClearProf42;
          regReadData[9]             = swClearProf41;
          regReadData[8]             = swClearProf40;
          regReadData[7]             = swClearProf39;
          regReadData[6]             = swClearProf38;
          regReadData[5]             = swClearProf37;
          regReadData[4]             = swClearProf36;
          regReadData[3]             = swClearProf35;
          regReadData[2]             = swClearProf34;
          regReadData[1]             = swClearProf33;
          regReadData[0]             = swClearProf32;
        end
`ifdef RW_MUMIMO_SEC_USER1_EN              

        // Read DEBUGSECU1TXCPTRREG register.
        DEBUGSECU1TXCPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = secU1TxCurrentPointer;
        end
`endif // RW_MUMIMO_SEC_USER1_EN              
`ifdef RW_MUMIMO_SEC_USER2_EN              

        // Read DEBUGSECU2TXCPTRREG register.
        DEBUGSECU2TXCPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = secU2TxCurrentPointer;
        end
`endif // RW_MUMIMO_SEC_USER2_EN              
`ifdef RW_MUMIMO_SEC_USER3_EN              

        // Read DEBUGSECU3TXCPTRREG register.
        DEBUGSECU3TXCPTRREG_ADDR_CT : begin
          regReadData[31 : 0]        = secU3TxCurrentPointer;
        end
`endif // RW_MUMIMO_SEC_USER3_EN              

        // Disable coverage on the default state because it cannot be reached.
        // pragma coverage block = off 
        default : regReadData = `RW_REG_DATA_WIDTH'b0;
        // pragma coverage block = on 

      endcase
    
    end
    else
      regReadData = `RW_REG_DATA_WIDTH'b0;
    
  end 
  
  
endmodule

////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

