//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : Top level of macController module
//                    
// Simulation Notes : 
// Synthesis Notes  :
//
//   A false path should be defined bewteen numMPDURetries and macPIClk
//   A false path should be defined bewteen numRTSRetries  and macPIClk
//   As per design, these signals are static when the DMA Engine capture them.
//
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module macController( 
          //$port_g Clock and Reset interface
          input  wire         macCoreClk,              // MAC Core Transmit Clock
          input  wire         macCoreClkHardRst_n,     // Hard Reset of the MAC Core Clock domain 
                                                       // active low
          input  wire         macCoreClkSoftRst_n,     // Soft Reset of the MAC Core Clock domain 
                                                       // active low
          output wire         macCoreTxClkEn,          // Enable the MAC Core TX Clock.
                                                       
          //$port_g Interface with the DMA Engine      
          input  wire         statusUpdated_p,         // Indication from the DMA that status have been updated.
          output wire         updateDMAStatus_p,       // trigs the DMA Status update.
          output wire         trigTxTB,                // TB DMA Channel Trigger
          output wire         swRTS_p,                 // Asserted high if the current transmitted packet is a
                                                       // RTS frame prepared by SW
          output wire         txMpduDone_p,            // Asserted high after every transmission of MPDU in an 
                                                       // AMPDU frame
          output wire         ampduFrm_p,              // Asserted high if the transmitted packet was an AMPDU
                                                       // frame
          output wire         retryFrame_p,            // If the transmitted frame has to be retried then this
                                                       // signal is asserted.
          output wire         mpduSuccess_p,           // If the transmitted frame was successful. Not asserted
                                                       // for RTS frames
          output wire         mpduFailed_p,            // If the transmitted frame was not successful. Not asserted
                                                       // if the RTS frame failed
          output wire         rtsFailed_p,             // If the transmitted frame was a RTS frame and did not 
                                                       // receive a CTS frame within the CTS timeout
          output wire         rtsSuccess_p,            // If the transmitted frame was a RTS frame and successfully
                                                       // received a CTS in reponse.
          output wire         retryLimitReached_p,     // If the transmitted frame was not successful and has reached  
                                                       // the retry limit.Is asserted for both RTS and other MPDU's    
          output wire   [1:0] transmissionBW,          // Indicates whether the frame was transmitted with 20MHz, 40MHz, 80MHz or 160MHz BW
          output wire   [3:0] whichDescriptorSW,       // Indicates the value of the whichDescriptorSW field for Status in THD
          output wire   [7:0] numMPDURetries,          // Indicates the number of retries for this MPDU. Valid when 
                                                       // rtsFailed_p rtsSuccess_p mpduSuccess_p mpduFailed_p or 
                                                       // retryLimitReached 
          output wire   [7:0] numRTSRetries,           // Indicates the number of retries for this RTS. Valid when 
                                                       // rtsFailed_p rtsSuccess_p mpduSuccess_p mpduFailed_p or 
                                                       // retryLimitReached 
          output wire  [31:0] mediumTimeUsed,          // Indicates the medium Time Used for current transmission
                                                       // Valid when DMA status is being updated
          input  wire         rxFrmDiscard,            // Discard current frame

          //$port_g Interface with the Tx Parameters Cache
          input  wire         txParameterHDReady_p,    // Indicates that the Header Descriptor fields are usable 
          input  wire         txParameterPTReady_p,    // Indicates that the Policy Table fields are usable
          input  wire         txParameterNextPTReady_p,// Indicates that a second policy table has already been loaded
          output wire         toggleHDSet_p,           // Indicates that the Header Descriptor Set can be toggled
          output wire         togglePTSet_p,           // Indicates that the Policy Table Set can be toggled
          output wire         clearSets_p,             // Indicates that the Sets have to be cleared.
          input  wire  [15:0] protFrmDur,              // Protection Frame Duration
          input  wire         writeACK,                // Indicate SW expects the ACK frame for this frame
                                                       // to be passed to it when received.
          input  wire         lowRateRetry,            // Lower Rate on Retries
          input  wire         lstpProt,                // L-SIG TXOP Protection for protection frame
          input  wire         lstp,                    // L-SIG TXOP Protection
          input  wire         dontTouchDur,            // Indicates that HW should not update the Duration field
          input  wire   [1:0] expectedAck,             // Expected Acknowledgement
                                                       //   2'b00: No acknowledgement.
                                                       //   2'b01: Normal ACK.
                                                       //   2'b10: BA.
                                                       //   2'b11: Compressed BA.
          input  wire   [2:0] navProtFrmEx,            // NAV Protection Frame Exchange
                                                       //   3'b000: No protection
                                                       //   3'b001: Self-CTS
                                                       //   3'b010: RTS/CTS with intended receiver of this PPDU
                                                       //   3'b011: RTS/CTS with QAP 
                                                       //   3'b100: STBC protection
          input  wire         muMIMOTx,                // Multi-User Transmission
          input  wire         preTypeProtTx,           // Preamble Type of Protection frame for Transmission
                                                       //   1'b0: SHORT
                                                       //   1'b1: LONG
          input  wire         preTypeTx,               // Preamble Type of PPDU for Transmission
                                                       // Same coding than preTypeProtTx
          input  wire         dynBWTx,                 // Dynamic Bandwidth for Transmission
          input  wire         useBWSignalingTx,        // Use BW Signaling for Transmission
          input  wire         smoothingProtTxPT,       // Smoothing of Protection frame for Transmission
          input  wire         smoothingTxPT,           // Smoothing of PPDU for Transmission
          input  wire         soundingTxPT,            // Sounding Protection frame for Transmission
          input  wire   [2:0] nTxProtPT,               // Number of Transmit Chains for Protection Frame
          input  wire   [2:0] nTxPT,                   // Number of Transmit Chains for PPDU
          input  wire   [1:0] giTypePT,                // Guard Interval Type for Transmission
          input  wire   [1:0] heLTFTypePT,             // HE-LTF Type for Transmission
          input  wire         fecCodingPT,             // FEC Coding
          input  wire   [1:0] stbcPT,                  // Space Time Block Coding
          input  wire   [1:0] numExtnSSPT,             // Number of Extension Spatial Streams
          input  wire   [2:0] packetExtensionPT,       // Packet Extension Value
          input  wire   [7:0] smmIndexPT,              // Spatial Map Matrix Index
          input  wire         dopplerPT,               // Doppler for transmission
          input  wire         midamblePT,              // Midamble for transmission
          input  wire         dcmPT,                   // Dual Carrier Modulation for transmission
          input  wire   [9:0] keySRAMIndex,            // Key Storage RAM Index
          input  wire   [9:0] keySRAMIndexRA,          // Key Storage RAM Index for Receiver Address
          input  wire         aMPDU,                   // Indicates whether this Transmit Header Descriptor belong to an A-MPDU
          input  wire         txSMPDU,                 // Flag of S-MPDU
          input  wire   [1:0] whichDescriptor,         // Indicates what kind of a descriptor this is
          input  wire   [3:0] fcSubtype,               // Indicates the fcSubtype field of the Frame Control field of the MPDU.
          input  wire   [1:0] fcType,                  // Indicates the fcType field of the Frame Control field of the MPDU
          input  wire         tsValid,                 // Indicates if the fcType and fcSubtype fields have been populated correctly
                                                       
          input  wire  [11:0] rtsThreshold,            // RTS Threshold
          input  wire   [7:0] shortRetryLimit,         // Short Retry Limit
          input  wire   [7:0] longRetryLimit,          // Long Retry Limit
          input  wire   [3:0] formatModProtTx,         // Format and Modulation of Protection frame for Transmission
                                                       //   4'b0000: NON-HT
                                                       //   4'b0001: NON-HT-DUP-OFDM
                                                       //   4'b0010: HT-MF
                                                       //   4'b0011: HT-GF
                                                       //   4'b0100: VHT
                                                       //   4'b0101: HE-SU
                                                       //   4'b0110: HE-MU
                                                       //   4'b0111: HE-ER-SU
                                                       //   4'b1000: HE-TB
          input  wire   [3:0] formatModTx,             // Format and Modulation of PPDU for Transmission
                                                       // Same coding than formatModProtTx
                                                       
          input  wire   [1:0] bwProtTx,                // Band Width of Protection frame for Transmission
          input  wire   [1:0] bwTx,                    // Band Width of PPDU for Transmission
          input  wire   [7:0] numMPDURetriesTPC,       // Indicates the number of MPDU retries already done   
          input  wire   [7:0] numRTSRetriesTPC,        // Indicates the number of RTS retries already done  
          input  wire  [19:0] aMPDUFrameLengthTx,      // Length of the entire A-MPDU
          input  wire  [19:0] aMPDUOptFrameLength20Tx, // Length of the entire A-MPDU BW drop 20Mhz
          input  wire  [19:0] aMPDUOptFrameLength40Tx, // Length of the entire A-MPDU BW drop 40Mhz
          input  wire  [19:0] aMPDUOptFrameLength80Tx, // Length of the entire A-MPDU BW drop 80Mhz
          input  wire   [6:0] mcsIndex0ProtTx,         // MCS Index 0 of Protection frame for Transmission
          input  wire   [6:0] mcsIndex0Tx,             // MCS Index 0 of PPDU for Transmission
                                                       
          input  wire  [15:0] MPDUFrameLengthTx,       // Length of the MPDU
                                                       
          input  wire  [31:0] mediumTimeUsedTPC,       // Medium Time Used for current TX transfer
                                                       
          //$port_g Tx Controller interface            
          output wire         txRxExchangeEnabled,     // Indicates that tx or rx echange is on-going  
          output wire         sendData_p,              // Indicates that data packet has to be sent
          output wire         sendRTS_p,               // Indicates that an RTS packet has to be sent
          output wire         sendCTS_p,               // Indicates that a CTS packet has to be sent
          output wire         sendACK_p,               // Indicates that an ACK packet has to be sent
          output wire         sendCFEND_p,             // Indicates that a CF-END packet has to be sent
          output wire         sendBA_p,                // Indicates that an Block ACK packet has to be sent
`ifdef RW_BFMEE_EN
          output wire         sendBFR_p,               // Indicates that an BFR packet has to be sent
`endif //RW_BFMEE_EN                                   
          output wire         sendBQR_p,               // Indicates that an BQR packet has to be sent
          output wire         sendSWTB_p,              // Indicates that an SW Trigger based frame
                                                       // has to be sent
          output wire         sendOnSIFS,              // If set, data is sent on tickSIFS else on tickSlot
          output wire         sendOnPIFS,              // If set, data is sent on tickPIFS
          output wire         skipMPDU_p,              // Indication that MPDU in TX FIFO has to be discarded
                                                       
          output wire  [47:0] srcAddr,                 // Source address
          output wire  [47:0] destAddr,                // Receiver address
          output wire  [15:0] duration,                // Duration
          output wire         retry,                   // Indicates that the trame is a retry.
          output wire  [15:0] tsfDuration,             // Duration from the preamble until the first bit of TSF
                                                       
          output wire   [6:0] txMCS,                   // MCS (Only used for HT frame)
          output wire  [11:0] txLegLength,             // Legacy Length of the PPDU         
          output wire  [ 3:0] txLegRate,               // Legacy Rate of the PPDU.         
          output wire  [19:0] txHTLength,              // Length of the HT PPDU
          output wire         txSTBC,                  // Transmit a Frame with Space Time Block Coding
          output wire   [6:0] txTxopDuration,          // Transmit a Frame with TXOP Duration
          output wire         txDisambiguityBit,       // Transmit a Frame with disambiguityBit
                                                       
                                                       
          output wire   [1:0] txChBW,                  // Transmit a Frame with Channel Bandwidth
          output wire         txBWSignaling,           // Transmission with BW Signaling
          output wire         txDynBW,                 // Transmission with Dynamic BW
          output wire         txResp,                  // Transmit a Response Frame
          output wire         txFromHD,                // Transmit a HW generated frame based on THD
          output wire         txFromFifo,              // Transmit a Frame from Tx FIFO
          output wire         txCFEND,                 // Transmit a HW generated CFEND frame
          output reg          txRxn,                   // Indicates the mode between TX and Rx
                                                       //   0 : RX
                                                       //   1 : TX
          output wire         txFecCoding,             // Transmit a frame with FEC Coding       
          output wire   [1:0] txGIType,                // Guard Interval type for transmission
          output wire   [1:0] txHELTFType,             // HE LTF TYpe of the frame to transmit
          output wire   [2:0] txPacketExtension,       // Packet Extension of the frame to transmit
          output wire         txDoppler,               // Doppler of the frame to transmit
          output wire         txMidamble,              // Midamble of the frame to transmit
          output wire         txDcm,                   // DCM of the frame to transmit
          input  wire         txDone_p,                // Indicates that the transmission is completed
          input  wire   [3:0] txTID,                   // TID of the transmitted frame
          input  wire   [1:0] typeTx,                  // TYPE of the transmitted frame
          input  wire         typeTxValid,             // Indicates typeTx is valid and can be latched
          input  wire         txAMSDUPresent,          // Indicates than the transmitted frame is an A-MSDU
          input  wire         txBcMc,                  // Indicates than the transmitted frame has a group address.
          input  wire         sentCFEND,               // Indicates that the transmitted frame is a CF-END
          input  wire         sentRTS,                 // Indicates that the transmitted frame is a RTS
          input  wire         sentBAReq,               // Indicates that the transmitted frame is a BA-Request
          input  wire         sentNDP,                 // Indicates that the transmitted frame is a NDP
`ifdef RW_BFMER_EN                                     
          input  wire         sentBFRPOLL,             // Indicates that the transmitted frame is a BFR POLL
`endif //RW_BFMER_EN
          input  wire         startTx_p,               // Start Tx trigger                 
          input  wire         mpduDone_p,              // Indicates that the MPDU has been sent
          input  wire         skipMPDUDone_p,          // Indicates that MPDU contained in the TXFIFO has been discarded.
          input  wire         beamFormed,              // Indicates that the transmitted frame is beamformed
                                                       
          output wire   [7:0] respTxAntennaSet,        // Response Transmission with Antenna Set
          output wire   [7:0] respTxSMMIndex,          // Response Transmission with Spatial Map Matrix Index
          output wire         respTxPreType,           // Response Transmission with Preamble Type
                                                       //   1'b0: SHORT
                                                       //   1'b1: LONG
          output wire   [3:0] respTxFormatMod,         // Response Transmission with Format and Modulation
                                                       //   3'd0: NON-HT
                                                       //   3'd1: NON-HT-DUP-OFDM
                                                       //   3'd2: HT-MF
                                                       //   3'd3: HT-GF
                                                       //   3'd4: VHT
                                                       //   3'd5: HE_SU
                                                       //   3'd8: HE_TB
          output wire         respTxAMPDU,             // Response Transmission with A-MPDU
          output wire         respTxSMPDU,             // Response Transmission with S-MPDU
          output wire  [14:0] respMPDUFrameLengthTx,   // MPDU Length of the A-MPDU response
          output wire   [1:0] respTxNumExtnSS,         // Response Transmission with Number of Extension Spatial Streams
          output wire         respTxFECCoding,         // Response Transmission with Low Density Partity Check       
          output wire   [2:0] respTxNTx,               // Response Transmission with Number of Transmit Chains for PPDU        
          output wire   [1:0] respTxGIType,            // Response Transmission with Guard Interval Type
          output wire   [7:0] respTxPwrLevel,          // Response Transmission with Transmit power level
          output wire   [1:0] respTxHELTFType,         // Response Transmission with HE LTF Type
          output wire         respTxDoppler,           // Response Transmission with Doppler
          output wire         respTxMidamble,          // Response Transmission with Midamble
          output wire   [5:0] respTxBSSColor,          // Response Transmission with BSS Color
          output wire         respTxDcm,               // Response Transmission with DCM
          output wire   [3:0] respTxSpatialReuse1,     // Response Transmission with Spatial Reuse 1
          output wire   [3:0] respTxSpatialReuse2,     // Response Transmission with Spatial Reuse 2
          output wire   [3:0] respTxSpatialReuse3,     // Response Transmission with Spatial Reuse 3
          output wire   [3:0] respTxSpatialReuse4,     // Response Transmission with Spatial Reuse 4
          output wire   [8:0] respTxHESigAReserved,    // Response Transmission with HE SIG-A Reserved bits
          output wire   [2:0] respTxNumHeLtf,          // Response Transmission with Number of HE LTF
          output wire         respTxHELtfMode,         // Response Transmission with HE LTF Mode
          output wire         respTxLDPCExtraSymbol,   // Response Transmission with LDPC extra symbol
          output wire   [2:0] respTxStartingSTSNum,    // Response Transmission with Starting STS Number
          output wire   [7:0] respTxRUAllocation,      // Response Transmission with RU allocation
          output wire   [2:0] respTxPacketExtension,   // Response Transmission with Packet Extension
          output wire         respTxTriggerMethod,     // Response Transmission with trigger method
          output wire   [6:0] respTxRUToneSetIndex,    // Response Transmission with RU tone set index
          output wire         respTxFeedBackStatus,    // Response Transmission with feedback status
          output wire         respTxTriggerResponding, // Response Transmission with Trigger Responding
          output wire         respTxBeamChange,        // Response Transmission with Beam Change
          output wire   [7:0] acBitmap,                // Available channel bitmap
          output wire   [5:0] ulPwrHeadroom,           // Uplink Power Headroom
          output wire         txUPHControl,            // UPH Control field is present in the
                                                       // transmitted frame
                                                       
          //$port_g Rx Controller interface            
          output reg          stopRx_p,                // Stop Rx
          output wire         activeRx,                // Current state Master is active Rx and Rx FSM is not IDLE
          output wire         rxAck,                   // Force receive only ACK after Tx
          output wire         rxBA,                    // Force receive only BA after Tx
          output wire         rxCts,                   // Force receive only CTS after RTS Tx
`ifdef RW_BFMER_EN                                     
          output wire         rxBfr,                   // Force receive only BFR after VHT NDP Tx
`endif                                                 
          output wire         forceWriteACK,           // Force the RX to pass the ACK to the Software
          output wire         lSIGTXOPDetected,        // Flag indicates received packet is LSIG TXOP protected
          output wire         frameExpectingResp,      // Indicates that the received frame expect
                                                       // an immediate response
          input  wire         dataFrame,               // Frame type received is DATA
          input  wire         reservedRcved,           // Frame type received is Reserved
          input  wire         trsRcved_p,              // Frame with TRS Control field received
                                                       // pulse
          input  wire         bfrPollRcved_p,          // BFR-Poll received pulse
          input  wire         ndpaRcved_p,             // NDP-A received pulse
          input  wire         ackRcved_p,              // ACK received
          input  wire         rtsRcved_p,              // RTS received
          input  wire         ctsRcved_p,              // CTS received
          input  wire         cfEndRcved_p,            // CF-End received
          input  wire         baRcved_p,               // BA received 
          input  wire         barRcved_p,              // BAR received
          input  wire         needAckRcved_p,          // Data or management received with ACK needed
          input  wire         needHTPAckRcved_p,       // Received frame that need an HTP Ack 
          input  wire         bcMcRcved_p,             // Broadcast/Multicast
          input  wire         bcnRcved_p,              // Beacon received
          input  wire         probRespRcved_p,         // Prob Response received
          input  wire         notMineRcved_p,          // Frame received but not mine
          input  wire         notMineRtsRcved_p,       // Not mine RTS received
          input  wire         notMineMURtsRcved_p,     // Not mine MU-RTS received
          input  wire         notMinePsPollRcved_p,    // Not mine PS-Poll received
          input  wire         unknownRcved_p,          // Unknown frame received
`ifdef RW_BFMER_EN                                     
          input  wire         bfrRcved_p,              // BFR received pulse 
`endif // RW_BFMER_EN                                  
          input  wire         muBARTriggerRcved_p,     // MU-BAR Trigger Received pulse
          input  wire         macHeaderCompleted,      // End of MAC Header reception
          input  wire   [1:0] rxFCType,                // Indicates the fcType field of the received frame
                                                       
          input  wire         incorrectRcved_p,        // Frame not received correctly
          input  wire         correctRcved_p,          // Frame received correctly
                                                       
          input  wire         rxCsIsIdle,              // Rx Controller is in idle state
                                                       
          input  wire  [47:0] rxAddr1,                 // Received addr1
          input  wire  [47:0] rxAddr2,                 // Received addr2
          input  wire   [1:0] rxAckPolicy,             // Ack policy (Ack, No Ack, BA)
          input  wire  [15:0] rxFrameDuration,         // Frame duration
          input  wire  [31:0] rxHTCtrl,                // HT control field of the received frame
                                                       
          input  wire   [3:0] rxTID,                   // TID of the received frame
          input  wire         rxAMSDUPresent,          // Indicates than the received frame is an A-MSDU
          input  wire         rxRetry,                 // Indicates than the received frame has its retry bit set.
          input  wire         bcMcRcved,               // Indicates than the received frame has a group address.
          input  wire         notMineRcved,            // Indicates than the received frame is not destined to this device.
          input  wire         rxBWSignalingTA,         // Indicate that the received frame has a Bandwidth Signaling TA
          input  wire         rxTriggerHWValid_p,      // Trigger HW Valid pulse
          input  wire         rxTriggerSWValid_p,      // Trigger SW Valid pulse
          input  wire   [3:0] rxTriggerType,           // Trigger frame, Type
          input  wire  [11:0] rxTriggerULLength,       // Trigger frame, UL Length
          input  wire         rxTriggerCS,             // Trigger frame, CS
          input  wire   [1:0] rxTriggerULBW,           // Trigger frame, UL BW
          input  wire   [1:0] rxTriggerGIAndLTFType,   // Trigger frame, GI And LTF Type
          input  wire         rxTriggerHELTFMode,      // Trigger frame, HE-LTF Mode
          input  wire   [2:0] rxTriggerNumHELTFAndMidPeriod,// Trigger frame, Number of HE-LTF
                                                            // symbols And Midamble Periodicity
          input  wire         rxTriggerULSTBC,         // Trigger frame, STBC
          input  wire         rxTriggerLDPCExtraSymbol,// Trigger frame, LDPC Extra Symbol Segment
          input  wire   [5:0] rxTriggerAPTxPower,      // Trigger frame, AP TX Power
          input  wire   [2:0] rxTriggerULPacketExtension,// Trigger frame, UL Packet Extension
          input  wire  [15:0] rxTriggerULSpatialReuse, // Trigger frame, UL Spatial Reuse
          input  wire         rxTriggerDoppler,        // Trigger frame, Doppler
          input  wire   [8:0] rxTriggerULHESigA2Reserved, // Trigger frame, UL HE-SIG-A Reserved
          input  wire   [7:0] rxTriggerRUAllocation,   // Trigger frame, RU Allocation
          input  wire         rxTriggerULFECCoding,    // Trigger frame, UL Coding Type
          input  wire   [3:0] rxTriggerULMCS,          // Trigger frame, UL MCS
          input  wire         rxTriggerULDCM,          // Trigger frame, UL DCM
          input  wire   [2:0] rxTriggerStartingSSNum,  // Trigger frame, Starting Spatial Stream
          input  wire   [2:0] rxTriggerNumSS,          // Trigger frame, Number Of Spatial Streams
          input  wire   [6:0] rxTriggerULTargetRSSSI,  // Trigger frame, UL Target RSSI

          //$port_g deaggregator interface
          input  wire  [11:0] rxLegLength,             // Legacy length
          input  wire  [19:0] rxHTLength,              // HT length
          input  wire  [15:0] rxMpduLength,            // RX MPDU length
          input  wire   [3:0] rxLegRate,               // Legacy rate
          input  wire   [6:0] rxMCS,                   // MCS
          input  wire         rxPreType,               // Preamble type
          input  wire   [3:0] rxFormatMod,             // Format and modulation
          input  wire         rxDynBWInNonHT,          // Dynamique Bandwidth
          input  wire         rxSTBC,                  // Space Time Block Coding
          input  wire   [1:0] rxChBW,                  // Channel bandwidth
          input  wire   [1:0] rxChBWInNonHT,           // Channel bandwidth in Non-HT extracted from the scrambler initialization sequence
          input  wire   [1:0] rxGIType,                // Guard Interval Type
          input  wire         rxLSIGValid,             // L-SIG Valid of received frame
          input  wire   [1:0] rxNumExtnSS,             // Number of Extension Spatial Streams
          input  wire         rxFecCoding,             // Low Density Partity Check  of received frame  
          input  wire         rxAggregation,           // MPDU aggregate
          input  wire   [7:0] rxAntennaSet,            // Antenna set
          input  wire   [2:0] rxNss,                   // Number of Spacial Stream
          input  wire         rxNDP,                   // Indicate that the received frame is a Null Data Packet
          input  wire         rxBeamformed,            // Indicate that the Received frame is beamformed
          input  wire   [5:0] rxGroupID,               // Group ID
          input  wire         rxDcm,                   // Indicates the Dual Carrier Modulation
          input  wire   [1:0] rxHeLtfType,             // Indicates the type of HE-LTF
          input  wire         rxDoppler,               // Indicates whether the doppler effect
                                                       // should be considered for the PPDU or not
          input  wire         rxMidamble,              // Indicates the midamble periodicity
          input  wire   [5:0] rxBssColor,              // Indicate the BSS color of the AP
          input  wire   [6:0] rxTxopDuration,          // Indicates a duration that is used to
                                                       // update the NAV for this TXOP
          input  wire  [7:0] rxRSSILegacy,            // RSSI during Legacy preamble of received
                                                      // frame
                                                       
          input  wire         ampduCorrectRcved_p,     // A-MPDU received correctly
          input  wire         ampduIncorrectRcved_p,   // A-MPDU not received correctly
          input  wire         rxSMPDU,                 // Detect EOF bit in AMPDU delimiter for a
                                                       // S-MPDU
          input  wire         rxVector1Valid_p,        // Rx vector 1 is available
          input  wire         rxEndOfFrame_p,          // Rx vector 2 is available
          input  wire         rxVector1Start_p,        // Indicate that the first byte of RX Vector has been received
          input  wire   [5:0] rxMPDUCnt,               // Count the number of MPDU detected
          input  wire   [7:0] incorrectDelCnt,         // Count the number of incorrect delimiter
                                                       
          output reg          startRx,                 // Start Rx
                                                       
          //$port_g MAC-PHY interface                                                             
          input  wire         mpIfTxErr_p,             // Tx error from MAC-PHY if. resynchronized
          input  wire         macPhyIfRxCca,           // CCA trigger                   
          input  wire         macPhyIfRxCcaSec20,      // CCA trigger Secondary 20MHz
          input  wire         macPhyIfRxCcaSec40,      // CCA trigger Secondary 40MHz
          input  wire         macPhyIfRxStart_p,       // Start of reception pulse
          input  wire         macPhyIfRxErr_p,         // Rx error from MAC-PHY if. resynchronized
          input  wire         macPhyIfRxEnd_p,         // mpIF state machine is idle
          input  wire         macPhyIfRxFlush_p,       // Rx flush pulse
          input  wire         macPHYIFUnderRun,        // Underrun from MAC-PHY if.
          input  wire         macPhyIfRifsRxDetected,  // RIFS detected indication                      
          input  wire         macPhyIfRxEndForTiming_p,// end of reception at the antenna                        
          output wire         mpifKeepRFon,            // Keep RF On

`ifdef RW_BFMEE_EN
          //$port_g BFR Controller interface
          input  wire         bfrStart,                // BFR computation started
          input  wire  [14:0] bfrLength,               // Beamforming Report frame Length
          input  wire         needBFRRcved_p,          // Frame received with BFR response needed pulse
          input  wire         needTBBFRRcved_p,        // Frame received with BFR response needed
                                                       // pulse
          input  wire         incorrectBFRPollRcved_p, // Beamforming Report Poll is not correct
`endif //RW_BFMEE_EN

          //$port_g SR controller interface
          input  wire         stopRxSRC_p,             // Stop Reception trigger from SR Controller

          //$port_g Interface with the Key Search Engine
          input  wire  [47:0] macAddressKSR,           // MAC Addr returned by Key Search Engine
          input  wire         keyStorageValid_p,       // Indicates when the Key Search Engine has returned the result 
          output wire         txKeySearchIndexTrig_p,  // Trigs the Key Search Engine for a Key Research based on index.
          output wire   [9:0] txKeySearchIndex,        // Key Index used by the Key Search Engine for Research based on index.

          //$port_g BackOff and AC Selection Module interface
          input  wire   [3:0] txDmaState,              // DMA state for the active channel
          input  wire  [15:0] txOpLimit,               // TXOP Limit of the active channel
          input  wire         backOffDone_p,           // Indicates when a backOff has expired
          input  wire         trigTxBackoff,           // Indicate that the backoff won the medium
          input  wire         trigTxBcn,               // Trigger from the MAC Controller to indicate DMA to run use the Beacon Queue
          output wire  [15:0] acMOT,                   // Current AC Medium Occupancy timer
          output wire         retryType,               // Indicates the type of retry
                                                       //   0 : Short Retry Limit
                                                       //   1 : Long Retry Limit
          output wire         txSuccessful_p,          // Indicates that the current frame has be correctly transmitted
          output wire         retry_p,                 // Indicates that the current frame has to be retried
          output wire         retryLTReached_p,        // Indicates that the retry limit has been reached
          output wire         txInProgress,            // Tx is ongoing
          output wire         endOfTxOp,               // Indicates the end of the TX OP.
                                                       
          //$port_g TXTIME calculator interface        
          input  wire  [15:0] timeOnAirMC,             // Time On Air result to MAC Controller
                                                       // This field gives the time taken for frame transmission in microseconds (us)
                                                       // computed from parameters given by the MAC Controller.
          input  wire         timeOnAirValidMC,        // Time On Air Valid to MAC Controller
                                                       // This field is set when the air time computation is completed.
          input  wire         disambiguityMC,          // Value of the disambiguityBit in case of VHT frame with shortGI computed by the TxTimeCalculator
                                                       
          output reg    [3:0] ppduPreTypeMC,           // PPDU Preamble Type from MAC Controller
                                                       // This field indicates what type of preamble is transmitted for the frame.
                                                       // The encoding is as follows:
                                                       //   4'b0000: Non-HT-Short
                                                       //   4'b0001: Non-HT-Long
                                                       //   4'b0010: HT-MF
                                                       //   4'b0011: HT-GF
                                                       //   4'b0100: VHT
                                                       //   4'b0101: HE-SU
                                                       //   4'b0110: HE-MU
                                                       //   4'b0111: HE-ER-SU
                                                       //   4'b1000: HE-TB
          output reg   [19:0] ppduLengthMC,            // PPDU Length from MAC Controller
                                                       // This field gives the length of the PPDU for computing time on air.
          output reg    [6:0] ppduMCSIndexMC,          // PPDU LegRate or MCS Index from MAC Controller
                                                       // This field indicates the rate at which this PPDU is transmitted. 
          output reg    [1:0] ppduBWMC,                // PPDU Bandwidth from MAC Controller
                                                       // This field indicates that that the PPDU should be transmitted at 40 MHz.
          output reg    [1:0] ppduNumExtnSSMC,         // Number of Extension Spatial Streams      
          output reg          ppduSTBCMC,              // Enable Space Time Block Coding          
          output reg    [1:0] ppduGITypeMC,            // PPDU Short Guard Interval from MAC Controller
                                                       // Indicates that the frame should be transmitted with Short GI.
          output reg    [1:0] ppduHELTFTypeMC,         // Indicates the type of HE-LTF
          output reg    [2:0] ppduNumHeLtfMC,          // Indicates the number of HE-LTF symbols
                                                       // minus 1
          output reg          ppduDCMMC,               // indicate that dual carrier modulation is
                                                       // used for the HE-Data field
          output reg          ppduTriggerMethodMC,     // Indicates the method used to trigger this 
                                                       // HE TB PPDU transmission
          output reg          ppduDopplerMC,           // Indicates whether the doppler effect 
                                                       // should be considered for the PPDU or not
          output reg          ppduMmaMC,               // Indicates the midamble periodicity
                                                       // 1'b0: 10
                                                       // 1'b1: 20
          output reg    [2:0] ppduRuTypeMC,            // Indicates the type of RU
          output reg    [2:0] ppduPacketExtensionMC,   // Indicates the packet extension parameters.
          output reg    [4:0] ppduHeTbLengthMC,        // Indicates the length of the HE TB PPDU 
                                                       // response to an URMS trigger and is set to
                                                       // the number of OFDM symbols in the Data 
                                                       // field of the HE TB PPDU minus 1.
          output reg          woPreambleMC,            // Indicates that total duration should not include the preamble duration 
          output reg          woSignExtMC,             // Indicates that total duration should not include the signal Extension duration 
          output reg          startComputationMC_p,    // Start Time on Air computation from MAC Controller
                                                       
                                                       
          //$port_g Timers Module interface            
          input  wire         tick1us_p,               // Pulse generated every us.
          input  wire  [15:0] impQICnt,                // Quiet interval counter in 32 us
          input  wire         sec20ChannelIdleFlag,    // Secondary 20MHz channel idle for PIFS flag
          input  wire         sec40ChannelIdleFlag,    // Secondary 40MHz channel idle for PIFS flag
          input  wire         sec80ChannelIdleFlag,    // Secondary 80MHz channel idle for PIFS flag
          input  wire         tickPIFS_p,              // A pulse to indicate the end of PIFS period
          input  wire         rifsTO_p,                // Pulse when RIFS timeout occurs
          input  wire  [7:0]  sifsRemaining,           // us remaining before tick sifs pulse
          output wire  [15:0] frmDurWithoutMH,         // Indicates the duration if the Beacon or Probe Response from the end of the MAC header
          output wire         rxSWTBResp,              // Indicates that a response frame of the 
                                                       // transmitted SW Trigger Based is expected
                                                       // (Flag)
          output wire         respTO_p,                // Indicates that the Time Out Counter has expired.
          output wire         moveToActive_p,          // Core should now move to ACTIVE state
          output wire         moveToIdle_p,            // Indicates that the macControllerMasterFSM moves to IDLE state
                                                       
                                                       
          //$port_g NAV Module interface               
          input  wire         channelBusy,             // Channel busy indicator
          input  wire         basicNAVBusy,            // basic NAV is not null
          output wire  [15:0] ctsDuration,             // Indicates the duration of a CTS frame response of the received RTS
          output wire         ctsDurationValid_p,      // Indicates that the ctsDuration is valid
          output wire  [15:0] ackDuration,             // Indicates the duration of a ACK frame response of the received PS-POLL
          output wire         ackDurationValid_p,      // Indicates that the ackDuration is valid
          output wire  [7:0]  phyRxStartDelay,         // Receive Start Delay of the PHY
          output wire  [15:0] navLsigDuration,         // Indicates the duration computed based on L_LENGTH and L_RATE in HT_MM
                                                       
          //$port_g Doze Module interface              
          input  wire         dozeWakeUp_p,            // Wake up the Mac Controller 
          output wire         moveToDoze_p,            // Move to Doze request

        `ifdef RW_MAC_MIBCNTL_EN
          //$port_g Interface with the MIB Controller
          output wire         mibdot11WEPExcludedCount,              // Counts the number of unencrypted frames that have been discarded.
          output wire         mibdot11FCSErrorCount,                 // Counts the receive FCS errors.
          output wire         mibrwRxPHYErrorCount,                  // Counts the number of PHY Errors reported during a receive transaction.
          output wire         mibrwRxFIFOOverflowCount,              // Counts the number of times the Receive FIFO has overflowed.
          output wire         mibrwTxUnderrunCount,                  // Counts the number of times underrun has occurred on the Transmit side
          output wire         mibrwQosUTransmittedMPDUCount,         // Counts the number of unicast MPDUs, not containing an A-MSDU, that were transmitted successfully without using BA policy.
          output wire         mibrwQosGTransmittedMPDUCount,         // Counts the number of group-addressed MPDUs, not containing an A-MSDU, that were transmitted successfully.
          output wire         mibdot11QosFailedCount,                // Counts the number of MSDUs or MMPDUs that were discarded because of retry-limit-reached condition.
          output wire         mibdot11QosRetryCount,                 // Counts the number of unfragmented MSDUs or unfragmented MMPDUs that were transmitted successfully after 1 or more retransmissions without using BA policy.
          output wire         mibdot11QosRTSSuccessCount,            // Counts the number of successful RTS frame transmissions.
          output wire         mibdot11QosRTSFailureCount,            // Counts the number of unsuccessful RTS frame transmissions
          output wire         mibrwQosACKFailureCount,               // Counts the number of MPDUs, not containing an A-MSDU, that did not receive an ACK frame successfully in response.
          output wire         mibrwQosUReceivedMPDUCount,            // Counts the number of unicast MPDUs, not containing an A-MSDU, received successfully, destined to this device.
          output wire         mibrwQosGReceivedMPDUCount,            // Counts the number of group-addressed MPDUs, not containing an A-MSDU, received successfully.
          output wire         mibrwQosUReceivedOtherMPDU,            // Counts the number of unicast MPDUs, not containing an A-MSDU, received successfully, not destined to this device.
          output wire         mibdot11QosRetriesReceivedCount,       // Counts the number of MPDUs that are received with the retry bit set.
          output wire         mibrwUTransmittedAMSDUCount,           // Counts the number of unicast A-MSDUs that were transmitted successfully without using BA policy. 
          output wire         mibrwGTransmittedAMSDUCount,           // Counts the number of group-addressed A-MSDUs that were transmitted successfully
          output wire         mibdot11FailedAMSDUCount,              // Counts the number of A-MSDUs that were discarded because of retry-limit-reached condition.
          output wire         mibdot11RetryAMSDUCount,               // Counts the number of A-MSDUs that were transmitted successfully after 1 or more retransmissions without using BA policy. 
          output wire  [15:0] mibdot11TransmittedOctetsInAMSDU,      // Counts the number of bytes in the frame body of an A-MSDU that was transmitted successfully without using BA policy
          output wire         mibdot11AMSDUAckFailureCount,          // Counts the number of A-MSDUs that did not receive an ACK frame successfully in response.
          output wire         mibrwUReceivedAMSDUCount,              // Counts the number of unicast A-MSDUs received successfully, destined to this device.
          output wire         mibrwGReceivedAMSDUCount,              // Counts the number of group-addressed A-MSDUs received successfully.
          output wire         mibrwUReceivedOtherAMSDU,              // Counts the number of unicast A-MSDUs received successfully, not destined to this device.
          output wire  [15:0] mibdot11ReceivedOctetsInAMSDUCount,    // Counts the number of bytes in the frame body of an A-MSDU that was received successfully.
          output wire         mibrwHETBBasicCount,                   // Counts the number of Basic frame sent in response to a basic trigger frame.                                                                                                                          
          output wire         mibrwHETBBFRCount,                     // Counts the number of Beamforming Report sent in response to a Beamforming Report Poll trigger frame.                                                                                                 
          output wire         mibrwHETBMUBACount,                    // Counts the number of MU-BA sent in response to a MU-BAR trigger frame.                                                                                                                               
          output wire         mibrwHETBMUCTSCount,                   // Counts the number of MU-CTS sent in response to a MU-RTS trigger frame.                                                                                                                              
          output wire         mibrwHETBBSRCount,                     // Counts the number of Buffer Status Report sent in response to a Buffer Status Report Poll trigger frame.                                                                                             
          output wire         mibrwHETBGCRMUBACount,                 // Counts the number of GCR MU-BA sent in response to a GCR MU-BAR trigger frame.                                                                                                                       
          output wire         mibrwHETBBQRCount,                     // Counts the number of Bandwidth Query Report sent in response to a Bandwidth Query Report Poll trigger frame.                                                                                         
          output wire         mibrwHETBNFRCount,                     // Counts the number of NDP Feedback Report sent in response to a NDP Feedback Report Poll trigger frame.                                                                                               
          output wire         mibrwTransmittedAMPDUInTBCount,        // Counts the number of A-MPDUs that were transmitted inside a Trigger Based frame.                                                                                                                     
          output wire         mibrwTransmittedMPDUInAMPDUInTBCount,  // Counts the number of MPDUs that were transmitted in an A-MPDU inside a Trigger Based frame.                                                                                                          
          output wire  [15:0] mibrwTransmittedOctetsInAMPDUInTBCount,// Counts the number of bytes in a transmitted A-MPDU inside a Trigger Based frame.                                                                                                                     
          output wire         mibdot11TransmittedAMPDUCount,         // Counts the number of A-MPDUs that were transmitted.
          output wire         mibdot11TransmittedMPDUInAMPDUCount,   // Counts the number of MPDUs that were transmitted in an A-MPDU.
          output wire  [15:0] mibdot11TransmittedOctetsInAMPDUCount, // Counts the number of bytes in a transmitted A-MPDU.
          output wire         mibrwUAMPDUReceivedCount,              // Counts the number of unicast A-MPDUs received, destined to this device.
          output wire         mibrwGAMPDUReceivedCount,              // Counts the number of group-addressed A-MPDUs received.
          output wire         mibrwOtherAMPDUReceivedCount,          // Counts the number of unicast A-MPDUs received, not destined to this device.
          output wire         mibdot11MPDUInReceivedAMPDUCount,      // Counts the number of MPDUs that were received in an A-MPDU.
          output wire  [15:0] mibdot11ReceivedOctetsInAMPDUCount,    // Counts the number of bytes received in an A-MPDU.
          output wire   [7:0] mibdot11AMPDUDelimiterCRCErrorCount,   // Counts the number of CRC errors in MPDU Delimiter of an A-MPDU. An immediately repeated CRC error within an A-MPDU is not counted.
          output wire         mibdot11ImplicitBARFailureCount,       // Counts the number of Implicit BAR frames that did not receive the BA frame successfully in response.
          output wire         mibdot11ExplicitBARFailureCount,       // Counts the number of Explicit BAR frames that did not receive the BA frame successfully in response.
          output wire         mibdot1120MHzFrameTransmittedCount,    // Counts the number of frames transmitted at 20 MHz BW.
          output wire         mibdot1140MHzFrameTransmittedCount,    // Counts the number of frames transmitted at 40 MHz BW.
          output wire         mibdot1180MHzFrameTransmittedCount,    // Counts the number of frames transmitted at 80 MHz BW.
          output wire         mibdot11160MHzFrameTransmittedCount,   // Counts the number of frames transmitted at 160 MHz BW.
          output wire         mibdot1120MHzFrameReceivedCount,       // Counts the number of frames received at 20 MHz BW.
          output wire         mibdot1140MHzFrameReceivedCount,       // Counts the number of frames received at 40 MHz BW.
          output wire         mibdot1180MHzFrameReceivedCount,       // Counts the number of frames received at 80 MHz BW.
          output wire         mibdot11160MHzFrameReceivedCount,      // Counts the number of frames received at 160 MHz BW.
          output wire         mibrw20MHzFailedTXOPCount,             // Counts the number of attempts made to acquire a 20 MHz TXOP.
          output wire         mibrw20MHzSuccessfulTXOPCount,         // Counts the number of successful 20 MHz TXOPs.
          output wire         mibrw40MHzFailedTXOPCount,             // Counts the number of attempts made to acquire a 40 MHz TXOP.
          output wire         mibrw40MHzSuccessfulTXOPCount,         // Counts the number of successful 40 MHz TXOPs.
          output wire         mibrw80MHzFailedTXOPCount,             // Counts the number of attempts made to acquire a 80 MHz TXOP.
          output wire         mibrw80MHzSuccessfulTXOPCount,         // Counts the number of successful 80 MHz TXOPs.
          output wire         mibrw160MHzFailedTXOPCount,            // Counts the number of attempts made to acquire a 160 MHz TXOP.
          output wire         mibrw160MHzSuccessfulTXOPCount,        // Counts the number of successful 160 MHz TXOPs.
          output wire         mibrwDynBWDropCount,                   // Count the number of BW drop using dynamic BW management.
          output wire         mibrwStaBWFailedCount,                 // Count the number of failure using static BW management.
          output wire         mibdot11DualCTSSuccessCount,           // Counts the number of times the dual CTS fails. 
          output wire         mibdot11STBCCTSSuccessCount,           // Counts the number of times the AP does not detect a collision PIFS after transmitting a STBC CTS frame. 
          output wire         mibdot11STBCCTSFailureCount,           // Counts the number of times the AP detects a collision PIFS after transmitting a STBC CTS frame.
          output wire         mibdot11nonSTBCCTSSuccessCount,        // Counts the number of times the AP does not detect a collision PIFS after transmitting a non-STBC CTS frame.
          output wire         mibdot11nonSTBCCTSFailureCount,        // Counts the number of times the AP detects a collision PIFS after transmitting a non-STBC CTS frame.
          output wire         mibdot11BeamformingFrameCount,         // Counts the number of frame transmitted using beamforming
          output wire         mibrwBeamformingReceivedFrameCount,    // Counts the number of beamformed frames addressed to the device received
          output wire         mibrwSUBFRTransmittedCount,            // Counts the number of Beamforming Report frames transmitted with SU reports.
          output wire         mibrwMUBFRTransmittedCount,            // Counts the number of Beamforming Report frames transmitted with MU reports.
`ifdef RW_BFMER_EN
          output wire         mibrwBFRReceivedCount,                 // Counts the number of Beamforming Report frames received.
`endif
          output wire         mibrwMUReceivedFrameCount,             // Counts the number of MU-MIMO frames received.

          output wire   [2:0] mibTIDIndex,                           // If TIDN of the MIB is
                                                                     // set to one then in that case
                                                                     // address given out of RAM
                                                                     // shall be determined from 
                                                                     // tidIndex
          output wire         mibTrigger,                            // Trigger From MAC to latch
                                                                     // MIB fields at MIB-MAC interface
 
        `endif // RW_MAC_MIBCNTL_EN

          //$port_g Interrupt Controller interface
          output wire         txopComplete,          // Indicates the completion of a TXOP
          output wire         acBWDropTrigger,       // Indicates a BW drop with AMPDU length change
          output wire         idleInterrupt,         // Indicates that the Core has moved to IDLE state
          output wire         tbTxCancelled,         // Indicates that a SW TB cancel interrupt

          //$port_g HW Error interface
          input  wire         hwErr,                 // HW error detected

        `ifdef RW_WLAN_COEX_EN
          input  wire         coexEnable,            // Enable Coex Feature
          input  wire         coexWlanTxAbort,       // Requests from external arbiter abort all on-going transmission 
          input  wire         coexWlanRxAbort,       // Requests from external arbiter abort all on-going reception 
        `endif // RW_WLAN_COEX_EN

          //$port_g CSReg interface
          output wire   [3:0] currentState,          // Indicates the current state of the Core. The state encoding is as follows:
                                                     //   0000 - IDLE state. This is the default state.
                                                     //   0010 - DOZE state
                                                     //   0011 - ACTIVE state
                                                     //   0100 to 1111  - reserved
          input  wire   [3:0] nextState,             // Indicates the next state of the Core
          output wire   [3:0] nextStateIn,           // When the current state goes back to IDLE, the nextState is also set to IDLE
          output wire         nextStateInValid,      // Indicates that the nextStateIn value can be capture.
          input  wire  [11:0] bssBasicRateSet,       // BSS Basic Rate Set
          input  wire  [15:0] bssBasicHTMCSSetEM,    // BSS Basic HT MCS Set for Equal Modulation
          input  wire   [5:0] bssBasicHTMCSSetUM,    // BSS Basic HT MCS Set for Unequal Modulation
          input  wire  [15:0] bssBasicVHTMCSSet,     // BSS Basic VTH MCS
          input  wire   [7:0] slotTime,              // aSlotTime parameter
          input  wire   [7:0] rxStartDelayMIMO,      // Receive Start Delay for MIMO
          input  wire   [7:0] rxStartDelayShort,     // Receive Start Delay for DSSS/CCK Short preamble
          input  wire   [7:0] rxStartDelayLong,      // Receive Start Delay for DSSS/CCK Long preamble
          input  wire   [7:0] rxStartDelayOFDM,      // Receive Start Delay for OFDM
          input  wire         ap,                    // Indicates the type of device (0: STA, 1: AP)
          input  wire         band5G,                // Indicate the current operating band (0: 2.4GHz, 1:5GHz)
          input  wire         bssType,               // Indicates the type of BSS (0: IBSS, 1: Infrastructure)
          output wire   [7:0] heTBUPHControl,        // HE-TB Uplink power headroom
          input  wire   [2:0] primaryChPosition,     // Primary Channel Position
          input  wire         rxRIFSEn,              // Enable RIFS in RX    
          input  wire  [47:0] bssID,                 // BSSID
          input  wire   [5:0] bssColorCSReg,         // BSS Color
          input  wire  [47:0] macAddr,               // MAC Addr
          input  wire  [15:0] cfEndSTBCDur,          // CF-End STBC Duration
          input  wire   [7:0] ctsSTBCDur,            // CTS STBC Duration
          input  wire         dualCTSProt,           // Dual-CTS Protection
          input  wire   [6:0] basicSTBCMCS,          // Basic STBC MCS
          input  wire   [7:0] ofdmMaxPwrLevel,       // Maximum Power Level for OFDM frames
          input  wire   [7:0] ofdmMinPwrLevel,       // Minimum Power Level for OFDM frames
          input  wire   [7:0] sifs,                  // Provide SIFS duration in us

          input  wire         dynBWEn,               // Enable dynamic Bandwidth support
          input  wire         dropToLowerBW,         // Drop To Lower Bandwidth
          input  wire   [2:0] numTryBWAcquisition,   // Number of Tries for 40/80/160MHz TXOP Acquisition
          input  wire   [1:0] defaultBWTXOP,         // Indicates the default bandwidth for TXOP acquisition
          input  wire         defaultBWTXOPV,        // Indicates if the defaultBWTXOP setting is valid.
          input  wire   [7:0] aPPDUMaxTime,          // aPPDU Maximum Time on Air
          input  wire   [1:0] maxSupportedBW,        // max Supported BW
          input  wire   [2:0] maxPHYNtx,             // Maximum Number of TX chains
          output wire   [1:0] txBWAfterDrop,         // Transmission bandwidth after BW Drop

          input  wire         supportLSTP,           // Indicates that the HW supports L-SIG TXOP

`ifdef RW_BFMEE_EN
          input  wire   [1:0] bfrHELTFType,          // Beamforming Report HE-LTF-TYPE(HE Only)
          input  wire   [1:0] bfrGIType,             // Beamforming Report giType (HE Only)
          input  wire   [2:0] bfrFormatMod,          // Beamforming Report Format and Modulation
          input  wire         bfrShortGI,            // Beamforming Report Short GI
          input  wire   [7:0] bfrMCS,                // Beamforming Report MCS
          input  wire   [1:0] bfrFeedbackType,       // Beamforming report Feedback Type
`endif //RW_BFMEE_EN
          input  wire  [2:0]  defaultPEDur,          // Default Packet Extension Duration

          input  wire         activeClkGating,       // Active Clock Gating This bit is set by SW to turn on 
                                                     // active clock gating in HW. When reset, the HW does not 
                                                     // perform active clock gating, i.e. does not turn off 
                                                     // clocks to save power in ACTIVE state.
          input  wire         disableACKResp,        // Disable ACK Response This bit is set by SW to disable 
                                                     // the automatic ACK generation logic in HW.
          input  wire         disableCTSResp,        // Disable CTS Response This bit is set by SW to disable 
                                                     // the automatic CTS generation logic in HW.
          input  wire         disableBAResp,         // Disable BA Response This bit is set by SW to disable 
          input  wire         disableBQRResp,        // Disable BQR Response. This bit is set by SW
                                                     // to disable the automatic BQR generation
                                                     // logic in HW.
          input  wire         disableTBResp,         // Disable Trigger Based Response.
          input  wire         disableTBCS,           // Disable Carrier Sense on Trigger Based
                                                     // Response
          input  wire         disableTBRU26Resp,     // Disable HE-TB Response on a 26-tones RU
                                                     // (except HE TB feedback NDP)
          input  wire         disableTBUPH,          // Disable UPH Control field in HE TB Response
          input  wire         disableSVDRxPause,     // Disable RX pause during SVD Processing
          input  wire         keepTXOPOpen,          // Keep TXOP Open
          input  wire         remTXOPInDurField,     // Remaining TXOP Indicated in Duration Field
          input  wire         sendCFEnd,             // Send CF-End
          input  wire         sendCFEndNow,          // Send CF-End Now
          output wire         sendCFEndNowInValid,   // Indicates that the sendCFEndNow register has to be updated with sendCFEndNowIn
          output wire         sendCFEndNowIn,        // Give the update value of sendCFEndNow
                                                     // the automatic BA generation logic in HW.

          //$port_g Debug interface
          output wire  [15:0] debugPortMACController1, // DebugPort 1 of the MAC Controller
          output wire  [15:0] debugPortMACControllerRx,// DebugPort of the MAC Controller Rx
          output wire  [15:0] debugPortMACControllerRxSWTB, // DebugPort of the MAC controller RX
          output wire  [15:0] debugPortMACControllerTx,// DebugPort of the MAC Controller Tx
          output wire  [15:0] debugPortBWManagement,   // DebugPort of BW Management
          output wire   [6:0] debugPortAMPDUMC,
          output wire   [7:0] macControlCs,           // State of the MAC Controller FSMs       
          output reg    [7:0] macControlLs            // State of the MAC Controller FSMs when the HW Error happened    
                 );

//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
wire  rxExchangeEnabled;     // Enables the RX frame exchange
wire  rxExchangeCompleted_p; // When the completion of a RX frame exchange
wire  txExchangeEnabled;     // Enables the TX frame exchange
wire  txExchangeCompleted_p; // When the completion of a TX frame exchange
`ifdef  RW_MAC_MIBCNTL_EN
wire  triggerResponse;       // Indicate a Trigger Response
`endif//RW_MAC_MIBCNTL_EN

reg   mpifKeepRFonRx;
wire  rxRIFSPossible;
wire  rxRIFSCancelled_p;

wire startRxMaster_p;
wire stopRxMaster_p;
wire startRxRxC_p;
wire startRxTxC_p;
wire stopRxRxC_p;
wire stopRxTxC_p;

wire txRxnTxC;
wire txRxnRxC;
wire sendCTSTxC_p;
wire sendCTSRxC_p;
wire sendCFENDTxC_p;
wire sendCFENDRxC_p;
wire sendOnSIFSTxC;
wire sendOnSIFSRxC;
wire sendOnPIFSTxC;
wire sendOnPIFSRxC;

wire  [6:0] txMCSTxC;                 // MCS (Only used for HT frame)
wire [11:0] txLegLengthTxC;           // Legacy Length of the PPDU         
wire [ 3:0] txLegRateTxC;             // Legacy Rate of the PPDU.         

wire [19:0] txHTLengthTxC;            // Length of the HT PPDU

wire  [6:0] txMCSRxC;                 // MCS (Only used for HT frame)
wire [11:0] txLegLengthRxC;           // Legacy Length of the PPDU         
wire [ 3:0] txLegRateRxC;             // Legacy Rate of the PPDU.         
wire [19:0] txHTLengthRxC;            // Length of the HT PPDU
wire        txSTBCRxC;                
wire        txSTBCTxC;                
wire  [6:0] txTxopDurationRxC;
wire  [6:0] txTxopDurationTxC;
wire [ 1:0] txChBWRxC;
wire        txDisambiguityBitTxC;                

wire [ 1:0] txChBWTxC;

wire        txBWSignalingTxC;       // Transmission with BW Signaling from MAC Controller TX 
wire        txBWSignalingRxC;       // Response Transmission with BW Signaling from MAC Controller RX
wire        txDynBWTxC;             // Transmission with Dynamic BW from MAC Controller TX 
wire        txDynBWRxC;             // Transmission with Dynamic BW from MAC Controller RX 


wire        retryTxC;              // Retry field from MAC Tx Controller
wire        retryRxC;              // Retry field from MAC Rx Controller
wire [15:0] durationTxC;           // Duration field from MAC Tx Controller
wire [15:0] durationRxC;           // Duration field from MAC Rx Controller
wire [47:0] destAddrTxC;           // Receiver address from MAC Tx Controller
wire [47:0] destAddrRxC;           // Receiver address from MAC Rx Controller
wire [47:0] srcAddrTxC;            // Source address from MAC Tx Controller
wire [47:0] srcAddrRxC;            // Source address from MAC Rx Controller

wire        rateUpdateTxC_p;       // Request from the macControllerTx to update the rate
wire  [6:0] mcsIndex0Prot;         // MCS Index 0 of Protection frame for Transmission

wire        rateUpdateRxC_p;       // Request from the macControllerTx to update the rate
wire        rateUpdateDone_p;      // Indicates the end of the rate processing
wire  [1:0] bwDataTx;              // BW of PPDU for Transmission


wire  [6:0] mcsData;               // MCS Index for PROT frame
wire  [3:0] legRateData;           // Legacy Rate Index for Data frame
wire  [6:0] mcsCFEND;              // MCS Index for CF-END
wire  [3:0] legRateCFEND;          // Legacy Rate Index for CF-END
wire  [6:0] mcsPROT;               // MCS Index for PROT frame
wire  [3:0] legRatePROT;           // Legacy Rate Index for Data frame
wire  [6:0] mcsRESP;               // MCS Index for response frame
wire  [3:0] legRateRESP;           // Legacy Rate Index for response frame



wire [19:0] ppduLengthMCRx;         // PPDU Length from MAC Controller
                                    // This field gives the length of the PPDU for computing time on air.
wire  [1:0] ppduBWMCRx;             // PPDU Bandwidth MHz from MAC Controller
                                    // This field indicates that that the PPDU should be transmitted at 40 MHz.
wire  [3:0] ppduPreTypeMCRx;        // PPDU Preamble Type from MAC Controller
                                    // This field indicates what type of preamble is transmitted for the frame.
                                    // The encoding is as follows:
                                    // 4'b0000: Non-HT-Short
                                    // 4'b0001: Non-HT-Long
                                    // 4'b0010: HT-MF
                                    // 4'b0011: HT-GF
                                    // 4'b0100: VHT
                                    // 4'b0101: HE-SU
                                    // 4'b0110: HE-MU
                                    // 4'b0111: HE-ER-SU
                                    // 4'b1000: HE-TB
wire  [1:0] ppduNumExtnSSMCRx;      // Number of Extension Spatial Streams      
wire        ppduSTBCMCRx;           // Enable Space Time Block Coding          
wire  [1:0] ppduGITypeMCRx;         // PPDU Guard Interval Type from MAC Controller
                                    // Indicates that the frame should be transmitted with Short GI.
wire  [7:0] ppduMCSIndexMCRx;       // PPDU LegRate or MCS Index from MAC Controller
                                    // This field indicates the rate at which this PPDU is transmitted. 
wire  [1:0] ppduHELTFTypeMCRx;      // Indicates the type of HE-LTF
wire  [2:0] ppduNumHeLtfMCRx;       // Indicates the number of HE-LTF symbols minus 1
wire        ppduDCMMCRx;            // Indicates that dual carrier modulation is used for the
                                    // HE-Data field
wire        ppduTriggerMethodMCRx;  // Indicates the method used to trigger this HE TB PPDU
                                    // transmission
wire        ppduDopplerMCRx;        // Indicates whether the doppler effect should be considered for
                                    // the PPDU or not
wire        ppduMmaMCRx;            // Indicates the midamble periodicity
                                    // 1'b0: 10
                                    // 1'b1: 20
wire  [2:0] ppduRuTypeMCRx;         // Indicates the type of RU
wire  [2:0] ppduPacketExtensionMCRx;// Indicates the packet extension parameters.
wire  [4:0] ppduHeTbLengthMCRx;     // Indicates the length of the HE TB PPDU response to an URMS
                                    // trigger and is set to the number of OFDM symbols in the Data 
                                    // field of the HE TB PPDU minus 1.
wire        woPreambleMCRx;         // Indicates that total duration should not include the preamble duration 
wire        woSignExtMCTx;          // Indicates that total duration should not include the signal Extension duration 
wire        startComputationMCRx_p; // Start Time on Air computation from MAC Controller

wire  [3:0] ppduPreTypeMCTx;        // PPDU Preamble Type from MAC Controller
                                    // This field indicates what type of preamble is transmitted for the frame.
                                    // The encoding is as follows:
                                    // 4'b0000: Non-HT-Short
                                    // 4'b0001: Non-HT-Long
                                    // 4'b0010: HT-MF
                                    // 4'b0011: HT-GF
                                    // 4'b0100: VHT
                                    // 4'b0101: HE-SU
                                    // 4'b0110: HE-MU
                                    // 4'b0111: HE-ER-SU
                                    // 4'b1000: HE-TB
wire [19:0] ppduLengthMCTx;         // PPDU Length from MAC Controller
                                    // This field gives the length of the PPDU for computing time on air.
wire  [1:0] ppduBWMCTx;             // PPDU bandwidth from MAC Controller
                                    // This field indicates that that the PPDU should be transmitted at 40 MHz.
wire  [1:0] ppduNumExtnSSMCTx;      // Number of Extension Spatial Streams      
wire        ppduSTBCMCTx;           // Enable Space Time Block Coding          
wire  [1:0] ppduGITypeMCTx;         // PPDU Guard Interval Type from MAC Controller
                                    // Indicates that the frame should be transmitted with Short GI.
wire  [1:0] ppduHELTFTypeMCTx;      // PPDU HE LTF Type from MAC Controller
wire  [6:0] ppduMCSIndexMCTx;       // PPDU LegRate or MCS Index from MAC Controller
wire  [2:0] ppduPacketExtensionMCTx;// PPDU Packet Extension from MAC Controller
wire        ppduDopplerMCTx;        // PPDU Doppler from MAC Controller TX
wire        ppduMmaMCTx;            // PPDU Midamble from MAC Controller TX
wire  [2:0] ppduRuTypeMCTx;         // PPDU Type Of RU
wire        ppduDCMMCTx;            // PPDU Dual Carrier modulation

wire        startComputationMCTx_p; // Start Time on Air computation from MAC Controller

wire  [1:0] rxChOffset;             // Channel Offset of received frame
wire  [7:0] rxSMMIndex;             // Spatial Map Matrix Index of received frame
wire  [2:0] rxNTx;                  // Number of Transmit Chains for PPDU   of received frame    

wire        macCoreTxClkEnTxC;      // Enable TX Clocks from MAC Controller TX
wire        macCoreTxClkEnRxC;      // Enable TX Clocks from MAC Controller RX

wire  [2:0] macControllerMasterFSMCs;  // State of the MAC Controller Master FSM when the HW Error happened          
wire  [4:0] macControllerTxFSMCs;      // State of the MAC Controller TX FSM when the HW Error happened          
wire  [3:0] macControllerRxFSMCs;      // State of the MAC Controller RX FSM when the HW Error happened          

reg         macPhyIfRxErrInt_p;     // Rx error from MAC-PHY if. delayed of one clock cycle
wire  [3:0] rxLegRateConv;          // Converted Rx Legacy rate

wire        toggleHDSetTxC_p;       // Indicates that the Header Descriptor Set can be toggled
                                    // from MAC Controller TX.
wire        toggleHDSetRxC_p;       // Indicates that the Header Descriptor Set can be toggled
                                    // from MAC Controller RX.
wire        clearSetsTxC_p;         // Indicates that the Sets have to be cleared
                                    // from MAC Controller TX.
wire        clearSetsRxC_p;         // Indicates that the Sets have to be cleared
                                    // from MAC Controller RX.
wire [ 1:0] stbcTx;                

`ifdef RW_MAC_MIBCNTL_EN
reg   [1:0] txFrameType;            //Latched value of txType signal from TX Controller
`endif // RW_MAC_MIBCNTL_EN
reg         macPhyIfRxCcaInt;       //Delayed version of macPhyIfRxCca

reg   [1:0] availableBWInt;         // Bandwidth available before the current reception.
wire  [1:0] availableBW;            // Bandwidth available before the current reception considering the maxSupportedBW.

`ifdef RW_MAC_MIBCNTL_EN
wire        frameCorrectlyRcved_p; // Indicate that a frame (AMPU or not has been correctly received.

  reg         bcMcRcvedCapt;         // Indicates than the received frame has a group address (Captured on correctRcved for AMPDU stat).
  reg         notMineRcvedCapt;      // Indicates than the received frame is not destined to this device (Captured on correctRcved for AMPDU stat).
`ifdef RW_BFMEE_EN
  reg         sendBFR;               //Latched value of sendBFR_p pulse
`endif//RW_BFMEE_EN
`endif // RW_MAC_MIBCNTL_EN

reg         macPhyIfRifsRxDetectedDly;
wire        channelBusyInt;// Channel busy indicator (for to 1 if coexWlanTxAbort in case of coex)

wire  [2:0] signalExtension;// Duration of signalExtension

`ifdef RW_MAC_MIBCNTL_EN
reg         startTxDly_p; // Delayed startTx_p pulse.
`endif // RW_MAC_MIBCNTL_EN

wire        txMpduDoneTxC_p;        // Asserted high after every transmission of MPDU in an AMPDU 
                                    // frame. from MAC Controller TX.
wire        txMpduDoneRxC_p;        // Asserted high after every transmission of MPDU in an AMPDU
                                    // frame. from MAC Controller RX.

wire        updateDMAStatusTxC_p;   // trigs the DMA Status update. from MAC Controller TX.
wire        updateDMAStatusRxC_p;   // trigs the DMA Status update. from MAC Controller RX.

wire        ampduFrmTxC_p;          // Asserted high if the transmitted packet was an AMPDU.
                                    // from MAC Controller TX.
wire        ampduFrmRxC_p;          // Asserted high if the transmitted packet was an AMPDU.
                                    // from MAC Controller RX.

wire        mpduSuccessTxC_p;       // If the transmitted frame was successful.
                                    // from MAC Controller TX.
wire        mpduSuccessRxC_p;       // If the transmitted frame was successful.
                                    // from MAC Controller RX.

wire  [3:0] whichDescriptorSWTxC;   // Indicates the value of the whichDescriptorSW field for Status
                                    // in THD. from MAC Controller TX.
wire  [3:0] whichDescriptorSWRxC;   // Indicates the value of the whichDescriptorSW field for Status
                                    // in THD. from MAC Controller RX.
                                    //
wire  [7:0] numMPDURetriesTxC;      // Indicates the value of the numMPDURetries field for Status
                                    // in THD. from MAC Controller TX.
wire  [7:0] numMPDURetriesRxC;      // Indicates the value of the numMPDURetries field for Status
                                    // in THD. from MAC Controller RX.

wire  [7:0] numRTSRetriesTxC;       // Indicates the value of the numMPDURetries field for Status
                                    // in THD. from MAC Controller TX.

wire  [1:0] transmissionBWTxC;      // Indicates the value of the transmissionBW field for Status
                                    // in THD. from MAC Controller TX.
wire  [1:0] transmissionBWRxC;      // Indicates the value of the transmissionBW field for Status
                                    // in THD. from MAC Controller RX.

wire        rxBATxC;                // Force receive only BA after Tx
                                    // from MAC Controller TX.
wire        rxBARxC;                // Force receive only BA after Tx
                                    // from MAC Controller RX.


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////



//assign macCoreTxClkEn = (activeClkGating) ? (txExchangeEnabled) ? macCoreTxClkEnTxC : macCoreTxClkEnRxC : 1'b1;  
assign macCoreTxClkEn = (activeClkGating && macCoreClkSoftRst_n) ? (txExchangeEnabled) ? macCoreTxClkEnTxC : macCoreTxClkEnRxC : 1'b1;  

assign activeRx = (macControlCs[7:5] == 3'b011) && (macControlCs[3:0] != 4'b0000);

// SignalExtension added for L-LENGTH computation.
assign signalExtension = (band5G) ? 3'd0 : 3'd6;


assign txRxExchangeEnabled = (rxExchangeEnabled || txExchangeEnabled) ? 1'b1 : 1'b0;


// Instanciation of macControllerMaster
// Name of the instance : U_macControllerMaster
// Name of the file containing this module : macControllerMaster.v
macControllerMaster U_macControllerMaster (
    .macCoreClk                       (macCoreClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreClkSoftRst_n              (macCoreClkSoftRst_n),
    .mpIfTxErr_p                      (mpIfTxErr_p),
    .macPhyIfRxCca                    (macPhyIfRxCca),
    .macPhyIfRxErr_p                  (macPhyIfRxErr_p),
    .macPhyIfRxEnd_p                  (macPhyIfRxEnd_p),
    .rxVector1Start_p                 (rxVector1Start_p),
    .startRxMaster_p                  (startRxMaster_p),
    .stopRxMaster_p                   (stopRxMaster_p),
    .backOffDone_p                    (backOffDone_p),
    .trigTxBackoff                    (trigTxBackoff),    
    .rxExchangeCompleted_p            (rxExchangeCompleted_p),
    .rxExchangeEnabled                (rxExchangeEnabled),
    .txExchangeCompleted_p            (txExchangeCompleted_p),
    .txExchangeEnabled                (txExchangeEnabled),
    .moveToActive_p                   (moveToActive_p),
    .moveToIdle_p                     (moveToIdle_p),
    .idleInterrupt                    (idleInterrupt),
    .dozeWakeUp_p                     (dozeWakeUp_p),
    .moveToDoze_p                     (moveToDoze_p),
`ifdef RW_BFMEE_EN
      .bfrStart                         (bfrStart),
`endif
    .hwErr                            (hwErr),
    .disableSVDRxPause                (disableSVDRxPause),
    .macControllerMasterFSMCs         (macControllerMasterFSMCs),
    .currentState                     (currentState),
    .nextState                        (nextState),
    .nextStateIn                      (nextStateIn),
    .nextStateInValid                 (nextStateInValid)
    );



// Instanciation of macControllerTx
// Name of the instance : U_macControllerTx
// Name of the file containing this module : macControllerTx.v
macControllerTx U_macControllerTx (
    .macCoreClk                       (macCoreClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreClkSoftRst_n              (macCoreClkSoftRst_n),
    .macCoreTxClkEnTxC                (macCoreTxClkEnTxC),
    .txExchangeEnabled                (txExchangeEnabled),
    .txExchangeCompleted_p            (txExchangeCompleted_p),
    .txRxnTxC                         (txRxnTxC),
    .availableBW                      (availableBW),
    .updateDMAStatusTxC_p             (updateDMAStatusTxC_p),
    .mcsData                          (mcsData),
    .legRateData                      (legRateData),
    .mcsCFEND                         (mcsCFEND),
    .legRateCFEND                     (legRateCFEND),
    .mcsPROT                          (mcsPROT),
    .legRatePROT                      (legRatePROT),
    .mcsRESP                          (mcsRESP),
    .legRateRESP                      (legRateRESP),
    .rateUpdateDone_p                 (rateUpdateDone_p),
    .rateUpdateTxC_p                  (rateUpdateTxC_p),
    .mcsIndex0Prot                    (mcsIndex0Prot),
    .bwDataTx                         (bwDataTx),
    .stbcTx                           (stbcTx),
    .rxAck                            (rxAck),
    .rxBATxC                          (rxBATxC),
    .rxCts                            (rxCts),
`ifdef RW_BFMER_EN
    .rxBfr                            (rxBfr),
`endif // RW_BFMER_EN
    .forceWriteACK                    (forceWriteACK),
    .ackRcved_p                       (ackRcved_p),
    .rtsRcved_p                       (rtsRcved_p),
    .ctsRcved_p                       (ctsRcved_p),
    .cfEndRcved_p                     (cfEndRcved_p),
    .baRcved_p                        (baRcved_p),
    .barRcved_p                       (barRcved_p),
    .needAckRcved_p                   (needAckRcved_p),
    .bcMcRcved_p                      (bcMcRcved_p),
    .bcnRcved_p                       (bcnRcved_p),
    .notMineRcved_p                   (notMineRcved_p),
    .unknownRcved_p                   (unknownRcved_p),
`ifdef RW_BFMER_EN
    .bfrRcved_p                       (bfrRcved_p),
`endif // RW_BFMER_EN
    .rxFrameDuration                  (rxFrameDuration),
    .incorrectRcved_p                 (incorrectRcved_p),
    .correctRcved_p                   (correctRcved_p),
    .rxCsIsIdle                       (rxCsIsIdle),
    .rxChBW                           (rxChBW),
    .rxChBWInNonHT                    (rxChBWInNonHT),
    .ampduCorrectRcved_p              (ampduCorrectRcved_p),
    .ampduIncorrectRcved_p            (ampduIncorrectRcved_p),
    .rxEndOfFrame_p                   (rxEndOfFrame_p),
    .startRxTxC_p                     (startRxTxC_p),
    .stopRxTxC_p                      (stopRxTxC_p),
    .sendData_p                       (sendData_p),
    .sendRTS_p                        (sendRTS_p),
    .sendCTSTxC_p                     (sendCTSTxC_p),
    .sendCFENDTxC_p                   (sendCFENDTxC_p),
    .sendOnSIFSTxC                    (sendOnSIFSTxC),
    .sendOnPIFSTxC                    (sendOnPIFSTxC),
    .skipMPDU_p                       (skipMPDU_p),
    .destAddrTxC                      (destAddrTxC),
    .srcAddrTxC                       (srcAddrTxC),
    .durationTxC                      (durationTxC),
    .retryTxC                         (retryTxC),
    .txMCSTxC                         (txMCSTxC),
    .txLegLengthTxC                   (txLegLengthTxC),
    .txLegRateTxC                     (txLegRateTxC),
    .txHTLengthTxC                    (txHTLengthTxC),
    .txSTBCTxC                        (txSTBCTxC),
    .txTxopDurationTxC                (txTxopDurationTxC),
    .txDisambiguityBitTxC             (txDisambiguityBitTxC),
    .txChBWTxC                        (txChBWTxC),
    .txDynBWTxC                       (txDynBWTxC),
    .txBWSignalingTxC                 (txBWSignalingTxC),
    .tsfDuration                      (tsfDuration),
    .txFromHD                         (txFromHD),
    .txFromFifo                       (txFromFifo),
    .txCFEND                          (txCFEND),
    .txDone_p                         (txDone_p),
    .txFecCoding                      (txFecCoding),
    .txGIType                         (txGIType),
    .txHELTFType                      (txHELTFType),
    .txPacketExtension                (txPacketExtension),
    .txDoppler                        (txDoppler),
    .txMidamble                       (txMidamble),
    .txDcm                            (txDcm),
    .sentCFEND                        (sentCFEND),
    .sentRTS                          (sentRTS),
    .sentBAReq                        (sentBAReq),
    .sentNDP                          (sentNDP),
`ifdef RW_BFMER_EN
    .sentBFRPOLL                      (sentBFRPOLL),
`endif // RW_BFMER_EN
    .startTx_p                        (startTx_p),
    .mpduDone_p                       (mpduDone_p),
    .skipMPDUDone_p                   (skipMPDUDone_p),
    .toggleHDSetTxC_p                 (toggleHDSetTxC_p),
    .togglePTSet_p                    (togglePTSet_p),
    .clearSetsTxC_p                   (clearSetsTxC_p),
    .clearSets_p                      (clearSets_p),
    .txParameterHDReady_p             (txParameterHDReady_p),
    .txParameterPTReady_p             (txParameterPTReady_p),
    .txParameterNextPTReady_p         (txParameterNextPTReady_p),
    .protFrmDur                       (protFrmDur),
    .writeACK                         (writeACK),
    .lowRateRetry                     (lowRateRetry),
    .lstpProt                         (lstpProt),
    .lstp                             (lstp),
    .dontTouchDur                     (dontTouchDur),
    .expectedAck                      (expectedAck),
    .navProtFrmEx                     (navProtFrmEx),
    .muMIMOTx                         (muMIMOTx),
    .formatModProtTx                  (formatModProtTx),
    .formatModTx                      (formatModTx),
    .preTypeProtTx                    (preTypeProtTx),
    .preTypeTx                        (preTypeTx),
    .bwProtTx                         (bwProtTx),
    .bwTx                             (bwTx),
    .dynBWTx                          (dynBWTx),
    .useBWSignalingTx                 (useBWSignalingTx),
    .smoothingProtTxPT                (smoothingProtTxPT),
    .smoothingTxPT                    (smoothingTxPT),
    .soundingTxPT                     (soundingTxPT),
    .nTxProtPT                        (nTxProtPT),
    .nTxPT                            (nTxPT),
    .giTypePT                         (giTypePT),
    .heLTFTypePT                      (heLTFTypePT),
    .fecCodingPT                      (fecCodingPT),
    .stbcPT                           (stbcPT),
    .numExtnSSPT                      (numExtnSSPT),
    .packetExtensionPT                (packetExtensionPT),
    .smmIndexPT                       (smmIndexPT),
    .dopplerPT                        (dopplerPT),
    .midamblePT                       (midamblePT),
    .dcmPT                            (dcmPT),
    .keySRAMIndex                     (keySRAMIndex),
    .keySRAMIndexRA                   (keySRAMIndexRA),
    .aMPDU                            (aMPDU),
    .txSMPDU                          (txSMPDU),
    .whichDescriptor                  (whichDescriptor),
    .fcSubtype                        (fcSubtype),
    .fcType                           (fcType),
    .tsValid                          (tsValid),
    .rtsThreshold                     (rtsThreshold),
    .shortRetryLimit                  (shortRetryLimit),
    .longRetryLimit                   (longRetryLimit),
    .aMPDUFrameLengthTx               (aMPDUFrameLengthTx),
    .aMPDUOptFrameLength20Tx          (aMPDUOptFrameLength20Tx),
    .aMPDUOptFrameLength40Tx          (aMPDUOptFrameLength40Tx),
    .aMPDUOptFrameLength80Tx          (aMPDUOptFrameLength80Tx),
    .MPDUFrameLengthTx                (MPDUFrameLengthTx),
    .mcsIndex0ProtTx                  (mcsIndex0ProtTx),
    .mcsIndex0Tx                      (mcsIndex0Tx),
    .mediumTimeUsedTPC                (mediumTimeUsedTPC),
    .numMPDURetriesTPC                (numMPDURetriesTPC),
    .numRTSRetriesTPC                 (numRTSRetriesTPC),
    .macAddressKSR                    (macAddressKSR),
    .keyStorageValid_p                (keyStorageValid_p),
    .txKeySearchIndexTrig_p           (txKeySearchIndexTrig_p),
    .txKeySearchIndex                 (txKeySearchIndex),
    .statusUpdated_p                  (statusUpdated_p),
    .swRTS_p                          (swRTS_p),
    .txMpduDoneTxC_p                  (txMpduDoneTxC_p),
    .ampduFrmTxC_p                    (ampduFrmTxC_p),
    .retryFrame_p                     (retryFrame_p),
    .mpduSuccessTxC_p                 (mpduSuccessTxC_p),
    .mpduFailed_p                     (mpduFailed_p),
    .rtsFailed_p                      (rtsFailed_p),
    .rtsSuccess_p                     (rtsSuccess_p),
    .retryLimitReached_p              (retryLimitReached_p),
    .transmissionBWTxC                (transmissionBWTxC),
    .whichDescriptorSWTxC             (whichDescriptorSWTxC),
    .numMPDURetriesTxC                (numMPDURetriesTxC),
    .numRTSRetriesTxC                 (numRTSRetriesTxC),
    .mediumTimeUsed                   (mediumTimeUsed),
    .txDmaState                       (txDmaState),
    .txOpLimit                        (txOpLimit),
    .trigTxBcn                        (trigTxBcn),
    .acMOT                            (acMOT),
    .retryType                        (retryType),
    .retry_p                          (retry_p),
    .retryLTReached_p                 (retryLTReached_p),
    .txSuccessful_p                   (txSuccessful_p),
    .endOfTxOp                        (endOfTxOp),
    .tick1us_p                        (tick1us_p),
    .impQICnt                         (impQICnt),
    .sec20ChannelIdleFlag             (sec20ChannelIdleFlag),
    .sec40ChannelIdleFlag             (sec40ChannelIdleFlag),
    .sec80ChannelIdleFlag             (sec80ChannelIdleFlag),
    .sifsRemaining                    (sifsRemaining),
    .respTO_p                         (respTO_p),
    .timeOnAirMC                      (timeOnAirMC),
    .timeOnAirValidMC                 (timeOnAirValidMC),
    .disambiguityMC                   (disambiguityMC),
    .ppduLengthMCTx                   (ppduLengthMCTx),
    .ppduBWMCTx                       (ppduBWMCTx),
    .ppduPreTypeMCTx                  (ppduPreTypeMCTx),
    .ppduNumExtnSSMCTx                (ppduNumExtnSSMCTx),
    .ppduSTBCMCTx                     (ppduSTBCMCTx),
    .ppduGITypeMCTx                   (ppduGITypeMCTx),
    .ppduHELTFTypeMCTx                (ppduHELTFTypeMCTx),
    .ppduMCSIndexMCTx                 (ppduMCSIndexMCTx),
    .ppduPacketExtensionMCTx          (ppduPacketExtensionMCTx),
    .ppduDopplerMCTx                  (ppduDopplerMCTx),
    .ppduMmaMCTx                      (ppduMmaMCTx),
    .ppduRuTypeMCTx                   (ppduRuTypeMCTx),
    .ppduDCMMCTx                      (ppduDCMMCTx),
    .woSignExtMCTx                    (woSignExtMCTx),
    .startComputationMCTx_p           (startComputationMCTx_p),
    .mpIfTxErr_p                      (mpIfTxErr_p),
    .macPhyIfRxStart_p                (macPhyIfRxStart_p),
    .macPhyIfRxErr_p                  (macPhyIfRxErr_p),
    .macPhyIfRxEnd_p                  (macPhyIfRxEnd_p),
    .macPHYIFUnderRun                 (macPHYIFUnderRun),
    .txopComplete                     (txopComplete),
    .acBWDropTrigger                  (acBWDropTrigger),
    .hwErr                            (hwErr),
  `ifdef RW_MAC_MIBCNTL_EN
    .mibrw20MHzFailedTXOPCount        (mibrw20MHzFailedTXOPCount),
    .mibrw20MHzSuccessfulTXOPCount    (mibrw20MHzSuccessfulTXOPCount),
    .mibrw40MHzFailedTXOPCount        (mibrw40MHzFailedTXOPCount),
    .mibrw40MHzSuccessfulTXOPCount    (mibrw40MHzSuccessfulTXOPCount),
    .mibrw80MHzFailedTXOPCount        (mibrw80MHzFailedTXOPCount),
    .mibrw80MHzSuccessfulTXOPCount    (mibrw80MHzSuccessfulTXOPCount),
    .mibrw160MHzFailedTXOPCount       (mibrw160MHzFailedTXOPCount),
    .mibrw160MHzSuccessfulTXOPCount   (mibrw160MHzSuccessfulTXOPCount),
    .mibrwDynBWDropCount              (mibrwDynBWDropCount),
    .mibrwStaBWFailedCount            (mibrwStaBWFailedCount),
  `endif // RW_MAC_MIBCNTL_EN
  `ifdef RW_WLAN_COEX_EN
    .coexEnable                       (coexEnable),
    .coexWlanTxAbort                  (coexWlanTxAbort),
    .coexWlanRxAbort                  (coexWlanRxAbort),
  `endif // RW_WLAN_COEX_EN
    .stopRxSRC_p                      (stopRxSRC_p),
    .signalExtension                  (signalExtension),
    .macControllerTxFSMCs             (macControllerTxFSMCs),
    .macAddr                          (macAddr),
    .bssID                            (bssID),
    .sifs                             (sifs),
    .slotTime                         (slotTime),
    .rxStartDelayMIMO                 (rxStartDelayMIMO),
    .rxStartDelayShort                (rxStartDelayShort),
    .rxStartDelayLong                 (rxStartDelayLong),
    .rxStartDelayOFDM                 (rxStartDelayOFDM),
    .ap                               (ap),
    .dynBWEn                          (dynBWEn),
    .dropToLowerBW                    (dropToLowerBW),
    .numTryBWAcquisition              (numTryBWAcquisition),
    .defaultBWTXOP                    (defaultBWTXOP),
    .defaultBWTXOPV                   (defaultBWTXOPV),
    .aPPDUMaxTime                     (aPPDUMaxTime),
    .txBWAfterDrop                    (txBWAfterDrop),
    .keepTXOPOpen                     (keepTXOPOpen),
    .remTXOPInDurField                (remTXOPInDurField),
    .sendCFEnd                        (sendCFEnd),
    .sendCFEndNow                     (sendCFEndNow),
    .sendCFEndNowInValid              (sendCFEndNowInValid),
    .sendCFEndNowIn                   (sendCFEndNowIn),
    .debugPortAMPDUMC                 (debugPortAMPDUMC),
    .debugPortMACControllerTx         (debugPortMACControllerTx)
    );

`ifdef RW_WLAN_COEX_EN
// If coex is enabled and the tx abort is requested, the channel is considered as busy to avoid transmission of immediate response.
assign channelBusyInt = (coexEnable && coexWlanTxAbort) ? 1'b1 : channelBusy;
`else // RW_WLAN_COEX_EN
assign channelBusyInt = channelBusy;
`endif // RW_WLAN_COEX_EN

  
// Instanciation of macControllerRx
// Name of the instance : U_macControllerRx
// Name of the file containing this module : macControllerRx.v
macControllerRx U_macControllerRx (
    .macCoreClk                       (macCoreClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreClkSoftRst_n              (macCoreClkSoftRst_n),
    .macCoreTxClkEnRxC                (macCoreTxClkEnRxC),
    .rxExchangeEnabled                (rxExchangeEnabled),
    .rxExchangeCompleted_p            (rxExchangeCompleted_p),
    .rxRIFSPossible                   (rxRIFSPossible),
    .rxRIFSCancelled_p                (rxRIFSCancelled_p),
    .txRxnRxC                         (txRxnRxC),
    .availableBW                      (availableBW),
    .mcsRESP                          (mcsRESP),
    .legRateRESP                      (legRateRESP),
    .rateUpdateRxC_p                  (rateUpdateRxC_p),
    .reservedRcved                    (reservedRcved),
    .trsRcved_p                       (trsRcved_p),
    .bfrPollRcved_p                   (bfrPollRcved_p),
    .ndpaRcved_p                      (ndpaRcved_p),
    .ackRcved_p                       (ackRcved_p),
    .rtsRcved_p                       (rtsRcved_p),
    .ctsRcved_p                       (ctsRcved_p),
    .cfEndRcved_p                     (cfEndRcved_p),
    .baRcved_p                        (baRcved_p),
    .barRcved_p                       (barRcved_p),
    .needAckRcved_p                   (needAckRcved_p),
    .needHTPAckRcved_p                (needHTPAckRcved_p),
    .bcMcRcved_p                      (bcMcRcved_p),
    .bcnRcved_p                       (bcnRcved_p),
    .probRespRcved_p                  (probRespRcved_p),
    .notMineRtsRcved_p                (notMineRtsRcved_p),
    .notMineMURtsRcved_p              (notMineMURtsRcved_p),
    .notMinePsPollRcved_p             (notMinePsPollRcved_p),
    .notMineRcved_p                   (notMineRcved_p),
    .unknownRcved_p                   (unknownRcved_p),
    .muBARTriggerRcved_p              (muBARTriggerRcved_p),
    .bcMcRcved                        (bcMcRcved),
    .macHeaderCompleted               (macHeaderCompleted),
    .rxAddr1                          (rxAddr1),
    .rxAddr2                          (rxAddr2),
    .rxAckPolicy                      (rxAckPolicy),
    .rxHTCtrl                         (rxHTCtrl),
    .rxFrameDuration                  (rxFrameDuration),
    .incorrectRcved_p                 (incorrectRcved_p),
    .correctRcved_p                   (correctRcved_p),
    .rxBWSignalingTA                  (rxBWSignalingTA),
    .rxLegRateConv                    (rxLegRateConv),
    .rxMCS                            (rxMCS),
    .rxHTLength                       (rxHTLength),
    .rxLegLength                      (rxLegLength),
    .rxDynBWInNonHT                   (rxDynBWInNonHT),
    .rxSTBC                           (rxSTBC),
    .rxChBW                           (rxChBW),
    .rxChBWInNonHT                    (rxChBWInNonHT),
    .rxChOffset                       (rxChOffset),
    .rxLSIGValid                      (rxLSIGValid),
    .rxAntennaSet                     (rxAntennaSet),
    .rxSMMIndex                       (rxSMMIndex),
    .rxPreType                        (rxPreType),
    .rxFormatMod                      (rxFormatMod),
    .rxNumExtnSS                      (rxNumExtnSS),
    .rxFecCoding                      (rxFecCoding),
    .rxNTx                            (rxNTx),
    .rxGIType                         (rxGIType),
    .rxNss                            (rxNss),
    .rxNDP                            (rxNDP),
    .rxDcm                            (rxDcm),
    .rxHeLtfType                      (rxHeLtfType),
    .rxDoppler                        (rxDoppler),
    .rxMidamble                       (rxMidamble),
    .rxBssColor                       (rxBssColor),
    .rxTriggerHWValid_p               (rxTriggerHWValid_p),
    .rxTriggerSWValid_p               (rxTriggerSWValid_p),
    .rxTriggerType                    (rxTriggerType),
    .rxTriggerULLength                (rxTriggerULLength),
    .rxTriggerCS                      (rxTriggerCS),
    .rxTriggerULBW                    (rxTriggerULBW),
    .rxTriggerGIAndLTFType            (rxTriggerGIAndLTFType),
    .rxTriggerHELTFMode               (rxTriggerHELTFMode),
    .rxTriggerNumHELTFAndMidPeriod    (rxTriggerNumHELTFAndMidPeriod),
    .rxTriggerULSTBC                  (rxTriggerULSTBC),
    .rxTriggerLDPCExtraSymbol         (rxTriggerLDPCExtraSymbol),
    .rxTriggerAPTxPower               (rxTriggerAPTxPower),
    .rxTriggerULPacketExtension       (rxTriggerULPacketExtension),
    .rxTriggerULSpatialReuse          (rxTriggerULSpatialReuse),
    .rxTriggerDoppler                 (rxTriggerDoppler),
    .rxTriggerULHESigA2Reserved       (rxTriggerULHESigA2Reserved),
    .rxTriggerRUAllocation            (rxTriggerRUAllocation),
    .rxTriggerULFECCoding             (rxTriggerULFECCoding),
    .rxTriggerULMCS                   (rxTriggerULMCS),
    .rxTriggerULDCM                   (rxTriggerULDCM),
    .rxTriggerStartingSSNum           (rxTriggerStartingSSNum),
    .rxTriggerNumSS                   (rxTriggerNumSS),
    .rxTriggerULTargetRSSSI           (rxTriggerULTargetRSSSI),
    .lSIGTXOPDetected                 (lSIGTXOPDetected),
    .frameExpectingResp               (frameExpectingResp),
    .rxBARxC                          (rxBARxC),
    .ampduCorrectRcved_p              (ampduCorrectRcved_p),
    .ampduIncorrectRcved_p            (ampduIncorrectRcved_p),
    .rxSMPDU                          (rxSMPDU),
    .rxVector1Valid_p                 (rxVector1Valid_p),
    .rxEndOfFrame_p                   (rxEndOfFrame_p),
    .rxAggregation                    (rxAggregation),
    .rxTxopDuration                   (rxTxopDuration),
    .rxRSSILegacy                     (rxRSSILegacy),
    .rxVector1Start_p                 (rxVector1Start_p),
    .startRxRxC_p                     (startRxRxC_p),
    .stopRxRxC_p                      (stopRxRxC_p),
    .txDone_p                         (txDone_p),
    .mpduDone_p                       (mpduDone_p),
    .sendCTSRxC_p                     (sendCTSRxC_p),
    .sendACK_p                        (sendACK_p),
    .sendBA_p                         (sendBA_p),
    .sendCFENDRxC_p                   (sendCFENDRxC_p),
`ifdef RW_BFMEE_EN
    .sendBFR_p                        (sendBFR_p),
`endif //RW_BFMEE_EN
    .sendBQR_p                        (sendBQR_p),
    .sendSWTB_p                       (sendSWTB_p),
    .sendOnSIFSRxC                    (sendOnSIFSRxC),
    .sendOnPIFSRxC                    (sendOnPIFSRxC),
    .destAddrRxC                      (destAddrRxC),
    .srcAddrRxC                       (srcAddrRxC),
    .durationRxC                      (durationRxC),
    .retryRxC                         (retryRxC),
    .txMCSRxC                         (txMCSRxC),
    .txLegLengthRxC                   (txLegLengthRxC),
    .txLegRateRxC                     (txLegRateRxC),
    .txHTLengthRxC                    (txHTLengthRxC),
    .txSTBCRxC                        (txSTBCRxC),
    .txTxopDurationRxC                (txTxopDurationRxC),
    .txResp                           (txResp),
    .txChBWRxC                        (txChBWRxC),
    .txBWSignalingRxC                 (txBWSignalingRxC),
    .txDynBWRxC                       (txDynBWRxC),
    .respTxAntennaSet                 (respTxAntennaSet),
    .respTxSMMIndex                   (respTxSMMIndex),
    .respTxPreType                    (respTxPreType),
    .respTxFormatMod                  (respTxFormatMod),
    .respTxAMPDU                      (respTxAMPDU),
    .respTxSMPDU                      (respTxSMPDU),
    .respMPDUFrameLengthTx            (respMPDUFrameLengthTx),
    .respTxNumExtnSS                  (respTxNumExtnSS),
    .respTxFECCoding                  (respTxFECCoding),
    .respTxNTx                        (respTxNTx),
    .respTxGIType                     (respTxGIType),
    .respTxPwrLevel                   (respTxPwrLevel),
    .respTxHELTFType                  (respTxHELTFType),
    .respTxDoppler                    (respTxDoppler),
    .respTxMidamble                   (respTxMidamble),
    .respTxBSSColor                   (respTxBSSColor),
    .respTxDcm                        (respTxDcm),
    .respTxSpatialReuse1              (respTxSpatialReuse1),
    .respTxSpatialReuse2              (respTxSpatialReuse2),
    .respTxSpatialReuse3              (respTxSpatialReuse3),
    .respTxSpatialReuse4              (respTxSpatialReuse4),
    .respTxHESigAReserved             (respTxHESigAReserved),
    .respTxNumHeLtf                   (respTxNumHeLtf),
    .respTxHELtfMode                  (respTxHELtfMode),
    .respTxLDPCExtraSymbol            (respTxLDPCExtraSymbol),
    .respTxStartingSTSNum             (respTxStartingSTSNum),
    .respTxRUAllocation               (respTxRUAllocation),
    .respTxPacketExtension            (respTxPacketExtension),
    .respTxTriggerMethod              (respTxTriggerMethod),
    .respTxRUToneSetIndex             (respTxRUToneSetIndex),
    .respTxFeedBackStatus             (respTxFeedBackStatus),
    .respTxTriggerResponding          (respTxTriggerResponding),
    .respTxBeamChange                 (respTxBeamChange),
    .acBitmap                         (acBitmap),
    .ulPwrHeadroom                    (ulPwrHeadroom),
    .txUPHControl                     (txUPHControl),
    .timeOnAirMC                      (timeOnAirMC),
    .timeOnAirValidMC                 (timeOnAirValidMC),
    .ppduLengthMCRx                   (ppduLengthMCRx),
    .ppduBWMCRx                       (ppduBWMCRx),
    .ppduPreTypeMCRx                  (ppduPreTypeMCRx),
    .ppduNumExtnSSMCRx                (ppduNumExtnSSMCRx),
    .ppduSTBCMCRx                     (ppduSTBCMCRx),
    .ppduGITypeMCRx                   (ppduGITypeMCRx),
    .ppduMCSIndexMCRx                 (ppduMCSIndexMCRx),
    .ppduHELTFTypeMCRx                (ppduHELTFTypeMCRx),
    .ppduNumHeLtfMCRx                 (ppduNumHeLtfMCRx),
    .ppduDCMMCRx                      (ppduDCMMCRx),
    .ppduTriggerMethodMCRx            (ppduTriggerMethodMCRx),
    .ppduDopplerMCRx                  (ppduDopplerMCRx),
    .ppduMmaMCRx                      (ppduMmaMCRx),
    .ppduRuTypeMCRx                   (ppduRuTypeMCRx),
    .ppduPacketExtensionMCRx          (ppduPacketExtensionMCRx),
    .ppduHeTbLengthMCRx               (ppduHeTbLengthMCRx),
    .woPreambleMCRx                   (woPreambleMCRx),
    .startComputationMCRx_p           (startComputationMCRx_p),
    .channelBusy                      (channelBusyInt),
    .basicNAVBusy                     (basicNAVBusy),
    .ctsDuration                      (ctsDuration),
    .ctsDurationValid_p               (ctsDurationValid_p),
    .ackDuration                      (ackDuration),
    .ackDurationValid_p               (ackDurationValid_p),
    .phyRxStartDelay                  (phyRxStartDelay),
    .navLsigDuration                  (navLsigDuration),
    .tick1us_p                        (tick1us_p),
    .tickPIFS_p                       (tickPIFS_p),
    .frmDurWithoutMH                  (frmDurWithoutMH),
    .rxSWTBResp                       (rxSWTBResp),
    .macPhyIfRxCca                    (macPhyIfRxCca),
    .macPhyIfRxCcaSec20               (macPhyIfRxCcaSec20),
    .macPhyIfRxCcaSec40               (macPhyIfRxCcaSec40),
    .mpIfTxErr_p                      (mpIfTxErr_p),
    .macPhyIfRxEnd_p                  (macPhyIfRxEnd_p),
    .macPhyIfRxErr_p                  (macPhyIfRxErr_p),
    .macPhyIfRxFlush_p                (macPhyIfRxFlush_p),
    .macPHYIFUnderRun                 (macPHYIFUnderRun),
    .macPhyIfRxEndForTiming_p         (macPhyIfRxEndForTiming_p),
`ifdef RW_BFMEE_EN
    .bfrStart                         (bfrStart),
    .bfrLength                        (bfrLength),
    .needBFRRcved_p                   (needBFRRcved_p),
    .needTBBFRRcved_p                 (needTBBFRRcved_p),
    .incorrectBFRPollRcved_p          (incorrectBFRPollRcved_p),
`endif //RW_BFMEE_EN
    .toggleHDSetRxC_p                 (toggleHDSetRxC_p),
    .clearSetsRxC_p                   (clearSetsRxC_p),
    .txParameterHDReady_p             (txParameterHDReady_p),
    .expectedAck                      (expectedAck),
    .aMPDU                            (aMPDU),
    .whichDescriptor                  (whichDescriptor),
    .numMPDURetriesTPC                (numMPDURetriesTPC),
    .aMPDUFrameLengthTx               (aMPDUFrameLengthTx),
    .MPDUFrameLengthTx                (MPDUFrameLengthTx),
    .statusUpdated_p                  (statusUpdated_p),
    .txMpduDoneRxC_p                  (txMpduDoneRxC_p),
    .updateDMAStatusRxC_p             (updateDMAStatusRxC_p),
    .ampduFrmRxC_p                    (ampduFrmRxC_p),
    .mpduSuccessRxC_p                 (mpduSuccessRxC_p),
    .whichDescriptorSWRxC             (whichDescriptorSWRxC),
    .numMPDURetriesRxC                (numMPDURetriesRxC),
    .transmissionBWRxC                (transmissionBWRxC),
    .trigTxTB                         (trigTxTB),
    .signalExtension                  (signalExtension),
    .stopRxSRC_p                      (stopRxSRC_p),
    .tbTxCancelled                    (tbTxCancelled),
    .hwErr                            (hwErr),
    .debugPortMACControllerRx         (debugPortMACControllerRx),
    .debugPortMACControllerRxSWTB     (debugPortMACControllerRxSWTB),
    .macControllerRxFSMCs             (macControllerRxFSMCs),
    .primaryChPosition                (primaryChPosition),
    .heTBUPHControl                   (heTBUPHControl),
    .bssColorCSReg                    (bssColorCSReg),
    .macAddr                          (macAddr),
    .sifs                             (sifs),
    .slotTime                         (slotTime),
    .ap                               (ap),
    .maxSupportedBW                   (maxSupportedBW),
    .maxPHYNtx                        (maxPHYNtx),
    .rxStartDelayMIMO                 (rxStartDelayMIMO),
    .rxStartDelayShort                (rxStartDelayShort),
    .rxStartDelayLong                 (rxStartDelayLong),
    .rxStartDelayOFDM                 (rxStartDelayOFDM),
    .disableACKResp                   (disableACKResp),
    .disableCTSResp                   (disableCTSResp),
    .disableBAResp                    (disableBAResp),
    .disableBQRResp                   (disableBQRResp),
    .disableTBResp                    (disableTBResp),
    .disableTBCS                      (disableTBCS),
    .disableTBRU26Resp                (disableTBRU26Resp),
    .disableTBUPH                     (disableTBUPH),
    .dynBWEn                          (dynBWEn),
    .supportLSTP                      (supportLSTP),
`ifdef RW_BFMEE_EN
    .bfrHELTFType                     (bfrHELTFType),
    .bfrGIType                        (bfrGIType),
    .bfrFormatMod                     (bfrFormatMod),
    .bfrShortGI                       (bfrShortGI),
    .bfrMCS                           (bfrMCS),
`endif //RW_BFMEE_EN
    .ctsSTBCDur                       (ctsSTBCDur),
    .dualCTSProt                      (dualCTSProt),
    .basicSTBCMCS                     (basicSTBCMCS),
    .ofdmMaxPwrLevel                  (ofdmMaxPwrLevel),
    .ofdmMinPwrLevel                  (ofdmMinPwrLevel),
    .defaultPEDur                     (defaultPEDur)
    );





// Instanciation of rateSelection
// Name of the instance : U_rateSelection
// Name of the file containing this module : rateSelection.v
rateSelection U_rateSelection (
    .macCoreClk             (macCoreClk),
    .macCoreClkHardRst_n    (macCoreClkHardRst_n),
    .macCoreClkSoftRst_n    (macCoreClkSoftRst_n),
    .mcsIndex0Tx            (mcsIndex0Tx),
    .formatModProtTx        (formatModProtTx[2:0]),                              //ToDo:11ax
    .formatModTx            (formatModTx[2:0]),                                  //ToDo:11ax
    .bwDataTx               (bwDataTx),
    .stbcTx                 (stbcTx),
    .lowRateRetry           (lowRateRetry),
    .rxMCS                  (rxMCS),
    .rxLegRate              (rxLegRate),
    .rxFormatMod            (rxFormatMod[2:0]),                                  //ToDo:11ax
    .rxSTBC                 ({1'b0,rxSTBC}),
    .bssBasicRateSet        (bssBasicRateSet),
    .bssBasicHTMCSSetEM     (bssBasicHTMCSSetEM),
    .bssBasicHTMCSSetUM     (bssBasicHTMCSSetUM),
    .bssBasicVHTMCSSet      (bssBasicVHTMCSSet),
    .basicSTBCMCS           (basicSTBCMCS),
    .dualCTSProt            (dualCTSProt),
    .ap                     (ap),
    .rateUpdateTxC_p        (rateUpdateTxC_p),
    .mcsIndex0Prot          (mcsIndex0Prot),
    .rateUpdateRxC_p        (rateUpdateRxC_p),
    .txExchangeEnabled      (txExchangeEnabled),
    .rateUpdateDone_p       (rateUpdateDone_p),
    .rxLegRateConv          (rxLegRateConv),
    .mcsData                (mcsData),
    .legRateData            (legRateData),
    .mcsCFEND               (mcsCFEND),
    .legRateCFEND           (legRateCFEND),
    .mcsPROT                (mcsPROT),
    .legRatePROT            (legRatePROT),
    .mcsRESP                (mcsRESP),
    .legRateRESP            (legRateRESP)
    );






////////////////////////////////////////////////////////////////////
////
//// Muxing between MAC Controller Rx and Tx for TX Controller interface
////
////////////////////////////////////////////////////////////////////

assign sendCTS_p    = sendCTSRxC_p   || sendCTSTxC_p;
assign sendCFEND_p  = sendCFENDRxC_p || sendCFENDTxC_p;
assign mpifKeepRFon = mpifKeepRFonRx;

reg [7:0] rxRIFSCnt;

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    mpifKeepRFonRx <= 1'b0;
  else if(macCoreClkSoftRst_n == 1'b0)
    mpifKeepRFonRx <= 1'b0;
  else if (rxRIFSEn)
  begin
    if (macPhyIfRxErr_p || rxRIFSCancelled_p || txExchangeEnabled || (!macPhyIfRifsRxDetected && macPhyIfRifsRxDetectedDly))
      mpifKeepRFonRx <= 1'b0;
    else if (rxRIFSPossible)    
      mpifKeepRFonRx <= 1'b1;
    else if (tick1us_p && rxRIFSCnt == 8'b1 && !macPhyIfRifsRxDetected)
      mpifKeepRFonRx <= 1'b0;
  end    
end

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    rxRIFSCnt <= 8'b0;
  else if(macCoreClkSoftRst_n == 1'b0 || !mpifKeepRFonRx)
    rxRIFSCnt <= 8'b0;
  else if (macPhyIfRxEndForTiming_p)
    rxRIFSCnt <= 8'd7;
  else if (tick1us_p && rxRIFSCnt != 8'b0)
    rxRIFSCnt <= rxRIFSCnt - 8'b1;
end

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macPhyIfRifsRxDetectedDly <= 1'b0;
  else 
    macPhyIfRifsRxDetectedDly <= macPhyIfRifsRxDetected;
end


// assign startRx_p    = startRxMaster_p || startRxRxC_p || startRxTxC_p;

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    startRx <= 1'b0;
  else if(macCoreClkSoftRst_n == 1'b0)
    startRx <= 1'b0;
  else if (startRxMaster_p || startRxRxC_p || startRxTxC_p)
    startRx <= 1'b1;
  else if (stopRx_p)  
    startRx <= 1'b0;
end

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    stopRx_p <= 1'b0;
  else if (stopRxMaster_p  || stopRxRxC_p  || stopRxTxC_p)
    stopRx_p <= 1'b1;
  else  
    stopRx_p <= 1'b0;
end

 
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    txRxn <= 1'b0;
  else  
    txRxn <= txRxnTxC || txRxnRxC;
end
 
// If the txEnchange is enabled, the sendOnSIFS information coming from the MAC Controller TX FSM is taken into account,
// else this is the sendOnSIFS coming from the MAC Controller RX FSM
assign sendOnSIFS        = (txExchangeEnabled) ? sendOnSIFSTxC        : sendOnSIFSRxC;
assign sendOnPIFS        = (txExchangeEnabled) ? sendOnPIFSTxC        : sendOnPIFSRxC;
                                                                      
assign txMCS             = (txExchangeEnabled) ? txMCSTxC             : txMCSRxC;       
assign txLegLength       = (txExchangeEnabled) ? txLegLengthTxC       : txLegLengthRxC;
assign txLegRate         = (txExchangeEnabled) ? txLegRateTxC         : txLegRateRxC;  
                                                                      
assign txHTLength        = (txExchangeEnabled) ? txHTLengthTxC        : txHTLengthRxC;
                                                                      
assign txSTBC            = (txExchangeEnabled) ? txSTBCTxC            : txSTBCRxC; 

assign txTxopDuration    = (txExchangeEnabled) ? txTxopDurationTxC    : txTxopDurationRxC;

assign txDisambiguityBit = (txExchangeEnabled) ? txDisambiguityBitTxC : 1'b0;

assign txChBW            = (txExchangeEnabled) ? txChBWTxC            : txChBWRxC;
                         
assign txBWSignaling     = (txExchangeEnabled) ? txBWSignalingTxC     : txBWSignalingRxC;
                         
assign txDynBW           = (txExchangeEnabled) ? txDynBWTxC           : txDynBWRxC;
                         
assign retry             = (txExchangeEnabled) ? retryTxC             : retryRxC;
assign duration          = (txExchangeEnabled) ? durationTxC          : durationRxC;
assign destAddr          = (txExchangeEnabled) ? destAddrTxC          : destAddrRxC;
assign srcAddr           = (txExchangeEnabled) ? srcAddrTxC           : srcAddrRxC;

// Indicate to the backoff and AC Selection Unit that the TX Exchange is on-going. 
// When set, the backoff are not counted down even if the CCA is idle
assign txInProgress = txExchangeEnabled; //$todo, in case of AP receiving non-STBC RTS with DualCTSProt enabled, the backoff shall be stop betwen the two CTS
                                         //because the second CTS will be received after PIFS and not SIFS

assign toggleHDSet_p = (txExchangeEnabled) ? toggleHDSetTxC_p : toggleHDSetRxC_p;

// assign clearSets_p = (txExchangeEnabled) ? clearSetsTxC_p : rxExchangeEnabled;
//assign clearSets_p = clearSetsTxC_p | (macPhyIfRxCca && !macPhyIfRxCcaInt && !txExchangeEnabled);
assign clearSets_p = (clearSetsTxC_p                      ) |
                     (clearSetsRxC_p && !txExchangeEnabled) |
                     (macPhyIfRxCca  && !txExchangeEnabled) |
                     moveToIdle_p;

assign txMpduDone_p      = (txExchangeEnabled) ? txMpduDoneTxC_p      : txMpduDoneRxC_p;
assign updateDMAStatus_p = (txExchangeEnabled) ? updateDMAStatusTxC_p : updateDMAStatusRxC_p;
assign ampduFrm_p        = (txExchangeEnabled) ? ampduFrmTxC_p        : ampduFrmRxC_p;
assign mpduSuccess_p     = (txExchangeEnabled) ? mpduSuccessTxC_p     : mpduSuccessRxC_p;
assign whichDescriptorSW = (txExchangeEnabled) ? whichDescriptorSWTxC : whichDescriptorSWRxC;
assign numMPDURetries    = (txExchangeEnabled) ? numMPDURetriesTxC    : numMPDURetriesRxC;
assign numRTSRetries     = (txExchangeEnabled) ? numRTSRetriesTxC     : 8'h0;
assign transmissionBW    = (txExchangeEnabled) ? transmissionBWTxC    : transmissionBWRxC;

// Generation of macPhyIfRxCcaInt which is macPhyIfRxCca delayed of one clock cycle
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macPhyIfRxCcaInt <= 1'b0;
  else
    macPhyIfRxCcaInt <= macPhyIfRxCca;
end

//


always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    availableBWInt <= 2'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    availableBWInt <= 2'b0;
  else
    if ((!macPhyIfRxCcaInt && macPhyIfRxCca) || backOffDone_p || (txExchangeEnabled && rxEndOfFrame_p))
      casex ({sec80ChannelIdleFlag,sec40ChannelIdleFlag,sec20ChannelIdleFlag})
        3'b111 : availableBWInt <= 2'd3;
        3'b011 : availableBWInt <= 2'd2;
        3'bx01 : availableBWInt <= 2'd1;
       default : availableBWInt <= 2'd0;
      endcase    
end

assign availableBW = (availableBWInt > maxSupportedBW) ? maxSupportedBW : availableBWInt;


////////////////////////////////////////////////////////////////////
////
//// Muxing between MAC Controller Rx and Tx for TX Controller interface
////
////////////////////////////////////////////////////////////////////
assign rxBA  = txExchangeEnabled ? rxBATxC  : rxBARxC;


////////////////////////////////////////////////////////////////////
////
//// Rx fields assignment
////
////////////////////////////////////////////////////////////////////
assign rxChOffset   = 2'b00;   //For to 0 as the modem knows which channel is the primary
assign rxSMMIndex   = 8'h00;   //$todo Don't know how to select that
assign rxNTx        = 3'b001;  //$todo Don't know how to select that always equal to 1.

////////////////////////////////////////////////////////////////////
////
//// Muxing between MAC Controller Rx and Tx for TX Time Calculator control signals
////
////////////////////////////////////////////////////////////////////

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
  begin
    ppduLengthMC          <= 20'd0;
    ppduMCSIndexMC        <= 7'd0;
    ppduPreTypeMC         <= 4'd0;
    ppduBWMC              <= 2'd0;
    ppduNumExtnSSMC       <= 2'd0;
    ppduSTBCMC            <= 1'd0;
    ppduGITypeMC          <= 2'd0;
    woPreambleMC          <= 1'd0;
    woSignExtMC           <= 1'd0;
    ppduHELTFTypeMC       <= 2'b0;
    ppduNumHeLtfMC        <= 3'b0;
    ppduDCMMC             <= 1'b0;
    ppduTriggerMethodMC   <= 1'b0;
    ppduDopplerMC         <= 1'b0;
    ppduMmaMC             <= 1'b0;
    ppduRuTypeMC          <= 3'b0;
    ppduPacketExtensionMC <= 3'b0;
    ppduHeTbLengthMC      <= 5'b0;
    startComputationMC_p  <= 1'd0;
  end
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
  begin
    ppduLengthMC          <= 20'd0;
    ppduMCSIndexMC        <= 7'd0;
    ppduPreTypeMC         <= 4'd0;
    ppduBWMC              <= 2'd0;
    ppduNumExtnSSMC       <= 2'd0;
    ppduSTBCMC            <= 1'd0;
    ppduGITypeMC          <= 2'd0;
    woPreambleMC          <= 1'd0;
    woSignExtMC           <= 1'd0;
    ppduHELTFTypeMC       <= 2'b0;
    ppduNumHeLtfMC        <= 3'b0;
    ppduDCMMC             <= 1'b0;
    ppduTriggerMethodMC   <= 1'b0;
    ppduDopplerMC         <= 1'b0;
    ppduMmaMC             <= 1'b0;
    ppduRuTypeMC          <= 3'b0;
    ppduPacketExtensionMC <= 3'b0;
    ppduHeTbLengthMC      <= 5'b0;
    startComputationMC_p  <= 1'd0;
  end
  else
    if (startComputationMCTx_p || startComputationMCRx_p)
    begin
      ppduLengthMC          <= (txExchangeEnabled) ? ppduLengthMCTx          : ppduLengthMCRx;
      ppduMCSIndexMC        <= (txExchangeEnabled) ? ppduMCSIndexMCTx        : ppduMCSIndexMCRx[6:0];  // TODO macController ppduMCSIndexMC when rXdesc Ac is ready
      ppduPreTypeMC         <= (txExchangeEnabled) ? ppduPreTypeMCTx         : ppduPreTypeMCRx;
      ppduBWMC              <= (txExchangeEnabled) ? ppduBWMCTx              : ppduBWMCRx;    
      ppduNumExtnSSMC       <= (txExchangeEnabled) ? ppduNumExtnSSMCTx       : ppduNumExtnSSMCRx;   
      ppduSTBCMC            <= (txExchangeEnabled) ? ppduSTBCMCTx            : ppduSTBCMCRx;        
      ppduGITypeMC          <= (txExchangeEnabled) ? ppduGITypeMCTx          : ppduGITypeMCRx;
      woPreambleMC          <= (txExchangeEnabled) ? 1'b0                    : woPreambleMCRx;
      woSignExtMC           <= (txExchangeEnabled) ? woSignExtMCTx           : 1'b0;
      ppduHELTFTypeMC       <= (txExchangeEnabled) ? ppduHELTFTypeMCTx       : ppduHELTFTypeMCRx;
      ppduNumHeLtfMC        <= (txExchangeEnabled) ? 3'b0                    : ppduNumHeLtfMCRx;
      ppduDCMMC             <= (txExchangeEnabled) ? ppduDCMMCTx             : ppduDCMMCRx;
      ppduTriggerMethodMC   <= (txExchangeEnabled) ? 1'b0                    : ppduTriggerMethodMCRx;
      ppduDopplerMC         <= (txExchangeEnabled) ? ppduDopplerMCTx         : ppduDopplerMCRx;
      ppduMmaMC             <= (txExchangeEnabled) ? ppduMmaMCTx             : ppduMmaMCRx;
      ppduRuTypeMC          <= (txExchangeEnabled) ? ppduRuTypeMCTx          : ppduRuTypeMCRx;
      ppduPacketExtensionMC <= (txExchangeEnabled) ? ppduPacketExtensionMCTx : ppduPacketExtensionMCRx;
      ppduHeTbLengthMC      <= (txExchangeEnabled) ? 5'b0                    : ppduHeTbLengthMCRx;
      startComputationMC_p  <= 1'b1;
    end
    else
      startComputationMC_p  <= 1'b0;
end



////////////////////////////////////////////////////////////////////
////
//// Muxing for HW Error
////
////////////////////////////////////////////////////////////////////
assign macControlCs = (txExchangeEnabled) ? {macControllerMasterFSMCs,macControllerTxFSMCs} : {macControllerMasterFSMCs,1'b0,macControllerRxFSMCs};

// Latch the current states of the MAC Controller FSMs in case of HW Error.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macControlLs <= 8'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    macControlLs <= 8'b0;
  else
    if (hwErr)
      macControlLs <= macControlCs;
end

//
//  | macControlCs[6:4] | macControllerMasterFSM |    
//  |     0x0           |                 IDLE   |
//  |     0x2           |        WAIT_TXRX_TRIG  |
//  |     0x3           |             ACTIVE_RX  |
//  |     0x4           |             ACTIVE_TX  |
//
//  When macControlCs[7:5] = 0x3
//  | macControlCs[3:0] | macControllerRxFSM | 
//  |     0x0           |          IDLE      |
//  |     0x1           |      RX_FRAME      |
//  |     0x2           |   RX_DECISION      |
//  |     0x3           | COMP_DURATION      |
//  |     0x4           |   RX_WAIT_END      |
//  |     0x5           |       TX_RESP      |
//  |     0x6           |  TX_STBC_RESP      |
//
//  When macControlCs[7:5] = 0x4
//  | macControlCs[4:0] | macControllerTxFSM        |
//  |     0x0           |                   IDLE    |
//  |     0x1           |               WAIT_DMA    |
//  |     0x2           |   DROPBW_LENGTH_UPDATE    |
//  |     0x3           |          COMP_DURATION    |
//  |     0x4           |             CHECK_TXOP    |
//  |     0x5           |                TX_PROT    |
//  |     0x6           |           RX_PROT_RESP    |
//  |     0x7           |  WAIT_RX_PROT_RESP_END    |
//  |     0x8           |                TX_DATA    |
//  |     0x9           |                RX_RESP    |
//  |     0xA           |       WAIT_RX_RESP_END    |
//  |     0xB           |          STATUS_UPDATE    |
//  |     0xC           |            CHECK_CFEND    |
//  |     0xD           |               TX_CFEND    |
//  |     0xE           |           TRIG_BACKOFF    |
//  |     0xF           |              SKIP_MPDU    |
//  |     0x10          |              PHY_ERROR    |

                                                       
                                                       
assign debugPortBWManagement = {txChBW,           // 2 
                                rxChBW,           // 2 
                                availableBW,      // 2
                                bwTx,             // 2
                                bwProtTx,         // 2
                                txBWSignaling,    // 1
                                txDynBW,          // 1
                                rxDynBWInNonHT,   // 1
                                rxChBWInNonHT,    // 2
                                rxBWSignalingTA}; // 1

`ifdef RW_MAC_MIBCNTL_EN

////////////////////////////////////////////////////////////////////
////
//// MIB Controller interface
////
////////////////////////////////////////////////////////////////////
//Latching TX Frame Type
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n)
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    txFrameType <= 2'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    txFrameType <= 2'b0;
  else if (typeTxValid == 1'b1)
    txFrameType <= typeTx;
end

`ifdef RW_BFMEE_EN
//Latching sendBFR_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n)
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    sendBFR <= 1'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    sendBFR <= 1'b0;
  else if (startTx_p == 1'b1)
    sendBFR <= 1'b0;
  else if (sendBFR_p == 1'b1)
    sendBFR <= 1'b1;
end
`endif//RW_BFMEE_EN

// 1 cycle delayed startTx_p pulse, used to capture beamformed flag from txController
// which is provided 1 cycle after startTx_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n)
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    startTxDly_p <= 1'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    startTxDly_p <= 1'b0;
  else 
    startTxDly_p <= startTx_p;
end


// Basic MIB set
assign mibdot11WEPExcludedCount = !rxFrmDiscard && incorrectRcved_p;
assign mibdot11FCSErrorCount = !rxFrmDiscard && incorrectRcved_p;
assign mibrwRxPHYErrorCount = macPhyIfRxErrInt_p;
assign mibrwRxFIFOOverflowCount = rxFrmDiscard && incorrectRcved_p;
assign mibrwTxUnderrunCount = 1'b0;

// EDCA MIB set 
assign mibrwQosUTransmittedMPDUCount = !txBcMc && !swRTS_p && mpduSuccessTxC_p && ((txFrameType == 2'b00) || (txFrameType == 2'b10));
assign mibrwQosGTransmittedMPDUCount =  txBcMc && !swRTS_p && mpduSuccessTxC_p && ((txFrameType == 2'b00) || (txFrameType == 2'b10));
assign mibdot11QosFailedCount = retryLimitReached_p;
assign mibdot11QosRetryCount = !txBcMc && !swRTS_p && mpduSuccessTxC_p && ((txFrameType == 2'b00) || (txFrameType == 2'b10)) && (numMPDURetries != 8'd0);
assign mibdot11QosRTSSuccessCount = rtsSuccess_p;
assign mibdot11QosRTSFailureCount = rtsFailed_p;
assign mibrwQosACKFailureCount = (!txAMSDUPresent && (retryLimitReached_p || retryFrame_p) && !rtsFailed_p);
assign mibrwQosUReceivedMPDUCount = !txExchangeEnabled && !notMineRcved && !bcMcRcved && correctRcved_p;
assign mibrwQosGReceivedMPDUCount = !txExchangeEnabled && bcMcRcved && correctRcved_p;
assign mibrwQosUReceivedOtherMPDU = !txExchangeEnabled && notMineRcved && correctRcved_p;
assign mibdot11QosRetriesReceivedCount = !txExchangeEnabled && rxRetry && correctRcved_p;
// A-MSDU MIB set txAMSDUPresent,
assign mibrwUTransmittedAMSDUCount = txAMSDUPresent && mibrwQosUTransmittedMPDUCount;
assign mibrwGTransmittedAMSDUCount = txAMSDUPresent && mibrwQosGTransmittedMPDUCount;
assign mibdot11FailedAMSDUCount = txAMSDUPresent && mibdot11QosFailedCount;
assign mibdot11RetryAMSDUCount = txAMSDUPresent && mibdot11QosRetryCount;
assign mibdot11TransmittedOctetsInAMSDU = (txAMSDUPresent) ? MPDUFrameLengthTx : 16'b0;
assign mibdot11AMSDUAckFailureCount = txAMSDUPresent && ((retryLimitReached_p || retryFrame_p) && !rtsFailed_p);
assign mibrwUReceivedAMSDUCount = rxAMSDUPresent && mibrwQosUReceivedMPDUCount;
assign mibrwGReceivedAMSDUCount = rxAMSDUPresent && mibrwQosGReceivedMPDUCount;
assign mibrwUReceivedOtherAMSDU = rxAMSDUPresent && mibrwQosUReceivedOtherMPDU;
assign mibdot11ReceivedOctetsInAMSDUCount = (rxAMSDUPresent && correctRcved_p) ? rxMpduLength : 16'b0;
// A-MPDU MIB set
assign mibdot11TransmittedAMPDUCount = aMPDU && startTx_p;
assign mibdot11TransmittedMPDUInAMPDUCount = aMPDU && mpduDone_p;
assign mibdot11TransmittedOctetsInAMPDUCount = (aMPDU && mpduDone_p) ? MPDUFrameLengthTx : 16'b0;
assign mibrwUAMPDUReceivedCount = !notMineRcvedCapt && !bcMcRcvedCapt && ampduCorrectRcved_p;
assign mibrwGAMPDUReceivedCount = bcMcRcvedCapt && ampduCorrectRcved_p;
assign mibrwOtherAMPDUReceivedCount = notMineRcvedCapt && ampduCorrectRcved_p;
assign mibdot11MPDUInReceivedAMPDUCount = rxAggregation && correctRcved_p;
assign mibdot11ReceivedOctetsInAMPDUCount =  (rxAggregation && correctRcved_p) ? rxMpduLength : 16'b0;
assign mibdot11AMPDUDelimiterCRCErrorCount = (ampduCorrectRcved_p || ampduIncorrectRcved_p) ? incorrectDelCnt : 8'b0;
assign mibdot11ImplicitBARFailureCount = aMPDU && mpduFailed_p;
assign mibdot11ExplicitBARFailureCount = (tsValid && (fcType == 2'b01) && (fcSubtype == 4'b1000)) && retryFrame_p && statusUpdated_p;

// Trigger Based MIB set
assign triggerResponse = rxExchangeEnabled && (respTxFormatMod == 4'd8);

assign mibrwTransmittedAMPDUInTBCount         = aMPDU && startTx_p && (rxTriggerType == 4'b0) && triggerResponse;      
assign mibrwTransmittedMPDUInAMPDUInTBCount   = aMPDU && mpduDone_p && (rxTriggerType == 4'b0) && triggerResponse; 
assign mibrwTransmittedOctetsInAMPDUInTBCount = (aMPDU && mpduDone_p && (rxTriggerType == 4'b0) && triggerResponse) ? MPDUFrameLengthTx : 16'b0;

// Trigger frame type
// 0 Basic
// 1 Beamforming Report Poll (BFRP)
// 2 MU-BAR
// 3 MU-RTS
// 4 Buffer Status Report Poll (BSRP)
// 5 GCR MU-BAR
// 6 Bandwidth Query Report Poll (BQRP)
// 7 NDP Feedback Report Poll (NFRP)
assign mibrwHETBBasicCount    = (rxTriggerType == 4'd0) && triggerResponse && startTx_p;
assign mibrwHETBBFRCount      = (rxTriggerType == 4'd1) && triggerResponse && startTx_p;
assign mibrwHETBMUBACount     = (rxTriggerType == 4'd2) && triggerResponse && startTx_p;    
assign mibrwHETBMUCTSCount    = (rxTriggerType == 4'd3) && triggerResponse && startTx_p;   
assign mibrwHETBBSRCount      = (rxTriggerType == 4'd4) && triggerResponse && startTx_p;     
assign mibrwHETBGCRMUBACount  = (rxTriggerType == 4'd5) && triggerResponse && startTx_p;  
assign mibrwHETBBQRCount      = (rxTriggerType == 4'd6) && triggerResponse && startTx_p;     
assign mibrwHETBNFRCount      = (rxTriggerType == 4'd7) && triggerResponse && startTx_p;    



// 20/40/80/160 MHz MIB set
assign mibdot1120MHzFrameTransmittedCount  = (txChBW == 2'd0) ? startTx_p : 1'b0;
assign mibdot1140MHzFrameTransmittedCount  = (txChBW == 2'd1) ? startTx_p : 1'b0;
assign mibdot1180MHzFrameTransmittedCount  = (txChBW == 2'd2) ? startTx_p : 1'b0;
assign mibdot11160MHzFrameTransmittedCount = (txChBW == 2'd3) ? startTx_p : 1'b0;
assign mibdot1120MHzFrameReceivedCount     = (rxChBW == 2'd0) ? frameCorrectlyRcved_p : 1'b0;
assign mibdot1140MHzFrameReceivedCount     = (rxChBW == 2'd1) ? frameCorrectlyRcved_p : 1'b0;
assign mibdot1180MHzFrameReceivedCount     = (rxChBW == 2'd2) ? frameCorrectlyRcved_p : 1'b0;
assign mibdot11160MHzFrameReceivedCount    = (rxChBW == 2'd3) ? frameCorrectlyRcved_p : 1'b0;

assign frameCorrectlyRcved_p = (!rxAggregation && correctRcved_p) || (rxAggregation && ampduCorrectRcved_p);

// STBC MIB set
assign mibdot11DualCTSSuccessCount = 1'b0;//$todo
assign mibdot11STBCCTSSuccessCount = 1'b0;//$todo
assign mibdot11STBCCTSFailureCount = 1'b0;//$todo
assign mibdot11nonSTBCCTSSuccessCount = 1'b0;//$todo
assign mibdot11nonSTBCCTSFailureCount = 1'b0;//$todo


// Beamforming set
assign mibdot11BeamformingFrameCount      = beamFormed && startTxDly_p;
assign mibrwBeamformingReceivedFrameCount = frameCorrectlyRcved_p && rxBeamformed; 
`ifdef RW_BFMEE_EN
assign mibrwSUBFRTransmittedCount         = sendBFR && (bfrFeedbackType==2'd0) && startTx_p;
assign mibrwMUBFRTransmittedCount         = sendBFR && (bfrFeedbackType==2'd1) && startTx_p;
`else//RW_BFMEE_EN
assign mibrwSUBFRTransmittedCount         = 1'b0;
assign mibrwMUBFRTransmittedCount         = 1'b0;
`endif//RW_BFMEE_EN
`ifdef RW_BFMER_EN
assign mibrwBFRReceivedCount              = bfrRcved_p;
`endif // RW_BFMER_EN

assign mibrwMUReceivedFrameCount          = ((rxGroupID != 6'd0) && (rxGroupID != 6'd63)) && !notMineRcved && ampduCorrectRcved_p;


// MIB Control
assign mibTIDIndex = (txExchangeEnabled) ? txTID[2:0] : rxTID[2:0];
assign mibTrigger = correctRcved_p || startTx_p || incorrectRcved_p || ampduCorrectRcved_p || statusUpdated_p || (aMPDU && mpduDone_p) || (!macPhyIfRxErr_p && macPhyIfRxErrInt_p);

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n)
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
  begin
    notMineRcvedCapt <= 1'b0;
    bcMcRcvedCapt    <= 1'b0;
  end
  else if (correctRcved_p)
  begin
    notMineRcvedCapt <= notMineRcved;
    bcMcRcvedCapt    <= bcMcRcved;
  end
end

`endif // RW_MAC_MIBCNTL_EN


// Generation of macPhyIfRxErrInt_p which is macPhyIfRxErr_p delayed of one clock cycle
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macPhyIfRxErrInt_p <= 1'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    macPhyIfRxErrInt_p <= 1'b0;
  else
    macPhyIfRxErrInt_p <= macPhyIfRxErr_p;
end


assign debugPortMACController1 = {txParameterHDReady_p,    
                                  txParameterPTReady_p,    
                                  txParameterNextPTReady_p,
                                  toggleHDSet_p,           
                                  togglePTSet_p,           
                                  clearSets_p,             
                                  statusUpdated_p,         
                                  swRTS_p,                 
                                  txMpduDone_p,            
                                  ampduFrm_p,              
                                  retryFrame_p,            
                                  rtsSuccess_p || mpduSuccessTxC_p,
                                  rtsFailed_p || mpduFailed_p,
                                  retryLimitReached_p,
                                  txExchangeEnabled,
                                  txSuccessful_p || retry_p || retryLTReached_p // Backoff trigger
                                 }; 
                    

endmodule
                 
