//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : 
//                    
// Simulation Notes : 
//    For simulation, two defines are available
//
//    RW_SIMU_ON   : which creates string signals to display the FSM states on  
//                the waveform viewers
//
//    RW_ASSERT_ON : which enables System Verilog Assertions.
//
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :
//   DualCTS protection and CF-END as an AP not fully supported                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none


module macControllerRx (
          //$port_g Clock and Reset interface
          input  wire        macCoreClk,              // MAC Core Clock
          input  wire        macCoreClkHardRst_n,     // Hard Reset of the MAC Core Clock domain 
                                                      // active low
          input  wire        macCoreClkSoftRst_n,     // Soft Reset of the MAC Core Clock domain 
          output wire        macCoreTxClkEnRxC,       // Enable TX Clocks
                                                      
          //$port_g MAC Controller Master interface  
          input  wire        rxExchangeEnabled,       // Enables the RX frame exchange
          output wire        rxExchangeCompleted_p,   // When the completion of a RX frame exchange
          output reg         rxRIFSPossible,          // Enable the RX path of the RF
          output reg         rxRIFSCancelled_p,       // Cancels the potential reception of frame after RIFS 
          output wire        txRxnRxC,                // Indicates the mode between TX and Rx
                                                      //   0 : RX
                                                      //   1 : TX
          input  wire  [1:0] availableBW,             // Bandwidth available before the current reception.
          input  wire  [2:0] signalExtension,         // Duration of signalExtension

          //$port_g MAC Controller Rate Selection interface
          input  wire  [6:0] mcsRESP,                 // MCS Index for response frame
          input  wire  [3:0] legRateRESP,             // Legacy Rate Index for response frame
          output wire        rateUpdateRxC_p,         // Request from the macControllerRx to update the response frame rate
                                                      
          //$port_g Rx Controller interface           
          input  wire        reservedRcved,           // RSVD received
          input  wire        trsRcved_p,              // Frame with TRS Control field received
                                                      // pulse
          input  wire        bfrPollRcved_p,          // BFR-Poll received pulse
          input  wire        ndpaRcved_p,             // NDP-A received pulse
          input  wire        ackRcved_p,              // ACK received
          input  wire        rtsRcved_p,              // RTS received
          input  wire        ctsRcved_p,              // CTS received
          input  wire        cfEndRcved_p,            // CF-End received
          input  wire        baRcved_p,               // BA received 
          input  wire        barRcved_p,              // BAR received
          input  wire        needAckRcved_p,          // Data or management received with ACK needed
          input  wire        needHTPAckRcved_p,       // Received frame that need an HTP Ack 
          input  wire        bcMcRcved_p,             // Broadcast/Multicast
          input  wire        bcnRcved_p,              // Beacon received
          input  wire        probRespRcved_p,         // Prob Response received
          input  wire        notMineRtsRcved_p,       // Not mine RTS received
          input  wire        notMineMURtsRcved_p,     // Not mine MU-RTS received
          input  wire        notMinePsPollRcved_p,    // Not mine PS-Poll received
          input  wire        notMineRcved_p,          // Frame received but not mine
          input  wire        unknownRcved_p,          // Unknown frame received
          input  wire        muBARTriggerRcved_p,     // MU-BAR Trigger Received pulse
          input  wire        bcMcRcved,               // Indicates than the received frame has a group address.
          input  wire        macHeaderCompleted,      // End of MAC Header reception
          input  wire [47:0] rxAddr1,                 // Received addr1
          input  wire [47:0] rxAddr2,                 // Received addr2
          input  wire  [1:0] rxAckPolicy,             // Ack policy (Ack, No Ack, BA)
          input  wire [31:0] rxHTCtrl,                // HT control field of the received frame
          input  wire [15:0] rxFrameDuration,         // Frame duration
                                                      
          input  wire        incorrectRcved_p,        // Frame not received correctly
          input  wire        correctRcved_p,          // Frame received correctly
                                                      
          input  wire        rxBWSignalingTA,         // Indicate that the received frame has a Bandwidth Signaling TA
                                                      
          input  wire  [3:0] rxLegRateConv,           // Legacy rate of received frame
          input  wire  [6:0] rxMCS,                   // MCS Index of received frame
          input  wire [19:0] rxHTLength,              // HT length of received frame
          input  wire [11:0] rxLegLength,             // Legacy length of received frame
          input  wire        rxSTBC,                  // STBC field of received frame
                                                      
          input  wire        rxDynBWInNonHT,          // Dynamique Bandwidth
          input  wire  [1:0] rxChBW,                  // Bandwidth  of received frame       
          input  wire  [1:0] rxChBWInNonHT,           // Channel bandwidth in Non-HT extracted from the scrambler initialization sequence
          input  wire  [1:0] rxChOffset,              // Channel Offset of received frame
          input  wire        rxLSIGValid,             // L-SIG Valid of received frame
          input  wire  [7:0] rxAntennaSet,            // Antenna Set of received frame
          input  wire  [7:0] rxSMMIndex,              // Spatial Map Matrix Index of received frame
          input  wire        rxPreType,               // Preamble Type of received frame
                                                      //   1'b0: SHORT
                                                      //   1'b1: LONG
          input  wire  [3:0] rxFormatMod,             // Format and Modulation of received frame
                                                      //   4'b0000: NON-HT
                                                      //   4'b0001: NON-HT-DUP-OFDM
                                                      //   4'b0010: HT-MF
                                                      //   4'b0011: HT-GF
                                                      //   4'b0100: VHT
                                                      //   4'b0101: HE-SU
                                                      //   4'b0110: HE-MU
                                                      //   4'b0111: HE-ER-SU
                                                      //   4'b1000: HE-TB
          input  wire  [1:0] rxNumExtnSS,             // Number of Extension Spatial Streams of received frame
          input  wire        rxFecCoding,             // Low Density Partity Check  of received frame      
          input  wire  [2:0] rxNTx,                   // Number of Transmit Chains for PPDU   of received frame     
          input  wire  [1:0] rxGIType,                // Guard Interval Type of received frame
          input  wire  [2:0] rxNss,                   // Number of Spacial Stream
          input  wire        rxNDP,                   // Indicate that the received frame is a Null Data Packet
          input  wire        rxDcm,                   // Indicates the Dual Carrier Modulation
          input  wire  [1:0] rxHeLtfType,             // Indicates the type of HE-LTF
          input  wire        rxDoppler,               // Indicates whether the doppler effect
                                                      // should be considered for the PPDU or not
          input  wire        rxMidamble,              // Indicates the midamble periodicity
          input  wire  [5:0] rxBssColor,              // Indicate the BSS color of the AP
          input  wire        rxTriggerHWValid_p,      // Trigger HW Valid pulse
          input  wire        rxTriggerSWValid_p,      // Trigger SW Valid pulse
          input  wire  [3:0] rxTriggerType,           // Trigger frame, Type
          input  wire [11:0] rxTriggerULLength,       // Trigger frame, UL Length
          input  wire        rxTriggerCS,             // Trigger frame, CS
          input  wire  [1:0] rxTriggerULBW,           // Trigger frame, UL BW
          input  wire  [1:0] rxTriggerGIAndLTFType,   // Trigger frame, GI And LTF Type
          input  wire        rxTriggerHELTFMode,      // Trigger frame, HE-LTF Mode
          input  wire  [2:0] rxTriggerNumHELTFAndMidPeriod,// Trigger frame, Number of HE-LTF
                                                           // symbols And Midamble Periodicity
          input  wire        rxTriggerULSTBC,         // Trigger frame, UL STBC
          input  wire        rxTriggerLDPCExtraSymbol,// Trigger frame, LDPC Extra Symbol Segment
          input  wire  [5:0] rxTriggerAPTxPower,      // Trigger frame, AP TX Power
          input  wire  [2:0] rxTriggerULPacketExtension,// Trigger frame, UL Packet Extension
          input  wire [15:0] rxTriggerULSpatialReuse, // Trigger frame, UL Spatial Reuse
          input  wire        rxTriggerDoppler,        // Trigger frame, Doppler
          input  wire  [8:0] rxTriggerULHESigA2Reserved, // Trigger frame, UL HE-SIG-A2 Reserved
          input  wire  [7:0] rxTriggerRUAllocation,   // Trigger frame, RU Allocation
          input  wire        rxTriggerULFECCoding,    // Trigger frame, Coding Type
          input  wire  [3:0] rxTriggerULMCS,          // Trigger frame, MCS
          input  wire        rxTriggerULDCM,          // Trigger frame, UL DCM
          input  wire  [2:0] rxTriggerStartingSSNum,  // Trigger frame, Starting Spatial Stream
          input  wire  [2:0] rxTriggerNumSS,          // Trigger frame, Number Of Spatial Streams
          input  wire  [6:0] rxTriggerULTargetRSSSI,  // Trigger frame, UL Target RSSI
          output reg         lSIGTXOPDetected,        // Flag indicating RX packet protected with LSIG TXOP
          output reg         frameExpectingResp,      // Indicates that the received frame expect an
                                                      // immediate response
          output wire        rxBARxC,                 // Indicates that transmitted frame expect
                                                      // an immediate response

          //$port_g Deaggregator interface
          input  wire        ampduCorrectRcved_p,     // A-MPDU received correctly
          input  wire        ampduIncorrectRcved_p,   // A-MPDU not received correctly
          input  wire        rxSMPDU,                 // Detect EOF bit in delimiter in S-MPDU
          input  wire        rxVector1Valid_p,        // Rx vector 1 is available
          input  wire        rxEndOfFrame_p,          // Rx vector 2 is available
          input  wire        rxAggregation,           // Indicates that the receving frame is an AMPDU
          input  wire  [6:0] rxTxopDuration,          // Indicates a duration that is used to
                                                      // update the NAV for this TXOP
          input  wire  [7:0] rxRSSILegacy,            // RSSI during Legacy preamble of received
                                                      // frame
          input  wire        rxVector1Start_p,        // Indicate that the first byte of RX Vector
                                                      // has been received
                                                      
          output wire        startRxRxC_p,            // Start Rx
          output wire        stopRxRxC_p,             // Stop Rx
                                                      
          //$port_g TX Controller interface           
          input  wire        txDone_p,                // Indicates the completion of the transmission
          input  wire        mpduDone_p,              // Indicates that the MPDU has been sent
          output reg         sendCTSRxC_p,            // Indicates that a CTS packet has to be sent
          output reg         sendACK_p,               // Indicates that an ACK packet has to be sent
          output reg         sendBA_p,                // Indicates that an Block ACK packet has to be sent
          output reg         sendCFENDRxC_p,          // Indicates that an CF-END packet has to be sent
`ifdef RW_BFMEE_EN                                    
          output reg         sendBFR_p,               // Indicates that an BFR packet has to be sent
`endif //RW_BFMEE_EN                                  
          output reg         sendBQR_p,               // Indicates that an BQR packet has to be sent
          output reg         sendSWTB_p,              // Indicates that an SW Trigger based frame
                                                      // has to be sent
          output wire        sendOnSIFSRxC,           // If set, data is sent on tickSIFS else on tickSlot
          output wire        sendOnPIFSRxC,           // If set, data is sent on tickPIFS
                                                      
          output reg  [47:0] destAddrRxC,             // Receiver address
          output reg  [47:0] srcAddrRxC,              // Source address
          output reg  [15:0] durationRxC,             // Duration
          output wire        retryRxC,                // Indicates that the trame is a retry.
                                                      
          output reg   [6:0] txMCSRxC,                // MCS (Only used for HT frame)
          output wire [11:0] txLegLengthRxC,          // Legacy Length of the PPDU         
          output reg   [3:0] txLegRateRxC,            // Legacy Rate of the PPDU.         
          output wire [19:0] txHTLengthRxC,           // Length of the HT PPDU         
          output wire        txSTBCRxC,               // Transmit a Frame with Space Time Block Coding
          output reg   [6:0] txTxopDurationRxC,       // Transmit a Frame with TXOP Duration
          output wire        txResp,                  // Transmit a Response Frame
                                                      
          output reg   [1:0] txChBWRxC,               // Response Transmission with Bandwidth        
          output wire        txBWSignalingRxC,        // Response Transmission with BW Signaling
          output wire        txDynBWRxC,              // Transmission with Dynamic BW
          output wire  [7:0] respTxAntennaSet,        // Response Transmission with Antenna Set
          output wire  [7:0] respTxSMMIndex,          // Response Transmission with Spatial Map Matrix Index
          output wire        respTxPreType,           // Response Transmission with Preamble Type
                                                      //   1'b0: SHORT
                                                      //   1'b1: LONG
          output reg   [3:0] respTxFormatMod,         // Response Transmission with Format and Modulation
                                                      //   4'd0: NON-HT
                                                      //   4'd1: NON-HT-DUP-OFDM
                                                      //   4'd2: HT-MF
                                                      //   4'd3: HT-GF
                                                      //   4'd4: VHT
                                                      //   4'd5: HE-SU
                                                      //   4'd6: HE-MU
                                                      //   4'd7: HE-EXT-SU
                                                      //   4'd8: HE-TB
          output wire        respTxAMPDU,             // Response Transmission with A-MPDU
          output wire        respTxSMPDU,             // Response Transmission with S-MPDU
          output wire [14:0] respMPDUFrameLengthTx,   // MPDU Length of the A-MPDU response
          output wire  [1:0] respTxNumExtnSS,         // Response Transmission with Number of Extension Spatial Streams
          output reg         respTxFECCoding,         // Response Transmission with Low Density Partity Check       
          output wire  [2:0] respTxNTx,               // Response Transmission with Number of Transmit Chains for PPDU        
          output reg   [1:0] respTxGIType,            // Response Transmission with Guard Interval Type
          output reg   [7:0] respTxPwrLevel,          // Response Transmission with Transmit power level
          output reg   [1:0] respTxHELTFType,         // Response Transmission with HE LTF Type
          output wire        respTxDoppler,           // Response Transmission with Doppler
          output reg         respTxMidamble,          // Response Transmission with Midamble
          output reg   [5:0] respTxBSSColor,          // Response Transmission with BSS Color
          output reg         respTxDcm,               // Response Transmission with DCM
          output reg   [3:0] respTxSpatialReuse1,     // Response Transmission with Spatial Reuse 1
          output reg   [3:0] respTxSpatialReuse2,     // Response Transmission with Spatial Reuse 2
          output reg   [3:0] respTxSpatialReuse3,     // Response Transmission with Spatial Reuse 3
          output reg   [3:0] respTxSpatialReuse4,     // Response Transmission with Spatial Reuse 4
          output wire  [8:0] respTxHESigAReserved,    // Response Transmission with HE SIG-A Reserved bits
          output reg   [2:0] respTxNumHeLtf,          // Response Transmission with Number of HE LTF
          output reg         respTxHELtfMode,         // Response Transmission with HE LTF Mode
          output reg         respTxLDPCExtraSymbol,   // Response Transmission with LDPC extra symbol
          output reg   [2:0] respTxStartingSTSNum,    // Response Transmission with Starting STS Number
          output reg   [7:0] respTxRUAllocation,      // Response Transmission with RU allocation
          output reg   [2:0] respTxPacketExtension,   // Response Transmission with Packet Extension
          output wire        respTxTriggerMethod,     // Response Transmission with trigger method
          output wire  [6:0] respTxRUToneSetIndex,    // Response Transmission with RU tone set index
          output wire        respTxFeedBackStatus,    // Response Transmission with feedback status
          output wire        respTxTriggerResponding, // Response Transmission with Trigger Responding
          output wire        respTxBeamChange,        // Response Transmission with Beam Change
          output reg   [7:0] acBitmap,                // Available channel bitmap
          output wire  [5:0] ulPwrHeadroom,           // Uplink Power Headroom
          output wire        txUPHControl,            // UPH Control field is present in the
                                                      // transmitted frame

          //$port_g TX Time interface
          input  wire [15:0] timeOnAirMC,             // Time On Air result to MAC Controller
                                                      // This field gives the time taken for frame transmission in microseconds (us)
                                                      // computed from parameters given by the MAC Controller.
          input  wire        timeOnAirValidMC,        // Time On Air Valid to MAC Controller
                                                      // This field is set when the air time computation is completed.
                                                      
          output reg  [19:0] ppduLengthMCRx,          // PPDU Length from MAC Controller
                                                      // This field gives the length of the PPDU for computing time on air.
          output reg   [1:0] ppduBWMCRx,              // PPDU 40 MHz from MAC Controller
                                                      // This field indicates that that the PPDU should be transmitted at 40 MHz.
          output reg   [3:0] ppduPreTypeMCRx,         // PPDU Preamble Type from MAC Controller
	                                                    // This field indicates what type of preamble is transmitted for the frame.
                                                      // The encoding is as follows:
                                                      //   4'b0000: Non-HT-Short
                                                      //   4'b0001: Non-HT-Long
                                                      //   4'b0010: HT-MF
                                                      //   4'b0011: HT-GF
                                                      //   4'b0100: VHT
                                                      //   4'b0101: HE-SU
                                                      //   4'b0110: HE-MU
                                                      //   4'b0111: HE-ER-SU
                                                      //   4'b1000: HE-TB
          output reg   [1:0] ppduNumExtnSSMCRx,       // Number of Extension Spatial Streams      
          output reg         ppduSTBCMCRx,            // Enable Space Time Block Coding          
          output reg   [1:0] ppduGITypeMCRx,          // PPDU Guard Interval Type from MAC Controller
                                                      // Indicates that the frame should be transmitted with Short GI.
          output reg   [7:0] ppduMCSIndexMCRx,        // PPDU LegRate or MCS Index from MAC Controller
                                                      // This field indicates the rate at which this PPDU is transmitted. 
          output reg   [1:0] ppduHELTFTypeMCRx,       // Indicates the type of HE-LTF
          output reg   [2:0] ppduNumHeLtfMCRx,        // Indicates the number of HE-LTF symbols
                                                      // minus 1
          output wire        ppduDCMMCRx,             // Indicates that dual carrier modulation is
                                                      // used for the HE-Data field
          output reg         ppduTriggerMethodMCRx,   // Indicates the method used to trigger this
                                                      // HE TB PPDU transmission
          output reg         ppduDopplerMCRx,         // Indicates whether the doppler effect should
                                                      // be considered for the PPDU or not
          output wire        ppduMmaMCRx,             // Indicates the midamble periodicity
                                                      // 1'b0: 10
                                                      // 1'b1: 20
          output reg   [2:0] ppduRuTypeMCRx,          // Indicates the type of RU
          output reg   [2:0] ppduPacketExtensionMCRx, // Indicates the packet extension parameters.
          output reg   [4:0] ppduHeTbLengthMCRx,      // Indicates the length of the HE TB PPDU
                                                      // response to an URMS trigger and is set to
                                                      // the number of OFDM symbols in the Data 
                                                      // field of the HE TB PPDU minus 1.
          output wire        woPreambleMCRx,          // Indicates that total duration should not include the preamble duration 
          output reg         startComputationMCRx_p,  // Start Time on Air computation from MAC Controller

          //$port_g NAV Module interface
          input  wire        channelBusy,             // Channel busy indicator
          input  wire        basicNAVBusy,            // basic NAV is not null
          output wire [15:0] ctsDuration,             // Indicates the duration of a CTS frame response of the received RTS
          output wire        ctsDurationValid_p,      // Indicates that the ctsDuration is valid
          output wire [15:0] ackDuration,             // Indicates the duration of a ACK frame response of the received PS-POLL
          output wire        ackDurationValid_p,      // Indicates that the ackDuration is valid
          output reg   [7:0] phyRxStartDelay,         // Receive Start Delay of the PHY
          output reg  [15:0] navLsigDuration,         // Indicates the duration computed based on L_LENGTH and L_RATE in HT_MM
                                                      
          //$port_g MAC Timer Unit interface          
          input  wire        tick1us_p,               // Pulse generated every us.
          input  wire        tickPIFS_p,              // A pulse to indicate the end of PIFS period
          output reg  [15:0] frmDurWithoutMH,         // Indicates the duration if the Beacon or Probe Response from the end of the MAC header
          output reg         rxSWTBResp,              // Indicates that a response frame of the 
                                                      // transmitted SW Trigger Based is expected
                                                      // (Flag)
                                                      
          //$port_g MAC PHY interface                 
          input  wire        macPhyIfRxCca,           // CCA trigger                   
          input  wire        macPhyIfRxCcaSec20,      // CCA trigger Secondary 20MHz
          input  wire        macPhyIfRxCcaSec40,      // CCA trigger Secondary 40MHz
          input  wire        mpIfTxErr_p,             // Tx error from MAC-PHY if. resynchronized
          input  wire        macPhyIfRxEnd_p,         // Rx error from MAC-PHY if. resynchronized
          input  wire        macPhyIfRxErr_p,         // Rx error from MAC-PHY if. resynchronized
          input  wire        macPhyIfRxFlush_p,       // Rx flush pulse
          input  wire        macPHYIFUnderRun,        // Underrun from MAC-PHY if.
          input  wire        macPhyIfRxEndForTiming_p,// end of reception at the antenna                        
                                                      
`ifdef RW_BFMEE_EN                                    
          //$port_g BFR Controller interface          
          input  wire        bfrStart,                // BFR computation started
          input  wire [14:0] bfrLength,               // Beamforming Report frame Length
          input  wire        needBFRRcved_p,          // Frame received with BFR response needed pulse
          input  wire        needTBBFRRcved_p,        // Frame received with Trigger Based BFR
                                                      // response needed pulse
          input  wire        incorrectBFRPollRcved_p, // Beamforming Report Poll is not correct
`endif //RW_BFMEE_EN

          //$port_g Tx Parameters Cache Interface 
          output wire        toggleHDSetRxC_p,        // Indicates that the Header Descriptor Set
                                                      // can be toggled
          output wire        clearSetsRxC_p,          // Indicates that the Sets have to be cleared.
          input  wire        txParameterHDReady_p,    // Indicates that the Header Descriptor fields
                                                      // are usable 
          input  wire  [1:0] expectedAck,             // Expected Acknowledgement
                                                      //   2'b00: No acknowledgement.
                                                      //   2'b01: Normal ACK.
                                                      //   2'b10: BA.
                                                      //   2'b11: Compressed BA.
          input  wire        aMPDU,                   // Indicates whether this Transmit Header
                                                      // Descriptor belong to an A-MPDU
          input  wire  [1:0] whichDescriptor,         // Indicates what kind of a descriptor this is
          input  wire  [7:0] numMPDURetriesTPC,       // Indicates the number of MPDU retries
                                                      // already done   
          input  wire [19:0] aMPDUFrameLengthTx,      // Length of the entire A-MPDU
          input  wire [15:0] MPDUFrameLengthTx,       // Length of the MPDU

          //$port_g dmaEngine Interface
          input  wire        statusUpdated_p,         // Indication from the DMA that status have
                                                      // been updated.
          output wire        txMpduDoneRxC_p,         // Asserted high after every transmission of
                                                      // MPDU in an AMPDU frame
          output reg         updateDMAStatusRxC_p,    // trigs the DMA Status update.
          output reg         ampduFrmRxC_p,           // Asserted high if the transmitted packet
                                                      // was an AMPDU
          output reg         mpduSuccessRxC_p,        // If the transmitted frame was successful.
          output reg  [ 3:0] whichDescriptorSWRxC,    // Indicates the value of the
                                                      // whichDescriptorSW field for Status in THD
          output reg  [ 7:0] numMPDURetriesRxC,       // Captured value of the number of retries for
                                                      // this MPDU.
          output reg   [1:0] transmissionBWRxC,       // Indicates the value of the transmissionBW
                                                      // field for Status in THD
          output reg         trigTxTB,                // TB DMA Channel Trigger

          //$port_g SR controller Interface
          input  wire        stopRxSRC_p,             // Stop Reception trigger from SR Controller

          //$port_g Interrupt Controller interface
          output reg         tbTxCancelled,           // Indicates that a SW TB cancel interrupt

          //$port_g HW Error detected
          input  wire        hwErr,                   // HW error detected

          //$port_g Debug Port
          output wire [15:0] debugPortMACControllerRx,// DebugPort of the MAC Controller Rx
          output wire [15:0] debugPortMACControllerRxSWTB, // DebugPort of the MAC controller RX
          
          //$port_g CSReg interface
          output reg   [3:0] macControllerRxFSMCs,    // State of the MAC Controller RX FSM      
          output reg   [7:0] heTBUPHControl,          // HE-TB Uplink power headroom
          input  wire  [2:0] primaryChPosition,       // Primary Channel Position
          input  wire  [5:0] bssColorCSReg,           // BSS Color
          input  wire [47:0] macAddr,                 // MAC Addr
          input  wire  [7:0] sifs,                    // Provide SIFS duration in us
          input  wire  [7:0] slotTime,                // Provide Slot duration in us
          input  wire        ap,                      // Indicates the type of device (0: STA, 1: AP)
          input  wire  [1:0] maxSupportedBW,          // max Supported BW
          input  wire  [2:0] maxPHYNtx,               // Maximum Number of TX chains
          input  wire  [7:0] rxStartDelayMIMO,        // Receive Start Delay for MIMO
          input  wire  [7:0] rxStartDelayShort,       // Receive Start Delay for DSSS/CCK Short preamble
          input  wire  [7:0] rxStartDelayLong,        // Receive Start Delay for DSSS/CCK Long preamble
          input  wire  [7:0] rxStartDelayOFDM,        // Receive Start Delay for OFDM
          input  wire        disableACKResp,          // Disable ACK Response This bit is set by SW to disable 
                                                      // the automatic ACK generation logic in HW.
          input  wire        disableCTSResp,          // Disable CTS Response This bit is set by SW to disable 
                                                      // the automatic CTS generation logic in HW.
          input  wire        disableBAResp,           // Disable BA Response This bit is set by SW to disable 
                                                      // the automatic BA generation logic in HW.
          input  wire        disableBQRResp,          // Disable BQR Response. This bit is set by SW
                                                      // to disable the automatic BA generation
                                                      // logic in HW.
          input  wire        disableTBResp,           // Disable Trigger Based Response.
          input  wire        disableTBCS,             // Disable Carrier Sense on Trigger Based
                                                      // Response
          input  wire        disableTBRU26Resp,       // Disable HE-TB Response on a 26-tones RU
                                                      // (except HE TB feedback NDP)
          input  wire        disableTBUPH,            // Disable UPH Control field in HE TB Response
          input  wire        dynBWEn,                 // Enable dynamic Bandwidth support
          input  wire        supportLSTP,             // Indicates that the HW supports L-SIG TXOP
`ifdef RW_BFMEE_EN                                    
          input  wire  [1:0] bfrHELTFType,            // Beamforming Report HE-LTF-TYPE(HE Only)
          input  wire  [1:0] bfrGIType,               // Beamforming Report giType (HE Only)
          input  wire  [2:0] bfrFormatMod,            // Beamforming Report Format and Modulation
          input  wire        bfrShortGI,              // Beamforming Report Short GI
          input  wire  [7:0] bfrMCS,                  // Beamforming Report MCS
`endif //RW_BFMEE_EN                                  
          input  wire  [7:0] ctsSTBCDur,              // CTS STBC Duration
          input  wire        dualCTSProt,             // Dual-CTS Protection
          input  wire  [6:0] basicSTBCMCS,            // Basic STBC MCS
          input  wire  [7:0] ofdmMaxPwrLevel,         // Maximum Power Level for OFDM frames
          input  wire  [7:0] ofdmMinPwrLevel,         // Minimum Power Level for OFDM frames
          input  wire  [2:0] defaultPEDur             // Default Packet Extension Duration
);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////
localparam
     NON_HT           = 4'd0,
     NON_HT_DUP_OFDM  = 4'd1,
     HT_MM            = 4'd2,
     HT_GF            = 4'd3,
     VHT              = 4'd4,
     HE_SU            = 4'd5,
     HE_MU            = 4'd6,
     HE_EXT_SU        = 4'd7,
     HE_TB            = 4'd8;

// macControllerRxFSM FSM states definition
//$fsm_sd macControllerRxFSM
localparam
                 IDLE  =  4'd0,
             RX_FRAME  =  4'd1,
 COMP_DURATION_RX_LEG  =  4'd2,
  COMP_DURATION_RX_MM  =  4'd3,
   COMP_DURATION_RESP  =  4'd4,
    COMP_DURATION_TFS  =  4'd5,
          RX_WAIT_END  =  4'd6,
              TX_RESP  =  4'd7,
         CHECK_MEDIUM  =  4'd8,
         TX_STBC_RESP  =  4'd9,
TX_RESP_STATUS_UPDATE  =  4'd10;

localparam 
       RESP_TYPE_NONE  =  3'd0,
        RESP_TYPE_ACK  =  3'd1,
        RESP_TYPE_CTS  =  3'd2,
         RESP_TYPE_BA  =  3'd3,
      RESP_TYPE_CFEND  =  3'd4,
`ifdef RW_BFMEE_EN
        RESP_TYPE_BFR  =  3'd5,
`endif //RW_BFMEE_EN
         RESP_TYPE_SW  =  3'd6,
        RESP_TYPE_BQR  =  3'd7;

// Trigger frame type
localparam
     BASIC             = 4'd0, // Basic Trigger
     BFRP              = 4'd1, // Beamforming Report Poll
     MU_BAR            = 4'd2, // MU-BAR
     MU_RTS            = 4'd3, // MU-RTS
     BSRP              = 4'd4, // Buffer Status Report Poll
     GCR_MU_BAR        = 4'd5, // GCR MU-BAR
     BQRP              = 4'd6, // Bandwitdh Query Report Poll
     NFRP              = 4'd7; // NDP Feedback Report Poll

      
//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////

// macControllerRxFSM FSM signals definition
reg [3:0]  macControllerRxFSMNs;  // macControllerRxFSM FSM Next State
reg [3:0]  macControllerRxFSMPs;  // macControllerRxFSM FSM Previous State

`ifdef RW_BFMEE_EN
reg        rxNDPHold;             // Indicate that the received frame is a Null Data Packet
reg        incorrectBFRPollRcved; // Beamforming Report Poll is not correct
`endif //RW_BFMEE_EN
reg        incorrectRcved;        // Frame not received correctly
reg        correctRcved;          // Frame received correctly
reg        durationCompEndFlag;   // duration computation end
wire       durationCompEnd;       // duration computation end
reg [2:0]  expectedResp;
reg        rxEndOfFrame;
reg [19:0] txRespLength;          // Length of the response      
reg [15:0] legLengthComputed;     // Legacy Length computed for HT_MM
reg [15:0] rxFrameLegDuration;
reg [15:0] rxFrameHTDuration;
reg        lsigCheckDone;         // Indicates that the lSIG check has been done
reg        notMinePsPollRcved;    // Indicates that a not mine PS-POLL has been received.
reg        notMineRtsRcved;       // Indicates that a not mine RTS has been received.
reg        notMineMURtsRcved;     // Indicates that a not mine MU-RTS has been received.
reg        tsfRcved;              // Indicates that a frame carrying a TSF (Beacon or Prob Response) has been received.
reg        probRespRcved;         // Prob Response received
reg        bcnRcved;              // Beacon received
reg        trsRcved;              // Frame with TRS control field received
reg        needHTPAckRcved;       // Frame with HTP Ack ack policy 
reg        macPhyIfRxFlush;
reg        macHeaderCompleted_ff1;// End of MAC Header reception
wire       rxFrameIsHT;			  // Indicate that the received frame is HT of VHT


`ifdef RW_SIMU_ON
// String definition to display macControllerRxFSM current state
reg [21*8-1:0] macControllerRxFSMCs_str;
reg [15*8-1:0] expectedResp_str;
reg [15*8-1:0] respTxFormatMod_str;
`endif // RW_SIMU_ON


reg         frameDontExpectingResp;
reg  [15:0] estDuration;         // Estimated duration of the response frame and SIFS.
wire [15:0] lSIGDuration;        // L-SIG Duration
`ifdef RW_BFMEE_EN
wire  [2:0] rxNsts;              // Number of space time stream of the received frame
reg   [7:0] rxNDPDur;            // NDP Duration
`endif // RW_BFMEE_EN
wire [15:0] txTimeInt;           // Equal to TXTIME-(signalExtension - 20)
wire [15:0] lSIGDurationInt;     // Equal to lSIGDuration-signalExtension
wire [15:0] txTimeWoPreamble;    // Equal to TXTIME - preambleTime
wire [15:0] ctsSTBCDurWoPreamble;// Equal to ctsSTBCDur - preambleTime


reg         rxNDPAn;             // NDP Announcement bit from the HT Control Field of the received frame
reg         rxTRQ;               // TRQ bit from the HT Control Field of the received frame
reg         respIsHT;            // Indicates if the response frame should be HT or NON-HT PPDU
reg         respIsTB;            // Indicates if the response frame should be HE-TB
reg         respIsTBCTS;         // Indicates if the response frame is a CTS frame in response of a 
                                 // MU-RTS Trigger frame
reg         dualRespNeeded;      // Indicates if the response needs STBC.
reg   [7:0] respTxMCSIndex;      // Indicates the response frame MCS index.

wire        txErr;               // Indicates that a error occured during transmission

reg         respBWFail;          // Indicates that the requested bandwidth is not available.
                                 // this flag is generated only in case of BW signaling mode with dynBW = static           
wire        timeOnAirDone_p;     // Indicates the end of the time on air computation
reg         timeOnAirValidMC_ff1;// timeOnAirValidMC delayed of one clock cycle

reg   [1:0] txChBWInt;           // Response Transmission with Bandwidth        

reg         rxTriggerMethod;     // Indicates the Trigger Method 
                                 //   0: a Trigger Frame
                                 //   1: a frame with a TRS control field
reg         rxTriggerHWValid;    // Indicates that a valid HW trigger frame has been received
reg         rxTriggerSWValid;    // Indicates that a valid SW trigger frame has been received
reg  [68:0] rxTriggerRUAllocIndex;// RU Allocation of the receive trigger frame
reg   [3:0] rxTriggerRUAllocInBW;// RU Allocation of the receive trigger frame
                                 // in the bandWidth(1 bit per 20Mhz)
                                 // bit0 for the lowest 20MHz
                                 // bit3 for the higest 20Mhz
reg   [3:0] ccaInBW;             // CCA in the bandwidth(1 bit per 20Mhz)
                                 // bit0 for the lowest 20MHz
                                 // bit3 for the higest 20Mhz
reg   [2:0] heTBPrimaryCh;       // Primary Channel Position in the HE-TB Bandwidth

reg   [4:0] rxTRSLength;         // HE TB PPDU Length field of the received TRS control field
reg   [7:0] rxTRSRUAllocation;   // RU Allocation     field of the received TRS control field
reg   [4:0] rxTRSDLTxPower;      // DL TX Power       field of the received TRS control field
reg   [4:0] rxTRSULTargetRSSI;   // UL Target RSSI    field of the received TRS control field
reg   [1:0] rxTRSMCS;            // UL MCS            field of the received TRS control field
wire        rxTRSValid_p;        // Frame with TRS control field received without error (pulse)
reg         rxTRSValid;          // Frame with TRS control field received without error

reg   [8:0] tbTxPwrLevelReq;     // Transmit Power Level Requested for the trigger based response
                                 // frame
reg   [7:0] tbTxPwrLevel;        // Transmit Power Level Used for the trigger based response frame
wire  [7:0] tbTxPwrHeadroom;     // Indicates the power headroom of the trigger based response
reg         tbTxPwrLevelMin;     // Indicates that the minimum Transmit Power Level is Used for
                                 // the trigger based response frame 

reg         captureStatus_p;
reg         captureStatusDly_p;

reg   [1:0] expectedAckCapt;     // ExpectedAck from txParameterCache Saved
reg   [1:0] whichDescriptorCapt; // whichDescriptor from txParameterCache Saved

reg         respRUFail;          // Indicates that the RU allocated to the trigger based frame is 
                                 // not idle.

wire        rxSWTBResp_p;        // Indicates that a response frame of the 
                                 // transmitted SW Trigger Based is expected (Pulse)
reg         rxSWTBRespTO;        // Indicates that a response frame of the 
                                 // transmitted SW Trigger Based is not received
                                 // on time (Flag)
wire        rxSWTBRespTO_p;      // Indicates that a response frame of the 
                                 // transmitted SW Trigger Based is not received
                                 // on time (Pulse)
reg   [9:0] timeOutCnt;          // SW TB Response Timeout down counter
reg         timeOutCntEn;        // SW TB Response Timeout down counter enable
reg         swTBAckRcved;        // Indicates that an Ack or a block ACK is received
reg         swTBStatusReady;     // Indicates that the SW TB response status is available
reg         swTBStatusReady_ff1; // swTBStatusReady delayed of one clock cycle
reg         swTBStatusError;     // Indicates that the SW TB response is not correct.

wire        pri20Idle;           // Indicates that primary   20MHz channel is Idle
wire        sec20Idle;           // Indicates that secondary 20MHz channel is Idle
wire        sec40Idle;           // Indicates that secondary 40MHz channel is Idle

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

assign macCoreTxClkEnRxC = (macControllerRxFSMCs == TX_RESP || 
                            macControllerRxFSMCs == TX_STBC_RESP || 
                            macControllerRxFSMCs == TX_RESP_STATUS_UPDATE || 
                            macControllerRxFSMCs == COMP_DURATION_RESP || 
                            macControllerRxFSMCs == CHECK_MEDIUM) ? 1'b1 : 1'b0; //$todo clock gating

// macControllerRxFSM FSM Current State Logic 
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macControllerRxFSMCs <= IDLE; 
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    macControllerRxFSMCs <= IDLE; 
  else
    macControllerRxFSMCs <= macControllerRxFSMNs; 
end
// macControllerRxFSM FSM Previous State Logic 
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macControllerRxFSMPs <= IDLE; 
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    macControllerRxFSMPs <= IDLE; 
  else
    macControllerRxFSMPs <= macControllerRxFSMCs; 
end


// macControllerRxFSM FSM Next State Logic.
always @* 
begin
  case(macControllerRxFSMCs)

    IDLE:
      //$fsm_s In IDLE state, the state machine waits for a trigger from the macControllerMaster state machine
      if (rxExchangeEnabled && !rxExchangeCompleted_p) 
        //$fsm_t When rxExchangeEnabled is received indicating the beginning of a reception, the state machine goes to RX_FRAME state.
        macControllerRxFSMNs = RX_FRAME; 
      else
        //$fsm_t While rxExchangeEnabled is not received, the state machine stays in IDLE state.
        macControllerRxFSMNs = IDLE;

    RX_FRAME:
      //$fsm_s In RX_FRAME state, the rxController is receiving the first bytes of the frame. The state machine waits for an indication
      // from the RX Controller indicating the type of frame which is being received.
`ifdef RW_BFMEE_EN
      if (macPhyIfRxErr_p || rxSWTBRespTO_p || (rxEndOfFrame && !bfrStart))
`else //RW_BFMEE_EN
      if (macPhyIfRxErr_p || rxSWTBRespTO_p || (rxEndOfFrame             ))
`endif //RW_BFMEE_EN
        //$fsm_t When macPhyIfRxErr_p is received indicating that an phy error has been detected, 
        // the state machine goes to IDLE state.
        macControllerRxFSMNs = IDLE;
      else if (rxVector1Valid_p && ((rxFormatMod == HT_MM) || (rxFormatMod == VHT)))
        //$fsm_t When rxVector1Valid_p is received with rxFormatMod = 2 or 4 indicating that we are receiving a HT_MM or a VHT frame, 
        // the state machine goes to COMP_DURATION_RX_LEG state to compute the rx frame duration.
        macControllerRxFSMNs = COMP_DURATION_RX_LEG;
      else if (bcnRcved || probRespRcved) 
        //$fsm_t When a Beacon or a Prob Response has been received, the state machine goes to COMP_DURATION_TFS state.
        macControllerRxFSMNs = COMP_DURATION_TFS;
      else if ((notMinePsPollRcved || notMineRtsRcved || notMineMURtsRcved || frameExpectingResp) && correctRcved)
        //$fsm_t When frameExpectingResp is received indicating that a frame is being received and expects a 
        //response or a PS-POLL or a RTS, the state machine goes to COMP_DURATION_RESP state.
        macControllerRxFSMNs = COMP_DURATION_RESP;
//       else if (frameDontExpectingResp || (!rxAggregation && correctRcved) || (rxAggregation && ampduCorrectRcved)) 
      else if ((!notMinePsPollRcved && !notMineRtsRcved && !notMineMURtsRcved && frameDontExpectingResp && macHeaderCompleted) || correctRcved) 
        //$fsm_t When frameDontExpectingResp is received indicating that a frame is being received and does 
        //not expect a response, the state machine goes to RX_WAIT_END state.
        macControllerRxFSMNs = RX_WAIT_END;
      else        
        //$fsm_t While nothing is received, the state machine stays in RX_FRAME state.
        macControllerRxFSMNs = RX_FRAME;

    COMP_DURATION_RX_LEG :
      //$fsm_s In COMP_DURATION_RX_LEG state, the state machine waits for the completion of the duration computation of the received frame
      if (macPhyIfRxErr_p)      
        //$fsm_t When macPhyIfRxErr_p is received set meaning that a PHY error has been detected, 
        //the state machine goes to IDLE state.
        macControllerRxFSMNs = IDLE; 
      else if (durationCompEnd)
        //$fsm_t When durationCompEnd is received, the state machine moves to COMP_DURATION_RX_MM.
        macControllerRxFSMNs = COMP_DURATION_RX_MM;
      else        
        //$fsm_t While durationCompEnd is not received, the state machine stays in COMP_DURATION_RX_LEG state.
        macControllerRxFSMNs = COMP_DURATION_RX_LEG;
    
    COMP_DURATION_RX_MM :
      //$fsm_s In COMP_DURATION_RX_MM state, the state machine waits for the completion of the duration computation of the received frame
      if (macPhyIfRxErr_p)      
        //$fsm_t When macPhyIfRxErr_p is received set meaning that a PHY error has been detected, 
        //the state machine goes to IDLE state.
        macControllerRxFSMNs = IDLE; 
      else if (durationCompEnd)
        //$fsm_t When durationCompEnd is received, the state machine moves back to RX_FRAME.
        macControllerRxFSMNs = RX_FRAME;
      else        
        //$fsm_t While durationCompEnd is not received, the state machine stays in COMP_DURATION_RX_MM state.
        macControllerRxFSMNs = COMP_DURATION_RX_MM;
    

    COMP_DURATION_RESP:
      //$fsm_s In COMP_DURATION_RESP state, the state machine waits for the completion of the duration computation
      if (macPhyIfRxErr_p)      
        //$fsm_t When macPhyIfRxErr_p is received set meaning that a PHY error has been detected, 
        //the state machine goes to IDLE state.
        macControllerRxFSMNs = IDLE; 
      else if (durationCompEnd && correctRcved && rxEndOfFrame && (expectedResp != RESP_TYPE_NONE))
      begin
        if (~respIsTBCTS && (channelBusy || respBWFail) && (expectedResp == RESP_TYPE_CTS))
          //$fsm_t When channelBusy is set after reception of rxEndOfFrame_p meaning that the NAV is set,
          // Or if the requested bandwidth is not available (in case of BW signaling),
          // the CTS response is not transmitted.
          macControllerRxFSMNs = IDLE; 
        else if (respIsTBCTS && rxTriggerCS && ~disableTBCS && (respRUFail || basicNAVBusy))
          //$fsm_t When basicNAVBusy is set after reception of rxEndOfFrame_p meaning that the 
          // inter-BBS NAV is set, Or if the requested RU is not available (when CS is required),
          // the TB CTS response is not transmitted.
          macControllerRxFSMNs = IDLE; 
        else if (respIsTB && ~rxTriggerMethod && rxTriggerCS && ~disableTBCS &&
                 (respRUFail || basicNAVBusy))
          //$fsm_t When basicNAVBusy is set after reception of rxEndOfFrame_p meaning that the 
          // inter-BBS NAV is set, Or if the requested RU is not available (when CS is required),
          // the TB response is not transmitted.
          macControllerRxFSMNs = IDLE; 
        else if (respIsTB && respTxRUAllocation[7:1]<=7'd36 && disableTBRU26Resp &&
                 rxTriggerType!=NFRP)
          //$fsm_t When response is in HE-TB frame on a 26-tones RU and 26-tones RU are disallowed
          //(except HE TB feedback NDP),
          //the TB response is not transmitted.
          macControllerRxFSMNs = IDLE; 
`ifdef RW_BFMEE_EN
        else if (incorrectBFRPollRcved && (expectedResp == RESP_TYPE_BFR))
          //$fsm_t When BFR-Poll packet is not correct, the BFR response is not transmitted.
          macControllerRxFSMNs = IDLE; 
`endif //RW_BFMEE_EN
        else if (rxSTBC && dualCTSProt)
          //$fsm_t When correctRcved, rxEndOfFrame and durationCompEnd are set meaning that the frame has been completly received with the FCS OK 
          //the duration computation is finished and the frame received is a STBC frame and dualCTS Protection is enabled, 
          //the state machine goes to TX_STBC_RESP state.
          macControllerRxFSMNs = TX_STBC_RESP; 
        else           
          //$fsm_t When correctRcved, rxEndOfFrame and durationCompEnd are set meaning that the frame has been completly received with the FCS OK 
          //the duration computation is finished and the frame received requires a response, 
          //the state machine goes to TX_RESP state.
          macControllerRxFSMNs = TX_RESP; 
      end
      else if (incorrectRcved && rxEndOfFrame)      
        //$fsm_t When rxEndOfFrame_p is received with incorrectRcved set meaning that the frame has been 
        // completly received with an FCS error, the state machine goes to RX_WAIT_END state.
        macControllerRxFSMNs = RX_WAIT_END; 
      else if (correctRcved && rxEndOfFrame && (expectedResp == RESP_TYPE_NONE))      
        //$fsm_t When rxEndOfFrame_p is received with correctRcved set meaning that the frame which does not expect reponse has been 
        // completly received without FCS error, the state machine goes to IDLE state.
        macControllerRxFSMNs = IDLE; 
      else
        //$fsm_t While durationCompEnd is not received, the state machine stays in COMP_DURATION_RESP state.
        macControllerRxFSMNs = COMP_DURATION_RESP;


    COMP_DURATION_TFS:
      //$fsm_s In COMP_DURATION_TFS state, the state machine waits for the completion of the duration computation
      if (macPhyIfRxErr_p)      
        //$fsm_t When macPhyIfRxErr_p is received set meaning that a PHY error has been detected, 
        //the state machine goes to IDLE state.
        macControllerRxFSMNs = IDLE;
      else if (durationCompEnd && probRespRcved && (expectedResp != RESP_TYPE_NONE) && macHeaderCompleted)
        //$fsm_t When a probe Response which expected a response was received and its frame duration computing is completed, 
        //the state machine moves to COMP_DURATION_RESP.
        macControllerRxFSMNs = COMP_DURATION_RESP;  
      else if (durationCompEnd && rxEndOfFrame)      
        //$fsm_t When rxEndOfFrame_p is received with incorrectRcved set meaning that the frame has been 
        // completly received with an FCS error, the state machine goes to RX_WAIT_END state.
        macControllerRxFSMNs = RX_WAIT_END; 
      else
        //$fsm_t While durationCompEnd is not received, the state machine stays in COMP_DURATION_TFS state.
        macControllerRxFSMNs = COMP_DURATION_TFS;

    TX_RESP:
      //$fsm_s In TX_RESP state, the state machine launches the response frame transmission and waits until its completion
      if (txErr)
      begin
        if (expectedResp != RESP_TYPE_SW) 
          //$fsm_t When txErr is received meaning that a PHY error has been detected and the
          //response frame is not software,
          //the state machine goes to IDLE state.
          macControllerRxFSMNs = IDLE; 
        else
          //$fsm_t When txErr is received meaning that a PHY error has been detected and the 
          //response frame is software,
          //the state machine goes to TX_RESP_STATUS_UPDATE state.
          macControllerRxFSMNs = TX_RESP_STATUS_UPDATE; 
      end
      else if (txDone_p) 
        if (ap && dualRespNeeded && ~rxSTBC)
          //$fsm_t When txDone_p is received meaning that the response frame has been completely transmitted, 
          // and a STBC CTS or CFEND has to be transmitted (ap = 1 and dualRespNeeded = 1) and the RTS/CFEND received was not STBC (rxSTBC = 0),
          // the state machine moves to TX_STBC_RESP state.
          // Note that the dual CTS/CFEND response only applies to the AP; a non-AP STA shall respond to a RTS request with a single CTS and 
          // shall not respond to a CFEND.
          macControllerRxFSMNs = TX_STBC_RESP; 
        else  if (expectedResp == RESP_TYPE_SW)
          //$fsm_t When txDone_p is received meaning that the response frame has been completely
          //transmitted and response is from software,
          //the state machine moves to TX_RESP_STATUS_UPDATE state.
          macControllerRxFSMNs = TX_RESP_STATUS_UPDATE; 
        else  
          //$fsm_t When txDone_p is received meaning that the response frame has been completely transmitted, 
          // and a STBC CTS/CFEND transmission is not required, the state machine moves to IDLE state.
          macControllerRxFSMNs = IDLE; 
      else
        //$fsm_t While txDone_p is not received, the state machine stays in TX_RESP state.
        macControllerRxFSMNs = TX_RESP;

    CHECK_MEDIUM:
      //$fsm_s In CHECK_MEDIUM state, the state machine turns the PHY in RX to check if the medium is free for PIFS
      if (tickPIFS_p) 
        //$fsm_t When tickPIFS_p is received meaning that the medium was free for PIFS, the second CTS has to be transmitted.
        // So, the state machine moves to TX_RESP state.
        macControllerRxFSMNs = TX_RESP; 
      else if (macPhyIfRxCca) 
          //$fsm_t When macPhyIfRxCca is received meaning that the the PHY has detected a frame, 
          // the state machine moves to IDLE state.
          macControllerRxFSMNs = IDLE; 
      else
        //$fsm_t While tickPIFS_p or macPhyIfRxCca are not received, the state machine stays in CHECK_MEDIUM state.
        macControllerRxFSMNs = CHECK_MEDIUM;

    TX_STBC_RESP:
      //$fsm_s In TX_STBC_RESP state, the state machine launches the STBC response frame transmission and waits until its completion
      if (txErr) 
        //$fsm_t When txErr is received meaning that a PHY error has been detected, 
        //the state machine goes to IDLE state.
        macControllerRxFSMNs = IDLE; 
      else if (txDone_p) 
        if (ap && dualRespNeeded && rxSTBC && (expectedResp == RESP_TYPE_CTS))
          //$fsm_t When txDone_p is received meaning that the STBC response frame has been completely transmitted, 
          // and a non-STBC CTS has to be transmitted (ap = 1 and dualRespNeeded = 1 and rxSTBC != 0 and expectedResp == RESP_TYPE_CTS),
          // the state machine moves to CHECK_MEDIUM state. 
          // Note that the dual CTS response only applies to the AP; a non-AP STA shall respond to a RTS request with a single CTS.
          macControllerRxFSMNs = CHECK_MEDIUM; 
        else if (ap && dualRespNeeded && rxSTBC)
          //$fsm_t When txDone_p is received meaning that the STBC response frame has been completely transmitted, 
          // and a non-STBC CFEND has to be transmitted (ap = 1 and dualRespNeeded = 1 and rxSTBC != 0),
          // the state machine moves to TX_RESP state. 
          // Note that the dual CFEND response only applies to the AP; a non-AP STA shall not respond to a CFEND.
          macControllerRxFSMNs = TX_RESP; 
        else  
          //$fsm_t When txDone_p is received meaning that the STBC response frame has been completely transmitted, 
          // and a non-STBC CTS/CFEND transmission is not required, the state machine moves to IDLE state.
          macControllerRxFSMNs = IDLE; 
      else
        //$fsm_t While txDone_p is not received, the state machine stays in TX_STBC_RESP state.
        macControllerRxFSMNs = TX_STBC_RESP;

    RX_WAIT_END:
      //$fsm_s In RX_WAIT_END state, the state machine waits for the completion of the reception 
      // This state is reached only when the frame which is receiving does not expect response.
      // In case of correctRcved (FCS OK), the FSM waits for rxEndOfFrame and BFR not busy (prevent receive new frame during BFR computation).
      // In case of incorrectRcved (FCS ERROR), the FSM waits for the completion of the MACPHY RX FIFO flush (macPhyIfRxFlush_p)
      // In case of macPhyIfRxErr_p, the FSM moves to IDLE.
`ifdef RW_BFMEE_EN
      if ((correctRcved && rxEndOfFrame && !bfrStart) || (incorrectRcved && macPhyIfRxFlush) || macPhyIfRxErr_p)
`else //RW_BFMEE_EN
      if ((correctRcved && rxEndOfFrame             ) || (incorrectRcved && macPhyIfRxFlush) || macPhyIfRxErr_p)
`endif //RW_BFMEE_EN
        //$fsm_t When incorrectRcved_p or correctRcved is received meaning that the frame a been completely receive., 
        //the state machine moves to IDLE state.
        macControllerRxFSMNs = IDLE; 
      else
        //$fsm_t While incorrectRcved_p or correctRcved are not received, the state machine stays in RX_WAIT_END state.
        macControllerRxFSMNs = RX_WAIT_END;

    TX_RESP_STATUS_UPDATE:
      //$fsm_s In TX_RESP_STATUS_UPDATE state, the state machine waits for the completion of the
      //status update on the DMA side.
      if (statusUpdated_p | rxSWTBResp)
      begin
        //$fsm_t When the DMA has finished the status update,
        //the state machine moves in IDLE state.
        macControllerRxFSMNs = IDLE;
      end
      else
        //$fsm_t While the DMA has not finished the status update,
        //the state machine stays in TX_RESP_STATUS_UPDATE state.
        macControllerRxFSMNs = TX_RESP_STATUS_UPDATE;

    // Disable coverage on the default state because it cannot be reached.
    // pragma coverage block = off 
     default:   
        macControllerRxFSMNs = IDLE; 
    // pragma coverage block = on 
  endcase
end


// Generates a flag when the receiving a frame expecting a response is received.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    frameExpectingResp <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    frameExpectingResp <= 1'b0; 
  else
  begin
    if ((rxAggregation && needAckRcved_p    && !disableBAResp                  ) ||
        (rxAggregation && barRcved_p        && !disableBAResp                  ))
        frameExpectingResp <= 1'b1;
    else if (!rxAggregation && 
        ((rtsRcved_p && !disableCTSResp) || 
         (barRcved_p && !disableBAResp) || 
         (needAckRcved_p && !disableACKResp) || 
         (ap && cfEndRcved_p)))
        frameExpectingResp <= 1'b1;
`ifdef RW_BFMEE_EN
    else if ((needBFRRcved_p                    ) ||
             (needTBBFRRcved_p && !disableTBResp))
        frameExpectingResp <= 1'b1;
`endif //RW_BFMEE_EN
    else if (needHTPAckRcved_p & rxTRSValid   && !disableTBResp && !disableBAResp ||
             needHTPAckRcved   & rxTRSValid_p && !disableTBResp && !disableBAResp )
        frameExpectingResp <= 1'b1;
    else if ((rxTriggerHWValid_p && rxTriggerType==MU_RTS && !disableTBResp && !disableCTSResp) ||
             (rxTriggerHWValid_p && rxTriggerType==BQRP   && !disableTBResp && !disableBQRResp) ||
             (rxTriggerSWValid_p && rxTriggerType==BASIC  && !disableTBResp                   ) ||
             (rxTriggerSWValid_p && rxTriggerType==BSRP   && !disableTBResp                   ) ||
             (muBARTriggerRcved_p                         && !disableTBResp && !disableBAResp)) 
        frameExpectingResp <= 1'b1;
  end
end  

// Generates a flag when a frame is received and does not expect a response.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    frameDontExpectingResp <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    frameDontExpectingResp <= 1'b0; 
  else
  begin
    if (rxAggregation && ampduIncorrectRcved_p)
        frameDontExpectingResp <= 1'b1;
    else if (!rxAggregation && 
        (ackRcved_p || 
         ctsRcved_p || 
         (!ap && cfEndRcved_p) || 
         baRcved_p || 
         bcnRcved_p || 
         bcMcRcved_p || 
         ndpaRcved_p ||
`ifndef RW_BFMEE_EN
         bfrPollRcved_p ||
`endif//RW_BFMEE_EN
`ifdef  RW_BFMEE_EN
         (needTBBFRRcved_p && disableTBResp) ||
`endif//RW_BFMEE_EN
         notMineRcved_p || 
        (unknownRcved_p && !reservedRcved) || 
         (needAckRcved_p && disableACKResp) || 
         (needHTPAckRcved_p && (disableBAResp || disableTBResp)) || 
         (rtsRcved_p && disableCTSResp)|| 
         (barRcved_p && disableBAResp) || 
         (rxTRSValid_p       &&                          (disableTBResp                  )) ||
         (rxTriggerHWValid_p && rxTriggerType==MU_RTS && (disableTBResp || disableCTSResp)) ||
         (rxTriggerHWValid_p && rxTriggerType==BQRP   && (disableTBResp || disableBQRResp)) ||
         (rxTriggerSWValid_p && rxTriggerType==BASIC  && (disableTBResp                  )) ||
         (rxTriggerSWValid_p && rxTriggerType==BSRP   && (disableTBResp                  )) ||
         (muBARTriggerRcved_p                         && (disableTBResp || disableBAResp )) ||
         incorrectRcved_p))
        frameDontExpectingResp <= 1'b1;
  end
end  

// Generate a pulse to the MAC Controller Master when the RX Exchange is completed.
assign rxExchangeCompleted_p = ((macControllerRxFSMPs != IDLE  ) &&
                                (macControllerRxFSMCs == IDLE  ) &&
                                (~rxSWTBResp || swTBStatusReady));

// Generates a pulse to start the reception. This pulse is generated when the FSM moves in RX_FRAME or in CHECK_MEDIUM
// assign startRxRxC_p = (((macControllerRxFSMCs == IDLE) && (macControllerRxFSMNs == RX_FRAME)) ||
//                        ((macControllerRxFSMCs == TX_STBC_RESP) && (macControllerRxFSMNs == CHECK_MEDIUM))) ? 1'b1 : 1'b0;

// Generates a pulse to start the reception. This pulse is generated when the FSM moves in CHECK_MEDIUM
assign startRxRxC_p = ((macControllerRxFSMPs == TX_STBC_RESP) &&
                       (macControllerRxFSMCs == CHECK_MEDIUM)  ) || 
                      ((macControllerRxFSMPs == IDLE        ) &&
                       (macControllerRxFSMCs == RX_FRAME    ) &&
                       rxSWTBResp                              );

// Generates a pulse to stop the reception. This pulse is generated when the FSM moves in TX_RESP or if a frame is not correctly received. 
// Note that in case of phyErr, the stopRx_p is not generated because already handled by the macPhyIf.
assign stopRxRxC_p  = (((macControllerRxFSMCs == TX_RESP) && (macControllerRxFSMPs != TX_RESP)) || 
                       ((macControllerRxFSMCs == TX_STBC_RESP) && (macControllerRxFSMPs != TX_STBC_RESP)) || 
                       ((macControllerRxFSMPs != IDLE) && !correctRcved && !rxNDP && rxEndOfFrame_p) ||
                       ((macControllerRxFSMCs == RX_FRAME   ) && stopRxSRC_p   ) ||
                       ((macControllerRxFSMCs == RX_FRAME   ) && rxSWTBRespTO_p) ||
                       ((macControllerRxFSMCs == RX_WAIT_END) && stopRxSRC_p   )
                      ) ? 1'b1 : 1'b0;

// Generates a pulse to launch the response frame rate selection. This pulse is generated when the FSM moves in COMP_DURATION_RESP state.
assign rateUpdateRxC_p = ((macControllerRxFSMPs != COMP_DURATION_RESP) && (macControllerRxFSMCs == COMP_DURATION_RESP)) ? 1'b1 : 1'b0;

//
// RIFS Detection
// These following processes check if another reception after SIFS could be prossible.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    rxRIFSPossible <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    rxRIFSPossible <= 1'b0; 
  else if (rxVector1Valid_p && ((rxFormatMod == HT_MM) || (rxFormatMod == HT_GF)))  
    rxRIFSPossible <= 1'b1;
  else
    rxRIFSPossible <= 1'b0;
end

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    rxRIFSCancelled_p <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    rxRIFSCancelled_p <= 1'b0; 
  else if (frameExpectingResp && correctRcved_p)
    rxRIFSCancelled_p <= 1'b1;  
end


// RA/TA capture
////////////////////////////

// Destination address assignation
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    destAddrRxC <= 48'b0;
  else if (correctRcved_p)
    destAddrRxC <= rxAddr2;  
end

// Source address assignation
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    srcAddrRxC <= 48'b0;
`ifdef RW_BFMEE_EN
  // In case of response to a broadcast frame (Broadcast NDP-A followed by a NDP)
  // -> the source address of the response frame is the MAC address.
  else if (bcMcRcved && correctRcved_p)
    srcAddrRxC <= macAddr;
`endif//RW_BFMEE_EN
  else if (correctRcved_p)
    srcAddrRxC <= rxAddr1;  
end

// Indicates that a error occured during transmission
assign txErr = mpIfTxErr_p || macPHYIFUnderRun;

 
// Duration field update
// In ACK frames, the duration value is the value obtained from the Duration/ID field of the immediately previous data,
// management, PS-Poll, BlockAckReq, or BlockAck frame minus the time, in microseconds, required to
// transmit the ACK frame and its SIFS interval.
// For all CTS frames sent in response to RTS frames, the duration value is the value obtained from the
// Duration field of the immediately previous RTS frame, minus the time, in microseconds, required to
// transmit the CTS frame and its SIFS interval. 
// If the BlockAck frame is sent in response to the BlockAckReq frame, the Duration/ID field value is the
// value obtained from the Duration/ID field of the immediate BlockAckReq frame, minus the time, in
// microseconds, required to transmit the BlockAck frame and its SIFS interval. 
// If the calculated duration includes a fractional microsecond, that value is rounded to the next higher integer.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    durationRxC <= 16'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || rxExchangeCompleted_p)  // Synchronous Reset
    durationRxC <= 16'b0; 
  else if (macControllerRxFSMCs != IDLE)
  begin
    if (sendACK_p ||
        sendBA_p  ||
`ifdef RW_BFMEE_EN
        sendBFR_p ||
`endif//RW_BFMEE_EN
        sendSWTB_p ||
        sendCTSRxC_p ||
        sendBQR_p)
    begin
      if ((rxFrameDuration > estDuration) && !rxFrameDuration[15])
        durationRxC <= rxFrameDuration - estDuration;
      else 
        durationRxC <= 16'b0;
    end    
  end
end  

// Assign the MAC Header retry bit
assign retryRxC = (numMPDURetriesTPC == 8'b0000) ? 1'b0 : 1'b1;

// Compute the estimated duration of the response frame + SIFS
// If the FSM is in TX_RESP with dualRespNeeded and (rxSTBC != 0) meaning that the second CTS transmission in non-STBC is requested,
//  the estimated duration from the end of the reception to the end of this transmission is
//  SIFS + CTS in STBC duration + PIFS + CTS duration in non-STBC
//
// If the FSM is in TX_STBC_RESP with dualRespNeeded and (rxSTBC != 0) meaning that the first CTS transmission in STBC is requested,
//  the estimated duration from the end of the reception to the end of this transmission is
//  SIFS + CTS in STBC duration
//
// If the FSM is in TX_STBC_RESP with dualRespNeeded and (rxSTBC == 0) meaning that the second CTS transmission in STBC is requested,
//  the estimated duration from the end of the reception to the end of this transmission is
//  SIFS + CTS in non-STBC duration + SIFS + CTS duration in STBC
//
// If the received frame is a NDP, the estimated duration from the end of the reception of the NDP-A frame to the end of this transmission is
//  SIFS + NDP + SIFS + Beamforming Report Response
//
// For all the other cases, the estimated duration is timeOnAir of the response + sifs
always @*
begin
  if (dualRespNeeded && rxSTBC && (macControllerRxFSMCs == TX_RESP))
    estDuration = {8'b0,ctsSTBCDur} + {7'b0,sifs,1'b0} + timeOnAirMC + {8'b0,slotTime};
  else if (dualRespNeeded && rxSTBC && (macControllerRxFSMCs == TX_STBC_RESP))
    estDuration = {8'b0,ctsSTBCDur} + {8'b0,sifs};
  else if (dualRespNeeded && ~rxSTBC && (macControllerRxFSMCs == TX_STBC_RESP))
    estDuration = timeOnAirMC + {7'b0,sifs,1'b0} + {8'b0,ctsSTBCDur};
`ifdef RW_BFMEE_EN
  else if (rxNDPHold)
    estDuration = timeOnAirMC + {7'b0,sifs,1'b0} + {8'b0,rxNDPDur};
`endif//RW_BFMEE_EN
  else  
    estDuration = timeOnAirMC + {8'b0,sifs};
end


`ifdef RW_BFMEE_EN
// Compute the duration of the received NDP frame (36us + 4us per VHT-LTF symbol)
// Table 22-13 -- Number of VHT LTFs required for differents number of spatial streams
// VHT NDP packet with Nsts=1 is not valid, decoded like Nsts=2.
assign rxNsts = rxSTBC ? {rxNss[1:0],1'b1} : rxNss;

always @*
begin
  case (rxNsts)
  3'd0, 3'd1: rxNDPDur = 8'd44; // 36us + 2 * 4us
  3'd2, 3'd3: rxNDPDur = 8'd52; // 36us + 4 * 4us
  3'd4, 3'd5: rxNDPDur = 8'd60; // 36us + 6 * 4us
  3'd6, 3'd7: rxNDPDur = 8'd68; // 36us + 8 * 4us
  endcase
end
`endif//RW_BFMEE_EN

// When the FSM moves to TX_RESP or TX_STBC_RESP and the expected response is CTS,
// the sendCTSRxC_p pulse to trig the TX Controller for CTS transmission is generated
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    sendCTSRxC_p <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    sendCTSRxC_p <= 1'b0; 
  else
    if ((((macControllerRxFSMCs == TX_RESP) && (macControllerRxFSMPs != TX_RESP)) ||
         ((macControllerRxFSMCs == TX_STBC_RESP) && (macControllerRxFSMPs != TX_STBC_RESP))) &&
        (expectedResp == RESP_TYPE_CTS))
      sendCTSRxC_p <= 1'b1; 
    else  
      sendCTSRxC_p <= 1'b0; 
end

// When the FSM moves to TX_RESP or TX_STBC_RESP and the expected response is CFEND,
// the sendCFENDRxC_p pulse to trig the TX Controller for CFEND transmission is generated
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    sendCFENDRxC_p <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    sendCFENDRxC_p <= 1'b0; 
  else
    if ((((macControllerRxFSMCs == TX_RESP) && (macControllerRxFSMPs != TX_RESP)) ||
         ((macControllerRxFSMCs == TX_STBC_RESP) && (macControllerRxFSMPs != TX_STBC_RESP))) &&
        (expectedResp == RESP_TYPE_CFEND))
      sendCFENDRxC_p <= 1'b1; 
    else  
      sendCFENDRxC_p <= 1'b0; 
end

// If the current state is COMP_DURATION_RESP and the next state is TX_RESP or TX_STBC_RESP and the expected response is ACK,
// the sendACK_p pulse is generated
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    sendACK_p <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    sendACK_p <= 1'b0; 
  else
    if (((macControllerRxFSMCs == TX_RESP) || (macControllerRxFSMCs == TX_STBC_RESP)) && 
        (macControllerRxFSMPs == COMP_DURATION_RESP) && 
        (expectedResp == RESP_TYPE_ACK))
      sendACK_p <= 1'b1; 
    else  
      sendACK_p <= 1'b0; 
end

// If the current state is COMP_DURATION_RESP and the next state is TX_RESP or TX_STBC_RESP and the expected response is BLOCK ACK,
// the sendBA_p pulse is generated
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n)
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    sendBA_p <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    sendBA_p <= 1'b0;
  else
    if (((macControllerRxFSMCs == TX_RESP) || (macControllerRxFSMCs == TX_STBC_RESP)) &&
        (macControllerRxFSMPs == COMP_DURATION_RESP) &&
        (expectedResp == RESP_TYPE_BA))
      sendBA_p <= 1'b1;
    else
      sendBA_p <= 1'b0;
end

`ifdef RW_BFMEE_EN
// If the current state is COMP_DURATION_RESP and the next state is TX_RESP or TX_STBC_RESP and the expected response is Beamforming Report,
// the sendBFR_p pulse is generated
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    sendBFR_p <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    sendBFR_p <= 1'b0; 
  else
    if (((macControllerRxFSMCs == TX_RESP) || (macControllerRxFSMCs == TX_STBC_RESP)) && 
        (macControllerRxFSMPs == COMP_DURATION_RESP) && 
        (expectedResp == RESP_TYPE_BFR))
      sendBFR_p <= 1'b1; 
    else  
      sendBFR_p <= 1'b0; 
end
`endif //RW_BFMEE_EN

// If the current state is COMP_DURATION_RESP and the next state is TX_RESP or TX_STBC_RESP and 
// the expected response is Bandwidth Query Report, the sendBQR_p pulse is generated
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    sendBQR_p <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    sendBQR_p <= 1'b0; 
  else
    if ((macControllerRxFSMCs == TX_RESP) && 
        (macControllerRxFSMPs == COMP_DURATION_RESP) && 
        (expectedResp == RESP_TYPE_BQR))
      sendBQR_p <= 1'b1; 
    else  
      sendBQR_p <= 1'b0; 
end

// If the current state is COMP_DURATION_RESP and the next state is TX_RESP and 
// the expected response is a software trigger based frame, the trigTxTB is set
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    trigTxTB <= 1'b0; 
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    trigTxTB <= 1'b0; 
  else
    if ((macControllerRxFSMCs == TX_RESP) && 
        (macControllerRxFSMPs == COMP_DURATION_RESP) && 
        (expectedResp == RESP_TYPE_SW))
      trigTxTB <= 1'b1; 
    else if (macControllerRxFSMCs==IDLE && ~rxSWTBResp ||
             statusUpdated_p            &&  rxSWTBResp)
      trigTxTB <= 1'b0; 
end

// If the current state is COMP_DURATION_RESP and the next state is TX_RESP and 
// the expected response is a software trigger based frame, the sendSWTB_p pulse
// is generated
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    sendSWTB_p <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    sendSWTB_p <= 1'b0; 
  else
    if ((macControllerRxFSMCs == TX_RESP) && 
        (macControllerRxFSMPs == COMP_DURATION_RESP) && 
        (expectedResp == RESP_TYPE_SW))
      sendSWTB_p <= 1'b1; 
    else  
      sendSWTB_p <= 1'b0; 
end


// DMA Status : MPDU part of an A-MPDU transmitted
assign txMpduDoneRxC_p = trigTxTB & aMPDU & mpduDone_p;

// DMA Status update
// Indicates when the DMA Status has to be updated.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
  begin
    captureStatus_p      <= 1'b0; 
    captureStatusDly_p   <= 1'b0; 
    updateDMAStatusRxC_p <= 1'b0; 
  end
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
  begin
    captureStatus_p      <= 1'b0; 
    captureStatusDly_p   <= 1'b0; 
    updateDMAStatusRxC_p <= 1'b0; 
  end
  else
  begin
    captureStatusDly_p   <= captureStatus_p & ~rxSWTBResp | swTBStatusReady & ~swTBStatusReady_ff1; 
    updateDMAStatusRxC_p <= captureStatusDly_p;
    if (macControllerRxFSMCs != TX_RESP_STATUS_UPDATE & 
        macControllerRxFSMNs == TX_RESP_STATUS_UPDATE)
      captureStatus_p <= 1'b1;
    else  
      captureStatus_p <= 1'b0;
  end     
end

// Capture expectedAck coming from txParametersCache
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    expectedAckCapt <= 2'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    expectedAckCapt <= 2'b0;
  else if (txParameterHDReady_p)
    expectedAckCapt <= expectedAck;
end 
 
// Capture whichDescriptor coming from txParametersCache
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    whichDescriptorCapt <= 2'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    whichDescriptorCapt <= 2'b0;
  else if (txParameterHDReady_p)
    whichDescriptorCapt <= whichDescriptor;
end 

// DMA Status : Number of retry already done for this frame
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    numMPDURetriesRxC <= 8'b0; 
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    numMPDURetriesRxC <= 8'b0; 
  else if (txParameterHDReady_p)
    numMPDURetriesRxC <= numMPDURetriesTPC; 
end

// Generate Tx Status and provided it to the DMA
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    whichDescriptorSWRxC <= 4'b0; 
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    whichDescriptorSWRxC <= 4'b0; 
  else if (captureStatus_p || txMpduDoneRxC_p)
    whichDescriptorSWRxC <= {expectedAckCapt[1],aMPDU,whichDescriptorCapt};
end

// Generate Tx Status and provided it to the DMA
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    transmissionBWRxC <= 2'b0; 
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    transmissionBWRxC <= 2'b0; 
  else if (macControllerRxFSMPs!=TX_RESP & 
           macControllerRxFSMCs==TX_RESP)
    // DMA Status : Bandwidth used for the transmission.
    transmissionBWRxC <= txChBWRxC;
end

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    ampduFrmRxC_p <= 1'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    ampduFrmRxC_p <= 1'b0;
  else if (captureStatus_p)
    // DMA Status : Transmitted frame was an A-MPDU
    ampduFrmRxC_p <= aMPDU;
end


always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    mpduSuccessRxC_p <= 1'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    mpduSuccessRxC_p <= 1'b0;
  else if (captureStatusDly_p)
    // DMA Status : frame has been successfully transmitted
    mpduSuccessRxC_p <= ~swTBStatusError;
end


//Generate ToggleHDSetRxC_p pulse
//  In case of aMPDU when the txController is triggered or when first or intermediate MPDU is
//  transmitted.
//  Note: aMPDU is not set by the txParameterCache in case of single MPDU from DMA TB Channel
assign toggleHDSetRxC_p = trigTxTB & aMPDU & ((txParameterHDReady_p && whichDescriptor==2'b00) | mpduDone_p) & whichDescriptor!=2'b11;


//Generate clearSetsRxC_p pulse
//   Clear parameter cache when SW TB Frame has been sent
assign clearSetsRxC_p = macControllerRxFSMPs!=TX_RESP_STATUS_UPDATE &&
                        macControllerRxFSMCs==TX_RESP_STATUS_UPDATE &&
                        expectedResp==RESP_TYPE_SW;


// All the response are transmitted after SIFS except for the second CTS in dualCTS protection if it is STBC
assign sendOnSIFSRxC = ~sendOnPIFSRxC;

// When the dual Protection is enabled, the second CTS is transmitted after PIFS only if it is STBC
assign sendOnPIFSRxC = ((expectedResp == RESP_TYPE_CTS) && (macControllerRxFSMCs == TX_STBC_RESP) && ~rxSTBC) ? 1'b1 : 1'b0;

assign txResp = ((macControllerRxFSMCs == TX_RESP) || (macControllerRxFSMCs == TX_STBC_RESP)) ? 1'b1 : 1'b0;

assign txRxnRxC = (macControllerRxFSMCs == TX_RESP) || (macControllerRxFSMCs == TX_STBC_RESP);

// TODO:11ax
//   Trigger Based Response Type:
//   TRS: Multi-TID Block Ack (Not Supported)
//   TF : GCR MU-BA           (Not Supported)
//   TF : NDP Feedback        (Not Supported)
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    expectedResp <= RESP_TYPE_NONE; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    expectedResp <= RESP_TYPE_NONE; 
  else
  begin
    if (frameDontExpectingResp)
      expectedResp <= RESP_TYPE_NONE; 
    else if (!rxAggregation && needAckRcved_p && !disableACKResp)
      expectedResp <= RESP_TYPE_ACK; 
    else if (rtsRcved_p && !disableCTSResp && !respBWFail)
      expectedResp <= RESP_TYPE_CTS;
    else if (rxTriggerHWValid_p  && rxTriggerType==MU_RTS && !disableTBResp && !disableCTSResp)
      expectedResp <= RESP_TYPE_CTS;
    else if (rxTriggerHWValid_p  && rxTriggerType==BQRP   && !disableTBResp && !disableBQRResp)
      expectedResp <= RESP_TYPE_BQR;
    else if ((rxTriggerSWValid_p && rxTriggerType==BASIC  && !disableTBResp) ||
             (rxTriggerSWValid_p && rxTriggerType==BSRP   && !disableTBResp))
      expectedResp <= RESP_TYPE_SW;
    else if ((barRcved_p          && !disableBAResp                  ) ||
             (muBARTriggerRcved_p && !disableBAResp && !disableTBResp))
      expectedResp <= RESP_TYPE_BA;
    else if ((rxAggregation && needAckRcved_p     && !disableBAResp &&
              !rxTriggerHWValid && !rxTriggerSWValid                  ) ||
             // Ack ack policy should update response type only
             // if no trigger received.
             (needHTPAckRcved_p && !disableBAResp && !disableTBResp &&
              !rxTriggerHWValid && (!rxTriggerSWValid | rxTriggerType==BASIC)))
             // HTP Ack ack policy should update response type only
             // if no trigger received or basic trigger received.
    begin
      if (rxSMPDU)
        expectedResp <= RESP_TYPE_ACK;
      else
        expectedResp <= RESP_TYPE_BA;
    end
    else if (ap && cfEndRcved_p)
      expectedResp <= RESP_TYPE_CFEND; 
`ifdef RW_BFMEE_EN
    else if ((needBFRRcved_p                    ) ||
             (needTBBFRRcved_p && !disableTBResp))
      expectedResp <= RESP_TYPE_BFR; 
`endif //RW_BFMEE_EN
   end
end


// Capture the incorrectRcved_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    incorrectRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    incorrectRcved <= 1'b0; 
  else
  begin
    if (!rxAggregation && incorrectRcved_p)
      incorrectRcved <= 1'b1; 
    else if (rxAggregation && ampduIncorrectRcved_p)
      incorrectRcved <= 1'b1; 
  end    
end

// Capture the correctRcved_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    correctRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    correctRcved <= 1'b0; 
  else
  begin
    if (!rxAggregation && correctRcved_p)
      correctRcved <= 1'b1; 
    else if (rxAggregation && ampduCorrectRcved_p)
      correctRcved <= 1'b1; 
  end
end

// Capture the probRespRcved_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    probRespRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    probRespRcved <= 1'b0; 
  else
    if (probRespRcved_p)
      probRespRcved <= 1'b1; 
end

// Capture the probRespRcved_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    bcnRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    bcnRcved <= 1'b0; 
  else
    if (bcnRcved_p)
      bcnRcved <= 1'b1; 
end

// Capture the timeOnAirValidMC pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    durationCompEndFlag <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE) || startComputationMCRx_p)  // Synchronous Reset
    durationCompEndFlag <= 1'b0; 
  else
    if (timeOnAirDone_p)
      durationCompEndFlag <= 1'b1; 
end

assign durationCompEnd = durationCompEndFlag && !startComputationMCRx_p && (macControllerRxFSMCs == macControllerRxFSMPs);


// Capture the rxEndOfFrame_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    rxEndOfFrame <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    rxEndOfFrame <= 1'b0;
  else
    if (rxEndOfFrame_p)
      rxEndOfFrame <= 1'b1;
end

// Capture the macPhyIfRxFlush_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macPhyIfRxFlush <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    macPhyIfRxFlush <= 1'b0;
  else
    if (macPhyIfRxFlush_p)
      macPhyIfRxFlush <= 1'b1;
end

`ifdef RW_BFMEE_EN
// Capture the incorrectBFRPollRcved_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    incorrectBFRPollRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    incorrectBFRPollRcved <= 1'b0; 
  else
    if (incorrectBFRPollRcved_p)
      incorrectBFRPollRcved <= 1'b1; 
end

// Capture the rxNDP signal
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    rxNDPHold <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    rxNDPHold <= 1'b0; 
  else
    if (rxNDP)
      rxNDPHold <= 1'b1; 
end
`endif //RW_BFMEE_EN


// Capture rxTriggerHWValid_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
   if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
      rxTriggerHWValid <= 1'b0; 
   else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
      rxTriggerHWValid <= 1'b0; 
   else
      if (rxTriggerHWValid_p)
         rxTriggerHWValid <= 1'b1; 
end


// Capture rxTriggerSWValid_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
   if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
      rxTriggerSWValid <= 1'b0; 
   else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
      rxTriggerSWValid <= 1'b0; 
   else
      if (rxTriggerSWValid_p)
         rxTriggerSWValid <= 1'b1; 
end


// Capture the trsRcved_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    trsRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    trsRcved <= 1'b0; 
  else
    if (incorrectRcved_p | correctRcved_p)
      trsRcved <= 1'b0; 
    else if (trsRcved_p)
      trsRcved <= 1'b1; 
end


// Capture needHTPAckRcved_p pulse
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
   if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
      needHTPAckRcved <= 1'b0; 
   else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
      needHTPAckRcved <= 1'b0; 
   else
      if (needHTPAckRcved_p)
         needHTPAckRcved <= 1'b1; 
end


// This process assignes the response frame length to txRespLength.
always @*
begin
  case (expectedResp)
    RESP_TYPE_ACK    : txRespLength = respIsTB ? 20'd20: // Ack + aMPDU delimiter + Padding
                                                 20'd14; // Ack
    RESP_TYPE_CTS    : txRespLength = 20'd14;
    RESP_TYPE_BA     : txRespLength = respIsTB ? 20'd36: // compressed BA + aMPDU delimiter
                                                 20'd32; // Only Compressed BA is supported
    RESP_TYPE_CFEND  : txRespLength = 20'd14;
`ifdef RW_BFMEE_EN
    RESP_TYPE_BFR    :
    begin
       if (bfrFormatMod!=VHT && bfrFormatMod!=HE_SU && ~respIsTB)
          txRespLength = {5'b0,bfrLength};
       else if (bfrLength[1:0]==2'd0 & ~txUPHControl)
          // aMPDU delimiter length is added
          txRespLength = {5'b0,bfrLength[14:2],2'd0}+20'd4;
       else if (bfrLength[1:0]!=2'd0 & ~txUPHControl)
          // aMPDU delimiter length + Padding is added
          txRespLength = {5'b0,bfrLength[14:2],2'd0}+20'd8;
       else if (bfrLength[1:0]==2'd0 &  txUPHControl)
          // aMPDU delimiter length and HTC Length is added
          txRespLength = {5'b0,bfrLength[14:2],2'd0}+20'd8;
       else//if (bfrLength[1:0]!=2'd0 &  txUPHControl)
          // aMPDU delimiter length + Padding is added
          txRespLength = {5'b0,bfrLength[14:2],2'd0}+20'd12;
    end
`endif //RW_BFMEE_EN
    RESP_TYPE_BQR:
    begin
       // QoS Null Frame + HTC + aMPDU delimiter + Padding
       txRespLength = 20'd40;
    end
    RESP_TYPE_SW:
    begin
       // A-MPDU: response length = aMPDU Length
       // S-MPDU: response length = mpdu length + aMPDU delimiter length + EOF Padding Octets
       // Note: aMPDU is not set by the txParameterCache in case of single MPDU from DMA TB Channel
       if (aMPDU)
          txRespLength = aMPDUFrameLengthTx;
       else if (MPDUFrameLengthTx[1:0]==2'b0)
          txRespLength = {4'd0,MPDUFrameLengthTx[15:2],2'b00}+20'd4;
       else
          txRespLength = {4'd0,MPDUFrameLengthTx[15:2],2'b00}+20'd8;
    end
    default          : txRespLength = 20'd0;
  endcase
end

// decided if the dual response with STBC is needed
// If as an AP the Frame received is a RTS in HT PPDU and the dualCTS protection is enabled.
// the DUAL CTS transmission is enabled (dualRespNeeded = 1).
// If as an AP the Frame received is a CFEND in HT PPDU and the dualCTS protection is enabled.
// the DUAL CFEND transmission is enabled (dualRespNeeded = 1).
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    dualRespNeeded <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    dualRespNeeded <= 1'b0;
  else
  begin
    if (ap && dualCTSProt && rtsRcved_p && rxFrameIsHT)
      dualRespNeeded <= 1'b1;
    if (ap && dualCTSProt && cfEndRcved_p && rxFrameIsHT)
      dualRespNeeded <= 1'b1;
  end    
end


// Assign rate
// if Trigger Based response, rate is coming from the trigger frame
// if response frame is BFR , rate is coming from the bfmeeControlReg
// else                     , rate is coming from the Rate Selection module
always @*
begin
  if (respIsTB && ~rxTriggerMethod)
    // The response frame is an HE-TB frame in response to a trigger frame
    txMCSRxC = {rxTriggerNumSS,rxTriggerULMCS};
  else if (respIsTB && rxTriggerMethod)
    // The response frame is an HE-TB frame in response to a frame with a TRS control field
    txMCSRxC = {5'd0,rxTRSMCS};
`ifdef RW_BFMEE_EN
  else if ((expectedResp == RESP_TYPE_BFR) &&  bfrMCS[7])
    txMCSRxC = bfrMCS[6:0];
  else if ((expectedResp == RESP_TYPE_BFR) && ~bfrMCS[7])
    txMCSRxC = 7'd0;
`endif //RW_BFMEE_EN
  else
    txMCSRxC = mcsRESP;
end

always @*
begin
  if (respIsHT | respIsTB)
    txLegRateRxC = 4'b0100;  
  else if (respIsTBCTS)
    txLegRateRxC = 4'b0100;  
`ifdef RW_BFMEE_EN
  else if (expectedResp == RESP_TYPE_BFR)
    txLegRateRxC = bfrMCS[3:0];
`endif //RW_BFMEE_EN
  else
    txLegRateRxC = legRateRESP;
end

// Assign HT length
// If the reponse frame is an HT frame (respIsHT == 1'b1), the HT Length takes the txRespLength else it takes the value 0
assign txHTLengthRxC  = (respIsHT | respIsTB) ? txRespLength : 20'b0;  

// If the reponse frame is an non-HT frame (respIsHT == 1'b0), the Legacy Length takes the txRespLength 
// If the response frame is an HE-TB frame in response to a trigger frame, the Legacy Length is provided by the Trigger Frame
// else it takes the legLengthComputed value
assign txLegLengthRxC = (~respIsHT && ~respIsTB)       ? txRespLength[11:0] :
                        (respIsTB && ~rxTriggerMethod) ? rxTriggerULLength    :
                                                         {legLengthComputed[11:0]};

// If the response frame is an HE-TB frame in response to a trigger frame,
//   the STBC is provided by the Trigger Frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//   the STBC is 0
assign txSTBCRxC  = (respIsTB && ~rxTriggerMethod)         ? rxTriggerULSTBC :
                    (respIsTB &&  rxTriggerMethod)         ? 1'b0          :
                    (macControllerRxFSMCs == TX_STBC_RESP) ? 1'b1 : 1'b0; //$todo Is STBC = 1 ok?  In 2x2, response can be STBC.

// If the response frame is an HE-SU, HE-ER-SU or HE-TB in response to an HE frame with unspecified
// TXOP Duration:
//   The TXOP Duration shall be UNSPECIFIED
// If the response frame is an HE-TB in response to a HE frame with TXOP Duration not UNSPECIFIED:
//   The TXOP Duration shall not be UNSPECIFIED
// If the response frame is an HE-TB in response to a not HE frame:
//   The TXOP Duration shall not be UNSPECIFIED
always @*
begin
   if (respIsTB & (rxFormatMod<=VHT | rxTxopDuration!={7{1'b1}}))
   begin
      if (durationRxC[15:9]==0)
      begin
         // TXOP Duration = durationID / 8
         txTxopDurationRxC[6:1] = durationRxC[8:3];
         txTxopDurationRxC[0]   = 1'b0;
      end
      else if (durationRxC<16'd8448)
      begin
         // TXOP Duration = (durationID - 512) / 128
         txTxopDurationRxC[6:1] = durationRxC[12:7]-6'd4;
         txTxopDurationRxC[0]   = 1'b1;
      end
      else
      begin
         // TXOP Duration = (8448 - 512) / 128
         txTxopDurationRxC[6:1] = 6'h3E;
         txTxopDurationRxC[0]   = 1'b1;
      end
   end
   else
      txTxopDurationRxC = {7{1'b1}};
end

// Extract and capture the TRQ and NDP Announcement bit from the HT Control Field of the received frame
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
  begin
    rxTRQ <= 1'b0;
    rxNDPAn <= 1'b0;
  end
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
  begin
    rxTRQ <= 1'b0;
    rxNDPAn <= 1'b0;
  end
  else
    if ((macHeaderCompleted && !macHeaderCompleted_ff1) && (rxHTCtrl[0] == 1'b0))
    begin
      // When the MAC Header has been received, check the HT Control field.
      // If the HT Control is a HT Variant, update rxTRQ and rxNDPAn.
      rxTRQ   <= rxHTCtrl[1];
      rxNDPAn <= rxHTCtrl[24];
    end    
end

// Extract and capture the TRS control field from the HT Control Field of the received frame
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
  begin
    rxTRSLength       <= 5'd0;
    rxTRSRUAllocation <= 8'd0;
    rxTRSDLTxPower    <= 5'd0;
    rxTRSULTargetRSSI <= 5'd0;
    rxTRSMCS          <= 2'd0;
    rxTRSValid        <= 1'b0;
  end
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
  begin
    rxTRSLength       <= 5'd0;
    rxTRSRUAllocation <= 8'd0;
    rxTRSDLTxPower    <= 5'd0;
    rxTRSULTargetRSSI <= 5'd0;
    rxTRSMCS          <= 2'd0;
    rxTRSValid        <= 1'b0;
  end
  else
    if (rxTRSValid_p)
    begin
      // When TRS control field is received, capture TRS subfields.
      rxTRSLength       <= rxHTCtrl[10:6];
      rxTRSRUAllocation <= rxHTCtrl[18:11];
      rxTRSDLTxPower    <= rxHTCtrl[23:19];
      rxTRSULTargetRSSI <= rxHTCtrl[28:24];
      rxTRSMCS          <= rxHTCtrl[30:29];
      rxTRSValid        <= 1'b1;
    end    
end
assign rxTRSValid_p = trsRcved & correctRcved_p;

assign rxFrameIsHT = ((rxFormatMod == HT_MM    ) ||
                      (rxFormatMod == HT_GF    ) ||
                      (rxFormatMod == VHT      ) || 
                      (rxFormatMod == HE_SU    ) ||
                      (rxFormatMod == HE_EXT_SU) ||
                      (rxFormatMod == HE_MU    )) ? 1'b1 : 1'b0;

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macHeaderCompleted_ff1 <= 1'b0;
  else
    macHeaderCompleted_ff1 <= macHeaderCompleted;
end

// determind if the response should be HT or NON-HT PPDU.
// A control response frame must be carried in an HT PPDU if it responds to a frame that:
//  1.	Contained TRQ = 1 and NDP announcement = 0
//  2.	Was an RTS carried in an HT-PPDU
//  3.	Used STBC, and Dual CTS Protection is enabled
//  4.  Contains an L-SIG Duration value (lSIGTXOPDetected = 1)
// Else, it must be carried in a non-HT PPDU.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    respIsHT <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
     respIsHT <= 1'b0;
  else
    if ((rxTRQ && !rxNDPAn) ||                                          
        ((expectedResp == RESP_TYPE_CTS) &&  rxFrameIsHT == 1'b1 && respIsTBCTS == 1'b0) || 
`ifdef RW_BFMEE_EN
        ((expectedResp == RESP_TYPE_BFR) && (bfrFormatMod >= 3'd2)) || 
`endif //RW_BFMEE_EN
        (rxSTBC && dualCTSProt) ||
        lSIGTXOPDetected)
      respIsHT <= 1'b1;
    else
      respIsHT <= 1'b0;
end

// Determine if the response should be HE-TB
// A response frame shall be carried in an HE-TB if it responds to:
//  1.	a Trigger Frame (except MU-RTS trigger Frame)
//  2.	a frame with a TRS control field received in an HE frame and an HTP ack is expected.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
  begin
    respIsTB        <= 1'b0;
    rxTriggerMethod <= 1'b0;
  end
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
  begin
    respIsTB        <= 1'b0;
    rxTriggerMethod <= 1'b0;
  end
  else
    if (rxTriggerHWValid_p && rxTriggerType!=MU_RTS ||
        rxTriggerSWValid_p)
    begin
      respIsTB        <= 1'b1;
      rxTriggerMethod <= 1'b0;
    end
    else if (rxTRSValid_p)
    begin
      respIsTB        <= 1'b1;
      rxTriggerMethod <= 1'b1;
    end
end

// Determine if the response should be a CTS frame in response of a MU-RTS Trigger frame
// TODO:11ax
//   - Verify that RU allocation indicates Primary 20, 40, 80 or 160MHz channel (11ax 2.0 p227)
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    respIsTBCTS <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    respIsTBCTS <= 1'b0;
  else
    if (rxTriggerHWValid_p && rxTriggerType==MU_RTS)
      respIsTBCTS <= 1'b1;
end

// If the response Legacy Rate is 0, the ppduPreTypeMCRx is forced to 1 (NON-HT Long preamble)
//assign respTxPreType    = (legRateRESP == 4'b0) ? 1'b1 : rxPreType;    
assign respTxPreType    = (respTxMCSIndex[3:0] == 4'b0) ? 1'b1 : rxPreType;    

assign respTxNumExtnSS  = 2'b00;
assign respTxAntennaSet = rxAntennaSet;

assign respTxSMMIndex   = 8'h00;

assign respTxNTx        = maxPHYNtx - 3'b1;

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response FEC Coding is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response FEC Coding is one if RU allocation is greather or equal to 484 tones.
always @*
  if (respIsTB && ~rxTriggerMethod)
    respTxFECCoding = rxTriggerULFECCoding;
  else if (respIsTB && rxTriggerMethod && rxTRSRUAllocation[7:1]>7'd64)
    respTxFECCoding = 1'd1;
  else if (respIsTB && rxTriggerMethod && rxTRSRUAllocation[7:1]<=7'd64)
    respTxFECCoding = 1'd0;
  else if (respIsHT)
    respTxFECCoding = rxFecCoding;
  else
    respTxFECCoding = 1'd0;

// If the response frame is Trigger Based in response to a trigger Frame,
//    the response GIType is from the trigger frame parameters
// If the response frame is Trigger Based in response to a frame with a TRS control field,
//    the response GIType depend of the received frame GIType & HELTFType.
// If the response frame is BFR,
//    the response GIType is from register
// else, if the response frame is HT (respIsHT set),
//    the reponse ShortGI is the ShortGI of the received frame 
// else, if the received frame is Leg,
//    the response ShortGI is 0
always @*
begin
  if (respIsTB && ~rxTriggerMethod)
    // Trigger Based frame in response to a trigger frame
    respTxGIType = (rxTriggerGIAndLTFType==2'd2) ? 2'd2 : 2'd1;
  else if (respIsTB && rxTriggerMethod)
    // Trigger Based frame in response to a frame with a TRS control field
    respTxGIType = (rxHeLtfType==2'd2 && rxGIType==2'd2 ||
                    rxHeLtfType==2'd1 && rxGIType==2'd1 ) ? 2'd2 : 2'd1;
`ifdef RW_BFMEE_EN
  else if (expectedResp == RESP_TYPE_BFR && bfrFormatMod>=4'd5)
    respTxGIType = bfrGIType;
  else if (expectedResp == RESP_TYPE_BFR)
    respTxGIType = {1'b0,bfrShortGI};
`endif //RW_BFMEE_EN
  else if (respIsHT && rxFormatMod<=VHT)
    respTxGIType = rxGIType;
  else
    respTxGIType = 2'b0;    
end

// If the response frame is BFR, the response Format modulation is from register
// else, if the response frame is HE-TB, the response Format Modulation is HE-TB
// else, if the response frame is CTS in response of a trigger frame, the response Format Modulation is NON-HT if allocated BW is 20MHz, or HT-DUP-OFDM if allocated BW is larger than 20MHz.
// else, if the response frame is HT-PPDU (respIsHT set), the response Format Modulation is HT-MF (the HT-GF is not supported in transmit)
// else, if the received frame was a NON-HT-DUP-OFDM (rxFormatMod = 1), the response Format Modulation is NON-HT-DUP-OFDM else it is NON-HT
always @*
begin
  if (respIsTB)
    respTxFormatMod = HE_TB;
  else if (respIsTBCTS && |rxTriggerRUAllocIndex[67:65] || notMineMURtsRcved && rxTriggerULBW!=2'd0)
    respTxFormatMod = NON_HT_DUP_OFDM;
  else if (respIsTBCTS || notMineMURtsRcved)
    respTxFormatMod = NON_HT;
`ifdef RW_BFMEE_EN
  else if (expectedResp == RESP_TYPE_BFR && ~respIsTB)
    respTxFormatMod = {1'b0,bfrFormatMod};
`endif //RW_BFMEE_EN
  else if (respIsHT)
    respTxFormatMod = HT_MM;
  else if ((rxFormatMod == NON_HT_DUP_OFDM) || (rxChBW != 2'd0 && maxSupportedBW != 2'd0))
    respTxFormatMod = NON_HT_DUP_OFDM;
  else
    respTxFormatMod = NON_HT;
end

// If trigger based response   , the response MCS Index is from trigger frame
// If the response frame is BFR, the response MCS Index is from register
// else,                         the response MCS Index is from the rate selection module
always @*
begin
  if (respIsTB && ~rxTriggerMethod)
    // The response frame is an HE-TB frame in response to a trigger frame
    respTxMCSIndex = {1'b1,rxTriggerNumSS,rxTriggerULMCS};
  else if (respIsTB && rxTriggerMethod)
    // The response frame is an HE-TB frame in response to a frame with a TRS control field
    respTxMCSIndex = {1'b1,5'd0,rxTRSMCS};
  else if (respIsTBCTS || notMineMURtsRcved)
    respTxMCSIndex = {4'b0,4'b0100};
`ifdef RW_BFMEE_EN
  else if (expectedResp == RESP_TYPE_BFR)
    respTxMCSIndex = bfrMCS;
`endif //RW_BFMEE_EN
  else if (respTxFormatMod >= 4'd2)
    respTxMCSIndex =  {1'b1,mcsRESP};
  else
    respTxMCSIndex =  {4'b0,legRateRESP};
end

// If the response frame format is VHT or HE, the response is an A-MPDU
// else, the response is never an A-MPDU
assign respTxAMPDU           = |respTxFormatMod[3:2];
assign respTxSMPDU           = |respTxFormatMod[3:2];
`ifdef RW_BFMEE_EN
assign respMPDUFrameLengthTx = (expectedResp == RESP_TYPE_ACK)? 20'd14 : // Ack
                               (expectedResp == RESP_TYPE_BA) ? 20'd32 : // Compressed BA
                               (expectedResp == RESP_TYPE_BQR)? 20'd34 : // QoS Null +HTC (BQR)
                               (txUPHControl)                 ? bfrLength+15'd4:
                                                                bfrLength;
`else//RW_BFMEE_EN
assign respMPDUFrameLengthTx = (expectedResp == RESP_TYPE_ACK)? 20'd14 : // Ack
                               (expectedResp == RESP_TYPE_BA) ? 20'd32 : // Compressed BA
                                                                20'd34 ; // QoS Null +HTC (BQR)
`endif //RW_BFMEE_EN

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response transmit power is based on the Trigger Frame parameters.
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response transmit power is based on the TRS parameters.
always @*
begin
   if ((~rxTriggerMethod & (&rxTriggerULTargetRSSSI)) |
       ( rxTriggerMethod & (&rxTRSULTargetRSSI)))
      // Maximum power level (127 dBm)
      tbTxPwrLevelReq = 9'h7f;
   else if (~rxTriggerMethod)
      // Tx Power Level from trigger frame field
      tbTxPwrLevelReq = {3'b0,rxTriggerAPTxPower} +
                        {2'b0,rxTriggerULTargetRSSSI} -
                        {rxRSSILegacy[7],rxRSSILegacy} -
                        9'd130;
   else
      // Tx Power Level from TRS control field
      tbTxPwrLevelReq = {3'b0,rxTRSDLTxPower,1'b0} +
                        {3'b0,rxTRSULTargetRSSI,1'b0} -
                        {rxRSSILegacy[7],rxRSSILegacy} -
                        9'd110;
end

always @*
begin
   if ((tbTxPwrLevelReq^9'h100)>=({ofdmMaxPwrLevel[7],ofdmMaxPwrLevel}^9'h100))
   begin
      // When transmit power for Trigger based frame response is greather than ofdmMaxPwrLevel,
      // the transmit power is force to ofdmMaxPwrLevel
      tbTxPwrLevel    = ofdmMaxPwrLevel;
      tbTxPwrLevelMin = 1'b0;
   end
   else if ((tbTxPwrLevelReq^9'h100)<=({ofdmMinPwrLevel[7],ofdmMinPwrLevel}^9'h100))
   begin
      // When transmit power for Trigger based frame response is lower than ofdmMinPwrLevel
      // the transmit power is force to ofdmMinPwrLevel
      tbTxPwrLevel    = ofdmMinPwrLevel;
      tbTxPwrLevelMin = 1'b1;
   end
   else
   begin
      tbTxPwrLevel    = tbTxPwrLevelReq[7:0];
      tbTxPwrLevelMin = 1'b0;
   end
end

always @*
begin
   if (respIsTB)
      respTxPwrLevel = tbTxPwrLevel;
   else
      respTxPwrLevel = ofdmMaxPwrLevel;
end

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response HE LTF Type is based on the Trigger Frame parameters.
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response HE LTF Type is based on the received frame GIType & HELTFType.
always @*
begin
  if (respIsTB && ~rxTriggerMethod)
    // Trigger Based frame in response to a trigger frame
    respTxHELTFType = rxTriggerGIAndLTFType;
  else if (respIsTB && rxTriggerMethod)
    // Trigger Based frame in response to a frame with a TRS control field
    respTxHELTFType = (rxHeLtfType==2'd2 && rxGIType==2'd2 ||
                       rxHeLtfType==2'd1 && rxGIType==2'd1 ) ? 2'd2 : 2'd1;
`ifdef  RW_BFMEE_EN
  else if (expectedResp == RESP_TYPE_BFR)
    respTxHELTFType = bfrHELTFType;
`endif//RW_BFMEE_EN
  else
    // Not applicable, Only HE_TB Response frame is supported.
    respTxHELTFType = 2'd2;
end

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response doppler is from the Trigger Frame parameters.
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response doppler is '0'
assign respTxDoppler = (respIsTB && ~rxTriggerMethod) ? rxTriggerDoppler :
                                                        1'b0;

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response midamble is from the Trigger Frame parameters.
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response doppler is '0'
always @*
   if (respIsTB & ~rxTriggerMethod & rxTriggerDoppler)
      respTxMidamble = rxTriggerNumHELTFAndMidPeriod[2];
   else
      respTxMidamble = 1'b0;

// If the response frame is a Trigger Based in response to a Trigger frame, 
//    if Trigger frame is received in an HE PPDU, the response BSS COLOR is from the Rx Vector
//    else                                        the response BSS COLOR is from register
// If the response frame is a Trigger Based in response to a frame with a TRS control field, 
//    the response BSS COLOR is from the Rx Vector
always @*
  if (respIsTB && ~rxTriggerMethod && rxFormatMod>=HE_SU)
    respTxBSSColor = rxBssColor;
  else if (respIsTB && ~rxTriggerMethod && rxFormatMod<HE_SU)
    respTxBSSColor = bssColorCSReg;
  else if (respIsTB && rxTriggerMethod)
    respTxBSSColor = rxBssColor;
  else
    // Not applicable, Only HE_TB Response frame is supported.
    respTxBSSColor = bssColorCSReg;

// If the response frame is a Trigger Based in response to a Trigger frame, 
//    the response DCM is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field, 
//    the response DCM is from the Rx Vector
//ToDo:11ax when DCM is supported
always @*
  if (respIsTB && ~rxTriggerMethod)
    respTxDcm = rxTriggerULDCM;
  else if (respIsTB && rxTriggerMethod && rxFormatMod>=HE_SU)
    respTxDcm = rxDcm;
  else
    // Not applicable, frame with a TRS control field should be received in HE format
    respTxDcm = 1'b0;


// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response spatial reuse is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response spatial reuse is SRP_AND_NONSRG_OBSS-PD_PROHIBITED
always @*
  if (respIsTB && ~rxTriggerMethod)
  begin
    respTxSpatialReuse1 = rxTriggerULSpatialReuse[ 0+:4];
    respTxSpatialReuse2 = rxTriggerULSpatialReuse[ 4+:4];
    respTxSpatialReuse3 = rxTriggerULSpatialReuse[ 8+:4];
    respTxSpatialReuse4 = rxTriggerULSpatialReuse[12+:4];
  end
  else if (respIsTB && rxTriggerMethod)
  begin
    respTxSpatialReuse1 = 4'd15;
    respTxSpatialReuse2 = 4'd15;
    respTxSpatialReuse3 = 4'd15;
    respTxSpatialReuse4 = 4'd15;
  end
  else
  begin
    // Not applicable, Only HE_TB Response frame is supported.
    respTxSpatialReuse1 = 4'd15;
    respTxSpatialReuse2 = 4'd15;
    respTxSpatialReuse3 = 4'd15;
    respTxSpatialReuse4 = 4'd15;
  end


// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response HE SIG-A Reserved is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response HE SIG-A Reserved is 511 (all 1s)
assign respTxHESigAReserved = (respIsTB && ~rxTriggerMethod) ? rxTriggerULHESigA2Reserved :
                                                               {9{1'b1}};

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response Number of HE LTF is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response Number of HE LTF is zero
always @*
  if (respIsTB && ~rxTriggerMethod && ~rxTriggerDoppler)
    case (rxTriggerNumHELTFAndMidPeriod)
    3'd0:    respTxNumHeLtf = 3'd0; // 1 HE-LTF symbol
    3'd1:    respTxNumHeLtf = 3'd1; // 2 HE-LTF symbol
    3'd2:    respTxNumHeLtf = 3'd3; // 4 HE-LTF symbol
    3'd3:    respTxNumHeLtf = 3'd5; // 6 HE-LTF symbol
    3'd4:    respTxNumHeLtf = 3'd7; // 8 HE-LTF symbol
    default: respTxNumHeLtf = 3'd0; // Reserved
    endcase
  else if (respIsTB && ~rxTriggerMethod && rxTriggerDoppler)
    case (rxTriggerNumHELTFAndMidPeriod)
    3'd0:    respTxNumHeLtf = 3'd0; // 1 HE-LTF symbol
    3'd1:    respTxNumHeLtf = 3'd1; // 2 HE-LTF symbol
    3'd2:    respTxNumHeLtf = 3'd3; // 4 HE-LTF symbol
    3'd4:    respTxNumHeLtf = 3'd0; // 1 HE-LTF symbol
    3'd5:    respTxNumHeLtf = 3'd1; // 2 HE-LTF symbol
    3'd6:    respTxNumHeLtf = 3'd3; // 4 HE-LTF symbol
    default: respTxNumHeLtf = 3'd0; // Reserved
    endcase
  else
    respTxNumHeLtf = 3'd0;

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response HE LTF mode is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response HE LTF mode is zero
always @*
  if (respIsTB && ~rxTriggerMethod)
    respTxHELtfMode = rxTriggerHELTFMode;
  else
    respTxHELtfMode = 1'd0;

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response LDPC Extra symbol is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response LDPC Extra symbol is one if RU allocation is greather or equal to 484 tones.
always @*
  if (respIsTB && ~rxTriggerMethod)
    respTxLDPCExtraSymbol = rxTriggerLDPCExtraSymbol;
  else if (respIsTB && rxTriggerMethod && rxTRSRUAllocation[7:1]>7'd64)
    respTxLDPCExtraSymbol = 1'd1;
  else
    respTxLDPCExtraSymbol = 1'd0;

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response starting STS number is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response starting STS number is zero
always @*
  if (respIsTB && ~rxTriggerMethod)
     respTxStartingSTSNum = rxTriggerStartingSSNum;
  else
     respTxStartingSTSNum = 3'd0;

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response RU allocation is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response RU allocation is from the TRS Field
always @*
  if (respIsTB && ~rxTriggerMethod)
     respTxRUAllocation = rxTriggerRUAllocation;
  else if (respIsTB && rxTriggerMethod)
     respTxRUAllocation = rxTRSRUAllocation;
  else
     respTxRUAllocation = 8'd0;

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response Packet Extension is from the trigger frame
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response Packet Extention is the default PE duration
always @*
  if (respIsTB && ~rxTriggerMethod)
    respTxPacketExtension = rxTriggerULPacketExtension;
  else
    respTxPacketExtension = defaultPEDur;

// If the response frame is a Trigger Based in response to a Trigger frame,
//    the response Trigger Method is zero
// If the response frame is a Trigger Based in response to a frame with a TRS control field,
//    the response Trigger Method is one
assign respTxTriggerMethod   = respIsTB && rxTriggerMethod;

// If the response frame is CTS in response to an trigger frame,
//    the response triggerResponding is '1'
assign respTxTriggerResponding = respIsTBCTS;

assign respTxRUToneSetIndex  = 7'd0;                                             //ToDo:11ax
assign respTxFeedBackStatus  = 1'd0;                                             //ToDo:11ax

// If the response frame is a HE-TB
//    the response Beam Change is '1'
// If the response frame is not a HE-TB
//    the response Beam Change is '0'
assign respTxBeamChange = respIsTB;


// Available channel bitmap
assign pri20Idle = ~channelBusy & ~macPhyIfRxCca;
assign sec20Idle = ~channelBusy & ~macPhyIfRxCcaSec20 & maxSupportedBW>=2'b01;
assign sec40Idle = ~channelBusy & ~macPhyIfRxCcaSec40 & maxSupportedBW>=2'b10;

always @*
begin
  case (primaryChPosition)
  3'd0:    acBitmap = {4'b0, sec40Idle, sec40Idle, sec20Idle, pri20Idle      };
  3'd1:    acBitmap = {4'b0, sec40Idle, sec40Idle, pri20Idle, sec20Idle      };
  3'd2:    acBitmap = {4'b0, sec20Idle, pri20Idle, sec40Idle, sec40Idle      };
  3'd3:    acBitmap = {4'b0, pri20Idle, sec20Idle, sec40Idle, sec40Idle      };
  3'd4:    acBitmap = {      sec40Idle, sec40Idle, sec20Idle, pri20Idle, 4'b0};
  3'd5:    acBitmap = {      sec40Idle, sec40Idle, pri20Idle, sec20Idle, 4'b0};
  3'd6:    acBitmap = {      sec20Idle, pri20Idle, sec40Idle, sec40Idle, 4'b0};
  default: acBitmap = {      pri20Idle, sec20Idle, sec40Idle, sec40Idle, 4'b0};
  endcase
end


// Inidicats that Uplink Power Headroom Control field must be transmitted
`ifdef  RW_BFMEE_EN
assign txUPHControl = respIsTB & ~disableTBUPH & expectedResp==RESP_TYPE_BQR |
                      respIsTB & ~disableTBUPH & expectedResp==RESP_TYPE_BFR;
`else //RW_BFMEE_EN
assign txUPHControl = respIsTB & ~disableTBUPH & expectedResp==RESP_TYPE_BQR;
`endif//RW_BFMEE_EN


// Indicates the Uplink Power Headroom Control value
assign tbTxPwrHeadroom = ofdmMaxPwrLevel-tbTxPwrLevel;

assign ulPwrHeadroom   = |tbTxPwrHeadroom[7:5] ? {tbTxPwrLevelMin,5'd31               }: 
                                                 {tbTxPwrLevelMin,tbTxPwrHeadroom[4:0]};

// Indicates the Uplink Power Headroom Control value in response to trigger frame
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    heTBUPHControl  <= 8'd0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    heTBUPHControl  <= 8'd0; 
  else if (rxTriggerHWValid_p | rxTriggerSWValid_p)
    heTBUPHControl  <= {2'b00/*reserved*/,ulPwrHeadroom};
end


////////////////////////////////////////////////////////////////////////////////
// TX Time Calculation signals assignment
////////////////////////////////////////////////////////////////////////////////

// Delay the timeOnAirValidMC signal of one clock cycle
// This signal is used to detect the rising edge and create /home/blauret/bt_eclipse_workspacethe timeOnAirDone_p pulse.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    timeOnAirValidMC_ff1 <= 1'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    timeOnAirValidMC_ff1 <= 1'b0; 
  else
    timeOnAirValidMC_ff1 <= timeOnAirValidMC; 
end

// Generation of timeOnAirDone_p pulse which indicated the completion of the TX Tim computing.
assign timeOnAirDone_p = timeOnAirValidMC && !timeOnAirValidMC_ff1;



// If a frame is received in HT_MM and the current duration computing is for TXTIME (macControllerRxFSMCs == COMP_DURATION_RX_MM), 
//   the duration is computed on rxHTLength,
// If a frame is received in HT_MM and the current duration computing is for Legacy duration (macControllerRxFSMCs == COMP_DURATION_RX_LEG), 
//   the duration is computed on rxLegLength,
// If a frame containing a TSF (Beacon or ProbResponse) is received (macControllerRxFSMCs == COMP_DURATION_TFS set), 
//   the duration is computed payload length without MAC Header (24 bytes),
// else
//   if the received frame does not expect response (expectedResp == RESP_TYPE_NONE), 
//     the length is set to 14 to enable CTS or ACK duration computing if required
//     (to update the nav in case of not Mine RTS or not Mine PSPOLL)
//   else it is computed on the entire frame length
always @ *
begin
  if (macControllerRxFSMCs == COMP_DURATION_RX_MM)
    ppduLengthMCRx = rxHTLength;
  else if (macControllerRxFSMCs == COMP_DURATION_RX_LEG)
    ppduLengthMCRx = {8'b0,rxLegLength}; 
  else if (macControllerRxFSMCs == COMP_DURATION_TFS)
  begin
    if (rxFrameIsHT)
      ppduLengthMCRx = rxHTLength - 20'd24;
    else
      ppduLengthMCRx = {8'b0,rxLegLength} - 20'd24;
  end      
  else
    ppduLengthMCRx = (expectedResp == RESP_TYPE_NONE) ? 20'd14 : ((respTxFormatMod == HE_TB)  && ~rxTriggerMethod) ? {6'b0,rxTriggerULLength} : txRespLength;
end

// If the current duration computing is for the TXTIME of the response, ppduBWMCRx takes the bandwidth of the response frame.
// Else it takes the bandwidth of the received frame
always @ *
begin
  if (macControllerRxFSMCs == COMP_DURATION_RESP)
    ppduBWMCRx = txChBWRxC;
  else
    ppduBWMCRx = rxChBW;
end


// If a frame is received in HT_MM and the current duration computing is for TXTIME (macControllerRxFSMCs == COMP_DURATION_RX_MM), 
//   the duration is computed with a HT_MM preamble,
// If a frame is received in HT_MM and the current duration computing is for Legacy duration (macControllerRxFSMCs == COMP_DURATION_RX_LEG), 
//   the duration is computed with a OFDM preamble
// If a frame containing a TSF (Beacon or ProbResponse) is received (macControllerRxFSMCs == COMP_DURATION_TFS), 
//   the ppduPreTypeMCRx takes the preamble Type 0 but this computqation is done without preamble. So it is not used.
// If the frame received was an HT frame (rxFormatMod >=2), ppduPreTypeMCRx takes the rxFormatMod value (MM or GF). Else it takes the 
//   rxPreType value (Long or Short).
// else
//   If the response frame is a NON-HT frame (respTxFormatMod<2), ppduPreTypeMC takes the value of respTxPreType (short or long preamble)
//   else it takes HT-MF value (the HT-GF is not supported in transmit).
always @ *
begin
  if (macControllerRxFSMCs == COMP_DURATION_RX_MM)
    ppduPreTypeMCRx = 4'b0010;
  else if (macControllerRxFSMCs == COMP_DURATION_RX_LEG)
    ppduPreTypeMCRx = 4'b0000; 
  else if (macControllerRxFSMCs == COMP_DURATION_TFS)
    ppduPreTypeMCRx = (rxFormatMod <= 4'd1) ? {3'b0,rxPreType} : rxFormatMod; 
  else
    ppduPreTypeMCRx = (respTxFormatMod == NON_HT          ||              
                       respTxFormatMod == NON_HT_DUP_OFDM)              ? {3'b0,respTxPreType} :
                      (respTxFormatMod == VHT            )              ? 4'b0100:
                      (respTxFormatMod == HE_SU          )              ? 4'b0101:
                      ((respTxFormatMod == HE_TB)  && ~rxTriggerMethod) ? 4'b0000:
                      ((respTxFormatMod == HE_TB)  && rxTriggerMethod)  ? 4'b1000:
                                                                          4'b0010;
end

// If the current duration computing is for the TXTIME of the response, 
//   ppduNumExtnSSMCRx takes the Number of Extended Spacial Stream of the response frame.
// Else it takes the Number if Extended Spacial Stream of the received frame
always @ *
begin
  if (macControllerRxFSMCs == COMP_DURATION_RESP)
    ppduNumExtnSSMCRx = respTxNumExtnSS;
  else 
    ppduNumExtnSSMCRx = rxNumExtnSS;
end

// If the current duration computing is for the TXTIME of the response, 
//   ppduSTBCMCRx takes 0. (the duration of the STBC response is given by the register ctsSTBCDur
// Else it takes the STBC information of the received frame
always @ *
begin
  if (ap && dualCTSProt && (expectedResp == RESP_TYPE_CTS) && (macControllerRxFSMCs == COMP_DURATION_RESP))
    ppduSTBCMCRx = 1'b0;
  else if (macControllerRxFSMCs == COMP_DURATION_RESP)
    ppduSTBCMCRx = 1'b0; // todo. In 2x2, Response can be STBC
  else 
    ppduSTBCMCRx = rxSTBC;
end

// If a frame is received in HT_MM and the current duration computing is for TXTIME (macControllerRxFSMCs == COMP_DURATION_RX_MM), 
//   the duration is computed with the ShortGI of the received frame,
// If a frame is received in HT_MM and the current duration computing is for Legacy duration (macControllerRxFSMCs == COMP_DURATION_RX_LEG), 
//   the duration is computed without ShortGI
// If a frame containing a TSF (Beacon or ProbResponse) is received (macControllerRxFSMCs == COMP_DURATION_TFS), 
//   the duration is computed with the ShortGI of the received frame,
// else
//   If the response frame is an HT Frame, ppduGITypeMCRx takes the value of respTxGIType (short or normal Guard interval)
//   else the Guard Interval is forced to 0 (Normal GI)
always @ *
begin
  if (macControllerRxFSMCs == COMP_DURATION_RX_MM)
    ppduGITypeMCRx = rxGIType;
  else if (macControllerRxFSMCs == COMP_DURATION_RX_LEG)
    ppduGITypeMCRx = 2'b0; 
  else if (macControllerRxFSMCs == COMP_DURATION_TFS)
    ppduGITypeMCRx = rxGIType;
  else 
    ppduGITypeMCRx = (respTxFormatMod >= 4'd2) ? respTxGIType : 2'b0;
end

// If a frame is received in HT_MM and the current duration computing is for TXTIME (macControllerRxFSMCs == COMP_DURATION_RX_MM), 
//   the duration is computed with the received MCS
// If a frame is received in HT_MM and the current duration computing is for Legacy duration (macControllerRxFSMCs == COMP_DURATION_RX_LEG), 
//   the duration is computed with the received LegRate
// If a frame containing a TSF (Beacon or ProbResponse) is received (macControllerRxFSMCs == COMP_DURATION_TFS), 
//   If the frame received was an HT frame (rxFrameIsHT >=2), ppduMCSIndexMC takes the rxMCS value (HT Rate).
//   else it takes the rxLegRateConv value (non-HT rate).
// else
//   If the response is an HT frame (respTxFormatMod >=2), ppduMCSIndexMC takes the mcsRESP value (HT Rate). 
//   else it takes the legRateRESP value (non-HT rate).
always @ *
begin
  if (macControllerRxFSMCs == COMP_DURATION_RX_MM)
    ppduMCSIndexMCRx = {1'b1,rxMCS};
  else if (macControllerRxFSMCs == COMP_DURATION_RX_LEG)
    ppduMCSIndexMCRx = {4'b0, rxLegRateConv}; 
  else if (macControllerRxFSMCs == COMP_DURATION_TFS)
    ppduMCSIndexMCRx = (rxFrameIsHT) ? {1'b1, rxMCS} : {4'b0, rxLegRateConv};
  else
    //ppduMCSIndexMCRx = (respTxFormatMod >= 3'd2) ? {1'b1,mcsRESP} : {4'b0,legRateRESP};
    ppduMCSIndexMCRx =  (respTxFormatMod == HE_TB  && ~rxTriggerMethod) ? {4'b0, 4'd4} : respTxMCSIndex;
end

// HE LTF Type 
//   The duration is computed with HE LTF Type of the response
always @*
begin
   ppduHELTFTypeMCRx       = respTxHELTFType;
end

// Number of HE LTF
//   The duration is computed with number of HE LTF of the response
always @*
begin
   ppduNumHeLtfMCRx        = respTxNumHeLtf;
end

// DCM (not supported)
assign ppduDCMMCRx         = 1'b0;

// Trigger Method
always @*
begin
   ppduTriggerMethodMCRx   = respTxTriggerMethod;
end

// Doppler
always @*
begin
   ppduDopplerMCRx         = respTxDoppler;
end

// Midamble periodicity
assign ppduMmaMCRx         = respTxMidamble;

// Type of RU
always @*
begin
   if (respTxRUAllocation[7:1] <= 7'd36 & ~respTxRUAllocation[0])
      // 26-tone RU
      ppduRuTypeMCRx = 3'd0;
   else if (respTxRUAllocation[7:1] <= 7'd52 & ~respTxRUAllocation[0])
      // 52-tone RU
      ppduRuTypeMCRx = 3'd1;
   else if (respTxRUAllocation[7:1] <= 7'd60 & ~respTxRUAllocation[0])
      // 106-tone RU
      ppduRuTypeMCRx = 3'd2;
   else if (respTxRUAllocation[7:1] <= 7'd64 & ~respTxRUAllocation[0])
      // 242-tone RU or 20MHz BW
      ppduRuTypeMCRx = 3'd3;
   else if (respTxRUAllocation[7:1] <= 7'd66 & ~respTxRUAllocation[0])
      // 484-tone RU or 40MHz BW
      ppduRuTypeMCRx = 3'd4;
   else
      // 996-tone RU or 80MHz BW
      ppduRuTypeMCRx = 3'd5;
end

// Packet Extension
always @*
begin
   ppduPacketExtensionMCRx = respTxPacketExtension;
end

// Length of the HE TB PPDU
//   Indicates the length of the HE TB PPDU response to an URMS trigger
always @*
begin
   ppduHeTbLengthMCRx = rxTRSLength;
end

// Indicates to the TX Time Computing that the duration has to be computed without preamble duration.
// This is the case for the MAC Header duration and for Legacy Duration.
assign woPreambleMCRx = ((macControllerRxFSMCs == COMP_DURATION_TFS) || (macControllerRxFSMCs == COMP_DURATION_RX_LEG)) ? 1'b1 : 1'b0;


// When the FSM moves to COMP_DURATION_RESP or COMP_DURATION_TFS, the macControllerRx launches a time on air computation to the TX TIME Module.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    startComputationMCRx_p <= 1'b0;
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    startComputationMCRx_p <= 1'b0; 
  else if (((macControllerRxFSMCs != macControllerRxFSMPs) && 
           ((macControllerRxFSMCs == COMP_DURATION_RESP) || 
            (macControllerRxFSMCs == COMP_DURATION_RX_MM) || 
            (macControllerRxFSMCs == COMP_DURATION_RX_LEG) || 
            (macControllerRxFSMCs == COMP_DURATION_TFS))))
    startComputationMCRx_p <= 1'b1;
  else   
    startComputationMCRx_p <= 1'b0;
end

////////////////////////////////////////////////////////////////////////////////
// L-SIG Length and Duration 
////////////////////////////////////////////////////////////////////////////////

// L_LENGTH (legLengthComputed) and L_DATARATE determine the duration that non-HT STAs will not transmit, equal to the
// remaining duration of the HT PPDU or the L-SIG Duration when L-SIG TXOP protection is used as defined
// in 9.13.5, following the non-HT portion of the preamble of the HT-mixed format PPDU.
//
// The L_DATARATE parameter of the TXVECTOR shall be set to the value 6 Mb/s.
//
// A STA that is transmitting a PPDU with the FORMAT parameter of the TXVECTOR set to HT_MF, and that
// is not operating by the L-SIG TXOP protection rules described in 9.13.5 (lSIGTXOPDetected = 0) shall set the value of the L_LENGTH
// parameter to the value (in units of octets) given by Equation (9-1) :
//
// L_LENGTH = ((TXTIME - Signal Extension) - (aPreambleLength + aPLCPHeaderLength))*NOPS/aSymbolLength - (aPLCPServiceLength + aPLCPConvolutionalTailLength)/8
// 
//
// A STA that is transmitting a PPDU with the FORMAT parameter of the TXVECTOR set to HT_MF, and that
// is not operating by the L-SIG TXOP protection rules described in 9.13.5 (lSIGTXOPDetected = 1) shall set the value of the L_LENGTH
// parameter to the value (in units of octets) given by Equation (9-1) :
//
// L_LENGTH (legLengthComputed) = (lSIGDuration - signalExtension) * NOPS/aSymbolLength - (aPLCPServiceLength + aPLCPConvolutionalTailLength)/8 
//
// where :
//   NOPS is the number of octets transmitted during a period of aSymbolLength at
//        the rate specified by L_DATARATE
// 
//   aPLCPServiceLength is the number of bits in the PLCP SERVICE field (16 bits)
//                     
//   aPLCPConvolutionalTailLength is the number of bits in the convolutional code tail bit sequence (6 bits)
//   
//   aSymbolLength is the duration of symbol, 4us
//
// if  (lSIGTXOPDetected = 0)
// legLengthComputed = (TXTIME - signalExtension - 20)*3/4 - 3
// 
// if  (lSIGTXOPDetected = 1)
// legLengthComputed = (lSIGDuration - signalExtension)*3/4 - 3
//
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    legLengthComputed <= 16'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || rxExchangeCompleted_p)  // Synchronous Reset
    legLengthComputed <= 16'b0;
  else if (macControllerRxFSMCs != IDLE)
  begin
    if ((respTxFormatMod == HT_MM) || (respTxFormatMod == VHT))
    begin
      if (lSIGTXOPDetected)
      begin
        if (lSIGDurationInt[1:0] != 2'b0)
          // if lSIGDurationInt[1:0] !=0, the rounding is done by adding 3. So, the -3 disappears
          legLengthComputed <= {1'b0,lSIGDurationInt[15:2],1'b0} + {2'b0,lSIGDurationInt[15:2]}; 
        else  
          legLengthComputed <= {1'b0,lSIGDurationInt[15:2],1'b0} + {2'b0,lSIGDurationInt[15:2]} - 16'd3;
      end
      else if ((macControllerRxFSMCs == TX_STBC_RESP) || (macControllerRxFSMCs == TX_RESP))
      begin
        if (txTimeInt[1:0] != 2'b0)
          // if txTimeInt[1:0] !=0, the rounding is done by adding 3. So, the -3 disappears
          legLengthComputed <= {1'b0,txTimeInt[15:2],1'b0} + {2'b0,txTimeInt[15:2]};
        else  
          legLengthComputed <= {1'b0,txTimeInt[15:2],1'b0} + {2'b0,txTimeInt[15:2]} - 16'd3;
      end    
    end
    else if (respTxFormatMod==HE_SU || respTxFormatMod==HE_TB)
    begin
      // legLengthComputed = (TXTIME - signalExtension - 20)*3/4 - 3 - 2
      if ((macControllerRxFSMCs == TX_STBC_RESP) || (macControllerRxFSMCs == TX_RESP))
      begin
        if (txTimeInt[1:0] != 2'b0)
          // if txTimeInt[1:0] !=0, the rounding is done by adding 3. So, the -3 disappears
          legLengthComputed <= {1'b0,txTimeInt[15:2],1'b0} + {2'b0,txTimeInt[15:2]} - 16'd2;
        else  
          legLengthComputed <= {1'b0,txTimeInt[15:2],1'b0} + {2'b0,txTimeInt[15:2]} - 16'd5;
      end    
    end
    else if (respTxFormatMod==HE_EXT_SU)
    begin
      // legLengthComputed = (TXTIME - signalExtension - 20)*3/4 - 3 - 1
      if ((macControllerRxFSMCs == TX_STBC_RESP) || (macControllerRxFSMCs == TX_RESP))
      begin
        if (txTimeInt[1:0] != 2'b0)
          // if txTimeInt[1:0] !=0, the rounding is done by adding 3. So, the -3 disappears
          legLengthComputed <= {1'b0,txTimeInt[15:2],1'b0} + {2'b0,txTimeInt[15:2]} - 16'd1;
        else  
          legLengthComputed <= {1'b0,txTimeInt[15:2],1'b0} + {2'b0,txTimeInt[15:2]} - 16'd4;
      end    
    end
    else    
      legLengthComputed <= 16'b0;
  end    
end

// TXTIME without the preamble duration (and signal extension if any)
assign txTimeWoPreamble = (timeOnAirMC - {13'd0,signalExtension} - 16'd20);

// CTS STBC Duration without the preamble duration
assign ctsSTBCDurWoPreamble = ({8'd0,ctsSTBCDur} - 16'd20);

// txTimeInt is the result of (TXTIME - signalExtension - 20)
// It is used in the previous process to compute the L_LENGTH for the response
// In case of STBC Response, timeOnAir is replaced by ctsSTBCDur from register.
assign txTimeInt       = ((macControllerRxFSMCs == TX_STBC_RESP) && (ap && dualCTSProt && (expectedResp == RESP_TYPE_CTS))) ? 
                          ctsSTBCDurWoPreamble : 
                          txTimeWoPreamble;

// lSIGDurationInt is the result of (lSIGDuration - signalExtension)
// It is used in the previous process to compute the L_LENGTH for the response
assign lSIGDurationInt = lSIGDuration - {13'd0,signalExtension};

// 9.13.5.3 L-SIG TXOP protection rules at the TXOP responder
// On receiving a PPDU containing an L-SIG Duration addressed to itself, a TXOP responder that set the L-SIG
// TXOP Protection Support field to 1 on association shall generate an L-SIG TXOP Protection response frame
// with the L-SIG Duration equivalent to:
//  L-SIG Duration = (TMACDur - SIFS - (aPreambleLength + aPLCPHeaderLength))
//
// where :
//   TMACDur is the Duration/ID value carried in the MAC Header of frame(s) received in the PPDU that
//   generated the response
//   aPreambleLength +  aPLCPHeaderLength = 20 us
//
// If the rxFrameDuration is smaller or equal to SIFS + (aPreambleLength + aPLCPHeaderLength), the lSIGDuration is forced to 0
assign lSIGDuration = (!rxFrameDuration[15] && (rxFrameDuration > {8'b0,sifs} + 16'd20)) ? (rxFrameDuration - {8'b0,sifs} - 16'd20) : 16'b0; //$todo DualCTS case to be handled

// Set lSIGTXOPDetected when a L_SIG TXOP is detected on the received frame.
// A LSIG TXOP is detected when the  duration value determined from the L_DATARATE 
// and L_LENGTH parameters rounded up to a multiple of aSymbolLength that is not equal to the 
// remaining duration of the frame
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    lSIGTXOPDetected <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    lSIGTXOPDetected <= 1'b0;
  else
  begin
    if ((macControllerRxFSMCs == RX_FRAME) && lsigCheckDone)
    begin
//       if (rxLSIGValid && (rxFrameHTDuration < (rxFrameLegDuration+16'd15)))
      if (supportLSTP && rxLSIGValid && (rxFrameHTDuration < rxFrameLegDuration))
      begin
        lSIGTXOPDetected <= 1'b1;
      end
      else
        lSIGTXOPDetected <= 1'b0;
    end    
  end    
end

// Captured the computed Duration based on received L_DATARATE 
// and L_LENGTH parameters.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    rxFrameLegDuration <= 16'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || rxExchangeCompleted_p)  // Synchronous Reset
    rxFrameLegDuration <= 16'b0;
  else if (macControllerRxFSMCs != IDLE)
  begin
    if ((macControllerRxFSMCs == COMP_DURATION_RX_LEG) && timeOnAirDone_p)
        rxFrameLegDuration <= timeOnAirMC;
  end    
end

// Captured the computed Duration based on received HT_DATARATE 
// and HT_LENGTH parameters.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    rxFrameHTDuration <= 16'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || rxExchangeCompleted_p)  // Synchronous Reset
    rxFrameHTDuration <= 16'b0;
  else if (macControllerRxFSMCs != IDLE)
  begin
    if ((macControllerRxFSMCs == COMP_DURATION_RX_MM) && timeOnAirDone_p)
        rxFrameHTDuration <= timeOnAirMC;
  end    
end

// Captured the computed Duration based on received HT_DATARATE 
// and HT_LENGTH parameters.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    lsigCheckDone <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    lsigCheckDone <= 1'b0;
  else
  begin
    if ((macControllerRxFSMCs == COMP_DURATION_RX_MM) && timeOnAirValidMC)
        lsigCheckDone <= 1'b1;
  end    
end

////////////////////////////////////////////////////////////////////////////////
// NAV Interface control
////////////////////////////////////////////////////////////////////////////////

// PSPoll Reception capture
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    notMinePsPollRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    notMinePsPollRcved <= 1'b0; 
  else
  begin
    if (notMinePsPollRcved_p)
      notMinePsPollRcved<= 1'b1; 
  end
end  

// RTS Reception capture
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    notMineRtsRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    notMineRtsRcved <= 1'b0; 
  else
  begin
    if (notMineRtsRcved_p)
      notMineRtsRcved<= 1'b1; 
  end
end  

// MU-RTS Reception capture
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    notMineMURtsRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    notMineMURtsRcved <= 1'b0; 
  else
  begin
    if (notMineMURtsRcved_p)
      notMineMURtsRcved<= 1'b1; 
  end
end  

// Beacon/Prob Response Reception capture
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    tsfRcved <= 1'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    tsfRcved <= 1'b0; 
  else
  begin
    if (bcnRcved_p || probRespRcved_p)
      tsfRcved<= 1'b1; 
    else if (macControllerRxFSMCs == COMP_DURATION_RESP)  
      tsfRcved<= 1'b0; 
  end
end  

// Provide duration information to the NAV block in case of incorrect reception.
assign ctsDuration         = timeOnAirMC;
assign ctsDurationValid_p  = ((notMineRtsRcved   && timeOnAirValidMC) ||
                              (notMineMURtsRcved && timeOnAirValidMC)) ? 1'b1 : 1'b0; 
assign ackDuration         = timeOnAirMC;        
assign ackDurationValid_p  = (notMinePsPollRcved && timeOnAirValidMC) ? 1'b1 : 1'b0;

// Compute LSIG Duration for NAV in case of HT_MM with FCS error.
// navLsigDuration  = Legacy frame duration - HT frame duration + Legacy preamble duration
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    navLsigDuration <= 16'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || rxExchangeCompleted_p)  // Synchronous Reset
    navLsigDuration <= 16'b0; 
  else if (macControllerRxFSMCs != IDLE)
  begin  
    if ((macControllerRxFSMNs == RX_FRAME) && (macControllerRxFSMCs == COMP_DURATION_RX_MM))
      navLsigDuration <= rxFrameLegDuration - timeOnAirMC + 16'd20;
  end  
end


// Provide duration from the end of the MAC Header until the end of the received Beacon or Prob Response frame.
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    frmDurWithoutMH <= 16'b0; 
  else if ((macCoreClkSoftRst_n == 1'b0) || rxExchangeCompleted_p)  // Synchronous Reset
    frmDurWithoutMH <= 16'b0; 
  else if (macControllerRxFSMCs != IDLE)
  begin
    if ((macControllerRxFSMCs == COMP_DURATION_TFS) && timeOnAirDone_p)
      frmDurWithoutMH <= timeOnAirMC; 
  end
end  



// Assign phyRxStartDelay duration based on the preamble type of the received frame.
// This signal is valid on ctsDurationValid_p pulse and indicates the PHY Start delay of the expected CTS
always @ *
begin
  if (rxFrameIsHT)
    phyRxStartDelay = rxStartDelayMIMO;
  else if (rxLegRateConv > 4'd3)
    phyRxStartDelay = rxStartDelayOFDM;
  else if (rxPreType)
    phyRxStartDelay = rxStartDelayLong;
  else  
    phyRxStartDelay = rxStartDelayShort;
end


////////////////////////////////////////////////////////////////////////////////
// Dynamic Bandwidth Support
////////////////////////////////////////////////////////////////////////////////

//  A VHT STA that is addressed by an RTS frame in a non-HT or non-HT duplicate PPDU that has a bandwidth
//  signaling TA and that has the RXVECTOR parameter DYN_BANDWIDTH_IN_NON_HT equal to Static,
//  behaves as follows:
//  - If the NAV indicates idle and CCA has been idle for all secondary channels (secondary 20 MHz
//  channel, secondary 40 MHz channel and secondary 80 MHz channel) in the channel width indicated
//  by the RTS frame's RXVECTOR parameter CH_BANDWIDTH_IN_NON_HT for a PIFS period
//  prior to the start of the RTS frame, then the STA shall respond with a CTS frame carried in a non-HT
//  or non-HT duplicate PPDU after a SIFS period. The CTS frame's TXVECTOR parameters
//  CH_BANDWIDTH and CH_BANDWIDTH_IN_NON_HT shall be set to the same value as the
//  RTS frame's RXVECTOR parameter CH_BANDWIDTH_IN_NON_HT.
//  - Otherwise the STA shall not respond with a CTS frame.
//
//  A VHT STA that is addressed by an RTS frame in a non-HT or non-HT duplicate PPDU that has a bandwidth
//  signaling TA and that has the RXVECTOR parameter DYN_BANDWIDTH_IN_NON_HT equal to Dynamic,
//  behaves as follows:
//   - If the NAV indicates idle, then the STA shall respond with a CTS frame in a non-HT or non-HT
//  duplicate PPDU after a SIFS period. The CTS frame's TXVECTOR parameters CH_BANDWIDTH
//  and CH_BANDWIDTH_IN_NON_HT may be set to any channel width for which CCA on all secondary
//  channels has been idle for a PIFS prior to the start of the RTS frame and that is equal to or
//  less than the channel width indicated in the RTS frame's RXVECTOR parameter
//  CH_BANDWIDTH_IN_NON_HT.
//    - Otherwise the STA shall not respond with a CTS frame.
//
//  A non-VHT STA that is addressed by an RTS frame or a VHT STA that is addressed by an RTS frame carried
//  in a non-HT or non-HT duplicate PPDU that has a non-bandwidth signaling TA or a VHT STA that is addressed
//  by an RTS frame in a format other than non-HT or non-HT duplicate behaves as follows:
//    - If the NAV indicates idle, the STA shall respond with a CTS frame after a SIFS period.
//    - Otherwise, the STA shall not respond with a CTS frame

// This process computes the bandwith of the response in case of DYN_BANDWIDTH_IN_NON_HT equal to Dynamic
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    txChBWInt <= 2'd0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    txChBWInt <= 2'd0;
  else if (dynBWEn)
  begin  
    if (rxBWSignalingTA && ((!rxAggregation && correctRcved_p) || (rxAggregation && ampduCorrectRcved_p)))
    begin
      if (rxDynBWInNonHT)
      begin
        if (availableBW < rxChBWInNonHT) 
          txChBWInt <= availableBW;
        else
          txChBWInt <= rxChBWInNonHT;
      end
      else
        txChBWInt  <= rxChBWInNonHT;   
    end
    else if ((!rxAggregation && correctRcved_p) || (rxAggregation && ampduCorrectRcved_p))
      txChBWInt  <= rxChBW;   
  end
  else if ((!rxAggregation && correctRcved_p) || (rxAggregation && ampduCorrectRcved_p))
    txChBWInt  <= rxChBW;   
end
    

// If the response frame is a CTS in reponse to an MU-RTS,
//    the BW of the response is extracted from the MU_RTS
// If the response frame is Trigger Based frame in reponse to a trigger frame,
//    the BW of the response is extracted from the Trigger frame.
// If the response frame is Trigger Based frame in reponse to a frame with TRS,
//    the BW of the response is the bandwidth of the received frame with TRS
// If the response frame is in HT,
//    the BW of the response is limited to 40Mhz or the maximum supported BW
// else
//    the BW of the response is limited to the maximum supported BW
always @*
begin
   if (notMineMURtsRcved)
      txChBWRxC = rxTriggerULBW;
   else if (respIsTBCTS &&  rxTriggerRUAllocIndex[67])
      txChBWRxC = 2'd2;
   else if (respIsTBCTS && |rxTriggerRUAllocIndex[66:65])
      txChBWRxC = 2'd1;
   else if (respIsTBCTS)
      txChBWRxC = 2'd0;
   else if (respIsTB && ~rxTriggerMethod)
      txChBWRxC = rxTriggerULBW;
   else if (respIsTB &&  rxTriggerMethod)
      txChBWRxC = txChBWInt;
   else if ((respTxFormatMod == HT_MM) && (txChBWInt >= 2'd2) && (maxSupportedBW!=2'd0))
      txChBWRxC = 2'd1;
   else if (txChBWInt > maxSupportedBW)
      txChBWRxC = maxSupportedBW;
   else
      txChBWRxC = txChBWInt;
end

// Check if the dynamic bandwidth selection fails in case of DYN_BANDWIDTH_IN_NON_HT equal to Static
// It fails if the bandwidth available is lower than the requested (availableBW < rxChBW)
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    respBWFail <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (macControllerRxFSMCs == IDLE))  // Synchronous Reset
    respBWFail <= 1'b0;
  else if (dynBWEn)
  begin  
    if ((!rxAggregation && correctRcved_p) || (rxAggregation && ampduCorrectRcved_p))
    begin
      if (rxBWSignalingTA && !rxDynBWInNonHT && (availableBW < rxChBWInNonHT)) 
        respBWFail <= 1'b1;
      else
        respBWFail <= 1'b0;
    end
  end
end


assign txBWSignalingRxC = (!respBWFail) ? rxBWSignalingTA : 1'b0;

// If the BW Signaling is used for the current reception (in this case, RTS reception), the flag rxDynBWInNonHT coming from the rxVector is 
// provided to the Tx Controller 
assign txDynBWRxC = (txBWSignalingRxC) ? rxDynBWInNonHT : 1'b0;


////////////////////////////////////////////////////////////////////////////////
// Trigger Based Frame Control
////////////////////////////////////////////////////////////////////////////////
always @*
begin
   rxTriggerRUAllocIndex = 69'h1;
   if (rxTriggerRUAllocation[7]) rxTriggerRUAllocIndex = rxTriggerRUAllocIndex<<64;
   if (rxTriggerRUAllocation[6]) rxTriggerRUAllocIndex = rxTriggerRUAllocIndex<<32;
   if (rxTriggerRUAllocation[5]) rxTriggerRUAllocIndex = rxTriggerRUAllocIndex<<16;
   if (rxTriggerRUAllocation[4]) rxTriggerRUAllocIndex = rxTriggerRUAllocIndex<<8;
   if (rxTriggerRUAllocation[3]) rxTriggerRUAllocIndex = rxTriggerRUAllocIndex<<4;
   if (rxTriggerRUAllocation[2]) rxTriggerRUAllocIndex = rxTriggerRUAllocIndex<<2;
   if (rxTriggerRUAllocation[1]) rxTriggerRUAllocIndex = rxTriggerRUAllocIndex<<1;
end

// Trigger Based RU allocation in BW
// Note: ruAllocation 18 is between two 20MHz band, both band are used for busy
//       detection
always @*
begin
   rxTriggerRUAllocInBW[0] = (|rxTriggerRUAllocIndex[8:0]  ) | //  26-tones RU
                             (|rxTriggerRUAllocIndex[40:37]) | //  52-tones RU
                             (|rxTriggerRUAllocIndex[54:53]) | // 106-tones RU
                             (|rxTriggerRUAllocIndex[61]   ) | // 242-tones RU
                             (|rxTriggerRUAllocIndex[65]   ) | // 484-tones RU
                             (|rxTriggerRUAllocIndex[67]   ) ; // 996-tones RU

   rxTriggerRUAllocInBW[1] = (|rxTriggerRUAllocIndex[18:9] ) | //  26-tones RU
                             (|rxTriggerRUAllocIndex[44:41]) | //  52-tones RU
                             (|rxTriggerRUAllocIndex[56:55]) | // 106-tones RU
                             (|rxTriggerRUAllocIndex[62]   ) | // 242-tones RU
                             (|rxTriggerRUAllocIndex[65]   ) | // 484-tones RU
                             (|rxTriggerRUAllocIndex[67]   ) ; // 996-tones RU

   rxTriggerRUAllocInBW[2] = (|rxTriggerRUAllocIndex[27:18]) | //  26-tones RU
                             (|rxTriggerRUAllocIndex[48:45]) | //  52-tones RU
                             (|rxTriggerRUAllocIndex[58:57]) | // 106-tones RU
                             (|rxTriggerRUAllocIndex[63]   ) | // 242-tones RU
                             (|rxTriggerRUAllocIndex[66]   ) | // 484-tones RU
                             (|rxTriggerRUAllocIndex[67]   ) ; // 996-tones RU

   rxTriggerRUAllocInBW[3] = (|rxTriggerRUAllocIndex[36:28]) | //  26-tones RU
                             (|rxTriggerRUAllocIndex[52:49]) | //  52-tones RU
                             (|rxTriggerRUAllocIndex[60:59]) | // 106-tones RU
                             (|rxTriggerRUAllocIndex[64]   ) | // 242-tones RU
                             (|rxTriggerRUAllocIndex[66]   ) | // 484-tones RU
                             (|rxTriggerRUAllocIndex[67]   ) ; // 996-tones RU
end


// Primary Channel Position in the HE-TB
always @*
begin
   case (rxTriggerULBW)
   2'b00:   heTBPrimaryCh = primaryChPosition & 3'b000;
   2'b01:   heTBPrimaryCh = primaryChPosition & 3'b001;
   2'b10:   heTBPrimaryCh = primaryChPosition & 3'b011;
   default: heTBPrimaryCh = primaryChPosition & 3'b111;
   endcase
end


// CCA In bandwidth
always @*
begin
   casex ({maxSupportedBW,heTBPrimaryCh[1:0]})
   // Max bandwidth 20Mhz
   {2'b00,2'bxx}: ccaInBW = {4{macPhyIfRxCca}};
   // Max bandwidth 40Mhz
   {2'b01,2'bx0}: ccaInBW = {2{macPhyIfRxCcaSec20,macPhyIfRxCca}};
   {2'b01,2'bx1}: ccaInBW = {2{macPhyIfRxCca,macPhyIfRxCcaSec20}};
   // Max bandwidth 80Mhz
   {2'b10,2'b00}: ccaInBW = {macPhyIfRxCcaSec40,macPhyIfRxCcaSec40,macPhyIfRxCcaSec20,macPhyIfRxCca};
   {2'b10,2'b01}: ccaInBW = {macPhyIfRxCcaSec40,macPhyIfRxCcaSec40,macPhyIfRxCca,macPhyIfRxCcaSec20};
   {2'b10,2'b10}: ccaInBW = {macPhyIfRxCcaSec20,macPhyIfRxCca,macPhyIfRxCcaSec40,macPhyIfRxCcaSec40};
   {2'b10,2'b11}: ccaInBW = {macPhyIfRxCca,macPhyIfRxCcaSec20,macPhyIfRxCcaSec40,macPhyIfRxCcaSec40};
   // Unsupported BW
   default:       ccaInBW = 4'b1111;
   endcase
end


// Detect occupation of the RU allocated to the trigger based response 
always @*
begin
   if (ccaInBW[0] & rxTriggerRUAllocInBW[0] |
       ccaInBW[1] & rxTriggerRUAllocInBW[1] |
       ccaInBW[2] & rxTriggerRUAllocInBW[2] |
       ccaInBW[3] & rxTriggerRUAllocInBW[3] )
      respRUFail = 1'b1;
   else
      respRUFail = 1'b0;
end


////////////////////////////////////////////////////////////////////////////////
// Software Trigger Based Response Control
////////////////////////////////////////////////////////////////////////////////

// rxSWTBResp
//   Indicates that a response frame of the transmitted Software Trigger Based
//   is expected.
assign rxSWTBResp_p = macControllerRxFSMCs==TX_RESP &&
                      expectedResp==RESP_TYPE_SW    &&
                      expectedAckCapt!=2'b0         &&
                      txDone_p;

always @(posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (~macCoreClkHardRst_n)  // Asynchronous Reset
    rxSWTBResp <= 1'b0;
  else if (~macCoreClkSoftRst_n)  // Synchronous Reset
    rxSWTBResp <= 1'b0;
  else if (rxSWTBResp_p)
    rxSWTBResp <= 1'b1;
  else if (statusUpdated_p)
    rxSWTBResp <= 1'b0;
end


// TimeOut counter
// The timeout timer is loaded with the SIFS + SLOT Time + RXStartDelay when the
// Trigger Based transmission is done and a response is expected.
// The down counter is decremented every us (on tick1us_p) until '0' or until 
// frame is received.
always @(posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (~macCoreClkHardRst_n)  // Asynchronous Reset
    timeOutCnt <= 10'b0;
  else if (~macCoreClkSoftRst_n)  // Synchronous Reset
    timeOutCnt <= 10'b0;
  else
  begin
    if (rxSWTBResp_p)
      timeOutCnt <= {2'b0,sifs} + {2'b0,slotTime} + {2'b0,rxStartDelayOFDM}; 
    else if (timeOutCntEn && tick1us_p)
      timeOutCnt <= timeOutCnt - 10'd1;
  end
end

always @(posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (~macCoreClkHardRst_n)  // Asynchronous Reset
    timeOutCntEn <= 1'b0;
  else if (~macCoreClkSoftRst_n)  // Synchronous Reset
    timeOutCntEn <= 1'b0;
  else
  begin
    if (rxSWTBResp_p)
      timeOutCntEn <= 1'b1;
    else if (rxVector1Start_p | swTBStatusError)
      timeOutCntEn <= 1'b0;
  end
end


// Software Trigger based response Time out flag & pulse
always @(posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (~macCoreClkHardRst_n)  // Asynchronous Reset
    rxSWTBRespTO <= 1'b0;
  else if (~macCoreClkSoftRst_n)  // Synchronous Reset
    rxSWTBRespTO <= 1'b0;
  else
  begin
    if (rxSWTBResp && timeOutCntEn && timeOutCnt==10'd1 && tick1us_p)
      rxSWTBRespTO <= 1'b1;
    else if (rxVector1Start_p | statusUpdated_p)
      rxSWTBRespTO <= 1'b0;
  end
end
assign rxSWTBRespTO_p = rxSWTBRespTO & statusUpdated_p & ~rxVector1Start_p;


// ackRcved_p or baRcved_p pulse capture
always @(posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (~macCoreClkHardRst_n)  // Asynchronous Reset
    swTBAckRcved <= 1'b0;
  else if (~macCoreClkSoftRst_n | ~rxSWTBResp)  // Synchronous Reset
    swTBAckRcved <= 1'b0;
  else if (ackRcved_p | baRcved_p)
    swTBAckRcved <= 1'b1;
end


// Response Error Flag
//   Set if the timeout down counter reach zero.
//   Or  if the received frames is not an ack frame.
//   Or  if the received frames is not correctly received.
always @(posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (~macCoreClkHardRst_n)  // Asynchronous Reset
  begin
    swTBStatusReady     <= 1'b0;
    swTBStatusReady_ff1 <= 1'b0;
    swTBStatusError     <= 1'b0;
  end
  else if (~macCoreClkSoftRst_n)  // Synchronous Reset
  begin
    swTBStatusReady     <= 1'b0;
    swTBStatusReady_ff1 <= 1'b0;
    swTBStatusError     <= 1'b0;
  end
  else
  begin
    swTBStatusReady_ff1 <= swTBStatusReady;
    if (rxSWTBResp && correctRcved_p && swTBAckRcved)
    begin
      swTBStatusReady <= 1'b1;
      swTBStatusError <= 1'b0;
    end
    else if (rxSWTBResp && timeOutCntEn && timeOutCnt==10'd1 && tick1us_p ||
             rxSWTBResp && correctRcved_p && ~swTBAckRcved                ||
             rxSWTBResp && incorrectRcved_p                               ||
             rxSWTBResp && macPhyIfRxErr_p                                ||
             rxSWTBResp && macControllerRxFSMPs!=COMP_DURATION_RESP &&
                           macControllerRxFSMCs==COMP_DURATION_RESP       )
    begin
      swTBStatusReady <= 1'b1;
      swTBStatusError <= 1'b1;
    end
    else if (statusUpdated_p)
    begin
      swTBStatusReady <= 1'b0;
      swTBStatusError <= 1'b0;
    end
  end
end


// Indicate that block ACK frame reception is expected and should not be discarded
assign rxBARxC = rxSWTBResp;


// tbTxCancelled
//    Indicates that trigger based response generated by software is cancelled.
always @(posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (~macCoreClkHardRst_n)  // Asynchronous Reset
    tbTxCancelled <= 1'b0;
  else if (~macCoreClkSoftRst_n)  // Synchronous Reset
    tbTxCancelled <= 1'b0;
  else if (rxTriggerSWValid                         &&
           macControllerRxFSMCs==COMP_DURATION_RESP && 
           macControllerRxFSMNs==IDLE)
    tbTxCancelled <= 1'b1;
  else if (rxTriggerSWValid                         &&
           expectedResp!=RESP_TYPE_SW               &&
           macControllerRxFSMCs==COMP_DURATION_RESP && 
           macControllerRxFSMNs!=COMP_DURATION_RESP)
    tbTxCancelled <= 1'b1;
  else
    tbTxCancelled <= 1'b0;
end

 
////////////////////////////////////////////////////////////////////////////////
// debug Port
////////////////////////////////////////////////////////////////////////////////
assign debugPortMACControllerRx = {rxFormatMod[2] || rxFormatMod[1],
                                   respIsHT,
                                   lSIGTXOPDetected,
                                   tsfRcved,
                                   (rxTRQ && !rxNDPAn),
                                   1'b0,rxSTBC,
                                   rxGIType[0],
                                   correctRcved,
                                   incorrectRcved,
                                   expectedResp[1:0],
                                   sendBA_p,
                                   sendACK_p,
                                   sendCFENDRxC_p,
                                   rxAggregation};

assign debugPortMACControllerRxSWTB = {
   respRUFail,
   statusUpdated_p,
   updateDMAStatusRxC_p,
   whichDescriptorSWRxC[3:0],
   txMpduDoneRxC_p,
   ampduFrmRxC_p,
   mpduSuccessRxC_p,
   rxSWTBRespTO,
   swTBAckRcved,
   swTBStatusReady,
   swTBStatusError,
   rxSWTBResp,
   trigTxTB};


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Additional Code to ease verification
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

`ifdef RW_SIMU_ON
// Disable coverage.
// pragma coverage block = off 
// macControllerRxFSM FSM states displayed in a string to easy simulation and debug
always @*
begin
  case (macControllerRxFSMCs)
                 IDLE  :  macControllerRxFSMCs_str = {"IDLE"};
             RX_FRAME  :  macControllerRxFSMCs_str = {"RX_FRAME"};
 COMP_DURATION_RX_LEG  :  macControllerRxFSMCs_str = {"COMP_DURATION_RX_LEG"};
  COMP_DURATION_RX_MM  :  macControllerRxFSMCs_str = {"COMP_DURATION_RX_MM"};
   COMP_DURATION_RESP  :  macControllerRxFSMCs_str = {"COMP_DURATION_RESP"};
    COMP_DURATION_TFS  :  macControllerRxFSMCs_str = {"COMP_DURATION_TFS"};
          RX_WAIT_END  :  macControllerRxFSMCs_str = {"RX_WAIT_END"};
              TX_RESP  :  macControllerRxFSMCs_str = {"TX_RESP"};
         CHECK_MEDIUM  :  macControllerRxFSMCs_str = {"CHECK_MEDIUM"};
         TX_STBC_RESP  :  macControllerRxFSMCs_str = {"TX_STBC_RESP"};
TX_RESP_STATUS_UPDATE  :  macControllerRxFSMCs_str = {"TX_RESP_STATUS_UPDATE"};
              default  :  macControllerRxFSMCs_str = {"XXX"};
   endcase
end

//  expected Response displayed in a string to easy simulation and debug
always @*
begin
  case (expectedResp)
      RESP_TYPE_ACK : expectedResp_str = {"RESP_TYPE_ACK  "};
      RESP_TYPE_CTS : expectedResp_str = {"RESP_TYPE_CTS  "};
       RESP_TYPE_BA : expectedResp_str = {"RESP_TYPE_BA   "};
    RESP_TYPE_CFEND : expectedResp_str = {"RESP_TYPE_CFEND"};
`ifdef RW_BFMEE_EN
      RESP_TYPE_BFR : expectedResp_str = {"RESP_TYPE_BFR  "};
`endif //RW_BFMEE_EN
       RESP_TYPE_SW : expectedResp_str = {"RESP_TYPE_SW   "};
      RESP_TYPE_BQR : expectedResp_str = {"RESP_TYPE_BQR  "};
            default : expectedResp_str = {"RESP_TYPE_NONE "};
  endcase
end

//  respTxFormatMod displayed in a string to easy simulation and debug
always @*
begin
  case (respTxFormatMod)
               NON_HT : respTxFormatMod_str = {"NON-HT"};
      NON_HT_DUP_OFDM : respTxFormatMod_str = {"NON-HT-DUP-OFDM"};
                HT_MM : respTxFormatMod_str = {"HT-MM"};
                HT_GF : respTxFormatMod_str = {"HT-GF"};
                  VHT : respTxFormatMod_str = {"VHT"};
                HE_SU : respTxFormatMod_str = {"HE_SU"};
                HE_MU : respTxFormatMod_str = {"HE_MU"};
            HE_EXT_SU : respTxFormatMod_str = {"HE_EXT_SU"};
                HE_TB : respTxFormatMod_str = {"HE_TB"};
              default : respTxFormatMod_str = {"XXX"};
  endcase
end

// pragma coverage block = on 
`endif // RW_SIMU_ON


`ifdef RW_ASSERT_ON

// System Verilog Assertions
////////////////////////////

// $rw_sva Checks if a STA does not transmit a PPDU with the FORMAT parameter set to HT_MF in TXVECTOR if the corresponding
// L_LENGTH value calculated exceeds 4095 octets.(LSIG Duration > 5468 us)
property maxLLenghtCheck_prop;
@(posedge macCoreClk)
    (((rxFormatMod == HT_MM) || (rxFormatMod == VHT)) && (sendACK_p || sendBA_p || sendCTSRxC_p)) |-> lSIGDuration <= 5468;
endproperty
maxLLenghtCheck: assert property (maxLLenghtCheck_prop); 


// Cover Points Definitions
///////////////////////////

//$rw_sva This cover point checks if we have received a RTS Frame
countRTSReceivedFrame: cover property (@(posedge macCoreClk) (rtsRcved_p));

//$rw_sva This cover point checks if we have received a Block Ack Request
countBAReqReceivedFrame: cover property (@(posedge macCoreClk) (barRcved_p));

//$rw_sva This cover point checks if we have received a frame which requires a acknowledgement
countneedAckReceivedFrame: cover property (@(posedge macCoreClk) (needAckRcved_p));
 
//$rw_sva This cover point checks if we have received a frame which requires a Trigger Based
//acknowledgement
countneedHTPAckReceivedFrame: cover property (@(posedge macCoreClk) (needHTPAckRcved_p));
 
//$rw_sva This cover point checks if we have received a BFR-Poll
countBFRPollReceivedFrame: cover property (@(posedge macCoreClk) (bfrPollRcved_p));

//$rw_sva This cover point checks if we have received a NDP-A
countNDPAReceivedFrame: cover property (@(posedge macCoreClk) (ndpaRcved_p));

`ifdef RW_BFMEE_EN
//$rw_sva This cover point checks if we have received a frame which requires a BFR response
countNeedBFRReceivedFrame: cover property (@(posedge macCoreClk) (needBFRRcved_p));

//$rw_sva This cover point checks if we have received a frame which requires a BFR response
countNeedTBBFRReceivedFrame: cover property (@(posedge macCoreClk) (needTBBFRRcved_p));
`endif //RW_BFMEE_EN

//$rw_sva This cover point checks if we have received a ACK
countACKReceivedFrame: cover property (@(posedge macCoreClk) (ackRcved_p));

//$rw_sva This cover point checks if we have received a CTS
countCTSReceivedFrame: cover property (@(posedge macCoreClk) (ctsRcved_p));

//$rw_sva This cover point checks if we have received a CF-END
countCFENDReceivedFrame: cover property (@(posedge macCoreClk) (cfEndRcved_p));

//$rw_sva This cover point checks if we have received a Block ACK
countBAReceivedFrame: cover property (@(posedge macCoreClk) (baRcved_p));

//$rw_sva This cover point checks if we have received a Beacon
countBCNReceivedFrame: cover property (@(posedge macCoreClk) (bcnRcved_p));

//$rw_sva This cover point checks if we have received a Prob Response
countProbRespReceivedFrame: cover property (@(posedge macCoreClk) (probRespRcved_p));

//$rw_sva This cover point checks if we have received a Broadcast/Multicast frame
countBcMcReceivedFrame: cover property (@(posedge macCoreClk) (bcMcRcved_p));

//$rw_sva This cover point checks if we have received a notMine frame
countnotMineReceivedFrame: cover property (@(posedge macCoreClk) (notMineRcved_p));

//$rw_sva This cover point checks if we have received a notMine PsPoll frame
countnotMinePsPollReceivedFrame: cover property (@(posedge macCoreClk) (notMinePsPollRcved_p));

//$rw_sva This cover point checks if we have received a notMine RTS frame
countnotMineRTSReceivedFrame: cover property (@(posedge macCoreClk) (notMineRtsRcved_p));

//$rw_sva This cover point checks if we have received an unknown frame
countunknownReceivedFrame: cover property (@(posedge macCoreClk) (unknownRcved_p));

//$rw_sva This cover point checks if we have received a MU-BAR Trigger
countMUBARTriggerReceivedFrame: cover property (@(posedge macCoreClk) (muBARTriggerRcved_p));

//$rw_sva This cover point checks if we have received an A-MPDU 
countAMPDUReceivedFrame: cover property (@(posedge macCoreClk) (ampduCorrectRcved_p || ampduIncorrectRcved_p));

//$rw_sva This cover point checks if we have received an A-MPDU and a BA has been transmitted 
countBAResponseToAMPDU: cover property (@(posedge sendBA_p) (rxAggregation));

//$rw_sva This cover point checks if a response frame has been transmitted in HT-MM formatMod
countHTMMRespFrame: cover property (@(posedge macCoreClk) ((sendCTSRxC_p || sendACK_p || sendBA_p || sendCFENDRxC_p) && (respTxFormatMod == HT_MM)));

//$rw_sva This cover point checks if a response frame has been transmitted in HT-GF formatMod
countHTGFRespFrame: cover property (@(posedge macCoreClk) ((sendCTSRxC_p || sendACK_p || sendBA_p || sendCFENDRxC_p) && (respTxFormatMod == HT_GF)));

//$rw_sva This cover point checks if a response frame has been transmitted in VHT formatMod
countVHTRespFrame: cover property (@(posedge macCoreClk) ((sendCTSRxC_p || sendACK_p || sendBA_p || sendCFENDRxC_p) && (respTxFormatMod == VHT)));

//$rw_sva This cover point checks if a CFEND response frame has been transmitted in STBC mode as an AP
countCFENDSTBCRespFrameAsAP: cover property (@(posedge sendCFENDRxC_p) (txSTBCRxC != 0));

//$rw_sva This cover point checks if a CTS response frame has been transmitted in STBC mode as an AP
countCTSSTBCRespFrameAsAP: cover property (@(posedge macCoreClk) (ap && sendCTSRxC_p && (rxSTBC != 0)));

//$rw_sva This cover point checks if a CTS response frame has been transmitted in STBC mode as a STA
countCTSSTBCRespFrameAsSTA: cover property (@(posedge macCoreClk) (!ap && sendCTSRxC_p && (rxSTBC != 0)));

//$rw_sva This cover point checks if a BA frame has been transmitted in STBC mode
countBASTBCRespFrame: cover property (@(posedge sendBA_p) (rxSTBC != 0));

//$rw_sva This cover point checks if an ACK frame has been transmitted in STBC mode
countACKSTBCRespFrame: cover property (@(posedge sendACK_p) (rxSTBC != 0));

//$rw_sva This cover point checks if an CTS frame has been transmitted in STBC mode after PIFS
countCTSSTBCSendOnPIFS: cover property (@(posedge sendCTSRxC_p) (sendOnPIFSRxC));

//$rw_sva This cover point checks if the CCA was raised during PIFS in case of dual CTS protection
countDualCTSResponseAbortedDuringPIFS: cover property (@(posedge macCoreClk) ((macControllerRxFSMCs == CHECK_MEDIUM) && macPhyIfRxCca));

//$rw_sva This cover point checks if an LSIG TXOP has been detected and a response transmitted
countLSIGTXOPWithResponse: cover property (@(posedge txDone_p) (lSIGTXOPDetected));


`endif // RW_ASSERT_ON


endmodule
                 
