// Define for 802.11ac support
`define RW_MAC_AC
`define RW_AES_AC

`ifndef MAC_FREQ
  `define MAC_FREQ 200
`endif


// Indicates the clock ration between WEP Clock and MAC Core Clock
`ifndef WEP_2_BB_CLK_RATIO
  `define WEP_2_BB_CLK_RATIO 1
`endif


// Encryption support
`define ENCRYPTION 1
`define WEP                  1
`define TKIP                 1
`define CCMP                 1
`define DOT11I_SUPPORTED     1

// Registers version
`define MACHW_SIGNATURE 32'h4d414300


//`ifdef RW_MUMIMO_TX_2_USERS
//  // Include or not MU-MIMO support by commenting or not the following defines
//  // Enable MU-MIMO transmission as an AP
//  `define RW_MUMIMO_TX_EN 
//
//  // The maximum number of supported users in a MU-MIMO transmission is controlled by
//  // Support MU-MIMO TX to two users. 
//  `define RW_MUMIMO_SEC_USER1_EN
//`endif // RW_MUMIMO_TX_2_USERS 
//
//`ifdef RW_MUMIMO_TX_3_USERS
//  // Include or not MU-MIMO support by commenting or not the following defines
//  // Enable MU-MIMO transmission as an AP
//  `define RW_MUMIMO_TX_EN 
//
//  //The maximum number of supported users in a MU-MIMO transmission is controlled by
//  // Support MU-MIMO TX to two users. 
//  `define RW_MUMIMO_SEC_USER1_EN
//  // Support MU-MIMO TX to three users.
//  `define RW_MUMIMO_SEC_USER2_EN 
//`endif // RW_MUMIMO_TX_3_USERS
//    
//`ifdef RW_MUMIMO_TX_4_USERS
//   // Include or not MU-MIMO support by commenting or not the following defines
//   // Enable MU-MIMO transmission as an AP
//   `define RW_MUMIMO_TX_EN 
//
//   //The maximum number of supported users in a MU-MIMO transmission is controlled by
//   // Support MU-MIMO TX to two users. 
//   `define RW_MUMIMO_SEC_USER1_EN
//   // Support MU-MIMO TX to three users.
//   `define RW_MUMIMO_SEC_USER2_EN 
//   // Support MU-MIMO TX to four users.
//   `define RW_MUMIMO_SEC_USER3_EN 
//`endif // RW_MUMIMO_TX_4_USERS


`ifdef RW_MUMIMO_TX_EN
  `define MACHW_MUMIMOTX  1
`else // RW_MUMIMO_TX_EN 
  `define MACHW_MUMIMOTX  0
`endif //RW_MUMIMO_TX_EN 


`ifdef RW_MUMIMO_RX_EN
  `define RW_BFMEE_EN
`endif 

`ifdef RW_BFMER_EN
  `define MACHW_BFMER     1
`else // RW_BFMER_EN
  `define MACHW_BFMER     0
`endif //RW_BFMER_EN

`ifdef RW_BFMEE_EN
  `define MACHW_BFMEE     1
`else // RW_BFMEE_EN
  `define MACHW_BFMEE     0
`endif //RW_BFMEE_EN

`ifdef RW_WLAN_COEX_EN
  `define MACHW_COEX      1
`else // RW_WLAN_COEX_EN
  `define MACHW_COEX      0
`endif //RW_WLAN_COEX_EN

`ifdef RW_WAPI_EN
  `define MACHW_WAPI      1
`else // RW_WAPI_EN
  `define MACHW_WAPI      0
`endif //RW_WAPI_EN

`ifdef  RW_GCMP_EN
  `define MACHW_GCMP      1      
`else //RW_GCMP_EN
  `define MACHW_GCMP      0      
`endif//RW_GCMP_EN

`define MACHW_TPC       1
`define MACHW_HE        1
`define MACHW_VHT       1        
`define MACHW_HT        1        
`define MACHW_RCE       1       
`define MACHW_CCMP      1      
`define MACHW_TKIP      1      
`define MACHW_WEP       1        
`define MACHW_SECURITY  1
`define MACHW_SME       1 
`define MACHW_HCCA      0      
`define MACHW_EDCA      1     
`define MACHW_QOS       1     

`define MACHW_PHASENUMBER   5  
`define MACHW_RELEASENUMBER 0
`define MACHW_IERELEASE     0      
// UM 4.07 (71)
`define MACHW_UMVERSION     71


`define MACHW_BITMAPCNT 1


// KEY Search RAM configuration
`ifdef RW_CONFIG_4VAP_128STA
  `define RW_KEY_INDEX_WIDTH 8
  `define RW_KEY_INDEX_MAX 143
  `define RW_KEY_NVAP 4
`else
  `ifdef RW_CONFIG_6VAP_104STA
    `define RW_KEY_INDEX_WIDTH 7
    `define RW_KEY_INDEX_MAX 127
    `define RW_KEY_NVAP 6
  `else
    `define RW_KEY_INDEX_WIDTH 6
    `define RW_KEY_INDEX_MAX 63
    `define RW_KEY_NVAP 6
  `endif
`endif

// ToDo: RW_KEY_EXTENDED must be define only when CCMP-256 or GCMP-256 or WAPI is supported
`define RW_KEY_EXTENDED
`ifdef RW_KEY_EXTENDED
   `define RW_KEY_DATA_WIDTH 316
`else
   `define RW_KEY_DATA_WIDTH 188
`endif


`ifdef RW_NX_LDPC_DEC
  // If LDPC is enabled in RX in the PHY, increase the MPIF RX FIFO to 512 bytes.
  `define MPIFRXADDRWIDTH 9
`endif  

// MAC-PHY IF FIFOs configuration
`ifndef MPIFTXADDRWIDTH
  // By default,the MPIF TX FIFO to 128 bytes.
  `define MPIFTXADDRWIDTH 7
`endif  


`ifndef MPIFRXADDRWIDTH
  // By default,the MPIF RX FIFO to 128 bytes.
  `define MPIFRXADDRWIDTH 7
`endif  


// TX FIFOs configuration
`ifndef TXFIFOADDRWIDTH
  `define TXFIFOADDRWIDTH 6
`endif // TXFIFOADDRWIDTH

`define TXFIFODEPTH 2**`TXFIFOADDRWIDTH
`define TXFIFO_ALMOST_EMPTY_THRESHOLD 7
`define TXFIFO_ALMOST_FULL_THRESHOLD 4

// RX FIFOs configuration
`ifndef RXFIFOADDRWIDTH
  `define RXFIFOADDRWIDTH 6
`endif // RXFIFOADDRWIDTH

`define RXFIFODEPTH 2**`RXFIFOADDRWIDTH
`define RXFIFO_ALMOST_EMPTY_THRESHOLD 7
`define RXFIFO_ALMOST_FULL_THRESHOLD 2



// DOZE Controller Definition
// Number of fast clock cycles required to switch to Low Power Clock
`define SWITCHTO32K_DURATION 3
// Number of Low Power clock cycles required to switch to Fast Clock
`define SWITCHTOFASTCLK_DURATION 2
// Number of Low Power clock cycles required to switch on Fast Crystal Oscillator
`define SWITCHONFASTCLK_DURATION 5
// Size of the DOZE counter
// Should be enough to count up to the max of SWITCHTO32K_DURATION, SWITCHONFASTCLK_DURATION and SWITCHTOFASTCLK_DURATION
`define DOZECOUNTERSIZE 3 

// Timing definition.
// All these defines are the reset values of registers timings1-9.
// They can be changed here or by the software.
`define TX_RF_DLY                      0     // in us
`define TX_CHAIN_DLY                   3     // in us
`define TX_DMA_PROC_DLY                1     // in us

`define SHORT_SLOT                     9     // in us
`define MAC_PROC_DELAY                 1     // in us
`define RX_RF_DLY                      0     // in us
`define RX_CCA_DLY                     4     // in us

`define SIFS_A                        16     // in us
`define SIFS_B                        10     // in us


`define RIFSTO                         5     // in us
//`define RX_DELAY_A                    10     // in us
//`define RX_DELAY_B                    10     // in us

`define NO_BCN_TX_TIME                27     // in 16 us
`define IMP_TBTT_TIME                 26
`define RADIOWAKEUP_TIME              21
`define RADIO_CHIRP_TIME              20



`define SLOT_TIME_DOT11B              20     // used for 802.11 b data rates

`define SIFS_TIME_DOT11B              10     // used for 802.11 b data rates
`define SIFS_TIME_DOT11A              16     // used for 802.11 a data rates

`define EIFS_MINUS_DIFS_DOT11B       314
`define EIFS_MINUS_DIFS_DOT11A        60     // at PHY's lowest rate


// Configuration of the divider architecture. Depending on the clock frequency, two architectures are available.
// For high macCoreClk frequency (above 100MHz), it is recommended to use RW_TXTIME_DIVIDER_ONECYCLE.
// For low macCoreClk frequency (below 80MHz), it is recommended to use RW_TXTIME_DIVIDER_FIVECYCLE.

// With this define, the divider computes 1 step per clock cycles.
// The max frequency in FPGA Virtex 5 is ~130MHz.
//`define RW_TXTIME_DIVIDER_ONECYCLE

// With this define, the divider computes 5 steps per clock cycles.
// The max frequency in FPGA Virtex 5 is ~45MHz.

`ifndef RW_TXTIME_DIVIDER_ONECYCLE
  `define RW_TXTIME_DIVIDER_FIVECYCLE
`endif  

`ifndef RW_TXTIME_DIVIDER_FIVECYCLE
  `ifndef RW_TXTIME_DIVIDER_ONECYCLE
    `define RW_TXTIME_DIVIDER_ONECYCLE
  `endif  
`endif  

// Number of Spatial Stream supported
// Note : If the MAC Support 3SS, both defines RW_MAC_2SS_SUPPORT and RW_MAC_3SS_SUPPORT shall be present. Only the define RW_MAC_4SS_SUPPORT shall be commented.
`ifndef RW_1NSS_ONLY
  `define RW_MAC_2SS_SUPPORT
  `define RW_MAC_3SS_SUPPORT
  `define RW_MAC_4SS_SUPPORT
`endif

// Support MIB Controller
// If the MIB Controller is not required, the following line can be commented.
`define RW_MAC_MIBCNTL_EN
