//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                    
// Description      : DebugPort multiplexing module
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module debugPortCtrl( 
          //$port_g Register Interface
          input  wire    [7:0] debugPortSel1,  // Debug Port Selection 1
          input  wire    [7:0] debugPortSel2,  // Debug Port Selection 2
          output wire   [31:0] debugPortRead,  // Reflect to register the value of debugPort output

          //$port_g Debug Interface
          output wire   [31:0] debugPort,      // Debug Port

          //$port_g Internal Signal Interface
          input  wire   [15:0] debugPortInt1,  // Debug Port 1 
          input  wire   [15:0] debugPortInt2,  // Debug Port 2 
          input  wire   [15:0] debugPortInt3,  // Debug Port 3 
          input  wire   [15:0] debugPortInt4,  // Debug Port 4 
          input  wire   [15:0] debugPortInt5,  // Debug Port 5 
          input  wire   [15:0] debugPortInt6,  // Debug Port 6 
          input  wire   [15:0] debugPortInt7,  // Debug Port 7 
          input  wire   [15:0] debugPortInt8,  // Debug Port 8 
          input  wire   [15:0] debugPortInt9,  // Debug Port 9 
          input  wire   [15:0] debugPortInt10, // Debug Port 10
          input  wire   [15:0] debugPortInt11, // Debug Port 11
          input  wire   [15:0] debugPortInt12, // Debug Port 12
          input  wire   [15:0] debugPortInt13, // Debug Port 13
          input  wire   [15:0] debugPortInt14, // Debug Port 14
          input  wire   [15:0] debugPortInt15, // Debug Port 15
          input  wire   [15:0] debugPortInt16, // Debug Port 16
          input  wire   [15:0] debugPortInt17, // Debug Port 17
          input  wire   [15:0] debugPortInt18, // Debug Port 18
          input  wire   [15:0] debugPortInt19, // Debug Port 19
          input  wire   [15:0] debugPortInt20, // Debug Port 20
          input  wire   [15:0] debugPortInt21, // Debug Port 21
          input  wire   [15:0] debugPortInt22, // Debug Port 22
          input  wire   [15:0] debugPortInt23, // Debug Port 23
          input  wire   [15:0] debugPortInt24, // Debug Port 24
          input  wire   [15:0] debugPortInt25, // Debug Port 25
          input  wire   [15:0] debugPortInt26, // Debug Port 26
          input  wire   [15:0] debugPortInt27, // Debug Port 27
          input  wire   [15:0] debugPortInt28, // Debug Port 28
          input  wire   [15:0] debugPortInt29, // Debug Port 29
          input  wire   [15:0] debugPortInt30, // Debug Port 30
          input  wire   [15:0] debugPortInt31, // Debug Port 31
          input  wire   [15:0] debugPortInt32, // Debug Port 32
          input  wire   [15:0] debugPortInt33, // Debug Port 33
          input  wire   [15:0] debugPortInt34, // Debug Port 34
          input  wire   [15:0] debugPortInt35, // Debug Port 35
          input  wire   [15:0] debugPortInt36, // Debug Port 36
          input  wire   [15:0] debugPortInt37, // Debug Port 37
          input  wire   [15:0] debugPortInt38, // Debug Port 38
          input  wire   [15:0] debugPortInt39, // Debug Port 39
          input  wire   [15:0] debugPortInt40, // Debug Port 40
          input  wire   [15:0] debugPortInt41, // Debug Port 41
          input  wire   [15:0] debugPortInt42, // Debug Port 42
          input  wire   [15:0] debugPortInt43, // Debug Port 43
          input  wire   [15:0] debugPortInt44, // Debug Port 44
          input  wire   [15:0] debugPortInt45, // Debug Port 45
          input  wire   [15:0] debugPortInt46, // Debug Port 46
          input  wire   [15:0] debugPortInt47, // Debug Port 47
          input  wire   [15:0] debugPortInt48, // Debug Port 48
          `ifdef RW_WAPI_EN
          input  wire   [15:0] debugPortInt49, // Debug Port 49
          `endif
          `ifdef RW_WLAN_COEX_EN
          input  wire   [15:0] debugPortInt50, // Debug Port 50
          `endif // RW_WLAN_COEX_EN
`ifdef  RW_BFMEE_EN
          input  wire   [15:0] debugPortInt51, // Debug Port 51
`endif//RW_BFMEE_EN
          input  wire   [15:0] debugPortInt52, // Debug Port 52
          input  wire   [15:0] debugPortInt53, // Debug Port 53
          input  wire   [15:0] debugPortInt54, // Debug Port 54
`ifdef  RW_BFMEE_EN
          input  wire   [15:0] debugPortInt55, // Debug Port 55
          input  wire   [15:0] debugPortInt56, // Debug Port 56
          input  wire   [15:0] debugPortInt57, // Debug Port 57
`endif//RW_BFMEE_EN
          input  wire   [15:0] debugPortInt58, // Debug Port 58
          input  wire   [15:0] debugPortInt59  // Debug Port 59
                 );



reg [15:0] debugPortLow;
reg [15:0] debugPortHigh;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

assign debugPort = {debugPortHigh,debugPortLow};

always @ *
begin
  case (debugPortSel1)
        8'd0 : debugPortLow = debugPortInt1;
        8'd1 : debugPortLow = debugPortInt2;
        8'd2 : debugPortLow = debugPortInt3;
        8'd3 : debugPortLow = debugPortInt4;
        8'd4 : debugPortLow = debugPortInt5;
        8'd5 : debugPortLow = debugPortInt6;
        8'd6 : debugPortLow = debugPortInt7;
        8'd7 : debugPortLow = debugPortInt8;
        8'd8 : debugPortLow = debugPortInt9;
        8'd9 : debugPortLow = debugPortInt10;
       8'd10 : debugPortLow = debugPortInt11;
       8'd11 : debugPortLow = debugPortInt12;
       8'd12 : debugPortLow = debugPortInt13;
       8'd13 : debugPortLow = debugPortInt14;
       8'd14 : debugPortLow = debugPortInt15;
       8'd15 : debugPortLow = debugPortInt16;
       8'd16 : debugPortLow = debugPortInt17;
       8'd17 : debugPortLow = debugPortInt18;
       8'd18 : debugPortLow = debugPortInt19;
       8'd19 : debugPortLow = debugPortInt20;
       8'd20 : debugPortLow = debugPortInt21;
       8'd21 : debugPortLow = debugPortInt22;
       8'd22 : debugPortLow = debugPortInt23;
       8'd23 : debugPortLow = debugPortInt24;
       8'd24 : debugPortLow = debugPortInt25;
       8'd25 : debugPortLow = debugPortInt26;
       8'd26 : debugPortLow = debugPortInt27;
       8'd27 : debugPortLow = debugPortInt28;
       8'd28 : debugPortLow = debugPortInt29;
       8'd29 : debugPortLow = debugPortInt30;
       8'd30 : debugPortLow = debugPortInt31;
       8'd31 : debugPortLow = debugPortInt32;
       8'd32 : debugPortLow = debugPortInt33;
       8'd33 : debugPortLow = debugPortInt34;
       8'd34 : debugPortLow = debugPortInt35;
       8'd35 : debugPortLow = debugPortInt36;
       8'd36 : debugPortLow = debugPortInt37;
       8'd37 : debugPortLow = debugPortInt38;
       8'd38 : debugPortLow = debugPortInt39;
       8'd39 : debugPortLow = debugPortInt40;
       8'd40 : debugPortLow = debugPortInt41;
       8'd41 : debugPortLow = debugPortInt42;
       8'd42 : debugPortLow = debugPortInt43;
       8'd43 : debugPortLow = debugPortInt44;
       8'd44 : debugPortLow = debugPortInt45;
       8'd45 : debugPortLow = debugPortInt46;
       8'd46 : debugPortLow = debugPortInt47;
       8'd47 : debugPortLow = debugPortInt48;
       `ifdef RW_WAPI_EN
       8'd48 : debugPortLow = debugPortInt49;
       `endif //RW_WAPI_EN
       `ifdef RW_WLAN_COEX_EN
       8'd49 : debugPortLow = debugPortInt50;
       `endif // RW_WLAN_COEX_EN
`ifdef  RW_BFMEE_EN
       8'd50 : debugPortLow = debugPortInt51;
`endif//RW_BFMEE_EN
       8'd51 : debugPortLow = debugPortInt52;
       8'd52 : debugPortLow = debugPortInt53;
       8'd53 : debugPortLow = debugPortInt54;
`ifdef  RW_BFMEE_EN
       8'd54 : debugPortLow = debugPortInt55;
       8'd55 : debugPortLow = debugPortInt56;
       8'd56 : debugPortLow = debugPortInt57;
`endif//RW_BFMEE_EN
       8'd57 : debugPortLow = debugPortInt58;
       8'd58 : debugPortLow = debugPortInt59;
     default : debugPortLow = debugPortInt1; 
  endcase
end

always @ *
begin
  case (debugPortSel2)
        8'd0 : debugPortHigh = debugPortInt1;
        8'd1 : debugPortHigh = debugPortInt2;
        8'd2 : debugPortHigh = debugPortInt3;
        8'd3 : debugPortHigh = debugPortInt4;
        8'd4 : debugPortHigh = debugPortInt5;
        8'd5 : debugPortHigh = debugPortInt6;
        8'd6 : debugPortHigh = debugPortInt7;
        8'd7 : debugPortHigh = debugPortInt8;
        8'd8 : debugPortHigh = debugPortInt9;
        8'd9 : debugPortHigh = debugPortInt10;
       8'd10 : debugPortHigh = debugPortInt11;
       8'd11 : debugPortHigh = debugPortInt12;
       8'd12 : debugPortHigh = debugPortInt13;
       8'd13 : debugPortHigh = debugPortInt14;
       8'd14 : debugPortHigh = debugPortInt15;
       8'd15 : debugPortHigh = debugPortInt16;
       8'd16 : debugPortHigh = debugPortInt17;
       8'd17 : debugPortHigh = debugPortInt18;
       8'd18 : debugPortHigh = debugPortInt19;
       8'd19 : debugPortHigh = debugPortInt20;
       8'd20 : debugPortHigh = debugPortInt21;
       8'd21 : debugPortHigh = debugPortInt22;
       8'd22 : debugPortHigh = debugPortInt23;
       8'd23 : debugPortHigh = debugPortInt24;
       8'd24 : debugPortHigh = debugPortInt25;
       8'd25 : debugPortHigh = debugPortInt26;
       8'd26 : debugPortHigh = debugPortInt27;
       8'd27 : debugPortHigh = debugPortInt28;
       8'd28 : debugPortHigh = debugPortInt29;
       8'd29 : debugPortHigh = debugPortInt30;
       8'd30 : debugPortHigh = debugPortInt31;
       8'd31 : debugPortHigh = debugPortInt32;
       8'd32 : debugPortHigh = debugPortInt33;
       8'd33 : debugPortHigh = debugPortInt34;
       8'd34 : debugPortHigh = debugPortInt35;
       8'd35 : debugPortHigh = debugPortInt36;
       8'd36 : debugPortHigh = debugPortInt37;
       8'd37 : debugPortHigh = debugPortInt38;
       8'd38 : debugPortHigh = debugPortInt39;
       8'd39 : debugPortHigh = debugPortInt40;
       8'd40 : debugPortHigh = debugPortInt41;
       8'd41 : debugPortHigh = debugPortInt42;
       8'd42 : debugPortHigh = debugPortInt43;
       8'd43 : debugPortHigh = debugPortInt44;
       8'd44 : debugPortHigh = debugPortInt45;
       8'd45 : debugPortHigh = debugPortInt46;
       8'd46 : debugPortHigh = debugPortInt47;
       8'd47 : debugPortHigh = debugPortInt48;
       `ifdef RW_WAPI_EN
       8'd48 : debugPortHigh = debugPortInt49;
       `endif
       `ifdef RW_WLAN_COEX_EN
       8'd49 : debugPortHigh = debugPortInt50;
       `endif // RW_WLAN_COEX_EN
`ifdef  RW_BFMEE_EN
       8'd50 : debugPortHigh = debugPortInt51;
`endif//RW_BFMEE_EN
       8'd51 : debugPortHigh = debugPortInt52;
       8'd52 : debugPortHigh = debugPortInt53;
       8'd53 : debugPortHigh = debugPortInt54;
`ifdef  RW_BFMEE_EN
       8'd54 : debugPortHigh = debugPortInt55;
       8'd55 : debugPortHigh = debugPortInt56;
       8'd56 : debugPortHigh = debugPortInt57;
`endif//RW_BFMEE_EN
       8'd57 : debugPortHigh = debugPortInt58;
       8'd58 : debugPortHigh = debugPortInt59;
     default : debugPortHigh = debugPortInt1; 
  endcase
end

assign debugPortRead = debugPort;

endmodule
