//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : mac Additionnal Tx Path (MuMIMO)
//
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :SECONDARY parameter is set when txVectorSel is part of
//                    a secondary TX path. In this case, only a subset of
//                    TX parameters are stored.
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none
module macSecTxCore(
  ///////////////////////////////////////////////
  //$port_g Resets
  ///////////////////////////////////////////////
  input  wire                            macPIClkHardRst_n,          // Active low hard reset
                                                                     // signal synchronized to the
                                                                     // macPIClk.
  input  wire                            macCoreClkHardRst_n,        // Active low hard reset
                                                                     // signal synchronized to the
                                                                     // macCoreClk.
  input  wire                            mpIFClkHardRst_n,           // Active low hard reset
                                                                     // signal synchronized to the
                                                                     // mpIFClk.
  input  wire                            macPIClkSoftRst_n,          // Active low soft reset
                                                                     // signal synchronized to the
                                                                     // macPIClk.
  input  wire                            macCoreClkSoftRst_n,        // Active low soft reset
                                                                     // signal synchronized to the
                                                                     // macCoreClk.
  input  wire                            dmaSoftRst_n,               // Active low DMA soft reset
  input  wire                            mpifSoftRst_n,              // Active low mpif soft reset
  input  wire                            txFifoSoftRst_n,            // Active low txFifo soft reset

  ///////////////////////////////////////////////
  //$port_g Clocks
  ///////////////////////////////////////////////
  input  wire                            macPIClk,                   // Primary MAC Platform
                                                                     // Interface Clock
  input  wire                            macPITxClk,                 // Secondary MAC Platform
                                                                     // Interface Clock for TX
  input  wire                            macCoreClk,                 // Primary MAC Core Clock
  input  wire                            macCoreTxClk,               // Secondary MAC Core Clock
                                                                     // for TX
  input  wire                            macCryptClk,                // Clock input for Crypto
                                                                     // Engine blocks.
  input  wire                            mpIFClk,                    // MAC PHY Interface Clock

  ///////////////////////////////////////////////
  //$port_g Clock Enables
  ///////////////////////////////////////////////
  output wire                            macCryptClkEn,              // Clock Enable for
                                                                     // macCryptClk Clock

  ///////////////////////////////////////////////
  //$port_g DMA Engine Interface with the MAC Controller
  ///////////////////////////////////////////////
  input  wire                            trigTxAC0PI,                // Trigger from the MAC
                                                                     // Controller to indicate DMA
                                                                     // to start fetching frames
                                                                     // associated with AC0
  input  wire                            trigTxAC1PI,                // Trigger from the MAC
                                                                     // Controller to indicate DMA
                                                                     // to start fetching frames
                                                                     // associated with AC1
  input  wire                            trigTxAC2PI,                // Trigger from the MAC
                                                                     // Controller to indicate DMA
                                                                     // to start fetching frames
                                                                     // associated with AC2
  input  wire                            trigTxAC3PI,                // Trigger from the MAC
                                                                     // Controller to indicate DMA
                                                                     // to start fetching frames
                                                                     // associated with AC3
  input  wire                      [1:0] transmissionBW,             // Indicates whether the frame
                                                                     // was transmitted with 20MHz,
                                                                     // 40Mhz, 80Mhz or 160Mhz BW
  input  wire                     [31:0] mediumTimeUsed,             // Indicates the medium Time
                                                                     // Used for current
                                                                     // transmission Valid when DMA
                                                                     // status is being updated
  input  wire                            txFIFORdFlush,              // Request from MAC Core Clock
                                                                     // domain to flush

  ///////////////////////////////////////////////
  //$port_g DMA Engine Interface with the Host
  ///////////////////////////////////////////////
  input  wire                     [31:0] dmaHIFReadDataOut,          // dma host interface read data
  input  wire                            dmaHIFReadDataValid,        // dma host interface read
                                                                     // data valid
  input  wire                            dmaHIFReady,                // dma host interface next data
  input  wire                            dmaHIFTransComplete,        // dma host interface transfer
                                                                     // complete
  input  wire                            dmaHIFError,                // dma host interface error
  output wire                            dmaHIFRead,                 // dma host interface read
                                                                     // enable
  output wire                            dmaHIFWrite,                // dma host interface write
                                                                     // enable
  output wire                      [2:0] dmaHIFSize,                 // dma host interface byte
                                                                     // enable
  output wire                     [31:0] dmaHIFAddressIn,            // dma host interface address
  output wire                     [31:0] dmaHIFWriteDataIn,          // dma host interface write data

  ///////////////////////////////////////////////
  //$port_g DMA engine interface with $ToDo
  ///////////////////////////////////////////////
  output reg                             dmaIsHalted,                // DMA in HALTED state
  output wire                            dmaInternalError,           // DMA Internal error occured

  ///////////////////////////////////////////////
  //$port_g DMA Engine Interface with the interrupt controller
  ///////////////////////////////////////////////
  output wire                            ptError,                    // Transmit PolicyTable Error
  output wire                            acxTxDMADead,               // acxTxDMADead internal
                                                                     // interruption
  output wire                            ac0TxTrigger,               // ac0TxTrigger internal
                                                                     // interruption
  output wire                            ac1TxTrigger,               // ac1TxTrigger internal
                                                                     // interruption
  output wire                            ac2TxTrigger,               // ac2TxTrigger internal
                                                                     // interruption
  output wire                            ac3TxTrigger,               // ac3TxTrigger internal
                                                                     // interruption
  output wire                            ac0TxBufTrigger,            // ac0TxBufTrigger internal
                                                                     // interruption
  output wire                            ac1TxBufTrigger,            // ac1TxBufTrigger internal
                                                                     // interruption
  output wire                            ac2TxBufTrigger,            // ac2TxBufTrigger internal
                                                                     // interruption
  output wire                            ac3TxBufTrigger,            // ac3TxBufTrigger internal
                                                                     // interruption

  ///////////////////////////////////////////////
  //$port_g Control and Status Register
  ///////////////////////////////////////////////
  input  wire                     [31:0] tsfTimerLowIn,              // TSF[31:0] to register
  output wire                      [1:0] txACxState,                 // DMA state for secondary channel
//output wire                            txAC0LenMismatch,           // Transmit AC0 Length Mismatch
//output wire                            txAC0UPatternErr,           // Transmit AC0 Unique Pattern
                                                                     // Error
//output wire                            txAC0NextPointerErr,        // Transmit AC0 Next Pointer
                                                                     // Error
//output wire                            txAC0PTAddressErr,          // Transmit AC0 Policy Table
                                                                     // Address Error
//output wire                            txAC0BusErr,                // Transmit AC0 Bus Error
  output wire                            txACxNewHeadErr,            // Transmit ACx New Head Error
  output wire                            txACxStartup,               // Transmit ACx Startup
  output wire                            txACxEndQ,                  // Transmit ACx End of Queue
  output wire                     [31:0] txCurrentPointer,           // status of the current
                                                                     // pointer
  input  wire                            txFIFOReset,                // TX FIFO reset
  output wire                            txFIFOResetInValid,         // TX FIFO reset clear
  input  wire                            hwFSMResetPIClk,            // HW FSM Reset
  input  wire                            hwFSMResetCoreClk,          // HW FSM Reset
  input  wire                     [47:0] bssID,                      // BSSID
  input  wire                      [7:0] timOffset,                  // Indicates to the HW the
                                                                     // offset, from the first byte
                                                                     // of the Beacon frame,
  input  wire                            pwrMgt,                     // Power Management is enabled
                                                                     // for the current transmission
  input  wire                      [7:0] dsssMaxPwrLevel,            // Maximum Power Level for
                                                                     // DSSS/CCK frames
  input  wire                      [7:0] ofdmMaxPwrLevel,            // Maximum Power Level for
                                                                     // OFDM frames
  input  wire                            activeClkGating,            // Active Clock Gating This
                                                                     // bit is set by SW to turn on
                                                                     // active clock gating in HW.
                                                                     // When reset, the HW does not
                                                                     // perform active clock
                                                                     // gating, i.e. does not turn
                                                                     // off
                                                                     // clocks to save power in
                                                                     // ACTIVE state.
  input  wire                            macPHYIFFIFOReset,          // Flush the FIFO
  output wire                            macPHYIFFIFOResetInValid,   // Flush the FIFO clear
  input  wire                            rateControllerMPIF,         // Select reverse handshaking
                                                                     // or PHy strobe tranmit
                                                                     // mechanism

  
  ///////////////////////////////////////////////
  //$port_g TX Controller interface with MAC timer unit interface
  ///////////////////////////////////////////////
  input  wire                            tickSlot_p,                 // slot indicator
  input  wire                            tickSIFS_p,                 // A pulse to indicate the end
                                                                     // of SIFS period
  input  wire                     [63:0] tsfTimer,                   // TSF timer value

  ///////////////////////////////////////////////
  //$port_g TX Controller interface with MAC controller
  ///////////////////////////////////////////////
  input  wire                            txRxExchangeEnabled,        // Indicates that tx or rx
                                                                     // echange is on-going  
  input  wire                            txInProgress,               // Tx Frame Exchange is ongoing
  input  wire                            sendOnSIFS,                 // If set; data is sent on
                                                                     // tickSIFS else on tickSlot
  input  wire                     [15:0] duration,                   // Duration
  input  wire                     [15:0] tsfDuration,                // Duration from the preamble
                                                                     // until the first bit of TSF

  ///////////////////////////////////////////////
  //$port_g TX Controller interface with Backoff
  ///////////////////////////////////////////////
  input  wire                      [2:0] activeAC,                   // Indicates which AC is
                                                                     // currently selected.

  ///////////////////////////////////////////////
  //$port_g Secondary Controller interface with MAC controller
  ///////////////////////////////////////////////
  input  wire                            secTxStart_p,               // Secondary path start
                                                                     // trigger pulse
  input  wire                            secTxAbort_p,               // If the transmitted frame has
                                                                     // to be aborted then this
                                                                     // signal is asserted.
  input  wire                      [2:0] txBWDropped,                // Indicates that the current
                                                                     // transmission BW has been
                                                                     // dropped to 20 Mhz, 40Mhz or
                                                                     // 80Mhz
  output wire                            secTxActive,                // Indicates that the secondary
                                                                     // path is active. A frame has
                                                                     // to be sent on this path.
  output wire                            secTxReady,                 // Indicates that the secondary
                                                                     // path is ready, Descriptor & 
                                                                     // Policy Table has been read.
  output wire                      [2:0] secTxNSTS,                  // Indicates the number of nSTS
                                                                     // of the secondary frame.

  ///////////////////////////////////////////////
  //$port_g TX Controller interface with Deaggregator
  ///////////////////////////////////////////////
  input  wire                            rxVector1Valid_p,           // Rx vector 1 is available

  ///////////////////////////////////////////////
  //$port_g MAC Phy interface with primary TX Controller
  ///////////////////////////////////////////////
  input  wire                      [7:0] txPwrLevel,                 // Transmit Power Level
  input  wire                      [1:0] chBW,                       // TX Vector Channel Bandwidth
  input  wire                            smoothing,                  // TX Vector Smoothing
                                                                     // recommended
  input  wire                      [7:0] antennaSet,                 // TX Vector Antenna Set
  input  wire                            beamFormed,                 // TX Vector BeamFormed
  input  wire                            preType,                    // TX Vector Preamble Type
  input  wire                      [2:0] formatMod,                  // TX Vector Format and
                                                                     // Modulation
  input  wire                      [1:0] numExtnSS,                  // TX Vector Number of
                                                                     // Extension Spatial Streams
  input  wire                      [1:0] stbc,                       // TX Vector Space Time Block
                                                                     // Coding
  input  wire                            disambiguityBit,            // TX Vector Disambiguity
  input  wire                      [8:0] partialAID,                 // TX Vector partial AID
  input  wire                      [5:0] groupID,                    // TX Vector group ID
  input  wire                            dozeNotAllowed,             // TX Vector TXOP PS Not
                                                                     // Allowed
  input  wire                            continuousTx,               // Enable continuous transmit 
  input  wire                            sounding,                   // TX Vector Indicates whether
                                                                     // this PPDU is Sounding
  input  wire                     [11:0] legLength,                  // TX Vector Legacy Length of
                                                                     // the PPDU
  input  wire                      [3:0] legRate,                    // TX Vector Legacy Rate of
                                                                     // the PPDU
  input  wire                     [15:0] service,                    // TX Vector Service
  input  wire                      [2:0] nTx,                        // TX Vector Number of
                                                                     // Transmit Chains.
  input  wire                            shortGI,                    // TX Vector Short Guard
                                                                     // Interval
  input  wire                            aggreation,                 // TX Vector MPDU Aggregate

  ///////////////////////////////////////////////
  //$port_g Key Search Engine interface
  ///////////////////////////////////////////////
  output wire  [`RW_KEY_INDEX_WIDTH-1:0] keySearchIndex,             // RAM Index to be searched
  output wire                            keySearchIndexTrig_p,       // Trigger for searching RAM
                                                                     // index and return contents
  input  wire                            keyStorageValid_p,          // Pulse signal indicating
                                                                     // completion of search
                                                                     // operation. Validates
                                                                     // outputs.
  input  wire                      [2:0] cTypeKSR,                   // Cipher Type found at Index
  input  wire                      [1:0] sppKSR,                     // SPP RAM value found at Index
  input  wire                    [127:0] cryptoKeyKSR,               // Value of crypto key at Index

  ///////////////////////////////////////////////
  //$port_g PHY interface
  ///////////////////////////////////////////////
  output wire                      [7:0] txData,                     // Tx data
  output wire                            macDataValid,               // data valid
  input  wire                            phyRdy,                     // data valid signal
  input  wire                            txEnd_p,                    // end of transaction
  input  wire                            phyErr_p,                   // phy error

  ///////////////////////////////////////////////
  //$port_g Primary DMA interface
  ///////////////////////////////////////////////
  input  wire                            trigTxACx_p,                // Transmit ACx Trigger
  input  wire                     [31:0] txACxHeadPtr,               // Transmit ACx List Head
                                                                     // Pointer

  ///////////////////////////////////////////////
  //$port_g Primary MAC-PHY
  ///////////////////////////////////////////////
  input  wire                            macPhyTxEnd_p,              // Transmit End
  output wire                            macPhySyncReady,            // Secondary Path is Ready
  input  wire                            macPhySyncStartTx_p,        // Secondary Path start trigger

  ///////////////////////////////////////////////
  //$port_g Debug Port
  ///////////////////////////////////////////////
  output wire                     [15:0] debugPortDMA1,              // Debug Port DMA 1
  output wire                     [15:0] debugPortDMA2,              // Debug Port DMA 2
  output wire                     [15:0] debugPortDMA3,              // Debug Port DMA 3
  output wire                     [15:0] debugPortDMA4,              // Debug Port DMA 4
  output wire                     [15:0] debugPortDMA5,              // Debug Port DMA 5
  output wire                     [15:0] debugPortDMA6,              // Debug Port DMA 6
  output wire                     [15:0] debugPortDMAStatus,         // Debug Port DMA Status
  output wire                     [15:0] debugPortDMATxStatus,       // Debug Port DMA
                                                                     // txStatusUpdater
  output wire                     [15:0] debugPortTxRxListA,         // Debug Port DMA Tx/Rx List
  output wire                     [15:0] debugPortDmaRdWrCtlr,       // Debug Port DMA Rd Wr
                                                                     // Controller
  output wire                     [15:0] debugPortTxParametersCache, // Debug Port from TX
                                                                     // Parameter Cache
  output wire                      [8:0] txControlCs,                // TX Controller current state
  output wire                      [8:0] txControlLs,                // TX Controller latched state
  output wire                     [15:0] debugPortTxFrameDebug1,     // Debug port for Tx frame
                                                                     // debug 1
  output wire                     [15:0] debugPortTxFrameDebug2,     // Debug port for Tx frame
                                                                     // debug 2
  output wire                     [31:0] debugPortEncryptionEngine,  // Debug Port of the
                                                                     // Encryption Engine
  output wire                     [15:0] debugPortMACPhyIf,          // Debug port from MAC PHY IF
  output wire                     [15:0] debugPortSecController,     // Debug port of the Secondary
                                                                     // Controller

  ///////////////////////////////////////////////
  //$port_g Memory Interface
  ///////////////////////////////////////////////
  ///////////////////////////////////////////////
  //$port_g TxFIFO 64*38 Two Ports SRAM
  ///////////////////////////////////////////////
  output wire                            txFIFOReadEn,               // Transmit FIFO Read Enable.
  output wire     [`TXFIFOADDRWIDTH-1:0] txFIFOReadAddr,             // Transmit FIFO Read Address
                                                                     // bus.
  input  wire                     [37:0] txFIFOReadData,             // Transmit FIFO Read Data bus.
  output wire                            txFIFOWriteEn,              // Transmit FIFO Write Enable.
  output wire     [`TXFIFOADDRWIDTH-1:0] txFIFOWriteAddr,            // Transmit FIFO Write Address
                                                                     // bus.
  output wire                     [37:0] txFIFOWriteData,            // Transmit FIFO Write Data
                                                                     // bus.

  ///////////////////////////////////////////////
  //$port_g MAC-PHY IF TX FIFO RAM 256*8 Two Ports SRAM
  ///////////////////////////////////////////////
  output wire                            mpIFTxFIFOReadEn,           // MAC-PHY Interface Transmit
                                                                     // FIFO Read Enable.
                                                                     // This signal is asserted for
                                                                     // read operations to the
                                                                     // MAC-PHY interface Transmit
                                                                     // FIFO.
  output wire     [`MPIFTXADDRWIDTH-1:0] mpIFTxFIFOReadAddr,         // MAC-PHY Interface Transmit
                                                                     // FIFO Read Address bus.
  input  wire                      [7:0] mpIFTxFIFOReadData,         // MAC-PHY Interface Transmit
                                                                     // FIFO Read Data bus.
  output wire                            mpIFTxFIFOWriteEn,          // MAC-PHY InterFace Transmit
                                                                     // FIFO Write Enable.
                                                                     // This signal is asserted for
                                                                     // write operations to the
                                                                     // MAC-PHY interface Transmit
                                                                     // FIFO.
  output wire     [`MPIFTXADDRWIDTH-1:0] mpIFTxFIFOWriteAddr,        // MAC-PHY Interface Transmit
                                                                     // FIFO Write Address bus.
  output wire                      [7:0] mpIFTxFIFOWriteData         // MAC-PHY Interface Transmit
                                                                     // FIFO Write Data bus.
);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////

// Internal Soft reset
wire          intMacPIClkSoftRst_n;              // soft reset on PI Clk domain
wire          intMacCoreClkSoftRst_n;            // soft reset on Core Clk domain
wire          macCoreTxClkSoftRst_n;             // Active low soft reset signal synchronized to
                                                 // the macCoreClk.

// Interconnect between DMA engine and $ToDo
wire          txListProcCsIsIdle;                // txListProc FSM is in IDLE state

// Interconnect between DMA engine and secondary Controller
wire          trigTxACxMC_p;                     // trigTxACx pulse on Core Clk domain
wire          statusUpdated_p;                   // Indication from the DMA that status have been
                                                 // updated.
wire          updateDMAStatus_p;                 // trigs the DMA Status update.
wire          txMpduDone_p;                      // Asserted high after every transmission of MPDU
                                                 // in an AMPDU frame
wire          ampduFrm_p;                        // Asserted high if the transmitted packet was an
wire          mpduSuccess_p;                     // If the transmitted frame was successful.
wire          mpduFailed_p;                      // If the transmitted frame was not successful.
wire    [3:0] whichDescriptorSW;                 // Indicates the value of the partAMorMSDU field
                                                 // Controller

// Interconnect between DMA engine and MAC-PHY IF
wire          macPHYIFUnderRun;                  // underrun status

// Interconnect between DMA engine and tx parameter cache
wire          txCtrlRegWr;                       // TX parameter Cache module signals
                                                 // Write signal to the Tx Parameter Cache.
wire   [31:0] txCtrlRegData;                     // TX parameter Cache module signals
                                                 // Write signal to the Tx Parameter Cache.
wire          txCtrlRegPT;                       // Indicates currently Policy table information is
                                                 // being passed.
wire          txCtrlRegHD;                       // Indicates currently Header descriptor
                                                 // information is being passed.
wire          discardPrevHD_p;                   // Signal to TX Parameter Cache module.
                                                 // Indicates to discard the recently
                                                 // fetch Header Descriptor.
wire          txCtrlRegBusy;                     // Indicates there are 2 sets of parameters
                                                 // already in the tx Parameter Cache module
                                                 // and not to fetch more.

// Interconnect between DMA engine and tx FIFO
wire          txFIFOAlmostFull;                  // Indicates that the TX FIFO is almost full
wire          txFIFOFull;                        // Indicates that the TX FIFO is full and cannot
                                                 // accept new write
wire          txFIFOFlushDone_p;                 // Indicates that the TX FIFO is flushed
wire          txFIFOAlmEmptyWrClk;               // Indicates that the TX FIFO is almost empty
wire          txFIFOEmptyWrClk;                  // Indicates that the TX FIFO is empty
wire          txFIFORead;                        // Request a new byte from the Tx FIFO
wire          txFIFOReadByFour;                  // Indicates that the TX FIFO has to be read
                                                 // per word and not per byte
wire          txFIFOReadByTwo;                   // Indicates that the TX FIFO has to be read
                                                 // per hlf-word and not per byte
wire          txFIFOEmpty;                       // Indicates that the TX FIFO is empty
wire          txFIFODataValid;                   // Indicates when the read data is valid
wire    [7:0] txFIFORdData;                      // Byte read from the TX FIFO
wire    [1:0] txFIFOMPDUDelimiters;              // Tag read from the TX FIFO
wire          txFIFOWrFlush;                     // Request from MAC Platform Clock domain to
                                                 // flush the FIFO
wire          txFIFOWrite;                       // Write a new word in the TX FIFO
wire   [31:0] txFIFOWrData;                      // Data written to the TX FIFO
wire    [5:0] txFIFOWrTag;                       // Tag written to the TX FIFO

// Interconnect between Tx Parameters Cache and the MAC Controller
wire          txParameterHDReady_p;              // Indicates that the Header Descriptor fields
                                                 // are usable
wire          txParameterPTReady_p;              // Indicates that the Policy Table fields
                                                 // are usable
wire          txPCtoggleHDSet_p;                 // Indicates that the Header Descriptor Set
                                                 // can be toggled
wire          txPCtogglePTSet_p;                 // Indicates that the Policy Table Set
                                                 // can be toggled
wire          txPCclearSets_p;                   // Indicates that the Sets have to be cleared.
wire          txPCtxParameterHDReady_p;          // Indicates that the Header Descriptor fields
                                                 // are usable
wire          txPCtxParameterPTReady_p;          // Indicates that the Policy Table fields are
                                                 // usable

// Interconnect between Tx Parameters Cache and the Secondary Controller
wire          toggleHDSet_p;                     // Indicates that the Header Descriptor Set can be
                                                 // toggled
wire          togglePTSet_p;                     // Indicates that the Policy Table Set can be
                                                 // toggled
wire          clearSets_p;                       // Indicates that the Sets have to be cleared.

// Interconnect between Tx Parameters Cache and P-Table MU-MIMO Control Information
wire          fecCodingPT;                       // FEC Coding
wire          txPCfecCodingPT;                   // FEC Coding
wire    [7:0] smmIndexPT;                        // Spatial Map Matrix Index
wire    [7:0] txPCsmmIndexPT;                    // Spatial Map Matrix Index
wire    [9:0] keySRAMIndex;                      // Key Storage RAM Index
wire    [9:0] txPCkeySRAMIndex;                  // Key Storage RAM Index
wire    [6:0] mcsIndex0Tx;                       // MCS Index 0 of PPDU for Transmission
wire    [6:0] txPCmcsIndex0Tx;                   // MCS Index 0 of PPDU for Transmission

// Interconnect between Tx Parameters Cache and H-Descriptor Status Information
wire   [19:0] aMPDUFrameLengthTx;                // Length of the entire A-MPDU
wire   [19:0] aMPDUOptFrameLength20Tx;           // Length of the entire A-MPDU BW drop 20 Mhz
wire   [19:0] aMPDUOptFrameLength40Tx;           // Length of the entire A-MPDU BW drop 40 Mhz
wire   [19:0] aMPDUOptFrameLength80Tx;           // Length of the entire A-MPDU BW drop 80 Mhz
//wire   [31:0] mediumTimeUsedTPC;
wire   [19:0] txPCaMPDUFrameLengthTx;            // Length of the entire A-MPDU
wire   [19:0] txPCaMPDUOptFrameLength20Tx;       // Length of the entire A-MPDU in case of
                                                 // BW drop 20Mhz
wire   [19:0] txPCaMPDUOptFrameLength40Tx;       // Length of the entire A-MPDU in case of
                                                 // BW drop 40Mhz
wire   [19:0] txPCaMPDUOptFrameLength80Tx;       // Length of the entire A-MPDU in case of
                                                 // BW drop 80Mhz
//wire   [31:0] txPCmediumTimeUsedTPC;


// Interconnect between Tx Parameters Cache and H-Descriptor Frame Lenght
wire   [15:0] MPDUFrameLengthTx;                 // Length of the MPDU
wire   [15:0] txPCMPDUFrameLengthTx;             // Length of the MPDU

// Interconnect between Tx Parameters Cache and H-Descriptor PHY Control Information 
wire          txSingleVHTMPDU;                   // Indicates that the AMPDU has only one MPDU
wire          txPCtxSingleVHTMPDU;               // Indicates that the AMPDU has only one MPDU
wire    [1:0] userPosition;                      // Indicates the user position of the A-MPDU inside
                                                 // a MUMIMO transmission
wire    [1:0] txPCuserPosition;                  // Indicates the user position of the A-MPDU inside
                                                 // a MUMIMO transmission

// Interconnect between Tx Parameters Cache and H-Descriptor MAC Control Information 2
wire          dontGenerateMH;                    // Indicates that HW should not generate the MAC
                                                 // Header by itself
wire          dontEncrypt;                       // Indicates that HW should bypassed the
                                                 // encryption operation during tx.
wire          dontTouchFC;                       // Indicates that HW should not update the
                                                 // Frame Control field,
wire          dontTouchDur;                      // Indicates that HW should not update the
                                                 // Duration field
wire          dontTouchQoS;                      // Indicates that HW should not update the
                                                 // QoS field
wire          dontTouchHTC;                      // Indicates that HW should not update the
                                                 // HTC field
wire          dontTouchTSF;                      // Indicates that HW should not update the
                                                 // TSF field
wire          dontTouchDTIM;                     // Indicates that HW should not update the
                                                 // DTIM Count field
wire          dontTouchFCS;                      // Indicates that HW should not update the
                                                 // FCS field
wire          underBASetup;                      // Indicates whether BA has been setup for
                                                 // this MPD
wire          aMPDU;                             // Indicates whether this Transmit Header
                                                 // Descriptor belong to an A-MPDU
wire    [1:0] whichDescriptor;                   // Indicates what kind of a descriptor this is
wire    [9:0] nBlankMDelimiters;                 // Indicates the number of blank MPDU delimiters
                                                 // that are inserted
wire          txPCdontGenerateMH;                // Indicates that HW should not generate the MAC
                                                 // Header by itself
wire          txPCdontEncrypt;                   // Indicates that HW should bypassed the
                                                 // encryption operation during tx.
wire          txPCdontTouchFC;                   // Indicates that HW should not update the
                                                 // Frame Control field,
wire          txPCdontTouchDur;                  // Indicates that HW should not update the
                                                 // Duration field
wire          txPCdontTouchQoS;                  // Indicates that HW should not update the
                                                 // QoS field
wire          txPCdontTouchHTC;                  // Indicates that HW should not update the
                                                 // HTC field
wire          txPCdontTouchTSF;                  // Indicates that HW should not update the
                                                 // TSF field
wire          txPCdontTouchDTIM;                 // Indicates that HW should not update the
                                                 // DTIM Count field
wire          txPCdontTouchFCS;                  // Indicates that HW should not update the
                                                 // FCS field
wire          txPCunderBASetup;                  // Indicates whether BA has been setup for
                                                 // this MPD
wire          txPCaMPDU;                         // Indicates whether this Transmit Header
                                                 // Descriptor belong to an A-MPDU
wire    [1:0] txPCwhichDescriptor;               // Indicates what kind of a descriptor this is
wire    [9:0] txPCnBlankMDelimiters;             // Indicates the number of blank MPDU delimiters
                                                 // that are inserted

// Interconnect between TX controller and MAC Timer Unit
wire          tickSlotTxController_p;            // slot indicator for the txController. This is
                                                 // tickSlot_p gated by txInProgress

// Interconnect between TX controller and secondary controller
wire          sendData_p;                        // Indication that data packet has to be sent
wire    [2:0] formatModTx;                       // Format and Modulation of PPDU for Transmission
wire   [19:0] txHTLength;                        // Length of the HT PPDU
wire          txFromFifo;                        // Transmit a Frame from Tx FIFO
wire          txDone_p;                          // Indicates the completion of the transmission
wire          mpduDone_p;                        // Indicates that the MPDU has been sent

// Interconnect between TX controller and MAC-PHY interface
wire          mpIfTxFifoFull;                    // FIFO status
wire          mpIfTxFifoAlmostFull;              // FIFO status
wire          mpIfTxErr_p;                       // Transmit error
wire          mpIfTxEn;                          // Transmit Enable
wire          startTx_p;                         // Start Tx trigger
wire          stopTx_p;                          // Stop Tx trigger
reg           secValidTx;                        // Indicate that Tx Path is valid
wire    [7:0] mpIfTxFifoData;                    // Data to transmit
wire          mpIfTxFifoWrite;                   // Data valid
wire    [7:0] smmIndex;                          // TX Vector Spatial Map Matrix Index
wire    [6:0] mcs;                               // TX Vector Modulation Coding Scheme
wire    [2:0] nSTS;                              // TX Vector Indicates the number of space-time
                                                 // streams.
wire          fecCoding;                         // TX Vector FEC Coding
wire   [19:0] htLength;                          // TX Vector Length of the HT and VHT PPDU
wire          hwErr;                             // HW error detected

// Interconnect between TX controller and FCS
wire          fcsEnd_p;                          // indicates the end of the transmission
wire          fcsBusy;                           // indicates that the FCS block is busy cannot
                                                 // accept new data.
wire          fcsDOutValid;                      // indicates that the fcsDOut is valid.
wire    [7:0] fcsDOut;                           // Data from the FCS block
wire          fcsEnableTx;                       // FCS enable
wire          fcsStartTx_p;                      // Initialize CRC
wire          fcsShiftTx;                        // Shift CRC on fcsDOut controlled by TX Controller
wire          fcsDInValidTx;                     // data input is valid
wire    [7:0] fcsDInTx;                          // data input

// Interconnect between TX Controller and Encryption Engine interface
wire          txCryptoKeyValid;                  // Indicates that the Key is valid
wire    [7:0] plainTxData;                       // Plain (unencrypted) data from TX Controller
wire          plainTxDataValid;                  // Validating signal for plain TX data
wire    [7:0] encryptDataOut;                    // Encrypted data output; for writing into FCS
                                                 // block
wire          encryptDataValid;                  // Validating signal for the output encrypted data.
                                                 // This signal will be asserted only when
                                                 // fcsBusy input is low.
wire          txError_p;                         // Indication of error signal from TX Controller
                                                 // during transmission operation
wire          txCsIsIdle;                        // State machine information from TX Controller
wire          txCCMP;                            // Indication for CCMP encryption
wire          txCCMPBusy;
wire          txCCMPMicDone;
wire          txCCMPStart;                       // Tx controller start CCMP
wire          txCCMPDataWrEn_p;                  // Write pulse for CCMP input buffer for TX
wire          txAddress4Pres;                    // Tx flag indicating address 4 is present
wire          txQoSFrame;                        // Tx flag indicating the current frame is a QoS
                                                 // Frame
wire          txCCMPHT;                          // Tx HT flag
wire          txPayLoadEnd_p;                    // End of payload from TX Controller needed by CCMP
wire          ccmpHTMode;                        // Flag for HT mode
                                                 // Following TX inputs are used in CCMP engine
                                                 // for Nonce or AAD calculation
                                                 // =========================================
wire   [15:0] tcPayLoadLen;                      // Transmit payload length in TX Frame
wire   [47:0] txAddr1;                           // Address1 field of TX frame
wire   [47:0] txAddr2;                           // Address1 field of TX frame
wire   [47:0] macAddress;                        // MAC address of the system
wire   [47:0] tcSfc;                             // Transmit SFC field in TX Frame
                                                 // and transformation phases
wire    [7:0] txEncrData;                        // Encrytped TKIP/WEP/CCMP data from Encrypt
                                                 // Engine to Tx Controller
wire          txEncrDataValid;                   // Encrytped  TKIP/WEP/CCMP data valid from
                                                 // Encrypt Engine to Tx Controller
wire    [3:0] txTID;                             // TID of the transmitted frame
wire          txAMSDUPresent;                    // A-MSDU Present

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Soft reset for mac core blocks
assign intMacPIClkSoftRst_n   =  !hwFSMResetPIClk   && macPIClkSoftRst_n;
assign intMacCoreClkSoftRst_n =  !hwFSMResetCoreClk && macCoreClkSoftRst_n;
assign macCoreTxClkSoftRst_n  =  intMacCoreClkSoftRst_n && !mpIfTxErr_p && !macPHYIFUnderRun;

// DMA State
always @(posedge macPIClk or negedge macPIClkHardRst_n)
begin
  if (macPIClkHardRst_n == 1'b0)
    dmaIsHalted <= 1'b1;
  else if (macPIClkSoftRst_n == 1'b0)
    dmaIsHalted <= 1'b1;
  else
  begin
    if (txACxState == 2'b00) // HALTED
      dmaIsHalted <= 1'b1;
    else
      dmaIsHalted <= 1'b0;
  end
end

// Instanciation of dmaEngineWrapper
// Name of the instance : U_dmaEngineWrapper
// Name of the file containing this module : dmaEngineWrapper.v
dmaEngineWrapper #(
    .SECONDARY                        (1)
) U_dmaEngineWrapper (
    .macPIClk                         (macPIClk),
    .macPITxClk                       (macPITxClk),
    .macPIRxClk                       (1'b0),
    .macCoreClk                       (macCoreClk),
    .macCoreRxClk                     (1'b0),
    .macPITxClkHardRst_n              (macPIClkHardRst_n),
    .macPIRxClkHardRst_n              (1'b0),
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macPITxClkSoftRst_n              (dmaSoftRst_n),
    .macPIRxClkSoftRst_n              (1'b0),
    .macPIClkSoftRst_n                (dmaSoftRst_n),
    .dmaHIFReadDataOut                (dmaHIFReadDataOut),
    .dmaHIFReadDataValid              (dmaHIFReadDataValid),
    .dmaHIFReady                      (dmaHIFReady),
    .dmaHIFTransComplete              (dmaHIFTransComplete),
    .dmaHIFError                      (dmaHIFError),
    .trigTxAC0                        (1'b0),
    .trigTxAC1                        (1'b0),
    .trigTxAC2                        (1'b0),
    .trigTxAC3                        (1'b0),
    .trigTxBcn                        (1'b0),
    .trigTxAC0PI                      (trigTxAC0PI),
    .trigTxAC1PI                      (trigTxAC1PI),
    .trigTxAC2PI                      (trigTxAC2PI),
    .trigTxAC3PI                      (trigTxAC3PI),
    .trigTxBcnPI                      (1'b0),
    .frameRxed_p                      (1'b0),
    .rxListProcCsIsIdle               (/*Open*/),
    .txListProcCsIsIdle               (txListProcCsIsIdle),
    .tsfTimerValue                    (tsfTimerLowIn),
    .swRTS_p                          (1'b0),
    .txMpduDone_p                     (txMpduDone_p),
    .ampduFrm_p                       (ampduFrm_p),
    .retryFrame_p                     (1'b0),
    .secTxAbort_p                     (secTxAbort_p),
    .mpduSuccess_p                    (mpduSuccess_p),
    .mpduFailed_p                     (mpduFailed_p),
    .rtsFailed_p                      (1'b0),
    .rtsSuccess_p                     (1'b0),
    .retryLimitReached_p              (1'b0),
    .transmissionBW                   (transmissionBW),
    .numMPDURetries                   (8'b0),
    .numRTSRetries                    (8'b0),
    .mediumTimeUsed                   (mediumTimeUsed),
    .rxFrmDiscard                     (/*Open*/),
    .rxDescAvailable                  (/*Open*/),
    .trigTxACx_p                      (trigTxACx_p),
    .txACxHeadPtr                     (txACxHeadPtr),
`ifdef  RW_MUMIMO_SEC_USER1_EN
    .trigTxUser1_p                    (/*Open*/),
    .txUser1HeadPtr                   (/*Open*/),
`endif//RW_MUMIMO_SEC_USER1_EN
`ifdef  RW_MUMIMO_SEC_USER2_EN
    .trigTxUser2_p                    (/*Open*/),
    .txUser2HeadPtr                   (/*Open*/),
`endif//RW_MUMIMO_SEC_USER2_EN
`ifdef  RW_MUMIMO_SEC_USER3_EN
    .trigTxUser3_p                    (/*Open*/),
    .txUser3HeadPtr                   (/*Open*/),
`endif//RW_MUMIMO_SEC_USER3_EN
    .rxFlowCntrlEn                    (1'b0),
    .whichDescriptorSW                (whichDescriptorSW),
    .macPHYIFUnderRun                 (macPHYIFUnderRun),
    .txBcnHeadPtr                     (32'h0),
    .txAC0HeadPtr                     (32'h0),
    .txAC1HeadPtr                     (32'h0),
    .txAC2HeadPtr                     (32'h0),
    .txAC3HeadPtr                     (32'h0),
    .rxHeaderHeadPtr                  (30'h0),
    .rxHeaderHeadPtrValid             (1'b0),
    .rxPayloadHeadPtr                 (30'h0),
    .rxPayloadHeadPtrValid            (1'b0),
    .rxPayloadUsedCount               (8'h0),
    .txCtrlRegBusy                    (txCtrlRegBusy),
    .txFifoAlmostFull                 (txFIFOAlmostFull),
    .txFifoFull                       (txFIFOFull),
    .txFIFOFlushDone_p                (txFIFOFlushDone_p),
    .txFifoEmpty                      (txFIFOEmptyWrClk),
    .rxFifoEmpty                      (1'b0),
    .rxFIFOAlmEmpty                   (1'b0),
    .rxFifoRdData                     (32'b0),
    .rxTagFifoRdData                  (4'b0),
    .dmaHIFRead                       (dmaHIFRead),
    .dmaHIFWrite                      (dmaHIFWrite),
    .dmaHIFSize                       (dmaHIFSize),
    .dmaHIFAddressIn                  (dmaHIFAddressIn),
    .dmaHIFWriteDataIn                (dmaHIFWriteDataIn),
    .txCtrlRegWr                      (txCtrlRegWr),
    .txCtrlRegPT                      (txCtrlRegPT),
    .txCtrlRegHD                      (txCtrlRegHD),
    .discardPrevHD_p                  (discardPrevHD_p),
    .txAC0State                       (/*Open*/),
    .txAC1State                       (/*Open*/),
    .txAC2State                       (/*Open*/),
    .txAC3State                       (/*Open*/),
    .txACxState                       (txACxState),
    .txBcnState                       (/*Open*/),
    .rxHeaderState                    (/*Open*/),
    .rxPayloadState                   (/*Open*/),
    .txAC0StateMC                     (/*Open*/),
    .txAC1StateMC                     (/*Open*/),
    .txAC2StateMC                     (/*Open*/),
    .txAC3StateMC                     (/*Open*/),
    .txBcnStateMC                     (/*Open*/),
    .txBcnLenMismatch                 (/*Open*/),
    .txAC0LenMismatch                 (/*Open*/),
    .txAC1LenMismatch                 (/*Open*/),
    .txAC2LenMismatch                 (/*Open*/),
    .txAC3LenMismatch                 (/*Open*/),
    .txBcnUPatternErr                 (/*Open*/),
    .txAC0UPatternErr                 (/*Open*/),
    .txAC1UPatternErr                 (/*Open*/),
    .txAC2UPatternErr                 (/*Open*/),
    .txAC3UPatternErr                 (/*Open*/),
    .txBcnNextPointerErr              (/*Open*/),
    .txAC0NextPointerErr              (/*Open*/),
    .txAC1NextPointerErr              (/*Open*/),
    .txAC2NextPointerErr              (/*Open*/),
    .txAC3NextPointerErr              (/*Open*/),
    .txBcnPTAddressErr                (/*Open*/),
    .txAC0PTAddressErr                (/*Open*/),
    .txAC1PTAddressErr                (/*Open*/),
    .txAC2PTAddressErr                (/*Open*/),
    .txAC3PTAddressErr                (/*Open*/),
    .txBcnBusErr                      (/*Open*/),
    .txAC0BusErr                      (/*Open*/),
    .txAC1BusErr                      (/*Open*/),
    .txAC2BusErr                      (/*Open*/),
    .txAC3BusErr                      (/*Open*/),
    .txBcnNewHeadErr                  (/*Open*/),
    .txAC0NewHeadErr                  (/*Open*/),
    .txAC1NewHeadErr                  (/*Open*/),
    .txAC2NewHeadErr                  (/*Open*/),
    .txAC3NewHeadErr                  (/*Open*/),
    .txACxNewHeadErr                  (txACxNewHeadErr),
    .rxHdrUPatternErr                 (/*Open*/),
    .rxPayUPatternErr                 (/*Open*/),
    .rxHdrNextPointerErr              (/*Open*/),
    .rxPayNextPointerErr              (/*Open*/),
    .rxHdrBusErr                      (/*Open*/),
    .rxPayBusErr                      (/*Open*/),
    .rxHdrNewHeadErr                  (/*Open*/),
    .rxPayNewHeadErr                  (/*Open*/),
    .ptError                          (ptError),
    .txBcnStartup                     (/*Open*/),
    .txAC0Startup                     (/*Open*/),
    .txAC1Startup                     (/*Open*/),
    .txAC2Startup                     (/*Open*/),
    .txAC3Startup                     (/*Open*/),
    .txACxStartup                     (txACxStartup),
    .txBcnEndQ                        (/*Open*/),
    .txAC0EndQ                        (/*Open*/),
    .txAC1EndQ                        (/*Open*/),
    .txAC2EndQ                        (/*Open*/),
    .txAC3EndQ                        (/*Open*/),
    .txACxEndQ                        (txACxEndQ),
    .txBcnHaltAfterTXOP               (/*Open*/),
    .txAC0HaltAfterTXOP               (/*Open*/),
    .txAC1HaltAfterTXOP               (/*Open*/),
    .txAC2HaltAfterTXOP               (/*Open*/),
    .txAC3HaltAfterTXOP               (/*Open*/),
    .debugPortDMA1                    (debugPortDMA1),
    .debugPortDMA2                    (debugPortDMA2),
    .debugPortDMA3                    (debugPortDMA3),
    .debugPortDMA4                    (debugPortDMA4),
    .debugPortDMA5                    (debugPortDMA5),
    .debugPortDMA6                    (debugPortDMA6),
    .debugPortDMAStatus               (debugPortDMAStatus),
    .debugPortDMATxStatus             (debugPortDMATxStatus),
    .debugPortTxRxListA               (debugPortTxRxListA),
    .debugPortDmaRdWrCtlr             (debugPortDmaRdWrCtlr),
    .dmaInternalError                 (dmaInternalError),
    .statusUpdated_p                  (statusUpdated_p),
    .updateDMAStatus_p                (updateDMAStatus_p),
    .rxTrig_p                         (/*Open*/),
    .txFifoWr                         (txFIFOWrite),
    .txFIFOWrData                     (txFIFOWrData),
    .flushTxFifo                      (txFIFOWrFlush),
    .rxFifoRd                         (/*Open*/),
    .txTagFifoWrData                  (txFIFOWrTag),
    .rxHeaderDMADead                  (/*Open*/),
    .rxPayloadDMADead                 (/*Open*/),
    .bcnTxDMADead                     (/*Open*/),
    .ac0TxDMADead                     (/*Open*/),
    .ac1TxDMADead                     (/*Open*/),
    .ac2TxDMADead                     (/*Open*/),
    .ac3TxDMADead                     (/*Open*/),
    .acxTxDMADead                     (acxTxDMADead),
    .rxDMAEmpty                       (/*Open*/),
    .ac0TxTrigger                     (ac0TxTrigger),
    .ac1TxTrigger                     (ac1TxTrigger),
    .ac2TxTrigger                     (ac2TxTrigger),
    .ac3TxTrigger                     (ac3TxTrigger),
    .bcnTxTrigger                     (/*Open*/),
    .ac0TxBufTrigger                  (ac0TxBufTrigger),
    .ac1TxBufTrigger                  (ac1TxBufTrigger),
    .ac2TxBufTrigger                  (ac2TxBufTrigger),
    .ac3TxBufTrigger                  (ac3TxBufTrigger),
    .bcnTxBufTrigger                  (/*Open*/),
    .rxTrigger                        (/*Open*/),
    .counterRxTrigger                 (/*Open*/),
    .statussettxAC0NewTail            (/*Open*/),
    .statussettxAC1NewTail            (/*Open*/),
    .statussettxAC2NewTail            (/*Open*/),
    .statussettxAC3NewTail            (/*Open*/),
    .statussettxBcnNewTail            (/*Open*/),
    .statussettxAC0NewHead            (/*Open*/),
    .statussettxAC1NewHead            (/*Open*/),
    .statussettxAC2NewHead            (/*Open*/),
    .statussettxAC3NewHead            (/*Open*/),
    .statussettxBcnNewHead            (/*Open*/),
    .statussetrxHeaderNewTail         (/*Open*/),
    .statussetrxHeaderNewHead         (/*Open*/),
    .statussetrxPayloadNewTail        (/*Open*/),
    .statussetrxPayloadNewHead        (/*Open*/),
    .statussethaltBcnAfterTXOP        (/*Open*/),
    .statussethaltAC3AfterTXOP        (/*Open*/),
    .statussethaltAC2AfterTXOP        (/*Open*/),
    .statussethaltAC1AfterTXOP        (/*Open*/),
    .statussethaltAC0AfterTXOP        (/*Open*/),
    .settxAC0NewTail                  (1'b0),
    .settxAC1NewTail                  (1'b0),
    .settxAC2NewTail                  (1'b0),
    .settxAC3NewTail                  (1'b0),
    .settxBcnNewTail                  (1'b0),
    .settxAC0NewHead                  (1'b0),
    .settxAC1NewHead                  (1'b0),
    .settxAC2NewHead                  (1'b0),
    .settxAC3NewHead                  (1'b0),
    .settxBcnNewHead                  (1'b0),
    .setrxHeaderNewTail               (1'b0),
    .setrxHeaderNewHead               (1'b0),
    .setrxPayloadNewTail              (1'b0),
    .setrxPayloadNewHead              (1'b0),
    .sethaltBcnAfterTXOP              (1'b0),
    .sethaltAC3AfterTXOP              (1'b0),
    .sethaltAC2AfterTXOP              (1'b0),
    .sethaltAC1AfterTXOP              (1'b0),
    .sethaltAC0AfterTXOP              (1'b0),
    .cleartxAC0NewTail                (1'b0),
    .cleartxAC1NewTail                (1'b0),
    .cleartxAC2NewTail                (1'b0),
    .cleartxAC3NewTail                (1'b0),
    .cleartxBcnNewTail                (1'b0),
    .cleartxAC0NewHead                (1'b0),
    .cleartxAC1NewHead                (1'b0),
    .cleartxAC2NewHead                (1'b0),
    .cleartxAC3NewHead                (1'b0),
    .cleartxBcnNewHead                (1'b0),
    .clearrxHeaderNewTail             (1'b0),
    .clearrxHeaderNewHead             (1'b0),
    .clearrxPayloadNewTail            (1'b0),
    .clearrxPayloadNewHead            (1'b0),
    .clearhaltBcnAfterTXOP            (1'b0),
    .clearhaltAC3AfterTXOP            (1'b0),
    .clearhaltAC2AfterTXOP            (1'b0),
    .clearhaltAC1AfterTXOP            (1'b0),
    .clearhaltAC0AfterTXOP            (1'b0),
    .ac0StatusPointer                 (/*Open*/),
    .ac1StatusPointer                 (/*Open*/),
    .ac2StatusPointer                 (/*Open*/),
    .ac3StatusPointer                 (/*Open*/),
    .txCurrentPointer                 (txCurrentPointer),
    .bcnStatusPointer                 (/*Open*/),
    .rxHdrStatPointer                 (/*Open*/),
    .rxPayStatPointer                 (/*Open*/),
    .rxPayCurrentPointer              (/*Open*/)
);

assign txCtrlRegData = dmaHIFReadDataOut;


// Instanciation of txFifo
// Name of the instance : U_txFifo
// Name of the file containing this module : txFifo.v
txFifo U_txFifo (
    .macPITxClk                       (macPITxClk),
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (txFifoSoftRst_n),
    .txFIFOReset                      (txFIFOReset),
    .txFIFOResetInValid               (txFIFOResetInValid),
    .txFIFOWrFlush                    (txFIFOWrFlush),
    .txFIFOWrite                      (txFIFOWrite),
    .txFIFOWrData                     (txFIFOWrData),
    .txFIFOWrTag                      (txFIFOWrTag),
    .txFIFOAlmostFull                 (txFIFOAlmostFull),
    .txFIFOFull                       (txFIFOFull),
    .txFIFOAlmEmptyWrClk              (txFIFOAlmEmptyWrClk),
    .txFIFOEmptyWrClk                 (txFIFOEmptyWrClk),
    .txFIFORdFlush                    (txFIFORdFlush),
    .txFIFORead                       (txFIFORead),
    .txFIFOReadByFour                 (txFIFOReadByFour),
    .txFIFOReadByTwo                  (txFIFOReadByTwo),
    .txFIFOEmpty                      (txFIFOEmpty),
    .txFIFODataValid                  (txFIFODataValid),
    .txFIFORdData                     (txFIFORdData),
    .txFIFOMPDUDelimiters             (txFIFOMPDUDelimiters),
    .txFIFOReadData                   (txFIFOReadData),
    .txFIFOReadAddr                   (txFIFOReadAddr),
    .txFIFOReadEn                     (txFIFOReadEn),
    .txFIFOWriteAddr                  (txFIFOWriteAddr),
    .txFIFOWriteData                  (txFIFOWriteData),
    .txFIFOWriteEn                    (txFIFOWriteEn)
);


// Instanciation of macCorePIResync
// Name of the instance : U_macCorePIResync
// Name of the file containing this module : macCorePIResync.v
macCorePIResync U_macCorePIResync (
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreClkSoftRst_n              (intMacCoreClkSoftRst_n),
    .macPIClk                         (macPIClk),
    .macPITxClk                       (macPITxClk),
    .macCoreClk                       (macCoreClk),
    .tick1us_p                        (1'b0),
    .tsfTimer                         (64'b0),
    .nextStatePlClkReg                (4'b0),
    .latchNextStatePlClk_p            (1'b0),
    .ac1MOT                           (/*Open*/),
    .ac0MOT                           (/*Open*/),
    .ac3MOT                           (/*Open*/),
    .ac2MOT                           (/*Open*/),
    .tsfTimerLowIn                    (/*Open*/),
    .tsfTimerLowInValid               (/*Open*/),
    .tsfTimerHighIn                   (/*Open*/),
    .tsfTimerHighInValid              (/*Open*/),
    .txBWAfterDropResync              (/*Open*/),
    .ac1MOTMC                         (16'b0),
    .ac0MOTMC                         (16'b0),
    .ac3MOTMC                         (16'b0),
    .ac2MOTMC                         (16'b0),
    .toggleHDSet_p                    (toggleHDSet_p),
    .togglePTSet_p                    (togglePTSet_p),
    .clearSets_p                      (clearSets_p),
    .txParameterHDReady_p             (txParameterHDReady_p),
    .txParameterPTReady_p             (txParameterPTReady_p),
    .txParameterNextPTReady_p         (/*Open*/),
    .nextStateCoreClkReg              (/*Open*/),
    .acBWDropTrigger                  (1'b0),
    .txBWAfterDrop                    (2'b0),
    .txPCtoggleHDSet_p                (txPCtoggleHDSet_p),
    .txPCtogglePTSet_p                (txPCtogglePTSet_p),
    .txPCclearSets_p                  (txPCclearSets_p),
    .txPCtxParameterHDReady_p         (txPCtxParameterHDReady_p),
    .txPCtxParameterPTReady_p         (txPCtxParameterPTReady_p),
    .txPCtxParameterNextPTReady_p     (1'b0),
    .txPCnTxProtPT                    (3'b0),
    .txPCnTxPT                        (3'b0),
    .txPCshortGIPT                    (1'b0),
    .txPCtxPwrLevelPT                 (8'b0),
    .txPCtxPwrLevelProtPT             (8'b0),
    .txPCstbcPT                       (2'b0),
    .txPCfecCodingPT                  (txPCfecCodingPT),
    .txPCnumExtnSSPT                  (2'b0),
    .txPCbfFrmExPT                    (1'b0),
    .txPCbeamFormedPT                 (1'b0),
    .txPCsmmIndexPT                   (txPCsmmIndexPT),
    .txPCantennaSetPT                 (8'b0),
    .txPCkeySRAMIndex                 (txPCkeySRAMIndex),
    .txPCkeySRAMIndexRA               (10'b0),
    .txPCrtsThreshold                 (12'b0),
    .txPCshortRetryLimit              (8'b0),
    .txPClongRetryLimit               (8'b0),
    .txPCaMPDUFrameLengthTx           (txPCaMPDUFrameLengthTx),
    .txPCaMPDUOptFrameLength20Tx      (txPCaMPDUOptFrameLength20Tx),
    .txPCaMPDUOptFrameLength40Tx      (txPCaMPDUOptFrameLength40Tx),
    .txPCaMPDUOptFrameLength80Tx      (txPCaMPDUOptFrameLength80Tx),
    .txPCtxSingleVHTMPDU              (txPCtxSingleVHTMPDU),
    .txPCMPDUFrameLengthTx            (txPCMPDUFrameLengthTx),
    .txPCmcsIndex0ProtTx              (7'b0),
    .txPCmcsIndex0Tx                  (txPCmcsIndex0Tx),
    .txPCmuMIMOTx                     (1'b0),
    .txPCuserPosition                 (txPCuserPosition),
    .txPCcontinuousTx                 (1'b0),
    .txPCformatModProtTx              (3'b0),
    .txPCformatModTx                  (3'b0),
    .txPCpreTypeProtTx                (1'b0),
    .txPCpreTypeTx                    (1'b0),
    .txPCbwProtTx                     (2'b0),
    .txPCbwTx                         (2'b0),
    .txPCpartialAIDTx                 (9'b0),
    .txPCgroupIDTx                    (6'b0),
    .txPCdozeNotAllowedTx             (1'b0),
    .txPCdynBWTx                      (1'b0),
    .txPCuseBWSignalingTx             (1'b0),
    .txPCsmoothingProtTx              (1'b0),
    .txPCsmoothingTx                  (1'b0),
    .txPCsoundingTx                   (1'b0),
    .txPCprotFrmDur                   (16'b0),
    .txPCwriteACK                     (1'b0),
    .txPClowRateRetry                 (1'b0),
    .txPClstpProt                     (1'b0),
    .txPClstp                         (1'b0),
    .txPCexpectedAck                  (2'b0),
    .txPCnavProtFrmEx                 (3'b0),
    .txPCdontGenerateMH               (txPCdontGenerateMH),
    .txPCdontEncrypt                  (txPCdontEncrypt),
    .txPCdontTouchFC                  (txPCdontTouchFC),
    .txPCdontTouchDur                 (txPCdontTouchDur),
    .txPCdontTouchQoS                 (txPCdontTouchQoS),
    .txPCdontTouchHTC                 (txPCdontTouchHTC),
    .txPCdontTouchTSF                 (txPCdontTouchTSF),
    .txPCdontTouchDTIM                (txPCdontTouchDTIM),
    .txPCdontTouchFCS                 (txPCdontTouchFCS),
    .txPCunderBASetup                 (txPCunderBASetup),
    .txPCaMPDUOut                     (txPCaMPDU),
    .txPCwhichDescriptor              (txPCwhichDescriptor),
    .txPCnBlankMDelimiters            (txPCnBlankMDelimiters),
    .txPCinterruptEnTx                (1'b0),
    .txPCfcSubtype                    (4'b0),
    .txPCfcType                       (2'b0),
    .txPCtsValid                      (1'b0),
    .txPClifetimeExpired              (1'b0),
    .txPCnumMPDURetries               (8'b0),
    .txPCnumRTSRetries                (8'b0),
    .txPCmediumTimeUsed               (32'b0), //txPCmediumTimeUsedTPC), //$ToDo: To be clarified
    .nTxProtPT                        (/*Open*/),
    .nTxPT                            (/*Open*/),
    .shortGIPT                        (/*Open*/),
    .txPwrLevelPT                     (/*Open*/),
    .txPwrLevelProtPT                 (/*Open*/),
    .stbcPT                           (/*Open*/),
    .fecCodingPT                      (fecCodingPT),
    .numExtnSSPT                      (/*Open*/),
    .bfFrmExPT                        (/*Open*/),
    .beamFormedPT                     (/*Open*/),
    .smmIndexPT                       (smmIndexPT),
    .antennaSetPT                     (/*Open*/),
    .keySRAMIndex                     (keySRAMIndex),
    .keySRAMIndexRA                   (/*Open*/),
    .rtsThreshold                     (/*Open*/),
    .shortRetryLimit                  (/*Open*/),
    .longRetryLimit                   (/*Open*/),
    .aMPDUFrameLengthTx               (aMPDUFrameLengthTx),
    .aMPDUOptFrameLength20Tx          (aMPDUOptFrameLength20Tx),
    .aMPDUOptFrameLength40Tx          (aMPDUOptFrameLength40Tx),
    .aMPDUOptFrameLength80Tx          (aMPDUOptFrameLength80Tx),
    .txSingleVHTMPDU                  (txSingleVHTMPDU),
    .MPDUFrameLengthTx                (MPDUFrameLengthTx),
    .mcsIndex0ProtTx                  (/*Open*/),
    .mcsIndex0Tx                      (mcsIndex0Tx),
    .muMIMOTx                         (/*Open*/),
    .userPosition                     (userPosition),
    .continuousTx                     (/*Open*/),
    .formatModProtTx                  (/*Open*/),
    .formatModTx                      (/*Open*/),
    .preTypeProtTx                    (/*Open*/),
    .preTypeTx                        (/*Open*/),
    .bwProtTx                         (/*Open*/),
    .bwTx                             (/*Open*/),
    .partialAIDTx                     (/*Open*/),
    .groupIDTx                        (/*Open*/),
    .dozeNotAllowedTx                 (/*Open*/),
    .dynBWTx                          (/*Open*/),
    .useBWSignalingTx                 (/*Open*/),
    .smoothingProtTx                  (/*Open*/),
    .smoothingTx                      (/*Open*/),
    .soundingTx                       (/*Open*/),
    .protFrmDur                       (/*Open*/),
    .writeACK                         (/*Open*/),
    .lowRateRetry                     (/*Open*/),
    .lstpProt                         (/*Open*/),
    .lstp                             (/*Open*/),
    .expectedAck                      (/*Open*/),
    .navProtFrmEx                     (/*Open*/),
    .dontGenerateMH                   (dontGenerateMH),
    .dontEncrypt                      (dontEncrypt),
    .dontTouchFC                      (dontTouchFC),
    .dontTouchDur                     (dontTouchDur),
    .dontTouchQoS                     (dontTouchQoS),
    .dontTouchHTC                     (dontTouchHTC),
    .dontTouchTSF                     (dontTouchTSF),
    .dontTouchDTIM                    (dontTouchDTIM),
    .dontTouchFCS                     (dontTouchFCS),
    .underBASetup                     (underBASetup),
    .aMPDUOut                         (aMPDU),
    .whichDescriptor                  (whichDescriptor),
    .nBlankMDelimiters                (nBlankMDelimiters),
    .interruptEnTx                    (/*Open*/),
    .fcSubtype                        (/*Open*/),
    .fcType                           (/*Open*/),
    .tsValid                          (/*Open*/),
    .lifetimeExpired                  (/*Open*/),
    .numMPDURetries                   (/*Open*/),
    .numRTSRetries                    (/*Open*/),
    .mediumTimeUsed                   (/*Open*/) //mediumTimeUsedTPC), //$ToDo: To be clarified
);


// !!! Auto instanciation does not work !!!
// Instanciation of txParametersCache
// Name of the instance : U_txParametersCache
// Name of the file containing this module : txParametersCache.v
txParametersCache #(
    .SECONDARY                        (1)
) U_txParametersCache (
    .macPITxClk                       (macPITxClk),
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .macPIClkSoftRst_n                (intMacPIClkSoftRst_n),
    .txCtrlRegWr                      (txCtrlRegWr),
    .txCtrlRegData                    (txCtrlRegData),
    .txCtrlRegPT                      (txCtrlRegPT),
    .txCtrlRegHD                      (txCtrlRegHD),
    .discardPrevHD_p                  (discardPrevHD_p),
    .txCtrlRegBusy                    (txCtrlRegBusy),
    .toggleHDSet_p                    (txPCtoggleHDSet_p),
    .togglePTSet_p                    (txPCtogglePTSet_p),
    .clearSets_p                      (txPCclearSets_p),
    .txParameterHDReady_p             (txPCtxParameterHDReady_p),
    .txParameterPTReady_p             (txPCtxParameterPTReady_p),
    .txParameterNextPTReady_p         (/*Open*/),
    .nTxProtPT                        (/*Open*/),
    .nTxPT                            (/*Open*/),
    .shortGIPT                        (/*Open*/),
    .txPwrLevelPT                     (/*Open*/),
    .txPwrLevelProtPT                 (/*Open*/),
    .stbcPT                           (/*Open*/),
    .fecCodingPT                      (txPCfecCodingPT),
    .numExtnSSPT                      (/*Open*/),
    .bfFrmExPT                        (/*Open*/),
    .beamFormedPT                     (/*Open*/),
    .smmIndexPT                       (txPCsmmIndexPT),
    .antennaSetPT                     (/*Open*/),
    .keySRAMIndex                     (txPCkeySRAMIndex),
    .keySRAMIndexRA                   (/*Open*/),
    .rtsThreshold                     (/*Open*/),
    .shortRetryLimit                  (/*Open*/),
    .longRetryLimit                   (/*Open*/),
    .aMPDUFrameLengthTx               (txPCaMPDUFrameLengthTx),
    .aMPDUOptFrameLength20Tx          (txPCaMPDUOptFrameLength20Tx),
    .aMPDUOptFrameLength40Tx          (txPCaMPDUOptFrameLength40Tx),
    .aMPDUOptFrameLength80Tx          (txPCaMPDUOptFrameLength80Tx),
    .txSingleVHTMPDU                  (txPCtxSingleVHTMPDU),
    .MPDUFrameLengthTx                (txPCMPDUFrameLengthTx),
    .mcsIndex0ProtTx                  (/*Open*/),
    .mcsIndex0Tx                      (txPCmcsIndex0Tx),
    .muMIMOTx                         (/*Open*/),
    .userPosition                     (txPCuserPosition),
    .continuousTx                     (/*Open*/),
    .formatModProtTx                  (/*Open*/),
    .formatModTx                      (/*Open*/),
    .preTypeProtTx                    (/*Open*/),
    .preTypeTx                        (/*Open*/),
    .bwProtTx                         (/*Open*/),
    .bwTx                             (/*Open*/),
    .partialAIDTx                     (/*Open*/),
    .groupIDTx                        (/*Open*/),
    .dozeNotAllowedTx                 (/*Open*/),
    .dynBWTx                          (/*Open*/),
    .useBWSignalingTx                 (/*Open*/),
    .smoothingProtTx                  (/*Open*/),
    .smoothingTx                      (/*Open*/),
    .soundingTx                       (/*Open*/),
    .protFrmDur                       (/*Open*/),
    .writeACK                         (/*Open*/),
    .lowRateRetry                     (/*Open*/),
    .lstpProt                         (/*Open*/),
    .lstp                             (/*Open*/),
    .expectedAck                      (/*Open*/),
    .navProtFrmEx                     (/*Open*/),
    .dontGenerateMH                   (txPCdontGenerateMH),
    .dontEncrypt                      (txPCdontEncrypt),
    .dontTouchFC                      (txPCdontTouchFC),
    .dontTouchDur                     (txPCdontTouchDur),
    .dontTouchQoS                     (txPCdontTouchQoS),
    .dontTouchHTC                     (txPCdontTouchHTC),
    .dontTouchTSF                     (txPCdontTouchTSF),
    .dontTouchDTIM                    (txPCdontTouchDTIM),
    .dontTouchFCS                     (txPCdontTouchFCS),
    .underBASetup                     (txPCunderBASetup),
    .aMPDUOut                         (txPCaMPDU),
    .whichDescriptor                  (txPCwhichDescriptor),
    .nBlankMDelimiters                (txPCnBlankMDelimiters),
    .interruptEnTx                    (/*Open*/),
    .fcSubtype                        (/*Open*/),
    .fcType                           (/*Open*/),
    .tsValid                          (/*Open*/),
    .lifetimeExpired                  (/*Open*/),
    .numMPDURetries                   (/*Open*/),
    .numRTSRetries                    (/*Open*/),
    .mediumTimeUsed                   (/*Open*/), //txPCmediumTimeUsedTPC),
    .debugPortTxParametersCache       (debugPortTxParametersCache)
);

assign tickSlotTxController_p = tickSlot_p & txInProgress;

// Instanciation of secController
// Name of the instance : U_secController
// Name of the file containing this module : secController.v
secController U_secController(
    // Clock and Reset interface
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    // Interface with the DMA Engine
    .trigTxACxMC_p                    (trigTxACxMC_p),
    .statusUpdated_p                  (statusUpdated_p),
    .updateDMAStatus_p                (updateDMAStatus_p),
    .txMpduDone_p                     (txMpduDone_p),
    .ampduFrm_p                       (ampduFrm_p),
    .mpduSuccess_p                    (mpduSuccess_p),
    .mpduFailed_p                     (mpduFailed_p),
    .whichDescriptorSW                (whichDescriptorSW),
    // Interface with the Tx Parameters Cache
    .txParameterHDReady_p             (txParameterHDReady_p),
    .txParameterPTReady_p             (txParameterPTReady_p),
    .toggleHDSet_p                    (toggleHDSet_p),
    .togglePTSet_p                    (togglePTSet_p),
    .clearSets_p                      (clearSets_p),
    .aMPDU                            (aMPDU),
    .txSingleVHTMPDU                  (txSingleVHTMPDU),
    .mcsIndex0Tx                      (mcsIndex0Tx),
    .whichDescriptor                  (whichDescriptor),
    .aMPDUFrameLengthTx               (aMPDUFrameLengthTx),
    .aMPDUOptFrameLength20Tx          (aMPDUOptFrameLength20Tx),
    .aMPDUOptFrameLength40Tx          (aMPDUOptFrameLength40Tx),
    .aMPDUOptFrameLength80Tx          (aMPDUOptFrameLength80Tx),
    // Interface with the Key Search Engine
    .keySearchIndexTrig_p             (keySearchIndexTrig_p),
    .keyStorageValid_p                (keyStorageValid_p),
    // Interface with the TX Controller
    .sendData_p                       (sendData_p),
    .txFromFifo                       (txFromFifo),
    .txDone_p                         (txDone_p),
    .mpduDone_p                       (mpduDone_p),
    .txHTLength                       (txHTLength),
    // Interface with the MAC controller
    .secTxStart_p                     (secTxStart_p),
    .secTxAbort_p                     (secTxAbort_p),
    .txBWDropped                      (txBWDropped),
    .secTxActive                      (secTxActive),
    .secTxReady                       (secTxReady),
    .secTxNSTS                        (secTxNSTS),
    // Interface with the MAC PHY
    .mpIfTxErr_p                      (mpIfTxErr_p),
    .macPHYIFUnderRun                 (macPHYIFUnderRun),
    // Debug port
    .debugPort                        (debugPortSecController)
);

assign keySearchIndex = keySRAMIndex[`RW_KEY_INDEX_WIDTH-1:0];


// Instanciation of pulse2PulseSynchro
// Name of the instance : U_trigTxACx_p_synchro
// Name of the file containing this module : pulse2PulseSynchro.v
pulse2PulseSynchro U_trigTxACx_p_synchro (
    .srcclk                           (macPIClk),
    .srcresetn                        (macPIClkHardRst_n),
    .dstclk                           (macCoreTxClk),
    .dstresetn                        (macCoreClkHardRst_n),
    .srcdata                          (trigTxACx_p),
    .dstdata                          (trigTxACxMC_p)
);


// Instanciation of txController
// Name of the instance : U_txController
// Name of the file containing this module : txController.v
txController #(
    .SECONDARY                        (1)
) U_txController (
    .macCoreClk                       (macCoreClk),
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    .txRxExchangeEnabled              (txRxExchangeEnabled),
    .sendData_p                       (sendData_p),
    .sendRTS_p                        (1'b0),
    .sendCTS_p                        (1'b0),
    .sendACK_p                        (1'b0),
    .sendCFEND_p                      (1'b0),
    .sendBA_p                         (1'b0),
`ifdef RW_BFMEE_EN
    .sendBFR_p                        (1'b0),
`endif //RW_BFMEE_EN
    .skipMPDU_p                       (1'b0),
    .sendOnSIFS                       (sendOnSIFS),
    .sendOnPIFS                       (1'b0),
    .srcAddr                          (48'h0),
    .destAddr                         (48'h0),
    .duration                         (duration),//$ToDo: To be verified
    .retry                            (1'b0),
    .tsfDuration                      (tsfDuration),//$ToDo: To be verified
    .txTID                            (txTID),
    .typeTx                           (/*Open*/),
    .typeTxValid                      (/*Open*/),
    .txAMSDUPresent                   (txAMSDUPresent),
    .txBcMc                           (/*Open*/),
    .txMCS                            (mcsIndex0Tx),
    .txLegLength                      (12'b0),
    .txLegRate                        (4'b0),
    .txHTLength                       (txHTLength),
    .txSTBC                           (2'b0),
    .txChBW                           (2'b0),
    .txDynBW                          (1'b0),
    .txBWSignaling                    (1'b0),
    .txDisambiguityBit                (1'b0),
    .txResp                           (1'b0),
    .txFromReg                        (1'b0),
    .txFromHD                         (1'b0),
    .txFromFifo                       (txFromFifo),
    .txCFEND                          (1'b0),
    .txDone_p                         (txDone_p),
    .mpduDone_p                       (mpduDone_p),
    .sentCFEND                        (/*Open*/),
    .sentRTS                          (/*Open*/),
    .sentBAReq                        (/*Open*/),
    .sentNDP                          (/*Open*/),
`ifdef RW_BFMER_EN
    .sentBFRPOLL                      (/*Open*/),
`endif //RW_BFMER_EN
    .skipMPDUDone_p                   (/*Open*/),
    .respTxAntennaSet                 (8'b0),
    .respTxSMMIndex                   (8'b0),
    .respTxPreType                    (1'b0),
    .respTxFormatMod                  (3'b0),
    .respTxAMPDU                      (1'b0),
    .respTxSingleVHTMPDU              (1'b0),
    .respMPDUFrameLengthTx            (15'b0),
    .respTxNumExtnSS                  (2'b0),
    .respTxFECCoding                  (1'b0),
    .respTxNTx                        (3'b0),
    .respTxShortGI                    (1'b0),
`ifdef RW_BFMEE_EN
    .bfrNr                            (3'b0),
    .bfrNc                            (3'b0),
    .bfrChBW                          (2'b0),
    .bfrFeedbackType                  (1'b0),
    .bfrSoundingDialToken             (6'b0),
`endif //RW_BFMEE_EN
    .cTypeRAM                         (cTypeKSR),
    .txCsIsIdle                       (txCsIsIdle),
    .txDataLength                     (tcPayLoadLen),
    .txCryptoKeyValid                 (txCryptoKeyValid),
    .txCCMPTKIPSeqCnt                 (tcSfc),
    .txPlainData                      (plainTxData),
    .txPlainDataValid                 (plainTxDataValid),
    .txPlainDataEnd                   (txPayLoadEnd_p),
    .txEncrData                       (txEncrData),
    .txEncrDataValid                  (txEncrDataValid),
    .txSBOXInit                       (/*Open*/),
    .txSBOXInitDone                   (1'b0),
    .txICVEnable                      (/*Open*/),
    .txWEP                            (/*Open*/),
    .txWEPIV                          (/*Open*/),
    .txWEPIVValid                     (/*Open*/),
    .txTKIP                           (/*Open*/),
    .txCCMPBusy                       (txCCMPBusy),
    .txCCMPMicDone                    (txCCMPMicDone),
    .txCCMP                           (txCCMP),
    .txCCMPStart                      (txCCMPStart),
    .txCCMPDataValid                  (txCCMPDataWrEn_p),
    .txCCMPAdd4Pres                   (txAddress4Pres),
    .txCCMPQoSPres                    (txQoSFrame),
    .txCCMPAddr1                      (txAddr1),
    .txCCMPAddr2                      (txAddr2),
    .txCCMPHT                         (txCCMPHT),
`ifdef RW_WAPI_EN
    .txWAPI                           (/*Open*/),
    .txWAPIStart                      (/*Open*/),
    .txWAPIMicDone                    (1'b0),
    .txWAPIBusy                       (1'b0),
    .txWAPIFrameControl               (/*Open*/),
    .txWAPIAddr3                      (/*Open*/),
    .txWAPIAddr4                      (/*Open*/),
    .txWAPIQoSCF                      (/*Open*/),
    .txWAPISeqControl                 (/*Open*/),
    .txWAPIKeyIdx                     (/*Open*/),
    .txWAPIPN                         (/*Open*/),
`endif //RW_WAPI_EN
    .fcsEnd_p                         (fcsEnd_p),
    .fcsBusy                          (fcsBusy),
    .fcsDOutValid                     (fcsDOutValid),
    .fcsDOut                          (fcsDOut),
    .fcsEnableTx                      (fcsEnableTx),
    .fcsStartTx_p                     (fcsStartTx_p),
    .fcsShiftTx                       (fcsShiftTx),
    .fcsDInValidTx                    (fcsDInValidTx),
    .fcsDInTx                         (fcsDInTx),
    .fcsPauseTx                       (/*Open*/),
    .txFIFOMPDUDelimiters             (txFIFOMPDUDelimiters),
    .txFIFORdData                     (txFIFORdData),
    .txFIFOEmpty                      (txFIFOEmpty),
    .txFIFODataValid                  (txFIFODataValid),
    .txFIFORead                       (txFIFORead),
    .txFIFOReadByFour                 (txFIFOReadByFour),
    .txFIFOReadByTwo                  (txFIFOReadByTwo),
    .txParameterHDReady_p             (txParameterHDReady_p),
    .MPDUFrameLengthTx                (MPDUFrameLengthTx),
    .formatModProtTx                  (3'b0),
    .formatModTx                      (formatModTx),
    .preTypeProtTx                    (1'b0),
    .preTypeTx                        (1'b0),
    .partialAIDTx                     (9'b0),
    .groupIDTx                        (6'b0),
    .dozeNotAllowedTx                 (1'b0),
    .smoothingProtTx                  (1'b0),
    .smoothingTx                      (1'b0),
    .soundingTx                       (1'b0),
    .nTxProtPT                        (3'b0),
    .nTxPT                            (3'b0),
    .txShortGI                        (1'b0),
    .txPwrLevelPT                     (8'b0),
    .txPwrLevelProtPT                 (8'b0),
    .stbcPT                           (2'b0),
    .txFecCoding                      (fecCodingPT),
    .numExtnSSPT                      (2'b0),
    .beamFormedPT                     (1'b0),
    .smmIndexPT                       (smmIndexPT),
    .antennaSetPT                     (8'b0),
    .dontGenerateMH                   (dontGenerateMH),
    .dontEncrypt                      (dontEncrypt),
    .dontTouchFC                      (dontTouchFC),
    .dontTouchDur                     (dontTouchDur),
    .dontTouchQoS                     (dontTouchQoS),
    .dontTouchHTC                     (dontTouchHTC),
    .dontTouchTSF                     (dontTouchTSF),
    .dontTouchDTIM                    (dontTouchDTIM),
    .dontTouchFCS                     (dontTouchFCS),
    .aMPDU                            (aMPDU),
    .whichDescriptor                  (whichDescriptor),
    .nBlankMDelimiters                (nBlankMDelimiters),
    .txSingleVHTMPDU                  (txSingleVHTMPDU),
    .rxTID                            (4'b0),
    .psBitmap                         (8'h0),
    .psBitmapValid                    (1'b0),
    .psBitmapReady                    (/*Open*/),
`ifdef RW_BFMEE_EN
    .bfrData                          (8'b0),
    .bfrDataValid                     (1'b0),
    .bfrDataReady                     (/*Open*/),
`endif //RW_BFMEE_EN
    .tsf                              (tsfTimer),
    .tickSIFS_p                       (tickSIFS_p),
    .tickPIFS_p                       (1'b0),
    .tickSlot_p                       (tickSlotTxController_p),
    .dtimCnt                          (8'b0),
    .rxVector1Valid_p                 (rxVector1Valid_p),
    .mpIfTxFifoFull                   (mpIfTxFifoFull),
    .mpIfTxErr_p                      (mpIfTxErr_p),
    .mpIfTxEn                         (mpIfTxEn),
//  .macPhyIfRxCca                    (1'b0),
    .startTx_p                        (startTx_p),
    .stopTx_p                         (stopTx_p),
    .mpIfTxFifoData                   (mpIfTxFifoData),
    .mpIfTxFifoWrite                  (mpIfTxFifoWrite),
    .txPwrLevel                       (/*Open*/),
    .chBW                             (/*Open*/),
    .smoothing                        (/*Open*/),
    .antennaSet                       (/*Open*/),
    .beamFormed                       (/*Open*/),
    .smmIndex                         (smmIndex),
    .mcs                              (mcs),
    .nSTS                             (nSTS),
    .preType                          (/*Open*/),
    .formatMod                        (/*Open*/),
    .numExtnSS                        (/*Open*/),
    .stbc                             (/*Open*/),
    .disambiguityBit                  (/*Open*/),
    .partialAID                       (/*Open*/),
    .groupID                          (/*Open*/),
    .dozeNotAllowed                   (/*Open*/),
    .fecCoding                        (fecCoding),
    .sounding                         (/*Open*/),
    .legLength                        (/*Open*/),
    .legRate                          (/*Open*/),
    .service                          (/*Open*/),
    .htLength                         (htLength),
    .nTx                              (/*Open*/),
    .shortGI                          (/*Open*/),
    .aggreation                       (/*Open*/),
    .hwErr                            (hwErr),
    .bssID                            (48'h0),
    .timOffset                        (timOffset),
    .pwrMgt                           (pwrMgt),
    .dsssMaxPwrLevel                  (dsssMaxPwrLevel),
    .ofdmMaxPwrLevel                  (ofdmMaxPwrLevel),
    .bbServiceA                       (16'b0),
    .bbServiceB                       (8'b0),
`ifdef RW_BFMEE_EN
    .bfrCodebook                      (1'b0),
    .bfrGrouping                      (2'b0),
    .bfrFormatMod                     (3'b0),
`endif //RW_BFMEE_EN
    .activeAC                         (activeAC),
    .txControlCs                      (txControlCs),
    .txControlLs                      (txControlLs),
    .debugPortTxFrameDebug1           (debugPortTxFrameDebug1),
    .debugPortTxFrameDebug2           (debugPortTxFrameDebug2)
);

assign formatModTx = 3'b100; // VHT Format
assign hwErr = macPHYIFUnderRun;


// Instanciation of encryptEngTop
// Name of the instance : U_encryptEngTop
// Name of the file containing this module : encryptEngTop.v
encryptEngTop #(
    .SECONDARY                        (1)
) U_encryptEngTop (
    .macCoreClk                       (macCoreClk),
    .macCryptClk                      (macCryptClk),
    .macWTClk                         (1'b0),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macWTClkHardRst_n                (1'b0),
    .macCoreClkSoftRst_n              (intMacCoreClkSoftRst_n),
    .macWTClkSoftRst_n                (1'b0),
    .macCryptClkEn                    (macCryptClkEn),
    .macWTClkEn                       (/*Open*/),
    .plainTxData                      (plainTxData),
    .plainTxDataValid                 (plainTxDataValid),
    .cryptoDataReady                  (/*Open*/),
    .encryptDataOut                   (encryptDataOut),
    .encryptDataValid                 (encryptDataValid),
    .fcsBusy                          (fcsBusy),
    .txWEPIV                          (24'b0),
    .txWEPIVValid                     (1'b0),
    .initPRNG_p_tx                    (1'b0),
    .icvStart_p_tx                    (1'b0),
    .txError_p                        (txError_p),
    .txCsIsIdle                       (txCsIsIdle),
    .txTKIP                           (1'b0),
    .txTkipSeqCntr                    (48'h0),
    .txCCMP                           (txCCMP),
    .txCCMPStart                      (txCCMPStart),
    .txCCMPDataWrEn_p                 (txCCMPDataWrEn_p),
    .txEnd_p                          (macPhyTxEnd_p),
    .txPayLoadEnd_p                   (txPayLoadEnd_p),
    .txAddress4Pres                   (txAddress4Pres),
    .txQoSFrame                       (txQoSFrame),
    .txTID                            (txTID),
    .txQoS7                           (txAMSDUPresent),
    .tcPayLoadLen                     (tcPayLoadLen),
    .txAddr1                          (txAddr1),
    .tcSfc                            (tcSfc),
    .ccmpHTMode                       (ccmpHTMode),
    .sppKSR                           (sppKSR),
    .encrTxCCMPBusy                   (txCCMPBusy),
    .encrTxCCMPMicDone                (txCCMPMicDone),
    .initSBOXDone                     (/*Open*/),
    .initDone_p                       (/*Open*/),
    .rxCsIsIdle                       (1'b1),
    .rxAddr1                          (48'b0),
    .rxAddr2                          (48'b0),
    .rxInitVector                     (24'b0),
    .rxTkipSeqCntr                    (48'b0),
    .rxPayLoadLen                     (16'b0),
    .rxFifoReady                      (1'b0),
    .rxDataSelect                     (1'b0),
    .rxError_p                        (1'b0),
    .encrRxBufFlush_p                 (1'b0),
    .writeFCSEn                       (1'b0),
    .rxDataEnd_p                      (1'b0),
    .rxAddress4Pres                   (1'b0),
    .rxQoSFrame                       (1'b0),
    .rxTID                            (4'b0),
    .rxQoS7                           (1'b0),
    .initEncrRxCntrl_p                (1'b0),
    .cryptoKeyValid                   (txCryptoKeyValid),
    .nullKeyFound                     (1'b0),
    .pushRxDataInBuffer               (1'b0),
    .wrDataToEncrBuffer               (8'b0),
    .rxCCMPAADwrEn_p                  (1'b0),
    .plainDataOut                     (/*Open*/),
    .plainOutDataValid                (/*Open*/),
    .plainOutDataEnd_p                (/*Open*/),
    .plainOutICVEnd_p                 (/*Open*/),
    .plainOutFCSValid                 (/*Open*/),
    .wepTkipPassed_p                  (/*Open*/),
    .wepTkipFailed_p                  (/*Open*/),
    .ccmpPassed_p                     (/*Open*/),
    .ccmpFailed_p                     (/*Open*/),
    .wrFIFOEn_c                       (/*Open*/),
    .encrBufferFull                   (/*Open*/),
    .encrBufferEmpty                  (/*Open*/),
    .macAddress                       (macAddress),
    .encrRxFIFOReset                  (1'b0),
    .encrRxFIFOResetIn                (/*Open*/),
    .encrRxFIFOResetInValid           (/*Open*/),
    .activeClkGating                  (activeClkGating),
    .wt2CryptClkRatio                 (2'b1),
`ifdef RW_WAPI_EN
    .txWAPI                           (1'b0),
    .txWAPIStart                      (1'b0),
    .rxWAPI                           (1'b0),
    .cryptoIntKey                     (128'b0),
    .wpiDone_p                        (/*Open*/),
    .wapiPassed_p                     (/*Open*/),
    .wapiFailed_p                     (/*Open*/),
    .encrTxWAPIBusy                   (/*Open*/),
    .txFrameControl                   (16'b0),
    .txAddr3                          (48'b0),
    .txAddr4                          (48'b0),
    .txQosCF                          (16'b0),
    .txSeqControl                     (16'b0),
    .txKeyIdx                         (8'b0),
    .txPN                             (128'b0),
    .rxFrameControl                   (16'b0),
    .rxAddr3                          (48'b0),
    .rxAddr4                          (48'b0),
    .rxQosCF                          (16'b0),
    .rxSeqControl                     (16'b0),
    .rxKeyIdx                         (8'b0),
    .rxPN                             (128'b0),
`endif // RW_WAPI_EN
    .cryptoKey                        (cryptoKeyKSR),
    .cipherType                       (cTypeKSR),
    .cipherLen                        (1'b0),
    .sBoxAReadData                    (8'b0),
    .sBoxBReadData                    (8'b0),
    .sBoxAAddr                        (/*Open*/),
    .sBoxBAddr                        (/*Open*/),
    .sBoxAWriteData                   (/*Open*/),
    .sBoxBWriteData                   (/*Open*/),
    .sBoxAWriteEn                     (/*Open*/),
    .sBoxBWriteEn                     (/*Open*/),
    .sBoxAEn                          (/*Open*/),
    .sBoxBEn                          (/*Open*/),
    .encrRxFIFOWriteEn                (/*Open*/),
    .encrRxFIFOWriteAddr              (/*Open*/),
    .encrRxFIFOWriteData              (/*Open*/),
    .encrRxFIFOReadData               (8'b0),
    .encrRxFIFOReadEn                 (/*Open*/),
    .encrRxFIFOReadAddr               (/*Open*/),
    .debugUseDefaultKeyKSR            (1'b0),
    .debugKeyIndexTrig                (keySearchIndexTrig_p),
    .debugKeyIndexKSR                 (keySearchIndex[5:0]),
    `ifdef RW_WAPI_EN
    .debugPortWapi                    (/*Open*/),
    `endif //RW_WAPI_EN
    .debugPortEncryptionEngine        (debugPortEncryptionEngine)
);


//// Interconnect between Encryption Engine and CSReg
// Interconnect between Encryption Engine and txController addr2 decoder
assign macAddress      = txAddr2;

// Interconnect between Encryption Engine and MAC PHY interface
assign txError_p       = mpIfTxErr_p;

// Interconnect between Encryption Engine and Tx controller (MPDU)
assign ccmpHTMode      = txCCMPHT;

assign txEncrData      = encryptDataOut;
assign txEncrDataValid = encryptDataValid;


// Instanciation of fcs
// Name of the instance : U_fcs
// Name of the file containing this module : fcs.v
fcs U_fcs (
    .macCoreClk                       (macCoreClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .fcsDIn                           (fcsDInTx),
    .fcsDInValid                      (fcsDInValidTx),
    .fcsEnable                        (fcsEnableTx),
    .fcsStart_p                       (fcsStartTx_p),
    .fcsShift                         (fcsShiftTx),
    .fcsOk                            (/*Open*/),
    .fcsDOut                          (fcsDOut),
    .fcsDOutValid                     (fcsDOutValid),
    .fcsBusy                          (fcsBusy),
    .fcsEnd_p                         (fcsEnd_p),
    .mpIfTxFifoFull                   (mpIfTxFifoFull),
    .mpIfTxFifoAlmostFull             (mpIfTxFifoAlmostFull)
);


// Instanciation of macPhyIf
// Name of the instance : U_macPhyIf
// Name of the file containing this module : macPhyIf.v
macPhyIf #(
    .SECONDARY                        (1)
) U_macPhyIf (
    .mpIFClk                          (mpIFClk),
    .mpIFClkHardRst_n                 (mpIFClkHardRst_n),
    .mpIFClkSoftRst_n                 (mpifSoftRst_n),
    .macCoreRxClk                     (macCoreClk),
    .macCoreTxClk                     (macCoreClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreClkSoftRst_n              (macCoreClkSoftRst_n),
    .phyRdy                           (phyRdy),
    .txEnd_p                          (txEnd_p),
    .rxData                           (8'b0),
    .CCAPrimary20                     (1'b0),
    .CCASecondary20                   (1'b0),
    .CCASecondary40                   (1'b0),
    .CCASecondary80                   (1'b0),
    .rxEndForTiming_p                 (1'b0),
    .rxErr_p                          (1'b0),
    .rxEnd_p                          (1'b0),
    .phyErr_p                         (phyErr_p),
    .rifsRxDetected                   (1'b0),
    .txReq                            (/*Open*/),
    .rxReq                            (/*Open*/),
    .txData                           (txData),
    .macDataValid                     (macDataValid),
    .mimoCmdValid                     (/*Open*/),
    .keepRFOn                         (/*Open*/),
    .startRx                          (1'b0),
    .stopRx_p                         (1'b0),
    .mpifKeepRFon                     (1'b0),
    .macPhyIfRxStart_p                (/*Open*/),
    .macPhyIfRxFlush_p                (/*Open*/),
    .startTx_p                        (startTx_p),
    .stopTx_p                         (stopTx_p),
    .secValidTx                       (secValidTx),
    .mpIfTxFifoData                   (mpIfTxFifoData),
    .mpIfTxFifoWrite                  (mpIfTxFifoWrite),
    .txPwrLevel                       (txPwrLevel),
    .chBW                             (chBW),
    .smoothing                        (smoothing),
    .antennaSet                       (antennaSet),
    .smmIndex                         (smmIndex),
    .mcs                              (mcs),
    .preType                          (preType),
    .formatMod                        (formatMod),
    .numExtnSS                        (numExtnSS),
    .stbc                             (stbc),
    .fecCoding                        (fecCoding),
    .sounding                         (sounding),
    .legLength                        (legLength),
    .legRate                          (legRate),
    .service                          (service),
    .htLength                         (htLength),
    .nTx                              (nTx),
    .nSTS                             (nSTS),
    .shortGI                          (shortGI),
    .aggreation                       (aggreation),
    .beamFormed                       (beamFormed),
    .disambiguityBit                  (disambiguityBit),
    .partialAID                       (partialAID),
    .groupID                          (groupID),
    .dozeNotAllowed                   (dozeNotAllowed),
    .continuousTx                     (continuousTx),
    .userPosition                     (userPosition),
    .mpIfTxFifoFull                   (mpIfTxFifoFull),
    .mpIfTxFifoAlmostFull             (mpIfTxFifoAlmostFull),
    .mpIfTxErr_p                      (mpIfTxErr_p),
    .mpIfTxEn                         (mpIfTxEn),
    .macPhyTxEnd_p                    (/*Open*/),
    .rxDSSS                           (1'b0),
    .macPhyIfRxFifoReadEn             (1'b0),
    .macPhyIfRxFifoEmpty              (/*Open*/),
    .macPhyIfRxFifoData               (/*Open*/),
    .macPhyIfRxErr_p                  (/*Open*/),
    .macPhyIfRxEnd_p                  (/*Open*/),
    .macPhyIfRxEndForTiming_p         (/*Open*/),
    .macPhyIfRifsRxDetected           (/*Open*/),
    .macPhyIfRxCca                    (/*Open*/),
    .macPhyIfRxCcaSec20               (/*Open*/),
    .macPhyIfRxCcaSec40               (/*Open*/),
    .macPhyIfRxCcaSec80               (/*Open*/),
    .macPhySyncReadyIn                (1'b0),
    .macPhySyncStartTxOut_p           (/*Open*/),
    .macPhySyncReadyOut               (macPhySyncReady),
    .macPhySyncStartTxIn_p            (macPhySyncStartTx_p),
    .band5G                           (1'b0),
    .macPHYIFFIFOReset                (macPHYIFFIFOReset),
    .macPHYIFFIFOResetInValid         (macPHYIFFIFOResetInValid),
    .rateControllerMPIF               (rateControllerMPIF),
    .rxReqForceDeassertion            (1'b0),
    .rxEndForTimingErrRec             (1'b0),
    .macCoreClkFreq                   (8'b0),
    .macPHYIFUnderRun                 (macPHYIFUnderRun),
    .macPHYIFOverflow                 (/*Open*/),
    .mpIFTxFIFOReadData               (mpIFTxFIFOReadData),
    .mpIFTxFIFOWriteData              (mpIFTxFIFOWriteData),
    .mpIFTxFIFOWriteAddr              (mpIFTxFIFOWriteAddr),
    .mpIFTxFIFOWriteEn                (mpIFTxFIFOWriteEn),
    .mpIFTxFIFOReadAddr               (mpIFTxFIFOReadAddr),
    .mpIFTxFIFOReadEn                 (mpIFTxFIFOReadEn),
    .mpIFRxFIFOReadData               (8'h0),
    .mpIFRxFIFOWriteData              (/*Open*/),
    .mpIFRxFIFOWriteAddr              (/*Open*/),
    .mpIFRxFIFOWriteEn                (/*Open*/),
    .mpIFRxFIFOReadAddr               (/*Open*/),
    .mpIFRxFIFOReadEn                 (/*Open*/),
    .debugPortMACPhyIf                (debugPortMACPhyIf),
    .debugPortMACPhyIf2               (/*Open*/)
);

//assign secValidTx = txFromFifo;
always @(posedge macCoreTxClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    secValidTx <= 1'b0;
  else if (macCoreTxClkSoftRst_n == 1'b0)  // Synchronous Reset
    secValidTx <= 1'b0;
  else
    secValidTx <= txFromFifo;
end


endmodule
