//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : Top level of rwWlanNxMACHW module
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none
module rwWlanNxMACHW( 
  ///////////////////////////////////////////////
  //$port_g Resets
  ///////////////////////////////////////////////
  input  wire                            macPIClkHardRst_n,     // Active low hard reset signal synchronized to the macPIClk.
  input  wire                            macCoreClkHardRst_n,   // Active low hard reset signal synchronized to the macCoreClk.
  input  wire                            macWTClkHardRst_n,     // Active low hard reset signal synchronized to the macWTClk.
  input  wire                            mpIFClkHardRst_n,      // Active low hard reset signal synchronized to the mpIFClk. 

  ///////////////////////////////////////////////
  //$port_g Clocks
  ///////////////////////////////////////////////
  input  wire                            macPIClk,              // Primary MAC Platform Interface Clock
  input  wire                            macPITxClk,            // Secondary MAC Platform Interface Clock for TX
  input  wire                            macPIRxClk,            // Secondary MAC Platform Interface Clock for RX
  input  wire                            macPISlaveClk,         // MAC Platform Interface Slave Clock
  input  wire                            macCoreClk,            // Primary MAC Core Clock
  input  wire                            macCryptClk,           // Secondary MAC Core Clock for encryption
  input  wire                            macCoreTxClk,          // Secondary MAC Core Clock for TX
  input  wire                            macCoreRxClk,          // Secondary MAC Core Clock for RX
  input  wire                            macLPClk,              // MAC Low Power clock. 
  input  wire                            macWTClk,              // Clock input for WEP/TKIP blocks.
  input  wire                            mpIFClk,               // MAC PHY Interface Clock

  ///////////////////////////////////////////////
  //$port_g Clock Enables
  ///////////////////////////////////////////////
  output wire                            macPriClkEn,           // Clock Enable for macPriClk Clocks
  output wire                            platformWakeUp,        // Wake Up platform
  output wire                            macPITxClkEn,          // Clock Enable for macPITxClk Clock
  output wire                            macPIRxClkEn,          // Clock Enable for macPIRxClk Clock
  output wire                            macCoreTxClkEn,        // Clock Enable for macCoreTxClk Clock
  output wire                            macCoreRxClkEn,        // Clock Enable for macCoreRxClk Clock
  output wire                            macLPClkSwitch,        // Switch MAC Lower Clock.
  output wire                            macWTClkEn,            // Clock Enable for macWTClk Clock
  output wire                            macCryptClkEn,         // Clock Enable for macCryptClk Clock
  output wire                            mpIFClkEn,             // Clock Enable for mpIFClk Clock

  ///////////////////////////////////////////////
  //$port_g Interrupts
  ///////////////////////////////////////////////
  output wire                            intGen_n,              // Active low general interrupt signal.
  output wire                            intProtTrigger_n,      // Active low protocol event interrupt signal
  output wire                            intTxTrigger_n,        // Active low TX event interrupt signal
  output wire                            intRxTrigger_n,        // Active low Rx event interrupt signal
  output wire                            intTxRxMisc_n,         // Active low Misc Tx/Rx event interrupt signal
  output wire                            intTxRxTimer_n,        // Active low Timer Tx Rx timer interrupt signal

  ///////////////////////////////////////////////
  //$port_g Debug Interface
  ///////////////////////////////////////////////
  output reg                             internalError,         // Internal Error
  output wire                     [15:0] debugPort0,            // Debug Port0
  output wire                     [15:0] debugPort1,            // Debug Port1
  output wire                     [15:0] debugPort2,            // Debug Port2
  output wire                     [15:0] debugPort3,            // Debug Port3
  output wire                     [15:0] debugPort4,            // Debug Port4
  output wire                     [15:0] debugPort5,            // Debug Port5
  output wire                     [15:0] debugPort6,            // Debug Port6
  output wire                     [15:0] debugPort7,            // Debug Port7
  output wire                     [15:0] debugPort8,            // Debug Port8
  output wire                     [15:0] debugPort9,            // Debug Port9
  output wire                     [15:0] debugPort10,           // Debug Port10
  output wire                     [15:0] debugPort11,           // Debug Port11
  output wire                     [15:0] debugPort12,           // Debug Port12
  output wire                     [15:0] debugPort13,           // Debug Port13
  output wire                     [15:0] debugPort14,           // Debug Port14
  output wire                     [15:0] debugPort15,           // Debug Port15
  output wire                     [15:0] debugPort16,           // Debug Port16
  output wire                     [15:0] debugPort17,           // Debug Port17
  output wire                     [15:0] debugPort18,           // Debug Port18
  output wire                     [15:0] debugPort19,           // Debug Port19
  output wire                     [15:0] debugPort20,           // Debug Port20
  output wire                     [15:0] debugPort21,           // Debug Port21
  output wire                     [15:0] debugPort22,           // Debug Port22
  output wire                     [15:0] debugPort23,           // Debug Port23
  output wire                     [15:0] debugPort24,           // Debug Port24
  output wire                     [15:0] debugPort25,           // Debug Port25
  output wire                     [15:0] debugPort26,           // Debug Port26
  output wire                     [15:0] debugPort27,           // Debug Port27
  output wire                     [15:0] debugPort28,           // Debug Port28
  output wire                     [15:0] debugPort29,           // Debug Port29
  output wire                     [15:0] debugPort30,           // Debug Port30
  output wire                     [15:0] debugPort31,           // Debug Port31
  output wire                     [15:0] debugPort32,           // Debug Port32
  output wire                     [15:0] debugPort33,           // Debug Port33
  output wire                     [15:0] debugPort34,           // Debug Port34
  output wire                     [15:0] debugPort35,           // Debug Port35
  output wire                     [15:0] debugPort36,           // Debug Port36
  output wire                     [15:0] debugPort37,           // Debug Port37
  output wire                     [15:0] debugPort38,           // Debug Port38
  output wire                     [15:0] debugPort39,           // Debug Port39
  output wire                     [15:0] debugPort40,           // Debug Port40
  output wire                     [15:0] debugPort41,           // Debug Port41
  output wire                     [15:0] debugPort42,           // Debug Port42
  output wire                     [15:0] debugPort43,           // Debug Port43
  output wire                     [15:0] debugPort44,           // Debug Port44
  output wire                     [15:0] debugPort45,           // Debug Port45
  output wire                     [15:0] debugPort46,           // Debug Port46
  output wire                     [15:0] debugPort47,           // Debug Port47
  output wire                     [15:0] debugPort48,           // Debug Port48
  output wire                     [15:0] debugPort49,           // Debug Port49
  output wire                     [15:0] debugPort50,           // Debug Port50
  output wire                     [15:0] debugPort51,           // Debug Port51
  output wire                     [15:0] debugPort52,           // Debug Port52
  output wire                     [15:0] debugPort53,           // Debug Port53
  output wire                     [15:0] debugPort54,           // Debug Port54
  output wire                     [15:0] debugPort55,           // Debug Port55
  output wire                     [15:0] debugPort56,           // Debug Port56
  output wire                     [15:0] debugPort57,           // Debug Port57
  output wire                     [15:0] debugPort58,           // Debug Port58
  output wire                     [15:0] debugPort59,           // Debug Port59
  output wire                     [15:0] debugPort60,           // Debug Port60
  output wire                     [15:0] debugPort61,           // Debug Port61
  input  wire                            debugKSR,              // Debug Key Storage RAM.
  `ifdef RW_SWPROF_DEBUG_PORT
  output wire                     [63:0] swProfDebugPort,       // Debug Port dedicated to Software Profiling
  `endif // RW_SWPROF_DEBUG_PORT

  ///////////////////////////////////////////////
  //$port_g ARM AHB/AHBLite Slave Interface
  ///////////////////////////////////////////////
  input  wire  [`RW_HOST_ADDR_WIDTH-1:0] hSAddr,                // The 16-bit system address bus.
  input  wire                     [ 1:0] hSTrans,               // Transfer type of the current transfer, 
  input  wire                            hSWrite,               // Transfer direction. When HIGH this signal indicates a write transfer and when LOW a read transfer
  input  wire                     [ 2:0] hSSize,                // Transfer size. Indicates the size of the transfer, which is typically byte (8-bit), halfword (16-bit) or word (32-bit).
  input  wire                     [ 2:0] hSBurst,               // Burst type. Indicates if the transfer forms part of a burst. Four, eight and sixteen beat bursts are supported and the burst may be either incrementing or wrapping.
  input  wire                     [ 3:0] hSProt,                // Protection control. Not used.
  input  wire                     [31:0] hSWData,               // Write data bus. The write data bus is used to transfer data from the master to the bus slaves during write operations. 
  input  wire                            hSSel,                 // Slave select. This signal is asserted from the decoder to indicate that the current transfer is meant for a particular slave.
  input  wire                            hSReadyIn,             // Transfer Done. When HIGH the hSReadyIn signal indicates that a transfer has finished on the bus. This signal signals the status of other slaves on the AHB.
  output wire                     [31:0] hSRData,               // Read data bus. The read data bus is used to transfer data from bus slaves to the bus master during read operations.
  output wire                            hSReadyOut,            // Transfer done. When HIGH the hSReadyOut signal indicates that a transfer has finished on the bus. This signal may be driven LOW to extend a transfer. Note: Slaves on the bus require hReady as both an input and an output signal.
  output wire                     [ 1:0] hSResp,                // Transfer response. The transfer response provides additional information on the status of a transfer. Two different responses are provided, OKAY and ERROR.
                                                                // RETRY and SPLIT are NA in an AHBLite system.

  ///////////////////////////////////////////////
  //$port_g ARM AHB/AHBLite Master Interface
  ///////////////////////////////////////////////
  output wire                            hMBusReq,              // Bus request. (Not used in AHB-Lite system)
  output wire                            hMLock,                // Locked transfers. When HIGH this signal indicates that the master requires locked access to the bus and no other master should be granted the bus until this signal is LOW.
  input  wire                            hMGrant,               // Bus Grant indication. (only used in AHB system. Must be tied high in AHB-Lite system).
  output wire                     [31:0] hMAddr,                // The 32-bit system address bus.
  output wire                     [ 1:0] hMTrans,               // Transfer type of the current transfer, which can be NONSEQUENTIAL, SEQUENTIAL, IDLE or BUSY.
  output wire                            hMWrite,               // Transfer direction. When HIGH this signal indicates a write transfer and when LOW a read transfer.
  output wire                     [ 2:0] hMSize,                // Transfer size. Indicates the size of the transfer, which is typically byte (8-bit), halfword (16-bit) or word (32-bit). The protocol allows for larger transfer sizes up to a maximum of 1024 bits.
  output wire                     [ 2:0] hMBurst,               // Burst type. Indicates if the transfer forms part of a burst. Four, eight and sixteen beat bursts are supported and the burst may be either incrementing or wrapping.
  output wire                     [ 3:0] hMProt,                // Protection control. Fixed to non-cache data. 
  output wire                     [31:0] hMWData,               // Write data bus. The write data bus is used to transfer data from the master to the bus slaves during write operations. 
  input  wire                     [31:0] hMRData,               // Read data bus. The read data bus is used to transfer data from bus slaves to the bus master during read operations.
  input  wire                            hMReady,               // Transfer done. When HIGH the hMReady signal indicates that a transfer has finished on the bus. This signal may be driven LOW to extend a transfer. 
  input  wire                     [ 1:0] hMResp,                // Transfer response. The transfer response provides additional information on the status of a transfer. Two different responses are provided, OKAY and ERROR.
                                                                // RETRY and SPLIT are NA in an AHBLite system.

  ///////////////////////////////////////////////
  //$port_g PHY interface
  ///////////////////////////////////////////////
  input  wire                            phyRdy,                // data valid signal             
  input  wire                            txEnd_p,               // end of transaction              
  input  wire                     [ 7:0] rxData,                // rx data                 
  input  wire                            CCAPrimary20,          // CCA on Primary 20MHz channel                       
  input  wire                            CCASecondary20,        // CCA on Secondary 20MHz channel                       
  input  wire                            CCASecondary40,        // CCA on Secondary 40MHz channel                       
  input  wire                            CCASecondary80,        // CCA on Secondary 80MHz channel                       
  input  wire                            rxEndForTiming_p,      // end of transmission (antenna) 
  input  wire                            rxErr_p,               // Rx error                      
  input  wire                            rxEnd_p,               // Rx end                        
  input  wire                            phyErr_p,              // phy error                     
  input  wire                            rifsRxDetected,        // rifs detected                 
  output wire                            txReq,                 // Tx request                     
  output wire                            rxReq,                 // Rx request                     
  output wire                     [ 7:0] txData,                // Tx data                        
  output wire                            macDataValid,          // data valid                     
  output wire                            mimoCmdValid,          // mimo command                   
  output wire                            keepRFOn,              // Keep RF on                     
  
  ///////////////////////////////////////////////
  //$port_g Coex Interface
  ///////////////////////////////////////////////
  `ifdef RW_WLAN_COEX_EN
  output wire                            coexWlanTx,            // Indicates that a WLAN Transmission is on-going
  output wire                            coexWlanRx,            // Indicates that a WLAN Reception is on-going
  input  wire                            coexWlanTxAbort,       // Requests from external arbiter abort all on-going transmission 
  input  wire                            coexWlanRxAbort,       // Requests from external arbiter abort all on-going reception 
  output wire [3:0]                      coexWlanPTI,           // Indicates the priority of the on-going traffic
  output wire                            coexWlanPTIToggle,     // Indicates a new priority value
  output wire                            coexWlanChanBw,        // Indicates the BW of the on-going traffic
  output wire [6:0]                      coexWlanChanFreq,      // Indicates the Center frequency of the on-going traffic
  output wire                            coexWlanChanOffset,    // Indicates the Center frequency of the on-going traffic
  `endif // RW_WLAN_COEX_EN

`ifdef RW_BFMEE_EN
  ///////////////////////////////////////////////
  //$port_g BFR HW Accelerator
  ///////////////////////////////////////////////
  output wire                            bfrStart,              // BFR computation started
  input  wire                            bfrDone,               // Beamforming Report computation is done
  output wire                      [1:0] bfrChBW,               // Beamforming report Channel Width
  output wire                      [1:0] bfrGrouping,           // Beamforming report Grouping
  output wire                            bfrCodebook,           // Beamforming report Codebook Information
  output wire                      [1:0] bfrFeedbackType,       // Beamforming report Feedback Type
  output wire                      [2:0] bfrNr,                 // Beamforming report Nr Index
  output wire                      [2:0] bfrNc,                 // Beamforming report Nc Index
  output wire                            bfrHE,                 // Beamforming report Format
                                                                // (VHT or HE)
  output wire                      [6:0] bfrRUStartIndex,       // Beamforming report RU Start Index
                                                                // (Only for HE BFR)
  output wire                      [6:0] bfrRUEndIndex,         // Beamforming report RU End Index 
                                                                // (Only for HE BFR)
  input  wire                      [7:0] bfrData,               // Beamforming report byte
  input  wire                            bfrDataValid,          // Beamforming report byte valid          
  output wire                            bfrDataReady,          // Beamforming report byte request
`endif //RW_BFMEE_EN

  ///////////////////////////////////////////////
  //$port_g Memory Interface
  ///////////////////////////////////////////////
  //$port_g TxFIFO 64*38 Two Ports SRAM 
  ///////////////////////////////////////////////
  output wire                            txFIFOReadEn,          // Transmit FIFO Read Enable. 
  output wire     [`TXFIFOADDRWIDTH-1:0] txFIFOReadAddr,        // Transmit FIFO Read Address bus.
  input  wire                     [37:0] txFIFOReadData,        // Transmit FIFO Read Data bus.
  output wire                            txFIFOWriteEn,         // Transmit FIFO Write Enable.
  output wire     [`TXFIFOADDRWIDTH-1:0] txFIFOWriteAddr,       // Transmit FIFO Write Address bus.
  output wire                     [37:0] txFIFOWriteData,       // Transmit FIFO Write Data bus.

  ///////////////////////////////////////////////
  //$port_g RxFIFO 64*36 Two Ports SRAM 
  ///////////////////////////////////////////////
  output wire                            rxFIFOReadEn,          // Receive FIFO Read Enable. 
  output wire     [`RXFIFOADDRWIDTH-1:0] rxFIFOReadAddr,        // Receive FIFO Read Address bus.
  input  wire                     [35:0] rxFIFOReadData,        // Receive FIFO Read Data bus.
  output wire                            rxFIFOWriteEn,         // Receive FIFO Write Enable.
  output wire     [`RXFIFOADDRWIDTH-1:0] rxFIFOWriteAddr,       // Receive FIFO Write Address bus.
  output wire                     [35:0] rxFIFOWriteData,       // Receive FIFO Write Data bus.

  ///////////////////////////////////////////////
  //$port_g Key Storage RAM 64*186 Single Port SRAM 
  ///////////////////////////////////////////////
  output wire                            keyStorageEn,          // Enable Key Storage RAM
                                                                // This signal is asserted for both read and write operations to the Key Storage RAM.
  output wire                            keyStorageWriteEn,     // Write Enable Key Storage RAM
                                                                // This signal is asserted for write operations to the Key Storage RAM.
  output wire  [`RW_KEY_INDEX_WIDTH-1:0] keyStorageAddr,        // Key Storage RAM write data bus
  input  wire   [`RW_KEY_DATA_WIDTH-1:0] keyStorageReadData,    // Key Storage RAM read data bus.
  output wire   [`RW_KEY_DATA_WIDTH-1:0] keyStorageWriteData,   // Key Storage RAM address bus.

  ///////////////////////////////////////////////
  //$port_g RC4 PRNG 128*16 Two Ports SRAM
  ///////////////////////////////////////////////
  input  wire  [15:0]                    sboxMemRdData,         // SBOX data bus from internal RAM
  output wire   [6:0]                    sboxMemWrAddr,         // SBOX address bus to internal RAM, port write
  output wire   [6:0]                    sboxMemRdAddr,         // SBOX address bus to internal RAM, port read
  output wire  [15:0]                    sboxMemWrData,         // SBOX data bus to internal RAM
  output wire   [1:0]                    sboxMemWrEn,           // SBOX write enable signal for internal RAM
  output wire                            sboxMemRdEn,           // SBOX read enable signal for internal RAM

`ifdef RW_MAC_MIBCNTL_EN
  ///////////////////////////////////////////////
  //$port_g MIB Table RAM 256*32 Single Port SRAM
  ///////////////////////////////////////////////
  output wire                            mibTableEn,            // MIB Table Enable. 
                                                                // This signal is asserted for both read and write operations to the MIB Table.
  output wire                            mibTableWriteEn,       // MIB Table Write Enable.
                                                                // This signal is asserted for write operations to the MIB Table.
  output wire                     [ 7:0] mibTableAddr,          // MIB Table Address bus.
  input  wire                     [31:0] mibTableReadData,      // MIB Table Read Data bus.
  output wire                     [31:0] mibTableWriteData,     // MIB Table Write Data bus.
`endif // RW_MAC_MIBCNTL_EN

  ///////////////////////////////////////////////
  //$port_g MAC-PHY IF TX FIFO RAM 256*8 Two Ports SRAM
  ///////////////////////////////////////////////
  output wire                            mpIFTxFIFOReadEn,      // MAC-PHY Interface Transmit FIFO Read Enable. 
                                                                // This signal is asserted for read operations to the MAC-PHY interface Transmit FIFO.
  output wire     [`MPIFTXADDRWIDTH-1:0] mpIFTxFIFOReadAddr,    // MAC-PHY Interface Transmit FIFO Read Address bus.
  input  wire                     [ 7:0] mpIFTxFIFOReadData,    // MAC-PHY Interface Transmit FIFO Read Data bus.
  output wire                            mpIFTxFIFOWriteEn,     // MAC-PHY InterFace Transmit FIFO Write Enable.
                                                                // This signal is asserted for write operations to the MAC-PHY interface Transmit FIFO.
  output wire     [`MPIFTXADDRWIDTH-1:0] mpIFTxFIFOWriteAddr,   // MAC-PHY Interface Transmit FIFO Write Address bus.
  output wire                     [ 7:0] mpIFTxFIFOWriteData,   // MAC-PHY Interface Transmit FIFO Write Data bus.

  ///////////////////////////////////////////////
  //$port_g MAC-PHY IF RX FIFO RAM 64*8 Two Ports SRAM
  ///////////////////////////////////////////////
  output wire                            mpIFRxFIFOReadEn,      // MAC-PHY Interface Receive FIFO Read Enable. 
                                                                // This signal is asserted for read operations to the MAC-PHY interface Receive FIFO.
  output wire     [`MPIFRXADDRWIDTH-1:0] mpIFRxFIFOReadAddr,    // MAC-PHY Interface Receive FIFO Read Address bus.
  input  wire                     [ 7:0] mpIFRxFIFOReadData,    // MAC-PHY Interface Receive FIFO Read Data bus.
  output wire                            mpIFRxFIFOWriteEn,     // MAC-PHY InterFace Receive FIFO Write Enable.
                                                                // This signal is asserted for write operations to the MAC-PHY interface Receive FIFO.
  output wire     [`MPIFRXADDRWIDTH-1:0] mpIFRxFIFOWriteAddr,   // MAC-PHY Interface Receive FIFO Write Address bus.
  output wire                     [ 7:0] mpIFRxFIFOWriteData    // MAC-PHY Interface Receive FIFO Write Data bus.

);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////

wire  ZERO_CT;
wire [31 : 0] signature;     
 // VERSION1REG register.
wire  muMIMOTx;
wire  bfmer;
wire  bfmee;
wire  he;
wire  coex;
wire  wapi;
wire  tpc;
wire  vht;                    
wire  ht;                    
wire  gcmp;
wire  rce;                   
wire  ccmp;                  
wire  tkip;                  
wire  wep;                   
wire  security;              
wire  sme;                   
wire  edca;                  
wire  qos;                   
 // VERSION2REG register.
wire [2 : 0] phaseNumber;    
wire [5 : 0] releaseNumber;  
wire  ieRelease;             
wire [6 : 0] umVersion ;     
 // BITMAPCNTREG register.
wire [15 : 0] bitmapCnt;     



wire        statuserrInHWLevel3;        // status err In Hw Level 3
wire        statuserrInTxRxLevel2;      // status err Tx/Rx Hw Level 1
wire        statuserrInRxLevel1;        // status err Rx Hw Level 1
wire        statuserrInTxLevel1;        // status err Tx Hw Level 1
wire        tsfUpdatedBySWIn ;          // Input to clear the Software update request
wire        tsfUpdatedBySWInValid ;     // Data valid  
wire        dtimUpdatedBySWIn ;         // Input to clear the Software update request
wire        dtimUpdatedBySWInValid ;    // Data valid  


wire        mpIFClkSoftRst_n;           // Soft Reset of the mpIF Clock domain 
                                        // active low
wire        macCoreClkSoftRst_n;        // Soft Reset of the MAC Core Clock domain 
                                        // active low
wire        macPIClkSoftRst_n;          // Soft Reset for the MAC Platform Clock domain 
                                        // active low
wire        macWTClkSoftRst_n;          // Soft Reset for the WT Clock domain 
                                        // active low
wire        macPISlaveClkSoftRst_n;     // mac PI Slave Soft reset
                                        // active low

wire        dmaSoftRst_n;               // dma soft reset active low
wire        mpifSoftRst_n;              // mpif soft reset active low
wire        txFifoSoftRst_n;            // txFifo soft reset active low

wire        hwErr;                      // Indicate a HW Error

// Interconnect between TX FIFO and TX Controller
wire        txFIFOWrFlush;              // Request from MAC Platform Clock domain to flush the FIFO
wire        txFIFOWrite;                // Write a new word in the Tx FIFO
wire [31:0] txFIFOWrData;               // Data written to the TX FIFO
wire [ 5:0] txFIFOWrTag;                // Tag written to the TX FIFO
wire        txFIFOAlmostFull;           // Indicates that the TX FIFO is almost full
wire        txFIFOFull;                 // Indicates that the TX FIFO is full and cannot accept new write
wire        txFIFOAlmEmptyWrClk;        // Indicates that the TX FIFO is almost empty
wire        txFIFOEmptyWrClk;           // Indicates that the TX FIFO is empty
wire        txFIFORdFlush;              // Request from MAC Core Clock domain to flush the FIFO
wire        txFIFORead;                 // Request a new byte from the Tx FIFO
wire        txFIFOEmpty;                // Indicates that the TX FIFO is empty
wire        txFIFODataValid;            // Indicates when the read data is valid
wire [ 7:0] txFIFORdData;               // Byte read from the TX FIFO
wire [ 1:0] txFIFOMPDUDelimiters;       // Tag read from the TX FIFO
          

// Interconnect between Tx Parameters Cache and the DMA Engine
wire         txCtrlRegWr;               // TX parameter Cache module signals
wire  [31:0] txCtrlRegData;             // TX parameter Cache module signals
wire         txCtrlRegPT;               // Indicates currently Policy table information is
wire         txCtrlRegHD;               // Indicates currently Header descriptor information
wire         discardPrevHD_p;           // Signal to TX Parameter Cache module.
wire         txCtrlRegBusy;             // Indicates there are 2 sets of parameters 

// Interconnect between RX FIFO and RX Controller
wire         rxFIFOAlmostFull;          // RX FIFO is almost full
wire         rxFIFOFull;                // RX FIFO is full

wire [3:0]   rxFIFOWrTag;               // RX FIFO write tag
wire [31:0]  rxFIFOWrData;              // RX FIFO write data
wire         rxFIFOWrite;               // RX FIFO write enable


// Interconnect between MAC-PHY IF and Mac Controller
wire        macPhyIfRxStart_p;          // Start of reception pulse
wire        macPhyIfRxFlush_p;          // Rx flush pulse
wire        startRx;                    // Start Rx trigger                   
wire        stopRx_p;                   // Stop Rx trigger                    
wire        mpifKeepRFon;               // Keep RF On
                                                                                         
// Interconnect between MAC-PHY IF and Tx  Controller If                                                            
wire        startTx_p;                  // Start Tx trigger              
wire        stopTx_p;                   // Stop Tx trigger               
wire [ 7:0] mpIfTxFifoData;             // Data to transmit              
wire        mpIfTxFifoWrite;            // Data valid                    

wire  [1:0] heLTFType;                  // HE-LTF Type
wire [ 7:0] txPwrLevel;                 // Transmit Power Level             
wire [ 2:0] chBW;                       // Channel Bandwidth             
wire [ 3:0] formatMod;                  // Format and Modulation           
wire [19:0] htLength;                   // Length of the HT/VHT/HE PPDU              
wire        htLengthValid;              // Length of the HT PPDU is valid
wire  [3:0] spatialReuse1;              // Spatial Reuse 1 Information
wire  [3:0] spatialReuse2;              // Spatial Reuse 2 Information
wire  [3:0] spatialReuse3;              // Spatial Reuse 3 Information
wire  [3:0] spatialReuse4;              // Spatial Reuse 4 Information
wire  [8:0] heSigAReserved;             // HE SIG-A Reserved bits
wire  [2:0] numHeLtf;                   // Number of HE LTF
wire        heLtfMode;                  // HE LTF Mode
wire        ldpcExtraSymbol;            // LDPC extra symbol
wire  [2:0] startingSTSNum;             // Starting STS Number
wire        sigBCompressionMode;        // SIG-B compression mode
wire        dcmSigB;                    // Dual carrier modulation on SIG-B
wire  [2:0] mcsSigB;                    // MCS of SIG-B
wire [31:0] ruAllocation;               // RU allocation
wire  [2:0] packetExtension;            // Packet extension
wire        triggerMethod;              // trigger method
wire  [6:0] ruToneSetIndex;             // RU tone set index
wire        feedBackStatus;             // feedback status
wire        doppler;                    // Doppler
wire        midamble;                   // Midamble Periodicity
wire [ 2:0] nTx;                        // Number of Transmit Chains.      
wire        smoothing;                  // Smoothing recommended            
wire [ 7:0] antennaSet;                 // Antenna Set           
wire [ 7:0] smmIndex;                   // Spatial Map Matrix Index           
wire [ 6:0] mcs;                        // Modulation Coding Scheme           
wire        preType;                    // Preamble Type         
wire [ 1:0] numExtnSS;                  // Number of Extension Spatial Streams              
wire        stbc;                       // Space Time Block Coding           
wire        fecCoding;                  // FEC Coding             
wire        sounding;                   // Indicates whether this PPDU is Sounding        
wire [11:0] legLength;                  // Legacy Length of the PPDU            
wire [ 3:0] legRate;                    // Legacy Rate of the PPDU               
wire [15:0] service;                    // Service              
wire        aggreation;                 // MPDU Aggregate
wire  [5:0] bssColor;                   // BSS Color
wire        upLinkFlag;                 // UP Link Flag
wire        beamChange;                 // Beam Change
wire        beamFormed;                 // BeamFormed
wire        disambiguityBit;            // Disambiguity
wire [8:0]  partialAID;                 // partial AID
wire [5:0]  groupID;                    // group ID
wire        dozeNotAllowed;             // TXOP PS Not Allowed
wire        continuousTx;               // Enable continuous transmit 
wire [4:0]  userPosition;               // User position
wire        timeOfDepartureReq;         // Time of departure requested
wire  [1:0] giType;                     // Guard Interval Type
wire        dcm;                        // Dual Carrier Modulation
wire  [6:0] txopDuration;               // Duration of TXOP
wire        triggerResponding;          // Trigger Responding
wire  [7:0] nUser;                      // Number of User
wire [10:0] staID;                      // STA ID
wire [31:0] timeOfDeparture;            // Time Of Departure
wire [15:0] timeOfDepartureClkRate;     // Time Of Departure Clock Rate

wire        mpIfTxFifoFull;             // FIFO status                        
wire        mpIfTxFifoAlmostFull;       // FIFO status                        
wire        mpIfTxErr_p;                // Transmit error                     
wire        mpIfTxEn;                   // Transmit Enable                    
                                                                                         
// Interconnect between MAC-PHY IF and Rx Controller                                                                
wire        macPhyTxEnd_p;              // Pulse tx end from phy domain to core domain
wire        macPhyIfRxFifoReadEn;       // FIFO read enable from the Rx controller                                    
wire        macPhyIfRxFifoEmpty;        // FIFO empty signal                                     
wire [ 7:0] macPhyIfRxFifoData;         // FIFO data 
wire        macPhyIfRxErr_p;            // abort pulse                                     
wire        macPhyIfRxEnd_p;            // end of reception pulse                                      
wire        macPhyIfRxEndForTiming_p;   // end of reception at the antenna                                     
wire        macPhyIfRifsRxDetected;     // RIFS detected indication                                   
wire        macPhyIfRxCca;              // CCA trigger                    
wire        macPhyIfRxCcaSec20;         // CCA trigger on Secondary 20MHz channel                    
wire        macPhyIfRxCcaSec40;         // CCA trigger on Secondary 40MHz channel                  
wire        macPhyIfRxCcaSec80;         // CCA trigger on Secondary 80MHz channel                  

// Interconnect between MAC-PHY IF and Registers
wire        macPHYIFFIFOReset;          // Flush the FIFO
wire        macPHYIFFIFOResetIn;        // Flush the FIFO In
wire        macPHYIFFIFOResetInValid;   // Flush the FIFO clear
wire        rateControllerMPIF;         // Select reverse handshaking or PHy strobe tranmit mechanism
wire        macPHYIFUnderRun;           // underrun status
wire        primaryMacPHYIFFIFOResetInValid; // Flush the FIFO clear

// MAC Timer Unit with the DMA Engine
wire        rxTrig_p;                   // RX trigger

// MAC Timer Unit with secondary TX Path
wire        tickSlot_p;                 // slot indicator
wire        tickSIFS_p;                 // A pulse to indicate the end of SIFS period
wire [63:0] tsfTimer;                   // TSF timer value

// Interconnect Host IF to Control and Status Registers
wire                            regReadyIn;              // read data valid or write completed 
wire [(`RW_REG_DATA_WIDTH-1):0] regReadData;             // Data read from registers
wire                            regWrite;                // Write enable
wire                            regRead;                 // Read enable
wire [(`RW_REG_ADDR_WIDTH-1):0] regAddr;                 // Register address
wire [(`RW_REG_DATA_WIDTH-1):0] regWriteData;            // Data to be written to the registers

// Interconnect Host IF to  DMA interface
wire                          dmaHIFRead            ;// dma host interface read enable
wire                          dmaHIFWrite           ;// dma host interface write enable
wire [31:0]                   dmaHIFAddressIn       ;// dma host interface address
wire [31:0]                   dmaHIFReadDataOut     ;// dma host interface read data
wire                          dmaHIFReadDataValid   ;// dma host interface read data valid
wire [ 2:0]                   dmaHIFSize            ;// dma host interface byte enable
wire                          dmaHIFReady           ;// dma host interface next data
wire [31:0]                   dmaHIFWriteDataIn     ;// dma host interface write data
wire                          dmaHIFTransComplete   ;// dma host interface transfer complete
wire                          dmaHIFError           ;// dma host interface error


wire                   [19:0] ppduLength;              // PPDU Length
                                                       // This field gives the length of the PPDU for computing time on air.
wire                    [1:0] ppduBW;                  // PPDU Bandwidth
                                                       // This field indicates that that the PPDU should be transmitted at 20,40,80 or 160 MHz.
wire                    [3:0] ppduPreType;             // PPDU Preamble Type
                                                       // This field indicates what type of preamble is transmitted for the frame.
                                                       // The encoding is as follows:
                                                       // 3'b000: Non-HT-Short
                                                       // 3'b001: Non-HT-Long
                                                       // 3'b010: HT-MF
                                                       // 3'b011: HT-GF
                                                       // 3'b100: VHT
wire                    [1:0] ppduNumExtnSS;           // Start Transmission with Number of Extension Spatial Streams      
wire                    [1:0] ppduSTBC;                // Start Transmission with Space Time Block Coding          
wire                    [1:0] ppduGIType;              // PPDU Guard Interval type
                                                       // Indicates that the frame should be transmitted with Short GI.
wire                    [6:0] ppduNUser;               // PPDU Number of User
wire                    [2:0] ppduPE;                  // PPDU Packet Extension
wire                    [2:0] ppduMCSSigB;             // PPDU MCS of SIG B
wire                          ppduDCMSigB;             // PPDU DCM on SIG B
wire                          ppduSigBCompMode;        // PPDU SIG B compression mode
wire                    [1:0] ppduHELTFType;           // PPDU HE LTF Type
wire                          ppduDCM;                 // PPDU Dual Carrier Modulation
wire                    [6:0] ppduMCSIndex;            // PPDU LegRate or MCS Index
                                                       // This field indicates the rate at which this PPDU is transmitted. 
wire                    [2:0] ppduNumHeLtf;            // PPDU Number of HE LTF
wire                    [2:0] ppduRuType;              // PPDU Ru Type
wire                          ppduMma;                 // PPDU Midamble
wire                          ppduDoppler;             // PPDU Doppler
wire                          computeDuration;         // Request to perform a Time on Air computation
wire                          computeDurationIn;       // Time on Air computation done
wire                          computeDurationInValid;  // Time on Air computation done valid
wire                   [15:0] timeOnAir;               // Time On Air
                                                       // This field gives the time taken for frame transmission in microseconds (us)
                                                       // computed from parameters programmed in timeOnAirParamReg register.

wire                          timeOnAirValid;          // Time On Air Valid
                                                       // This field is set when the air time computation is completed.

// Interconnect Interrupt Controller
reg                          phyRxStart;               // phyRxStart internal interruption
reg                          phyErr;                   // phyErr internal interruption
wire                         impSecDTIM;               // impSecDTIM internal interruption
wire                         impPriDTIM;               // impPriDTIM internal interruption
wire                         tbTxDMADead;              // tbTxDMADead internal interruption
wire                         bcnTxDMADead;             // bcnTxDMADead internal interruption
wire                         ac3TxDMADead;             // ac3TxDMADead internal interruption
wire                         ac2TxDMADead;             // ac2TxDMADead internal interruption
wire                         ac1TxDMADead;             // ac1TxDMADead internal interruption
wire                         ac0TxDMADead;             // ac0TxDMADead internal interruption
wire                         ptError;                  // ptError internal interruption
wire                         timSet;                   // timSet internal interruption
wire                         olbcDSSS;                 // olbcDSSS internal interruption
wire                         olbcOFDM;                 // olbcOFDM internal interruption
wire                         rxFIFOOverFlow;           // rxFIFOOverFlow internal interruption
wire                         macPHYIFOverflow;         // macPHYIFOverflow internal interruption
wire                         rxPayloadDMADead;         // rxPayloadDMADead internal interruption
wire                         rxHeaderDMADead;          // rxHeaderDMADead internal interruption
wire [9:0]                   absTimers;                // absTimer2 internal interruption
wire                         idleInterrupt;            // idleInterrupt internal interruption
reg                          idleInterruptGated;       // idleInterrupt internal interruption
wire                         impSecTBTT;               // impSecTBTT internal interruption
wire                         impPriTBTT;               // impPriTBTT internal interruption
wire                         timerRxTrigger;           // timerRxTrigger internal interruption
wire                         tbTxBufTrigger;           // tbTxBufTrigger internal interruption
wire                         bcnTxBufTrigger;          // bcnTxBufTrigger internal interruption
wire                         ac3TxBufTrigger;          // ac3TxBufTrigger internal interruption
wire                         ac2TxBufTrigger;          // ac2TxBufTrigger internal interruption
wire                         ac1TxBufTrigger;          // ac1TxBufTrigger internal interruption
wire                         ac0TxBufTrigger;          // ac0TxBufTrigger internal interruption
wire                         timerTxTrigger;           // timerTxTrigger internal interruption
wire                         txopComplete;             // txopComplete internal interruption
wire                         tbTxTrigger;              // tbTxTrigger internal interruption
wire                         tbTxCancelled;            // tbTxCancelled internal interruption
wire                         bcnTxTrigger;             // bcnTxTrigger internal interruption
wire                         ac3TxTrigger;             // ac3TxTrigger internal interruption
wire                         ac2TxTrigger;             // ac2TxTrigger internal interruption
wire                         ac1TxTrigger;             // ac1TxTrigger internal interruption
wire                         ac0TxTrigger;             // ac0TxTrigger internal interruption
wire                         tbProtTrigger;            // tbProtTrigger internal interruption
wire                         ac3ProtTrigger;           // ac3ProtTrigger internal interruption
wire                         ac2ProtTrigger;           // ac2ProtTrigger internal interruption
wire                         ac1ProtTrigger;           // ac1ProtTrigger internal interruption
wire                         ac0ProtTrigger;           // ac0ProtTrigger internal interruption
wire                         ac3BWDropTrigger;         // ac3BWDropTrigger internal interruption
wire                         ac2BWDropTrigger;         // ac2BWDropTrigger internal interruption
wire                         ac1BWDropTrigger;         // ac1BWDropTrigger internal interruption
wire                         ac0BWDropTrigger;         // ac0BWDropTrigger internal interruption



// Interconnect Control and Status Register and Key search Engine
wire                         keyStoRAMReset;                // Key Storage RAM reset
wire                         keyStoRAMResetIn;              // Key Storage RAM reset In
wire                         keyStoRAMResetInValid;         // Key Storage RAM reset clear
wire                 [31: 0] encrKeyRAMWord0;               // Write Crypto key [31 : 0]
wire                 [31: 0] encrKeyRAMWord1;               // Write Crypto key [63 :32]
wire                 [31: 0] encrKeyRAMWord2;               // Write Crypto key [95 :64]
wire                 [31: 0] encrKeyRAMWord3;               // Write Crypto key [127:96]
`ifdef  RW_KEY_EXTENDED
wire                 [31: 0] encrIntKeyRAMWord0;          // Write Integrity Crypto key [31 : 0]
wire                 [31: 0] encrIntKeyRAMWord1;          // Write Integrity Crypto key [63 :32]
wire                 [31: 0] encrIntKeyRAMWord2;          // Write Integrity Crypto key [95 :64]
wire                 [31: 0] encrIntKeyRAMWord3;          // Write Integrity Crypto key [127:96]
`endif//RW_KEY_EXTENDED
wire                 [31: 0] macAddrRAMLow;                 // Write MAC address [31: 0]
wire                 [15: 0] macAddrRAMHigh;                // Write MAC address [47:32]
wire                 [31: 0] encrKeyRAMWord0In;             // Read Crypto key [31 : 0]
wire                 [31: 0] encrKeyRAMWord1In;             // Read Crypto key [63 :32]
wire                 [31: 0] encrKeyRAMWord2In;             // Read Crypto key [95 :64]
wire                 [31: 0] encrKeyRAMWord3In;             // Read Crypto key [127:96]
`ifdef  RW_KEY_EXTENDED
wire                 [31: 0] encrIntKeyRAMWord0In;        // Read Integrity Crypto key [31 : 0]
wire                 [31: 0] encrIntKeyRAMWord1In;        // Read Integrity Crypto key [63 :32]
wire                 [31: 0] encrIntKeyRAMWord2In;        // Read Integrity Crypto key [95 :64]
wire                 [31: 0] encrIntKeyRAMWord3In;        // Read Integrity Crypto key [127:96]
`endif//RW_KEY_EXTENDED
wire                 [31: 0] macAddrRAMLowIn;               // Read MAC address [31: 0]
wire                 [15: 0] macAddrRAMHighIn;              // Read MAC address [47:32]
wire                         encrKeyRAMWord0InValid;        // Read Valid Crypto key [31 : 0]
wire                         encrKeyRAMWord1InValid;        // Read Valid Crypto key [63 :32]
wire                         encrKeyRAMWord2InValid;        // Read Valid Crypto key [95 :64]
wire                         encrKeyRAMWord3InValid;        // Read Valid Crypto key [127:96]
`ifdef  RW_KEY_EXTENDED
wire                         encrIntKeyRAMWord0InValid;   // Read Valid Integrity Crypto key [31 : 0]
wire                         encrIntKeyRAMWord1InValid;   // Read Valid Integrity Crypto key [63 :32]
wire                         encrIntKeyRAMWord2InValid;   // Read Valid Integrity Crypto key [95 :64]
wire                         encrIntKeyRAMWord3InValid;   // Read Valid Integrity Crypto key [127:96]
`endif//RW_KEY_EXTENDED
wire                         macAddrRAMLowInValid;          // Read Valid MAC address [31: 0]
wire                         macAddrRAMHighInValid;         // Read Valid MAC address [47:32]
wire                 [ 9: 0] keyIndexRAM;                   // Index of Key Storage RAM
wire                 [ 9: 0] keyIndexRAMIn;                 // keyIndexRAMIn
wire                         keyIndexRAMInValid;            // keyIndexRAMIn update
wire                         newWrite;                      // Trigger for write operation
wire                         newWriteIn;                    // newWriteIn
wire                         newWriteInValid;               // Clearing newWrite
wire                         newRead;                       // Trigger for read operation
wire                         newReadIn;                     // newReadIn
wire                         newReadInValid;                // Clearing newRead
wire                         newSearch;                     // Trigger for search operation
wire                         newSearchIn;                   // newSearchIn
wire                         newSearchInValid;              // Clearing newSearch
wire                         searchErrorIn;                 // searchErrorIn
wire                         searchErrorInValid;            // Clearing searchError
wire                   [1:0] cLenRAM;                       // Cipher length indication for WEP
wire                   [1:0] cLenRAMIn;                     // cLenRAM from Key Search Engine
wire                         cLenRAMInValid;                // cLenRAM update
wire                         useDefKeyRAM;                  // Indication for usage of Default Keys.
wire                         useDefKeyRAMIn;                // useDefKeyRAM from Key Search Engine
wire                         useDefKeyRAMInValid;           // useDefKeyRAM update
wire                   [1:0] sppRAM;                        // Indication for handling A-MSDU frames
wire                   [1:0] sppRAMIn;                      // sppRAM from Key Search Engine
wire                         sppRAMInValid;                 // sppRAM update
wire                   [3:0] vlanIDRAM;                     // Virtual LAN ID for searching default key
wire                   [3:0] vlanIDRAMIn;                   // vlanIDRAM from Key Search Engine
wire                         vlanIDRAMInValid;              // vlanIDRAM update
wire                   [2:0] cTypeRAM;                      // Cipher type
wire                   [2:0] cTypeRAMIn;                    // cTypeRAM from Key Search Engine
wire                         cTypeRAMInValid;               // cTypeRAM update

wire                   [7:0] staKeyStartIndex;              // Configures the index of the first STA in the Key Storage RAM.
wire                   [7:0] staKeyEndIndex;                // Configures the index of the latest STA in the Key Storage RAM. 
wire                   [3:0] nVAP;                          // Configures the number of VAP.
wire                   [7:0] staKeyMaxIndex;                // Contains the index max which can be used in the key Storage RAM

// Interconnect Control and Status Register and BA controller
wire                         baPSBitmapReset;          // PS Bitmap reset
wire                         baPSBitmapResetIn;        // PS Bitmap reset In
wire                         baPSBitmapResetInValid;   // PS Bitmap reset clear

// Interconnect Control and Status Register
wire statussetrxPayloadDMADead;  // rxPayloadDMADead interruption status       
wire statussetrxHeaderDMADead;   // rxHeaderDMADead interruption status       
wire statussetphyRxStart;        // phyRxStart interruption status       
wire statussetphyErr;            // phyErr interruption status           
wire statussetmacPHYIFUnderRun;  // macPHYIFUnderRun interruption status 
wire statussethwErr;             // hwErr interruption status            
wire statussetimpSecDTIM;        // impSecDTIM interruption status       
wire statussetimpPriDTIM;        // impPriDTIM interruption status       
wire statussettbTxDMADead;       // tbTxDMADead interruption status     
wire statussetbcnTxDMADead;      // bcnTxDMADead interruption status     
wire statussetac3TxDMADead;      // ac3TxDMADead interruption status     
wire statussetac2TxDMADead;      // ac2TxDMADead interruption status     
wire statussetac1TxDMADead;      // ac1TxDMADead interruption status     
wire statussetac0TxDMADead;      // ac0TxDMADead interruption status     
wire statussetptError;           // ptError interruption status          
wire statussettimSet;            // timSet interruption status           
wire statussetolbcDSSS;          // olbcDSSS interruption status         
wire statussetolbcOFDM;          // olbcOFDM interruption status         
wire statussetrxFIFOOverFlow;    // rxFIFOOverFlow interruption status   
wire statussetmacPHYIFOverflow;  // macPHYIFOverflow interruption status       
wire statusabsGenTimers;         // absGenTimer interruption status 
wire [9:0]statussetabsTimers;    // absTimers interruption status 
wire statussetidleInterrupt;     // idleInterrupt interruption status    
wire statussetimpSecTBTT;        // impSecTBTT interruption status       
wire statussetimpPriTBTT;        // impPriTBTT interruption status       
wire statussetrxBuffer2Trigger;  // rxBuffer2Trigger interruption status
wire statussettimerRxTrigger;    // timerRxTrigger interruption status
wire statussetrxBuffer1Trigger;  // rxBuffer1Trigger interruption status
wire statussettbTxBufTrigger;    // tbTxBufTrigger interruption status
wire statussetbcnTxBufTrigger;   // bcnTxBufTrigger interruption status
wire statussetac3TxBufTrigger;   // ac3TxBufTrigger interruption status
wire statussetac2TxBufTrigger;   // ac2TxBufTrigger interruption status
wire statussetac1TxBufTrigger;   // ac1TxBufTrigger interruption status
wire statussetac0TxBufTrigger;   // ac0TxBufTrigger interruption status
wire statussettimerTxTrigger;    // timerTxTrigger interruption status
wire statussettxopComplete;      // txopComplete interruption status
wire statussettbTxTrigger;       // tbTxTrigger interruption status
wire statussettbTxCancelled;     // tbTxCancelled interruption status
wire statussetbcnTxTrigger;      // bcnTxTrigger interruption status
wire statussetac3TxTrigger;      // ac3TxTrigger interruption status
wire statussetac2TxTrigger;      // ac2TxTrigger interruption status
wire statussetac1TxTrigger;      // ac1TxTrigger interruption status
wire statussetac0TxTrigger;      // ac0TxTrigger interruption status
wire statussettbProtTrigger;     // tbProtTrigger interruption status
wire statussetac3ProtTrigger;    // ac3ProtTrigger interruption status
wire statussetac2ProtTrigger;    // ac2ProtTrigger interruption status
wire statussetac1ProtTrigger;    // ac1ProtTrigger interruption status
wire statussetac0ProtTrigger;    // ac0ProtTrigger interruption status
wire statussetac3BWDropTrigger;  // ac3BWDropTrigger interruption status
wire statussetac2BWDropTrigger;  // ac2BWDropTrigger interruption status
wire statussetac1BWDropTrigger;  // ac1BWDropTrigger interruption status
wire statussetac0BWDropTrigger;  // ac0BWDropTrigger interruption status

wire  softReset;                   // soft reset sample 
wire  softResetMACCoreClksync;     // soft reset sample resynchronized with macCoreClk
wire  softResetMACCoreClkBacksync; // soft reset sample resynchronized with macPIClk
wire  softResetmpIFClksync;        // soft reset sample resynchronized with mpIFClk
wire  softResetmpIFClkBacksync;    // soft reset sample resynchronized with macPIClk
wire  softResetMACWTClksync;       // soft reset sample resynchronized with macWTClk
wire  softResetMACWTClkBacksync;   // soft reset sample resynchronized with macPIClk
wire  softResetMACPISlaveClksync;  // soft reset sample resynchronized with macPISlaveClk
wire  softResetMacPIClk;           // soft reset sample 
//wire  softResetMacPIClksync;       // soft reset sample 

wire  setphyRxStart;          // set phyRxStart interruption      
wire  setphyErr;              // set phyErr interruption           
wire  setmacPHYIFUnderRun;    // set macPHYIFUnderRun interruption 
wire  sethwErr;               // set hwErr interruption            
wire  setimpSecDTIM;          // set impSecDTIM interruption       
wire  setimpPriDTIM;          // set impPriDTIM interruption       
wire  settbTxDMADead;         // set tbTxDMADead interruption     
wire  setbcnTxDMADead;        // set bcnTxDMADead interruption     
wire  setac3TxDMADead;        // set ac3TxDMADead interruption     
wire  setac2TxDMADead;        // set ac2TxDMADead interruption     
wire  setac1TxDMADead;        // set ac1TxDMADead interruption     
wire  setac0TxDMADead;        // set ac0TxDMADead interruption     
wire  setptError;             // set ptError interruption          
wire  settimSet;              // set timSet interruption           
wire  setolbcDSSS;            // set olbcDSSS interruption         
wire  setolbcOFDM;            // set olbcOFDM interruption         
wire  setrxFIFOOverFlow;      // set rxFIFOOverFlow interruption   
wire  setmacPHYIFOverflow;    // set macPHYIFOverflow interruption       
wire  setrxPayloadDMADead;    // set rxPayloadDMADead interruption       
wire  setrxHeaderDMADead;     // set rxHeaderDMADead interruption       
wire  absGenTimers;           // set All absTimers interruption
wire [9:0] setabsTimers;      // set absTimers interruption
wire  setidleInterrupt;       // set idleInterrupt interruption    
wire  setimpSecTBTT;          // set impSecTBTT interruption       
wire  setimpPriTBTT;          // set impPriTBTT interruption       
wire  clearrxPayloadDMADead;  // clear rxPayloadDMADead interruption
wire  clearrxHeaderDMADead;   // clear rxHeaderDMADead interruption
wire  clearphyRxStart;        // clear phyRxStart interruption      
wire  clearphyErr;            // clear phyErr interruption           
wire  clearmacPHYIFUnderRun;  // clear macPHYIFUnderRun interruption 
wire  clearhwErr;             // clear hwErr interruption            
wire  clearimpSecDTIM;        // clear impSecDTIM interruption       
wire  clearimpPriDTIM;        // clear impPriDTIM interruption       
wire  cleartbTxDMADead;       // clear tbTxDMADead interruption     
wire  clearbcnTxDMADead;      // clear bcnTxDMADead interruption     
wire  clearac3TxDMADead;      // clear ac3TxDMADead interruption     
wire  clearac2TxDMADead;      // clear ac2TxDMADead interruption     
wire  clearac1TxDMADead;      // clear ac1TxDMADead interruption     
wire  clearac0TxDMADead;      // clear ac0TxDMADead interruption     
wire  clearptError;           // clear ptError interruption          
wire  cleartimSet;            // clear timSet interruption           
wire  clearolbcDSSS;          // clear olbcDSSS interruption         
wire  clearolbcOFDM;          // clear olbcOFDM interruption         
wire  clearrxFIFOOverFlow;    // clear rxFIFOOverFlow interruption   
wire  clearmacPHYIFOverflow;  // clear macPHYIFOverflow interruption       
wire [9:0] clearabsTimers;    // clear absTimers interruption        
wire  clearidleInterrupt;     // clear idleInterrupt interruption    
wire  clearimpSecTBTT;        // clear impSecTBTT interruption       
wire  clearimpPriTBTT;        // clear impPriTBTT interruption       
wire  masterGenIntEn;         // General Interrupt master Enable
wire  maskphyRxStart;         // phyRxStart output mask interruption
wire  maskphyErr;             // phyErr output mask interruption
wire  maskmacPHYIFUnderRun;   // macPHYIFUnderRun output mask interruption
wire  maskhwErr;              // hwErr output mask interruption
wire  maskimpSecDTIM;         // impSecDTIM output mask interruption
wire  maskimpPriDTIM;         // impPriDTIM output mask interruption
wire  masktbTxDMADead;        // tbTxDMADead output mask interruption
wire  maskbcnTxDMADead;       // bcnTxDMADead output mask interruption
wire  maskac3TxDMADead;       // ac3TxDMADead output mask interruption
wire  maskac2TxDMADead;       // ac2TxDMADead output mask interruption
wire  maskac1TxDMADead;       // ac1TxDMADead output mask interruption
wire  maskac0TxDMADead;       // ac0TxDMADead output mask interruption
wire  maskptError;            // ptError output mask interruption
wire  masktimSet;             // timSet output mask interruption
wire  maskolbcDSSS;           // olbcDSSS output mask interruption
wire  maskolbcOFDM;           // olbcOFDM output mask interruption
wire  maskrxFIFOOverFlow;     // rxFIFOOverFlow output mask interruption
wire  maskmacPHYIFOverflow;   // macPHYIFOverflow output mask interruption
wire  maskrxPayloadDMADead;   // rxPayloadDMADead output mask interruption
wire  maskrxHeaderDMADead;    // rxHeaderDMADead output mask interruption
wire  maskabsGenTimers;       // All absTimers output mask interruption
wire [9:0] maskabsTimers;     // absTimers output mask interruption
wire  maskidleInterrupt;      // idleInterrupt output mask interruption
wire  maskimpSecTBTT;         // impSecTBTT output mask interruption
wire  maskimpPriTBTT;         // impPriTBTT interruption       
wire  setrxBuffer2Trigger;         // set rxBuffer2Trigger
wire  settimerRxTrigger;      // set timerRxTrigger  
wire  setrxBuffer1Trigger;           // set rxBuffer1Trigger       
wire  settbTxBufTrigger;         // set tbTxBufTrigger
wire  setbcnTxBufTrigger;        // set bcnTxBufTrigger
wire  setac3TxBufTrigger;        // set ac3TxBufTrigger    
wire  setac2TxBufTrigger;        // set ac2TxBufTrigger    
wire  setac1TxBufTrigger;        // set ac1TxBufTrigger    
wire  setac0TxBufTrigger;        // set ac0TxBufTrigger    
wire  settimerTxTrigger;      // set timerTxTrigger  
wire  settxopComplete;        // set txopComplete    
wire  settbTxTrigger;         // set tbTxTrigger
wire  settbTxCancelled;       // set tbTxCancelled
wire  setbcnTxTrigger;        // set bcnTxTrigger
wire  setac3TxTrigger;        // set ac3TxTrigger    
wire  setac2TxTrigger;        // set ac2TxTrigger    
wire  setac1TxTrigger;        // set ac1TxTrigger    
wire  setac0TxTrigger;        // set ac0TxTrigger    
wire  settbProtTrigger;       // set tbProtTrigger  
wire  setac3ProtTrigger;      // set ac3ProtTrigger  
wire  setac2ProtTrigger;      // set ac2ProtTrigger  
wire  setac1ProtTrigger;      // set ac1ProtTrigger  
wire  setac0ProtTrigger;      // set ac0ProtTrigger  
wire  setac3BWDropTrigger;      // set ac3ProtTrigger  
wire  setac2BWDropTrigger;      // set ac2ProtTrigger  
wire  setac1BWDropTrigger;      // set ac1ProtTrigger  
wire  setac0BWDropTrigger;      // set ac0ProtTrigger  
wire  clearrxBuffer2Trigger;       // clear rxBuffer2Trigger
wire  cleartimerRxTrigger;    // clear timerRxTrigger  
wire  clearrxBuffer1Trigger;         // clear rxBuffer1Trigger       
wire  cleartbTxBufTrigger;    // clear cleartbTxBufTrigger    
wire  clearbcnTxBufTrigger;   // clear clearbcnTxBufTrigger    
wire  clearac3TxBufTrigger;   // clear ac3TxBufTrigger    
wire  clearac2TxBufTrigger;   // clear ac2TxBufTrigger    
wire  clearac1TxBufTrigger;   // clear ac1TxBufTrigger    
wire  clearac0TxBufTrigger;   // clear ac0TxBufTrigger    
wire  cleartimerTxTrigger;    // clear timerTxTrigger  
wire  cleartxopComplete;      // clear txopComplete    
wire  cleartbTxTrigger;       // clear cleartbTxTrigger    
wire  cleartbTxCancelled;     // clear cleartbTxCancelled    
wire  clearbcnTxTrigger;      // clear clearbcnTxTrigger    
wire  clearac3TxTrigger;      // clear ac3TxTrigger    
wire  clearac2TxTrigger;      // clear ac2TxTrigger    
wire  clearac1TxTrigger;      // clear ac1TxTrigger    
wire  clearac0TxTrigger;      // clear ac0TxTrigger    
wire  cleartbProtTrigger;     // clear tbProtTrigger  
wire  clearac3ProtTrigger;    // clear ac3ProtTrigger  
wire  clearac2ProtTrigger;    // clear ac2ProtTrigger  
wire  clearac1ProtTrigger;    // clear ac1ProtTrigger  
wire  clearac0ProtTrigger;    // clear ac0ProtTrigger  
wire  clearac3BWDropTrigger;  // clear ac3BWRopTrigger  
wire  clearac2BWDropTrigger;  // clear ac2BWRopTrigger  
wire  clearac1BWDropTrigger;  // clear ac1BWRopTrigger  
wire  clearac0BWDropTrigger;  // clear ac0BWRopTrigger  

wire  masterTxRxIntEn;        // TxRx Interruption master enable
wire  masktimerRxTrigger;     // timerRxTrigger output interruption mask 
wire  maskrxBuffer1Trigger;          // rxBuffer1Trigger output interruption mask 
wire  maskrxBuffer2Trigger;        // rxBuffer2Trigger output interruption mask 
wire  maskac3TxBufTrigger;    // ac3TxBufTrigger output interruption mask 
wire  maskac2TxBufTrigger;    // ac2TxBufTrigger output interruption mask 
wire  maskac1TxBufTrigger;    // ac1TxBufTrigger output interruption mask 
wire  maskac0TxBufTrigger;    // ac0TxBufTrigger output interruption mask 
wire  maskbcnTxBufTrigger;    // bcnTxBufTrigger output interruption mask 
wire  masktbTxBufTrigger;     // tbTxBufTrigger output interruption mask 
wire  masktimerTxTrigger;     // timerTxTrigger output interruption mask 
wire  masktxopComplete;       // txopComplete output interruption mask 
wire  maskac3TxTrigger;       // ac3TxTrigger output interruption mask 
wire  maskac2TxTrigger;       // ac2TxTrigger output interruption mask 
wire  maskac1TxTrigger;       // ac1TxTrigger output interruption mask 
wire  maskac0TxTrigger;       // ac0TxTrigger output interruption mask 
wire  maskbcnTxTrigger;       // bcnTxTrigger output interruption mask 
wire  masktbTxTrigger;        // tbTxTrigger output interruption mask 
wire  masktbTxCancelled;      // tbTxCancelled output interruption mask 
wire  masktbProtTrigger;      // tbProtTrigger output interruption mask 
wire  maskac3ProtTrigger;     // ac3ProtTrigger output interruption mask 
wire  maskac2ProtTrigger;     // ac2ProtTrigger output interruption mask 
wire  maskac1ProtTrigger;     // ac1ProtTrigger output interruption mask 
wire  maskac0ProtTrigger;     // ac0ProtTrigger output interruption mask 
wire  maskac3BWDropTrigger;   // ac3BWDropTrigger output interruption mask 
wire  maskac2BWDropTrigger;   // ac2BWDropTrigger output interruption mask 
wire  maskac1BWDropTrigger;   // ac1BWDropTrigger output interruption mask 
wire  maskac0BWDropTrigger;   // ac0BWDropTrigger output interruption mask 
wire  masksecUserTxTrigger;     // secUserTxTrigger output interruption mask 

wire [15:0] nextTBTT;         // Next TBTT counter in 32 us

wire   [2:0] primaryChPosition;          // Primary Channel Position
wire [15: 0] probeDelay;                 // Probe delay during active scan
wire  [15:0] listenInterval;             // Listen interval
wire         wakeupDTIM;                 // Wakeup DTIM interval
wire  [15:0] beaconInt;                  // Beacon interval
wire  [6:0]  impTBTTPeriod;              // Impending TBTT Period
wire         impTBTTIn128Us;             // Impending TBTT Interrupt Period in 128us
wire  [7:0]  noBcnTxTime;                // No Beacon Transmit Time in 16us
wire  [7:0]  dtimPeriod;                 // DTIM Period
wire  [31:0] tsfTimerLow;                // TSF[31:0] from register
wire  [31:0] tsfTimerLowIn;              // TSF[31:0] to register
wire         tsfTimerLowInValid;         // Indicates that the tsfTimerLow register has to be updated with tsfTimerLowIn
wire  [31:0] tsfTimerHigh;               // TSF[63:32] from register
wire  [31:0] tsfTimerHighIn;             // TSF[63:32] to register
wire         tsfTimerHighInValid;        // Indicates that the tsfTimerHigh register has to be updated with tsfTimerHighIn
wire  [ 7:0] timOffset;                  // Indicates to the HW the offset, from the first byte of the Beacon frame, 
                                         // at which the first byte of the TIM field is located
wire  [15:0] olbcTimer;                  // OLBC Timer
wire  [7:0]  ofdmCount;                  // OFDM Count
wire  [7:0]  dsssCount;                  // DSSS/CCK Count
wire  [7:0]  macCoreClkFreq;             // MAC Core Clock Frequency
wire  [ 9:0] txRFDelayInMACClk;          // Indicates the TX delay on the RF
wire  [ 9:0] txChainDelayInMACClk;       // Indicates the TX delay on the PHY
wire  [ 7:0] slotTime;                   // slot time for timeout
wire  [15:0] slotTimeInMACClk;           // Slot time in MAC Clocks
wire  [9:0]  macProcDelayInMACClk;       // MAC Processing Delay in MAC Clocks
wire  [9:0]  rxRFDelayInMACClk;          // Receive RF Delay in MAC Clocks
wire  [9:0]  radioWakeUpTime;            // RF wakeup time in 32us resolution
wire  [15:0] sifsBInMACClk;              // SIFS Duration for 802.11b in MAC Clocks
wire  [15:0] sifsAInMACClk;              // SIFS Duration for 802.11a in MAC Clocks
wire  [7:0]  sifsB;                      // SIFS Duration for 802.11b in us
wire  [7:0]  sifsA;                      // SIFS Duration for 802.11a in us
wire  [3:0]  rxCCADelay;                 // CCA Delay
wire  [9:0]  txDMAProcDlyInMACClk;       // Transmit DMA Processing Delay in MAC Clocks
wire  [9:0]  rifsTOInMACClk;             // RIFS TimeOut Duration in MAC Clocks
wire  [7:0]  txAbsoluteTimeout;          // Transmission Absolute Timeout
wire         dataMHStoredwithPld;        // Data Frame Mac Header Stored With Payload
wire         mgtMHStoredwithPld;         // Management Frame Mac Header Stored With Payload
wire         ctrlMHStoredwithPld;        // Control Frame Mac Header Stored With Payload
wire  [7:0]  partialUnwrapSize;          // Partial Unwrap Size
wire  [1:0]  dataFrmWrapMode;            // Data Frame Wrap Mode
wire  [1:0]  mgtFrmWrapMode;             // Management Frame Wrap Mode
wire  [1:0]  ctrlFrmWrapMode;            // Control Frame Wrap Mode
wire         disableRxBuffer2;           // Disable Rx Buffer 2

wire  [7:0]  txPacketTimeout;            // Transmission Packet Timeout
wire  [7:0]  rxAbsoluteTimeout;          // Reception Absolute Timeout
wire  [7:0]  rxPacketTimeout;            // Reception Packet Timeout
wire  [31:0] ccaBusyDurIn;               // CCA Busy Duration
wire         ccaBusyDurInValid;          // Indicates that the ccaBusyDur register has to be updated with ccaBusyDurIn
wire  [31:0] ccaBusyDur;                 // CCA Busy Duration
wire  [31:0] ccaBusyDurSec20In;          // CCA Busy Duration on Secondary 20MHz
wire         ccaBusyDurSec20InValid;     // Indicates that the ccaBusyDurSec20 register has to be updated with ccaBusyDurSec20In
wire  [31:0] ccaBusyDurSec20;            // CCA Busy Duration on Secondary 20MHz
wire  [31:0] ccaBusyDurSec40In;          // CCA Busy Duration on Secondary 40MHz
wire         ccaBusyDurSec40InValid;     // Indicates that the ccaBusyDurSec40 register has to be updated with ccaBusyDurSec40In
wire  [31:0] ccaBusyDurSec40;            // CCA Busy Duration  on Secondary 40MHz
wire  [31:0] ccaBusyDurSec80In;          // CCA Busy Duration on Secondary 80MHz
wire         ccaBusyDurSec80InValid;     // Indicates that the ccaBusyDurSec80 register has to be updated with ccaBusyDurSec80In
wire  [31:0] ccaBusyDurSec80;            // CCA Busy Duration  on Secondary 80MHz
wire  [7:0]  quietCount1;                // Quiet Count 1
wire  [7:0]  quietPeriod1;               // Quiet Period 1
wire  [15:0] quietDuration1;             // Quiet Duration 1
wire  [15:0] quietOffset1;               // Quiet Offset 1
wire         ap;                         // Indicates the type of device (0: STA, 1: AP)
wire         bssType;                    // Indicates the type of BSS (0: IBSS, 1: Infrastructure)
wire         lpClk32786Hz;               // LP Clock Frequency (0 : 32kHz, 1 : 32.768kHz)

wire         band5G;                     // Indicate the current operating band (0: 2.4GHz, 1:5GHz)
wire         rxDSSS;                     // Indicate the current reception is DSSS/CCK
   
wire   [3:0] txAC0StateMC;               //DMA state for AC0 channel resynchronized on macCoreClk.
wire   [3:0] txAC1StateMC;               //DMA state for AC1 channel resynchronized on macCoreClk.
wire   [3:0] txAC2StateMC;               //DMA state for AC2 channel resynchronized on macCoreClk.
wire   [3:0] txAC3StateMC;               //DMA state for AC3 channel resynchronized on macCoreClk.
wire   [3:0] txBcnStateMC;               //DMA state for Beacon channel resynchronized on macCoreClk.


wire [ 9: 0] radioChirpTime          ;// out

wire [1 : 0] txAC3State              ;// DMA state for AC0 channel
wire [1 : 0] txAC2State              ;// DMA state for AC1 channel
wire [1 : 0] txAC1State              ;// DMA state for AC2 channel
wire [1 : 0] txAC0State              ;// DMA state for AC3 channel
wire [1 : 0] txBcnState              ;// DMA state for Beacon channel
wire [1 : 0] txTBState               ;// DMA state for Beacon channel

wire [1 : 0] txBWAfterDrop           ;// Transmit Bandwidth After Drop
wire [2 : 0] eOCWIn                  ;// Exposent of OFDMA Contention Window In
wire         eOCWInValid             ;// Exposent of OFDMA Contention Window In Valid
wire [3 : 0] maxMCSInHETB            ;// Max MCS in HE TB
wire [2 : 0] eOCW                    ;// Exposent of OFDMA Contention Window
wire [2 : 0] eOCWMin                 ;// Exposent of OFDMA Contention Window Minimum
wire         raRUType                ;// Random Access RU Type
wire         raRUEnable              ;// Random Access RU Enable
wire [5 : 0] txHETBRemDur            ;// HE TB Preparation Remaining Duration
wire [5 : 0] txHETBMaxDur            ;// HE TB Preparation Max Duration

wire         ulDoppler               ;// UpLink Doppler
wire         ulPEDisambiguity        ;// UpLink PE Disambiguity
wire   [1:0] ulPreFecPadding         ;// UpLink Pre-FEC Padding Factor
wire         ulLDPCExtrSymb          ;// UpLink LDPC Extra Symbol Segment
wire         ulSTBC                  ;// UpLink STBC
wire   [2:0] ulNLTFAndMidamble       ;// UpLink Number Of HE-LTF Symbols And Midamble Periodicity
wire         ulMULTFMode             ;// UpLink MU-MIMO LTF Mode
wire   [1:0] ulGILTFType             ;// UpLink GI And LTF Type
wire   [1:0] ulBW                    ;// UpLink Bandwidth
wire  [11:0] ulLength                ;// UpLink Length
wire   [3:0] ulTriggerType           ;// UpLink Trigger Type
wire   [7:0] tdUserInfoSubfield      ;// Trigger Dependent User Info subfield
wire   [2:0] ulNSS                   ;// UpLink NSS
wire         ulRUType                ;// UpLink RU Type
wire         ulDCM                   ;// UpLink DCM
wire   [3:0] ulMCS                   ;// UpLink MCS
wire         ulFECCoding             ;// UpLink Fec Coding
wire   [2:0] ulRUSize                ;// UpLink RU Size
wire         ulPSDULenValidPI        ;// UpLink PSDU Length Valid
wire  [19:0] ulPSDULen               ;// UpLink PSDU Length
wire   [6:0] ulTargetRSSI            ;// Uplink Target RSSI 
wire   [5:0] apTXPower               ;// AP TX power
wire   [7:0] heTBUPHControl          ;// HE-TB Uplink power headroom

wire         rxPayBusErr             ;// out
wire         rxHdrBusErr             ;// out
wire         txNewHeadErr            ;// out
wire         txBusErr                ;// out
wire         txPTAddressErr          ;// out
wire         txNextPointerErr        ;// out
wire         txUPatternErr           ;// out
wire         txLenMismatch           ;// in
wire         txTBHaltAfterTXOP       ;// in
wire         txAC3HaltAfterTXOP      ;// in
wire         txAC2HaltAfterTXOP      ;// in
wire         txAC1HaltAfterTXOP      ;// in
wire         txAC0HaltAfterTXOP      ;// in
wire         txBcnHaltAfterTXOP      ;// in
wire         txAC3EndQ               ;// in
wire         txAC2EndQ               ;// in
wire         txAC1EndQ               ;// in
wire         txAC0EndQ               ;// in
wire         txBcnEndQ               ;// in
wire         txAC3Startup            ;// in
wire         txAC2Startup            ;// in
wire         txAC1Startup            ;// in
wire         txAC0Startup            ;// in
wire         txBcnStartup            ;// in
wire [31: 0] tbStatusPointer         ;// in
wire [31: 0] bcnStatusPointer        ;// in
wire [31: 0] ac0StatusPointer        ;// in
wire [31: 0] ac1StatusPointer        ;// in
wire [31: 0] ac2StatusPointer        ;// in
wire [31: 0] ac3StatusPointer        ;// in
wire [31: 0] txCurrentPointer        ;// in
wire [29: 0] rxHeaderTFPtr           ;// in

wire [31: 0] txTBHeadPtr             ;// out
wire [31: 0] txBcnHeadPtr            ;// out
wire [31: 0] txAC0HeadPtr            ;// out
wire [31: 0] txAC1HeadPtr            ;// out
wire [31: 0] txAC2HeadPtr            ;// out
wire [31: 0] txAC3HeadPtr            ;// out
wire [ 5: 0] dmaRBDSize              ;// out
wire [ 5: 0] dmaRHDSize              ;// out
wire [ 5: 0] dmaTBDSize              ;// out
wire [ 5: 0] dmaTHDSize              ;// out
wire [ 5: 0] ptEntrySize             ;// out
wire [ 7: 0] rxFIFOThreshold         ;// out
wire [ 7: 0] txFIFOThreshold         ;// out

wire [31: 0] macAddrLow              ;// out
wire [15: 0] macAddrHigh             ;// out
wire [31: 0] macAddrLowMask          ;// out
wire [15: 0] macAddrHighMask         ;// out
wire [31: 0] bssIDLow                ;// out
wire [15: 0] bssIDHigh               ;// out
wire [31: 0] bssIDLowMask            ;// out
wire [15: 0] bssIDHighMask           ;// out
wire         rxRIFSEn                ;// out
wire         tsfUpdatedBySW          ;// out
wire         tsfMgtDisable           ;// out
wire [ 2: 0] abgnMode                ;// a/b/g/n/ac Mode
wire   [5:0] bssColorCSReg           ;// out
wire         bssColorEnCSReg         ;// out
wire         partialBSSColorEnCSReg  ;// out
//wire         bssHE                   ;// out

wire         useErrDet               ;// out
wire         useErrRec               ;// in
wire         errInHWLevel3           ;// out
wire         errInTxRxLevel2         ;// out
wire         errInRxLevel1           ;// out
wire         errInTxLevel1           ;// out
wire         clearErrInHWLevel3      ;// out
wire         clearErrInTxRxLevel2    ;// out
wire         clearErrInRxLevel1      ;// out
wire         clearErrInTxLevel1      ;// out
wire         enDuplicateDetection    ;// out
wire [15: 0] aid                     ;// out
wire [ 7: 0] bcnUpdateOffset         ;// out
wire         dtimUpdatedBySW         ;// out

wire   [1:0] backoffOffset           ;// out

wire  [25:0] basicNAVCounter         ;// out
wire  [25:0] basicNAVCounterIn       ;// out
wire         basicNAVCounterInValid  ;// out
wire  [15:0] intraNAVCounter         ;// out
wire  [15:0] intraNAVCounterIn       ;// out
wire         intraNAVCounterInValid  ;// out

wire         enableLPClkSwitch;    // Enable the switch to LP clock in DOZE  

wire [ 3: 0] currentState;         // Indicates the current state of the Core. The state encoding is as follows:
                                   // 0000 - IDLE state. This is the default state.
                                   // 0010 - DOZE state
                                   // 0011 - ACTIVE state
                                   // 0100 to 1111  - reserved
wire  [3:0]  nextState;            // Indicates the next state of the Core
wire         latchNextState_p;     // Pulse in macPlReg domain to indicate that nextState has been updated
wire  [3:0]  nextStateIn;          // When the current state goes back to IDLE, the nextState is also set to IDLE
wire         nextStateInValid;     // Indicates that the nextStateIn value can be capture.

wire         activeClkGating;      // Active Clock Gating This bit is set by SW to turn on 
                                   // active clock gating in HW. When reset; the HW does not 
                                   // perform active clock gating; i.e. does not turn off 
                                   // clocks to save power in ACTIVE state.
wire  [1:0]  wt2CryptClkRatio;     // Clock ratio between wtClk and macCryptClk
wire         macSecClkEn;          // Clock Enable for macSecClk Clocks
wire         disableACKResp;       // Disable ACK Response This bit is set by SW to disable 
                                   // the automatic ACK generation logic in HW.
wire         disableCTSResp;       // Disable CTS Response This bit is set by SW to disable 
                                   // the automatic CTS generation logic in HW.
wire         disableBAResp;        // Disable BA Response This bit is set by SW to disable 
                                   // the automatic BA generation logic in HW.
wire         disableBQRResp;       // Disable BQR Response This bit is set by SW to disable 
                                   // the automatic BQR generation logic in HW.
wire         disableTBResp;        // Disable Trigger Based Response.
wire         disableTBCS;          // Disable Carrier Sense on Trigger Based Response
wire         disableTBRU26Resp;    // Disable HE-TB Response on a 26-tones RU
                                   // (except HE TB feedback NDP)
wire         disableTBUPH;         // Disable UPH Control field in HE TB Response
wire         disableSVDRxPause;    // Disable RX pause during SVD Processing


wire [47:0]  macAddr;                 // MAC Addr
wire [47:0]  macAddrMask;             // MAC Addr mask

wire [47:0]  bssID;                   // BSSID
wire [47:0]  bssIDMask;               // BSSID Mask

wire         excUnencrypted;          // Exclude unencrypted frames
wire         dontDecrypt;             // Don't decrypt frames
wire         enableOBSSPD;            // Enable OBSS PD Spatial Resuse
wire         enableSRP;               // Enable SRP Spatial Reuse
wire         acceptTriggerSWFrames;   // Accept Trigger frames handled by SW
wire         acceptTriggerHWFrames;   // Accept Trigger frames handled by HW
wire         dcmSupport;              // DCM Support
wire         dopplerSupport;          // Doppler Support
wire         acceptAllTriggerFrames;  // Accept All Trigger frames
wire         acceptMulticast;         // Accept Multicast frames
wire         acceptBroadcast;         // Accept Broadcast frames
wire         acceptOtherBSSID;        // Accept other BSSID frames
wire         acceptErrorFrames;       // Accept error frames
wire         acceptUnicast;           // Accept Unicast frames
wire         acceptMyUnicast;         // Accept frames directed to this device
wire         acceptProbeReq;          // Accept Probe Request frames
wire         acceptProbeResp;         // Accept Probe Response frames
wire         acceptBeacon;            // Accept Beacon frames
wire         acceptAllBeacon;         // Accept all Beacon 
wire         acceptDecryptErrorFrames;// Accept frames which failed decryption
wire         acceptOtherMgmtFrames;   // Accept other management frames
wire         acceptBfmeeFrames;       // Accept Beamformee frames
wire         acceptBAR;               // Accept Block Ack Request frames
wire         acceptNotExpectedBA;     // Accept Block Ack Request frames received after SIFS
wire         acceptBA;                // Accept Block Ack frames
wire         acceptPSPoll;            // Accept PS-Poll frames
wire         acceptRTS;               // Accept RTS frames
wire         acceptCTS;               // Accept CTS frames
wire         acceptACK;               // Accept ACK frames
wire         acceptCFEnd;             // Accept CF-End frames
wire         acceptOtherCntrlFrames;  // Accept other control frames
wire         acceptData;              // Accept Data frames
wire         acceptCFWOData;          // Accept CF WithOut Data frames
wire         acceptQData;             // Accept QoS Data frames
wire         acceptQCFWOData;         // Accept QoS CF WithOut Data frames
wire         acceptQoSNull;           // Accept QoS Null frames
wire         acceptOtherDataFrames;   // Accept other Data frames
wire         acceptUnknown;           // Accept unknown frames

// hwFSMReset
wire         hwFSMReset;              // HW FSM Reset
wire         hwFSMResetIn;            // HW FSM Reset In
wire         hwFSMResetInValid;       // HW FSM Reset clear
wire         hwFSMResetmpIFClk;       // HW FSM Reset Resync on mpIFClk
wire         hwFSMResetBackmpIFClk;   // HW FSM Reset Resync on mpIFClk
wire         hwFSMResetPIClk;         // HW FSM Reset Resync on PIFClk
wire         hwFSMResetBackPIClk;     // HW FSM Reset Resync on PIFClk
wire         hwFSMResetWTClk;         // HW FSM Reset Resync on WTFClk
wire         hwFSMResetBackWTClk;     // HW FSM Reset Resync on WTFClk
wire         hwFSMResetCoreClk;       // HW FSM Reset Resync on CoreClk
wire         hwFSMResetAll;           // HW FSM Reset All from all clk domain


wire   [7:0] rxStartDelayMIMO;       // Receive Start Delay for MIMO
wire   [7:0] rxStartDelayShort;      // Receive Start Delay for DSSS/CCK Short preamble
wire   [7:0] rxStartDelayLong;       // Receive Start Delay for DSSS/CCK Long preamble
wire   [7:0] rxStartDelayOFDM;       // Receive Start Delay for OFDM

wire  [31:0] absTimerValue0;         // absolute timer 0 value
wire  [31:0] absTimerValue1;         // absolute timer 1 value
wire  [31:0] absTimerValue2;         // absolute timer 2 value
wire  [31:0] absTimerValue3;         // absolute timer 3 value
wire  [31:0] absTimerValue4;         // absolute timer 4 value
wire  [31:0] absTimerValue5;         // absolute timer 5 value
wire  [31:0] absTimerValue6;         // absolute timer 6 value
wire  [31:0] absTimerValue7;         // absolute timer 7 value
wire  [31:0] absTimerValue8;         // absolute timer 8 value
wire  [31:0] absTimerValue9;         // absolute timer 9 value
wire  [31:0] monotonicCounter1;      // monotonic counter 1
wire  [31:0] monotonicCounterLow2;   // monotonic counter 2
wire  [15:0] monotonicCounterHigh2;  // monotonic counter 2
wire         monotonicCounter2SWUpdate;  // monotonic counter 2
wire  [31:0] monotonicCounterLow2In;   // monotonic counter 2
wire  [15:0] monotonicCounterHigh2In;  // monotonic counter 2
wire         monotonicCounterLow2InValid;   // monotonic counter 2
wire         monotonicCounterHigh2InValid;  // monotonic counter 2

wire [15:0] txOpLimit0;              // Transmit Opportunity Limit for AC0.
wire [15:0] txOpLimit1;              // Transmit Opportunity Limit for AC1.
wire [15:0] txOpLimit2;              // Transmit Opportunity Limit for AC2.
wire [15:0] txOpLimit3;              // Transmit Opportunity Limit for AC3.
wire [ 3:0] aifsn0;                  // AIFSN for AC0.
wire [ 3:0] aifsn1;                  // AIFSN for AC1.
wire [ 3:0] aifsn2;                  // AIFSN for AC2.
wire [ 3:0] aifsn3;                  // AIFSN for AC3.
wire [ 3:0] cwMin0;                  // Minimum CW for AC0.
wire [ 3:0] cwMin1;                  // Minimum CW for AC1.
wire [ 3:0] cwMin2;                  // Minimum CW for AC2.
wire [ 3:0] cwMin3;                  // Minimum CW for AC3.
wire [ 3:0] cwMax0;                  // Maximum CW for AC0.
wire [ 3:0] cwMax1;                  // Maximum CW for AC1.
wire [ 3:0] cwMax2;                  // Maximum CW for AC2.
wire [ 3:0] cwMax3;                  // Maximum CW for AC3.

wire [ 3:0] currentCW0;              // current Contetion window value
wire [ 3:0] currentCW1;              // current Contetion window value 
wire [ 3:0] currentCW2;              // current Contetion window value
wire [ 3:0] currentCW3;              // current Contetion window value
wire [15:0] ac1MOT;                  // medium occupancy timer of AC0
wire [15:0] ac0MOT;                  // medium occupancy timer of AC1
wire [15:0] ac3MOT;                  // medium occupancy timer of AC2
wire [15:0] ac2MOT;                  // medium occupancy timer of AC3
wire [ 7:0] ac3QSRC;                 // short retry count on AC0
wire [ 7:0] ac2QSRC;                 // short retry count on AC1
wire [ 7:0] ac1QSRC;                 // short retry count on AC2
wire [ 7:0] ac0QSRC;                 // short retry count on AC3
wire [ 7:0] ac3QLRC;                 // long retry count on AC0
wire [ 7:0] ac2QLRC;                 // long retry count on AC1
wire [ 7:0] ac1QLRC;                 // long retry count on AC2
wire [ 7:0] ac0QLRC;                 // long retry count on AC3
wire [ 2:0] activeAC;                // Indicates which AC is currently selected.
wire [ 6:0] ocwLFSR;                 // OFDMA Contention Window LFSR
wire [ 6:0] ocwLFSRIn;               // OFDMA Contention Window LFSR In
wire        ocwLFSRInValid;          // OFDMA Contention Window LFSR In Valid



wire [ 5:0] rxControlLs;             // RX Controller latched state
wire [ 5:0] rxControlCs;             // RX Controller current state
wire [ 8:0] txControlLs;             // TX Controller latched state
wire [ 8:0] txControlCs;             // TX Controller current state
wire [ 7:0] macControlLs;            // MAC Controller latched state
wire [ 7:0] macControlCs;            // MAC Controller current state


wire        pwrMgt;                // Power Management is enabled for the current
                                   // transmission
wire [ 7:0] dot11LongRetryLimit;   // dot11LongRetryLimit
wire [ 7:0] dot11ShortRetryLimit;  // dot11ShortRetryLimit
wire  [7:0] dsssMaxPwrLevel;       // Maximum Power Level for DSSS/CK frames
wire  [7:0] ofdmMaxPwrLevel;       // Maximum Power Level for OFDM frames
wire  [7:0] ofdmMinPwrLevel;       // Minimum Power Level for OFDM frames
wire  [2:0] maxPHYNtx;             // Maximum Number of TX chains
wire [19:0] maxAllowedLength;      // Filter frames whose length is greater than this length

wire [15:0] cfEndSTBCDur;          // CF-End STBC Duration
wire  [7:0] ctsSTBCDur;            // CTS STBC Duration
wire        dualCTSProt;           // Dual-CTS Protection
wire  [6:0] basicSTBCMCS;          // Basic STBC MCS

wire [15:0] bbServiceA;            // Service field when the modulation is OFDM.
wire  [7:0] bbServiceB;            // Service field when the modulation is DSSS/CCK.

wire        sendCFEnd;             // Send CF-End
wire        sendCFEndNow;          // Send CF-End Now
wire        sendCFEndNowInValid;   // Indicates that the sendCFEndNow register has to be updated with sendCFEndNowIn
wire        sendCFEndNowIn;        // Give the update value of sendCFEndNow
wire        keepTXOPOpen;          // Keep TXOP Open
wire        remTXOPInDurField;     // Remaining TXOP Indicated in Duration Field

wire        dynBWEn;               // Enable dynamic Bandwidth support
wire        dropToLowerBW;         // Drop To Lower Bandwidth
wire  [2:0] numTryBWAcquisition;   // Number of Tries for 40/80/160MHz TXOP Acquisition
wire  [1:0] defaultBWTXOP;         // Indicates the default bandwidth for TXOP acquisition
wire        defaultBWTXOPV;        // Indicates if the defaultBWTXOP setting is valid.
wire  [7:0] aPPDUMaxTime;          // aPPDU Maximum Time on Air
wire  [1:0] maxSupportedBW;        // max Supported BW

wire        supportLSTP;           // Indicates that the HW support L-SIG TXOP

`ifdef RW_BFMEE_EN                    
wire  [1:0] bfrHELTFType;          // Beamforming Report HE-LTF-TYPE(HE Only)
wire  [1:0] bfrGIType;             // Beamforming Report giType (HE Only)
wire  [2:0] bfrFormatMod;          // Beamforming Report Format and Modulation
wire        bfrShortGI;            // Beamforming Report Short GI
wire  [7:0] bfrMCS;                // Beamforming Report MCS
wire  [2:0] bfmeeNc;               // Beamforming Report Nc Index
wire  [2:0] bfmeeNr;               // Beamforming Report Nr Index
wire  [1:0] bfmeeGrouping;         // Beamforming Report Grouping
wire        bfmeeCodebook;         // Beamforming Report Codebook
wire        bfmeeMUSupport;        // Enable Beamformee Multi User
wire        bfmeeEnable;           // Enable Beamformee mode
`endif // RW_BFMEE_EN                    
wire  [2:0] defaultPEDur;          // Default Packet Extension Duration

wire        srParameterSetValid;   // Indicates that the Spatial reuse parameters are valid
wire        srpDisallowed;         // Indicates whether SRP-based SR transmissions are 
                                   // allowed or not
wire        nonSRGOBSSPDSRDisallowed; // Indicates whether non-SRG OBSS PD SR transmissions are
                                   // allowed or not
wire        nonSRGOffsetPresent;   // Indicates that the non-SRG OBSS PD Max Offset is valid
wire  [7:0] nonSRGOBSSPDMaxOffset; // Indicates the non-SRG OBSS PD Max Offset value
wire        srgInformationPresent; // Indicates that the SRG OBSS PD parameters are valid
wire  [7:0] srgOBSSPDMaxOffset;    // Indicates the SRG OBSS PD Max Offset value
wire  [7:0] srgOBSSPDMinOffset;    // Indicates the SRG OBSS PD Min Offset value
wire [63:0] srgBSSColorBitmap;     // Indicates the SRG BSS Color Bitmap
wire [63:0] srgPartialBSSIDBitmap; // Indicates the SRG Partial BSSID Bitmap

wire [11:0] bssBasicRateSet;       // BSS Basic Rate Set
wire [15:0] bssBasicHTMCSSetEM;    // BSS Basic HT MCS Set for Equal Modulation
wire  [5:0] bssBasicHTMCSSetUM;    // BSS Basic HT MCS Set for Unequal Modulation
wire [15:0] bssBasicVHTMCSSet;     // BSS Basic VHT MCS Set

wire  [7:0] quietCount1In;         // Quiet Count 1 update 
wire        quietCount1InValid;    // Quiet Count 1 update valid
wire  [7:0] quietPeriod1In;        // Quiet Period 1 update
wire        quietPeriod1InValid;   // Quiet Period 1 update valid
wire [15:0] quietDuration1In;      // Quiet Duration 1 update 
wire        quietDuration1InValid; // Quiet Duration 1 update valid
wire [15:0] quietOffset1In;        // Quiet Offset 1 update
wire        quietOffset1InValid;   // Quiet Offset 1 update valid
wire        quietElement1InValid;  // Indicates that the Quiet 1 registers have to be updated with Quiet 1 In elements

wire  [7:0] dtimPeriodIn;          // DTIM period
wire        dtimPeriodInValid;     // Indicates that the dtimPeriod register has to be updated with dtimPeriodIn

// Interconnect between RX Controller and Doze controller
wire        wakeUpFromDoze;        // Wake Up From Doze
wire        wakeUpSW;              // Wake Up SW

wire        trigTxAC0;             // Trigger from the MAC Controller to indicate DMA to 
                                   // start fetching frames associated with AC0
wire        trigTxAC1;             // Trigger from the MAC Controller to indicate DMA to
                                   // start fetching frames associated with AC1
wire        trigTxAC2;             // Trigger from the MAC Controller to indicate DMA to 
                                   // start fetching frames associated with AC2
wire        trigTxAC3;             // Trigger from the MAC Controller to indicate DMA to
                                   // start fetching frames associated with AC3
wire        trigTxBcn;             // Trigger from the MAC Controller to indicate DMA to 
                                   // start fetching frames associated with Beacon
wire        trigTxTB;              // Trigger from the MAC Controller to indicate DMA to 
                                   // start fetching frames associated with TB

wire        trigTxAC0PI;           // trigTxAC0 Resynchronized on macPITxClk clock domain
wire        trigTxAC1PI;           // trigTxAC1 Resynchronized on macPITxClk clock domain
wire        trigTxAC2PI;           // trigTxAC2 Resynchronized on macPITxClk clock domain
wire        trigTxAC3PI;           // trigTxAC3 Resynchronized on macPITxClk clock domain
wire        trigTxBcnPI;           // trigTxBcn Resynchronized on macPITxClk clock domain
wire        trigTxTBPI;            // trigTxTB  Resynchronized on macPITxClk clock domain

wire        frameRxed_p;           // MAC Controller indicates a frame is successfully
                                   // received
wire        rxListProcCsIsIdle;    // rxListProc FSM is in IDLE state                                   
wire        txListProcCsIsIdle;    // txListProc FSM is in IDLE state                                   
wire        rxFifoAboveThreshold;  // Indication that the current level of FIFO is above the 
                                   // minimum threshold to start moving packets from the 
                                   // RX FIFO to the SRAM.
wire        swRTS_p;               // Asserted high if the current transmitted packet is a
                                   // RTS frame prepared by SW
wire        txMpduDone_p;          // Asserted high after every transmission of MPDU in an 
                                   // AMPDU frame
wire        ampduFrm_p;            // Asserted high if the transmitted packet was an AMPDU
                                   // frame
wire        retryFrame_p;          // If the transmitted frame has to be retried then this
                                   // signal is asserted.
wire        mpduSuccess_p;         // If the transmitted frame was successful. Not asserted
                                   // for RTS frames
wire        mpduFailed_p;          // If the transmitted frame was not successful. Not asserted
                                   // if the RTS frame failed
wire        rtsFailed_p;           // If the transmitted frame was a RTS frame and did not 
                                   // receive a CTS frame within the CTS timeout
wire        rtsSuccess_p;          // If the transmitted frame was a RTS frame and successfully
                                   // received a CTS in reponse.
wire        retryLimitReached_p;   // If the transmitted frame was not successful and has reached  
                                   // the retry limit.Is asserted for both RTS and other MPDU's    
wire [1:0]  transmissionBW;        // Indicates whether the frame was transmitted with 20MHz or 40Mhz BW
wire [7:0]  numMPDURetries;        // Indicates the number of retries for this MPDU. Valid when 
                                   // rtsFailed_p rtsSuccess_p mpduSuccess_p mpduFailed_p or 
                                   // retryLimitReached 
wire [7:0]  numRTSRetries;         // Indicates the number of retries for this RTS. Valid when 
                                   // rtsFailed_p rtsSuccess_p mpduSuccess_p mpduFailed_p or 
                                   // retryLimitReached 
wire [31:0] mediumTimeUsed;        // Indicates the medium Time Used for current transmission
                                   // Valid when DMA status is being updated

wire        rxFrmDiscard;          // Indicate the rxController to discard current frame
wire        rxDescAvailable;       // Indicate that the DMA has all the needed desc for the current rxFrame
wire        rxFlowCntrlEn;         // Indicate the rx Flow Control is enabled
wire [ 3:0] whichDescriptorSW;     // Indicates the value of the partAMorMSDU field Controller

wire        statusUpdated_p;       // Indication from the DMA that status have been updated.
wire        updateDMAStatus_p;     // trigs the DMA Status update.


// TX FIFO
wire        txFIFOReset;                  // TX FIFO reset
wire        txFIFOResetIn;                // TX FIFO reset In
wire        txFIFOResetInValid;           // TX FIFO reset clear
wire        primaryTxFIFOResetInValid;    // TX FIFO reset clear

// RX FIFO 
wire        rxFIFOEmpty;                  // FIFO empty indication
wire [31:0] rxFIFORdData;                 // Data read from RX FIFO
wire  [3:0] rxFIFORdTag;                  // Data from TAG FIFO
wire        rxFIFORead;                   // Read signal to RX FIFO
wire        rxFIFOAlmEmpty;               // RX FIFO Almst Empty indication
wire        rxFIFOReset;                  // RX FIFO reset
wire        rxFIFOResetIn;                // RX FIFO reset In
wire        rxFIFOResetInValid;           // RX FIFO reset clear
   
// DMA
wire        cleartxAC0NewTail;             //Clear signal to Clear the txAC0NewTail bit in
                                           //the DMA Control register
wire        cleartxAC1NewTail;             //Clear signal to Clear the txAC1NewTail bit in
                                           //the DMA Control register
wire        cleartxAC2NewTail;             //Clear signal to Clear the txAC2NewTail bit in
                                           //the DMA Control register
wire        cleartxAC3NewTail;             //Clear signal to Clear the txAC3NewTail bit in
                                           //the DMA Control register
wire        cleartxBcnNewTail;             //Clear signal to Clear the txBcnNewTail bit in
                                           //the DMA Control register
wire        cleartxAC0NewHead;             //Clear signal to Clear the txAC0NewHead bit in
                                           //the DMA Control register
wire        cleartxAC1NewHead;             //Clear signal to Clear the txAC1NewHead bit in
                                           //the DMA Control register
wire        cleartxAC2NewHead;             //Clear signal to Clear the txAC2NewHead bit in
                                           //the DMA Control register
wire        cleartxAC3NewHead;             //Clear signal to Clear the txAC3NewHead bit in
                                           //the DMA Control register
wire        cleartxBcnNewHead;             //Clear signal to Clear the txBcnNewHead bit in
                                           //the DMA Control register
wire        cleartxTBNewHead;              //Clear signal to Clear the txTBNewHead bit in
                                           //the DMA Control register


wire        settxAC0NewTail;              //Set signal to Set the txAC0NewTail bit in
                                          //the DMA Control register
wire        settxAC1NewTail;              //Set signal to Set the txAC1NewTail bit in
                                          //the DMA Control register
wire        settxAC2NewTail;              //Set signal to Set the txAC2NewTail bit in
                                          //the DMA Control register
wire        settxAC3NewTail;              //Set signal to Set the txAC3NewTail bit in
                                          //the DMA Control register
wire        settxBcnNewTail;              //Set signal to Set the txBcnNewTail bit in
                                          //the DMA Control register
wire        settxAC0NewHead;              //Set signal to Set the txAC0NewHead bit in
                                          //the DMA Control register
wire        settxAC1NewHead;              //Set signal to Set the txAC1NewHead bit in
                                          //the DMA Control register
wire        settxAC2NewHead;              //Set signal to Set the txAC2NewHead bit in
                                          //the DMA Control register
wire        settxAC3NewHead;              //Set signal to Set the txAC3NewHead bit in
                                          //the DMA Control register
wire        settxBcnNewHead;              //Set signal to Set the txBcnNewHead bit in
                                          //the DMA Control register
wire        settxTBNewHead;               //Set signal to Set the txTBNewHead bit in
                                          //the DMA Control register


wire        statussettxAC0NewTail;      //Status signal of txAC0NewTail bit in
                                        //the DMA Control register
wire        statussettxAC1NewTail;      //Status signal of txAC1NewTail bit in
                                        //the DMA Control register
wire        statussettxAC2NewTail;      //Status signal of txAC2NewTail bit in
                                        //the DMA Control register
wire        statussettxAC3NewTail;      //Status signal of txAC3NewTail bit in
                                        //the DMA Control register
wire        statussettxBcnNewTail;      //Status signal of txBcnNewTail bit in
                                        //the DMA Control register
wire        statussettxAC0NewHead;      //Status signal of txAC0NewHead bit in
                                        //the DMA Control register
wire        statussettxAC1NewHead;      //Status signal of txAC1NewHead bit in
                                        //the DMA Control register
wire        statussettxAC2NewHead;      //Status signal of txAC2NewHead bit in
                                        //the DMA Control register
wire        statussettxAC3NewHead;      //Status signal of txAC3NewHead bit in
                                        //the DMA Control register
wire        statussettxBcnNewHead;      //Status signal of txBcnNewHead bit in
                                        //the DMA Control register
wire        statussettxTBNewHead;       //Status signal of txTBNewHead bit in
                                        //the DMA Control register


wire        statussethaltAC0AfterTXOP;     //Indicates the status of the haltAC0AfterTXOP bit of the 
                                           //DMA Control register
wire        statussethaltAC1AfterTXOP;     //Indicates the status of the haltAC1AfterTXOP bit of the 
                                           //DMA Control register
wire        statussethaltAC2AfterTXOP;     //Indicates the status of the haltAC2AfterTXOP bit of the 
                                           //DMA Control register
wire        statussethaltAC3AfterTXOP;     //Indicates the status of the haltAC3AfterTXOP bit of the 
                                           //DMA Control register
wire        statussethaltBcnAfterTXOP;     //Indicates the status of the haltBcnAfterTXOP bit of the 
                                           //DMA Control register
wire        statussethaltTBAfterTXOP;      //Indicates the status of the haltTBAfterTXOP bit of the 
                                           //DMA Control register


wire        sethaltAC0AfterTXOP;     //Set the status of the haltAC0AfterTXOP bit of the 
                                     //DMA Control register
wire        sethaltAC1AfterTXOP;     //Set the status of the haltAC1AfterTXOP bit of the 
                                     //DMA Control register
wire        sethaltAC2AfterTXOP;     //Set the status of the haltAC2AfterTXOP bit of the 
                                     //DMA Control register
wire        sethaltAC3AfterTXOP;     //Set the status of the haltAC3AfterTXOP bit of the 
                                     //DMA Control register
wire        sethaltBcnAfterTXOP;     //Set the status of the haltBcnAfterTXOP bit of the 
                                     //DMA Control register
wire        sethaltTBAfterTXOP;      //Set the status of the haltTBAfterTXOP bit of the 
                                     //DMA Control register


wire        clearhaltAC0AfterTXOP;   //Clear the status of the haltAC0AfterTXOP bit of the 
                                     //DMA Control register
wire        clearhaltAC1AfterTXOP;   //Clear the status of the haltAC1AfterTXOP bit of the 
                                     //DMA Control register
wire        clearhaltAC2AfterTXOP;   //Clear the status of the haltAC2AfterTXOP bit of the 
                                     //DMA Control register
wire        clearhaltAC3AfterTXOP;   //Clear the status of the haltAC3AfterTXOP bit of the 
                                     //DMA Control register
wire        clearhaltBcnAfterTXOP;   //Clear the status of the haltBcnAfterTXOP bit of the 
                                     //DMA Control register
wire        clearhaltTBAfterTXOP;    //Clear the status of the haltTBAfterTXOP bit of the 
                                     //DMA Control register
wire [30:0] rxBuf1StartPtr;          // Receive buffer 1 start pointer
wire [30:0] rxBuf1EndPtr;            // Receive buffer 1 end   pointer
wire [31:0] rxBuf1RdPtr;             // Receive buffer 1 read  pointer
wire [31:0] rxBuf1WrPtr;             // Receive buffer 1 write pointer
wire [31:0] rxBuf1WrPtrIn;           // Receive buffer 1 write pointer
wire        rxBuf1WrPtrInValid;      // Receive buffer 1 write pointer update
wire [30:0] rxBuf2StartPtr;          // Receive buffer 2 start pointer
wire [30:0] rxBuf2EndPtr;            // Receive buffer 2 end   pointer
wire [31:0] rxBuf2RdPtr;             // Receive buffer 2 read  pointer
wire [31:0] rxBuf2WrPtr;             // Receive buffer 2 write pointer
wire [31:0] rxBuf2WrPtrIn;           // Receive buffer 1 write pointer
wire        rxBuf2WrPtrInValid;      // Receive buffer 1 write pointer update
wire  [7:0] rxBufRHDHeader;          // Receive buffer RHD header size
wire  [7:0] rxBufRHDFooter;          // Receive buffer RHD footer size
wire  [7:0] rxBufRPDHeader;          // Receive buffer RHD header size
wire  [7:0] rxBufRPDFooter;          // Receive buffer RHD footer size


// Interconnect between mibController module and register
wire        mibTableReset;              // mibTableReset from host indicating
                                        // of mibTableReset bit in
                                        // macCntrl1Reg
wire [9:0]  mibTableIndex;              // MIB Table Index in the MIB Table that needs to be updated.
wire        mibIncrementMode;           // MIB Increment Mode
                                        //   When set; the contents of the MIB entry pointed to 
                                        //   by the mibTableIndex are incremented by the mibValue.
                                        //   When reset; the contents of the MIB entry pointed to 
                                        //   by the mibTableIndex are overwritten by the mibValue.

wire [15:0] mibValue;                   // MIB Value
wire        mibWrite;                   // MIB Write
wire        mibWriteInValid;            // Clear the mibWrite bit
wire        mibWriteIn;                 // mibWrite
wire        mibTableResetIn;            // mibTableResetIn  
wire        mibTableResetInValid;       // Clear the mibTableReset bit


// Interconnect between debugPort module and register
wire [31:0] debugPortRead;               // Reflect to register the value of debugPort output
reg  [31:0] debugPortReadResync;         // Reflect to register the value of debugPort output captured on macLPClock
wire  [7:0] debugPortSel1;               // Debug Port Selection 1
wire  [7:0] debugPortSel2;               // Debug Port Selection 2
wire [15:0] debugPortBackoff;            // Debug Port from BackOff Module
wire [15:0] debugPortBackoff2;           // Debug Port from BackOff Module
wire [15:0] debugPortBackoff3;           // Debug Port from BackOff Module
wire [15:0] debugPortMainFSM1;           // Debug Port with Main FSMs
wire [15:0] debugPortMainFSM2;           // Debug Port with Main FSMs
wire [15:0] debugPortMainFSM;            // Debug Port with Main FSMs
wire [15:0] debugPortDMA1;               // Debug Port DMA 1
wire [15:0] debugPortDMA2;               // Debug Port DMA 2
wire [15:0] debugPortDMA3;               // Debug Port DMA 3
wire [15:0] debugPortDMA4;               // Debug Port DMA 4
wire [15:0] debugPortDMA5;               // Debug Port DMA 5
wire [15:0] debugPortDMA6;               // Debug Port DMA 6
wire [15:0] debugPortMACTimerUnit;       // Debug Port MAC Timer Unit
wire [15:0] debugPortMACTimerUnit2;      // Debug Port MAC Timer Unit
wire [15:0] debugPortMACTimerUnit3;      // Debug Port MAC Timer Unit
wire [15:0] debugPortDeaggregator;       // Debug port from Deaggregator
wire [15:0] debugPortDeaggregator2;      // Debug port from Deaggregator2
wire  [3:0] debugPortDeaggregatorFsm;    // Debug port from Deaggregator FSM
wire [15:0] debugPortRxController;       // Debug port from Rx Controller
wire [15:0] debugPortRxFrameDebug1;      // Debug port for Rx frame debug 1
wire [15:0] debugPortRxFrameDebug2;      // Debug port for Rx frame debug 2
wire [15:0] debugPortTxFrameDebug1;      // Debug port for Tx frame debug 1
wire [15:0] debugPortTxFrameDebug2;      // Debug port for Tx frame debug 2
wire [15:0] debugPortFrameDebug1;        // Debug port for frame debug 1
wire [15:0] debugPortFrameDebug2;        // Debug port for frame debug 2
wire [15:0] debugPortInterrupt;          // Debug port for Interrupts
wire [15:0] debugPortMACPhyIf;           // Debug port from MAC PHY IF
wire [15:0] debugPortMACPhyIf2;          // Debug port from MAC PHY IF
wire [15:0] debugPortMACPhyIf3;          // Debug port from MAC PHY IF
wire [15:0] debugPortBAController;       // Debug port from BA Controller
wire [15:0] debugPortBAController2;      // Debug port from BA Controller
wire [15:0] debugPortBAController3;      // Debug port from BA Controller
wire [15:0] debugPortTxParametersCache;  // Debug Port from TX Parameter Cache
wire [15:0] debugPortMACController1;     // Debug Port 1 from the MAC Controller
wire [15:0] debugPortMediumAccess;       // Debug Port Medium Access
wire [15:0] debugPortNAV;                // Debug Port NAV
wire [15:0] debugPortMACControllerRx;    // DebugPort of the MAC Controller Rx
wire [15:0] debugPortMACControllerRxSWTB;// DebugPort of the MAC controller RX
wire [15:0] debugPortMACControllerTx;    // DebugPort of the MAC Controller Tx
wire [15:0] debugPortBWManagement;       // DebugPort of BW Management
wire [31:0] debugPortEncryptionEngine;   // DebugPort of the EncryptionEngine
wire [15:0] debugPortEncryptionCCMP;      // DebugPort of the EncryptionEngine CCMP
`ifdef RW_WAPI_EN
wire [15:0] debugPortWapi;               // DebugPort of Wapi encryption engine
`endif //RW_WAPI_EN
wire [15:0] debugPortDMAStatus;          // DebugPort of DMA Status
wire [15:0] debugPortDMATxStatus;        // txStatusUpdater Debug Port
wire [15:0] debugPortDmaRdWrCtlr;        // DebugPort of DMA Rd Wr Controller
wire [15:0] debugPortTxRxListA;          // DebugPort of DMA Rx List
wire [15:0] debugPortAMPDU;              // Debug Port AMPDU
wire [15:0] debugPortKeySearch;          // Debug Port Key search Engine
wire [15:0] debugPortrxFIFOCntrl;        // Debug Port rxFifoController
wire [15:0] debugPortDecryptFsm;         // Debug Port rxDecryptFSM
wire [15:0] debugPortTriggerDecoder;     // Debug port triggerDecoder
`ifdef RW_BFMEE_EN
wire [15:0] debugPortBFRController;      // Debug port of the BFR Controller
`endif //RW_BFMEE_EN
wire [15:0] debugPortDozeController;     // DebugPort of the Doze Controller
wire [15:0] debugPortSRController;       // Debug port of the SR Controller
wire [15:0] debugPortTxTimeCalculator;   // Debug port of the TX Time Calculator
wire [15:0] debugPortClockGating;        // Debug Port from BackOff Module
wire [15:0] debugPortClock;              // Debug Port from BackOff Module
`ifdef  RW_BFMEE_EN
wire [15:0] debugPortSVD;                // Debug Port of SVD Interface
wire [15:0] debugPortSVD2;               // Debug Port of SVD Interface
wire [15:0] debugPortSVDFifo;            // Debug Port of SVD Interface
`endif//RW_BFMEE_EN
wire        dmaInternalError;            // Generate a pulse when an internal error occured
// Debug clock generation
reg         macPIClkDbg;                 // Primary MAC Platform Interface Clock
reg         macPITxClkDbg;               // Secondary MAC Platform Interface Clock for TX
reg         macPIRxClkDbg;               // Secondary MAC Platform Interface Clock for RX
reg         macPISlaveClkDbg;            // MAC Platform Interface Slave Clock
reg         macCoreClkDbg;               // Primary MAC Core Clock
reg         macCryptClkDbg;              // Secondary MAC Core Clock for encryption
reg         macCoreTxClkDbg;             // Secondary MAC Core Clock for TX
reg         macCoreRxClkDbg;             // Secondary MAC Core Clock for RX
reg         macLPClkDbg;                 // MAC Low Power clock. 
reg         macWTClkDbg;                 // Clock input for WEP/TKIP blocks.
reg         mpIFClkDbg;                  // MAC PHY Interface Clock


wire        rxReqForceDeassertion;       // Force Deassertion of rxReq after each reception of rxEnd_p
wire        rxEndForTimingErrRec;        // Enable rxEndForTiming error recovery mechanism
wire [63:0] swProf;                      // Debug Port Software Profiling
wire [63:0] swProfInValid;               // Debug Port Software Profiling
wire [63:0] swProfIn;                    // Debug Port Software Profiling
wire [63:0] swSetProf;
wire [63:0] swClearProf;
wire [63:0] statusswSetProf;


`ifdef RW_BFMEE_EN
//BFR HW Accelerator Interface
wire        macBfrStart;              // BFR computation started
wire        macBfrDone;               // Beamforming Report computation is done
wire  [1:0] macBfrChBW;               // Beamforming report Channel Width
wire  [1:0] macBfrGrouping;           // Beamforming report Grouping
wire        macBfrCodebook;           // Beamforming report Codebook Information
wire  [1:0] macBfrFeedbackType;       // Beamforming report Feedback Type
wire  [2:0] macBfrNr;                 // Beamforming report Nr Index
wire  [2:0] macBfrNc;                 // Beamforming report Nc Index
wire        macBfrHE;                 // Beamforming report Format
                                      // (VHT or HE)
wire  [6:0] macBfrRUStartIndex;       // Beamforming report RU Start Index
                                      // (Only for HE BFR)
wire  [6:0] macBfrRUEndIndex;         // Beamforming report RU End Index 
                                      // (Only for HE BFR)
wire  [7:0] macBfrData;               // Beamforming report byte
wire        macBfrDataValid;          // Beamforming report byte valid          
wire        macBfrDataReady;          // Beamforming report byte request
`endif //RW_BFMEE_EN


`ifdef RW_MAC_MIBCNTL_EN

////////////////////////////////////////
// interconnect MIB HostIF
////////////////////////////////////////
wire [`RW_MIB_ADDR_WIDTH-1 :0] mibAddr;       // Address From Host
wire [`RW_MIB_DATA_WIDTH-1 :0] mibWrData;     // Data from Host to be
                                              // written to RAM
wire                           mibWr;         // Wr Enable signal from host
wire                           mibRd;         // Rd Enable signal from host
wire [`RW_MIB_DATA_WIDTH-1 :0] mibRdData;     // Read Data forwarded to Host
wire                           mibBusy;       // Output MIB busy indication to host

`endif // RW_MAC_MIBCNTL_EN


reg         macPIRxClkEnMC;
reg         macPITxClkEnMC;
wire        macCoreRxClkEnInt;
wire        rxFIFOEmptyWrClk;
wire        txFIFOFlushDone_p;
wire        absGenTimersInt;       // absGenTimers masked with maskabsTimers
wire        absGenTimersIntMC;     // absGenTimersInt resynchronized on macLPClk
wire        rxBuffer1Trigger;      // Trigger for receive Buffer 1 interrupt
wire        rxBuffer2Trigger;      // Trigger for receive Buffer 2 interrupt

`ifdef RW_WLAN_COEX_EN                
wire        coexEnable;            // Enable Coex Feature
wire  [3:0] coexPTIBKData;         // PTI default value for Data frame transmitted on BK AC
wire  [3:0] coexPTIBEData;         // PTI default value for Data frame transmitted on BE AC
wire  [3:0] coexPTIVIData;         // PTI default value for Data frame transmitted on VI AC
wire  [3:0] coexPTIVOData;         // PTI default value for Data frame transmitted on VO AC
wire  [3:0] coexPTIBcnData;        // PTI default value for Data frame transmitted on Beacon AC
wire  [3:0] coexPTIMgt;            // PTI default value for Management frame
wire  [3:0] coexPTICntl;           // PTI default value for Control frames other than ACK and BA
wire  [3:0] coexPTIAck;            // PTI default value for ACK and BA

wire  [3:0] coexForceWlanPTI;      // Forced value of coexWlanPTI
wire        coexForceWlanPTIToggle;// Forced value of coexWlanPTIToggle
wire        coexForceWlanChanBw;   // Forced value of coexWlanPTIToggle
wire        coexForceWlanRx;       // Forced value of coexWlanPTIToggle
wire        coexForceWlanTx;       // Forced value of coexWlanPTIToggle
wire        coexForceEnable;       // Use coex Forced values
wire        coexPostponeTxEnable;  // Enable the Postpone Tx feature
wire        coexAutoPTIAdjEnable;  // Enable the Automatic PTI Adjustment feature
wire  [1:0] coexAutoPTIAdjIncr;    // Automatic PTI Adjustment Increment
wire        coexPHYRxAbortEnable;  // Enable the PHY Rx Abort
wire        coexPHYTxAbortEnable;  // Enable the PHY Rx Abort
wire [15:0] debugPortCoexController;// Coex Debug Port
wire        coexWlanTxAbortGated;  // Gated version of coexWlanTxAbort by coexEnable
wire        coexWlanTxAbortResync; // coexWlanTxAbort resynchronized on macCoreClk 
wire        coexWlanRxAbortGated;  // Gated version of coexWlanRxAbort by coexEnable
wire        coexWlanRxAbortResync; // coexWlanRxAbort resynchronized on macCoreClk 

wire  [3:0] coexWlanPTIState;      // Coex Wlan PTI output State
wire        coexWlanPTIToggleState;// Coex Wlan PTI Toggle output State
wire        coexWlanChanBwState;   // Coex Wlan Channel BW output State
wire        coexWlanRxState;       // Coex Wlan Rx output State
wire        coexWlanTxState;       // Coex Wlan Tx output State
wire        coexWlanRxAbortState;  // Coex Wlan RX Abort input State
wire        coexWlanTxAbortState;  // Coex Wlan Tx Abort input State

wire        coexWlanRxAbortFallEn; // Coex Wlan Rx Abort Falling Edge Enable
wire        coexWlanRxAbortRiseEn; // Coex Wlan Rx Abort Rising Edge Enable
wire        coexWlanTxAbortFallEn; // Coex Wlan Tx Abort Falling Edge Enable
wire        coexWlanTxAbortRiseEn; // Coex Wlan Tx Abort Rising Edge Enable

wire        setcoexEvent;          // set coexEvent interruption           
wire        clearcoexEvent;        // clear coexEvent interruption           
wire        maskcoexEvent;         // coexEvent output mask interruption
wire        statussetcoexEvent;    // coexEvent interruption status           
wire        coexEvent;             // Pulse coex event for interrupt generation
`endif // RW_WLAN_COEX_EN                



`ifdef RW_SIMU_ON
wire [8:0]  hMSelSpy;
wire [8:0]  hSSelSpy;
wire [31:0] hSAddrSpy;
`endif // RW_SIMU_ON

// Interconnect Primary and Secondary TX Path
wire        txRxExchangeEnabled;   // Indicates that tx or rx echange is on-going  
wire        txInProgress;          // Tx Frame Exchange is ongoing
wire        sendOnSIFS;            // If set; data is sent on tickSIFS else on tickSlot
wire [15:0] duration;              // Duration
wire [15:0] tsfDuration;           // Duration from the preamble until the first bit of TSF
wire        rxVector1Valid_p;      // Rx vector 1 is available


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////



 // SIGNATUREREG register.
assign signature        = `MACHW_SIGNATURE;
 // VERSION1REG register.
assign muMIMOTx         = 1'd`MACHW_MUMIMOTX;
assign bfmer            = 1'd`MACHW_BFMER;
assign bfmee            = 1'd`MACHW_BFMEE;
assign he               = 1'd`MACHW_HE;
assign coex             = 1'd`MACHW_COEX;
assign wapi             = 1'd`MACHW_WAPI;
assign vht              = 1'd`MACHW_VHT;        
assign tpc              = 1'd`MACHW_TPC;        
assign ht               = 1'd`MACHW_HT;        
assign gcmp             = 1'd`MACHW_GCMP;
assign rce              = 1'd`MACHW_RCE;       
assign ccmp             = 1'd`MACHW_CCMP;      
assign tkip             = 1'd`MACHW_TKIP;      
assign wep              = 1'd`MACHW_WEP;       
assign security         = 1'd`MACHW_SECURITY;  
assign sme              = 1'd`MACHW_SME;       
assign edca             = 1'd`MACHW_EDCA;      
assign qos              = 1'd`MACHW_QOS;       
 // VERSION2REG register.
assign phaseNumber      = 3'd`MACHW_PHASENUMBER;   
assign releaseNumber    = 6'd`MACHW_RELEASENUMBER; 
assign ieRelease        = 1'd`MACHW_IERELEASE;      
assign umVersion        = 7'd`MACHW_UMVERSION ;    
 // BITMAPCNTREG register.
assign bitmapCnt        = 16'd`MACHW_BITMAPCNT; 
 // ERRRECCTRL register.
assign useErrRec      = 1'b0;
 // MACERRRECSTATUS1REG register.
assign  statuserrInHWLevel3   = 1'b0;
assign  statuserrInTxRxLevel2 = 1'b0;
assign  statuserrInRxLevel1   = 1'b0;
assign  statuserrInTxLevel1   = 1'b0; 
 // RXCNTRLREG register.
assign  enDuplicateDetection  = 1'b0;

// Instanciation of simpleSynchro
// Name of the instance : U_CoreClk_softReset_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_coreClk_softReset_synchro (
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (softReset),
                .dstdata            (softResetMACCoreClksync)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_CoreClk_softReset_back_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_coreClk_softReset_back_synchro (
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (softResetMACCoreClksync),
                .dstdata            (softResetMACCoreClkBacksync)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_mpIFClk_softReset_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_mpIFClk_softReset_synchro (
                .dstclk             (mpIFClk),
                .dstresetn          (mpIFClkHardRst_n),
                .srcdata            (softReset),
                .dstdata            (softResetmpIFClksync)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_mpIFClk_softReset_back_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_mpIFClk_softReset_back_synchro (
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (softResetmpIFClksync),
                .dstdata            (softResetmpIFClkBacksync)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_macWTClk_softReset_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_macWTClk_softReset_synchro (
                .dstclk             (macWTClk),
                .dstresetn          (macWTClkHardRst_n),
                .srcdata            (softReset),
                .dstdata            (softResetMACWTClksync)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_macWTClk_softReset_back_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_macWTClk_softReset_back_synchro (
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (softResetMACWTClksync),
                .dstdata            (softResetMACWTClkBacksync)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_macPISlaveClk_softReset_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_macPISlaveClk_softReset_synchro (
                .dstclk             (macPISlaveClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (softResetMACCoreClksync),
                .dstdata            (softResetMACPISlaveClksync)
                );

//// Instanciation of simpleSynchro
//// Name of the instance : U_macPISlaveClk_softReset_synchro
//// Name of the file containing this module : simpleSynchro.v
//simpleSynchro U_macPIClk_softReset_synchro (
//                .dstclk             (macPIClk),
//                .dstresetn          (macPIClkHardRst_n),
//                .srcdata            (softResetMacPIClk),
//                .dstdata            (softResetMacPIClksync)
//                );

assign softResetMacPIClk = softResetMACPISlaveClksync && softResetMACWTClkBacksync && softResetmpIFClkBacksync && softResetMACCoreClkBacksync;

assign macCoreClkSoftRst_n    = !softResetMACCoreClksync;
assign mpIFClkSoftRst_n       = !softResetmpIFClksync;
assign macWTClkSoftRst_n      = !softResetMACWTClksync;
assign macPISlaveClkSoftRst_n = !softResetMACPISlaveClksync;
assign macPIClkSoftRst_n      = !softResetMacPIClk;


always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macPIRxClkEnMC <= 1'b1; 
  else if (macCoreClkSoftRst_n == 1'b0)  // Synchronous Reset
    macPIRxClkEnMC <= 1'b1; 
  else
  begin 
    if (macCoreRxClkEn || !activeClkGating)
      macPIRxClkEnMC <= 1'b1;
    else if (!macSecClkEn)
      macPIRxClkEnMC <= 1'b0;
    else if (rxListProcCsIsIdle && rxFIFOEmptyWrClk) 
      macPIRxClkEnMC <= 1'b0;
  end
end

assign macCoreRxClkEn = macCoreRxClkEnInt | !rxFIFOEmptyWrClk;

always @(posedge macCoreClk or negedge macCoreClkHardRst_n)
begin
  if (macCoreClkHardRst_n == 1'b0)
    macPITxClkEnMC <= 1'b1;
  else if(macCoreClkSoftRst_n == 1'b0)
    macPITxClkEnMC <= 1'b1;
  else 
  begin
    if (macCoreTxClkEn || (currentState != 4'd2) || !activeClkGating)
      macPITxClkEnMC <= 1'b1;
    else if (!macSecClkEn || ((currentState != 4'd2) && activeClkGating && txListProcCsIsIdle))
      macPITxClkEnMC <= 1'b0;
  end
end


//// Instanciation of simpleSynchro
//// Name of the instance : U_hwFSMResetmpIFClk_synchro
//// Name of the file containing this module : simpleSynchro.v
//simpleSynchro U_platformWakeUpMC_synchro (
//                .dstclk             (macPIClk),
//                .dstresetn          (macPIClkHardRst_n),
//                .srcdata            (platformWakeUpMC),
//                .dstdata            (platformWakeUp)
//                );


// Instanciation of simpleSynchro
// Name of the instance : U_macPIRxClkEnMC_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_macPIRxClkEnMC_synchro (
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (macPIRxClkEnMC),
                .dstdata            (macPIRxClkEn)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_macPITxClkEnMC_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_macPITxClkEnMC_synchro (
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (macPITxClkEnMC),
                .dstdata            (macPITxClkEn)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_hwFSMResetmpIFClk_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_hwFSMResetmpIFClk_synchro (
                .dstclk             (mpIFClk),
                .dstresetn          (mpIFClkHardRst_n),
                .srcdata            (hwFSMReset),
                .dstdata            (hwFSMResetmpIFClk)
                );

simpleSynchro U_hwFSMResetmpIFClk_back_synchro (
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (hwFSMResetmpIFClk),
                .dstdata            (hwFSMResetBackmpIFClk)
                );


// Instanciation of simpleSynchro
// Name of the instance : U_hwFSMResetPIClk_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_hwFSMResetPIClk_synchro (
                .dstclk             (macPIClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (hwFSMReset),
                .dstdata            (hwFSMResetPIClk)
                );

simpleSynchro U_hwFSMResetPIClk_back_synchro (
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (hwFSMResetPIClk),
                .dstdata            (hwFSMResetBackPIClk)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_hwFSMResetWTClk_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_hwFSMResetWTClk_synchro (
                .dstclk             (macWTClk),
                .dstresetn          (macWTClkHardRst_n),
                .srcdata            (hwFSMReset),
                .dstdata            (hwFSMResetWTClk)
                );

simpleSynchro U_hwFSMResetWTClk_back_synchro (
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (hwFSMResetWTClk),
                .dstdata            (hwFSMResetBackWTClk)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_hwFSMResetCoreClk_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_hwFSMResetCoreClk_synchro (
                .dstclk             (macLPClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (hwFSMResetAll),
                .dstdata            (hwFSMResetCoreClk)
                );

assign absGenTimersInt = ((absTimers & maskabsTimers) != 10'b0) ? 1'b1 : 1'b0;


// Instanciation of simpleSynchro
// Name of the instance : U_statusabsGenTimers_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_statusabsGenTimers_synchro (
                .dstclk             (macLPClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (absGenTimersInt),
                .dstdata            (absGenTimersIntMC)
                );


assign hwFSMResetAll     = hwFSMResetBackmpIFClk && hwFSMResetBackPIClk && hwFSMResetBackWTClk && hwFSMReset;
assign hwFSMResetIn      = !(hwFSMReset && hwFSMResetCoreClk);
assign hwFSMResetInValid =  (hwFSMReset && hwFSMResetCoreClk);

assign dmaSoftRst_n      = !hwFSMResetPIClk    && macPIClkSoftRst_n;
assign mpifSoftRst_n     = !hwFSMResetmpIFClk  && mpIFClkSoftRst_n;
assign txFifoSoftRst_n   = !hwFSMResetCoreClk  && macCoreClkSoftRst_n;


// Instanciation of simpleSynchro
// Name of the instance : U_trigTxAC0_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_trigTxAC0_synchro (
                .dstclk             (macPITxClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (trigTxAC0),
                .dstdata            (trigTxAC0PI)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_trigTxAC1_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_trigTxAC1_synchro (
                .dstclk             (macPITxClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (trigTxAC1),
                .dstdata            (trigTxAC1PI)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_trigTxAC2_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_trigTxAC2_synchro (
                .dstclk             (macPITxClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (trigTxAC2),
                .dstdata            (trigTxAC2PI)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_trigTxAC3_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_trigTxAC3_synchro (
                .dstclk             (macPITxClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (trigTxAC3),
                .dstdata            (trigTxAC3PI)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_trigTxACBcn_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_trigTxACBcn_synchro (
                .dstclk             (macPITxClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (trigTxBcn),
                .dstdata            (trigTxBcnPI)
                );

// Instanciation of simpleSynchro
// Name of the instance : U_trigTxTB_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_trigTxTB_synchro (
                .dstclk             (macPITxClk),
                .dstresetn          (macPIClkHardRst_n),
                .srcdata            (trigTxTB),
                .dstdata            (trigTxTBPI)
                );


// Instanciation of txFifo
// Name of the instance : U_txFifo
// Name of the file containing this module : txFifo.v
txFifo U_txFifo (
    .macPITxClk                       (macPITxClk),
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    //.macCoreTxClk                     (macCoreTxClk),
    .macCoreTxClk                     (macCoreClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (txFifoSoftRst_n),
    .txFIFOReset                      (txFIFOReset),
    .txFIFOResetInValid               (primaryTxFIFOResetInValid),
    .txFIFOWrFlush                    (txFIFOWrFlush),
    .txFIFOWrite                      (txFIFOWrite),
    .txFIFOWrData                     (txFIFOWrData),
    .txFIFOWrTag                      (txFIFOWrTag),
    .txFIFOAlmostFull                 (txFIFOAlmostFull),
    .txFIFOFull                       (txFIFOFull),
    .txFIFOAlmEmptyWrClk              (txFIFOAlmEmptyWrClk),
    .txFIFOEmptyWrClk                 (txFIFOEmptyWrClk),
    .txFIFORdFlush                    (txFIFORdFlush),
    .txFIFORead                       (txFIFORead),
    .txFIFOEmpty                      (txFIFOEmpty),
    .txFIFODataValid                  (txFIFODataValid),
    .txFIFORdData                     (txFIFORdData),
    .txFIFOMPDUDelimiters             (txFIFOMPDUDelimiters),
    .txFIFOReadData                   (txFIFOReadData),
    .txFIFOReadAddr                   (txFIFOReadAddr),
    .txFIFOReadEn                     (txFIFOReadEn),
    .txFIFOWriteAddr                  (txFIFOWriteAddr),
    .txFIFOWriteData                  (txFIFOWriteData),
    .txFIFOWriteEn                    (txFIFOWriteEn)
    );

assign txFIFOResetIn = 1'b0;


// Instanciation of rxFifo
// Name of the instance : U_rxFifo
// Name of the file containing this module : rxFifo.v
rxFifo U_rxFifo (
    .macPIRxClk                       (macPIRxClk),
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .macCoreRxClk                     (macCoreRxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .rxFIFOReset                      (rxFIFOReset),
    .rxFIFOResetInValid               (rxFIFOResetInValid),
    .rxFIFOWrFlush                    (ZERO_CT),
    .rxFIFOWrite                      (rxFIFOWrite),
    .rxFIFOWrData                     (rxFIFOWrData),
    .rxFIFOWrTag                      (rxFIFOWrTag),
    .rxFIFOAlmostFull                 (rxFIFOAlmostFull),
    .rxFIFOFull                       (rxFIFOFull),
    .rxFIFOAlmEmptyWrClk              (),
    .rxFIFOEmptyWrClk                 (rxFIFOEmptyWrClk),
    .rxFIFORdFlush                    (ZERO_CT),
    .rxFIFORead                       (rxFIFORead),
    .rxFIFOAlmEmpty                   (rxFIFOAlmEmpty),
    .rxFIFOEmpty                      (rxFIFOEmpty),
    .rxFIFODataValid                  (),
    .rxFIFORdData                     (rxFIFORdData),
    .rxFIFOMPDUDelimiters             (rxFIFORdTag),
    .rxFIFOReadData                   (rxFIFOReadData),
    .rxFIFOReadAddr                   (rxFIFOReadAddr),
    .rxFIFOReadEn                     (rxFIFOReadEn),
    .rxFIFOWriteAddr                  (rxFIFOWriteAddr),
    .rxFIFOWriteData                  (rxFIFOWriteData),
    .rxFIFOWriteEn                    (rxFIFOWriteEn)
    );

assign rxFIFOResetIn = 1'b0;
assign ZERO_CT       = 1'b0;

// Instanciation of dmaEngineWrapper
// Name of the instance : U_dmaEngineWrapper
// Name of the file containing this module : dmaEngineWrapper.v
dmaEngineWrapper U_dmaEngineWrapper (
    .macPITxClk                       (macPITxClk),
    .macPIRxClk                       (macPIRxClk),
    .macCoreClk                       (macCoreClk),
    .macCoreRxClk                     (macCoreRxClk),
    .macPIClk                         (macPIClk),
    .macPITxClkHardRst_n              (macPIClkHardRst_n),
    .macPIRxClkHardRst_n              (macPIClkHardRst_n),
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macPITxClkSoftRst_n              (dmaSoftRst_n),
    .macPIRxClkSoftRst_n              (dmaSoftRst_n),
    .macPIClkSoftRst_n                (dmaSoftRst_n),
    .dmaHIFReadDataOut                (dmaHIFReadDataOut),
    .dmaHIFReadDataValid              (dmaHIFReadDataValid),
    .dmaHIFReady                      (dmaHIFReady),
    .dmaHIFTransComplete              (dmaHIFTransComplete),
    .dmaHIFError                      (dmaHIFError),
    .trigTxAC0                        (trigTxAC0),
    .trigTxAC1                        (trigTxAC1),
    .trigTxAC2                        (trigTxAC2),
    .trigTxAC3                        (trigTxAC3),
    .trigTxBcn                        (trigTxBcn),
    .trigTxTB                         (trigTxTB),
    .trigTxAC0PI                      (trigTxAC0PI),
    .trigTxAC1PI                      (trigTxAC1PI),
    .trigTxAC2PI                      (trigTxAC2PI),
    .trigTxAC3PI                      (trigTxAC3PI),
    .trigTxBcnPI                      (trigTxBcnPI),
    .trigTxTBPI                       (trigTxTBPI),
    .frameRxed_p                      (frameRxed_p),
    .rxListProcCsIsIdle               (rxListProcCsIsIdle),
    .txListProcCsIsIdle               (txListProcCsIsIdle),
    .tsfTimerValue                    (tsfTimerLowIn),
    .swRTS_p                          (swRTS_p),
    .txMpduDone_p                     (txMpduDone_p),
    .ampduFrm_p                       (ampduFrm_p),
    .retryFrame_p                     (retryFrame_p),
    .mpduSuccess_p                    (mpduSuccess_p),
    .mpduFailed_p                     (mpduFailed_p),
    .rtsFailed_p                      (rtsFailed_p),
    .rtsSuccess_p                     (rtsSuccess_p),
    .retryLimitReached_p              (retryLimitReached_p),
    .transmissionBW                   (transmissionBW),
    .numMPDURetries                   (numMPDURetries),
    .numRTSRetries                    (numRTSRetries),
    .mediumTimeUsed                   (mediumTimeUsed),
    .rxFrmDiscard                     (rxFrmDiscard),
    .rxDescAvailable                  (rxDescAvailable),
    .rxBuf1StartPtr                   (rxBuf1StartPtr),
    .rxBuf1EndPtr                     (rxBuf1EndPtr),
    .rxBuf1RdPtr                      (rxBuf1RdPtr),
    .rxBuf1WrPtr                      (rxBuf1WrPtr),
    .rxBuf1WrPtrIn                    (rxBuf1WrPtrIn),
    .rxBuf1WrPtrInValid               (rxBuf1WrPtrInValid),
    .rxBuf2StartPtr                   (rxBuf2StartPtr),
    .rxBuf2EndPtr                     (rxBuf2EndPtr),
    .rxBuf2RdPtr                      (rxBuf2RdPtr),
    .rxBuf2WrPtr                      (rxBuf2WrPtr),
    .rxBuf2WrPtrIn                    (rxBuf2WrPtrIn),
    .rxBuf2WrPtrInValid               (rxBuf2WrPtrInValid),
    .rxBufRHDHeader                   (rxBufRHDHeader),
    .rxBufRHDFooter                   (rxBufRHDFooter),
    .rxBufRPDHeader                   (rxBufRPDHeader),
    .rxBufRPDFooter                   (rxBufRPDFooter),
    .partialUnwrapSize                (partialUnwrapSize),
    .rxFlowCntrlEn                    (rxFlowCntrlEn),
    .whichDescriptorSW                (whichDescriptorSW),
    .macPHYIFUnderRun                 (macPHYIFUnderRun),
    .txTBHeadPtr                      (txTBHeadPtr),
    .txBcnHeadPtr                     (txBcnHeadPtr),
    .txAC0HeadPtr                     (txAC0HeadPtr),
    .txAC1HeadPtr                     (txAC1HeadPtr),
    .txAC2HeadPtr                     (txAC2HeadPtr),
    .txAC3HeadPtr                     (txAC3HeadPtr),
    .txCtrlRegBusy                    (txCtrlRegBusy),
    .txFifoAlmostFull                 (txFIFOAlmostFull),
    .txFifoFull                       (txFIFOFull),
    .txFIFOFlushDone_p                (txFIFOFlushDone_p),
    .txFifoEmpty                      (txFIFOEmptyWrClk),
    .rxFifoEmpty                      (rxFIFOEmpty),
    .rxFIFOAlmEmpty                   (rxFIFOAlmEmpty),
    .rxFifoRdData                     (rxFIFORdData),
    .rxTagFifoRdData                  (rxFIFORdTag),
    .dmaHIFRead                       (dmaHIFRead),
    .dmaHIFWrite                      (dmaHIFWrite),
    .dmaHIFSize                       (dmaHIFSize),
    .dmaHIFAddressIn                  (dmaHIFAddressIn),
    .dmaHIFWriteDataIn                (dmaHIFWriteDataIn),
    .txCtrlRegWr                      (txCtrlRegWr),
    .txCtrlRegPT                      (txCtrlRegPT),
    .txCtrlRegHD                      (txCtrlRegHD),
    .discardPrevHD_p                  (discardPrevHD_p),
    .txAC0State                       (txAC0State),
    .txAC1State                       (txAC1State),
    .txAC2State                       (txAC2State),
    .txAC3State                       (txAC3State),
    .txBcnState                       (txBcnState),
    .txTBState                        (txTBState),
    .txAC0StateMC                     (txAC0StateMC),
    .txAC1StateMC                     (txAC1StateMC),
    .txAC2StateMC                     (txAC2StateMC),
    .txAC3StateMC                     (txAC3StateMC),
    .txBcnStateMC                     (txBcnStateMC),
    .txTBStateMC                      (/*Open*/),                                //TODO:11ax
    .txLenMismatch                    (txLenMismatch),
    .txUPatternErr                    (txUPatternErr),
    .txNextPointerErr                 (txNextPointerErr),
    .txPTAddressErr                   (txPTAddressErr),
    .txBusErr                         (txBusErr),
    .txNewHeadErr                     (txNewHeadErr),
    .rxHdrBusErr                      (rxHdrBusErr),
    .rxPayBusErr                      (rxPayBusErr),
    .ptError                          (ptError),
    .txBcnStartup                     (txBcnStartup),
    .txAC0Startup                     (txAC0Startup),
    .txAC1Startup                     (txAC1Startup),
    .txAC2Startup                     (txAC2Startup),
    .txAC3Startup                     (txAC3Startup),
    .txBcnEndQ                        (txBcnEndQ),
    .txAC0EndQ                        (txAC0EndQ),
    .txAC1EndQ                        (txAC1EndQ),
    .txAC2EndQ                        (txAC2EndQ),
    .txAC3EndQ                        (txAC3EndQ),
    .txTBHaltAfterTXOP                (txTBHaltAfterTXOP),
    .txBcnHaltAfterTXOP               (txBcnHaltAfterTXOP),
    .txAC0HaltAfterTXOP               (txAC0HaltAfterTXOP),
    .txAC1HaltAfterTXOP               (txAC1HaltAfterTXOP),
    .txAC2HaltAfterTXOP               (txAC2HaltAfterTXOP),
    .txAC3HaltAfterTXOP               (txAC3HaltAfterTXOP),
    .debugPortDMA1                    (debugPortDMA1),
    .debugPortDMA2                    (debugPortDMA2),
    .debugPortDMA3                    (debugPortDMA3),
    .debugPortDMA4                    (debugPortDMA4),
    .debugPortDMA5                    (debugPortDMA5),
    .debugPortDMA6                    (debugPortDMA6),
    .debugPortDMAStatus               (debugPortDMAStatus),
    .debugPortDMATxStatus             (debugPortDMATxStatus),
    .debugPortTxRxListA               (debugPortTxRxListA),
    .debugPortDmaRdWrCtlr             (debugPortDmaRdWrCtlr),
    .dmaInternalError                 (dmaInternalError),
    .statusUpdated_p                  (statusUpdated_p),
    .updateDMAStatus_p                (updateDMAStatus_p),
    .rxTrig_p                         (rxTrig_p),
    .tbProtTrigger                    (tbProtTrigger),
    .txFifoWr                         (txFIFOWrite),
    .txFIFOWrData                     (txFIFOWrData),
    .flushTxFifo                      (txFIFOWrFlush),
    .rxFifoRd                         (rxFIFORead),
    .txTagFifoWrData                  (txFIFOWrTag),
    .rxHeaderDMADead                  (rxHeaderDMADead),
    .rxPayloadDMADead                 (rxPayloadDMADead),
    .tbTxDMADead                      (tbTxDMADead),
    .bcnTxDMADead                     (bcnTxDMADead),
    .ac0TxDMADead                     (ac0TxDMADead),
    .ac1TxDMADead                     (ac1TxDMADead),
    .ac2TxDMADead                     (ac2TxDMADead),
    .ac3TxDMADead                     (ac3TxDMADead),
    .ac0TxTrigger                     (ac0TxTrigger),
    .ac1TxTrigger                     (ac1TxTrigger),
    .ac2TxTrigger                     (ac2TxTrigger),
    .ac3TxTrigger                     (ac3TxTrigger),
    .bcnTxTrigger                     (bcnTxTrigger),
    .tbTxTrigger                      (tbTxTrigger),
    .ac0TxBufTrigger                  (ac0TxBufTrigger),
    .ac1TxBufTrigger                  (ac1TxBufTrigger),
    .ac2TxBufTrigger                  (ac2TxBufTrigger),
    .ac3TxBufTrigger                  (ac3TxBufTrigger),
    .bcnTxBufTrigger                  (bcnTxBufTrigger),
    .tbTxBufTrigger                   (tbTxBufTrigger),
    .rxBuffer1Trigger                 (rxBuffer1Trigger),
    .rxBuffer2Trigger                 (rxBuffer2Trigger),
    .statussettxAC0NewTail            (statussettxAC0NewTail),
    .statussettxAC1NewTail            (statussettxAC1NewTail),
    .statussettxAC2NewTail            (statussettxAC2NewTail),
    .statussettxAC3NewTail            (statussettxAC3NewTail),
    .statussettxBcnNewTail            (statussettxBcnNewTail),
    .statussettxAC0NewHead            (statussettxAC0NewHead),
    .statussettxAC1NewHead            (statussettxAC1NewHead),
    .statussettxAC2NewHead            (statussettxAC2NewHead),
    .statussettxAC3NewHead            (statussettxAC3NewHead),
    .statussettxBcnNewHead            (statussettxBcnNewHead),
    .statussettxTBNewHead             (statussettxTBNewHead),
    .statussethaltTBAfterTXOP         (statussethaltTBAfterTXOP),
    .statussethaltBcnAfterTXOP        (statussethaltBcnAfterTXOP),
    .statussethaltAC3AfterTXOP        (statussethaltAC3AfterTXOP),
    .statussethaltAC2AfterTXOP        (statussethaltAC2AfterTXOP),
    .statussethaltAC1AfterTXOP        (statussethaltAC1AfterTXOP),
    .statussethaltAC0AfterTXOP        (statussethaltAC0AfterTXOP),
    .settxAC0NewTail                  (settxAC0NewTail),
    .settxAC1NewTail                  (settxAC1NewTail),
    .settxAC2NewTail                  (settxAC2NewTail),
    .settxAC3NewTail                  (settxAC3NewTail),
    .settxBcnNewTail                  (settxBcnNewTail),
    .settxAC0NewHead                  (settxAC0NewHead),
    .settxAC1NewHead                  (settxAC1NewHead),
    .settxAC2NewHead                  (settxAC2NewHead),
    .settxAC3NewHead                  (settxAC3NewHead),
    .settxBcnNewHead                  (settxBcnNewHead),
    .settxTBNewHead                   (settxTBNewHead),
    .sethaltTBAfterTXOP               (sethaltTBAfterTXOP),
    .sethaltBcnAfterTXOP              (sethaltBcnAfterTXOP),
    .sethaltAC3AfterTXOP              (sethaltAC3AfterTXOP),
    .sethaltAC2AfterTXOP              (sethaltAC2AfterTXOP),
    .sethaltAC1AfterTXOP              (sethaltAC1AfterTXOP),
    .sethaltAC0AfterTXOP              (sethaltAC0AfterTXOP),
    .cleartxAC0NewTail                (cleartxAC0NewTail),
    .cleartxAC1NewTail                (cleartxAC1NewTail),
    .cleartxAC2NewTail                (cleartxAC2NewTail),
    .cleartxAC3NewTail                (cleartxAC3NewTail),
    .cleartxBcnNewTail                (cleartxBcnNewTail),
    .cleartxAC0NewHead                (cleartxAC0NewHead),
    .cleartxAC1NewHead                (cleartxAC1NewHead),
    .cleartxAC2NewHead                (cleartxAC2NewHead),
    .cleartxAC3NewHead                (cleartxAC3NewHead),
    .cleartxBcnNewHead                (cleartxBcnNewHead),
    .cleartxTBNewHead                 (cleartxTBNewHead),
    .clearhaltTBAfterTXOP             (clearhaltTBAfterTXOP),
    .clearhaltBcnAfterTXOP            (clearhaltBcnAfterTXOP),
    .clearhaltAC3AfterTXOP            (clearhaltAC3AfterTXOP),
    .clearhaltAC2AfterTXOP            (clearhaltAC2AfterTXOP),
    .clearhaltAC1AfterTXOP            (clearhaltAC1AfterTXOP),
    .clearhaltAC0AfterTXOP            (clearhaltAC0AfterTXOP),
    .ac0StatusPointer                 (ac0StatusPointer),
    .ac1StatusPointer                 (ac1StatusPointer),
    .ac2StatusPointer                 (ac2StatusPointer),
    .ac3StatusPointer                 (ac3StatusPointer),
    .txCurrentPointer                 (txCurrentPointer),
    .bcnStatusPointer                 (bcnStatusPointer),
    .tbStatusPointer                  (tbStatusPointer),
    .rxHeaderTFPtr                    (rxHeaderTFPtr)
    );

assign rxFifoAboveThreshold = !rxFIFOAlmEmpty;
assign txCtrlRegData        = dmaHIFReadDataOut;


// Instanciation of hostIfAhb
// Name of the instance : U_hostIfAhb
// Name of the file containing this module : hostIfAhb.v
hostIfAhb U_hostIfAhb (
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macPIClk                         (macPISlaveClk),
    .macCoreClk                       (macCoreClk),
    .hSAddr                           (hSAddr),
    .hSTrans                          (hSTrans),
    .hSWrite                          (hSWrite),
    .hSSize                           (hSSize),
    .hSWData                          (hSWData),
    .hSSel                            (hSSel),
    .hSReadyIn                        (hSReadyIn),
    .hSRData                          (hSRData),
    .hSReadyOut                       (hSReadyOut),
    .hSResp                           (hSResp),
    .hMBusReq                         (hMBusReq),
    .hMLock                           (hMLock),
    .hMGrant                          (hMGrant),
    .hMAddr                           (hMAddr),
    .hMTrans                          (hMTrans),
    .hMWrite                          (hMWrite),
    .hMSize                           (hMSize),
    .hMBurst                          (hMBurst),
    .hMProt                           (hMProt),
    .hMWData                          (hMWData),
    .hMRData                          (hMRData),
    .hMReady                          (hMReady),
    .hMResp                           (hMResp),
`ifdef RW_MAC_MIBCNTL_EN
    .mibRdData                        (mibRdData),
    .mibBusy                          (mibBusy),
    .mibAddr                          (mibAddr),
    .mibWrData                        (mibWrData),
    .mibWr                            (mibWr),
    .mibRd                            (mibRd),
`endif // RW_MAC_MIBCNTL_EN
    .regReadyIn                       (regReadyIn),
    .regReadData                      (regReadData),
    .regWrite                         (regWrite),
    .regRead                          (regRead),
    .regAddr                          (regAddr),
    .regWriteData                     (regWriteData),
    .dmaHIFRead                       (dmaHIFRead),
    .dmaHIFWrite                      (dmaHIFWrite),
    .dmaHIFAddressIn                  (dmaHIFAddressIn),
    .dmaHIFReadDataOut                (dmaHIFReadDataOut),
    .dmaHIFReadDataValid              (dmaHIFReadDataValid),
    .dmaHIFSize                       (dmaHIFSize),
    .dmaHIFReady                      (dmaHIFReady),
    .dmaHIFWriteDataIn                (dmaHIFWriteDataIn),
    .dmaHIFTransComplete              (dmaHIFTransComplete),
    .dmaHIFError                      (dmaHIFError)
    );

assign hwErr = macPHYIFUnderRun;
assign timSet = 1'b0; //$todo


// Instanciation of intCtrl
// Name of the instance : U_intCtrl
// Name of the file containing this module : intCtrl.v
intCtrl U_intCtrl (
    .macPIClk                         (macPISlaveClk),
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .masterGenIntEn                   (masterGenIntEn),
    .setphyRxStart                    (setphyRxStart),
    .setphyErr                        (setphyErr),
    .setmacPHYIFUnderRun              (setmacPHYIFUnderRun),
    .sethwErr                         (sethwErr),
    .setimpSecDTIM                    (setimpSecDTIM),
    .setimpPriDTIM                    (setimpPriDTIM),
    .settbTxDMADead                   (settbTxDMADead),
    .setbcnTxDMADead                  (setbcnTxDMADead),
    .setac3TxDMADead                  (setac3TxDMADead),
    .setac2TxDMADead                  (setac2TxDMADead),
    .setac1TxDMADead                  (setac1TxDMADead),
    .setac0TxDMADead                  (setac0TxDMADead),
    .setptError                       (setptError),
    .settimSet                        (settimSet),
    .setolbcDSSS                      (setolbcDSSS),
    .setolbcOFDM                      (setolbcOFDM),
    .setrxFIFOOverFlow                (setrxFIFOOverFlow),
    .setmacPHYIFOverflow              (setmacPHYIFOverflow),
    .setrxPayloadDMADead              (setrxPayloadDMADead),
    .setrxHeaderDMADead               (setrxHeaderDMADead),
    .setabsTimers                     (setabsTimers),
    .absGenTimers                     (absGenTimers),
    .setidleInterrupt                 (setidleInterrupt),
    .setimpSecTBTT                    (setimpSecTBTT),
    .setimpPriTBTT                    (setimpPriTBTT),
    .clearphyRxStart                  (clearphyRxStart),
    .clearphyErr                      (clearphyErr),
    .clearmacPHYIFUnderRun            (clearmacPHYIFUnderRun),
    .clearhwErr                       (clearhwErr),
    .clearimpSecDTIM                  (clearimpSecDTIM),
    .clearimpPriDTIM                  (clearimpPriDTIM),
    .cleartbTxDMADead                 (cleartbTxDMADead),
    .clearbcnTxDMADead                (clearbcnTxDMADead),
    .clearac3TxDMADead                (clearac3TxDMADead),
    .clearac2TxDMADead                (clearac2TxDMADead),
    .clearac1TxDMADead                (clearac1TxDMADead),
    .clearac0TxDMADead                (clearac0TxDMADead),
    .clearptError                     (clearptError),
    .cleartimSet                      (cleartimSet),
    .clearolbcDSSS                    (clearolbcDSSS),
    .clearolbcOFDM                    (clearolbcOFDM),
    .clearrxFIFOOverFlow              (clearrxFIFOOverFlow),
    .clearmacPHYIFOverflow            (clearmacPHYIFOverflow),
    .clearrxPayloadDMADead            (clearrxPayloadDMADead),
    .clearrxHeaderDMADead             (clearrxHeaderDMADead),
    .clearabsTimers                   (clearabsTimers),
    .clearidleInterrupt               (clearidleInterrupt),
    .clearimpSecTBTT                  (clearimpSecTBTT),
    .clearimpPriTBTT                  (clearimpPriTBTT),
    .maskphyRxStart                   (maskphyRxStart),
    .maskphyErr                       (maskphyErr),
    .maskmacPHYIFUnderRun             (maskmacPHYIFUnderRun),
    .maskhwErr                        (maskhwErr),
    .maskimpSecDTIM                   (maskimpSecDTIM),
    .maskimpPriDTIM                   (maskimpPriDTIM),
    .masktbTxDMADead                  (masktbTxDMADead),
    .maskbcnTxDMADead                 (maskbcnTxDMADead),
    .maskac3TxDMADead                 (maskac3TxDMADead),
    .maskac2TxDMADead                 (maskac2TxDMADead),
    .maskac1TxDMADead                 (maskac1TxDMADead),
    .maskac0TxDMADead                 (maskac0TxDMADead),
    .maskptError                      (maskptError),
    .masktimSet                       (masktimSet),
    .maskolbcDSSS                     (maskolbcDSSS),
    .maskolbcOFDM                     (maskolbcOFDM),
    .maskrxFIFOOverFlow               (maskrxFIFOOverFlow),
    .maskmacPHYIFOverflow             (maskmacPHYIFOverflow),
    .maskrxPayloadDMADead             (maskrxPayloadDMADead),
    .maskrxHeaderDMADead              (maskrxHeaderDMADead),
    .maskabsTimers                    (maskabsTimers),
    .maskabsGenTimers                 (maskabsGenTimers),
    .maskidleInterrupt                (maskidleInterrupt),
    .maskimpSecTBTT                   (maskimpSecTBTT),
    .maskimpPriTBTT                   (maskimpPriTBTT),
    .statussetphyRxStart              (statussetphyRxStart),
    .statussetphyErr                  (statussetphyErr),
    .statussetmacPHYIFUnderRun        (statussetmacPHYIFUnderRun),
    .statussethwErr                   (statussethwErr),
    .statussetimpSecDTIM              (statussetimpSecDTIM),
    .statussetimpPriDTIM              (statussetimpPriDTIM),
    .statussettbTxDMADead             (statussettbTxDMADead),
    .statussetbcnTxDMADead            (statussetbcnTxDMADead),
    .statussetac3TxDMADead            (statussetac3TxDMADead),
    .statussetac2TxDMADead            (statussetac2TxDMADead),
    .statussetac1TxDMADead            (statussetac1TxDMADead),
    .statussetac0TxDMADead            (statussetac0TxDMADead),
    .statussetptError                 (statussetptError),
    .statussettimSet                  (statussettimSet),
    .statussetolbcDSSS                (statussetolbcDSSS),
    .statussetolbcOFDM                (statussetolbcOFDM),
    .statussetrxFIFOOverFlow          (statussetrxFIFOOverFlow),
    .statussetmacPHYIFOverflow        (statussetmacPHYIFOverflow),
    .statussetrxPayloadDMADead        (statussetrxPayloadDMADead),
    .statussetrxHeaderDMADead         (statussetrxHeaderDMADead),
    .statussetabsTimers               (statussetabsTimers),
    .statusabsGenTimers               (statusabsGenTimers),
    .statussetidleInterrupt           (statussetidleInterrupt),
    .statussetimpSecTBTT              (statussetimpSecTBTT),
    .statussetimpPriTBTT              (statussetimpPriTBTT),
    .masterTxRxIntEn                  (masterTxRxIntEn),
    .settimerRxTrigger                (settimerRxTrigger),
    .setrxBuffer1Trigger              (setrxBuffer1Trigger),
    .setrxBuffer2Trigger              (setrxBuffer2Trigger),
    .setac3TxBufTrigger               (setac3TxBufTrigger),
    .setac2TxBufTrigger               (setac2TxBufTrigger),
    .setac1TxBufTrigger               (setac1TxBufTrigger),
    .setac0TxBufTrigger               (setac0TxBufTrigger),
    .setbcnTxBufTrigger               (setbcnTxBufTrigger),
    .settbTxBufTrigger                (settbTxBufTrigger),
    .settimerTxTrigger                (settimerTxTrigger),
    .settxopComplete                  (settxopComplete),
    .setac3TxTrigger                  (setac3TxTrigger),
    .setac2TxTrigger                  (setac2TxTrigger),
    .setac1TxTrigger                  (setac1TxTrigger),
    .setac0TxTrigger                  (setac0TxTrigger),
    .setac3BWDropTrigger              (setac3BWDropTrigger),
    .setac2BWDropTrigger              (setac2BWDropTrigger),
    .setac1BWDropTrigger              (setac1BWDropTrigger),
    .setac0BWDropTrigger              (setac0BWDropTrigger),
    .settbTxTrigger                   (settbTxTrigger),
    .settbTxCancelled                 (settbTxCancelled),
    .setbcnTxTrigger                  (setbcnTxTrigger),
    .settbProtTrigger                 (settbProtTrigger),
    .setac3ProtTrigger                (setac3ProtTrigger),
    .setac2ProtTrigger                (setac2ProtTrigger),
    .setac1ProtTrigger                (setac1ProtTrigger),
    .setac0ProtTrigger                (setac0ProtTrigger),
    .cleartimerRxTrigger              (cleartimerRxTrigger),
    .clearrxBuffer1Trigger            (clearrxBuffer1Trigger),
    .clearrxBuffer2Trigger            (clearrxBuffer2Trigger),
    .clearac3TxBufTrigger             (clearac3TxBufTrigger),
    .clearac2TxBufTrigger             (clearac2TxBufTrigger),
    .clearac1TxBufTrigger             (clearac1TxBufTrigger),
    .clearac0TxBufTrigger             (clearac0TxBufTrigger),
    .clearbcnTxBufTrigger             (clearbcnTxBufTrigger),
    .cleartbTxBufTrigger              (cleartbTxBufTrigger),
    .cleartimerTxTrigger              (cleartimerTxTrigger),
    .cleartxopComplete                (cleartxopComplete),
    .clearac3TxTrigger                (clearac3TxTrigger),
    .clearac2TxTrigger                (clearac2TxTrigger),
    .clearac1TxTrigger                (clearac1TxTrigger),
    .clearac0TxTrigger                (clearac0TxTrigger),
    .clearac3BWDropTrigger            (clearac3BWDropTrigger),
    .clearac2BWDropTrigger            (clearac2BWDropTrigger),
    .clearac1BWDropTrigger            (clearac1BWDropTrigger),
    .clearac0BWDropTrigger            (clearac0BWDropTrigger),
    .clearbcnTxTrigger                (clearbcnTxTrigger),
    .cleartbTxTrigger                 (cleartbTxTrigger),
    .cleartbTxCancelled               (cleartbTxCancelled),
    .cleartbProtTrigger               (cleartbProtTrigger),
    .clearac3ProtTrigger              (clearac3ProtTrigger),
    .clearac2ProtTrigger              (clearac2ProtTrigger),
    .clearac1ProtTrigger              (clearac1ProtTrigger),
    .clearac0ProtTrigger              (clearac0ProtTrigger),
    .masktimerRxTrigger               (masktimerRxTrigger),
    .maskrxBuffer1Trigger             (maskrxBuffer1Trigger),
    .maskrxBuffer2Trigger             (maskrxBuffer2Trigger),
    .maskac3TxBufTrigger              (maskac3TxBufTrigger),
    .maskac2TxBufTrigger              (maskac2TxBufTrigger),
    .maskac1TxBufTrigger              (maskac1TxBufTrigger),
    .maskac0TxBufTrigger              (maskac0TxBufTrigger),
    .maskbcnTxBufTrigger              (maskbcnTxBufTrigger),
    .masktbTxBufTrigger               (masktbTxBufTrigger),
    .masktimerTxTrigger               (masktimerTxTrigger),
    .masktxopComplete                 (masktxopComplete),
    .maskac3TxTrigger                 (maskac3TxTrigger),
    .maskac2TxTrigger                 (maskac2TxTrigger),
    .maskac1TxTrigger                 (maskac1TxTrigger),
    .maskac0TxTrigger                 (maskac0TxTrigger),
    .maskac3BWDropTrigger             (maskac3BWDropTrigger),
    .maskac2BWDropTrigger             (maskac2BWDropTrigger),
    .maskac1BWDropTrigger             (maskac1BWDropTrigger),
    .maskac0BWDropTrigger             (maskac0BWDropTrigger),
    .maskbcnTxTrigger                 (maskbcnTxTrigger),
    .masktbTxTrigger                  (masktbTxTrigger),
    .masktbTxCancelled                (masktbTxCancelled),
    .masktbProtTrigger                (masktbProtTrigger),
    .maskac3ProtTrigger               (maskac3ProtTrigger),
    .maskac2ProtTrigger               (maskac2ProtTrigger),
    .maskac1ProtTrigger               (maskac1ProtTrigger),
    .maskac0ProtTrigger               (maskac0ProtTrigger),
    .statussettimerRxTrigger          (statussettimerRxTrigger),
    .statussetrxBuffer1Trigger        (statussetrxBuffer1Trigger),
    .statussetrxBuffer2Trigger        (statussetrxBuffer2Trigger),
    .statussetac3TxBufTrigger         (statussetac3TxBufTrigger),
    .statussetac2TxBufTrigger         (statussetac2TxBufTrigger),
    .statussetac1TxBufTrigger         (statussetac1TxBufTrigger),
    .statussetac0TxBufTrigger         (statussetac0TxBufTrigger),
    .statussetbcnTxBufTrigger         (statussetbcnTxBufTrigger),
    .statussettbTxBufTrigger          (statussettbTxBufTrigger),
    .statussettimerTxTrigger          (statussettimerTxTrigger),
    .statussettxopComplete            (statussettxopComplete),
    .statussetac3TxTrigger            (statussetac3TxTrigger),
    .statussetac2TxTrigger            (statussetac2TxTrigger),
    .statussetac1TxTrigger            (statussetac1TxTrigger),
    .statussetac0TxTrigger            (statussetac0TxTrigger),
    .statussetbcnTxTrigger            (statussetbcnTxTrigger),
    .statussettbTxTrigger             (statussettbTxTrigger),
    .statussettbTxCancelled           (statussettbTxCancelled),
    .statussettbProtTrigger           (statussettbProtTrigger),
    .statussetac3ProtTrigger          (statussetac3ProtTrigger),
    .statussetac2ProtTrigger          (statussetac2ProtTrigger),
    .statussetac1ProtTrigger          (statussetac1ProtTrigger),
    .statussetac0ProtTrigger          (statussetac0ProtTrigger),
    .statussetac3BWDropTrigger        (statussetac3BWDropTrigger),
    .statussetac2BWDropTrigger        (statussetac2BWDropTrigger),
    .statussetac1BWDropTrigger        (statussetac1BWDropTrigger),
    .statussetac0BWDropTrigger        (statussetac0BWDropTrigger),
  `ifdef RW_WLAN_COEX_EN
    .setcoexEvent                     (setcoexEvent),
    .clearcoexEvent                   (clearcoexEvent),
    .maskcoexEvent                    (maskcoexEvent),
    .statussetcoexEvent               (statussetcoexEvent),
    .coexEvent                        (coexEvent),
  `endif // RW_WLAN_COEX_EN
    .phyRxStart                       (phyRxStart),
    .phyErr                           (phyErr),
    .macPHYIFUnderRun                 (macPHYIFUnderRun),
    .hwErr                            (hwErr),
    .impSecDTIM                       (impSecDTIM),
    .impPriDTIM                       (impPriDTIM),
    .tbTxDMADead                      (tbTxDMADead),
    .bcnTxDMADead                     (bcnTxDMADead),
    .ac3TxDMADead                     (ac3TxDMADead),
    .ac2TxDMADead                     (ac2TxDMADead),
    .ac1TxDMADead                     (ac1TxDMADead),
    .ac0TxDMADead                     (ac0TxDMADead),
    .ptError                          (ptError),
    .timSet                           (timSet),
    .olbcDSSS                         (olbcDSSS),
    .olbcOFDM                         (olbcOFDM),
    .rxFIFOOverFlow                   (rxFIFOOverFlow),
    .macPHYIFOverflow                 (macPHYIFOverflow),
    .rxPayloadDMADead                 (rxPayloadDMADead),
    .rxHeaderDMADead                  (rxHeaderDMADead),
    .absTimers                        (absTimers),
    .idleInterrupt                    (idleInterruptGated),
    .impSecTBTT                       (impSecTBTT),
    .impPriTBTT                       (impPriTBTT),
    .timerRxTrigger                   (timerRxTrigger),
    .rxBuffer1Trigger                 (rxBuffer1Trigger),
    .rxBuffer2Trigger                 (rxBuffer2Trigger),
    .ac3TxBufTrigger                  (ac3TxBufTrigger),
    .ac2TxBufTrigger                  (ac2TxBufTrigger),
    .ac1TxBufTrigger                  (ac1TxBufTrigger),
    .ac0TxBufTrigger                  (ac0TxBufTrigger),
    .bcnTxBufTrigger                  (bcnTxBufTrigger),
    .tbTxBufTrigger                   (tbTxBufTrigger),
    .timerTxTrigger                   (timerTxTrigger),
    .txopComplete                     (txopComplete),
    .ac3TxTrigger                     (ac3TxTrigger),
    .ac2TxTrigger                     (ac2TxTrigger),
    .ac1TxTrigger                     (ac1TxTrigger),
    .ac0TxTrigger                     (ac0TxTrigger),
    .bcnTxTrigger                     (bcnTxTrigger),
    .tbTxTrigger                      (tbTxTrigger),
    .tbTxCancelled                    (tbTxCancelled),
    .tbProtTrigger                    (tbProtTrigger),
    .ac3ProtTrigger                   (ac3ProtTrigger),
    .ac2ProtTrigger                   (ac2ProtTrigger),
    .ac1ProtTrigger                   (ac1ProtTrigger),
    .ac0ProtTrigger                   (ac0ProtTrigger),
    .ac3BWDropTrigger                 (ac3BWDropTrigger),
    .ac2BWDropTrigger                 (ac2BWDropTrigger),
    .ac1BWDropTrigger                 (ac1BWDropTrigger),
    .ac0BWDropTrigger                 (ac0BWDropTrigger),
    .intGen_n                         (intGen_n),
    .intProtTrigger_n                 (intProtTrigger_n),
    .intTxTrigger_n                   (intTxTrigger_n),
    .intRxTrigger_n                   (intRxTrigger_n),
    .intTxRxMisc_n                    (intTxRxMisc_n),
    .intTxRxTimer_n                   (intTxRxTimer_n)
    );

// Force the idle interrupt generation only when both tx and rx list proc are back to IDLE state
always @ (posedge macLPClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    idleInterruptGated <= 1'b0;
  else 
    idleInterruptGated <= idleInterrupt & rxListProcCsIsIdle & txListProcCsIsIdle;
end

always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
  begin
    phyRxStart <= 1'b0;
    phyErr     <= 1'b0;
  end
  else
  begin 
    phyRxStart <= macPhyIfRxStart_p;
    phyErr     <= mpIfTxErr_p;
  end
end


// Instanciation of macCSReg
// Name of the instance : U_macCSReg
// Name of the file containing this module : macCSReg.v
macCSReg U_macCSReg (
    .macPIClk                         (macPISlaveClk),
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .macPIClkSoftRst_n                (macPIClkSoftRst_n),
    .macCoreClk                       (macCoreClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreClkSoftRst_n              (macCoreClkSoftRst_n),
    .nextStateIn                      (nextStateIn),
    .nextStateInValid                 (nextStateInValid),
    .currentState                     (currentState),
    .statussetrxPayloadDMADead        (statussetrxPayloadDMADead),
    .statussetrxHeaderDMADead         (statussetrxHeaderDMADead),
    .statussetphyRxStart              (statussetphyRxStart),
    .statussetphyErr                  (statussetphyErr),
    .statussetmacPHYIFUnderRun        (statussetmacPHYIFUnderRun),
    .statussethwErr                   (statussethwErr),
    .statussetimpSecDTIM              (statussetimpSecDTIM),
    .statussetimpPriDTIM              (statussetimpPriDTIM),
    .statussettbTxDMADead             (statussettbTxDMADead),
    .statussetbcnTxDMADead            (statussetbcnTxDMADead),
    .statussetac3TxDMADead            (statussetac3TxDMADead),
    .statussetac2TxDMADead            (statussetac2TxDMADead),
    .statussetac1TxDMADead            (statussetac1TxDMADead),
    .statussetac0TxDMADead            (statussetac0TxDMADead),
    .statussetptError                 (statussetptError),
    .statussettimSet                  (statussettimSet),
    .statussetolbcDSSS                (statussetolbcDSSS),
    .statussetolbcOFDM                (statussetolbcOFDM),
    .statussetrxFIFOOverFlow          (statussetrxFIFOOverFlow),
    .statussetmacPHYIFOverflow        (statussetmacPHYIFOverflow),
    .statussetabsTimers0              (statussetabsTimers[0]),
    .statussetabsTimers1              (statussetabsTimers[1]),
    .statussetabsTimers2              (statussetabsTimers[2]),
    .statussetabsTimers3              (statussetabsTimers[3]),
    .statussetabsTimers4              (statussetabsTimers[4]),
    .statussetabsTimers5              (statussetabsTimers[5]),
    .statussetabsTimers6              (statussetabsTimers[6]),
    .statussetabsTimers7              (statussetabsTimers[7]),
    .statussetabsTimers8              (statussetabsTimers[8]),
    .statussetabsTimers9              (statussetabsTimers[9]),
    .statusabsGenTimers               (statusabsGenTimers),
    .statussetidleInterrupt           (statussetidleInterrupt),
    .statussetimpSecTBTT              (statussetimpSecTBTT),
    .statussetimpPriTBTT              (statussetimpPriTBTT),
    .statussetrxBuffer2Trigger             (statussetrxBuffer2Trigger),
    .statussettimerRxTrigger          (statussettimerRxTrigger),
    .statussetrxBuffer1Trigger               (statussetrxBuffer1Trigger),
    .statussetsecUserTxTrigger        (1'b0),
    .statussettbTxBufTrigger          (statussettbTxBufTrigger),
    .statussetbcnTxBufTrigger         (statussetbcnTxBufTrigger),
    .statussetac3TxBufTrigger         (statussetac3TxBufTrigger),
    .statussetac2TxBufTrigger         (statussetac2TxBufTrigger),
    .statussetac1TxBufTrigger         (statussetac1TxBufTrigger),
    .statussetac0TxBufTrigger         (statussetac0TxBufTrigger),
    .statussettimerTxTrigger          (statussettimerTxTrigger),
    .statussettxopComplete            (statussettxopComplete),
    .statussettbTxCancelled           (statussettbTxCancelled),
    .statussettbTxTrigger             (statussettbTxTrigger),
    .statussetbcnTxTrigger            (statussetbcnTxTrigger),
    .statussetac3TxTrigger            (statussetac3TxTrigger),
    .statussetac2TxTrigger            (statussetac2TxTrigger),
    .statussetac1TxTrigger            (statussetac1TxTrigger),
    .statussetac0TxTrigger            (statussetac0TxTrigger),
    .statussettbProtTrigger           (statussettbProtTrigger),
    .statussetac3ProtTrigger          (statussetac3ProtTrigger),
    .statussetac2ProtTrigger          (statussetac2ProtTrigger),
    .statussetac1ProtTrigger          (statussetac1ProtTrigger),
    .statussetac0ProtTrigger          (statussetac0ProtTrigger),
    .statussetac3BWDropTrigger        (statussetac3BWDropTrigger),
    .statussetac2BWDropTrigger        (statussetac2BWDropTrigger),
    .statussetac1BWDropTrigger        (statussetac1BWDropTrigger),
    .statussetac0BWDropTrigger        (statussetac0BWDropTrigger),
    .nextTBTT                         (nextTBTT),
    .tsfTimerLowIn                    (tsfTimerLowIn),
    .tsfTimerLowInValid               (tsfTimerLowInValid),
    .tsfTimerHighIn                   (tsfTimerHighIn),
    .tsfTimerHighInValid              (tsfTimerHighInValid),
    .computeDurationIn                (computeDurationIn),
    .computeDurationInValid           (computeDurationInValid),
    .timeOnAirValid                   (timeOnAirValid),
    .timeOnAir                        (timeOnAir),
    .statussethaltTBAfterTXOP         (statussethaltTBAfterTXOP),
    .statussethaltBcnAfterTXOP        (statussethaltBcnAfterTXOP),
    .statussethaltAC3AfterTXOP        (statussethaltAC3AfterTXOP),
    .statussethaltAC2AfterTXOP        (statussethaltAC2AfterTXOP),
    .statussethaltAC1AfterTXOP        (statussethaltAC1AfterTXOP),
    .statussethaltAC0AfterTXOP        (statussethaltAC0AfterTXOP),
    .statussettxAC3NewHead            (statussettxAC3NewHead),
    .statussettxAC2NewHead            (statussettxAC2NewHead),
    .statussettxAC1NewHead            (statussettxAC1NewHead),
    .statussettxAC0NewHead            (statussettxAC0NewHead),
    .statussettxBcnNewHead            (statussettxBcnNewHead),
    .statussettxTBNewHead             (statussettxTBNewHead),
    .statussettxAC3NewTail            (statussettxAC3NewTail),
    .statussettxAC2NewTail            (statussettxAC2NewTail),
    .statussettxAC1NewTail            (statussettxAC1NewTail),
    .statussettxAC0NewTail            (statussettxAC0NewTail),
    .statussettxBcnNewTail            (statussettxBcnNewTail),
    .txAC3State                       (txAC3State),
    .txAC2State                       (txAC2State),
    .txAC1State                       (txAC1State),
    .txAC0State                       (txAC0State),
    .txBcnState                       (txBcnState),
    .txTBState                        (txTBState),
    .txNewHeadErr                     (txNewHeadErr),
    .txBusErr                         (txBusErr),
    .txPTAddressErr                   (txPTAddressErr),
    .txNextPointerErr                 (txNextPointerErr),
    .txUPatternErr                    (txUPatternErr),
    .txLenMismatch                    (txLenMismatch),
    .rxPayBusErr                      (rxPayBusErr),
    .rxHdrBusErr                      (rxHdrBusErr),
    .txAC3EndQ                        (txAC3EndQ),
    .txAC2EndQ                        (txAC2EndQ),
    .txAC1EndQ                        (txAC1EndQ),
    .txAC0EndQ                        (txAC0EndQ),
    .txBcnEndQ                        (txBcnEndQ),
    .txAC3Startup                     (txAC3Startup),
    .txAC2Startup                     (txAC2Startup),
    .txAC1Startup                     (txAC1Startup),
    .txAC0Startup                     (txAC0Startup),
    .txBcnStartup                     (txBcnStartup),
    .ac1MOT                           (ac1MOT),
    .ac0MOT                           (ac0MOT),
    .ac3MOT                           (ac3MOT),
    .ac2MOT                           (ac2MOT),
    .txBWAfterDrop                    (txBWAfterDrop),
    .eOCWIn                           (eOCWIn),
    .eOCWInValid                      (eOCWInValid),
    .maxMCSInHETB                     (maxMCSInHETB),
    .eOCW                             (eOCW),
    .eOCWMin                          (eOCWMin),
    .ocwLFSR                          (ocwLFSR),
    .ocwLFSRIn                        (ocwLFSRIn),
    .ocwLFSRInValid                   (ocwLFSRInValid),
    .raRUType                         (raRUType),
    .raRUEnable                       (raRUEnable),
    .txHETBRemDur                     (txHETBRemDur),
    .txHETBMaxDur                     (txHETBMaxDur),
    .ulDoppler                        (ulDoppler),
    .ulPEDisambiguity                 (ulPEDisambiguity),
    .ulPreFecPadding                  (ulPreFecPadding),
    .ulLDPCExtrSymb                   (ulLDPCExtrSymb),
    .ulSTBC                           (ulSTBC),
    .ulNLTFAndMidamble                (ulNLTFAndMidamble),
    .ulMULTFMode                      (ulMULTFMode),
    .ulGILTFType                      (ulGILTFType),
    .ulBW                             (ulBW),
    .ulLength                         (ulLength),
    .ulTriggerType                    (ulTriggerType),
    .tdUserInfoSubfield               (tdUserInfoSubfield),
    .ulNSS                            (ulNSS),
    .ulRUType                         (ulRUType),
    .ulDCM                            (ulDCM),
    .ulMCS                            (ulMCS),
    .ulFECCoding                      (ulFECCoding),
    .ulRUSize                         (ulRUSize),
    .ulPSDULenValid                   (ulPSDULenValidPI),
    .ulPSDULen                        (ulPSDULen),
    .ulTargetRSSI                     (ulTargetRSSI),
    .apTXPower                        (apTXPower),
    .heTBUPHControl                   (heTBUPHControl),
    .tbStatusPointer                  (tbStatusPointer),
    .bcnStatusPointer                 (bcnStatusPointer),
    .ac0StatusPointer                 (ac0StatusPointer),
    .ac1StatusPointer                 (ac1StatusPointer),
    .ac2StatusPointer                 (ac2StatusPointer),
    .ac3StatusPointer                 (ac3StatusPointer),
    .txCurrentPointer                 (txCurrentPointer),
    .rxHeaderTFPtr                    (rxHeaderTFPtr),
    .rxBuf1WrPtrIn                    (rxBuf1WrPtrIn),
    .rxBuf1WrPtrInValid               (rxBuf1WrPtrInValid),
    .rxBuf2WrPtrIn                    (rxBuf2WrPtrIn),
    .rxBuf2WrPtrInValid               (rxBuf2WrPtrInValid),
    .signature                        (signature),
    .muMIMOTx                         (muMIMOTx),
    .bfmer                            (bfmer),
    .bfmee                            (bfmee),
    .he                               (he),
    .coex                             (coex),
    .wapi                             (wapi),
    .tpc                              (tpc),
    .vht                              (vht),
    .ht                               (ht),
    .gcmp                             (gcmp),
    .rce                              (rce),
    .ccmp                             (ccmp),
    .tkip                             (tkip),
    .wep                              (wep),
    .security                         (security),
    .sme                              (sme),
    .edca                             (edca),
    .qos                              (qos),
    .phaseNumber                      (phaseNumber),
    .releaseNumber                    (releaseNumber),
    .ieRelease                        (ieRelease),
    .umVersion                        (umVersion),
    .bitmapCnt                        (bitmapCnt),
    .tsfUpdatedBySWIn                 (tsfUpdatedBySWIn),
    .tsfUpdatedBySWInValid            (tsfUpdatedBySWInValid),
    .keyStoRAMResetIn                 (keyStoRAMResetIn),
    .keyStoRAMResetInValid            (keyStoRAMResetInValid),
    .mibTableResetIn                  (mibTableResetIn),
    .mibTableResetInValid             (mibTableResetInValid),
    .baPSBitmapResetIn                (baPSBitmapResetIn),
    .baPSBitmapResetInValid           (baPSBitmapResetInValid),
    .macPHYIFFIFOResetIn              (macPHYIFFIFOResetIn),
    .macPHYIFFIFOResetInValid         (macPHYIFFIFOResetInValid),
    .txFIFOResetIn                    (txFIFOResetIn),
    .txFIFOResetInValid               (txFIFOResetInValid),
    .rxFIFOResetIn                    (rxFIFOResetIn),
    .rxFIFOResetInValid               (rxFIFOResetInValid),
    .hwFSMResetIn                     (hwFSMResetIn),
    .hwFSMResetInValid                (hwFSMResetInValid),
    .useErrRec                        (useErrRec),
    .statuserrInHWLevel3              (statuserrInHWLevel3),
    .statuserrInTxRxLevel2            (statuserrInTxRxLevel2),
    .statuserrInRxLevel1              (statuserrInRxLevel1),
    .statuserrInTxLevel1              (statuserrInTxLevel1),
    .enDuplicateDetection             (enDuplicateDetection),
    .dtimUpdatedBySWIn                (dtimUpdatedBySWIn),
    .dtimUpdatedBySWInValid           (dtimUpdatedBySWInValid),
    .dtimPeriodIn                     (dtimPeriodIn),
    .dtimPeriodInValid                (dtimPeriodInValid),
    .encrKeyRAMWord0In                (encrKeyRAMWord0In),
    .encrKeyRAMWord0InValid           (encrKeyRAMWord0InValid),
    .encrKeyRAMWord1In                (encrKeyRAMWord1In),
    .encrKeyRAMWord1InValid           (encrKeyRAMWord1InValid),
    .encrKeyRAMWord2In                (encrKeyRAMWord2In),
    .encrKeyRAMWord2InValid           (encrKeyRAMWord2InValid),
    .encrKeyRAMWord3In                (encrKeyRAMWord3In),
    .encrKeyRAMWord3InValid           (encrKeyRAMWord3InValid),
`ifdef  RW_KEY_EXTENDED
    .encrIntKeyRAMWord0In             (encrIntKeyRAMWord0In),
    .encrIntKeyRAMWord0InValid        (encrIntKeyRAMWord0InValid),
    .encrIntKeyRAMWord1In             (encrIntKeyRAMWord1In),
    .encrIntKeyRAMWord1InValid        (encrIntKeyRAMWord1InValid),
    .encrIntKeyRAMWord2In             (encrIntKeyRAMWord2In),
    .encrIntKeyRAMWord2InValid        (encrIntKeyRAMWord2InValid),
    .encrIntKeyRAMWord3In             (encrIntKeyRAMWord3In),
    .encrIntKeyRAMWord3InValid        (encrIntKeyRAMWord3InValid),
`endif//RW_KEY_EXTENDED
    .macAddrRAMLowIn                  (macAddrRAMLowIn),
    .macAddrRAMLowInValid             (macAddrRAMLowInValid),
    .macAddrRAMHighIn                 (macAddrRAMHighIn),
    .macAddrRAMHighInValid            (macAddrRAMHighInValid),
    .newReadIn                        (newReadIn),
    .newReadInValid                   (newReadInValid),
    .newWriteIn                       (newWriteIn),
    .newWriteInValid                  (newWriteInValid),
    .newSearchIn                      (newSearchIn),
    .newSearchInValid                 (newSearchInValid),
    .searchErrorIn                    (searchErrorIn),
    .searchErrorInValid               (searchErrorInValid),
    .keyIndexRAMIn                    (keyIndexRAMIn),
    .keyIndexRAMInValid               (keyIndexRAMInValid),
    .cTypeRAMIn                       (cTypeRAMIn),
    .cTypeRAMInValid                  (cTypeRAMInValid),
    .vlanIDRAMIn                      (vlanIDRAMIn),
    .vlanIDRAMInValid                 (vlanIDRAMInValid),
    .sppRAMIn                         (sppRAMIn),
    .sppRAMInValid                    (sppRAMInValid),
    .useDefKeyRAMIn                   (useDefKeyRAMIn),
    .useDefKeyRAMInValid              (useDefKeyRAMInValid),
    .cLenRAMIn                        (cLenRAMIn),
    .cLenRAMInValid                   (cLenRAMInValid),
    .staKeyStartIndex                 (staKeyStartIndex),
    .staKeyEndIndex                   (staKeyEndIndex),
    .nVAP                             (nVAP),
    .staKeyMaxIndex                   (staKeyMaxIndex),
    .mibWriteIn                       (mibWriteIn),
    .mibWriteInValid                  (mibWriteInValid),
    .monotonicCounter1                (monotonicCounter1),
    .monotonicCounterLow2             (monotonicCounterLow2),
    .monotonicCounterHigh2            (monotonicCounterHigh2),
    .monotonicCounter2SWUpdate        (monotonicCounter2SWUpdate),
    .monotonicCounterLow2In           (monotonicCounterLow2In),
    .monotonicCounterHigh2In          (monotonicCounterHigh2In),
    .monotonicCounterLow2InValid      (monotonicCounterLow2InValid),
    .monotonicCounterHigh2InValid     (monotonicCounterHigh2InValid),
    .ccaBusyDurIn                     (ccaBusyDurIn),
    .ccaBusyDurInValid                (ccaBusyDurInValid),
    .ccaBusyDurSec20In                (ccaBusyDurSec20In),
    .ccaBusyDurSec20InValid           (ccaBusyDurSec20InValid),
    .ccaBusyDurSec40In                (ccaBusyDurSec40In),
    .ccaBusyDurSec40InValid           (ccaBusyDurSec40InValid),
    .ccaBusyDurSec80In                (ccaBusyDurSec80In),
    .ccaBusyDurSec80InValid           (ccaBusyDurSec80InValid),
    .sendCFEndNowIn                   (sendCFEndNowIn),
    .sendCFEndNowInValid              (sendCFEndNowInValid),
    .quietDuration1In                 (quietDuration1In),
    .quietDuration1InValid            (quietDuration1InValid),
    .quietPeriod1In                   (quietPeriod1In),
    .quietPeriod1InValid              (quietPeriod1InValid),
    .quietCount1In                    (quietCount1In),
    .quietCount1InValid               (quietCount1InValid),
    .quietOffset1In                   (quietOffset1In),
    .quietOffset1InValid              (quietOffset1InValid),
`ifdef RW_WLAN_COEX_EN                
    .coexWlanPTIState                 (coexWlanPTIState),
    .coexWlanPTIToggleState           (coexWlanPTIToggleState),
    .coexWlanChanBwState              (coexWlanChanBwState),
    .coexWlanRxState                  (coexWlanRxState),
    .coexWlanTxState                  (coexWlanTxState),
    .coexWlanRxAbortState             (coexWlanRxAbortState),
    .coexWlanTxAbortState             (coexWlanTxAbortState),
`endif // RW_WLAN_COEX_EN                
    .macControlLs                     (macControlLs),
    .txControlLs                      (txControlLs),
    .rxControlLs                      (rxControlLs),
    .macControlCs                     (macControlCs),
    .txControlCs                      (txControlCs),
    .rxControlCs                      (rxControlCs),
    .debugPortRead                    (debugPortReadResync),
    .basicNAVCounterIn                (basicNAVCounterIn),                       
    .basicNAVCounterInValid           (basicNAVCounterInValid),                  
    .intraNAVCounterIn                (intraNAVCounterIn),                       
    .intraNAVCounterInValid           (intraNAVCounterInValid),                  
    .activeAC                         (activeAC),
    .currentCW3                       (currentCW3),
    .currentCW2                       (currentCW2),
    .currentCW1                       (currentCW1),
    .currentCW0                       (currentCW0),
    .ac3QSRC                          (ac3QSRC),
    .ac2QSRC                          (ac2QSRC),
    .ac1QSRC                          (ac1QSRC),
    .ac0QSRC                          (ac0QSRC),
    .ac3QLRC                          (ac3QLRC),
    .ac2QLRC                          (ac2QLRC),
    .ac1QLRC                          (ac1QLRC),
    .ac0QLRC                          (ac0QLRC),
    .bssColor                         (bssColorCSReg),
    .bssColorEn                       (bssColorEnCSReg),
    .partialBSSColorEn                (partialBSSColorEnCSReg),
    .nextState                        (nextState),
    .softReset                        (softReset),
    .setrxPayloadDMADead              (setrxPayloadDMADead),
    .setrxHeaderDMADead               (setrxHeaderDMADead),
    .setphyRxStart                    (setphyRxStart),
    .setphyErr                        (setphyErr),
    .setmacPHYIFUnderRun              (setmacPHYIFUnderRun),
    .sethwErr                         (sethwErr),
    .setimpSecDTIM                    (setimpSecDTIM),
    .setimpPriDTIM                    (setimpPriDTIM),
    .settbTxDMADead                   (settbTxDMADead),
    .setbcnTxDMADead                  (setbcnTxDMADead),
    .setac3TxDMADead                  (setac3TxDMADead),
    .setac2TxDMADead                  (setac2TxDMADead),
    .setac1TxDMADead                  (setac1TxDMADead),
    .setac0TxDMADead                  (setac0TxDMADead),
    .setptError                       (setptError),
    .settimSet                        (settimSet),
    .setolbcDSSS                      (setolbcDSSS),
    .setolbcOFDM                      (setolbcOFDM),
    .setrxFIFOOverFlow                (setrxFIFOOverFlow),
    .setmacPHYIFOverflow              (setmacPHYIFOverflow),
    .setabsTimers0                    (setabsTimers[0]),
    .setabsTimers1                    (setabsTimers[1]),
    .setabsTimers2                    (setabsTimers[2]),
    .setabsTimers3                    (setabsTimers[3]),
    .setabsTimers4                    (setabsTimers[4]),
    .setabsTimers5                    (setabsTimers[5]),
    .setabsTimers6                    (setabsTimers[6]),
    .setabsTimers7                    (setabsTimers[7]),
    .setabsTimers8                    (setabsTimers[8]),
    .setabsTimers9                    (setabsTimers[9]),
    .absGenTimers                     (absGenTimers),
    .setidleInterrupt                 (setidleInterrupt),
    .setimpSecTBTT                    (setimpSecTBTT),
    .setimpPriTBTT                    (setimpPriTBTT),
    .clearrxPayloadDMADead            (clearrxPayloadDMADead),
    .clearrxHeaderDMADead             (clearrxHeaderDMADead),
    .clearphyRxStart                  (clearphyRxStart),
    .clearphyErr                      (clearphyErr),
    .clearmacPHYIFUnderRun            (clearmacPHYIFUnderRun),
    .clearhwErr                       (clearhwErr),
    .clearimpSecDTIM                  (clearimpSecDTIM),
    .clearimpPriDTIM                  (clearimpPriDTIM),
    .cleartbTxDMADead                 (cleartbTxDMADead),
    .clearbcnTxDMADead                (clearbcnTxDMADead),
    .clearac3TxDMADead                (clearac3TxDMADead),
    .clearac2TxDMADead                (clearac2TxDMADead),
    .clearac1TxDMADead                (clearac1TxDMADead),
    .clearac0TxDMADead                (clearac0TxDMADead),
    .clearptError                     (clearptError),
    .cleartimSet                      (cleartimSet),
    .clearolbcDSSS                    (clearolbcDSSS),
    .clearolbcOFDM                    (clearolbcOFDM),
    .clearrxFIFOOverFlow              (clearrxFIFOOverFlow),
    .clearmacPHYIFOverflow            (clearmacPHYIFOverflow),
    .clearabsTimers0                  (clearabsTimers[0]),
    .clearabsTimers1                  (clearabsTimers[1]),
    .clearabsTimers2                  (clearabsTimers[2]),
    .clearabsTimers3                  (clearabsTimers[3]),
    .clearabsTimers4                  (clearabsTimers[4]),
    .clearabsTimers5                  (clearabsTimers[5]),
    .clearabsTimers6                  (clearabsTimers[6]),
    .clearabsTimers7                  (clearabsTimers[7]),
    .clearabsTimers8                  (clearabsTimers[8]),
    .clearabsTimers9                  (clearabsTimers[9]),
    .clearidleInterrupt               (clearidleInterrupt),
    .clearimpSecTBTT                  (clearimpSecTBTT),
    .clearimpPriTBTT                  (clearimpPriTBTT),
    .masterGenIntEn                   (masterGenIntEn),
    .maskrxPayloadDMADead             (maskrxPayloadDMADead),
    .maskrxHeaderDMADead              (maskrxHeaderDMADead),
    .maskphyRxStart                   (maskphyRxStart),
    .maskphyErr                       (maskphyErr),
    .maskmacPHYIFUnderRun             (maskmacPHYIFUnderRun),
    .maskhwErr                        (maskhwErr),
    .maskimpSecDTIM                   (maskimpSecDTIM),
    .maskimpPriDTIM                   (maskimpPriDTIM),
    .masktbTxDMADead                  (masktbTxDMADead),
    .maskbcnTxDMADead                 (maskbcnTxDMADead),
    .maskac3TxDMADead                 (maskac3TxDMADead),
    .maskac2TxDMADead                 (maskac2TxDMADead),
    .maskac1TxDMADead                 (maskac1TxDMADead),
    .maskac0TxDMADead                 (maskac0TxDMADead),
    .maskptError                      (maskptError),
    .masktimSet                       (masktimSet),
    .maskolbcDSSS                     (maskolbcDSSS),
    .maskolbcOFDM                     (maskolbcOFDM),
    .maskrxFIFOOverFlow               (maskrxFIFOOverFlow),
    .maskmacPHYIFOverflow             (maskmacPHYIFOverflow),
    .maskabsTimers0                   (maskabsTimers[0]),
    .maskabsTimers1                   (maskabsTimers[1]),
    .maskabsTimers2                   (maskabsTimers[2]),
    .maskabsTimers3                   (maskabsTimers[3]),
    .maskabsTimers4                   (maskabsTimers[4]),
    .maskabsTimers5                   (maskabsTimers[5]),
    .maskabsTimers6                   (maskabsTimers[6]),
    .maskabsTimers7                   (maskabsTimers[7]),
    .maskabsTimers8                   (maskabsTimers[8]),
    .maskabsTimers9                   (maskabsTimers[9]),
    .maskabsGenTimers                 (maskabsGenTimers),
    .maskidleInterrupt                (maskidleInterrupt),
    .maskimpSecTBTT                   (maskimpSecTBTT),
    .maskimpPriTBTT                   (maskimpPriTBTT),
    .setrxBuffer2Trigger              (setrxBuffer2Trigger),
    .settimerRxTrigger                (settimerRxTrigger),
    .setrxBuffer1Trigger              (setrxBuffer1Trigger),
    .setsecUserTxTrigger              (/*Open*/),
    .settbTxBufTrigger                (settbTxBufTrigger),
    .setbcnTxBufTrigger               (setbcnTxBufTrigger),
    .setac3TxBufTrigger               (setac3TxBufTrigger),
    .setac2TxBufTrigger               (setac2TxBufTrigger),
    .setac1TxBufTrigger               (setac1TxBufTrigger),
    .setac0TxBufTrigger               (setac0TxBufTrigger),
    .settimerTxTrigger                (settimerTxTrigger),
    .settxopComplete                  (settxopComplete),
    .settbTxCancelled                 (settbTxCancelled),
    .settbTxTrigger                   (settbTxTrigger),
    .setbcnTxTrigger                  (setbcnTxTrigger),
    .setac3TxTrigger                  (setac3TxTrigger),
    .setac2TxTrigger                  (setac2TxTrigger),
    .setac1TxTrigger                  (setac1TxTrigger),
    .setac0TxTrigger                  (setac0TxTrigger),
    .setac3BWDropTrigger              (setac3BWDropTrigger),
    .setac2BWDropTrigger              (setac2BWDropTrigger),
    .setac1BWDropTrigger              (setac1BWDropTrigger),
    .setac0BWDropTrigger              (setac0BWDropTrigger),
    .settbProtTrigger                 (settbProtTrigger),
    .setac3ProtTrigger                (setac3ProtTrigger),
    .setac2ProtTrigger                (setac2ProtTrigger),
    .setac1ProtTrigger                (setac1ProtTrigger),
    .setac0ProtTrigger                (setac0ProtTrigger),
    .clearrxBuffer2Trigger            (clearrxBuffer2Trigger),
    .cleartimerRxTrigger              (cleartimerRxTrigger),
    .clearrxBuffer1Trigger            (clearrxBuffer1Trigger),
    .cleartbTxBufTrigger              (cleartbTxBufTrigger),
    .clearbcnTxBufTrigger             (clearbcnTxBufTrigger),
    .clearac3TxBufTrigger             (clearac3TxBufTrigger),
    .clearac2TxBufTrigger             (clearac2TxBufTrigger),
    .clearac1TxBufTrigger             (clearac1TxBufTrigger),
    .clearac0TxBufTrigger             (clearac0TxBufTrigger),
    .cleartimerTxTrigger              (cleartimerTxTrigger),
    .cleartxopComplete                (cleartxopComplete),
    .cleartbTxCancelled               (cleartbTxCancelled),
    .cleartbTxTrigger                 (cleartbTxTrigger),
    .clearbcnTxTrigger                (clearbcnTxTrigger),
    .clearac3TxTrigger                (clearac3TxTrigger),
    .clearac2TxTrigger                (clearac2TxTrigger),
    .clearac1TxTrigger                (clearac1TxTrigger),
    .clearac0TxTrigger                (clearac0TxTrigger),
    .clearac3BWDropTrigger            (clearac3BWDropTrigger),
    .clearac2BWDropTrigger            (clearac2BWDropTrigger),
    .clearac1BWDropTrigger            (clearac1BWDropTrigger),
    .clearac0BWDropTrigger            (clearac0BWDropTrigger),
    .cleartbProtTrigger               (cleartbProtTrigger),
    .clearac3ProtTrigger              (clearac3ProtTrigger),
    .clearac2ProtTrigger              (clearac2ProtTrigger),
    .clearac1ProtTrigger              (clearac1ProtTrigger),
    .clearac0ProtTrigger              (clearac0ProtTrigger),
    .masterTxRxIntEn                  (masterTxRxIntEn),
    .maskrxBuffer2Trigger             (maskrxBuffer2Trigger),
    .masktimerRxTrigger               (masktimerRxTrigger),
    .maskrxBuffer1Trigger             (maskrxBuffer1Trigger),
    .masksecUserTxTrigger             (masksecUserTxTrigger),
    .masktbTxBufTrigger               (masktbTxBufTrigger),
    .maskbcnTxBufTrigger              (maskbcnTxBufTrigger),
    .maskac3TxBufTrigger              (maskac3TxBufTrigger),
    .maskac2TxBufTrigger              (maskac2TxBufTrigger),
    .maskac1TxBufTrigger              (maskac1TxBufTrigger),
    .maskac0TxBufTrigger              (maskac0TxBufTrigger),
    .masktimerTxTrigger               (masktimerTxTrigger),
    .masktxopComplete                 (masktxopComplete),
    .masktbTxCancelled                (masktbTxCancelled),
    .masktbTxTrigger                  (masktbTxTrigger),
    .maskbcnTxTrigger                 (maskbcnTxTrigger),
    .maskac3TxTrigger                 (maskac3TxTrigger),
    .maskac2TxTrigger                 (maskac2TxTrigger),
    .maskac1TxTrigger                 (maskac1TxTrigger),
    .maskac0TxTrigger                 (maskac0TxTrigger),
    .maskac3BWDropTrigger             (maskac3BWDropTrigger),
    .maskac2BWDropTrigger             (maskac2BWDropTrigger),
    .maskac1BWDropTrigger             (maskac1BWDropTrigger),
    .maskac0BWDropTrigger             (maskac0BWDropTrigger),
    .masktbProtTrigger                (masktbProtTrigger),
    .maskac3ProtTrigger               (maskac3ProtTrigger),
    .maskac2ProtTrigger               (maskac2ProtTrigger),
    .maskac1ProtTrigger               (maskac1ProtTrigger),
    .maskac0ProtTrigger               (maskac0ProtTrigger),
    .tsfTimerLow                      (tsfTimerLow),
    .tsfTimerHigh                     (tsfTimerHigh),
    .ppduSTBC                         (ppduSTBC),
    .ppduNumExtnSS                    (ppduNumExtnSS),
    .ppduMCSIndex                     (ppduMCSIndex),
    .ppduGI                           (ppduGIType),
    .ppduPreType                      (ppduPreType),
    .ppduBW                           (ppduBW),
    .ppduLength                       (ppduLength),
    .ppduNUser                        (ppduNUser),
    .ppduPE                           (ppduPE),
    .ppduMCSSigB                      (ppduMCSSigB),
    .ppduDCMSigB                      (ppduDCMSigB),
    .ppduSigBCompMode                 (ppduSigBCompMode),
    .ppduHELTFType                    (ppduHELTFType),
    .ppduNumHeLtf                     (ppduNumHeLtf),
    .ppduDCM                          (ppduDCM),
    .ppduDoppler                      (ppduDoppler), 
    .ppduMma                          (ppduMma),     
    .ppduRuType                       (ppduRuType),  
    .computeDuration                  (computeDuration),
    .sethaltTBAfterTXOP               (sethaltTBAfterTXOP),
    .sethaltBcnAfterTXOP              (sethaltBcnAfterTXOP),
    .sethaltAC3AfterTXOP              (sethaltAC3AfterTXOP),
    .sethaltAC2AfterTXOP              (sethaltAC2AfterTXOP),
    .sethaltAC1AfterTXOP              (sethaltAC1AfterTXOP),
    .sethaltAC0AfterTXOP              (sethaltAC0AfterTXOP),
    .settxAC3NewHead                  (settxAC3NewHead),
    .settxAC2NewHead                  (settxAC2NewHead),
    .settxAC1NewHead                  (settxAC1NewHead),
    .settxAC0NewHead                  (settxAC0NewHead),
    .settxBcnNewHead                  (settxBcnNewHead),
    .settxTBNewHead                   (settxTBNewHead),
    .settxAC3NewTail                  (settxAC3NewTail),
    .settxAC2NewTail                  (settxAC2NewTail),
    .settxAC1NewTail                  (settxAC1NewTail),
    .settxAC0NewTail                  (settxAC0NewTail),
    .settxBcnNewTail                  (settxBcnNewTail),
    .clearhaltTBAfterTXOP             (clearhaltTBAfterTXOP),
    .clearhaltBcnAfterTXOP            (clearhaltBcnAfterTXOP),
    .clearhaltAC3AfterTXOP            (clearhaltAC3AfterTXOP),
    .clearhaltAC2AfterTXOP            (clearhaltAC2AfterTXOP),
    .clearhaltAC1AfterTXOP            (clearhaltAC1AfterTXOP),
    .clearhaltAC0AfterTXOP            (clearhaltAC0AfterTXOP),
    .cleartxAC3NewHead                (cleartxAC3NewHead),
    .cleartxAC2NewHead                (cleartxAC2NewHead),
    .cleartxAC1NewHead                (cleartxAC1NewHead),
    .cleartxAC0NewHead                (cleartxAC0NewHead),
    .cleartxBcnNewHead                (cleartxBcnNewHead),
    .cleartxTBNewHead                 (cleartxTBNewHead),
    .cleartxAC3NewTail                (cleartxAC3NewTail),
    .cleartxAC2NewTail                (cleartxAC2NewTail),
    .cleartxAC1NewTail                (cleartxAC1NewTail),
    .cleartxAC0NewTail                (cleartxAC0NewTail),
    .cleartxBcnNewTail                (cleartxBcnNewTail),
    .txTBHaltAfterTXOP                (txTBHaltAfterTXOP),
    .txBcnHaltAfterTXOP               (txBcnHaltAfterTXOP),
    .txAC3HaltAfterTXOP               (txAC3HaltAfterTXOP),
    .txAC2HaltAfterTXOP               (txAC2HaltAfterTXOP),
    .txAC1HaltAfterTXOP               (txAC1HaltAfterTXOP),
    .txAC0HaltAfterTXOP               (txAC0HaltAfterTXOP),
    .txTBHeadPtr                      (txTBHeadPtr),
    .txBcnHeadPtr                     (txBcnHeadPtr),
    .txAC0HeadPtr                     (txAC0HeadPtr),
    .txAC1HeadPtr                     (txAC1HeadPtr),
    .txAC2HeadPtr                     (txAC2HeadPtr),
    .txAC3HeadPtr                     (txAC3HeadPtr),
    .dmaRBDSize                       (dmaRBDSize),
    .dmaRHDSize                       (dmaRHDSize),
    .dmaTBDSize                       (dmaTBDSize),
    .dmaTHDSize                       (dmaTHDSize),
    .ptEntrySize                      (ptEntrySize),
    .rxFIFOThreshold                  (rxFIFOThreshold),
    .txFIFOThreshold                  (txFIFOThreshold),
    .rxBuf1StartPtr                   (rxBuf1StartPtr),
    .rxBuf1EndPtr                     (rxBuf1EndPtr),
    .rxBuf1RdPtr                      (rxBuf1RdPtr),
    .rxBuf1WrPtr                      (rxBuf1WrPtr),
    .rxBuf2StartPtr                   (rxBuf2StartPtr),
    .rxBuf2EndPtr                     (rxBuf2EndPtr),
    .rxBuf2RdPtr                      (rxBuf2RdPtr),
    .rxBuf2WrPtr                      (rxBuf2WrPtr),
    .rxBufRPDFooter                   (rxBufRPDFooter),
    .rxBufRPDHeader                   (rxBufRPDHeader),
    .rxBufRHDFooter                   (rxBufRHDFooter),
    .rxBufRHDHeader                   (rxBufRHDHeader),
    .rxReqForceDeassertion            (rxReqForceDeassertion),
    .rxEndForTimingErrRec             (rxEndForTimingErrRec),
    .swProf0InValid                   (swProfInValid[0]),
    .swProf1InValid                   (swProfInValid[1]),
    .swProf2InValid                   (swProfInValid[2]),
    .swProf3InValid                   (swProfInValid[3]),
    .swProf4InValid                   (swProfInValid[4]),
    .swProf5InValid                   (swProfInValid[5]),
    .swProf6InValid                   (swProfInValid[6]),
    .swProf7InValid                   (swProfInValid[7]),
    .swProf8InValid                   (swProfInValid[8]),
    .swProf9InValid                   (swProfInValid[9]),
    .swProf10InValid                  (swProfInValid[10]),
    .swProf11InValid                  (swProfInValid[11]),
    .swProf12InValid                  (swProfInValid[12]),
    .swProf13InValid                  (swProfInValid[13]),
    .swProf14InValid                  (swProfInValid[14]),
    .swProf15InValid                  (swProfInValid[15]),
    .swProf16InValid                  (swProfInValid[16]),
    .swProf17InValid                  (swProfInValid[17]),
    .swProf18InValid                  (swProfInValid[18]),
    .swProf19InValid                  (swProfInValid[19]),
    .swProf20InValid                  (swProfInValid[20]),
    .swProf21InValid                  (swProfInValid[21]),
    .swProf22InValid                  (swProfInValid[22]),
    .swProf23InValid                  (swProfInValid[23]),
    .swProf24InValid                  (swProfInValid[24]),
    .swProf25InValid                  (swProfInValid[25]),
    .swProf26InValid                  (swProfInValid[26]),
    .swProf27InValid                  (swProfInValid[27]),
    .swProf28InValid                  (swProfInValid[28]),
    .swProf29InValid                  (swProfInValid[29]),
    .swProf30InValid                  (swProfInValid[30]),
    .swProf31InValid                  (swProfInValid[31]),
    .swProf32InValid                  (swProfInValid[32]),
    .swProf33InValid                  (swProfInValid[33]),
    .swProf34InValid                  (swProfInValid[34]),
    .swProf35InValid                  (swProfInValid[35]),
    .swProf36InValid                  (swProfInValid[36]),
    .swProf37InValid                  (swProfInValid[37]),
    .swProf38InValid                  (swProfInValid[38]),
    .swProf39InValid                  (swProfInValid[39]),
    .swProf40InValid                  (swProfInValid[40]),
    .swProf41InValid                  (swProfInValid[41]),
    .swProf42InValid                  (swProfInValid[42]),
    .swProf43InValid                  (swProfInValid[43]),
    .swProf44InValid                  (swProfInValid[44]),
    .swProf45InValid                  (swProfInValid[45]),
    .swProf46InValid                  (swProfInValid[46]),
    .swProf47InValid                  (swProfInValid[47]),
    .swProf48InValid                  (swProfInValid[48]),
    .swProf49InValid                  (swProfInValid[49]),
    .swProf50InValid                  (swProfInValid[50]),
    .swProf51InValid                  (swProfInValid[51]),
    .swProf52InValid                  (swProfInValid[52]),
    .swProf53InValid                  (swProfInValid[53]),
    .swProf54InValid                  (swProfInValid[54]),
    .swProf55InValid                  (swProfInValid[55]),
    .swProf56InValid                  (swProfInValid[56]),
    .swProf57InValid                  (swProfInValid[57]),
    .swProf58InValid                  (swProfInValid[58]),
    .swProf59InValid                  (swProfInValid[59]),
    .swProf60InValid                  (swProfInValid[60]),
    .swProf61InValid                  (swProfInValid[61]),
    .swProf62InValid                  (swProfInValid[62]),
    .swProf63InValid                  (swProfInValid[63]),
    .swProf0In                        (swProfIn[0]),
    .swProf1In                        (swProfIn[1]),
    .swProf2In                        (swProfIn[2]),
    .swProf3In                        (swProfIn[3]),
    .swProf4In                        (swProfIn[4]),
    .swProf5In                        (swProfIn[5]),
    .swProf6In                        (swProfIn[6]),
    .swProf7In                        (swProfIn[7]),
    .swProf8In                        (swProfIn[8]),
    .swProf9In                        (swProfIn[9]),
    .swProf10In                       (swProfIn[10]),
    .swProf11In                       (swProfIn[11]),
    .swProf12In                       (swProfIn[12]),
    .swProf13In                       (swProfIn[13]),
    .swProf14In                       (swProfIn[14]),
    .swProf15In                       (swProfIn[15]),
    .swProf16In                       (swProfIn[16]),
    .swProf17In                       (swProfIn[17]),
    .swProf18In                       (swProfIn[18]),
    .swProf19In                       (swProfIn[19]),
    .swProf20In                       (swProfIn[20]),
    .swProf21In                       (swProfIn[21]),
    .swProf22In                       (swProfIn[22]),
    .swProf23In                       (swProfIn[23]),
    .swProf24In                       (swProfIn[24]),
    .swProf25In                       (swProfIn[25]),
    .swProf26In                       (swProfIn[26]),
    .swProf27In                       (swProfIn[27]),
    .swProf28In                       (swProfIn[28]),
    .swProf29In                       (swProfIn[29]),
    .swProf30In                       (swProfIn[30]),
    .swProf31In                       (swProfIn[31]),
    .swProf32In                       (swProfIn[32]),
    .swProf33In                       (swProfIn[33]),
    .swProf34In                       (swProfIn[34]),
    .swProf35In                       (swProfIn[35]),
    .swProf36In                       (swProfIn[36]),
    .swProf37In                       (swProfIn[37]),
    .swProf38In                       (swProfIn[38]),
    .swProf39In                       (swProfIn[39]),
    .swProf40In                       (swProfIn[40]),
    .swProf41In                       (swProfIn[41]),
    .swProf42In                       (swProfIn[42]),
    .swProf43In                       (swProfIn[43]),
    .swProf44In                       (swProfIn[44]),
    .swProf45In                       (swProfIn[45]),
    .swProf46In                       (swProfIn[46]),
    .swProf47In                       (swProfIn[47]),
    .swProf48In                       (swProfIn[48]),
    .swProf49In                       (swProfIn[49]),
    .swProf50In                       (swProfIn[50]),
    .swProf51In                       (swProfIn[51]),
    .swProf52In                       (swProfIn[52]),
    .swProf53In                       (swProfIn[53]),
    .swProf54In                       (swProfIn[54]),
    .swProf55In                       (swProfIn[55]),
    .swProf56In                       (swProfIn[56]),
    .swProf57In                       (swProfIn[57]),
    .swProf58In                       (swProfIn[58]),
    .swProf59In                       (swProfIn[59]),
    .swProf60In                       (swProfIn[60]),
    .swProf61In                       (swProfIn[61]),
    .swProf62In                       (swProfIn[62]),
    .swProf63In                       (swProfIn[63]),
    .swSetProf0                       (swSetProf[0]),
    .swSetProf1                       (swSetProf[1]),
    .swSetProf2                       (swSetProf[2]),
    .swSetProf3                       (swSetProf[3]),
    .swSetProf4                       (swSetProf[4]),
    .swSetProf5                       (swSetProf[5]),
    .swSetProf6                       (swSetProf[6]),
    .swSetProf7                       (swSetProf[7]),
    .swSetProf8                       (swSetProf[8]),
    .swSetProf9                       (swSetProf[9]),
    .swSetProf10                      (swSetProf[10]),
    .swSetProf11                      (swSetProf[11]),
    .swSetProf12                      (swSetProf[12]),
    .swSetProf13                      (swSetProf[13]),
    .swSetProf14                      (swSetProf[14]),
    .swSetProf15                      (swSetProf[15]),
    .swSetProf16                      (swSetProf[16]),
    .swSetProf17                      (swSetProf[17]),
    .swSetProf18                      (swSetProf[18]),
    .swSetProf19                      (swSetProf[19]),
    .swSetProf20                      (swSetProf[20]),
    .swSetProf21                      (swSetProf[21]),
    .swSetProf22                      (swSetProf[22]),
    .swSetProf23                      (swSetProf[23]),
    .swSetProf24                      (swSetProf[24]),
    .swSetProf25                      (swSetProf[25]),
    .swSetProf26                      (swSetProf[26]),
    .swSetProf27                      (swSetProf[27]),
    .swSetProf28                      (swSetProf[28]),
    .swSetProf29                      (swSetProf[29]),
    .swSetProf30                      (swSetProf[30]),
    .swSetProf31                      (swSetProf[31]),
    .swSetProf32                      (swSetProf[32]),
    .swSetProf33                      (swSetProf[33]),
    .swSetProf34                      (swSetProf[34]),
    .swSetProf35                      (swSetProf[35]),
    .swSetProf36                      (swSetProf[36]),
    .swSetProf37                      (swSetProf[37]),
    .swSetProf38                      (swSetProf[38]),
    .swSetProf39                      (swSetProf[39]),
    .swSetProf40                      (swSetProf[40]),
    .swSetProf41                      (swSetProf[41]),
    .swSetProf42                      (swSetProf[42]),
    .swSetProf43                      (swSetProf[43]),
    .swSetProf44                      (swSetProf[44]),
    .swSetProf45                      (swSetProf[45]),
    .swSetProf46                      (swSetProf[46]),
    .swSetProf47                      (swSetProf[47]),
    .swSetProf48                      (swSetProf[48]),
    .swSetProf49                      (swSetProf[49]),
    .swSetProf50                      (swSetProf[50]),
    .swSetProf51                      (swSetProf[51]),
    .swSetProf52                      (swSetProf[52]),
    .swSetProf53                      (swSetProf[53]),
    .swSetProf54                      (swSetProf[54]),
    .swSetProf55                      (swSetProf[55]),
    .swSetProf56                      (swSetProf[56]),
    .swSetProf57                      (swSetProf[57]),
    .swSetProf58                      (swSetProf[58]),
    .swSetProf59                      (swSetProf[59]),
    .swSetProf60                      (swSetProf[60]),
    .swSetProf61                      (swSetProf[61]),
    .swSetProf62                      (swSetProf[62]),
    .swSetProf63                      (swSetProf[63]),
    .swClearProf0                     (swClearProf[0]),
    .swClearProf1                     (swClearProf[1]),
    .swClearProf2                     (swClearProf[2]),
    .swClearProf3                     (swClearProf[3]),
    .swClearProf4                     (swClearProf[4]),
    .swClearProf5                     (swClearProf[5]),
    .swClearProf6                     (swClearProf[6]),
    .swClearProf7                     (swClearProf[7]),
    .swClearProf8                     (swClearProf[8]),
    .swClearProf9                     (swClearProf[9]),
    .swClearProf10                    (swClearProf[10]),
    .swClearProf11                    (swClearProf[11]),
    .swClearProf12                    (swClearProf[12]),
    .swClearProf13                    (swClearProf[13]),
    .swClearProf14                    (swClearProf[14]),
    .swClearProf15                    (swClearProf[15]),
    .swClearProf16                    (swClearProf[16]),
    .swClearProf17                    (swClearProf[17]),
    .swClearProf18                    (swClearProf[18]),
    .swClearProf19                    (swClearProf[19]),
    .swClearProf20                    (swClearProf[20]),
    .swClearProf21                    (swClearProf[21]),
    .swClearProf22                    (swClearProf[22]),
    .swClearProf23                    (swClearProf[23]),
    .swClearProf24                    (swClearProf[24]),
    .swClearProf25                    (swClearProf[25]),
    .swClearProf26                    (swClearProf[26]),
    .swClearProf27                    (swClearProf[27]),
    .swClearProf28                    (swClearProf[28]),
    .swClearProf29                    (swClearProf[29]),
    .swClearProf30                    (swClearProf[30]),
    .swClearProf31                    (swClearProf[31]),
    .swClearProf32                    (swClearProf[32]),
    .swClearProf33                    (swClearProf[33]),
    .swClearProf34                    (swClearProf[34]),
    .swClearProf35                    (swClearProf[35]),
    .swClearProf36                    (swClearProf[36]),
    .swClearProf37                    (swClearProf[37]),
    .swClearProf38                    (swClearProf[38]),
    .swClearProf39                    (swClearProf[39]),
    .swClearProf40                    (swClearProf[40]),
    .swClearProf41                    (swClearProf[41]),
    .swClearProf42                    (swClearProf[42]),
    .swClearProf43                    (swClearProf[43]),
    .swClearProf44                    (swClearProf[44]),
    .swClearProf45                    (swClearProf[45]),
    .swClearProf46                    (swClearProf[46]),
    .swClearProf47                    (swClearProf[47]),
    .swClearProf48                    (swClearProf[48]),
    .swClearProf49                    (swClearProf[49]),
    .swClearProf50                    (swClearProf[50]),
    .swClearProf51                    (swClearProf[51]),
    .swClearProf52                    (swClearProf[52]),
    .swClearProf53                    (swClearProf[53]),
    .swClearProf54                    (swClearProf[54]),
    .swClearProf55                    (swClearProf[55]),
    .swClearProf56                    (swClearProf[56]),
    .swClearProf57                    (swClearProf[57]),
    .swClearProf58                    (swClearProf[58]),
    .swClearProf59                    (swClearProf[59]),
    .swClearProf60                    (swClearProf[60]),
    .swClearProf61                    (swClearProf[61]),
    .swClearProf62                    (swClearProf[62]),
    .swClearProf63                    (swClearProf[63]),
    .statusswSetProf0                 (statusswSetProf[0]),
    .statusswSetProf1                 (statusswSetProf[1]),
    .statusswSetProf2                 (statusswSetProf[2]),
    .statusswSetProf3                 (statusswSetProf[3]),
    .statusswSetProf4                 (statusswSetProf[4]),
    .statusswSetProf5                 (statusswSetProf[5]),
    .statusswSetProf6                 (statusswSetProf[6]),
    .statusswSetProf7                 (statusswSetProf[7]),
    .statusswSetProf8                 (statusswSetProf[8]),
    .statusswSetProf9                 (statusswSetProf[9]),
    .statusswSetProf10                (statusswSetProf[10]),
    .statusswSetProf11                (statusswSetProf[11]),
    .statusswSetProf12                (statusswSetProf[12]),
    .statusswSetProf13                (statusswSetProf[13]),
    .statusswSetProf14                (statusswSetProf[14]),
    .statusswSetProf15                (statusswSetProf[15]),
    .statusswSetProf16                (statusswSetProf[16]),
    .statusswSetProf17                (statusswSetProf[17]),
    .statusswSetProf18                (statusswSetProf[18]),
    .statusswSetProf19                (statusswSetProf[19]),
    .statusswSetProf20                (statusswSetProf[20]),
    .statusswSetProf21                (statusswSetProf[21]),
    .statusswSetProf22                (statusswSetProf[22]),
    .statusswSetProf23                (statusswSetProf[23]),
    .statusswSetProf24                (statusswSetProf[24]),
    .statusswSetProf25                (statusswSetProf[25]),
    .statusswSetProf26                (statusswSetProf[26]),
    .statusswSetProf27                (statusswSetProf[27]),
    .statusswSetProf28                (statusswSetProf[28]),
    .statusswSetProf29                (statusswSetProf[29]),
    .statusswSetProf30                (statusswSetProf[30]),
    .statusswSetProf31                (statusswSetProf[31]),
    .statusswSetProf32                (statusswSetProf[32]),
    .statusswSetProf33                (statusswSetProf[33]),
    .statusswSetProf34                (statusswSetProf[34]),
    .statusswSetProf35                (statusswSetProf[35]),
    .statusswSetProf36                (statusswSetProf[36]),
    .statusswSetProf37                (statusswSetProf[37]),
    .statusswSetProf38                (statusswSetProf[38]),
    .statusswSetProf39                (statusswSetProf[39]),
    .statusswSetProf40                (statusswSetProf[40]),
    .statusswSetProf41                (statusswSetProf[41]),
    .statusswSetProf42                (statusswSetProf[42]),
    .statusswSetProf43                (statusswSetProf[43]),
    .statusswSetProf44                (statusswSetProf[44]),
    .statusswSetProf45                (statusswSetProf[45]),
    .statusswSetProf46                (statusswSetProf[46]),
    .statusswSetProf47                (statusswSetProf[47]),
    .statusswSetProf48                (statusswSetProf[48]),
    .statusswSetProf49                (statusswSetProf[49]),
    .statusswSetProf50                (statusswSetProf[50]),
    .statusswSetProf51                (statusswSetProf[51]),
    .statusswSetProf52                (statusswSetProf[52]),
    .statusswSetProf53                (statusswSetProf[53]),
    .statusswSetProf54                (statusswSetProf[54]),
    .statusswSetProf55                (statusswSetProf[55]),
    .statusswSetProf56                (statusswSetProf[56]),
    .statusswSetProf57                (statusswSetProf[57]),
    .statusswSetProf58                (statusswSetProf[58]),
    .statusswSetProf59                (statusswSetProf[59]),
    .statusswSetProf60                (statusswSetProf[60]),
    .statusswSetProf61                (statusswSetProf[61]),
    .statusswSetProf62                (statusswSetProf[62]),
    .statusswSetProf63                (statusswSetProf[63]),
    .swProf0                          (swProf[0]),
    .swProf1                          (swProf[1]),
    .swProf2                          (swProf[2]),
    .swProf3                          (swProf[3]),
    .swProf4                          (swProf[4]),
    .swProf5                          (swProf[5]),
    .swProf6                          (swProf[6]),
    .swProf7                          (swProf[7]),
    .swProf8                          (swProf[8]),
    .swProf9                          (swProf[9]),
    .swProf10                         (swProf[10]),
    .swProf11                         (swProf[11]),
    .swProf12                         (swProf[12]),
    .swProf13                         (swProf[13]),
    .swProf14                         (swProf[14]),
    .swProf15                         (swProf[15]),
    .swProf16                         (swProf[16]),
    .swProf17                         (swProf[17]),
    .swProf18                         (swProf[18]),
    .swProf19                         (swProf[19]),
    .swProf20                         (swProf[20]),
    .swProf21                         (swProf[21]),
    .swProf22                         (swProf[22]),
    .swProf23                         (swProf[23]),
    .swProf24                         (swProf[24]),
    .swProf25                         (swProf[25]),
    .swProf26                         (swProf[26]),
    .swProf27                         (swProf[27]),
    .swProf28                         (swProf[28]),
    .swProf29                         (swProf[29]),
    .swProf30                         (swProf[30]),
    .swProf31                         (swProf[31]),
    .swProf32                         (swProf[32]),
    .swProf33                         (swProf[33]),
    .swProf34                         (swProf[34]),
    .swProf35                         (swProf[35]),
    .swProf36                         (swProf[36]),
    .swProf37                         (swProf[37]),
    .swProf38                         (swProf[38]),
    .swProf39                         (swProf[39]),
    .swProf40                         (swProf[40]),
    .swProf41                         (swProf[41]),
    .swProf42                         (swProf[42]),
    .swProf43                         (swProf[43]),
    .swProf44                         (swProf[44]),
    .swProf45                         (swProf[45]),
    .swProf46                         (swProf[46]),
    .swProf47                         (swProf[47]),
    .swProf48                         (swProf[48]),
    .swProf49                         (swProf[49]),
    .swProf50                         (swProf[50]),
    .swProf51                         (swProf[51]),
    .swProf52                         (swProf[52]),
    .swProf53                         (swProf[53]),
    .swProf54                         (swProf[54]),
    .swProf55                         (swProf[55]),
    .swProf56                         (swProf[56]),
    .swProf57                         (swProf[57]),
    .swProf58                         (swProf[58]),
    .swProf59                         (swProf[59]),
    .swProf60                         (swProf[60]),
    .swProf61                         (swProf[61]),
    .swProf62                         (swProf[62]),
    .swProf63                         (swProf[63]),
    .macAddrLow                       (macAddrLow),
    .macAddrHigh                      (macAddrHigh),
    .macAddrLowMask                   (macAddrLowMask),
    .macAddrHighMask                  (macAddrHighMask),
    .bssIDLow                         (bssIDLow),
    .bssIDHigh                        (bssIDHigh),
    .bssIDLowMask                     (bssIDLowMask),
    .bssIDHighMask                    (bssIDHighMask),
    .primaryChPosition                (primaryChPosition),
    .probeDelay                       (probeDelay),
    .wakeupDTIM                       (wakeupDTIM),
    .listenInterval                   (listenInterval),
    .wakeUpSW                         (wakeUpSW),
    .wakeUpFromDoze                   (wakeUpFromDoze),
    .enableLPClkSwitch                (enableLPClkSwitch),
    .rxRIFSEn                         (rxRIFSEn),
    .tsfMgtDisable                    (tsfMgtDisable),
    .tsfUpdatedBySW                   (tsfUpdatedBySW),
    .abgnMode                         (abgnMode),
    .keyStoRAMReset                   (keyStoRAMReset),
    .mibTableReset                    (mibTableReset),
    .rateControllerMPIF               (rateControllerMPIF),
    .disableSVDRxPause                (disableSVDRxPause),
    .disableBQRResp                   (disableBQRResp),
    .disableBAResp                    (disableBAResp),
    .disableCTSResp                   (disableCTSResp),
    .disableACKResp                   (disableACKResp),
    .activeClkGating                  (activeClkGating),
    .wt2CryptClkRatio                 (wt2CryptClkRatio),
    .pwrMgt                           (pwrMgt),
    .ap                               (ap),
    .bssType                          (bssType),
    .lpClk32786Hz                     (lpClk32786Hz),
    .rxFlowCntrlEn                    (rxFlowCntrlEn),
    .baPSBitmapReset                  (baPSBitmapReset),
    .macPHYIFFIFOReset                (macPHYIFFIFOReset),
    .txFIFOReset                      (txFIFOReset),
    .rxFIFOReset                      (rxFIFOReset),
    .hwFSMReset                       (hwFSMReset),
    .useErrDet                        (useErrDet),
    .errInHWLevel3                    (errInHWLevel3),
    .errInTxRxLevel2                  (errInTxRxLevel2),
    .errInRxLevel1                    (errInRxLevel1),
    .errInTxLevel1                    (errInTxLevel1),
    .clearErrInHWLevel3               (clearErrInHWLevel3),
    .clearErrInTxRxLevel2             (clearErrInTxRxLevel2),
    .clearErrInRxLevel1               (clearErrInRxLevel1),
    .clearErrInTxLevel1               (clearErrInTxLevel1),
    .acceptUnknown                    (acceptUnknown),
    .acceptOtherDataFrames            (acceptOtherDataFrames),
    .acceptQoSNull                    (acceptQoSNull),
    .acceptQCFWOData                  (acceptQCFWOData),
    .acceptQData                      (acceptQData),
    .acceptCFWOData                   (acceptCFWOData),
    .acceptData                       (acceptData),
    .acceptOtherCntrlFrames           (acceptOtherCntrlFrames),
    .acceptCFEnd                      (acceptCFEnd),
    .acceptACK                        (acceptACK),
    .acceptCTS                        (acceptCTS),
    .acceptRTS                        (acceptRTS),
    .acceptPSPoll                     (acceptPSPoll),
    .acceptBA                         (acceptBA),
    .acceptNotExpectedBA              (acceptNotExpectedBA),
    .acceptBAR                        (acceptBAR),
    .acceptOtherMgmtFrames            (acceptOtherMgmtFrames),
    .acceptBfmeeFrames                (acceptBfmeeFrames),
    .acceptDecryptErrorFrames         (acceptDecryptErrorFrames),
    .acceptAllBeacon                  (acceptAllBeacon),
    .acceptBeacon                     (acceptBeacon),
    .acceptProbeResp                  (acceptProbeResp),
    .acceptProbeReq                   (acceptProbeReq),
    .acceptMyUnicast                  (acceptMyUnicast),
    .acceptUnicast                    (acceptUnicast),
    .acceptErrorFrames                (acceptErrorFrames),
    .acceptOtherBSSID                 (acceptOtherBSSID),
    .acceptBroadcast                  (acceptBroadcast),
    .acceptMulticast                  (acceptMulticast),
    .dontDecrypt                      (dontDecrypt),
    .excUnencrypted                   (excUnencrypted),
    .noBcnTxTime                      (noBcnTxTime),
    .impTBTTIn128Us                   (impTBTTIn128Us),
    .impTBTTPeriod                    (impTBTTPeriod),
    .beaconInt                        (beaconInt),
    .aid                              (aid),
    .timOffset                        (timOffset),
    .bcnUpdateOffset                  (bcnUpdateOffset),
    .dtimUpdatedBySW                  (dtimUpdatedBySW),
    .dtimPeriod                       (dtimPeriod),
    .dot11LongRetryLimit              (dot11LongRetryLimit),
    .dot11ShortRetryLimit             (dot11ShortRetryLimit),
    .maxPHYNtx                        (maxPHYNtx),
    .dsssMaxPwrLevel                  (dsssMaxPwrLevel),
    .ofdmMaxPwrLevel                  (ofdmMaxPwrLevel),
    .ofdmMinPwrLevel                  (ofdmMinPwrLevel),
    .bbServiceB                       (bbServiceB),
    .bbServiceA                       (bbServiceA),
    .encrKeyRAMWord0                  (encrKeyRAMWord0),
    .encrKeyRAMWord1                  (encrKeyRAMWord1),
    .encrKeyRAMWord2                  (encrKeyRAMWord2),
    .encrKeyRAMWord3                  (encrKeyRAMWord3),
`ifdef  RW_KEY_EXTENDED
    .encrIntKeyRAMWord0               (encrIntKeyRAMWord0),
    .encrIntKeyRAMWord1               (encrIntKeyRAMWord1),
    .encrIntKeyRAMWord2               (encrIntKeyRAMWord2),
    .encrIntKeyRAMWord3               (encrIntKeyRAMWord3),
`endif//RW_KEY_EXTENDED
    .macAddrRAMLow                    (macAddrRAMLow),
    .macAddrRAMHigh                   (macAddrRAMHigh),
    .newRead                          (newRead),
    .newWrite                         (newWrite),
    .newSearch                        (newSearch),
    .searchError                      (),
    .keyIndexRAM                      (keyIndexRAM),
    .cTypeRAM                         (cTypeRAM),
    .vlanIDRAM                        (vlanIDRAM),
    .sppRAM                           (sppRAM),
    .useDefKeyRAM                     (useDefKeyRAM),
    .cLenRAM                          (cLenRAM),
    .bssBasicRateSet                  (bssBasicRateSet),
    .dsssCount                        (dsssCount),
    .ofdmCount                        (ofdmCount),
    .olbcTimer                        (olbcTimer),
    .txChainDelayInMACClk             (txChainDelayInMACClk),
    .txRFDelayInMACClk                (txRFDelayInMACClk),
    .macCoreClkFreq                   (macCoreClkFreq),
    .slotTimeInMACClk                 (slotTimeInMACClk),
    .slotTime                         (slotTime),
    .rxRFDelayInMACClk                (rxRFDelayInMACClk),
    .macProcDelayInMACClk             (macProcDelayInMACClk),
    .radioWakeUpTime                  (radioWakeUpTime),
    .radioChirpTime                   (radioChirpTime),
    .sifsBInMACClk                    (sifsBInMACClk),
    .sifsB                            (sifsB),
    .sifsAInMACClk                    (sifsAInMACClk),
    .sifsA                            (sifsA),
    .rxCCADelay                       (rxCCADelay),
    .rxStartDelayMIMO                 (rxStartDelayMIMO),
    .rxStartDelayShort                (rxStartDelayShort),
    .rxStartDelayLong                 (rxStartDelayLong),
    .rxStartDelayOFDM                 (rxStartDelayOFDM),
    .rifsTOInMACClk                   (rifsTOInMACClk),
    .txDMAProcDlyInMACClk             (txDMAProcDlyInMACClk),
    .dataMHStoredwithPld              (dataMHStoredwithPld),
    .mgtMHStoredwithPld               (mgtMHStoredwithPld),
    .ctrlMHStoredwithPld              (ctrlMHStoredwithPld),
    .partialUnwrapSize                (partialUnwrapSize),
    .dataFrmWrapMode                  (dataFrmWrapMode),
    .mgtFrmWrapMode                   (mgtFrmWrapMode),
    .ctrlFrmWrapMode                  (ctrlFrmWrapMode),
    .disableRxBuffer2                 (disableRxBuffer2),
    .txPacketTimeout                  (txPacketTimeout),
    .txAbsoluteTimeout                (txAbsoluteTimeout),
    .rxPacketTimeout                  (rxPacketTimeout),
    .rxAbsoluteTimeout                (rxAbsoluteTimeout),
    .mibValue                         (mibValue),
    .mibWrite                         (mibWrite),
    .mibIncrementMode                 (mibIncrementMode),
    .mibTableIndex                    (mibTableIndex),
    .absTimerValue0                   (absTimerValue0),
    .absTimerValue1                   (absTimerValue1),
    .absTimerValue2                   (absTimerValue2),
    .absTimerValue3                   (absTimerValue3),
    .absTimerValue4                   (absTimerValue4),
    .absTimerValue5                   (absTimerValue5),
    .absTimerValue6                   (absTimerValue6),
    .absTimerValue7                   (absTimerValue7),
    .absTimerValue8                   (absTimerValue8),
    .absTimerValue9                   (absTimerValue9),
    .maxAllowedLength                 (maxAllowedLength),
    .txOpLimit0                       (txOpLimit0),
    .cwMax0                           (cwMax0),
    .cwMin0                           (cwMin0),
    .aifsn0                           (aifsn0),
    .txOpLimit1                       (txOpLimit1),
    .cwMax1                           (cwMax1),
    .cwMin1                           (cwMin1),
    .aifsn1                           (aifsn1),
    .txOpLimit2                       (txOpLimit2),
    .cwMax2                           (cwMax2),
    .cwMin2                           (cwMin2),
    .aifsn2                           (aifsn2),
    .txOpLimit3                       (txOpLimit3),
    .cwMax3                           (cwMax3),
    .cwMin3                           (cwMin3),
    .aifsn3                           (aifsn3),
    .ccaBusyDur                       (ccaBusyDur),
    .ccaBusyDurSec20                  (ccaBusyDurSec20),
    .ccaBusyDurSec40                  (ccaBusyDurSec40),
    .ccaBusyDurSec80                  (ccaBusyDurSec80),
    .keepTXOPOpen                     (keepTXOPOpen),
    .remTXOPInDurField                (remTXOPInDurField),
    .sendCFEnd                        (sendCFEnd),
    .sendCFEndNow                     (sendCFEndNow),
    .quietDuration1                   (quietDuration1),
    .quietPeriod1                     (quietPeriod1),
    .quietCount1                      (quietCount1),
    .quietOffset1                     (quietOffset1),
    .basicSTBCMCS                     (basicSTBCMCS),
    .dualCTSProt                      (dualCTSProt),
    .ctsSTBCDur                       (ctsSTBCDur),
    .cfEndSTBCDur                     (cfEndSTBCDur),
    .aPPDUMaxTime                     (aPPDUMaxTime),
    .maxSupportedBW                   (maxSupportedBW),
    .dynBWEn                          (dynBWEn),
    .dropToLowerBW                    (dropToLowerBW),
    .numTryBWAcquisition              (numTryBWAcquisition),
    .defaultBWTXOP                    (defaultBWTXOP),
    .defaultBWTXOPV                   (defaultBWTXOPV),
    .supportLSTP                      (supportLSTP),
    .defaultPEDur                     (defaultPEDur),
    .enableOBSSPD                     (enableOBSSPD),
    .enableSRP                        (enableSRP),
    .acceptTriggerHWFrames            (acceptTriggerHWFrames),
    .acceptTriggerSWFrames            (acceptTriggerSWFrames),
    .acceptAllTriggerFrames           (acceptAllTriggerFrames),
    .dcmSupport                       (dcmSupport),
    .dopplerSupport                   (dopplerSupport),
    .disableTBUPH                     (disableTBUPH),
    .disableTBRU26Resp                (disableTBRU26Resp),
    .disableTBCS                      (disableTBCS),
    .disableTBResp                    (disableTBResp),
    .srgOBSSPDMaxOffset               (srgOBSSPDMaxOffset),
    .srgOBSSPDMinOffset               (srgOBSSPDMinOffset),
    .nonSRGOBSSPDMaxOffset            (nonSRGOBSSPDMaxOffset),
    .srgInformationPresent            (srgInformationPresent),
    .nonSRGOffsetPresent              (nonSRGOffsetPresent),
    .nonSRGOBSSPDSRDisallowed         (nonSRGOBSSPDSRDisallowed),
    .SRPDisallowed                    (srpDisallowed),
    .SRGBSSColorBitmapLow             (srgBSSColorBitmap[31:00]),
    .SRGBSSColorBitmapHigh            (srgBSSColorBitmap[63:32]),
    .SRGPartialBSSIDBitmapLow         (srgPartialBSSIDBitmap[31:00]),
    .SRGPartialBSSIDBitmapHigh        (srgPartialBSSIDBitmap[63:32]),
`ifdef RW_BFMEE_EN                    
    .bfrHELTFType                     (bfrHELTFType),
    .bfrGIType                        (bfrGIType),
    .bfrFormatMod                     (bfrFormatMod),
    .bfrShortGI                       (bfrShortGI),
    .bfrMCS                           (bfrMCS),
    .bfmeeNc                          (bfmeeNc),
    .bfmeeNr                          (bfmeeNr),
    .bfmeeGrouping                    (bfmeeGrouping),
    .bfmeeCodebook                    (bfmeeCodebook),
    .bfmeeMUSupport                   (bfmeeMUSupport),
    .bfmeeEnable                      (bfmeeEnable),
`endif // RW_BFMEE_EN                            
    .bssBasicHTMCSSetUM               (bssBasicHTMCSSetUM),
    .bssBasicHTMCSSetEM               (bssBasicHTMCSSetEM),
    .bssBasicVHTMCSSet                (bssBasicVHTMCSSet),
`ifdef RW_WLAN_COEX_EN                
    .coexWlanChanFreq                 (coexWlanChanFreq),
    .coexWlanChanOffset               (coexWlanChanOffset),
    .coexEnable                       (coexEnable),
    .coexPTIBKData                    (coexPTIBKData),
    .coexPTIBEData                    (coexPTIBEData),
    .coexPTIVIData                    (coexPTIVIData),
    .coexPTIVOData                    (coexPTIVOData),
    .coexPTIBcnData                   (coexPTIBcnData),
    .coexPTIMgt                       (coexPTIMgt),
    .coexPTICntl                      (coexPTICntl),
    .coexPTIAck                       (coexPTIAck),
    .coexForceWlanPTI                 (coexForceWlanPTI),
    .coexForceWlanPTIToggle           (coexForceWlanPTIToggle),
    .coexForceWlanChanBw              (coexForceWlanChanBw),
    .coexForceWlanRx                  (coexForceWlanRx),
    .coexForceWlanTx                  (coexForceWlanTx),
    .coexForceEnable                  (coexForceEnable),
    .coexPostponeTxEnable             (coexPostponeTxEnable),
    .coexPHYRxAbortEnable             (coexPHYRxAbortEnable),
    .coexPHYTxAbortEnable             (coexPHYTxAbortEnable),
    .coexAutoPTIAdjEnable             (coexAutoPTIAdjEnable),
    .coexAutoPTIAdjIncr               (coexAutoPTIAdjIncr),
    .coexWlanRxAbortFallEn            (coexWlanRxAbortFallEn),
    .coexWlanRxAbortRiseEn            (coexWlanRxAbortRiseEn),
    .coexWlanTxAbortFallEn            (coexWlanTxAbortFallEn),
    .coexWlanTxAbortRiseEn            (coexWlanTxAbortRiseEn),
    .setcoexEvent                     (setcoexEvent),
    .clearcoexEvent                   (clearcoexEvent),
    .maskcoexEvent                    (maskcoexEvent),
    .statussetcoexEvent               (statussetcoexEvent),
`else // RW_WLAN_COEX_EN
    .setcoexEvent                     (),
    .clearcoexEvent                   (),
    .maskcoexEvent                    (),
    .statussetcoexEvent               (ZERO_CT),
`endif // RW_WLAN_COEX_EN                
    .debugPortSel2                    (debugPortSel2),
    .debugPortSel1                    (debugPortSel1),
    .basicNAVCounter                  (basicNAVCounter),                        
    .intraNAVCounter                  (intraNAVCounter),                        
    .backoffOffset                    (backoffOffset),
    .latchNextState_p                 (latchNextState_p),
    .regWrite                         (regWrite),
    .regRead                          (regRead),
    .regAddr                          (regAddr),
    .regWriteData                     (regWriteData),
    .regReadyIn                       (regReadyIn),
    .regReadData                      (regReadData)
    );
// Temporary, waiting for Spatial Reuse Registers
assign srParameterSetValid = 1'b0;


assign swProfInValid   = swSetProf | swClearProf;
assign swProfIn        = (swProf | swSetProf) & ~swClearProf;
assign statusswSetProf = 64'b0;


assign quietOffset1InValid   = quietElement1InValid;
assign quietDuration1InValid = quietElement1InValid;
assign quietPeriod1InValid   = quietElement1InValid;
assign quietCount1InValid    = quietElement1InValid;

assign macAddr      =  {macAddrHigh,macAddrLow};
assign macAddrMask  =  {macAddrHighMask,macAddrLowMask};   

assign bssID        =  {bssIDHigh,bssIDLow};        
assign bssIDMask    =  {bssIDHighMask,bssIDLowMask};    

assign macPHYIFFIFOResetInValid = primaryMacPHYIFFIFOResetInValid;

assign txFIFOResetInValid = primaryTxFIFOResetInValid;


// Instanciation of macCore
// Name of the instance : U_macCore
// Name of the file containing this module : macCore.v
macCore U_macCore (
    .macPIClkHardRst_n                (macPIClkHardRst_n),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macWTClkHardRst_n                (macWTClkHardRst_n),
    .mpIFClkHardRst_n                 (mpIFClkHardRst_n),
    .macPIClkSoftRst_n                (macPIClkSoftRst_n),
    .macCoreClkSoftRst_n              (macCoreClkSoftRst_n),
    .macWTClkSoftRst_n                (macWTClkSoftRst_n),
    .macPISlaveClk                    (macPISlaveClk),
    .macPIClk                         (macPIClk),
    .macPITxClk                       (macPITxClk),
    .macCoreClk                       (macCoreClk),
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreRxClk                     (macCoreRxClk),
    .macLPClk                         (macLPClk),
    .macWTClk                         (macWTClk),
    .macCryptClk                      (macCryptClk),
    .macPriClkEn                      (macPriClkEn),
    .macSecClkEn                      (macSecClkEn),
    .platformWakeUp                   (platformWakeUp),
    .macCoreTxClkEn                   (macCoreTxClkEn),
    .macCoreRxClkEn                   (macCoreRxClkEnInt),
    .macLPClkSwitch                   (macLPClkSwitch),
    .macCryptClkEn                    (macCryptClkEn),
    .macWTClkEn                       (macWTClkEn),
    .mpIFClkEn                        (mpIFClkEn),
    .absGenTimersInt                  (absGenTimersIntMC),
    .txRxExchangeEnabled              (txRxExchangeEnabled),
    .txInProgress                     (txInProgress),
    .sendOnSIFS                       (sendOnSIFS),
    .duration                         (duration),
    .tsfDuration                      (tsfDuration),
    .rxVector1Valid_p                 (rxVector1Valid_p),
    .txopComplete                     (txopComplete),
    .ac3ProtTrigger                   (ac3ProtTrigger),
    .ac2ProtTrigger                   (ac2ProtTrigger),
    .ac1ProtTrigger                   (ac1ProtTrigger),
    .ac0ProtTrigger                   (ac0ProtTrigger),
    .ac3BWDropTrigger                 (ac3BWDropTrigger),
    .ac2BWDropTrigger                 (ac2BWDropTrigger),
    .ac1BWDropTrigger                 (ac1BWDropTrigger),
    .ac0BWDropTrigger                 (ac0BWDropTrigger),
    .olbcOFDM                         (olbcOFDM),
    .olbcDSSS                         (olbcDSSS),
    .impPriTBTT                       (impPriTBTT),
    .impSecTBTT                       (impSecTBTT),
    .impPriDTIM                       (impPriDTIM),
    .impSecDTIM                       (impSecDTIM),
    .timerTxTrigger                   (timerTxTrigger),
    .timerRxTrigger                   (timerRxTrigger),
    .idleInterrupt                    (idleInterrupt),
    .tbTxCancelled                    (tbTxCancelled),
    .rxFIFOOverFlow                   (rxFIFOOverFlow),
    .absTimers                        (absTimers),
    .hwErr                            (hwErr),
    .softReset                        (softReset),
    .txCtrlRegWr                      (txCtrlRegWr),
    .txCtrlRegData                    (txCtrlRegData),
    .txCtrlRegPT                      (txCtrlRegPT),
    .txCtrlRegHD                      (txCtrlRegHD),
    .discardPrevHD_p                  (discardPrevHD_p),
    .txCtrlRegBusy                    (txCtrlRegBusy),
    .rxFrmDiscard                     (rxFrmDiscard),
    .rxDescAvailable                  (rxDescAvailable),
    .statusUpdated_p                  (statusUpdated_p),
    .updateDMAStatus_p                (updateDMAStatus_p),
    .txAC0StateMC                     (txAC0StateMC),
    .txAC1StateMC                     (txAC1StateMC),
    .txAC2StateMC                     (txAC2StateMC),
    .txAC3StateMC                     (txAC3StateMC),
    .txBcnStateMC                     (txBcnStateMC),
    .trigTxAC0                        (trigTxAC0),
    .trigTxAC1                        (trigTxAC1),
    .trigTxAC2                        (trigTxAC2),
    .trigTxAC3                        (trigTxAC3),
    .trigTxBcn                        (trigTxBcn),
    .trigTxTB                         (trigTxTB),
    .frameRxed_p                      (frameRxed_p),
    .swRTS_p                          (swRTS_p),
    .txMpduDone_p                     (txMpduDone_p),
    .ampduFrm_p                       (ampduFrm_p),
    .retryFrame_p                     (retryFrame_p),
    .mpduSuccess_p                    (mpduSuccess_p),
    .mpduFailed_p                     (mpduFailed_p),
    .rtsFailed_p                      (rtsFailed_p),
    .rtsSuccess_p                     (rtsSuccess_p),
    .retryLimitReached_p              (retryLimitReached_p),
    .transmissionBW                   (transmissionBW),
    .numMPDURetries                   (numMPDURetries),
    .numRTSRetries                    (numRTSRetries),
    .mediumTimeUsed                   (mediumTimeUsed),
    .whichDescriptorSW                (whichDescriptorSW),
    .rxTrig_p                         (rxTrig_p),
    .tickSlot_p                       (tickSlot_p),
    .tickSIFS_p                       (tickSIFS_p),
    .tsfTimer                         (tsfTimer),
    .txFIFOMPDUDelimiters             (txFIFOMPDUDelimiters),
    .txFIFORdData                     (txFIFORdData),
    .txFIFOEmpty                      (txFIFOEmpty),
    .txFIFODataValid                  (txFIFODataValid),
    .txFIFORdFlush                    (txFIFORdFlush),
    .txFIFORead                       (txFIFORead),
    .rxFIFOAlmostFull                 (rxFIFOAlmostFull),
    .rxFIFOFull                       (rxFIFOFull),
    .rxFIFOEmptyWrClk                 (rxFIFOEmptyWrClk),
    .rxFIFOWrTag                      (rxFIFOWrTag),
    .rxFIFOWrData                     (rxFIFOWrData),
    .rxFIFOWrite                      (rxFIFOWrite),
    .macPhyIfRxStart_p                (macPhyIfRxStart_p),
    .macPhyIfRxFlush_p                (macPhyIfRxFlush_p),
    .startRx                          (startRx),
    .stopRx_p                         (stopRx_p),
    .mpifKeepRFon                     (mpifKeepRFon),
    .startTx_p                        (startTx_p),
    .stopTx_p                         (stopTx_p),
    .mpIfTxFifoData                   (mpIfTxFifoData),
    .mpIfTxFifoWrite                  (mpIfTxFifoWrite),
    .heLTFType                        (heLTFType),
    .txPwrLevel                       (txPwrLevel),
    .chBW                             (chBW),
    .smoothing                        (smoothing),
    .antennaSet                       (antennaSet),
    .smmIndex                         (smmIndex),
    .mcs                              (mcs),
    .preType                          (preType),
    .formatMod                        (formatMod),
    .numExtnSS                        (numExtnSS),
    .stbc                             (stbc),
    .fecCoding                        (fecCoding),
    .sounding                         (sounding),
    .legLength                        (legLength),
    .legRate                          (legRate),
    .service                          (service),
    .htLength                         (htLength),
    .htLengthValid                    (htLengthValid),
    .spatialReuse1                    (spatialReuse1),
    .spatialReuse2                    (spatialReuse2),
    .spatialReuse3                    (spatialReuse3),
    .spatialReuse4                    (spatialReuse4),
    .heSigAReserved                   (heSigAReserved),
    .numHeLtf                         (numHeLtf),
    .heLtfMode                        (heLtfMode),
    .ldpcExtraSymbol                  (ldpcExtraSymbol),
    .startingSTSNum                   (startingSTSNum),
    .sigBCompressionMode              (sigBCompressionMode),
    .dcmSigB                          (dcmSigB),
    .mcsSigB                          (mcsSigB),
    .ruAllocation                     (ruAllocation),
    .triggerMethod                    (triggerMethod),
    .ruToneSetIndex                   (ruToneSetIndex),
    .feedBackStatus                   (feedBackStatus),
    .doppler                          (doppler),
    .midamble                         (midamble),
    .nTx                              (nTx),
    .giType                           (giType),
    .aggreation                       (aggreation),
    .packetExtension                  (packetExtension),
    .bssColor                         (bssColor),
    .txopDuration                     (txopDuration),
    .triggerResponding                (triggerResponding),
    .upLinkFlag                       (upLinkFlag),
    .beamChange                       (beamChange),
    .dcm                              (dcm),
    .beamFormed                       (beamFormed),
    .disambiguityBit                  (disambiguityBit),
    .partialAID                       (partialAID),
    .groupID                          (groupID),
    .dozeNotAllowed                   (dozeNotAllowed),
    .continuousTx                     (continuousTx),
    .userPosition                     (userPosition[1:0]),                       // ToDo
    .mpIfTxFifoFull                   (mpIfTxFifoFull),
    .mpIfTxFifoAlmostFull             (mpIfTxFifoAlmostFull),
    .mpIfTxErr_p                      (mpIfTxErr_p),
    .mpIfTxEn                         (mpIfTxEn),
    .macPhyTxEnd_p                    (macPhyTxEnd_p),
    .macPhyIfRxFifoReadEn             (macPhyIfRxFifoReadEn),
    .macPhyIfRxFifoEmpty              (macPhyIfRxFifoEmpty),
    .macPhyIfRxFifoData               (macPhyIfRxFifoData),
    .macPhyIfRxErr_p                  (macPhyIfRxErr_p),
    .macPhyIfRxEnd_p                  (macPhyIfRxEnd_p),
    .macPhyIfRxEndForTiming_p         (macPhyIfRxEndForTiming_p),
    .macPhyIfRifsRxDetected           (macPhyIfRifsRxDetected),
    .macPhyIfRxCca                    (macPhyIfRxCca),
    .macPhyIfRxCcaSec20               (macPhyIfRxCcaSec20),
    .macPhyIfRxCcaSec40               (macPhyIfRxCcaSec40),
    .macPhyIfRxCcaSec80               (macPhyIfRxCcaSec80),
    .macPHYIFUnderRun                 (macPHYIFUnderRun),
    .macPHYIFOverflow                 (macPHYIFOverflow),
    .rxDSSS                           (rxDSSS),
`ifdef RW_MAC_MIBCNTL_EN
    .mibAddr                          (mibAddr),
    .mibRd                            (mibRd),
    .mibRdData                        (mibRdData),
    .mibBusy                          (mibBusy),
    .mibTableEn                       (mibTableEn),
    .mibTableAddr                     (mibTableAddr),
    .mibTableWriteEn                  (mibTableWriteEn),
    .mibTableWriteData                (mibTableWriteData),
    .mibTableReadData                 (mibTableReadData),
`endif // RW_MAC_MIBCNTL_EN
    .keyStorageEn                     (keyStorageEn),
    .keyStorageWriteEn                (keyStorageWriteEn),
    .keyStorageAddr                   (keyStorageAddr),
    .keyStorageReadData               (keyStorageReadData),
    .keyStorageWriteData              (keyStorageWriteData),
    .sboxMemRdAddr                    (sboxMemRdAddr),          
    .sboxMemRdData                    (sboxMemRdData),          
    .sboxMemWrAddr                    (sboxMemWrAddr),          
    .sboxMemRdEn                      (sboxMemRdEn),            
    .sboxMemWrEn                      (sboxMemWrEn),            
    .sboxMemWrData                    (sboxMemWrData),      
    .basicNAVCounter                  (basicNAVCounter),
    .basicNAVCounterIn                (basicNAVCounterIn),
    .basicNAVCounterInValid           (basicNAVCounterInValid),
    .intraNAVCounter                  (intraNAVCounter),
    .intraNAVCounterIn                (intraNAVCounterIn),
    .intraNAVCounterInValid           (intraNAVCounterInValid),
    .currentState                     (currentState),
    .nextState                        (nextState),
    .latchNextState_p                 (latchNextState_p),
    .nextStateIn                      (nextStateIn),
    .nextStateInValid                 (nextStateInValid),
    .wakeUpSW                         (wakeUpSW),
    .wakeUpFromDoze                   (wakeUpFromDoze),
    .enableLPClkSwitch                (enableLPClkSwitch),
    .activeClkGating                  (activeClkGating),
    .wt2CryptClkRatio                 (wt2CryptClkRatio),
    .disableACKResp                   (disableACKResp),
    .disableCTSResp                   (disableCTSResp),
    .disableBAResp                    (disableBAResp),
    .disableBQRResp                   (disableBQRResp),
    .disableTBResp                    (disableTBResp),
    .disableTBCS                      (disableTBCS),
    .disableTBRU26Resp                (disableTBRU26Resp),
    .disableTBUPH                     (disableTBUPH),
    .disableSVDRxPause                (disableSVDRxPause),
    .macAddr                          (macAddr),
    .macAddrMask                      (macAddrMask),
    .bssID                            (bssID),
    .bssIDMask                        (bssIDMask),
    .aid                              (aid),
    .bssColorCSReg                    (bssColorCSReg),
    .bssColorEnCSReg                  (bssColorEnCSReg),
    .partialBSSColorEnCSReg           (partialBSSColorEnCSReg),
    .bssHE                            (1'b0),                                    //ToDo:11ax
    .excUnencrypted                   (excUnencrypted),
    .dontDecrypt                      (dontDecrypt),
    .acceptMulticast                  (acceptMulticast),
    .acceptBroadcast                  (acceptBroadcast),
    .acceptOtherBSSID                 (acceptOtherBSSID),
    .acceptErrorFrames                (acceptErrorFrames),
    .acceptUnicast                    (acceptUnicast),
    .acceptMyUnicast                  (acceptMyUnicast),
    .acceptProbeReq                   (acceptProbeReq),
    .acceptProbeResp                  (acceptProbeResp),
    .acceptDecryptErrorFrames         (acceptDecryptErrorFrames),
    .acceptBeacon                     (acceptBeacon),
    .acceptAllBeacon                  (acceptAllBeacon),
    .acceptOtherMgmtFrames            (acceptOtherMgmtFrames),
`ifdef RW_BFMEE_EN
    .acceptBfmeeFrames                (acceptBfmeeFrames),
`endif //RW_BFMEE_EN
    .acceptBAR                        (acceptBAR),
    .acceptBA                         (acceptBA),
    .acceptNotExpectedBA              (acceptNotExpectedBA),
    .acceptPSPoll                     (acceptPSPoll),
    .acceptRTS                        (acceptRTS),
    .acceptCTS                        (acceptCTS),
    .acceptACK                        (acceptACK),
    .acceptCFEnd                      (acceptCFEnd),
    .acceptOtherCntrlFrames           (acceptOtherCntrlFrames),
    .acceptData                       (acceptData),
    .acceptCFWOData                   (acceptCFWOData),
    .acceptQData                      (acceptQData),
    .acceptQCFWOData                  (acceptQCFWOData),
    .acceptQoSNull                    (acceptQoSNull),
    .acceptOtherDataFrames            (acceptOtherDataFrames),
    .acceptUnknown                    (acceptUnknown),
    .acceptTriggerHWFrames            (acceptTriggerHWFrames),
    .acceptTriggerSWFrames            (acceptTriggerSWFrames),
    .acceptAllTriggerFrames           (acceptAllTriggerFrames),
    .hwFSMResetPIClk                  (hwFSMResetPIClk),
    .hwFSMResetWTClk                  (hwFSMResetWTClk),
    .hwFSMResetCoreClk                (hwFSMResetCoreClk),
    .baPSBitmapReset                  (baPSBitmapReset),
    .baPSBitmapResetIn                (baPSBitmapResetIn),
    .baPSBitmapResetInValid           (baPSBitmapResetInValid),
    .mibTableReset                    (mibTableReset),
    .mibTableResetIn                  (mibTableResetIn),
    .mibTableResetInValid             (mibTableResetInValid),
    .mibTableIndex                    (mibTableIndex),
    .mibIncrementMode                 (mibIncrementMode),
    .mibValue                         (mibValue),
    .mibWrite                         (mibWrite),
    .mibWriteInValid                  (mibWriteInValid),
    .mibWriteIn                       (mibWriteIn),
    .quietCount1In                    (quietCount1In),
    .quietPeriod1In                   (quietPeriod1In),
    .quietDuration1In                 (quietDuration1In),
    .quietOffset1In                   (quietOffset1In),
    .quietElement1InValid             (quietElement1InValid),
    .dtimPeriodIn                     (dtimPeriodIn),
    .dtimPeriodInValid                (dtimPeriodInValid),
    .txOpLimit0                       (txOpLimit0),
    .txOpLimit1                       (txOpLimit1),
    .txOpLimit2                       (txOpLimit2),
    .txOpLimit3                       (txOpLimit3),
    .aifsn0                           (aifsn0),
    .aifsn1                           (aifsn1),
    .aifsn2                           (aifsn2),
    .aifsn3                           (aifsn3),
    .cwMin0                           (cwMin0),
    .cwMin1                           (cwMin1),
    .cwMin2                           (cwMin2),
    .cwMin3                           (cwMin3),
    .cwMax0                           (cwMax0),
    .cwMax1                           (cwMax1),
    .cwMax2                           (cwMax2),
    .cwMax3                           (cwMax3),
    .ac0MOT                           (ac0MOT),
    .ac1MOT                           (ac1MOT),
    .ac2MOT                           (ac2MOT),
    .ac3MOT                           (ac3MOT),
    .rxControlLs                      (rxControlLs),
    .rxControlCs                      (rxControlCs),
    .txControlLs                      (txControlLs),
    .txControlCs                      (txControlCs),
    .macControlLs                     (macControlLs),
    .macControlCs                     (macControlCs),
    .primaryChPosition                (primaryChPosition),
    .probeDelay                       (probeDelay),
    .listenInterval                   (listenInterval),
    .wakeupDTIM                       (wakeupDTIM),
    .beaconInt                        (beaconInt),
    .impTBTTPeriod                    (impTBTTPeriod),
    .impTBTTIn128Us                   (impTBTTIn128Us),
    .noBcnTxTime                      (noBcnTxTime),
    .dtimPeriod                       (dtimPeriod),
    .dtimUpdatedBySW                  (dtimUpdatedBySW),
    .dtimUpdatedBySWIn                (dtimUpdatedBySWIn),
    .dtimUpdatedBySWInValid           (dtimUpdatedBySWInValid),
    .tsfTimerHigh                     (tsfTimerHigh),
    .tsfTimerLow                      (tsfTimerLow),
    .tsfUpdatedBySW                   (tsfUpdatedBySW),
    .tsfMgtDisable                    (tsfMgtDisable),
    .txBWAfterDropResync              (txBWAfterDrop),
    .eOCWIn                           (eOCWIn),
    .eOCWInValid                      (eOCWInValid),
    .maxMCSInHETB                     (maxMCSInHETB),
    .eOCW                             (eOCW),
    .eOCWMin                          (eOCWMin),
    .ocwLFSR                          (ocwLFSR),
    .ocwLFSRIn                        (ocwLFSRIn),
    .ocwLFSRInValid                   (ocwLFSRInValid),
    .raRUType                         (raRUType),
    .raRUEnable                       (raRUEnable),
    .txHETBRemDur                     (txHETBRemDur),
    .txHETBMaxDur                     (txHETBMaxDur),
    .ulDoppler                        (ulDoppler),
    .ulPEDisambiguity                 (ulPEDisambiguity),
    .ulPreFecPadding                  (ulPreFecPadding),
    .ulLDPCExtrSymb                   (ulLDPCExtrSymb),
    .ulSTBC                           (ulSTBC),
    .ulNLTFAndMidamble                (ulNLTFAndMidamble),
    .ulMULTFMode                      (ulMULTFMode),
    .ulGILTFType                      (ulGILTFType),
    .ulBW                             (ulBW),
    .ulLength                         (ulLength),
    .ulTriggerType                    (ulTriggerType),
    .tdUserInfoSubfield               (tdUserInfoSubfield),
    .ulNSS                            (ulNSS),
    .ulRUType                         (ulRUType),
    .ulDCM                            (ulDCM),
    .ulMCS                            (ulMCS),
    .ulFECCoding                      (ulFECCoding),
    .ulRUSize                         (ulRUSize),
    .ulPSDULenValidPI                 (ulPSDULenValidPI),
    .ulPSDULen                        (ulPSDULen),
    .ulTargetRSSI                     (ulTargetRSSI),
    .apTXPower                        (apTXPower),
    .heTBUPHControl                   (heTBUPHControl),
    .nextTBTT                         (nextTBTT),
    .timOffset                        (timOffset),
    .tsfUpdatedBySWIn                 (tsfUpdatedBySWIn),
    .tsfUpdatedBySWInValid            (tsfUpdatedBySWInValid),
    .tsfTimerLowIn                    (tsfTimerLowIn),
    .tsfTimerLowInValid               (tsfTimerLowInValid),
    .tsfTimerHighIn                   (tsfTimerHighIn),
    .tsfTimerHighInValid              (tsfTimerHighInValid),
    .absTimerValue0                   (absTimerValue0),
    .absTimerValue1                   (absTimerValue1),
    .absTimerValue2                   (absTimerValue2),
    .absTimerValue3                   (absTimerValue3),
    .absTimerValue4                   (absTimerValue4),
    .absTimerValue5                   (absTimerValue5),
    .absTimerValue6                   (absTimerValue6),
    .absTimerValue7                   (absTimerValue7),
    .absTimerValue8                   (absTimerValue8),
    .absTimerValue9                   (absTimerValue9),
    .monotonicCounter1                (monotonicCounter1),
    .monotonicCounterLow2             (monotonicCounterLow2),
    .monotonicCounterHigh2            (monotonicCounterHigh2),
    .monotonicCounter2SWUpdate        (monotonicCounter2SWUpdate),
    .monotonicCounterLow2In           (monotonicCounterLow2In),
    .monotonicCounterHigh2In          (monotonicCounterHigh2In),
    .monotonicCounterLow2InValid      (monotonicCounterLow2InValid),
    .monotonicCounterHigh2InValid     (monotonicCounterHigh2InValid),
    .abgnMode                         (abgnMode),
    .band5G                           (band5G),
    .olbcTimer                        (olbcTimer),
    .ofdmCount                        (ofdmCount),
    .dsssCount                        (dsssCount),
    .macCoreClkFreq                   (macCoreClkFreq),
    .txChainDelayInMACClk             (txChainDelayInMACClk),
    .slotTime                         (slotTime),
    .slotTimeInMACClk                 (slotTimeInMACClk),
    .macProcDelayInMACClk             (macProcDelayInMACClk),
    .rxRFDelayInMACClk                (rxRFDelayInMACClk),
    .radioWakeUpTime                  (radioWakeUpTime),
    .sifsBInMACClk                    (sifsBInMACClk),
    .sifsAInMACClk                    (sifsAInMACClk),
    .sifsB                            (sifsB),
    .sifsA                            (sifsA),
    .rxCCADelay                       (rxCCADelay),
    .txDMAProcDlyInMACClk             (txDMAProcDlyInMACClk),
    .rifsTOInMACClk                   (rifsTOInMACClk),
    .dataMHStoredwithPld              (dataMHStoredwithPld),
    .mgtMHStoredwithPld               (mgtMHStoredwithPld),
    .ctrlMHStoredwithPld              (ctrlMHStoredwithPld),
    .dataFrmWrapMode                  (dataFrmWrapMode),
    .mgtFrmWrapMode                   (mgtFrmWrapMode),
    .ctrlFrmWrapMode                  (ctrlFrmWrapMode),
    .disableRxBuffer2                 (disableRxBuffer2),
    .txAbsoluteTimeout                (txAbsoluteTimeout),
    .txPacketTimeout                  (txPacketTimeout),
    .rxAbsoluteTimeout                (rxAbsoluteTimeout),
    .rxPacketTimeout                  (rxPacketTimeout),
    .ccaBusyDur                       (ccaBusyDur),
    .ccaBusyDurIn                     (ccaBusyDurIn),
    .ccaBusyDurInValid                (ccaBusyDurInValid),
    .ccaBusyDurSec20                  (ccaBusyDurSec20),
    .ccaBusyDurSec20In                (ccaBusyDurSec20In),
    .ccaBusyDurSec20InValid           (ccaBusyDurSec20InValid),
    .ccaBusyDurSec40                  (ccaBusyDurSec40),
    .ccaBusyDurSec40In                (ccaBusyDurSec40In),
    .ccaBusyDurSec40InValid           (ccaBusyDurSec40InValid),
    .ccaBusyDurSec80                  (ccaBusyDurSec80),
    .ccaBusyDurSec80In                (ccaBusyDurSec80In),
    .ccaBusyDurSec80InValid           (ccaBusyDurSec80InValid),
    .quietCount1                      (quietCount1),
    .quietPeriod1                     (quietPeriod1),
    .quietDuration1                   (quietDuration1),
    .quietOffset1                     (quietOffset1),
    .rxStartDelayMIMO                 (rxStartDelayMIMO),
    .rxStartDelayShort                (rxStartDelayShort),
    .rxStartDelayLong                 (rxStartDelayLong),
    .rxStartDelayOFDM                 (rxStartDelayOFDM),
    .pwrMgt                           (pwrMgt),
    .ap                               (ap),
    .bssType                          (bssType),
    .lpClk32786Hz                     (lpClk32786Hz),
    .rxRIFSEn                         (rxRIFSEn),
    .dsssMaxPwrLevel                  (dsssMaxPwrLevel),
    .ofdmMaxPwrLevel                  (ofdmMaxPwrLevel),
    .ofdmMinPwrLevel                  (ofdmMinPwrLevel),
    .maxPHYNtx                        (maxPHYNtx),
    .maxAllowedLength                 (maxAllowedLength),
    .ppduLength                       (ppduLength),
    .ppduBW                           (ppduBW),
    .ppduPreType                      (ppduPreType),
    .ppduNumExtnSS                    (ppduNumExtnSS),
    .ppduSTBC                         (ppduSTBC),
    .ppduGIType                       (ppduGIType),
    .ppduMCSIndex                     (ppduMCSIndex),
    .ppduNUser                        (ppduNUser),
    .ppduPE                           (ppduPE),
    .ppduMCSSigB                      (ppduMCSSigB),
    .ppduDCMSigB                      (ppduDCMSigB),
    .ppduSigBCompMode                 (ppduSigBCompMode),
    .ppduHELTFType                    (ppduHELTFType),
    .ppduNumHeLtf                     (ppduNumHeLtf),
    .ppduDCM                          (ppduDCM),
    .ppduDoppler                      (ppduDoppler), 
    .ppduMma                          (ppduMma),     
    .ppduRuType                       (ppduRuType),  
    .computeDuration                  (computeDuration),
    .computeDurationIn                (computeDurationIn),
    .computeDurationInValid           (computeDurationInValid),
    .timeOnAir                        (timeOnAir),
    .timeOnAirValid                   (timeOnAirValid),
    .cfEndSTBCDur                     (cfEndSTBCDur),
    .ctsSTBCDur                       (ctsSTBCDur),
    .dualCTSProt                      (dualCTSProt),
    .basicSTBCMCS                     (basicSTBCMCS),
    .bbServiceA                       (bbServiceA),
    .bbServiceB                       (bbServiceB),
    .keepTXOPOpen                     (keepTXOPOpen),
    .remTXOPInDurField                (remTXOPInDurField),    
    .sendCFEnd                        (sendCFEnd),
    .sendCFEndNow                     (sendCFEndNow),
    .sendCFEndNowInValid              (sendCFEndNowInValid),
    .sendCFEndNowIn                   (sendCFEndNowIn),
    .dynBWEn                          (dynBWEn),
    .dropToLowerBW                    (dropToLowerBW),
    .numTryBWAcquisition              (numTryBWAcquisition),
    .defaultBWTXOP                    (defaultBWTXOP),
    .defaultBWTXOPV                   (defaultBWTXOPV),
    .aPPDUMaxTime                     (aPPDUMaxTime),
    .maxSupportedBW                   (maxSupportedBW),
    .supportLSTP                      (supportLSTP),
    .bssBasicRateSet                  (bssBasicRateSet),
    .bssBasicHTMCSSetEM               (bssBasicHTMCSSetEM),
    .bssBasicHTMCSSetUM               (bssBasicHTMCSSetUM),
    .bssBasicVHTMCSSet                (bssBasicVHTMCSSet),
`ifdef RW_WLAN_COEX_EN                
    .coexEnable                       (coexEnable),
    .coexPostponeTxEnable             (coexPostponeTxEnable),
    .coexAutoPTIAdjEnable             (coexAutoPTIAdjEnable),
    .coexAutoPTIAdjIncr               (coexAutoPTIAdjIncr),
    .coexPTIBKData                    (coexPTIBKData),
    .coexPTIBEData                    (coexPTIBEData),
    .coexPTIVIData                    (coexPTIVIData),
    .coexPTIVOData                    (coexPTIVOData),
    .coexPTIBcnData                   (coexPTIBcnData),
    .coexPTIMgt                       (coexPTIMgt),
    .coexPTICntl                      (coexPTICntl),
    .coexPTIAck                       (coexPTIAck),
    .coexForceWlanPTI                 (coexForceWlanPTI),
    .coexForceWlanPTIToggle           (coexForceWlanPTIToggle),
    .coexForceWlanChanBw              (coexForceWlanChanBw),
    .coexForceWlanRx                  (coexForceWlanRx),
    .coexForceWlanTx                  (coexForceWlanTx),
    .coexForceEnable                  (coexForceEnable),
    .coexWlanTx                       (coexWlanTx),
    .coexWlanRx                       (coexWlanRx),
    .coexWlanTxAbort                  (coexWlanTxAbortGated),
    .coexWlanRxAbort                  (coexWlanRxAbortGated),
    .coexWlanPTI                      (coexWlanPTI),
    .coexWlanPTIToggle                (coexWlanPTIToggle),
    .coexWlanChanBw                   (coexWlanChanBw),
    .debugPortCoexController          (debugPortCoexController),

    .coexWlanPTIState                 (coexWlanPTIState),
    .coexWlanPTIToggleState           (coexWlanPTIToggleState),
    .coexWlanChanBwState              (coexWlanChanBwState),
    .coexWlanRxState                  (coexWlanRxState),
    .coexWlanTxState                  (coexWlanTxState),
    .coexWlanRxAbortState             (coexWlanRxAbortState),
    .coexWlanTxAbortState             (coexWlanTxAbortState),
    .coexWlanRxAbortFallEn            (coexWlanRxAbortFallEn),
    .coexWlanRxAbortRiseEn            (coexWlanRxAbortRiseEn),
    .coexWlanTxAbortFallEn            (coexWlanTxAbortFallEn),
    .coexWlanTxAbortRiseEn            (coexWlanTxAbortRiseEn),
    .coexEvent                        (coexEvent),
`endif // RW_WLAN_COEX_EN                
`ifdef RW_BFMEE_EN
    .bfrStart                         (macBfrStart),
    .bfrDone                          (macBfrDone),
    .bfrChBW                          (macBfrChBW),
    .bfrGrouping                      (macBfrGrouping),
    .bfrCodebook                      (macBfrCodebook),
    .bfrFeedbackType                  (macBfrFeedbackType),
    .bfrNr                            (macBfrNr),
    .bfrNc                            (macBfrNc),
    .bfrHE                            (macBfrHE),
    .bfrRUStartIndex                  (macBfrRUStartIndex),
    .bfrRUEndIndex                    (macBfrRUEndIndex),
    .bfrData                          (macBfrData),
    .bfrDataValid                     (macBfrDataValid),
    .bfrDataReady                     (macBfrDataReady),
`endif //RW_BFMEE_EN
    .backoffOffset                    (backoffOffset),
    .currentCW0                       (currentCW0),
    .currentCW1                       (currentCW1),
    .currentCW2                       (currentCW2),
    .currentCW3                       (currentCW3),
    .ac3QSRC                          (ac3QSRC),
    .ac2QSRC                          (ac2QSRC),
    .ac1QSRC                          (ac1QSRC),
    .ac0QSRC                          (ac0QSRC),
    .ac3QLRC                          (ac3QLRC),
    .ac2QLRC                          (ac2QLRC),
    .ac1QLRC                          (ac1QLRC),
    .ac0QLRC                          (ac0QLRC),
    .activeAC                         (activeAC),
    .keyStoRAMReset                   (keyStoRAMReset),
    .keyStoRAMResetIn                 (keyStoRAMResetIn),
    .keyStoRAMResetInValid            (keyStoRAMResetInValid),
    .debugKSR                         (debugKSR),
    .encrKeyRAMWord0                  (encrKeyRAMWord0),
    .encrKeyRAMWord1                  (encrKeyRAMWord1),
    .encrKeyRAMWord2                  (encrKeyRAMWord2),
    .encrKeyRAMWord3                  (encrKeyRAMWord3),
`ifdef  RW_KEY_EXTENDED
    .encrIntKeyRAMWord0               (encrIntKeyRAMWord0),
    .encrIntKeyRAMWord1               (encrIntKeyRAMWord1),
    .encrIntKeyRAMWord2               (encrIntKeyRAMWord2),
    .encrIntKeyRAMWord3               (encrIntKeyRAMWord3),
`endif//RW_KEY_EXTENDED
    .macAddrRAMLow                    (macAddrRAMLow),
    .macAddrRAMHigh                   (macAddrRAMHigh),
    .encrKeyRAMWord0In                (encrKeyRAMWord0In),
    .encrKeyRAMWord1In                (encrKeyRAMWord1In),
    .encrKeyRAMWord2In                (encrKeyRAMWord2In),
    .encrKeyRAMWord3In                (encrKeyRAMWord3In),
`ifdef  RW_KEY_EXTENDED
    .encrIntKeyRAMWord0In             (encrIntKeyRAMWord0In),
    .encrIntKeyRAMWord1In             (encrIntKeyRAMWord1In),
    .encrIntKeyRAMWord2In             (encrIntKeyRAMWord2In),
    .encrIntKeyRAMWord3In             (encrIntKeyRAMWord3In),
`endif//RW_KEY_EXTENDED
    .macAddrRAMLowIn                  (macAddrRAMLowIn),
    .macAddrRAMHighIn                 (macAddrRAMHighIn),
    .encrKeyRAMWord0InValid           (encrKeyRAMWord0InValid),
    .encrKeyRAMWord1InValid           (encrKeyRAMWord1InValid),
    .encrKeyRAMWord2InValid           (encrKeyRAMWord2InValid),
    .encrKeyRAMWord3InValid           (encrKeyRAMWord3InValid),
`ifdef  RW_KEY_EXTENDED
    .encrIntKeyRAMWord0InValid        (encrIntKeyRAMWord0InValid),
    .encrIntKeyRAMWord1InValid        (encrIntKeyRAMWord1InValid),
    .encrIntKeyRAMWord2InValid        (encrIntKeyRAMWord2InValid),
    .encrIntKeyRAMWord3InValid        (encrIntKeyRAMWord3InValid),
`endif//RW_KEY_EXTENDED
    .macAddrRAMLowInValid             (macAddrRAMLowInValid),
    .macAddrRAMHighInValid            (macAddrRAMHighInValid),
    .keyIndexRAM                      (keyIndexRAM),
    .keyIndexRAMIn                    (keyIndexRAMIn),
    .keyIndexRAMInValid               (keyIndexRAMInValid),
    .newWrite                         (newWrite),
    .newWriteIn                       (newWriteIn),
    .newWriteInValid                  (newWriteInValid),
    .newRead                          (newRead),
    .newReadIn                        (newReadIn),
    .newReadInValid                   (newReadInValid),
    .newSearch                        (newSearch),
    .newSearchIn                      (newSearchIn),
    .newSearchInValid                 (newSearchInValid),
    .searchErrorIn                    (searchErrorIn),
    .searchErrorInValid               (searchErrorInValid),
    .cLenRAM                          (cLenRAM),
    .cLenRAMIn                        (cLenRAMIn),
    .cLenRAMInValid                   (cLenRAMInValid),
    .useDefKeyRAM                     (useDefKeyRAM),
    .useDefKeyRAMIn                   (useDefKeyRAMIn),
    .useDefKeyRAMInValid              (useDefKeyRAMInValid),
    .sppRAM                           (sppRAM),
    .sppRAMIn                         (sppRAMIn),
    .sppRAMInValid                    (sppRAMInValid),
    .vlanIDRAM                        (vlanIDRAM),
    .vlanIDRAMIn                      (vlanIDRAMIn),
    .vlanIDRAMInValid                 (vlanIDRAMInValid),
    .cTypeRAM                         (cTypeRAM),
    .cTypeRAMIn                       (cTypeRAMIn),
    .cTypeRAMInValid                  (cTypeRAMInValid),
    .staKeyStartIndex                 (staKeyStartIndex),
    .staKeyEndIndex                   (staKeyEndIndex),
    .nVAP                             (nVAP),
    .staKeyMaxIndex                   (staKeyMaxIndex),
`ifdef RW_BFMEE_EN                    
    .bfrHELTFType                     (bfrHELTFType),
    .bfrGIType                        (bfrGIType),
    .bfrFormatMod                     (bfrFormatMod),
    .bfrShortGI                       (bfrShortGI),
    .bfrMCS                           (bfrMCS),
    .bfmeeNc                          (bfmeeNc),
    .bfmeeNr                          (bfmeeNr),
    .bfmeeGrouping                    (bfmeeGrouping),
    .bfmeeCodebook                    (bfmeeCodebook),
    .bfmeeMUSupport                   (bfmeeMUSupport),
    .bfmeeEnable                      (bfmeeEnable),
`endif // RW_BFMEE_EN                            
    .defaultPEDur                     (defaultPEDur),
    .srParameterSetValid              (srParameterSetValid),
    .srpDisallowed                    (srpDisallowed),
    .nonSRGOBSSPDSRDisallowed         (nonSRGOBSSPDSRDisallowed),
    .nonSRGOffsetPresent              (nonSRGOffsetPresent),
    .nonSRGOBSSPDMaxOffset            (nonSRGOBSSPDMaxOffset),
    .srgInformationPresent            (srgInformationPresent),
    .srgOBSSPDMaxOffset               (srgOBSSPDMaxOffset),
    .srgOBSSPDMinOffset               (srgOBSSPDMinOffset),
    .srgBSSColorBitmap                (srgBSSColorBitmap),
    .srgPartialBSSIDBitmap            (srgPartialBSSIDBitmap),
    .enableOBSSPD                     (enableOBSSPD),
    .enableSRP                        (enableSRP),
    .dcmSupport                       (dcmSupport),
    .dopplerSupport                   (dopplerSupport),
    .debugPortMACTimerUnit            (debugPortMACTimerUnit),
    .debugPortMACTimerUnit2           (debugPortMACTimerUnit2),
    .debugPortMACTimerUnit3           (debugPortMACTimerUnit3),
    .debugPortBackoff                 (debugPortBackoff),
    .debugPortBackoff2                (debugPortBackoff2),
    .debugPortBackoff3                (debugPortBackoff3),
    .debugPortDeaggregator            (debugPortDeaggregator),
    .debugPortDeaggregator2           (debugPortDeaggregator2),
    .debugPortDeaggregatorFsm         (debugPortDeaggregatorFsm),
    .debugPortRxController            (debugPortRxController),
    .debugPortRxFrameDebug1           (debugPortRxFrameDebug1),
    .debugPortRxFrameDebug2           (debugPortRxFrameDebug2),
    .debugPortTxFrameDebug1           (debugPortTxFrameDebug1),
    .debugPortTxFrameDebug2           (debugPortTxFrameDebug2),
    .debugPortBAController            (debugPortBAController),
    .debugPortBAController2           (debugPortBAController2),
    .debugPortBAController3           (debugPortBAController3),
    .debugPortTxParametersCache       (debugPortTxParametersCache),
    .debugPortMACController1          (debugPortMACController1),
    .debugPortMediumAccess            (debugPortMediumAccess),
    .debugPortNAV                     (debugPortNAV),
    .debugPortMACControllerRx         (debugPortMACControllerRx),
    .debugPortMACControllerRxSWTB     (debugPortMACControllerRxSWTB),
    .debugPortMACControllerTx         (debugPortMACControllerTx),
    .debugPortBWManagement            (debugPortBWManagement),
    .debugPortAMPDU                   (debugPortAMPDU[13:0]),
    .debugPortEncryptionEngine        (debugPortEncryptionEngine),
    .debugPortEncryptionCCMP          (debugPortEncryptionCCMP),
`ifdef RW_WAPI_EN
    .debugPortWapi                    (debugPortWapi),
`endif //RW_WAPI_EN
    .debugPortKeySearch               (debugPortKeySearch),
    .debugPortrxFIFOCntrl             (debugPortrxFIFOCntrl),
    .debugPortDecryptFsm              (debugPortDecryptFsm),
    .debugPortTriggerDecoder          (debugPortTriggerDecoder),
`ifdef RW_BFMEE_EN
    .debugPortBFRController           (debugPortBFRController),
`endif //RW_BFMEE_EN
    .debugPortDozeController          (debugPortDozeController),
    .debugPortSRController            (debugPortSRController),
    .debugPortTxTimeCalculator        (debugPortTxTimeCalculator)
    );


// Instanciation of macPhyIf
// Name of the instance : U_macPhyIf
// Name of the file containing this module : macPhyIf.v
macPhyIf U_macPhyIf (
    .mpIFClk                          (mpIFClk),
    .mpIFClkHardRst_n                 (mpIFClkHardRst_n),
    .mpIFClkSoftRst_n                 (mpifSoftRst_n),
    .macCoreClk                       (macCoreClk),
    .macCoreRxClk                     (macCoreClk),
    .macCoreTxClk                     (macCoreClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreClkSoftRst_n              (macCoreClkSoftRst_n),
    .phyRdy                           (phyRdy),
    .txEnd_p                          (txEnd_p),
    .rxData                           (rxData),
    .CCAPrimary20                     (CCAPrimary20),
    .CCASecondary20                   (CCASecondary20),
    .CCASecondary40                   (CCASecondary40),
    .CCASecondary80                   (CCASecondary80),
    .rxEndForTiming_p                 (rxEndForTiming_p),
    .rxErr_p                          (rxErr_p),
    .rxEnd_p                          (rxEnd_p),
    .phyErr_p                         (phyErr_p),
    .rifsRxDetected                   (rifsRxDetected),
    .txReq                            (txReq),
    .rxReq                            (rxReq),
    .txData                           (txData),
    .macDataValid                     (macDataValid),
    .mimoCmdValid                     (mimoCmdValid),
    .keepRFOn                         (keepRFOn),
    .startRx                          (startRx),
    .stopRx_p                         (stopRx_p),
    .mpifKeepRFon                     (mpifKeepRFon),
    .macPhyIfRxStart_p                (macPhyIfRxStart_p),
    .macPhyIfRxFlush_p                (macPhyIfRxFlush_p),
    .startTx_p                        (startTx_p),
    .stopTx_p                         (stopTx_p),
    .mpIfTxFifoData                   (mpIfTxFifoData),
    .mpIfTxFifoWrite                  (mpIfTxFifoWrite),
    .txPwrLevel                       (txPwrLevel),
    .chBW                             (chBW),
    .smoothing                        (smoothing),
    .antennaSet                       (antennaSet),
    .smmIndex                         (smmIndex),
    .mcs                              (mcs),
    .preType                          (preType),
    .formatMod                        (formatMod),
    .numExtnSS                        (numExtnSS),
    .stbc                             (stbc),
    .fecCoding                        (fecCoding),
    .sounding                         (sounding),
    .legLength                        (legLength),
    .legRate                          (legRate),
    .service                          (service),
    .htLength                         (htLength),
    .htLengthValid                    (htLengthValid),
    .nTx                              (nTx),
    .aggreation                       (aggreation),
    .beamFormed                       (beamFormed),
    .partialAID                       (partialAID),
    .groupID                          (groupID),
    .dozeNotAllowed                   (dozeNotAllowed),
    .continuousTx                     (continuousTx),
    .userPosition                     ({3'd0,userPosition[1:0]}),                // ToDo:11ax(HE-MU)
    .timeOfDepartureReq               (1'b0),//timeOfDepartureReq),              // ToDo:11ax
    .giType                           (giType),
    .upLinkFlag                       (upLinkFlag),
    .beamChange                       (beamChange),
    .dcm                              (dcm),
    .heLTFType                        (heLTFType),
    .doppler                          (doppler),
    .midamble                         (midamble),
    .bssColor                         (bssColor),
    .txopDuration                     (txopDuration),
    .triggerResponding                (triggerResponding),
    .nUser                            (8'd0),//nUser),                           // ToDo:11ax(HE-MU)
    .staID                            (11'd0),//staID),                          // ToDo:11ax(HE-MU)
    .spatialReuse1                    (spatialReuse1),
    .spatialReuse2                    (spatialReuse2),
    .spatialReuse3                    (spatialReuse3),
    .spatialReuse4                    (spatialReuse4),
    .heSigAReserved                   (heSigAReserved),
    .numHeLtf                         (numHeLtf),
    .heLtfMode                        (heLtfMode),
    .ldpcExtraSymbol                  (ldpcExtraSymbol),
    .startingSTSNum                   (startingSTSNum),
    .sigBCompressionMode              (sigBCompressionMode),
    .dcmSigB                          (dcmSigB),
    .mcsSigB                          (mcsSigB),
    .ruAllocation                     (ruAllocation),
    .packetExtension                  (packetExtension),
    .triggerMethod                    (triggerMethod),
    .ruToneSetIndex                   (ruToneSetIndex),
    .feedBackStatus                   (feedBackStatus),
    .mpIfTxFifoFull                   (mpIfTxFifoFull),
    .mpIfTxFifoAlmostFull             (mpIfTxFifoAlmostFull),
    .mpIfTxErr_p                      (mpIfTxErr_p),
    .mpIfTxEn                         (mpIfTxEn),
    .timeOfDeparture                  (timeOfDeparture),                         // ToDo:11ax
    .timeOfDepartureClkRate           (timeOfDepartureClkRate),                  // ToDo:11ax
    .macPhyTxEnd_p                    (macPhyTxEnd_p),
    .rxDSSS                           (rxDSSS),
    .macPhyIfRxFifoReadEn             (macPhyIfRxFifoReadEn),
    .macPhyIfRxFifoEmpty              (macPhyIfRxFifoEmpty),
    .macPhyIfRxFifoData               (macPhyIfRxFifoData),
    .macPhyIfRxErr_p                  (macPhyIfRxErr_p),
    .macPhyIfRxEnd_p                  (macPhyIfRxEnd_p),
    .macPhyIfRxEndForTiming_p         (macPhyIfRxEndForTiming_p),
    .macPhyIfRifsRxDetected           (macPhyIfRifsRxDetected),
    .macPhyIfRxCca                    (macPhyIfRxCca),
    .macPhyIfRxCcaSec20               (macPhyIfRxCcaSec20),
    .macPhyIfRxCcaSec40               (macPhyIfRxCcaSec40),
    .macPhyIfRxCcaSec80               (macPhyIfRxCcaSec80),
    .band5G                           (band5G),
    .macPHYIFFIFOReset                (macPHYIFFIFOReset),
    .macPHYIFFIFOResetInValid         (primaryMacPHYIFFIFOResetInValid),
    .rateControllerMPIF               (rateControllerMPIF),
    .rxReqForceDeassertion            (rxReqForceDeassertion),
    .rxEndForTimingErrRec             (rxEndForTimingErrRec),
    .macCoreClkFreq                   (macCoreClkFreq),
    .macPHYIFUnderRun                 (macPHYIFUnderRun),
    .macPHYIFOverflow                 (macPHYIFOverflow),
`ifdef RW_BFMEE_EN
    .mpifBfrStart                     (bfrStart),
    .mpifBfrDone                      (bfrDone),
    .mpifBfrChBW                      (bfrChBW),
    .mpifBfrGrouping                  (bfrGrouping),
    .mpifBfrCodebook                  (bfrCodebook),
    .mpifBfrFeedbackType              (bfrFeedbackType),
    .mpifBfrNr                        (bfrNr),
    .mpifBfrNc                        (bfrNc),
    .mpifBfrHE                        (bfrHE),
    .mpifBfrRUStartIndex              (bfrRUStartIndex),
    .mpifBfrRUEndIndex                (bfrRUEndIndex),
    .mpifBfrData                      (bfrData),
    .mpifBfrDataValid                 (bfrDataValid),
    .mpifBfrDataReady                 (bfrDataReady),
    .macBfrStart                      (macBfrStart),
    .macBfrDone                       (macBfrDone),
    .macBfrChBW                       (macBfrChBW),
    .macBfrGrouping                   (macBfrGrouping),
    .macBfrCodebook                   (macBfrCodebook),
    .macBfrFeedbackType               (macBfrFeedbackType),
    .macBfrNr                         (macBfrNr),
    .macBfrNc                         (macBfrNc),
    .macBfrHE                         (macBfrHE),
    .macBfrRUStartIndex               (macBfrRUStartIndex),
    .macBfrRUEndIndex                 (macBfrRUEndIndex),
    .macBfrData                       (macBfrData),
    .macBfrDataValid                  (macBfrDataValid),
    .macBfrDataReady                  (macBfrDataReady),
`endif // RW_BFMEE_EN
    .mpIFTxFIFOReadData               (mpIFTxFIFOReadData),
    .mpIFTxFIFOWriteData              (mpIFTxFIFOWriteData),
    .mpIFTxFIFOWriteAddr              (mpIFTxFIFOWriteAddr),
    .mpIFTxFIFOWriteEn                (mpIFTxFIFOWriteEn),
    .mpIFTxFIFOReadAddr               (mpIFTxFIFOReadAddr),
    .mpIFTxFIFOReadEn                 (mpIFTxFIFOReadEn),
    .mpIFRxFIFOReadData               (mpIFRxFIFOReadData),
    .mpIFRxFIFOWriteData              (mpIFRxFIFOWriteData),
    .mpIFRxFIFOWriteAddr              (mpIFRxFIFOWriteAddr),
    .mpIFRxFIFOWriteEn                (mpIFRxFIFOWriteEn),
    .mpIFRxFIFOReadAddr               (mpIFRxFIFOReadAddr),
    .mpIFRxFIFOReadEn                 (mpIFRxFIFOReadEn),
    .debugPortMACPhyIf                (debugPortMACPhyIf),
    .debugPortMACPhyIf2               (debugPortMACPhyIf2),
    .debugPortMACPhyIf3               (debugPortMACPhyIf3)
`ifdef  RW_BFMEE_EN
    ,
    .debugPortSVD                     (debugPortSVD),
    .debugPortSVD2                    (debugPortSVD2),
    .debugPortSVDFifo                 (debugPortSVDFifo)
`endif//RW_BFMEE_EN
    );

assign macPHYIFFIFOResetIn = 1'b0;



////////////////////////////////////////////////////
/// DEBUG port assignment
////////////////////////////////////////////////////


//Important Note : macControlCs MSB is not connected to debugPort. 
//                 macController Tx FSM : DROPBW_LENGTH_UPDATE state will appear as "IDLE"
assign debugPortMainFSM1 = {txControlCs, macControlCs[7:5], macControlCs[3:0]};
assign debugPortMainFSM2 = {debugPortDeaggregatorFsm, rxControlCs[4:0], macControlCs[7:5],macControlCs[3:0]};

assign debugPortMainFSM = (txControlCs == 9'd0) ? debugPortMainFSM2 : debugPortMainFSM1;


/*
// Instanciation of debugPortCtrl
// Name of the instance : U_debugPortCtrl
// Name of the file containing this module : debugPortCtrl.v
debugPortCtrl U_debugPortCtrl (
    .debugPortSel1          (debugPortSel1),
    .debugPortSel2          (debugPortSel2),
    .debugPortRead          (debugPortRead),
    .debugPort              (debugPort),
    .debugPortInt1          (debugPortBackoff),
    .debugPortInt2          (debugPortMainFSM1),
    .debugPortInt3          (debugPortMainFSM2),
    .debugPortInt4          (debugPortDMA1),
    .debugPortInt5          (debugPortMACTimerUnit),
    .debugPortInt6          (debugPortDeaggregator),
    .debugPortInt7          (debugPortRxController),
    .debugPortInt8          (debugPortDMA2),
    .debugPortInt9          (debugPortFrameDebug1),
    .debugPortInt10         (debugPortFrameDebug2),
    .debugPortInt11         (debugPortInterrupt),
    .debugPortInt12         (debugPortMACPhyIf),
    .debugPortInt13         (debugPortBAController),
    .debugPortInt14         (debugPortTxParametersCache),
    .debugPortInt15         (debugPortMACController1),
    .debugPortInt16         (debugPortDMA3),
    .debugPortInt17         (debugPortDMA4),
    .debugPortInt18         (debugPortDMA5),
    .debugPortInt19         (debugPortDMA6),
    .debugPortInt20         (debugPortMediumAccess),
    .debugPortInt21         (debugPortNAV),
    .debugPortInt22         (debugPortMACControllerRx),
    .debugPortInt23         (debugPortBAController2),
    .debugPortInt24         (debugPortBAController3),
    .debugPortInt25         (debugPortEncryptionEngine[15:0]),
    .debugPortInt26         (debugPortEncryptionEngine[31:16]),
    .debugPortInt27         (debugPortMACControllerTx),
    .debugPortInt28         (debugPortDMAStatus),
    .debugPortInt29         (debugPortAMPDU),
    .debugPortInt30         (debugPortDMATxStatus),
    .debugPortInt31         (swProf[15:0]),
    .debugPortInt32         (swProf[31:16]),
    .debugPortInt33         (debugPortKeySearch),
    .debugPortInt34         (debugPortrxFIFOCntrl),
    .debugPortInt35         (debugPortDecryptFsm),
    .debugPortInt36         (debugPortTxRxListA),
    .debugPortInt37         (debugPortDmaRdWrCtlr),
    .debugPortInt38         (debugPortMainFSM),
    .debugPortInt39         (debugPortDeaggregator2),
    .debugPortInt40         (debugPortMACTimerUnit2),
    .debugPortInt41         (debugPortMACTimerUnit3),
    .debugPortInt42         (debugPortDozeController),
    .debugPortInt43         (debugPortBWManagement),
    .debugPortInt44         (debugPortBackoff2),
    .debugPortInt45         (debugPortBackoff3),
    .debugPortInt46         (debugPortClockGating),
    .debugPortInt47         (debugPortClock),
    .debugPortInt48         (debugPortMACPhyIf2),
`ifdef RW_WAPI_EN
    .debugPortInt49         (debugPortWapi),
`endif //RW_WAPI_EN
`ifdef RW_WLAN_COEX_EN
    .debugPortInt50         (debugPortCoexController),
`endif // RW_WLAN_COEX_EN
`ifdef RW_BFMEE_EN
    .debugPortInt51         (debugPortBFRController),
`endif //RW_BFMEE_EN
    .debugPortInt52         (debugPortSRController),
    .debugPortInt53         (debugPortMACPhyIf3),
    .debugPortInt54         (debugPortEncryptionCCMP),
`ifdef  RW_BFMEE_EN
    .debugPortInt55         (debugPortSVD),
    .debugPortInt56         (debugPortSVD2),
    .debugPortInt57         (debugPortSVDFifo),
`endif//RW_BFMEE_EN
    .debugPortInt58         (debugPortMACControllerRxSWTB),
    .debugPortInt59         (debugPortTriggerDecoder)
    );
*/
assign debugPortRead = 32'h0;

assign debugPort0  = debugPortBackoff;
assign debugPort1  = debugPortMainFSM1;
assign debugPort2  = debugPortMainFSM2;
assign debugPort3  = debugPortDMA1;
assign debugPort4  = debugPortMACTimerUnit;
assign debugPort5  = debugPortDeaggregator;
assign debugPort6  = debugPortRxController;
assign debugPort7  = debugPortDMA2;
assign debugPort8  = debugPortFrameDebug1;
assign debugPort9  = debugPortFrameDebug2;
assign debugPort10 = debugPortInterrupt;
assign debugPort11 = debugPortMACPhyIf;
assign debugPort12 = debugPortBAController;
assign debugPort13 = debugPortTxParametersCache;
assign debugPort14 = debugPortMACController1;
assign debugPort15 = debugPortDMA3;
assign debugPort16 = debugPortDMA4;
assign debugPort17 = debugPortDMA5;
assign debugPort18 = debugPortDMA6;
assign debugPort19 = debugPortMediumAccess;
assign debugPort20 = debugPortNAV;
assign debugPort21 = debugPortMACControllerRx;
assign debugPort22 = debugPortBAController2;
assign debugPort23 = debugPortBAController3;
assign debugPort24 = debugPortEncryptionEngine[15:0];
assign debugPort25 = debugPortEncryptionEngine[31:16];
assign debugPort26 = debugPortMACControllerTx;
assign debugPort27 = debugPortDMAStatus;
assign debugPort28 = debugPortAMPDU;
assign debugPort29 = debugPortDMATxStatus;
assign debugPort30 = swProf[15:0];
assign debugPort31 = swProf[31:16];
assign debugPort32 = debugPortKeySearch;
assign debugPort33 = debugPortrxFIFOCntrl;
assign debugPort34 = debugPortDecryptFsm;
assign debugPort35 = debugPortTxRxListA;
assign debugPort36 = debugPortDmaRdWrCtlr;
assign debugPort37 = debugPortMainFSM;
assign debugPort38 = debugPortDeaggregator2;
assign debugPort39 = debugPortMACTimerUnit2;
assign debugPort40 = debugPortMACTimerUnit3;
assign debugPort41 = debugPortDozeController;
assign debugPort42 = debugPortBWManagement;
assign debugPort43 = debugPortBackoff2;
assign debugPort44 = debugPortBackoff3;
assign debugPort45 = debugPortClockGating;
assign debugPort46 = debugPortClock;
assign debugPort47 = debugPortMACPhyIf2;

`ifdef  RW_WAPI_EN
assign debugPort48 = debugPortWapi;
`else //RW_WAPI_EN
assign debugPort48 = 16'h0;
`endif//RW_WAPI_EN

`ifdef  RW_WLAN_COEX_EN
assign debugPort49 = debugPortCoexController;
`else //RW_WLAN_COEX_EN
assign debugPort49 = 16'h0;
`endif//RW_WLAN_COEX_EN

`ifdef  RW_BFMEE_EN
assign debugPort50 = debugPortBFRController;
`else //RW_BFMEE_EN
assign debugPort50 = 16'h0;
`endif//RW_BFMEE_EN

assign debugPort51 = debugPortSRController;
assign debugPort52 = debugPortMACPhyIf3;
assign debugPort53 = debugPortEncryptionCCMP;

`ifdef  RW_BFMEE_EN
assign debugPort54 = debugPortSVD;
assign debugPort55 = debugPortSVD2;
assign debugPort56 = debugPortSVDFifo;
`else //RW_BFMEE_EN
assign debugPort54 = 16'h0;
assign debugPort55 = 16'h0;
assign debugPort56 = 16'h0;
`endif//RW_BFMEE_EN

assign debugPort57 = debugPortMACControllerRxSWTB;
assign debugPort58 = debugPortTriggerDecoder;
assign debugPort59 = swProf[47:32];
assign debugPort60 = swProf[63:48];
assign debugPort61 = debugPortTxTimeCalculator;

`ifdef RW_SWPROF_DEBUG_PORT
  // Additional debugPort dedicated to SW profiling
  assign swProfDebugPort = swProf;
`endif // RW_SWPROF_DEBUG_PORT

// This process captures the debugPortRead on the macLPClk.
// This is not a real resynchronization as the debugPortRead content comes from
// different clock domain but it is named Resync to ease the CDC analysis
always @ (posedge macLPClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    debugPortReadResync <= 32'b0;
  else 
    debugPortReadResync <= debugPortRead;
end

assign debugPortAMPDU[15] = !intRxTrigger_n;
assign debugPortAMPDU[14] = !intTxTrigger_n;

// Mux debugPortTxFrameDebug and debugPortRxFrameDebug
assign debugPortFrameDebug1 = (debugPortTxFrameDebug1[15]) ? {2'b10,debugPortTxFrameDebug1[13:0]} 
                                         : (debugPortRxFrameDebug1[15]) ? {2'b01,debugPortRxFrameDebug1[13:0]} 
                                                                        : 16'b0;
assign debugPortFrameDebug2 = (debugPortTxFrameDebug1[15]) ? debugPortTxFrameDebug2
                                         : (debugPortRxFrameDebug1[15]) ? debugPortRxFrameDebug2
                                                                        : 16'b0;

// Debug Port Interrupts assignment
assign debugPortInterrupt = {(phyErr | hwErr | macPHYIFUnderRun | rxFIFOOverFlow),
                             (tbTxDMADead  | bcnTxDMADead | ac0TxDMADead | ac1TxDMADead | ac2TxDMADead | ac3TxDMADead | ptError),
                             (ac3TxTrigger | ac2TxTrigger | ac1TxTrigger | ac0TxTrigger | bcnTxTrigger | tbTxTrigger | tbTxCancelled),
                             1'b0/*rxDMAEmpty*/,
                             idleInterrupt,
                             absTimers[1],
                             absTimers[0],
                             (impPriDTIM | impSecDTIM),
                             (impPriTBTT | impSecTBTT),                                                           
                             txopComplete,
                             !intGen_n,         
                             !intProtTrigger_n, 
                             !intTxTrigger_n,   
                             !intRxTrigger_n,   
                             !intTxRxMisc_n,    
                             !intTxRxTimer_n};  
                             
assign debugPortClockGating = {idleInterrupt,
                               txListProcCsIsIdle,
                               rxListProcCsIsIdle,
                               rxFIFOEmptyWrClk,
                               macSecClkEn,
                               activeClkGating,
                               macPriClkEn,
                               platformWakeUp,
                               macPITxClkEn,
                               macPIRxClkEn,
                               macCoreTxClkEn,
                               macCoreRxClkEn,
                               macCryptClkEn,
                               macLPClkSwitch,
                               macWTClkEn,
                               mpIFClkEn};


assign debugPortClock = {                             
      macLPClkSwitch,
      macCoreTxClkEn,
      macCoreRxClkEn,
      activeClkGating,
      macPriClkEn,
      macPIClkDbg,       
      macPITxClkDbg,     
      macPIRxClkDbg,     
      macPISlaveClkDbg,  
      macCoreClkDbg,     
      macCryptClkDbg,    
      macCoreTxClkDbg,   
      macCoreRxClkDbg,   
      macLPClkDbg,       
      macWTClkDbg,       
      mpIFClkDbg};

        
always @ (posedge macPIClk or negedge macPIClkHardRst_n) 
begin
  if (macPIClkHardRst_n == 1'b0)  // Asynchronous Reset
    macPIClkDbg <= 1'b0;
  else 
    macPIClkDbg <= ~macPIClkDbg;
end
always @ (posedge macPITxClk or negedge macPIClkHardRst_n) 
begin
  if (macPIClkHardRst_n == 1'b0)  // Asynchronous Reset
    macPITxClkDbg <= 1'b0;
  else 
    macPITxClkDbg <= ~macPITxClkDbg;
end

always @ (posedge macPIRxClk or negedge macPIClkHardRst_n) 
begin
  if (macPIClkHardRst_n == 1'b0)  // Asynchronous Reset
    macPIRxClkDbg <= 1'b0;
  else 
    macPIRxClkDbg <= ~macPIRxClkDbg;
end
always @ (posedge macPISlaveClk or negedge macPIClkHardRst_n) 
begin
  if (macPIClkHardRst_n == 1'b0)  // Asynchronous Reset
    macPISlaveClkDbg <= 1'b0;
  else 
    macPISlaveClkDbg <= ~macPISlaveClkDbg;
end
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macCoreClkDbg <= 1'b0;
  else 
    macCoreClkDbg <= ~macCoreClkDbg;
end
always @ (posedge macCryptClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macCryptClkDbg <= 1'b0;
  else 
    macCryptClkDbg <= ~macCryptClkDbg;
end
always @ (posedge macCoreTxClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macCoreTxClkDbg <= 1'b0;
  else 
    macCoreTxClkDbg <= ~macCoreTxClkDbg;
end
always @ (posedge macCoreRxClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macCoreRxClkDbg <= 1'b0;
  else 
    macCoreRxClkDbg <= ~macCoreRxClkDbg;
end
always @ (posedge macLPClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    macLPClkDbg <= 1'b0;
  else 
    macLPClkDbg <= ~macLPClkDbg;
end
always @ (posedge macWTClk or negedge macWTClkHardRst_n) 
begin
  if (macWTClkHardRst_n == 1'b0)  // Asynchronous Reset
    macWTClkDbg <= 1'b0;
  else 
    macWTClkDbg <= ~macWTClkDbg;
end
always @ (posedge mpIFClk or negedge mpIFClkHardRst_n) 
begin
  if (mpIFClkHardRst_n == 1'b0)  // Asynchronous Reset
    mpIFClkDbg <= 1'b0;
  else 
    mpIFClkDbg <= ~mpIFClkDbg;
end


// Generate internalError indication based on the different error flags 
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    internalError <= 1'b0;
  else if ((macCoreClkSoftRst_n == 1'b0) || (hwFSMResetCoreClk == 1'b1)) // Synchronous Reset
     internalError <= 1'b0;
  else if (phyErr | hwErr | macPHYIFOverflow | macPHYIFUnderRun | rxFIFOOverFlow | dmaInternalError)
     internalError <= 1'b1;
end


////////////////////////////////////////////////////////////////////////////////
// Coex
////////////////////////////////////////////////////////////////////////////////
`ifdef RW_WLAN_COEX_EN
assign coexWlanTxAbortGated = coexWlanTxAbortResync && coexEnable;

// Instanciation of simpleSynchro
// Name of the instance : U_coexWlanTxAbort_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_coexWlanTxAbort_synchro (
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (coexWlanTxAbort),
                .dstdata            (coexWlanTxAbortResync)
                );

assign coexWlanRxAbortGated = coexWlanRxAbortResync && coexEnable;

// Instanciation of simpleSynchro
// Name of the instance : U_coexWlanRxAbort_synchro
// Name of the file containing this module : simpleSynchro.v
simpleSynchro U_coexWlanRxAbort_synchro (
                .dstclk             (macCoreClk),
                .dstresetn          (macCoreClkHardRst_n),
                .srcdata            (coexWlanRxAbort),
                .dstdata            (coexWlanRxAbortResync)
                );


`endif // RW_WLAN_COEX_EN


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Additional Code to ease verification
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

`ifdef RW_SIMU_ON
initial
begin
  $display(" ");
  $display("MAC RTL Configuration");
  $display("-----------------");
  $display(" ");
  $display("  Features:");

  $display("    - MACHW_BFMEE            : %0d",`MACHW_BFMEE);
  $display("    - MACHW_BFMER            : %0d",`MACHW_BFMER);
  $display("    - MACHW_COEX             : %0d",`MACHW_COEX);
  $display("    - MACHW_HE               : %0d",`MACHW_HE);
  $display("    - MACHW_VHT              : %0d",`MACHW_VHT);
  $display("    - MACHW_TPC              : %0d",`MACHW_TPC);
  $display("    - MACHW_HT               : %0d",`MACHW_HT);
  $display("    - MACHW_RCE              : %0d",`MACHW_RCE);
  $display("    - MACHW_CCMP             : %0d",`MACHW_CCMP);
  $display("    - MACHW_GCMP             : %0d",`MACHW_GCMP);
  $display("    - MACHW_TKIP             : %0d",`MACHW_TKIP);
  $display("    - MACHW_WAPI             : %0d",`MACHW_WAPI);
  $display("    - MACHW_WEP              : %0d",`MACHW_WEP);
  $display("    - MACHW_SECURITY         : %0d",`MACHW_SECURITY);
  $display("    - MACHW_EDCA             : %0d",`MACHW_EDCA);
  $display("    - MACHW_QOS              : %0d",`MACHW_QOS);
                                         
`ifdef RW_MAC_MIBCNTL_EN                 
  $display("    - RW_MAC_MIBCNTL_EN      : 1");
`else                                    
  $display("    - RW_MAC_MIBCNTL_EN      : 0");
`endif                                   
  $display("    - mac80211MHFormat       : 1");
  $display(" ");

`ifdef RW_TXTIME_DIVIDER_ONECYCLE  
  $display("    - RW_TXTIME_DIVIDER_ONECYCLE");
`endif

`ifdef RW_TXTIME_DIVIDER_FIVECYCLE  
  $display("    - RW_TXTIME_DIVIDER_FIVECYCLE");
`endif

  $display(" ");
  $display(" ");

  $display("  Clocks:");
  $display("    - MAC_FREQ          : %0d MHz",`MAC_FREQ);
  $display("    - WT_CLOCK_FREQ     : %0d MHz",`MAC_FREQ*`WEP_2_BB_CLK_RATIO);
  $display("    - WEP_2_BB_CLK_RATIO: %0d",`WEP_2_BB_CLK_RATIO);
  $display(" ");
  $display(" ");

end
`endif // RW_SIMU_ON

`ifdef RW_AHBSPY_ON

ahbSpy #(.ahbSpyNumber(0)) U_ahbMasterSpy (
  .resetn     (macPIClkHardRst_n),
  .clk        (macPIClk),
  .hready_in  (hMReady),
  .hsel       (hMSelSpy),
  .haddr      (hMAddr),
  .htrans     (hMTrans),
  .hburst     (hMBurst),
  .hsize      (hMSize),
  .hwrite     (hMWrite),
  .hresp      (hMResp),
  .hready     (hMReady),
  .hit        ()
  );

ahbSpy #(.ahbSpyNumber(1)) U_ahbSlaveSpy (
  .resetn     (macPIClkHardRst_n),
  .clk        (macPIClk),
  .hready_in  (hSReadyOut),
  .hsel       (hSSelSpy),
  .haddr      (hSAddrSpy),
  .htrans     (hSTrans),
  .hburst     (hSBurst),
  .hsize      (hSSize),
  .hwrite     (hSWrite),
  .hresp      (hSResp),
  .hready     (hSReadyOut),
  .hit        ()
  );

assign hMSelSpy  = {7'b0, 1'b1};
assign hSSelSpy  = {7'b0, 1'b1};
assign hSAddrSpy = {16'b0, hSAddr};

`endif // RW_AHBSPY_ON


`ifdef RW_ASSERT_ON
///////////////////////////////////////////////////////
// External Memory Interface Checks
///////////////////////////////////////////////////////

//$rw_sva Check addr and data in case of Write Access in mpIFTXFifo
property mpIFTXFifo_CheckAddrAndDataInWrite_prop;
@(posedge macCoreTxClk)
  disable iff(!macCoreClkHardRst_n)
  mpIFTxFIFOWriteEn |-> (^mpIFTxFIFOWriteAddr !== 1'bX && ^mpIFTxFIFOWriteData !== 1'bX);
endproperty
mpIFTXFifo_CheckAddrAndDataInWrite: assert property (mpIFTXFifo_CheckAddrAndDataInWrite_prop); 

//$rw_sva Check addr in case of Read Access in mpIFTXFifo
property mpIFTXFifo_CheckAddrInRead_prop;
@(posedge mpIFClk)
  disable iff(!mpIFClkHardRst_n)
  mpIFTxFIFOReadEn |-> (^mpIFTxFIFOReadAddr !== 1'bX);
endproperty
mpIFTXFifo_CheckAddrInRead: assert property (mpIFTXFifo_CheckAddrInRead_prop); 


//$rw_sva Check addr and data in case of Write Access in mpIFRxFIFO
property mpIFRxFIFO_CheckAddrAndDataInWrite_prop;
@(posedge mpIFClk)
  disable iff(!mpIFClkHardRst_n)
  mpIFRxFIFOWriteEn |-> (^mpIFRxFIFOWriteAddr !== 1'bX && ^mpIFRxFIFOWriteData !== 1'bX);
endproperty
mpIFRxFIFO_CheckAddrAndDataInWrite: assert property (mpIFRxFIFO_CheckAddrAndDataInWrite_prop); 

//$rw_sva Check addr in case of Read Access in mpIFRxFIFO
property mpIFRxFIFO_CheckAddrInRead_prop;
@(posedge macCoreTxClk)
  disable iff(!macCoreClkHardRst_n)
  mpIFRxFIFOReadEn |-> (^mpIFRxFIFOReadAddr !== 1'bX);
endproperty
mpIFRxFIFO_CheckAddrInRead: assert property (mpIFRxFIFO_CheckAddrInRead_prop); 


//$rw_sva Check addr in case of Write Access in txFifo
property txFifo_CheckAddrInWrite_prop;
@(posedge macPITxClk)
  disable iff(!macPIClkHardRst_n)
  txFIFOWriteEn |-> (^txFIFOWriteAddr !== 1'bX);
endproperty
txFifo_CheckAddrInWrite: assert property (txFifo_CheckAddrInWrite_prop); 

//$rw_sva Check data in case of Write Access in txFifo
property txFifo_CheckDataInWrite_prop;
@(posedge macPITxClk)
  disable iff(!macPIClkHardRst_n)
  txFIFOWriteEn |-> (^(txFIFOWriteData & {{6{1'b1}},{8{txFIFOWriteData[35]}},{8{txFIFOWriteData[34]}},{8{txFIFOWriteData[33]}},{8{txFIFOWriteData[32]}}}) !== 1'bX);
endproperty
txFifo_CheckDataInWrite: assert property (txFifo_CheckDataInWrite_prop); 

//$rw_sva Check addr in case of Read Access in txFifo
property txFifo_CheckAddrInRead_prop;
@(posedge macCoreTxClk)
  disable iff(!macCoreClkHardRst_n)
  txFIFOReadEn |-> (^txFIFOReadAddr !== 1'bX);
endproperty
txFifo_CheckAddrInRead: assert property (txFifo_CheckAddrInRead_prop); 


//$rw_sva Check addr and data in case of Write Access in rxFifo
property rxFifo_CheckAddrAndDataInWrite_prop;
@(posedge macCoreTxClk)
  disable iff(!macCoreClkHardRst_n)
  rxFIFOWriteEn |-> (^rxFIFOWriteAddr !== 1'bX && ^rxFIFOWriteData !== 1'bX);
endproperty
rxFifo_CheckAddrAndDataInWrite: assert property (rxFifo_CheckAddrAndDataInWrite_prop); 

//$rw_sva Check addr in case of Read Access in rxFifo
property rxFifo_CheckAddrInRead_prop;
@(posedge macPIRxClk)
  disable iff(!macPIClkHardRst_n)
  rxFIFOReadEn |-> (^rxFIFOReadAddr !== 1'bX);
endproperty
rxFifo_CheckAddrInRead: assert property (rxFifo_CheckAddrInRead_prop); 


//$rw_sva Check addr and data in case of Write Access in keyStorage
property keyStorage_CheckAddrAndDataInWrite_prop;
@(posedge macCoreClk)
  disable iff(!macCoreClkHardRst_n)
  keyStorageWriteEn |-> (keyStorageEn === 1 && ^keyStorageAddr !== 1'bX && ^keyStorageWriteData !== 1'bX);
endproperty
keyStorage_CheckAddrAndDataInWrite: assert property (keyStorage_CheckAddrAndDataInWrite_prop); 

//$rw_sva Check addr in case of Read Access in keyStorage
property keyStorage_CheckAddrInRead_prop;
@(posedge macCoreClk)
  disable iff(!macCoreClkHardRst_n)
  keyStorageEn |-> (^keyStorageAddr !== 1'bX);
endproperty
keyStorage_CheckAddrInRead: assert property (keyStorage_CheckAddrInRead_prop); 


`ifdef RW_MAC_MIBCNTL_EN

//$rw_sva Check addr and data in case of Write Access in mibTable
property mibTable_CheckAddrAndDataInWrite_prop;
@(posedge macCoreClk)
  disable iff(!macCoreClkHardRst_n)
  mibTableWriteEn |-> (mibTableEn === 1 && ^mibTableAddr !== 1'bX && ^mibTableWriteData !== 1'bX);
endproperty
mibTable_CheckAddrAndDataInWrite: assert property (mibTable_CheckAddrAndDataInWrite_prop); 

//$rw_sva Check addr in case of Read Access in mibTable
property mibTable_CheckAddrInRead_prop;
@(posedge macCoreClk)
  disable iff(!macCoreClkHardRst_n)
  mibTableEn |-> (^mibTableAddr !== 1'bX);
endproperty
mibTable_CheckAddrInRead: assert property (mibTable_CheckAddrInRead_prop); 

`endif // RW_MAC_MIBCNTL_EN


//$rw_sva Check addr and data in case of Write Access in sbox
property sbox_CheckAddrAndDataInWrite_prop;
@(posedge macWTClk)
  disable iff(!macWTClkHardRst_n)
  sboxMemWrEn |-> (^sboxMemWrAddr !== 1'bX && ^sboxMemWrData !== 1'bX);
endproperty
sbox_CheckAddrAndDataInWrite: assert property (sbox_CheckAddrAndDataInWrite_prop); 

//$rw_sva Check addr in case of Read Access in sbox
property sbox_CheckAddrInRead_prop;
@(posedge macWTClk)
  disable iff(!macWTClkHardRst_n)
  sboxMemRdEn |-> (^sboxMemRdAddr !== 1'bX);
endproperty
sbox_CheckAddrInRead: assert property (sbox_CheckAddrInRead_prop); 


`endif
endmodule
                 
