//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : Top level of txController module
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module txController ( 
          //$port_g Clock and Reset interface
          input  wire        macCoreClk,            // MAC Core Clock
          input  wire        macCoreTxClk,          // MAC Core Transmit Clock
          input  wire        macCoreClkHardRst_n,   // Hard Reset of the MAC Core Clock domain 
                                                    // active low
          input  wire        macCoreTxClkSoftRst_n, // Soft Reset of the MAC Core Clock domain 
                                                    // active low
`ifdef  RW_BFMEE_EN
          output wire        macCoreBfrRxClkEn,     // Indicates that the RX Clock must be enabled
                                                    // for the BFR Report Read on MPIF
`endif//RW_BFMEE_EN
          //$port_g MAC Controller interface
          input  wire        sendData_p,            // Indication that data packet has to be sent
          input  wire        sendRTS_p,             // Indication that an RTS packet has to be sent
          input  wire        sendCTS_p,             // Indication that a CTS packet has to be sent
          input  wire        sendACK_p,             // Indication that an ACK packet has to be sent
          input  wire        sendCFEND_p,           // Indication that a CF-END packet has to be sent
          input  wire        sendBA_p,              // Indication that an Block ACK packet has to be sent
`ifdef RW_BFMEE_EN
          input  wire        sendBFR_p,             // Indication that an Beamforming report packet has to be sent
`endif //RW_BFMEE_EN
          input  wire        sendBQR_p,             // Indication that an BQR packet has to be sent
          input  wire        sendSWTB_p,            // Indicates that an SW Trigger based frame has
                                                    // to be sent
          input  wire        skipMPDU_p,            // Indication that MPDU in TX FIFO has to be discarded
          input  wire        sendOnSIFS,            // If set, data is sent on tickSIFS else on tickSlot
          input  wire        sendOnPIFS,            // If set, data is sent on tickPIFS

          input  wire [47:0] destAddr,              // Receiver address
          input  wire [47:0] srcAddr,               // Source address
          input  wire [15:0] duration,              // Duration
          input  wire        retry,                 // Indicates that the trame is a retry.
          input  wire [15:0] tsfDuration,           // Duration from the preamble until the first bit of TSF
          output wire  [3:0] txTID,                 // TID of the transmitted frame
          output wire  [1:0] typeTx,                // TYPE of the transmitted frame
          output wire        typeTxValid,           // Indicates the typeTx signal is valid
          output wire        txAMSDUPresent,        // Indicates than the transmitted frame is an A-MSDU
          output wire        txBcMc,                // Indicates than the transmitted frame has a group address.

          input  wire  [6:0] txMCS,                 // MCS (Only used for HT frame)
          input  wire [11:0] txLegLength,           // Legacy Length of the PPDU         
          input  wire [ 3:0] txLegRate,             // Legacy Rate of the PPDU.         
          input  wire  [1:0] txChBW,                // Transmit a Frame with Channel Bandwidth
          input  wire        txDynBW,               // Transmit a Frame with dynamic bandwidth
          input  wire        txBWSignaling,         // Transmit a Frame with BW signaling 
          input  wire [19:0] txHTLength,            // Length of the HT PPDU         
          input  wire        txSTBC,                // Transmit a Frame with Space Time Block Coding
          input  wire  [6:0] txTxopDuration,        // Transmit a Frame with TXOP Duration
          input  wire        txDisambiguityBit,     // Transmit a Frame with disambiguityBit
          input  wire        txResp,                // Transmit a Response Frame
          input  wire        txFromHD,              // Transmit a HW generated frame based on THD
          input  wire        txFromFifo,            // Transmit a Frame from Tx FIFO
          input  wire        txCFEND,               // Transmit a HW generated CFEND frame
          output wire        txDone_p,              // Indicates the completion of the transmission
          output wire        mpduDone_p,            // indicates that the MPDU packet has been sent (including padding and blank delimiter if any)
          output wire        sentCFEND,             // Indicates that the transmitted frame is a CF-END
          output wire        sentRTS,               // Indicates that the transmitted frame is a RTS
          output wire        sentBAReq,             // Indicates that the transmitted frame is a BA-Request
          output wire        sentNDP,               // Indicates that the frame is a NDP
`ifdef RW_BFMER_EN
          output wire        sentBFRPOLL,           // Indicates that the frame is a BFR POLL
`endif // RW_BFMER_EN
          output wire        skipMPDUDone_p,        // Indicates that MPDU contained in the TXFIFO has been discarded.

          input  wire  [7:0] respTxAntennaSet,      // Response Transmission with Antenna Set
          input  wire  [7:0] respTxSMMIndex,        // Response Transmission with Spatial Map Matrix Index
          input  wire        respTxPreType,         // Response Transmission with Preamble Type
                                                    // 1'b0: SHORT
                                                    // 1'b1: LONG
          input  wire  [3:0] respTxFormatMod,       // Response Transmission with Format and Modulation
                                                    // 4'b0000: NON-HT
                                                    // 4'b0001: NON-HT-DUP-OFDM
                                                    // 4'b0010: HT-MF
                                                    // 4'b0011: HT-GF
                                                    // 4'b0100: VHT
                                                    // 4'b0101: HE-SU
                                                    // 4'b0110: HE-MU
                                                    // 4'b0111: HE-EXT-SU
                                                    // 4'b1000: HE-TB
          input  wire        respTxAMPDU,           // Response Transmission with A-MPDU
          input  wire        respTxSMPDU,           // Response Transmission with S-MPDU
          input  wire [14:0] respMPDUFrameLengthTx, // MPDU Length of the A-MPDU response
          input  wire  [1:0] respTxNumExtnSS,       // Response Transmission with Number of Extension Spatial Streams
          input  wire        respTxFECCoding,       // Response Transmission with FEC Coding      
          input  wire  [2:0] respTxNTx,             // Response Transmission with Number of Transmit Chains for PPDU        
          input  wire  [1:0] respTxGIType,          // Response Transmission with Short Guard Interval
          input  wire  [7:0] respTxPwrLevel,        // Response Transmission with Transmit power level
          input  wire  [1:0] respTxHELTFType,       // Response Transmission with HE LTF Type
          input  wire        respTxDoppler,         // Response Transmission with Doppler
          input  wire        respTxMidamble,        // Response Transmission with Midamble
          input  wire  [5:0] respTxBSSColor,        // Response Transmission with BSS Color
          input  wire        respTxDcm,             // Response Transmission with DCM
          input  wire  [3:0] respTxSpatialReuse1,   // Response Transmission with Spatial Reuse 1
          input  wire  [3:0] respTxSpatialReuse2,   // Response Transmission with Spatial Reuse 2
          input  wire  [3:0] respTxSpatialReuse3,   // Response Transmission with Spatial Reuse 3
          input  wire  [3:0] respTxSpatialReuse4,   // Response Transmission with Spatial Reuse 4
          input  wire  [8:0] respTxHESigAReserved,  // Response Transmission with HE SIG-A Reserved bits
          input  wire  [2:0] respTxNumHeLtf,        // Response Transmission with Number of HE LTF
          input  wire        respTxHELtfMode,       // Response Transmission with HE LTF Mode
          input  wire        respTxLDPCExtraSymbol, // Response Transmission with LDPC extra symbol
          input  wire  [2:0] respTxStartingSTSNum,  // Response Transmission with Starting STS Number
          input  wire  [7:0] respTxRUAllocation,    // Response Transmission with RU allocation
          input  wire  [2:0] respTxPacketExtension, // Response Transmission with Packet Extension
          input  wire        respTxTriggerMethod,   // Response Transmission with trigger method
          input  wire  [6:0] respTxRUToneSetIndex,  // Response Transmission with RU tone set index
          input  wire        respTxFeedBackStatus,  // Response Transmission with feedback status
          input  wire        respTxTriggerResponding,//Response Transmission with Trigger Responding
          input  wire        respTxBeamChange,      // Response Transmission with Beam Change
          input  wire  [7:0] acBitmap,              // Available channel bitmap
          input  wire  [5:0] ulPwrHeadroom,         // Uplink Power Headroom
          input  wire        txUPHControl,          // Uplink Power Headroom HT control field is
                                                    // present

          //$port_g BFR Controller interface
`ifdef RW_BFMEE_EN
          input  wire [14:0] bfrLength,             // Beamforming report frame length
          input  wire  [2:0] bfrNr,                 // Beamforming report Nr Index
          input  wire  [2:0] bfrNc,                 // Beamforming report Nc Index
          input  wire  [1:0] bfrChBW,               // Beamforming report Channel Width
          input  wire  [1:0] bfrFeedbackType,       // Beamforming report Feedback Type
          input  wire        bfrHE,                 // Beamforming report Format (VHT or HE)
          input  wire  [6:0] bfrRUStartIndex,       // Beamforming report RU Start Index
                                                    // (Only for HE BFR)
          input  wire  [6:0] bfrRUEndIndex,         // Beamforming report RU End Index
                                                    // (Only for HE BFR)
          input  wire  [5:0] bfrSoundingDialToken,  // Beamforming report Sounding Dialog Token Number
          input  wire        bfrCodebook,           // Beamforming report Codebook Information
          input  wire  [1:0] bfrGrouping,           // Beamforming report Grouping
`endif //RW_BFMEE_EN

          //$port_g Key Search Engine interface
          output wire        txKeySearchIndexTrig_p,// Trigs the Key Search Engine for a Key
                                                    // Research based on index.
          input  wire        keyStorageValid_p,     // Indicates when the Key Search Engine has
                                                    // returned the result 
          input  wire  [2:0] cTypeKSR,              // Indicates the type of encryption
                                                    // 0 : No Key
                                                    // 1 : WEP
                                                    // 2 : TKIP
                                                    // 3 : CCMP
                                                    // 5 : GCMP
          input  wire  [1:0] cLenKSR,               // Indicates the cypher length of encryption

          //$port_g Encryption Engine interface
          
          // Shared by all encrypt mode
          output wire        txCsIsIdle,            // Indicates the FSM is out of IDLE
          output wire [15:0] txDataLength,          // Indicate the Tx Data to encrypted Length
          output wire [47:0] txCCMPTKIPSeqCnt,      // Packet Number for TKIP and CCMP

          // Plain Data
          output wire  [7:0] txPlainData,           // Plain data out
          output wire        txPlainDataValid,      // Plain data valid
          output wire        txPlainDataEnd,        // Last byte valid
          input  wire        txPlainDataReady,      // Plain data ready

          // Encrypted Data
          input  wire  [7:0] txEncrData,            // Encrypted data in
          input  wire        txEncrDataValid,       // Encrypted data in Valid
          input  wire        txEncrDataEnd_p,       // Encrypted data in the last byte
          output wire        txEncrDataReady,       // Encrypted data Ready

          //Encryption Init
          output wire        initEncrTxCntrl_p,     // Pulse to init the Encryption Engine 
          input  wire        cryptoInitDone_p,      // Indicates crypto Engine has finished initialization  

          // WEP Only
          output wire [23:0] txWEPIV,               // WEP IV

          // CCMP Only
          output wire        txAddress4Pres,        // Address 4 is present
          output wire        txQoSFrame,             // Frame is QoS
          output wire [15:0] txFrameControl,        // MAC Header Frame Control Field
          output wire [47:0] txAddr1,               // Address 1 Value
          output wire [47:0] txAddr2,               // Address 2 Value
          output wire [47:0] txAddr3,               // MAC Header Address 3 Field
          output wire [47:0] txAddr4,               // MAC Header Address 4 Field
          output wire [15:0] txQoSCF,               // MAC Header QoS Control Field
          output wire [15:0] txSeqControl,          // MAC Header Seauence Control Field
          output wire        txHTMode,              // HT flag

`ifdef RW_WAPI_EN
          // WAPI Only
          output wire [7:0]  txKeyIdx,              // WAPI Header Key Index
          output wire [127:0] txPN,                  // WAPI Header Packet Number (PN) Field
`endif //RW_WAPI_EN

          //$port_g FCS Block interface
          input  wire        fcsEnd_p,              // Indicates the end of the transmission
          input  wire        fcsBusy,               // Indicates that the FCS block is busy cannot accept new data.
          input  wire        fcsDOutValid,          // Indicates that the fcsDOut is valid.
          input  wire  [7:0] fcsDOut,               // Data from the FCS block
          
          output wire        fcsEnableTx,           // Indicates the begining of the transmission and enable the FCS block
          output wire        fcsStartTx_p,          // Indicates the begining of the transmission and enable the FCS block
          output wire        fcsShiftTx,            // Indicates FCS engine to append FCS calculated on data
          output wire        fcsDInValidTx,         // Indicates that the data on fcsDInTx is valid and can be processed.
          output reg   [7:0] fcsDInTx,              // Data to the FCS block
          output wire        fcsPauseTx,            // Indicates that the FCS block must stop the processing.
        
          //$port_g TX FIFO interface
          input  wire  [1:0] txFIFOMPDUDelimiters,  // MPDU delimiters from TX FIFO
          input  wire  [7:0] txFIFORdData,          // Read Data from TX FIFO
          input  wire        txFIFOEmpty,           // Indicates that the TX FIFO is empty
          input  wire        txFIFODataValid,       // Indicates when the txFIFORdData is Valid
          output wire        txFIFORead,            // Request a new byte from the TX FIFO

          //$port_g Tx Parameters Cache interface
          input  wire        txParameterHDReady_p,  // Indicates if the Header Descriptor fields are usable 
          input  wire        txParameterPTReady_p,  // Indicates if the Policy Table fields are usable 
          input  wire [15:0] MPDUFrameLengthTx,     // Indicates that a DATA packet has to be sent
          input  wire        preTypeProtTx,         // Preamble Type of Protection frame for Transmission
                                                    // 1'b0: SHORT
                                                    // 1'b1: LONG
          input  wire        preTypeTx,             // Preamble Type of PPDU for Transmission
                                                    // Same coding than preTypeTx
          input  wire  [3:0] formatModProtTx,       // Format and Modulation of Protection frame for Transmission
                                                    // 4'b0000: NON-HT
                                                    // 4'b0001: NON-HT-DUP-OFDM
                                                    // 4'b0010: HT-MF
                                                    // 4'b0011: HT-GF
                                                    // 4'b0100: VHT
                                                    // 4'b0101: HE-SU
                                                    // 4'b0110: HE-MU
                                                    // 4'b0111: HE-EXT-SU
                                                    // 4'b1000: HE-TB
          input  wire  [3:0] formatModTx,           // Format and Modulation of PPDU for Transmission
                                                    // Same coding than formatModProtTx
          input  wire  [1:0] txHELTFType,           // HE-LTF Type
          input  wire        txDoppler,             // Doppler of the frame to transmit
          input  wire        txMidamble,            // Midamble of the frame to transmit
          input  wire        txDcm,                 // DCM of the frame to transmit
          input  wire  [7:0] txPwrLevelPT,          // Transmit Power Level
          input  wire  [7:0] txPwrLevelProtPT,      // Transmit Power Level for Protection Frame
          input  wire  [9:0] nBlankMDelimiters,     // Indicates the number of blank MPDU delimiters that are inserted
          input  wire  [8:0] partialAIDTx,          // Partial AID
          input  wire  [5:0] groupIDTx,             // Group ID
          input  wire        dozeNotAllowedTx,      // TXOP PS is not allowed
          input  wire        smoothingProtTxPT,     // Smoothing of Protection frame for Transmission
          input  wire        smoothingTxPT,         // Smoothing of PPDU for Transmission
          input  wire        soundingTxPT,          // Sounding Protection frame for Transmission
          input  wire  [3:0] spatialReusePT,        // Spatial Reuse Information
          input  wire  [2:0] nTxProtPT,             // Number of Transmit Chains for Protection Frame
          input  wire  [2:0] nTxPT,                 // Number of Transmit Chains for PPDU
          input  wire  [1:0] txGIType,              // Guard Interval Type for Transmission
                                                    // When High, it indicates whether a short Guard Interval
          input  wire  [1:0] stbcPT,                // Space Time Block Coding
          input  wire        txFecCoding,           // FEC Coding
          input  wire  [1:0] numExtnSSPT,           // Number of Extension Spatial Streams
          input  wire  [2:0] txPacketExtension,     // Packet Extension Value
          input  wire  [5:0] bssColorPT,            // BSS Color
          input  wire        upLinkFlagPT,          // UP Link Flag
          input  wire        beamChangePT,          // Beam Change
          input  wire        beamFormedPT,          // BeamFormed frame
          input  wire  [7:0] smmIndexPT,            // Spatial Map Matrix Index
          input  wire  [7:0] antennaSetPT,          // Antenna Set
          input  wire        dontGenerateMH,        // Indicates that HW should not generate the MAC Header by itself
          input  wire        dontEncrypt,           // Indicates that HW should bypassed the encryption operation during tx.
          input  wire        dontTouchFC,           // Indicates that HW should not update the Frame Control field,
          input  wire        dontTouchDur,          // Indicates that HW should not update the Duration field
          input  wire        dontTouchQoS,          // Indicates that HW should not update the QoS field 
          input  wire        dontTouchHTC,          // Indicates that HW should not update the HTC field 
          input  wire        dontTouchTSF,          // Indicates that HW should not update the TSF field 
          input  wire        dontTouchDTIM,         // Indicates that HW should not update the DTIM Count field
          input  wire        dontTouchFCS,          // Indicates that HW should not update the FCS field
          input  wire        aMPDU,                 // Indicates whether this Transmit Header Descriptor belong to an A-MPDU
          input  wire  [1:0] whichDescriptor,       // Indicates what kind of a descriptor this is
          input  wire        txSMPDU,               // Detect S-MPDU

          //$port_g RX Controller interface
          input  wire  [3:0] rxTID,                 // TID of the received frame

          //$port_g BA Controller
          input  wire  [7:0] psBitmap,              // PS Bitmap field
          input  wire        psBitmapValid,         // PS Bitmap field valid          
          
          output wire        psBitmapReady,         // PS Bitmap field request

`ifdef RW_BFMEE_EN
          //$port_g Beamforming Report HW Accelerator
          input  wire  [7:0] bfrData,               // Beamforming report byte
          input  wire        bfrDataValid,          // Beamforming report byte valid          
          
          output wire        bfrDataReady,          // Beamforming report byte request
`endif //RW_BFMEE_EN

          //$port_g Timers Block interface
          input  wire [63:0] tsf,                   // TSF timer value
          input  wire        tickSIFS_p,            // A pulse to indicate the end of SIFS period
          input  wire        tickPIFS_p,            // A pulse to indicate the end of PIFS period
          input  wire        tickSlot_p,            // A pulse to indicate the end of a slot period
          input  wire  [7:0] dtimCnt,               // DTIM count maintained in hardware
          
          
          //$port_g Deaggregator interface
          input  wire        rxVector1Valid_p,      // A pulse to indicate the beginning of a reception

          //$port_g MAC-PHY-IF Block interface
          input  wire        mpIfTxFifoFull,        // MAC-PHY FIFO status                      
          input  wire        mpIfTxErr_p,           // Transmit error 
          input  wire        mpIfTxEn,              // Transmit on-going indication 
          input  wire        txRxExchangeEnabled,   // Transmit/Receive on-going indication 

          output wire        startTx_p,             // Start Tx trigger                 
          output wire        stopTx_p,              // Stop Tx trigger                  

          output wire  [7:0] mpIfTxFifoData,        // Data to transmit                 
          output wire        mpIfTxFifoWrite,       // Data valid                       

          output wire  [1:0] heLTFType,             // HE-LTF Type
          output wire  [7:0] txPwrLevel,            // Transmit power Level
          output wire  [2:0] chBW,                  // Channel Bandwidth        
          output wire        smoothing,             // Smoothing Recommended or Not
          output wire  [2:0] packetExtension,       // Packet Extension Value
          output wire  [5:0] bssColor,              // BSS Color
          output wire  [6:0] txopDuration,          // TXOP Duration
          output wire        triggerResponding,     // Trigger Responding
          output wire        upLinkFlag,            // UP Link Flag
          output wire        beamChange,            // Beam Change
          output wire        dcm,                   // Dual Carrier Modulation
          output wire        beamFormed,            // BeamFormed frame
          output wire  [7:0] antennaSet,            // Antenna Set
          output wire  [7:0] smmIndex,              // Spatial Map Matrix Index
          output wire  [6:0] mcs,                   // MCS (Only used for HT/VHT frame)
          output wire        preType,               // Preamble Type
                                                    // 1'b0: SHORT
                                                    // 1'b1: LONG
          output wire  [3:0] formatMod,             // Format and Modulation         
                                                    // 4'b0000: NON-HT
                                                    // 4'b0001: NON-HT-DUP-OFDM
                                                    // 4'b0010: HT-MF
                                                    // 4'b0011: HT-GF
                                                    // 4'b0100: VHT
                                                    // 4'b0101: HE-SU
                                                    // 4'b0110: HE-MU
                                                    // 4'b0111: HE-EXT-SU
                                                    // 4'b1000: HE-TB
          output wire  [1:0] numExtnSS,             // Number of Extension Spatial Streams         
          output wire        stbc,                  // Space Time Block Coding         
          output wire        disambiguityBit,       // disambiguity Bit value
          output wire        fecCoding,             // FEC Coding
          output wire  [8:0] partialAID,            // Partial AID
          output wire  [5:0] groupID,               // Group ID
          output wire        dozeNotAllowed,        // TXOP PS is not allowed
          output wire        sounding,              // Indicates whether this PPDU is Sounding         
          output wire [11:0] legLength,             // Legacy Length of the PPDU         
          output wire [ 3:0] legRate,               // Legacy Rate of the PPDU.         
          output wire [15:0] service,               // Scrambler initialization
          output wire [19:0] htLength,              // Length of the HT PPDU         
          output wire        htLengthValid,         // Length of the HT PPDU is valid
          output wire  [3:0] spatialReuse1,         // Spatial Reuse 1 Information
          output wire  [3:0] spatialReuse2,         // Spatial Reuse 2 Information
          output wire  [3:0] spatialReuse3,         // Spatial Reuse 3 Information
          output wire  [3:0] spatialReuse4,         // Spatial Reuse 4 Information
          output wire  [8:0] heSigAReserved,        // HE SIG-A Reserved bits
          output wire  [2:0] numHeLtf,              // Number of HE LTF
          output wire        heLtfMode,             // HE LTF Mode
          output wire        ldpcExtraSymbol,       // LDPC extra symbol
          output wire  [2:0] startingSTSNum,        // Starting STS Number
          output wire        sigBCompressionMode,   // SIG-B compression mode
          output wire        dcmSigB,               // Dual carrier modulation on SIG-B
          output wire  [2:0] mcsSigB,               // MCS of SIG-B
          output wire [31:0] ruAllocation,          // RU allocation
          output wire        triggerMethod,         // trigger method
          output wire  [6:0] ruToneSetIndex,        // RU tone set index
          output wire        feedBackStatus,        // feedback status
          output wire        doppler,               // Doppler
          output wire        midamble,              // Midamble
          output wire [ 2:0] nTx,                   // Number of Transmit Chains         
          output wire  [1:0] giType,                // Guard Interval Type
          output wire        aggreation,            // MPDU Aggregate         

          //$port_g HW Error interface
          input  wire        hwErr,                 // HW error detected
          
          //$port_g CSReg Block interface
          input  wire [47:0] bssID,                 // BSS ID
          input  wire  [7:0] timOffset,             // Indicates to the HW the offset, from the first byte of the Beacon frame, 
                                                    // at which the first byte of the TIM field is located
          input  wire        pwrMgt,                // Power Management is enabled for the current
                                                    // transmission
          input  wire  [7:0] dsssMaxPwrLevel,       // Maximum Power Level for DSSS/CCK
          input  wire  [7:0] ofdmMaxPwrLevel,       // Maximum Power Level for OFDM frames
          input  wire [15:0] bbServiceA,            // Service field when the modulation is OFDM.
          input  wire [ 7:0] bbServiceB,            // Service field when the modulation is DSSS/CCK.
          //$port_g Backoff interface
          input  wire  [2:0] activeAC,              // Indicates Access category which has currently won contention

          //$port_g SR Controller
          input  wire        obssPDSRPeriod,        // Indicates that an OBSS PD SR power
                                                    // restriction period
          input  wire  [7:0] obssPDSRPeriodTxPwrMax,// Indicates the maximum transmit power of the 
                                                    // OBSS PD SR power restriction period

          //$port_g Debug interface
          output reg   [8:0] txControlCs,           // Current state of the TX Controller FSM
          output reg   [8:0] txControlLs,           // State of the TX Controller FSM captured when the HW Error happened
          output reg  [15:0] debugPortTxFrameDebug1,// Tx Frame Debug 1
          output reg  [15:0] debugPortTxFrameDebug2 // Tx Frame Debug 2
                 );


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
wire        ctsDone_p;
wire        ctsTxStart_p;
wire        ctsFCSEnable;
wire        ctsFCSStart_p;
wire        ctsFCSShiftTx;
wire  [7:0] ctsFCSDInTx;    
wire        ctsFCSDInValidTx;

wire        rtsDone_p;
wire        rtsTxStart_p;
wire        rtsFCSEnable;
wire        rtsFCSStart_p;
wire        rtsFCSShiftTx;
wire  [7:0] rtsFCSDInTx;    
wire        rtsFCSDInValidTx;

wire        ackDone_p;
wire        ackStart_p;
wire        ackFCSEnable;
wire        ackFCSStart_p;
wire        ackFCSShiftTx;
wire  [7:0] ackFCSDInTx;    
wire        ackFCSDInValidTx;

wire        cfendDone_p;
wire        cfendTxStart_p;
wire        cfendFCSEnable;
wire        cfendFCSStart_p;
wire        cfendFCSShiftTx;
wire  [7:0] cfendFCSDInTx;    
wire        cfendFCSDInValidTx;

wire        baDone_p;
wire        baStart_p;
wire        baFCSEnable;
wire        baFCSStart_p;
wire        baFCSShiftTx;
wire  [7:0] baFCSDInTx;    
wire        baFCSDInValidTx;

wire        qosnullDone_p;
wire        qosnullStart_p;
wire        qosnullFCSEnable;
wire        qosnullFCSStart_p;
wire        qosnullFCSShiftTx;
wire  [7:0] qosnullFCSDInTx;    
wire        qosnullFCSDInValidTx;
wire        sendBQR;

`ifdef RW_BFMEE_EN
wire        bfrStart_p;
wire        bfrDone_p;
`endif //RW_BFMEE_EN
wire        bfrFCSEnable;
wire        bfrFCSStart_p;
wire        bfrFCSShiftTx;
wire  [7:0] bfrFCSDInTx;    
wire        bfrFCSDInValidTx;

wire        mpduTxStart_p;
wire        mpduFCSEnable;
wire        mpduFCSStart_p;
wire        mpduFCSShiftTx;
wire  [7:0] mpduFCSDInTx;    
wire        mpduFCSDInValidTx;

wire        sendMPDU_p;
wire        sendSWTB;
wire        aMPDUPaddingStart_p;
wire        aMPDUDelimiterStart_p;
wire        aMPDUBlankDelimiterStart_p;
wire  [3:0] aMPDUFormatMod;
wire [13:0] aMPDUDelMPDULength;
wire        aMPDUDelEOF;
wire        aMPDUDelimiterDone_p;
wire        aMPDUPaddingDone_p;
wire        aMPDUBlankDelimiterDone_p;

wire  [7:0] aMPDUDelimiterData;  
wire        aMPDUDelimiterWriteEn;  

`ifdef RW_BFMEE_EN
wire  [3:0] formatBFRFSMCs;         // formatBFRFSM FSM Current State
`endif //RW_BFMEE_EN
wire  [2:0] formatACKFSMCs;         // formatACKFSM FSM Current State
wire  [3:0] formatBAFSMCs;          // formatBAFSM FSM Current State
wire  [1:0] formatAMPDUDelFSMCs;    // formatAMPDUDelFSM FSM Current State
wire  [3:0] formatCFENDFSMCs;       // formatCFENDFSM FSM Current State
wire  [2:0] formatCTSFSMCs;         // formatCTSFSM FSM Current State
wire  [4:0] formatMPDUFSMCs;        // formatMPDUFSM FSM Current State
wire  [3:0] formatRTSFSMCs;         // formatRTSFSM FSM Current State
wire  [3:0] formatQOSNULLFSMCs;     // formatQOSNULLFSM FSM Current State

wire  [4:0] txControlMainFSMCs;     // txControlMainFSM FSM Current State
//reg   [3:0] txControlMainFSMCapt;   // txControlMainFSM FSM Current State capture when the transmission is done

wire        mpduSeqCtrlDone_p;      // Indicates that the sequence number has been transmitted
wire        currentMPDUDone_p;      // indicates that the Data packet has been sent

wire [14:0] formatMPDUFrameDebug1; // frame Debug 1 from formatMPDU module
wire [14:0] formatMPDUFrameDebug2; // frame Debug 2 from formatMPDU module

reg         tickSIFS;              // Captured version of tickSIFS_p
reg         tickSlot;              // Captured version of tickSlot_p
reg         tickPIFS;              // Captured version of tickPIFS_p

wire        stopTxInt_p;           // Stop Tx;
wire        swtbReady_p;           // Indicates that the Header Descriptor of the
                                   // software TB frame is ready

wire        ctsPwrMgt;             // pwrMgt bit for the CTS frame transmission

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Force the macPhyIF to stop the transmission in case of error.
assign stopTx_p = stopTxInt_p | hwErr;

// Force the CTS pwrMgt bit to '0' when CTS response to an trigger frame.
assign ctsPwrMgt = (txResp && respTxTriggerResponding) ? 1'b0 : pwrMgt;

// Instanciation of txControllerMainFSM
// Name of the instance : U_txControllerMainFSM
// Name of the file containing this module : txControllerMainFSM.v
txControllerMainFSM U_txControllerMainFSM (
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    .sendData_p                       (sendData_p),
    .sendRTS_p                        (sendRTS_p),
    .sendCTS_p                        (sendCTS_p),
    .sendACK_p                        (sendACK_p),
    .sendCFEND_p                      (sendCFEND_p),
    .sendBA_p                         (sendBA_p),
`ifdef RW_BFMEE_EN
    .sendBFR_p                        (sendBFR_p),
`endif //RW_BFMEE_EN
    .sendBQR_p                        (sendBQR_p),
    .sendSWTB_p                       (sendSWTB_p),
    .sendOnSIFS                       (sendOnSIFS),
    .txDone_p                         (txDone_p),
    .respTxFormatMod                  (respTxFormatMod),
    .respTxAMPDU                      (respTxAMPDU),
    .respTxSMPDU                      (respTxSMPDU),
    .respMPDUFrameLengthTx            (respMPDUFrameLengthTx),
    .txParameterHDReady_p             (txParameterHDReady_p),
    .txParameterPTReady_p             (txParameterPTReady_p),
    .aMPDU                            (aMPDU),
    .txSMPDU                          (txSMPDU),
    .MPDUFrameLengthTx                (MPDUFrameLengthTx),
    .formatModTx                      (formatModTx),
    .nBlankMDelimiters                (nBlankMDelimiters),
    .whichDescriptor                  (whichDescriptor),
    .tickSlot                         (tickSlot),
    .tickSIFS                         (tickSIFS),
    .rtsDone_p                        (rtsDone_p),
    .ctsDone_p                        (ctsDone_p),
    .ackDone_p                        (ackDone_p),
    .cfendDone_p                      (cfendDone_p),
    .baDone_p                         (baDone_p),
`ifdef RW_BFMEE_EN
    .bfrDone_p                        (bfrDone_p),
`endif //RW_BFMEE_EN
    .qosnullDone_p                    (qosnullDone_p),
    .currentMPDUDone_p                (currentMPDUDone_p),
    .mpduDone_p                       (mpduDone_p),
    .rtsTxStart_p                     (rtsTxStart_p),
    .ctsTxStart_p                     (ctsTxStart_p),
    .cfendTxStart_p                   (cfendTxStart_p),
//  .qosnullTxStart_p                 (qosnullTxStart_p),
    .mpduTxStart_p                    (mpduTxStart_p),
    .aMPDUDelimiterDone_p             (aMPDUDelimiterDone_p),
    .aMPDUBlankDelimiterDone_p        (aMPDUBlankDelimiterDone_p),
    .aMPDUPaddingDone_p               (aMPDUPaddingDone_p),
    .aMPDUPaddingStart_p              (aMPDUPaddingStart_p),
    .aMPDUDelimiterStart_p            (aMPDUDelimiterStart_p),
    .aMPDUBlankDelimiterStart_p       (aMPDUBlankDelimiterStart_p),
    .aMPDUFormatMod                   (aMPDUFormatMod),
    .aMPDUDelMPDULength               (aMPDUDelMPDULength),
    .aMPDUDelEOF                      (aMPDUDelEOF),
    .sendBQR                          (sendBQR),
    .sendMPDU_p                       (sendMPDU_p),
    .sendSWTB                         (sendSWTB),
`ifdef RW_BFMEE_EN
    .bfrStart_p                       (bfrStart_p),
`endif //RW_BFMEE_EN
    .ackStart_p                       (ackStart_p),
    .baStart_p                        (baStart_p),
    .qosnullStart_p                   (qosnullStart_p),
    .mpIfTxErr_p                      (mpIfTxErr_p),
    .mpIfTxEn                         (mpIfTxEn),
    .startTx_p                        (startTx_p),
    .stopTx_p                         (stopTxInt_p),
    .swtbReady_p                      (swtbReady_p),
    .txKeySearchIndexTrig_p           (txKeySearchIndexTrig_p),
    .keyStorageValid_p                (keyStorageValid_p),
    .txControlMainFSMCs               (txControlMainFSMCs)
    );


// Instanciation of formatACK
// Name of the instance : U_formatACK
// Name of the file containing this module : formatACK.v
formatACK U_formatACK (
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    .destAddr                         (destAddr),
    .duration                         (duration),
    .ackStart_p                       (ackStart_p),
    .ackDone_p                        (ackDone_p),
    .fcsEnd_p                         (fcsEnd_p),
    .fcsBusy                          (fcsBusy),
    .ackFCSEnable                     (ackFCSEnable),
    .ackFCSStart_p                    (ackFCSStart_p),
    .ackFCSShiftTx                    (ackFCSShiftTx),
    .ackFCSDInTx                      (ackFCSDInTx),
    .ackFCSDInValidTx                 (ackFCSDInValidTx),
    .tickSIFS                         (tickSIFS),
    .pwrMgt                           (pwrMgt),
    .formatACKFSMCs                   (formatACKFSMCs)
    );


// Instanciation of formatAMPDUDelimiter
// Name of the instance : U_formatAMPDUDelimiter
// Name of the file containing this module : formatAMPDUDelimiter.v
formatAMPDUDelimiter U_formatAMPDUDelimiter (
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    .aMPDUPaddingStart_p              (aMPDUPaddingStart_p),
    .aMPDUDelimiterStart_p            (aMPDUDelimiterStart_p),
    .aMPDUBlankDelimiterStart_p       (aMPDUBlankDelimiterStart_p),
    .aMPDUDelimiterDone_p             (aMPDUDelimiterDone_p),
    .aMPDUBlankDelimiterDone_p        (aMPDUBlankDelimiterDone_p),
    .aMPDUPaddingDone_p               (aMPDUPaddingDone_p),
    .nBlankMDelimiters                (nBlankMDelimiters),
    .aMPDUFormatMod                   (aMPDUFormatMod),
    .aMPDUDelMPDULength               (aMPDUDelMPDULength),
    .aMPDUDelEOF                      (aMPDUDelEOF),
    .mpIfTxFifoFull                   (mpIfTxFifoFull),
    .aMPDUDelimiterData               (aMPDUDelimiterData),
    .aMPDUDelimiterWriteEn            (aMPDUDelimiterWriteEn),
    .formatAMPDUDelFSMCs              (formatAMPDUDelFSMCs)
    );


// Instanciation of formatCFEND
// Name of the instance : U_formatCFEND
// Name of the file containing this module : formatCFEND.v
formatCFEND U_formatCFEND (
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    .sendCFEND_p                      (sendCFEND_p),
    .cfendDone_p                      (cfendDone_p),
    .cfendTxStart_p                   (cfendTxStart_p),
    .fcsEnd_p                         (fcsEnd_p),
    .fcsBusy                          (fcsBusy),
    .cfendFCSEnable                   (cfendFCSEnable),
    .cfendFCSStart_p                  (cfendFCSStart_p),
    .cfendFCSShiftTx                  (cfendFCSShiftTx),
    .cfendFCSDInTx                    (cfendFCSDInTx),
    .cfendFCSDInValidTx               (cfendFCSDInValidTx),
    .tickSIFS                         (tickSIFS),
    .bssID                            (bssID),
    .pwrMgt                           (pwrMgt),
    .formatCFENDFSMCs                 (formatCFENDFSMCs)
    );


// Instanciation of formatCTS
// Name of the instance : U_formatCTS
// Name of the file containing this module : formatCTS.v
formatCTS U_formatCTS (
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    .destAddr                         (destAddr),
    .duration                         (duration),
    .sendCTS_p                        (sendCTS_p),
    .sendOnPIFS                       (sendOnPIFS),
    .sendOnSIFS                       (sendOnSIFS),
    .ctsDone_p                        (ctsDone_p),
    .ctsTxStart_p                     (ctsTxStart_p),
    .fcsEnd_p                         (fcsEnd_p),
    .fcsBusy                          (fcsBusy),
    .ctsFCSEnable                     (ctsFCSEnable),
    .ctsFCSStart_p                    (ctsFCSStart_p),
    .ctsFCSShiftTx                    (ctsFCSShiftTx),
    .ctsFCSDInTx                      (ctsFCSDInTx),
    .ctsFCSDInValidTx                 (ctsFCSDInValidTx),
    .tickSIFS                         (tickSIFS),
    .tickSlot                         (tickSlot),
    .tickPIFS                         (tickPIFS),
    .pwrMgt                           (ctsPwrMgt),
    .formatCTSFSMCs                   (formatCTSFSMCs)
    );


// Instanciation of formatMPDU
// Name of the instance : U_formatMPDU
// Name of the file containing this module : formatMPDU.v
formatMPDU U_formatMPDU (
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    .skipMPDU_p                       (skipMPDU_p),
    .duration                         (duration),
    .retry                            (retry),
    .tsfDuration                      (tsfDuration),
    .sendOnSIFS                       (sendOnSIFS),
    .txTID                            (txTID),
    .typeTx                           (typeTx),
    .typeTxValid                      (typeTxValid),
    .txAMSDUPresent                   (txAMSDUPresent),
    .txBcMc                           (txBcMc),
    .sentCFEND                        (sentCFEND),
    .sentRTS                          (sentRTS),
    .sentBAReq                        (sentBAReq),
    .sentNDP                          (sentNDP),
`ifdef RW_BFMER_EN
    .sentBFRPOLL                      (sentBFRPOLL),
`endif // RW_BFMER_EN
    .skipMPDUDone_p                   (skipMPDUDone_p),
    .mpIfTxEn                         (mpIfTxEn),
    .sendMPDU_p                       (sendMPDU_p),
    .sendSWTB                         (sendSWTB),
    .currentMPDUDone_p                (currentMPDUDone_p),
    .mpduTxStart_p                    (mpduTxStart_p),
    .MPDUFrameLengthTx                (MPDUFrameLengthTx),
    .dontGenerateMH                   (dontGenerateMH),
    .dontEncrypt                      (dontEncrypt),
    .dontTouchFC                      (dontTouchFC),
    .dontTouchDur                     (dontTouchDur),
    .dontTouchQoS                     (dontTouchQoS),
    .dontTouchHTC                     (dontTouchHTC),
    .dontTouchTSF                     (dontTouchTSF),
    .dontTouchDTIM                    (dontTouchDTIM),
    .dontTouchFCS                     (dontTouchFCS),
    .aMPDU                            (aMPDU),
    .txSMPDU                          (txSMPDU),
    .txFIFOEmpty                      (txFIFOEmpty),
    .txFIFORdData                     (txFIFORdData),
    .txFIFOMPDUDelimiters             (txFIFOMPDUDelimiters),
    .txFIFODataValid                  (txFIFODataValid),
    .txFIFORead                       (txFIFORead),
    .cTypeKSR                         (cTypeKSR),
    .cLenKSR                          (cLenKSR),
    .formatMod                        (formatModTx),
    .txCsIsIdle                       (txCsIsIdle),
    .txDataLength                     (txDataLength),
    .txCCMPTKIPSeqCnt                 (txCCMPTKIPSeqCnt),
    .txPlainData                      (txPlainData),
    .txPlainDataValid                 (txPlainDataValid),
    .txPlainDataEnd                   (txPlainDataEnd),
    .txPlainDataReady                 (txPlainDataReady),
    .txEncrData                       (txEncrData),
    .txEncrDataValid                  (txEncrDataValid),
    .txEncrDataEnd_p                  (txEncrDataEnd_p),
    .txEncrDataReady                  (txEncrDataReady),
    .initEncrTxCntrl_p                (initEncrTxCntrl_p),
    .cryptoInitDone_p                 (cryptoInitDone_p),
    .txWEPIV                          (txWEPIV),
    .txAddress4Pres                   (txAddress4Pres),
    .txQoSFrame                       (txQoSFrame),
    .txFrameControl                   (txFrameControl),
    .txAddr1                          (txAddr1),
    .txAddr2                          (txAddr2),
    .txAddr3                          (txAddr3),       
    .txAddr4                          (txAddr4),       
    .txQoSCF                          (txQoSCF),       
    .txSeqControl                     (txSeqControl),  
    .txHTMode                         (txHTMode),
    .fcsEnd_p                         (fcsEnd_p),
    .fcsBusy                          (fcsBusy),
`ifdef RW_WAPI_EN
    .txKeyIdx                         (txKeyIdx),      
    .txPN                             (txPN),          
`endif //RW_WAPI_EN
    .mpduFCSEnable                    (mpduFCSEnable),
    .mpduFCSStart_p                   (mpduFCSStart_p),
    .mpduFCSShiftTx                   (mpduFCSShiftTx),
    .mpduFCSDInTx                     (mpduFCSDInTx),
    .mpduFCSDInValidTx                (mpduFCSDInValidTx),
    .tickSIFS                         (tickSIFS),
    .tickSlot                         (tickSlot),
    .dtimCnt                          (dtimCnt),
    .tsf                              (tsf),
    .timOffset                        (timOffset),
    .pwrMgt                           (pwrMgt),
    .activeAC                         (activeAC),
    .formatMPDUFSMCs                  (formatMPDUFSMCs),
    .mpduSeqCtrlDone_p                (mpduSeqCtrlDone_p),
    .formatMPDUFrameDebug1            (formatMPDUFrameDebug1),
    .formatMPDUFrameDebug2            (formatMPDUFrameDebug2)
    );


// Instanciation of formatRTS
// Name of the instance : U_formatRTS
// Name of the file containing this module : formatRTS.v
formatRTS U_formatRTS (
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    .destAddr                         (destAddr),
    .srcAddr                          (srcAddr),
    .duration                         (duration),
    .txBWSignaling                    (txBWSignaling),
    .sendRTS_p                        (sendRTS_p),
    .sendOnPIFS                       (sendOnPIFS),
    .sendOnSIFS                       (sendOnSIFS),
    .rtsDone_p                        (rtsDone_p),
    .rtsTxStart_p                     (rtsTxStart_p),
    .fcsEnd_p                         (fcsEnd_p),
    .fcsBusy                          (fcsBusy),
    .rtsFCSEnable                     (rtsFCSEnable),
    .rtsFCSStart_p                    (rtsFCSStart_p),
    .rtsFCSShiftTx                    (rtsFCSShiftTx),
    .rtsFCSDInTx                      (rtsFCSDInTx),
    .rtsFCSDInValidTx                 (rtsFCSDInValidTx),
    .tickSIFS                         (tickSIFS),
    .tickPIFS                         (tickPIFS),
    .tickSlot                         (tickSlot),
    .pwrMgt                           (pwrMgt),
    .formatRTSFSMCs                   (formatRTSFSMCs)
    );


// Instanciation of formatBA
// Name of the instance : U_formatBA
// Name of the file containing this module : formatBA.v
formatBA U_formatBA (
    .macCoreTxClk                     (macCoreTxClk),
    .macCoreClkHardRst_n              (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n            (macCoreTxClkSoftRst_n),
    .destAddr                         (destAddr),
    .srcAddr                          (srcAddr),
    .duration                         (duration),
    .baStart_p                        (baStart_p),
    .baDone_p                         (baDone_p),
    .rxTID                            (rxTID),
    .fcsEnd_p                         (fcsEnd_p),
    .fcsBusy                          (fcsBusy),
    .baFCSEnable                      (baFCSEnable),
    .baFCSStart_p                     (baFCSStart_p),
    .baFCSShiftTx                     (baFCSShiftTx),
    .baFCSDInTx                       (baFCSDInTx),
    .baFCSDInValidTx                  (baFCSDInValidTx),
    .psBitmap                         (psBitmap),
    .psBitmapValid                    (psBitmapValid),
    .psBitmapReady                    (psBitmapReady),
    .tickSIFS                         (tickSIFS),
    .pwrMgt                           (pwrMgt),
    .formatBAFSMCs                    (formatBAFSMCs)
    );


// Instanciation of formatBFR
// Name of the instance : U_formatBFR
// Name of the file containing this module : formatBFR.v
`ifdef RW_BFMEE_EN
formatBFR U_formatBFR (
     .macCoreTxClk          (macCoreTxClk          ),
     .macCoreClkHardRst_n   (macCoreClkHardRst_n   ),
     .macCoreTxClkSoftRst_n (macCoreTxClkSoftRst_n ),
     .macCoreBfrRxClkEn     (macCoreBfrRxClkEn     ),
     .destAddr              (destAddr              ),
     .srcAddr               (srcAddr               ),
     .duration              (duration              ),
     .ulPwrHeadroom         (ulPwrHeadroom         ),
     .txUPHControl          (txUPHControl          ),
     .bfrLength             (bfrLength             ),
     .bfrNr                 (bfrNr                 ),
     .bfrNc                 (bfrNc                 ),
     .bfrChBW               (bfrChBW               ),
     .bfrFeedbackType       (bfrFeedbackType       ),
     .bfrHE                 (bfrHE                 ),
     .bfrRUStartIndex       (bfrRUStartIndex       ),
     .bfrRUEndIndex         (bfrRUEndIndex         ),
     .bfrSoundingDialToken  (bfrSoundingDialToken  ),
     .bfrCodebook           (bfrCodebook           ),
     .bfrGrouping           (bfrGrouping           ),
     .bfrStart_p            (bfrStart_p            ),
     .bfrDone_p             (bfrDone_p             ),
     .fcsEnd_p              (fcsEnd_p              ),
     .fcsBusy               (fcsBusy               ),
     .bfrFCSEnable          (bfrFCSEnable          ),
     .bfrFCSStart_p         (bfrFCSStart_p         ),
     .bfrFCSShiftTx         (bfrFCSShiftTx         ),
     .bfrFCSDInTx           (bfrFCSDInTx           ),
     .bfrFCSDInValidTx      (bfrFCSDInValidTx      ),
     .bfrData               (bfrData               ),
     .bfrDataValid          (bfrDataValid          ),
     .bfrDataReady          (bfrDataReady          ),
     .pwrMgt                (pwrMgt                ),
     .bssID                 (bssID                 ),
     .formatBFRFSMCs        (formatBFRFSMCs        )
   );

`else  //RW_BFMEE_EN
assign bfrFCSEnable     = 1'b0;
assign bfrFCSStart_p    = 1'b0;
assign bfrFCSShiftTx    = 1'b0;
assign bfrFCSDInTx      = 8'h0;
assign bfrFCSDInValidTx = 1'b0;
`endif //RW_BFMEE_EN


// Instanciation of formatQOSNULL
// Name of the instance : U_formatQOSNULL
// Name of the file containing this module : formatQOSNULL.v
formatQOSNULL U_formatQOSNULL (
    .macCoreTxClk              (macCoreTxClk),
    .macCoreClkHardRst_n       (macCoreClkHardRst_n),
    .macCoreTxClkSoftRst_n     (macCoreTxClkSoftRst_n),
    .destAddr                  (destAddr),
    .srcAddr                   (srcAddr),
    .bssID                     (bssID),
    .duration                  (duration),
    .acBitmap                  (acBitmap),
    .ulPwrHeadroom             (ulPwrHeadroom),
    .txUPHControl              (txUPHControl),
//  .sendBQR                   (sendBQR),
    .qosnullStart_p            (qosnullStart_p),
    .qosnullDone_p             (qosnullDone_p),
    .fcsEnd_p                  (fcsEnd_p),
    .fcsBusy                   (fcsBusy),
    .qosnullFCSEnable          (qosnullFCSEnable),
    .qosnullFCSStart_p         (qosnullFCSStart_p),
    .qosnullFCSShiftTx         (qosnullFCSShiftTx),
    .qosnullFCSDInTx           (qosnullFCSDInTx),
    .qosnullFCSDInValidTx      (qosnullFCSDInValidTx),
    .pwrMgt                    (pwrMgt),
    .formatQOSNULLFSMCs        (formatQOSNULLFSMCs)
    );


// Instanciation of txVectorSel
// Name of the instance : U_txVectorSel
// Name of the file containing this module : txVectorSel.v
txVectorSel U_txVectorSel (               
    .macCoreTxClk              (macCoreTxClk),
    .macCoreClkHardRst_n       (macCoreClkHardRst_n),
    .startTx_p                 (startTx_p),
    .swtbReady_p               (swtbReady_p),
    .sendSWTB                  (sendSWTB),
    .txMCS                     (txMCS),
    .txLegLength               (txLegLength),
    .txLegRate                 (txLegRate),
    .txHTLength                (txHTLength),
    .txResp                    (txResp),
    .txFromHD                  (txFromHD),
    .txSTBC                    (txSTBC),
    .txTxopDuration            (txTxopDuration),
    .txDisambiguityBit         (txDisambiguityBit),
    .txChBW                    (txChBW),
    .txDynBW                   (txDynBW),
    .txBWSignaling             (txBWSignaling),
    .txFromFifo                (txFromFifo),
    .txCFEND                   (txCFEND),
    .respTxAntennaSet          (respTxAntennaSet),
    .respTxSMMIndex            (respTxSMMIndex),
    .respTxPreType             (respTxPreType),
    .respTxFormatMod           (respTxFormatMod),
    .respTxAMPDU               (respTxAMPDU),
    .respTxNumExtnSS           (respTxNumExtnSS),
    .respTxFECCoding           (respTxFECCoding),
    .respTxNTx                 (respTxNTx),
    .respTxGIType              (respTxGIType),
    .respTxPwrLevel            (respTxPwrLevel),
    .respTxHELTFType           (respTxHELTFType),
    .respTxDoppler             (respTxDoppler),
    .respTxMidamble            (respTxMidamble),
    .respTxBSSColor            (respTxBSSColor),
    .respTxDcm                 (respTxDcm),
    .respTxSpatialReuse1       (respTxSpatialReuse1),
    .respTxSpatialReuse2       (respTxSpatialReuse2),
    .respTxSpatialReuse3       (respTxSpatialReuse3),
    .respTxSpatialReuse4       (respTxSpatialReuse4),
    .respTxHESigAReserved      (respTxHESigAReserved),
    .respTxNumHeLtf            (respTxNumHeLtf),
    .respTxHELtfMode           (respTxHELtfMode),
    .respTxLDPCExtraSymbol     (respTxLDPCExtraSymbol),
    .respTxStartingSTSNum      (respTxStartingSTSNum),
    .respTxRUAllocation        (respTxRUAllocation),
    .respTxPacketExtension     (respTxPacketExtension),
    .respTxTriggerMethod       (respTxTriggerMethod),
    .respTxRUToneSetIndex      (respTxRUToneSetIndex),
    .respTxFeedBackStatus      (respTxFeedBackStatus),
    .respTxTriggerResponding   (respTxTriggerResponding),
    .respTxBeamChange          (respTxBeamChange),
    .formatModProtTx           (formatModProtTx),
    .formatModTx               (formatModTx),
    .preTypeProtTx             (preTypeProtTx),
    .preTypeTx                 (preTypeTx),
    .smoothingProtTxPT         (smoothingProtTxPT),
    .partialAIDTx              (partialAIDTx),
    .groupIDTx                 (groupIDTx),
    .dozeNotAllowedTx          (dozeNotAllowedTx),
    .smoothingTxPT             (smoothingTxPT),
    .soundingTxPT              (soundingTxPT),
    .spatialReusePT            (spatialReusePT),
    .nTxProtPT                 (nTxProtPT),
    .nTxPT                     (nTxPT),
    .txGIType                  (txGIType),
    .txHELTFType               (txHELTFType),
    .txDoppler                 (txDoppler),
    .txMidamble                (txMidamble),
    .txDcm                     (txDcm),
    .txPwrLevelPT              (txPwrLevelPT),
    .txPwrLevelProtPT          (txPwrLevelProtPT),
    .stbcPT                    (stbcPT),
    .txFecCoding               (txFecCoding),
    .numExtnSSPT               (numExtnSSPT),
    .txPacketExtension         (txPacketExtension),
    .bssColorPT                (bssColorPT),
    .upLinkFlagPT              (upLinkFlagPT),
    .beamChangePT              (beamChangePT),
    .beamFormedPT              (beamFormedPT),
    .smmIndexPT                (smmIndexPT),
    .antennaSetPT              (antennaSetPT),
    .aMPDU                     (aMPDU),
    .dsssMaxPwrLevel           (dsssMaxPwrLevel),
    .ofdmMaxPwrLevel           (ofdmMaxPwrLevel),
    .pRandom                   (tsf[2:0]),
    .bbServiceA                (bbServiceA),
    .bbServiceB                (bbServiceB),
    .obssPDSRPeriod            (obssPDSRPeriod),
    .obssPDSRPeriodTxPwrMax    (obssPDSRPeriodTxPwrMax),
    .heLTFType                 (heLTFType),
    .txPwrLevel                (txPwrLevel),
    .chBW                      (chBW),
    .partialAID                (partialAID),
    .groupID                   (groupID),
    .dozeNotAllowed            (dozeNotAllowed),
    .smoothing                 (smoothing),
    .antennaSet                (antennaSet),
    .packetExtension           (packetExtension),
    .bssColor                  (bssColor),
    .txopDuration              (txopDuration),
    .triggerResponding         (triggerResponding),
    .upLinkFlag                (upLinkFlag),
    .beamChange                (beamChange),
    .dcm                       (dcm),
    .beamFormed                (beamFormed),
    .smmIndex                  (smmIndex),
    .mcs                       (mcs),
    .preType                   (preType),
    .formatMod                 (formatMod),
    .numExtnSS                 (numExtnSS),
    .stbc                      (stbc),
    .disambiguityBit           (disambiguityBit),
    .fecCoding                 (fecCoding),
    .sounding                  (sounding),
    .legLength                 (legLength),
    .legRate                   (legRate),
    .service                   (service),
    .htLength                  (htLength),
    .htLengthValid             (htLengthValid),
    .spatialReuse1             (spatialReuse1),
    .spatialReuse2             (spatialReuse2),
    .spatialReuse3             (spatialReuse3),
    .spatialReuse4             (spatialReuse4),
    .heSigAReserved            (heSigAReserved),
    .numHeLtf                  (numHeLtf),
    .heLtfMode                 (heLtfMode),
    .ldpcExtraSymbol           (ldpcExtraSymbol),
    .startingSTSNum            (startingSTSNum),
    .sigBCompressionMode       (sigBCompressionMode),
    .dcmSigB                   (dcmSigB),
    .mcsSigB                   (mcsSigB),
    .ruAllocation              (ruAllocation),
    .triggerMethod             (triggerMethod),
    .ruToneSetIndex            (ruToneSetIndex),
    .feedBackStatus            (feedBackStatus),
    .doppler                   (doppler),
    .midamble                  (midamble),
    .nTx                       (nTx),
    .giType                    (giType),
    .aggreation                (aggreation)
    );



assign fcsPauseTx     = mpIfTxFifoFull;
assign fcsStartTx_p   = ctsFCSStart_p      || rtsFCSStart_p        || ackFCSStart_p     ||
                        cfendFCSStart_p    || baFCSStart_p         || mpduFCSStart_p    ||
                        bfrFCSStart_p      || qosnullFCSStart_p;

assign fcsShiftTx     = ctsFCSShiftTx      || rtsFCSShiftTx        || ackFCSShiftTx     ||
                        cfendFCSShiftTx    || baFCSShiftTx         || mpduFCSShiftTx    ||
                        bfrFCSShiftTx      || qosnullFCSShiftTx;

assign fcsDInValidTx  = ctsFCSDInValidTx   || rtsFCSDInValidTx     || ackFCSDInValidTx  ||
                        cfendFCSDInValidTx || baFCSDInValidTx      || mpduFCSDInValidTx ||
                        bfrFCSDInValidTx   || qosnullFCSDInValidTx; 

assign fcsEnableTx    = ctsFCSEnable       || rtsFCSEnable         || ackFCSEnable      ||
                        cfendFCSEnable     || baFCSEnable          || mpduFCSEnable     ||
                        bfrFCSEnable       || qosnullFCSEnable;


always @*
begin
  case ({qosnullFCSDInValidTx, bfrFCSDInValidTx, mpduFCSDInValidTx, baFCSDInValidTx,
         cfendFCSDInValidTx  , ackFCSDInValidTx, ctsFCSDInValidTx , rtsFCSDInValidTx})
    8'b00000001 :  fcsDInTx    = rtsFCSDInTx;

    8'b00000010 :  fcsDInTx    = ctsFCSDInTx;
    
    8'b00000100 :  fcsDInTx    = ackFCSDInTx;
    
    8'b00001000 :  fcsDInTx    = cfendFCSDInTx;
    
    8'b00010000 :  fcsDInTx    = baFCSDInTx;
    
    8'b00100000 :  fcsDInTx    = mpduFCSDInTx;
    
    8'b01000000 :  fcsDInTx    = bfrFCSDInTx;

    8'b10000000 :  fcsDInTx    = qosnullFCSDInTx;

    default     :  fcsDInTx    =  8'b0;
  endcase
end


assign mpIfTxFifoData    = (fcsDOutValid) ? fcsDOut      : aMPDUDelimiterData;
assign mpIfTxFifoWrite   = (txResp || txFromHD || txFromFifo || txCFEND) ?  
                           (fcsDOutValid) ? fcsDOutValid : aMPDUDelimiterWriteEn
                           : 1'b0;


// tickSIFS_p capture
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    tickSIFS <= 1'b0; 
  else if ((macCoreTxClkSoftRst_n == 1'b0) || hwErr) // Synchronous Reset
    tickSIFS <= 1'b0; 
  else if (startTx_p || !txRxExchangeEnabled || rxVector1Valid_p)   
    tickSIFS <= 1'b0; 
  else if (tickSIFS_p)
    tickSIFS <= 1'b1;
end

// tickPIFS_p capture
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    tickPIFS <= 1'b0; 
  else if ((macCoreTxClkSoftRst_n == 1'b0) || hwErr) // Synchronous Reset
    tickPIFS <= 1'b0; 
  else if (startTx_p || !txRxExchangeEnabled || rxVector1Valid_p)   
    tickPIFS <= 1'b0; 
  else if (tickPIFS_p)
    tickPIFS <= 1'b1;
end

// tickSlot capture
always @ (posedge macCoreClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    tickSlot <= 1'b0; 
  else if ((macCoreTxClkSoftRst_n == 1'b0) || hwErr) // Synchronous Reset
    tickSlot <= 1'b0; 
  else if (startTx_p || !txRxExchangeEnabled || rxVector1Valid_p)   
    tickSlot <= 1'b0; 
  else if (tickSlot_p)
    tickSlot <= 1'b1;
end



////////////////////////////////////////////////////////////////////////////////
//
// Debug logic.
//
////////////////////////////////////////////////////////////////////////////////

// This process merges together the state of the different FSM based on the txControlMain
// current state
always @*
begin
  case (txControlMainFSMCs)
      5'd2  : txControlCs = {txControlMainFSMCs[3:0],3'b0,formatAMPDUDelFSMCs}; // TX_AMPDU_DLM
      5'd3  : txControlCs = {txControlMainFSMCs[3:0],formatMPDUFSMCs};          // TX_FRAME
      5'd5  : txControlCs = {txControlMainFSMCs[3:0],3'b0,formatAMPDUDelFSMCs}; // TX_AMPDU_PAD
      5'd6  : txControlCs = {txControlMainFSMCs[3:0],1'b0,formatCFENDFSMCs};    // TX_CFEND
      5'd7  : txControlCs = {txControlMainFSMCs[3:0],1'b0,formatRTSFSMCs};      // TX_RTS
      5'd8  : txControlCs = {txControlMainFSMCs[3:0],2'b0,formatCTSFSMCs};      // TX_CTS
      5'd9  : txControlCs = {txControlMainFSMCs[3:0],2'b0,formatACKFSMCs};      // TX_ACK
      5'd10 : txControlCs = {txControlMainFSMCs[3:0],1'b0,formatBAFSMCs};       // TX_BACK
      5'd11 : txControlCs = {txControlMainFSMCs[3:0],1'b0,formatQOSNULLFSMCs};  // TX_QOSNULL
      5'd13 : txControlCs = {txControlMainFSMCs[3:0],3'b0,formatAMPDUDelFSMCs}; // TX_RESP_AMPDU_DLM
      5'd16 : txControlCs = {txControlMainFSMCs[3:0],3'b0,formatAMPDUDelFSMCs}; // TX_RESP_AMPDU_PAD
`ifdef RW_BFMEE_EN
      5'd14 : txControlCs = {txControlMainFSMCs[3:0],1'b0,formatBFRFSMCs};      // TX_BFR
`endif //RW_BFMEE_EN
    default : txControlCs = {txControlMainFSMCs[3:0],5'b0};                 
  endcase
end                                                                        

// | *txControlCs[8:5]* | *txControllerMainFSMCs*  |
// |  0x0               |                  IDLE    |
// |  0x1               | WAIT_FOR_SIFS_OR_SLOT    |
// |  0x2               |          TX_AMPDU_DLM    |
// |  0x3               |              TX_FRAME    |
// |  0x4               |        WAIT_HD_TOGGLE    |
// |  0x5               |          TX_AMPDU_PAD    |
// |  0x6               |              TX_CFEND    |
// |  0x7               |                TX_RTS    |
// |  0x8               |                TX_CTS    |
// |  0x9               |                TX_ACK    |
// |  0xA               |               TX_BACK    |
// |  0xB               |            TX_QOSNULL    |
// |  0xC               | TX_RESP_WAIT_FOR_SIFS    |
// |  0xD               |     TX_RESP_AMPDU_DLM    |
// |  0xE               |                TX_BFR    |
// |  0xF               |           TX_WAIT_END    |
//
// | *txControlCs[4:0]* | *TX_AMPDU_DLM*  |    *TX_FRAME*      |  *TX_AMPDU_PAD* | *TX_CFEND*           |     *TX_RTS*       | *TX_CTS*           | *TX_ACK*           |    *TX_BACK*     |   *TX_BFR*     |
// |  0x0               |            IDLE |                    |            IDLE |           CFEND_IDLE |           RTS_IDLE |           CTS_IDLE |           ACK_IDLE |          BA_IDLE |       BFR_IDLE |
// |  0x1               | INSERT_BLANKDEL |            FD_IDLE | INSERT_BLANKDEL |           CFEND_WAIT |           RTS_WAIT |           CTS_WAIT |           ACK_WAIT |          BA_WAIT |    BFR_STARTTX |
// |  0x2               |      INSERT_DEL |      FD_INITCRYPTO |      INSERT_DEL |        CFEND_STARTTX |        RTS_STARTTX |        CTS_STARTTX |        ACK_STARTTX |       BA_STARTTX |   BFR_FRMCNTRL |
// |  0x3               |      INSERT_PAD |         FD_STARTTX |      INSERT_PAD | CFEND_FRMCNTRL_BYTE1 | RTS_FRMCNTRL_BYTE1 | CTS_FRMCNTRL_BYTE1 | ACK_FRMCNTRL_BYTE1 |BA_FRMCNTRL_BYTE1 | BFR_DURATIONID |
// |  0x4               |                 |  FD_FRMCNTRL_BYTE1 |                 | CFEND_FRMCNTRL_BYTE2 | RTS_FRMCNTRL_BYTE2 | CTS_FRMCNTRL_BYTE2 | ACK_FRMCNTRL_BYTE2 |BA_FRMCNTRL_BYTE2 |         BFR_RA |
// |  0x5               |                 |  FD_FRMCNTRL_BYTE2 |                 |     CFEND_DURATIONID |     RTS_DURATIONID |     CTS_DURATIONID |     ACK_DURATIONID |    BA_DURATIONID |         BFR_TA |
// |  0x6               |                 |      FD_DURID_DATA |                 |             CFEND_RA |             RTS_RA |             CTS_RA |             ACK_RA |            BA_RA |      BFR_BSSID |
// |  0x7               |                 |           FD_ADDR1 |                 |          CFEND_BSSID |             RTS_TA |            CTS_FCS |            ACK_FCS |            BA_TA |   BFR_SEQCNTRL |
// |  0x8               |                 |           FD_ADDR2 |                 |            CFEND_FCS |            RTS_FCS |                    |                    |       BA_CONTROL |   BFR_CATEGORY |
// |  0x9               |                 |           FD_ADDR3 |                 |                      |                    |                    |                    |          BA_INFO |     BFR_ACTION |
// |  0xA               |                 |        FD_SQNCNTRL |                 |                      |                    |                    |                    |           BA_FCS |  BFR_MIMOCNTRL |
// |  0xB               |                 |           FD_ADDR4 |                 |                      |                    |                    |                    |                  |     BFR_REPORT |
// |  0xC               |                 |        FD_QOSCNTRL |                 |                      |                    |                    |                    |                  |        BFR_FCS |
// |  0xD               |                 |         FD_CFCNTRL |                 |                      |                    |                    |                    |                  |      BFR_ERROR |
// |  0xE               |                 |         FD_HTCNTRL |                 |                      |                    |                    |                    |                  |                |
// |  0xF               |                 |             FD_TSF |                 |                      |                    |                    |                    |                  |                |
// |  0x10              |                 |              FD_IV |                 |                      |                    |                    |                    |                  |                |
// |  0x11              |                 |           FD_EXTIV |                 |                      |                    |                    |                    |                  |                |
// |  0x12              |                 |       FD_MPDUSTART |                 |                      |                    |                    |                    |                  |                |
// |  0x13              |                 |        FD_FRM_BODY |                 |                      |                    |                    |                    |                  |                |
// |  0x14              |                 |             FD_ICV |                 |                      |                    |                    |                    |                  |                |
// |  0x15              |                 | FD_WAITCCMPMICDONE |                 |                      |                    |                    |                    |                  |                |
// |  0x16              |                 |         FD_CCMPMIC |                 |                      |                    |                    |                    |                  |                |
// |  0x17              |                 |             FD_FCS |                 |                      |                    |                    |                    |                  |                |
// |  0x18              |                 |     FD_FLUSHTXFIFO |                 |                      |                    |                    |                    |                  |                |


// TX Controller FSMs current states latched when an HW error happened
always @ (posedge macCoreTxClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
    txControlLs <= 9'b0; 
  else if (macCoreTxClkSoftRst_n == 1'b0)  // Synchronous Reset
    txControlLs <= 9'b0; 
  else
    if (hwErr)
      txControlLs <= txControlCs; 
end

// Capture the information about the frame which has been transmitted
always @ (posedge macCoreTxClk or negedge macCoreClkHardRst_n) 
begin
  if (macCoreClkHardRst_n == 1'b0)  // Asynchronous Reset
  begin
    debugPortTxFrameDebug1 <= 16'b0;
    debugPortTxFrameDebug2 <= 16'b0;
  end
  else
  begin
    if (txDone_p)
    begin
      debugPortTxFrameDebug1 <= 16'b0;
      debugPortTxFrameDebug2 <= 16'b0;
    end  
`ifdef RW_BFMEE_EN
    if (mpduSeqCtrlDone_p || ctsTxStart_p || rtsTxStart_p || ackStart_p || cfendTxStart_p || baStart_p || qosnullStart_p || bfrStart_p)
`else //RW_BFMEE_EN
    if (mpduSeqCtrlDone_p || ctsTxStart_p || rtsTxStart_p || ackStart_p || cfendTxStart_p || baStart_p || qosnullStart_p)
`endif //RW_BFMEE_EN
    begin
      case (txControlMainFSMCs)
          5'd3  : debugPortTxFrameDebug1 <= {1'b1,formatMPDUFrameDebug1};            // TX_FRAME
          5'd5  : debugPortTxFrameDebug1 <= {1'b1,5'b0,pwrMgt,3'b0,6'b111001};       // TX_CFEND
          5'd6  : debugPortTxFrameDebug1 <= {1'b1,5'b0,pwrMgt,2'b0,retry,6'b101101}; // TX_RTS
          5'd7  : debugPortTxFrameDebug1 <= {1'b1,5'b0,pwrMgt,3'b0,6'b101101};       // TX_CTS
          5'd8  : debugPortTxFrameDebug1 <= {1'b1,5'b0,pwrMgt,3'b0,6'b101101};       // TX_ACK
          5'd9  : debugPortTxFrameDebug1 <= {1'b1,5'b0,pwrMgt,3'b0,6'b100101};       // TX_BACK
          5'd11 : debugPortTxFrameDebug1 <= {1'b1,5'b0,pwrMgt,3'b0,6'b110010};       // TX_QOSNULL
`ifdef RW_BFMEE_EN
          5'd14 : debugPortTxFrameDebug1 <= {1'b1,5'b0,pwrMgt,3'b0,6'b111000};       // TX_BFR
`endif //RW_BFMEE_EN
        default : debugPortTxFrameDebug1 <= 16'b0;                 
      endcase
      if (txControlMainFSMCs == 5'd3)
        debugPortTxFrameDebug2 <= {1'b0,formatMPDUFrameDebug2};   // TX_FRAME
      else
        debugPortTxFrameDebug2 <= {8'b0,destAddr[47:40]};         // Others TX_CFEND
    end
  end
end    



////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Additional Code to ease verification
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////



// System Verilog Assertions
////////////////////////////

`ifdef RW_ASSERT_ON
//$rw_sva Checks if the Tx Controller does not write when the mpIfTxFifoFull is set 
// That guaranty the handshaking between Tx Controller and the MAC-PHY Interface
property noWriteWhenFiFoFullCheck_prop;
@(posedge macCoreTxClk)
    (mpIfTxFifoFull == 1'b1) |-> mpIfTxFifoWrite == 1'b0;
endproperty
noWriteWhenFiFoFullCheck: assert property (noWriteWhenFiFoFullCheck_prop); 

//$rw_sva Checks if the Tx Controller does not read when the TX FIFO is empty
// That guaranty the handshaking between Tx Controller and the TX FIFO
property noReadWhenFiFoEmptyCheck_prop;
@(posedge macCoreTxClk)
    (txFIFOEmpty == 1'b1) |-> txFIFORead == 1'b0;
endproperty
noReadWhenFiFoEmptyCheck: assert property (noReadWhenFiFoEmptyCheck_prop); 


`endif // RW_ASSERT_ON
endmodule
                 
