//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of ahb_bridge module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module ahb_bridge( 
   // Clock and reset
   input  wire        clk,
   input  wire        rst_n,

   // AHB slave
   input  wire        s_hreadyin,
   input  wire        s_hsel,
   input  wire [31:0] s_haddr,
   input  wire  [1:0] s_htrans,
   input  wire        s_hwrite,
   input  wire  [2:0] s_hsize,
   input  wire [31:0] s_hwdata,
   output reg  [31:0] s_hrdata,
   output reg   [1:0] s_hresp,
   output reg         s_hready,

   // AHB Master
   output reg  [31:0] m_haddr,
   output reg   [1:0] m_htrans,
   output reg         m_hwrite,
   output reg   [2:0] m_hsize,
   output reg  [31:0] m_hwdata,
   input  wire [31:0] m_hrdata,
   input  wire  [1:0] m_hresp,
   input  wire        m_hready
);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////
localparam IDLE=2'd0,
           ADDR=2'd1,
           WDATA=2'd2,
           RDATA=2'd3;


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
reg [1:0] state;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////
always @(posedge clk or negedge rst_n)
begin
   if (rst_n==1'b0)
   begin
      m_haddr  <= 32'b0;
      m_htrans <= 2'b0;
      m_hwrite <= 1'b0;
      m_hsize  <= 3'b0;
      m_hwdata <= 32'b0;

      s_hrdata <= 32'b0;
      s_hresp  <= 2'b0;
      s_hready <= 1'b0;

      state  <= IDLE;
   end
   else
   begin
      case(state)
      IDLE:
      begin
         s_hready       <= 1'b1;
         // Active Transfert
         if (s_hsel==1'b1 && s_htrans[1]==1'b1 && s_hreadyin==1'b1 && s_hready==1'b1)
         begin
            m_haddr     <= s_haddr;
            m_htrans    <= s_htrans;
            m_hwrite    <= s_hwrite;
            m_hsize     <= s_hsize;
                        
            s_hready    <= 1'b0;
                        
            state       <= ADDR;
         end
      end
      ADDR:
      begin
         if (m_hready==1'b1)
         begin
            m_htrans    <= 2'b0;

            if (m_hwrite)
            begin
               m_hwdata <= s_hwdata;

               state    <= WDATA;
            end
            else
            begin
               state    <= RDATA;
            end
         end
      end
      WDATA:
      begin
         if (m_hready==1'b1)
         begin
            s_hresp     <= m_hresp;
            s_hready    <= 1'b1;

            state       <= IDLE;
         end
      end
      RDATA:
      begin
         if (m_hready==1'b1)
         begin
            s_hrdata    <= m_hrdata;
            s_hresp     <= m_hresp;
            s_hready    <= 1'b1;
                        
            state       <= IDLE;
         end
      end
      endcase
   end
end


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Additional Code to ease verification
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////
// System Verilog Assertions
///////////////////////////////////////
`ifdef RW_ASSERT_ON
`endif // RW_ASSERT_ON


///////////////////////////////////////
// FSM state to string convertion
///////////////////////////////////////
`ifdef RW_SIMU_ON
// pragma coverage block = off

reg [16*8-1:0] state_str;

always @*
begin
   case (state)
   IDLE :   state_str = "IDLE";
   ADDR :   state_str = "ADDR";
   WDATA:   state_str = "WDATA";
   RDATA:   state_str = "RDATA";
   default: state_str = "XXX";
   endcase
end

// pragma coverage block = on
`endif

endmodule
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
