//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Downstream Physical Channel Top
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module downstream_channel
(
  /*****************************************************************************
  * System
  *****************************************************************************/
  input wire                      clk,
  input wire                      rst_n,

  /*****************************************************************************
  * Configuration from register
  *****************************************************************************/
  input  wire               [3:0] axi_burst_length_limit,

  /*****************************************************************************
  * Channel Control
  *****************************************************************************/
  input  wire                     channel_sel,
  input  wire                     channel_req,
  input  wire              [31:0] channel_saddr,
  input  wire              [31:0] channel_daddr,
  input  wire               [3:0] channel_tag,
  input  wire              [15:0] channel_length,
  output wire                     channel_busy,
  output wire                     downstream_ack,
  output wire               [3:0] downstream_ack_tag,
  output wire                     downstream_ack_error,
  input  wire                     downstream_ack_ack,

  /*****************************************************************************
  * AXI interface
  *****************************************************************************/
  output wire              [ 3:0] dma1_arid,
  output wire              [31:0] dma1_araddr,
  output wire              [ 7:0] dma1_arlen,
  output wire              [ 2:0] dma1_arsize,
  output wire              [ 1:0] dma1_arburst,
  output wire                     dma1_arvalid,
  input  wire                     dma1_arready,

  input  wire              [ 3:0] dma1_rid,
  input  wire              [63:0] dma1_rdata,
  input  wire              [ 1:0] dma1_rresp,
  input  wire                     dma1_rlast,
  input  wire                     dma1_rvalid,
  output wire                     dma1_rready,

  /*****************************************************************************
  * Bus interface (SRAM)
  *****************************************************************************/
  input  wire                     dma1_ready,
  output wire [31:0]              dma1_addr,
  output wire                     dma1_trans,
  output wire [ 7:0]              dma1_we,
  output wire [63:0]              dma1_wdata,

  /*****************************************************************************
  * AHB Master (AHB Address Map)
  *****************************************************************************/
  input  wire                     dma1_hready,
  output wire [31:0]              dma1_haddr,
  output wire  [1:0]              dma1_htrans,
  output wire  [1:0]              dma1_hsize,
  output wire [31:0]              dma1_hwdata,
  input  wire  [1:0]              dma1_hresp,

  /*****************************************************************************
  * Debug interface
  *****************************************************************************/
  output wire              [15:0] diag_port_downstream_axi0,
  output wire              [15:0] diag_port_downstream_axi1,
  output wire              [15:0] diag_port_downstream_axi2
);


  /*****************************************************************************
  * declarations
  *****************************************************************************/
  wire        downstream_start;
  wire  [2:0] downstream_saddr;
  wire [31:0] downstream_daddr;
  wire [11:0] downstream_length;
  reg         downstream_done;
  reg         downstream_ready;

  reg         downstream_busif_start;
  wire        downstream_busif_done;
  wire        downstream_busif_stall;

  reg         downstream_ahbif_start;
  wire        downstream_ahbif_done;
  wire        downstream_ahbif_rdy;

  wire [63:0] axi_datao;
  wire        axi_datao_en;
  wire        axi_datao_last;

  wire [63:0] aligner_datao;
  wire        aligner_datao_en;

  wire [63:0] aligner_datai;
  wire        aligner_datai_en;
  wire        aligner_datai_last;

  //////////////////////////////////////////////////////////////////////////////
  //
  //  AXI Interface
  //
  //////////////////////////////////////////////////////////////////////////////
  downstream_axi downstream_axi_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk                       (clk                       ),
    .rst_n                     (rst_n                     ),
    
    /***************************************************************************
    * Configuration from register
    ***************************************************************************/
    .axi_burst_length_limit    (axi_burst_length_limit    ),

    /***************************************************************************
    * Channel Control
    ***************************************************************************/
    .channel_sel               (channel_sel               ),
    .channel_req               (channel_req               ),
    .channel_saddr             (channel_saddr             ),
    .channel_daddr             (channel_daddr             ),
    .channel_tag               (channel_tag               ),
    .channel_length            (channel_length            ),
    .channel_busy              (channel_busy              ),
    .channel_ack               (downstream_ack            ),
    .channel_ack_tag           (downstream_ack_tag        ),
    .channel_ack_error         (downstream_ack_error      ),
    .channel_ack_ack           (downstream_ack_ack        ),
    
    /***************************************************************************
    * Downstream Control
    ***************************************************************************/
    .start                     (downstream_start          ),
    .saddr                     (downstream_saddr          ),
    .daddr                     (downstream_daddr          ),
    .length                    (downstream_length         ),
    .done                      (downstream_done           ),
    
    /***************************************************************************
    * AXI interface
    ***************************************************************************/
    .arid                      (dma1_arid                 ),
    .araddr                    (dma1_araddr               ),
    .arlen                     (dma1_arlen                ),
    .arsize                    (dma1_arsize               ),
    .arburst                   (dma1_arburst              ),
    .arvalid                   (dma1_arvalid              ),
    .arready                   (dma1_arready              ),

    .rid                       (dma1_rid                  ),
    .rdata                     (dma1_rdata                ),
    .rresp                     (dma1_rresp                ),
    .rlast                     (dma1_rlast                ),
    .rvalid                    (dma1_rvalid               ),
    .rready                    (dma1_rready               ),
    
    /***************************************************************************
    * Aligner interface
    ***************************************************************************/
    .datao                     (axi_datao                 ),
    .datao_last                (axi_datao_last            ),
    .datao_en                  (axi_datao_en              ),
    .datao_rdy                 (downstream_ready          ),

    /***************************************************************************
    * Debug interface
    ***************************************************************************/
    .diag_port_downstream_axi0 (diag_port_downstream_axi0 ),
    .diag_port_downstream_axi1 (diag_port_downstream_axi1 ),
    .diag_port_downstream_axi2 (diag_port_downstream_axi2 )
  );


  //////////////////////////////////////////////////////////////////////////////
  //
  //  Aligner
  //
  //////////////////////////////////////////////////////////////////////////////
  aligner downstream_aligner_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk        (clk                   ),
    .rst_n      (rst_n                 ),

    /***************************************************************************
    * 
    ***************************************************************************/
    .start      (downstream_start      ),
    .src_addr   (downstream_saddr[2:0] ),
    .dst_addr   (downstream_daddr[2:0] ),

    /***************************************************************************
    * 
    ***************************************************************************/
    .datai      (aligner_datai         ),
    .datai_en   (aligner_datai_en      ),
    .datai_last (aligner_datai_last    ),

    /***************************************************************************
    * 
    ***************************************************************************/
    .datao      (aligner_datao         ),
    .datao_en   (aligner_datao_en      )
  );

  assign aligner_datai      = axi_datao;
  assign aligner_datai_en   = axi_datao_en & downstream_ready;
  assign aligner_datai_last = axi_datao_last;


  //////////////////////////////////////////////////////////////////////////////
  //
  //  Bus IF
  //
  //////////////////////////////////////////////////////////////////////////////
  downstream_busif downstream_busif_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk        (clk                    ),
    .rst_n      (rst_n                  ),

    /***************************************************************************
    * control/state
    ***************************************************************************/
    .start      (downstream_busif_start ),
    .stall      (downstream_busif_stall ),
    .done       (downstream_busif_done  ),
  
    /***************************************************************************
    * Static parameters
    ***************************************************************************/
    .dst_addr   (downstream_daddr       ),
    .dst_length (downstream_length      ),
  
    /***************************************************************************
    * aligner interface
    ***************************************************************************/
    .data       (aligner_datao          ),
    .data_en    (aligner_datao_en       ),
   
    /***************************************************************************
    * bus interface
    ***************************************************************************/
    .bus_ready  (dma1_ready             ),
    .bus_addr   (dma1_addr              ),
    .bus_trans  (dma1_trans             ),
    .bus_we     (dma1_we                ),
    .bus_data   (dma1_wdata             )
  );


  //////////////////////////////////////////////////////////////////////////////
  //
  //  AHB IF
  //
  //////////////////////////////////////////////////////////////////////////////
  downstream_ahbif downstream_ahbif_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk         (clk                    ),
    .rst_n       (rst_n                  ),
    
    /***************************************************************************
    * control      
    ***************************************************************************/
    .start       (downstream_ahbif_start ),
    .done        (downstream_ahbif_done  ),
    
    /***************************************************************************
    * Static parameters
    ***************************************************************************/
    .dst_addr    (downstream_daddr       ),
    .byte_length (downstream_length      ),
    
    /***************************************************************************
    * AHB interface
    ***************************************************************************/
    .hready      (dma1_hready            ),
    .haddr       (dma1_haddr             ),
    .htrans      (dma1_htrans            ),
    .hsize       (dma1_hsize             ),
    .hwdata      (dma1_hwdata            ),
    .hresp       (dma1_hresp             ),
    
    /***************************************************************************
    * aligner interface
    ***************************************************************************/
    .datai       (aligner_datao          ),
    .datai_en    (aligner_datao_en       ),
    .datai_rdy   (downstream_ahbif_rdy   )
);


  /*****************************************************************************
  * Output Selection
  *****************************************************************************/
  always @*
  begin
    // If the destination address is in the SRAM, the busif interface is used
    if (downstream_daddr[24:23] == 2'b0)
    begin
      downstream_busif_start = downstream_start;
      downstream_ahbif_start = 1'b0;
      downstream_done        = downstream_busif_done;
      downstream_ready       =~downstream_busif_stall;
    end
    else
    // If the destination address is not in the SRAM, the ahbif interface is used
    begin
      downstream_busif_start = 1'b0;
      downstream_ahbif_start = downstream_start;
      downstream_done        = downstream_ahbif_done;
      downstream_ready       = downstream_ahbif_rdy;
    end
  end


endmodule
`default_nettype wire
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////
