#!/usr/bin/perl
#############################################################################
#  Copyright (C) by RivieraWaves.
#  This module is a confidential and proprietary property of RivieraWaves
#  and a possession or use of this module requires written permission
#  from RivieraWaves.
#----------------------------------------------------------------------------
# $Author: $
# Company          : RivieraWaves
#----------------------------------------------------------------------------
# $Revision: $
# $Date: $
# ---------------------------------------------------------------------------
# Dependencies     : None
# Description      : 
#
#  This small script describes and tests the formulas used
#  to compute the leading/byte enable masks, the number of 32/64 bits 
#  words transfered.
#
# Simulation Notes : 
# Synthesis Notes  :
# Application Note :
# Simulator        :
# Parameters       :
# Terms & concepts :
# Bugs             :
# Open issues and future enhancements :
# References       :
# Revision History :
# ---------------------------------------------------------------------------
#
# $HeadURL: $
#
##############################################################################
use strict;

my ($saddr,$trailing_be,$leading_be);
my ($nbr_byte,$nbr_dword,$nbr_qword);
my ($s,$d,$x,$y,$t,$u);

for($nbr_byte=1;$nbr_byte<16;$nbr_byte++)
{
  for($saddr=0;$saddr<8;$saddr++)
  {

    printf "saddr      = %d\n",$saddr;
    printf "nbr bytes  = %d\n",$nbr_byte;
    ################################################################################
    # compute nbr of dwords
    ################################################################################
    $s=$saddr&0xfffffffc;
    $d=$saddr+$nbr_byte;
    if((int($d)&0x3)!=0)
    {
      $d = int($d+4)&0xfffffffc;
    }
    $nbr_dword = ($d - $s)>>2;

    printf "nbr dwords = %d  (%d,%d)\n",$nbr_dword,$s,$d;


    $t = $nbr_byte + ($saddr&3);
    if(($t&3) != 0)
    {
      $t=$t + 4;
    }
    $t = $t>>2;
    
    if($t!= $nbr_dword)
    {
      print "error !!\n";
      exit;
    }
    
    ################################################################################
    # compute nbr of qwords
    ################################################################################
    $s=$saddr&0xfffffff8;
    $d=$saddr+$nbr_byte;
    if((int($d)&0x7)!=0)
    {
      $d = int($d+8)&0xfffffff8;
    }
    $nbr_qword = ($d - $s)>>3;

    printf "nbr qwords = %d  (%d,%d)\n",$nbr_qword,$s,$d;

    $u = $nbr_byte + ($saddr&7);
    if(($u&7)!=0)
    {
      $u=$u+8;
    }
    $u = $u>>3;

    if($u!= $nbr_qword)
    {
      print "error !!\n";
      exit;
    }

    ################################################################################
    # compute leading be
    ################################################################################
    if(($saddr&0x3)==0) { $leading_be = 0xf };
    if(($saddr&0x3)==1) { $leading_be = 0xe };
    if(($saddr&0x3)==2) { $leading_be = 0xc };
    if(($saddr&0x3)==3) { $leading_be = 0x8 };

    if((($saddr+$nbr_byte)&0x3)==0) { $trailing_be = 0xf };
    if((($saddr+$nbr_byte)&0x3)==1) { $trailing_be = 0x1 };
    if((($saddr+$nbr_byte)&0x3)==2) { $trailing_be = 0x3 };
    if((($saddr+$nbr_byte)&0x3)==3) { $trailing_be = 0x7};

    if($nbr_dword==1)
    {
      $leading_be = $trailing_be = $leading_be & $trailing_be;
    }
   
    printf "lead be    = 0x%x\n",$leading_be;
    printf "trail be   = 0x%x\n",$trailing_be;


    $y=0;
    while(1)
    {
      for($x=7;$x>=0;$x--)
      {
        if( (($x+8*$y)>= $saddr) && (($x+8*$y)< ($saddr + $nbr_byte)))
        {
          print("#");
        }
        else
        {
          print(".");
        }
      }
      print "\n";
      $y=$y+1;
      if((8*$y)>=($saddr + $nbr_byte))
      {
        last;
      }
    }
    print "\n\n";
  }
}
 

 
